'use client';

// @mui
import { useTheme } from '@mui/material/styles';

/***************************  IMAGE - ERROR 404  ***************************/

export default function Error404() {
  const theme = useTheme();

  return (
    <svg viewBox="0 0 1344 550" fill="none" xmlns="http://www.w3.org/2000/svg" style={{ width: '100%', height: 'auto' }}>
      <path
        d="M0 384.577H111.687C126.213 384.577 137.988 396.352 137.988 410.878V514.822C137.988 532.731 152.506 547.249 170.415 547.249V547.249C188.324 547.249 202.842 532.731 202.842 514.822V275.35C202.842 257.346 217.437 242.751 235.441 242.751V242.751C253.446 242.751 268.041 257.346 268.041 275.351V451.95C268.041 468.239 281.246 481.445 297.536 481.445V481.445C313.825 481.445 327.031 468.239 327.031 451.95V400.239C327.031 391.589 334.042 384.577 342.692 384.577H387.014"
        stroke={theme.palette.primary.main}
        strokeOpacity="0.4"
        strokeWidth="4.64882"
      />
      <path
        opacity="0.5"
        d="M513.319 424.975L515.851 339.527C515.846 337.893 515.205 336.324 514.064 335.154C512.924 333.983 511.373 333.301 509.739 333.253C508.105 333.205 506.516 333.794 505.309 334.895C504.101 335.997 503.369 337.525 503.267 339.156L503.162 343.047L468.396 343.717C464.71 343.785 461.097 344.758 457.875 346.548C454.652 348.339 451.918 350.892 449.912 353.986L428.945 354.397C425.456 354.465 422.137 355.916 419.717 358.431C417.297 360.945 415.975 364.317 416.04 367.806L416.216 375.375L395.699 375.794C394.34 375.821 392.999 376.116 391.753 376.661C390.508 377.206 389.382 377.992 388.44 378.972C387.498 379.953 386.758 381.109 386.263 382.375C385.768 383.642 385.527 384.993 385.554 386.353C385.581 387.712 385.876 389.053 386.421 390.299C386.967 391.544 387.752 392.67 388.732 393.612C389.713 394.554 390.869 395.294 392.136 395.789C393.402 396.284 394.754 396.525 396.113 396.498L416.644 396.101L416.759 402.019C416.827 405.508 418.278 408.827 420.792 411.247C423.307 413.667 426.679 414.989 430.168 414.924L451.514 414.504L451.55 414.343C453.689 417.206 456.478 419.519 459.688 421.091C462.899 422.662 466.437 423.447 470.01 423.38L500.858 422.806L500.794 424.674C500.8 426.308 501.44 427.877 502.581 429.048C503.721 430.219 505.273 430.9 506.906 430.948C508.54 430.997 510.129 430.408 511.337 429.306C512.544 428.205 513.276 426.677 513.378 425.045L513.319 424.975Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M501.547 422.772C501.314 422.719 501.302 404.91 501.539 382.904C501.776 360.897 502.154 343.026 502.417 343.028C502.68 343.031 502.667 360.872 502.443 382.9C502.22 404.929 501.81 422.774 501.547 422.772Z"
        fill="#263238"
      />
      <path
        d="M451.491 414.275C451.258 414.223 450.772 400.768 450.282 384.075C449.792 367.382 449.74 353.837 449.973 353.889C450.206 353.942 450.692 367.396 451.174 384.125C451.656 400.854 451.724 414.328 451.491 414.275Z"
        fill="#263238"
      />
      <path
        d="M416.601 396.092C415.987 392.69 415.763 389.23 415.933 385.777C415.809 382.331 415.896 378.881 416.192 375.446C416.795 378.853 417.011 382.318 416.838 385.774C416.964 389.215 416.885 392.661 416.601 396.092Z"
        fill="#263238"
      />
      <path
        d="M443.856 357.571C443.827 357.696 441.846 357.551 438.62 357.501C437.007 357.476 435.087 357.476 432.955 357.579C430.672 357.647 428.406 357.996 426.209 358.618C424.017 359.072 422.08 360.345 420.794 362.178C419.994 363.852 419.545 365.673 419.475 367.527C419.171 370.715 419.262 372.731 419.129 372.738C418.753 371.011 418.651 369.235 418.828 367.476C418.841 365.519 419.276 363.588 420.104 361.815C420.678 360.759 421.528 359.877 422.562 359.264C423.627 358.621 424.772 358.12 425.966 357.773C428.232 357.115 430.577 356.77 432.936 356.747C435.095 356.688 437.035 356.767 438.56 356.848C440.349 356.853 442.13 357.096 443.856 357.571Z"
        fill={theme.palette.background.default}
      />
      <path
        d="M495.852 346.466C495.257 346.605 494.643 346.651 494.034 346.602C492.881 346.624 491.184 346.637 489.098 346.619L472.852 346.381C469.909 346.333 466.972 346.671 464.117 347.386C461.797 347.998 459.628 349.086 457.75 350.581C456.051 352.01 454.689 353.799 453.765 355.818C453.807 355.198 453.988 354.596 454.294 354.055C455.049 352.544 456.101 351.2 457.387 350.104C459.284 348.478 461.512 347.285 463.917 346.607C466.837 345.806 469.857 345.428 472.884 345.485C479.269 345.551 484.986 345.823 489.164 345.994C491.233 346.084 492.888 346.174 494.093 346.258C494.685 346.262 495.275 346.332 495.852 346.466Z"
        fill={theme.palette.background.default}
      />
      <path
        d="M411.789 379.139C410.592 379.609 409.306 379.814 408.022 379.738C405.645 379.843 402.454 379.387 398.907 379.34C397.272 379.305 395.64 379.494 394.056 379.902C392.775 380.24 391.562 380.794 390.468 381.54C389.495 382.309 388.61 383.183 387.829 384.145C388.197 382.881 388.989 381.784 390.073 381.037C391.186 380.155 392.46 379.496 393.823 379.097C395.474 378.589 397.193 378.342 398.92 378.364C402.543 378.409 405.728 378.976 408.032 379.025C410.336 379.074 411.772 378.965 411.789 379.139Z"
        fill={theme.palette.background.default}
      />
      <path
        d="M1343.61 391.817H1238.39C1224.7 391.817 1213.61 380.724 1213.61 367.04V269.113C1213.61 252.24 1199.93 238.563 1183.06 238.563V238.563C1166.19 238.563 1152.51 252.24 1152.51 269.113V494.721C1152.51 511.683 1138.76 525.434 1121.8 525.434V525.434C1104.84 525.434 1091.08 511.683 1091.08 494.721V328.345C1091.08 312.998 1078.64 300.558 1063.3 300.558V300.558C1047.95 300.558 1035.51 312.998 1035.51 328.345V377.063C1035.51 385.211 1028.9 391.817 1020.76 391.817H979.974"
        stroke={theme.palette.primary.main}
        strokeOpacity="0.4"
        strokeWidth="4.37971"
      />
      <path
        opacity="0.5"
        d="M983.054 392.638C982.923 395.466 981.674 398.126 979.582 400.034C977.49 401.941 974.726 402.94 971.898 402.81L956.432 402.855L957.431 381.514L972.882 381.482C975.71 381.613 978.37 382.862 980.278 384.954C982.185 387.046 983.184 389.81 983.054 392.638Z"
        fill={theme.palette.primary.main}
      />
      <g opacity="0.6">
        <path
          d="M857.622 376.744L825.446 376.171C824.845 376.16 824.249 376.015 823.69 375.744C823.132 375.472 822.623 375.08 822.191 374.59C821.76 374.099 821.415 373.52 821.177 372.885C820.938 372.25 820.811 371.572 820.802 370.89C820.792 370.207 820.901 369.534 821.121 368.907C821.342 368.281 821.671 367.714 822.089 367.239C822.507 366.764 823.005 366.391 823.556 366.14C824.108 365.889 824.7 365.766 825.301 365.777L857.465 366.362L857.622 376.744Z"
          fill="white"
        />
      </g>
      <g opacity="0.6">
        <path
          d="M858.039 419.781L827.6 419.189C826.92 419.18 826.243 419.037 825.609 418.767C824.976 418.497 824.397 418.107 823.907 417.617C823.417 417.128 823.025 416.55 822.753 415.915C822.481 415.281 822.335 414.603 822.323 413.92C822.31 413.237 822.431 412.562 822.681 411.934C822.93 411.307 823.303 410.739 823.777 410.264C824.251 409.788 824.817 409.415 825.443 409.165C826.069 408.915 826.742 408.793 827.423 408.807L857.877 409.362L858.039 419.781Z"
          fill="white"
        />
      </g>
      <path
        d="M857.683 377.141C857.644 376.913 857.62 376.684 857.61 376.455L857.496 374.555L857.164 367.602L857.391 367.885L842.346 367.574L832.883 367.322L827.764 367.141L825.161 367.087C824.348 367.047 823.556 367.261 822.889 367.704C822.319 368.068 821.852 368.58 821.532 369.193C821.212 369.806 821.048 370.501 821.055 371.215C821.064 371.91 821.233 372.603 821.546 373.235C821.86 373.868 822.31 374.422 822.859 374.852C823.38 375.253 823.981 375.52 824.609 375.631C825.278 375.733 825.951 375.783 826.622 375.779L830.635 375.904L844.544 376.432L854.02 376.855L856.586 376.94C856.907 376.945 857.23 376.974 857.55 377.027C857.272 377.068 856.99 377.081 856.706 377.064L854.14 376.979C851.805 376.947 848.616 376.915 844.729 376.843L830.64 376.557L826.567 376.461C825.842 376.466 825.115 376.426 824.389 376.34C823.37 376.169 822.41 375.674 821.642 374.925C820.874 374.177 820.336 373.211 820.103 372.162C819.87 371.113 819.953 370.033 820.341 369.073C820.729 368.113 821.403 367.319 822.268 366.803C823.072 366.29 824.012 366.033 824.98 366.061L827.571 366.126L832.678 366.317L842.148 366.63L857.177 367.205L857.434 367.213L857.43 367.467L857.507 374.569L857.484 376.402C857.58 376.641 857.647 376.889 857.683 377.141Z"
        fill="#263238"
      />
      <path
        d="M857.585 419.446C857.548 419.197 857.535 418.943 857.544 418.69C857.522 418.134 857.497 417.458 857.485 416.626L857.35 409.066L857.564 409.366L842.949 409.5L833.775 409.547L828.808 409.515L826.281 409.54C825.49 409.541 824.715 409.803 824.046 410.297C823.485 410.719 823.022 411.295 822.696 411.975C822.371 412.654 822.193 413.416 822.18 414.194C822.168 414.951 822.313 415.7 822.603 416.377C822.894 417.054 823.32 417.64 823.846 418.084C824.339 418.503 824.91 418.778 825.513 418.887C826.161 418.967 826.814 418.991 827.466 418.957L831.358 418.989L844.866 419.103L854.057 419.256L856.547 419.266C856.856 419.252 857.165 419.277 857.469 419.341C857.469 419.341 857.206 419.378 856.661 419.397L854.209 419.471L845.072 419.627L831.408 419.76L827.445 419.772C826.741 419.816 826.034 419.795 825.333 419.712C824.59 419.573 823.887 419.224 823.287 418.695C822.661 418.168 822.154 417.472 821.809 416.667C821.464 415.862 821.292 414.971 821.307 414.072C821.336 413.15 821.557 412.25 821.951 411.45C822.345 410.65 822.9 409.974 823.569 409.48C824.364 408.896 825.284 408.586 826.223 408.584C827.082 408.6 827.921 408.586 828.75 408.559L833.705 408.602L842.884 408.623L857.476 408.776L857.713 408.789L857.714 409.053C857.645 412.277 857.605 414.871 857.575 416.781L857.526 418.78C857.627 419.214 857.595 419.461 857.585 419.446Z"
        fill="#263238"
      />
      <path
        opacity="0.5"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M930.726 356.4L930.722 357.56C937.952 357.945 944.768 361.055 949.798 366.263C954.827 371.471 957.698 378.39 957.831 385.629L957.999 396.435C958.119 403.882 955.331 411.082 950.228 416.506C945.125 421.931 938.109 425.152 930.669 425.487C930.611 428.078 929.542 430.543 927.69 432.355C925.837 434.167 923.349 435.182 920.758 435.183C918.335 435.18 915.997 434.291 914.183 432.684C912.369 431.077 911.205 428.863 910.91 426.458L857.147 427.557L857.322 391.868L857.323 394.828L895.088 394.816L895.085 387.443L857.343 387.455L857.507 354.145L911.071 354.32C911.58 351.916 912.963 349.787 914.951 348.343C916.939 346.898 919.392 346.242 921.836 346.501C924.279 346.759 926.541 347.914 928.183 349.742C929.825 351.571 930.731 353.942 930.726 356.4ZM857.343 387.455L857.322 391.868L857.32 387.455L857.343 387.455Z"
        fill={theme.palette.primary.main}
      />
      <path
        d="M930.721 358.402C930.862 359.289 930.927 360.187 930.916 361.085C931.003 362.821 931.07 365.32 931.122 368.412C931.25 374.597 931.261 383.146 931.188 392.583C931.115 402.021 931.036 410.403 930.965 416.754L930.882 424.054C930.906 424.958 930.847 425.862 930.707 426.755C930.566 425.867 930.5 424.97 930.511 424.072C930.425 422.336 930.357 419.836 930.306 416.745C930.177 410.559 930.167 402.011 930.299 392.645L930.463 368.402L930.56 361.091C930.528 360.191 930.582 359.291 930.721 358.402Z"
        fill="#263238"
      />
      <path
        d="M911.028 355.104C911.175 356.043 911.235 356.993 911.209 357.943C911.26 359.782 911.298 362.45 911.332 365.724C911.371 372.297 911.306 381.366 911.153 391.376C911 401.387 910.817 410.313 910.696 417.042C910.609 420.2 910.617 422.772 910.517 424.808C910.532 425.764 910.468 426.719 910.327 427.665C910.201 426.72 910.146 425.767 910.16 424.814C910.11 422.975 910.057 420.319 910.037 417.033C909.998 410.46 910.063 401.391 910.216 391.38L910.685 365.729L910.852 357.949C910.838 356.998 910.897 356.046 911.028 355.104Z"
        fill="#263238"
      />
      <g filter="url(#filter0_d_10063_23282)">
        <mask
          id="path-18-outside-1_10063_23282"
          maskUnits="userSpaceOnUse"
          x="391"
          y="85"
          width="563"
          height="223"
          fill={theme.palette.text.primary}
        >
          <rect fill={theme.palette.background.default} x="391" y="85" width="563" height="223" />
          <path d="M496.11 303V259.974H391.878V215.13L465.204 90.9H534.894V225.432H570.042V259.974H534.894V303H496.11ZM428.844 225.432H496.11V115.746H490.656L428.844 220.584V225.432ZM671.772 307.242C646.724 307.242 626.625 300.374 611.475 286.638C596.325 272.7 588.75 251.692 588.75 223.614V170.286C588.75 143.016 596.325 122.311 611.475 108.171C626.625 93.829 646.724 86.658 671.772 86.658C697.022 86.658 717.121 93.829 732.069 108.171C747.219 122.311 754.794 143.016 754.794 170.286V223.614C754.794 251.692 747.219 272.7 732.069 286.638C717.121 300.374 697.022 307.242 671.772 307.242ZM671.772 272.7C686.922 272.7 698.032 268.559 705.102 260.277C712.374 251.995 716.01 240.178 716.01 224.826V168.468C716.01 152.914 711.97 141.198 703.89 133.32C696.012 125.24 685.306 121.2 671.772 121.2C657.834 121.2 646.926 125.341 639.048 133.623C631.372 141.905 627.534 153.52 627.534 168.468V224.826C627.534 240.784 631.17 252.803 638.442 260.883C645.916 268.761 657.026 272.7 671.772 272.7ZM879.156 303V259.974H774.924V215.13L848.25 90.9H917.94V225.432H953.088V259.974H917.94V303H879.156ZM811.89 225.432H879.156V115.746H873.702L811.89 220.584V225.432Z" />
        </mask>
        <path
          d="M496.11 303V259.974H391.878V215.13L465.204 90.9H534.894V225.432H570.042V259.974H534.894V303H496.11ZM428.844 225.432H496.11V115.746H490.656L428.844 220.584V225.432ZM671.772 307.242C646.724 307.242 626.625 300.374 611.475 286.638C596.325 272.7 588.75 251.692 588.75 223.614V170.286C588.75 143.016 596.325 122.311 611.475 108.171C626.625 93.829 646.724 86.658 671.772 86.658C697.022 86.658 717.121 93.829 732.069 108.171C747.219 122.311 754.794 143.016 754.794 170.286V223.614C754.794 251.692 747.219 272.7 732.069 286.638C717.121 300.374 697.022 307.242 671.772 307.242ZM671.772 272.7C686.922 272.7 698.032 268.559 705.102 260.277C712.374 251.995 716.01 240.178 716.01 224.826V168.468C716.01 152.914 711.97 141.198 703.89 133.32C696.012 125.24 685.306 121.2 671.772 121.2C657.834 121.2 646.926 125.341 639.048 133.623C631.372 141.905 627.534 153.52 627.534 168.468V224.826C627.534 240.784 631.17 252.803 638.442 260.883C645.916 268.761 657.026 272.7 671.772 272.7ZM879.156 303V259.974H774.924V215.13L848.25 90.9H917.94V225.432H953.088V259.974H917.94V303H879.156ZM811.89 225.432H879.156V115.746H873.702L811.89 220.584V225.432Z"
          fill={theme.palette.primary.main}
        />
        <path
          d="M496.11 303H495.451V303.659H496.11V303ZM496.11 259.974H496.769V259.315H496.11V259.974ZM391.878 259.974H391.219V260.633H391.878V259.974ZM391.878 215.13L391.311 214.795L391.219 214.95V215.13H391.878ZM465.204 90.9V90.241H464.828L464.637 90.565L465.204 90.9ZM534.894 90.9H535.553V90.241H534.894V90.9ZM534.894 225.432H534.235V226.091H534.894V225.432ZM570.042 225.432H570.701V224.773H570.042V225.432ZM570.042 259.974V260.633H570.701V259.974H570.042ZM534.894 259.974V259.315H534.235V259.974H534.894ZM534.894 303V303.659H535.553V303H534.894ZM428.844 225.432H428.185V226.091H428.844V225.432ZM496.11 225.432V226.091H496.769V225.432H496.11ZM496.11 115.746H496.769V115.087H496.11V115.746ZM490.656 115.746V115.087H490.28L490.088 115.411L490.656 115.746ZM428.844 220.584L428.276 220.249L428.185 220.404V220.584H428.844ZM496.769 303V259.974H495.451V303H496.769ZM496.11 259.315H391.878V260.633H496.11V259.315ZM392.537 259.974V215.13H391.219V259.974H392.537ZM392.445 215.465L465.771 91.2349L464.637 90.565L391.311 214.795L392.445 215.465ZM465.204 91.5589H534.894V90.241H465.204V91.5589ZM534.235 90.9V225.432H535.553V90.9H534.235ZM534.894 226.091H570.042V224.773H534.894V226.091ZM569.383 225.432V259.974H570.701V225.432H569.383ZM570.042 259.315H534.894V260.633H570.042V259.315ZM534.235 259.974V303H535.553V259.974H534.235ZM534.894 302.341H496.11V303.659H534.894V302.341ZM428.844 226.091H496.11V224.773H428.844V226.091ZM496.769 225.432V115.746H495.451V225.432H496.769ZM496.11 115.087H490.656V116.405H496.11V115.087ZM490.088 115.411L428.276 220.249L429.412 220.919L491.224 116.081L490.088 115.411ZM428.185 220.584V225.432H429.503V220.584H428.185ZM611.475 286.638L611.029 287.123L611.032 287.126L611.475 286.638ZM611.475 108.171L611.924 108.653L611.928 108.65L611.475 108.171ZM732.069 108.171L731.613 108.647L731.619 108.653L732.069 108.171ZM732.069 286.638L732.515 287.123L732.515 287.123L732.069 286.638ZM705.102 260.277L704.607 259.842L704.601 259.849L705.102 260.277ZM703.89 133.32L703.418 133.78L703.424 133.786L703.43 133.792L703.89 133.32ZM639.048 133.623L638.57 133.169L638.565 133.175L639.048 133.623ZM638.442 260.883L637.952 261.324L637.958 261.33L637.964 261.337L638.442 260.883ZM671.772 306.583C646.849 306.583 626.92 299.753 611.917 286.15L611.032 287.126C626.329 300.995 646.599 307.901 671.772 307.901V306.583ZM611.921 286.153C596.951 272.38 589.409 251.577 589.409 223.614H588.091C588.091 251.807 595.699 273.02 611.029 287.123L611.921 286.153ZM589.409 223.614V170.286H588.091V223.614H589.409ZM589.409 170.286C589.409 143.138 596.947 122.632 611.924 108.653L611.025 107.689C595.703 121.99 588.091 142.894 588.091 170.286H589.409ZM611.928 108.65C626.932 94.4459 646.857 87.3169 671.772 87.3169V85.999C646.591 85.999 626.318 93.2121 611.022 107.692L611.928 108.65ZM671.772 87.3169C696.891 87.3169 716.813 94.4469 731.613 108.646L732.525 107.696C717.429 93.2111 697.153 85.999 671.772 85.999V87.3169ZM731.619 108.653C746.597 122.632 754.135 143.138 754.135 170.286H755.453C755.453 142.894 747.841 121.99 732.518 107.689L731.619 108.653ZM754.135 170.286V223.614H755.453V170.286H754.135ZM754.135 223.614C754.135 251.577 746.593 272.38 731.623 286.153L732.515 287.123C747.845 273.02 755.453 251.807 755.453 223.614H754.135ZM731.623 286.153C716.824 299.752 696.899 306.583 671.772 306.583V307.901C697.145 307.901 717.417 300.996 732.515 287.123L731.623 286.153ZM671.772 273.359C687.036 273.359 698.364 269.184 705.603 260.705L704.601 259.849C697.699 267.934 686.808 272.041 671.772 272.041V273.359ZM705.597 260.712C713.01 252.27 716.669 240.275 716.669 224.826H715.351C715.351 240.081 711.738 251.72 704.607 259.842L705.597 260.712ZM716.669 224.826V168.468H715.351V224.826H716.669ZM716.669 168.468C716.669 152.805 712.599 140.891 704.35 132.848L703.43 133.792C711.341 141.505 715.351 153.023 715.351 168.468H716.669ZM704.362 132.86C696.335 124.628 685.445 120.541 671.772 120.541V121.859C685.166 121.859 695.688 125.852 703.418 133.78L704.362 132.86ZM671.772 120.541C657.696 120.541 646.599 124.728 638.57 133.169L639.525 134.077C647.252 125.954 657.972 121.859 671.772 121.859V120.541ZM638.565 133.175C630.743 141.614 626.875 153.409 626.875 168.468H628.193C628.193 153.631 632.001 142.196 639.531 134.071L638.565 133.175ZM626.875 168.468V224.826H628.193V168.468H626.875ZM626.875 224.826C626.875 240.872 630.53 253.077 637.952 261.324L638.932 260.442C631.81 252.529 628.193 240.696 628.193 224.826H626.875ZM637.964 261.337C645.602 269.387 656.912 273.359 671.772 273.359V272.041C657.14 272.041 646.23 268.135 638.92 260.429L637.964 261.337ZM879.156 303H878.497V303.659H879.156V303ZM879.156 259.974H879.815V259.315H879.156V259.974ZM774.924 259.974H774.266V260.633H774.924V259.974ZM774.924 215.13L774.357 214.795L774.266 214.95V215.13H774.924ZM848.25 90.9V90.241H847.874L847.683 90.565L848.25 90.9ZM917.94 90.9H918.599V90.241H917.94V90.9ZM917.94 225.432H917.281V226.091H917.94V225.432ZM953.088 225.432H953.747V224.773H953.088V225.432ZM953.088 259.974V260.633H953.747V259.974H953.088ZM917.94 259.974V259.315H917.281V259.974H917.94ZM917.94 303V303.659H918.599V303H917.94ZM811.89 225.432H811.232V226.091H811.89V225.432ZM879.156 225.432V226.091H879.815V225.432H879.156ZM879.156 115.746H879.815V115.087H879.156V115.746ZM873.702 115.746V115.087H873.326L873.135 115.411L873.702 115.746ZM811.89 220.584L811.323 220.249L811.232 220.404V220.584H811.89ZM879.815 303V259.974H878.497V303H879.815ZM879.156 259.315H774.924V260.633H879.156V259.315ZM775.583 259.974V215.13H774.266V259.974H775.583ZM775.492 215.465L848.818 91.2349L847.683 90.565L774.357 214.795L775.492 215.465ZM848.25 91.5589H917.94V90.241H848.25V91.5589ZM917.281 90.9V225.432H918.599V90.9H917.281ZM917.94 226.091H953.088V224.773H917.94V226.091ZM952.43 225.432V259.974H953.747V225.432H952.43ZM953.088 259.315H917.94V260.633H953.088V259.315ZM917.281 259.974V303H918.599V259.974H917.281ZM917.94 302.341H879.156V303.659H917.94V302.341ZM811.89 226.091H879.156V224.773H811.89V226.091ZM879.815 225.432V115.746H878.497V225.432H879.815ZM879.156 115.087H873.702V116.405H879.156V115.087ZM873.135 115.411L811.323 220.249L812.458 220.919L874.27 116.081L873.135 115.411ZM811.232 220.584V225.432H812.549V220.584H811.232Z"
          fill={theme.palette.background.default}
          mask="url(#path-18-outside-1_10063_23282)"
        />
      </g>
      <path
        d="M662.5 185.637L650.5 197.637"
        stroke={theme.palette.primary.main}
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M650.5 185.637L662.5 197.637"
        stroke={theme.palette.primary.main}
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M693.5 185.637L681.5 197.637"
        stroke={theme.palette.primary.main}
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M681.5 185.637L693.5 197.637"
        stroke={theme.palette.primary.main}
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <line x1="653.5" y1="211.637" x2="689.5" y2="211.637" stroke={theme.palette.primary.main} strokeWidth="2" strokeLinecap="round" />
      <mask id="path-25-inside-2_10063_23282" fill="white">
        <path d="M668.5 212.637H687.5V219.137C687.5 224.383 683.247 228.637 678 228.637C672.753 228.637 668.5 224.383 668.5 219.137V212.637Z" />
      </mask>
      <path
        d="M668.5 212.637H687.5H668.5ZM689.5 219.137C689.5 225.488 684.351 230.637 678 230.637C671.649 230.637 666.5 225.488 666.5 219.137H670.5C670.5 223.279 673.858 226.637 678 226.637C682.142 226.637 685.5 223.279 685.5 219.137H689.5ZM678 230.637C671.649 230.637 666.5 225.488 666.5 219.137V212.637H670.5V219.137C670.5 223.279 673.858 226.637 678 226.637V230.637ZM689.5 212.637V219.137C689.5 225.488 684.351 230.637 678 230.637V226.637C682.142 226.637 685.5 223.279 685.5 219.137V212.637H689.5Z"
        fill={theme.palette.primary.main}
        mask="url(#path-25-inside-2_10063_23282)"
      />
      <g filter="url(#filter1_d_10063_23282)">
        <path
          d="M921.428 19C921.428 36.47 913.028 52.9675 904 67.412"
          stroke={theme.palette.primary.main}
          strokeWidth="16.8316"
          strokeLinecap="round"
        />
      </g>
      <g filter="url(#filter2_d_10063_23282)">
        <path
          d="M943 76C947.657 70.3166 952.672 65.7723 957.525 61.0374C966.938 51.8529 976.397 42.8041 985.977 34.5028C997.142 24.8273 1008.52 16.5762 1020 9"
          stroke={theme.palette.primary.main}
          strokeWidth="16.8316"
          strokeLinecap="round"
        />
      </g>
      <g filter="url(#filter3_d_10063_23282)">
        <path
          d="M951 106C964.108 106 977.044 106.631 990.033 108.546C999.918 110.003 1009.82 112.646 1019.73 113.637"
          stroke={theme.palette.primary.main}
          strokeWidth="16.8316"
          strokeLinecap="round"
        />
      </g>
      <defs>
        <filter
          id="filter0_d_10063_23282"
          x="391.878"
          y="86.6582"
          width="568.211"
          height="227.584"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
          <feOffset dx="7" dy="7" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.566667 0 0 0 0 0.566667 0 0 0 0 0.566667 0 0 0 0.36 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_10063_23282" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_10063_23282" result="shape" />
        </filter>
        <filter
          id="filter1_d_10063_23282"
          x="895.583"
          y="10.584"
          width="41.2607"
          height="72.2451"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
          <feOffset dx="7" dy="7" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0.36 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_10063_23282" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_10063_23282" result="shape" />
        </filter>
        <filter
          id="filter2_d_10063_23282"
          x="934.584"
          y="0.583008"
          width="100.833"
          height="90.833"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
          <feOffset dx="7" dy="7" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0.36 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_10063_23282" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_10063_23282" result="shape" />
        </filter>
        <filter
          id="filter3_d_10063_23282"
          x="942.584"
          y="97.584"
          width="92.5645"
          height="31.4697"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
          <feOffset dx="7" dy="7" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0.36 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_10063_23282" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_10063_23282" result="shape" />
        </filter>
      </defs>
    </svg>
  );
}
