'use client';

// @mui
import { useTheme } from '@mui/material/styles';

/***************************  IMAGE - UNDER MAINTENANCE  ***************************/

export default function UnderMaintenance() {
  const theme = useTheme();

  return (
    <svg viewBox="0 0 722 110" fill="none" xmlns="http://www.w3.org/2000/svg" style={{ width: '100%', height: 'auto' }}>
      <g filter="url(#filter0_d_9619_900)">
        <mask id="path-1-outside-1_9619_900" maskUnits="userSpaceOnUse" x="-1" y="-1" width="719" height="107" fill="black">
          <rect fill={theme.palette.background.default} x="-1" y="-1" width="719" height="107" />
          <path d="M0.244 82V68.776H10.732V15.424H0.244V2.19999H41.284C46.148 2.19999 50.366 3.036 53.938 4.708C57.586 6.304 60.398 8.622 62.374 11.662C64.426 14.626 65.452 18.198 65.452 22.378V23.518C65.452 27.166 64.768 30.168 63.4 32.524C62.032 34.804 60.398 36.59 58.498 37.882C56.674 39.098 54.926 39.972 53.254 40.504V42.556C54.926 43.012 56.75 43.886 58.726 45.178C60.702 46.394 62.374 48.18 63.742 50.536C65.186 52.892 65.908 55.97 65.908 59.77V60.91C65.908 65.318 64.882 69.118 62.83 72.31C60.778 75.426 57.928 77.82 54.28 79.492C50.708 81.164 46.528 82 41.74 82H0.244ZM25.78 68.32H39.916C43.184 68.32 45.806 67.522 47.782 65.926C49.834 64.33 50.86 62.05 50.86 59.086V57.946C50.86 54.982 49.872 52.702 47.896 51.106C45.92 49.51 43.26 48.712 39.916 48.712H25.78V68.32ZM25.78 35.032H39.688C42.804 35.032 45.35 34.234 47.326 32.638C49.378 31.042 50.404 28.838 50.404 26.026V24.886C50.404 21.998 49.416 19.794 47.44 18.274C45.464 16.678 42.88 15.88 39.688 15.88H25.78V35.032ZM95.0991 83.596C91.0711 83.596 87.4611 82.912 84.2691 81.544C81.0771 80.1 78.5311 78.048 76.6311 75.388C74.8071 72.652 73.8951 69.346 73.8951 65.47C73.8951 61.594 74.8071 58.364 76.6311 55.78C78.5311 53.12 81.1151 51.144 84.3831 49.852C87.7271 48.484 91.5271 47.8 95.7831 47.8H111.287V44.608C111.287 41.948 110.451 39.782 108.779 38.11C107.107 36.362 104.447 35.488 100.799 35.488C97.2271 35.488 94.5671 36.324 92.8191 37.996C91.0711 39.592 89.9311 41.682 89.3991 44.266L76.1751 39.82C77.0871 36.932 78.5311 34.31 80.5071 31.954C82.5591 29.522 85.2571 27.584 88.6011 26.14C92.0211 24.62 96.1631 23.86 101.027 23.86C108.475 23.86 114.365 25.722 118.697 29.446C123.029 33.17 125.195 38.566 125.195 45.634V66.724C125.195 69.004 126.259 70.144 128.387 70.144H132.947V82H123.371C120.559 82 118.241 81.316 116.417 79.948C114.593 78.58 113.681 76.756 113.681 74.476V74.362H111.515C111.211 75.274 110.527 76.49 109.463 78.01C108.399 79.454 106.727 80.746 104.447 81.886C102.167 83.026 99.0511 83.596 95.0991 83.596ZM97.6071 71.968C101.635 71.968 104.903 70.866 107.411 68.662C109.995 66.382 111.287 63.38 111.287 59.656V58.516H96.8091C94.1491 58.516 92.0591 59.086 90.5391 60.226C89.0191 61.366 88.2591 62.962 88.2591 65.014C88.2591 67.066 89.0571 68.738 90.6531 70.03C92.2491 71.322 94.5671 71.968 97.6071 71.968ZM167.758 83.596C162.286 83.596 157.308 82.456 152.824 80.176C148.416 77.896 144.92 74.59 142.336 70.258C139.752 65.926 138.46 60.682 138.46 54.526V52.93C138.46 46.774 139.752 41.53 142.336 37.198C144.92 32.866 148.416 29.56 152.824 27.28C157.308 25 162.286 23.86 167.758 23.86C173.154 23.86 177.79 24.81 181.666 26.71C185.542 28.61 188.658 31.232 191.014 34.576C193.446 37.844 195.042 41.568 195.802 45.748L181.894 48.712C181.59 46.432 180.906 44.38 179.842 42.556C178.778 40.732 177.258 39.288 175.282 38.224C173.382 37.16 170.988 36.628 168.1 36.628C165.212 36.628 162.59 37.274 160.234 38.566C157.954 39.782 156.13 41.644 154.762 44.152C153.47 46.584 152.824 49.586 152.824 53.158V54.298C152.824 57.87 153.47 60.91 154.762 63.418C156.13 65.85 157.954 67.712 160.234 69.004C162.59 70.22 165.212 70.828 168.1 70.828C172.432 70.828 175.7 69.726 177.904 67.522C180.184 65.242 181.628 62.278 182.236 58.63L196.144 61.936C195.156 65.964 193.446 69.65 191.014 72.994C188.658 76.262 185.542 78.846 181.666 80.746C177.79 82.646 173.154 83.596 167.758 83.596ZM206.853 82V2.19999H221.217V46.318H223.269L241.965 25.456H260.661L234.555 52.816L261.573 82H243.105L223.269 59.542H221.217V82H206.853ZM325.112 83.596C318.956 83.596 313.522 82.494 308.81 80.29C304.098 78.086 300.412 74.932 297.752 70.828C295.092 66.724 293.762 61.784 293.762 56.008V52.816H308.582V56.008C308.582 60.796 310.064 64.406 313.028 66.838C315.992 69.194 320.02 70.372 325.112 70.372C330.28 70.372 334.118 69.346 336.626 67.294C339.21 65.242 340.502 62.62 340.502 59.428C340.502 57.224 339.856 55.438 338.564 54.07C337.348 52.702 335.524 51.6 333.092 50.764C330.736 49.852 327.848 49.016 324.428 48.256L321.806 47.686C316.334 46.47 311.622 44.95 307.67 43.126C303.794 41.226 300.792 38.756 298.664 35.716C296.612 32.676 295.586 28.724 295.586 23.86C295.586 18.996 296.726 14.854 299.006 11.434C301.362 7.938 304.63 5.278 308.81 3.454C313.066 1.554 318.044 0.603995 323.744 0.603995C329.444 0.603995 334.498 1.592 338.906 3.568C343.39 5.468 346.886 8.35599 349.394 12.232C351.978 16.032 353.27 20.82 353.27 26.596V30.016H338.45V26.596C338.45 23.556 337.842 21.124 336.626 19.3C335.486 17.4 333.814 16.032 331.61 15.196C329.406 14.284 326.784 13.828 323.744 13.828C319.184 13.828 315.802 14.702 313.598 16.45C311.47 18.122 310.406 20.44 310.406 23.404C310.406 25.38 310.9 27.052 311.888 28.42C312.952 29.788 314.51 30.928 316.562 31.84C318.614 32.752 321.236 33.55 324.428 34.234L327.05 34.804C332.75 36.02 337.69 37.578 341.87 39.478C346.126 41.378 349.432 43.886 351.788 47.002C354.144 50.118 355.322 54.108 355.322 58.972C355.322 63.836 354.068 68.13 351.56 71.854C349.128 75.502 345.632 78.39 341.072 80.518C336.588 82.57 331.268 83.596 325.112 83.596ZM365.861 82V2.19999H380.225V32.41H382.277C382.885 31.194 383.835 29.978 385.127 28.762C386.419 27.546 388.129 26.558 390.257 25.798C392.461 24.962 395.235 24.544 398.579 24.544C402.987 24.544 406.825 25.57 410.093 27.622C413.437 29.598 416.021 32.372 417.845 35.944C419.669 39.44 420.581 43.544 420.581 48.256V82H406.217V49.396C406.217 45.14 405.153 41.948 403.025 39.82C400.973 37.692 398.009 36.628 394.133 36.628C389.725 36.628 386.305 38.11 383.873 41.074C381.441 43.962 380.225 48.028 380.225 53.272V82H365.861ZM461.873 83.596C456.249 83.596 451.195 82.456 446.711 80.176C442.227 77.896 438.693 74.59 436.109 70.258C433.525 65.926 432.233 60.72 432.233 54.64V52.816C432.233 46.736 433.525 41.53 436.109 37.198C438.693 32.866 442.227 29.56 446.711 27.28C451.195 25 456.249 23.86 461.873 23.86C467.497 23.86 472.551 25 477.035 27.28C481.519 29.56 485.053 32.866 487.637 37.198C490.221 41.53 491.513 46.736 491.513 52.816V54.64C491.513 60.72 490.221 65.926 487.637 70.258C485.053 74.59 481.519 77.896 477.035 80.176C472.551 82.456 467.497 83.596 461.873 83.596ZM461.873 70.828C466.281 70.828 469.929 69.422 472.817 66.61C475.705 63.722 477.149 59.618 477.149 54.298V53.158C477.149 47.838 475.705 43.772 472.817 40.96C470.005 38.072 466.357 36.628 461.873 36.628C457.465 36.628 453.817 38.072 450.929 40.96C448.041 43.772 446.597 47.838 446.597 53.158V54.298C446.597 59.618 448.041 63.722 450.929 66.61C453.817 69.422 457.465 70.828 461.873 70.828ZM503.631 82V25.456H517.767V31.84H519.819C520.655 29.56 522.023 27.888 523.923 26.824C525.899 25.76 528.179 25.228 530.763 25.228H537.603V37.996H530.535C526.887 37.996 523.885 38.984 521.529 40.96C519.173 42.86 517.995 45.824 517.995 49.852V82H503.631ZM569.351 82C565.627 82 562.587 80.86 560.231 78.58C557.951 76.224 556.811 73.108 556.811 69.232V37.312H542.675V25.456H556.811V7.9H571.175V25.456H586.679V37.312H571.175V66.724C571.175 69.004 572.239 70.144 574.367 70.144H585.311V82H569.351ZM598.541 82V2.19999H612.905V82H598.541ZM633.838 104.8V92.26H664.618C666.746 92.26 667.81 91.12 667.81 88.84V74.59H665.758C665.15 75.882 664.2 77.174 662.908 78.466C661.616 79.758 659.868 80.822 657.664 81.658C655.46 82.494 652.648 82.912 649.228 82.912C644.82 82.912 640.944 81.924 637.6 79.948C634.332 77.896 631.786 75.084 629.962 71.512C628.138 67.94 627.226 63.836 627.226 59.2V25.456H641.59V58.06C641.59 62.316 642.616 65.508 644.668 67.636C646.796 69.764 649.798 70.828 653.674 70.828C658.082 70.828 661.502 69.384 663.934 66.496C666.366 63.532 667.582 59.428 667.582 54.184V25.456H681.946V92.032C681.946 95.908 680.806 98.986 678.526 101.266C676.246 103.622 673.206 104.8 669.406 104.8H633.838ZM698.5 55.78V2.19999H713.092V55.78H698.5ZM705.796 83.596C702.756 83.596 700.172 82.608 698.044 80.632C695.992 78.58 694.966 75.958 694.966 72.766C694.966 69.574 695.992 66.99 698.044 65.014C700.172 62.962 702.756 61.936 705.796 61.936C708.912 61.936 711.496 62.962 713.548 65.014C715.6 66.99 716.626 69.574 716.626 72.766C716.626 75.958 715.6 78.58 713.548 80.632C711.496 82.608 708.912 83.596 705.796 83.596Z" />
        </mask>
        <path
          d="M0.244 82V68.776H10.732V15.424H0.244V2.19999H41.284C46.148 2.19999 50.366 3.036 53.938 4.708C57.586 6.304 60.398 8.622 62.374 11.662C64.426 14.626 65.452 18.198 65.452 22.378V23.518C65.452 27.166 64.768 30.168 63.4 32.524C62.032 34.804 60.398 36.59 58.498 37.882C56.674 39.098 54.926 39.972 53.254 40.504V42.556C54.926 43.012 56.75 43.886 58.726 45.178C60.702 46.394 62.374 48.18 63.742 50.536C65.186 52.892 65.908 55.97 65.908 59.77V60.91C65.908 65.318 64.882 69.118 62.83 72.31C60.778 75.426 57.928 77.82 54.28 79.492C50.708 81.164 46.528 82 41.74 82H0.244ZM25.78 68.32H39.916C43.184 68.32 45.806 67.522 47.782 65.926C49.834 64.33 50.86 62.05 50.86 59.086V57.946C50.86 54.982 49.872 52.702 47.896 51.106C45.92 49.51 43.26 48.712 39.916 48.712H25.78V68.32ZM25.78 35.032H39.688C42.804 35.032 45.35 34.234 47.326 32.638C49.378 31.042 50.404 28.838 50.404 26.026V24.886C50.404 21.998 49.416 19.794 47.44 18.274C45.464 16.678 42.88 15.88 39.688 15.88H25.78V35.032ZM95.0991 83.596C91.0711 83.596 87.4611 82.912 84.2691 81.544C81.0771 80.1 78.5311 78.048 76.6311 75.388C74.8071 72.652 73.8951 69.346 73.8951 65.47C73.8951 61.594 74.8071 58.364 76.6311 55.78C78.5311 53.12 81.1151 51.144 84.3831 49.852C87.7271 48.484 91.5271 47.8 95.7831 47.8H111.287V44.608C111.287 41.948 110.451 39.782 108.779 38.11C107.107 36.362 104.447 35.488 100.799 35.488C97.2271 35.488 94.5671 36.324 92.8191 37.996C91.0711 39.592 89.9311 41.682 89.3991 44.266L76.1751 39.82C77.0871 36.932 78.5311 34.31 80.5071 31.954C82.5591 29.522 85.2571 27.584 88.6011 26.14C92.0211 24.62 96.1631 23.86 101.027 23.86C108.475 23.86 114.365 25.722 118.697 29.446C123.029 33.17 125.195 38.566 125.195 45.634V66.724C125.195 69.004 126.259 70.144 128.387 70.144H132.947V82H123.371C120.559 82 118.241 81.316 116.417 79.948C114.593 78.58 113.681 76.756 113.681 74.476V74.362H111.515C111.211 75.274 110.527 76.49 109.463 78.01C108.399 79.454 106.727 80.746 104.447 81.886C102.167 83.026 99.0511 83.596 95.0991 83.596ZM97.6071 71.968C101.635 71.968 104.903 70.866 107.411 68.662C109.995 66.382 111.287 63.38 111.287 59.656V58.516H96.8091C94.1491 58.516 92.0591 59.086 90.5391 60.226C89.0191 61.366 88.2591 62.962 88.2591 65.014C88.2591 67.066 89.0571 68.738 90.6531 70.03C92.2491 71.322 94.5671 71.968 97.6071 71.968ZM167.758 83.596C162.286 83.596 157.308 82.456 152.824 80.176C148.416 77.896 144.92 74.59 142.336 70.258C139.752 65.926 138.46 60.682 138.46 54.526V52.93C138.46 46.774 139.752 41.53 142.336 37.198C144.92 32.866 148.416 29.56 152.824 27.28C157.308 25 162.286 23.86 167.758 23.86C173.154 23.86 177.79 24.81 181.666 26.71C185.542 28.61 188.658 31.232 191.014 34.576C193.446 37.844 195.042 41.568 195.802 45.748L181.894 48.712C181.59 46.432 180.906 44.38 179.842 42.556C178.778 40.732 177.258 39.288 175.282 38.224C173.382 37.16 170.988 36.628 168.1 36.628C165.212 36.628 162.59 37.274 160.234 38.566C157.954 39.782 156.13 41.644 154.762 44.152C153.47 46.584 152.824 49.586 152.824 53.158V54.298C152.824 57.87 153.47 60.91 154.762 63.418C156.13 65.85 157.954 67.712 160.234 69.004C162.59 70.22 165.212 70.828 168.1 70.828C172.432 70.828 175.7 69.726 177.904 67.522C180.184 65.242 181.628 62.278 182.236 58.63L196.144 61.936C195.156 65.964 193.446 69.65 191.014 72.994C188.658 76.262 185.542 78.846 181.666 80.746C177.79 82.646 173.154 83.596 167.758 83.596ZM206.853 82V2.19999H221.217V46.318H223.269L241.965 25.456H260.661L234.555 52.816L261.573 82H243.105L223.269 59.542H221.217V82H206.853ZM325.112 83.596C318.956 83.596 313.522 82.494 308.81 80.29C304.098 78.086 300.412 74.932 297.752 70.828C295.092 66.724 293.762 61.784 293.762 56.008V52.816H308.582V56.008C308.582 60.796 310.064 64.406 313.028 66.838C315.992 69.194 320.02 70.372 325.112 70.372C330.28 70.372 334.118 69.346 336.626 67.294C339.21 65.242 340.502 62.62 340.502 59.428C340.502 57.224 339.856 55.438 338.564 54.07C337.348 52.702 335.524 51.6 333.092 50.764C330.736 49.852 327.848 49.016 324.428 48.256L321.806 47.686C316.334 46.47 311.622 44.95 307.67 43.126C303.794 41.226 300.792 38.756 298.664 35.716C296.612 32.676 295.586 28.724 295.586 23.86C295.586 18.996 296.726 14.854 299.006 11.434C301.362 7.938 304.63 5.278 308.81 3.454C313.066 1.554 318.044 0.603995 323.744 0.603995C329.444 0.603995 334.498 1.592 338.906 3.568C343.39 5.468 346.886 8.35599 349.394 12.232C351.978 16.032 353.27 20.82 353.27 26.596V30.016H338.45V26.596C338.45 23.556 337.842 21.124 336.626 19.3C335.486 17.4 333.814 16.032 331.61 15.196C329.406 14.284 326.784 13.828 323.744 13.828C319.184 13.828 315.802 14.702 313.598 16.45C311.47 18.122 310.406 20.44 310.406 23.404C310.406 25.38 310.9 27.052 311.888 28.42C312.952 29.788 314.51 30.928 316.562 31.84C318.614 32.752 321.236 33.55 324.428 34.234L327.05 34.804C332.75 36.02 337.69 37.578 341.87 39.478C346.126 41.378 349.432 43.886 351.788 47.002C354.144 50.118 355.322 54.108 355.322 58.972C355.322 63.836 354.068 68.13 351.56 71.854C349.128 75.502 345.632 78.39 341.072 80.518C336.588 82.57 331.268 83.596 325.112 83.596ZM365.861 82V2.19999H380.225V32.41H382.277C382.885 31.194 383.835 29.978 385.127 28.762C386.419 27.546 388.129 26.558 390.257 25.798C392.461 24.962 395.235 24.544 398.579 24.544C402.987 24.544 406.825 25.57 410.093 27.622C413.437 29.598 416.021 32.372 417.845 35.944C419.669 39.44 420.581 43.544 420.581 48.256V82H406.217V49.396C406.217 45.14 405.153 41.948 403.025 39.82C400.973 37.692 398.009 36.628 394.133 36.628C389.725 36.628 386.305 38.11 383.873 41.074C381.441 43.962 380.225 48.028 380.225 53.272V82H365.861ZM461.873 83.596C456.249 83.596 451.195 82.456 446.711 80.176C442.227 77.896 438.693 74.59 436.109 70.258C433.525 65.926 432.233 60.72 432.233 54.64V52.816C432.233 46.736 433.525 41.53 436.109 37.198C438.693 32.866 442.227 29.56 446.711 27.28C451.195 25 456.249 23.86 461.873 23.86C467.497 23.86 472.551 25 477.035 27.28C481.519 29.56 485.053 32.866 487.637 37.198C490.221 41.53 491.513 46.736 491.513 52.816V54.64C491.513 60.72 490.221 65.926 487.637 70.258C485.053 74.59 481.519 77.896 477.035 80.176C472.551 82.456 467.497 83.596 461.873 83.596ZM461.873 70.828C466.281 70.828 469.929 69.422 472.817 66.61C475.705 63.722 477.149 59.618 477.149 54.298V53.158C477.149 47.838 475.705 43.772 472.817 40.96C470.005 38.072 466.357 36.628 461.873 36.628C457.465 36.628 453.817 38.072 450.929 40.96C448.041 43.772 446.597 47.838 446.597 53.158V54.298C446.597 59.618 448.041 63.722 450.929 66.61C453.817 69.422 457.465 70.828 461.873 70.828ZM503.631 82V25.456H517.767V31.84H519.819C520.655 29.56 522.023 27.888 523.923 26.824C525.899 25.76 528.179 25.228 530.763 25.228H537.603V37.996H530.535C526.887 37.996 523.885 38.984 521.529 40.96C519.173 42.86 517.995 45.824 517.995 49.852V82H503.631ZM569.351 82C565.627 82 562.587 80.86 560.231 78.58C557.951 76.224 556.811 73.108 556.811 69.232V37.312H542.675V25.456H556.811V7.9H571.175V25.456H586.679V37.312H571.175V66.724C571.175 69.004 572.239 70.144 574.367 70.144H585.311V82H569.351ZM598.541 82V2.19999H612.905V82H598.541ZM633.838 104.8V92.26H664.618C666.746 92.26 667.81 91.12 667.81 88.84V74.59H665.758C665.15 75.882 664.2 77.174 662.908 78.466C661.616 79.758 659.868 80.822 657.664 81.658C655.46 82.494 652.648 82.912 649.228 82.912C644.82 82.912 640.944 81.924 637.6 79.948C634.332 77.896 631.786 75.084 629.962 71.512C628.138 67.94 627.226 63.836 627.226 59.2V25.456H641.59V58.06C641.59 62.316 642.616 65.508 644.668 67.636C646.796 69.764 649.798 70.828 653.674 70.828C658.082 70.828 661.502 69.384 663.934 66.496C666.366 63.532 667.582 59.428 667.582 54.184V25.456H681.946V92.032C681.946 95.908 680.806 98.986 678.526 101.266C676.246 103.622 673.206 104.8 669.406 104.8H633.838ZM698.5 55.78V2.19999H713.092V55.78H698.5ZM705.796 83.596C702.756 83.596 700.172 82.608 698.044 80.632C695.992 78.58 694.966 75.958 694.966 72.766C694.966 69.574 695.992 66.99 698.044 65.014C700.172 62.962 702.756 61.936 705.796 61.936C708.912 61.936 711.496 62.962 713.548 65.014C715.6 66.99 716.626 69.574 716.626 72.766C716.626 75.958 715.6 78.58 713.548 80.632C711.496 82.608 708.912 83.596 705.796 83.596Z"
          fill={theme.palette.primary.main}
        />
        <path
          d="M0.244 82H-0.41494V82.6589H0.244V82ZM0.244 68.776V68.1171H-0.41494V68.776H0.244ZM10.732 68.776V69.4349H11.3909V68.776H10.732ZM10.732 15.424H11.3909V14.7651H10.732V15.424ZM0.244 15.424H-0.41494V16.0829H0.244V15.424ZM0.244 2.19999V1.54105H-0.41494V2.19999H0.244ZM53.938 4.708L53.6586 5.30479L53.6662 5.30834L53.6739 5.31169L53.938 4.708ZM62.374 11.662L61.8215 12.0211L61.8268 12.0292L61.8322 12.0371L62.374 11.662ZM63.4 32.524L63.9651 32.8631L63.9698 32.8549L63.4 32.524ZM58.498 37.882L58.8635 38.4303L58.8685 38.4269L58.498 37.882ZM53.254 40.504L53.0542 39.8761L52.5951 40.0222V40.504H53.254ZM53.254 42.556H52.5951V43.0593L53.0806 43.1917L53.254 42.556ZM58.726 45.178L58.3654 45.7295L58.373 45.7345L58.3807 45.7392L58.726 45.178ZM63.742 50.536L63.1722 50.8669L63.1761 50.8737L63.1802 50.8803L63.742 50.536ZM62.83 72.31L63.3804 72.6724L63.3843 72.6663L62.83 72.31ZM54.28 79.492L54.0054 78.893L54.0007 78.8952L54.28 79.492ZM25.78 68.32H25.1211V68.9789H25.78V68.32ZM47.782 65.926L47.3774 65.4058L47.368 65.4134L47.782 65.926ZM47.896 51.106L48.31 50.5934L47.896 51.106ZM25.78 48.712V48.0531H25.1211V48.712H25.78ZM25.78 35.032H25.1211V35.6909H25.78V35.032ZM47.326 32.638L46.9214 32.1178L46.912 32.1254L47.326 32.638ZM47.44 18.274L47.026 18.7866L47.032 18.7915L47.0382 18.7963L47.44 18.274ZM25.78 15.88V15.2211H25.1211V15.88H25.78ZM0.902941 82V68.776H-0.41494V82H0.902941ZM0.244 69.4349H10.732V68.1171H0.244V69.4349ZM11.3909 68.776V15.424H10.0731V68.776H11.3909ZM10.732 14.7651H0.244V16.0829H10.732V14.7651ZM0.902941 15.424V2.19999H-0.41494V15.424H0.902941ZM0.244 2.85893H41.284V1.54105H0.244V2.85893ZM41.284 2.85893C46.0735 2.85893 50.192 3.68212 53.6586 5.30479L54.2174 4.1112C50.54 2.38987 46.2225 1.54105 41.284 1.54105V2.85893ZM53.6739 5.31169C57.216 6.86136 59.9225 9.09959 61.8215 12.0211L62.9265 11.3029C60.8735 8.14441 57.956 5.74664 54.2021 4.1043L53.6739 5.31169ZM61.8322 12.0371C63.7963 14.8741 64.7931 18.31 64.7931 22.378H66.1109C66.1109 18.086 65.0557 14.3779 62.9158 11.2869L61.8322 12.0371ZM64.7931 22.378V23.518H66.1109V22.378H64.7931ZM64.7931 23.518C64.7931 27.0878 64.1233 29.9661 62.8302 32.1931L63.9698 32.8549C65.4127 30.3699 66.1109 27.2442 66.1109 23.518H64.7931ZM62.835 32.185C61.5084 34.3959 59.937 36.1066 58.1275 37.3371L58.8685 38.4269C60.859 37.0734 62.5556 35.2121 63.965 32.863L62.835 32.185ZM58.1325 37.3337C56.3476 38.5237 54.655 39.3667 53.0542 39.8761L53.4538 41.1319C55.197 40.5773 57.0004 39.6723 58.8635 38.4303L58.1325 37.3337ZM52.5951 40.504V42.556H53.9129V40.504H52.5951ZM53.0806 43.1917C54.667 43.6244 56.4276 44.4625 58.3654 45.7295L59.0866 44.6265C57.0724 43.3095 55.185 42.3996 53.4274 41.9203L53.0806 43.1917ZM58.3807 45.7392C60.249 46.889 61.8493 48.5886 63.1722 50.8669L64.3119 50.2051C62.8987 47.7714 61.155 45.899 59.0714 44.6168L58.3807 45.7392ZM63.1802 50.8803C64.5411 53.1008 65.2491 56.0477 65.2491 59.77H66.5669C66.5669 55.8923 65.8309 52.6832 64.3038 50.1917L63.1802 50.8803ZM65.2491 59.77V60.91H66.5669V59.77H65.2491ZM65.2491 60.91C65.2491 65.2125 64.2489 68.8842 62.2757 71.9537L63.3843 72.6663C65.5151 69.3518 66.5669 65.4235 66.5669 60.91H65.2491ZM62.2797 71.9476C60.3008 74.9526 57.55 77.2684 54.0055 78.893L54.5546 80.091C58.306 78.3716 61.2552 75.8994 63.3803 72.6724L62.2797 71.9476ZM54.0007 78.8952C50.5328 80.5185 46.4517 81.3411 41.74 81.3411V82.6589C46.6043 82.6589 50.8832 81.8095 54.5594 80.0888L54.0007 78.8952ZM41.74 81.3411H0.244V82.6589H41.74V81.3411ZM25.78 68.9789H39.916V67.6611H25.78V68.9789ZM39.916 68.9789C43.2909 68.9789 46.0727 68.1536 48.196 66.4386L47.368 65.4134C45.5393 66.8904 43.0771 67.6611 39.916 67.6611V68.9789ZM48.1866 66.4461C50.423 64.7067 51.5189 62.221 51.5189 59.086H50.2011C50.2011 61.879 49.245 63.9533 47.3775 65.4059L48.1866 66.4461ZM51.5189 59.086V57.946H50.2011V59.086H51.5189ZM51.5189 57.946C51.5189 54.8201 50.4677 52.3361 48.31 50.5934L47.482 51.6186C49.2763 53.0679 50.2011 55.1439 50.2011 57.946H51.5189ZM48.31 50.5934C46.1842 48.8764 43.3627 48.0531 39.916 48.0531V49.3709C43.1573 49.3709 45.6558 50.1436 47.482 51.6186L48.31 50.5934ZM39.916 48.0531H25.78V49.3709H39.916V48.0531ZM25.1211 48.712V68.32H26.4389V48.712H25.1211ZM25.78 35.6909H39.688V34.3731H25.78V35.6909ZM39.688 35.6909C42.9195 35.6909 45.6221 34.8613 47.74 33.1506L46.912 32.1254C45.0779 33.6067 42.6885 34.3731 39.688 34.3731V35.6909ZM47.7306 33.1581C49.9576 31.426 51.0629 29.0222 51.0629 26.026H49.7451C49.7451 28.6538 48.7984 30.658 46.9215 32.1179L47.7306 33.1581ZM51.0629 26.026V24.886H49.7451V26.026H51.0629ZM51.0629 24.886C51.0629 21.8301 50.0069 19.4172 47.8418 17.7517L47.0382 18.7963C48.8251 20.1708 49.7451 22.1659 49.7451 24.886H51.0629ZM47.854 17.7614C45.7334 16.0485 42.9911 15.2211 39.688 15.2211V16.5389C42.7689 16.5389 45.1946 17.3075 47.026 18.7866L47.854 17.7614ZM39.688 15.2211H25.78V16.5389H39.688V15.2211ZM25.1211 15.88V35.032H26.4389V15.88H25.1211ZM84.2691 81.544L83.9975 82.1445L84.0096 82.1497L84.2691 81.544ZM76.6311 75.388L76.0829 75.7535L76.0887 75.7624L76.0949 75.771L76.6311 75.388ZM76.6311 55.78L76.0949 55.397L76.0928 55.4L76.6311 55.78ZM84.3831 49.852L84.6254 50.4648L84.6326 50.4619L84.3831 49.852ZM111.287 47.8V48.4589H111.946V47.8H111.287ZM108.779 38.11L108.303 38.5655L108.308 38.5708L108.313 38.5759L108.779 38.11ZM92.8191 37.996L93.2634 38.4826L93.2691 38.4775L93.2746 38.4722L92.8191 37.996ZM89.3991 44.266L89.1891 44.8906L89.8945 45.1277L90.0445 44.3989L89.3991 44.266ZM76.1751 39.82L75.5468 39.6216L75.352 40.2384L75.9651 40.4446L76.1751 39.82ZM80.5071 31.954L80.0035 31.5291L80.0023 31.5306L80.5071 31.954ZM88.6011 26.14L88.8624 26.745L88.8688 26.7421L88.6011 26.14ZM118.697 29.446L118.268 29.9457L118.697 29.446ZM132.947 70.144H133.606V69.4851H132.947V70.144ZM132.947 82V82.6589H133.606V82H132.947ZM116.417 79.948L116.022 80.4752H116.022L116.417 79.948ZM113.681 74.362H114.34V73.7031H113.681V74.362ZM111.515 74.362V73.7031H111.04L110.89 74.1536L111.515 74.362ZM109.463 78.01L109.994 78.4009L109.998 78.3944L110.003 78.3879L109.463 78.01ZM104.447 81.886L104.742 82.4754L104.447 81.886ZM107.411 68.662L107.846 69.157L107.847 69.1561L107.411 68.662ZM111.287 58.516H111.946V57.8571H111.287V58.516ZM90.5391 60.226L90.9345 60.7532L90.5391 60.226ZM90.6531 70.03L90.2385 70.5422L90.6531 70.03ZM95.0991 82.9371C91.1462 82.9371 87.6266 82.266 84.5287 80.9383L84.0096 82.1497C87.2956 83.558 90.996 84.2549 95.0991 84.2549V82.9371ZM84.5407 80.9436C81.4467 79.5439 78.995 77.5637 77.1673 75.005L76.0949 75.771C78.0673 78.5323 80.7076 80.6561 83.9975 82.1444L84.5407 80.9436ZM77.1794 75.0225C75.4397 72.4129 74.5541 69.2396 74.5541 65.47H73.2362C73.2362 69.4524 74.1746 72.8911 76.0829 75.7535L77.1794 75.0225ZM74.5541 65.47C74.5541 61.699 75.4402 58.6098 77.1695 56.16L76.0928 55.4C74.1741 58.1181 73.2362 61.489 73.2362 65.47H74.5541ZM77.1673 56.163C78.988 53.6141 81.4662 51.7138 84.6254 50.4648L84.1409 49.2392C80.764 50.5742 78.0743 52.6259 76.0949 55.397L77.1673 56.163ZM84.6326 50.4619C87.8847 49.1315 91.5977 48.4589 95.7831 48.4589V47.1411C91.4565 47.1411 87.5696 47.8365 84.1336 49.2421L84.6326 50.4619ZM95.7831 48.4589H111.287V47.1411H95.7831V48.4589ZM111.946 47.8V44.608H110.628V47.8H111.946ZM111.946 44.608C111.946 41.7971 111.057 39.4555 109.245 37.6441L108.313 38.5759C109.846 40.1085 110.628 42.0989 110.628 44.608H111.946ZM109.255 37.6545C107.408 35.723 104.536 34.8291 100.799 34.8291V36.1469C104.358 36.1469 106.806 37.001 108.303 38.5655L109.255 37.6545ZM100.799 34.8291C97.1373 34.8291 94.2819 35.685 92.3637 37.5198L93.2746 38.4722C94.8524 36.963 97.3169 36.1469 100.799 36.1469V34.8291ZM92.3748 37.5094C90.5125 39.2098 89.3104 41.4293 88.7537 44.1331L90.0445 44.3989C90.5519 41.9347 91.6298 39.9742 93.2634 38.4826L92.3748 37.5094ZM89.6091 43.6414L76.3851 39.1954L75.9651 40.4446L89.1891 44.8906L89.6091 43.6414ZM76.8035 40.0184C77.6891 37.2141 79.0906 34.6683 81.012 32.3774L80.0023 31.5306C77.9716 33.9517 76.4852 36.6499 75.5468 39.6216L76.8035 40.0184ZM81.0107 32.3789C82.988 30.0355 85.5984 28.1544 88.8624 26.7449L88.3399 25.5351C84.9159 27.0136 82.1302 29.0085 80.0035 31.5291L81.0107 32.3789ZM88.8688 26.7421C92.1833 25.269 96.2289 24.5189 101.027 24.5189V23.2011C96.0974 23.2011 91.859 23.971 88.3335 25.5379L88.8688 26.7421ZM101.027 24.5189C108.366 24.5189 114.088 26.3523 118.268 29.9457L119.127 28.9463C114.643 25.0917 108.584 23.2011 101.027 23.2011V24.5189ZM118.268 29.9457C122.42 33.5155 124.536 38.7085 124.536 45.634H125.854C125.854 38.4235 123.638 32.8245 119.127 28.9463L118.268 29.9457ZM124.536 45.634V66.724H125.854V45.634H124.536ZM124.536 66.724C124.536 67.9547 124.822 69.0004 125.511 69.7386C126.208 70.4854 127.209 70.8029 128.387 70.8029V69.4851C127.437 69.4851 126.842 69.2327 126.475 68.8394C126.1 68.4376 125.854 67.7733 125.854 66.724H124.536ZM128.387 70.8029H132.947V69.4851H128.387V70.8029ZM132.288 70.144V82H133.606V70.144H132.288ZM132.947 81.3411H123.371V82.6589H132.947V81.3411ZM123.371 81.3411C120.668 81.3411 118.498 80.685 116.812 79.4208L116.022 80.4752C117.984 81.947 120.45 82.6589 123.371 82.6589V81.3411ZM116.812 79.4208C115.154 78.1773 114.34 76.5486 114.34 74.476H113.022C113.022 76.9634 114.032 78.9827 116.022 80.4752L116.812 79.4208ZM114.34 74.476V74.362H113.022V74.476H114.34ZM113.681 73.7031H111.515V75.0209H113.681V73.7031ZM110.89 74.1536C110.617 74.9726 109.978 76.1253 108.923 77.6321L110.003 78.3879C111.076 76.8547 111.805 75.5754 112.14 74.5704L110.89 74.1536ZM108.933 77.6191C107.951 78.9515 106.376 80.1849 104.152 81.2966L104.742 82.4754C107.078 81.3071 108.847 79.9565 109.994 78.4009L108.933 77.6191ZM104.152 81.2966C102.001 82.3726 98.9997 82.9371 95.0991 82.9371V84.2549C99.1025 84.2549 102.334 83.6795 104.742 82.4754L104.152 81.2966ZM97.6071 72.6269C101.761 72.6269 105.194 71.4875 107.846 69.157L106.976 68.167C104.612 70.2445 101.51 71.3091 97.6071 71.3091V72.6269ZM107.847 69.1561C110.585 66.7401 111.946 63.5519 111.946 59.656H110.628C110.628 63.2081 109.405 66.0239 106.975 68.1679L107.847 69.1561ZM111.946 59.656V58.516H110.628V59.656H111.946ZM111.287 57.8571H96.8091V59.1749H111.287V57.8571ZM96.8091 57.8571C94.0622 57.8571 91.8155 58.445 90.1438 59.6988L90.9345 60.7532C92.3028 59.727 94.2361 59.1749 96.8091 59.1749V57.8571ZM90.1438 59.6988C88.443 60.9744 87.6002 62.7738 87.6002 65.014H88.9181C88.9181 63.1502 89.5952 61.7576 90.9345 60.7532L90.1438 59.6988ZM87.6002 65.014C87.6002 67.265 88.4881 69.1251 90.2385 70.5422L91.0677 69.5178C89.6262 68.3509 88.9181 66.867 88.9181 65.014H87.6002ZM90.2385 70.5422C91.9966 71.9654 94.4861 72.6269 97.6071 72.6269V71.3091C94.6481 71.3091 92.5017 70.6786 91.0677 69.5178L90.2385 70.5422ZM152.824 80.176L152.521 80.7613L152.525 80.7634L152.824 80.176ZM142.336 37.198L142.902 37.5356L142.336 37.198ZM152.824 27.28L152.525 26.6926L152.521 26.6947L152.824 27.28ZM181.666 26.71L181.376 27.3017L181.666 26.71ZM191.014 34.576L190.475 34.9555L190.48 34.9625L190.485 34.9694L191.014 34.576ZM195.802 45.748L195.939 46.3925L196.565 46.2592L196.45 45.6301L195.802 45.748ZM181.894 48.712L181.241 48.7991L181.335 49.5049L182.031 49.3565L181.894 48.712ZM175.282 38.224L174.96 38.799L174.97 38.8042L175.282 38.224ZM160.234 38.566L160.544 39.1475L160.551 39.1438L160.234 38.566ZM154.762 44.152L154.184 43.8364L154.18 43.8429L154.762 44.152ZM154.762 63.418L154.176 63.7198L154.182 63.7305L154.188 63.7411L154.762 63.418ZM160.234 69.004L159.909 69.5773L159.92 69.5836L159.932 69.5895L160.234 69.004ZM177.904 67.522L178.37 67.9879L177.904 67.522ZM182.236 58.63L182.388 57.9889L181.702 57.8258L181.586 58.5217L182.236 58.63ZM196.144 61.936L196.784 62.093L196.942 61.4484L196.296 61.2949L196.144 61.936ZM191.014 72.994L190.481 72.6064L190.48 72.6087L191.014 72.994ZM167.758 82.9371C162.381 82.9371 157.506 81.8175 153.123 79.5886L152.525 80.7634C157.11 83.0945 162.192 84.2549 167.758 84.2549V82.9371ZM153.127 79.5907C148.83 77.3681 145.424 74.1488 142.902 69.9204L141.77 70.5956C144.416 75.0312 148.002 78.4239 152.521 80.7613L153.127 79.5907ZM142.902 69.9204C140.391 65.7109 139.119 60.5893 139.119 54.526H137.801C137.801 60.7747 139.113 66.1411 141.77 70.5956L142.902 69.9204ZM139.119 54.526V52.93H137.801V54.526H139.119ZM139.119 52.93C139.119 46.8667 140.391 41.7451 142.902 37.5356L141.77 36.8604C139.113 41.3148 137.801 46.6813 137.801 52.93H139.119ZM142.902 37.5356C145.424 33.3072 148.83 30.0879 153.127 27.8653L152.521 26.6947C148.002 29.0321 144.416 32.4248 141.77 36.8604L142.902 37.5356ZM153.123 27.8674C157.506 25.6385 162.381 24.5189 167.758 24.5189V23.2011C162.192 23.2011 157.11 24.3615 152.525 26.6926L153.123 27.8674ZM167.758 24.5189C173.078 24.5189 177.61 25.4556 181.376 27.3017L181.956 26.1183C177.97 24.1644 173.23 23.2011 167.758 23.2011V24.5189ZM181.376 27.3017C185.158 29.1557 188.187 31.707 190.475 34.9555L191.553 34.1965C189.129 30.757 185.926 28.0643 181.956 26.1183L181.376 27.3017ZM190.485 34.9694C192.854 38.1525 194.411 41.7813 195.154 45.8659L196.45 45.6301C195.673 41.3547 194.038 37.5355 191.543 34.1826L190.485 34.9694ZM195.665 45.1035L181.757 48.0675L182.031 49.3565L195.939 46.3925L195.665 45.1035ZM182.547 48.6249C182.233 46.2663 181.523 44.1297 180.411 42.224L179.273 42.888C180.289 44.6302 180.947 46.5977 181.241 48.7991L182.547 48.6249ZM180.411 42.224C179.282 40.2885 177.67 38.7616 175.594 37.6438L174.97 38.8042C176.846 39.8144 178.274 41.1754 179.273 42.888L180.411 42.224ZM175.604 37.6491C173.579 36.5149 171.065 35.9691 168.1 35.9691V37.2869C170.911 37.2869 173.185 37.8051 174.96 38.7989L175.604 37.6491ZM168.1 35.9691C165.11 35.9691 162.378 36.639 159.917 37.9882L160.551 39.1438C162.803 37.909 165.314 37.2869 168.1 37.2869V35.9691ZM159.924 37.9846C157.519 39.2674 155.606 41.2279 154.184 43.8365L155.341 44.4675C156.654 42.0601 158.39 40.2966 160.544 39.1474L159.924 37.9846ZM154.18 43.8429C152.825 46.3941 152.165 49.5092 152.165 53.158H153.483C153.483 49.6628 154.115 46.7739 155.344 44.4611L154.18 43.8429ZM152.165 53.158V54.298H153.483V53.158H152.165ZM152.165 54.298C152.165 57.9477 152.825 61.0969 154.176 63.7198L155.348 63.1162C154.115 60.7231 153.483 57.7923 153.483 54.298H152.165ZM154.188 63.7411C155.611 66.2706 157.518 68.2223 159.909 69.5773L160.559 68.4307C158.39 67.2017 156.65 65.4294 155.336 63.0949L154.188 63.7411ZM159.932 69.5895C162.389 70.858 165.117 71.4869 168.1 71.4869V70.1691C165.308 70.1691 162.791 69.582 160.536 68.4184L159.932 69.5895ZM168.1 71.4869C172.538 71.4869 176.001 70.3572 178.37 67.9879L177.438 67.0561C175.399 69.0948 172.327 70.1691 168.1 70.1691V71.4869ZM178.37 67.9879C180.761 65.597 182.259 62.5012 182.886 58.7383L181.586 58.5217C180.997 62.0548 179.607 64.887 177.438 67.0561L178.37 67.9879ZM182.084 59.2711L195.992 62.5771L196.296 61.2949L182.388 57.9889L182.084 59.2711ZM195.504 61.779C194.536 65.7242 192.863 69.3318 190.481 72.6064L191.547 73.3816C194.029 69.9682 195.776 66.2038 196.784 62.093L195.504 61.779ZM190.48 72.6087C188.191 75.7826 185.162 78.2985 181.376 80.1543L181.956 81.3377C185.922 79.3935 189.125 76.7414 191.549 73.3793L190.48 72.6087ZM181.376 80.1543C177.61 82.0004 173.078 82.9371 167.758 82.9371V84.2549C173.23 84.2549 177.97 83.2916 181.956 81.3377L181.376 80.1543ZM206.853 82H206.194V82.6589H206.853V82ZM206.853 2.19999V1.54105H206.194V2.19999H206.853ZM221.217 2.19999H221.876V1.54105H221.217V2.19999ZM221.217 46.318H220.558V46.9769H221.217V46.318ZM223.269 46.318V46.9769H223.563L223.76 46.7578L223.269 46.318ZM241.965 25.456V24.7971H241.671L241.474 25.0162L241.965 25.456ZM260.661 25.456L261.138 25.9109L262.201 24.7971H260.661V25.456ZM234.555 52.816L234.078 52.3611L233.651 52.8092L234.071 53.2636L234.555 52.816ZM261.573 82V82.6589H263.081L262.057 81.5523L261.573 82ZM243.105 82L242.611 82.4362L242.808 82.6589H243.105V82ZM223.269 59.542L223.763 59.1058L223.566 58.8831H223.269V59.542ZM221.217 59.542V58.8831H220.558V59.542H221.217ZM221.217 82V82.6589H221.876V82H221.217ZM207.512 82V2.19999H206.194V82H207.512ZM206.853 2.85893H221.217V1.54105H206.853V2.85893ZM220.558 2.19999V46.318H221.876V2.19999H220.558ZM221.217 46.9769H223.269V45.6591H221.217V46.9769ZM223.76 46.7578L242.456 25.8958L241.474 25.0162L222.778 45.8782L223.76 46.7578ZM241.965 26.1149H260.661V24.7971H241.965V26.1149ZM260.184 25.0011L234.078 52.3611L235.032 53.2709L261.138 25.9109L260.184 25.0011ZM234.071 53.2636L261.089 82.4477L262.057 81.5523L235.039 52.3683L234.071 53.2636ZM261.573 81.3411H243.105V82.6589H261.573V81.3411ZM243.599 81.5638L223.763 59.1058L222.775 59.9782L242.611 82.4362L243.599 81.5638ZM223.269 58.8831H221.217V60.2009H223.269V58.8831ZM220.558 59.542V82H221.876V59.542H220.558ZM221.217 81.3411H206.853V82.6589H221.217V81.3411ZM308.81 80.29L308.531 80.8869L308.81 80.29ZM297.752 70.828L298.305 70.4696L297.752 70.828ZM293.762 52.816V52.1571H293.103V52.816H293.762ZM308.582 52.816H309.241V52.1571H308.582V52.816ZM313.028 66.838L312.61 67.3475L312.618 67.3538L313.028 66.838ZM336.626 67.294L336.216 66.7779L336.209 66.784L336.626 67.294ZM338.564 54.07L338.071 54.5078L338.078 54.5152L338.085 54.5224L338.564 54.07ZM333.092 50.764L332.854 51.3785L332.866 51.3831L332.878 51.3871L333.092 50.764ZM324.428 48.256L324.571 47.6127L324.568 47.6121L324.428 48.256ZM321.806 47.686L321.663 48.3293L321.666 48.3299L321.806 47.686ZM307.67 43.126L307.38 43.7177L307.387 43.7211L307.394 43.7243L307.67 43.126ZM298.664 35.716L298.118 36.0847L298.124 36.0939L298.664 35.716ZM299.006 11.434L298.459 11.0657L298.458 11.0685L299.006 11.434ZM308.81 3.454L309.073 4.05797L309.079 4.0557L308.81 3.454ZM338.906 3.568L338.636 4.16941L338.649 4.17472L338.906 3.568ZM349.394 12.232L348.841 12.59L348.845 12.5963L348.849 12.6025L349.394 12.232ZM353.27 30.016V30.6749H353.929V30.016H353.27ZM338.45 30.016H337.791V30.6749H338.45V30.016ZM336.626 19.3L336.061 19.639L336.069 19.6525L336.078 19.6655L336.626 19.3ZM331.61 15.196L331.358 15.8049L331.367 15.8086L331.376 15.8121L331.61 15.196ZM313.598 16.45L314.005 16.9681L314.007 16.9663L313.598 16.45ZM311.888 28.42L311.354 28.8058L311.361 28.8153L311.368 28.8245L311.888 28.42ZM324.428 34.234L324.568 33.5901L324.566 33.5897L324.428 34.234ZM327.05 34.804L326.91 35.4479L326.912 35.4484L327.05 34.804ZM341.87 39.478L341.597 40.0779L341.601 40.0797L341.87 39.478ZM351.788 47.002L352.314 46.6046L351.788 47.002ZM351.56 71.854L351.013 71.4859L351.012 71.4885L351.56 71.854ZM341.072 80.518L341.346 81.1172L341.351 81.1151L341.072 80.518ZM325.112 82.9371C319.035 82.9371 313.699 81.8494 309.089 79.6931L308.531 80.8869C313.345 83.1386 318.877 84.2549 325.112 84.2549V82.9371ZM309.089 79.6931C304.481 77.5379 300.893 74.4634 298.305 70.4696L297.199 71.1864C299.93 75.4006 303.714 78.6341 308.531 80.8869L309.089 79.6931ZM298.305 70.4696C295.726 66.4904 294.421 61.6802 294.421 56.008H293.103C293.103 61.8878 294.458 66.9576 297.199 71.1864L298.305 70.4696ZM294.421 56.008V52.816H293.103V56.008H294.421ZM293.762 53.4749H308.582V52.1571H293.762V53.4749ZM307.923 52.816V56.008H309.241V52.816H307.923ZM307.923 56.008C307.923 60.9397 309.456 64.7598 312.61 67.3474L313.446 66.3286C310.672 64.0522 309.241 60.6523 309.241 56.008H307.923ZM312.618 67.3538C315.733 69.83 319.922 71.0309 325.112 71.0309V69.7131C320.118 69.7131 316.251 68.558 313.438 66.3222L312.618 67.3538ZM325.112 71.0309C330.347 71.0309 334.365 69.995 337.043 67.804L336.209 66.784C333.871 68.697 330.213 69.7131 325.112 69.7131V71.0309ZM337.036 67.81C339.771 65.6379 341.161 62.8288 341.161 59.428H339.843C339.843 62.4112 338.649 64.8461 336.216 66.778L337.036 67.81ZM341.161 59.428C341.161 57.0866 340.47 55.1286 339.043 53.6176L338.085 54.5224C339.242 55.7474 339.843 57.3614 339.843 59.428H341.161ZM339.056 53.6322C337.741 52.1521 335.804 50.9996 333.306 50.1408L332.878 51.3871C335.244 52.2004 336.955 53.2519 338.071 54.5078L339.056 53.6322ZM333.33 50.1495C330.934 49.222 328.012 48.3774 324.571 47.6128L324.285 48.8993C327.684 49.6546 330.538 50.482 332.854 51.3785L333.33 50.1495ZM324.568 47.6121L321.946 47.0421L321.666 48.3299L324.288 48.8999L324.568 47.6121ZM321.949 47.0427C316.51 45.8342 311.845 44.3273 307.946 42.5277L307.394 43.7243C311.399 45.5727 316.157 47.1058 321.663 48.3292L321.949 47.0427ZM307.96 42.5343C304.168 40.6753 301.258 38.273 299.204 35.3381L298.124 36.0939C300.326 39.239 303.42 41.7767 307.38 43.7177L307.96 42.5343ZM299.21 35.3473C297.252 32.4466 296.245 28.6347 296.245 23.86H294.927C294.927 28.8132 295.972 32.9054 298.118 36.0847L299.21 35.3473ZM296.245 23.86C296.245 19.1018 297.359 15.0927 299.554 11.7995L298.458 11.0685C296.093 14.6153 294.927 18.8902 294.927 23.86H296.245ZM299.552 11.8022C301.833 8.4186 304.998 5.83612 309.073 4.05794L308.546 2.85005C304.261 4.71987 300.891 7.45739 298.46 11.0657L299.552 11.8022ZM309.079 4.0557C313.233 2.20087 318.116 1.26294 323.744 1.26294V-0.0549457C317.972 -0.0549457 312.898 0.907126 308.541 2.8523L309.079 4.0557ZM323.744 1.26294C329.368 1.26294 334.327 2.23751 338.636 4.16929L339.175 2.96671C334.669 0.946481 329.52 -0.0549457 323.744 -0.0549457V1.26294ZM338.649 4.17472C343.018 6.02627 346.408 8.83088 348.841 12.59L349.947 11.874C347.363 7.88111 343.761 4.90973 339.163 2.96128L338.649 4.17472ZM348.849 12.6025C351.342 16.2681 352.611 20.9181 352.611 26.596H353.929C353.929 20.7219 352.614 15.7958 349.939 11.8615L348.849 12.6025ZM352.611 26.596V30.016H353.929V26.596H352.611ZM353.27 29.3571H338.45V30.6749H353.27V29.3571ZM339.109 30.016V26.596H337.791V30.016H339.109ZM339.109 26.596C339.109 23.4745 338.485 20.9011 337.174 18.9345L336.078 19.6655C337.199 21.3469 337.791 23.6375 337.791 26.596H339.109ZM337.191 18.961C335.97 16.9256 334.177 15.4648 331.844 14.5799L331.376 15.8121C333.451 16.5992 335.002 17.8744 336.061 19.639L337.191 18.961ZM331.862 14.5871C329.559 13.6344 326.848 13.1691 323.744 13.1691V14.4869C326.72 14.4869 329.253 14.9336 331.358 15.8049L331.862 14.5871ZM323.744 13.1691C319.121 13.1691 315.562 14.0514 313.188 15.9337L314.007 16.9663C316.042 15.3526 319.247 14.4869 323.744 14.4869V13.1691ZM313.191 15.9319C310.887 17.7418 309.747 20.2599 309.747 23.404H311.065C311.065 20.6201 312.053 18.5022 314.005 16.9681L313.191 15.9319ZM309.747 23.404C309.747 25.4941 310.271 27.3072 311.354 28.8058L312.422 28.0342C311.528 26.7968 311.065 25.2659 311.065 23.404H309.747ZM311.368 28.8245C312.515 30.2998 314.172 31.4987 316.294 32.4421L316.83 31.2379C314.848 30.3573 313.389 29.2762 312.408 28.0154L311.368 28.8245ZM316.294 32.4421C318.402 33.3789 321.071 34.1887 324.29 34.8783L324.566 33.5897C321.4 32.9113 318.826 32.1251 316.83 31.2379L316.294 32.4421ZM324.288 34.8779L326.91 35.4479L327.19 34.1601L324.568 33.5901L324.288 34.8779ZM326.912 35.4484C332.578 36.657 337.47 38.202 341.597 40.0779L342.143 38.8781C337.91 36.954 332.922 35.383 327.187 34.1596L326.912 35.4484ZM341.601 40.0797C345.775 41.9431 348.985 44.3878 351.262 47.3994L352.314 46.6046C349.879 43.3842 346.477 40.8129 342.139 38.8763L341.601 40.0797ZM351.262 47.3994C353.512 50.3754 354.663 54.2157 354.663 58.972H355.981C355.981 54.0003 354.775 49.8606 352.314 46.6046L351.262 47.3994ZM354.663 58.972C354.663 63.7163 353.442 67.8798 351.013 71.4859L352.106 72.2221C354.694 68.3802 355.981 63.9557 355.981 58.972H354.663ZM351.012 71.4885C348.656 75.0219 345.26 77.8362 340.793 79.9209L341.351 81.1151C346.004 78.9438 349.6 75.9821 352.108 72.2195L351.012 71.4885ZM340.798 79.9188C336.418 81.9229 331.196 82.9371 325.112 82.9371V84.2549C331.34 84.2549 336.757 83.2171 341.346 81.1172L340.798 79.9188ZM365.861 82H365.202V82.6589H365.861V82ZM365.861 2.19999V1.54105H365.202V2.19999H365.861ZM380.225 2.19999H380.884V1.54105H380.225V2.19999ZM380.225 32.41H379.566V33.0689H380.225V32.41ZM382.277 32.41V33.0689H382.684L382.866 32.7047L382.277 32.41ZM385.127 28.762L385.578 29.2418L385.127 28.762ZM390.257 25.798L390.478 26.4187L390.49 26.4141L390.257 25.798ZM410.093 27.622L409.742 28.18L409.75 28.1848L409.757 28.1893L410.093 27.622ZM417.845 35.944L417.258 36.2437L417.26 36.2488L417.845 35.944ZM420.581 82V82.6589H421.24V82H420.581ZM406.217 82H405.558V82.6589H406.217V82ZM403.025 39.82L402.55 40.2775L402.559 40.2859L403.025 39.82ZM383.873 41.074L384.377 41.4985L384.382 41.492L383.873 41.074ZM380.225 82V82.6589H380.884V82H380.225ZM366.52 82V2.19999H365.202V82H366.52ZM365.861 2.85893H380.225V1.54105H365.861V2.85893ZM379.566 2.19999V32.41H380.884V2.19999H379.566ZM380.225 33.0689H382.277V31.7511H380.225V33.0689ZM382.866 32.7047C383.431 31.5756 384.326 30.42 385.578 29.2418L384.675 28.2822C383.343 29.5359 382.339 30.8124 381.687 32.1153L382.866 32.7047ZM385.578 29.2418C386.789 28.1026 388.413 27.156 390.478 26.4185L390.035 25.1774C387.844 25.96 386.049 26.9894 384.675 28.2822L385.578 29.2418ZM390.49 26.4141C392.596 25.6156 395.284 25.2029 398.579 25.2029V23.8851C395.186 23.8851 392.326 24.3084 390.023 25.1819L390.49 26.4141ZM398.579 25.2029C402.881 25.2029 406.594 26.203 409.742 28.18L410.443 27.0639C407.056 24.937 403.093 23.8851 398.579 23.8851V25.2029ZM409.757 28.1893C412.99 30.0996 415.489 32.7791 417.258 36.2437L418.432 35.6443C416.553 31.9649 413.883 29.0964 410.428 27.0547L409.757 28.1893ZM417.26 36.2488C419.027 39.634 419.922 43.6296 419.922 48.256H421.24C421.24 43.4584 420.311 39.246 418.429 35.6392L417.26 36.2488ZM419.922 48.256V82H421.24V48.256H419.922ZM420.581 81.3411H406.217V82.6589H420.581V81.3411ZM406.876 82V49.396H405.558V82H406.876ZM406.876 49.396C406.876 45.0384 405.786 41.6492 403.491 39.3541L402.559 40.2859C404.52 42.2468 405.558 45.2416 405.558 49.396H406.876ZM403.499 39.3626C401.288 37.0692 398.129 35.9691 394.133 35.9691V37.2869C397.888 37.2869 400.658 38.3148 402.55 40.2774L403.499 39.3626ZM394.133 35.9691C389.561 35.9691 385.94 37.5156 383.363 40.656L384.382 41.492C386.669 38.7044 389.889 37.2869 394.133 37.2869V35.9691ZM383.369 40.6496C380.804 43.6953 379.566 47.9327 379.566 53.272H380.884C380.884 48.1233 382.078 44.2287 384.377 41.4984L383.369 40.6496ZM379.566 53.272V82H380.884V53.272H379.566ZM380.225 81.3411H365.861V82.6589H380.225V81.3411ZM446.711 80.176L446.412 80.7634L446.711 80.176ZM436.109 37.198L436.675 37.5356L436.109 37.198ZM446.711 27.28L447.009 27.8674L446.711 27.28ZM477.035 27.28L476.736 27.8674L477.035 27.28ZM487.637 37.198L487.071 37.5356L487.637 37.198ZM487.637 70.258L487.071 69.9204L487.637 70.258ZM477.035 80.176L476.736 79.5886L477.035 80.176ZM472.817 66.61L473.276 67.0822L473.283 67.0759L472.817 66.61ZM472.817 40.96L472.345 41.4197L472.351 41.426L472.357 41.4321L472.817 40.96ZM450.929 40.96L451.388 41.4322L451.395 41.4259L450.929 40.96ZM450.929 66.61L450.463 67.076L450.469 67.0821L450.929 66.61ZM461.873 82.9371C456.34 82.9371 451.39 81.8163 447.009 79.5886L446.412 80.7634C450.999 83.0957 456.157 84.2549 461.873 84.2549V82.9371ZM447.009 79.5886C442.637 77.3652 439.195 74.1459 436.675 69.9204L435.543 70.5956C438.19 75.0341 441.817 78.4268 446.412 80.7634L447.009 79.5886ZM436.675 69.9204C434.163 65.7097 432.892 60.6256 432.892 54.64H431.574C431.574 60.8144 432.887 66.1423 435.543 70.5956L436.675 69.9204ZM432.892 54.64V52.816H431.574V54.64H432.892ZM432.892 52.816C432.892 46.8304 434.163 41.7463 436.675 37.5356L435.543 36.8604C432.887 41.3137 431.574 46.6416 431.574 52.816H432.892ZM436.675 37.5356C439.195 33.3101 442.637 30.0908 447.009 27.8674L446.412 26.6926C441.817 29.0292 438.19 32.4219 435.543 36.8604L436.675 37.5356ZM447.009 27.8674C451.39 25.6397 456.34 24.5189 461.873 24.5189V23.2011C456.157 23.2011 450.999 24.3603 446.412 26.6926L447.009 27.8674ZM461.873 24.5189C467.405 24.5189 472.355 25.6397 476.736 27.8674L477.333 26.6926C472.746 24.3603 467.588 23.2011 461.873 23.2011V24.5189ZM476.736 27.8674C481.109 30.0908 484.55 33.3101 487.071 37.5356L488.203 36.8604C485.555 32.4219 481.929 29.0292 477.333 26.6926L476.736 27.8674ZM487.071 37.5356C489.583 41.7463 490.854 46.8304 490.854 52.816H492.172C492.172 46.6416 490.859 41.3137 488.203 36.8604L487.071 37.5356ZM490.854 52.816V54.64H492.172V52.816H490.854ZM490.854 54.64C490.854 60.6256 489.583 65.7097 487.071 69.9204L488.203 70.5956C490.859 66.1423 492.172 60.8144 492.172 54.64H490.854ZM487.071 69.9204C484.55 74.1459 481.109 77.3652 476.736 79.5886L477.333 80.7634C481.929 78.4268 485.555 75.0341 488.203 70.5956L487.071 69.9204ZM476.736 79.5886C472.355 81.8163 467.405 82.9371 461.873 82.9371V84.2549C467.588 84.2549 472.746 83.0957 477.333 80.7634L476.736 79.5886ZM461.873 71.4869C466.435 71.4869 470.253 70.0257 473.276 67.0821L472.357 66.1379C469.604 68.8183 466.127 70.1691 461.873 70.1691V71.4869ZM473.283 67.0759C476.328 64.0302 477.808 59.7377 477.808 54.298H476.49C476.49 59.4983 475.081 63.4138 472.351 66.1441L473.283 67.0759ZM477.808 54.298V53.158H476.49V54.298H477.808ZM477.808 53.158C477.808 47.7194 476.329 43.4599 473.276 40.4879L472.357 41.4321C475.081 44.0841 476.49 47.9566 476.49 53.158H477.808ZM473.289 40.5003C470.338 37.47 466.513 35.9691 461.873 35.9691V37.2869C466.201 37.2869 469.671 38.674 472.345 41.4197L473.289 40.5003ZM461.873 35.9691C457.305 35.9691 453.485 37.4721 450.463 40.4941L451.395 41.4259C454.149 38.6719 457.624 37.2869 461.873 37.2869V35.9691ZM450.469 40.4879C447.417 43.4599 445.938 47.7194 445.938 53.158H447.256C447.256 47.9566 448.665 44.0841 451.388 41.4321L450.469 40.4879ZM445.938 53.158V54.298H447.256V53.158H445.938ZM445.938 54.298C445.938 59.7377 447.417 64.0302 450.463 67.0759L451.395 66.1441C448.664 63.4138 447.256 59.4983 447.256 54.298H445.938ZM450.469 67.0821C453.492 70.0257 457.311 71.4869 461.873 71.4869V70.1691C457.619 70.1691 454.141 68.8183 451.388 66.1379L450.469 67.0821ZM503.632 82H502.973V82.6589H503.632V82ZM503.632 25.456V24.7971H502.973V25.456H503.632ZM517.768 25.456H518.426V24.7971H517.768V25.456ZM517.768 31.84H517.109V32.4989H517.768V31.84ZM519.82 31.84V32.4989H520.28L520.438 32.0668L519.82 31.84ZM523.923 26.824L523.611 26.2437L523.602 26.2491L523.923 26.824ZM537.604 25.228H538.262V24.5691H537.604V25.228ZM537.604 37.996V38.6549H538.262V37.996H537.604ZM521.529 40.96L521.943 41.473L521.953 41.4649L521.529 40.96ZM517.995 82V82.6589H518.654V82H517.995ZM504.29 82V25.456H502.973V82H504.29ZM503.632 26.1149H517.768V24.7971H503.632V26.1149ZM517.109 25.456V31.84H518.426V25.456H517.109ZM517.768 32.4989H519.82V31.1811H517.768V32.4989ZM520.438 32.0668C521.227 29.9164 522.499 28.3771 524.245 27.3989L523.602 26.2491C521.548 27.3989 520.084 29.2036 519.201 31.6132L520.438 32.0668ZM524.236 27.4042C526.102 26.3992 528.272 25.8869 530.763 25.8869V24.5691C528.087 24.5691 525.697 25.1208 523.611 26.2438L524.236 27.4042ZM530.763 25.8869H537.604V24.5691H530.763V25.8869ZM536.945 25.228V37.996H538.262V25.228H536.945ZM537.604 37.3371H530.536V38.6549H537.604V37.3371ZM530.536 37.3371C526.763 37.3371 523.602 38.3618 521.106 40.4551L521.953 41.4649C524.169 39.6062 527.012 38.6549 530.536 38.6549V37.3371ZM521.116 40.4471C518.557 42.5106 517.337 45.6954 517.337 49.852H518.654C518.654 45.9526 519.79 43.2094 521.943 41.4729L521.116 40.4471ZM517.337 49.852V82H518.654V49.852H517.337ZM517.995 81.3411H503.632V82.6589H517.995V81.3411ZM560.231 78.58L559.757 79.0382L559.765 79.046L559.772 79.0535L560.231 78.58ZM556.811 37.312H557.47V36.6531H556.811V37.312ZM542.675 37.312H542.016V37.9709H542.675V37.312ZM542.675 25.456V24.7971H542.016V25.456H542.675ZM556.811 25.456V26.1149H557.47V25.456H556.811ZM556.811 7.9V7.24106H556.152V7.9H556.811ZM571.175 7.9H571.834V7.24106H571.175V7.9ZM571.175 25.456H570.516V26.1149H571.175V25.456ZM586.679 25.456H587.338V24.7971H586.679V25.456ZM586.679 37.312V37.9709H587.338V37.312H586.679ZM571.175 37.312V36.6531H570.516V37.312H571.175ZM585.311 70.144H585.97V69.4851H585.311V70.144ZM585.311 82V82.6589H585.97V82H585.311ZM569.351 81.3411C565.773 81.3411 562.905 80.2511 560.689 78.1065L559.772 79.0535C562.268 81.4689 565.481 82.6589 569.351 82.6589V81.3411ZM560.704 78.1218C558.564 75.9107 557.47 72.9703 557.47 69.232H556.152C556.152 73.2457 557.337 76.5373 559.757 79.0382L560.704 78.1218ZM557.47 69.232V37.312H556.152V69.232H557.47ZM556.811 36.6531H542.675V37.9709H556.811V36.6531ZM543.334 37.312V25.456H542.016V37.312H543.334ZM542.675 26.1149H556.811V24.7971H542.675V26.1149ZM557.47 25.456V7.9H556.152V25.456H557.47ZM556.811 8.55894H571.175V7.24106H556.811V8.55894ZM570.516 7.9V25.456H571.834V7.9H570.516ZM571.175 26.1149H586.679V24.7971H571.175V26.1149ZM586.02 25.456V37.312H587.338V25.456H586.02ZM586.679 36.6531H571.175V37.9709H586.679V36.6531ZM570.516 37.312V66.724H571.834V37.312H570.516ZM570.516 66.724C570.516 67.9547 570.802 69.0004 571.491 69.7386C572.188 70.4854 573.189 70.8029 574.367 70.8029V69.4851C573.416 69.4851 572.821 69.2327 572.454 68.8394C572.079 68.4376 571.834 67.7733 571.834 66.724H570.516ZM574.367 70.8029H585.311V69.4851H574.367V70.8029ZM584.652 70.144V82H585.97V70.144H584.652ZM585.311 81.3411H569.351V82.6589H585.311V81.3411ZM598.541 82H597.882V82.6589H598.541V82ZM598.541 2.19999V1.54105H597.882V2.19999H598.541ZM612.905 2.19999H613.564V1.54105H612.905V2.19999ZM612.905 82V82.6589H613.564V82H612.905ZM599.2 82V2.19999H597.882V82H599.2ZM598.541 2.85893H612.905V1.54105H598.541V2.85893ZM612.246 2.19999V82H613.564V2.19999H612.246ZM612.905 81.3411H598.541V82.6589H612.905V81.3411ZM633.838 104.8H633.179V105.459H633.838V104.8ZM633.838 92.26V91.6011H633.179V92.26H633.838ZM667.81 74.59H668.469V73.9311H667.81V74.59ZM665.758 74.59V73.9311H665.34L665.162 74.3094L665.758 74.59ZM662.908 78.466L662.442 78.0001L662.908 78.466ZM657.664 81.658L657.431 81.0419L657.664 81.658ZM637.6 79.948L637.25 80.5061L637.257 80.5108L637.265 80.5153L637.6 79.948ZM627.226 25.456V24.7971H626.567V25.456H627.226ZM641.59 25.456H642.249V24.7971H641.59V25.456ZM644.668 67.636L644.194 68.0935L644.202 68.1019L644.668 67.636ZM663.934 66.496L664.438 66.9205L664.444 66.914L663.934 66.496ZM667.582 25.456V24.7971H666.923V25.456H667.582ZM681.946 25.456H682.605V24.7971H681.946V25.456ZM678.526 101.266L678.06 100.8L678.053 100.808L678.526 101.266ZM634.497 104.8V92.26H633.179V104.8H634.497ZM633.838 92.9189H664.618V91.6011H633.838V92.9189ZM664.618 92.9189C665.796 92.9189 666.797 92.6013 667.494 91.8546C668.183 91.1164 668.469 90.0707 668.469 88.84H667.151C667.151 89.8893 666.906 90.5536 666.531 90.9554C666.163 91.3486 665.569 91.6011 664.618 91.6011V92.9189ZM668.469 88.84V74.59H667.151V88.84H668.469ZM667.81 73.9311H665.758V75.2489H667.81V73.9311ZM665.162 74.3094C664.594 75.5164 663.695 76.7475 662.442 78.0001L663.374 78.9319C664.706 77.6005 665.706 76.2476 666.354 74.8706L665.162 74.3094ZM662.442 78.0001C661.232 79.21 659.572 80.2297 657.431 81.0419L657.898 82.2741C660.165 81.4143 662 80.306 663.374 78.9319L662.442 78.0001ZM657.431 81.0419C655.327 81.8399 652.601 82.2531 649.228 82.2531V83.5709C652.695 83.5709 655.594 83.1481 657.898 82.2741L657.431 81.0419ZM649.228 82.2531C644.922 82.2531 641.165 81.289 637.935 79.3807L637.265 80.5153C640.724 82.559 644.719 83.5709 649.228 83.5709V82.2531ZM637.951 79.39C634.787 77.4037 632.321 74.6828 630.549 71.2123L629.375 71.8117C631.251 75.4852 633.877 78.3883 637.25 80.5061L637.951 79.39ZM630.549 71.2123C628.779 67.7466 627.885 63.7481 627.885 59.2H626.567C626.567 63.9239 627.497 68.1334 629.375 71.8117L630.549 71.2123ZM627.885 59.2V25.456H626.567V59.2H627.885ZM627.226 26.1149H641.59V24.7971H627.226V26.1149ZM640.931 25.456V58.06H642.249V25.456H640.931ZM640.931 58.06C640.931 62.4117 641.98 65.7976 644.194 68.0934L645.143 67.1786C643.252 65.2184 642.249 62.2203 642.249 58.06H640.931ZM644.202 68.1019C646.487 70.3863 649.676 71.4869 653.674 71.4869V70.1691C649.92 70.1691 647.106 69.1417 645.134 67.1701L644.202 68.1019ZM653.674 71.4869C658.24 71.4869 661.859 69.9827 664.438 66.9204L663.43 66.0715C661.145 68.7853 657.924 70.1691 653.674 70.1691V71.4869ZM664.444 66.914C667.003 63.7952 668.241 59.5246 668.241 54.184H666.923C666.923 59.3314 665.73 63.2688 663.425 66.078L664.444 66.914ZM668.241 54.184V25.456H666.923V54.184H668.241ZM667.582 26.1149H681.946V24.7971H667.582V26.1149ZM681.287 25.456V92.032H682.605V25.456H681.287ZM681.287 92.032C681.287 95.771 680.192 98.668 678.06 100.8L678.992 101.732C681.42 99.304 682.605 96.045 682.605 92.032H681.287ZM678.053 100.808C675.917 103.015 673.059 104.141 669.406 104.141V105.459C673.354 105.459 676.576 104.229 679 101.724L678.053 100.808ZM669.406 104.141H633.838V105.459H669.406V104.141ZM698.5 55.78H697.841V56.4389H698.5V55.78ZM698.5 2.19999V1.54105H697.841V2.19999H698.5ZM713.092 2.19999H713.751V1.54105H713.092V2.19999ZM713.092 55.78V56.4389H713.751V55.78H713.092ZM698.044 80.632L697.578 81.0979L697.587 81.1066L697.596 81.1149L698.044 80.632ZM698.044 65.014L698.501 65.4886L698.502 65.4883L698.044 65.014ZM713.548 65.014L713.082 65.48L713.091 65.4886L713.548 65.014ZM713.548 80.632L714.005 81.1067L714.014 81.0979L713.548 80.632ZM699.159 55.78V2.19999H697.841V55.78H699.159ZM698.5 2.85893H713.092V1.54105H698.5V2.85893ZM712.433 2.19999V55.78H713.751V2.19999H712.433ZM713.092 55.1211H698.5V56.4389H713.092V55.1211ZM705.796 82.9371C702.914 82.9371 700.493 82.0062 698.493 80.1491L697.596 81.1149C699.852 83.2097 702.599 84.2549 705.796 84.2549V82.9371ZM698.51 80.1661C696.595 78.2506 695.625 75.8024 695.625 72.766H694.307C694.307 76.1136 695.39 78.9094 697.578 81.0979L698.51 80.1661ZM695.625 72.766C695.625 69.7293 696.594 67.3249 698.501 65.4886L697.587 64.5394C695.39 66.6551 694.307 69.4186 694.307 72.766H695.625ZM698.502 65.4883C700.503 63.5584 702.921 62.5949 705.796 62.5949V61.2771C702.591 61.2771 699.841 62.3656 697.587 64.5397L698.502 65.4883ZM705.796 62.5949C708.752 62.5949 711.164 63.5612 713.082 65.4799L714.014 64.5481C711.829 62.3628 709.073 61.2771 705.796 61.2771V62.5949ZM713.091 65.4886C714.998 67.3249 715.967 69.7293 715.967 72.766H717.285C717.285 69.4186 716.202 66.6551 714.005 64.5394L713.091 65.4886ZM715.967 72.766C715.967 75.8024 714.998 78.2506 713.082 80.1661L714.014 81.0979C716.203 78.9094 717.285 76.1136 717.285 72.766H715.967ZM713.091 80.1573C711.174 82.0035 708.759 82.9371 705.796 82.9371V84.2549C709.065 84.2549 711.818 83.2125 714.005 81.1067L713.091 80.1573Z"
          fill={theme.palette.background.default}
          mask="url(#path-1-outside-1_9619_900)"
        />
      </g>
      <defs>
        <filter
          id="filter0_d_9619_900"
          x="0.244141"
          y="0.604004"
          width="721.383"
          height="109.196"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
          <feOffset dx="5" dy="5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0 0.564706 0 0 0 0.36 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_9619_900" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_9619_900" result="shape" />
        </filter>
      </defs>
    </svg>
  );
}
