'use client';
import PropTypes from 'prop-types';

import { useId } from 'react';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - REDDIT  ***************************/

export default function Reddit({ imageSize }) {
  const theme = useTheme();
  const uniqueId = useId(); // Generate a unique ID

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 89, sm: 105, md: 110 }, height: imageSize?.height || { xs: 16, sm: 18, md: 26 } }
      }}
    >
      <svg viewBox="0 0 110 26" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath={`url(#${uniqueId})`}>
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M23.627 13.126C23.627 19.4773 18.4782 24.626 12.127 24.626C5.77568 24.626 0.626953 19.4773 0.626953 13.126C0.626953 6.7747 5.77568 1.62598 12.127 1.62598C18.4782 1.62598 23.627 6.7747 23.627 13.126ZM18.0549 11.508C18.9838 11.4765 19.7615 12.1997 19.7957 13.1259C19.8072 13.7719 19.4441 14.3666 18.8665 14.6554C18.878 14.824 18.878 14.9927 18.8665 15.1614C18.8665 17.7397 15.865 19.8322 12.1633 19.8322C8.46157 19.8322 5.46007 17.7369 5.46007 15.1614C5.44857 14.9927 5.44857 14.824 5.46007 14.6554C5.29141 14.581 5.14012 14.4752 5.00851 14.3523C4.33103 13.7177 4.2996 12.6544 4.93414 11.9797C5.56868 11.3022 6.63205 11.2708 7.30672 11.9053C8.63305 11.0078 10.1909 10.5161 11.7917 10.4903L12.6407 6.49984V6.49422C12.6836 6.29974 12.8753 6.17963 13.0667 6.22256L15.8852 6.7858C16.0651 6.47122 16.391 6.25962 16.7541 6.22256C17.3858 6.15382 17.9516 6.61126 18.0204 7.24299C18.0891 7.87473 17.6317 8.44078 16.9999 8.50927C16.3682 8.57802 15.8022 8.12057 15.7337 7.48884L13.2724 6.97134L12.5264 10.5588C14.1073 10.5931 15.6452 11.0819 16.9545 11.9738C17.2517 11.6909 17.6432 11.5223 18.0549 11.508ZM9.44776 13.1259C8.81322 13.1259 8.29572 13.6434 8.29572 14.2779C8.29572 14.9125 8.81041 15.4241 9.44776 15.43C10.0823 15.43 10.5998 14.9125 10.5998 14.2779C10.5998 13.6434 10.0823 13.1259 9.44776 13.1259ZM14.9762 17.4394V17.4851C15.1019 17.3622 15.1047 17.1565 14.9818 17.0308C14.8586 16.905 14.6529 16.9022 14.5272 17.0251C13.827 17.5253 12.9808 17.7711 12.1232 17.7254C11.2658 17.7655 10.4225 17.5081 9.73066 17.0021C9.61336 16.9078 9.45032 16.9078 9.33609 17.0021C9.20447 17.1108 9.18454 17.3078 9.29315 17.4394C10.1109 18.054 11.1112 18.3686 12.1347 18.3257C13.1582 18.3683 14.1587 18.054 14.9762 17.4394ZM14.7618 15.5128H14.819C15.4536 15.487 15.9481 14.9526 15.9225 14.3178C15.9225 13.6832 15.405 13.1657 14.7705 13.1657C14.1359 13.1657 13.6184 13.6832 13.6184 14.3178C13.6184 14.9523 14.1359 15.4698 14.7705 15.4698L14.7618 15.5128Z"
            fill={theme.palette.primary.main}
          />
        </g>
        <path
          d="M36.0584 20.5V4.21788H42.1526C43.4552 4.21788 44.5329 4.44273 45.3858 4.89242C46.2541 5.34212 46.8977 5.94688 47.3164 6.70672C47.735 7.45104 47.9444 8.28065 47.9444 9.19555C47.9444 10.0639 47.735 10.878 47.3164 11.6379C46.9132 12.3822 46.2774 12.987 45.409 13.4522C44.5561 13.9019 43.4552 14.1267 42.1061 14.1267H39.1986V20.5H36.0584ZM44.5019 20.5L41.1524 13.3359H44.5484L48.0839 20.5H44.5019ZM39.1986 11.8472H41.9665C42.9124 11.8472 43.6102 11.6146 44.0599 11.1494C44.5096 10.6842 44.7345 10.0717 44.7345 9.31186C44.7345 8.55202 44.5096 7.95501 44.0599 7.52082C43.6257 7.07113 42.9202 6.84628 41.9433 6.84628H39.1986V11.8472ZM55.5657 20.7791C54.3872 20.7791 53.3405 20.531 52.4256 20.0348C51.5262 19.5386 50.8206 18.8408 50.3089 17.9414C49.7972 17.042 49.5413 16.003 49.5413 14.8245C49.5413 13.6305 49.7894 12.5683 50.2857 11.6379C50.7974 10.7075 51.5029 9.97865 52.4023 9.45142C53.3172 8.92419 54.3795 8.66057 55.589 8.66057C56.7365 8.66057 57.7444 8.91643 58.6128 9.42816C59.4967 9.92437 60.179 10.5989 60.6597 11.4518C61.1559 12.3047 61.404 13.2816 61.404 14.3826C61.404 14.5376 61.404 14.7082 61.404 14.8943C61.404 15.0804 61.3885 15.282 61.3575 15.4991H51.7976V13.5685H58.2174C58.1709 12.8552 57.8995 12.2892 57.4033 11.8705C56.9226 11.4363 56.3178 11.2192 55.589 11.2192C55.0462 11.2192 54.55 11.3432 54.1003 11.5914C53.6506 11.824 53.294 12.1806 53.0304 12.6613C52.7667 13.142 52.6349 13.7468 52.6349 14.4756V15.1502C52.6349 15.7704 52.759 16.3132 53.0071 16.7784C53.2552 17.2281 53.5964 17.5847 54.0306 17.8483C54.4802 18.0964 54.9842 18.2205 55.5425 18.2205C56.1162 18.2205 56.5969 18.0964 56.9846 17.8483C57.3723 17.5847 57.6669 17.2513 57.8685 16.8482H61.0784C60.8458 17.577 60.4736 18.2438 59.9619 18.8485C59.4502 19.4378 58.8221 19.9107 58.0778 20.2674C57.3335 20.6085 56.4961 20.7791 55.5657 20.7791ZM69.2093 20.7791C68.1238 20.7791 67.1546 20.5155 66.3017 19.9883C65.4489 19.461 64.7743 18.74 64.2781 17.8251C63.7819 16.8947 63.5338 15.8557 63.5338 14.7082C63.5338 13.5452 63.7819 12.514 64.2781 11.6146C64.7743 10.6997 65.4489 9.97865 66.3017 9.45142C67.1701 8.92419 68.1393 8.66057 69.2093 8.66057C70.0621 8.66057 70.8065 8.82339 71.4422 9.14903C72.0935 9.45917 72.613 9.90111 73.0007 10.4749V3.75267H76.1408V20.5H73.3496L73.0007 18.895C72.7526 19.2362 72.4579 19.5541 72.1168 19.8487C71.7756 20.1278 71.3647 20.3527 70.884 20.5233C70.4033 20.6938 69.845 20.7791 69.2093 20.7791ZM69.9071 18.0344C70.5273 18.0344 71.0778 17.8949 71.5585 17.6157C72.0393 17.3211 72.4114 16.9257 72.675 16.4295C72.9386 15.9333 73.0705 15.3673 73.0705 14.7315C73.0705 14.0802 72.9386 13.5064 72.675 13.0102C72.4114 12.4985 72.0393 12.1031 71.5585 11.824C71.0778 11.5448 70.5273 11.4053 69.9071 11.4053C69.3023 11.4053 68.7596 11.5526 68.2789 11.8472C67.7981 12.1263 67.4182 12.514 67.1391 13.0102C66.8755 13.5064 66.7437 14.0724 66.7437 14.7082C66.7437 15.3595 66.8755 15.9333 67.1391 16.4295C67.4027 16.9257 67.7749 17.3211 68.2556 17.6157C68.7518 17.8949 69.3023 18.0344 69.9071 18.0344ZM84.4738 20.7791C83.3883 20.7791 82.4191 20.5155 81.5662 19.9883C80.7134 19.461 80.0388 18.74 79.5426 17.8251C79.0464 16.8947 78.7983 15.8557 78.7983 14.7082C78.7983 13.5452 79.0464 12.514 79.5426 11.6146C80.0388 10.6997 80.7134 9.97865 81.5662 9.45142C82.4346 8.92419 83.4038 8.66057 84.4738 8.66057C85.3266 8.66057 86.071 8.82339 86.7067 9.14903C87.358 9.45917 87.8775 9.90111 88.2652 10.4749V3.75267H91.4053V20.5H88.6141L88.2652 18.895C88.0171 19.2362 87.7224 19.5541 87.3813 19.8487C87.0401 20.1278 86.6292 20.3527 86.1485 20.5233C85.6678 20.6938 85.1095 20.7791 84.4738 20.7791ZM85.1716 18.0344C85.7918 18.0344 86.3423 17.8949 86.823 17.6157C87.3037 17.3211 87.6759 16.9257 87.9395 16.4295C88.2031 15.9333 88.3349 15.3673 88.3349 14.7315C88.3349 14.0802 88.2031 13.5064 87.9395 13.0102C87.6759 12.4985 87.3037 12.1031 86.823 11.824C86.3423 11.5448 85.7918 11.4053 85.1716 11.4053C84.5668 11.4053 84.0241 11.5526 83.5433 11.8472C83.0626 12.1263 82.6827 12.514 82.4036 13.0102C82.14 13.5064 82.0082 14.0724 82.0082 14.7082C82.0082 15.3595 82.14 15.9333 82.4036 16.4295C82.6672 16.9257 83.0394 17.3211 83.5201 17.6157C84.0163 17.8949 84.5668 18.0344 85.1716 18.0344ZM94.528 20.5V8.93969H97.6681V20.5H94.528ZM96.0864 7.28822C95.5282 7.28822 95.063 7.11765 94.6908 6.7765C94.3341 6.43535 94.1558 6.01666 94.1558 5.52045C94.1558 4.99322 94.3341 4.56678 94.6908 4.24114C95.063 3.9155 95.5282 3.75267 96.0864 3.75267C96.6602 3.75267 97.1254 3.9155 97.482 4.24114C97.8542 4.56678 98.0403 4.99322 98.0403 5.52045C98.0403 6.01666 97.8542 6.43535 97.482 6.7765C97.1254 7.11765 96.6602 7.28822 96.0864 7.28822ZM106.006 20.5C105.184 20.5 104.463 20.3759 103.843 20.1278C103.238 19.8642 102.765 19.4378 102.424 18.8485C102.083 18.2438 101.912 17.4219 101.912 16.3829V11.5681H99.9351V8.93969H101.912L102.261 5.79957H105.052V8.93969H108.123V11.5681H105.052V16.4295C105.052 16.9567 105.169 17.3211 105.401 17.5227C105.634 17.7243 106.029 17.8251 106.587 17.8251H108.053V20.5H106.006Z"
          fill={theme.palette.primary.main}
        />
        <defs>
          <clipPath id={uniqueId}>
            <rect width="24" height="24" fill={theme.palette.primary.main} transform="translate(0.5 1)" />
          </clipPath>
        </defs>
      </svg>
    </Box>
  );
}

Reddit.propTypes = { imageSize: PropTypes.object };
