'use client';
import PropTypes from 'prop-types';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - REALTOR  ***************************/

export default function Realtor({ imageSize }) {
  const theme = useTheme();

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 74, sm: 88, md: 116 }, height: imageSize?.height || { xs: 18, sm: 21, md: 28 } }
      }}
    >
      <svg viewBox="0 0 115 27" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M36.4411 20V3.71788H42.4189C43.7215 3.71788 44.7915 3.94273 45.6288 4.39242C46.4817 4.82661 47.1175 5.42362 47.5362 6.18346C47.9549 6.92778 48.1642 7.75739 48.1642 8.67229C48.1642 9.66473 47.9006 10.5719 47.3733 11.3937C46.8616 12.2156 46.0553 12.8126 44.9543 13.1848L48.327 20H44.9078L41.8839 13.5802H39.4184V20H36.4411ZM39.4184 11.3937H42.2329C43.2253 11.3937 43.9541 11.1534 44.4193 10.6727C44.8845 10.192 45.1171 9.55618 45.1171 8.76534C45.1171 7.99 44.8845 7.36972 44.4193 6.90452C43.9696 6.43932 43.233 6.20672 42.2096 6.20672H39.4184V11.3937ZM55.765 20.2791C54.602 20.2791 53.5708 20.031 52.6714 19.5348C51.772 19.0386 51.0664 18.3408 50.5547 17.4414C50.043 16.542 49.7871 15.503 49.7871 14.3245C49.7871 13.1305 50.0352 12.0683 50.5315 11.1379C51.0432 10.2075 51.741 9.4864 52.6249 8.97468C53.5243 8.44745 54.5787 8.18383 55.7883 8.18383C56.9203 8.18383 57.9204 8.43194 58.7888 8.92816C59.6572 9.42437 60.3317 10.1067 60.8125 10.9751C61.3087 11.8279 61.5568 12.7816 61.5568 13.8361C61.5568 14.0066 61.549 14.185 61.5335 14.371C61.5335 14.5571 61.5258 14.751 61.5103 14.9525H52.7412C52.8032 15.8519 53.1133 16.5575 53.6716 17.0692C54.2453 17.5809 54.9354 17.8368 55.7417 17.8368C56.3465 17.8368 56.8505 17.705 57.2537 17.4414C57.6723 17.1623 57.9825 16.8056 58.1841 16.3714H61.2079C60.9908 17.1002 60.6264 17.767 60.1147 18.3718C59.6184 18.961 58.9982 19.4262 58.2538 19.7674C57.525 20.1085 56.6954 20.2791 55.765 20.2791ZM55.7883 10.6029C55.0594 10.6029 54.4159 10.8122 53.8577 11.2309C53.2994 11.6341 52.9428 12.2544 52.7877 13.0917H58.533C58.4864 12.3319 58.2073 11.7271 57.6956 11.2774C57.1839 10.8277 56.5481 10.6029 55.7883 10.6029ZM68.0384 20.2791C67.0459 20.2791 66.2318 20.1241 65.5961 19.8139C64.9603 19.4883 64.4873 19.0618 64.1772 18.5346C63.8671 18.0074 63.712 17.4259 63.712 16.7901C63.712 15.7201 64.1307 14.8517 64.968 14.185C65.8054 13.5182 67.0615 13.1848 68.7362 13.1848H71.667V12.9056C71.667 12.1148 71.4421 11.5333 70.9924 11.1611C70.5427 10.789 69.9845 10.6029 69.3177 10.6029C68.7129 10.6029 68.1857 10.7502 67.736 11.0448C67.2863 11.324 67.0072 11.7426 66.8986 12.3009H63.9911C64.0686 11.4635 64.3478 10.7347 64.8285 10.1144C65.3247 9.49415 65.9605 9.0212 66.7358 8.69555C67.5111 8.35441 68.3795 8.18383 69.3409 8.18383C70.9847 8.18383 72.2795 8.59476 73.2254 9.41662C74.1713 10.2385 74.6443 11.4015 74.6443 12.9056V20H72.1089L71.8298 18.1392C71.4886 18.7595 71.0079 19.2712 70.3877 19.6744C69.7829 20.0775 68.9998 20.2791 68.0384 20.2791ZM68.7129 17.9531C69.5658 17.9531 70.2248 17.674 70.69 17.1157C71.1707 16.5575 71.4731 15.8674 71.5972 15.0456H69.0618C68.271 15.0456 67.705 15.1929 67.3638 15.4875C67.0227 15.7666 66.8521 16.1156 66.8521 16.5342C66.8521 16.9839 67.0227 17.3328 67.3638 17.5809C67.705 17.8291 68.1547 17.9531 68.7129 17.9531ZM77.4855 20V3.25267H80.4628V20H77.4855ZM88.6454 20C87.4359 20 86.4667 19.7054 85.7379 19.1161C85.0091 18.5269 84.6447 17.4801 84.6447 15.976V10.9518H82.6676V8.46295H84.6447L84.9936 5.36935H87.622V8.46295H90.7389V10.9518H87.622V15.9992C87.622 16.5575 87.7383 16.9452 87.9709 17.1623C88.219 17.3638 88.6377 17.4646 89.2269 17.4646H90.6691V20H88.6454ZM98.5357 20.2791C97.4192 20.2791 96.4113 20.0233 95.5119 19.5115C94.628 18.9998 93.9225 18.2943 93.3952 17.3949C92.8835 16.48 92.6277 15.4255 92.6277 14.2315C92.6277 13.0375 92.8913 11.9907 93.4185 11.0914C93.9457 10.1765 94.6513 9.46314 95.5352 8.95142C96.4346 8.43969 97.4425 8.18383 98.559 8.18383C99.66 8.18383 100.652 8.43969 101.536 8.95142C102.436 9.46314 103.141 10.1765 103.653 11.0914C104.18 11.9907 104.444 13.0375 104.444 14.2315C104.444 15.4255 104.18 16.48 103.653 17.3949C103.141 18.2943 102.436 18.9998 101.536 19.5115C100.637 20.0233 99.6367 20.2791 98.5357 20.2791ZM98.5357 17.6972C99.3111 17.6972 99.9856 17.4104 100.559 16.8366C101.133 16.2474 101.42 15.379 101.42 14.2315C101.42 13.084 101.133 12.2233 100.559 11.6496C99.9856 11.0603 99.3188 10.7657 98.559 10.7657C97.7682 10.7657 97.0859 11.0603 96.5121 11.6496C95.9539 12.2233 95.6747 13.084 95.6747 14.2315C95.6747 15.379 95.9539 16.2474 96.5121 16.8366C97.0859 17.4104 97.7604 17.6972 98.5357 17.6972ZM107.106 20V8.46295H109.757L110.037 10.6261C110.455 9.88182 111.021 9.29257 111.735 8.85838C112.463 8.40868 113.316 8.18383 114.293 8.18383V11.324H113.456C112.805 11.324 112.223 11.4247 111.711 11.6263C111.2 11.8279 110.796 12.1768 110.502 12.673C110.223 13.1693 110.083 13.8593 110.083 14.7432V20H107.106Z"
          fill={theme.palette.primary.main}
        />
        <path
          d="M0.929688 1.80261C0.929688 1.0832 1.51288 0.5 2.23229 0.5H6.62708C7.34649 0.5 7.92969 1.0832 7.92969 1.80261V15.5H0.929688V1.80261Z"
          fill={theme.palette.secondary.lighter}
        />
        <path
          d="M1.2219 26.3364H23.6777C24.0839 26.3364 24.4132 26.0071 24.4132 25.6008V12.2911C24.4132 12.0734 24.3169 11.867 24.1501 11.7272L12.9222 2.31965C12.6489 2.09065 12.2507 2.09065 11.9774 2.31965L0.749488 11.7272C0.582685 11.867 0.486328 12.0734 0.486328 12.2911V25.6008C0.486328 26.0071 0.815656 26.3364 1.2219 26.3364Z"
          fill={theme.palette.primary.main}
        />
      </svg>
    </Box>
  );
}

Realtor.propTypes = { imageSize: PropTypes.object };
