'use client';
import PropTypes from 'prop-types';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - MARKETLY  ***************************/

export default function Marketly({ imageSize }) {
  const theme = useTheme();

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 80, sm: 102, md: 131 }, height: imageSize?.height || { xs: 15, sm: 20, md: 26 } }
      }}
    >
      <svg viewBox="0 0 132 26" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M34.068 20V3.71788H37.6036L42.7906 14.0454L47.9078 3.71788H51.4434V20H48.4661V8.76534L43.9303 17.674H41.5811L37.0453 8.76534V20H34.068ZM58.5101 20.2791C57.5177 20.2791 56.7036 20.1241 56.0678 19.8139C55.432 19.4883 54.959 19.0618 54.6489 18.5346C54.3388 18.0074 54.1837 17.4259 54.1837 16.7901C54.1837 15.7201 54.6024 14.8517 55.4398 14.185C56.2771 13.5182 57.5332 13.1848 59.2079 13.1848H62.1387V12.9056C62.1387 12.1148 61.9138 11.5333 61.4641 11.1611C61.0144 10.789 60.4562 10.6029 59.7894 10.6029C59.1846 10.6029 58.6574 10.7502 58.2077 11.0448C57.758 11.324 57.4789 11.7426 57.3704 12.3009H54.4628C54.5404 11.4635 54.8195 10.7347 55.3002 10.1144C55.7964 9.49415 56.4322 9.0212 57.2075 8.69555C57.9829 8.35441 58.8513 8.18383 59.8127 8.18383C61.4564 8.18383 62.7512 8.59476 63.6971 9.41662C64.643 10.2385 65.116 11.4015 65.116 12.9056V20H62.5806L62.3015 18.1392C61.9604 18.7595 61.4797 19.2712 60.8594 19.6744C60.2546 20.0775 59.4715 20.2791 58.5101 20.2791ZM59.1846 17.9531C60.0375 17.9531 60.6966 17.674 61.1618 17.1157C61.6425 16.5575 61.9449 15.8674 62.0689 15.0456H59.5335C58.7427 15.0456 58.1767 15.1929 57.8356 15.4875C57.4944 15.7666 57.3238 16.1156 57.3238 16.5342C57.3238 16.9839 57.4944 17.3328 57.8356 17.5809C58.1767 17.8291 58.6264 17.9531 59.1846 17.9531ZM67.9572 20V8.46295H70.6088L70.888 10.6261C71.3067 9.88182 71.8726 9.29257 72.586 8.85838C73.3148 8.40868 74.1677 8.18383 75.1446 8.18383V11.324H74.3072C73.6559 11.324 73.0744 11.4247 72.5627 11.6263C72.051 11.8279 71.6478 12.1768 71.3532 12.673C71.074 13.1693 70.9345 13.8593 70.9345 14.7432V20H67.9572ZM77.1795 20V3.25267H80.1568V13.1382L84.2506 8.46295H87.7861L83.0643 13.7198L88.5537 20H84.8321L80.1568 14.2082V20H77.1795ZM95.0513 20.2791C93.8883 20.2791 92.8571 20.031 91.9577 19.5348C91.0583 19.0386 90.3527 18.3408 89.841 17.4414C89.3293 16.542 89.0734 15.503 89.0734 14.3245C89.0734 13.1305 89.3215 12.0683 89.8178 11.1379C90.3295 10.2075 91.0273 9.4864 91.9112 8.97468C92.8106 8.44745 93.865 8.18383 95.0746 8.18383C96.2065 8.18383 97.2067 8.43194 98.0751 8.92816C98.9435 9.42437 99.618 10.1067 100.099 10.9751C100.595 11.8279 100.843 12.7816 100.843 13.8361C100.843 14.0066 100.835 14.185 100.82 14.371C100.82 14.5571 100.812 14.751 100.797 14.9525H92.0275C92.0895 15.8519 92.3996 16.5575 92.9579 17.0692C93.5316 17.5809 94.2217 17.8368 95.028 17.8368C95.6328 17.8368 96.1368 17.705 96.5399 17.4414C96.9586 17.1623 97.2688 16.8056 97.4703 16.3714H100.494C100.277 17.1002 99.9127 17.767 99.4009 18.3718C98.9047 18.961 98.2845 19.4262 97.5401 19.7674C96.8113 20.1085 95.9817 20.2791 95.0513 20.2791ZM95.0746 10.6029C94.3457 10.6029 93.7022 10.8122 93.144 11.2309C92.5857 11.6341 92.2291 12.2544 92.074 13.0917H97.8193C97.7727 12.3319 97.4936 11.7271 96.9819 11.2774C96.4702 10.8277 95.8344 10.6029 95.0746 10.6029ZM108.283 20C107.074 20 106.105 19.7054 105.376 19.1161C104.647 18.5269 104.282 17.4801 104.282 15.976V10.9518H102.305V8.46295H104.282L104.631 5.36935H107.26V8.46295H110.377V10.9518H107.26V15.9992C107.26 16.5575 107.376 16.9452 107.609 17.1623C107.857 17.3638 108.275 17.4646 108.865 17.4646H110.307V20H108.283ZM112.933 20V3.25267H115.91V20H112.933ZM120.395 25.1172L123.069 19.2324H122.372L117.882 8.46295H121.116L124.349 16.5808L127.721 8.46295H130.885L123.558 25.1172H120.395Z"
          fill={theme.palette.primary.main}
        />
        <rect x="0.845703" y="14.8545" width="5.91373" height="9.19306" rx="2.95687" fill={theme.palette.primary.main} />
        <rect x="0.845703" y="0.783203" width="5.91373" height="5.91373" rx="2.95687" fill={theme.palette.primary.main} />
        <rect x="9.44922" y="7.62695" width="5.91373" height="16.4206" rx="2.95687" fill={theme.palette.primary.main} />
        <rect x="18.0547" y="0.783203" width="5.91373" height="23.2642" rx="2.95687" fill={theme.palette.secondary.lighter} />
      </svg>
    </Box>
  );
}

Marketly.propTypes = { imageSize: PropTypes.object };
