'use client';
import PropTypes from 'prop-types';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - FINANCELY  ***************************/

export default function Financely({ imageSize }) {
  const theme = useTheme();

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 89, sm: 105, md: 147 }, height: imageSize?.height || { xs: 16, sm: 18, md: 26 } }
      }}
    >
      <svg viewBox="0 0 146 26" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M38.4274 20.3887V4.10655H48.941V6.50235H41.4047V11.0613H47.4989V13.4106H41.4047V20.3887H38.4274ZM52.7738 7.06059C52.2311 7.06059 51.7814 6.89777 51.4247 6.57213C51.0836 6.24649 50.913 5.83556 50.913 5.33934C50.913 4.84312 51.0836 4.43995 51.4247 4.12981C51.7814 3.80417 52.2311 3.64135 52.7738 3.64135C53.3166 3.64135 53.7585 3.80417 54.0997 4.12981C54.4563 4.43995 54.6346 4.84312 54.6346 5.33934C54.6346 5.83556 54.4563 6.24649 54.0997 6.57213C53.7585 6.89777 53.3166 7.06059 52.7738 7.06059ZM51.2852 20.3887V8.85163H54.2625V20.3887H51.2852ZM57.3701 20.3887V8.85163H59.9985L60.2311 10.8055C60.5877 10.1232 61.0995 9.58044 61.7663 9.17727C62.4486 8.77409 63.2472 8.5725 64.1621 8.5725C65.5887 8.5725 66.6974 9.0222 67.4883 9.92159C68.2791 10.821 68.6745 12.1391 68.6745 13.8758V20.3887H65.6972V14.1549C65.6972 13.1625 65.4956 12.4027 65.0925 11.8754C64.6893 11.3482 64.0613 11.0846 63.2084 11.0846C62.371 11.0846 61.681 11.3792 61.1382 11.9685C60.611 12.5577 60.3474 13.3796 60.3474 14.4341V20.3887H57.3701ZM75.499 20.6678C74.5066 20.6678 73.6925 20.5127 73.0567 20.2026C72.4209 19.8769 71.948 19.4505 71.6378 18.9233C71.3277 18.3961 71.1726 17.8145 71.1726 17.1788C71.1726 16.1088 71.5913 15.2404 72.4287 14.5736C73.266 13.9068 74.5221 13.5734 76.1968 13.5734H79.1276V13.2943C79.1276 12.5035 78.9028 11.922 78.4531 11.5498C78.0034 11.1776 77.4451 10.9916 76.7783 10.9916C76.1736 10.9916 75.6463 11.1389 75.1966 11.4335C74.7469 11.7126 74.4678 12.1313 74.3593 12.6896H71.4518C71.5293 11.8522 71.8084 11.1234 72.2891 10.5031C72.7853 9.88283 73.4211 9.40987 74.1965 9.08423C74.9718 8.74308 75.8402 8.5725 76.8016 8.5725C78.4453 8.5725 79.7401 8.98343 80.686 9.80529C81.632 10.6272 82.1049 11.7902 82.1049 13.2943V20.3887H79.5696L79.2904 18.5279C78.9493 19.1481 78.4686 19.6599 77.8483 20.063C77.2435 20.4662 76.4604 20.6678 75.499 20.6678ZM76.1736 18.3418C77.0264 18.3418 77.6855 18.0627 78.1507 17.5044C78.6314 16.9462 78.9338 16.2561 79.0578 15.4343H76.5225C75.7316 15.4343 75.1656 15.5816 74.8245 15.8762C74.4833 16.1553 74.3128 16.5042 74.3128 16.9229C74.3128 17.3726 74.4833 17.7215 74.8245 17.9696C75.1656 18.2177 75.6153 18.3418 76.1736 18.3418ZM84.9461 20.3887V8.85163H87.5745L87.8071 10.8055C88.1638 10.1232 88.6755 9.58044 89.3423 9.17727C90.0246 8.77409 90.8232 8.5725 91.7381 8.5725C93.1647 8.5725 94.2734 9.0222 95.0643 9.92159C95.8551 10.821 96.2506 12.1391 96.2506 13.8758V20.3887H93.2733V14.1549C93.2733 13.1625 93.0717 12.4027 92.6685 11.8754C92.2653 11.3482 91.6373 11.0846 90.7844 11.0846C89.947 11.0846 89.257 11.3792 88.7143 11.9685C88.187 12.5577 87.9234 13.3796 87.9234 14.4341V20.3887H84.9461ZM104.75 20.6678C103.571 20.6678 102.532 20.4119 101.633 19.9002C100.734 19.3885 100.02 18.6752 99.493 17.7603C98.9813 16.8454 98.7254 15.7987 98.7254 14.6201C98.7254 13.4416 98.9813 12.3949 99.493 11.48C100.02 10.5651 100.734 9.85181 101.633 9.34009C102.532 8.82837 103.571 8.5725 104.75 8.5725C106.223 8.5725 107.463 8.96017 108.471 9.73551C109.479 10.4953 110.123 11.5498 110.402 12.8989H107.262C107.107 12.3407 106.797 11.9065 106.331 11.5963C105.882 11.2707 105.347 11.1079 104.727 11.1079C103.905 11.1079 103.207 11.418 102.633 12.0383C102.059 12.6585 101.772 13.5192 101.772 14.6201C101.772 15.7211 102.059 16.5818 102.633 17.202C103.207 17.8223 103.905 18.1324 104.727 18.1324C105.347 18.1324 105.882 17.9774 106.331 17.6672C106.797 17.3571 107.107 16.9152 107.262 16.3414H110.402C110.123 17.644 109.479 18.6907 108.471 19.4815C107.463 20.2724 106.223 20.6678 104.75 20.6678ZM118.65 20.6678C117.487 20.6678 116.456 20.4197 115.557 19.9235C114.657 19.4273 113.952 18.7294 113.44 17.8301C112.928 16.9307 112.672 15.8917 112.672 14.7132C112.672 13.5192 112.921 12.457 113.417 11.5265C113.928 10.5961 114.626 9.87507 115.51 9.36335C116.41 8.83612 117.464 8.5725 118.674 8.5725C119.806 8.5725 120.806 8.82061 121.674 9.31683C122.542 9.81305 123.217 10.4953 123.698 11.3637C124.194 12.2166 124.442 13.1703 124.442 14.2247C124.442 14.3953 124.434 14.5736 124.419 14.7597C124.419 14.9458 124.411 15.1396 124.396 15.3412H115.626C115.688 16.2406 115.999 16.9462 116.557 17.4579C117.131 17.9696 117.821 18.2255 118.627 18.2255C119.232 18.2255 119.736 18.0937 120.139 17.8301C120.558 17.5509 120.868 17.1943 121.069 16.7601H124.093C123.876 17.4889 123.512 18.1557 123 18.7605C122.504 19.3497 121.883 19.8149 121.139 20.1561C120.41 20.4972 119.581 20.6678 118.65 20.6678ZM118.674 10.9916C117.945 10.9916 117.301 11.2009 116.743 11.6196C116.185 12.0228 115.828 12.643 115.673 13.4804H121.418C121.372 12.7206 121.093 12.1158 120.581 11.6661C120.069 11.2164 119.433 10.9916 118.674 10.9916ZM126.946 20.3887V3.64135H129.923V20.3887H126.946ZM134.408 25.5059L137.083 19.6211H136.385L131.896 8.85163H135.129L138.362 16.9694L141.735 8.85163H144.898L137.571 25.5059H134.408Z"
          fill={theme.palette.primary.main}
        />
        <rect x="0.287109" width="26.9297" height="23.3604" rx="6.41893" fill={theme.palette.primary.main} />
        <path
          d="M28.5524 7.40039H17.7207C15.3573 7.40039 13.4414 9.31629 13.4414 11.6797C13.4414 14.0431 15.3573 15.959 17.7207 15.959H28.5524V7.40039Z"
          fill={theme.palette.primary.lighter}
        />
        <circle cx="17.5771" cy="11.6797" r="2.13964" fill={theme.palette.primary.main} />
      </svg>
    </Box>
  );
}

Financely.propTypes = { imageSize: PropTypes.object };
