'use client';
import PropTypes from 'prop-types';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - DRIBBBLE  ***************************/

export default function Dribbble({ imageSize }) {
  const theme = useTheme();

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 89, sm: 105, md: 132 }, height: imageSize?.height || { xs: 16, sm: 18, md: 26 } }
      }}
    >
      <svg viewBox="0 0 132 26" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M34.5584 20.3779V4.09581H40.2107C42.1025 4.09581 43.6609 4.43696 44.8859 5.11926C46.1265 5.78605 47.0414 6.73196 47.6306 7.957C48.2354 9.16653 48.5378 10.5931 48.5378 12.2369C48.5378 13.8806 48.2354 15.315 47.6306 16.54C47.0414 17.7495 46.1265 18.6954 44.8859 19.3777C43.6609 20.0445 42.1025 20.3779 40.2107 20.3779H34.5584ZM37.6986 17.6797H40.0246C41.3737 17.6797 42.4281 17.4627 43.188 17.0285C43.9633 16.5943 44.5138 15.974 44.8394 15.1677C45.1651 14.3458 45.3279 13.3689 45.3279 12.2369C45.3279 11.0894 45.1651 10.1124 44.8394 9.30609C44.5138 8.48423 43.9633 7.8562 43.188 7.42201C42.4281 6.98782 41.3737 6.77073 40.0246 6.77073H37.6986V17.6797ZM51.0939 20.3779V8.81762H53.8851L54.1875 10.9808C54.4666 10.4846 54.8077 10.0582 55.2109 9.70151C55.6296 9.32935 56.1026 9.04247 56.6298 8.84088C57.1725 8.6393 57.7695 8.5385 58.4208 8.5385V11.8647H57.5369C57.0562 11.8647 56.6065 11.919 56.1879 12.0275C55.7847 12.1361 55.4358 12.3144 55.1411 12.5625C54.8465 12.8106 54.6217 13.1518 54.4666 13.586C54.3115 14.0046 54.234 14.5396 54.234 15.1909V20.3779H51.0939ZM60.5455 20.3779V8.81762H63.6856V20.3779H60.5455ZM62.1039 7.16615C61.5457 7.16615 61.0805 6.99558 60.7083 6.65443C60.3517 6.31328 60.1733 5.89459 60.1733 5.39838C60.1733 4.87115 60.3517 4.44471 60.7083 4.11907C61.0805 3.79342 61.5457 3.6306 62.1039 3.6306C62.6777 3.6306 63.1429 3.79342 63.4995 4.11907C63.8717 4.44471 64.0578 4.87115 64.0578 5.39838C64.0578 5.89459 63.8717 6.31328 63.4995 6.65443C63.1429 6.99558 62.6777 7.16615 62.1039 7.16615ZM73.7215 20.6571C73.1477 20.6571 72.6205 20.5873 72.1398 20.4477C71.6746 20.3081 71.2559 20.1066 70.8837 19.8429C70.5116 19.5638 70.1937 19.2382 69.9301 18.866L69.5812 20.3779H66.7899V3.6306H69.9301V10.4458C70.2867 9.93411 70.7674 9.49217 71.3722 9.12C71.977 8.73234 72.7601 8.5385 73.7215 8.5385C74.807 8.5385 75.7684 8.80212 76.6057 9.32935C77.4586 9.85658 78.1332 10.5776 78.6294 11.4925C79.1256 12.4074 79.3737 13.4542 79.3737 14.6327C79.3737 15.7802 79.1256 16.8114 78.6294 17.7263C78.1332 18.6412 77.4586 19.3622 76.6057 19.8895C75.7684 20.4012 74.807 20.6571 73.7215 20.6571ZM73.0237 17.9124C73.6439 17.9124 74.1867 17.7728 74.6519 17.4937C75.1326 17.2145 75.5048 16.8269 75.7684 16.3307C76.0475 15.8344 76.1871 15.2607 76.1871 14.6094C76.1871 13.9736 76.0475 13.4076 75.7684 12.9114C75.5048 12.3997 75.1326 12.0043 74.6519 11.7251C74.1867 11.4305 73.6439 11.2832 73.0237 11.2832C72.4034 11.2832 71.8529 11.4305 71.3722 11.7251C70.8915 12.0043 70.5116 12.3919 70.2325 12.8882C69.9688 13.3844 69.837 13.9581 69.837 14.6094C69.837 15.2452 69.9688 15.8189 70.2325 16.3307C70.5116 16.8269 70.8915 17.2145 71.3722 17.4937C71.8529 17.7728 72.4034 17.9124 73.0237 17.9124ZM88.9633 20.6571C88.3895 20.6571 87.8623 20.5873 87.3816 20.4477C86.9164 20.3081 86.4977 20.1066 86.1255 19.8429C85.7533 19.5638 85.4355 19.2382 85.1718 18.866L84.8229 20.3779H82.0317V3.6306H85.1718V10.4458C85.5285 9.93411 86.0092 9.49217 86.614 9.12C87.2187 8.73234 88.0018 8.5385 88.9633 8.5385C90.0487 8.5385 91.0101 8.80212 91.8475 9.32935C92.7004 9.85658 93.3749 10.5776 93.8711 11.4925C94.3674 12.4074 94.6155 13.4542 94.6155 14.6327C94.6155 15.7802 94.3674 16.8114 93.8711 17.7263C93.3749 18.6412 92.7004 19.3622 91.8475 19.8895C91.0101 20.4012 90.0487 20.6571 88.9633 20.6571ZM88.2654 17.9124C88.8857 17.9124 89.4285 17.7728 89.8937 17.4937C90.3744 17.2145 90.7465 16.8269 91.0101 16.3307C91.2893 15.8344 91.4288 15.2607 91.4288 14.6094C91.4288 13.9736 91.2893 13.4076 91.0101 12.9114C90.7465 12.3997 90.3744 12.0043 89.8937 11.7251C89.4285 11.4305 88.8857 11.2832 88.2654 11.2832C87.6452 11.2832 87.0947 11.4305 86.614 11.7251C86.1333 12.0043 85.7533 12.3919 85.4742 12.8882C85.2106 13.3844 85.0788 13.9581 85.0788 14.6094C85.0788 15.2452 85.2106 15.8189 85.4742 16.3307C85.7533 16.8269 86.1333 17.2145 86.614 17.4937C87.0947 17.7728 87.6452 17.9124 88.2654 17.9124ZM104.205 20.6571C103.631 20.6571 103.104 20.5873 102.623 20.4477C102.158 20.3081 101.739 20.1066 101.367 19.8429C100.995 19.5638 100.677 19.2382 100.414 18.866L100.065 20.3779H97.2735V3.6306H100.414V10.4458C100.77 9.93411 101.251 9.49217 101.856 9.12C102.461 8.73234 103.244 8.5385 104.205 8.5385C105.29 8.5385 106.252 8.80212 107.089 9.32935C107.942 9.85658 108.617 10.5776 109.113 11.4925C109.609 12.4074 109.857 13.4542 109.857 14.6327C109.857 15.7802 109.609 16.8114 109.113 17.7263C108.617 18.6412 107.942 19.3622 107.089 19.8895C106.252 20.4012 105.29 20.6571 104.205 20.6571ZM103.507 17.9124C104.127 17.9124 104.67 17.7728 105.135 17.4937C105.616 17.2145 105.988 16.8269 106.252 16.3307C106.531 15.8344 106.671 15.2607 106.671 14.6094C106.671 13.9736 106.531 13.4076 106.252 12.9114C105.988 12.3997 105.616 12.0043 105.135 11.7251C104.67 11.4305 104.127 11.2832 103.507 11.2832C102.887 11.2832 102.336 11.4305 101.856 11.7251C101.375 12.0043 100.995 12.3919 100.716 12.8882C100.452 13.3844 100.321 13.9581 100.321 14.6094C100.321 15.2452 100.452 15.8189 100.716 16.3307C100.995 16.8269 101.375 17.2145 101.856 17.4937C102.336 17.7728 102.887 17.9124 103.507 17.9124ZM112.515 20.3779V3.6306H115.655V20.3779H112.515ZM124.323 20.6571C123.145 20.6571 122.098 20.4089 121.183 19.9127C120.284 19.4165 119.578 18.7187 119.066 17.8193C118.555 16.9199 118.299 15.881 118.299 14.7024C118.299 13.5084 118.547 12.4462 119.043 11.5158C119.555 10.5854 120.26 9.85658 121.16 9.32935C122.075 8.80212 123.137 8.5385 124.347 8.5385C125.494 8.5385 126.502 8.79436 127.37 9.30609C128.254 9.8023 128.937 10.4768 129.417 11.3297C129.913 12.1826 130.162 13.1595 130.162 14.2605C130.162 14.4156 130.162 14.5861 130.162 14.7722C130.162 14.9583 130.146 15.1599 130.115 15.377H120.555V13.4464H126.975C126.928 12.7331 126.657 12.1671 126.161 11.7484C125.68 11.3142 125.075 11.0971 124.347 11.0971C123.804 11.0971 123.308 11.2212 122.858 11.4693C122.408 11.7019 122.052 12.0585 121.788 12.5393C121.524 13.02 121.392 13.6247 121.392 14.3535V15.0281C121.392 15.6484 121.517 16.1911 121.765 16.6563C122.013 17.106 122.354 17.4627 122.788 17.7263C123.238 17.9744 123.742 18.0984 124.3 18.0984C124.874 18.0984 125.354 17.9744 125.742 17.7263C126.13 17.4627 126.424 17.1293 126.626 16.7261H129.836C129.603 17.4549 129.231 18.1217 128.719 18.7265C128.208 19.3157 127.58 19.7887 126.835 20.1453C126.091 20.4865 125.254 20.6571 124.323 20.6571Z"
          fill={theme.palette.primary.main}
        />
        <g clipPath="url(#clip0_10969_1027)">
          <path
            d="M0 12.1836C0 10.0983 0.513682 8.17393 1.541 6.41059C2.56834 4.64725 3.96368 3.25193 5.727 2.22459C7.49034 1.19725 9.41468 0.683594 11.5 0.683594C13.5853 0.683594 15.5097 1.19725 17.273 2.22459C19.0363 3.25193 20.4317 4.64725 21.459 6.41059C22.4863 8.17393 23 10.0983 23 12.1836C23 14.2689 22.4863 16.1933 21.459 17.9566C20.4317 19.7199 19.0363 21.1153 17.273 22.1426C15.5097 23.1699 13.5853 23.6836 11.5 23.6836C9.41468 23.6836 7.49034 23.1699 5.727 22.1426C3.96368 21.1153 2.56834 19.7199 1.541 17.9566C0.513682 16.1933 0 14.2689 0 12.1836ZM1.909 12.1836C1.909 14.5756 2.714 16.6839 4.324 18.5086C5.06 17.0673 6.22534 15.6949 7.82 14.3916C9.41468 13.0883 10.971 12.2679 12.489 11.9306C12.259 11.3939 12.0367 10.9109 11.822 10.4816C9.18468 11.3249 6.33268 11.7466 3.266 11.7466C2.668 11.7466 2.22334 11.7389 1.932 11.7236C1.932 11.7849 1.92818 11.8616 1.9205 11.9536C1.91284 12.0456 1.909 12.1223 1.909 12.1836ZM2.208 9.81459C2.54534 9.84525 3.04368 9.86059 3.703 9.86059C6.26368 9.86059 8.694 9.51559 10.994 8.82559C9.82868 6.75559 8.54834 5.03059 7.153 3.65059C5.94168 4.26393 4.90284 5.11493 4.0365 6.20359C3.17018 7.29225 2.56068 8.49593 2.208 9.81459ZM5.635 19.7506C7.36768 21.0999 9.32268 21.7746 11.5 21.7746C12.6347 21.7746 13.7617 21.5599 14.881 21.1306C14.5743 18.5086 13.9763 15.9709 13.087 13.5176C11.6763 13.8243 10.2542 14.5986 8.8205 15.8406C7.38684 17.0826 6.325 18.3859 5.635 19.7506ZM9.154 2.91459C10.5033 4.30993 11.753 6.05025 12.903 8.13559C14.9883 7.26159 16.56 6.14993 17.618 4.80059C15.8393 3.32859 13.8 2.59259 11.5 2.59259C10.718 2.59259 9.936 2.69993 9.154 2.91459ZM13.731 9.76859C13.961 10.2593 14.2217 10.8803 14.513 11.6316C15.6477 11.5243 16.882 11.4706 18.216 11.4706C19.1667 11.4706 20.1097 11.4936 21.045 11.5396C20.9223 9.45425 20.171 7.59893 18.791 5.97359C17.7943 7.46093 16.1077 8.72593 13.731 9.76859ZM15.088 13.2416C15.87 15.5109 16.399 17.8416 16.675 20.2336C17.8863 19.4516 18.8753 18.4473 19.642 17.2206C20.4087 15.9939 20.8687 14.6676 21.022 13.2416C19.9027 13.1649 18.883 13.1266 17.963 13.1266C17.1197 13.1266 16.1613 13.1649 15.088 13.2416Z"
            fill={theme.palette.primary.main}
          />
        </g>
        <defs>
          <clipPath id="clip0_10969_1027">
            <rect width="23" height="23" fill={theme.palette.secondary.lighter} transform="translate(0 0.683594)" />
          </clipPath>
        </defs>
      </svg>
    </Box>
  );
}

Dribbble.propTypes = { imageSize: PropTypes.object };
