'use client';
import PropTypes from 'prop-types';

// @mui
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';

/***************************  IMAGE - DEVTO  ***************************/

export default function Devto({ imageSize }) {
  const theme = useTheme();

  return (
    <Box
      sx={{
        lineHeight: 0,
        '& svg': { width: imageSize?.width || { xs: 89, sm: 105, md: 106 }, height: imageSize?.height || { xs: 16, sm: 18, md: 26 } }
      }}
    >
      <svg viewBox="0 0 106 26" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M41.3152 20.7791C40.2298 20.7791 39.2606 20.5155 38.4077 19.9883C37.5548 19.461 36.8803 18.74 36.3841 17.8251C35.8879 16.8947 35.6397 15.8557 35.6397 14.7082C35.6397 13.5452 35.8879 12.514 36.3841 11.6146C36.8803 10.6997 37.5548 9.97865 38.4077 9.45142C39.2761 8.92419 40.2453 8.66057 41.3152 8.66057C42.1681 8.66057 42.9124 8.82339 43.5482 9.14903C44.1995 9.45917 44.719 9.90111 45.1066 10.4749V3.75267H48.2468V20.5H45.4555L45.1066 18.895C44.8585 19.2362 44.5639 19.5541 44.2228 19.8487C43.8816 20.1278 43.4707 20.3527 42.99 20.5233C42.5093 20.6938 41.951 20.7791 41.3152 20.7791ZM42.013 18.0344C42.6333 18.0344 43.1838 17.8949 43.6645 17.6157C44.1452 17.3211 44.5174 16.9257 44.781 16.4295C45.0446 15.9333 45.1764 15.3673 45.1764 14.7315C45.1764 14.0802 45.0446 13.5064 44.781 13.0102C44.5174 12.4985 44.1452 12.1031 43.6645 11.824C43.1838 11.5448 42.6333 11.4053 42.013 11.4053C41.4083 11.4053 40.8655 11.5526 40.3848 11.8472C39.9041 12.1263 39.5242 12.514 39.2451 13.0102C38.9815 13.5064 38.8497 14.0724 38.8497 14.7082C38.8497 15.3595 38.9815 15.9333 39.2451 16.4295C39.5087 16.9257 39.8809 17.3211 40.3616 17.6157C40.8578 17.8949 41.4083 18.0344 42.013 18.0344ZM56.9286 20.7791C55.7501 20.7791 54.7034 20.531 53.7885 20.0348C52.8891 19.5386 52.1835 18.8408 51.6718 17.9414C51.1601 17.042 50.9042 16.003 50.9042 14.8245C50.9042 13.6305 51.1523 12.5683 51.6486 11.6379C52.1603 10.7075 52.8658 9.97865 53.7652 9.45142C54.6801 8.92419 55.7424 8.66057 56.9519 8.66057C58.0994 8.66057 59.1073 8.91643 59.9757 9.42816C60.8596 9.92437 61.5419 10.5989 62.0226 11.4518C62.5188 12.3047 62.7669 13.2816 62.7669 14.3826C62.7669 14.5376 62.7669 14.7082 62.7669 14.8943C62.7669 15.0804 62.7514 15.282 62.7204 15.4991H53.1605V13.5685H59.5803C59.5338 12.8552 59.2624 12.2892 58.7662 11.8705C58.2855 11.4363 57.6807 11.2192 56.9519 11.2192C56.4091 11.2192 55.9129 11.3432 55.4632 11.5914C55.0135 11.824 54.6569 12.1806 54.3933 12.6613C54.1296 13.142 53.9978 13.7468 53.9978 14.4756V15.1502C53.9978 15.7704 54.1219 16.3132 54.37 16.7784C54.6181 17.2281 54.9593 17.5847 55.3935 17.8483C55.8431 18.0964 56.3471 18.2205 56.9054 18.2205C57.4791 18.2205 57.9598 18.0964 58.3475 17.8483C58.7352 17.5847 59.0298 17.2513 59.2314 16.8482H62.4413C62.2087 17.577 61.8365 18.2438 61.3248 18.8485C60.8131 19.4378 60.185 19.9107 59.4407 20.2674C58.6964 20.6085 57.859 20.7791 56.9286 20.7791ZM67.9082 20.5L63.6748 8.93969H66.9777L69.8155 17.546L72.6765 8.93969H75.9329L71.6996 20.5H67.9082ZM78.2486 20.6163C77.6748 20.6163 77.2019 20.4457 76.8297 20.1046C76.473 19.7479 76.2947 19.3137 76.2947 18.802C76.2947 18.2903 76.473 17.8638 76.8297 17.5227C77.2019 17.166 77.6748 16.9877 78.2486 16.9877C78.8223 16.9877 79.2875 17.166 79.6442 17.5227C80.0008 17.8638 80.1792 18.2903 80.1792 18.802C80.1792 19.3137 80.0008 19.7479 79.6442 20.1046C79.2875 20.4457 78.8223 20.6163 78.2486 20.6163ZM87.8567 20.5C87.0348 20.5 86.3137 20.3759 85.6935 20.1278C85.0887 19.8642 84.6157 19.4378 84.2746 18.8485C83.9334 18.2438 83.7629 17.4219 83.7629 16.3829V11.5681H81.7858V8.93969H83.7629L84.1118 5.79957H86.903V8.93969H89.9733V11.5681H86.903V16.4295C86.903 16.9567 87.0193 17.3211 87.2519 17.5227C87.4845 17.7243 87.8799 17.8251 88.4382 17.8251H89.9036V20.5H87.8567ZM97.7902 20.7791C96.6892 20.7791 95.689 20.5233 94.7896 20.0115C93.9058 19.4998 93.2002 18.7865 92.673 17.8716C92.1457 16.9567 91.8821 15.91 91.8821 14.7315C91.8821 13.5375 92.1457 12.483 92.673 11.5681C93.2002 10.6532 93.9135 9.93988 94.8129 9.42816C95.7123 8.91643 96.7125 8.66057 97.8135 8.66057C98.9455 8.66057 99.9534 8.91643 100.837 9.42816C101.737 9.93988 102.442 10.6532 102.954 11.5681C103.481 12.483 103.745 13.5375 103.745 14.7315C103.745 15.91 103.481 16.9567 102.954 17.8716C102.442 18.7865 101.737 19.4998 100.837 20.0115C99.9379 20.5233 98.9222 20.7791 97.7902 20.7791ZM97.8135 18.0577C98.3097 18.0577 98.7594 17.9336 99.1626 17.6855C99.5812 17.4374 99.9146 17.0652 100.163 16.569C100.426 16.0728 100.558 15.4603 100.558 14.7315C100.558 13.9872 100.434 13.3669 100.186 12.8707C99.9379 12.3744 99.6045 12.0023 99.1858 11.7542C98.7826 11.5061 98.3329 11.382 97.8367 11.382C97.3405 11.382 96.8831 11.5061 96.4644 11.7542C96.0457 12.0023 95.7123 12.3744 95.4642 12.8707C95.2161 13.3669 95.092 13.9872 95.092 14.7315C95.092 15.4603 95.2161 16.0728 95.4642 16.569C95.7123 17.0652 96.0379 17.4374 96.4411 17.6855C96.8598 17.9336 97.3173 18.0577 97.8135 18.0577Z"
          fill={theme.palette.primary.main}
        />
        <g clipPath="url(#clip0_10973_27015)">
          <path
            d="M7.47938 10.6561C7.28018 10.5072 7.08047 10.4327 6.88127 10.4327H5.98592V15.7962H6.88179C7.08098 15.7962 7.28069 15.7217 7.47989 15.5728C7.67908 15.424 7.77868 15.2006 7.77868 14.9023V11.3266C7.77817 11.0288 7.67806 10.805 7.47938 10.6561ZM22.0587 1.60547H3.56629C2.32388 1.60547 1.31558 2.61121 1.3125 3.85413V22.3568C1.31558 23.5997 2.32388 24.6055 3.56629 24.6055H22.0587C23.3016 24.6055 24.3094 23.5997 24.3125 22.3568V3.85413C24.3094 2.61121 23.3011 1.60547 22.0587 1.60547ZM9.22902 14.9121C9.22902 15.8778 8.63297 17.341 6.74625 17.3379H4.36411V8.84328H6.79656C8.61603 8.84328 9.22799 10.3044 9.2285 11.2706L9.22902 14.9121ZM14.3979 10.3604H11.6625V12.3328H13.3346V13.8509H11.6625V15.8229H14.3984V17.341H11.2061C10.6331 17.3558 10.1567 16.903 10.1423 16.3301V9.90703C10.1285 9.3346 10.5818 8.8592 11.1542 8.84482H14.3984L14.3979 10.3604ZM19.7187 16.2793C19.041 17.8579 17.8268 17.5438 17.2831 16.2793L15.305 8.84534H16.9771L18.5024 14.6836L20.0205 8.84534H21.6932L19.7187 16.2793Z"
            fill={theme.palette.primary.main}
          />
        </g>
        <defs>
          <clipPath id="clip0_10973_27015">
            <rect width="24" height="24" fill={theme.palette.primary.main} transform="translate(0.5 1.5)" />
          </clipPath>
        </defs>
      </svg>
    </Box>
  );
}

Devto.propTypes = { imageSize: PropTypes.object };
