'use client';

// @mui
import { useTheme } from '@mui/material/styles';
import CardMedia from '@mui/material/CardMedia';
import Box from '@mui/material/Box';

// @project
import branding from '@/branding.json';

/***************************  LOGO - MAIN  ***************************/

export default function LogoMain() {
  const theme = useTheme();
  const logoMainPath = branding.logo.main;

  return logoMainPath ? (
    <CardMedia src={logoMainPath} component="img" alt="logo" sx={{ width: { xs: 112, lg: 140 } }} loading="lazy" />
  ) : (
    <Box sx={{ width: { xs: 112, lg: 140 }, height: { xs: 22, lg: 26 } }}>
      <svg viewBox="0 0 140 27" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M18.8829 0.427107C21.4241 -0.961272 24.4323 1.23978 23.8814 4.08446L20.2026 23.083C20.1771 23.2543 20.1385 23.4244 20.0865 23.5919C19.9716 23.983 19.8053 24.3088 19.5985 24.5713L19.5803 24.5963C18.4651 26.1231 16.3244 26.456 14.7989 25.3398C14.0423 24.7862 13.5792 23.9802 13.4405 23.1221L13.4413 23.1226C13.018 21.5306 13.6228 17.2572 16.7968 10.4168L18.0197 11.7888L19.6391 5.17618C19.7118 4.87928 19.3889 4.64305 19.1283 4.80246L13.3241 8.35306L15.0704 9.15363C11.7777 12.6269 7.19306 15.8763 3.94258 16.2187C3.13058 16.3043 2.15871 16.0911 1.40248 15.5377C-0.123006 14.4215 -0.455588 12.279 0.659645 10.7522L0.66829 10.7404L0.678147 10.7271C0.865156 10.4504 1.1246 10.1932 1.46169 9.96519C1.60563 9.86452 1.75619 9.77586 1.91185 9.69943L18.8829 0.427107ZM6.39334 23.161C7.37266 23.8631 8.73948 23.6318 9.44623 22.6444C9.91583 21.9883 10.2609 19.8511 10.4396 18.4907C10.5082 17.9682 9.98185 17.5908 9.50966 17.8239C8.28019 18.431 6.36939 19.4456 5.8998 20.1017C5.19305 21.0891 5.41402 22.4588 6.39334 23.161Z"
          fill={theme.palette.primary.main}
        />
        <path
          d="M38.1793 21.288C37.2193 21.288 36.3073 21.192 35.4433 21C34.5793 20.808 33.8113 20.504 33.1393 20.088C32.4833 19.656 31.9633 19.12 31.5793 18.48C31.2113 17.824 31.0273 17.032 31.0273 16.104C31.0273 16.024 31.0273 15.944 31.0273 15.864C31.0273 15.768 31.0353 15.696 31.0513 15.648H34.6033C34.5873 15.696 34.5793 15.76 34.5793 15.84C34.5793 15.92 34.5793 15.992 34.5793 16.056C34.5793 16.568 34.7153 17 34.9873 17.352C35.2753 17.704 35.6913 17.968 36.2353 18.144C36.7793 18.32 37.4113 18.408 38.1313 18.408C38.5953 18.408 39.0033 18.384 39.3553 18.336C39.7233 18.272 40.0433 18.192 40.3153 18.096C40.6033 17.984 40.8353 17.856 41.0113 17.712C41.2033 17.568 41.3393 17.4 41.4193 17.208C41.5153 17.016 41.5633 16.8 41.5633 16.56C41.5633 16.128 41.4193 15.776 41.1313 15.504C40.8593 15.232 40.4753 15 39.9793 14.808C39.4993 14.616 38.9553 14.44 38.3473 14.28C37.7393 14.12 37.1153 13.96 36.4753 13.8C35.8353 13.624 35.2113 13.416 34.6033 13.176C33.9953 12.92 33.4513 12.616 32.9713 12.264C32.4913 11.912 32.1073 11.464 31.8193 10.92C31.5313 10.376 31.3873 9.72 31.3873 8.952C31.3873 8.136 31.5553 7.432 31.8913 6.84C32.2433 6.248 32.7313 5.76 33.3553 5.376C33.9793 4.992 34.6993 4.712 35.5153 4.536C36.3313 4.344 37.2193 4.248 38.1793 4.248C39.0753 4.248 39.9233 4.344 40.7233 4.536C41.5233 4.712 42.2273 5 42.8353 5.4C43.4433 5.8 43.9153 6.304 44.2513 6.912C44.6033 7.52 44.7793 8.24 44.7793 9.072V9.36H41.2993V9.168C41.2993 8.736 41.1713 8.368 40.9153 8.064C40.6593 7.76 40.2993 7.52 39.8353 7.344C39.3713 7.168 38.8273 7.08 38.2033 7.08C37.5313 7.08 36.9553 7.144 36.4753 7.272C36.0113 7.4 35.6513 7.592 35.3953 7.848C35.1553 8.088 35.0353 8.376 35.0353 8.712C35.0353 9.096 35.1713 9.416 35.4433 9.672C35.7313 9.912 36.1153 10.128 36.5953 10.32C37.0913 10.496 37.6433 10.656 38.2513 10.8C38.8593 10.944 39.4833 11.104 40.1233 11.28C40.7633 11.456 41.3873 11.664 41.9953 11.904C42.6033 12.144 43.1473 12.448 43.6273 12.816C44.1073 13.168 44.4913 13.608 44.7793 14.136C45.0673 14.664 45.2113 15.296 45.2113 16.032C45.2113 17.296 44.9073 18.312 44.2993 19.08C43.6913 19.848 42.8593 20.408 41.8033 20.76C40.7473 21.112 39.5393 21.288 38.1793 21.288ZM51.1083 21.288C50.6923 21.288 50.2443 21.24 49.7643 21.144C49.3003 21.048 48.8603 20.88 48.4443 20.64C48.0283 20.384 47.6843 20.024 47.4123 19.56C47.1563 19.08 47.0283 18.472 47.0283 17.736C47.0283 16.856 47.2203 16.128 47.6043 15.552C47.9883 14.976 48.5323 14.528 49.2363 14.208C49.9563 13.872 50.8123 13.64 51.8043 13.512C52.7963 13.384 53.8923 13.32 55.0923 13.32V12.384C55.0923 12.016 55.0283 11.696 54.9003 11.424C54.7883 11.152 54.5803 10.936 54.2763 10.776C53.9883 10.616 53.5803 10.536 53.0523 10.536C52.5243 10.536 52.0923 10.6 51.7563 10.728C51.4363 10.856 51.2043 11.024 51.0603 11.232C50.9323 11.424 50.8683 11.64 50.8683 11.88V12.168H47.6283C47.6123 12.088 47.6043 12.016 47.6043 11.952C47.6043 11.872 47.6043 11.776 47.6043 11.664C47.6043 10.928 47.8283 10.296 48.2763 9.768C48.7243 9.224 49.3563 8.808 50.1723 8.52C50.9883 8.232 51.9403 8.088 53.0283 8.088C54.1963 8.088 55.1723 8.24 55.9563 8.544C56.7563 8.848 57.3643 9.296 57.7803 9.888C58.2123 10.48 58.4283 11.224 58.4283 12.12V17.856C58.4283 18.144 58.5083 18.36 58.6683 18.504C58.8443 18.632 59.0363 18.696 59.2443 18.696H60.0363V20.88C59.8763 20.96 59.6283 21.04 59.2923 21.12C58.9563 21.216 58.5483 21.264 58.0683 21.264C57.6043 21.264 57.1883 21.192 56.8203 21.048C56.4683 20.92 56.1723 20.736 55.9323 20.496C55.6923 20.24 55.5243 19.936 55.4283 19.584H55.2603C54.9883 19.92 54.6523 20.216 54.2523 20.472C53.8683 20.728 53.4123 20.928 52.8843 21.072C52.3723 21.216 51.7803 21.288 51.1083 21.288ZM52.2363 18.768C52.6843 18.768 53.0843 18.704 53.4363 18.576C53.7883 18.432 54.0843 18.248 54.3243 18.024C54.5643 17.784 54.7483 17.496 54.8763 17.16C55.0203 16.824 55.0923 16.464 55.0923 16.08V15.384C54.1963 15.384 53.3963 15.448 52.6923 15.576C51.9883 15.688 51.4283 15.888 51.0123 16.176C50.6123 16.464 50.4123 16.864 50.4123 17.376C50.4123 17.664 50.4843 17.912 50.6283 18.12C50.7723 18.328 50.9803 18.488 51.2523 18.6C51.5243 18.712 51.8523 18.768 52.2363 18.768ZM65.0302 21.288C64.6142 21.288 64.1662 21.24 63.6862 21.144C63.2222 21.048 62.7822 20.88 62.3662 20.64C61.9502 20.384 61.6062 20.024 61.3342 19.56C61.0782 19.08 60.9502 18.472 60.9502 17.736C60.9502 16.856 61.1422 16.128 61.5262 15.552C61.9102 14.976 62.4542 14.528 63.1582 14.208C63.8782 13.872 64.7342 13.64 65.7262 13.512C66.7182 13.384 67.8142 13.32 69.0142 13.32V12.384C69.0142 12.016 68.9502 11.696 68.8222 11.424C68.7102 11.152 68.5022 10.936 68.1982 10.776C67.9102 10.616 67.5022 10.536 66.9742 10.536C66.4462 10.536 66.0142 10.6 65.6782 10.728C65.3582 10.856 65.1262 11.024 64.9822 11.232C64.8542 11.424 64.7902 11.64 64.7902 11.88V12.168H61.5502C61.5342 12.088 61.5262 12.016 61.5262 11.952C61.5262 11.872 61.5262 11.776 61.5262 11.664C61.5262 10.928 61.7502 10.296 62.1982 9.768C62.6462 9.224 63.2782 8.808 64.0942 8.52C64.9102 8.232 65.8622 8.088 66.9502 8.088C68.1182 8.088 69.0942 8.24 69.8782 8.544C70.6782 8.848 71.2862 9.296 71.7022 9.888C72.1342 10.48 72.3502 11.224 72.3502 12.12V17.856C72.3502 18.144 72.4302 18.36 72.5902 18.504C72.7662 18.632 72.9582 18.696 73.1662 18.696H73.9582V20.88C73.7982 20.96 73.5502 21.04 73.2142 21.12C72.8782 21.216 72.4702 21.264 71.9902 21.264C71.5262 21.264 71.1102 21.192 70.7422 21.048C70.3902 20.92 70.0942 20.736 69.8542 20.496C69.6142 20.24 69.4462 19.936 69.3502 19.584H69.1822C68.9102 19.92 68.5742 20.216 68.1742 20.472C67.7902 20.728 67.3342 20.928 66.8062 21.072C66.2942 21.216 65.7022 21.288 65.0302 21.288ZM66.1582 18.768C66.6062 18.768 67.0062 18.704 67.3582 18.576C67.7102 18.432 68.0062 18.248 68.2462 18.024C68.4862 17.784 68.6702 17.496 68.7982 17.16C68.9422 16.824 69.0142 16.464 69.0142 16.08V15.384C68.1182 15.384 67.3182 15.448 66.6142 15.576C65.9102 15.688 65.3502 15.888 64.9342 16.176C64.5342 16.464 64.3342 16.864 64.3342 17.376C64.3342 17.664 64.4062 17.912 64.5502 18.12C64.6942 18.328 64.9022 18.488 65.1742 18.6C65.4462 18.712 65.7742 18.768 66.1582 18.768ZM80.7281 21.288C79.8481 21.288 79.0561 21.192 78.3521 21C77.6481 20.808 77.0481 20.544 76.5521 20.208C76.0561 19.856 75.6721 19.44 75.4001 18.96C75.1441 18.48 75.0161 17.936 75.0161 17.328C75.0161 17.264 75.0161 17.2 75.0161 17.136C75.0161 17.072 75.0241 17.024 75.0401 16.992H78.2561C78.2561 17.024 78.2561 17.056 78.2561 17.088C78.2561 17.12 78.2561 17.152 78.2561 17.184C78.2721 17.584 78.4001 17.912 78.6401 18.168C78.8801 18.408 79.1921 18.584 79.5761 18.696C79.9761 18.808 80.3921 18.864 80.8241 18.864C81.2081 18.864 81.5761 18.832 81.9281 18.768C82.2961 18.688 82.6001 18.552 82.8401 18.36C83.0961 18.168 83.2241 17.92 83.2241 17.616C83.2241 17.232 83.0641 16.936 82.7441 16.728C82.4401 16.52 82.0321 16.352 81.5201 16.224C81.0241 16.096 80.4801 15.952 79.8881 15.792C79.3441 15.664 78.8001 15.52 78.2561 15.36C77.7121 15.184 77.2161 14.96 76.7681 14.688C76.3361 14.416 75.9841 14.064 75.7121 13.632C75.4401 13.184 75.3041 12.624 75.3041 11.952C75.3041 11.296 75.4481 10.728 75.7361 10.248C76.0241 9.752 76.4161 9.344 76.9121 9.024C77.4241 8.704 78.0161 8.472 78.6881 8.328C79.3761 8.168 80.1121 8.088 80.8961 8.088C81.6321 8.088 82.3201 8.168 82.9601 8.328C83.6001 8.472 84.1601 8.696 84.6401 9C85.1201 9.288 85.4961 9.656 85.7681 10.104C86.0401 10.536 86.1761 11.024 86.1761 11.568C86.1761 11.68 86.1761 11.784 86.1761 11.88C86.1761 11.976 86.1681 12.04 86.1521 12.072H82.9601V11.88C82.9601 11.592 82.8721 11.352 82.6961 11.16C82.5201 10.952 82.2641 10.792 81.9281 10.68C81.6081 10.568 81.2161 10.512 80.7521 10.512C80.4321 10.512 80.1361 10.536 79.8641 10.584C79.6081 10.632 79.3841 10.704 79.1921 10.8C79.0001 10.896 78.8481 11.016 78.7361 11.16C78.6401 11.288 78.5921 11.448 78.5921 11.64C78.5921 11.912 78.7041 12.136 78.9281 12.312C79.1681 12.472 79.4801 12.608 79.8641 12.72C80.2481 12.832 80.6721 12.952 81.1361 13.08C81.7121 13.24 82.3121 13.4 82.9361 13.56C83.5761 13.704 84.1681 13.904 84.7121 14.16C85.2561 14.416 85.6961 14.784 86.0321 15.264C86.3681 15.728 86.5361 16.36 86.5361 17.16C86.5361 17.928 86.3841 18.576 86.0801 19.104C85.7921 19.632 85.3841 20.056 84.8561 20.376C84.3281 20.696 83.7121 20.928 83.0081 21.072C82.3041 21.216 81.5441 21.288 80.7281 21.288ZM87.56 21L93.896 4.536H98.312L104.648 21H100.784L99.608 17.76H92.432L91.256 21H87.56ZM93.464 14.88H98.576L97.112 10.824C97.048 10.648 96.968 10.44 96.872 10.2C96.792 9.944 96.704 9.664 96.608 9.36C96.512 9.056 96.416 8.76 96.32 8.472C96.24 8.168 96.16 7.896 96.08 7.656H95.936C95.856 7.96 95.752 8.32 95.624 8.736C95.496 9.136 95.368 9.528 95.24 9.912C95.112 10.28 95.008 10.584 94.928 10.824L93.464 14.88ZM113.375 21.288C112.559 21.288 111.807 21.128 111.119 20.808C110.447 20.472 109.903 19.968 109.487 19.296H109.319L109.055 21H106.319V3.648H109.655V9.768H109.799C110.055 9.4 110.367 9.088 110.735 8.832C111.103 8.576 111.519 8.392 111.983 8.28C112.447 8.152 112.951 8.088 113.495 8.088C114.487 8.088 115.351 8.32 116.087 8.784C116.839 9.248 117.423 9.968 117.839 10.944C118.255 11.904 118.463 13.144 118.463 14.664C118.463 16.184 118.255 17.432 117.839 18.408C117.439 19.384 116.855 20.112 116.087 20.592C115.335 21.056 114.431 21.288 113.375 21.288ZM112.343 18.552C113.015 18.552 113.543 18.424 113.927 18.168C114.327 17.896 114.615 17.496 114.791 16.968C114.967 16.44 115.055 15.776 115.055 14.976V14.424C115.055 13.624 114.967 12.96 114.791 12.432C114.615 11.888 114.327 11.488 113.927 11.232C113.543 10.96 113.015 10.824 112.343 10.824C111.863 10.824 111.455 10.912 111.119 11.088C110.783 11.248 110.503 11.488 110.279 11.808C110.071 12.112 109.911 12.496 109.799 12.96C109.687 13.424 109.631 13.936 109.631 14.496V14.928C109.631 15.68 109.727 16.328 109.919 16.872C110.111 17.416 110.407 17.832 110.807 18.12C111.207 18.408 111.719 18.552 112.343 18.552ZM120.921 21V3.648H124.257V21H120.921ZM133.055 21.288C131.663 21.288 130.495 21.056 129.551 20.592C128.607 20.112 127.895 19.384 127.415 18.408C126.935 17.432 126.695 16.192 126.695 14.688C126.695 13.168 126.935 11.928 127.415 10.968C127.895 9.992 128.599 9.272 129.527 8.808C130.471 8.328 131.623 8.088 132.983 8.088C134.263 8.088 135.343 8.32 136.223 8.784C137.103 9.232 137.767 9.936 138.215 10.896C138.663 11.84 138.887 13.064 138.887 14.568V15.432H130.079C130.111 16.168 130.223 16.792 130.415 17.304C130.623 17.816 130.935 18.2 131.351 18.456C131.783 18.696 132.351 18.816 133.055 18.816C133.439 18.816 133.783 18.768 134.087 18.672C134.407 18.576 134.679 18.432 134.903 18.24C135.127 18.048 135.303 17.808 135.431 17.52C135.559 17.232 135.623 16.904 135.623 16.536H138.887C138.887 17.336 138.743 18.032 138.455 18.624C138.167 19.216 137.767 19.712 137.255 20.112C136.743 20.496 136.127 20.792 135.407 21C134.703 21.192 133.919 21.288 133.055 21.288ZM130.127 13.32H135.455C135.455 12.84 135.391 12.424 135.263 12.072C135.151 11.72 134.991 11.432 134.783 11.208C134.575 10.984 134.319 10.824 134.015 10.728C133.727 10.616 133.399 10.56 133.031 10.56C132.423 10.56 131.911 10.664 131.495 10.872C131.095 11.064 130.783 11.368 130.559 11.784C130.351 12.184 130.207 12.696 130.127 13.32Z"
          fill={theme.palette.primary.main}
        />
      </svg>
    </Box>
  );
}
