package com.gitee.pifeng.monitoring.server.business.server.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 实时监控表
 * </p>
 *
 * @author 皮锋
 * @custom.date 2021-01-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@Builder
@TableName("MONITOR_REALTIME_MONITORING")
public class MonitorRealtimeMonitoring {

    /**
     * 主键ID
     */
    @TableId(value = "ID", type = IdType.AUTO)
    private Long id;

    /**
     * 监控类型
     */
    @TableField("TYPE")
    private String type;

    /**
     * 监控编号
     */
    @TableField("CODE")
    private String code;

    /**
     * 是否已经发送了告警（1：是，0：否）
     */
    @TableField("IS_SENT_ALARM")
    private String isSentAlarm;

    /**
     * 插入时间
     */
    @TableField("INSERT_TIME")
    private Date insertTime;

    /**
     * 更新时间
     */
    @TableField("UPDATE_TIME")
    private Date updateTime;

}
