/*******************************************************************************
* The MIT License (MIT)
*
* Copyright (c) 2015 David Williams and Matthew Williams
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*******************************************************************************/

#ifndef __PolyVox_RandomVectors_H__
#define __PolyVox_RandomVectors_H__

#include "PlatformDefinitions.h"

#include "../Vector.h"

namespace PolyVox
{
	const Vector3DFloat randomVectors[1024] =
	{
		Vector3DFloat(+0.348918f, -0.385662f, +0.650197f),
		Vector3DFloat(-0.259255f, +0.791559f, +0.920957f),
		Vector3DFloat(+0.940733f, -0.101535f, +0.250160f),
		Vector3DFloat(-0.308939f, +0.367656f, +0.877987f),
		Vector3DFloat(+0.112949f, -0.047090f, -0.730277f),
		Vector3DFloat(-0.605579f, +0.039705f, +0.310160f),
		Vector3DFloat(+0.086459f, +0.376446f, -0.496078f),
		Vector3DFloat(+0.565661f, -0.261574f, -0.924986f),
		Vector3DFloat(-0.285745f, -0.792047f, -0.582568f),
		Vector3DFloat(+0.943175f, +0.226844f, +0.823481f),
		Vector3DFloat(+0.599414f, +0.846797f, -0.438215f),
		Vector3DFloat(-0.502731f, -0.907407f, +0.170751f),
		Vector3DFloat(+0.136204f, -0.735527f, -0.066622f),
		Vector3DFloat(-0.618763f, +0.825617f, -0.325053f),
		Vector3DFloat(+0.942076f, +0.608325f, -0.532517f),
		Vector3DFloat(-0.466414f, -0.248756f, -0.189856f),
		Vector3DFloat(+0.618213f, +0.879513f, +0.120090f),
		Vector3DFloat(-0.918393f, +0.876522f, +0.265114f),
		Vector3DFloat(+0.345195f, +0.670705f, -0.914243f),
		Vector3DFloat(-0.600757f, -0.417646f, -0.736747f),
		Vector3DFloat(-0.271828f, +0.215674f, +0.890622f),
		Vector3DFloat(+0.100986f, +0.821955f, +0.429975f),
		Vector3DFloat(+0.811823f, -0.506943f, +0.635853f),
		Vector3DFloat(+0.647084f, +0.297403f, -0.714774f),
		Vector3DFloat(+0.531907f, -0.917417f, +0.795770f),
		Vector3DFloat(-0.151585f, +0.250038f, +0.959105f),
		Vector3DFloat(+0.311747f, -0.850948f, +0.946348f),
		Vector3DFloat(+0.641407f, -0.747978f, +0.464583f),
		Vector3DFloat(+0.297769f, -0.427839f, +0.867489f),
		Vector3DFloat(+0.305032f, +0.985900f, +0.071261f),
		Vector3DFloat(+0.105930f, -0.895016f, +0.871700f),
		Vector3DFloat(+0.060335f, -0.312235f, +0.247475f),
		Vector3DFloat(+0.174718f, +0.776055f, -0.783563f),
		Vector3DFloat(-0.018342f, -0.031343f, +0.533982f),
		Vector3DFloat(+0.136753f, -0.201575f, -0.694998f),
		Vector3DFloat(+0.606006f, +0.353069f, -0.174841f),
		Vector3DFloat(-0.720573f, +0.272805f, -0.679189f),
		Vector3DFloat(+0.802484f, -0.649281f, -0.884274f),
		Vector3DFloat(-0.577807f, -0.794610f, +0.227332f),
		Vector3DFloat(-0.391644f, +0.440474f, -0.927854f),
		Vector3DFloat(+0.631825f, +0.072115f, +0.943785f),
		Vector3DFloat(-0.898312f, +0.257363f, -0.942930f),
		Vector3DFloat(-0.608264f, +0.583667f, +0.228126f),
		Vector3DFloat(-0.788202f, +0.777764f, +0.722953f),
		Vector3DFloat(-0.624622f, -0.296976f, -0.382122f),
		Vector3DFloat(+0.921323f, -0.356365f, -0.750542f),
		Vector3DFloat(-0.899106f, +0.578234f, +0.937132f),
		Vector3DFloat(+0.830744f, -0.789422f, -0.026154f),
		Vector3DFloat(+0.720634f, +0.135166f, -0.366985f),
		Vector3DFloat(+0.796930f, +0.687124f, +0.807855f),
		Vector3DFloat(+0.262001f, -0.120945f, -0.196631f),
		Vector3DFloat(+0.562426f, -0.886166f, +0.699149f),
		Vector3DFloat(+0.047945f, -0.781793f, +0.465987f),
		Vector3DFloat(+0.219275f, +0.152440f, +0.726127f),
		Vector3DFloat(-0.970641f, -0.384136f, -0.340739f),
		Vector3DFloat(+0.244606f, +0.969848f, +0.466903f),
		Vector3DFloat(+0.608753f, +0.329936f, -0.411542f),
		Vector3DFloat(+0.959593f, -0.833186f, -0.698721f),
		Vector3DFloat(+0.475692f, -0.320658f, +0.507675f),
		Vector3DFloat(-0.155431f, -0.050447f, -0.455855f),
		Vector3DFloat(-0.738456f, +0.917173f, -0.407758f),
		Vector3DFloat(-0.555284f, +0.842891f, -0.984619f),
		Vector3DFloat(+0.696951f, +0.155553f, -0.031526f),
		Vector3DFloat(-0.131565f, -0.563707f, +0.076815f),
		Vector3DFloat(-0.319376f, +0.620106f, +0.567614f),
		Vector3DFloat(-0.628163f, -0.813959f, -0.438581f),
		Vector3DFloat(+0.484115f, +0.060640f, -0.176183f),
		Vector3DFloat(-0.523240f, -0.572314f, +0.633778f),
		Vector3DFloat(-0.524949f, -0.334574f, -0.326701f),
		Vector3DFloat(+0.747673f, +0.725944f, +0.701651f),
		Vector3DFloat(-0.500961f, +0.564867f, -0.902341f),
		Vector3DFloat(+0.995422f, -0.245949f, +0.301065f),
		Vector3DFloat(+0.655080f, -0.783380f, +0.835871f),
		Vector3DFloat(+0.541795f, -0.693472f, -0.355083f),
		Vector3DFloat(+0.891110f, +0.891171f, -0.891903f),
		Vector3DFloat(+0.507675f, -0.949034f, -0.485214f),
		Vector3DFloat(-0.116123f, +0.368999f, +0.514756f),
		Vector3DFloat(-0.859432f, -0.525071f, +0.632008f),
		Vector3DFloat(-0.707205f, +0.077914f, +0.930540f),
		Vector3DFloat(-0.783380f, -0.577074f, -0.180212f),
		Vector3DFloat(-0.047884f, -0.523789f, +0.471664f),
		Vector3DFloat(-0.210791f, +0.904904f, -0.585864f),
		Vector3DFloat(+0.132664f, +0.792230f, +0.707266f),
		Vector3DFloat(-0.735710f, -0.263710f, -0.258827f),
		Vector3DFloat(+0.912290f, +0.497421f, -0.518845f),
		Vector3DFloat(-0.790521f, -0.707144f, +0.314982f),
		Vector3DFloat(-0.799249f, +0.381207f, -0.756462f),
		Vector3DFloat(+0.694998f, -0.521836f, +0.957213f),
		Vector3DFloat(+0.310709f, +0.049837f, +0.920652f),
		Vector3DFloat(+0.581530f, +0.164647f, +0.560900f),
		Vector3DFloat(+0.406903f, -0.650563f, -0.674551f),
		Vector3DFloat(-0.749016f, +0.119663f, -0.040193f),
		Vector3DFloat(+0.955260f, -0.142552f, +0.175756f),
		Vector3DFloat(-0.925108f, -0.970824f, -0.430952f),
		Vector3DFloat(+0.666372f, +0.449507f, -0.801813f),
		Vector3DFloat(-0.311991f, -0.079928f, -0.608142f),
		Vector3DFloat(-0.344829f, +0.280862f, +0.800775f),
		Vector3DFloat(-0.880123f, +0.318217f, -0.120212f),
		Vector3DFloat(-0.146519f, +0.573412f, -0.358013f),
		Vector3DFloat(+0.297220f, -0.889523f, +0.246620f),
		Vector3DFloat(-0.628834f, -0.383404f, -0.630360f),
		Vector3DFloat(-0.397382f, +0.547533f, -0.579150f),
		Vector3DFloat(+0.758049f, +0.631947f, -0.916807f),
		Vector3DFloat(-0.678030f, -0.606433f, -0.881527f),
		Vector3DFloat(+0.213233f, +0.854060f, -0.043428f),
		Vector3DFloat(+0.175085f, +0.139500f, -0.208472f),
		Vector3DFloat(+0.983520f, -0.389386f, +0.178076f),
		Vector3DFloat(+0.956603f, +0.696951f, -0.307657f),
		Vector3DFloat(-0.276345f, +0.576220f, +0.182104f),
		Vector3DFloat(+0.864742f, -0.657582f, +0.253639f),
		Vector3DFloat(-0.275735f, -0.012177f, +0.306619f),
		Vector3DFloat(-0.385235f, -0.881649f, +0.658071f),
		Vector3DFloat(-0.117466f, -0.306681f, -0.235755f),
		Vector3DFloat(+0.173254f, +0.685720f, +0.116733f),
		Vector3DFloat(-0.641041f, +0.704642f, -0.585864f),
		Vector3DFloat(+0.154820f, +0.999939f, -0.761345f),
		Vector3DFloat(-0.726310f, +0.695181f, -0.490036f),
		Vector3DFloat(-0.149510f, -0.593188f, -0.794122f),
		Vector3DFloat(+0.798212f, +0.872555f, -0.361980f),
		Vector3DFloat(+0.749687f, -0.931944f, +0.519211f),
		Vector3DFloat(-0.151952f, -0.889096f, -0.313822f),
		Vector3DFloat(-0.467879f, +0.289651f, -0.901242f),
		Vector3DFloat(+0.522752f, +0.406781f, +0.157079f),
		Vector3DFloat(+0.088534f, -0.421735f, -0.236122f),
		Vector3DFloat(+0.722221f, -0.136692f, -0.292825f),
		Vector3DFloat(-0.572436f, +0.349162f, +0.819697f),
		Vector3DFloat(+0.252113f, +0.773614f, -0.299051f),
		Vector3DFloat(-0.401410f, +0.400250f, -0.091037f),
		Vector3DFloat(+0.449507f, +0.205115f, +0.075533f),
		Vector3DFloat(+0.246803f, -0.197851f, -0.322123f),
		Vector3DFloat(-0.822077f, +0.037263f, +0.157445f),
		Vector3DFloat(+0.373455f, +0.983154f, -0.580920f),
		Vector3DFloat(+0.201758f, -0.075289f, +0.514878f),
		Vector3DFloat(+0.552477f, +0.760430f, +0.938963f),
		Vector3DFloat(-0.297525f, -0.603504f, -0.285318f),
		Vector3DFloat(-0.504257f, +0.135899f, +0.694021f),
		Vector3DFloat(-0.701895f, +0.509140f, -0.768914f),
		Vector3DFloat(+0.725639f, +0.083834f, -0.985961f),
		Vector3DFloat(+0.617847f, -0.604114f, +0.976440f),
		Vector3DFloat(-0.557115f, +0.562853f, +0.214087f),
		Vector3DFloat(-0.480819f, -0.048738f, -0.759392f),
		Vector3DFloat(-0.268105f, -0.168493f, -0.141881f),
		Vector3DFloat(+0.664357f, -0.999207f, +0.486740f),
		Vector3DFloat(-0.739128f, +0.089328f, +0.611194f),
		Vector3DFloat(-0.355876f, +0.889523f, +0.701895f),
		Vector3DFloat(-0.123692f, -0.252358f, -0.739250f),
		Vector3DFloat(+0.405438f, -0.276772f, -0.896786f),
		Vector3DFloat(-0.803644f, +0.517563f, -0.146886f),
		Vector3DFloat(+0.647511f, +0.766289f, -0.811518f),
		Vector3DFloat(-0.266457f, -0.779534f, +0.720634f),
		Vector3DFloat(-0.643849f, -0.014130f, -0.345134f),
		Vector3DFloat(-0.527390f, +0.047700f, -0.271340f),
		Vector3DFloat(+0.993957f, -0.305643f, +0.841731f),
		Vector3DFloat(+0.441816f, -0.849117f, -0.411664f),
		Vector3DFloat(+0.303323f, -0.088473f, -0.677602f),
		Vector3DFloat(+0.897824f, +0.203833f, +0.821039f),
		Vector3DFloat(+0.468123f, +0.717338f, +0.338542f),
		Vector3DFloat(-0.452986f, -0.830622f, -0.832942f),
		Vector3DFloat(-0.245582f, -0.273171f, -0.820612f),
		Vector3DFloat(-0.007660f, -0.799371f, +0.156896f),
		Vector3DFloat(-0.022919f, +0.152013f, +0.614246f),
		Vector3DFloat(-0.414045f, +0.637440f, -0.542711f),
		Vector3DFloat(+0.453108f, -0.034516f, +0.330607f),
		Vector3DFloat(+0.324015f, +0.689505f, +0.719108f),
		Vector3DFloat(-0.236854f, +0.700491f, +0.276406f),
		Vector3DFloat(-0.405316f, +0.871944f, +0.233863f),
		Vector3DFloat(+0.898373f, +0.660756f, -0.914609f),
		Vector3DFloat(+0.737114f, -0.179601f, -0.990539f),
		Vector3DFloat(-0.536241f, -0.980712f, -0.352702f),
		Vector3DFloat(+0.730094f, -0.970214f, -0.857967f),
		Vector3DFloat(-0.194800f, -0.286782f, +0.604236f),
		Vector3DFloat(+0.163366f, -0.441755f, -0.149022f),
		Vector3DFloat(+0.457564f, +0.433149f, -0.626698f),
		Vector3DFloat(+0.192846f, -0.909848f, +0.501572f),
		Vector3DFloat(+0.444563f, -0.377789f, -0.545213f),
		Vector3DFloat(-0.296670f, -0.809259f, +0.614246f),
		Vector3DFloat(-0.068209f, +0.480148f, +0.537828f),
		Vector3DFloat(+0.638173f, +0.371685f, -0.495956f),
		Vector3DFloat(+0.798822f, +0.767510f, +0.516282f),
		Vector3DFloat(-0.336161f, -0.035615f, +0.058687f),
		Vector3DFloat(-0.888852f, -0.022370f, +0.215552f),
		Vector3DFloat(-0.737541f, -0.977783f, -0.506638f),
		Vector3DFloat(+0.471969f, +0.429670f, +0.668508f),
		Vector3DFloat(+0.240394f, -0.212500f, -0.026215f),
		Vector3DFloat(-0.916379f, -0.706229f, -0.593799f),
		Vector3DFloat(-0.246681f, +0.919736f, -0.984741f),
		Vector3DFloat(+0.291055f, -0.263771f, +0.703726f),
		Vector3DFloat(-0.468245f, -0.062777f, +0.808527f),
		Vector3DFloat(+0.661245f, +0.514817f, -0.715995f),
		Vector3DFloat(-0.709830f, -0.580920f, +0.323710f),
		Vector3DFloat(-0.463912f, -0.279092f, -0.101291f),
		Vector3DFloat(-0.426252f, -0.292520f, -0.523057f),
		Vector3DFloat(-0.285928f, -0.806574f, +0.701468f),
		Vector3DFloat(-0.216468f, +0.385968f, +0.031953f),
		Vector3DFloat(+0.737053f, +0.683767f, +0.684561f),
		Vector3DFloat(+0.080172f, -0.063753f, +0.526902f),
		Vector3DFloat(+0.414228f, +0.367351f, +0.884335f),
		Vector3DFloat(-0.460677f, -0.048189f, -0.403851f),
		Vector3DFloat(+0.973998f, +0.039399f, -0.148839f),
		Vector3DFloat(+0.578539f, -0.651173f, +0.859432f),
		Vector3DFloat(-0.172948f, +0.534593f, +0.255531f),
		Vector3DFloat(+0.537584f, -0.570116f, +0.317606f),
		Vector3DFloat(-0.380535f, +0.841548f, -0.274880f),
		Vector3DFloat(+0.627247f, +0.655507f, -0.813532f),
		Vector3DFloat(+0.288186f, +0.273171f, -0.674123f),
		Vector3DFloat(-0.489303f, +0.828913f, +0.552599f),
		Vector3DFloat(-0.541002f, +0.170019f, -0.242836f),
		Vector3DFloat(+0.802972f, +0.340190f, +0.414716f),
		Vector3DFloat(-0.997253f, -0.806635f, +0.588122f),
		Vector3DFloat(+0.011017f, -0.599109f, -0.183325f),
		Vector3DFloat(-0.871578f, -0.430708f, -0.042634f),
		Vector3DFloat(+0.144627f, -0.921751f, +0.142003f),
		Vector3DFloat(-0.695059f, -0.091037f, -0.647694f),
		Vector3DFloat(-0.346477f, +0.663381f, -0.528977f),
		Vector3DFloat(-0.194739f, +0.724967f, +0.615894f),
		Vector3DFloat(+0.741874f, +0.720695f, -0.544847f),
		Vector3DFloat(-0.984863f, +0.715445f, +0.461287f),
		Vector3DFloat(-0.277871f, +0.329936f, +0.678091f),
		Vector3DFloat(+0.090854f, +0.565905f, -0.254250f),
		Vector3DFloat(-0.844050f, +0.781915f, -0.783929f),
		Vector3DFloat(+0.332377f, -0.336528f, +0.820673f),
		Vector3DFloat(-0.673391f, +0.589953f, -0.685598f),
		Vector3DFloat(+0.022370f, +0.979980f, +0.686453f),
		Vector3DFloat(-0.640065f, +0.369488f, +0.022919f),
		Vector3DFloat(+0.699088f, -0.286355f, +0.684378f),
		Vector3DFloat(-0.702139f, -0.827754f, +0.528367f),
		Vector3DFloat(+0.150365f, -0.669851f, -0.695486f),
		Vector3DFloat(+0.885617f, +0.492416f, -0.964599f),
		Vector3DFloat(-0.923643f, -0.338847f, -0.369060f),
		Vector3DFloat(+0.009064f, +0.632435f, +0.628956f),
		Vector3DFloat(+0.620411f, +0.959777f, -0.769890f),
		Vector3DFloat(+0.865413f, +0.685659f, -0.149327f),
		Vector3DFloat(-0.933042f, +0.517258f, +0.168493f),
		Vector3DFloat(+0.309732f, +0.299417f, +0.995361f),
		Vector3DFloat(+0.196814f, -0.128025f, +0.565233f),
		Vector3DFloat(-0.343669f, +0.889157f, +0.616688f),
		Vector3DFloat(-0.676870f, +0.035432f, +0.906430f),
		Vector3DFloat(-0.238868f, +0.320475f, -0.307596f),
		Vector3DFloat(+0.164159f, +0.774468f, +0.502792f),
		Vector3DFloat(+0.733146f, +0.517563f, +0.572741f),
		Vector3DFloat(+0.676931f, -0.930235f, +0.231056f),
		Vector3DFloat(-0.640370f, +0.241127f, -0.518479f),
		Vector3DFloat(-0.953795f, +0.673086f, -0.706656f),
		Vector3DFloat(+0.538621f, -0.340495f, +0.202124f),
		Vector3DFloat(+0.431501f, +0.452315f, +0.422651f),
		Vector3DFloat(+0.935606f, -0.442793f, -0.087191f),
		Vector3DFloat(-0.921873f, -0.794733f, -0.003388f),
		Vector3DFloat(+0.978576f, +0.342814f, -0.813898f),
		Vector3DFloat(-0.750969f, +0.077853f, -0.849117f),
		Vector3DFloat(+0.416120f, +0.678030f, +0.187475f),
		Vector3DFloat(+0.370342f, -0.101901f, -0.544053f),
		Vector3DFloat(+0.248512f, +0.803766f, -0.654042f),
		Vector3DFloat(-0.925230f, +0.883480f, +0.287698f),
		Vector3DFloat(-0.861873f, -0.263771f, +0.476730f),
		Vector3DFloat(-0.298868f, -0.459517f, +0.932798f),
		Vector3DFloat(+0.680532f, +0.697928f, +0.761162f),
		Vector3DFloat(-0.466964f, -0.590625f, +0.972716f),
		Vector3DFloat(+0.400067f, -0.316507f, +0.385418f),
		Vector3DFloat(-0.123814f, -0.144444f, -0.161290f),
		Vector3DFloat(-0.703726f, +0.189489f, +0.250099f),
		Vector3DFloat(-0.766533f, -0.369854f, +0.871395f),
		Vector3DFloat(-0.561205f, -0.891415f, +0.247658f),
		Vector3DFloat(+0.590991f, +0.661489f, -0.996887f),
		Vector3DFloat(-0.244667f, +0.857723f, +0.402692f),
		Vector3DFloat(-0.574572f, -0.257790f, +0.561449f),
		Vector3DFloat(+0.020600f, -0.784173f, -0.057711f),
		Vector3DFloat(+0.735954f, +0.708487f, +0.913022f),
		Vector3DFloat(-0.615101f, -0.643666f, +0.350017f),
		Vector3DFloat(+0.436933f, +0.596423f, +0.985412f),
		Vector3DFloat(-0.167577f, +0.400555f, +0.914670f),
		Vector3DFloat(-0.920896f, -0.621570f, -0.637074f),
		Vector3DFloat(-0.020356f, -0.234657f, +0.460860f),
		Vector3DFloat(+0.336650f, -0.537767f, +0.907712f),
		Vector3DFloat(-0.138768f, +0.860653f, +0.093661f),
		Vector3DFloat(-0.733512f, -0.564196f, -0.046724f),
		Vector3DFloat(+0.058260f, -0.429060f, +0.150792f),
		Vector3DFloat(+0.255837f, -0.187780f, +0.312601f),
		Vector3DFloat(-0.050081f, +0.680105f, -0.609485f),
		Vector3DFloat(+0.075411f, +0.016511f, -0.127293f),
		Vector3DFloat(-0.735710f, -0.787957f, +0.992248f),
		Vector3DFloat(-0.191931f, +0.812311f, +0.681692f),
		Vector3DFloat(-0.284402f, -0.177160f, -0.533128f),
		Vector3DFloat(+0.859432f, +0.042940f, +0.404096f),
		Vector3DFloat(+0.599841f, +0.131260f, +0.313028f),
		Vector3DFloat(-0.955809f, -0.792474f, +0.086947f),
		Vector3DFloat(-0.980712f, -0.525498f, -0.539598f),
		Vector3DFloat(-0.877377f, -0.748222f, +0.590320f),
		Vector3DFloat(-0.822443f, -0.733634f, -0.529588f),
		Vector3DFloat(+0.379620f, -0.710013f, +0.038484f),
		Vector3DFloat(-0.826472f, -0.831050f, -0.645436f),
		Vector3DFloat(+0.160131f, -0.977050f, -0.502609f),
		Vector3DFloat(-0.818964f, +0.921567f, -0.011261f),
		Vector3DFloat(+0.932005f, -0.364727f, +0.023103f),
		Vector3DFloat(-0.923826f, -0.862300f, +0.680410f),
		Vector3DFloat(-0.298379f, +0.196936f, -0.486618f),
		Vector3DFloat(-0.281411f, -0.045747f, -0.252602f),
		Vector3DFloat(+0.706534f, +0.296976f, +0.672292f),
		Vector3DFloat(-0.543077f, +0.319376f, +0.238075f),
		Vector3DFloat(-0.501938f, +0.067293f, +0.119602f),
		Vector3DFloat(-0.740287f, -0.783197f, +0.407514f),
		Vector3DFloat(-0.933470f, -0.855098f, -0.503952f),
		Vector3DFloat(-0.574877f, -0.533067f, +0.525437f),
		Vector3DFloat(+0.785394f, -0.262612f, +0.571642f),
		Vector3DFloat(-0.659108f, -0.811396f, +0.264138f),
		Vector3DFloat(+0.926695f, -0.963622f, +0.121372f),
		Vector3DFloat(+0.505661f, -0.209815f, -0.439131f),
		Vector3DFloat(-0.433882f, +0.026887f, +0.928953f),
		Vector3DFloat(-0.771599f, +0.737785f, -0.288003f),
		Vector3DFloat(-0.894406f, +0.505905f, +0.971068f),
		Vector3DFloat(+0.350383f, +0.570421f, -0.211646f),
		Vector3DFloat(+0.644093f, -0.882748f, -0.131382f),
		Vector3DFloat(+0.225745f, +0.948973f, -0.488327f),
		Vector3DFloat(+0.277810f, -0.337748f, +0.322672f),
		Vector3DFloat(-0.686514f, +0.185766f, +0.752129f),
		Vector3DFloat(+0.350566f, +0.122959f, +0.722526f),
		Vector3DFloat(-0.687002f, +0.955260f, -0.955687f),
		Vector3DFloat(+0.958983f, -0.019074f, -0.317118f),
		Vector3DFloat(+0.076937f, -0.015839f, -0.772027f),
		Vector3DFloat(+0.899777f, -0.224647f, +0.174230f),
		Vector3DFloat(+0.805719f, -0.288797f, +0.742119f),
		Vector3DFloat(+0.964904f, -0.322794f, +0.416486f),
		Vector3DFloat(-0.485641f, -0.559130f, -0.500168f),
		Vector3DFloat(+0.310282f, +0.408185f, -0.946471f),
		Vector3DFloat(-0.279031f, +0.645131f, -0.118259f),
		Vector3DFloat(+0.780694f, -0.650136f, -0.433943f),
		Vector3DFloat(+0.981262f, +0.039521f, -0.532395f),
		Vector3DFloat(+0.830866f, +0.430769f, -0.333293f),
		Vector3DFloat(-0.462081f, -0.872799f, -0.070711f),
		Vector3DFloat(+0.276894f, -0.418683f, -0.198767f),
		Vector3DFloat(+0.217750f, +0.312662f, -0.725211f),
		Vector3DFloat(-0.193091f, -0.522752f, -0.901486f),
		Vector3DFloat(+0.040071f, -0.307291f, +0.622669f),
		Vector3DFloat(-0.788446f, -0.817438f, -0.566027f),
		Vector3DFloat(-0.947508f, -0.519822f, +0.143468f),
		Vector3DFloat(-0.072970f, -0.580920f, +0.925230f),
		Vector3DFloat(-0.072359f, +0.954772f, +0.980163f),
		Vector3DFloat(+0.954344f, -0.229774f, -0.562059f),
		Vector3DFloat(+0.095004f, +0.123020f, +0.103366f),
		Vector3DFloat(+0.784478f, -0.571764f, +0.774529f),
		Vector3DFloat(-0.113498f, -0.852229f, +0.422468f),
		Vector3DFloat(-0.128941f, -0.637196f, -0.590869f),
		Vector3DFloat(+0.603259f, -0.670766f, +0.303201f),
		Vector3DFloat(+0.693960f, +0.278542f, +0.171422f),
		Vector3DFloat(+0.801813f, +0.236671f, +0.195227f),
		Vector3DFloat(-0.193823f, +0.684072f, -0.594714f),
		Vector3DFloat(+0.715201f, +0.750725f, +0.591479f),
		Vector3DFloat(+0.698782f, +0.073214f, +0.106052f),
		Vector3DFloat(+0.803522f, -0.470809f, +0.279763f),
		Vector3DFloat(+0.099704f, +0.861385f, -0.397687f),
		Vector3DFloat(+0.230506f, -0.993286f, +0.054292f),
		Vector3DFloat(-0.292398f, +0.585376f, +0.762139f),
		Vector3DFloat(-0.168004f, +0.731132f, -0.020051f),
		Vector3DFloat(+0.577441f, +0.205359f, +0.703848f),
		Vector3DFloat(-0.869076f, +0.873653f, -0.802301f),
		Vector3DFloat(+0.697256f, +0.399335f, +0.842708f),
		Vector3DFloat(-0.590258f, -0.620777f, -0.628040f),
		Vector3DFloat(-0.048982f, +0.759697f, -0.957335f),
		Vector3DFloat(+0.026582f, +0.696402f, -0.537645f),
		Vector3DFloat(+0.919431f, +0.040254f, +0.931394f),
		Vector3DFloat(+0.308512f, +0.591052f, -0.194739f),
		Vector3DFloat(-0.934202f, +0.307718f, -0.688894f),
		Vector3DFloat(-0.285318f, +0.460860f, +0.757012f),
		Vector3DFloat(+0.048799f, -0.720389f, +0.325968f),
		Vector3DFloat(-0.202246f, +0.068697f, +0.641407f),
		Vector3DFloat(-0.566088f, +0.523301f, +0.857295f),
		Vector3DFloat(+0.040193f, -0.036836f, +0.699881f),
		Vector3DFloat(-0.789422f, -0.195959f, -0.217505f),
		Vector3DFloat(-0.836665f, +0.293741f, +0.418867f),
		Vector3DFloat(+0.489486f, +0.954344f, +0.486007f),
		Vector3DFloat(-0.755913f, -0.485153f, +0.253822f),
		Vector3DFloat(+0.823420f, -0.565722f, -0.393353f),
		Vector3DFloat(-0.817560f, +0.851436f, -0.368755f),
		Vector3DFloat(+0.004791f, -0.474899f, -0.299417f),
		Vector3DFloat(-0.012726f, +0.620289f, -0.555773f),
		Vector3DFloat(+0.197058f, -0.916318f, -0.469466f),
		Vector3DFloat(+0.243812f, +0.820734f, -0.694021f),
		Vector3DFloat(-0.896359f, -0.753716f, -0.676321f),
		Vector3DFloat(-0.761589f, -0.936033f, -0.154149f),
		Vector3DFloat(+0.821528f, +0.641224f, -0.188025f),
		Vector3DFloat(+0.799432f, +0.168981f, +0.571520f),
		Vector3DFloat(+0.309793f, -0.181005f, -0.565416f),
		Vector3DFloat(+0.211890f, -0.153539f, -0.473312f),
		Vector3DFloat(+0.284097f, +0.968444f, -0.005829f),
		Vector3DFloat(+0.835994f, +0.087374f, -0.599780f),
		Vector3DFloat(+0.068270f, -0.178930f, -0.439741f),
		Vector3DFloat(-0.455611f, +0.404218f, -0.862911f),
		Vector3DFloat(+0.754143f, +0.197058f, +0.762749f),
		Vector3DFloat(+0.053499f, -0.794549f, -0.285257f),
		Vector3DFloat(+0.176916f, +0.163121f, -0.941954f),
		Vector3DFloat(-0.102817f, -0.446944f, +0.830195f),
		Vector3DFloat(+0.970824f, -0.484848f, -0.661977f),
		Vector3DFloat(-0.561998f, -0.377544f, -0.955321f),
		Vector3DFloat(-0.434980f, +0.501022f, +0.627186f),
		Vector3DFloat(-0.828120f, +0.591540f, +0.701895f),
		Vector3DFloat(-0.327555f, +0.628346f, -0.159581f),
		Vector3DFloat(-0.082980f, -0.308084f, -0.077731f),
		Vector3DFloat(+0.858150f, -0.706473f, +0.886532f),
		Vector3DFloat(+0.526475f, +0.001373f, +0.438276f),
		Vector3DFloat(-0.594958f, +0.084994f, -0.935057f),
		Vector3DFloat(+0.783746f, -0.501877f, -0.797052f),
		Vector3DFloat(-0.835566f, -0.808405f, +0.956359f),
		Vector3DFloat(+0.380169f, +0.184118f, +0.857540f),
		Vector3DFloat(+0.647206f, +0.652089f, -0.895383f),
		Vector3DFloat(-0.421369f, -0.038667f, +0.500046f),
		Vector3DFloat(-0.478133f, +0.447432f, +0.981750f),
		Vector3DFloat(+0.593921f, -0.330485f, -0.966674f),
		Vector3DFloat(-0.811823f, +0.928892f, -0.741935f),
		Vector3DFloat(+0.115879f, -0.490707f, -0.080355f),
		Vector3DFloat(+0.443159f, +0.030061f, -0.465560f),
		Vector3DFloat(+0.013703f, -0.765435f, -0.311502f),
		Vector3DFloat(+0.698782f, -0.612903f, +0.660207f),
		Vector3DFloat(+0.341227f, -0.746940f, +0.284341f),
		Vector3DFloat(-0.005036f, -0.863460f, -0.168432f),
		Vector3DFloat(-0.434370f, -0.629933f, +0.545152f),
		Vector3DFloat(-0.570544f, +0.023591f, +0.072970f),
		Vector3DFloat(+0.709830f, +0.603626f, +0.031831f),
		Vector3DFloat(-0.148961f, +0.783807f, -0.292154f),
		Vector3DFloat(+0.088107f, -0.467818f, +0.319498f),
		Vector3DFloat(+0.976623f, -0.185339f, +0.274087f),
		Vector3DFloat(+0.770867f, +0.267861f, -0.022004f),
		Vector3DFloat(-0.245338f, +0.171056f, -0.720389f),
		Vector3DFloat(-0.909299f, +0.616993f, -0.950926f),
		Vector3DFloat(+0.050935f, -0.842341f, -0.519944f),
		Vector3DFloat(+0.646779f, +0.560839f, +0.129673f),
		Vector3DFloat(-0.171361f, -0.501328f, -0.762749f),
		Vector3DFloat(-0.374065f, -0.905209f, -0.561144f),
		Vector3DFloat(-0.811029f, -0.510483f, -0.757073f),
		Vector3DFloat(-0.905332f, -0.027924f, -0.263649f),
		Vector3DFloat(-0.828730f, -0.067721f, -0.295206f),
		Vector3DFloat(-0.538133f, +0.242714f, +0.914914f),
		Vector3DFloat(-0.657949f, -0.732658f, -0.743584f),
		Vector3DFloat(+0.837214f, -0.077181f, +0.767449f),
		Vector3DFloat(+0.174047f, +0.397687f, +0.602405f),
		Vector3DFloat(-0.256996f, +0.911435f, -0.927915f),
		Vector3DFloat(+0.282754f, +0.500900f, +0.510178f),
		Vector3DFloat(+0.849971f, +0.652821f, +0.002838f),
		Vector3DFloat(-1.000000f, -0.103305f, -0.548814f),
		Vector3DFloat(-0.673208f, -0.734489f, +0.204749f),
		Vector3DFloat(-0.235511f, -0.977477f, -0.771538f),
		Vector3DFloat(+0.294412f, +0.173009f, -0.075533f),
		Vector3DFloat(-0.339946f, -0.970946f, -0.443525f),
		Vector3DFloat(-0.016144f, -0.066134f, -0.394635f),
		Vector3DFloat(-0.627003f, +0.683401f, -0.967101f),
		Vector3DFloat(-0.217994f, -0.777642f, -0.404584f),
		Vector3DFloat(+0.123447f, -0.590747f, +0.507614f),
		Vector3DFloat(+0.648610f, +0.006806f, -0.677969f),
		Vector3DFloat(+0.006561f, +0.662648f, -0.236305f),
		Vector3DFloat(+0.658132f, +0.166173f, -0.283975f),
		Vector3DFloat(-0.098178f, +0.665273f, -0.068636f),
		Vector3DFloat(-0.091891f, +0.319620f, +0.058870f),
		Vector3DFloat(+0.922666f, +0.077731f, +0.399701f),
		Vector3DFloat(-0.007050f, +0.772942f, -0.957945f),
		Vector3DFloat(-0.456832f, -0.293313f, +0.437300f),
		Vector3DFloat(+0.917173f, -0.542100f, +0.909665f),
		Vector3DFloat(-0.711722f, -0.917356f, +0.513169f),
		Vector3DFloat(-0.032624f, +0.808100f, +0.354472f),
		Vector3DFloat(-0.526597f, -0.049409f, +0.691702f),
		Vector3DFloat(-0.073946f, +0.923521f, -0.389813f),
		Vector3DFloat(+0.172216f, +0.642140f, -0.302896f),
		Vector3DFloat(-0.660024f, +0.381329f, -0.833064f),
		Vector3DFloat(+0.622791f, -0.809076f, +0.557787f),
		Vector3DFloat(+0.609790f, +0.897702f, +0.998352f),
		Vector3DFloat(-0.084384f, +0.169042f, -0.596667f),
		Vector3DFloat(-0.315470f, -0.014618f, -0.640187f),
		Vector3DFloat(+0.275552f, -0.199438f, -0.759941f),
		Vector3DFloat(-0.615223f, -0.960021f, +0.367901f),
		Vector3DFloat(+0.819514f, -0.787225f, +0.627308f),
		Vector3DFloat(+0.083834f, -0.836299f, +0.926450f),
		Vector3DFloat(-0.420637f, -0.047273f, +0.370281f),
		Vector3DFloat(-0.097629f, -0.240577f, -0.594836f),
		Vector3DFloat(+0.085604f, +0.385601f, -0.121189f),
		Vector3DFloat(+0.968444f, -0.255104f, +0.021027f),
		Vector3DFloat(+0.152440f, -0.450484f, +0.971496f),
		Vector3DFloat(-0.095737f, +0.395672f, -0.605213f),
		Vector3DFloat(+0.949278f, -0.284951f, +0.875118f),
		Vector3DFloat(+0.787286f, +0.580248f, +0.494613f),
		Vector3DFloat(+0.225990f, -0.455123f, +0.239540f),
		Vector3DFloat(+0.630238f, -0.251747f, -0.617725f),
		Vector3DFloat(+0.940733f, -0.390484f, +0.394024f),
		Vector3DFloat(+0.197851f, -0.276345f, -0.893368f),
		Vector3DFloat(-0.240883f, +0.349651f, -0.922178f),
		Vector3DFloat(-0.037080f, -0.609119f, -0.018342f),
		Vector3DFloat(-0.787042f, +0.624500f, -0.274880f),
		Vector3DFloat(-0.536485f, +0.989746f, -0.400128f),
		Vector3DFloat(+0.963988f, +0.006012f, +0.323649f),
		Vector3DFloat(-0.501022f, -0.791864f, +0.514817f),
		Vector3DFloat(-0.126316f, -0.782769f, +0.155553f),
		Vector3DFloat(-0.254921f, +0.828547f, -0.173925f),
		Vector3DFloat(-0.321512f, -0.180822f, +0.603198f),
		Vector3DFloat(+0.733757f, -0.407514f, +0.170385f),
		Vector3DFloat(-0.741691f, -0.322611f, -0.070956f),
		Vector3DFloat(-0.025300f, +0.454329f, -0.889767f),
		Vector3DFloat(+0.024751f, +0.133518f, -0.246498f),
		Vector3DFloat(+0.545701f, -0.260842f, +0.869747f),
		Vector3DFloat(+0.082247f, -0.579638f, -0.885495f),
		Vector3DFloat(-0.000885f, -0.834346f, +0.040254f),
		Vector3DFloat(-0.211097f, -0.059297f, +0.747856f),
		Vector3DFloat(-0.829646f, +0.475753f, +0.527451f),
		Vector3DFloat(+0.409162f, -0.167882f, -0.177099f),
		Vector3DFloat(-0.319865f, -0.205664f, -0.130222f),
		Vector3DFloat(+0.962523f, -0.992615f, +0.062655f),
		Vector3DFloat(+0.849361f, -0.935301f, +0.394024f),
		Vector3DFloat(+0.373699f, -0.148350f, +0.208594f),
		Vector3DFloat(+0.639332f, +0.220557f, -0.277444f),
		Vector3DFloat(+0.880734f, +0.209937f, -0.576708f),
		Vector3DFloat(+0.342814f, +0.416364f, -0.832453f),
		Vector3DFloat(+0.594958f, +0.479843f, -0.306070f),
		Vector3DFloat(+0.335002f, -0.107334f, +0.784173f),
		Vector3DFloat(+0.395917f, +0.763604f, +0.866756f),
		Vector3DFloat(-0.507553f, +0.148717f, -0.436750f),
		Vector3DFloat(-0.780450f, -0.599048f, -0.146031f),
		Vector3DFloat(-0.841304f, -0.712577f, -0.329997f),
		Vector3DFloat(+0.524033f, +0.033845f, +0.057100f),
		Vector3DFloat(-0.976562f, -0.066866f, +0.026887f),
		Vector3DFloat(-0.469405f, -0.094394f, +0.398175f),
		Vector3DFloat(+0.238685f, -0.750237f, +0.156713f),
		Vector3DFloat(+0.000702f, +0.617298f, -0.206397f),
		Vector3DFloat(-0.228553f, +0.562548f, -0.719840f),
		Vector3DFloat(-0.939451f, -0.698782f, +0.688162f),
		Vector3DFloat(+0.637623f, +0.149022f, -0.536058f),
		Vector3DFloat(-0.814386f, +0.379315f, +0.647145f),
		Vector3DFloat(+0.523179f, -0.820368f, +0.386517f),
		Vector3DFloat(+0.146092f, +0.999146f, +0.227332f),
		Vector3DFloat(-0.366924f, -0.211707f, +0.274697f),
		Vector3DFloat(+0.751640f, +0.136509f, +0.662648f),
		Vector3DFloat(+0.657888f, +0.102695f, +0.022736f),
		Vector3DFloat(+0.861019f, -0.535813f, +0.561449f),
		Vector3DFloat(+0.766839f, +0.006317f, +0.681204f),
		Vector3DFloat(+0.596301f, +0.671255f, -0.933470f),
		Vector3DFloat(+0.776910f, -0.313211f, -0.353923f),
		Vector3DFloat(+0.266213f, +0.215796f, +0.026093f),
		Vector3DFloat(-0.648732f, +0.907407f, -0.755425f),
		Vector3DFloat(-0.585498f, -0.234535f, -0.085421f),
		Vector3DFloat(-0.490890f, +0.657582f, +0.242897f),
		Vector3DFloat(+0.913450f, +0.066622f, -0.220252f),
		Vector3DFloat(+0.121067f, +0.658193f, -0.645314f),
		Vector3DFloat(+0.367779f, +0.941588f, +0.618702f),
		Vector3DFloat(-0.320231f, +0.354900f, -0.653005f),
		Vector3DFloat(+0.540147f, -0.212317f, +0.559374f),
		Vector3DFloat(+0.715812f, -0.211951f, +0.078646f),
		Vector3DFloat(-0.711051f, +0.598132f, -0.708914f),
		Vector3DFloat(+0.029756f, +0.324809f, +0.014924f),
		Vector3DFloat(-0.106418f, +0.386090f, +0.596301f),
		Vector3DFloat(-0.317179f, -0.068880f, -0.315165f),
		Vector3DFloat(+0.860164f, -0.772881f, -0.158788f),
		Vector3DFloat(-0.326640f, -0.304239f, +0.445906f),
		Vector3DFloat(+0.621265f, -0.815729f, +0.129429f),
		Vector3DFloat(+0.687063f, -0.052767f, -0.969481f),
		Vector3DFloat(-0.800043f, -0.598621f, +0.764702f),
		Vector3DFloat(-0.518052f, -0.221534f, -0.066256f),
		Vector3DFloat(+0.164953f, +0.886898f, +0.954100f),
		Vector3DFloat(-0.384808f, -0.641102f, -1.000000f),
		Vector3DFloat(+0.299051f, +0.218360f, +0.561205f),
		Vector3DFloat(-0.419050f, +0.324992f, -0.161779f),
		Vector3DFloat(-0.403241f, -0.176305f, +0.442976f),
		Vector3DFloat(+0.262001f, +0.042817f, -0.818842f),
		Vector3DFloat(+0.740410f, +0.888852f, -0.281716f),
		Vector3DFloat(-0.853084f, +0.886227f, -0.736442f),
		Vector3DFloat(-0.666616f, +0.555956f, +0.477950f),
		Vector3DFloat(-0.714164f, +0.112156f, -0.032197f),
		Vector3DFloat(+0.142674f, -0.842341f, +0.199744f),
		Vector3DFloat(-0.305948f, -0.295999f, +0.131504f),
		Vector3DFloat(+0.667470f, -0.966674f, +0.728629f),
		Vector3DFloat(+0.122166f, +0.928281f, -0.725028f),
		Vector3DFloat(-0.236854f, -0.756096f, +0.374798f),
		Vector3DFloat(+0.035432f, -0.423505f, -0.663747f),
		Vector3DFloat(+0.051973f, -0.510910f, +0.716849f),
		Vector3DFloat(+0.540208f, -0.821711f, +0.055757f),
		Vector3DFloat(+0.699149f, +0.988098f, +0.326579f),
		Vector3DFloat(+0.108188f, -0.867367f, +0.668996f),
		Vector3DFloat(+0.077181f, -0.738884f, +0.103671f),
		Vector3DFloat(-0.467391f, +0.957335f, -0.194494f),
		Vector3DFloat(+0.123386f, +0.893674f, -0.523118f),
		Vector3DFloat(-0.151036f, +0.955809f, +0.199622f),
		Vector3DFloat(+0.075411f, +0.726493f, -0.363994f),
		Vector3DFloat(+0.224647f, -0.208960f, +0.242531f),
		Vector3DFloat(+0.993591f, +0.751213f, -0.535203f),
		Vector3DFloat(+0.308512f, +0.990905f, -0.197241f),
		Vector3DFloat(+0.292886f, +0.536180f, +0.191748f),
		Vector3DFloat(+0.489853f, -0.461531f, +0.351665f),
		Vector3DFloat(-0.329447f, +0.531602f, +0.216834f),
		Vector3DFloat(-0.809320f, +0.675649f, +0.516037f),
		Vector3DFloat(+0.565172f, -0.661184f, +0.359111f),
		Vector3DFloat(-0.039460f, +0.110080f, +0.978698f),
		Vector3DFloat(+0.885372f, -0.763787f, +0.145726f),
		Vector3DFloat(+0.006195f, +0.231117f, +0.417585f),
		Vector3DFloat(-0.566027f, +0.179846f, -0.010407f),
		Vector3DFloat(-0.879391f, +0.940123f, +0.163305f),
		Vector3DFloat(+0.490646f, +0.391949f, +0.415998f),
		Vector3DFloat(-0.973815f, +0.550096f, +0.710868f),
		Vector3DFloat(+0.643544f, +0.763543f, +0.160375f),
		Vector3DFloat(-0.832759f, +0.150792f, -0.602466f),
		Vector3DFloat(-0.564745f, -0.121982f, +0.213172f),
		Vector3DFloat(-0.775750f, +0.120640f, +0.703970f),
		Vector3DFloat(+0.952208f, -0.233375f, +0.984619f),
		Vector3DFloat(+0.330241f, +0.344707f, -0.002472f),
		Vector3DFloat(-0.601489f, +0.772454f, +0.954527f),
		Vector3DFloat(-0.605335f, +0.422590f, -0.629261f),
		Vector3DFloat(+0.199011f, +0.389996f, -0.293069f),
		Vector3DFloat(-0.664479f, +0.964110f, -0.223731f),
		Vector3DFloat(-0.477340f, +0.905515f, +0.378521f),
		Vector3DFloat(-0.366741f, +0.233497f, +0.181860f),
		Vector3DFloat(-0.438826f, -0.664724f, +0.521653f),
		Vector3DFloat(-0.298990f, +0.153844f, -0.795587f),
		Vector3DFloat(+0.679983f, -0.192114f, +0.451033f),
		Vector3DFloat(-0.630360f, +0.283303f, +0.892270f),
		Vector3DFloat(+0.940489f, +0.396222f, +0.550890f),
		Vector3DFloat(-0.448653f, +0.065889f, -0.753105f),
		Vector3DFloat(+0.712821f, +0.740410f, +0.025178f),
		Vector3DFloat(-0.862606f, +0.692923f, +0.973937f),
		Vector3DFloat(-0.583789f, +0.849544f, -0.579455f),
		Vector3DFloat(+0.640675f, +0.542711f, +0.062960f),
		Vector3DFloat(-0.916196f, +0.493881f, +0.192602f),
		Vector3DFloat(+0.270119f, +0.636525f, +0.380108f),
		Vector3DFloat(-0.297952f, -0.165502f, +0.871578f),
		Vector3DFloat(-0.731132f, -0.883175f, +0.756951f),
		Vector3DFloat(+0.373760f, +0.645436f, -0.736503f),
		Vector3DFloat(-0.289407f, +0.663259f, +0.329142f),
		Vector3DFloat(+0.544115f, +0.908933f, -0.156713f),
		Vector3DFloat(+0.780816f, +0.264870f, -0.632984f),
		Vector3DFloat(-0.935667f, +0.959899f, -0.686148f),
		Vector3DFloat(+0.121250f, -0.882687f, -0.204260f),
		Vector3DFloat(-0.002106f, -0.032807f, -0.532334f),
		Vector3DFloat(+0.334208f, -0.147862f, -0.719474f),
		Vector3DFloat(-0.956114f, +0.622791f, -0.764702f),
		Vector3DFloat(+0.482162f, -0.907651f, +0.396100f),
		Vector3DFloat(-0.477645f, +0.710196f, -0.589221f),
		Vector3DFloat(-0.374676f, -0.293008f, -0.738578f),
		Vector3DFloat(+0.273232f, -0.007050f, +0.227454f),
		Vector3DFloat(-0.634449f, -0.640675f, -0.644276f),
		Vector3DFloat(-0.173315f, +0.852840f, -0.000580f),
		Vector3DFloat(+0.258766f, +0.261086f, -0.720450f),
		Vector3DFloat(+0.048921f, +0.562609f, +0.668569f),
		Vector3DFloat(+0.072970f, -0.296182f, -0.753594f),
		Vector3DFloat(+0.409528f, -0.742302f, -0.429365f),
		Vector3DFloat(-0.551012f, +0.193579f, -0.672414f),
		Vector3DFloat(-0.698111f, -0.188940f, +0.302896f),
		Vector3DFloat(-0.176366f, +0.111606f, +0.180273f),
		Vector3DFloat(-0.273537f, -0.817988f, -0.519028f),
		Vector3DFloat(+0.742546f, -0.983154f, -0.585864f),
		Vector3DFloat(-0.631031f, +0.641469f, +0.681936f),
		Vector3DFloat(+0.181127f, +0.238929f, -0.851680f),
		Vector3DFloat(-0.075655f, -0.175085f, +0.213904f),
		Vector3DFloat(-0.554369f, -0.458724f, -0.080172f),
		Vector3DFloat(-0.326273f, +0.086398f, -0.203162f),
		Vector3DFloat(+0.905332f, +0.605762f, +0.191443f),
		Vector3DFloat(-0.920835f, -0.636525f, -0.977844f),
		Vector3DFloat(-0.552110f, +0.156102f, +0.504135f),
		Vector3DFloat(-0.243934f, +0.970763f, -0.160070f),
		Vector3DFloat(+0.418195f, -0.050996f, +0.090060f),
		Vector3DFloat(+0.875729f, -0.335307f, +0.542589f),
		Vector3DFloat(-0.873226f, -0.135777f, +0.750908f),
		Vector3DFloat(+0.086032f, -0.780999f, +0.032624f),
		Vector3DFloat(-0.929746f, +0.173376f, -0.738212f),
		Vector3DFloat(+0.665639f, -0.140172f, +0.821223f),
		Vector3DFloat(-0.977416f, +0.008698f, +0.739372f),
		Vector3DFloat(-0.899045f, +0.494980f, -0.542833f),
		Vector3DFloat(+0.395062f, -0.662465f, +0.553148f),
		Vector3DFloat(-0.157689f, +0.970824f, +0.186377f),
		Vector3DFloat(+0.969970f, -0.372051f, +0.728263f),
		Vector3DFloat(+0.902463f, +0.860225f, -0.170141f),
		Vector3DFloat(+0.539415f, +0.112949f, -0.387066f),
		Vector3DFloat(-0.530259f, +0.773553f, -0.593554f),
		Vector3DFloat(-0.626392f, +0.377483f, +0.141209f),
		Vector3DFloat(-0.949278f, -0.859554f, -0.846858f),
		Vector3DFloat(-0.942442f, +0.152562f, -0.463973f),
		Vector3DFloat(-0.897763f, -0.911557f, +0.570482f),
		Vector3DFloat(+0.317179f, -0.045076f, -0.960204f),
		Vector3DFloat(+0.895077f, -0.314066f, +0.184240f),
		Vector3DFloat(-0.744621f, -0.192602f, -0.536485f),
		Vector3DFloat(-0.266274f, +0.682974f, -0.871090f),
		Vector3DFloat(-0.809748f, -0.032258f, +0.273232f),
		Vector3DFloat(-0.124363f, -0.786309f, +0.657216f),
		Vector3DFloat(-0.726981f, -0.371563f, -0.172521f),
		Vector3DFloat(+0.812860f, -0.024384f, +0.532212f),
		Vector3DFloat(+0.523545f, -0.821589f, -0.509934f),
		Vector3DFloat(+0.236671f, +0.420148f, -0.802911f),
		Vector3DFloat(+0.093783f, -0.909177f, -0.071932f),
		Vector3DFloat(+0.262429f, +0.728141f, -0.095798f),
		Vector3DFloat(+0.717826f, +0.067171f, -0.797784f),
		Vector3DFloat(-0.413678f, +0.049593f, -0.137364f),
		Vector3DFloat(-0.334391f, +0.978515f, +0.529893f),
		Vector3DFloat(-0.559862f, +0.913511f, +0.188513f),
		Vector3DFloat(-0.644642f, -0.352214f, +0.085849f),
		Vector3DFloat(-0.257302f, +0.108371f, -0.744804f),
		Vector3DFloat(-0.676015f, +0.866207f, -0.834712f),
		Vector3DFloat(-0.021882f, -0.053072f, -0.795160f),
		Vector3DFloat(-0.219214f, +0.475448f, -0.291055f),
		Vector3DFloat(-0.698721f, -0.089816f, -0.867977f),
		Vector3DFloat(-0.297403f, +0.136876f, +0.832881f),
		Vector3DFloat(+0.438887f, +0.468001f, -0.946959f),
		Vector3DFloat(+0.638905f, +0.782952f, -0.127903f),
		Vector3DFloat(+0.363811f, -0.358745f, +0.460494f),
		Vector3DFloat(+0.320109f, -0.028047f, -0.223365f),
		Vector3DFloat(-0.274758f, -0.139256f, +0.302469f),
		Vector3DFloat(-0.943297f, -0.316263f, +0.749382f),
		Vector3DFloat(+0.863704f, -0.867183f, -0.148473f),
		Vector3DFloat(+0.030122f, +0.751030f, -0.963439f),
		Vector3DFloat(-0.818232f, -0.299966f, +0.403485f),
		Vector3DFloat(-0.841548f, +0.378826f, -0.981689f),
		Vector3DFloat(+0.927671f, +0.527696f, +0.309549f),
		Vector3DFloat(+0.521897f, +0.299844f, -0.545579f),
		Vector3DFloat(+0.324992f, +0.310648f, +0.759880f),
		Vector3DFloat(+0.599170f, -0.695303f, +0.165380f),
		Vector3DFloat(+0.708914f, +0.528916f, -0.764336f),
		Vector3DFloat(+0.059297f, -0.576586f, +0.825312f),
		Vector3DFloat(+0.139805f, +0.627247f, -0.101657f),
		Vector3DFloat(+0.805414f, +0.160619f, +0.154210f),
		Vector3DFloat(+0.131443f, +0.918393f, -0.376629f),
		Vector3DFloat(-0.354289f, +0.161534f, +0.880612f),
		Vector3DFloat(+0.880184f, +0.543138f, -0.826594f),
		Vector3DFloat(-0.388714f, +0.751946f, +0.645680f),
		Vector3DFloat(-0.018586f, -0.968078f, -0.617969f),
		Vector3DFloat(+0.802057f, -0.795648f, +0.790704f),
		Vector3DFloat(+0.311075f, -0.065828f, +0.444746f),
		Vector3DFloat(-0.024201f, -0.412152f, +0.955382f),
		Vector3DFloat(+0.783868f, +0.879452f, +0.727409f),
		Vector3DFloat(-0.854427f, -0.093844f, +0.874935f),
		Vector3DFloat(-0.670522f, -0.453780f, +0.165014f),
		Vector3DFloat(-0.530381f, +0.169836f, +0.937071f),
		Vector3DFloat(+0.902158f, +0.596423f, +0.575976f),
		Vector3DFloat(+0.957152f, -0.666372f, -0.794610f),
		Vector3DFloat(+0.901425f, -0.066378f, -0.684988f),
		Vector3DFloat(+0.219581f, -0.090426f, -0.020356f),
		Vector3DFloat(+0.297342f, +0.915708f, -0.119419f),
		Vector3DFloat(+0.923887f, -0.212622f, +0.793695f),
		Vector3DFloat(-0.747124f, -0.364666f, -0.375591f),
		Vector3DFloat(-0.003021f, -0.386944f, +0.304849f),
		Vector3DFloat(-0.614368f, +0.345805f, +0.845210f),
		Vector3DFloat(+0.245827f, -0.766961f, +0.046358f),
		Vector3DFloat(-0.746818f, +0.777642f, -0.485580f),
		Vector3DFloat(+0.138524f, +0.468673f, -0.247108f),
		Vector3DFloat(-0.569628f, -0.256020f, -0.044465f),
		Vector3DFloat(-0.707572f, +0.080599f, +0.177892f),
		Vector3DFloat(+0.925657f, -0.710807f, +0.201453f),
		Vector3DFloat(+0.986267f, +0.476547f, +0.244362f),
		Vector3DFloat(-0.092746f, -0.028718f, -0.235450f),
		Vector3DFloat(-0.001740f, +0.748466f, +0.268288f),
		Vector3DFloat(-0.974181f, -0.081942f, -0.602161f),
		Vector3DFloat(+0.534898f, -0.743217f, -0.895077f),
		Vector3DFloat(-0.720573f, -0.683096f, -0.631825f),
		Vector3DFloat(+0.183569f, -0.549913f, -0.348125f),
		Vector3DFloat(+0.623341f, -0.764275f, -0.951964f),
		Vector3DFloat(+0.973693f, -0.825251f, -0.558580f),
		Vector3DFloat(+0.620350f, +0.380169f, +0.510849f),
		Vector3DFloat(+0.989074f, +0.641774f, +0.327128f),
		Vector3DFloat(+0.624805f, +0.817988f, +0.537339f),
		Vector3DFloat(+0.809870f, -0.280984f, +0.755486f),
		Vector3DFloat(+0.521531f, -0.903928f, -0.742851f),
		Vector3DFloat(-0.389325f, -0.433699f, -0.928343f),
		Vector3DFloat(+0.176366f, -0.211768f, -0.189428f),
		Vector3DFloat(-0.737602f, -0.928159f, -0.016449f),
		Vector3DFloat(+0.723380f, -0.405866f, +0.167211f),
		Vector3DFloat(+0.523301f, -0.666372f, -0.046480f),
		Vector3DFloat(-0.118259f, +0.912290f, -0.160985f),
		Vector3DFloat(+0.611927f, -0.191748f, +0.149998f),
		Vector3DFloat(+0.905881f, -0.424482f, +0.913816f),
		Vector3DFloat(-0.620411f, -0.027131f, +0.923276f),
		Vector3DFloat(+0.774957f, -0.569140f, +0.871944f),
		Vector3DFloat(-0.804193f, +0.661061f, +0.820795f),
		Vector3DFloat(+0.077059f, -0.102023f, +0.278054f),
		Vector3DFloat(+0.772637f, -0.104831f, -0.823847f),
		Vector3DFloat(+0.983947f, +0.818659f, -0.089267f),
		Vector3DFloat(+0.735221f, -0.709586f, -0.454268f),
		Vector3DFloat(+0.996643f, -0.944945f, -0.538316f),
		Vector3DFloat(+0.049165f, -0.796014f, +0.971374f),
		Vector3DFloat(-0.976623f, +0.655263f, -0.156163f),
		Vector3DFloat(+0.681143f, -0.005585f, +0.476547f),
		Vector3DFloat(-0.928159f, +0.237648f, -0.346538f),
		Vector3DFloat(+0.361003f, -0.709586f, +0.595325f),
		Vector3DFloat(-0.345927f, +0.798700f, -0.321390f),
		Vector3DFloat(-0.731803f, -0.701346f, -0.652272f),
		Vector3DFloat(+0.164708f, -0.335795f, -0.213599f),
		Vector3DFloat(-0.857601f, +0.151463f, +0.157689f),
		Vector3DFloat(-0.754692f, -0.954283f, +0.308939f),
		Vector3DFloat(-0.037446f, -0.637562f, -0.991150f),
		Vector3DFloat(+0.744987f, -0.130894f, -0.575610f),
		Vector3DFloat(-0.799249f, -0.131687f, +0.906247f),
		Vector3DFloat(+0.580004f, +0.468734f, -0.745232f),
		Vector3DFloat(+0.991882f, +0.138401f, +0.694693f),
		Vector3DFloat(+0.830195f, +0.634877f, +0.715140f),
		Vector3DFloat(+0.607532f, -0.317972f, -0.250710f),
		Vector3DFloat(+0.037629f, -0.384320f, +0.812922f),
		Vector3DFloat(+0.645009f, +0.224036f, -0.778924f),
		Vector3DFloat(-0.852779f, -0.743522f, +0.346843f),
		Vector3DFloat(+0.578478f, -0.894955f, -0.327616f),
		Vector3DFloat(-0.905759f, -0.239296f, -0.945799f),
		Vector3DFloat(+0.028352f, -0.658254f, -0.705313f),
		Vector3DFloat(+0.954405f, +0.825434f, -0.553575f),
		Vector3DFloat(-0.471480f, +0.504440f, -0.262856f),
		Vector3DFloat(-0.924131f, +0.393353f, +0.106967f),
		Vector3DFloat(-0.032685f, +0.385846f, -0.877255f),
		Vector3DFloat(-0.039094f, +0.220557f, +0.356731f),
		Vector3DFloat(+0.490890f, -0.403790f, -0.650624f),
		Vector3DFloat(-0.896115f, -0.866817f, -0.837825f),
		Vector3DFloat(-0.260842f, -0.027558f, +0.511582f),
		Vector3DFloat(+0.782037f, +0.493759f, +0.229835f),
		Vector3DFloat(+0.086337f, -0.713431f, +0.484664f),
		Vector3DFloat(+0.168615f, -0.742058f, +0.639637f),
		Vector3DFloat(+0.325968f, -0.567919f, -0.359294f),
		Vector3DFloat(-0.633717f, -0.662709f, +0.374615f),
		Vector3DFloat(+0.230995f, -0.701041f, +0.557970f),
		Vector3DFloat(-0.729911f, -0.967650f, +0.951170f),
		Vector3DFloat(-0.126011f, -0.819819f, -0.299539f),
		Vector3DFloat(-0.166540f, +0.321024f, -0.704398f),
		Vector3DFloat(+0.769890f, -0.977111f, -0.374187f),
		Vector3DFloat(+0.562120f, +0.025300f, +0.299234f),
		Vector3DFloat(+0.048189f, +0.404462f, -0.420026f),
		Vector3DFloat(-0.840632f, +0.586291f, +0.360515f),
		Vector3DFloat(+0.223792f, +0.024140f, +0.607593f),
		Vector3DFloat(-0.562120f, +0.602771f, +0.948302f),
		Vector3DFloat(+0.968627f, -0.994263f, -0.206030f),
		Vector3DFloat(+0.146886f, -0.315287f, +0.034455f),
		Vector3DFloat(+0.836848f, -0.348613f, +0.213904f),
		Vector3DFloat(+0.494980f, -0.216041f, +0.405927f),
		Vector3DFloat(-0.584338f, -0.268715f, -0.165258f),
		Vector3DFloat(+0.118686f, -0.751091f, -0.381817f),
		Vector3DFloat(-0.887753f, +0.178686f, -0.730216f),
		Vector3DFloat(-0.684194f, -0.351543f, +0.952330f),
		Vector3DFloat(-0.006256f, -0.564562f, +0.137974f),
		Vector3DFloat(-0.229408f, +0.182470f, +0.427168f),
		Vector3DFloat(+0.024445f, +0.920713f, +0.119724f),
		Vector3DFloat(-0.996948f, -0.518784f, -0.045991f),
		Vector3DFloat(-0.062166f, -0.592090f, +0.849117f),
		Vector3DFloat(-0.377422f, -0.942808f, -0.649770f),
		Vector3DFloat(+0.093478f, -0.242470f, -0.198096f),
		Vector3DFloat(-0.594348f, -0.156102f, +0.401105f),
		Vector3DFloat(-0.746574f, -0.294351f, +0.577685f),
		Vector3DFloat(+0.504929f, +0.405194f, +0.724296f),
		Vector3DFloat(-0.489059f, -0.492294f, +0.680288f),
		Vector3DFloat(-0.025971f, -0.241127f, +0.103977f),
		Vector3DFloat(+0.875301f, -0.574206f, -0.671804f),
		Vector3DFloat(-0.483444f, +0.592029f, -0.537339f),
		Vector3DFloat(+0.504257f, -0.413984f, -0.779839f),
		Vector3DFloat(+0.182043f, -0.805292f, +0.988403f),
		Vector3DFloat(+0.533372f, -0.142064f, +0.793512f),
		Vector3DFloat(-0.105380f, -0.039338f, -0.624317f),
		Vector3DFloat(+0.125950f, +0.384259f, +0.596973f),
		Vector3DFloat(+0.452071f, +0.039216f, +0.924802f),
		Vector3DFloat(-0.986694f, +0.452498f, +0.199194f),
		Vector3DFloat(+0.230323f, +0.931516f, -0.380596f),
		Vector3DFloat(+0.657277f, +0.811945f, -0.176733f),
		Vector3DFloat(-0.477767f, -0.251137f, -0.468734f),
		Vector3DFloat(+0.499252f, +0.543260f, +0.886898f),
		Vector3DFloat(-0.528855f, +0.747124f, -0.789300f),
		Vector3DFloat(-0.188330f, +0.434675f, -0.915891f),
		Vector3DFloat(-0.807733f, +0.861080f, +0.386029f),
		Vector3DFloat(-0.314615f, +0.761223f, -0.177953f),
		Vector3DFloat(-0.855098f, +0.549486f, +0.547227f),
		Vector3DFloat(-0.072970f, +0.647816f, -0.034089f),
		Vector3DFloat(+0.385784f, +0.557482f, -0.912534f),
		Vector3DFloat(-0.654530f, -0.923032f, -0.783624f),
		Vector3DFloat(-0.755425f, -0.523789f, -0.132725f),
		Vector3DFloat(+0.333781f, +0.322733f, +0.267678f),
		Vector3DFloat(-0.533982f, -0.534471f, -0.399884f),
		Vector3DFloat(-0.953673f, -0.589465f, +0.450423f),
		Vector3DFloat(-0.789911f, -0.535936f, -0.409833f),
		Vector3DFloat(+0.085726f, +0.363079f, +0.082003f),
		Vector3DFloat(+0.744194f, -0.114292f, +0.322245f),
		Vector3DFloat(+0.693472f, -0.256447f, -0.516160f),
		Vector3DFloat(+0.446028f, -0.553026f, +0.471908f),
		Vector3DFloat(-0.757561f, +0.608997f, +0.833064f),
		Vector3DFloat(+0.115024f, +0.632191f, +0.314493f),
		Vector3DFloat(-0.403851f, -0.325663f, -0.057161f),
		Vector3DFloat(-0.188696f, +0.636097f, +0.514756f),
		Vector3DFloat(-0.110813f, -0.473861f, -0.041597f),
		Vector3DFloat(-0.239540f, +0.673940f, -0.874325f),
		Vector3DFloat(+0.739982f, +0.350932f, -0.930418f),
		Vector3DFloat(+0.519639f, -0.430952f, +0.569262f),
		Vector3DFloat(-0.916807f, +0.117832f, +0.924070f),
		Vector3DFloat(+0.856136f, +0.764763f, +0.653798f),
		Vector3DFloat(+0.953185f, +0.721061f, +0.723441f),
		Vector3DFloat(-0.113010f, +0.617176f, -0.436140f),
		Vector3DFloat(+0.912839f, +0.496811f, -0.742058f),
		Vector3DFloat(+0.219275f, -0.751701f, +0.479965f),
		Vector3DFloat(+0.655690f, -0.964538f, +0.619312f),
		Vector3DFloat(+0.364971f, +0.635975f, -0.697989f),
		Vector3DFloat(-0.142247f, +0.554918f, +0.291238f),
		Vector3DFloat(-0.163732f, -0.772820f, -0.887997f),
		Vector3DFloat(-0.122593f, -0.456404f, -0.006989f),
		Vector3DFloat(-0.704154f, -0.551378f, -0.237770f),
		Vector3DFloat(+0.637501f, -0.831843f, -0.706534f),
		Vector3DFloat(-0.794061f, -0.717887f, +0.576464f),
		Vector3DFloat(+0.233558f, -0.683218f, +0.879147f),
		Vector3DFloat(-0.170934f, +0.848811f, +0.840510f),
		Vector3DFloat(+0.735282f, -0.625965f, -0.309732f),
		Vector3DFloat(-0.562975f, +0.929746f, +0.794794f),
		Vector3DFloat(-0.455611f, -0.860836f, -0.810114f),
		Vector3DFloat(+0.433882f, -0.190222f, -0.529405f),
		Vector3DFloat(+0.785638f, -0.040864f, +0.050569f),
		Vector3DFloat(-0.963134f, -0.993713f, -0.817011f),
		Vector3DFloat(+0.787347f, -0.598071f, +0.782220f),
		Vector3DFloat(-0.551378f, +0.589526f, +0.061983f),
		Vector3DFloat(-0.987243f, +0.894589f, -0.469649f),
		Vector3DFloat(+0.329264f, +0.164464f, -0.088656f),
		Vector3DFloat(+0.068270f, +0.938841f, +0.700858f),
		Vector3DFloat(+0.101535f, -0.583850f, -0.809503f),
		Vector3DFloat(+0.906980f, -0.943724f, +0.461592f),
		Vector3DFloat(+0.438520f, -0.329264f, +0.261086f),
		Vector3DFloat(-0.700003f, -0.259316f, +0.784356f),
		Vector3DFloat(+0.442305f, +0.444502f, +0.481185f),
		Vector3DFloat(+0.326701f, -0.331523f, -0.227393f),
		Vector3DFloat(-0.222327f, -0.308390f, +0.517136f),
		Vector3DFloat(+0.275369f, -0.513169f, -0.177892f),
		Vector3DFloat(-0.378887f, +0.668203f, +0.619312f),
		Vector3DFloat(-0.785455f, -0.093661f, -0.071322f),
		Vector3DFloat(-0.022309f, -0.744987f, +0.832820f),
		Vector3DFloat(-0.177892f, +0.829707f, -0.550218f),
		Vector3DFloat(+0.952879f, +0.477767f, +0.428999f),
		Vector3DFloat(+0.113376f, +0.097568f, -0.921201f),
		Vector3DFloat(+0.195898f, -0.924619f, -0.494613f),
		Vector3DFloat(+0.727592f, -0.628956f, -0.029756f),
		Vector3DFloat(-0.796197f, -0.450484f, -0.045686f),
		Vector3DFloat(+0.670888f, +0.958068f, -0.902402f),
		Vector3DFloat(-0.259194f, -0.570666f, +0.098422f),
		Vector3DFloat(+0.120273f, -0.732475f, -0.712272f),
		Vector3DFloat(+0.539109f, +0.754753f, -0.517075f),
		Vector3DFloat(+0.320170f, +0.300821f, -0.790643f),
		Vector3DFloat(-0.049287f, +0.269814f, -0.149998f),
		Vector3DFloat(-0.004120f, +0.402081f, -0.856807f),
		Vector3DFloat(+0.566881f, -0.224464f, -0.552049f),
		Vector3DFloat(+0.323405f, -0.345317f, -0.119114f),
		Vector3DFloat(-0.736198f, -0.234352f, +0.803278f),
		Vector3DFloat(-0.424421f, +0.059358f, -0.162389f),
		Vector3DFloat(+0.918516f, -0.884640f, -0.853511f),
		Vector3DFloat(-0.633717f, +0.231239f, +0.672170f),
		Vector3DFloat(+0.417096f, +0.454878f, +0.097201f),
		Vector3DFloat(+0.183630f, -0.957030f, -0.368938f),
		Vector3DFloat(-0.199133f, +0.191687f, -0.787774f),
		Vector3DFloat(-0.109104f, +0.676077f, +0.731193f),
		Vector3DFloat(-0.288186f, -0.801691f, +0.855037f),
		Vector3DFloat(+0.332133f, -0.828730f, +0.005402f),
		Vector3DFloat(+0.959166f, +0.197790f, -0.221107f),
		Vector3DFloat(-0.646046f, +0.043428f, -0.379254f),
		Vector3DFloat(-0.717338f, +0.122105f, +0.107883f),
		Vector3DFloat(-0.299783f, +0.089389f, +0.977172f),
		Vector3DFloat(+0.486862f, -0.577990f, -0.726615f),
		Vector3DFloat(-0.400922f, +0.430769f, -0.834956f),
		Vector3DFloat(+0.308756f, +0.735221f, -0.809076f),
		Vector3DFloat(-0.304605f, +0.335551f, -0.350627f),
		Vector3DFloat(-0.078219f, -0.288491f, -0.225318f),
		Vector3DFloat(+0.529099f, +0.710562f, +0.002960f),
		Vector3DFloat(+0.102695f, +0.410932f, -0.950072f),
		Vector3DFloat(-0.715751f, +0.598621f, +0.188879f),
		Vector3DFloat(-0.936460f, -0.232398f, -0.123203f),
		Vector3DFloat(-0.733146f, -0.201819f, -0.463851f),
		Vector3DFloat(-0.982971f, -0.581347f, -0.104953f),
		Vector3DFloat(-0.219459f, +0.104648f, +0.416425f),
		Vector3DFloat(+0.952391f, -0.038789f, +0.993530f),
		Vector3DFloat(+0.992370f, +0.891537f, +0.959227f),
		Vector3DFloat(+0.104221f, -0.305704f, -0.359722f),
		Vector3DFloat(-0.722770f, +0.069735f, -0.801447f),
		Vector3DFloat(+0.444563f, +0.354961f, +0.041414f),
		Vector3DFloat(+0.642018f, -0.878903f, +0.058809f),
		Vector3DFloat(-0.532579f, -0.463668f, +0.565233f),
		Vector3DFloat(+0.411176f, -0.843379f, -0.172704f),
		Vector3DFloat(+0.823908f, +0.619922f, +0.439863f),
		Vector3DFloat(-0.340007f, +0.048189f, -0.529160f),
		Vector3DFloat(+0.241310f, -0.585070f, +0.637135f),
		Vector3DFloat(+0.146886f, +0.873226f, -0.425153f),
		Vector3DFloat(-0.114658f, -0.465621f, +0.364483f),
		Vector3DFloat(+0.987121f, -0.552599f, -0.918821f),
		Vector3DFloat(+0.138401f, -0.917722f, +0.930479f),
		Vector3DFloat(-0.732536f, -0.150731f, +0.613269f),
		Vector3DFloat(-0.071139f, +0.752373f, +0.192541f),
		Vector3DFloat(+0.475143f, -0.187353f, +0.258950f),
		Vector3DFloat(-0.500412f, -0.829157f, -0.418073f),
		Vector3DFloat(+0.260414f, +0.930479f, +0.483016f),
		Vector3DFloat(-0.899106f, +0.528550f, +0.076510f),
		Vector3DFloat(-0.084384f, +0.022614f, +0.609180f),
		Vector3DFloat(-0.213843f, -0.532334f, -0.282022f),
		Vector3DFloat(-0.715323f, +0.025117f, -0.698477f),
		Vector3DFloat(+0.521348f, +0.088656f, -0.415265f),
		Vector3DFloat(-0.131809f, -0.395672f, +0.932432f),
		Vector3DFloat(-0.549364f, -0.948363f, -0.207862f),
		Vector3DFloat(+0.908322f, +0.643605f, -0.103732f),
		Vector3DFloat(+0.632496f, +0.330973f, +0.345622f),
		Vector3DFloat(-0.522141f, +0.031892f, -0.920713f),
		Vector3DFloat(-0.875912f, +0.481918f, -0.229408f),
		Vector3DFloat(-0.698172f, -0.934202f, +0.051668f),
		Vector3DFloat(-0.791070f, -0.452193f, -0.366680f),
		Vector3DFloat(-0.531907f, +0.497299f, +0.386517f),
		Vector3DFloat(-0.942808f, -0.775811f, -0.397320f),
		Vector3DFloat(+0.577563f, +0.075289f, -0.943297f),
		Vector3DFloat(+0.464827f, -0.145848f, -0.167638f),
		Vector3DFloat(-0.503220f, +0.592273f, -0.617359f),
		Vector3DFloat(+0.752739f, +0.503464f, -0.586230f),
		Vector3DFloat(-0.040315f, +0.197180f, -0.259072f),
		Vector3DFloat(-0.304422f, -0.989380f, -0.281289f),
		Vector3DFloat(+0.063387f, -0.662954f, +0.451338f),
		Vector3DFloat(-0.272744f, +0.768914f, -0.141270f),
		Vector3DFloat(+0.475021f, +0.378033f, +0.186010f),
		Vector3DFloat(+0.893613f, -0.671560f, +0.494491f),
		Vector3DFloat(+0.154027f, +0.994873f, +0.138096f),
		Vector3DFloat(-0.661061f, -0.039094f, +0.072787f),
		Vector3DFloat(+0.849666f, -0.956298f, +0.300699f),
		Vector3DFloat(-0.227027f, +0.343913f, +0.514512f),
		Vector3DFloat(+0.812738f, -0.891659f, +0.790277f),
		Vector3DFloat(+0.619251f, -0.234779f, -0.342448f),
		Vector3DFloat(-0.698904f, -0.525620f, -0.553331f),
		Vector3DFloat(-0.357524f, +0.950194f, -0.358623f),
		Vector3DFloat(-0.174352f, -0.802911f, +0.215552f),
		Vector3DFloat(+0.046175f, +0.043794f, +0.139927f),
		Vector3DFloat(+0.911924f, +0.433149f, +0.302286f),
		Vector3DFloat(+0.563463f, -0.326823f, -0.832759f),
		Vector3DFloat(-0.293741f, -0.448103f, -0.951781f),
		Vector3DFloat(+0.196448f, +0.627979f, +0.340800f),
		Vector3DFloat(-0.727042f, -0.013886f, -0.847346f),
		Vector3DFloat(-0.769707f, +0.780084f, +0.239174f),
		Vector3DFloat(+0.168493f, +0.564806f, +0.509690f),
		Vector3DFloat(-0.786126f, +0.663564f, -0.908261f),
		Vector3DFloat(+0.084017f, -0.548631f, -0.207312f),
		Vector3DFloat(+0.011567f, +0.906552f, +0.726188f),
		Vector3DFloat(-0.723746f, +0.031648f, +0.250587f),
		Vector3DFloat(+0.031892f, +0.693045f, -0.263283f),
		Vector3DFloat(-0.601856f, -0.585742f, -0.769280f),
		Vector3DFloat(+0.588122f, -0.108127f, -0.535020f),
		Vector3DFloat(+0.455672f, +0.864498f, +0.963378f),
		Vector3DFloat(-0.712882f, -0.335490f, -0.143712f),
		Vector3DFloat(+0.199194f, +0.747002f, +0.380840f),
		Vector3DFloat(+0.626820f, +0.508042f, -0.177465f),
		Vector3DFloat(-0.441816f, +0.652150f, -0.549058f),
		Vector3DFloat(+0.862667f, +0.053377f, +0.652333f),
		Vector3DFloat(-0.002289f, +0.568834f, -0.069185f)
	};
}

#endif //__PolyVox_RandomVectors_H__
