/*******************************************************************************
* The MIT License (MIT)
*
* Copyright (c) 2015 David Williams and Matthew Williams
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*******************************************************************************/

#ifndef __PolyVox_RandomUnitVectors_H__
#define __PolyVox_RandomUnitVectors_H__

#include "PlatformDefinitions.h"

#include "../Vector.h"

namespace PolyVox
{
	const Vector3DFloat randomUnitVectors[1024] =
	{
		Vector3DFloat(+0.339922f, +0.827727f, -0.446454f),
		Vector3DFloat(+0.084104f, -0.552666f, -0.829148f),
		Vector3DFloat(+0.272549f, -0.946890f, +0.170637f),
		Vector3DFloat(-0.366941f, -0.785500f, -0.498341f),
		Vector3DFloat(-0.566493f, -0.533056f, +0.628440f),
		Vector3DFloat(+0.964857f, -0.261032f, -0.030203f),
		Vector3DFloat(+0.692249f, -0.251370f, +0.676465f),
		Vector3DFloat(-0.962508f, -0.173232f, -0.208734f),
		Vector3DFloat(-0.659700f, +0.712315f, +0.239589f),
		Vector3DFloat(+0.818392f, -0.574522f, +0.012631f),
		Vector3DFloat(+0.560367f, -0.792890f, -0.239405f),
		Vector3DFloat(+0.906429f, -0.307885f, +0.289127f),
		Vector3DFloat(-0.159051f, +0.461737f, +0.872641f),
		Vector3DFloat(-0.231332f, +0.080769f, +0.969516f),
		Vector3DFloat(-0.053423f, +0.774833f, +0.629904f),
		Vector3DFloat(+0.824248f, -0.144982f, +0.547353f),
		Vector3DFloat(+0.174020f, -0.439121f, -0.881413f),
		Vector3DFloat(+0.467553f, +0.882007f, -0.058800f),
		Vector3DFloat(+0.538442f, -0.808622f, +0.237089f),
		Vector3DFloat(+0.502236f, +0.150786f, -0.851483f),
		Vector3DFloat(+0.735645f, +0.569407f, -0.366882f),
		Vector3DFloat(-0.855825f, -0.328077f, -0.399912f),
		Vector3DFloat(-0.474060f, -0.211393f, +0.854740f),
		Vector3DFloat(+0.828518f, -0.114561f, +0.548119f),
		Vector3DFloat(+0.740223f, -0.663929f, +0.106149f),
		Vector3DFloat(-0.604006f, -0.756687f, +0.250204f),
		Vector3DFloat(+0.382515f, -0.373773f, -0.844971f),
		Vector3DFloat(-0.819034f, -0.162715f, -0.550188f),
		Vector3DFloat(-0.982375f, +0.169525f, -0.078743f),
		Vector3DFloat(+0.367097f, +0.380576f, +0.848765f),
		Vector3DFloat(+0.569529f, +0.516287f, +0.639597f),
		Vector3DFloat(-0.853575f, -0.243752f, +0.460429f),
		Vector3DFloat(+0.678039f, -0.729861f, -0.086982f),
		Vector3DFloat(-0.869225f, +0.393408f, +0.299462f),
		Vector3DFloat(-0.916254f, -0.295218f, +0.270784f),
		Vector3DFloat(-0.070601f, +0.873182f, +0.482253f),
		Vector3DFloat(-0.863217f, +0.189580f, +0.467885f),
		Vector3DFloat(-0.691774f, -0.687382f, -0.221257f),
		Vector3DFloat(-0.229393f, -0.552390f, +0.801402f),
		Vector3DFloat(+0.463007f, -0.161958f, -0.871432f),
		Vector3DFloat(-0.952260f, +0.214379f, +0.217352f),
		Vector3DFloat(+0.052543f, -0.983907f, +0.170781f),
		Vector3DFloat(+0.286530f, +0.546131f, -0.787173f),
		Vector3DFloat(+0.975618f, -0.202665f, +0.084242f),
		Vector3DFloat(-0.946903f, +0.193782f, -0.256561f),
		Vector3DFloat(+0.602392f, +0.563710f, +0.565115f),
		Vector3DFloat(-0.419515f, -0.334134f, -0.844015f),
		Vector3DFloat(+0.032529f, -0.018906f, -0.999292f),
		Vector3DFloat(+0.683276f, +0.293783f, -0.668450f),
		Vector3DFloat(+0.194348f, +0.974682f, +0.110565f),
		Vector3DFloat(-0.140892f, +0.831281f, +0.537700f),
		Vector3DFloat(+0.685721f, -0.335248f, -0.646062f),
		Vector3DFloat(+0.308294f, +0.062479f, -0.949237f),
		Vector3DFloat(-0.619897f, +0.133633f, -0.773220f),
		Vector3DFloat(+0.568018f, -0.694982f, +0.440858f),
		Vector3DFloat(+0.014460f, +0.810882f, -0.585031f),
		Vector3DFloat(-0.939900f, +0.051870f, +0.337488f),
		Vector3DFloat(+0.886477f, -0.450612f, -0.105395f),
		Vector3DFloat(-0.787830f, +0.158037f, -0.595271f),
		Vector3DFloat(-0.318153f, -0.830670f, -0.456910f),
		Vector3DFloat(-0.106830f, -0.755766f, -0.646069f),
		Vector3DFloat(-0.077610f, -0.893295f, -0.442720f),
		Vector3DFloat(+0.321718f, -0.338373f, +0.884309f),
		Vector3DFloat(+0.405993f, -0.037181f, +0.913119f),
		Vector3DFloat(+0.635434f, -0.612340f, +0.470387f),
		Vector3DFloat(-0.440661f, +0.527619f, -0.726248f),
		Vector3DFloat(+0.682630f, +0.730693f, +0.010181f),
		Vector3DFloat(+0.364300f, -0.398796f, -0.841574f),
		Vector3DFloat(+0.023390f, -0.827974f, +0.560279f),
		Vector3DFloat(-0.647533f, -0.750712f, +0.130894f),
		Vector3DFloat(+0.618352f, +0.694153f, +0.368499f),
		Vector3DFloat(+0.087485f, -0.552555f, +0.828872f),
		Vector3DFloat(-0.317011f, -0.740865f, -0.592134f),
		Vector3DFloat(+0.992075f, +0.089501f, +0.088190f),
		Vector3DFloat(+0.660945f, -0.628212f, -0.410490f),
		Vector3DFloat(-0.376167f, +0.394528f, -0.838359f),
		Vector3DFloat(+0.761817f, -0.647395f, -0.022690f),
		Vector3DFloat(+0.839361f, -0.432911f, -0.328727f),
		Vector3DFloat(-0.411275f, +0.046377f, -0.910331f),
		Vector3DFloat(+0.078506f, -0.797408f, +0.598312f),
		Vector3DFloat(-0.381022f, +0.922073f, +0.067844f),
		Vector3DFloat(-0.837489f, -0.501853f, +0.216232f),
		Vector3DFloat(-0.993133f, +0.055873f, -0.102786f),
		Vector3DFloat(+0.927419f, -0.354639f, -0.118844f),
		Vector3DFloat(+0.159676f, +0.614049f, -0.772947f),
		Vector3DFloat(-0.187074f, +0.846574f, +0.498312f),
		Vector3DFloat(+0.516069f, +0.728369f, -0.450724f),
		Vector3DFloat(-0.960108f, -0.233106f, -0.154447f),
		Vector3DFloat(-0.987760f, -0.112007f, +0.108557f),
		Vector3DFloat(+0.049202f, +0.998738f, -0.010071f),
		Vector3DFloat(-0.821445f, +0.254709f, +0.510247f),
		Vector3DFloat(+0.252350f, -0.204056f, +0.945876f),
		Vector3DFloat(-0.398037f, +0.781383f, -0.480633f),
		Vector3DFloat(+0.527785f, +0.747611f, -0.403137f),
		Vector3DFloat(-0.998566f, +0.043248f, +0.031542f),
		Vector3DFloat(+0.548139f, +0.684886f, +0.480078f),
		Vector3DFloat(-0.566315f, -0.745438f, +0.351581f),
		Vector3DFloat(-0.848496f, -0.030994f, +0.528294f),
		Vector3DFloat(-0.070703f, +0.825305f, -0.560244f),
		Vector3DFloat(+0.624014f, -0.043543f, +0.780199f),
		Vector3DFloat(+0.964602f, -0.189230f, -0.183670f),
		Vector3DFloat(+0.637905f, -0.539396f, +0.549663f),
		Vector3DFloat(+0.114321f, +0.904904f, -0.409974f),
		Vector3DFloat(-0.021617f, +0.186501f, +0.982217f),
		Vector3DFloat(+0.469141f, -0.747866f, +0.469685f),
		Vector3DFloat(+0.132117f, +0.385378f, +0.913252f),
		Vector3DFloat(-0.252634f, -0.349595f, +0.902197f),
		Vector3DFloat(-0.145421f, +0.945344f, +0.291851f),
		Vector3DFloat(-0.600604f, +0.448416f, -0.661965f),
		Vector3DFloat(+0.381683f, -0.700133f, -0.603433f),
		Vector3DFloat(+0.569938f, -0.030470f, +0.821122f),
		Vector3DFloat(+0.112037f, +0.915575f, +0.386225f),
		Vector3DFloat(+0.059716f, -0.821586f, -0.566949f),
		Vector3DFloat(-0.158273f, -0.639328f, -0.752468f),
		Vector3DFloat(+0.001205f, -0.990747f, -0.135715f),
		Vector3DFloat(-0.100969f, -0.176804f, -0.979054f),
		Vector3DFloat(+0.169578f, -0.733794f, -0.657868f),
		Vector3DFloat(+0.474056f, +0.669558f, -0.571807f),
		Vector3DFloat(+0.014190f, -0.179546f, -0.983647f),
		Vector3DFloat(-0.506680f, +0.784137f, -0.358337f),
		Vector3DFloat(+0.402466f, +0.736544f, -0.543621f),
		Vector3DFloat(-0.740589f, +0.430129f, +0.516252f),
		Vector3DFloat(-0.731489f, -0.411418f, +0.543745f),
		Vector3DFloat(-0.372220f, +0.822132f, -0.430756f),
		Vector3DFloat(-0.403935f, +0.195178f, +0.893724f),
		Vector3DFloat(+0.893255f, -0.191946f, +0.406512f),
		Vector3DFloat(+0.257182f, +0.933321f, +0.250537f),
		Vector3DFloat(-0.946047f, -0.252800f, +0.202699f),
		Vector3DFloat(+0.287823f, -0.484935f, +0.825830f),
		Vector3DFloat(+0.880378f, +0.321649f, +0.348535f),
		Vector3DFloat(-0.820150f, +0.481236f, +0.309460f),
		Vector3DFloat(-0.888465f, +0.169680f, -0.426425f),
		Vector3DFloat(+0.761535f, -0.481027f, +0.434371f),
		Vector3DFloat(+0.581314f, +0.037144f, -0.812831f),
		Vector3DFloat(-0.014257f, -0.470925f, +0.882058f),
		Vector3DFloat(+0.327440f, +0.265095f, -0.906922f),
		Vector3DFloat(+0.445945f, +0.877176f, +0.178034f),
		Vector3DFloat(+0.724926f, -0.523194f, -0.448052f),
		Vector3DFloat(-0.649973f, +0.748818f, -0.129641f),
		Vector3DFloat(-0.862141f, -0.181190f, -0.473163f),
		Vector3DFloat(+0.546248f, -0.486978f, -0.681517f),
		Vector3DFloat(-0.466403f, -0.132595f, +0.874578f),
		Vector3DFloat(-0.726486f, +0.640533f, -0.248868f),
		Vector3DFloat(-0.717238f, -0.164892f, +0.677038f),
		Vector3DFloat(-0.173482f, -0.912751f, -0.369852f),
		Vector3DFloat(+0.151425f, +0.097703f, +0.983628f),
		Vector3DFloat(-0.367962f, +0.286588f, -0.884574f),
		Vector3DFloat(-0.269776f, -0.681349f, +0.680430f),
		Vector3DFloat(+0.587256f, +0.243525f, +0.771898f),
		Vector3DFloat(+0.052027f, +0.391610f, -0.918659f),
		Vector3DFloat(+0.991548f, -0.106357f, +0.074308f),
		Vector3DFloat(+0.659039f, +0.457360f, -0.597067f),
		Vector3DFloat(-0.626734f, -0.682082f, -0.376787f),
		Vector3DFloat(-0.353101f, +0.033567f, -0.934983f),
		Vector3DFloat(+0.621237f, -0.289495f, +0.728188f),
		Vector3DFloat(+0.490845f, -0.189807f, +0.850320f),
		Vector3DFloat(-0.699031f, -0.710681f, -0.079302f),
		Vector3DFloat(-0.050094f, +0.880791f, +0.470847f),
		Vector3DFloat(+0.070288f, -0.086374f, +0.993780f),
		Vector3DFloat(+0.853154f, +0.022317f, +0.521181f),
		Vector3DFloat(+0.230886f, +0.693269f, -0.682693f),
		Vector3DFloat(-0.466130f, +0.883868f, -0.038727f),
		Vector3DFloat(-0.551610f, +0.824661f, +0.125144f),
		Vector3DFloat(-0.137494f, +0.409326f, -0.901968f),
		Vector3DFloat(-0.890857f, -0.180159f, +0.417034f),
		Vector3DFloat(+0.553659f, -0.392300f, +0.734549f),
		Vector3DFloat(+0.406329f, -0.048366f, +0.912446f),
		Vector3DFloat(-0.270581f, +0.233748f, -0.933888f),
		Vector3DFloat(-0.197245f, +0.810087f, -0.552136f),
		Vector3DFloat(+0.295429f, +0.704757f, +0.645011f),
		Vector3DFloat(+0.717722f, -0.581869f, -0.382496f),
		Vector3DFloat(+0.626543f, -0.539930f, +0.562067f),
		Vector3DFloat(+0.971598f, -0.144608f, +0.187311f),
		Vector3DFloat(-0.697722f, -0.464932f, -0.544998f),
		Vector3DFloat(+0.457003f, +0.780926f, +0.425797f),
		Vector3DFloat(+0.183694f, +0.717668f, -0.671720f),
		Vector3DFloat(+0.251615f, -0.738280f, -0.625805f),
		Vector3DFloat(+0.545768f, +0.806104f, +0.228766f),
		Vector3DFloat(-0.928760f, -0.348049f, +0.127545f),
		Vector3DFloat(+0.137432f, -0.972652f, -0.187242f),
		Vector3DFloat(-0.804669f, -0.253834f, +0.536727f),
		Vector3DFloat(-0.931569f, -0.252185f, -0.261882f),
		Vector3DFloat(-0.604266f, -0.710349f, +0.360924f),
		Vector3DFloat(-0.687860f, -0.535154f, -0.490367f),
		Vector3DFloat(+0.017091f, +0.824354f, -0.565817f),
		Vector3DFloat(+0.978598f, +0.134960f, +0.155346f),
		Vector3DFloat(-0.802635f, +0.545353f, -0.241595f),
		Vector3DFloat(+0.155235f, +0.909842f, +0.384824f),
		Vector3DFloat(+0.499090f, -0.206100f, -0.841684f),
		Vector3DFloat(-0.474793f, -0.216500f, +0.853053f),
		Vector3DFloat(-0.317506f, -0.762610f, -0.563575f),
		Vector3DFloat(-0.914433f, +0.049911f, -0.401649f),
		Vector3DFloat(+0.209168f, +0.632836f, -0.745498f),
		Vector3DFloat(+0.571789f, +0.197009f, -0.796395f),
		Vector3DFloat(-0.364670f, +0.917590f, -0.158254f),
		Vector3DFloat(-0.966271f, +0.140594f, -0.215761f),
		Vector3DFloat(-0.915867f, +0.394413f, +0.075008f),
		Vector3DFloat(+0.035516f, +0.991982f, -0.121285f),
		Vector3DFloat(+0.334756f, -0.834260f, +0.438120f),
		Vector3DFloat(+0.471469f, +0.810497f, -0.347579f),
		Vector3DFloat(-0.630204f, -0.370799f, -0.682166f),
		Vector3DFloat(+0.752076f, -0.232512f, +0.616701f),
		Vector3DFloat(+0.780218f, -0.524134f, +0.341385f),
		Vector3DFloat(-0.717151f, -0.558684f, -0.416614f),
		Vector3DFloat(+0.026975f, +0.354843f, +0.934537f),
		Vector3DFloat(+0.660713f, -0.205604f, +0.721931f),
		Vector3DFloat(+0.569071f, -0.717916f, +0.400942f),
		Vector3DFloat(+0.345670f, +0.917475f, -0.196853f),
		Vector3DFloat(+0.109370f, +0.150700f, -0.982511f),
		Vector3DFloat(-0.075296f, +0.867593f, -0.491541f),
		Vector3DFloat(+0.427583f, +0.181258f, -0.885617f),
		Vector3DFloat(-0.423011f, -0.536708f, +0.730073f),
		Vector3DFloat(+0.410061f, +0.902819f, +0.129491f),
		Vector3DFloat(+0.783330f, +0.352044f, -0.512307f),
		Vector3DFloat(+0.019660f, +0.294402f, +0.955480f),
		Vector3DFloat(+0.370284f, +0.795152f, -0.480232f),
		Vector3DFloat(+0.620337f, +0.569302f, -0.539516f),
		Vector3DFloat(-0.947343f, -0.008934f, +0.320097f),
		Vector3DFloat(-0.093679f, +0.931693f, -0.350960f),
		Vector3DFloat(-0.555730f, +0.665103f, +0.498802f),
		Vector3DFloat(+0.319960f, +0.176651f, -0.930817f),
		Vector3DFloat(-0.679840f, +0.281903f, +0.677014f),
		Vector3DFloat(-0.954067f, +0.193782f, +0.228484f),
		Vector3DFloat(+0.592922f, -0.708226f, +0.383222f),
		Vector3DFloat(-0.759157f, -0.391265f, +0.520184f),
		Vector3DFloat(-0.256083f, +0.304044f, +0.917594f),
		Vector3DFloat(-0.462124f, +0.481197f, +0.744910f),
		Vector3DFloat(-0.679480f, +0.733098f, +0.029563f),
		Vector3DFloat(+0.025552f, -0.585890f, -0.809987f),
		Vector3DFloat(-0.060045f, +0.002791f, +0.998192f),
		Vector3DFloat(-0.507954f, +0.858736f, +0.067494f),
		Vector3DFloat(-0.060525f, +0.636414f, -0.768969f),
		Vector3DFloat(-0.874884f, +0.448472f, -0.182895f),
		Vector3DFloat(+0.643562f, +0.762645f, -0.064807f),
		Vector3DFloat(-0.516967f, -0.154231f, +0.841996f),
		Vector3DFloat(+0.448249f, -0.717116f, -0.533683f),
		Vector3DFloat(+0.536270f, -0.786853f, +0.305411f),
		Vector3DFloat(+0.000761f, +0.527854f, -0.849335f),
		Vector3DFloat(+0.723561f, -0.634332f, +0.272181f),
		Vector3DFloat(+0.112740f, -0.371782f, -0.921449f),
		Vector3DFloat(+0.966055f, +0.051903f, +0.253070f),
		Vector3DFloat(-0.600327f, +0.248981f, -0.760011f),
		Vector3DFloat(+0.091875f, +0.041693f, -0.994897f),
		Vector3DFloat(-0.302152f, +0.607269f, +0.734798f),
		Vector3DFloat(+0.287662f, -0.651858f, -0.701663f),
		Vector3DFloat(-0.004536f, +0.679631f, +0.733540f),
		Vector3DFloat(+0.526143f, +0.799583f, -0.289551f),
		Vector3DFloat(-0.603927f, +0.789648f, -0.108294f),
		Vector3DFloat(-0.033126f, +0.944024f, -0.328210f),
		Vector3DFloat(-0.167102f, -0.851884f, -0.496358f),
		Vector3DFloat(+0.288185f, -0.113731f, +0.950797f),
		Vector3DFloat(+0.578194f, -0.436702f, -0.689190f),
		Vector3DFloat(+0.217496f, +0.313876f, +0.924217f),
		Vector3DFloat(-0.915961f, -0.158736f, -0.368535f),
		Vector3DFloat(-0.498651f, +0.155245f, +0.852787f),
		Vector3DFloat(-0.248762f, +0.679310f, -0.690403f),
		Vector3DFloat(-0.582908f, +0.077123f, +0.808870f),
		Vector3DFloat(+0.686950f, +0.229251f, -0.689597f),
		Vector3DFloat(-0.647296f, +0.760051f, +0.057711f),
		Vector3DFloat(-0.485938f, -0.092580f, +0.869076f),
		Vector3DFloat(+0.418369f, +0.089460f, -0.903861f),
		Vector3DFloat(-0.047269f, +0.350493f, -0.935372f),
		Vector3DFloat(-0.242049f, -0.214469f, +0.946264f),
		Vector3DFloat(-0.804456f, +0.566448f, +0.178852f),
		Vector3DFloat(+0.097365f, -0.900938f, +0.422885f),
		Vector3DFloat(+0.956649f, +0.290563f, +0.019905f),
		Vector3DFloat(-0.783547f, +0.574387f, -0.236925f),
		Vector3DFloat(-0.308724f, -0.086733f, -0.947189f),
		Vector3DFloat(-0.035715f, +0.856029f, -0.515692f),
		Vector3DFloat(+0.920461f, +0.190617f, +0.341199f),
		Vector3DFloat(+0.637306f, +0.769628f, -0.038913f),
		Vector3DFloat(-0.040111f, +0.877976f, +0.477021f),
		Vector3DFloat(+0.110588f, +0.251198f, +0.961598f),
		Vector3DFloat(-0.391595f, +0.858960f, +0.329911f),
		Vector3DFloat(+0.159040f, +0.801465f, -0.576507f),
		Vector3DFloat(-0.420361f, +0.896705f, +0.138623f),
		Vector3DFloat(-0.706685f, -0.506701f, -0.493812f),
		Vector3DFloat(+0.589701f, +0.807018f, -0.031213f),
		Vector3DFloat(+0.613812f, +0.504595f, -0.607140f),
		Vector3DFloat(+0.453930f, +0.802963f, +0.386261f),
		Vector3DFloat(+0.034816f, +0.204525f, +0.978242f),
		Vector3DFloat(+0.557178f, -0.795610f, +0.237816f),
		Vector3DFloat(+0.694672f, -0.364363f, +0.620218f),
		Vector3DFloat(+0.703004f, +0.571702f, +0.423015f),
		Vector3DFloat(-0.821828f, -0.569379f, +0.020152f),
		Vector3DFloat(+0.999573f, +0.011862f, +0.026716f),
		Vector3DFloat(+0.045244f, +0.476148f, +0.878201f),
		Vector3DFloat(-0.879083f, +0.458490f, +0.130387f),
		Vector3DFloat(-0.548204f, +0.534573f, -0.643198f),
		Vector3DFloat(+0.371419f, +0.536568f, +0.757722f),
		Vector3DFloat(-0.121365f, +0.656202f, -0.744761f),
		Vector3DFloat(-0.594210f, +0.803019f, -0.045540f),
		Vector3DFloat(+0.249812f, +0.564218f, -0.786926f),
		Vector3DFloat(+0.807295f, +0.588715f, -0.041117f),
		Vector3DFloat(-0.333582f, +0.911830f, +0.239350f),
		Vector3DFloat(+0.437116f, -0.527554f, -0.728434f),
		Vector3DFloat(+0.061956f, +0.967757f, +0.244147f),
		Vector3DFloat(+0.511582f, -0.822519f, -0.248487f),
		Vector3DFloat(-0.341118f, -0.068048f, -0.937554f),
		Vector3DFloat(+0.387840f, +0.793197f, +0.469487f),
		Vector3DFloat(+0.682570f, +0.445391f, -0.579418f),
		Vector3DFloat(+0.769534f, -0.445299f, -0.457740f),
		Vector3DFloat(-0.883027f, -0.468901f, -0.019884f),
		Vector3DFloat(-0.595228f, +0.589924f, +0.545613f),
		Vector3DFloat(+0.123593f, +0.850082f, +0.511943f),
		Vector3DFloat(+0.428617f, -0.326588f, -0.842394f),
		Vector3DFloat(-0.838837f, +0.492096f, +0.232796f),
		Vector3DFloat(-0.912950f, -0.283450f, -0.293562f),
		Vector3DFloat(-0.701007f, +0.660260f, +0.269527f),
		Vector3DFloat(-0.726761f, -0.673596f, -0.134488f),
		Vector3DFloat(+0.969362f, -0.234200f, +0.074084f),
		Vector3DFloat(-0.249448f, -0.056271f, +0.966752f),
		Vector3DFloat(+0.996651f, -0.018843f, +0.079570f),
		Vector3DFloat(+0.807648f, +0.476489f, +0.347367f),
		Vector3DFloat(-0.749837f, -0.398796f, -0.527926f),
		Vector3DFloat(+0.739222f, +0.268296f, +0.617712f),
		Vector3DFloat(+0.770822f, -0.517357f, -0.371720f),
		Vector3DFloat(-0.799675f, +0.207189f, +0.563554f),
		Vector3DFloat(+0.858095f, +0.081493f, +0.506983f),
		Vector3DFloat(+0.677579f, -0.727246f, +0.109543f),
		Vector3DFloat(-0.745912f, -0.097643f, +0.658848f),
		Vector3DFloat(+0.923446f, -0.321145f, +0.210033f),
		Vector3DFloat(+0.633275f, +0.749248f, -0.193880f),
		Vector3DFloat(+0.445950f, +0.115095f, +0.887627f),
		Vector3DFloat(-0.813021f, +0.255444f, -0.523207f),
		Vector3DFloat(-0.872976f, -0.483345f, -0.065502f),
		Vector3DFloat(+0.587776f, +0.807323f, -0.052440f),
		Vector3DFloat(-0.324123f, +0.518088f, -0.791536f),
		Vector3DFloat(+0.041866f, +0.935359f, -0.351214f),
		Vector3DFloat(-0.745819f, -0.037221f, -0.665108f),
		Vector3DFloat(-0.625395f, -0.780290f, -0.005274f),
		Vector3DFloat(-0.949212f, -0.125200f, -0.288653f),
		Vector3DFloat(+0.746352f, +0.513825f, -0.423016f),
		Vector3DFloat(+0.165203f, -0.819308f, -0.549038f),
		Vector3DFloat(+0.749447f, -0.199908f, +0.631162f),
		Vector3DFloat(-0.935221f, +0.313398f, +0.164751f),
		Vector3DFloat(+0.574888f, +0.577243f, -0.579908f),
		Vector3DFloat(+0.213935f, -0.439668f, +0.872309f),
		Vector3DFloat(-0.067281f, -0.429365f, -0.900621f),
		Vector3DFloat(-0.675176f, -0.265100f, -0.688374f),
		Vector3DFloat(-0.940780f, -0.187993f, +0.282119f),
		Vector3DFloat(+0.608412f, -0.674603f, -0.418026f),
		Vector3DFloat(+0.226805f, -0.971072f, -0.074690f),
		Vector3DFloat(-0.922002f, -0.058313f, -0.382768f),
		Vector3DFloat(-0.889078f, -0.285307f, +0.357968f),
		Vector3DFloat(-0.463386f, -0.780956f, +0.418785f),
		Vector3DFloat(+0.480335f, -0.863968f, +0.151120f),
		Vector3DFloat(-0.467641f, -0.601770f, -0.647444f),
		Vector3DFloat(+0.752364f, -0.628982f, +0.195781f),
		Vector3DFloat(+0.068107f, -0.990481f, -0.119616f),
		Vector3DFloat(+0.225170f, -0.147543f, +0.963083f),
		Vector3DFloat(+0.225228f, +0.971322f, +0.076195f),
		Vector3DFloat(-0.991397f, -0.118660f, +0.055239f),
		Vector3DFloat(-0.160493f, -0.746967f, +0.645200f),
		Vector3DFloat(-0.458821f, -0.208468f, +0.863727f),
		Vector3DFloat(+0.333033f, +0.516134f, +0.789110f),
		Vector3DFloat(+0.732654f, +0.260905f, -0.628607f),
		Vector3DFloat(-0.669918f, -0.656301f, -0.347102f),
		Vector3DFloat(-0.786699f, +0.543142f, -0.293431f),
		Vector3DFloat(+0.347036f, +0.004466f, +0.937841f),
		Vector3DFloat(-0.484482f, -0.771461f, +0.412463f),
		Vector3DFloat(+0.103332f, +0.547687f, -0.830278f),
		Vector3DFloat(+0.119923f, -0.930107f, -0.347159f),
		Vector3DFloat(+0.005754f, +0.994568f, +0.103930f),
		Vector3DFloat(-0.033282f, +0.896829f, +0.441124f),
		Vector3DFloat(+0.457958f, +0.771949f, +0.440874f),
		Vector3DFloat(-0.519990f, +0.369290f, -0.770218f),
		Vector3DFloat(-0.171662f, -0.061337f, -0.983245f),
		Vector3DFloat(+0.250848f, +0.937167f, -0.242472f),
		Vector3DFloat(-0.527961f, -0.608927f, +0.592001f),
		Vector3DFloat(+0.524343f, -0.097826f, +0.845869f),
		Vector3DFloat(-0.900974f, +0.373399f, +0.220951f),
		Vector3DFloat(+0.287497f, +0.561963f, +0.775592f),
		Vector3DFloat(+0.540008f, +0.803719f, -0.249855f),
		Vector3DFloat(+0.566511f, +0.497948f, -0.656592f),
		Vector3DFloat(+0.337228f, +0.656232f, -0.675009f),
		Vector3DFloat(+0.978888f, -0.153522f, -0.134940f),
		Vector3DFloat(+0.720676f, +0.649026f, +0.243702f),
		Vector3DFloat(+0.530737f, +0.228155f, -0.816250f),
		Vector3DFloat(+0.429492f, +0.091242f, -0.898449f),
		Vector3DFloat(-0.572942f, +0.085360f, +0.815139f),
		Vector3DFloat(+0.918652f, -0.255422f, +0.301395f),
		Vector3DFloat(+0.947882f, -0.087598f, +0.306343f),
		Vector3DFloat(+0.108362f, +0.969752f, -0.218719f),
		Vector3DFloat(-0.471217f, +0.713578f, +0.518421f),
		Vector3DFloat(+0.750274f, -0.244288f, -0.614339f),
		Vector3DFloat(+0.560909f, -0.563116f, -0.606862f),
		Vector3DFloat(+0.863412f, -0.431809f, +0.260886f),
		Vector3DFloat(+0.316636f, +0.937246f, -0.145983f),
		Vector3DFloat(-0.292652f, +0.171648f, +0.940687f),
		Vector3DFloat(-0.636577f, +0.687143f, -0.350149f),
		Vector3DFloat(+0.876483f, +0.262488f, +0.403581f),
		Vector3DFloat(-0.477533f, +0.501607f, +0.721355f),
		Vector3DFloat(+0.620654f, +0.186584f, +0.761561f),
		Vector3DFloat(+0.085796f, +0.736783f, +0.670664f),
		Vector3DFloat(-0.444489f, -0.220480f, -0.868227f),
		Vector3DFloat(-0.380013f, +0.496385f, +0.780508f),
		Vector3DFloat(+0.076912f, -0.385017f, -0.919699f),
		Vector3DFloat(+0.148937f, -0.407401f, -0.901023f),
		Vector3DFloat(+0.790103f, +0.361770f, -0.494833f),
		Vector3DFloat(+0.206634f, +0.909197f, +0.361474f),
		Vector3DFloat(+0.171861f, -0.895971f, -0.409512f),
		Vector3DFloat(-0.961243f, +0.146552f, -0.233527f),
		Vector3DFloat(-0.142180f, +0.815553f, +0.560944f),
		Vector3DFloat(-0.423930f, -0.030949f, +0.905166f),
		Vector3DFloat(+0.618879f, -0.685650f, +0.383241f),
		Vector3DFloat(-0.209245f, +0.545013f, +0.811898f),
		Vector3DFloat(+0.377987f, +0.747944f, -0.545624f),
		Vector3DFloat(-0.791300f, +0.607509f, -0.069108f),
		Vector3DFloat(+0.754199f, -0.113604f, -0.646744f),
		Vector3DFloat(-0.583229f, -0.063801f, +0.809798f),
		Vector3DFloat(-0.469901f, +0.015164f, +0.882589f),
		Vector3DFloat(-0.978270f, +0.003442f, -0.207306f),
		Vector3DFloat(+0.655500f, +0.726545f, +0.206039f),
		Vector3DFloat(+0.967185f, -0.245972f, +0.063652f),
		Vector3DFloat(-0.442760f, +0.675317f, +0.589840f),
		Vector3DFloat(+0.403392f, +0.270425f, +0.874154f),
		Vector3DFloat(+0.902052f, +0.135317f, +0.409868f),
		Vector3DFloat(-0.210257f, -0.926257f, -0.312794f),
		Vector3DFloat(-0.933559f, -0.225815f, -0.278344f),
		Vector3DFloat(-0.635320f, +0.772243f, -0.003054f),
		Vector3DFloat(-0.554821f, +0.812428f, -0.179259f),
		Vector3DFloat(-0.844807f, +0.091109f, -0.527258f),
		Vector3DFloat(-0.748601f, +0.549263f, -0.371358f),
		Vector3DFloat(-0.081435f, +0.491490f, -0.867067f),
		Vector3DFloat(+0.005014f, -0.658765f, +0.752332f),
		Vector3DFloat(-0.384916f, +0.588836f, -0.710712f),
		Vector3DFloat(-0.563287f, -0.436926f, -0.701287f),
		Vector3DFloat(+0.075923f, -0.889985f, +0.449624f),
		Vector3DFloat(+0.460179f, +0.240506f, -0.854630f),
		Vector3DFloat(+0.133134f, +0.863013f, +0.487323f),
		Vector3DFloat(-0.451891f, -0.691915f, +0.563071f),
		Vector3DFloat(+0.482576f, +0.491924f, -0.724659f),
		Vector3DFloat(-0.772395f, +0.503554f, +0.387091f),
		Vector3DFloat(-0.861070f, -0.363456f, -0.355610f),
		Vector3DFloat(-0.219092f, -0.539591f, +0.812921f),
		Vector3DFloat(-0.232021f, +0.937887f, +0.257940f),
		Vector3DFloat(+0.864410f, +0.411132f, +0.289425f),
		Vector3DFloat(-0.657914f, +0.356283f, +0.663485f),
		Vector3DFloat(-0.695536f, -0.354660f, -0.624856f),
		Vector3DFloat(-0.984126f, +0.139830f, -0.109283f),
		Vector3DFloat(-0.739931f, -0.568047f, +0.360312f),
		Vector3DFloat(-0.422765f, +0.793857f, -0.437105f),
		Vector3DFloat(+0.695244f, +0.499122f, +0.517216f),
		Vector3DFloat(+0.620847f, +0.772096f, +0.135708f),
		Vector3DFloat(+0.640543f, +0.693625f, -0.329529f),
		Vector3DFloat(-0.716203f, +0.695845f, -0.053417f),
		Vector3DFloat(+0.688286f, -0.614140f, +0.386127f),
		Vector3DFloat(+0.990001f, -0.012803f, -0.140479f),
		Vector3DFloat(-0.842904f, +0.537664f, +0.020753f),
		Vector3DFloat(+0.008333f, +0.285713f, +0.958279f),
		Vector3DFloat(-0.276086f, -0.823605f, +0.495431f),
		Vector3DFloat(+0.795835f, -0.446944f, +0.408518f),
		Vector3DFloat(-0.068520f, +0.989143f, -0.130001f),
		Vector3DFloat(-0.995477f, -0.013318f, -0.094068f),
		Vector3DFloat(-0.013256f, -0.205680f, +0.978530f),
		Vector3DFloat(+0.286330f, +0.478558f, +0.830058f),
		Vector3DFloat(-0.312670f, -0.000134f, +0.949862f),
		Vector3DFloat(-0.992102f, -0.018784f, -0.124017f),
		Vector3DFloat(-0.218201f, +0.471729f, +0.854318f),
		Vector3DFloat(-0.885932f, -0.441603f, +0.141812f),
		Vector3DFloat(+0.410418f, -0.903853f, +0.120862f),
		Vector3DFloat(-0.046755f, -0.618559f, +0.784346f),
		Vector3DFloat(+0.561077f, +0.827730f, +0.007490f),
		Vector3DFloat(-0.264927f, +0.963738f, +0.031968f),
		Vector3DFloat(+0.360743f, +0.887368f, -0.287127f),
		Vector3DFloat(+0.829757f, -0.531319f, -0.170889f),
		Vector3DFloat(-0.716516f, -0.646065f, +0.263068f),
		Vector3DFloat(+0.557460f, +0.677923f, -0.479227f),
		Vector3DFloat(-0.709849f, +0.694781f, -0.115733f),
		Vector3DFloat(+0.853291f, -0.488531f, -0.182299f),
		Vector3DFloat(+0.455284f, -0.849392f, -0.266925f),
		Vector3DFloat(+0.417165f, +0.856319f, -0.304453f),
		Vector3DFloat(+0.871881f, +0.388090f, +0.298681f),
		Vector3DFloat(-0.103988f, +0.510844f, -0.853361f),
		Vector3DFloat(+0.351047f, +0.889847f, -0.291441f),
		Vector3DFloat(+0.389540f, -0.053379f, -0.919462f),
		Vector3DFloat(-0.581684f, +0.075521f, +0.809901f),
		Vector3DFloat(-0.422965f, -0.141455f, +0.895037f),
		Vector3DFloat(+0.213377f, +0.454586f, -0.864767f),
		Vector3DFloat(+0.159390f, +0.466820f, +0.869870f),
		Vector3DFloat(+0.385902f, -0.013831f, +0.922436f),
		Vector3DFloat(-0.360291f, -0.335817f, -0.870297f),
		Vector3DFloat(-0.420892f, +0.570921f, -0.704910f),
		Vector3DFloat(+0.046113f, -0.619140f, -0.783925f),
		Vector3DFloat(+0.454440f, +0.871791f, -0.182935f),
		Vector3DFloat(+0.523305f, -0.762818f, +0.379816f),
		Vector3DFloat(-0.639517f, -0.634506f, -0.434073f),
		Vector3DFloat(+0.286115f, -0.720485f, +0.631695f),
		Vector3DFloat(+0.391046f, -0.912504f, -0.120079f),
		Vector3DFloat(+0.562545f, +0.825619f, +0.043556f),
		Vector3DFloat(+0.976939f, +0.145670f, -0.156113f),
		Vector3DFloat(-0.197444f, -0.653530f, -0.730695f),
		Vector3DFloat(-0.727176f, +0.159246f, +0.667724f),
		Vector3DFloat(+0.977135f, +0.039408f, +0.208935f),
		Vector3DFloat(+0.487883f, -0.668376f, -0.561466f),
		Vector3DFloat(+0.081173f, -0.454129f, -0.887231f),
		Vector3DFloat(+0.007776f, -0.558369f, -0.829556f),
		Vector3DFloat(+0.392559f, -0.216208f, +0.893952f),
		Vector3DFloat(+0.552351f, -0.797994f, -0.241067f),
		Vector3DFloat(-0.812645f, +0.582758f, -0.000884f),
		Vector3DFloat(+0.723477f, +0.425448f, +0.543668f),
		Vector3DFloat(-0.290387f, -0.824836f, +0.485099f),
		Vector3DFloat(-0.648037f, +0.731057f, +0.213549f),
		Vector3DFloat(-0.112077f, +0.911214f, +0.396394f),
		Vector3DFloat(-0.257374f, +0.878627f, +0.402212f),
		Vector3DFloat(-0.871679f, -0.449228f, -0.195884f),
		Vector3DFloat(-0.832643f, +0.503619f, -0.230377f),
		Vector3DFloat(-0.750683f, +0.454826f, -0.479174f),
		Vector3DFloat(+0.668945f, -0.737419f, +0.093412f),
		Vector3DFloat(+0.232689f, -0.239415f, -0.942622f),
		Vector3DFloat(+0.932416f, +0.058455f, -0.356629f),
		Vector3DFloat(-0.266008f, -0.899388f, +0.346900f),
		Vector3DFloat(+0.574940f, -0.817948f, -0.020127f),
		Vector3DFloat(-0.332832f, +0.728233f, +0.599083f),
		Vector3DFloat(+0.252574f, -0.202957f, +0.946052f),
		Vector3DFloat(+0.614750f, -0.787545f, +0.043079f),
		Vector3DFloat(+0.502885f, +0.757385f, -0.416503f),
		Vector3DFloat(-0.829003f, +0.454711f, -0.325562f),
		Vector3DFloat(-0.568805f, +0.542102f, +0.618536f),
		Vector3DFloat(-0.024095f, -0.673837f, -0.738487f),
		Vector3DFloat(+0.138735f, -0.428584f, -0.892787f),
		Vector3DFloat(-0.535936f, -0.016858f, +0.844090f),
		Vector3DFloat(-0.040976f, +0.588714f, +0.807302f),
		Vector3DFloat(-0.691862f, -0.721945f, +0.011050f),
		Vector3DFloat(+0.862563f, -0.438786f, -0.251897f),
		Vector3DFloat(+0.278186f, +0.894754f, +0.349326f),
		Vector3DFloat(-0.377682f, -0.908327f, +0.179719f),
		Vector3DFloat(-0.632125f, -0.611940f, +0.475339f),
		Vector3DFloat(-0.575327f, -0.789967f, -0.212015f),
		Vector3DFloat(+0.112909f, -0.993543f, -0.011156f),
		Vector3DFloat(+0.593082f, -0.037683f, -0.804260f),
		Vector3DFloat(-0.067094f, -0.620832f, +0.781067f),
		Vector3DFloat(-0.152754f, +0.253291f, -0.955254f),
		Vector3DFloat(-0.325782f, +0.882758f, -0.338533f),
		Vector3DFloat(+0.359581f, -0.906944f, +0.219441f),
		Vector3DFloat(-0.436527f, +0.597887f, +0.672291f),
		Vector3DFloat(-0.475060f, +0.315753f, +0.821351f),
		Vector3DFloat(-0.504146f, +0.392763f, -0.769138f),
		Vector3DFloat(+0.732747f, -0.275063f, -0.622432f),
		Vector3DFloat(-0.222604f, +0.239178f, +0.945115f),
		Vector3DFloat(+0.929953f, +0.212024f, +0.300389f),
		Vector3DFloat(+0.212224f, -0.914623f, -0.344129f),
		Vector3DFloat(+0.744091f, -0.069074f, +0.664498f),
		Vector3DFloat(+0.378632f, +0.925135f, -0.027624f),
		Vector3DFloat(-0.657970f, +0.042972f, +0.751817f),
		Vector3DFloat(-0.475295f, -0.858227f, -0.193754f),
		Vector3DFloat(-0.002138f, -0.163379f, -0.986561f),
		Vector3DFloat(+0.762016f, +0.464503f, -0.451186f),
		Vector3DFloat(+0.110962f, +0.350977f, +0.929786f),
		Vector3DFloat(+0.359220f, -0.409270f, +0.838725f),
		Vector3DFloat(+0.067679f, -0.492517f, -0.867667f),
		Vector3DFloat(-0.765643f, -0.627245f, -0.142671f),
		Vector3DFloat(-0.736364f, -0.613024f, -0.286304f),
		Vector3DFloat(-0.404067f, -0.396451f, +0.824352f),
		Vector3DFloat(-0.908793f, +0.158289f, +0.386057f),
		Vector3DFloat(-0.582767f, +0.467557f, +0.664660f),
		Vector3DFloat(+0.437506f, -0.078200f, -0.895809f),
		Vector3DFloat(+0.079580f, -0.165593f, -0.982978f),
		Vector3DFloat(-0.152308f, +0.193183f, +0.969269f),
		Vector3DFloat(+0.537776f, -0.029450f, -0.842573f),
		Vector3DFloat(+0.242145f, -0.450593f, +0.859262f),
		Vector3DFloat(-0.731540f, -0.287459f, +0.618237f),
		Vector3DFloat(-0.822775f, +0.200303f, +0.531903f),
		Vector3DFloat(+0.814744f, -0.396544f, +0.423019f),
		Vector3DFloat(+0.981241f, +0.108708f, -0.159215f),
		Vector3DFloat(+0.435099f, -0.134466f, -0.890285f),
		Vector3DFloat(-0.863642f, -0.333093f, +0.378379f),
		Vector3DFloat(+0.975214f, -0.007932f, +0.221121f),
		Vector3DFloat(+0.562312f, +0.756514f, -0.333904f),
		Vector3DFloat(-0.860757f, -0.321366f, -0.394743f),
		Vector3DFloat(+0.202468f, +0.651174f, +0.731423f),
		Vector3DFloat(+0.070835f, -0.997485f, -0.002525f),
		Vector3DFloat(-0.282142f, -0.646099f, +0.709191f),
		Vector3DFloat(+0.734636f, +0.546486f, -0.402073f),
		Vector3DFloat(-0.792802f, +0.359455f, -0.492196f),
		Vector3DFloat(+0.064556f, -0.768826f, +0.636192f),
		Vector3DFloat(-0.387159f, -0.539262f, +0.747867f),
		Vector3DFloat(-0.321231f, +0.945995f, +0.043642f),
		Vector3DFloat(-0.051543f, -0.358058f, +0.932276f),
		Vector3DFloat(+0.463676f, -0.211202f, +0.860464f),
		Vector3DFloat(-0.985546f, -0.040806f, -0.164421f),
		Vector3DFloat(-0.956965f, +0.289910f, -0.013071f),
		Vector3DFloat(-0.575614f, -0.401429f, -0.712406f),
		Vector3DFloat(+0.005411f, +0.912319f, +0.409443f),
		Vector3DFloat(-0.147120f, +0.145609f, +0.978342f),
		Vector3DFloat(+0.381181f, -0.303247f, +0.873351f),
		Vector3DFloat(+0.646964f, -0.669990f, -0.364076f),
		Vector3DFloat(+0.335662f, -0.334853f, +0.880457f),
		Vector3DFloat(+0.812790f, -0.515621f, -0.271122f),
		Vector3DFloat(+0.406265f, +0.443117f, -0.799122f),
		Vector3DFloat(+0.818068f, +0.142779f, +0.557117f),
		Vector3DFloat(-0.202146f, +0.482979f, +0.851979f),
		Vector3DFloat(-0.359491f, -0.834883f, +0.416817f),
		Vector3DFloat(+0.897243f, +0.373837f, -0.234949f),
		Vector3DFloat(+0.734938f, -0.377211f, -0.563541f),
		Vector3DFloat(+0.938936f, +0.089082f, +0.332362f),
		Vector3DFloat(+0.847286f, +0.101367f, -0.521375f),
		Vector3DFloat(+0.976962f, +0.212808f, -0.016060f),
		Vector3DFloat(-0.484037f, -0.785288f, -0.386045f),
		Vector3DFloat(+0.412432f, -0.846393f, -0.336925f),
		Vector3DFloat(-0.290605f, -0.951829f, +0.097828f),
		Vector3DFloat(+0.522856f, +0.099925f, -0.846544f),
		Vector3DFloat(-0.268624f, -0.592962f, +0.759103f),
		Vector3DFloat(+0.532873f, -0.247493f, +0.809193f),
		Vector3DFloat(-0.313247f, +0.857502f, -0.408126f),
		Vector3DFloat(-0.279136f, +0.481391f, +0.830870f),
		Vector3DFloat(-0.648063f, -0.437447f, -0.623422f),
		Vector3DFloat(+0.693159f, -0.411042f, +0.592094f),
		Vector3DFloat(-0.361556f, -0.008347f, -0.932313f),
		Vector3DFloat(-0.706752f, -0.017905f, +0.707235f),
		Vector3DFloat(+0.277671f, +0.588210f, +0.759544f),
		Vector3DFloat(+0.706147f, +0.436673f, -0.557380f),
		Vector3DFloat(+0.329465f, -0.938612f, -0.102275f),
		Vector3DFloat(+0.941491f, +0.304731f, -0.143996f),
		Vector3DFloat(-0.530440f, -0.419970f, -0.736382f),
		Vector3DFloat(-0.933059f, +0.333768f, -0.134161f),
		Vector3DFloat(-0.799598f, -0.383384f, -0.462234f),
		Vector3DFloat(+0.589799f, +0.017619f, -0.807358f),
		Vector3DFloat(-0.157486f, -0.147213f, +0.976487f),
		Vector3DFloat(+0.144612f, -0.765441f, +0.627046f),
		Vector3DFloat(-0.224062f, +0.971686f, +0.074988f),
		Vector3DFloat(-0.525446f, +0.743496f, +0.413666f),
		Vector3DFloat(+0.913834f, -0.396502f, +0.087711f),
		Vector3DFloat(+0.551810f, +0.713484f, -0.431793f),
		Vector3DFloat(-0.988855f, +0.027355f, +0.146346f),
		Vector3DFloat(+0.129678f, -0.922163f, +0.364417f),
		Vector3DFloat(-0.443546f, +0.337851f, +0.830135f),
		Vector3DFloat(-0.076099f, -0.128182f, -0.988827f),
		Vector3DFloat(-0.930714f, -0.363326f, +0.042022f),
		Vector3DFloat(-0.062724f, +0.597013f, -0.799776f),
		Vector3DFloat(+0.674612f, -0.080125f, +0.733811f),
		Vector3DFloat(-0.732149f, -0.106968f, -0.672693f),
		Vector3DFloat(-0.477404f, -0.735544f, +0.480688f),
		Vector3DFloat(+0.720306f, +0.691043f, +0.060162f),
		Vector3DFloat(-0.480694f, -0.691928f, -0.538673f),
		Vector3DFloat(+0.284364f, -0.490827f, +0.823545f),
		Vector3DFloat(-0.467068f, -0.635840f, +0.614455f),
		Vector3DFloat(+0.259424f, +0.728928f, +0.633532f),
		Vector3DFloat(-0.829024f, +0.499711f, +0.251015f),
		Vector3DFloat(+0.918101f, +0.199840f, +0.342278f),
		Vector3DFloat(-0.132256f, +0.844697f, -0.518648f),
		Vector3DFloat(-0.880945f, +0.470246f, +0.052958f),
		Vector3DFloat(-0.907893f, +0.418701f, -0.020494f),
		Vector3DFloat(-0.898489f, +0.435552f, -0.054882f),
		Vector3DFloat(-0.181486f, -0.981241f, -0.065032f),
		Vector3DFloat(+0.612484f, -0.390415f, -0.687342f),
		Vector3DFloat(-0.674745f, +0.504350f, +0.538841f),
		Vector3DFloat(-0.489037f, -0.427926f, +0.760080f),
		Vector3DFloat(-0.629283f, +0.776741f, +0.026012f),
		Vector3DFloat(-0.327015f, +0.559793f, +0.761375f),
		Vector3DFloat(+0.143982f, -0.052568f, +0.988183f),
		Vector3DFloat(+0.963642f, +0.246339f, -0.103498f),
		Vector3DFloat(+0.083550f, +0.206217f, +0.974933f),
		Vector3DFloat(+0.985008f, +0.097629f, -0.142221f),
		Vector3DFloat(+0.386516f, -0.544556f, +0.744355f),
		Vector3DFloat(-0.390134f, -0.377051f, +0.840017f),
		Vector3DFloat(+0.188428f, -0.872526f, -0.450770f),
		Vector3DFloat(-0.249415f, +0.963139f, +0.100774f),
		Vector3DFloat(-0.246900f, -0.688081f, +0.682338f),
		Vector3DFloat(-0.815515f, -0.341331f, -0.467363f),
		Vector3DFloat(-0.828295f, -0.545972f, +0.125866f),
		Vector3DFloat(-0.251196f, +0.860882f, +0.442473f),
		Vector3DFloat(+0.787130f, -0.124629f, -0.604065f),
		Vector3DFloat(-0.546825f, -0.350565f, +0.760320f),
		Vector3DFloat(+0.910761f, +0.326941f, +0.252237f),
		Vector3DFloat(-0.822947f, -0.029868f, +0.567332f),
		Vector3DFloat(-0.119863f, -0.101264f, +0.987612f),
		Vector3DFloat(+0.338978f, +0.251339f, +0.906600f),
		Vector3DFloat(-0.168116f, +0.130641f, +0.977072f),
		Vector3DFloat(+0.630274f, -0.051172f, +0.774685f),
		Vector3DFloat(+0.509020f, +0.860289f, -0.028316f),
		Vector3DFloat(-0.741184f, +0.614383f, -0.270518f),
		Vector3DFloat(+0.783367f, +0.216068f, -0.582796f),
		Vector3DFloat(-0.917044f, -0.239253f, -0.319042f),
		Vector3DFloat(+0.326503f, +0.605534f, +0.725758f),
		Vector3DFloat(-0.858028f, +0.033090f, +0.512536f),
		Vector3DFloat(+0.920390f, +0.341687f, +0.190084f),
		Vector3DFloat(+0.184870f, +0.206034f, -0.960923f),
		Vector3DFloat(-0.320575f, -0.873361f, -0.366704f),
		Vector3DFloat(-0.908564f, +0.179683f, -0.377129f),
		Vector3DFloat(-0.995162f, +0.060094f, -0.077721f),
		Vector3DFloat(-0.970805f, +0.057864f, +0.232786f),
		Vector3DFloat(-0.438989f, -0.719230f, -0.538514f),
		Vector3DFloat(-0.305764f, +0.586163f, +0.750281f),
		Vector3DFloat(+0.813263f, +0.070638f, +0.577593f),
		Vector3DFloat(-0.856072f, +0.356367f, -0.374356f),
		Vector3DFloat(-0.291393f, -0.496711f, -0.817538f),
		Vector3DFloat(-0.465919f, +0.423021f, +0.777157f),
		Vector3DFloat(-0.197288f, +0.747479f, +0.634312f),
		Vector3DFloat(+0.459532f, -0.294706f, +0.837842f),
		Vector3DFloat(-0.669432f, -0.715572f, -0.199543f),
		Vector3DFloat(+0.651361f, +0.729418f, -0.208995f),
		Vector3DFloat(+0.899675f, -0.409092f, +0.152409f),
		Vector3DFloat(-0.909013f, +0.374561f, +0.182756f),
		Vector3DFloat(+0.584390f, +0.675714f, -0.449332f),
		Vector3DFloat(-0.679644f, +0.693287f, -0.239658f),
		Vector3DFloat(-0.447022f, -0.041260f, +0.893571f),
		Vector3DFloat(-0.116547f, +0.050542f, -0.991898f),
		Vector3DFloat(+0.395893f, +0.741111f, -0.542239f),
		Vector3DFloat(+0.350204f, -0.445076f, -0.824175f),
		Vector3DFloat(-0.172775f, +0.743090f, -0.646503f),
		Vector3DFloat(+0.990144f, +0.139743f, -0.009361f),
		Vector3DFloat(+0.519086f, +0.780496f, -0.348389f),
		Vector3DFloat(-0.437746f, -0.398253f, +0.806085f),
		Vector3DFloat(-0.008119f, +0.986280f, -0.164880f),
		Vector3DFloat(+0.597715f, -0.604411f, -0.526711f),
		Vector3DFloat(-0.097509f, +0.175580f, -0.979624f),
		Vector3DFloat(+0.660655f, -0.124974f, +0.740214f),
		Vector3DFloat(-0.206022f, +0.283440f, -0.936599f),
		Vector3DFloat(-0.702342f, +0.672455f, -0.233496f),
		Vector3DFloat(+0.306125f, -0.350950f, -0.884942f),
		Vector3DFloat(+0.572172f, -0.424424f, -0.701772f),
		Vector3DFloat(-0.218533f, -0.939401f, -0.264138f),
		Vector3DFloat(+0.409469f, -0.491877f, -0.768370f),
		Vector3DFloat(-0.651781f, -0.191800f, +0.733754f),
		Vector3DFloat(+0.900352f, -0.242264f, -0.361490f),
		Vector3DFloat(+0.809489f, +0.255902f, -0.528434f),
		Vector3DFloat(+0.615724f, -0.777952f, +0.125199f),
		Vector3DFloat(-0.337892f, -0.510143f, -0.790938f),
		Vector3DFloat(-0.326182f, -0.695879f, +0.639811f),
		Vector3DFloat(-0.877877f, -0.220692f, +0.425002f),
		Vector3DFloat(+0.837897f, -0.278492f, -0.469436f),
		Vector3DFloat(-0.802587f, -0.151114f, +0.577077f),
		Vector3DFloat(+0.409855f, +0.796889f, -0.443832f),
		Vector3DFloat(-0.374483f, +0.669830f, -0.641164f),
		Vector3DFloat(-0.745860f, +0.343937f, -0.570438f),
		Vector3DFloat(-0.202905f, +0.156353f, +0.966635f),
		Vector3DFloat(+0.556026f, +0.322254f, -0.766151f),
		Vector3DFloat(+0.776714f, +0.240272f, -0.582224f),
		Vector3DFloat(-0.125301f, +0.638214f, -0.759594f),
		Vector3DFloat(+0.399976f, +0.226329f, -0.888141f),
		Vector3DFloat(-0.704797f, +0.579196f, -0.409625f),
		Vector3DFloat(-0.007629f, +0.072037f, +0.997373f),
		Vector3DFloat(-0.284284f, +0.861559f, +0.420592f),
		Vector3DFloat(+0.775941f, +0.385137f, -0.499586f),
		Vector3DFloat(-0.234994f, +0.400120f, +0.885823f),
		Vector3DFloat(+0.575813f, +0.632406f, +0.518172f),
		Vector3DFloat(+0.076477f, +0.592931f, -0.801613f),
		Vector3DFloat(+0.603536f, -0.788719f, -0.116900f),
		Vector3DFloat(-0.301173f, -0.779883f, -0.548705f),
		Vector3DFloat(-0.315064f, -0.948217f, +0.040230f),
		Vector3DFloat(+0.332902f, +0.851413f, -0.405304f),
		Vector3DFloat(-0.403429f, +0.778318f, +0.481110f),
		Vector3DFloat(-0.213870f, +0.976545f, +0.024873f),
		Vector3DFloat(-0.753760f, -0.519440f, +0.402528f),
		Vector3DFloat(-0.293424f, +0.935690f, -0.195925f),
		Vector3DFloat(-0.370354f, +0.922391f, -0.109697f),
		Vector3DFloat(+0.278418f, +0.666623f, +0.691445f),
		Vector3DFloat(-0.284329f, +0.930765f, +0.229857f),
		Vector3DFloat(+0.860824f, -0.367097f, -0.352452f),
		Vector3DFloat(+0.541854f, -0.702580f, -0.461275f),
		Vector3DFloat(+0.912176f, +0.185368f, -0.365478f),
		Vector3DFloat(+0.168057f, +0.931969f, -0.321232f),
		Vector3DFloat(-0.267320f, +0.845122f, +0.462934f),
		Vector3DFloat(-0.201487f, +0.198600f, +0.959146f),
		Vector3DFloat(-0.839945f, -0.276826f, -0.466754f),
		Vector3DFloat(-0.740956f, -0.484640f, +0.464874f),
		Vector3DFloat(-0.383491f, +0.705487f, -0.596006f),
		Vector3DFloat(-0.954405f, -0.026765f, -0.297313f),
		Vector3DFloat(+0.468574f, +0.859438f, +0.204460f),
		Vector3DFloat(-0.940360f, +0.331786f, +0.075105f),
		Vector3DFloat(-0.852277f, +0.454172f, -0.259522f),
		Vector3DFloat(-0.759647f, +0.519837f, -0.390776f),
		Vector3DFloat(+0.111525f, -0.475265f, -0.872746f),
		Vector3DFloat(-0.452079f, -0.035104f, +0.891287f),
		Vector3DFloat(+0.390392f, -0.669936f, -0.631490f),
		Vector3DFloat(-0.292073f, +0.321693f, -0.900670f),
		Vector3DFloat(+0.104005f, +0.994338f, +0.021788f),
		Vector3DFloat(+0.960865f, +0.271665f, +0.054189f),
		Vector3DFloat(-0.723235f, +0.690428f, +0.015487f),
		Vector3DFloat(+0.179328f, -0.278614f, +0.943513f),
		Vector3DFloat(+0.673808f, +0.589682f, +0.445263f),
		Vector3DFloat(+0.731197f, +0.497511f, +0.466726f),
		Vector3DFloat(+0.153734f, -0.134017f, +0.978982f),
		Vector3DFloat(+0.456781f, -0.221267f, -0.861622f),
		Vector3DFloat(+0.688864f, +0.648593f, +0.323719f),
		Vector3DFloat(-0.036351f, +0.715024f, -0.698155f),
		Vector3DFloat(+0.979208f, -0.118292f, +0.164797f),
		Vector3DFloat(-0.543655f, -0.797469f, -0.261692f),
		Vector3DFloat(+0.474224f, -0.342549f, -0.811031f),
		Vector3DFloat(+0.455954f, +0.830262f, +0.320580f),
		Vector3DFloat(+0.050584f, -0.993831f, -0.098696f),
		Vector3DFloat(-0.061916f, +0.662832f, +0.746204f),
		Vector3DFloat(+0.153491f, -0.981695f, +0.112766f),
		Vector3DFloat(-0.303003f, +0.664435f, +0.683165f),
		Vector3DFloat(+0.490302f, +0.248088f, -0.835497f),
		Vector3DFloat(-0.909045f, +0.282351f, -0.306455f),
		Vector3DFloat(+0.412988f, -0.552647f, +0.723894f),
		Vector3DFloat(-0.254003f, -0.874419f, +0.413370f),
		Vector3DFloat(-0.254922f, +0.922643f, -0.289387f),
		Vector3DFloat(+0.788379f, -0.515671f, +0.335474f),
		Vector3DFloat(+0.704882f, -0.446475f, -0.551182f),
		Vector3DFloat(+0.446454f, +0.893141f, -0.054572f),
		Vector3DFloat(-0.139484f, +0.078095f, -0.987140f),
		Vector3DFloat(+0.196257f, -0.117325f, -0.973508f),
		Vector3DFloat(-0.887951f, -0.452728f, +0.081119f),
		Vector3DFloat(+0.482286f, +0.838290f, -0.254304f),
		Vector3DFloat(-0.085400f, +0.836828f, +0.540764f),
		Vector3DFloat(-0.033243f, -0.288034f, +0.957043f),
		Vector3DFloat(+0.262770f, -0.771585f, +0.579318f),
		Vector3DFloat(-0.911785f, -0.235533f, +0.336411f),
		Vector3DFloat(+0.927275f, +0.367451f, -0.071696f),
		Vector3DFloat(+0.771172f, -0.229858f, +0.593683f),
		Vector3DFloat(-0.375316f, -0.068341f, -0.924374f),
		Vector3DFloat(-0.735343f, +0.284450f, -0.615109f),
		Vector3DFloat(-0.985363f, +0.154529f, +0.071973f),
		Vector3DFloat(-0.544949f, +0.792232f, -0.274589f),
		Vector3DFloat(-0.565066f, -0.783807f, -0.257579f),
		Vector3DFloat(-0.188990f, +0.764476f, -0.616328f),
		Vector3DFloat(+0.011964f, -0.681395f, +0.731818f),
		Vector3DFloat(+0.647082f, +0.652894f, -0.393719f),
		Vector3DFloat(-0.883463f, +0.088810f, -0.460006f),
		Vector3DFloat(-0.443140f, -0.048579f, -0.895135f),
		Vector3DFloat(+0.925708f, +0.333853f, -0.177785f),
		Vector3DFloat(-0.057825f, -0.850139f, +0.523373f),
		Vector3DFloat(+0.376782f, +0.740216f, +0.556881f),
		Vector3DFloat(-0.711665f, -0.184658f, -0.677816f),
		Vector3DFloat(+0.410214f, -0.115790f, -0.904609f),
		Vector3DFloat(+0.382722f, +0.646393f, -0.660076f),
		Vector3DFloat(-0.300767f, -0.354337f, +0.885429f),
		Vector3DFloat(+0.568398f, +0.272778f, +0.776219f),
		Vector3DFloat(-0.157935f, +0.980750f, +0.114830f),
		Vector3DFloat(+0.359219f, +0.495150f, -0.791068f),
		Vector3DFloat(-0.349238f, +0.056262f, -0.935344f),
		Vector3DFloat(-0.633800f, +0.743629f, +0.212869f),
		Vector3DFloat(+0.097107f, -0.993326f, -0.062246f),
		Vector3DFloat(+0.372454f, -0.806078f, -0.459908f),
		Vector3DFloat(-0.263428f, +0.934015f, +0.241290f),
		Vector3DFloat(-0.943443f, +0.122444f, +0.308095f),
		Vector3DFloat(+0.408781f, +0.502375f, -0.761917f),
		Vector3DFloat(+0.697179f, -0.332546f, -0.635102f),
		Vector3DFloat(-0.491802f, +0.870583f, -0.014715f),
		Vector3DFloat(+0.737536f, -0.656902f, +0.156592f),
		Vector3DFloat(+0.827336f, -0.246097f, +0.504928f),
		Vector3DFloat(-0.446202f, +0.667651f, +0.595941f),
		Vector3DFloat(-0.964936f, -0.243630f, +0.097691f),
		Vector3DFloat(+0.897134f, -0.435766f, -0.072518f),
		Vector3DFloat(-0.669699f, -0.151247f, -0.727068f),
		Vector3DFloat(-0.016765f, -0.955618f, +0.294130f),
		Vector3DFloat(-0.230630f, +0.832879f, -0.503112f),
		Vector3DFloat(+0.899464f, +0.318825f, -0.298856f),
		Vector3DFloat(+0.058885f, -0.789911f, +0.610388f),
		Vector3DFloat(+0.659402f, +0.666930f, +0.346977f),
		Vector3DFloat(+0.284813f, -0.414001f, -0.864572f),
		Vector3DFloat(+0.484149f, -0.789140f, -0.377964f),
		Vector3DFloat(+0.738956f, +0.298547f, -0.603998f),
		Vector3DFloat(+0.136326f, +0.352541f, -0.925813f),
		Vector3DFloat(+0.868090f, +0.478579f, +0.131841f),
		Vector3DFloat(+0.446372f, -0.633533f, -0.631972f),
		Vector3DFloat(-0.464744f, -0.873724f, +0.143596f),
		Vector3DFloat(-0.157889f, +0.556623f, -0.815624f),
		Vector3DFloat(-0.916952f, -0.270205f, +0.293579f),
		Vector3DFloat(-0.968515f, +0.157169f, -0.193071f),
		Vector3DFloat(-0.428526f, -0.889206f, +0.160242f),
		Vector3DFloat(+0.396152f, +0.173085f, +0.901724f),
		Vector3DFloat(+0.966792f, +0.160015f, -0.199271f),
		Vector3DFloat(-0.912490f, -0.111826f, +0.393519f),
		Vector3DFloat(+0.866392f, -0.192509f, -0.460765f),
		Vector3DFloat(+0.480992f, +0.492893f, -0.725054f),
		Vector3DFloat(-0.355535f, +0.884194f, +0.302977f),
		Vector3DFloat(+0.980976f, -0.055915f, +0.185905f),
		Vector3DFloat(-0.740688f, +0.154276f, -0.653896f),
		Vector3DFloat(+0.193789f, -0.135151f, -0.971689f),
		Vector3DFloat(-0.301940f, -0.417607f, -0.856993f),
		Vector3DFloat(-0.519232f, +0.773966f, -0.362455f),
		Vector3DFloat(+0.938672f, -0.020909f, -0.344177f),
		Vector3DFloat(+0.637853f, -0.449939f, +0.625058f),
		Vector3DFloat(+0.544105f, -0.664601f, -0.512109f),
		Vector3DFloat(-0.170728f, -0.774921f, +0.608563f),
		Vector3DFloat(+0.669668f, +0.441721f, -0.597016f),
		Vector3DFloat(-0.311388f, -0.044999f, -0.949217f),
		Vector3DFloat(+0.146744f, +0.375501f, +0.915131f),
		Vector3DFloat(-0.703678f, -0.557559f, -0.440414f),
		Vector3DFloat(-0.470187f, +0.695298f, +0.543585f),
		Vector3DFloat(-0.254132f, -0.184139f, +0.949479f),
		Vector3DFloat(-0.900622f, +0.005714f, +0.434565f),
		Vector3DFloat(-0.014656f, +0.303063f, -0.952858f),
		Vector3DFloat(-0.865696f, -0.264074f, +0.425247f),
		Vector3DFloat(+0.481061f, +0.842497f, +0.242445f),
		Vector3DFloat(-0.450784f, +0.137271f, +0.882015f),
		Vector3DFloat(+0.091619f, +0.964503f, +0.247669f),
		Vector3DFloat(-0.135659f, -0.122365f, +0.983170f),
		Vector3DFloat(-0.322292f, +0.502269f, +0.802405f),
		Vector3DFloat(+0.157842f, +0.435303f, +0.886339f),
		Vector3DFloat(+0.158697f, -0.622087f, -0.766696f),
		Vector3DFloat(+0.427134f, -0.647168f, -0.631451f),
		Vector3DFloat(-0.101271f, +0.917326f, +0.385042f),
		Vector3DFloat(-0.351641f, -0.653340f, -0.670445f),
		Vector3DFloat(-0.903498f, -0.392917f, +0.171195f),
		Vector3DFloat(+0.227012f, -0.849095f, -0.476974f),
		Vector3DFloat(-0.094069f, -0.890637f, +0.444878f),
		Vector3DFloat(+0.803352f, -0.594284f, -0.038110f),
		Vector3DFloat(-0.094739f, -0.865030f, -0.492695f),
		Vector3DFloat(+0.264702f, -0.854667f, +0.446629f),
		Vector3DFloat(-0.897678f, +0.277821f, -0.342037f),
		Vector3DFloat(-0.327036f, +0.939653f, +0.100497f),
		Vector3DFloat(-0.826248f, -0.337885f, -0.450719f),
		Vector3DFloat(+0.066622f, -0.956883f, +0.282730f),
		Vector3DFloat(-0.746913f, -0.121996f, +0.653635f),
		Vector3DFloat(-0.671734f, +0.736418f, +0.080385f),
		Vector3DFloat(+0.693715f, +0.576755f, -0.431408f),
		Vector3DFloat(-0.788320f, -0.082995f, -0.609642f),
		Vector3DFloat(-0.456573f, +0.863290f, -0.215108f),
		Vector3DFloat(-0.622201f, +0.453957f, +0.637800f),
		Vector3DFloat(+0.723922f, +0.655748f, +0.214319f),
		Vector3DFloat(+0.882913f, -0.420816f, -0.208276f),
		Vector3DFloat(-0.926551f, +0.212056f, -0.310703f),
		Vector3DFloat(+0.388695f, -0.691965f, +0.608358f),
		Vector3DFloat(+0.728427f, +0.198534f, -0.655728f),
		Vector3DFloat(+0.319262f, +0.105299f, +0.941798f),
		Vector3DFloat(-0.333911f, +0.881805f, +0.333050f),
		Vector3DFloat(+0.245338f, -0.611922f, -0.751904f),
		Vector3DFloat(+0.220061f, -0.101481f, -0.970193f),
		Vector3DFloat(+0.930032f, -0.311841f, +0.194412f),
		Vector3DFloat(+0.048087f, -0.993913f, +0.099115f),
		Vector3DFloat(-0.275537f, +0.705669f, +0.652772f),
		Vector3DFloat(+0.383019f, -0.163631f, -0.909132f),
		Vector3DFloat(-0.135900f, -0.988939f, +0.059414f),
		Vector3DFloat(-0.662199f, +0.747009f, +0.058896f),
		Vector3DFloat(-0.124689f, +0.015288f, +0.992078f),
		Vector3DFloat(+0.489432f, -0.555663f, -0.672082f),
		Vector3DFloat(-0.780927f, -0.255976f, +0.569763f),
		Vector3DFloat(+0.694171f, +0.278571f, -0.663720f),
		Vector3DFloat(-0.604581f, -0.463542f, -0.647774f),
		Vector3DFloat(-0.676259f, -0.684602f, -0.272018f),
		Vector3DFloat(+0.494855f, -0.701192f, -0.513272f),
		Vector3DFloat(+0.565633f, +0.823079f, +0.050993f),
		Vector3DFloat(+0.050237f, -0.998492f, +0.022122f),
		Vector3DFloat(-0.386389f, -0.893963f, -0.227011f),
		Vector3DFloat(+0.888703f, -0.437519f, -0.137056f),
		Vector3DFloat(-0.914197f, +0.390980f, +0.106670f),
		Vector3DFloat(+0.778906f, -0.627140f, -0.001437f),
		Vector3DFloat(-0.603014f, +0.672265f, -0.429458f),
		Vector3DFloat(+0.501042f, -0.665212f, +0.553579f),
		Vector3DFloat(-0.995164f, +0.092308f, -0.033577f),
		Vector3DFloat(-0.998104f, +0.018497f, +0.058712f),
		Vector3DFloat(+0.929569f, +0.123842f, -0.347225f),
		Vector3DFloat(+0.235077f, -0.609238f, +0.757343f),
		Vector3DFloat(-0.452902f, -0.887545f, +0.084525f),
		Vector3DFloat(-0.137550f, -0.488131f, -0.861863f),
		Vector3DFloat(+0.660545f, -0.371465f, +0.652453f),
		Vector3DFloat(+0.747313f, -0.657236f, +0.097799f),
		Vector3DFloat(-0.543312f, -0.315699f, -0.777911f),
		Vector3DFloat(+0.189959f, -0.346861f, +0.918478f),
		Vector3DFloat(+0.323571f, +0.300781f, +0.897125f),
		Vector3DFloat(-0.482606f, +0.875832f, -0.003165f),
		Vector3DFloat(-0.936502f, +0.291824f, -0.194430f),
		Vector3DFloat(-0.503609f, -0.390560f, +0.770610f),
		Vector3DFloat(-0.540142f, +0.002774f, -0.841569f),
		Vector3DFloat(-0.085055f, -0.996376f, -0.000148f),
		Vector3DFloat(-0.615309f, +0.059981f, -0.786000f),
		Vector3DFloat(+0.718191f, +0.505958f, -0.477711f),
		Vector3DFloat(-0.167397f, +0.844465f, -0.508780f),
		Vector3DFloat(+0.636446f, -0.344036f, -0.690345f),
		Vector3DFloat(+0.663267f, +0.700418f, -0.263613f),
		Vector3DFloat(+0.602334f, +0.435514f, +0.668970f),
		Vector3DFloat(-0.275820f, -0.393792f, +0.876842f),
		Vector3DFloat(+0.437736f, -0.747931f, +0.498986f),
		Vector3DFloat(+0.882319f, +0.417138f, +0.217965f),
		Vector3DFloat(-0.851108f, -0.482384f, -0.207174f),
		Vector3DFloat(+0.320590f, +0.898664f, +0.299375f),
		Vector3DFloat(-0.621201f, -0.614972f, +0.485714f),
		Vector3DFloat(+0.911173f, +0.041873f, +0.409892f),
		Vector3DFloat(+0.729444f, +0.142692f, -0.668992f),
		Vector3DFloat(+0.666307f, -0.735324f, +0.123831f),
		Vector3DFloat(+0.463591f, +0.847227f, -0.259402f),
		Vector3DFloat(+0.894296f, +0.059634f, +0.443484f),
		Vector3DFloat(-0.736335f, -0.674274f, +0.056256f),
		Vector3DFloat(+0.469502f, -0.733536f, +0.491420f),
		Vector3DFloat(-0.391723f, -0.837099f, +0.381861f),
		Vector3DFloat(-0.437372f, -0.437618f, -0.785618f),
		Vector3DFloat(-0.203384f, -0.343038f, -0.917039f),
		Vector3DFloat(-0.945306f, +0.221497f, +0.239450f),
		Vector3DFloat(+0.773091f, +0.496793f, +0.394369f),
		Vector3DFloat(-0.710103f, +0.093103f, +0.697915f),
		Vector3DFloat(-0.456786f, +0.151779f, +0.876533f),
		Vector3DFloat(+0.373153f, +0.587166f, -0.718326f),
		Vector3DFloat(-0.559785f, -0.793881f, +0.237473f),
		Vector3DFloat(-0.884665f, +0.422952f, +0.196163f),
		Vector3DFloat(-0.468879f, +0.300549f, -0.830556f),
		Vector3DFloat(+0.958105f, +0.285330f, -0.024919f),
		Vector3DFloat(+0.825326f, -0.423197f, -0.373819f),
		Vector3DFloat(-0.034122f, +0.999414f, +0.002781f),
		Vector3DFloat(-0.904795f, -0.041789f, -0.423792f),
		Vector3DFloat(-0.799927f, +0.541477f, -0.258687f),
		Vector3DFloat(+0.995132f, +0.000543f, -0.098546f),
		Vector3DFloat(+0.843984f, -0.507103f, -0.174749f),
		Vector3DFloat(-0.640934f, +0.618163f, +0.455058f),
		Vector3DFloat(+0.543397f, +0.492878f, +0.679553f),
		Vector3DFloat(+0.408980f, -0.467105f, +0.783932f),
		Vector3DFloat(+0.219682f, +0.823953f, +0.522343f),
		Vector3DFloat(+0.845523f, +0.410442f, -0.341509f),
		Vector3DFloat(-0.997099f, +0.057254f, -0.050159f),
		Vector3DFloat(+0.535588f, +0.112415f, +0.836964f),
		Vector3DFloat(+0.139015f, +0.182777f, +0.973277f),
		Vector3DFloat(+0.681261f, +0.731126f, -0.036585f),
		Vector3DFloat(-0.161589f, +0.986188f, -0.036352f),
		Vector3DFloat(-0.294098f, +0.640063f, +0.709806f),
		Vector3DFloat(+0.213370f, -0.880985f, -0.422301f),
		Vector3DFloat(-0.903331f, +0.383376f, +0.192395f),
		Vector3DFloat(+0.020283f, +0.989297f, -0.144498f),
		Vector3DFloat(+0.550858f, -0.603955f, +0.576016f),
		Vector3DFloat(-0.297499f, -0.396883f, -0.868319f),
		Vector3DFloat(-0.125581f, +0.971238f, +0.202303f),
		Vector3DFloat(+0.994606f, -0.096856f, +0.037125f),
		Vector3DFloat(+0.959844f, -0.254636f, -0.117729f),
		Vector3DFloat(-0.332961f, +0.808031f, +0.486028f),
		Vector3DFloat(+0.118411f, -0.818829f, +0.561692f),
		Vector3DFloat(-0.329010f, +0.932571f, +0.148536f),
		Vector3DFloat(+0.386616f, -0.386923f, -0.837149f),
		Vector3DFloat(+0.501223f, -0.201907f, -0.841433f),
		Vector3DFloat(+0.555119f, -0.793008f, -0.250959f),
		Vector3DFloat(-0.512485f, +0.850268f, -0.120011f),
		Vector3DFloat(+0.573352f, +0.737293f, +0.357306f),
		Vector3DFloat(+0.315311f, -0.182192f, +0.931335f),
		Vector3DFloat(+0.156167f, -0.963694f, -0.216579f),
		Vector3DFloat(-0.285174f, -0.542273f, +0.790326f),
		Vector3DFloat(-0.277593f, +0.668866f, +0.689609f),
		Vector3DFloat(+0.319798f, -0.921924f, +0.218599f),
		Vector3DFloat(-0.727455f, -0.686116f, -0.007338f),
		Vector3DFloat(+0.219712f, -0.952663f, +0.210141f),
		Vector3DFloat(+0.491792f, +0.552463f, -0.672997f),
		Vector3DFloat(-0.526640f, +0.820445f, +0.222533f)
	};
}

#endif //__PolyVox_RandomUnitVectors_H__
