<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{config('app.name')}</title>
    <link rel="shortcut icon" href="data:image/svg+xml;base64,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" />

    <style>

        html,body {
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #1a1d20;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            color: #dee2e6;
            height: 100%;
        }

        .d-flex {
            display: flex;
        }

        .justify-content-center {
            justify-content: center;
        }

        .align-items-center {
            align-items: center;
        }

        .ms-1 {
            margin-left: 0.25rem;
        }

        .me-1 {
            margin-right: 0.25rem;
        }

        .mb-1 {
            margin-bottom: 0.25rem;
        }

        .mt-1 {
            margin-top: 0.25rem;
        }

        .ms-2 {
            margin-left: 0.5rem;
        }

        .me-2 {
            margin-right: 0.5rem;
        }

        .mb-2 {
            margin-bottom: 0.5rem;
        }

        .mt-2 {
            margin-top: 0.5rem;
        }

        .ms-3 {
            margin-left: 1rem;
        }

        .me-3 {
            margin-right: 1rem;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .mt-3 {
            margin-top: 1rem;
        }

        .container {
            max-width: 600px;
            width: 100%;
            padding: 1rem;
        }

        .text-muted {
            color: #6c757d;
        }

        .card {
            background-color: #212529;
            border-radius: 0.25rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            overflow: hidden;
        }

        .card-body {
            padding: 2rem;
        }

        .card-footer {
            padding: 1rem 2rem;
            background-color: #343a40;
        }

        .badge {
            border-radius: 0.25rem;
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
            font-weight: 700;
            line-height: 1;
            display: inline-block;
            text-align: center;
        }

        .bg-secondary {
            background-color: #343a40;
            color: #aeb2b6;
        }

        .message {
            font-size: 1.25rem;
            margin-bottom: 0;
            font-weight: 500;
        }

        .text-secondary {
            color: #6c757d;
        }

        .justify-content-between {
            justify-content: space-between;
        }

        .align-items-center {
            align-items: center;
        }

        .text-secondary a {
            color: #6c757d;
            text-decoration: none;
        }

        .text-secondary a:hover {
            color: #6c757d;
            text-decoration: underline;
        }

        .justify-content-end {
            justify-content: flex-end;
        }

        .justify-content-center {
            justify-content: center;
        }

        .text-center {
            text-align: center;
        }

        .mt-5 {
            margin-top: 3rem;
        }

        .m-0 {
            margin: 0;
        }

        code {
            font-size: 0.875rem;
            border-radius: 0.25rem;
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
            font-weight: 700;
            line-height: 1;
            display: inline-block;
            text-align: center;
            background-color: #343a40;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="card">
            <div class="card-body">
                <div class="d-flex">
                    <div class="me-3">
                        <img height="50px" alt="Phenomine" src="data:image/svg+xml;base64,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" />
                    </div>
                </div>

                <p class="message">
                    Welcome to The Phenomine Framework
                </p>
                <p class="text-white">
                Phenomine stands at the forefront of innovation in the realm of PHP development, offering a robust and efficient Model-View-Controller (MVC) framework. Designed with a commitment to excellence, Phenomine empowers developers with a versatile toolkit, combining power, speed, and simplicity for a seamless development experience.
                </p>
                <p class="text-secondary">
                    This page is located at <code>res/views/welcome.latte.php</code>. You can modify it according to your needs. If you want to learn more about Phenomine, you can visit the official website or read the documentation.
                </p>
            </div>
            <div class="card-footer">
                <div class="text-secondary">
                    <a href="https://github.com/phenomine" class="me-3">
                        See on GitHub
                    </a>
                    <a href="https://phenomine.spentura.com">
                        Read the docs
                    </a>
                </div>
            </div>
        </div>
        <div class="text-center mt-5">
            <small class="text-secondary">Build v.{Phenomine\Support\Application::VERSION} running with PHP {phpversion()}</small>
            <p class="m-0"><small class="text-secondary">The Phenomine Framework</small></p>
            <p class="m-0"><small class="text-secondary">Built in Indonesia by <a href="https://github.com/fahlisaputra">@fahlisaputra</a></p>
        </div>
    </div>
</body>

</html>
