//
// Copyright © 2021-present Peter M. Stahl pemistahl@gmail.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either expressed or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.9
// source: model.proto

package serialization

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SerializableLanguage represents a language that is serialized as a protocol
// buffer and stored on disk as a binary file. Even though this type is public,
// it is not meant to be used directly. It is used only internally for
// serialization and deserialization.
type SerializableLanguage int32

const (
	SerializableLanguage_AFRIKAANS   SerializableLanguage = 0
	SerializableLanguage_ALBANIAN    SerializableLanguage = 1
	SerializableLanguage_ARABIC      SerializableLanguage = 2
	SerializableLanguage_ARMENIAN    SerializableLanguage = 3
	SerializableLanguage_AZERBAIJANI SerializableLanguage = 4
	SerializableLanguage_BASQUE      SerializableLanguage = 5
	SerializableLanguage_BELARUSIAN  SerializableLanguage = 6
	SerializableLanguage_BENGALI     SerializableLanguage = 7
	SerializableLanguage_BOKMAL      SerializableLanguage = 8
	SerializableLanguage_BOSNIAN     SerializableLanguage = 9
	SerializableLanguage_BULGARIAN   SerializableLanguage = 10
	SerializableLanguage_CATALAN     SerializableLanguage = 11
	SerializableLanguage_CHINESE     SerializableLanguage = 12
	SerializableLanguage_CROATIAN    SerializableLanguage = 13
	SerializableLanguage_CZECH       SerializableLanguage = 14
	SerializableLanguage_DANISH      SerializableLanguage = 15
	SerializableLanguage_DUTCH       SerializableLanguage = 16
	SerializableLanguage_ENGLISH     SerializableLanguage = 17
	SerializableLanguage_ESPERANTO   SerializableLanguage = 18
	SerializableLanguage_ESTONIAN    SerializableLanguage = 19
	SerializableLanguage_FINNISH     SerializableLanguage = 20
	SerializableLanguage_FRENCH      SerializableLanguage = 21
	SerializableLanguage_GANDA       SerializableLanguage = 22
	SerializableLanguage_GEORGIAN    SerializableLanguage = 23
	SerializableLanguage_GERMAN      SerializableLanguage = 24
	SerializableLanguage_GREEK       SerializableLanguage = 25
	SerializableLanguage_GUJARATI    SerializableLanguage = 26
	SerializableLanguage_HEBREW      SerializableLanguage = 27
	SerializableLanguage_HINDI       SerializableLanguage = 28
	SerializableLanguage_HUNGARIAN   SerializableLanguage = 29
	SerializableLanguage_ICELANDIC   SerializableLanguage = 30
	SerializableLanguage_INDONESIAN  SerializableLanguage = 31
	SerializableLanguage_IRISH       SerializableLanguage = 32
	SerializableLanguage_ITALIAN     SerializableLanguage = 33
	SerializableLanguage_JAPANESE    SerializableLanguage = 34
	SerializableLanguage_KAZAKH      SerializableLanguage = 35
	SerializableLanguage_KOREAN      SerializableLanguage = 36
	SerializableLanguage_LATIN       SerializableLanguage = 37
	SerializableLanguage_LATVIAN     SerializableLanguage = 38
	SerializableLanguage_LITHUANIAN  SerializableLanguage = 39
	SerializableLanguage_MACEDONIAN  SerializableLanguage = 40
	SerializableLanguage_MALAY       SerializableLanguage = 41
	SerializableLanguage_MAORI       SerializableLanguage = 42
	SerializableLanguage_MARATHI     SerializableLanguage = 43
	SerializableLanguage_MONGOLIAN   SerializableLanguage = 44
	SerializableLanguage_NYNORSK     SerializableLanguage = 45
	SerializableLanguage_PERSIAN     SerializableLanguage = 46
	SerializableLanguage_POLISH      SerializableLanguage = 47
	SerializableLanguage_PORTUGUESE  SerializableLanguage = 48
	SerializableLanguage_PUNJABI     SerializableLanguage = 49
	SerializableLanguage_ROMANIAN    SerializableLanguage = 50
	SerializableLanguage_RUSSIAN     SerializableLanguage = 51
	SerializableLanguage_SERBIAN     SerializableLanguage = 52
	SerializableLanguage_SHONA       SerializableLanguage = 53
	SerializableLanguage_SLOVAK      SerializableLanguage = 54
	SerializableLanguage_SLOVENE     SerializableLanguage = 55
	SerializableLanguage_SOMALI      SerializableLanguage = 56
	SerializableLanguage_SOTHO       SerializableLanguage = 57
	SerializableLanguage_SPANISH     SerializableLanguage = 58
	SerializableLanguage_SWAHILI     SerializableLanguage = 59
	SerializableLanguage_SWEDISH     SerializableLanguage = 60
	SerializableLanguage_TAGALOG     SerializableLanguage = 61
	SerializableLanguage_TAMIL       SerializableLanguage = 62
	SerializableLanguage_TELUGU      SerializableLanguage = 63
	SerializableLanguage_THAI        SerializableLanguage = 64
	SerializableLanguage_TSONGA      SerializableLanguage = 65
	SerializableLanguage_TSWANA      SerializableLanguage = 66
	SerializableLanguage_TURKISH     SerializableLanguage = 67
	SerializableLanguage_UKRAINIAN   SerializableLanguage = 68
	SerializableLanguage_URDU        SerializableLanguage = 69
	SerializableLanguage_VIETNAMESE  SerializableLanguage = 70
	SerializableLanguage_WELSH       SerializableLanguage = 71
	SerializableLanguage_XHOSA       SerializableLanguage = 72
	SerializableLanguage_YORUBA      SerializableLanguage = 73
	SerializableLanguage_ZULU        SerializableLanguage = 74
)

// Enum value maps for SerializableLanguage.
var (
	SerializableLanguage_name = map[int32]string{
		0:  "AFRIKAANS",
		1:  "ALBANIAN",
		2:  "ARABIC",
		3:  "ARMENIAN",
		4:  "AZERBAIJANI",
		5:  "BASQUE",
		6:  "BELARUSIAN",
		7:  "BENGALI",
		8:  "BOKMAL",
		9:  "BOSNIAN",
		10: "BULGARIAN",
		11: "CATALAN",
		12: "CHINESE",
		13: "CROATIAN",
		14: "CZECH",
		15: "DANISH",
		16: "DUTCH",
		17: "ENGLISH",
		18: "ESPERANTO",
		19: "ESTONIAN",
		20: "FINNISH",
		21: "FRENCH",
		22: "GANDA",
		23: "GEORGIAN",
		24: "GERMAN",
		25: "GREEK",
		26: "GUJARATI",
		27: "HEBREW",
		28: "HINDI",
		29: "HUNGARIAN",
		30: "ICELANDIC",
		31: "INDONESIAN",
		32: "IRISH",
		33: "ITALIAN",
		34: "JAPANESE",
		35: "KAZAKH",
		36: "KOREAN",
		37: "LATIN",
		38: "LATVIAN",
		39: "LITHUANIAN",
		40: "MACEDONIAN",
		41: "MALAY",
		42: "MAORI",
		43: "MARATHI",
		44: "MONGOLIAN",
		45: "NYNORSK",
		46: "PERSIAN",
		47: "POLISH",
		48: "PORTUGUESE",
		49: "PUNJABI",
		50: "ROMANIAN",
		51: "RUSSIAN",
		52: "SERBIAN",
		53: "SHONA",
		54: "SLOVAK",
		55: "SLOVENE",
		56: "SOMALI",
		57: "SOTHO",
		58: "SPANISH",
		59: "SWAHILI",
		60: "SWEDISH",
		61: "TAGALOG",
		62: "TAMIL",
		63: "TELUGU",
		64: "THAI",
		65: "TSONGA",
		66: "TSWANA",
		67: "TURKISH",
		68: "UKRAINIAN",
		69: "URDU",
		70: "VIETNAMESE",
		71: "WELSH",
		72: "XHOSA",
		73: "YORUBA",
		74: "ZULU",
	}
	SerializableLanguage_value = map[string]int32{
		"AFRIKAANS":   0,
		"ALBANIAN":    1,
		"ARABIC":      2,
		"ARMENIAN":    3,
		"AZERBAIJANI": 4,
		"BASQUE":      5,
		"BELARUSIAN":  6,
		"BENGALI":     7,
		"BOKMAL":      8,
		"BOSNIAN":     9,
		"BULGARIAN":   10,
		"CATALAN":     11,
		"CHINESE":     12,
		"CROATIAN":    13,
		"CZECH":       14,
		"DANISH":      15,
		"DUTCH":       16,
		"ENGLISH":     17,
		"ESPERANTO":   18,
		"ESTONIAN":    19,
		"FINNISH":     20,
		"FRENCH":      21,
		"GANDA":       22,
		"GEORGIAN":    23,
		"GERMAN":      24,
		"GREEK":       25,
		"GUJARATI":    26,
		"HEBREW":      27,
		"HINDI":       28,
		"HUNGARIAN":   29,
		"ICELANDIC":   30,
		"INDONESIAN":  31,
		"IRISH":       32,
		"ITALIAN":     33,
		"JAPANESE":    34,
		"KAZAKH":      35,
		"KOREAN":      36,
		"LATIN":       37,
		"LATVIAN":     38,
		"LITHUANIAN":  39,
		"MACEDONIAN":  40,
		"MALAY":       41,
		"MAORI":       42,
		"MARATHI":     43,
		"MONGOLIAN":   44,
		"NYNORSK":     45,
		"PERSIAN":     46,
		"POLISH":      47,
		"PORTUGUESE":  48,
		"PUNJABI":     49,
		"ROMANIAN":    50,
		"RUSSIAN":     51,
		"SERBIAN":     52,
		"SHONA":       53,
		"SLOVAK":      54,
		"SLOVENE":     55,
		"SOMALI":      56,
		"SOTHO":       57,
		"SPANISH":     58,
		"SWAHILI":     59,
		"SWEDISH":     60,
		"TAGALOG":     61,
		"TAMIL":       62,
		"TELUGU":      63,
		"THAI":        64,
		"TSONGA":      65,
		"TSWANA":      66,
		"TURKISH":     67,
		"UKRAINIAN":   68,
		"URDU":        69,
		"VIETNAMESE":  70,
		"WELSH":       71,
		"XHOSA":       72,
		"YORUBA":      73,
		"ZULU":        74,
	}
)

func (x SerializableLanguage) Enum() *SerializableLanguage {
	p := new(SerializableLanguage)
	*p = x
	return p
}

func (x SerializableLanguage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SerializableLanguage) Descriptor() protoreflect.EnumDescriptor {
	return file_model_proto_enumTypes[0].Descriptor()
}

func (SerializableLanguage) Type() protoreflect.EnumType {
	return &file_model_proto_enumTypes[0]
}

func (x SerializableLanguage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SerializableLanguage.Descriptor instead.
func (SerializableLanguage) EnumDescriptor() ([]byte, []int) {
	return file_model_proto_rawDescGZIP(), []int{0}
}

// SerializableLanguageModel represents a statistical language model
// that is serialized as a protocol buffer and stored on disk as a binary file.
// Even though this struct is public, it is not meant to be used directly.
// It is used only internally for serialization and deserialization.
type SerializableLanguageModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Language    SerializableLanguage    `protobuf:"varint,1,opt,name=language,proto3,enum=lingua.SerializableLanguage" json:"language,omitempty"`
	NgramLength uint32                  `protobuf:"varint,2,opt,name=ngram_length,json=ngramLength,proto3" json:"ngram_length,omitempty"`
	TotalNgrams uint32                  `protobuf:"varint,3,opt,name=total_ngrams,json=totalNgrams,proto3" json:"total_ngrams,omitempty"`
	NgramSets   []*SerializableNgramSet `protobuf:"bytes,4,rep,name=ngram_sets,json=ngramSets,proto3" json:"ngram_sets,omitempty"`
}

func (x *SerializableLanguageModel) Reset() {
	*x = SerializableLanguageModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerializableLanguageModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializableLanguageModel) ProtoMessage() {}

func (x *SerializableLanguageModel) ProtoReflect() protoreflect.Message {
	mi := &file_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializableLanguageModel.ProtoReflect.Descriptor instead.
func (*SerializableLanguageModel) Descriptor() ([]byte, []int) {
	return file_model_proto_rawDescGZIP(), []int{0}
}

func (x *SerializableLanguageModel) GetLanguage() SerializableLanguage {
	if x != nil {
		return x.Language
	}
	return SerializableLanguage_AFRIKAANS
}

func (x *SerializableLanguageModel) GetNgramLength() uint32 {
	if x != nil {
		return x.NgramLength
	}
	return 0
}

func (x *SerializableLanguageModel) GetTotalNgrams() uint32 {
	if x != nil {
		return x.TotalNgrams
	}
	return 0
}

func (x *SerializableLanguageModel) GetNgramSets() []*SerializableNgramSet {
	if x != nil {
		return x.NgramSets
	}
	return nil
}

// SerializableNgramSet represents a collection of ngrams sharing the same
// probability within a specific language model that is serialized as a protocol
// buffer and stored on disk as a binary file. Even though this struct is public,
// it is not meant to be used directly. It is used only internally for
// serialization and deserialization.
type SerializableNgramSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Probability float64  `protobuf:"fixed64,1,opt,name=probability,proto3" json:"probability,omitempty"`
	Ngrams      []string `protobuf:"bytes,2,rep,name=ngrams,proto3" json:"ngrams,omitempty"`
}

func (x *SerializableNgramSet) Reset() {
	*x = SerializableNgramSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerializableNgramSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializableNgramSet) ProtoMessage() {}

func (x *SerializableNgramSet) ProtoReflect() protoreflect.Message {
	mi := &file_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializableNgramSet.ProtoReflect.Descriptor instead.
func (*SerializableNgramSet) Descriptor() ([]byte, []int) {
	return file_model_proto_rawDescGZIP(), []int{1}
}

func (x *SerializableNgramSet) GetProbability() float64 {
	if x != nil {
		return x.Probability
	}
	return 0
}

func (x *SerializableNgramSet) GetNgrams() []string {
	if x != nil {
		return x.Ngrams
	}
	return nil
}

var File_model_proto protoreflect.FileDescriptor

var file_model_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x6c,
	0x69, 0x6e, 0x67, 0x75, 0x61, 0x22, 0xd8, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x38, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x2e, 0x53,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4e, 0x67, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61,
	0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x67, 0x72,
	0x61, 0x6d, 0x53, 0x65, 0x74, 0x52, 0x09, 0x6e, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x73,
	0x22, 0x50, 0x0a, 0x14, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x62,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x70,
	0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x67,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x67, 0x72, 0x61,
	0x6d, 0x73, 0x2a, 0xdc, 0x07, 0x0a, 0x14, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x62, 0x6c, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x46, 0x52, 0x49, 0x4b, 0x41, 0x41, 0x4e, 0x53, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x4c,
	0x42, 0x41, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x52, 0x41, 0x42,
	0x49, 0x43, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x52, 0x4d, 0x45, 0x4e, 0x49, 0x41, 0x4e,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x5a, 0x45, 0x52, 0x42, 0x41, 0x49, 0x4a, 0x41, 0x4e,
	0x49, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x41, 0x53, 0x51, 0x55, 0x45, 0x10, 0x05, 0x12,
	0x0e, 0x0a, 0x0a, 0x42, 0x45, 0x4c, 0x41, 0x52, 0x55, 0x53, 0x49, 0x41, 0x4e, 0x10, 0x06, 0x12,
	0x0b, 0x0a, 0x07, 0x42, 0x45, 0x4e, 0x47, 0x41, 0x4c, 0x49, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06,
	0x42, 0x4f, 0x4b, 0x4d, 0x41, 0x4c, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x53, 0x4e,
	0x49, 0x41, 0x4e, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x55, 0x4c, 0x47, 0x41, 0x52, 0x49,
	0x41, 0x4e, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x41, 0x54, 0x41, 0x4c, 0x41, 0x4e, 0x10,
	0x0b, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x48, 0x49, 0x4e, 0x45, 0x53, 0x45, 0x10, 0x0c, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x4f, 0x41, 0x54, 0x49, 0x41, 0x4e, 0x10, 0x0d, 0x12, 0x09, 0x0a, 0x05,
	0x43, 0x5a, 0x45, 0x43, 0x48, 0x10, 0x0e, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x41, 0x4e, 0x49, 0x53,
	0x48, 0x10, 0x0f, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x55, 0x54, 0x43, 0x48, 0x10, 0x10, 0x12, 0x0b,
	0x0a, 0x07, 0x45, 0x4e, 0x47, 0x4c, 0x49, 0x53, 0x48, 0x10, 0x11, 0x12, 0x0d, 0x0a, 0x09, 0x45,
	0x53, 0x50, 0x45, 0x52, 0x41, 0x4e, 0x54, 0x4f, 0x10, 0x12, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x53,
	0x54, 0x4f, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x13, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4e, 0x4e,
	0x49, 0x53, 0x48, 0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x52, 0x45, 0x4e, 0x43, 0x48, 0x10,
	0x15, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x41, 0x4e, 0x44, 0x41, 0x10, 0x16, 0x12, 0x0c, 0x0a, 0x08,
	0x47, 0x45, 0x4f, 0x52, 0x47, 0x49, 0x41, 0x4e, 0x10, 0x17, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x45,
	0x52, 0x4d, 0x41, 0x4e, 0x10, 0x18, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x52, 0x45, 0x45, 0x4b, 0x10,
	0x19, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x55, 0x4a, 0x41, 0x52, 0x41, 0x54, 0x49, 0x10, 0x1a, 0x12,
	0x0a, 0x0a, 0x06, 0x48, 0x45, 0x42, 0x52, 0x45, 0x57, 0x10, 0x1b, 0x12, 0x09, 0x0a, 0x05, 0x48,
	0x49, 0x4e, 0x44, 0x49, 0x10, 0x1c, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x55, 0x4e, 0x47, 0x41, 0x52,
	0x49, 0x41, 0x4e, 0x10, 0x1d, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x43, 0x45, 0x4c, 0x41, 0x4e, 0x44,
	0x49, 0x43, 0x10, 0x1e, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x53, 0x49,
	0x41, 0x4e, 0x10, 0x1f, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x52, 0x49, 0x53, 0x48, 0x10, 0x20, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x54, 0x41, 0x4c, 0x49, 0x41, 0x4e, 0x10, 0x21, 0x12, 0x0c, 0x0a, 0x08,
	0x4a, 0x41, 0x50, 0x41, 0x4e, 0x45, 0x53, 0x45, 0x10, 0x22, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x41,
	0x5a, 0x41, 0x4b, 0x48, 0x10, 0x23, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x4f, 0x52, 0x45, 0x41, 0x4e,
	0x10, 0x24, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x41, 0x54, 0x49, 0x4e, 0x10, 0x25, 0x12, 0x0b, 0x0a,
	0x07, 0x4c, 0x41, 0x54, 0x56, 0x49, 0x41, 0x4e, 0x10, 0x26, 0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x49,
	0x54, 0x48, 0x55, 0x41, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x27, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41,
	0x43, 0x45, 0x44, 0x4f, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x28, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41,
	0x4c, 0x41, 0x59, 0x10, 0x29, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41, 0x4f, 0x52, 0x49, 0x10, 0x2a,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x52, 0x41, 0x54, 0x48, 0x49, 0x10, 0x2b, 0x12, 0x0d, 0x0a,
	0x09, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x4c, 0x49, 0x41, 0x4e, 0x10, 0x2c, 0x12, 0x0b, 0x0a, 0x07,
	0x4e, 0x59, 0x4e, 0x4f, 0x52, 0x53, 0x4b, 0x10, 0x2d, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x52,
	0x53, 0x49, 0x41, 0x4e, 0x10, 0x2e, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x4f, 0x4c, 0x49, 0x53, 0x48,
	0x10, 0x2f, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x52, 0x54, 0x55, 0x47, 0x55, 0x45, 0x53, 0x45,
	0x10, 0x30, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x55, 0x4e, 0x4a, 0x41, 0x42, 0x49, 0x10, 0x31, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x4f, 0x4d, 0x41, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x32, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x53, 0x53, 0x49, 0x41, 0x4e, 0x10, 0x33, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x45,
	0x52, 0x42, 0x49, 0x41, 0x4e, 0x10, 0x34, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x48, 0x4f, 0x4e, 0x41,
	0x10, 0x35, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4c, 0x4f, 0x56, 0x41, 0x4b, 0x10, 0x36, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x4c, 0x4f, 0x56, 0x45, 0x4e, 0x45, 0x10, 0x37, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x4f, 0x4d, 0x41, 0x4c, 0x49, 0x10, 0x38, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4f, 0x54, 0x48, 0x4f,
	0x10, 0x39, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x50, 0x41, 0x4e, 0x49, 0x53, 0x48, 0x10, 0x3a, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x57, 0x41, 0x48, 0x49, 0x4c, 0x49, 0x10, 0x3b, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x57, 0x45, 0x44, 0x49, 0x53, 0x48, 0x10, 0x3c, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x41, 0x47,
	0x41, 0x4c, 0x4f, 0x47, 0x10, 0x3d, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x4d, 0x49, 0x4c, 0x10,
	0x3e, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x45, 0x4c, 0x55, 0x47, 0x55, 0x10, 0x3f, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x48, 0x41, 0x49, 0x10, 0x40, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x53, 0x4f, 0x4e, 0x47,
	0x41, 0x10, 0x41, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x53, 0x57, 0x41, 0x4e, 0x41, 0x10, 0x42, 0x12,
	0x0b, 0x0a, 0x07, 0x54, 0x55, 0x52, 0x4b, 0x49, 0x53, 0x48, 0x10, 0x43, 0x12, 0x0d, 0x0a, 0x09,
	0x55, 0x4b, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x41, 0x4e, 0x10, 0x44, 0x12, 0x08, 0x0a, 0x04, 0x55,
	0x52, 0x44, 0x55, 0x10, 0x45, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x45, 0x54, 0x4e, 0x41, 0x4d,
	0x45, 0x53, 0x45, 0x10, 0x46, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x45, 0x4c, 0x53, 0x48, 0x10, 0x47,
	0x12, 0x09, 0x0a, 0x05, 0x58, 0x48, 0x4f, 0x53, 0x41, 0x10, 0x48, 0x12, 0x0a, 0x0a, 0x06, 0x59,
	0x4f, 0x52, 0x55, 0x42, 0x41, 0x10, 0x49, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x55, 0x4c, 0x55, 0x10,
	0x4a, 0x42, 0x0a, 0x5a, 0x08, 0x2e, 0x2f, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_model_proto_rawDescOnce sync.Once
	file_model_proto_rawDescData = file_model_proto_rawDesc
)

func file_model_proto_rawDescGZIP() []byte {
	file_model_proto_rawDescOnce.Do(func() {
		file_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_model_proto_rawDescData)
	})
	return file_model_proto_rawDescData
}

var file_model_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_model_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_model_proto_goTypes = []interface{}{
	(SerializableLanguage)(0),         // 0: lingua.SerializableLanguage
	(*SerializableLanguageModel)(nil), // 1: lingua.SerializableLanguageModel
	(*SerializableNgramSet)(nil),      // 2: lingua.SerializableNgramSet
}
var file_model_proto_depIdxs = []int32{
	0, // 0: lingua.SerializableLanguageModel.language:type_name -> lingua.SerializableLanguage
	2, // 1: lingua.SerializableLanguageModel.ngram_sets:type_name -> lingua.SerializableNgramSet
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_model_proto_init() }
func file_model_proto_init() {
	if File_model_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerializableLanguageModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerializableNgramSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_model_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_model_proto_goTypes,
		DependencyIndexes: file_model_proto_depIdxs,
		EnumInfos:         file_model_proto_enumTypes,
		MessageInfos:      file_model_proto_msgTypes,
	}.Build()
	File_model_proto = out.File
	file_model_proto_rawDesc = nil
	file_model_proto_goTypes = nil
	file_model_proto_depIdxs = nil
}
