﻿CREATE TABLE [dbo].[RSSITEM]
(
	[ID] BIGINT NOT NULL IDENTITY, 
    [CHANNEL_ID] BIGINT NOT NULL, 
    [AUTHOR] NVARCHAR(50) NULL, 
    [CATEGORY] NVARCHAR(50) NULL, 
    [COMMENTS] NVARCHAR(200) NULL, 
    [DESCRIPTION] NVARCHAR(2000) NULL, 
    [ENCLOSURE] NVARCHAR(50) NULL, 
    [GUID] NVARCHAR(400) NULL, 
    [LINK] NVARCHAR(400) NULL, 
	[PUB_DATE] NVARCHAR(100) NULL, 
    [PUB_DATE_TIME] DATETIME NULL, 
    [SOURCE] NVARCHAR(50) NULL, 
    [TITLE] NVARCHAR(200) NULL, 
    CONSTRAINT [PK_RSSITEM_ID] PRIMARY KEY CLUSTERED ([ID] ASC),
    CONSTRAINT [FK_RSSITEM_RSSCHANNEL] FOREIGN KEY ([CHANNEL_ID]) REFERENCES [RSSCHANNEL]([ID]) ON DELETE CASCADE
)

GO

CREATE UNIQUE INDEX [IX_RSSITEM_GUID] ON [dbo].[RSSITEM] ([GUID])