//---------------------------------------------------------------------
//  This file is part of the CLR Managed Debugger (mdbg) Sample.
// 
//  Copyright (C) Microsoft Corporation.  All rights reserved.
//---------------------------------------------------------------------

namespace Microsoft.Samples.Debugging.CorDebug
{
	public enum HResult
	{
		// Imported HRESULTs from WinError.h
		E_UNEXPECTED = unchecked((int)0x8000FFFF),
		E_NOTIMPL = unchecked((int)0x80004001),
		E_OUTOFMEMORY = unchecked((int)0x8007000E),
		E_INVALIDARG = unchecked((int)0x80070057),
		E_NOINTERFACE = unchecked((int)0x80004002),
		E_POINTER = unchecked((int)0x80004003),
		E_HANDLE = unchecked((int)0x80070006),
		E_ABORT = unchecked((int)0x80004004),
		E_FAIL = unchecked((int)0x80004005),
		E_ACCESSDENIED = unchecked((int)0x80070005),
		E_PENDING = unchecked((int)0x8000000A),
        E_PDB_CORRUPT = unchecked((int)0x806D0014),
        E_PARTIAL_COPY = unchecked((int)0x8007012b),
        E_BAD_LENGTH = unchecked((int)0x80070018),
		CO_E_INIT_TLS = unchecked((int)0x80004006),
		CO_E_INIT_SHARED_ALLOCATOR = unchecked((int)0x80004007),
		CO_E_INIT_MEMORY_ALLOCATOR = unchecked((int)0x80004008),
		CO_E_INIT_CLASS_CACHE = unchecked((int)0x80004009),
		CO_E_INIT_RPC_CHANNEL = unchecked((int)0x8000400A),
		CO_E_INIT_TLS_SET_CHANNEL_CONTROL = unchecked((int)0x8000400B),
		CO_E_INIT_TLS_CHANNEL_CONTROL = unchecked((int)0x8000400C),
		CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = unchecked((int)0x8000400D),
		CO_E_INIT_SCM_MUTEX_EXISTS = unchecked((int)0x8000400E),
		CO_E_INIT_SCM_FILE_MAPPING_EXISTS = unchecked((int)0x8000400F),
		CO_E_INIT_SCM_MAP_VIEW_OF_FILE = unchecked((int)0x80004010),
		CO_E_INIT_SCM_EXEC_FAILURE = unchecked((int)0x80004011),
		CO_E_INIT_ONLY_SINGLE_THREADED = unchecked((int)0x80004012),
		CO_E_CANT_REMOTE = unchecked((int)0x80004013),
		CO_E_BAD_SERVER_NAME = unchecked((int)0x80004014),
		CO_E_WRONG_SERVER_IDENTITY = unchecked((int)0x80004015),
		CO_E_OLE1DDE_DISABLED = unchecked((int)0x80004016),
		CO_E_RUNAS_SYNTAX = unchecked((int)0x80004017),
		CO_E_CREATEPROCESS_FAILURE = unchecked((int)0x80004018),
		CO_E_RUNAS_CREATEPROCESS_FAILURE = unchecked((int)0x80004019),
		CO_E_RUNAS_LOGON_FAILURE = unchecked((int)0x8000401A),
		CO_E_LAUNCH_PERMSSION_DENIED = unchecked((int)0x8000401B),
		CO_E_START_SERVICE_FAILURE = unchecked((int)0x8000401C),
		CO_E_REMOTE_COMMUNICATION_FAILURE = unchecked((int)0x8000401D),
		CO_E_SERVER_START_TIMEOUT = unchecked((int)0x8000401E),
		CO_E_CLSREG_INCONSISTENT = unchecked((int)0x8000401F),
		CO_E_IIDREG_INCONSISTENT = unchecked((int)0x80004020),
		CO_E_NOT_SUPPORTED = unchecked((int)0x80004021),
		CO_E_RELOAD_DLL = unchecked((int)0x80004022),
		CO_E_MSI_ERROR = unchecked((int)0x80004023),
		CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT = unchecked((int)0x80004024),
		CO_E_SERVER_PAUSED = unchecked((int)0x80004025),
		CO_E_SERVER_NOT_PAUSED = unchecked((int)0x80004026),
		CO_E_CLASS_DISABLED = unchecked((int)0x80004027),
		CO_E_CLRNOTAVAILABLE = unchecked((int)0x80004028),
		CO_E_ASYNC_WORK_REJECTED = unchecked((int)0x80004029),
		CO_E_SERVER_INIT_TIMEOUT = unchecked((int)0x8000402A),
		CO_E_NO_SECCTX_IN_ACTIVATE = unchecked((int)0x8000402B),
		CO_E_TRACKER_CONFIG = unchecked((int)0x80004030),
		CO_E_THREADPOOL_CONFIG = unchecked((int)0x80004031),
		CO_E_SXS_CONFIG = unchecked((int)0x80004032),
		CO_E_MALFORMED_SPN = unchecked((int)0x80004033),
		S_OK = unchecked((int)0x00000000),
		S_FALSE = unchecked((int)0x00000001),
		OLE_E_FIRST = unchecked((int)0x80040000),
		OLE_E_LAST = unchecked((int)0x800400FF),
		OLE_S_FIRST = unchecked((int)0x00040000),
		OLE_S_LAST = unchecked((int)0x000400FF),
		OLE_E_OLEVERB = unchecked((int)0x80040000),
		OLE_E_ADVF = unchecked((int)0x80040001),
		OLE_E_ENUM_NOMORE = unchecked((int)0x80040002),
		OLE_E_ADVISENOTSUPPORTED = unchecked((int)0x80040003),
		OLE_E_NOCONNECTION = unchecked((int)0x80040004),
		OLE_E_NOTRUNNING = unchecked((int)0x80040005),
		OLE_E_NOCACHE = unchecked((int)0x80040006),
		OLE_E_BLANK = unchecked((int)0x80040007),
		OLE_E_CLASSDIFF = unchecked((int)0x80040008),
		OLE_E_CANT_GETMONIKER = unchecked((int)0x80040009),
		OLE_E_CANT_BINDTOSOURCE = unchecked((int)0x8004000A),
		OLE_E_STATIC = unchecked((int)0x8004000B),
		OLE_E_PROMPTSAVECANCELLED = unchecked((int)0x8004000C),
		OLE_E_INVALIDRECT = unchecked((int)0x8004000D),
		OLE_E_WRONGCOMPOBJ = unchecked((int)0x8004000E),
		OLE_E_INVALIDHWND = unchecked((int)0x8004000F),
		OLE_E_NOT_INPLACEACTIVE = unchecked((int)0x80040010),
		OLE_E_CANTCONVERT = unchecked((int)0x80040011),
		OLE_E_NOSTORAGE = unchecked((int)0x80040012),
		DV_E_FORMATETC = unchecked((int)0x80040064),
		DV_E_DVTARGETDEVICE = unchecked((int)0x80040065),
		DV_E_STGMEDIUM = unchecked((int)0x80040066),
		DV_E_STATDATA = unchecked((int)0x80040067),
		DV_E_LINDEX = unchecked((int)0x80040068),
		DV_E_TYMED = unchecked((int)0x80040069),
		DV_E_CLIPFORMAT = unchecked((int)0x8004006A),
		DV_E_DVASPECT = unchecked((int)0x8004006B),
		DV_E_DVTARGETDEVICE_SIZE = unchecked((int)0x8004006C),
		DV_E_NOIVIEWOBJECT = unchecked((int)0x8004006D),
		DRAGDROP_E_FIRST = unchecked((int)0x80040100),
		DRAGDROP_E_LAST = unchecked((int)0x8004010F),
		DRAGDROP_S_FIRST = unchecked((int)0x00040100),
		DRAGDROP_S_LAST = unchecked((int)0x0004010F),
		DRAGDROP_E_NOTREGISTERED = unchecked((int)0x80040100),
		DRAGDROP_E_ALREADYREGISTERED = unchecked((int)0x80040101),
		DRAGDROP_E_INVALIDHWND = unchecked((int)0x80040102),
		CLASSFACTORY_E_FIRST = unchecked((int)0x80040110),
		CLASSFACTORY_E_LAST = unchecked((int)0x8004011F),
		CLASSFACTORY_S_FIRST = unchecked((int)0x00040110),
		CLASSFACTORY_S_LAST = unchecked((int)0x0004011F),
		CLASS_E_NOAGGREGATION = unchecked((int)0x80040110),
		CLASS_E_CLASSNOTAVAILABLE = unchecked((int)0x80040111),
		CLASS_E_NOTLICENSED = unchecked((int)0x80040112),
		MARSHAL_E_FIRST = unchecked((int)0x80040120),
		MARSHAL_E_LAST = unchecked((int)0x8004012F),
		MARSHAL_S_FIRST = unchecked((int)0x00040120),
		MARSHAL_S_LAST = unchecked((int)0x0004012F),
		DATA_E_FIRST = unchecked((int)0x80040130),
		DATA_E_LAST = unchecked((int)0x8004013F),
		DATA_S_FIRST = unchecked((int)0x00040130),
		DATA_S_LAST = unchecked((int)0x0004013F),
		VIEW_E_FIRST = unchecked((int)0x80040140),
		VIEW_E_LAST = unchecked((int)0x8004014F),
		VIEW_S_FIRST = unchecked((int)0x00040140),
		VIEW_S_LAST = unchecked((int)0x0004014F),
		VIEW_E_DRAW = unchecked((int)0x80040140),
		REGDB_E_FIRST = unchecked((int)0x80040150),
		REGDB_E_LAST = unchecked((int)0x8004015F),
		REGDB_S_FIRST = unchecked((int)0x00040150),
		REGDB_S_LAST = unchecked((int)0x0004015F),
		REGDB_E_READREGDB = unchecked((int)0x80040150),
		REGDB_E_WRITEREGDB = unchecked((int)0x80040151),
		REGDB_E_KEYMISSING = unchecked((int)0x80040152),
		REGDB_E_INVALIDVALUE = unchecked((int)0x80040153),
		REGDB_E_CLASSNOTREG = unchecked((int)0x80040154),
		REGDB_E_IIDNOTREG = unchecked((int)0x80040155),
		REGDB_E_BADTHREADINGMODEL = unchecked((int)0x80040156),
		CAT_E_FIRST = unchecked((int)0x80040160),
		CAT_E_LAST = unchecked((int)0x80040161),
		CAT_E_CATIDNOEXIST = unchecked((int)0x80040160),
		CAT_E_NODESCRIPTION = unchecked((int)0x80040161),
		CS_E_FIRST = unchecked((int)0x80040164),
		CS_E_LAST = unchecked((int)0x8004016F),
		CS_E_PACKAGE_NOTFOUND = unchecked((int)0x80040164),
		CS_E_NOT_DELETABLE = unchecked((int)0x80040165),
		CS_E_CLASS_NOTFOUND = unchecked((int)0x80040166),
		CS_E_INVALID_VERSION = unchecked((int)0x80040167),
		CS_E_NO_CLASSSTORE = unchecked((int)0x80040168),
		CS_E_OBJECT_NOTFOUND = unchecked((int)0x80040169),
		CS_E_OBJECT_ALREADY_EXISTS = unchecked((int)0x8004016A),
		CS_E_INVALID_PATH = unchecked((int)0x8004016B),
		CS_E_NETWORK_ERROR = unchecked((int)0x8004016C),
		CS_E_ADMIN_LIMIT_EXCEEDED = unchecked((int)0x8004016D),
		CS_E_SCHEMA_MISMATCH = unchecked((int)0x8004016E),
		CS_E_INTERNAL_ERROR = unchecked((int)0x8004016F),
		CACHE_E_FIRST = unchecked((int)0x80040170),
		CACHE_E_LAST = unchecked((int)0x8004017F),
		CACHE_S_FIRST = unchecked((int)0x00040170),
		CACHE_S_LAST = unchecked((int)0x0004017F),
		CACHE_E_NOCACHE_UPDATED = unchecked((int)0x80040170),
		OLEOBJ_E_FIRST = unchecked((int)0x80040180),
		OLEOBJ_E_LAST = unchecked((int)0x8004018F),
		OLEOBJ_S_FIRST = unchecked((int)0x00040180),
		OLEOBJ_S_LAST = unchecked((int)0x0004018F),
		OLEOBJ_E_NOVERBS = unchecked((int)0x80040180),
		OLEOBJ_E_INVALIDVERB = unchecked((int)0x80040181),
		CLIENTSITE_E_FIRST = unchecked((int)0x80040190),
		CLIENTSITE_E_LAST = unchecked((int)0x8004019F),
		CLIENTSITE_S_FIRST = unchecked((int)0x00040190),
		CLIENTSITE_S_LAST = unchecked((int)0x0004019F),
		INPLACE_E_NOTUNDOABLE = unchecked((int)0x800401A0),
		INPLACE_E_NOTOOLSPACE = unchecked((int)0x800401A1),
		INPLACE_E_FIRST = unchecked((int)0x800401A0),
		INPLACE_E_LAST = unchecked((int)0x800401AF),
		INPLACE_S_FIRST = unchecked((int)0x000401A0),
		INPLACE_S_LAST = unchecked((int)0x000401AF),
		ENUM_E_FIRST = unchecked((int)0x800401B0),
		ENUM_E_LAST = unchecked((int)0x800401BF),
		ENUM_S_FIRST = unchecked((int)0x000401B0),
		ENUM_S_LAST = unchecked((int)0x000401BF),
		CONVERT10_E_FIRST = unchecked((int)0x800401C0),
		CONVERT10_E_LAST = unchecked((int)0x800401CF),
		CONVERT10_S_FIRST = unchecked((int)0x000401C0),
		CONVERT10_S_LAST = unchecked((int)0x000401CF),
		CONVERT10_E_OLESTREAM_GET = unchecked((int)0x800401C0),
		CONVERT10_E_OLESTREAM_PUT = unchecked((int)0x800401C1),
		CONVERT10_E_OLESTREAM_FMT = unchecked((int)0x800401C2),
		CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = unchecked((int)0x800401C3),
		CONVERT10_E_STG_FMT = unchecked((int)0x800401C4),
		CONVERT10_E_STG_NO_STD_STREAM = unchecked((int)0x800401C5),
		CONVERT10_E_STG_DIB_TO_BITMAP = unchecked((int)0x800401C6),
		CLIPBRD_E_FIRST = unchecked((int)0x800401D0),
		CLIPBRD_E_LAST = unchecked((int)0x800401DF),
		CLIPBRD_S_FIRST = unchecked((int)0x000401D0),
		CLIPBRD_S_LAST = unchecked((int)0x000401DF),
		CLIPBRD_E_CANT_OPEN = unchecked((int)0x800401D0),
		CLIPBRD_E_CANT_EMPTY = unchecked((int)0x800401D1),
		CLIPBRD_E_CANT_SET = unchecked((int)0x800401D2),
		CLIPBRD_E_BAD_DATA = unchecked((int)0x800401D3),
		CLIPBRD_E_CANT_CLOSE = unchecked((int)0x800401D4),
		MK_E_FIRST = unchecked((int)0x800401E0),
		MK_E_LAST = unchecked((int)0x800401EF),
		MK_S_FIRST = unchecked((int)0x000401E0),
		MK_S_LAST = unchecked((int)0x000401EF),
		MK_E_CONNECTMANUALLY = unchecked((int)0x800401E0),
		MK_E_EXCEEDEDDEADLINE = unchecked((int)0x800401E1),
		MK_E_NEEDGENERIC = unchecked((int)0x800401E2),
		MK_E_UNAVAILABLE = unchecked((int)0x800401E3),
		MK_E_SYNTAX = unchecked((int)0x800401E4),
		MK_E_NOOBJECT = unchecked((int)0x800401E5),
		MK_E_INVALIDEXTENSION = unchecked((int)0x800401E6),
		MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = unchecked((int)0x800401E7),
		MK_E_NOTBINDABLE = unchecked((int)0x800401E8),
		MK_E_NOTBOUND = unchecked((int)0x800401E9),
		MK_E_CANTOPENFILE = unchecked((int)0x800401EA),
		MK_E_MUSTBOTHERUSER = unchecked((int)0x800401EB),
		MK_E_NOINVERSE = unchecked((int)0x800401EC),
		MK_E_NOSTORAGE = unchecked((int)0x800401ED),
		MK_E_NOPREFIX = unchecked((int)0x800401EE),
		MK_E_ENUMERATION_FAILED = unchecked((int)0x800401EF),
		CO_E_FIRST = unchecked((int)0x800401F0),
		CO_E_LAST = unchecked((int)0x800401FF),
		CO_S_FIRST = unchecked((int)0x000401F0),
		CO_S_LAST = unchecked((int)0x000401FF),
		CO_E_NOTINITIALIZED = unchecked((int)0x800401F0),
		CO_E_ALREADYINITIALIZED = unchecked((int)0x800401F1),
		CO_E_CANTDETERMINECLASS = unchecked((int)0x800401F2),
		CO_E_CLASSSTRING = unchecked((int)0x800401F3),
		CO_E_IIDSTRING = unchecked((int)0x800401F4),
		CO_E_APPNOTFOUND = unchecked((int)0x800401F5),
		CO_E_APPSINGLEUSE = unchecked((int)0x800401F6),
		CO_E_ERRORINAPP = unchecked((int)0x800401F7),
		CO_E_DLLNOTFOUND = unchecked((int)0x800401F8),
		CO_E_ERRORINDLL = unchecked((int)0x800401F9),
		CO_E_WRONGOSFORAPP = unchecked((int)0x800401FA),
		CO_E_OBJNOTREG = unchecked((int)0x800401FB),
		CO_E_OBJISREG = unchecked((int)0x800401FC),
		CO_E_OBJNOTCONNECTED = unchecked((int)0x800401FD),
		CO_E_APPDIDNTREG = unchecked((int)0x800401FE),
		CO_E_RELEASED = unchecked((int)0x800401FF),
		EVENT_E_FIRST = unchecked((int)0x80040200),
		EVENT_E_LAST = unchecked((int)0x8004021F),
		EVENT_S_FIRST = unchecked((int)0x00040200),
		EVENT_S_LAST = unchecked((int)0x0004021F),
		EVENT_S_SOME_SUBSCRIBERS_FAILED = unchecked((int)0x00040200),
		EVENT_E_ALL_SUBSCRIBERS_FAILED = unchecked((int)0x80040201),
		EVENT_S_NOSUBSCRIBERS = unchecked((int)0x00040202),
		EVENT_E_QUERYSYNTAX = unchecked((int)0x80040203),
		EVENT_E_QUERYFIELD = unchecked((int)0x80040204),
		EVENT_E_INTERNALEXCEPTION = unchecked((int)0x80040205),
		EVENT_E_INTERNALERROR = unchecked((int)0x80040206),
		EVENT_E_INVALID_PER_USER_SID = unchecked((int)0x80040207),
		EVENT_E_USER_EXCEPTION = unchecked((int)0x80040208),
		EVENT_E_TOO_MANY_METHODS = unchecked((int)0x80040209),
		EVENT_E_MISSING_EVENTCLASS = unchecked((int)0x8004020A),
		EVENT_E_NOT_ALL_REMOVED = unchecked((int)0x8004020B),
		EVENT_E_COMPLUS_NOT_INSTALLED = unchecked((int)0x8004020C),
		EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT = unchecked((int)0x8004020D),
		EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT = unchecked((int)0x8004020E),
		EVENT_E_INVALID_EVENT_CLASS_PARTITION = unchecked((int)0x8004020F),
		EVENT_E_PER_USER_SID_NOT_LOGGED_ON = unchecked((int)0x80040210),
		XACT_E_FIRST = unchecked((int)0x8004D000),
		XACT_E_LAST = unchecked((int)0x8004D029),
		XACT_S_FIRST = unchecked((int)0x0004D000),
		XACT_S_LAST = unchecked((int)0x0004D010),
		XACT_E_ALREADYOTHERSINGLEPHASE = unchecked((int)0x8004D000),
		XACT_E_CANTRETAIN = unchecked((int)0x8004D001),
		XACT_E_COMMITFAILED = unchecked((int)0x8004D002),
		XACT_E_COMMITPREVENTED = unchecked((int)0x8004D003),
		XACT_E_HEURISTICABORT = unchecked((int)0x8004D004),
		XACT_E_HEURISTICCOMMIT = unchecked((int)0x8004D005),
		XACT_E_HEURISTICDAMAGE = unchecked((int)0x8004D006),
		XACT_E_HEURISTICDANGER = unchecked((int)0x8004D007),
		XACT_E_ISOLATIONLEVEL = unchecked((int)0x8004D008),
		XACT_E_NOASYNC = unchecked((int)0x8004D009),
		XACT_E_NOENLIST = unchecked((int)0x8004D00A),
		XACT_E_NOISORETAIN = unchecked((int)0x8004D00B),
		XACT_E_NORESOURCE = unchecked((int)0x8004D00C),
		XACT_E_NOTCURRENT = unchecked((int)0x8004D00D),
		XACT_E_NOTRANSACTION = unchecked((int)0x8004D00E),
		XACT_E_NOTSUPPORTED = unchecked((int)0x8004D00F),
		XACT_E_UNKNOWNRMGRID = unchecked((int)0x8004D010),
		XACT_E_WRONGSTATE = unchecked((int)0x8004D011),
		XACT_E_WRONGUOW = unchecked((int)0x8004D012),
		XACT_E_XTIONEXISTS = unchecked((int)0x8004D013),
		XACT_E_NOIMPORTOBJECT = unchecked((int)0x8004D014),
		XACT_E_INVALIDCOOKIE = unchecked((int)0x8004D015),
		XACT_E_INDOUBT = unchecked((int)0x8004D016),
		XACT_E_NOTIMEOUT = unchecked((int)0x8004D017),
		XACT_E_ALREADYINPROGRESS = unchecked((int)0x8004D018),
		XACT_E_ABORTED = unchecked((int)0x8004D019),
		XACT_E_LOGFULL = unchecked((int)0x8004D01A),
		XACT_E_TMNOTAVAILABLE = unchecked((int)0x8004D01B),
		XACT_E_CONNECTION_DOWN = unchecked((int)0x8004D01C),
		XACT_E_CONNECTION_DENIED = unchecked((int)0x8004D01D),
		XACT_E_REENLISTTIMEOUT = unchecked((int)0x8004D01E),
		XACT_E_TIP_CONNECT_FAILED = unchecked((int)0x8004D01F),
		XACT_E_TIP_PROTOCOL_ERROR = unchecked((int)0x8004D020),
		XACT_E_TIP_PULL_FAILED = unchecked((int)0x8004D021),
		XACT_E_DEST_TMNOTAVAILABLE = unchecked((int)0x8004D022),
		XACT_E_TIP_DISABLED = unchecked((int)0x8004D023),
		XACT_E_NETWORK_TX_DISABLED = unchecked((int)0x8004D024),
		XACT_E_PARTNER_NETWORK_TX_DISABLED = unchecked((int)0x8004D025),
		XACT_E_XA_TX_DISABLED = unchecked((int)0x8004D026),
		XACT_E_UNABLE_TO_READ_DTC_CONFIG = unchecked((int)0x8004D027),
		XACT_E_UNABLE_TO_LOAD_DTC_PROXY = unchecked((int)0x8004D028),
		XACT_E_ABORTING = unchecked((int)0x8004D029),
		XACT_E_CLERKNOTFOUND = unchecked((int)0x8004D080),
		XACT_E_CLERKEXISTS = unchecked((int)0x8004D081),
		XACT_E_RECOVERYINPROGRESS = unchecked((int)0x8004D082),
		XACT_E_TRANSACTIONCLOSED = unchecked((int)0x8004D083),
		XACT_E_INVALIDLSN = unchecked((int)0x8004D084),
		XACT_E_REPLAYREQUEST = unchecked((int)0x8004D085),
		XACT_S_ASYNC = unchecked((int)0x0004D000),
		XACT_S_DEFECT = unchecked((int)0x0004D001),
		XACT_S_READONLY = unchecked((int)0x0004D002),
		XACT_S_SOMENORETAIN = unchecked((int)0x0004D003),
		XACT_S_OKINFORM = unchecked((int)0x0004D004),
		XACT_S_MADECHANGESCONTENT = unchecked((int)0x0004D005),
		XACT_S_MADECHANGESINFORM = unchecked((int)0x0004D006),
		XACT_S_ALLNORETAIN = unchecked((int)0x0004D007),
		XACT_S_ABORTING = unchecked((int)0x0004D008),
		XACT_S_SINGLEPHASE = unchecked((int)0x0004D009),
		XACT_S_LOCALLY_OK = unchecked((int)0x0004D00A),
		XACT_S_LASTRESOURCEMANAGER = unchecked((int)0x0004D010),
		CONTEXT_E_FIRST = unchecked((int)0x8004E000),
		CONTEXT_E_LAST = unchecked((int)0x8004E02F),
		CONTEXT_S_FIRST = unchecked((int)0x0004E000),
		CONTEXT_S_LAST = unchecked((int)0x0004E02F),
		CONTEXT_E_ABORTED = unchecked((int)0x8004E002),
		CONTEXT_E_ABORTING = unchecked((int)0x8004E003),
		CONTEXT_E_NOCONTEXT = unchecked((int)0x8004E004),
		CONTEXT_E_WOULD_DEADLOCK = unchecked((int)0x8004E005),
		CONTEXT_E_SYNCH_TIMEOUT = unchecked((int)0x8004E006),
		CONTEXT_E_OLDREF = unchecked((int)0x8004E007),
		CONTEXT_E_ROLENOTFOUND = unchecked((int)0x8004E00C),
		CONTEXT_E_TMNOTAVAILABLE = unchecked((int)0x8004E00F),
		CO_E_ACTIVATIONFAILED = unchecked((int)0x8004E021),
		CO_E_ACTIVATIONFAILED_EVENTLOGGED = unchecked((int)0x8004E022),
		CO_E_ACTIVATIONFAILED_CATALOGERROR = unchecked((int)0x8004E023),
		CO_E_ACTIVATIONFAILED_TIMEOUT = unchecked((int)0x8004E024),
		CO_E_INITIALIZATIONFAILED = unchecked((int)0x8004E025),
		CONTEXT_E_NOJIT = unchecked((int)0x8004E026),
		CONTEXT_E_NOTRANSACTION = unchecked((int)0x8004E027),
		CO_E_THREADINGMODEL_CHANGED = unchecked((int)0x8004E028),
		CO_E_NOIISINTRINSICS = unchecked((int)0x8004E029),
		CO_E_NOCOOKIES = unchecked((int)0x8004E02A),
		CO_E_DBERROR = unchecked((int)0x8004E02B),
		CO_E_NOTPOOLED = unchecked((int)0x8004E02C),
		CO_E_NOTCONSTRUCTED = unchecked((int)0x8004E02D),
		CO_E_NOSYNCHRONIZATION = unchecked((int)0x8004E02E),
		CO_E_ISOLEVELMISMATCH = unchecked((int)0x8004E02F),
		OLE_S_USEREG = unchecked((int)0x00040000),
		OLE_S_STATIC = unchecked((int)0x00040001),
		OLE_S_MAC_CLIPFORMAT = unchecked((int)0x00040002),
		DRAGDROP_S_DROP = unchecked((int)0x00040100),
		DRAGDROP_S_CANCEL = unchecked((int)0x00040101),
		DRAGDROP_S_USEDEFAULTCURSORS = unchecked((int)0x00040102),
		DATA_S_SAMEFORMATETC = unchecked((int)0x00040130),
		VIEW_S_ALREADY_FROZEN = unchecked((int)0x00040140),
		CACHE_S_FORMATETC_NOTSUPPORTED = unchecked((int)0x00040170),
		CACHE_S_SAMECACHE = unchecked((int)0x00040171),
		CACHE_S_SOMECACHES_NOTUPDATED = unchecked((int)0x00040172),
		OLEOBJ_S_INVALIDVERB = unchecked((int)0x00040180),
		OLEOBJ_S_CANNOT_DOVERB_NOW = unchecked((int)0x00040181),
		OLEOBJ_S_INVALIDHWND = unchecked((int)0x00040182),
		INPLACE_S_TRUNCATED = unchecked((int)0x000401A0),
		CONVERT10_S_NO_PRESENTATION = unchecked((int)0x000401C0),
		MK_S_REDUCED_TO_SELF = unchecked((int)0x000401E2),
		MK_S_ME = unchecked((int)0x000401E4),
		MK_S_HIM = unchecked((int)0x000401E5),
		MK_S_US = unchecked((int)0x000401E6),
		MK_S_MONIKERALREADYREGISTERED = unchecked((int)0x000401E7),
		SCHED_S_TASK_READY = unchecked((int)0x00041300),
		SCHED_S_TASK_RUNNING = unchecked((int)0x00041301),
		SCHED_S_TASK_DISABLED = unchecked((int)0x00041302),
		SCHED_S_TASK_HAS_NOT_RUN = unchecked((int)0x00041303),
		SCHED_S_TASK_NO_MORE_RUNS = unchecked((int)0x00041304),
		SCHED_S_TASK_NOT_SCHEDULED = unchecked((int)0x00041305),
		SCHED_S_TASK_TERMINATED = unchecked((int)0x00041306),
		SCHED_S_TASK_NO_VALID_TRIGGERS = unchecked((int)0x00041307),
		SCHED_S_EVENT_TRIGGER = unchecked((int)0x00041308),
		SCHED_E_TRIGGER_NOT_FOUND = unchecked((int)0x80041309),
		SCHED_E_TASK_NOT_READY = unchecked((int)0x8004130A),
		SCHED_E_TASK_NOT_RUNNING = unchecked((int)0x8004130B),
		SCHED_E_SERVICE_NOT_INSTALLED = unchecked((int)0x8004130C),
		SCHED_E_CANNOT_OPEN_TASK = unchecked((int)0x8004130D),
		SCHED_E_INVALID_TASK = unchecked((int)0x8004130E),
		SCHED_E_ACCOUNT_INFORMATION_NOT_SET = unchecked((int)0x8004130F),
		SCHED_E_ACCOUNT_NAME_NOT_FOUND = unchecked((int)0x80041310),
		SCHED_E_ACCOUNT_DBASE_CORRUPT = unchecked((int)0x80041311),
		SCHED_E_NO_SECURITY_SERVICES = unchecked((int)0x80041312),
		SCHED_E_UNKNOWN_OBJECT_VERSION = unchecked((int)0x80041313),
		SCHED_E_UNSUPPORTED_ACCOUNT_OPTION = unchecked((int)0x80041314),
		SCHED_E_SERVICE_NOT_RUNNING = unchecked((int)0x80041315),
		CO_E_CLASS_CREATE_FAILED = unchecked((int)0x80080001),
		CO_E_SCM_ERROR = unchecked((int)0x80080002),
		CO_E_SCM_RPC_FAILURE = unchecked((int)0x80080003),
		CO_E_BAD_PATH = unchecked((int)0x80080004),
		CO_E_SERVER_EXEC_FAILURE = unchecked((int)0x80080005),
		CO_E_OBJSRV_RPC_FAILURE = unchecked((int)0x80080006),
		MK_E_NO_NORMALIZED = unchecked((int)0x80080007),
		CO_E_SERVER_STOPPING = unchecked((int)0x80080008),
		MEM_E_INVALID_ROOT = unchecked((int)0x80080009),
		MEM_E_INVALID_LINK = unchecked((int)0x80080010),
		MEM_E_INVALID_SIZE = unchecked((int)0x80080011),
		CO_S_NOTALLINTERFACES = unchecked((int)0x00080012),
		CO_S_MACHINENAMENOTFOUND = unchecked((int)0x00080013),
		DISP_E_UNKNOWNINTERFACE = unchecked((int)0x80020001),
		DISP_E_MEMBERNOTFOUND = unchecked((int)0x80020003),
		DISP_E_PARAMNOTFOUND = unchecked((int)0x80020004),
		DISP_E_TYPEMISMATCH = unchecked((int)0x80020005),
		DISP_E_UNKNOWNNAME = unchecked((int)0x80020006),
		DISP_E_NONAMEDARGS = unchecked((int)0x80020007),
		DISP_E_BADVARTYPE = unchecked((int)0x80020008),
		DISP_E_EXCEPTION = unchecked((int)0x80020009),
		DISP_E_OVERFLOW = unchecked((int)0x8002000A),
		DISP_E_BADINDEX = unchecked((int)0x8002000B),
		DISP_E_UNKNOWNLCID = unchecked((int)0x8002000C),
		DISP_E_ARRAYISLOCKED = unchecked((int)0x8002000D),
		DISP_E_BADPARAMCOUNT = unchecked((int)0x8002000E),
		DISP_E_PARAMNOTOPTIONAL = unchecked((int)0x8002000F),
		DISP_E_BADCALLEE = unchecked((int)0x80020010),
		DISP_E_NOTACOLLECTION = unchecked((int)0x80020011),
		DISP_E_DIVBYZERO = unchecked((int)0x80020012),
		DISP_E_BUFFERTOOSMALL = unchecked((int)0x80020013),
		TYPE_E_BUFFERTOOSMALL = unchecked((int)0x80028016),
		TYPE_E_FIELDNOTFOUND = unchecked((int)0x80028017),
		TYPE_E_INVDATAREAD = unchecked((int)0x80028018),
		TYPE_E_UNSUPFORMAT = unchecked((int)0x80028019),
		TYPE_E_REGISTRYACCESS = unchecked((int)0x8002801C),
		TYPE_E_LIBNOTREGISTERED = unchecked((int)0x8002801D),
		TYPE_E_UNDEFINEDTYPE = unchecked((int)0x80028027),
		TYPE_E_QUALIFIEDNAMEDISALLOWED = unchecked((int)0x80028028),
		TYPE_E_INVALIDSTATE = unchecked((int)0x80028029),
		TYPE_E_WRONGTYPEKIND = unchecked((int)0x8002802A),
		TYPE_E_ELEMENTNOTFOUND = unchecked((int)0x8002802B),
		TYPE_E_AMBIGUOUSNAME = unchecked((int)0x8002802C),
		TYPE_E_NAMECONFLICT = unchecked((int)0x8002802D),
		TYPE_E_UNKNOWNLCID = unchecked((int)0x8002802E),
		TYPE_E_DLLFUNCTIONNOTFOUND = unchecked((int)0x8002802F),
		TYPE_E_BADMODULEKIND = unchecked((int)0x800288BD),
		TYPE_E_SIZETOOBIG = unchecked((int)0x800288C5),
		TYPE_E_DUPLICATEID = unchecked((int)0x800288C6),
		TYPE_E_INVALIDID = unchecked((int)0x800288CF),
		TYPE_E_TYPEMISMATCH = unchecked((int)0x80028CA0),
		TYPE_E_OUTOFBOUNDS = unchecked((int)0x80028CA1),
		TYPE_E_IOERROR = unchecked((int)0x80028CA2),
		TYPE_E_CANTCREATETMPFILE = unchecked((int)0x80028CA3),
		TYPE_E_CANTLOADLIBRARY = unchecked((int)0x80029C4A),
		TYPE_E_INCONSISTENTPROPFUNCS = unchecked((int)0x80029C83),
		TYPE_E_CIRCULARTYPE = unchecked((int)0x80029C84),
		STG_E_INVALIDFUNCTION = unchecked((int)0x80030001),
		STG_E_FILENOTFOUND = unchecked((int)0x80030002),
		STG_E_PATHNOTFOUND = unchecked((int)0x80030003),
		STG_E_TOOMANYOPENFILES = unchecked((int)0x80030004),
		STG_E_ACCESSDENIED = unchecked((int)0x80030005),
		STG_E_INVALIDHANDLE = unchecked((int)0x80030006),
		STG_E_INSUFFICIENTMEMORY = unchecked((int)0x80030008),
		STG_E_INVALIDPOINTER = unchecked((int)0x80030009),
		STG_E_NOMOREFILES = unchecked((int)0x80030012),
		STG_E_DISKISWRITEPROTECTED = unchecked((int)0x80030013),
		STG_E_SEEKERROR = unchecked((int)0x80030019),
		STG_E_WRITEFAULT = unchecked((int)0x8003001D),
		STG_E_READFAULT = unchecked((int)0x8003001E),
		STG_E_SHAREVIOLATION = unchecked((int)0x80030020),
		STG_E_LOCKVIOLATION = unchecked((int)0x80030021),
		STG_E_FILEALREADYEXISTS = unchecked((int)0x80030050),
		STG_E_INVALIDPARAMETER = unchecked((int)0x80030057),
		STG_E_MEDIUMFULL = unchecked((int)0x80030070),
		STG_E_PROPSETMISMATCHED = unchecked((int)0x800300F0),
		STG_E_ABNORMALAPIEXIT = unchecked((int)0x800300FA),
		STG_E_INVALIDHEADER = unchecked((int)0x800300FB),
		STG_E_INVALIDNAME = unchecked((int)0x800300FC),
		STG_E_UNKNOWN = unchecked((int)0x800300FD),
		STG_E_UNIMPLEMENTEDFUNCTION = unchecked((int)0x800300FE),
		STG_E_INVALIDFLAG = unchecked((int)0x800300FF),
		STG_E_INUSE = unchecked((int)0x80030100),
		STG_E_NOTCURRENT = unchecked((int)0x80030101),
		STG_E_REVERTED = unchecked((int)0x80030102),
		STG_E_CANTSAVE = unchecked((int)0x80030103),
		STG_E_OLDFORMAT = unchecked((int)0x80030104),
		STG_E_OLDDLL = unchecked((int)0x80030105),
		STG_E_SHAREREQUIRED = unchecked((int)0x80030106),
		STG_E_NOTFILEBASEDSTORAGE = unchecked((int)0x80030107),
		STG_E_EXTANTMARSHALLINGS = unchecked((int)0x80030108),
		STG_E_DOCFILECORRUPT = unchecked((int)0x80030109),
		STG_E_BADBASEADDRESS = unchecked((int)0x80030110),
		STG_E_DOCFILETOOLARGE = unchecked((int)0x80030111),
		STG_E_NOTSIMPLEFORMAT = unchecked((int)0x80030112),
		STG_E_INCOMPLETE = unchecked((int)0x80030201),
		STG_E_TERMINATED = unchecked((int)0x80030202),
		STG_S_CONVERTED = unchecked((int)0x00030200),
		STG_S_BLOCK = unchecked((int)0x00030201),
		STG_S_RETRYNOW = unchecked((int)0x00030202),
		STG_S_MONITORING = unchecked((int)0x00030203),
		STG_S_MULTIPLEOPENS = unchecked((int)0x00030204),
		STG_S_CONSOLIDATIONFAILED = unchecked((int)0x00030205),
		STG_S_CANNOTCONSOLIDATE = unchecked((int)0x00030206),
		STG_E_STATUS_COPY_PROTECTION_FAILURE = unchecked((int)0x80030305),
		STG_E_CSS_AUTHENTICATION_FAILURE = unchecked((int)0x80030306),
		STG_E_CSS_KEY_NOT_PRESENT = unchecked((int)0x80030307),
		STG_E_CSS_KEY_NOT_ESTABLISHED = unchecked((int)0x80030308),
		STG_E_CSS_SCRAMBLED_SECTOR = unchecked((int)0x80030309),
		STG_E_CSS_REGION_MISMATCH = unchecked((int)0x8003030A),
		STG_E_RESETS_EXHAUSTED = unchecked((int)0x8003030B),
		RPC_E_CALL_REJECTED = unchecked((int)0x80010001),
		RPC_E_CALL_CANCELED = unchecked((int)0x80010002),
		RPC_E_CANTPOST_INSENDCALL = unchecked((int)0x80010003),
		RPC_E_CANTCALLOUT_INASYNCCALL = unchecked((int)0x80010004),
		RPC_E_CANTCALLOUT_INEXTERNALCALL = unchecked((int)0x80010005),
		RPC_E_CONNECTION_TERMINATED = unchecked((int)0x80010006),
		RPC_E_SERVER_DIED = unchecked((int)0x80010007),
		RPC_E_CLIENT_DIED = unchecked((int)0x80010008),
		RPC_E_INVALID_DATAPACKET = unchecked((int)0x80010009),
		RPC_E_CANTTRANSMIT_CALL = unchecked((int)0x8001000A),
		RPC_E_CLIENT_CANTMARSHAL_DATA = unchecked((int)0x8001000B),
		RPC_E_CLIENT_CANTUNMARSHAL_DATA = unchecked((int)0x8001000C),
		RPC_E_SERVER_CANTMARSHAL_DATA = unchecked((int)0x8001000D),
		RPC_E_SERVER_CANTUNMARSHAL_DATA = unchecked((int)0x8001000E),
		RPC_E_INVALID_DATA = unchecked((int)0x8001000F),
		RPC_E_INVALID_PARAMETER = unchecked((int)0x80010010),
		RPC_E_CANTCALLOUT_AGAIN = unchecked((int)0x80010011),
		RPC_E_SERVER_DIED_DNE = unchecked((int)0x80010012),
		RPC_E_SYS_CALL_FAILED = unchecked((int)0x80010100),
		RPC_E_OUT_OF_RESOURCES = unchecked((int)0x80010101),
		RPC_E_ATTEMPTED_MULTITHREAD = unchecked((int)0x80010102),
		RPC_E_NOT_REGISTERED = unchecked((int)0x80010103),
		RPC_E_FAULT = unchecked((int)0x80010104),
		RPC_E_SERVERFAULT = unchecked((int)0x80010105),
		RPC_E_CHANGED_MODE = unchecked((int)0x80010106),
		RPC_E_INVALIDMETHOD = unchecked((int)0x80010107),
		RPC_E_DISCONNECTED = unchecked((int)0x80010108),
		RPC_E_RETRY = unchecked((int)0x80010109),
		RPC_E_SERVERCALL_RETRYLATER = unchecked((int)0x8001010A),
		RPC_E_SERVERCALL_REJECTED = unchecked((int)0x8001010B),
		RPC_E_INVALID_CALLDATA = unchecked((int)0x8001010C),
		RPC_E_CANTCALLOUT_ININPUTSYNCCALL = unchecked((int)0x8001010D),
		RPC_E_WRONG_THREAD = unchecked((int)0x8001010E),
		RPC_E_THREAD_NOT_INIT = unchecked((int)0x8001010F),
		RPC_E_VERSION_MISMATCH = unchecked((int)0x80010110),
		RPC_E_INVALID_HEADER = unchecked((int)0x80010111),
		RPC_E_INVALID_EXTENSION = unchecked((int)0x80010112),
		RPC_E_INVALID_IPID = unchecked((int)0x80010113),
		RPC_E_INVALID_OBJECT = unchecked((int)0x80010114),
		RPC_S_CALLPENDING = unchecked((int)0x80010115),
		RPC_S_WAITONTIMER = unchecked((int)0x80010116),
		RPC_E_CALL_COMPLETE = unchecked((int)0x80010117),
		RPC_E_UNSECURE_CALL = unchecked((int)0x80010118),
		RPC_E_TOO_LATE = unchecked((int)0x80010119),
		RPC_E_NO_GOOD_SECURITY_PACKAGES = unchecked((int)0x8001011A),
		RPC_E_ACCESS_DENIED = unchecked((int)0x8001011B),
		RPC_E_REMOTE_DISABLED = unchecked((int)0x8001011C),
		RPC_E_INVALID_OBJREF = unchecked((int)0x8001011D),
		RPC_E_NO_CONTEXT = unchecked((int)0x8001011E),
		RPC_E_TIMEOUT = unchecked((int)0x8001011F),
		RPC_E_NO_SYNC = unchecked((int)0x80010120),
		RPC_E_FULLSIC_REQUIRED = unchecked((int)0x80010121),
		RPC_E_INVALID_STD_NAME = unchecked((int)0x80010122),
		CO_E_FAILEDTOIMPERSONATE = unchecked((int)0x80010123),
		CO_E_FAILEDTOGETSECCTX = unchecked((int)0x80010124),
		CO_E_FAILEDTOOPENTHREADTOKEN = unchecked((int)0x80010125),
		CO_E_FAILEDTOGETTOKENINFO = unchecked((int)0x80010126),
		CO_E_TRUSTEEDOESNTMATCHCLIENT = unchecked((int)0x80010127),
		CO_E_FAILEDTOQUERYCLIENTBLANKET = unchecked((int)0x80010128),
		CO_E_FAILEDTOSETDACL = unchecked((int)0x80010129),
		CO_E_ACCESSCHECKFAILED = unchecked((int)0x8001012A),
		CO_E_NETACCESSAPIFAILED = unchecked((int)0x8001012B),
		CO_E_WRONGTRUSTEENAMESYNTAX = unchecked((int)0x8001012C),
		CO_E_INVALIDSID = unchecked((int)0x8001012D),
		CO_E_CONVERSIONFAILED = unchecked((int)0x8001012E),
		CO_E_NOMATCHINGSIDFOUND = unchecked((int)0x8001012F),
		CO_E_LOOKUPACCSIDFAILED = unchecked((int)0x80010130),
		CO_E_NOMATCHINGNAMEFOUND = unchecked((int)0x80010131),
		CO_E_LOOKUPACCNAMEFAILED = unchecked((int)0x80010132),
		CO_E_SETSERLHNDLFAILED = unchecked((int)0x80010133),
		CO_E_FAILEDTOGETWINDIR = unchecked((int)0x80010134),
		CO_E_PATHTOOLONG = unchecked((int)0x80010135),
		CO_E_FAILEDTOGENUUID = unchecked((int)0x80010136),
		CO_E_FAILEDTOCREATEFILE = unchecked((int)0x80010137),
		CO_E_FAILEDTOCLOSEHANDLE = unchecked((int)0x80010138),
		CO_E_EXCEEDSYSACLLIMIT = unchecked((int)0x80010139),
		CO_E_ACESINWRONGORDER = unchecked((int)0x8001013A),
		CO_E_INCOMPATIBLESTREAMVERSION = unchecked((int)0x8001013B),
		CO_E_FAILEDTOOPENPROCESSTOKEN = unchecked((int)0x8001013C),
		CO_E_DECODEFAILED = unchecked((int)0x8001013D),
		CO_E_ACNOTINITIALIZED = unchecked((int)0x8001013F),
		CO_E_CANCEL_DISABLED = unchecked((int)0x80010140),
		RPC_E_UNEXPECTED = unchecked((int)0x8001FFFF),
		ERROR_AUDITING_DISABLED = unchecked((int)0xC0090001),
		ERROR_ALL_SIDS_FILTERED = unchecked((int)0xC0090002),
		NTE_BAD_UID = unchecked((int)0x80090001),
		NTE_BAD_HASH = unchecked((int)0x80090002),
		NTE_BAD_KEY = unchecked((int)0x80090003),
		NTE_BAD_LEN = unchecked((int)0x80090004),
		NTE_BAD_DATA = unchecked((int)0x80090005),
		NTE_BAD_SIGNATURE = unchecked((int)0x80090006),
		NTE_BAD_VER = unchecked((int)0x80090007),
		NTE_BAD_ALGID = unchecked((int)0x80090008),
		NTE_BAD_FLAGS = unchecked((int)0x80090009),
		NTE_BAD_TYPE = unchecked((int)0x8009000A),
		NTE_BAD_KEY_STATE = unchecked((int)0x8009000B),
		NTE_BAD_HASH_STATE = unchecked((int)0x8009000C),
		NTE_NO_KEY = unchecked((int)0x8009000D),
		NTE_NO_MEMORY = unchecked((int)0x8009000E),
		NTE_EXISTS = unchecked((int)0x8009000F),
		NTE_PERM = unchecked((int)0x80090010),
		NTE_NOT_FOUND = unchecked((int)0x80090011),
		NTE_DOUBLE_ENCRYPT = unchecked((int)0x80090012),
		NTE_BAD_PROVIDER = unchecked((int)0x80090013),
		NTE_BAD_PROV_TYPE = unchecked((int)0x80090014),
		NTE_BAD_PUBLIC_KEY = unchecked((int)0x80090015),
		NTE_BAD_KEYSET = unchecked((int)0x80090016),
		NTE_PROV_TYPE_NOT_DEF = unchecked((int)0x80090017),
		NTE_PROV_TYPE_ENTRY_BAD = unchecked((int)0x80090018),
		NTE_KEYSET_NOT_DEF = unchecked((int)0x80090019),
		NTE_KEYSET_ENTRY_BAD = unchecked((int)0x8009001A),
		NTE_PROV_TYPE_NO_MATCH = unchecked((int)0x8009001B),
		NTE_SIGNATURE_FILE_BAD = unchecked((int)0x8009001C),
		NTE_PROVIDER_DLL_FAIL = unchecked((int)0x8009001D),
		NTE_PROV_DLL_NOT_FOUND = unchecked((int)0x8009001E),
		NTE_BAD_KEYSET_PARAM = unchecked((int)0x8009001F),
		NTE_FAIL = unchecked((int)0x80090020),
		NTE_SYS_ERR = unchecked((int)0x80090021),
		NTE_SILENT_CONTEXT = unchecked((int)0x80090022),
		NTE_TOKEN_KEYSET_STORAGE_FULL = unchecked((int)0x80090023),
		NTE_TEMPORARY_PROFILE = unchecked((int)0x80090024),
		NTE_FIXEDPARAMETER = unchecked((int)0x80090025),
		SEC_E_INSUFFICIENT_MEMORY = unchecked((int)0x80090300),
		SEC_E_INVALID_HANDLE = unchecked((int)0x80090301),
		SEC_E_UNSUPPORTED_FUNCTION = unchecked((int)0x80090302),
		SEC_E_TARGET_UNKNOWN = unchecked((int)0x80090303),
		SEC_E_INTERNAL_ERROR = unchecked((int)0x80090304),
		SEC_E_SECPKG_NOT_FOUND = unchecked((int)0x80090305),
		SEC_E_NOT_OWNER = unchecked((int)0x80090306),
		SEC_E_CANNOT_INSTALL = unchecked((int)0x80090307),
		SEC_E_INVALID_TOKEN = unchecked((int)0x80090308),
		SEC_E_CANNOT_PACK = unchecked((int)0x80090309),
		SEC_E_QOP_NOT_SUPPORTED = unchecked((int)0x8009030A),
		SEC_E_NO_IMPERSONATION = unchecked((int)0x8009030B),
		SEC_E_LOGON_DENIED = unchecked((int)0x8009030C),
		SEC_E_UNKNOWN_CREDENTIALS = unchecked((int)0x8009030D),
		SEC_E_NO_CREDENTIALS = unchecked((int)0x8009030E),
		SEC_E_MESSAGE_ALTERED = unchecked((int)0x8009030F),
		SEC_E_OUT_OF_SEQUENCE = unchecked((int)0x80090310),
		SEC_E_NO_AUTHENTICATING_AUTHORITY = unchecked((int)0x80090311),
		SEC_I_CONTINUE_NEEDED = unchecked((int)0x00090312),
		SEC_I_COMPLETE_NEEDED = unchecked((int)0x00090313),
		SEC_I_COMPLETE_AND_CONTINUE = unchecked((int)0x00090314),
		SEC_I_LOCAL_LOGON = unchecked((int)0x00090315),
		SEC_E_BAD_PKGID = unchecked((int)0x80090316),
		SEC_E_CONTEXT_EXPIRED = unchecked((int)0x80090317),
		SEC_I_CONTEXT_EXPIRED = unchecked((int)0x00090317),
		SEC_E_INCOMPLETE_MESSAGE = unchecked((int)0x80090318),
		SEC_E_INCOMPLETE_CREDENTIALS = unchecked((int)0x80090320),
		SEC_E_BUFFER_TOO_SMALL = unchecked((int)0x80090321),
		SEC_I_INCOMPLETE_CREDENTIALS = unchecked((int)0x00090320),
		SEC_I_RENEGOTIATE = unchecked((int)0x00090321),
		SEC_E_WRONG_PRINCIPAL = unchecked((int)0x80090322),
		SEC_I_NO_LSA_CONTEXT = unchecked((int)0x00090323),
		SEC_E_TIME_SKEW = unchecked((int)0x80090324),
		SEC_E_UNTRUSTED_ROOT = unchecked((int)0x80090325),
		SEC_E_ILLEGAL_MESSAGE = unchecked((int)0x80090326),
		SEC_E_CERT_UNKNOWN = unchecked((int)0x80090327),
		SEC_E_CERT_EXPIRED = unchecked((int)0x80090328),
		SEC_E_ENCRYPT_FAILURE = unchecked((int)0x80090329),
		SEC_E_DECRYPT_FAILURE = unchecked((int)0x80090330),
		SEC_E_ALGORITHM_MISMATCH = unchecked((int)0x80090331),
		SEC_E_SECURITY_QOS_FAILED = unchecked((int)0x80090332),
		SEC_E_UNFINISHED_CONTEXT_DELETED = unchecked((int)0x80090333),
		SEC_E_NO_TGT_REPLY = unchecked((int)0x80090334),
		SEC_E_NO_IP_ADDRESSES = unchecked((int)0x80090335),
		SEC_E_WRONG_CREDENTIAL_HANDLE = unchecked((int)0x80090336),
		SEC_E_CRYPTO_SYSTEM_INVALID = unchecked((int)0x80090337),
		SEC_E_MAX_REFERRALS_EXCEEDED = unchecked((int)0x80090338),
		SEC_E_MUST_BE_KDC = unchecked((int)0x80090339),
		SEC_E_STRONG_CRYPTO_NOT_SUPPORTED = unchecked((int)0x8009033A),
		SEC_E_TOO_MANY_PRINCIPALS = unchecked((int)0x8009033B),
		SEC_E_NO_PA_DATA = unchecked((int)0x8009033C),
		SEC_E_PKINIT_NAME_MISMATCH = unchecked((int)0x8009033D),
		SEC_E_SMARTCARD_LOGON_REQUIRED = unchecked((int)0x8009033E),
		SEC_E_SHUTDOWN_IN_PROGRESS = unchecked((int)0x8009033F),
		SEC_E_KDC_INVALID_REQUEST = unchecked((int)0x80090340),
		SEC_E_KDC_UNABLE_TO_REFER = unchecked((int)0x80090341),
		SEC_E_KDC_UNKNOWN_ETYPE = unchecked((int)0x80090342),
		SEC_E_UNSUPPORTED_PREAUTH = unchecked((int)0x80090343),
		SEC_E_DELEGATION_REQUIRED = unchecked((int)0x80090345),
		SEC_E_BAD_BINDINGS = unchecked((int)0x80090346),
		SEC_E_MULTIPLE_ACCOUNTS = unchecked((int)0x80090347),
		SEC_E_NO_KERB_KEY = unchecked((int)0x80090348),
		SEC_E_CERT_WRONG_USAGE = unchecked((int)0x80090349),
		SEC_E_DOWNGRADE_DETECTED = unchecked((int)0x80090350),
		SEC_E_SMARTCARD_CERT_REVOKED = unchecked((int)0x80090351),
		SEC_E_ISSUING_CA_UNTRUSTED = unchecked((int)0x80090352),
		SEC_E_REVOCATION_OFFLINE_C = unchecked((int)0x80090353),
		SEC_E_PKINIT_CLIENT_FAILURE = unchecked((int)0x80090354),
		SEC_E_SMARTCARD_CERT_EXPIRED = unchecked((int)0x80090355),
		SEC_E_NO_S4U_PROT_SUPPORT = unchecked((int)0x80090356),
		SEC_E_CROSSREALM_DELEGATION_FAILURE = unchecked((int)0x80090357),
		SEC_E_REVOCATION_OFFLINE_KDC = unchecked((int)0x80090358),
		SEC_E_ISSUING_CA_UNTRUSTED_KDC = unchecked((int)0x80090359),
		SEC_E_KDC_CERT_EXPIRED = unchecked((int)0x8009035A),
		SEC_E_KDC_CERT_REVOKED = unchecked((int)0x8009035B),
		CRYPT_E_MSG_ERROR = unchecked((int)0x80091001),
		CRYPT_E_UNKNOWN_ALGO = unchecked((int)0x80091002),
		CRYPT_E_OID_FORMAT = unchecked((int)0x80091003),
		CRYPT_E_INVALID_MSG_TYPE = unchecked((int)0x80091004),
		CRYPT_E_UNEXPECTED_ENCODING = unchecked((int)0x80091005),
		CRYPT_E_AUTH_ATTR_MISSING = unchecked((int)0x80091006),
		CRYPT_E_HASH_VALUE = unchecked((int)0x80091007),
		CRYPT_E_INVALID_INDEX = unchecked((int)0x80091008),
		CRYPT_E_ALREADY_DECRYPTED = unchecked((int)0x80091009),
		CRYPT_E_NOT_DECRYPTED = unchecked((int)0x8009100A),
		CRYPT_E_RECIPIENT_NOT_FOUND = unchecked((int)0x8009100B),
		CRYPT_E_CONTROL_TYPE = unchecked((int)0x8009100C),
		CRYPT_E_ISSUER_SERIALNUMBER = unchecked((int)0x8009100D),
		CRYPT_E_SIGNER_NOT_FOUND = unchecked((int)0x8009100E),
		CRYPT_E_ATTRIBUTES_MISSING = unchecked((int)0x8009100F),
		CRYPT_E_STREAM_MSG_NOT_READY = unchecked((int)0x80091010),
		CRYPT_E_STREAM_INSUFFICIENT_DATA = unchecked((int)0x80091011),
		CRYPT_I_NEW_PROTECTION_REQUIRED = unchecked((int)0x00091012),
		CRYPT_E_BAD_LEN = unchecked((int)0x80092001),
		CRYPT_E_BAD_ENCODE = unchecked((int)0x80092002),
		CRYPT_E_FILE_ERROR = unchecked((int)0x80092003),
		CRYPT_E_NOT_FOUND = unchecked((int)0x80092004),
		CRYPT_E_EXISTS = unchecked((int)0x80092005),
		CRYPT_E_NO_PROVIDER = unchecked((int)0x80092006),
		CRYPT_E_SELF_SIGNED = unchecked((int)0x80092007),
		CRYPT_E_DELETED_PREV = unchecked((int)0x80092008),
		CRYPT_E_NO_MATCH = unchecked((int)0x80092009),
		CRYPT_E_UNEXPECTED_MSG_TYPE = unchecked((int)0x8009200A),
		CRYPT_E_NO_KEY_PROPERTY = unchecked((int)0x8009200B),
		CRYPT_E_NO_DECRYPT_CERT = unchecked((int)0x8009200C),
		CRYPT_E_BAD_MSG = unchecked((int)0x8009200D),
		CRYPT_E_NO_SIGNER = unchecked((int)0x8009200E),
		CRYPT_E_PENDING_CLOSE = unchecked((int)0x8009200F),
		CRYPT_E_REVOKED = unchecked((int)0x80092010),
		CRYPT_E_NO_REVOCATION_DLL = unchecked((int)0x80092011),
		CRYPT_E_NO_REVOCATION_CHECK = unchecked((int)0x80092012),
		CRYPT_E_REVOCATION_OFFLINE = unchecked((int)0x80092013),
		CRYPT_E_NOT_IN_REVOCATION_DATABASE = unchecked((int)0x80092014),
		CRYPT_E_INVALID_NUMERIC_STRING = unchecked((int)0x80092020),
		CRYPT_E_INVALID_PRINTABLE_STRING = unchecked((int)0x80092021),
		CRYPT_E_INVALID_IA5_STRING = unchecked((int)0x80092022),
		CRYPT_E_INVALID_X500_STRING = unchecked((int)0x80092023),
		CRYPT_E_NOT_CHAR_STRING = unchecked((int)0x80092024),
		CRYPT_E_FILERESIZED = unchecked((int)0x80092025),
		CRYPT_E_SECURITY_SETTINGS = unchecked((int)0x80092026),
		CRYPT_E_NO_VERIFY_USAGE_DLL = unchecked((int)0x80092027),
		CRYPT_E_NO_VERIFY_USAGE_CHECK = unchecked((int)0x80092028),
		CRYPT_E_VERIFY_USAGE_OFFLINE = unchecked((int)0x80092029),
		CRYPT_E_NOT_IN_CTL = unchecked((int)0x8009202A),
		CRYPT_E_NO_TRUSTED_SIGNER = unchecked((int)0x8009202B),
		CRYPT_E_MISSING_PUBKEY_PARA = unchecked((int)0x8009202C),
		CRYPT_E_OSS_ERROR = unchecked((int)0x80093000),
		OSS_MORE_BUF = unchecked((int)0x80093001),
		OSS_NEGATIVE_UINTEGER = unchecked((int)0x80093002),
		OSS_PDU_RANGE = unchecked((int)0x80093003),
		OSS_MORE_INPUT = unchecked((int)0x80093004),
		OSS_DATA_ERROR = unchecked((int)0x80093005),
		OSS_BAD_ARG = unchecked((int)0x80093006),
		OSS_BAD_VERSION = unchecked((int)0x80093007),
		OSS_OUT_MEMORY = unchecked((int)0x80093008),
		OSS_PDU_MISMATCH = unchecked((int)0x80093009),
		OSS_LIMITED = unchecked((int)0x8009300A),
		OSS_BAD_PTR = unchecked((int)0x8009300B),
		OSS_BAD_TIME = unchecked((int)0x8009300C),
		OSS_INDEFINITE_NOT_SUPPORTED = unchecked((int)0x8009300D),
		OSS_MEM_ERROR = unchecked((int)0x8009300E),
		OSS_BAD_TABLE = unchecked((int)0x8009300F),
		OSS_TOO_LONG = unchecked((int)0x80093010),
		OSS_CONSTRAINT_VIOLATED = unchecked((int)0x80093011),
		OSS_FATAL_ERROR = unchecked((int)0x80093012),
		OSS_ACCESS_SERIALIZATION_ERROR = unchecked((int)0x80093013),
		OSS_NULL_TBL = unchecked((int)0x80093014),
		OSS_NULL_FCN = unchecked((int)0x80093015),
		OSS_BAD_ENCRULES = unchecked((int)0x80093016),
		OSS_UNAVAIL_ENCRULES = unchecked((int)0x80093017),
		OSS_CANT_OPEN_TRACE_WINDOW = unchecked((int)0x80093018),
		OSS_UNIMPLEMENTED = unchecked((int)0x80093019),
		OSS_OID_DLL_NOT_LINKED = unchecked((int)0x8009301A),
		OSS_CANT_OPEN_TRACE_FILE = unchecked((int)0x8009301B),
		OSS_TRACE_FILE_ALREADY_OPEN = unchecked((int)0x8009301C),
		OSS_TABLE_MISMATCH = unchecked((int)0x8009301D),
		OSS_TYPE_NOT_SUPPORTED = unchecked((int)0x8009301E),
		OSS_REAL_DLL_NOT_LINKED = unchecked((int)0x8009301F),
		OSS_REAL_CODE_NOT_LINKED = unchecked((int)0x80093020),
		OSS_OUT_OF_RANGE = unchecked((int)0x80093021),
		OSS_COPIER_DLL_NOT_LINKED = unchecked((int)0x80093022),
		OSS_CONSTRAINT_DLL_NOT_LINKED = unchecked((int)0x80093023),
		OSS_COMPARATOR_DLL_NOT_LINKED = unchecked((int)0x80093024),
		OSS_COMPARATOR_CODE_NOT_LINKED = unchecked((int)0x80093025),
		OSS_MEM_MGR_DLL_NOT_LINKED = unchecked((int)0x80093026),
		OSS_PDV_DLL_NOT_LINKED = unchecked((int)0x80093027),
		OSS_PDV_CODE_NOT_LINKED = unchecked((int)0x80093028),
		OSS_API_DLL_NOT_LINKED = unchecked((int)0x80093029),
		OSS_BERDER_DLL_NOT_LINKED = unchecked((int)0x8009302A),
		OSS_PER_DLL_NOT_LINKED = unchecked((int)0x8009302B),
		OSS_OPEN_TYPE_ERROR = unchecked((int)0x8009302C),
		OSS_MUTEX_NOT_CREATED = unchecked((int)0x8009302D),
		OSS_CANT_CLOSE_TRACE_FILE = unchecked((int)0x8009302E),
		CRYPT_E_ASN1_ERROR = unchecked((int)0x80093100),
		CRYPT_E_ASN1_INTERNAL = unchecked((int)0x80093101),
		CRYPT_E_ASN1_EOD = unchecked((int)0x80093102),
		CRYPT_E_ASN1_CORRUPT = unchecked((int)0x80093103),
		CRYPT_E_ASN1_LARGE = unchecked((int)0x80093104),
		CRYPT_E_ASN1_CONSTRAINT = unchecked((int)0x80093105),
		CRYPT_E_ASN1_MEMORY = unchecked((int)0x80093106),
		CRYPT_E_ASN1_OVERFLOW = unchecked((int)0x80093107),
		CRYPT_E_ASN1_BADPDU = unchecked((int)0x80093108),
		CRYPT_E_ASN1_BADARGS = unchecked((int)0x80093109),
		CRYPT_E_ASN1_BADREAL = unchecked((int)0x8009310A),
		CRYPT_E_ASN1_BADTAG = unchecked((int)0x8009310B),
		CRYPT_E_ASN1_CHOICE = unchecked((int)0x8009310C),
		CRYPT_E_ASN1_RULE = unchecked((int)0x8009310D),
		CRYPT_E_ASN1_UTF8 = unchecked((int)0x8009310E),
		CRYPT_E_ASN1_PDU_TYPE = unchecked((int)0x80093133),
		CRYPT_E_ASN1_NYI = unchecked((int)0x80093134),
		CRYPT_E_ASN1_EXTENDED = unchecked((int)0x80093201),
		CRYPT_E_ASN1_NOEOD = unchecked((int)0x80093202),
		CERTSRV_E_BAD_REQUESTSUBJECT = unchecked((int)0x80094001),
		CERTSRV_E_NO_REQUEST = unchecked((int)0x80094002),
		CERTSRV_E_BAD_REQUESTSTATUS = unchecked((int)0x80094003),
		CERTSRV_E_PROPERTY_EMPTY = unchecked((int)0x80094004),
		CERTSRV_E_INVALID_CA_CERTIFICATE = unchecked((int)0x80094005),
		CERTSRV_E_SERVER_SUSPENDED = unchecked((int)0x80094006),
		CERTSRV_E_ENCODING_LENGTH = unchecked((int)0x80094007),
		CERTSRV_E_ROLECONFLICT = unchecked((int)0x80094008),
		CERTSRV_E_RESTRICTEDOFFICER = unchecked((int)0x80094009),
		CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED = unchecked((int)0x8009400A),
		CERTSRV_E_NO_VALID_KRA = unchecked((int)0x8009400B),
		CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL = unchecked((int)0x8009400C),
		CERTSRV_E_NO_CAADMIN_DEFINED = unchecked((int)0x8009400D),
		CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE = unchecked((int)0x8009400E),
		CERTSRV_E_NO_DB_SESSIONS = unchecked((int)0x8009400F),
		CERTSRV_E_ALIGNMENT_FAULT = unchecked((int)0x80094010),
		CERTSRV_E_ENROLL_DENIED = unchecked((int)0x80094011),
		CERTSRV_E_TEMPLATE_DENIED = unchecked((int)0x80094012),
		CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE = unchecked((int)0x80094013),
		CERTSRV_E_UNSUPPORTED_CERT_TYPE = unchecked((int)0x80094800),
		CERTSRV_E_NO_CERT_TYPE = unchecked((int)0x80094801),
		CERTSRV_E_TEMPLATE_CONFLICT = unchecked((int)0x80094802),
		CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED = unchecked((int)0x80094803),
		CERTSRV_E_ARCHIVED_KEY_REQUIRED = unchecked((int)0x80094804),
		CERTSRV_E_SMIME_REQUIRED = unchecked((int)0x80094805),
		CERTSRV_E_BAD_RENEWAL_SUBJECT = unchecked((int)0x80094806),
		CERTSRV_E_BAD_TEMPLATE_VERSION = unchecked((int)0x80094807),
		CERTSRV_E_TEMPLATE_POLICY_REQUIRED = unchecked((int)0x80094808),
		CERTSRV_E_SIGNATURE_POLICY_REQUIRED = unchecked((int)0x80094809),
		CERTSRV_E_SIGNATURE_COUNT = unchecked((int)0x8009480A),
		CERTSRV_E_SIGNATURE_REJECTED = unchecked((int)0x8009480B),
		CERTSRV_E_ISSUANCE_POLICY_REQUIRED = unchecked((int)0x8009480C),
		CERTSRV_E_SUBJECT_UPN_REQUIRED = unchecked((int)0x8009480D),
		CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED = unchecked((int)0x8009480E),
		CERTSRV_E_SUBJECT_DNS_REQUIRED = unchecked((int)0x8009480F),
		CERTSRV_E_ARCHIVED_KEY_UNEXPECTED = unchecked((int)0x80094810),
		CERTSRV_E_KEY_LENGTH = unchecked((int)0x80094811),
		CERTSRV_E_SUBJECT_EMAIL_REQUIRED = unchecked((int)0x80094812),
		CERTSRV_E_UNKNOWN_CERT_TYPE = unchecked((int)0x80094813),
		CERTSRV_E_CERT_TYPE_OVERLAP = unchecked((int)0x80094814),
		XENROLL_E_KEY_NOT_EXPORTABLE = unchecked((int)0x80095000),
		XENROLL_E_CANNOT_ADD_ROOT_CERT = unchecked((int)0x80095001),
		XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND = unchecked((int)0x80095002),
		XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH = unchecked((int)0x80095003),
		XENROLL_E_RESPONSE_KA_HASH_MISMATCH = unchecked((int)0x80095004),
		XENROLL_E_KEYSPEC_SMIME_MISMATCH = unchecked((int)0x80095005),
		TRUST_E_SYSTEM_ERROR = unchecked((int)0x80096001),
		TRUST_E_NO_SIGNER_CERT = unchecked((int)0x80096002),
		TRUST_E_COUNTER_SIGNER = unchecked((int)0x80096003),
		TRUST_E_CERT_SIGNATURE = unchecked((int)0x80096004),
		TRUST_E_TIME_STAMP = unchecked((int)0x80096005),
		TRUST_E_BAD_DIGEST = unchecked((int)0x80096010),
		TRUST_E_BASIC_CONSTRAINTS = unchecked((int)0x80096019),
		TRUST_E_FINANCIAL_CRITERIA = unchecked((int)0x8009601E),
		MSSIPOTF_E_OUTOFMEMRANGE = unchecked((int)0x80097001),
		MSSIPOTF_E_CANTGETOBJECT = unchecked((int)0x80097002),
		MSSIPOTF_E_NOHEADTABLE = unchecked((int)0x80097003),
		MSSIPOTF_E_BAD_MAGICNUMBER = unchecked((int)0x80097004),
		MSSIPOTF_E_BAD_OFFSET_TABLE = unchecked((int)0x80097005),
		MSSIPOTF_E_TABLE_TAGORDER = unchecked((int)0x80097006),
		MSSIPOTF_E_TABLE_LONGWORD = unchecked((int)0x80097007),
		MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT = unchecked((int)0x80097008),
		MSSIPOTF_E_TABLES_OVERLAP = unchecked((int)0x80097009),
		MSSIPOTF_E_TABLE_PADBYTES = unchecked((int)0x8009700A),
		MSSIPOTF_E_FILETOOSMALL = unchecked((int)0x8009700B),
		MSSIPOTF_E_TABLE_CHECKSUM = unchecked((int)0x8009700C),
		MSSIPOTF_E_FILE_CHECKSUM = unchecked((int)0x8009700D),
		MSSIPOTF_E_FAILED_POLICY = unchecked((int)0x80097010),
		MSSIPOTF_E_FAILED_HINTS_CHECK = unchecked((int)0x80097011),
		MSSIPOTF_E_NOT_OPENTYPE = unchecked((int)0x80097012),
		MSSIPOTF_E_FILE = unchecked((int)0x80097013),
		MSSIPOTF_E_CRYPT = unchecked((int)0x80097014),
		MSSIPOTF_E_BADVERSION = unchecked((int)0x80097015),
		MSSIPOTF_E_DSIG_STRUCTURE = unchecked((int)0x80097016),
		MSSIPOTF_E_PCONST_CHECK = unchecked((int)0x80097017),
		MSSIPOTF_E_STRUCTURE = unchecked((int)0x80097018),
		TRUST_E_PROVIDER_UNKNOWN = unchecked((int)0x800B0001),
		TRUST_E_ACTION_UNKNOWN = unchecked((int)0x800B0002),
		TRUST_E_SUBJECT_FORM_UNKNOWN = unchecked((int)0x800B0003),
		TRUST_E_SUBJECT_NOT_TRUSTED = unchecked((int)0x800B0004),
		DIGSIG_E_ENCODE = unchecked((int)0x800B0005),
		DIGSIG_E_DECODE = unchecked((int)0x800B0006),
		DIGSIG_E_EXTENSIBILITY = unchecked((int)0x800B0007),
		DIGSIG_E_CRYPTO = unchecked((int)0x800B0008),
		PERSIST_E_SIZEDEFINITE = unchecked((int)0x800B0009),
		PERSIST_E_SIZEINDEFINITE = unchecked((int)0x800B000A),
		PERSIST_E_NOTSELFSIZING = unchecked((int)0x800B000B),
		TRUST_E_NOSIGNATURE = unchecked((int)0x800B0100),
		CERT_E_EXPIRED = unchecked((int)0x800B0101),
		CERT_E_VALIDITYPERIODNESTING = unchecked((int)0x800B0102),
		CERT_E_ROLE = unchecked((int)0x800B0103),
		CERT_E_PATHLENCONST = unchecked((int)0x800B0104),
		CERT_E_CRITICAL = unchecked((int)0x800B0105),
		CERT_E_PURPOSE = unchecked((int)0x800B0106),
		CERT_E_ISSUERCHAINING = unchecked((int)0x800B0107),
		CERT_E_MALFORMED = unchecked((int)0x800B0108),
		CERT_E_UNTRUSTEDROOT = unchecked((int)0x800B0109),
		CERT_E_CHAINING = unchecked((int)0x800B010A),
		TRUST_E_FAIL = unchecked((int)0x800B010B),
		CERT_E_REVOKED = unchecked((int)0x800B010C),
		CERT_E_UNTRUSTEDTESTROOT = unchecked((int)0x800B010D),
		CERT_E_REVOCATION_FAILURE = unchecked((int)0x800B010E),
		CERT_E_CN_NO_MATCH = unchecked((int)0x800B010F),
		CERT_E_WRONG_USAGE = unchecked((int)0x800B0110),
		TRUST_E_EXPLICIT_DISTRUST = unchecked((int)0x800B0111),
		CERT_E_UNTRUSTEDCA = unchecked((int)0x800B0112),
		CERT_E_INVALID_POLICY = unchecked((int)0x800B0113),
		CERT_E_INVALID_NAME = unchecked((int)0x800B0114),
		SPAPI_E_EXPECTED_SECTION_NAME = unchecked((int)0x800F0000),
		SPAPI_E_BAD_SECTION_NAME_LINE = unchecked((int)0x800F0001),
		SPAPI_E_SECTION_NAME_TOO_LONG = unchecked((int)0x800F0002),
		SPAPI_E_GENERAL_SYNTAX = unchecked((int)0x800F0003),
		SPAPI_E_WRONG_INF_STYLE = unchecked((int)0x800F0100),
		SPAPI_E_SECTION_NOT_FOUND = unchecked((int)0x800F0101),
		SPAPI_E_LINE_NOT_FOUND = unchecked((int)0x800F0102),
		SPAPI_E_NO_BACKUP = unchecked((int)0x800F0103),
		SPAPI_E_NO_ASSOCIATED_CLASS = unchecked((int)0x800F0200),
		SPAPI_E_CLASS_MISMATCH = unchecked((int)0x800F0201),
		SPAPI_E_DUPLICATE_FOUND = unchecked((int)0x800F0202),
		SPAPI_E_NO_DRIVER_SELECTED = unchecked((int)0x800F0203),
		SPAPI_E_KEY_DOES_NOT_EXIST = unchecked((int)0x800F0204),
		SPAPI_E_INVALID_DEVINST_NAME = unchecked((int)0x800F0205),
		SPAPI_E_INVALID_CLASS = unchecked((int)0x800F0206),
		SPAPI_E_DEVINST_ALREADY_EXISTS = unchecked((int)0x800F0207),
		SPAPI_E_DEVINFO_NOT_REGISTERED = unchecked((int)0x800F0208),
		SPAPI_E_INVALID_REG_PROPERTY = unchecked((int)0x800F0209),
		SPAPI_E_NO_INF = unchecked((int)0x800F020A),
		SPAPI_E_NO_SUCH_DEVINST = unchecked((int)0x800F020B),
		SPAPI_E_CANT_LOAD_CLASS_ICON = unchecked((int)0x800F020C),
		SPAPI_E_INVALID_CLASS_INSTALLER = unchecked((int)0x800F020D),
		SPAPI_E_DI_DO_DEFAULT = unchecked((int)0x800F020E),
		SPAPI_E_DI_NOFILECOPY = unchecked((int)0x800F020F),
		SPAPI_E_INVALID_HWPROFILE = unchecked((int)0x800F0210),
		SPAPI_E_NO_DEVICE_SELECTED = unchecked((int)0x800F0211),
		SPAPI_E_DEVINFO_LIST_LOCKED = unchecked((int)0x800F0212),
		SPAPI_E_DEVINFO_DATA_LOCKED = unchecked((int)0x800F0213),
		SPAPI_E_DI_BAD_PATH = unchecked((int)0x800F0214),
		SPAPI_E_NO_CLASSINSTALL_PARAMS = unchecked((int)0x800F0215),
		SPAPI_E_FILEQUEUE_LOCKED = unchecked((int)0x800F0216),
		SPAPI_E_BAD_SERVICE_INSTALLSECT = unchecked((int)0x800F0217),
		SPAPI_E_NO_CLASS_DRIVER_LIST = unchecked((int)0x800F0218),
		SPAPI_E_NO_ASSOCIATED_SERVICE = unchecked((int)0x800F0219),
		SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE = unchecked((int)0x800F021A),
		SPAPI_E_DEVICE_INTERFACE_ACTIVE = unchecked((int)0x800F021B),
		SPAPI_E_DEVICE_INTERFACE_REMOVED = unchecked((int)0x800F021C),
		SPAPI_E_BAD_INTERFACE_INSTALLSECT = unchecked((int)0x800F021D),
		SPAPI_E_NO_SUCH_INTERFACE_CLASS = unchecked((int)0x800F021E),
		SPAPI_E_INVALID_REFERENCE_STRING = unchecked((int)0x800F021F),
		SPAPI_E_INVALID_MACHINENAME = unchecked((int)0x800F0220),
		SPAPI_E_REMOTE_COMM_FAILURE = unchecked((int)0x800F0221),
		SPAPI_E_MACHINE_UNAVAILABLE = unchecked((int)0x800F0222),
		SPAPI_E_NO_CONFIGMGR_SERVICES = unchecked((int)0x800F0223),
		SPAPI_E_INVALID_PROPPAGE_PROVIDER = unchecked((int)0x800F0224),
		SPAPI_E_NO_SUCH_DEVICE_INTERFACE = unchecked((int)0x800F0225),
		SPAPI_E_DI_POSTPROCESSING_REQUIRED = unchecked((int)0x800F0226),
		SPAPI_E_INVALID_COINSTALLER = unchecked((int)0x800F0227),
		SPAPI_E_NO_COMPAT_DRIVERS = unchecked((int)0x800F0228),
		SPAPI_E_NO_DEVICE_ICON = unchecked((int)0x800F0229),
		SPAPI_E_INVALID_INF_LOGCONFIG = unchecked((int)0x800F022A),
		SPAPI_E_DI_DONT_INSTALL = unchecked((int)0x800F022B),
		SPAPI_E_INVALID_FILTER_DRIVER = unchecked((int)0x800F022C),
		SPAPI_E_NON_WINDOWS_NT_DRIVER = unchecked((int)0x800F022D),
		SPAPI_E_NON_WINDOWS_DRIVER = unchecked((int)0x800F022E),
		SPAPI_E_NO_CATALOG_FOR_OEM_INF = unchecked((int)0x800F022F),
		SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE = unchecked((int)0x800F0230),
		SPAPI_E_NOT_DISABLEABLE = unchecked((int)0x800F0231),
		SPAPI_E_CANT_REMOVE_DEVINST = unchecked((int)0x800F0232),
		SPAPI_E_INVALID_TARGET = unchecked((int)0x800F0233),
		SPAPI_E_DRIVER_NONNATIVE = unchecked((int)0x800F0234),
		SPAPI_E_IN_WOW64 = unchecked((int)0x800F0235),
		SPAPI_E_SET_SYSTEM_RESTORE_POINT = unchecked((int)0x800F0236),
		SPAPI_E_INCORRECTLY_COPIED_INF = unchecked((int)0x800F0237),
		SPAPI_E_SCE_DISABLED = unchecked((int)0x800F0238),
		SPAPI_E_UNKNOWN_EXCEPTION = unchecked((int)0x800F0239),
		SPAPI_E_PNP_REGISTRY_ERROR = unchecked((int)0x800F023A),
		SPAPI_E_REMOTE_REQUEST_UNSUPPORTED = unchecked((int)0x800F023B),
		SPAPI_E_NOT_AN_INSTALLED_OEM_INF = unchecked((int)0x800F023C),
		SPAPI_E_INF_IN_USE_BY_DEVICES = unchecked((int)0x800F023D),
		SPAPI_E_DI_FUNCTION_OBSOLETE = unchecked((int)0x800F023E),
		SPAPI_E_NO_AUTHENTICODE_CATALOG = unchecked((int)0x800F023F),
		SPAPI_E_AUTHENTICODE_DISALLOWED = unchecked((int)0x800F0240),
		SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER = unchecked((int)0x800F0241),
		SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED = unchecked((int)0x800F0242),
		SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED = unchecked((int)0x800F0243),
		SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH = unchecked((int)0x800F0244),
		SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE = unchecked((int)0x800F0245),
		SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW = unchecked((int)0x800F0300),
		SPAPI_E_ERROR_NOT_INSTALLED = unchecked((int)0x800F1000),
		SCARD_F_INTERNAL_ERROR = unchecked((int)0x80100001),
		SCARD_E_CANCELLED = unchecked((int)0x80100002),
		SCARD_E_INVALID_HANDLE = unchecked((int)0x80100003),
		SCARD_E_INVALID_PARAMETER = unchecked((int)0x80100004),
		SCARD_E_INVALID_TARGET = unchecked((int)0x80100005),
		SCARD_E_NO_MEMORY = unchecked((int)0x80100006),
		SCARD_F_WAITED_TOO_LONG = unchecked((int)0x80100007),
		SCARD_E_INSUFFICIENT_BUFFER = unchecked((int)0x80100008),
		SCARD_E_UNKNOWN_READER = unchecked((int)0x80100009),
		SCARD_E_TIMEOUT = unchecked((int)0x8010000A),
		SCARD_E_SHARING_VIOLATION = unchecked((int)0x8010000B),
		SCARD_E_NO_SMARTCARD = unchecked((int)0x8010000C),
		SCARD_E_UNKNOWN_CARD = unchecked((int)0x8010000D),
		SCARD_E_CANT_DISPOSE = unchecked((int)0x8010000E),
		SCARD_E_PROTO_MISMATCH = unchecked((int)0x8010000F),
		SCARD_E_NOT_READY = unchecked((int)0x80100010),
		SCARD_E_INVALID_VALUE = unchecked((int)0x80100011),
		SCARD_E_SYSTEM_CANCELLED = unchecked((int)0x80100012),
		SCARD_F_COMM_ERROR = unchecked((int)0x80100013),
		SCARD_F_UNKNOWN_ERROR = unchecked((int)0x80100014),
		SCARD_E_INVALID_ATR = unchecked((int)0x80100015),
		SCARD_E_NOT_TRANSACTED = unchecked((int)0x80100016),
		SCARD_E_READER_UNAVAILABLE = unchecked((int)0x80100017),
		SCARD_P_SHUTDOWN = unchecked((int)0x80100018),
		SCARD_E_PCI_TOO_SMALL = unchecked((int)0x80100019),
		SCARD_E_READER_UNSUPPORTED = unchecked((int)0x8010001A),
		SCARD_E_DUPLICATE_READER = unchecked((int)0x8010001B),
		SCARD_E_CARD_UNSUPPORTED = unchecked((int)0x8010001C),
		SCARD_E_NO_SERVICE = unchecked((int)0x8010001D),
		SCARD_E_SERVICE_STOPPED = unchecked((int)0x8010001E),
		SCARD_E_UNEXPECTED = unchecked((int)0x8010001F),
		SCARD_E_ICC_INSTALLATION = unchecked((int)0x80100020),
		SCARD_E_ICC_CREATEORDER = unchecked((int)0x80100021),
		SCARD_E_UNSUPPORTED_FEATURE = unchecked((int)0x80100022),
		SCARD_E_DIR_NOT_FOUND = unchecked((int)0x80100023),
		SCARD_E_FILE_NOT_FOUND = unchecked((int)0x80100024),
		SCARD_E_NO_DIR = unchecked((int)0x80100025),
		SCARD_E_NO_FILE = unchecked((int)0x80100026),
		SCARD_E_NO_ACCESS = unchecked((int)0x80100027),
		SCARD_E_WRITE_TOO_MANY = unchecked((int)0x80100028),
		SCARD_E_BAD_SEEK = unchecked((int)0x80100029),
		SCARD_E_INVALID_CHV = unchecked((int)0x8010002A),
		SCARD_E_UNKNOWN_RES_MNG = unchecked((int)0x8010002B),
		SCARD_E_NO_SUCH_CERTIFICATE = unchecked((int)0x8010002C),
		SCARD_E_CERTIFICATE_UNAVAILABLE = unchecked((int)0x8010002D),
		SCARD_E_NO_READERS_AVAILABLE = unchecked((int)0x8010002E),
		SCARD_E_COMM_DATA_LOST = unchecked((int)0x8010002F),
		SCARD_E_NO_KEY_CONTAINER = unchecked((int)0x80100030),
		SCARD_E_SERVER_TOO_BUSY = unchecked((int)0x80100031),
		SCARD_W_UNSUPPORTED_CARD = unchecked((int)0x80100065),
		SCARD_W_UNRESPONSIVE_CARD = unchecked((int)0x80100066),
		SCARD_W_UNPOWERED_CARD = unchecked((int)0x80100067),
		SCARD_W_RESET_CARD = unchecked((int)0x80100068),
		SCARD_W_REMOVED_CARD = unchecked((int)0x80100069),
		SCARD_W_SECURITY_VIOLATION = unchecked((int)0x8010006A),
		SCARD_W_WRONG_CHV = unchecked((int)0x8010006B),
		SCARD_W_CHV_BLOCKED = unchecked((int)0x8010006C),
		SCARD_W_EOF = unchecked((int)0x8010006D),
		SCARD_W_CANCELLED_BY_USER = unchecked((int)0x8010006E),
		SCARD_W_CARD_NOT_AUTHENTICATED = unchecked((int)0x8010006F),
		COMADMIN_E_OBJECTERRORS = unchecked((int)0x80110401),
		COMADMIN_E_OBJECTINVALID = unchecked((int)0x80110402),
		COMADMIN_E_KEYMISSING = unchecked((int)0x80110403),
		COMADMIN_E_ALREADYINSTALLED = unchecked((int)0x80110404),
		COMADMIN_E_APP_FILE_WRITEFAIL = unchecked((int)0x80110407),
		COMADMIN_E_APP_FILE_READFAIL = unchecked((int)0x80110408),
		COMADMIN_E_APP_FILE_VERSION = unchecked((int)0x80110409),
		COMADMIN_E_BADPATH = unchecked((int)0x8011040A),
		COMADMIN_E_APPLICATIONEXISTS = unchecked((int)0x8011040B),
		COMADMIN_E_ROLEEXISTS = unchecked((int)0x8011040C),
		COMADMIN_E_CANTCOPYFILE = unchecked((int)0x8011040D),
		COMADMIN_E_NOUSER = unchecked((int)0x8011040F),
		COMADMIN_E_INVALIDUSERIDS = unchecked((int)0x80110410),
		COMADMIN_E_NOREGISTRYCLSID = unchecked((int)0x80110411),
		COMADMIN_E_BADREGISTRYPROGID = unchecked((int)0x80110412),
		COMADMIN_E_AUTHENTICATIONLEVEL = unchecked((int)0x80110413),
		COMADMIN_E_USERPASSWDNOTVALID = unchecked((int)0x80110414),
		COMADMIN_E_CLSIDORIIDMISMATCH = unchecked((int)0x80110418),
		COMADMIN_E_REMOTEINTERFACE = unchecked((int)0x80110419),
		COMADMIN_E_DLLREGISTERSERVER = unchecked((int)0x8011041A),
		COMADMIN_E_NOSERVERSHARE = unchecked((int)0x8011041B),
		COMADMIN_E_DLLLOADFAILED = unchecked((int)0x8011041D),
		COMADMIN_E_BADREGISTRYLIBID = unchecked((int)0x8011041E),
		COMADMIN_E_APPDIRNOTFOUND = unchecked((int)0x8011041F),
		COMADMIN_E_REGISTRARFAILED = unchecked((int)0x80110423),
		COMADMIN_E_COMPFILE_DOESNOTEXIST = unchecked((int)0x80110424),
		COMADMIN_E_COMPFILE_LOADDLLFAIL = unchecked((int)0x80110425),
		COMADMIN_E_COMPFILE_GETCLASSOBJ = unchecked((int)0x80110426),
		COMADMIN_E_COMPFILE_CLASSNOTAVAIL = unchecked((int)0x80110427),
		COMADMIN_E_COMPFILE_BADTLB = unchecked((int)0x80110428),
		COMADMIN_E_COMPFILE_NOTINSTALLABLE = unchecked((int)0x80110429),
		COMADMIN_E_NOTCHANGEABLE = unchecked((int)0x8011042A),
		COMADMIN_E_NOTDELETEABLE = unchecked((int)0x8011042B),
		COMADMIN_E_SESSION = unchecked((int)0x8011042C),
		COMADMIN_E_COMP_MOVE_LOCKED = unchecked((int)0x8011042D),
		COMADMIN_E_COMP_MOVE_BAD_DEST = unchecked((int)0x8011042E),
		COMADMIN_E_REGISTERTLB = unchecked((int)0x80110430),
		COMADMIN_E_SYSTEMAPP = unchecked((int)0x80110433),
		COMADMIN_E_COMPFILE_NOREGISTRAR = unchecked((int)0x80110434),
		COMADMIN_E_COREQCOMPINSTALLED = unchecked((int)0x80110435),
		COMADMIN_E_SERVICENOTINSTALLED = unchecked((int)0x80110436),
		COMADMIN_E_PROPERTYSAVEFAILED = unchecked((int)0x80110437),
		COMADMIN_E_OBJECTEXISTS = unchecked((int)0x80110438),
		COMADMIN_E_COMPONENTEXISTS = unchecked((int)0x80110439),
		COMADMIN_E_REGFILE_CORRUPT = unchecked((int)0x8011043B),
		COMADMIN_E_PROPERTY_OVERFLOW = unchecked((int)0x8011043C),
		COMADMIN_E_NOTINREGISTRY = unchecked((int)0x8011043E),
		COMADMIN_E_OBJECTNOTPOOLABLE = unchecked((int)0x8011043F),
		COMADMIN_E_APPLID_MATCHES_CLSID = unchecked((int)0x80110446),
		COMADMIN_E_ROLE_DOES_NOT_EXIST = unchecked((int)0x80110447),
		COMADMIN_E_START_APP_NEEDS_COMPONENTS = unchecked((int)0x80110448),
		COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM = unchecked((int)0x80110449),
		COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY = unchecked((int)0x8011044A),
		COMADMIN_E_CAN_NOT_START_APP = unchecked((int)0x8011044B),
		COMADMIN_E_CAN_NOT_EXPORT_SYS_APP = unchecked((int)0x8011044C),
		COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT = unchecked((int)0x8011044D),
		COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER = unchecked((int)0x8011044E),
		COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE = unchecked((int)0x8011044F),
		COMADMIN_E_BASE_PARTITION_ONLY = unchecked((int)0x80110450),
		COMADMIN_E_START_APP_DISABLED = unchecked((int)0x80110451),
		COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME = unchecked((int)0x80110457),
		COMADMIN_E_CAT_INVALID_PARTITION_NAME = unchecked((int)0x80110458),
		COMADMIN_E_CAT_PARTITION_IN_USE = unchecked((int)0x80110459),
		COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES = unchecked((int)0x8011045A),
		COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED = unchecked((int)0x8011045B),
		COMADMIN_E_AMBIGUOUS_APPLICATION_NAME = unchecked((int)0x8011045C),
		COMADMIN_E_AMBIGUOUS_PARTITION_NAME = unchecked((int)0x8011045D),
		COMADMIN_E_REGDB_NOTINITIALIZED = unchecked((int)0x80110472),
		COMADMIN_E_REGDB_NOTOPEN = unchecked((int)0x80110473),
		COMADMIN_E_REGDB_SYSTEMERR = unchecked((int)0x80110474),
		COMADMIN_E_REGDB_ALREADYRUNNING = unchecked((int)0x80110475),
		COMADMIN_E_MIG_VERSIONNOTSUPPORTED = unchecked((int)0x80110480),
		COMADMIN_E_MIG_SCHEMANOTFOUND = unchecked((int)0x80110481),
		COMADMIN_E_CAT_BITNESSMISMATCH = unchecked((int)0x80110482),
		COMADMIN_E_CAT_UNACCEPTABLEBITNESS = unchecked((int)0x80110483),
		COMADMIN_E_CAT_WRONGAPPBITNESS = unchecked((int)0x80110484),
		COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED = unchecked((int)0x80110485),
		COMADMIN_E_CAT_SERVERFAULT = unchecked((int)0x80110486),
		COMQC_E_APPLICATION_NOT_QUEUED = unchecked((int)0x80110600),
		COMQC_E_NO_QUEUEABLE_INTERFACES = unchecked((int)0x80110601),
		COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE = unchecked((int)0x80110602),
		COMQC_E_NO_IPERSISTSTREAM = unchecked((int)0x80110603),
		COMQC_E_BAD_MESSAGE = unchecked((int)0x80110604),
		COMQC_E_UNAUTHENTICATED = unchecked((int)0x80110605),
		COMQC_E_UNTRUSTED_ENQUEUER = unchecked((int)0x80110606),
		MSDTC_E_DUPLICATE_RESOURCE = unchecked((int)0x80110701),
		COMADMIN_E_OBJECT_PARENT_MISSING = unchecked((int)0x80110808),
		COMADMIN_E_OBJECT_DOES_NOT_EXIST = unchecked((int)0x80110809),
		COMADMIN_E_APP_NOT_RUNNING = unchecked((int)0x8011080A),
		COMADMIN_E_INVALID_PARTITION = unchecked((int)0x8011080B),
		COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE = unchecked((int)0x8011080D),
		COMADMIN_E_USER_IN_SET = unchecked((int)0x8011080E),
		COMADMIN_E_CANTRECYCLELIBRARYAPPS = unchecked((int)0x8011080F),
		COMADMIN_E_CANTRECYCLESERVICEAPPS = unchecked((int)0x80110811),
		COMADMIN_E_PROCESSALREADYRECYCLED = unchecked((int)0x80110812),
		COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED = unchecked((int)0x80110813),
		COMADMIN_E_CANTMAKEINPROCSERVICE = unchecked((int)0x80110814),
		COMADMIN_E_PROGIDINUSEBYCLSID = unchecked((int)0x80110815),
		COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET = unchecked((int)0x80110816),
		COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED = unchecked((int)0x80110817),
		COMADMIN_E_PARTITION_ACCESSDENIED = unchecked((int)0x80110818),
		COMADMIN_E_PARTITION_MSI_ONLY = unchecked((int)0x80110819),
		COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT = unchecked((int)0x8011081A),
		COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS = unchecked((int)0x8011081B),
		COMADMIN_E_COMP_MOVE_SOURCE = unchecked((int)0x8011081C),
		COMADMIN_E_COMP_MOVE_DEST = unchecked((int)0x8011081D),
		COMADMIN_E_COMP_MOVE_PRIVATE = unchecked((int)0x8011081E),
		COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET = unchecked((int)0x8011081F),
		COMADMIN_E_CANNOT_ALIAS_EVENTCLASS = unchecked((int)0x80110820),
		COMADMIN_E_PRIVATE_ACCESSDENIED = unchecked((int)0x80110821),
		COMADMIN_E_SAFERINVALID = unchecked((int)0x80110822),
		COMADMIN_E_REGISTRY_ACCESSDENIED = unchecked((int)0x80110823),
		COMADMIN_E_PARTITIONS_DISABLED = unchecked((int)0x80110824),
		// Imported HRESULTs from CorError.h
		CEE_E_ENTRYPOINT = unchecked((int)0x80131000),
		CEE_E_CVTRES_NOT_FOUND = unchecked((int)0x80131001),
		MSEE_E_LOADLIBFAILED = unchecked((int)0x80131010),
		MSEE_E_GETPROCFAILED = unchecked((int)0x80131011),
		MSEE_E_MULTCOPIESLOADED = unchecked((int)0x80131012),
		COR_E_APPDOMAINUNLOADED = unchecked((int)0x80131014),
		COR_E_CANNOTUNLOADAPPDOMAIN = unchecked((int)0x80131015),
		MSEE_E_ASSEMBLYLOADINPROGRESS = unchecked((int)0x80131016),
		MSEE_E_CANNOTCREATEAPPDOMAIN = unchecked((int)0x80131017),
		COR_E_FIXUPSINEXE = unchecked((int)0x80131019),
		COR_E_NO_LOADLIBRARY_ALLOWED = unchecked((int)0x8013101A),
		COR_E_NEWER_RUNTIME = unchecked((int)0x8013101B),
		HOST_E_DEADLOCK = unchecked((int)0x80131020),
		HOST_E_INTERRUPTED = unchecked((int)0x80131021),
		HOST_E_INVALIDOPERATION = unchecked((int)0x80131022),
		HOST_E_CLRNOTAVAILABLE = unchecked((int)0x80131023),
		HOST_E_TIMEOUT = unchecked((int)0x80131024),
		HOST_E_NOT_OWNER = unchecked((int)0x80131025),
		HOST_E_ABANDONED = unchecked((int)0x80131026),
		HOST_E_EXITPROCESS_THREADABORT = unchecked((int)0x80131027),
		HOST_E_EXITPROCESS_ADUNLOAD = unchecked((int)0x80131028),
		HOST_E_EXITPROCESS_TIMEOUT = unchecked((int)0x80131029),
		HOST_E_EXITPROCESS_OUTOFMEMORY = unchecked((int)0x8013102a),
		HOST_E_EXITPROCESS_STACKOVERFLOW = unchecked((int)0x8013102b),
		COR_E_MODULE_HASH_CHECK_FAILED = unchecked((int)0x80131039),
		FUSION_E_REF_DEF_MISMATCH = unchecked((int)0x80131040),
		FUSION_E_INVALID_PRIVATE_ASM_LOCATION = unchecked((int)0x80131041),
		FUSION_E_ASM_MODULE_MISSING = unchecked((int)0x80131042),
		FUSION_E_UNEXPECTED_MODULE_FOUND = unchecked((int)0x80131043),
		FUSION_E_PRIVATE_ASM_DISALLOWED = unchecked((int)0x80131044),
		FUSION_E_SIGNATURE_CHECK_FAILED = unchecked((int)0x80131045),
		FUSION_E_DATABASE_ERROR = unchecked((int)0x80131046),
		FUSION_E_INVALID_NAME = unchecked((int)0x80131047),
		FUSION_E_CODE_DOWNLOAD_DISABLED = unchecked((int)0x80131048),
		FUSION_E_UNINSTALL_DISALLOWED = unchecked((int)0x80131049),
		FUSION_E_HOST_GAC_ASM_MISMATCH = unchecked((int)0x80131050),
		CLDB_E_FILE_BADREAD = unchecked((int)0x80131100),
		CLDB_E_FILE_BADWRITE = unchecked((int)0x80131101),
		CLDB_E_FILE_READONLY = unchecked((int)0x80131103),
		CLDB_E_NAME_ERROR = unchecked((int)0x80131105),
		CLDB_S_TRUNCATION = unchecked((int)0x00131106),
		CLDB_E_TRUNCATION = unchecked((int)0x80131106),
		CLDB_E_FILE_OLDVER = unchecked((int)0x80131107),
		CLDB_E_RELOCATED = unchecked((int)0x80131108),
		CLDB_S_NULL = unchecked((int)0x00131109),
		CLDB_E_SMDUPLICATE = unchecked((int)0x8013110A),
		CLDB_E_NO_DATA = unchecked((int)0x8013110B),
		CLDB_E_READONLY = unchecked((int)0x8013110C),
		CLDB_E_INCOMPATIBLE = unchecked((int)0x8013110D),
		CLDB_E_FILE_CORRUPT = unchecked((int)0x8013110E),
		CLDB_E_SCHEMA_VERNOTFOUND = unchecked((int)0x8013110F),
		CLDB_E_BADUPDATEMODE = unchecked((int)0x80131110),
		CLDB_E_INDEX_NONULLKEYS = unchecked((int)0x80131121),
		CLDB_E_INDEX_DUPLICATE = unchecked((int)0x80131122),
		CLDB_E_INDEX_BADTYPE = unchecked((int)0x80131123),
		CLDB_E_INDEX_NOTFOUND = unchecked((int)0x80131124),
		CLDB_S_INDEX_TABLESCANREQUIRED = unchecked((int)0x00131125),
		CLDB_E_RECORD_NOTFOUND = unchecked((int)0x80131130),
		CLDB_E_RECORD_OVERFLOW = unchecked((int)0x80131131),
		CLDB_E_RECORD_DUPLICATE = unchecked((int)0x80131132),
		CLDB_E_RECORD_PKREQUIRED = unchecked((int)0x80131133),
		CLDB_E_RECORD_DELETED = unchecked((int)0x80131134),
		CLDB_E_RECORD_OUTOFORDER = unchecked((int)0x80131135),
		CLDB_E_COLUMN_OVERFLOW = unchecked((int)0x80131140),
		CLDB_E_COLUMN_READONLY = unchecked((int)0x80131141),
		CLDB_E_COLUMN_SPECIALCOL = unchecked((int)0x80131142),
		CLDB_E_COLUMN_PKNONULLS = unchecked((int)0x80131143),
		CLDB_E_TABLE_CANTDROP = unchecked((int)0x80131150),
		CLDB_E_OBJECT_NOTFOUND = unchecked((int)0x80131151),
		CLDB_E_OBJECT_COLNOTFOUND = unchecked((int)0x80131152),
		CLDB_E_VECTOR_BADINDEX = unchecked((int)0x80131153),
		CLDB_E_TOO_BIG = unchecked((int)0x80131154),
		META_E_INVALID_TOKEN_TYPE = unchecked((int)0x8013115f),
		TLBX_E_INVALID_TYPEINFO = unchecked((int)0x80131160),
		TLBX_E_INVALID_TYPEINFO_UNNAMED = unchecked((int)0x80131161),
		TLBX_E_CTX_NESTED = unchecked((int)0x80131162),
		TLBX_E_ERROR_MESSAGE = unchecked((int)0x80131163),
		TLBX_E_CANT_SAVE = unchecked((int)0x80131164),
		TLBX_W_LIBNOTREGISTERED = unchecked((int)0x80131165),
		TLBX_E_CANTLOADLIBRARY = unchecked((int)0x80131166),
		TLBX_E_BAD_VT_TYPE = unchecked((int)0x80131167),
		TLBX_E_NO_MSCOREE_TLB = unchecked((int)0x80131168),
		TLBX_E_BAD_MSCOREE_TLB = unchecked((int)0x80131169),
		TLBX_E_TLB_EXCEPTION = unchecked((int)0x8013116a),
		TLBX_E_MULTIPLE_LCIDS = unchecked((int)0x8013116b),
		TLBX_I_TYPEINFO_IMPORTED = unchecked((int)0x0013116c),
		TLBX_E_AMBIGUOUS_RETURN = unchecked((int)0x8013116d),
		TLBX_E_DUPLICATE_TYPE_NAME = unchecked((int)0x8013116e),
		TLBX_I_USEIUNKNOWN = unchecked((int)0x0013116f),
		TLBX_I_UNCONVERTABLE_ARGS = unchecked((int)0x00131170),
		TLBX_I_UNCONVERTABLE_FIELD = unchecked((int)0x00131171),
		TLBX_I_NONSEQUENTIALSTRUCT = unchecked((int)0x80131172),
		TLBX_W_WARNING_MESSAGE = unchecked((int)0x00131173),
		TLBX_I_RESOLVEREFFAILED = unchecked((int)0x80131174),
		TLBX_E_ASANY = unchecked((int)0x80131175),
		TLBX_E_INVALIDLCIDPARAM = unchecked((int)0x80131176),
		TLBX_E_LCIDONDISPONLYITF = unchecked((int)0x80131177),
		TLBX_E_NONPUBLIC_FIELD = unchecked((int)0x80131178),
		TLBX_I_TYPE_EXPORTED = unchecked((int)0x00131179),
		TLBX_I_DUPLICATE_DISPID = unchecked((int)0x0013117A),
		TLBX_E_BAD_NAMES = unchecked((int)0x8013117B),
		TLBX_I_REF_TYPE_AS_STRUCT = unchecked((int)0x0013117C),
		TLBX_E_GENERICINST_SIGNATURE = unchecked((int)0x8013117D),
		TLBX_E_GENERICPAR_SIGNATURE = unchecked((int)0x8013117E),
		TLBX_I_GENERIC_TYPE = unchecked((int)0x0013117F),
		META_E_DUPLICATE = unchecked((int)0x80131180),
		META_E_GUID_REQUIRED = unchecked((int)0x80131181),
		META_E_TYPEDEF_MISMATCH = unchecked((int)0x80131182),
		META_E_MERGE_COLLISION = unchecked((int)0x80131183),
		TLBX_W_NON_INTEGRAL_CA_TYPE = unchecked((int)0x00131184),
		TLBX_W_IENUM_CA_ON_IUNK = unchecked((int)0x00131185),
		TLBX_E_NO_SAFEHANDLE_ARRAYS = unchecked((int)0x80131186),
		META_E_METHD_NOT_FOUND = unchecked((int)0x80131187),
		META_E_FIELD_NOT_FOUND = unchecked((int)0x80131188),
		META_S_PARAM_MISMATCH = unchecked((int)0x00131189),
		META_E_PARAM_MISMATCH = unchecked((int)0x80131189),
		META_E_BADMETADATA = unchecked((int)0x8013118A),
		META_E_INTFCEIMPL_NOT_FOUND = unchecked((int)0x8013118B),
		TLBX_E_NO_CRITICALHANDLE_ARRAYS = unchecked((int)0x8013118C),
		META_E_CLASS_LAYOUT_INCONSISTENT = unchecked((int)0x8013118D),
		META_E_FIELD_MARSHAL_NOT_FOUND = unchecked((int)0x8013118E),
		META_E_METHODSEM_NOT_FOUND = unchecked((int)0x8013118F),
		META_E_EVENT_NOT_FOUND = unchecked((int)0x80131190),
		META_E_PROP_NOT_FOUND = unchecked((int)0x80131191),
		META_E_BAD_SIGNATURE = unchecked((int)0x80131192),
		META_E_BAD_INPUT_PARAMETER = unchecked((int)0x80131193),
		META_E_METHDIMPL_INCONSISTENT = unchecked((int)0x80131194),
		META_E_MD_INCONSISTENCY = unchecked((int)0x80131195),
		META_E_CANNOTRESOLVETYPEREF = unchecked((int)0x80131196),
		META_S_DUPLICATE = unchecked((int)0x00131197),
		META_E_STRINGSPACE_FULL = unchecked((int)0x80131198),
        META_E_UNEXPECTED_REMAP = unchecked((int)0x80131199), 
		META_E_HAS_UNMARKALL = unchecked((int)0x8013119A),
		META_E_MUST_CALL_UNMARKALL = unchecked((int)0x8013119B),
		META_E_GENERICPARAM_INCONSISTENT = unchecked((int)0x8013119C),
		META_E_EVENT_COUNTS = unchecked((int)0x8013119D),
		META_E_PROPERTY_COUNTS = unchecked((int)0x8013119E),
		META_E_TYPEDEF_MISSING = unchecked((int)0x8013119F),
		TLBX_E_CANT_LOAD_MODULE = unchecked((int)0x801311A0),
		TLBX_E_CANT_LOAD_CLASS = unchecked((int)0x801311A1),
		TLBX_E_NULL_MODULE = unchecked((int)0x801311A2),
		TLBX_E_NO_CLSID_KEY = unchecked((int)0x801311A3),
		TLBX_E_CIRCULAR_EXPORT = unchecked((int)0x801311A4),
		TLBX_E_CIRCULAR_IMPORT = unchecked((int)0x801311A5),
		TLBX_E_BAD_NATIVETYPE = unchecked((int)0x801311A6),
		TLBX_E_BAD_VTABLE = unchecked((int)0x801311A7),
		TLBX_E_CRM_NON_STATIC = unchecked((int)0x801311A8),
		TLBX_E_CRM_INVALID_SIG = unchecked((int)0x801311A9),
		TLBX_E_CLASS_LOAD_EXCEPTION = unchecked((int)0x801311AA),
		TLBX_E_UNKNOWN_SIGNATURE = unchecked((int)0x801311AB),
		TLBX_E_REFERENCED_TYPELIB = unchecked((int)0x801311AC),
		TLBX_S_REFERENCED_TYPELIB = unchecked((int)0x001311AC),
		TLBX_E_INVALID_NAMESPACE = unchecked((int)0x801311AD),
		TLBX_E_LAYOUT_ERROR = unchecked((int)0x801311AE),
		TLBX_E_NOTIUNKNOWN = unchecked((int)0x801311AF),
		TLBX_E_NONVISIBLEVALUECLASS = unchecked((int)0x801311B0),
		TLBX_E_LPTSTR_NOT_ALLOWED = unchecked((int)0x801311B1),
		TLBX_E_AUTO_CS_NOT_ALLOWED = unchecked((int)0x801311B2),
		TLBX_S_NOSTDINTERFACE = unchecked((int)0x001311B3),
		TLBX_S_DUPLICATE_DISPID = unchecked((int)0x001311B4),
		TLBX_E_ENUM_VALUE_INVALID = unchecked((int)0x801311B5),
		TLBX_E_DUPLICATE_IID = unchecked((int)0x801311B6),
		TLBX_E_NO_NESTED_ARRAYS = unchecked((int)0x801311B7),
		TLBX_E_PARAM_ERROR_NAMED = unchecked((int)0x801311B8),
		TLBX_E_PARAM_ERROR_UNNAMED = unchecked((int)0x801311B9),
		TLBX_E_AGNOST_SIGNATURE = unchecked((int)0x801311BA),
		TLBX_E_CONVERT_FAIL = unchecked((int)0x801311BB),
		TLBX_W_DUAL_NOT_DISPATCH = unchecked((int)0x801311BC),
		TLBX_E_BAD_SIGNATURE = unchecked((int)0x801311BD),
		TLBX_E_ARRAY_NEEDS_NT_FIXED = unchecked((int)0x801311BE),
		TLBX_E_CLASS_NEEDS_NT_INTF = unchecked((int)0x801311BF),
		META_E_CA_INVALID_TARGET = unchecked((int)0x801311C0),
		META_E_CA_INVALID_VALUE = unchecked((int)0x801311C1),
		META_E_CA_INVALID_BLOB = unchecked((int)0x801311C2),
		META_E_CA_REPEATED_ARG = unchecked((int)0x801311C3),
		META_E_CA_UNKNOWN_ARGUMENT = unchecked((int)0x801311C4),
		META_E_CA_VARIANT_NYI = unchecked((int)0x801311C5),
		META_E_CA_ARRAY_NYI = unchecked((int)0x801311C6),
		META_E_CA_UNEXPECTED_TYPE = unchecked((int)0x801311C7),
		META_E_CA_INVALID_ARGTYPE = unchecked((int)0x801311C8),
		META_E_CA_INVALID_ARG_FOR_TYPE = unchecked((int)0x801311C9),
		META_E_CA_INVALID_UUID = unchecked((int)0x801311CA),
		META_E_CA_INVALID_MARSHALAS_FIELDS = unchecked((int)0x801311CB),
		META_E_CA_NT_FIELDONLY = unchecked((int)0x801311CC),
		META_E_CA_NEGATIVE_PARAMINDEX = unchecked((int)0x801311CD),
		META_E_CA_NEGATIVE_MULTIPLIER = unchecked((int)0x801311CE),
		META_E_CA_NEGATIVE_CONSTSIZE = unchecked((int)0x801311CF),
		META_E_CA_FIXEDSTR_SIZE_REQUIRED = unchecked((int)0x801311D0),
		META_E_CA_CUSTMARSH_TYPE_REQUIRED = unchecked((int)0x801311D1),
		META_E_CA_FILENAME_REQUIRED = unchecked((int)0x801311D2),
		TLBX_W_NO_PROPS_IN_EVENTS = unchecked((int)0x801311D3),
		META_E_NOT_IN_ENC_MODE = unchecked((int)0x801311D4),
		TLBX_W_ENUM_VALUE_TOOBIG = unchecked((int)0x001311D5),
		META_E_METHOD_COUNTS = unchecked((int)0x801311D6),
		META_E_FIELD_COUNTS = unchecked((int)0x801311D7),
		META_E_PARAM_COUNTS = unchecked((int)0x801311D8),
		TLBX_W_EXPORTING_AUTO_LAYOUT = unchecked((int)0x001311D9),
		TLBX_E_TYPED_REF = unchecked((int)0x801311DA),
		TLBX_W_DEFAULT_INTF_NOT_VISIBLE = unchecked((int)0x001311DB),
		TLBX_W_BAD_SAFEARRAYFIELD_NO_ELEMENTVT = unchecked((int)0x001311DE),
		TLBX_W_LAYOUTCLASS_AS_INTERFACE = unchecked((int)0x001311DF),
		TLBX_I_GENERIC_BASE_TYPE = unchecked((int)0x001311E0),
		TLBX_E_BITNESS_MISMATCH = unchecked((int)0x801311E1),
		VLDTR_S_WRN = unchecked((int)0x00131200),
		VLDTR_S_ERR = unchecked((int)0x00131201),
		VLDTR_S_WRNERR = unchecked((int)0x00131202),
		VLDTR_E_RID_OUTOFRANGE = unchecked((int)0x80131203),
		VLDTR_E_CDTKN_OUTOFRANGE = unchecked((int)0x80131204),
		VLDTR_E_CDRID_OUTOFRANGE = unchecked((int)0x80131205),
		VLDTR_E_STRING_INVALID = unchecked((int)0x80131206),
		VLDTR_E_GUID_INVALID = unchecked((int)0x80131207),
		VLDTR_E_BLOB_INVALID = unchecked((int)0x80131208),
		VLDTR_E_MOD_MULTI = unchecked((int)0x80131209),
		VLDTR_E_MOD_NULLMVID = unchecked((int)0x8013120A),
		VLDTR_E_TR_NAMENULL = unchecked((int)0x8013120B),
		VLDTR_E_TR_DUP = unchecked((int)0x8013120C),
		VLDTR_E_TD_NAMENULL = unchecked((int)0x8013120D),
		VLDTR_E_TD_DUPNAME = unchecked((int)0x8013120E),
		VLDTR_E_TD_DUPGUID = unchecked((int)0x8013120F),
		VLDTR_E_TD_NOTIFACEOBJEXTNULL = unchecked((int)0x80131210),
		VLDTR_E_TD_OBJEXTENDSNONNULL = unchecked((int)0x80131211),
		VLDTR_E_TD_EXTENDSSEALED = unchecked((int)0x80131212),
		VLDTR_E_TD_DLTNORTSPCL = unchecked((int)0x80131213),
		VLDTR_E_TD_RTSPCLNOTDLT = unchecked((int)0x80131214),
		VLDTR_E_MI_DECLPRIV = unchecked((int)0x80131215),
		VLDTR_E_AS_BADNAME = unchecked((int)0x80131216),
		VLDTR_E_FILE_SYSNAME = unchecked((int)0x80131217),
		VLDTR_E_MI_BODYSTATIC = unchecked((int)0x80131218),
		VLDTR_E_TD_IFACENOTABS = unchecked((int)0x80131219),
		VLDTR_E_TD_IFACEPARNOTNIL = unchecked((int)0x8013121A),
		VLDTR_E_TD_IFACEGUIDNULL = unchecked((int)0x8013121B),
		VLDTR_E_MI_DECLFINAL = unchecked((int)0x8013121C),
		VLDTR_E_TD_VTNOTSEAL = unchecked((int)0x8013121D),
		VLDTR_E_PD_BADFLAGS = unchecked((int)0x8013121E),
		VLDTR_E_IFACE_DUP = unchecked((int)0x8013121F),
		VLDTR_E_MR_NAMENULL = unchecked((int)0x80131220),
		VLDTR_E_MR_VTBLNAME = unchecked((int)0x80131221),
		VLDTR_E_MR_DELNAME = unchecked((int)0x80131222),
		VLDTR_E_MR_PARNIL = unchecked((int)0x80131223),
		VLDTR_E_MR_BADCALLINGCONV = unchecked((int)0x80131224),
		VLDTR_E_MR_NOTVARARG = unchecked((int)0x80131225),
		VLDTR_E_MR_NAMEDIFF = unchecked((int)0x80131226),
		VLDTR_E_MR_SIGDIFF = unchecked((int)0x80131227),
		VLDTR_E_MR_DUP = unchecked((int)0x80131228),
		VLDTR_E_CL_TDAUTO = unchecked((int)0x80131229),
		VLDTR_E_CL_BADPCKSZ = unchecked((int)0x8013122A),
		VLDTR_E_CL_DUP = unchecked((int)0x8013122B),
		VLDTR_E_FL_BADOFFSET = unchecked((int)0x8013122C),
		VLDTR_E_FL_TDNIL = unchecked((int)0x8013122D),
		VLDTR_E_FL_NOCL = unchecked((int)0x8013122E),
		VLDTR_E_FL_TDNOTEXPLCT = unchecked((int)0x8013122F),
		VLDTR_E_FL_FLDSTATIC = unchecked((int)0x80131230),
		VLDTR_E_FL_DUP = unchecked((int)0x80131231),
		VLDTR_E_MODREF_NAMENULL = unchecked((int)0x80131232),
		VLDTR_E_MODREF_DUP = unchecked((int)0x80131233),
		VLDTR_E_TR_BADSCOPE = unchecked((int)0x80131234),
		VLDTR_E_TD_NESTEDNOENCL = unchecked((int)0x80131235),
		VLDTR_E_TD_EXTTRRES = unchecked((int)0x80131236),
		VLDTR_E_SIGNULL = unchecked((int)0x80131237),
		VLDTR_E_SIGNODATA = unchecked((int)0x80131238),
		VLDTR_E_MD_BADCALLINGCONV = unchecked((int)0x80131239),
		VLDTR_E_MD_THISSTATIC = unchecked((int)0x8013123A),
		VLDTR_E_MD_NOTTHISNOTSTATIC = unchecked((int)0x8013123B),
		VLDTR_E_MD_NOARGCNT = unchecked((int)0x8013123C),
		VLDTR_E_SIG_MISSELTYPE = unchecked((int)0x8013123D),
		VLDTR_E_SIG_MISSTKN = unchecked((int)0x8013123E),
		VLDTR_E_SIG_TKNBAD = unchecked((int)0x8013123F),
		VLDTR_E_SIG_MISSFPTR = unchecked((int)0x80131240),
		VLDTR_E_SIG_MISSFPTRARGCNT = unchecked((int)0x80131241),
		VLDTR_E_SIG_MISSRANK = unchecked((int)0x80131242),
		VLDTR_E_SIG_MISSNSIZE = unchecked((int)0x80131243),
		VLDTR_E_SIG_MISSSIZE = unchecked((int)0x80131244),
		VLDTR_E_SIG_MISSNLBND = unchecked((int)0x80131245),
		VLDTR_E_SIG_MISSLBND = unchecked((int)0x80131246),
		VLDTR_E_SIG_BADELTYPE = unchecked((int)0x80131247),
		VLDTR_E_SIG_MISSVASIZE = unchecked((int)0x80131248),
		VLDTR_E_FD_BADCALLINGCONV = unchecked((int)0x80131249),
		VLDTR_E_MD_NAMENULL = unchecked((int)0x8013124A),
		VLDTR_E_MD_PARNIL = unchecked((int)0x8013124B),
		VLDTR_E_MD_DUP = unchecked((int)0x8013124C),
		VLDTR_E_FD_NAMENULL = unchecked((int)0x8013124D),
		VLDTR_E_FD_PARNIL = unchecked((int)0x8013124E),
		VLDTR_E_FD_DUP = unchecked((int)0x8013124F),
		VLDTR_E_AS_MULTI = unchecked((int)0x80131250),
		VLDTR_E_AS_NAMENULL = unchecked((int)0x80131251),
		VLDTR_E_SIG_TOKTYPEMISMATCH = unchecked((int)0x80131252),
		VLDTR_E_CL_TDINTF = unchecked((int)0x80131253),
		VLDTR_E_ASOS_OSPLTFRMIDINVAL = unchecked((int)0x80131254),
		VLDTR_E_AR_NAMENULL = unchecked((int)0x80131255),
		VLDTR_E_TD_ENCLNOTNESTED = unchecked((int)0x80131256),
		VLDTR_E_AROS_OSPLTFRMIDINVAL = unchecked((int)0x80131257),
		VLDTR_E_FILE_NAMENULL = unchecked((int)0x80131258),
		VLDTR_E_CT_NAMENULL = unchecked((int)0x80131259),
		VLDTR_E_TD_EXTENDSCHILD = unchecked((int)0x8013125A),
		VLDTR_E_MAR_NAMENULL = unchecked((int)0x8013125B),
		VLDTR_E_FILE_DUP = unchecked((int)0x8013125C),
		VLDTR_E_FILE_NAMEFULLQLFD = unchecked((int)0x8013125D),
		VLDTR_E_CT_DUP = unchecked((int)0x8013125E),
		VLDTR_E_MAR_DUP = unchecked((int)0x8013125F),
		VLDTR_E_MAR_NOTPUBPRIV = unchecked((int)0x80131260),
		VLDTR_E_TD_ENUMNOVALUE = unchecked((int)0x80131261),
		VLDTR_E_TD_ENUMVALSTATIC = unchecked((int)0x80131262),
		VLDTR_E_TD_ENUMVALNOTSN = unchecked((int)0x80131263),
		VLDTR_E_TD_ENUMFLDNOTST = unchecked((int)0x80131264),
		VLDTR_E_TD_ENUMFLDNOTLIT = unchecked((int)0x80131265),
		VLDTR_E_TD_ENUMNOLITFLDS = unchecked((int)0x80131266),
		VLDTR_E_TD_ENUMFLDSIGMISMATCH = unchecked((int)0x80131267),
		VLDTR_E_TD_ENUMVALNOT1ST = unchecked((int)0x80131268),
		VLDTR_E_FD_NOTVALUERTSN = unchecked((int)0x80131269),
		VLDTR_E_FD_VALUEPARNOTENUM = unchecked((int)0x8013126A),
		VLDTR_E_FD_INSTINIFACE = unchecked((int)0x8013126B),
		VLDTR_E_FD_NOTPUBINIFACE = unchecked((int)0x8013126C),
		VLDTR_E_FMD_GLOBALNOTPUBPRIVSC = unchecked((int)0x8013126D),
		VLDTR_E_FMD_GLOBALNOTSTATIC = unchecked((int)0x8013126E),
		VLDTR_E_FD_GLOBALNORVA = unchecked((int)0x8013126F),
		VLDTR_E_MD_CTORZERORVA = unchecked((int)0x80131270),
		VLDTR_E_FD_MARKEDNOMARSHAL = unchecked((int)0x80131271),
		VLDTR_E_FD_MARSHALNOTMARKED = unchecked((int)0x80131272),
		VLDTR_E_FD_MARKEDNODEFLT = unchecked((int)0x80131273),
		VLDTR_E_FD_DEFLTNOTMARKED = unchecked((int)0x80131274),
		VLDTR_E_FMD_MARKEDNOSECUR = unchecked((int)0x80131275),
		VLDTR_E_FMD_SECURNOTMARKED = unchecked((int)0x80131276),
		VLDTR_E_FMD_PINVOKENOTSTATIC = unchecked((int)0x80131277),
		VLDTR_E_FMD_MARKEDNOPINVOKE = unchecked((int)0x80131278),
		VLDTR_E_FMD_PINVOKENOTMARKED = unchecked((int)0x80131279),
		VLDTR_E_FMD_BADIMPLMAP = unchecked((int)0x8013127A),
		VLDTR_E_IMAP_BADMODREF = unchecked((int)0x8013127B),
		VLDTR_E_IMAP_BADMEMBER = unchecked((int)0x8013127C),
		VLDTR_E_IMAP_BADIMPORTNAME = unchecked((int)0x8013127D),
		VLDTR_E_IMAP_BADCALLCONV = unchecked((int)0x8013127E),
		VLDTR_E_FMD_BADACCESSFLAG = unchecked((int)0x8013127F),
		VLDTR_E_FD_INITONLYANDLITERAL = unchecked((int)0x80131280),
		VLDTR_E_FD_LITERALNOTSTATIC = unchecked((int)0x80131281),
		VLDTR_E_FMD_RTSNNOTSN = unchecked((int)0x80131282),
		VLDTR_E_MD_ABSTPARNOTABST = unchecked((int)0x80131283),
		VLDTR_E_MD_NOTSTATABSTININTF = unchecked((int)0x80131284),
		VLDTR_E_MD_NOTPUBININTF = unchecked((int)0x80131285),
		VLDTR_E_MD_CTORININTF = unchecked((int)0x80131286),
		VLDTR_E_MD_GLOBALCTORCCTOR = unchecked((int)0x80131287),
		VLDTR_E_MD_CTORSTATIC = unchecked((int)0x80131288),
		VLDTR_E_MD_CTORNOTSNRTSN = unchecked((int)0x80131289),
		VLDTR_E_MD_CTORVIRT = unchecked((int)0x8013128A),
		VLDTR_E_MD_CTORABST = unchecked((int)0x8013128B),
		VLDTR_E_MD_CCTORNOTSTATIC = unchecked((int)0x8013128C),
		VLDTR_E_MD_ZERORVA = unchecked((int)0x8013128D),
		VLDTR_E_MD_FINNOTVIRT = unchecked((int)0x8013128E),
		VLDTR_E_MD_STATANDFINORVIRT = unchecked((int)0x8013128F),
		VLDTR_E_MD_ABSTANDFINAL = unchecked((int)0x80131290),
		VLDTR_E_MD_ABSTANDIMPL = unchecked((int)0x80131291),
		VLDTR_E_MD_ABSTANDPINVOKE = unchecked((int)0x80131292),
		VLDTR_E_MD_ABSTNOTVIRT = unchecked((int)0x80131293),
		VLDTR_E_MD_NOTABSTNOTIMPL = unchecked((int)0x80131294),
		VLDTR_E_MD_NOTABSTBADFLAGSRVA = unchecked((int)0x80131295),
		VLDTR_E_MD_PRIVSCOPENORVA = unchecked((int)0x80131296),
		VLDTR_E_MD_GLOBALABSTORVIRT = unchecked((int)0x80131297),
		VLDTR_E_SIG_LONGFORM = unchecked((int)0x80131298),
		VLDTR_E_MD_MULTIPLESEMANTICS = unchecked((int)0x80131299),
		VLDTR_E_MD_INVALIDSEMANTICS = unchecked((int)0x8013129A),
		VLDTR_E_MD_SEMANTICSNOTEXIST = unchecked((int)0x8013129B),
		VLDTR_E_MI_DECLNOTVIRT = unchecked((int)0x8013129C),
		VLDTR_E_FMD_GLOBALITEM = unchecked((int)0x8013129D),
		VLDTR_E_MD_MULTSEMANTICFLAGS = unchecked((int)0x8013129E),
		VLDTR_E_MD_NOSEMANTICFLAGS = unchecked((int)0x8013129F),
		VLDTR_E_FD_FLDINIFACE = unchecked((int)0x801312A0),
		VLDTR_E_AS_HASHALGID = unchecked((int)0x801312A1),
		VLDTR_E_AS_PROCID = unchecked((int)0x801312A2),
		VLDTR_E_AR_PROCID = unchecked((int)0x801312A3),
		VLDTR_E_CN_PARENTRANGE = unchecked((int)0x801312A4),
		VLDTR_E_AS_BADFLAGS = unchecked((int)0x801312A5),
		VLDTR_E_TR_HASTYPEDEF = unchecked((int)0x801312A6),
		VLDTR_E_IFACE_BADIMPL = unchecked((int)0x801312A7),
		VLDTR_E_IFACE_BADIFACE = unchecked((int)0x801312A8),
		VLDTR_E_TD_SECURNOTMARKED = unchecked((int)0x801312A9),
		VLDTR_E_TD_MARKEDNOSECUR = unchecked((int)0x801312AA),
		VLDTR_E_MD_CCTORHASARGS = unchecked((int)0x801312AB),
		VLDTR_E_CT_BADIMPL = unchecked((int)0x801312AC),
		VLDTR_E_MI_ALIENBODY = unchecked((int)0x801312AD),
		VLDTR_E_MD_CCTORCALLCONV = unchecked((int)0x801312AE),
		VLDTR_E_MI_BADCLASS = unchecked((int)0x801312AF),
		VLDTR_E_MI_CLASSISINTF = unchecked((int)0x801312B0),
		VLDTR_E_MI_BADDECL = unchecked((int)0x801312B1),
		VLDTR_E_MI_BADBODY = unchecked((int)0x801312B2),
		VLDTR_E_MI_DUP = unchecked((int)0x801312B3),
		VLDTR_E_FD_BADPARENT = unchecked((int)0x801312B4),
		VLDTR_E_MD_PARAMOUTOFSEQ = unchecked((int)0x801312B5),
		VLDTR_E_MD_PARASEQTOOBIG = unchecked((int)0x801312B6),
		VLDTR_E_MD_PARMMARKEDNOMARSHAL = unchecked((int)0x801312B7),
		VLDTR_E_MD_PARMMARSHALNOTMARKED = unchecked((int)0x801312B8),
		VLDTR_E_MD_PARMMARKEDNODEFLT = unchecked((int)0x801312BA),
		VLDTR_E_MD_PARMDEFLTNOTMARKED = unchecked((int)0x801312BB),
		VLDTR_E_PR_BADSCOPE = unchecked((int)0x801312BC),
		VLDTR_E_PR_NONAME = unchecked((int)0x801312BD),
		VLDTR_E_PR_NOSIG = unchecked((int)0x801312BE),
		VLDTR_E_PR_DUP = unchecked((int)0x801312BF),
		VLDTR_E_PR_BADCALLINGCONV = unchecked((int)0x801312C0),
		VLDTR_E_PR_MARKEDNODEFLT = unchecked((int)0x801312C1),
		VLDTR_E_PR_DEFLTNOTMARKED = unchecked((int)0x801312C2),
		VLDTR_E_PR_BADSEMANTICS = unchecked((int)0x801312C3),
		VLDTR_E_PR_BADMETHOD = unchecked((int)0x801312C4),
		VLDTR_E_PR_ALIENMETHOD = unchecked((int)0x801312C5),
		VLDTR_E_CN_BLOBNOTNULL = unchecked((int)0x801312C6),
		VLDTR_E_CN_BLOBNULL = unchecked((int)0x801312C7),
		VLDTR_E_EV_BADSCOPE = unchecked((int)0x801312C8),
		VLDTR_E_EV_NONAME = unchecked((int)0x801312CA),
		VLDTR_E_EV_DUP = unchecked((int)0x801312CB),
		VLDTR_E_EV_BADEVTYPE = unchecked((int)0x801312CC),
		VLDTR_E_EV_EVTYPENOTCLASS = unchecked((int)0x801312CD),
		VLDTR_E_EV_BADSEMANTICS = unchecked((int)0x801312CE),
		VLDTR_E_EV_BADMETHOD = unchecked((int)0x801312CF),
		VLDTR_E_EV_ALIENMETHOD = unchecked((int)0x801312D0),
		VLDTR_E_EV_NOADDON = unchecked((int)0x801312D1),
		VLDTR_E_EV_NOREMOVEON = unchecked((int)0x801312D2),
		VLDTR_E_CT_DUPTDNAME = unchecked((int)0x801312D3),
		VLDTR_E_MAR_BADOFFSET = unchecked((int)0x801312D4),
		VLDTR_E_DS_BADOWNER = unchecked((int)0x801312D5),
		VLDTR_E_DS_BADFLAGS = unchecked((int)0x801312D6),
		VLDTR_E_DS_NOBLOB = unchecked((int)0x801312D7),
		VLDTR_E_MAR_BADIMPL = unchecked((int)0x801312D8),
		VLDTR_E_MR_VARARGCALLINGCONV = unchecked((int)0x801312DA),
		VLDTR_E_MD_CTORNOTVOID = unchecked((int)0x801312DB),
		VLDTR_E_EV_FIRENOTVOID = unchecked((int)0x801312DC),
		VLDTR_E_AS_BADLOCALE = unchecked((int)0x801312DD),
		VLDTR_E_CN_PARENTTYPE = unchecked((int)0x801312DE),
		VLDTR_E_SIG_SENTINMETHODDEF = unchecked((int)0x801312DF),
		VLDTR_E_SIG_SENTMUSTVARARG = unchecked((int)0x801312E0),
		VLDTR_E_SIG_MULTSENTINELS = unchecked((int)0x801312E1),
		VLDTR_E_SIG_LASTSENTINEL = unchecked((int)0x801312E2),
		VLDTR_E_SIG_MISSARG = unchecked((int)0x801312E3),
		VLDTR_E_SIG_BYREFINFIELD = unchecked((int)0x801312E4),
		VLDTR_E_MD_SYNCMETHODINVTYPE = unchecked((int)0x801312E5),
		VLDTR_E_TD_NAMETOOLONG = unchecked((int)0x801312E6),
		VLDTR_E_AS_PROCDUP = unchecked((int)0x801312E7),
		VLDTR_E_ASOS_DUP = unchecked((int)0x801312E8),
		VLDTR_E_MAR_BADFLAGS = unchecked((int)0x801312E9),
		VLDTR_E_CT_NOTYPEDEFID = unchecked((int)0x801312EA),
		VLDTR_E_FILE_BADFLAGS = unchecked((int)0x801312EB),
		VLDTR_E_FILE_NULLHASH = unchecked((int)0x801312EC),
		VLDTR_E_MOD_NONAME = unchecked((int)0x801312ED),
		VLDTR_E_MOD_NAMEFULLQLFD = unchecked((int)0x801312EE),
		VLDTR_E_TD_RTSPCLNOTSPCL = unchecked((int)0x801312EF),
		VLDTR_E_TD_EXTENDSIFACE = unchecked((int)0x801312F0),
		VLDTR_E_MD_CTORPINVOKE = unchecked((int)0x801312F1),
		VLDTR_E_TD_SYSENUMNOTCLASS = unchecked((int)0x801312F2),
		VLDTR_E_TD_SYSENUMNOTEXTVTYPE = unchecked((int)0x801312F3),
		VLDTR_E_MI_SIGMISMATCH = unchecked((int)0x801312F4),
		VLDTR_E_TD_ENUMHASMETHODS = unchecked((int)0x801312F5),
		VLDTR_E_TD_ENUMIMPLIFACE = unchecked((int)0x801312F6),
		VLDTR_E_TD_ENUMHASPROP = unchecked((int)0x801312F7),
		VLDTR_E_TD_ENUMHASEVENT = unchecked((int)0x801312F8),
		VLDTR_E_TD_BADMETHODLST = unchecked((int)0x801312F9),
		VLDTR_E_TD_BADFIELDLST = unchecked((int)0x801312FA),
		VLDTR_E_CN_BADTYPE = unchecked((int)0x801312FB),
		VLDTR_E_TD_ENUMNOINSTFLD = unchecked((int)0x801312FC),
		VLDTR_E_TD_ENUMMULINSTFLD = unchecked((int)0x801312FD),
		VLDTR_E_INTERRUPTED = unchecked((int)0x801312FE),
		VLDTR_E_NOTINIT = unchecked((int)0x801312FF),
		VLDTR_E_IFACE_NOTIFACE = unchecked((int)0x80131B00),
		VLDTR_E_FD_RVAHASNORVA = unchecked((int)0x80131B01),
		VLDTR_E_FD_RVAHASZERORVA = unchecked((int)0x80131B02),
		VLDTR_E_MD_RVAANDIMPLMAP = unchecked((int)0x80131B03),
		VLDTR_E_TD_EXTRAFLAGS = unchecked((int)0x80131B04),
		VLDTR_E_TD_EXTENDSITSELF = unchecked((int)0x80131B05),
		VLDTR_E_TD_SYSVTNOTEXTOBJ = unchecked((int)0x80131B06),
		VLDTR_E_TD_EXTTYPESPEC = unchecked((int)0x80131B07),
		VLDTR_E_TD_VTNOSIZE = unchecked((int)0x80131B09),
		VLDTR_E_TD_IFACESEALED = unchecked((int)0x80131B0A),
		VLDTR_E_NC_BADNESTED = unchecked((int)0x80131B0B),
		VLDTR_E_NC_BADENCLOSER = unchecked((int)0x80131B0C),
		VLDTR_E_NC_DUP = unchecked((int)0x80131B0D),
		VLDTR_E_NC_DUPENCLOSER = unchecked((int)0x80131B0E),
		VLDTR_E_FRVA_ZERORVA = unchecked((int)0x80131B0F),
		VLDTR_E_FRVA_BADFIELD = unchecked((int)0x80131B10),
		VLDTR_E_FRVA_DUPRVA = unchecked((int)0x80131B11),
		VLDTR_E_FRVA_DUPFIELD = unchecked((int)0x80131B12),
		VLDTR_E_EP_BADTOKEN = unchecked((int)0x80131B13),
		VLDTR_E_EP_INSTANCE = unchecked((int)0x80131B14),
		VLDTR_E_TD_ENUMFLDBADTYPE = unchecked((int)0x80131B15),
		VLDTR_E_MD_BADRVA = unchecked((int)0x80131B16),
		VLDTR_E_FD_LITERALNODEFAULT = unchecked((int)0x80131B17),
		VLDTR_E_IFACE_METHNOTIMPL = unchecked((int)0x80131B18),
		VLDTR_E_CA_BADPARENT = unchecked((int)0x80131B19),
		VLDTR_E_CA_BADTYPE = unchecked((int)0x80131B1A),
		VLDTR_E_CA_NOTCTOR = unchecked((int)0x80131B1B),
		VLDTR_E_CA_BADSIG = unchecked((int)0x80131B1C),
		VLDTR_E_CA_NOSIG = unchecked((int)0x80131B1D),
		VLDTR_E_CA_BADPROLOG = unchecked((int)0x80131B1E),
		VLDTR_E_MD_BADLOCALSIGTOK = unchecked((int)0x80131B1F),
		VLDTR_E_MD_BADHEADER = unchecked((int)0x80131B20),
		VLDTR_E_EP_TOOMANYARGS = unchecked((int)0x80131B21),
		VLDTR_E_EP_BADRET = unchecked((int)0x80131B22),
		VLDTR_E_EP_BADARG = unchecked((int)0x80131B23),
		VLDTR_E_SIG_BADVOID = unchecked((int)0x80131B24),
		VLDTR_E_IFACE_METHMULTIMPL = unchecked((int)0x80131B25),
		VLDTR_E_GP_NAMENULL = unchecked((int)0x80131B26),
		VLDTR_E_GP_OWNERNIL = unchecked((int)0x80131B27),
		VLDTR_E_GP_DUPNAME = unchecked((int)0x80131B28),
		VLDTR_E_GP_DUPNUMBER = unchecked((int)0x80131B29),
		VLDTR_E_GP_NONSEQ_BY_OWNER = unchecked((int)0x80131B2A),
		VLDTR_E_GP_NONSEQ_BY_NUMBER = unchecked((int)0x80131B2B),
		VLDTR_E_GP_UNEXPECTED_OWNER_FOR_VARIANT_VAR = unchecked((int)0x80131B2C),
		VLDTR_E_GP_ILLEGAL_VARIANT_MVAR = unchecked((int)0x80131B2D),
		VLDTR_E_GP_ILLEGAL_VARIANCE_FLAGS = unchecked((int)0x80131B2E),
		VLDTR_E_GP_REFANDVALUETYPE = unchecked((int)0x80131B2F),
		VLDTR_E_GPC_OWNERNIL = unchecked((int)0x80131B30),
		VLDTR_E_GPC_DUP = unchecked((int)0x80131B31),
		VLDTR_E_GPC_NONCONTIGUOUS = unchecked((int)0x80131B32),
		VLDTR_E_MS_METHODNIL = unchecked((int)0x80131B33),
		VLDTR_E_MS_DUP = unchecked((int)0x80131B34),
		VLDTR_E_MS_BADCALLINGCONV = unchecked((int)0x80131B35),
		VLDTR_E_MS_MISSARITY = unchecked((int)0x80131B36),
		VLDTR_E_MS_MISSARG = unchecked((int)0x80131B37),
		VLDTR_E_MS_ARITYMISMATCH = unchecked((int)0x80131B38),
		VLDTR_E_MS_METHODNOTGENERIC = unchecked((int)0x80131B39),
		VLDTR_E_SIG_MISSARITY = unchecked((int)0x80131B3A),
		VLDTR_E_SIG_ARITYMISMATCH = unchecked((int)0x80131B3B),
		VLDTR_E_MD_GENERIC_CCTOR = unchecked((int)0x80131B3C),
		VLDTR_E_MD_GENERIC_CTOR = unchecked((int)0x80131B3D),
		VLDTR_E_MD_GENERIC_IMPORT = unchecked((int)0x80131B3E),
		VLDTR_E_MD_GENERIC_BADCALLCONV = unchecked((int)0x80131B3F),
		VLDTR_E_MD_GENERIC_GLOBAL = unchecked((int)0x80131B40),
		VLDTR_E_EP_GENERIC_METHOD = unchecked((int)0x80131B41),
		VLDTR_E_MD_MISSARITY = unchecked((int)0x80131B42),
		VLDTR_E_MD_ARITYZERO = unchecked((int)0x80131B43),
		VLDTR_E_SIG_ARITYZERO = unchecked((int)0x80131B44),
		VLDTR_E_MS_ARITYZERO = unchecked((int)0x80131B45),
		VLDTR_E_MD_GPMISMATCH = unchecked((int)0x80131B46),
		VLDTR_E_EP_GENERIC_TYPE = unchecked((int)0x80131B47),
		VLDTR_E_MI_DECLNOTGENERIC = unchecked((int)0x80131B48),
		VLDTR_E_MI_IMPLNOTGENERIC = unchecked((int)0x80131B49),
		VLDTR_E_MI_ARITYMISMATCH = unchecked((int)0x80131B4A),
		VLDTR_E_TD_EXTBADTYPESPEC = unchecked((int)0x80131B4B),
		VLDTR_E_SIG_BYREFINST = unchecked((int)0x80131B4C),
		VLDTR_E_MS_BYREFINST = unchecked((int)0x80131B4D),
		VLDTR_E_TS_EMPTY = unchecked((int)0x80131B4E),
		VLDTR_E_TS_HASSENTINALS = unchecked((int)0x80131B4F),
		VLDTR_E_TD_GENERICHASEXPLAYOUT = unchecked((int)0x80131B50),
		VLDTR_E_SIG_BADTOKTYPE = unchecked((int)0x80131B51),
		VLDTR_E_IFACE_METHNOTIMPLTHISMOD = unchecked((int)0x80131B52),
		CORDBG_E_UNRECOVERABLE_ERROR = unchecked((int)0x80131300),
		CORDBG_E_PROCESS_TERMINATED = unchecked((int)0x80131301),
		CORDBG_E_PROCESS_NOT_SYNCHRONIZED = unchecked((int)0x80131302),
		CORDBG_E_CLASS_NOT_LOADED = unchecked((int)0x80131303),
		CORDBG_E_IL_VAR_NOT_AVAILABLE = unchecked((int)0x80131304),
		CORDBG_E_BAD_REFERENCE_VALUE = unchecked((int)0x80131305),
		CORDBG_E_FIELD_NOT_AVAILABLE = unchecked((int)0x80131306),
		CORDBG_E_NON_NATIVE_FRAME = unchecked((int)0x80131307),
		CORDBG_E_NONCONTINUABLE_EXCEPTION = unchecked((int)0x80131308),
		CORDBG_E_CODE_NOT_AVAILABLE = unchecked((int)0x80131309),
		CORDBG_E_FUNCTION_NOT_IL = unchecked((int)0x8013130A),
		CORDBG_S_BAD_START_SEQUENCE_POINT = unchecked((int)0x0013130B),
		CORDBG_S_BAD_END_SEQUENCE_POINT = unchecked((int)0x0013130C),
		CORDBG_S_INSUFFICIENT_INFO_FOR_SET_IP = unchecked((int)0x0013130D),
		CORDBG_E_CANT_SET_IP_INTO_FINALLY = unchecked((int)0x8013130E),
		CORDBG_E_CANT_SET_IP_OUT_OF_FINALLY = unchecked((int)0x8013130F),
		CORDBG_E_CANT_SET_IP_INTO_CATCH = unchecked((int)0x80131310),
		CORDBG_E_SET_IP_NOT_ALLOWED_ON_NONLEAF_FRAME = unchecked((int)0x80131311),
		CORDBG_E_SET_IP_IMPOSSIBLE = unchecked((int)0x80131312),
		CORDBG_E_FUNC_EVAL_BAD_START_POINT = unchecked((int)0x80131313),
		CORDBG_E_INVALID_OBJECT = unchecked((int)0x80131314),
		CORDBG_E_FUNC_EVAL_NOT_COMPLETE = unchecked((int)0x80131315),
		CORDBG_S_FUNC_EVAL_HAS_NO_RESULT = unchecked((int)0x00131316),
		CORDBG_S_VALUE_POINTS_TO_VOID = unchecked((int)0x00131317),
		CORDBG_E_INPROC_NOT_IMPL = unchecked((int)0x80131318),
		CORDBG_S_FUNC_EVAL_ABORTED = unchecked((int)0x00131319),
		CORDBG_E_STATIC_VAR_NOT_AVAILABLE = unchecked((int)0x8013131A),
		CORDBG_E_OBJECT_IS_NOT_COPYABLE_VALUE_CLASS = unchecked((int)0x8013131B),
		CORDBG_E_CANT_SETIP_INTO_OR_OUT_OF_FILTER = unchecked((int)0x8013131C),
		CORDBG_E_CANT_CHANGE_JIT_SETTING_FOR_ZAP_MODULE = unchecked((int)0x8013131D),
		CORDBG_E_CANT_SET_IP_OUT_OF_FINALLY_ON_WIN64 = unchecked((int)0x8013131E),
		CORDBG_E_CANT_SET_IP_OUT_OF_CATCH_ON_WIN64 = unchecked((int)0x8013131F),
		CORDBG_E_REMOTE_CONNECTION_CONN_RESET = unchecked((int)0x80131320),
		CORDBG_E_REMOTE_CONNECTION_KEEP_ALIVE = unchecked((int)0x80131321),
		CORDBG_E_REMOTE_CONNECTION_FATAL_ERROR = unchecked((int)0x80131322),
		CORDBG_E_CANT_SET_TO_JMC = unchecked((int)0x80131323),          
        CORDBG_S_AT_END_OF_STACK = unchecked((int)0x131324),
        CORDBG_E_FAIL_TO_UNWIND_FRAME = unchecked((int)0x80131325),
        CORDBG_E_NOT_CHILD_FRAME = unchecked((int)0x80131326),
        CORDBG_E_NON_MATCHING_CONTEXT = unchecked((int)0x80131327),
        CORDBG_E_PAST_END_OF_STACK = unchecked((int)0x80131328),           
		CORDBG_E_BAD_THREAD_STATE = unchecked((int)0x8013132d),
		CORDBG_E_DEBUGGER_ALREADY_ATTACHED = unchecked((int)0x8013132e),
		CORDBG_E_SUPERFLOUS_CONTINUE = unchecked((int)0x8013132f),
		CORDBG_E_SET_VALUE_NOT_ALLOWED_ON_NONLEAF_FRAME = unchecked((int)0x80131330),
		CORDBG_E_ENC_EH_MAX_NESTING_LEVEL_CANT_INCREASE = unchecked((int)0x80131331),
		CORDBG_E_ENC_MODULE_NOT_ENC_ENABLED = unchecked((int)0x80131332),
		CORDBG_E_SET_IP_NOT_ALLOWED_ON_EXCEPTION = unchecked((int)0x80131333),
		CORDBG_E_VARIABLE_IS_ACTUALLY_LITERAL = unchecked((int)0x80131334),
		CORDBG_E_PROCESS_DETACHED = unchecked((int)0x80131335),
		CORDBG_E_ENC_METHOD_SIG_CHANGED = unchecked((int)0x80131336),
		CORDBG_E_ENC_METHOD_NO_LOCAL_SIG = unchecked((int)0x80131337),
		CORDBG_E_ENC_CANT_ADD_FIELD_TO_VALUE_OR_LAYOUT_CLASS = unchecked((int)0x80131338),
		CORDBG_E_ENC_CANT_CHANGE_FIELD = unchecked((int)0x80131339),
		CORDBG_E_ENC_CANT_ADD_NON_PRIVATE_MEMBER = unchecked((int)0x8013133A),
		CORDBG_E_FIELD_NOT_STATIC = unchecked((int)0x8013133B),
		CORDBG_E_FIELD_NOT_INSTANCE = unchecked((int)0x8013133C),
		CORDBG_E_ENC_ZAPPED_WITHOUT_ENC = unchecked((int)0x8013133D),
		CORDBG_E_ENC_BAD_METHOD_INFO = unchecked((int)0x8013133E),
		CORDBG_E_ENC_JIT_CANT_UPDATE = unchecked((int)0x8013133F),
		CORDBG_E_ENC_MISSING_CLASS = unchecked((int)0x80131340),
		CORDBG_E_ENC_INTERNAL_ERROR = unchecked((int)0x80131341),
		CORDBG_E_ENC_HANGING_FIELD = unchecked((int)0x80131342),
		CORDBG_E_MODULE_NOT_LOADED = unchecked((int)0x80131343),
		CORDBG_E_ENC_CANT_CHANGE_SUPERCLASS = unchecked((int)0x80131344),
		CORDBG_E_UNABLE_TO_SET_BREAKPOINT = unchecked((int)0x80131345),
		CORDBG_E_DEBUGGING_NOT_POSSIBLE = unchecked((int)0x80131346),
		CORDBG_E_KERNEL_DEBUGGER_ENABLED = unchecked((int)0x80131347),
		CORDBG_E_KERNEL_DEBUGGER_PRESENT = unchecked((int)0x80131348),
		CORDBG_E_HELPER_THREAD_DEAD = unchecked((int)0x80131349),
		CORDBG_E_INTERFACE_INHERITANCE_CANT_CHANGE = unchecked((int)0x8013134A),
		CORDBG_E_INCOMPATIBLE_PROTOCOL = unchecked((int)0x8013134B),
		CORDBG_E_TOO_MANY_PROCESSES = unchecked((int)0x8013134C),
		CORDBG_E_INTEROP_NOT_SUPPORTED = unchecked((int)0x8013134D),
		CORDBG_E_NO_REMAP_BREAKPIONT = unchecked((int)0x8013134E),
        CORDBG_E_OBJECT_NEUTERED = unchecked((int)0x8013134F),
        CORDBG_E_LIBRARY_PROVIDER_ERROR = unchecked((int)0x80131c43),
        CORDBG_E_NOT_CLR = unchecked((int)0x80131c44),
        CORDBG_E_MISSING_DATA_TARGET_INTERFACE = unchecked((int)0x80131c45),
        CORDBG_E_UNSUPPORTED_DEBUGGING_MODEL = unchecked((int)0x80131c46),
        CORDBG_E_UNSUPPORTED_FORWARD_COMPAT = unchecked((int)0x80131c47),
        CORDBG_E_UNSUPPORTED_VERSION_STRUCT = unchecked((int)0x80131c48),
        CORDBG_E_READVIRTUAL_FAILURE = unchecked((int)0x80131c49),
		CORPROF_E_FUNCTION_NOT_COMPILED = unchecked((int)0x80131350),
		CORPROF_E_DATAINCOMPLETE = unchecked((int)0x80131351),
		CORPROF_E_NOT_REJITABLE_METHODS = unchecked((int)0x80131352),
		CORPROF_E_CANNOT_UPDATE_METHOD = unchecked((int)0x80131353),
		CORPROF_E_FUNCTION_NOT_IL = unchecked((int)0x80131354),
		CORPROF_E_NOT_MANAGED_THREAD = unchecked((int)0x80131355),
		CORPROF_E_CALL_ONLY_FROM_INIT = unchecked((int)0x80131356),
		CORPROF_E_INPROC_NOT_ENABLED = unchecked((int)0x80131357),
		CORPROF_E_JITMAPS_NOT_ENABLED = unchecked((int)0x80131358),
		CORPROF_E_INPROC_ALREADY_BEGUN = unchecked((int)0x80131359),
		CORPROF_E_INPROC_NOT_AVAILABLE = unchecked((int)0x8013135A),
		CORPROF_E_NOT_YET_AVAILABLE = unchecked((int)0x8013135B),
		CORPROF_E_TYPE_IS_PARAMETERIZED = unchecked((int)0x8013135C),
		CORPROF_E_FUNCTION_IS_PARAMETERIZED = unchecked((int)0x8013135D),
		SECURITY_E_XML_TO_ASN_ENCODING = unchecked((int)0x80131400),
		SECURITY_E_INCOMPATIBLE_SHARE = unchecked((int)0x80131401),
		SECURITY_E_UNVERIFIABLE = unchecked((int)0x80131402),
		SECURITY_E_INCOMPATIBLE_EVIDENCE = unchecked((int)0x80131403),
		CLDB_E_INTERNALERROR = unchecked((int)0x80131fff),
		CORSEC_E_DECODE_SET = unchecked((int)0x80131410),
		CORSEC_E_ENCODE_SET = unchecked((int)0x80131411),
		CORSEC_E_UNSUPPORTED_FORMAT = unchecked((int)0x80131412),
		SN_CRYPTOAPI_CALL_FAILED = unchecked((int)0x80131413),
		CORSEC_E_CRYPTOAPI_CALL_FAILED = unchecked((int)0x80131413),
		SN_NO_SUITABLE_CSP = unchecked((int)0x80131414),
		CORSEC_E_NO_SUITABLE_CSP = unchecked((int)0x80131414),
		CORSEC_E_INVALID_ATTR = unchecked((int)0x80131415),
		CORSEC_E_POLICY_EXCEPTION = unchecked((int)0x80131416),
		CORSEC_E_MIN_GRANT_FAIL = unchecked((int)0x80131417),
		CORSEC_E_NO_EXEC_PERM = unchecked((int)0x80131418),
		CORSEC_E_XMLSYNTAX = unchecked((int)0x80131419),
		CORSEC_E_INVALID_STRONGNAME = unchecked((int)0x8013141a),
		CORSEC_E_MISSING_STRONGNAME = unchecked((int)0x8013141b),
		CORSEC_E_CONTAINER_NOT_FOUND = unchecked((int)0x8013141c),
		CORSEC_E_INVALID_IMAGE_FORMAT = unchecked((int)0x8013141d),
		CORSEC_E_INVALID_PUBLICKEY = unchecked((int)0x8013141e),
		CORSEC_E_SIGNATURE_MISMATCH = unchecked((int)0x80131420),
		CORSEC_E_CRYPTO = unchecked((int)0x80131430),
		CORSEC_E_CRYPTO_UNEX_OPER = unchecked((int)0x80131431),
		CORSECATTR_E_BAD_ATTRIBUTE = unchecked((int)0x8013143a),
		CORSECATTR_E_MISSING_CONSTRUCTOR = unchecked((int)0x8013143b),
		CORSECATTR_E_FAILED_TO_CREATE_PERM = unchecked((int)0x8013143c),
		CORSECATTR_E_BAD_ACTION_ASM = unchecked((int)0x8013143d),
		CORSECATTR_E_BAD_ACTION_OTHER = unchecked((int)0x8013143e),
		CORSECATTR_E_BAD_PARENT = unchecked((int)0x8013143f),
		CORSECATTR_E_TRUNCATED = unchecked((int)0x80131440),
		CORSECATTR_E_BAD_VERSION = unchecked((int)0x80131441),
		CORSECATTR_E_BAD_ACTION = unchecked((int)0x80131442),
		CORSECATTR_E_NO_SELF_REF = unchecked((int)0x80131443),
		CORSECATTR_E_BAD_NONCAS = unchecked((int)0x80131444),
		CORSECATTR_E_ASSEMBLY_LOAD_FAILED = unchecked((int)0x80131445),
		CORSECATTR_E_ASSEMBLY_LOAD_FAILED_EX = unchecked((int)0x80131446),
		CORSECATTR_E_TYPE_LOAD_FAILED = unchecked((int)0x80131447),
		CORSECATTR_E_TYPE_LOAD_FAILED_EX = unchecked((int)0x80131448),
		CORSECATTR_E_ABSTRACT = unchecked((int)0x80131449),
		CORSECATTR_E_UNSUPPORTED_TYPE = unchecked((int)0x8013144a),
		CORSECATTR_E_UNSUPPORTED_ENUM_TYPE = unchecked((int)0x8013144b),
		CORSECATTR_E_NO_FIELD = unchecked((int)0x8013144c),
		CORSECATTR_E_NO_PROPERTY = unchecked((int)0x8013144d),
		CORSECATTR_E_EXCEPTION = unchecked((int)0x8013144e),
		CORSECATTR_E_EXCEPTION_HR = unchecked((int)0x8013144f),
		ISS_E_ISOSTORE = unchecked((int)0x80131450),
		ISS_E_OPEN_STORE_FILE = unchecked((int)0x80131460),
		ISS_E_OPEN_FILE_MAPPING = unchecked((int)0x80131461),
		ISS_E_MAP_VIEW_OF_FILE = unchecked((int)0x80131462),
		ISS_E_GET_FILE_SIZE = unchecked((int)0x80131463),
		ISS_E_CREATE_MUTEX = unchecked((int)0x80131464),
		ISS_E_LOCK_FAILED = unchecked((int)0x80131465),
		ISS_E_FILE_WRITE = unchecked((int)0x80131466),
		ISS_E_SET_FILE_POINTER = unchecked((int)0x80131467),
		ISS_E_CREATE_DIR = unchecked((int)0x80131468),
		ISS_E_STORE_NOT_OPEN = unchecked((int)0x80131469),
		ISS_E_CORRUPTED_STORE_FILE = unchecked((int)0x80131480),
		ISS_E_STORE_VERSION = unchecked((int)0x80131481),
		ISS_E_FILE_NOT_MAPPED = unchecked((int)0x80131482),
		ISS_E_BLOCK_SIZE_TOO_SMALL = unchecked((int)0x80131483),
		ISS_E_ALLOC_TOO_LARGE = unchecked((int)0x80131484),
		ISS_E_USAGE_WILL_EXCEED_QUOTA = unchecked((int)0x80131485),
		ISS_E_TABLE_ROW_NOT_FOUND = unchecked((int)0x80131486),
		ISS_E_DEPRECATE = unchecked((int)0x801314A0),
		ISS_E_CALLER = unchecked((int)0x801314A1),
		ISS_E_PATH_LENGTH = unchecked((int)0x801314A2),
		ISS_E_MACHINE = unchecked((int)0x801314A3),
		ISS_E_MACHINE_DACL = unchecked((int)0x801314A4),
		ISS_E_ISOSTORE_START = unchecked((int)0x80131450),
		ISS_E_ISOSTORE_END = unchecked((int)0x801314FF),
		COR_E_APPLICATION = unchecked((int)0x80131600),
		COR_E_ARGUMENT = unchecked((int)0x80070057),
		COR_E_ARGUMENTOUTOFRANGE = unchecked((int)0x80131502),
		COR_E_ARITHMETIC = unchecked((int)0x80070216),
		COR_E_ARRAYTYPEMISMATCH = unchecked((int)0x80131503),
		COR_E_CONTEXTMARSHAL = unchecked((int)0x80131504),
		COR_E_TIMEOUT = unchecked((int)0x80131505),
		COR_E_KEYNOTFOUND = unchecked((int)0x80131577),
		COR_E_DEVICESNOTSUPPORTED = unchecked((int)0x80131540),
		COR_E_DIVIDEBYZERO = unchecked((int)0x80020012),
		COR_E_EXCEPTION = unchecked((int)0x80131500),
		COR_E_EXECUTIONENGINE = unchecked((int)0x80131506),
		COR_E_FIELDACCESS = unchecked((int)0x80131507),
		COR_E_FORMAT = unchecked((int)0x80131537),
		COR_E_BADIMAGEFORMAT = unchecked((int)0x8007000B),
		COR_E_ASSEMBLYEXPECTED = unchecked((int)0x80131018),
		COR_E_TYPEUNLOADED = unchecked((int)0x80131013),
		COR_E_INDEXOUTOFRANGE = unchecked((int)0x80131508),
		COR_E_INVALIDCAST = unchecked((int)0x80004002),
		COR_E_INVALIDOPERATION = unchecked((int)0x80131509),
		COR_E_INVALIDPROGRAM = unchecked((int)0x8013153A),
		COR_E_MEMBERACCESS = unchecked((int)0x8013151A),
		COR_E_METHODACCESS = unchecked((int)0x80131510),
		COR_E_MISSINGFIELD = unchecked((int)0x80131511),
		COR_E_MISSINGMANIFESTRESOURCE = unchecked((int)0x80131532),
		COR_E_MISSINGMEMBER = unchecked((int)0x80131512),
		COR_E_MISSINGMETHOD = unchecked((int)0x80131513),
		COR_E_MISSINGSATELLITEASSEMBLY = unchecked((int)0x80131536),
		COR_E_MULTICASTNOTSUPPORTED = unchecked((int)0x80131514),
		COR_E_NOTFINITENUMBER = unchecked((int)0x80131528),
		COR_E_DUPLICATEWAITOBJECT = unchecked((int)0x80131529),
		COR_E_PLATFORMNOTSUPPORTED = unchecked((int)0x80131539),
		COR_E_NOTSUPPORTED = unchecked((int)0x80131515),
		COR_E_NULLREFERENCE = unchecked((int)0x80004003),
		COR_E_OUTOFMEMORY = unchecked((int)0x8007000E),
		COR_E_OVERFLOW = unchecked((int)0x80131516),
		COR_E_RANK = unchecked((int)0x80131517),
		COR_E_REMOTING = unchecked((int)0x8013150B),
		COR_E_SERVER = unchecked((int)0x8013150E),
		COR_E_SERVICEDCOMPONENT = unchecked((int)0x8013150F),
		COR_E_SECURITY = unchecked((int)0x8013150A),
		COR_E_SERIALIZATION = unchecked((int)0x8013150C),
		COR_E_STACKOVERFLOW = unchecked((int)0x800703E9),
		COR_E_SYNCHRONIZATIONLOCK = unchecked((int)0x80131518),
		COR_E_SYSTEM = unchecked((int)0x80131501),
		COR_E_THREADABORTED = unchecked((int)0x80131530),
		COR_E_OPERATIONCANCELED = unchecked((int)0x8013153B),
		COR_E_NOTCANCELABLE = unchecked((int)0x8013153C),
		COR_E_THREADINTERRUPTED = unchecked((int)0x80131519),
		COR_E_THREADSTATE = unchecked((int)0x80131520),
		COR_E_THREADSTOP = unchecked((int)0x80131521),
		COR_E_TYPEINITIALIZATION = unchecked((int)0x80131534),
		COR_E_TYPELOAD = unchecked((int)0x80131522),
		COR_E_ENTRYPOINTNOTFOUND = unchecked((int)0x80131523),
		COR_E_DLLNOTFOUND = unchecked((int)0x80131524),
		COR_E_UNAUTHORIZEDACCESS = unchecked((int)0x80070005),
		COR_E_VERIFICATION = unchecked((int)0x8013150D),
		COR_E_INVALIDCOMOBJECT = unchecked((int)0x80131527),
		COR_E_COMOBJECTINUSE = unchecked((int)0x8013152A),
		COR_E_SEMAPHOREFULL = unchecked((int)0x8013152B),
		COR_E_WAITHANDLECANNOTBEOPENED = unchecked((int)0x8013152C),
		COR_E_ABANDONEDMUTEX = unchecked((int)0x8013152D),
		COR_E_MARSHALDIRECTIVE = unchecked((int)0x80131535),
		COR_E_INVALIDOLEVARIANTTYPE = unchecked((int)0x80131531),
		COR_E_SAFEARRAYTYPEMISMATCH = unchecked((int)0x80131533),
		COR_E_SAFEARRAYRANKMISMATCH = unchecked((int)0x80131538),
		COR_E_DATAMISALIGNED = unchecked((int)0x80131541),
		COR_E_TARGETPARAMCOUNT = unchecked((int)0x8002000E),
		COR_E_AMBIGUOUSMATCH = unchecked((int)0x8000211D),
		COR_E_INVALIDFILTERCRITERIA = unchecked((int)0x80131601),
		COR_E_REFLECTIONTYPELOAD = unchecked((int)0x80131602),
		COR_E_TARGET = unchecked((int)0x80131603),
		COR_E_TARGETINVOCATION = unchecked((int)0x80131604),
		COR_E_CUSTOMATTRIBUTEFORMAT = unchecked((int)0x80131605),
		COR_E_FILELOAD = unchecked((int)0x80131621),
		COR_E_IO = unchecked((int)0x80131620),
		COR_E_OBJECTDISPOSED = unchecked((int)0x80131622),
		COR_E_HOSTPROTECTION = unchecked((int)0x80131640),
		COR_E_FAILFAST = unchecked((int)0x80131623),
		CLR_E_SHIM_RUNTIMELOAD = unchecked((int)0x80131700),
		CLR_E_SHIM_RUNTIMEEXPORT = unchecked((int)0x80131701),
		CLR_E_SHIM_INSTALLROOT = unchecked((int)0x80131702),
		CLR_E_SHIM_INSTALLCOMP = unchecked((int)0x80131703),
		VER_E_HRESULT = unchecked((int)0x80131801),
		VER_E_OFFSET = unchecked((int)0x80131802),
		VER_E_OPCODE = unchecked((int)0x80131803),
		VER_E_OPERAND = unchecked((int)0x80131804),
		VER_E_TOKEN = unchecked((int)0x80131805),
		VER_E_EXCEPT = unchecked((int)0x80131806),
		VER_E_STACK_SLOT = unchecked((int)0x80131807),
		VER_E_LOC = unchecked((int)0x80131808),
		VER_E_ARG = unchecked((int)0x80131809),
		VER_E_FOUND = unchecked((int)0x8013180A),
		VER_E_EXPECTED = unchecked((int)0x8013180B),
		VER_E_LOC_BYNAME = unchecked((int)0x8013180C),
		VER_E_UNKNOWN_OPCODE = unchecked((int)0x80131810),
		VER_E_SIG_CALLCONV = unchecked((int)0x80131811),
		VER_E_SIG_ELEMTYPE = unchecked((int)0x80131812),
		VER_E_RET_SIG = unchecked((int)0x80131814),
		VER_E_FIELD_SIG = unchecked((int)0x80131815),
		VER_E_INTERNAL = unchecked((int)0x80131818),
		VER_E_STACK_TOO_LARGE = unchecked((int)0x80131819),
		VER_E_ARRAY_NAME_LONG = unchecked((int)0x8013181A),
		VER_E_FALLTHRU = unchecked((int)0x80131820),
		VER_E_TRY_GTEQ_END = unchecked((int)0x80131821),
		VER_E_TRYEND_GT_CS = unchecked((int)0x80131822),
		VER_E_HND_GTEQ_END = unchecked((int)0x80131823),
		VER_E_HNDEND_GT_CS = unchecked((int)0x80131824),
		VER_E_FLT_GTEQ_CS = unchecked((int)0x80131825),
		VER_E_TRY_START = unchecked((int)0x80131826),
		VER_E_HND_START = unchecked((int)0x80131827),
		VER_E_FLT_START = unchecked((int)0x80131828),
		VER_E_TRY_OVERLAP = unchecked((int)0x80131829),
		VER_E_TRY_EQ_HND_FIL = unchecked((int)0x8013182A),
		VER_E_TRY_SHARE_FIN_FAL = unchecked((int)0x8013182B),
		VER_E_HND_OVERLAP = unchecked((int)0x8013182C),
		VER_E_HND_EQ = unchecked((int)0x8013182D),
		VER_E_FIL_OVERLAP = unchecked((int)0x8013182E),
		VER_E_FIL_EQ = unchecked((int)0x8013182F),
		VER_E_FIL_CONT_TRY = unchecked((int)0x80131830),
		VER_E_FIL_CONT_HND = unchecked((int)0x80131831),
		VER_E_FIL_CONT_FIL = unchecked((int)0x80131832),
		VER_E_FIL_GTEQ_CS = unchecked((int)0x80131833),
		VER_E_FIL_START = unchecked((int)0x80131834),
		VER_E_FALLTHRU_EXCEP = unchecked((int)0x80131835),
		VER_E_FALLTHRU_INTO_HND = unchecked((int)0x80131836),
		VER_E_FALLTHRU_INTO_FIL = unchecked((int)0x80131837),
		VER_E_LEAVE = unchecked((int)0x80131838),
		VER_E_RETHROW = unchecked((int)0x80131839),
		VER_E_ENDFINALLY = unchecked((int)0x8013183A),
		VER_E_ENDFILTER = unchecked((int)0x8013183B),
		VER_E_ENDFILTER_MISSING = unchecked((int)0x8013183C),
		VER_E_BR_INTO_TRY = unchecked((int)0x8013183D),
		VER_E_BR_INTO_HND = unchecked((int)0x8013183E),
		VER_E_BR_INTO_FIL = unchecked((int)0x8013183F),
		VER_E_BR_OUTOF_TRY = unchecked((int)0x80131840),
		VER_E_BR_OUTOF_HND = unchecked((int)0x80131841),
		VER_E_BR_OUTOF_FIL = unchecked((int)0x80131842),
		VER_E_BR_OUTOF_FIN = unchecked((int)0x80131843),
		VER_E_RET_FROM_TRY = unchecked((int)0x80131844),
		VER_E_RET_FROM_HND = unchecked((int)0x80131845),
		VER_E_RET_FROM_FIL = unchecked((int)0x80131846),
		VER_E_BAD_JMP_TARGET = unchecked((int)0x80131847),
		VER_E_PATH_LOC = unchecked((int)0x80131848),
		VER_E_PATH_THIS = unchecked((int)0x80131849),
		VER_E_PATH_STACK = unchecked((int)0x8013184A),
		VER_E_PATH_STACK_DEPTH = unchecked((int)0x8013184B),
		VER_E_THIS = unchecked((int)0x8013184C),
		VER_E_THIS_UNINIT_EXCEP = unchecked((int)0x8013184D),
		VER_E_THIS_UNINIT_STORE = unchecked((int)0x8013184E),
		VER_E_THIS_UNINIT_RET = unchecked((int)0x8013184F),
		VER_E_THIS_UNINIT_V_RET = unchecked((int)0x80131850),
		VER_E_THIS_UNINIT_BR = unchecked((int)0x80131851),
		VER_E_LDFTN_CTOR = unchecked((int)0x80131852),
		VER_E_STACK_NOT_EQ = unchecked((int)0x80131853),
		VER_E_STACK_UNEXPECTED = unchecked((int)0x80131854),
		VER_E_STACK_EXCEPTION = unchecked((int)0x80131855),
		VER_E_STACK_OVERFLOW = unchecked((int)0x80131856),
		VER_E_STACK_UNDERFLOW = unchecked((int)0x80131857),
		VER_E_STACK_EMPTY = unchecked((int)0x80131858),
		VER_E_STACK_UNINIT = unchecked((int)0x80131859),
		VER_E_STACK_I_I4_I8 = unchecked((int)0x8013185A),
		VER_E_STACK_R_R4_R8 = unchecked((int)0x8013185B),
		VER_E_STACK_NO_R_I8 = unchecked((int)0x8013185C),
		VER_E_STACK_NUMERIC = unchecked((int)0x8013185D),
		VER_E_STACK_OBJREF = unchecked((int)0x8013185E),
		VER_E_STACK_P_OBJREF = unchecked((int)0x8013185F),
		VER_E_STACK_BYREF = unchecked((int)0x80131860),
		VER_E_STACK_METHOD = unchecked((int)0x80131861),
		VER_E_STACK_ARRAY_SD = unchecked((int)0x80131862),
		VER_E_STACK_VALCLASS = unchecked((int)0x80131863),
		VER_E_STACK_P_VALCLASS = unchecked((int)0x80131864),
		VER_E_STACK_NO_VALCLASS = unchecked((int)0x80131865),
		VER_E_LOC_DEAD = unchecked((int)0x80131866),
		VER_E_LOC_NUM = unchecked((int)0x80131867),
		VER_E_ARG_NUM = unchecked((int)0x80131868),
		VER_E_TOKEN_RESOLVE = unchecked((int)0x80131869),
		VER_E_TOKEN_TYPE = unchecked((int)0x8013186A),
		VER_E_TOKEN_TYPE_MEMBER = unchecked((int)0x8013186B),
		VER_E_TOKEN_TYPE_FIELD = unchecked((int)0x8013186C),
		VER_E_TOKEN_TYPE_SIG = unchecked((int)0x8013186D),
		VER_E_UNVERIFIABLE = unchecked((int)0x8013186E),
		VER_E_LDSTR_OPERAND = unchecked((int)0x8013186F),
		VER_E_RET_PTR_TO_STACK = unchecked((int)0x80131870),
		VER_E_RET_VOID = unchecked((int)0x80131871),
		VER_E_RET_MISSING = unchecked((int)0x80131872),
		VER_E_RET_EMPTY = unchecked((int)0x80131873),
		VER_E_RET_UNINIT = unchecked((int)0x80131874),
		VER_E_ARRAY_ACCESS = unchecked((int)0x80131875),
		VER_E_ARRAY_V_STORE = unchecked((int)0x80131876),
		VER_E_ARRAY_SD = unchecked((int)0x80131877),
		VER_E_ARRAY_SD_PTR = unchecked((int)0x80131878),
		VER_E_ARRAY_FIELD = unchecked((int)0x80131879),
		VER_E_ARGLIST = unchecked((int)0x8013187A),
		VER_E_VALCLASS = unchecked((int)0x8013187B),
		VER_E_METHOD_ACCESS = unchecked((int)0x8013187C),
		VER_E_FIELD_ACCESS = unchecked((int)0x8013187D),
		VER_E_DEAD = unchecked((int)0x8013187E),
		VER_E_FIELD_STATIC = unchecked((int)0x8013187F),
		VER_E_FIELD_NO_STATIC = unchecked((int)0x80131880),
		VER_E_ADDR = unchecked((int)0x80131881),
		VER_E_ADDR_BYREF = unchecked((int)0x80131882),
		VER_E_ADDR_LITERAL = unchecked((int)0x80131883),
		VER_E_INITONLY = unchecked((int)0x80131884),
		VER_E_THROW = unchecked((int)0x80131885),
		VER_E_CALLVIRT_VALCLASS = unchecked((int)0x80131886),
		VER_E_CALL_SIG = unchecked((int)0x80131887),
		VER_E_CALL_STATIC = unchecked((int)0x80131888),
		VER_E_CTOR = unchecked((int)0x80131889),
		VER_E_CTOR_VIRT = unchecked((int)0x8013188A),
		VER_E_CTOR_OR_SUPER = unchecked((int)0x8013188B),
		VER_E_CTOR_MUL_INIT = unchecked((int)0x8013188C),
		VER_E_SIG = unchecked((int)0x8013188D),
		VER_E_SIG_ARRAY = unchecked((int)0x8013188E),
		VER_E_SIG_ARRAY_PTR = unchecked((int)0x8013188F),
		VER_E_SIG_ARRAY_BYREF = unchecked((int)0x80131890),
		VER_E_SIG_ELEM_PTR = unchecked((int)0x80131891),
		VER_E_SIG_VARARG = unchecked((int)0x80131892),
		VER_E_SIG_VOID = unchecked((int)0x80131893),
		VER_E_SIG_BYREF_BYREF = unchecked((int)0x80131894),
		VER_E_CODE_SIZE_ZERO = unchecked((int)0x80131896),
		VER_E_BAD_VARARG = unchecked((int)0x80131897),
		VER_E_TAIL_CALL = unchecked((int)0x80131898),
		VER_E_TAIL_BYREF = unchecked((int)0x80131899),
		VER_E_TAIL_RET = unchecked((int)0x8013189A),
		VER_E_TAIL_RET_VOID = unchecked((int)0x8013189B),
		VER_E_TAIL_RET_TYPE = unchecked((int)0x8013189C),
		VER_E_TAIL_STACK_EMPTY = unchecked((int)0x8013189D),
		VER_E_METHOD_END = unchecked((int)0x8013189E),
		VER_E_BAD_BRANCH = unchecked((int)0x8013189F),
		VER_E_FIN_OVERLAP = unchecked((int)0x801318A0),
		VER_E_LEXICAL_NESTING = unchecked((int)0x801318A1),
		VER_E_VOLATILE = unchecked((int)0x801318A2),
		VER_E_UNALIGNED = unchecked((int)0x801318A3),
		VER_E_INNERMOST_FIRST = unchecked((int)0x801318A4),
		VER_E_CALLI_VIRTUAL = unchecked((int)0x801318A5),
		VER_E_CALL_ABSTRACT = unchecked((int)0x801318A6),
		VER_E_STACK_UNEXP_ARRAY = unchecked((int)0x801318A7),
		VER_E_NOT_IN_GC_HEAP = unchecked((int)0x801318A8),
		VER_E_TRY_N_EMPTY_STACK = unchecked((int)0x801318A9),
		VER_E_DLGT_CTOR = unchecked((int)0x801318AA),
		VER_E_DLGT_BB = unchecked((int)0x801318AB),
		VER_E_DLGT_PATTERN = unchecked((int)0x801318AC),
		VER_E_DLGT_LDFTN = unchecked((int)0x801318AD),
		VER_E_FTN_ABSTRACT = unchecked((int)0x801318AE),
		VER_E_SIG_C_VC = unchecked((int)0x801318AF),
		VER_E_SIG_VC_C = unchecked((int)0x801318B0),
		VER_E_BOX_PTR_TO_STACK = unchecked((int)0x801318B1),
		VER_E_SIG_BYREF_TB_AH = unchecked((int)0x801318B2),
		VER_E_SIG_ARRAY_TB_AH = unchecked((int)0x801318B3),
		VER_E_ENDFILTER_STACK = unchecked((int)0x801318B4),
		VER_E_DLGT_SIG_I = unchecked((int)0x801318B5),
		VER_E_DLGT_SIG_O = unchecked((int)0x801318B6),
		VER_E_RA_PTR_TO_STACK = unchecked((int)0x801318B7),
		VER_E_CATCH_VALUE_TYPE = unchecked((int)0x801318B8),
		VER_E_CATCH_BYREF = unchecked((int)0x801318B9),
		VER_E_FIL_PRECEED_HND = unchecked((int)0x801318BA),
		VER_E_LDVIRTFTN_STATIC = unchecked((int)0x801318BB),
		VER_E_CALLVIRT_STATIC = unchecked((int)0x801318BC),
		VER_E_INITLOCALS = unchecked((int)0x801318BD),
		VER_E_BR_TO_EXCEPTION = unchecked((int)0x801318BE),
		VER_E_CALL_CTOR = unchecked((int)0x801318BF),
		VER_E_VALCLASS_OBJREF_VAR = unchecked((int)0x801318C0),
		VER_E_STACK_P_VALCLASS_OBJREF_VAR = unchecked((int)0x801318C1),
		VER_E_SIG_VAR_PARAM = unchecked((int)0x801318C2),
		VER_E_SIG_MVAR_PARAM = unchecked((int)0x801318C3),
		VER_E_SIG_VAR_ARG = unchecked((int)0x801318C4),
		VER_E_SIG_MVAR_ARG = unchecked((int)0x801318C5),
		VER_E_SIG_GENERICINST = unchecked((int)0x801318C6),
		VER_E_SIG_METHOD_INST = unchecked((int)0x801318C7),
		VER_E_SIG_METHOD_PARENT_INST = unchecked((int)0x801318C8),
		VER_E_SIG_FIELD_PARENT_INST = unchecked((int)0x801318C9),
		VER_E_CALLCONV_NOT_GENERICINST = unchecked((int)0x801318CA),
		VER_E_TOKEN_BAD_METHOD_SPEC = unchecked((int)0x801318CB),
		VER_E_BAD_READONLY_PREFIX = unchecked((int)0x801318CC),
		VER_E_BAD_CONSTRAINED_PREFIX = unchecked((int)0x801318CD),
		VER_E_CIRCULAR_VAR_CONSTRAINTS = unchecked((int)0x801318CE),
		VER_E_CIRCULAR_MVAR_CONSTRAINTS = unchecked((int)0x801318CF),
		VER_E_UNSATISFIED_METHOD_INST = unchecked((int)0x801318D0),
		VER_E_UNSATISFIED_METHOD_PARENT_INST = unchecked((int)0x801318D1),
		VER_E_UNSATISFIED_FIELD_PARENT_INST = unchecked((int)0x801318D2),
		VER_E_UNSATISFIED_BOX_OPERAND = unchecked((int)0x801318D3),
		VER_E_CONSTRAINED_CALL_WITH_NON_BYREF_THIS = unchecked((int)0x801318D4),
		VER_E_CONSTRAINED_OF_NON_VARIABLE_TYPE = unchecked((int)0x801318D5),
		VER_E_READONLY_UNEXPECTED_CALLEE = unchecked((int)0x801318D6),
		VER_E_READONLY_ILLEGAL_WRITE = unchecked((int)0x801318D7),
		VER_E_READONLY_IN_MKREFANY = unchecked((int)0x801318D8),
		VER_E_UNALIGNED_ALIGNMENT = unchecked((int)0x801318D9),
		VER_E_TAILCALL_INSIDE_EH = unchecked((int)0x801318DA),
		VER_E_BACKWARD_BRANCH = unchecked((int)0x801318DB),
		VER_E_CALL_TO_VTYPE_BASE = unchecked((int)0x801318DC),
		VER_E_NEWOBJ_OF_ABSTRACT_CLASS = unchecked((int)0x801318DD),
		VER_E_FIELD_OVERLAP = unchecked((int)0x801318E0),
		VER_E_BAD_PE = unchecked((int)0x801318F0),
		VER_E_BAD_MD = unchecked((int)0x801318F1),
		VER_E_BAD_APPDOMAIN = unchecked((int)0x801318F2),
		VER_E_TYPELOAD = unchecked((int)0x801318F3),
		VER_E_PE_LOAD = unchecked((int)0x801318F4),
		VER_E_WRITE_RVA_STATIC = unchecked((int)0x801318F5),
		CORDBG_E_THREAD_NOT_SCHEDULED = unchecked((int)0x80131C00),
		CORDBG_E_HANDLE_HAS_BEEN_DISPOSED = unchecked((int)0x80131C01),
		CORDBG_E_NONINTERCEPTABLE_EXCEPTION = unchecked((int)0x80131C02),
		CORDBG_E_CANT_UNWIND_ABOVE_CALLBACK = unchecked((int)0x80131C03),
		CORDBG_E_INTERCEPT_FRAME_ALREADY_SET = unchecked((int)0x80131C04),
		CORDBG_E_NO_NATIVE_PATCH_AT_ADDR = unchecked((int)0x80131C05),
		CORDBG_E_MUST_BE_INTEROP_DEBUGGING = unchecked((int)0x80131C06),
		CORDBG_E_NATIVE_PATCH_ALREADY_AT_ADDR = unchecked((int)0x80131C07),
		CORDBG_E_TIMEOUT = unchecked((int)0x80131C08),
		CORDBG_E_CANT_CALL_ON_THIS_THREAD = unchecked((int)0x80131C09),
		CORDBG_E_ENC_INFOLESS_METHOD = unchecked((int)0x80131C0A),
		CORDBG_E_ENC_NESTED_HANLDERS = unchecked((int)0x80131C0B),
		CORDBG_E_ENC_IN_FUNCLET = unchecked((int)0x80131C0C),
		CORDBG_E_ENC_LOCALLOC = unchecked((int)0x80131C0D),
		CORDBG_E_ENC_EDIT_NOT_SUPPORTED = unchecked((int)0x80131C0E),
		CORDBG_E_FEABORT_DELAYED_UNTIL_THREAD_RESUMED = unchecked((int)0x80131C0F),
		CORDBG_E_NOTREADY = unchecked((int)0x80131C10),
		CORDBG_E_CANNOT_RESOLVE_ASSEMBLY = unchecked((int)0x80131c11),
		CORDBG_E_MUST_BE_IN_LOAD_MODULE = unchecked((int)0x80131C12),
		CORDBG_E_CANNOT_BE_ON_ATTACH = unchecked((int)0x80131C13),
		CORDBG_S_NOT_ALL_BITS_SET = unchecked((int)0x00131C13),
		CORDBG_E_NGEN_NOT_SUPPORTED = unchecked((int)0x80131C14),
		CORDBG_E_ILLEGAL_SHUTDOWN_ORDER = unchecked((int)0x80131C15),
		CORDBG_E_CANNOT_DEBUG_FIBER_PROCESS = unchecked((int)0x80131C16),
		CORDBG_E_MUST_BE_IN_CREATE_PROCESS = unchecked((int)0x80131C17),
		CORDBG_E_DETACH_FAILED_OUTSTANDING_EVALS = unchecked((int)0x80131C18),
		CORDBG_E_DETACH_FAILED_OUTSTANDING_STEPPERS = unchecked((int)0x80131C19),
		CORDBG_E_CANT_INTEROP_STEP_OUT = unchecked((int)0x80131C20),
		CORDBG_E_DETACH_FAILED_OUTSTANDING_BREAKPOINTS = unchecked((int)0x80131C21),
		CORDBG_E_ILLEGAL_IN_STACK_OVERFLOW = unchecked((int)0x80131c22),
		CORDBG_E_ILLEGAL_AT_GC_UNSAFE_POINT = unchecked((int)0x80131c23),
		CORDBG_E_ILLEGAL_IN_PROLOG = unchecked((int)0x80131c24),
		CORDBG_E_ILLEGAL_IN_NATIVE_CODE = unchecked((int)0x80131c25),
		CORDBG_E_ILLEGAL_IN_OPTIMIZED_CODE = unchecked((int)0x80131c26),
        CORDBG_E_MISSING_METADATA = unchecked((int)0x80131C35),
        CORDBG_E_MODULE_LOADED_FROM_DISK = unchecked((int)0x80131c3a),
        CORDBG_E_SYMBOLS_NOT_AVAILABLE = unchecked((int)0x80131c3b),
        CORDBG_E_VALUE_POINTS_TO_FUNCTION = unchecked((int)0x80131c4a),
		PEFMT_E_NO_CONTENTS = unchecked((int)0x80131D00),
		PEFMT_E_NO_NTHEADERS = unchecked((int)0x80131D01),
		PEFMT_E_64BIT = unchecked((int)0x80131D02),
		PEFMT_E_NO_CORHEADER = unchecked((int)0x80131D03),
		PEFMT_E_NOT_ILONLY = unchecked((int)0x80131D04),
		PEFMT_E_IMPORT_DLLS = unchecked((int)0x80131D05),
		PEFMT_E_EXE_NOENTRYPOINT = unchecked((int)0x80131D06),
		PEFMT_E_BASE_RELOCS = unchecked((int)0x80131D07),
		PEFMT_E_ENTRYPOINT = unchecked((int)0x80131D08),
		PEFMT_E_ZERO_SIZEOFCODE = unchecked((int)0x80131D09),
		PEFMT_E_BAD_CORHEADER = unchecked((int)0x80131D0A),
	}
}
