<?php
/**
 * @var \App\View\AppView $this
 * @var array $body
 */
    use Cake\Core\Configure;
    use Passbolt\MultiFactorAuthentication\Utility\MfaSettings;

    $title = __('Yubikey One Time Password is enabled!');
    $this->assign('title', $title);
    $this->assign('pageClass', 'iframe mfa');
    $this->Html->script('app/mfa-settings.js?v=' . Configure::read('passbolt.version'), ['block' => 'js', 'fullBase' => true]);
?>
<div class="grid grid-responsive-12">
    <div class="row">
        <div class="col7 main-column">
            <h3><?= $title; ?></h3>
            <div class="feedback-card">
                <?= $this->element('successMark'); ?>
                <div class="additional-information">
                    <p>
                        <?= __('When logging in from a new device you will need a unique code generated by your yubikey.'); ?>
                    </p>
                    <p class="created date">
                        <?= __('Since')?>: <?= $body['verified']->nice(); ?>
                    </p>
                    <?= $this->element('turnOffProviderButton', ['provider' => MfaSettings::PROVIDER_YUBIKEY]); ?>
                </div>
            </div>
            <?= $this->element('manageProvidersButton'); ?>
        </div>
    </div>
</div>
