<?php
/**
 * @var \App\View\AppView $this
 */
    use Cake\Routing\Router;

    $title = __('Getting started with Time based One Time Password (TOTP)');
    $this->assign('title', $title);
    $this->assign('pageClass', 'iframe mfa');
?>
<div class="grid grid-responsive-12">
    <div class="row">
        <div class="col7 main-column how-it-works">
            <h3><?= $title; ?></h3>
            <h4 class="no-border"><?= __('How does it work?'); ?></h4>
            <div class="instruction">
                <div class="step">
                    <!-- SVG Passbolt login -->
                    <svg width="177" height="243" viewBox="0 0 177 243" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_280_142230)">
                            <path d="M52.4666 22.9608V27.3321H53.7262C54.562 27.3321 55.1406 27.1546 55.4883 26.8178C55.836 26.481 56.0027 25.8921 56.0027 25.0937C56.0027 24.3223 55.8478 23.7759 55.5264 23.4597C55.2049 23.1177 54.6656 22.966 53.881 22.966L52.4666 22.9608ZM50.4092 21.2997H54.3691C55.5657 21.2997 56.4908 21.643 57.1599 22.3398C57.8291 23.0367 58.1624 23.9996 58.1624 25.2287C58.1704 25.7019 58.1008 26.1733 57.9564 26.6249C57.8198 27.0449 57.6064 27.437 57.3266 27.782C57.0091 28.1785 56.593 28.4884 56.1181 28.682C55.6418 28.8594 55.0252 28.9481 54.2405 28.9481H52.4666V31.729H50.4092V21.2997Z" fill="var(--icon-color)"/>
                            <path d="M62.3024 27.4208H64.8741V25.8368H62.4572C61.9809 25.8368 61.6476 25.8998 61.4665 26.0271C61.2855 26.1544 61.2041 26.382 61.2041 26.6982C61.2041 26.9644 61.2802 27.1546 61.4219 27.2678C61.5636 27.3809 61.8523 27.4208 62.3024 27.4208ZM59.5771 21.2997H63.7758C64.8439 21.2997 65.6403 21.5414 66.1809 22.0223C66.7215 22.5031 66.9905 23.2141 66.9905 24.1642V28.9661H61.4665C60.695 28.9661 60.0915 28.7759 59.6795 28.3966C59.2675 28.0173 59.0693 27.4709 59.0693 26.7612C59.0693 25.887 59.3003 25.266 59.7766 24.8867C60.2529 24.5075 61.0375 24.3108 62.162 24.3108H64.861V24.1256C64.861 23.6692 64.7206 23.3542 64.4503 23.1627C64.18 22.9711 63.7037 22.8837 62.9978 22.8837H59.5771V21.2997Z" fill="var(--icon-color)"/>
                            <path d="M68.6672 27.3693H72.9971C73.3829 27.3693 73.6663 27.3063 73.8329 27.1919C73.9255 27.1295 73.9996 27.0442 74.0475 26.9445C74.0955 26.8449 74.1156 26.7346 74.1058 26.6249C74.1162 26.5149 74.0967 26.4041 74.0492 26.3038C74.0017 26.2036 73.928 26.1174 73.8355 26.0541C73.6558 25.9255 73.3737 25.8638 72.9997 25.8638H71.2258C70.1761 25.8638 69.4649 25.6992 69.091 25.383C68.717 25.0667 68.5386 24.4959 68.5386 23.6975C68.5386 22.8747 68.7577 22.2652 69.2077 21.8731C69.6578 21.481 70.3532 21.2881 71.2717 21.2881H75.6817V22.8837H72.0589C71.4667 22.8837 71.081 22.9346 70.9017 23.0366C70.7219 23.1369 70.6314 23.3143 70.6314 23.5805C70.6229 23.6784 70.6397 23.7769 70.6803 23.8668C70.7209 23.9566 70.7839 24.035 70.8636 24.0947C71.0171 24.2079 71.2743 24.2593 71.6089 24.2593H73.476C74.3249 24.2593 74.9797 24.4612 75.4179 24.8546C75.8562 25.248 76.0858 25.8047 76.0858 26.5401C76.0858 27.2498 75.8798 27.8257 75.4822 28.2757C75.2945 28.4927 75.0594 28.6656 74.7944 28.7818C74.5294 28.8979 74.2412 28.9543 73.951 28.9468H68.6672V27.3693Z" fill="var(--icon-color)"/>
                            <path d="M77.4388 27.3693H81.7688C82.1545 27.3693 82.4379 27.3063 82.6046 27.1919C82.6967 27.1292 82.7703 27.0437 82.8177 26.9441C82.8652 26.8445 82.8849 26.7344 82.8749 26.6249C82.8852 26.5149 82.8657 26.4041 82.8182 26.3038C82.7707 26.2036 82.697 26.1174 82.6046 26.0541C82.4248 25.9255 82.1427 25.8638 81.7688 25.8638H79.9948C78.9451 25.8638 78.234 25.6992 77.86 25.383C77.4861 25.0667 77.3076 24.4933 77.3076 23.6949C77.3076 22.8721 77.5267 22.2627 77.9768 21.8706C78.4268 21.4784 79.1209 21.2881 80.046 21.2881H84.4573V22.8837H80.8306C80.2393 22.8837 79.8535 22.9346 79.6733 23.0366C79.4936 23.1369 79.403 23.3143 79.403 23.5805C79.3945 23.6784 79.4114 23.7769 79.452 23.8667C79.4925 23.9566 79.5556 24.035 79.6353 24.0947C79.7888 24.2079 80.046 24.2593 80.3806 24.2593H82.2451C83.094 24.2593 83.75 24.4612 84.187 24.8546C84.6239 25.248 84.8548 25.8047 84.8548 26.5401C84.8548 27.2498 84.6501 27.8257 84.2513 28.2757C84.0637 28.4925 83.8288 28.6653 83.5641 28.7815C83.2993 28.8976 83.0113 28.9541 82.7213 28.9468H77.4113V27.3693H77.4388Z" fill="var(--icon-color)"/>
                            <path d="M88.3903 18.5253V21.2997H90.1525C90.9397 21.2997 91.5538 21.3884 92.0288 21.5787C92.5091 21.7629 92.9275 22.0745 93.2372 22.4787C93.5172 22.8272 93.731 23.2221 93.8683 23.6448C94.0114 24.0958 94.0805 24.5662 94.073 25.0384C94.073 26.2675 93.7389 27.2305 93.0706 27.9273C92.4027 28.6241 91.4764 28.9661 90.2811 28.9661H86.3198V18.5253H88.3903ZM89.6408 22.9608H88.3798V27.332H89.7943C90.5815 27.332 91.1313 27.1675 91.441 26.8499C91.7506 26.5324 91.9159 25.9757 91.9159 25.1901C91.9159 24.4046 91.7362 23.8222 91.3911 23.4802C91.046 23.1382 90.4608 22.9608 89.6408 22.9608Z" fill="var(--icon-color)"/>
                            <path d="M96.9796 25.14C96.9796 25.8741 97.1462 26.4256 97.4939 26.8499C97.8417 27.2742 98.3166 27.458 98.9464 27.458C99.5763 27.458 100.039 27.2562 100.4 26.8499C100.761 26.4436 100.925 25.8741 100.925 25.14C100.925 24.4059 100.744 23.8466 100.4 23.4416C100.056 23.0366 99.5776 22.8335 98.9464 22.8335C98.6732 22.8212 98.4007 22.8695 98.1492 22.9748C97.8977 23.0801 97.6738 23.2397 97.4939 23.4416C97.1462 23.8466 96.9796 24.4174 96.9796 25.14ZM103.074 25.14C103.074 26.3399 102.702 27.3029 101.956 28.0288C101.21 28.7385 100.219 29.1062 98.9596 29.1062C97.6999 29.1062 96.6962 28.7514 95.9509 28.0288C95.2056 27.3063 94.833 26.3575 94.833 25.1528C94.833 23.9482 95.2056 22.9852 95.9509 22.2627C96.6962 21.5401 97.6999 21.1737 98.9569 21.1737C100.214 21.1737 101.207 21.5414 101.954 22.2627C102.7 22.9839 103.074 23.9353 103.074 25.14Z" fill="var(--icon-color)"/>
                            <path d="M106.443 28.9661H104.309V18.5253H106.443V28.9661Z" fill="var(--icon-color)"/>
                            <path d="M107.433 21.2997H108.885V18.5253H110.943V21.2997H113.116V22.8335H110.943V25.9255C110.943 26.4951 111.046 26.8885 111.238 27.116C111.429 27.3436 111.778 27.4452 112.267 27.4452H113.116V28.979H111.226C110.468 28.979 109.888 28.7758 109.477 28.358C109.066 27.9402 108.873 27.3449 108.873 26.5709V22.8335H107.42V21.2997H107.433Z" fill="var(--icon-color)"/>
                            <path d="M126.257 23.6949L121.656 19.4497C121.46 19.2722 121.202 19.1737 120.935 19.1737C120.667 19.1737 120.41 19.2722 120.213 19.4497L117.326 22.1251C117.705 22.2627 118.044 22.4858 118.318 22.7762C118.591 23.0666 118.791 23.4162 118.901 23.7965H122.798C122.845 23.7965 122.892 23.8057 122.936 23.8235C122.98 23.8414 123.02 23.8675 123.053 23.9005C123.087 23.9334 123.114 23.9726 123.132 24.0156C123.15 24.0587 123.159 24.1048 123.159 24.1513V24.7337C123.159 24.7803 123.15 24.8264 123.132 24.8694C123.114 24.9125 123.087 24.9516 123.053 24.9846C123.02 25.0175 122.98 25.0437 122.936 25.0615C122.892 25.0794 122.845 25.0886 122.798 25.0886H122.348V25.9127C122.348 25.9591 122.339 26.0052 122.321 26.0483C122.303 26.0913 122.277 26.1304 122.243 26.1634C122.21 26.1964 122.17 26.2226 122.126 26.2405C122.083 26.2583 122.036 26.2675 121.988 26.2675H121C120.953 26.2675 120.906 26.2583 120.862 26.2405C120.818 26.2226 120.779 26.1964 120.745 26.1634C120.712 26.1304 120.685 26.0913 120.667 26.0483C120.649 26.0052 120.64 25.9591 120.641 25.9127V25.0886H118.901C118.797 25.473 118.599 25.8271 118.325 26.1206C118.051 26.414 117.708 26.6382 117.326 26.7741L120.226 29.4534C120.423 29.6308 120.68 29.7293 120.948 29.7293C121.215 29.7293 121.473 29.6308 121.669 29.4534L126.262 25.2107C126.366 25.1126 126.449 24.9947 126.506 24.8643C126.562 24.7338 126.591 24.5934 126.591 24.4517C126.59 24.31 126.56 24.1698 126.503 24.0397C126.445 23.9096 126.362 23.7923 126.257 23.6949Z" fill="#D40101"/>
                            <path d="M116.472 23.2822C116.284 23.2859 116.1 23.3298 115.931 23.4108C115.743 23.5024 115.583 23.6416 115.468 23.814C115.353 23.9865 115.287 24.1859 115.277 24.3917C115.267 24.5976 115.313 24.8023 115.411 24.9848C115.508 25.1672 115.654 25.3209 115.832 25.4297C116.011 25.5386 116.216 25.5988 116.426 25.604C116.636 25.6093 116.844 25.5595 117.028 25.4597C117.212 25.3599 117.366 25.2138 117.473 25.0364C117.58 24.8591 117.637 24.6569 117.637 24.4509C117.641 24.2987 117.613 24.1473 117.557 24.0057C117.5 23.8641 117.414 23.735 117.306 23.6261C117.197 23.5172 117.068 23.4307 116.924 23.3716C116.781 23.3126 116.627 23.2822 116.472 23.2822Z" fill="#D40101"/>
                        </g>
                        <g filter="url(#filter0_d_280_142230)">
                            <path d="M9.07129 46.5832C9.07129 45.6717 9.81023 44.9327 10.7218 44.9327H166.278C167.19 44.9327 167.929 45.6717 167.929 46.5832V201.368C167.929 202.28 167.19 203.019 166.278 203.019H10.7218C9.81023 203.019 9.07129 202.28 9.07129 201.368V46.5832Z" fill="#F1F1F1" shape-rendering="crispEdges"/>
                            <path d="M88.4999 101.874C98.7546 101.874 107.068 93.5607 107.068 83.306C107.068 73.0513 98.7546 64.7383 88.4999 64.7383C78.2452 64.7383 69.9321 73.0513 69.9321 83.306C69.9321 93.5607 78.2452 101.874 88.4999 101.874Z" fill="#939598"/>
                            <path d="M88.4842 85.1546C86.7225 85.1505 85.0344 84.4477 83.7901 83.2005C82.5459 81.9533 81.8472 80.2636 81.8472 78.5019C81.8513 76.7429 82.552 75.0572 83.7957 73.8134C85.0395 72.5696 86.7252 71.869 88.4842 71.8649C90.2431 71.869 91.9288 72.5696 93.1726 73.8134C94.4164 75.0572 95.117 76.7429 95.1212 78.5019C95.1212 80.2636 94.4224 81.9533 93.1782 83.2005C91.934 84.4477 90.2459 85.1505 88.4842 85.1546V85.1546Z" fill="white"/>
                            <path d="M93.9675 88.2049H83.0639C82.1833 88.1914 81.3091 88.3567 80.4943 88.6908C79.6794 89.0249 78.9408 89.5208 78.3232 90.1486C77.694 90.766 77.1961 91.5042 76.8594 92.3189C76.5227 93.1336 76.3541 94.0079 76.3637 94.8893V95.9007C79.6071 99.0351 83.942 100.786 88.4525 100.784C92.963 100.786 97.2978 99.0351 100.541 95.9007V94.8893C100.554 94.0089 100.388 93.135 100.054 92.3202C99.7201 91.5055 99.2246 90.7668 98.5976 90.1486C97.9924 89.535 97.2717 89.0472 96.477 88.7136C95.6823 88.38 94.8294 88.2071 93.9675 88.2049V88.2049Z" fill="white"/>
                            <path d="M71.4976 114.476L71.1772 113.424H69.5664L69.2461 114.476H68.2367L69.7961 110.039H70.9415L72.5069 114.476H71.4976ZM70.9536 112.638L70.6332 111.611C70.6131 111.542 70.5859 111.455 70.5516 111.348C70.5194 111.239 70.4862 111.129 70.4519 111.018C70.4197 110.906 70.3935 110.808 70.3733 110.725C70.3532 110.808 70.325 110.911 70.2887 111.033C70.2545 111.154 70.2212 111.269 70.189 111.378C70.1568 111.487 70.1336 111.564 70.1195 111.611L69.8022 112.638H70.9536ZM74.0633 114.536C73.6866 114.536 73.3793 114.389 73.1416 114.095C72.9059 113.799 72.788 113.365 72.788 112.792C72.788 112.214 72.9079 111.777 73.1476 111.481C73.3874 111.183 73.7007 111.033 74.0875 111.033C74.2487 111.033 74.3907 111.056 74.5136 111.1C74.6365 111.144 74.7423 111.204 74.8309 111.278C74.9216 111.353 74.9981 111.436 75.0606 111.529H75.0908C75.0787 111.465 75.0636 111.37 75.0455 111.245C75.0294 111.118 75.0213 110.988 75.0213 110.855V109.773H75.9461V114.476H75.2389L75.0606 114.037H75.0213C74.9629 114.13 74.8894 114.215 74.8007 114.291C74.7141 114.366 74.6103 114.425 74.4894 114.47C74.3685 114.514 74.2265 114.536 74.0633 114.536ZM74.3867 113.802C74.6385 113.802 74.8158 113.727 74.9186 113.578C75.0233 113.427 75.0787 113.2 75.0848 112.898V112.798C75.0848 112.47 75.0344 112.219 74.9337 112.046C74.8329 111.871 74.6456 111.783 74.3716 111.783C74.1681 111.783 74.0089 111.871 73.8941 112.046C73.7792 112.221 73.7218 112.474 73.7218 112.804C73.7218 113.135 73.7792 113.384 73.8941 113.551C74.0109 113.718 74.1751 113.802 74.3867 113.802ZM78.2942 111.027C78.7476 111.027 79.0951 111.126 79.3369 111.324C79.5786 111.521 79.6995 111.821 79.6995 112.224V114.476H79.0558L78.8775 114.016H78.8533C78.7566 114.137 78.6579 114.236 78.5572 114.312C78.4564 114.389 78.3406 114.445 78.2096 114.482C78.0787 114.518 77.9195 114.536 77.7321 114.536C77.5327 114.536 77.3534 114.498 77.1942 114.421C77.0371 114.345 76.9131 114.228 76.8225 114.071C76.7318 113.912 76.6865 113.71 76.6865 113.466C76.6865 113.108 76.8124 112.844 77.0643 112.674C77.3161 112.503 77.6939 112.409 78.1975 112.39L78.7838 112.372V112.224C78.7838 112.047 78.7375 111.917 78.6448 111.834C78.5521 111.752 78.4232 111.71 78.258 111.71C78.0948 111.71 77.9346 111.734 77.7775 111.78C77.6203 111.826 77.4632 111.885 77.306 111.955L77.0008 111.333C77.1801 111.238 77.3806 111.163 77.6022 111.109C77.8258 111.055 78.0565 111.027 78.2942 111.027ZM78.7838 112.91L78.4272 112.922C78.129 112.93 77.9215 112.984 77.8047 113.082C77.6898 113.181 77.6324 113.311 77.6324 113.472C77.6324 113.613 77.6737 113.714 77.7563 113.775C77.8389 113.833 77.9467 113.862 78.0797 113.862C78.2771 113.862 78.4433 113.804 78.5783 113.687C78.7153 113.57 78.7838 113.404 78.7838 113.188V112.91ZM82.3318 114.476V110.057H83.2686V113.702H85.0607V114.476H82.3318ZM88.8293 112.78C88.8293 113.062 88.791 113.312 88.7144 113.53C88.6399 113.747 88.5301 113.932 88.385 114.083C88.242 114.232 88.0687 114.345 87.8652 114.421C87.6637 114.498 87.4361 114.536 87.1822 114.536C86.9445 114.536 86.7259 114.498 86.5264 114.421C86.329 114.345 86.1567 114.232 86.0096 114.083C85.8646 113.932 85.7518 113.747 85.6712 113.53C85.5926 113.312 85.5533 113.062 85.5533 112.78C85.5533 112.406 85.6198 112.088 85.7528 111.828C85.8857 111.568 86.0751 111.371 86.3209 111.236C86.5667 111.101 86.8599 111.033 87.2004 111.033C87.5167 111.033 87.7967 111.101 88.0405 111.236C88.2863 111.371 88.4787 111.568 88.6177 111.828C88.7587 112.088 88.8293 112.406 88.8293 112.78ZM86.4932 112.78C86.4932 113.002 86.5174 113.188 86.5657 113.339C86.6141 113.49 86.6896 113.604 86.7924 113.681C86.8951 113.757 87.0291 113.796 87.1943 113.796C87.3575 113.796 87.4895 113.757 87.5902 113.681C87.693 113.604 87.7675 113.49 87.8138 113.339C87.8622 113.188 87.8864 113.002 87.8864 112.78C87.8864 112.557 87.8622 112.371 87.8138 112.224C87.7675 112.075 87.693 111.963 87.5902 111.889C87.4875 111.814 87.3535 111.777 87.1883 111.777C86.9445 111.777 86.7672 111.861 86.6564 112.028C86.5476 112.195 86.4932 112.446 86.4932 112.78ZM90.3947 114.476L89.1073 111.097H90.0713L90.7241 113.022C90.7604 113.135 90.7886 113.254 90.8087 113.379C90.8309 113.504 90.846 113.615 90.8541 113.714H90.8782C90.8843 113.607 90.8984 113.493 90.9206 113.373C90.9447 113.252 90.976 113.135 91.0142 113.022L91.664 111.097H92.628L91.3406 114.476H90.3947ZM94.5078 111.033C94.8201 111.033 95.089 111.094 95.3147 111.215C95.5403 111.334 95.7146 111.507 95.8375 111.735C95.9604 111.962 96.0218 112.24 96.0218 112.569V113.016H93.8429C93.853 113.276 93.9306 113.48 94.0756 113.629C94.2227 113.777 94.4262 113.85 94.6861 113.85C94.9017 113.85 95.0991 113.828 95.2784 113.784C95.4577 113.739 95.6421 113.673 95.8315 113.584V114.297C95.6642 114.38 95.489 114.44 95.3056 114.479C95.1243 114.517 94.9037 114.536 94.6438 114.536C94.3053 114.536 94.0051 114.474 93.7432 114.349C93.4833 114.224 93.2788 114.033 93.1297 113.778C92.9826 113.522 92.9091 113.199 92.9091 112.81C92.9091 112.416 92.9756 112.087 93.1085 111.825C93.2435 111.561 93.4309 111.364 93.6707 111.233C93.9104 111.1 94.1895 111.033 94.5078 111.033ZM94.5138 111.689C94.3345 111.689 94.1854 111.747 94.0666 111.862C93.9497 111.976 93.8822 112.157 93.8641 112.402H95.1575C95.1555 112.265 95.1303 112.144 95.082 112.037C95.0356 111.93 94.9651 111.845 94.8704 111.783C94.7778 111.721 94.6589 111.689 94.5138 111.689ZM97.6931 114.476H96.7713V109.773H97.6931V114.476ZM100.047 111.027C100.501 111.027 100.848 111.126 101.09 111.324C101.332 111.521 101.453 111.821 101.453 112.224V114.476H100.809L100.631 114.016H100.606C100.51 114.137 100.411 114.236 100.31 114.312C100.209 114.389 100.094 114.445 99.9627 114.482C99.8317 114.518 99.6725 114.536 99.4852 114.536C99.2857 114.536 99.1064 114.498 98.9472 114.421C98.7901 114.345 98.6662 114.228 98.5755 114.071C98.4849 113.912 98.4395 113.71 98.4395 113.466C98.4395 113.108 98.5654 112.844 98.8173 112.674C99.0691 112.503 99.4469 112.409 99.9506 112.39L100.537 112.372V112.224C100.537 112.047 100.491 111.917 100.398 111.834C100.305 111.752 100.176 111.71 100.011 111.71C99.8478 111.71 99.6876 111.734 99.5305 111.78C99.3733 111.826 99.2162 111.885 99.059 111.955L98.7538 111.333C98.9331 111.238 99.1336 111.163 99.3552 111.109C99.5788 111.055 99.8095 111.027 100.047 111.027ZM100.537 112.91L100.18 112.922C99.8821 112.93 99.6745 112.984 99.5577 113.082C99.4429 113.181 99.3854 113.311 99.3854 113.472C99.3854 113.613 99.4267 113.714 99.5093 113.775C99.5919 113.833 99.6997 113.862 99.8327 113.862C100.03 113.862 100.196 113.804 100.331 113.687C100.468 113.57 100.537 113.404 100.537 113.188V112.91ZM103.777 114.536C103.442 114.536 103.157 114.476 102.921 114.355C102.686 114.232 102.506 114.042 102.383 113.787C102.26 113.531 102.199 113.203 102.199 112.804C102.199 112.391 102.269 112.055 102.408 111.795C102.549 111.533 102.743 111.341 102.991 111.218C103.241 111.095 103.53 111.033 103.858 111.033C104.092 111.033 104.293 111.057 104.463 111.103C104.634 111.147 104.783 111.201 104.91 111.263L104.638 111.976C104.493 111.918 104.358 111.871 104.233 111.834C104.108 111.796 103.983 111.777 103.858 111.777C103.697 111.777 103.563 111.815 103.456 111.892C103.349 111.966 103.27 112.079 103.217 112.23C103.165 112.381 103.139 112.571 103.139 112.798C103.139 113.022 103.167 113.207 103.223 113.354C103.28 113.502 103.362 113.611 103.468 113.684C103.575 113.754 103.705 113.79 103.858 113.79C104.05 113.79 104.22 113.764 104.369 113.714C104.518 113.662 104.663 113.589 104.804 113.496V114.285C104.663 114.374 104.515 114.437 104.36 114.476C104.207 114.516 104.012 114.536 103.777 114.536ZM106.983 111.033C107.295 111.033 107.564 111.094 107.79 111.215C108.016 111.334 108.19 111.507 108.313 111.735C108.436 111.962 108.497 112.24 108.497 112.569V113.016H106.318C106.328 113.276 106.406 113.48 106.551 113.629C106.698 113.777 106.901 113.85 107.161 113.85C107.377 113.85 107.574 113.828 107.754 113.784C107.933 113.739 108.117 113.673 108.307 113.584V114.297C108.139 114.38 107.964 114.44 107.781 114.479C107.599 114.517 107.379 114.536 107.119 114.536C106.78 114.536 106.48 114.474 106.218 114.349C105.958 114.224 105.754 114.033 105.605 113.778C105.458 113.522 105.384 113.199 105.384 112.81C105.384 112.416 105.451 112.087 105.584 111.825C105.719 111.561 105.906 111.364 106.146 111.233C106.386 111.1 106.665 111.033 106.983 111.033ZM106.989 111.689C106.81 111.689 106.661 111.747 106.542 111.862C106.425 111.976 106.357 112.157 106.339 112.402H107.633C107.631 112.265 107.606 112.144 107.557 112.037C107.511 111.93 107.44 111.845 107.346 111.783C107.253 111.721 107.134 111.689 106.989 111.689Z" fill="#020202"/>
                            <path d="M68.0439 120.433C68.3598 120.433 68.5943 120.504 68.7474 120.646C68.9006 120.787 68.9771 121.014 68.9771 121.325V123.126H68.6846L68.6072 122.734H68.5879C68.5137 122.831 68.4364 122.913 68.3558 122.979C68.2752 123.043 68.1817 123.092 68.0753 123.126C67.9706 123.158 67.8416 123.174 67.6885 123.174C67.5273 123.174 67.3839 123.146 67.2582 123.09C67.1341 123.033 67.0357 122.948 66.9632 122.834C66.8923 122.719 66.8568 122.574 66.8568 122.398C66.8568 122.134 66.9616 121.931 67.1711 121.789C67.3807 121.647 67.6998 121.57 68.1285 121.557L68.5855 121.538V121.376C68.5855 121.147 68.5363 120.986 68.438 120.895C68.3397 120.803 68.2011 120.757 68.0221 120.757C67.8835 120.757 67.7514 120.777 67.6256 120.817C67.4999 120.858 67.3807 120.905 67.2678 120.96L67.1445 120.655C67.2638 120.594 67.4008 120.542 67.5555 120.498C67.7103 120.455 67.8731 120.433 68.0439 120.433ZM68.5806 121.821L68.1769 121.837C67.8465 121.85 67.6136 121.904 67.4782 121.999C67.3428 122.095 67.2751 122.229 67.2751 122.403C67.2751 122.555 67.321 122.667 67.4129 122.739C67.5048 122.812 67.6265 122.848 67.778 122.848C68.0133 122.848 68.2059 122.783 68.3558 122.652C68.5057 122.522 68.5806 122.326 68.5806 122.065V121.821ZM70.7469 123.174C70.4116 123.174 70.1457 123.06 69.949 122.831C69.754 122.602 69.6565 122.262 69.6565 121.811C69.6565 121.355 69.7564 121.011 69.9563 120.779C70.1561 120.545 70.4221 120.428 70.7541 120.428C70.8943 120.428 71.0168 120.447 71.1216 120.484C71.2264 120.521 71.3166 120.571 71.3924 120.633C71.4681 120.695 71.5318 120.765 71.5834 120.844H71.6124C71.6059 120.794 71.5995 120.725 71.5931 120.638C71.5866 120.551 71.5834 120.48 71.5834 120.426V119.364H71.9847V123.126H71.6607L71.6003 122.749H71.5834C71.5334 122.828 71.4698 122.9 71.3924 122.964C71.3166 123.029 71.2256 123.08 71.1192 123.119C71.0144 123.156 70.8903 123.174 70.7469 123.174ZM70.8097 122.841C71.0934 122.841 71.2941 122.76 71.4117 122.599C71.5294 122.438 71.5882 122.199 71.5882 121.881V121.808C71.5882 121.472 71.5318 121.213 71.419 121.032C71.3078 120.852 71.1047 120.762 70.8097 120.762C70.5631 120.762 70.3786 120.857 70.2561 121.047C70.1336 121.235 70.0723 121.493 70.0723 121.821C70.0723 122.146 70.1328 122.398 70.2537 122.575C70.3762 122.752 70.5615 122.841 70.8097 122.841ZM73.827 120.433C74.1429 120.433 74.3774 120.504 74.5305 120.646C74.6836 120.787 74.7602 121.014 74.7602 121.325V123.126H74.4677L74.3903 122.734H74.371C74.2968 122.831 74.2195 122.913 74.1389 122.979C74.0583 123.043 73.9648 123.092 73.8584 123.126C73.7536 123.158 73.6247 123.174 73.4716 123.174C73.3104 123.174 73.167 123.146 73.0412 123.09C72.9171 123.033 72.8188 122.948 72.7463 122.834C72.6754 122.719 72.6399 122.574 72.6399 122.398C72.6399 122.134 72.7447 121.931 72.9542 121.789C73.1637 121.647 73.4829 121.57 73.9116 121.557L74.3685 121.538V121.376C74.3685 121.147 74.3194 120.986 74.2211 120.895C74.1227 120.803 73.9841 120.757 73.8052 120.757C73.6666 120.757 73.5344 120.777 73.4087 120.817C73.283 120.858 73.1637 120.905 73.0509 120.96L72.9276 120.655C73.0469 120.594 73.1839 120.542 73.3386 120.498C73.4933 120.455 73.6561 120.433 73.827 120.433ZM74.3637 121.821L73.96 121.837C73.6295 121.85 73.3966 121.904 73.2612 121.999C73.1259 122.095 73.0582 122.229 73.0582 122.403C73.0582 122.555 73.1041 122.667 73.196 122.739C73.2878 122.812 73.4095 122.848 73.561 122.848C73.7964 122.848 73.989 122.783 74.1389 122.652C74.2888 122.522 74.3637 122.326 74.3637 122.065V121.821ZM79.3199 121.361C79.3199 121.514 79.3022 121.664 79.2668 121.811C79.2329 121.956 79.1805 122.087 79.1096 122.205C79.0387 122.321 78.95 122.414 78.8437 122.483C78.7389 122.552 78.6148 122.587 78.4713 122.587C78.3214 122.587 78.2022 122.543 78.1135 122.456C78.0249 122.369 77.9717 122.266 77.954 122.147H77.9322C77.8709 122.274 77.7807 122.38 77.6614 122.464C77.5438 122.546 77.3987 122.587 77.2262 122.587C76.9748 122.587 76.7806 122.504 76.6436 122.338C76.5082 122.17 76.4405 121.948 76.4405 121.671C76.4405 121.455 76.4832 121.264 76.5686 121.098C76.6557 120.93 76.7774 120.799 76.9337 120.704C77.0917 120.607 77.2778 120.559 77.4922 120.559C77.6356 120.559 77.775 120.571 77.9104 120.595C78.0458 120.619 78.1538 120.646 78.2344 120.675L78.1861 121.649C78.1844 121.709 78.1828 121.754 78.1812 121.787C78.1796 121.817 78.1788 121.842 78.1788 121.859C78.1788 122.033 78.2094 122.151 78.2707 122.212C78.3335 122.272 78.4093 122.302 78.4979 122.302C78.6059 122.302 78.6962 122.26 78.7687 122.176C78.8429 122.091 78.8993 121.977 78.938 121.835C78.9766 121.692 78.996 121.533 78.996 121.359C78.996 121.051 78.9339 120.788 78.8098 120.571C78.6857 120.353 78.5141 120.187 78.2948 120.073C78.0773 119.958 77.8266 119.901 77.543 119.901C77.2609 119.901 77.0103 119.945 76.7911 120.034C76.5735 120.123 76.3889 120.248 76.2374 120.411C76.0875 120.572 75.9739 120.764 75.8965 120.986C75.8191 121.209 75.7805 121.455 75.7805 121.724C75.7805 122.053 75.8385 122.332 75.9545 122.563C76.0722 122.793 76.2439 122.969 76.4695 123.09C76.6968 123.209 76.9732 123.269 77.2988 123.269C77.4954 123.269 77.6848 123.247 77.8669 123.203C78.0491 123.16 78.2118 123.111 78.3553 123.056V123.37C78.2135 123.43 78.0547 123.478 77.879 123.515C77.7033 123.554 77.5099 123.573 77.2988 123.573C76.9103 123.573 76.5783 123.5 76.3027 123.353C76.0271 123.208 75.8159 122.999 75.6693 122.725C75.5226 122.451 75.4492 122.122 75.4492 121.738C75.4492 121.427 75.4968 121.141 75.5919 120.88C75.6886 120.619 75.8272 120.393 76.0077 120.201C76.1899 120.009 76.4099 119.861 76.6678 119.756C76.9273 119.649 77.219 119.596 77.543 119.596C77.8895 119.596 78.1957 119.668 78.4617 119.811C78.7292 119.953 78.9388 120.156 79.0903 120.421C79.2434 120.683 79.3199 120.997 79.3199 121.361ZM76.8007 121.68C76.8007 121.895 76.8434 122.052 76.9289 122.152C77.0143 122.252 77.1328 122.302 77.2843 122.302C77.4712 122.302 77.6082 122.232 77.6953 122.091C77.7839 121.951 77.8347 121.766 77.8476 121.535L77.8766 120.904C77.8298 120.89 77.7726 120.878 77.7049 120.868C77.6389 120.857 77.5695 120.851 77.497 120.851C77.331 120.851 77.1964 120.891 77.0933 120.97C76.9917 121.049 76.9176 121.151 76.8708 121.277C76.8241 121.402 76.8007 121.537 76.8007 121.68ZM81.271 120.428C81.6014 120.428 81.8649 120.542 82.0616 120.769C82.2582 120.996 82.3565 121.338 82.3565 121.794C82.3565 122.095 82.3114 122.348 82.2212 122.553C82.1309 122.758 82.0036 122.913 81.8392 123.017C81.6764 123.122 81.4838 123.174 81.2613 123.174C81.1211 123.174 80.9978 123.156 80.8914 123.119C80.7851 123.082 80.694 123.032 80.6182 122.969C80.5425 122.906 80.4796 122.838 80.4297 122.763H80.4006C80.4055 122.826 80.4111 122.902 80.4176 122.991C80.4256 123.079 80.4297 123.157 80.4297 123.223V124.311H80.0259V120.476H80.3571L80.4103 120.868H80.4297C80.4812 120.787 80.5441 120.714 80.6182 120.648C80.6924 120.58 80.7826 120.527 80.889 120.488C80.997 120.448 81.1243 120.428 81.271 120.428ZM81.2009 120.766C81.0171 120.766 80.8689 120.802 80.756 120.873C80.6448 120.944 80.5634 121.05 80.5119 121.192C80.4603 121.332 80.4329 121.509 80.4297 121.721V121.799C80.4297 122.023 80.4538 122.212 80.5022 122.367C80.5522 122.522 80.6335 122.639 80.7464 122.72C80.8608 122.801 81.0139 122.841 81.2057 122.841C81.3701 122.841 81.5071 122.796 81.6167 122.708C81.7263 122.619 81.8077 122.496 81.8609 122.338C81.9157 122.178 81.9431 121.995 81.9431 121.789C81.9431 121.476 81.8819 121.228 81.7594 121.044C81.6385 120.859 81.4523 120.766 81.2009 120.766ZM84.0489 120.433C84.3648 120.433 84.5993 120.504 84.7525 120.646C84.9056 120.787 84.9821 121.014 84.9821 121.325V123.126H84.6896L84.6122 122.734H84.5929C84.5187 122.831 84.4414 122.913 84.3608 122.979C84.2802 123.043 84.1867 123.092 84.0803 123.126C83.9756 123.158 83.8466 123.174 83.6935 123.174C83.5323 123.174 83.3889 123.146 83.2632 123.09C83.1391 123.033 83.0407 122.948 82.9682 122.834C82.8973 122.719 82.8618 122.574 82.8618 122.398C82.8618 122.134 82.9666 121.931 83.1761 121.789C83.3857 121.647 83.7048 121.57 84.1335 121.557L84.5905 121.538V121.376C84.5905 121.147 84.5413 120.986 84.443 120.895C84.3447 120.803 84.2061 120.757 84.0272 120.757C83.8885 120.757 83.7564 120.777 83.6307 120.817C83.5049 120.858 83.3857 120.905 83.2728 120.96L83.1495 120.655C83.2688 120.594 83.4058 120.542 83.5605 120.498C83.7153 120.455 83.8781 120.433 84.0489 120.433ZM84.5856 121.821L84.1819 121.837C83.8515 121.85 83.6186 121.904 83.4832 121.999C83.3478 122.095 83.2801 122.229 83.2801 122.403C83.2801 122.555 83.326 122.667 83.4179 122.739C83.5098 122.812 83.6315 122.848 83.783 122.848C84.0183 122.848 84.2109 122.783 84.3608 122.652C84.5107 122.522 84.5856 122.326 84.5856 122.065V121.821ZM87.5231 122.401C87.5231 122.57 87.4804 122.713 87.395 122.829C87.3112 122.943 87.1903 123.029 87.0323 123.087C86.876 123.145 86.689 123.174 86.4714 123.174C86.2861 123.174 86.1257 123.16 85.9903 123.131C85.8549 123.102 85.7365 123.061 85.6349 123.008V122.638C85.7429 122.691 85.8718 122.739 86.0217 122.783C86.1716 122.826 86.3248 122.848 86.4811 122.848C86.71 122.848 86.876 122.811 86.9791 122.737C87.0823 122.663 87.1339 122.562 87.1339 122.435C87.1339 122.362 87.1129 122.298 87.071 122.244C87.0307 122.187 86.9622 122.133 86.8655 122.082C86.7688 122.028 86.635 121.97 86.4642 121.908C86.2949 121.843 86.1483 121.779 86.0242 121.717C85.9017 121.652 85.8066 121.574 85.7389 121.482C85.6728 121.39 85.6397 121.271 85.6397 121.124C85.6397 120.9 85.73 120.729 85.9105 120.609C86.0927 120.488 86.3312 120.428 86.6262 120.428C86.7857 120.428 86.9348 120.444 87.0734 120.476C87.2137 120.507 87.3442 120.549 87.4651 120.602L87.3297 120.924C87.2201 120.877 87.1032 120.837 86.9791 120.805C86.855 120.773 86.7285 120.757 86.5996 120.757C86.4142 120.757 86.2716 120.787 86.1716 120.849C86.0733 120.91 86.0242 120.994 86.0242 121.1C86.0242 121.182 86.0467 121.25 86.0919 121.303C86.1386 121.356 86.2127 121.406 86.3143 121.453C86.4158 121.5 86.5496 121.555 86.7156 121.617C86.8816 121.679 87.0251 121.742 87.146 121.808C87.2668 121.873 87.3595 121.952 87.424 122.045C87.4901 122.137 87.5231 122.256 87.5231 122.401ZM89.8828 122.401C89.8828 122.57 89.8401 122.713 89.7546 122.829C89.6708 122.943 89.5499 123.029 89.392 123.087C89.2356 123.145 89.0487 123.174 88.8311 123.174C88.6457 123.174 88.4853 123.16 88.35 123.131C88.2146 123.102 88.0961 123.061 87.9946 123.008V122.638C88.1026 122.691 88.2315 122.739 88.3814 122.783C88.5313 122.826 88.6844 122.848 88.8407 122.848C89.0696 122.848 89.2356 122.811 89.3388 122.737C89.4419 122.663 89.4935 122.562 89.4935 122.435C89.4935 122.362 89.4726 122.298 89.4307 122.244C89.3904 122.187 89.3219 122.133 89.2252 122.082C89.1285 122.028 88.9947 121.97 88.8238 121.908C88.6546 121.843 88.5079 121.779 88.3838 121.717C88.2613 121.652 88.1662 121.574 88.0985 121.482C88.0324 121.39 87.9994 121.271 87.9994 121.124C87.9994 120.9 88.0897 120.729 88.2702 120.609C88.4523 120.488 88.6909 120.428 88.9858 120.428C89.1454 120.428 89.2945 120.444 89.4331 120.476C89.5733 120.507 89.7039 120.549 89.8247 120.602L89.6894 120.924C89.5798 120.877 89.4629 120.837 89.3388 120.805C89.2147 120.773 89.0882 120.757 88.9592 120.757C88.7739 120.757 88.6312 120.787 88.5313 120.849C88.433 120.91 88.3838 120.994 88.3838 121.1C88.3838 121.182 88.4064 121.25 88.4515 121.303C88.4982 121.356 88.5724 121.406 88.6739 121.453C88.7755 121.5 88.9092 121.555 89.0753 121.617C89.2413 121.679 89.3847 121.742 89.5056 121.808C89.6265 121.873 89.7192 121.952 89.7836 122.045C89.8497 122.137 89.8828 122.256 89.8828 122.401ZM90.9296 119.364V120.305C90.9296 120.413 90.9264 120.517 90.9199 120.619C90.9151 120.721 90.9111 120.799 90.9079 120.856H90.9296C91.0021 120.737 91.1069 120.636 91.2439 120.554C91.3809 120.471 91.5558 120.43 91.7686 120.43C92.1006 120.43 92.3649 120.546 92.5615 120.776C92.7598 121.005 92.8589 121.346 92.8589 121.799C92.8589 122.097 92.8138 122.348 92.7235 122.553C92.6333 122.758 92.5059 122.913 92.3415 123.017C92.1771 123.122 91.9829 123.174 91.7589 123.174C91.5493 123.174 91.3769 123.136 91.2415 123.058C91.1077 122.979 91.0046 122.884 90.932 122.771H90.9006L90.8184 123.126H90.5283V119.364H90.9296ZM91.7033 120.766C91.5115 120.766 91.3592 120.804 91.2463 120.88C91.1335 120.954 91.0521 121.067 91.0021 121.219C90.9538 121.368 90.9296 121.559 90.9296 121.789V121.811C90.9296 122.145 90.9852 122.4 91.0964 122.577C91.2077 122.753 91.4099 122.841 91.7033 122.841C91.9499 122.841 92.1344 122.751 92.2569 122.57C92.381 122.39 92.4431 122.132 92.4431 121.796C92.4431 121.455 92.3818 121.198 92.2593 121.025C92.1385 120.853 91.9531 120.766 91.7033 120.766ZM95.8448 121.796C95.8448 122.014 95.8165 122.208 95.7601 122.379C95.7037 122.55 95.6223 122.694 95.5159 122.812C95.4096 122.929 95.2806 123.02 95.1291 123.083C94.9792 123.144 94.8092 123.174 94.619 123.174C94.4417 123.174 94.2789 123.144 94.1306 123.083C93.9839 123.02 93.8566 122.929 93.7486 122.812C93.6422 122.694 93.5592 122.55 93.4996 122.379C93.4416 122.208 93.4126 122.014 93.4126 121.796C93.4126 121.506 93.4617 121.26 93.56 121.057C93.6584 120.852 93.7986 120.696 93.9807 120.59C94.1645 120.482 94.3829 120.428 94.6359 120.428C94.8777 120.428 95.0888 120.482 95.2693 120.59C95.4515 120.698 95.5925 120.854 95.6924 121.059C95.794 121.262 95.8448 121.508 95.8448 121.796ZM93.8284 121.796C93.8284 122.009 93.8566 122.194 93.913 122.35C93.9694 122.506 94.0565 122.627 94.1741 122.713C94.2918 122.798 94.4433 122.841 94.6287 122.841C94.8124 122.841 94.9631 122.798 95.0808 122.713C95.2 122.627 95.2879 122.506 95.3443 122.35C95.4007 122.194 95.4289 122.009 95.4289 121.796C95.4289 121.585 95.4007 121.403 95.3443 121.25C95.2879 121.095 95.2008 120.976 95.0832 120.892C94.9655 120.808 94.8132 120.766 94.6262 120.766C94.3506 120.766 94.1483 120.858 94.0194 121.04C93.8921 121.222 93.8284 121.474 93.8284 121.796ZM96.9424 123.126H96.5386V119.364H96.9424V123.126ZM98.6468 122.846C98.7129 122.846 98.7806 122.84 98.8499 122.829C98.9192 122.817 98.9756 122.804 99.0192 122.788V123.1C98.9724 123.12 98.9071 123.138 98.8233 123.153C98.7411 123.167 98.6605 123.174 98.5816 123.174C98.4413 123.174 98.314 123.15 98.1996 123.102C98.0851 123.052 97.9933 122.968 97.924 122.85C97.8563 122.733 97.8224 122.57 97.8224 122.362V120.791H97.4453V120.595L97.8248 120.438L97.9844 119.862H98.2262V120.476H99.0022V120.791H98.2262V122.35C98.2262 122.516 98.264 122.64 98.3398 122.722C98.4172 122.805 98.5195 122.846 98.6468 122.846ZM99.4954 122.875C99.4954 122.762 99.5228 122.682 99.5776 122.635C99.6324 122.587 99.6993 122.563 99.7783 122.563C99.8605 122.563 99.9298 122.587 99.9862 122.635C100.043 122.682 100.071 122.762 100.071 122.875C100.071 122.986 100.043 123.067 99.9862 123.119C99.9298 123.169 99.8605 123.194 99.7783 123.194C99.6993 123.194 99.6324 123.169 99.5776 123.119C99.5228 123.067 99.4954 122.986 99.4954 122.875ZM101.918 123.174C101.679 123.174 101.469 123.125 101.287 123.027C101.105 122.929 100.963 122.779 100.861 122.577C100.76 122.376 100.709 122.122 100.709 121.816C100.709 121.495 100.762 121.233 100.869 121.03C100.977 120.825 101.125 120.674 101.314 120.575C101.502 120.477 101.716 120.428 101.957 120.428C102.089 120.428 102.216 120.442 102.339 120.469C102.463 120.495 102.564 120.528 102.643 120.568L102.522 120.904C102.442 120.872 102.348 120.843 102.242 120.817C102.137 120.791 102.039 120.779 101.947 120.779C101.763 120.779 101.61 120.818 101.488 120.897C101.367 120.976 101.276 121.092 101.214 121.245C101.155 121.398 101.125 121.587 101.125 121.811C101.125 122.025 101.154 122.208 101.212 122.36C101.272 122.511 101.359 122.627 101.476 122.708C101.593 122.787 101.74 122.826 101.916 122.826C102.056 122.826 102.182 122.812 102.295 122.783C102.408 122.752 102.51 122.717 102.602 122.676V123.034C102.514 123.079 102.414 123.114 102.305 123.138C102.197 123.162 102.068 123.174 101.918 123.174ZM105.515 121.796C105.515 122.014 105.487 122.208 105.431 122.379C105.374 122.55 105.293 122.694 105.187 122.812C105.08 122.929 104.951 123.02 104.8 123.083C104.65 123.144 104.48 123.174 104.29 123.174C104.112 123.174 103.95 123.144 103.801 123.083C103.655 123.02 103.527 122.929 103.419 122.812C103.313 122.694 103.23 122.55 103.17 122.379C103.112 122.208 103.083 122.014 103.083 121.796C103.083 121.506 103.132 121.26 103.231 121.057C103.329 120.852 103.469 120.696 103.651 120.59C103.835 120.482 104.054 120.428 104.307 120.428C104.548 120.428 104.76 120.482 104.94 120.59C105.122 120.698 105.263 120.854 105.363 121.059C105.465 121.262 105.515 121.508 105.515 121.796ZM103.499 121.796C103.499 122.009 103.527 122.194 103.584 122.35C103.64 122.506 103.727 122.627 103.845 122.713C103.962 122.798 104.114 122.841 104.299 122.841C104.483 122.841 104.634 122.798 104.751 122.713C104.871 122.627 104.959 122.506 105.015 122.35C105.071 122.194 105.1 122.009 105.1 121.796C105.1 121.585 105.071 121.403 105.015 121.25C104.959 121.095 104.872 120.976 104.754 120.892C104.636 120.808 104.484 120.766 104.297 120.766C104.021 120.766 103.819 120.858 103.69 121.04C103.563 121.222 103.499 121.474 103.499 121.796ZM109.086 120.428C109.378 120.428 109.598 120.505 109.746 120.658C109.895 120.809 109.969 121.053 109.969 121.39V123.126H109.572V121.41C109.572 121.195 109.526 121.035 109.432 120.928C109.34 120.82 109.203 120.766 109.021 120.766C108.765 120.766 108.579 120.841 108.463 120.989C108.347 121.137 108.289 121.356 108.289 121.644V123.126H107.89V121.41C107.89 121.266 107.869 121.147 107.827 121.052C107.786 120.957 107.725 120.886 107.643 120.839C107.562 120.791 107.46 120.766 107.336 120.766C107.16 120.766 107.019 120.803 106.913 120.875C106.806 120.948 106.729 121.056 106.681 121.199C106.634 121.341 106.611 121.516 106.611 121.724V123.126H106.209V120.476H106.533L106.594 120.851H106.615C106.669 120.759 106.736 120.682 106.816 120.619C106.897 120.556 106.987 120.509 107.087 120.476C107.187 120.444 107.293 120.428 107.406 120.428C107.608 120.428 107.776 120.466 107.911 120.542C108.048 120.616 108.147 120.729 108.209 120.882H108.231C108.318 120.729 108.437 120.616 108.588 120.542C108.74 120.466 108.906 120.428 109.086 120.428Z" fill="#020202"/>
                            <rect x="22.0686" y="138.124" width="132.863" height="14.1892" rx="1.44416" fill="white"/>
                            <g opacity="0.5">
                                <path d="M27.3345 142.8C27.9047 142.8 28.3208 142.912 28.5827 143.135C28.8466 143.357 28.9786 143.675 28.9786 144.09C28.9786 144.278 28.9473 144.456 28.8849 144.625C28.8244 144.792 28.7257 144.94 28.5887 145.069C28.4517 145.196 28.2714 145.297 28.0478 145.372C27.8261 145.444 27.5541 145.48 27.2318 145.48H26.6939V147.218H26.1801V142.8H27.3345ZM27.2862 143.238H26.6939V145.039H27.1744C27.4564 145.039 27.6911 145.009 27.8785 144.949C28.0679 144.888 28.2099 144.79 28.3046 144.655C28.3993 144.518 28.4467 144.337 28.4467 144.111C28.4467 143.817 28.353 143.599 28.1656 143.456C27.9782 143.311 27.6851 143.238 27.2862 143.238ZM31.0668 143.852C31.4617 143.852 31.7549 143.94 31.9463 144.117C32.1377 144.295 32.2334 144.578 32.2334 144.967V147.218H31.8677L31.771 146.729H31.7468C31.6541 146.849 31.5574 146.951 31.4567 147.034C31.3559 147.114 31.2391 147.176 31.1061 147.218C30.9752 147.258 30.814 147.279 30.6226 147.279C30.4211 147.279 30.2418 147.243 30.0846 147.173C29.9295 147.102 29.8066 146.996 29.716 146.852C29.6273 146.709 29.583 146.528 29.583 146.308C29.583 145.978 29.7139 145.724 29.9759 145.547C30.2378 145.37 30.6367 145.273 31.1726 145.257L31.7438 145.233V145.03C31.7438 144.744 31.6823 144.544 31.5594 144.429C31.4365 144.314 31.2633 144.256 31.0396 144.256C30.8664 144.256 30.7012 144.282 30.544 144.332C30.3869 144.382 30.2378 144.442 30.0967 144.51L29.9426 144.13C30.0917 144.053 30.263 143.988 30.4564 143.933C30.6498 143.879 30.8533 143.852 31.0668 143.852ZM31.7377 145.586L31.233 145.607C30.82 145.623 30.5289 145.691 30.3597 145.81C30.1904 145.929 30.1058 146.097 30.1058 146.315C30.1058 146.504 30.1632 146.644 30.2781 146.735C30.3929 146.825 30.545 146.871 30.7344 146.871C31.0285 146.871 31.2693 146.789 31.4567 146.626C31.644 146.463 31.7377 146.218 31.7377 145.891V145.586ZM35.4096 146.312C35.4096 146.523 35.3562 146.701 35.2494 146.846C35.1446 146.989 34.9935 147.097 34.7961 147.17C34.6007 147.242 34.367 147.279 34.095 147.279C33.8633 147.279 33.6628 147.26 33.4936 147.224C33.3243 147.188 33.1762 147.137 33.0493 147.07V146.608C33.1843 146.674 33.3455 146.735 33.5329 146.789C33.7202 146.843 33.9116 146.871 34.1071 146.871C34.3931 146.871 34.6007 146.824 34.7296 146.732C34.8585 146.639 34.923 146.513 34.923 146.354C34.923 146.263 34.8968 146.184 34.8444 146.115C34.7941 146.045 34.7085 145.977 34.5876 145.913C34.4667 145.846 34.2995 145.774 34.0859 145.695C33.8744 145.614 33.691 145.535 33.5359 145.456C33.3828 145.376 33.2639 145.278 33.1793 145.163C33.0967 145.048 33.0554 144.899 33.0554 144.716C33.0554 144.436 33.1682 144.221 33.3938 144.072C33.6215 143.921 33.9197 143.845 34.2884 143.845C34.4878 143.845 34.6742 143.866 34.8475 143.906C35.0227 143.944 35.1859 143.997 35.337 144.063L35.1678 144.465C35.0308 144.407 34.8847 144.357 34.7296 144.317C34.5745 144.277 34.4163 144.256 34.2551 144.256C34.0234 144.256 33.8451 144.295 33.7202 144.371C33.5973 144.448 33.5359 144.553 33.5359 144.686C33.5359 144.788 33.5641 144.873 33.6205 144.939C33.6789 145.006 33.7716 145.068 33.8985 145.127C34.0255 145.185 34.1927 145.254 34.4002 145.332C34.6077 145.409 34.787 145.488 34.9381 145.571C35.0892 145.652 35.2051 145.75 35.2857 145.867C35.3683 145.982 35.4096 146.13 35.4096 146.312ZM38.3591 146.312C38.3591 146.523 38.3057 146.701 38.199 146.846C38.0942 146.989 37.9431 147.097 37.7457 147.17C37.5502 147.242 37.3165 147.279 37.0445 147.279C36.8128 147.279 36.6124 147.26 36.4431 147.224C36.2739 147.188 36.1258 147.137 35.9989 147.07V146.608C36.1339 146.674 36.295 146.735 36.4824 146.789C36.6698 146.843 36.8612 146.871 37.0566 146.871C37.3427 146.871 37.5502 146.824 37.6792 146.732C37.8081 146.639 37.8726 146.513 37.8726 146.354C37.8726 146.263 37.8464 146.184 37.794 146.115C37.7436 146.045 37.658 145.977 37.5371 145.913C37.4162 145.846 37.249 145.774 37.0355 145.695C36.8239 145.614 36.6406 145.535 36.4854 145.456C36.3323 145.376 36.2135 145.278 36.1288 145.163C36.0462 145.048 36.0049 144.899 36.0049 144.716C36.0049 144.436 36.1178 144.221 36.3434 144.072C36.5711 143.921 36.8692 143.845 37.2379 143.845C37.4374 143.845 37.6238 143.866 37.797 143.906C37.9723 143.944 38.1355 143.997 38.2866 144.063L38.1174 144.465C37.9804 144.407 37.8343 144.357 37.6792 144.317C37.524 144.277 37.3659 144.256 37.2047 144.256C36.973 144.256 36.7947 144.295 36.6698 144.371C36.5469 144.448 36.4854 144.553 36.4854 144.686C36.4854 144.788 36.5136 144.873 36.5701 144.939C36.6285 145.006 36.7212 145.068 36.8481 145.127C36.975 145.185 37.1422 145.254 37.3498 145.332C37.5573 145.409 37.7366 145.488 37.8877 145.571C38.0388 145.652 38.1546 145.75 38.2352 145.867C38.3178 145.982 38.3591 146.13 38.3591 146.312ZM40.7224 143.845C41.1354 143.845 41.4648 143.988 41.7106 144.272C41.9564 144.556 42.0793 144.983 42.0793 145.553C42.0793 145.93 42.0229 146.246 41.9101 146.502C41.7973 146.758 41.6381 146.951 41.4326 147.082C41.2291 147.213 40.9884 147.279 40.7103 147.279C40.535 147.279 40.3809 147.255 40.2479 147.209C40.115 147.163 40.0011 147.1 39.9065 147.022C39.8118 146.943 39.7332 146.858 39.6707 146.765H39.6345C39.6405 146.843 39.6476 146.938 39.6556 147.049C39.6657 147.16 39.6707 147.256 39.6707 147.339V148.699H39.166V143.906H39.5801L39.6466 144.396H39.6707C39.7352 144.295 39.8138 144.203 39.9065 144.12C39.9991 144.036 40.112 143.969 40.2449 143.921C40.3799 143.871 40.5391 143.845 40.7224 143.845ZM40.6348 144.269C40.4051 144.269 40.2197 144.313 40.0787 144.402C39.9397 144.49 39.838 144.623 39.7735 144.8C39.709 144.976 39.6748 145.196 39.6707 145.462V145.559C39.6707 145.839 39.7009 146.076 39.7614 146.269C39.8238 146.463 39.9256 146.61 40.0666 146.71C40.2097 146.811 40.4011 146.862 40.6408 146.862C40.8463 146.862 41.0176 146.806 41.1546 146.695C41.2916 146.585 41.3933 146.43 41.4598 146.233C41.5283 146.033 41.5626 145.805 41.5626 145.547C41.5626 145.156 41.486 144.846 41.3329 144.616C41.1818 144.384 40.9491 144.269 40.6348 144.269ZM43.4574 142.516V143.921C43.4574 144.002 43.4554 144.083 43.4514 144.166C43.4473 144.246 43.4403 144.321 43.4302 144.389H43.4635C43.532 144.273 43.6186 144.175 43.7234 144.096C43.8301 144.016 43.951 143.955 44.086 143.915C44.221 143.873 44.364 143.852 44.5151 143.852C44.7811 143.852 45.0027 143.894 45.18 143.978C45.3593 144.063 45.4933 144.194 45.5819 144.371C45.6726 144.549 45.7179 144.778 45.7179 145.06V147.218H45.2223V145.094C45.2223 144.818 45.1588 144.611 45.0319 144.474C44.907 144.337 44.7146 144.269 44.4547 144.269C44.2089 144.269 44.0125 144.316 43.8654 144.411C43.7203 144.503 43.6156 144.64 43.5511 144.822C43.4886 145.003 43.4574 145.225 43.4574 145.486V147.218H42.9557V142.516H43.4574ZM48.2565 143.845C48.323 143.845 48.3925 143.85 48.465 143.858C48.5375 143.864 48.602 143.873 48.6584 143.885L48.595 144.35C48.5406 144.336 48.4801 144.325 48.4136 144.317C48.3472 144.309 48.2847 144.305 48.2263 144.305C48.0933 144.305 47.9674 144.332 47.8485 144.386C47.7317 144.439 47.6289 144.515 47.5403 144.616C47.4516 144.715 47.3821 144.835 47.3317 144.976C47.2814 145.115 47.2562 145.27 47.2562 145.441V147.218H46.7515V143.906H47.1685L47.2229 144.516H47.2441C47.3126 144.393 47.3952 144.282 47.4919 144.181C47.5886 144.078 47.7004 143.997 47.8274 143.936C47.9563 143.876 48.0993 143.845 48.2565 143.845ZM50.5231 143.852C50.918 143.852 51.2111 143.94 51.4025 144.117C51.5939 144.295 51.6896 144.578 51.6896 144.967V147.218H51.3239L51.2272 146.729H51.203C51.1104 146.849 51.0137 146.951 50.9129 147.034C50.8122 147.114 50.6953 147.176 50.5624 147.218C50.4314 147.258 50.2702 147.279 50.0788 147.279C49.8773 147.279 49.698 147.243 49.5409 147.173C49.3858 147.102 49.2629 146.996 49.1722 146.852C49.0835 146.709 49.0392 146.528 49.0392 146.308C49.0392 145.978 49.1702 145.724 49.4321 145.547C49.694 145.37 50.0929 145.273 50.6288 145.257L51.2 145.233V145.03C51.2 144.744 51.1386 144.544 51.0157 144.429C50.8928 144.314 50.7195 144.256 50.4959 144.256C50.3226 144.256 50.1574 144.282 50.0002 144.332C49.8431 144.382 49.694 144.442 49.553 144.51L49.3988 144.13C49.5479 144.053 49.7192 143.988 49.9126 143.933C50.106 143.879 50.3095 143.852 50.5231 143.852ZM51.194 145.586L50.6893 145.607C50.2763 145.623 49.9851 145.691 49.8159 145.81C49.6467 145.929 49.562 146.097 49.562 146.315C49.562 146.504 49.6195 146.644 49.7343 146.735C49.8491 146.825 50.0013 146.871 50.1906 146.871C50.4848 146.871 50.7255 146.789 50.9129 146.626C51.1003 146.463 51.194 146.218 51.194 145.891V145.586ZM54.8658 146.312C54.8658 146.523 54.8124 146.701 54.7056 146.846C54.6009 146.989 54.4498 147.097 54.2523 147.17C54.0569 147.242 53.8232 147.279 53.5512 147.279C53.3195 147.279 53.119 147.26 52.9498 147.224C52.7806 147.188 52.6325 147.137 52.5056 147.07V146.608C52.6405 146.674 52.8017 146.735 52.9891 146.789C53.1765 146.843 53.3679 146.871 53.5633 146.871C53.8494 146.871 54.0569 146.824 54.1858 146.732C54.3148 146.639 54.3793 146.513 54.3793 146.354C54.3793 146.263 54.3531 146.184 54.3007 146.115C54.2503 146.045 54.1647 145.977 54.0438 145.913C53.9229 145.846 53.7557 145.774 53.5421 145.695C53.3306 145.614 53.1472 145.535 52.9921 145.456C52.839 145.376 52.7201 145.278 52.6355 145.163C52.5529 145.048 52.5116 144.899 52.5116 144.716C52.5116 144.436 52.6244 144.221 52.8501 144.072C53.0777 143.921 53.3759 143.845 53.7446 143.845C53.9441 143.845 54.1304 143.866 54.3037 143.906C54.479 143.944 54.6422 143.997 54.7933 144.063L54.624 144.465C54.487 144.407 54.341 144.357 54.1858 144.317C54.0307 144.277 53.8726 144.256 53.7114 144.256C53.4797 144.256 53.3014 144.295 53.1765 144.371C53.0536 144.448 52.9921 144.553 52.9921 144.686C52.9921 144.788 53.0203 144.873 53.0767 144.939C53.1352 145.006 53.2278 145.068 53.3548 145.127C53.4817 145.185 53.6489 145.254 53.8564 145.332C54.064 145.409 54.2433 145.488 54.3944 145.571C54.5455 145.652 54.6613 145.75 54.7419 145.867C54.8245 145.982 54.8658 146.13 54.8658 146.312ZM56.948 143.845C57.2301 143.845 57.4719 143.908 57.6733 144.033C57.8748 144.158 58.0289 144.333 58.1357 144.559C58.2425 144.782 58.2959 145.044 58.2959 145.344V145.656H56.0082C56.0142 146.045 56.1109 146.341 56.2983 146.544C56.4857 146.748 56.7496 146.849 57.0901 146.849C57.2996 146.849 57.485 146.83 57.6461 146.792C57.8073 146.754 57.9745 146.697 58.1478 146.623V147.064C57.9806 147.139 57.8144 147.193 57.6492 147.227C57.486 147.261 57.2926 147.279 57.0689 147.279C56.7506 147.279 56.4726 147.214 56.2348 147.085C55.9991 146.954 55.8158 146.763 55.6848 146.511C55.5538 146.259 55.4884 145.951 55.4884 145.586C55.4884 145.23 55.5478 144.921 55.6667 144.661C55.7876 144.4 55.9568 144.198 56.1744 144.057C56.394 143.916 56.6519 143.845 56.948 143.845ZM56.942 144.256C56.674 144.256 56.4605 144.344 56.3013 144.519C56.1421 144.695 56.0475 144.939 56.0172 145.254H57.77C57.768 145.056 57.7368 144.883 57.6764 144.734C57.6179 144.583 57.5283 144.466 57.4074 144.383C57.2865 144.299 57.1314 144.256 56.942 144.256Z" fill="black"/>
                            </g>
                            <rect x="22.0686" y="138.124" width="132.863" height="14.1892" rx="1.44416" stroke="#BDBDBD" stroke-width="0.412617"/>
                            <rect x="22.4812" y="171.866" width="132.037" height="17.7425" rx="1.44416" fill="#2894DF"/>
                            <path d="M79.7967 182.265C79.7967 182.579 79.7206 182.853 79.5682 183.085C79.4159 183.317 79.1935 183.496 78.901 183.621C78.6108 183.747 78.2579 183.81 77.842 183.81C77.6583 183.81 77.4782 183.798 77.3017 183.774C77.1276 183.75 76.9596 183.715 76.7976 183.669C76.638 183.62 76.4857 183.561 76.3406 183.491V182.446C76.5921 182.558 76.8532 182.658 77.124 182.747C77.3948 182.837 77.6631 182.882 77.9291 182.882C78.1128 182.882 78.2603 182.857 78.3715 182.809C78.4851 182.761 78.5673 182.694 78.6181 182.61C78.6689 182.525 78.6943 182.428 78.6943 182.32C78.6943 182.187 78.6495 182.073 78.5601 181.979C78.4706 181.884 78.3473 181.796 78.1902 181.714C78.0354 181.632 77.8602 181.543 77.6643 181.449C77.541 181.391 77.4068 181.321 77.2618 181.239C77.1167 181.154 76.9789 181.051 76.8484 180.931C76.7178 180.81 76.6102 180.663 76.5256 180.492C76.4434 180.318 76.4023 180.11 76.4023 179.868C76.4023 179.551 76.4748 179.281 76.6199 179.056C76.7649 178.831 76.9717 178.659 77.24 178.541C77.5108 178.42 77.8299 178.359 78.1974 178.359C78.473 178.359 78.7354 178.392 78.9844 178.457C79.2358 178.52 79.4981 178.612 79.7713 178.733L79.4087 179.607C79.1645 179.508 78.9457 179.432 78.7523 179.378C78.5589 179.323 78.3618 179.295 78.1612 179.295C78.0209 179.295 77.9013 179.318 77.8021 179.364C77.703 179.407 77.6281 179.47 77.5773 179.552C77.5265 179.632 77.5011 179.725 77.5011 179.832C77.5011 179.957 77.5374 180.064 77.6099 180.151C77.6849 180.235 77.7961 180.318 77.9436 180.397C78.0935 180.477 78.2796 180.57 78.502 180.677C78.7728 180.805 79.0037 180.939 79.1947 181.079C79.3881 181.217 79.5368 181.38 79.6408 181.569C79.7447 181.755 79.7967 181.987 79.7967 182.265ZM81.7768 179.683V183.737H80.6707V179.683H81.7768ZM81.2256 178.095C81.39 178.095 81.5314 178.133 81.6499 178.211C81.7683 178.286 81.8276 178.427 81.8276 178.635C81.8276 178.84 81.7683 178.983 81.6499 179.063C81.5314 179.14 81.39 179.179 81.2256 179.179C81.0587 179.179 80.9161 179.14 80.7976 179.063C80.6816 178.983 80.6236 178.84 80.6236 178.635C80.6236 178.427 80.6816 178.286 80.7976 178.211C80.9161 178.133 81.0587 178.095 81.2256 178.095ZM84.1268 185.522C83.561 185.522 83.1283 185.423 82.8285 185.224C82.5311 185.029 82.3824 184.753 82.3824 184.398C82.3824 184.153 82.4586 183.949 82.6109 183.785C82.7632 183.62 82.9868 183.503 83.2818 183.433C83.1682 183.385 83.069 183.306 82.9844 183.197C82.8998 183.086 82.8575 182.969 82.8575 182.845C82.8575 182.691 82.9022 182.562 82.9917 182.461C83.0811 182.357 83.2105 182.255 83.3797 182.156C83.167 182.064 82.9977 181.917 82.872 181.714C82.7487 181.511 82.687 181.271 82.687 180.996C82.687 180.701 82.7511 180.451 82.8792 180.245C83.0098 180.037 83.1984 179.879 83.445 179.77C83.694 179.661 83.9962 179.607 84.3516 179.607C84.4266 179.607 84.5136 179.612 84.6127 179.621C84.7118 179.631 84.8025 179.642 84.8847 179.654C84.9693 179.666 85.0261 179.676 85.0552 179.683H86.4695V180.245L85.8349 180.408C85.8929 180.498 85.9364 180.593 85.9654 180.695C85.9944 180.796 86.0089 180.904 86.0089 181.018C86.0089 181.453 85.8566 181.792 85.552 182.037C85.2498 182.278 84.8291 182.399 84.29 182.399C84.1618 182.392 84.0409 182.382 83.9273 182.37C83.8717 182.414 83.8294 182.46 83.8004 182.508C83.7714 182.556 83.7569 182.607 83.7569 182.66C83.7569 182.714 83.7786 182.758 83.8221 182.795C83.8681 182.828 83.9358 182.855 84.0252 182.874C84.1171 182.891 84.2307 182.9 84.3661 182.9H85.0552C85.5 182.9 85.8385 182.995 86.0706 183.186C86.3051 183.377 86.4224 183.658 86.4224 184.028C86.4224 184.501 86.2241 184.869 85.8276 185.13C85.4335 185.391 84.8666 185.522 84.1268 185.522ZM84.1739 184.8C84.4374 184.8 84.6635 184.775 84.8521 184.724C85.0431 184.676 85.1893 184.605 85.2909 184.514C85.3924 184.424 85.4432 184.317 85.4432 184.191C85.4432 184.089 85.413 184.008 85.3525 183.948C85.2945 183.89 85.2051 183.849 85.0842 183.825C84.9657 183.8 84.8134 183.788 84.6272 183.788H84.0542C83.9189 183.788 83.7968 183.81 83.688 183.854C83.5816 183.897 83.497 183.957 83.4341 184.035C83.3712 184.115 83.3398 184.207 83.3398 184.31C83.3398 184.463 83.4123 184.582 83.5574 184.67C83.7049 184.757 83.9104 184.8 84.1739 184.8ZM84.3516 181.725C84.5595 181.725 84.7118 181.661 84.8086 181.533C84.9053 181.404 84.9536 181.23 84.9536 181.01C84.9536 180.766 84.9028 180.584 84.8013 180.463C84.7022 180.339 84.5523 180.278 84.3516 180.278C84.1485 180.278 83.9962 180.339 83.8947 180.463C83.7931 180.584 83.7424 180.766 83.7424 181.01C83.7424 181.23 83.7919 181.404 83.891 181.533C83.9926 181.661 84.1461 181.725 84.3516 181.725ZM89.4432 179.607C89.876 179.607 90.2241 179.725 90.4877 179.962C90.7512 180.197 90.883 180.574 90.883 181.094V183.737H89.7769V181.369C89.7769 181.079 89.7237 180.86 89.6173 180.713C89.5133 180.565 89.3489 180.492 89.1241 180.492C88.7856 180.492 88.5547 180.607 88.4314 180.836C88.3081 181.066 88.2465 181.397 88.2465 181.83V183.737H87.1404V179.683H87.9854L88.1341 180.202H88.1957C88.2828 180.061 88.3903 179.948 88.5185 179.861C88.649 179.774 88.7929 179.71 88.95 179.669C89.1096 179.627 89.274 179.607 89.4432 179.607ZM95.0571 179.683V183.737H93.951V179.683H95.0571ZM94.5058 178.095C94.6703 178.095 94.8117 178.133 94.9302 178.211C95.0486 178.286 95.1078 178.427 95.1078 178.635C95.1078 178.84 95.0486 178.983 94.9302 179.063C94.8117 179.14 94.6703 179.179 94.5058 179.179C94.339 179.179 94.1964 179.14 94.0779 179.063C93.9619 178.983 93.9038 178.84 93.9038 178.635C93.9038 178.427 93.9619 178.286 94.0779 178.211C94.1964 178.133 94.339 178.095 94.5058 178.095ZM98.524 179.607C98.9568 179.607 99.3049 179.725 99.5685 179.962C99.832 180.197 99.9638 180.574 99.9638 181.094V183.737H98.8577V181.369C98.8577 181.079 98.8045 180.86 98.6981 180.713C98.5941 180.565 98.4297 180.492 98.2049 180.492C97.8664 180.492 97.6355 180.607 97.5122 180.836C97.3889 181.066 97.3273 181.397 97.3273 181.83V183.737H96.2212V179.683H97.0662L97.2149 180.202H97.2765C97.3635 180.061 97.4711 179.948 97.5993 179.861C97.7298 179.774 97.8737 179.71 98.0308 179.669C98.1904 179.627 98.3548 179.607 98.524 179.607Z" fill="white"/>
                            <rect x="22.4812" y="171.866" width="132.037" height="17.7425" rx="1.44416" stroke="#2894DF" stroke-width="0.412617"/>
                        </g>
                        <defs>
                            <filter id="filter0_d_280_142230" x="6.59559" y="42.457" width="167.11" height="166.338" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                <feOffset dx="1.65047" dy="1.65047"/>
                                <feGaussianBlur stdDeviation="2.06308"/>
                                <feComposite in2="hardAlpha" operator="out"/>
                                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_280_142230"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_280_142230" result="shape"/>
                            </filter>
                            <clipPath id="clip0_280_142230">
                                <rect width="76.1816" height="13.2037" fill="white" transform="translate(50.4092 18.5253)"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <p><?= __('You sign in to passbolt just like you normally do.'); ?></p>
                </div>
                <div class="step">
                    <!-- SVG setup TOTP check -->
                    <svg width="177" height="243" viewBox="0 0 177 243" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="0.699504" y="-0.699504" width="121.714" height="229.437" rx="14.6896" transform="matrix(-1 0 0 1 150.056 7.48083)" fill="white"/>
                        <rect x="-2.09851" y="2.09851" width="116.118" height="223.841" rx="11.8916" transform="matrix(-1 0 0 1 144.46 7.48083)" fill="white"/>
                        <path d="M40.8511 64.7021C41.1451 64.7021 41.3634 64.7681 41.5059 64.9001C41.6484 65.0321 41.7196 65.2429 41.7196 65.5324V67.2088H41.4474L41.3754 66.8443H41.3574C41.2884 66.9343 41.2163 67.01 41.1413 67.0715C41.0663 67.1315 40.9793 67.1773 40.8803 67.2088C40.7828 67.2388 40.6628 67.2538 40.5203 67.2538C40.3703 67.2538 40.2368 67.2276 40.1197 67.175C40.0042 67.1225 39.9127 67.043 39.8452 66.9365C39.7792 66.83 39.7462 66.695 39.7462 66.5315C39.7462 66.2855 39.8437 66.0964 40.0387 65.9644C40.2338 65.8324 40.5308 65.7604 40.9298 65.7484L41.3551 65.7304V65.5796C41.3551 65.3666 41.3094 65.2174 41.2178 65.1318C41.1263 65.0463 40.9973 65.0036 40.8308 65.0036C40.7018 65.0036 40.5788 65.0223 40.4618 65.0598C40.3448 65.0973 40.2338 65.1416 40.1287 65.1926L40.014 64.9091C40.125 64.8521 40.2525 64.8033 40.3965 64.7628C40.5405 64.7223 40.692 64.7021 40.8511 64.7021ZM41.3506 65.9937L40.9748 66.0094C40.6673 66.0214 40.4505 66.0717 40.3245 66.1602C40.1985 66.2487 40.1355 66.374 40.1355 66.536C40.1355 66.677 40.1782 66.7813 40.2638 66.8488C40.3493 66.9163 40.4625 66.95 40.6035 66.95C40.8226 66.95 41.0018 66.8893 41.1413 66.7678C41.2809 66.6462 41.3506 66.464 41.3506 66.221V65.9937ZM43.3668 67.2538C43.0548 67.2538 42.8073 67.1473 42.6242 66.9343C42.4427 66.7213 42.352 66.4047 42.352 65.9847C42.352 65.5601 42.445 65.2399 42.631 65.0238C42.817 64.8063 43.0645 64.6976 43.3736 64.6976C43.5041 64.6976 43.6181 64.7148 43.7156 64.7493C43.8131 64.7838 43.8971 64.8303 43.9676 64.8888C44.0381 64.9458 44.0974 65.0111 44.1454 65.0846H44.1724C44.1664 65.0381 44.1604 64.9743 44.1544 64.8933C44.1484 64.8123 44.1454 64.7463 44.1454 64.6953V63.7075H44.5189V67.2088H44.2174L44.1611 66.8578H44.1454C44.0989 66.9313 44.0396 66.998 43.9676 67.058C43.8971 67.118 43.8123 67.166 43.7133 67.2021C43.6158 67.2366 43.5003 67.2538 43.3668 67.2538ZM43.4253 66.9433C43.6893 66.9433 43.8761 66.8683 43.9856 66.7183C44.0951 66.5682 44.1499 66.3455 44.1499 66.0499V65.9824C44.1499 65.6689 44.0974 65.4281 43.9924 65.2601C43.8889 65.0921 43.6998 65.0081 43.4253 65.0081C43.1958 65.0081 43.024 65.0966 42.91 65.2736C42.796 65.4491 42.739 65.6892 42.739 65.9937C42.739 66.2967 42.7953 66.5307 42.9078 66.6958C43.0218 66.8608 43.1943 66.9433 43.4253 66.9433ZM46.2336 64.7021C46.5276 64.7021 46.7459 64.7681 46.8884 64.9001C47.0309 65.0321 47.1022 65.2429 47.1022 65.5324V67.2088H46.8299L46.7579 66.8443H46.7399C46.6709 66.9343 46.5989 67.01 46.5239 67.0715C46.4489 67.1315 46.3618 67.1773 46.2628 67.2088C46.1653 67.2388 46.0453 67.2538 45.9028 67.2538C45.7528 67.2538 45.6193 67.2276 45.5023 67.175C45.3868 67.1225 45.2952 67.043 45.2277 66.9365C45.1617 66.83 45.1287 66.695 45.1287 66.5315C45.1287 66.2855 45.2262 66.0964 45.4213 65.9644C45.6163 65.8324 45.9133 65.7604 46.3123 65.7484L46.7376 65.7304V65.5796C46.7376 65.3666 46.6919 65.2174 46.6004 65.1318C46.5089 65.0463 46.3798 65.0036 46.2133 65.0036C46.0843 65.0036 45.9613 65.0223 45.8443 65.0598C45.7273 65.0973 45.6163 65.1416 45.5113 65.1926L45.3965 64.9091C45.5075 64.8521 45.635 64.8033 45.779 64.7628C45.9231 64.7223 46.0746 64.7021 46.2336 64.7021ZM46.7331 65.9937L46.3573 66.0094C46.0498 66.0214 45.833 66.0717 45.707 66.1602C45.581 66.2487 45.518 66.374 45.518 66.536C45.518 66.677 45.5608 66.7813 45.6463 66.8488C45.7318 66.9163 45.845 66.95 45.9861 66.95C46.2051 66.95 46.3843 66.8893 46.5239 66.7678C46.6634 66.6462 46.7331 66.464 46.7331 66.221V65.9937ZM51.3461 65.5661C51.3461 65.7087 51.3296 65.8482 51.2966 65.9847C51.2651 66.1197 51.2163 66.242 51.1503 66.3515C51.0843 66.4595 51.0018 66.5457 50.9028 66.6102C50.8053 66.6747 50.6898 66.707 50.5563 66.707C50.4167 66.707 50.3057 66.6665 50.2232 66.5855C50.1407 66.5045 50.0912 66.4085 50.0747 66.2975H50.0545C49.9975 66.416 49.9134 66.5142 49.8024 66.5922C49.6929 66.6687 49.5579 66.707 49.3974 66.707C49.1634 66.707 48.9826 66.6297 48.8551 66.4752C48.7291 66.3192 48.6661 66.1122 48.6661 65.8542C48.6661 65.6532 48.7058 65.4754 48.7853 65.3209C48.8663 65.1649 48.9796 65.0426 49.1251 64.9541C49.2721 64.8641 49.4454 64.8191 49.6449 64.8191C49.7784 64.8191 49.9082 64.8303 50.0342 64.8528C50.1602 64.8753 50.2607 64.9001 50.3357 64.9271L50.2907 65.8339C50.2892 65.8894 50.2877 65.9322 50.2862 65.9622C50.2847 65.9907 50.284 66.0132 50.284 66.0297C50.284 66.1917 50.3125 66.3012 50.3695 66.3582C50.428 66.4137 50.4985 66.4415 50.581 66.4415C50.6815 66.4415 50.7655 66.4025 50.833 66.3245C50.902 66.245 50.9545 66.1392 50.9905 66.0072C51.0266 65.8737 51.0446 65.7259 51.0446 65.5639C51.0446 65.2774 50.9868 65.0328 50.8713 64.8303C50.7558 64.6278 50.596 64.4733 50.392 64.3668C50.1895 64.2603 49.9562 64.207 49.6922 64.207C49.4296 64.207 49.1964 64.2483 48.9924 64.3308C48.7898 64.4133 48.6181 64.5303 48.4771 64.6818C48.3375 64.8318 48.2318 65.0103 48.1598 65.2174C48.0878 65.4244 48.0518 65.6532 48.0518 65.9037C48.0518 66.2097 48.1058 66.47 48.2138 66.6845C48.3233 66.899 48.4831 67.0625 48.6931 67.175C48.9046 67.2861 49.1619 67.3416 49.4649 67.3416C49.6479 67.3416 49.8242 67.3213 49.9937 67.2808C50.1632 67.2403 50.3147 67.1945 50.4482 67.1435V67.4361C50.3162 67.4916 50.1685 67.5366 50.005 67.5711C49.8414 67.6071 49.6614 67.6251 49.4649 67.6251C49.1034 67.6251 48.7943 67.5568 48.5378 67.4203C48.2813 67.2853 48.0848 67.0903 47.9483 66.8353C47.8117 66.5802 47.7435 66.2742 47.7435 65.9172C47.7435 65.6276 47.7877 65.3614 47.8762 65.1183C47.9663 64.8753 48.0953 64.6646 48.2633 64.486C48.4328 64.3075 48.6376 64.1695 48.8776 64.072C49.1191 63.973 49.3906 63.9235 49.6922 63.9235C50.0147 63.9235 50.2997 63.9902 50.5473 64.1238C50.7963 64.2558 50.9913 64.4448 51.1323 64.6908C51.2748 64.9353 51.3461 65.2271 51.3461 65.5661ZM49.0014 65.8632C49.0014 66.0627 49.0411 66.209 49.1206 66.302C49.2001 66.395 49.3104 66.4415 49.4514 66.4415C49.6254 66.4415 49.7529 66.3762 49.8339 66.2457C49.9164 66.1152 49.9637 65.9427 49.9757 65.7282L50.0027 65.1409C49.9592 65.1273 49.9059 65.1161 49.8429 65.1071C49.7814 65.0966 49.7169 65.0913 49.6494 65.0913C49.4949 65.0913 49.3696 65.1281 49.2736 65.2016C49.1791 65.2751 49.1101 65.3704 49.0666 65.4874C49.0231 65.6044 49.0014 65.7297 49.0014 65.8632ZM53.162 64.6976C53.4695 64.6976 53.7148 64.8033 53.8978 65.0148C54.0808 65.2264 54.1724 65.5444 54.1724 65.9689C54.1724 66.2495 54.1304 66.485 54.0463 66.6755C53.9623 66.866 53.8438 67.01 53.6908 67.1075C53.5393 67.2051 53.36 67.2538 53.153 67.2538C53.0225 67.2538 52.9077 67.2366 52.8087 67.2021C52.7097 67.1675 52.625 67.121 52.5544 67.0625C52.4839 67.004 52.4254 66.9403 52.3789 66.8713H52.3519C52.3564 66.9298 52.3617 67.0003 52.3677 67.0828C52.3752 67.1653 52.3789 67.2373 52.3789 67.2988V68.3114H52.0031V64.7426H52.3114L52.3609 65.1071H52.3789C52.4269 65.0321 52.4854 64.9638 52.5544 64.9023C52.6235 64.8393 52.7075 64.7898 52.8065 64.7538C52.907 64.7163 53.0255 64.6976 53.162 64.6976ZM53.0968 65.0126C52.9257 65.0126 52.7877 65.0456 52.6827 65.1116C52.5792 65.1776 52.5034 65.2766 52.4554 65.4086C52.4074 65.5391 52.3819 65.7034 52.3789 65.9014V65.9734C52.3789 66.182 52.4014 66.3582 52.4464 66.5022C52.4929 66.6462 52.5687 66.7558 52.6737 66.8308C52.7802 66.9058 52.9227 66.9433 53.1013 66.9433C53.2543 66.9433 53.3818 66.902 53.4838 66.8195C53.5858 66.737 53.6616 66.6222 53.7111 66.4752C53.7621 66.3267 53.7876 66.1564 53.7876 65.9644C53.7876 65.6734 53.7306 65.4424 53.6166 65.2714C53.504 65.0988 53.3308 65.0126 53.0968 65.0126ZM55.7475 64.7021C56.0415 64.7021 56.2598 64.7681 56.4023 64.9001C56.5448 65.0321 56.6161 65.2429 56.6161 65.5324V67.2088H56.3438L56.2718 66.8443H56.2538C56.1848 66.9343 56.1128 67.01 56.0378 67.0715C55.9628 67.1315 55.8758 67.1773 55.7768 67.2088C55.6793 67.2388 55.5592 67.2538 55.4167 67.2538C55.2667 67.2538 55.1332 67.2276 55.0162 67.175C54.9007 67.1225 54.8092 67.043 54.7417 66.9365C54.6757 66.83 54.6427 66.695 54.6427 66.5315C54.6427 66.2855 54.7402 66.0964 54.9352 65.9644C55.1302 65.8324 55.4272 65.7604 55.8263 65.7484L56.2516 65.7304V65.5796C56.2516 65.3666 56.2058 65.2174 56.1143 65.1318C56.0228 65.0463 55.8938 65.0036 55.7273 65.0036C55.5982 65.0036 55.4752 65.0223 55.3582 65.0598C55.2412 65.0973 55.1302 65.1416 55.0252 65.1926L54.9104 64.9091C55.0214 64.8521 55.149 64.8033 55.293 64.7628C55.437 64.7223 55.5885 64.7021 55.7475 64.7021ZM56.2471 65.9937L55.8713 66.0094C55.5637 66.0214 55.347 66.0717 55.221 66.1602C55.0949 66.2487 55.0319 66.374 55.0319 66.536C55.0319 66.677 55.0747 66.7813 55.1602 66.8488C55.2457 66.9163 55.359 66.95 55.5 66.95C55.719 66.95 55.8983 66.8893 56.0378 66.7678C56.1773 66.6462 56.2471 66.464 56.2471 66.221V65.9937ZM58.9811 66.5337C58.9811 66.6913 58.9413 66.824 58.8618 66.932C58.7838 67.0385 58.6713 67.1188 58.5243 67.1728C58.3788 67.2268 58.2047 67.2538 58.0022 67.2538C57.8297 67.2538 57.6804 67.2403 57.5544 67.2133C57.4284 67.1863 57.3182 67.148 57.2237 67.0985V66.7543C57.3242 66.8038 57.4442 66.8488 57.5837 66.8893C57.7232 66.9298 57.8657 66.95 58.0112 66.95C58.2243 66.95 58.3788 66.9155 58.4748 66.8465C58.5708 66.7775 58.6188 66.6838 58.6188 66.5652C58.6188 66.4977 58.5993 66.4385 58.5603 66.3875C58.5228 66.335 58.459 66.2847 58.369 66.2367C58.279 66.1872 58.1545 66.1332 57.9955 66.0747C57.838 66.0147 57.7014 65.9554 57.5859 65.8969C57.4719 65.8369 57.3834 65.7642 57.3204 65.6787C57.2589 65.5931 57.2282 65.4821 57.2282 65.3456C57.2282 65.1371 57.3122 64.9773 57.4802 64.8663C57.6497 64.7538 57.8717 64.6976 58.1462 64.6976C58.2948 64.6976 58.4335 64.7126 58.5625 64.7426C58.693 64.7711 58.8146 64.8101 58.9271 64.8596L58.8011 65.1589C58.699 65.1153 58.5903 65.0786 58.4748 65.0486C58.3593 65.0186 58.2415 65.0036 58.1215 65.0036C57.949 65.0036 57.8162 65.0321 57.7232 65.0891C57.6317 65.1461 57.5859 65.2241 57.5859 65.3231C57.5859 65.3996 57.6069 65.4626 57.6489 65.5121C57.6924 65.5616 57.7615 65.6081 57.856 65.6516C57.9505 65.6952 58.075 65.7462 58.2295 65.8047C58.384 65.8617 58.5175 65.9209 58.63 65.9824C58.7426 66.0424 58.8288 66.1159 58.8888 66.203C58.9503 66.2885 58.9811 66.3987 58.9811 66.5337ZM61.1773 66.5337C61.1773 66.6913 61.1375 66.824 61.058 66.932C60.98 67.0385 60.8675 67.1188 60.7205 67.1728C60.575 67.2268 60.401 67.2538 60.1984 67.2538C60.0259 67.2538 59.8767 67.2403 59.7506 67.2133C59.6246 67.1863 59.5144 67.148 59.4199 67.0985V66.7543C59.5204 66.8038 59.6404 66.8488 59.7799 66.8893C59.9194 66.9298 60.0619 66.95 60.2074 66.95C60.4205 66.95 60.575 66.9155 60.671 66.8465C60.767 66.7775 60.815 66.6838 60.815 66.5652C60.815 66.4977 60.7955 66.4385 60.7565 66.3875C60.719 66.335 60.6552 66.2847 60.5652 66.2367C60.4752 66.1872 60.3507 66.1332 60.1917 66.0747C60.0342 66.0147 59.8977 65.9554 59.7822 65.8969C59.6681 65.8369 59.5796 65.7642 59.5166 65.6787C59.4551 65.5931 59.4244 65.4821 59.4244 65.3456C59.4244 65.1371 59.5084 64.9773 59.6764 64.8663C59.8459 64.7538 60.0679 64.6976 60.3425 64.6976C60.491 64.6976 60.6297 64.7126 60.7587 64.7426C60.8893 64.7711 61.0108 64.8101 61.1233 64.8596L60.9973 65.1589C60.8953 65.1153 60.7865 65.0786 60.671 65.0486C60.5555 65.0186 60.4377 65.0036 60.3177 65.0036C60.1452 65.0036 60.0124 65.0321 59.9194 65.0891C59.8279 65.1461 59.7822 65.2241 59.7822 65.3231C59.7822 65.3996 59.8032 65.4626 59.8452 65.5121C59.8887 65.5616 59.9577 65.6081 60.0522 65.6516C60.1467 65.6952 60.2712 65.7462 60.4257 65.8047C60.5802 65.8617 60.7137 65.9209 60.8263 65.9824C60.9388 66.0424 61.025 66.1159 61.085 66.203C61.1465 66.2885 61.1773 66.3987 61.1773 66.5337ZM62.1516 63.7075V64.5828C62.1516 64.6833 62.1486 64.7808 62.1426 64.8753C62.1381 64.9698 62.1344 65.0433 62.1314 65.0958H62.1516C62.2191 64.9848 62.3166 64.8911 62.4442 64.8146C62.5717 64.7381 62.7344 64.6998 62.9325 64.6998C63.2415 64.6998 63.4875 64.8071 63.6705 65.0216C63.855 65.2346 63.9473 65.5519 63.9473 65.9734C63.9473 66.251 63.9053 66.485 63.8213 66.6755C63.7373 66.866 63.6188 67.01 63.4658 67.1075C63.3127 67.2051 63.132 67.2538 62.9235 67.2538C62.7284 67.2538 62.5679 67.2178 62.4419 67.1458C62.3174 67.0723 62.2214 66.983 62.1539 66.878H62.1246L62.0481 67.2088H61.7781V63.7075H62.1516ZM62.8717 65.0126C62.6932 65.0126 62.5514 65.0478 62.4464 65.1183C62.3414 65.1874 62.2656 65.2924 62.2191 65.4334C62.1741 65.5729 62.1516 65.7499 62.1516 65.9644V65.9847C62.1516 66.2952 62.2034 66.533 62.3069 66.698C62.4104 66.8615 62.5987 66.9433 62.8717 66.9433C63.1012 66.9433 63.273 66.8593 63.387 66.6913C63.5025 66.5232 63.5603 66.2832 63.5603 65.9712C63.5603 65.6532 63.5033 65.4139 63.3893 65.2534C63.2767 65.0928 63.1042 65.0126 62.8717 65.0126ZM66.7263 65.9712C66.7263 66.1737 66.7001 66.3545 66.6476 66.5135C66.5951 66.6725 66.5193 66.8068 66.4203 66.9163C66.3213 67.0258 66.2013 67.1098 66.0603 67.1683C65.9207 67.2253 65.7625 67.2538 65.5855 67.2538C65.4204 67.2538 65.2689 67.2253 65.1309 67.1683C64.9944 67.1098 64.8759 67.0258 64.7754 66.9163C64.6764 66.8068 64.5991 66.6725 64.5436 66.5135C64.4896 66.3545 64.4626 66.1737 64.4626 65.9712C64.4626 65.7012 64.5084 65.4716 64.5999 65.2826C64.6914 65.0921 64.8219 64.9473 64.9914 64.8483C65.1624 64.7478 65.3657 64.6976 65.6012 64.6976C65.8262 64.6976 66.0228 64.7478 66.1908 64.8483C66.3603 64.9488 66.4916 65.0943 66.5846 65.2849C66.6791 65.4739 66.7263 65.7027 66.7263 65.9712ZM64.8496 65.9712C64.8496 66.1692 64.8759 66.341 64.9284 66.4865C64.9809 66.632 65.0619 66.7445 65.1714 66.824C65.2809 66.9035 65.4219 66.9433 65.5945 66.9433C65.7655 66.9433 65.9057 66.9035 66.0153 66.824C66.1263 66.7445 66.208 66.632 66.2605 66.4865C66.313 66.341 66.3393 66.1692 66.3393 65.9712C66.3393 65.7747 66.313 65.6051 66.2605 65.4626C66.208 65.3186 66.127 65.2076 66.0175 65.1296C65.908 65.0516 65.7662 65.0126 65.5922 65.0126C65.3357 65.0126 65.1474 65.0973 65.0274 65.2669C64.9089 65.4364 64.8496 65.6712 64.8496 65.9712ZM67.7479 67.2088H67.3721V63.7075H67.7479V67.2088ZM69.3343 66.9478C69.3958 66.9478 69.4588 66.9425 69.5233 66.932C69.5879 66.9215 69.6404 66.9088 69.6809 66.8938V67.184C69.6374 67.2036 69.5766 67.2201 69.4986 67.2336C69.4221 67.2471 69.3471 67.2538 69.2736 67.2538C69.1431 67.2538 69.0246 67.2313 68.918 67.1863C68.8115 67.1398 68.726 67.0618 68.6615 66.9523C68.5985 66.8428 68.567 66.6913 68.567 66.4977V65.0351H68.216V64.8528L68.5693 64.7066L68.7178 64.171H68.9428V64.7426H69.6651V65.0351H68.9428V66.4865C68.9428 66.641 68.978 66.7565 69.0486 66.833C69.1206 66.9095 69.2158 66.9478 69.3343 66.9478ZM70.1242 66.9748C70.1242 66.8698 70.1497 66.7955 70.2007 66.752C70.2517 66.707 70.3139 66.6845 70.3874 66.6845C70.4639 66.6845 70.5284 66.707 70.581 66.752C70.6335 66.7955 70.6597 66.8698 70.6597 66.9748C70.6597 67.0783 70.6335 67.154 70.581 67.2021C70.5284 67.2486 70.4639 67.2718 70.3874 67.2718C70.3139 67.2718 70.2517 67.2486 70.2007 67.2021C70.1497 67.154 70.1242 67.0783 70.1242 66.9748ZM72.3789 67.2538C72.1569 67.2538 71.9611 67.2081 71.7916 67.1165C71.6221 67.025 71.49 66.8855 71.3955 66.698C71.301 66.5105 71.2538 66.2742 71.2538 65.9892C71.2538 65.6907 71.3033 65.4469 71.4023 65.2579C71.5028 65.0673 71.6408 64.9263 71.8163 64.8348C71.9918 64.7433 72.1914 64.6976 72.4149 64.6976C72.5379 64.6976 72.6564 64.7103 72.7704 64.7358C72.8859 64.7598 72.9804 64.7906 73.0539 64.8281L72.9414 65.1409C72.8664 65.1108 72.7794 65.0838 72.6804 65.0598C72.5829 65.0358 72.4914 65.0238 72.4059 65.0238C72.2349 65.0238 72.0923 65.0606 71.9783 65.1341C71.8658 65.2076 71.7811 65.3156 71.7241 65.4581C71.6686 65.6006 71.6408 65.7762 71.6408 65.9847C71.6408 66.1842 71.6678 66.3545 71.7218 66.4955C71.7773 66.6365 71.8591 66.7445 71.9671 66.8195C72.0766 66.893 72.2131 66.9298 72.3766 66.9298C72.5071 66.9298 72.6249 66.9163 72.7299 66.8893C72.8349 66.8608 72.9302 66.8278 73.0157 66.7903V67.1233C72.9332 67.1653 72.8409 67.1976 72.7389 67.2201C72.6384 67.2426 72.5184 67.2538 72.3789 67.2538ZM75.7272 65.9712C75.7272 66.1737 75.7009 66.3545 75.6484 66.5135C75.5959 66.6725 75.5202 66.8068 75.4212 66.9163C75.3222 67.0258 75.2021 67.1098 75.0611 67.1683C74.9216 67.2253 74.7634 67.2538 74.5863 67.2538C74.4213 67.2538 74.2698 67.2253 74.1318 67.1683C73.9953 67.1098 73.8768 67.0258 73.7763 66.9163C73.6773 66.8068 73.6 66.6725 73.5445 66.5135C73.4905 66.3545 73.4635 66.1737 73.4635 65.9712C73.4635 65.7012 73.5092 65.4716 73.6007 65.2826C73.6923 65.0921 73.8228 64.9473 73.9923 64.8483C74.1633 64.7478 74.3666 64.6976 74.6021 64.6976C74.8271 64.6976 75.0236 64.7478 75.1916 64.8483C75.3612 64.9488 75.4924 65.0943 75.5854 65.2849C75.6799 65.4739 75.7272 65.7027 75.7272 65.9712ZM73.8505 65.9712C73.8505 66.1692 73.8768 66.341 73.9293 66.4865C73.9818 66.632 74.0628 66.7445 74.1723 66.824C74.2818 66.9035 74.4228 66.9433 74.5953 66.9433C74.7664 66.9433 74.9066 66.9035 75.0161 66.824C75.1271 66.7445 75.2089 66.632 75.2614 66.4865C75.3139 66.341 75.3402 66.1692 75.3402 65.9712C75.3402 65.7747 75.3139 65.6051 75.2614 65.4626C75.2089 65.3186 75.1279 65.2076 75.0184 65.1296C74.9089 65.0516 74.7671 65.0126 74.5931 65.0126C74.3366 65.0126 74.1483 65.0973 74.0283 65.2669C73.9098 65.4364 73.8505 65.6712 73.8505 65.9712ZM79.0508 64.6976C79.3223 64.6976 79.5271 64.7688 79.6651 64.9113C79.8031 65.0523 79.8721 65.2796 79.8721 65.5931V67.2088H79.5031V65.6111C79.5031 65.4116 79.4596 65.2624 79.3726 65.1634C79.287 65.0628 79.1595 65.0126 78.99 65.0126C78.7515 65.0126 78.5782 65.0816 78.4702 65.2196C78.3622 65.3576 78.3082 65.5609 78.3082 65.8294V67.2088H77.9369V65.6111C77.9369 65.4776 77.9174 65.3666 77.8784 65.2781C77.8409 65.1896 77.7839 65.1236 77.7074 65.0801C77.6324 65.0351 77.5371 65.0126 77.4216 65.0126C77.2581 65.0126 77.1268 65.0463 77.0278 65.1138C76.9288 65.1814 76.8568 65.2819 76.8118 65.4154C76.7683 65.5474 76.7465 65.7102 76.7465 65.9037V67.2088H76.373V64.7426H76.6745L76.7308 65.0913H76.7511C76.8006 65.0058 76.8628 64.9338 76.9378 64.8753C77.0128 64.8168 77.0968 64.7726 77.1898 64.7426C77.2829 64.7126 77.3819 64.6976 77.4869 64.6976C77.6744 64.6976 77.8312 64.7328 77.9572 64.8033C78.0847 64.8723 78.1769 64.9781 78.2339 65.1206H78.2542C78.3352 64.9781 78.4462 64.8723 78.5872 64.8033C78.7282 64.7328 78.8828 64.6976 79.0508 64.6976Z" fill="#020202"/>
                        <path d="M42.3809 59.2178V52.1982L40.8472 52.8176L40.4048 51.3724L42.897 50.0304H44.475V59.2178H42.3809ZM47.6308 57.7136C48.2207 57.1532 48.7368 56.6617 49.1793 56.2389C49.6217 55.8162 50.0002 55.4426 50.3148 55.1182C50.6392 54.7839 50.8997 54.4791 51.0964 54.2038C51.3028 53.9286 51.4503 53.6582 51.5388 53.3928C51.6371 53.1273 51.6863 52.8422 51.6863 52.5374C51.6863 52.39 51.6666 52.2572 51.6273 52.1393C51.5879 52.0213 51.524 51.923 51.4356 51.8443C51.3471 51.7558 51.2291 51.687 51.0816 51.6379C50.944 51.5887 50.7719 51.5641 50.5655 51.5641C50.3787 51.5641 50.2066 51.5838 50.0493 51.6231C49.892 51.6526 49.7446 51.7067 49.6069 51.7853C49.4693 51.864 49.3415 51.9672 49.2235 52.095C49.1252 52.2228 49.0613 52.3211 49.0318 52.39C49.0121 52.4588 49.0072 52.5325 49.017 52.6112L48.9138 52.7439L48.8106 52.6702L47.4096 51.5936C47.6456 51.2102 47.9307 50.8907 48.2649 50.6351C48.5992 50.3794 48.963 50.1877 49.3562 50.0599C49.7593 49.9223 50.1722 49.8535 50.595 49.8535C51.1455 49.8535 51.6469 49.9665 52.0992 50.1926C52.5612 50.4089 52.9299 50.7186 53.2052 51.1217C53.4805 51.515 53.6181 51.982 53.6181 52.5227C53.6181 52.8864 53.5739 53.2256 53.4854 53.5402C53.3969 53.8548 53.2642 54.1596 53.0872 54.4545C52.9201 54.7495 52.7087 55.0543 52.4531 55.3689C52.1975 55.6835 51.8927 56.0177 51.5388 56.3717C51.1947 56.7256 50.8063 57.1188 50.3738 57.5514H52.925C53.0921 57.5514 53.2101 57.5416 53.2789 57.5219C53.3478 57.5023 53.4117 57.4679 53.4706 57.4187H53.6329V57.5514V59.2178H47.6308V57.7136ZM57.762 59.3948C57.182 59.3948 56.6118 59.3063 56.0514 59.1294C55.491 58.9426 55.0535 58.6525 54.7389 58.2593L55.6974 56.7551L55.7712 56.6371L55.9187 56.7256C55.9383 56.7944 55.958 56.8731 55.9776 56.9615C56.0071 57.0402 56.0809 57.1385 56.1988 57.2565C56.3955 57.4138 56.6167 57.5416 56.8625 57.6399C57.1181 57.7284 57.3835 57.7726 57.6588 57.7726C57.9243 57.7726 58.1504 57.7235 58.3372 57.6252C58.524 57.5268 58.6665 57.3892 58.7648 57.2122C58.873 57.0254 58.927 56.8141 58.927 56.5781C58.927 56.3028 58.8828 56.0718 58.7943 55.885C58.7058 55.6982 58.5682 55.5557 58.3814 55.4573C58.1946 55.3492 57.9537 55.2853 57.6588 55.2656C57.3737 55.2361 57.0296 55.246 56.6265 55.2951V53.6729C57.0296 53.6926 57.3688 53.6779 57.6441 53.6287C57.9292 53.5796 58.1553 53.5058 58.3224 53.4075C58.4896 53.2994 58.6075 53.1765 58.6763 53.0388C58.755 52.9012 58.7943 52.7537 58.7943 52.5964C58.7943 52.4293 58.7648 52.2818 58.7058 52.154C58.6567 52.0262 58.583 51.9181 58.4846 51.8296C58.3863 51.7313 58.2634 51.6575 58.116 51.6084C57.9783 51.5592 57.821 51.5346 57.6441 51.5346C57.4474 51.5346 57.2508 51.5641 57.0542 51.6231C56.8575 51.6723 56.6757 51.7509 56.5085 51.8591C56.3414 51.9672 56.1939 52.1048 56.0661 52.272L54.8864 51.0627C55.2501 50.6301 55.6876 50.3205 56.1988 50.1337C56.7199 49.9469 57.2361 49.8535 57.7473 49.8535C58.3175 49.8535 58.8287 49.9616 59.281 50.1779C59.7431 50.3844 60.1068 50.6695 60.3723 51.0332C60.6377 51.397 60.7704 51.8099 60.7704 52.272C60.7704 52.6259 60.6918 52.9405 60.5345 53.2158C60.387 53.4911 60.2002 53.7221 59.9741 53.9089C59.7578 54.0859 59.5464 54.2235 59.34 54.3218C59.5956 54.4103 59.8512 54.5529 60.1068 54.7495C60.3624 54.9363 60.5738 55.187 60.7409 55.5016C60.9179 55.8162 61.0064 56.1947 61.0064 56.6371C61.0064 57.1582 60.8687 57.6301 60.5935 58.0528C60.328 58.4657 59.9544 58.7951 59.4727 59.0409C58.991 59.2768 58.4207 59.3948 57.762 59.3948ZM73.0105 59.2178V57.0943H69.6481V55.767L73.4824 50.0304H74.9718V55.4278H76.1958V57.109H74.9718V59.2178H73.0105ZM71.6537 55.4721H73.0695V53.1716L71.6537 55.4721ZM80.2955 59.3948C79.6073 59.3948 78.9928 59.2768 78.4521 59.0409C77.9114 58.7951 77.5083 58.4166 77.2429 57.9053L78.6438 56.7403L78.7471 56.6519L78.8503 56.7698C78.8503 56.8485 78.865 56.9222 78.8945 56.991C78.924 57.0599 78.9879 57.1582 79.0862 57.286C79.2435 57.4334 79.4205 57.5465 79.6171 57.6252C79.8138 57.7038 80.0202 57.7431 80.2365 57.7431C80.443 57.7431 80.6249 57.7087 80.7822 57.6399C80.9493 57.5613 81.0918 57.4531 81.2098 57.3155C81.3278 57.1778 81.4163 57.0254 81.4753 56.8583C81.5343 56.6813 81.5637 56.4995 81.5637 56.3127C81.5637 56.0865 81.5343 55.8801 81.4753 55.6933C81.4261 55.4967 81.3475 55.3295 81.2393 55.1919C81.1312 55.0444 80.9935 54.9314 80.8264 54.8527C80.6593 54.7642 80.4626 54.72 80.2365 54.72C80.0497 54.72 79.8728 54.7397 79.7056 54.779C79.5385 54.8183 79.3861 54.8871 79.2485 54.9854C79.1207 55.0739 79.0027 55.1919 78.8945 55.3394L77.641 55.0739L77.9802 50.0304H83.0679V51.6526H79.7204L79.6024 53.3633C79.6909 53.3043 79.8039 53.2502 79.9416 53.201C80.0792 53.1519 80.2218 53.1175 80.3692 53.0978C80.5167 53.0683 80.6494 53.0536 80.7674 53.0536C81.1803 53.0536 81.5539 53.1175 81.8882 53.2453C82.2224 53.3731 82.5076 53.5648 82.7435 53.8204C82.9893 54.0662 83.1761 54.3808 83.3039 54.7642C83.4317 55.1477 83.4956 55.5901 83.4956 56.0915C83.4956 56.7698 83.358 57.3597 83.0827 57.8611C82.8074 58.3527 82.4289 58.7312 81.9472 58.9966C81.4753 59.2621 80.9247 59.3948 80.2955 59.3948ZM87.7722 59.3948C87.0841 59.3948 86.4991 59.2129 86.0174 58.8492C85.5356 58.4756 85.1719 57.9594 84.9261 57.3007C84.6803 56.6322 84.5574 55.8604 84.5574 54.9854C84.5574 53.9138 84.7147 52.9995 85.0293 52.2425C85.3439 51.4756 85.7667 50.8858 86.2975 50.4728C86.8383 50.0599 87.4478 49.8535 88.1262 49.8535C88.5489 49.8535 88.9913 49.9272 89.4534 50.0747C89.9253 50.2123 90.3284 50.4532 90.6627 50.7973L89.5861 52.0065L89.4977 52.1098L89.3649 52.0065C89.3551 51.9279 89.3207 51.8689 89.2617 51.8296C89.2027 51.7902 89.1044 51.7313 88.9668 51.6526C88.9078 51.6329 88.8439 51.6182 88.775 51.6084C88.7062 51.5887 88.6374 51.574 88.5686 51.5641C88.4998 51.5543 88.4309 51.5494 88.3621 51.5494C88.2245 51.5494 88.077 51.5641 87.9197 51.5936C87.7722 51.6231 87.6297 51.6821 87.4921 51.7706C87.3544 51.8492 87.2217 51.9672 87.0939 52.1245C86.9759 52.2818 86.8727 52.4883 86.7842 52.7439C86.6957 52.9995 86.6318 53.319 86.5925 53.7024C86.7203 53.5746 86.8678 53.4665 87.0349 53.378C87.2119 53.2895 87.3937 53.2207 87.5805 53.1716C87.7673 53.1224 87.9492 53.0978 88.1262 53.0978C88.5096 53.0978 88.8635 53.1568 89.188 53.2748C89.5124 53.3829 89.7926 53.5599 90.0285 53.8057C90.2743 54.0416 90.4611 54.3513 90.5889 54.7347C90.7266 55.1083 90.7954 55.5606 90.7954 56.0915C90.7954 56.701 90.6676 57.2565 90.412 57.7579C90.1564 58.2593 89.8024 58.6574 89.3502 58.9524C88.8979 59.2473 88.372 59.3948 87.7722 59.3948ZM87.8017 57.7726C87.9689 57.7726 88.1163 57.7284 88.2442 57.6399C88.3818 57.5514 88.4998 57.4334 88.5981 57.286C88.6964 57.1287 88.7701 56.9517 88.8193 56.7551C88.8684 56.5486 88.893 56.3274 88.893 56.0915C88.893 55.8555 88.8635 55.6491 88.8045 55.4721C88.7456 55.2951 88.662 55.1477 88.5538 55.0297C88.4555 54.9117 88.3376 54.8232 88.1999 54.7642C88.0721 54.7052 87.9345 54.6757 87.787 54.6757C87.6592 54.6757 87.5412 54.6954 87.4331 54.7347C87.3249 54.7741 87.2217 54.833 87.1234 54.9117C87.0349 54.9805 86.9464 55.069 86.8579 55.1771C86.7793 55.2755 86.7006 55.3934 86.622 55.5311C86.622 55.9243 86.6515 56.2635 86.7105 56.5486C86.7694 56.8337 86.8481 57.0697 86.9464 57.2565C87.0546 57.4334 87.1775 57.5662 87.3151 57.6546C87.4626 57.7333 87.6248 57.7726 87.8017 57.7726Z" fill="#020202"/>
                        <path d="M40.9996 41.937C41.4241 41.937 41.7339 42.0285 41.9289 42.2115C42.124 42.393 42.2215 42.6436 42.2215 42.9631C42.2215 43.1071 42.1997 43.2451 42.1562 43.3771C42.1127 43.5076 42.0414 43.6239 41.9424 43.7259C41.8449 43.8279 41.7144 43.9089 41.5509 43.9689C41.3874 44.0274 41.1856 44.0567 40.9456 44.0567H40.6463V45.2268H39.9487V41.937H40.9996ZM40.9636 42.5085H40.6463V43.4851H40.8758C41.0063 43.4851 41.1196 43.4679 41.2156 43.4334C41.3116 43.3989 41.3859 43.3449 41.4384 43.2714C41.4909 43.1979 41.5171 43.1034 41.5171 42.9878C41.5171 42.8258 41.4721 42.7058 41.3821 42.6278C41.2921 42.5483 41.1526 42.5085 40.9636 42.5085ZM43.8191 42.6593C44.1566 42.6593 44.4154 42.7328 44.5954 42.8798C44.7755 43.0268 44.8655 43.2504 44.8655 43.5504V45.2268H44.3862L44.2534 44.8848H44.2354C44.1634 44.9748 44.0899 45.0483 44.0149 45.1053C43.9399 45.1623 43.8536 45.2043 43.7561 45.2313C43.6586 45.2583 43.5401 45.2718 43.4006 45.2718C43.2521 45.2718 43.1185 45.2433 43 45.1863C42.883 45.1293 42.7908 45.0423 42.7233 44.9253C42.6558 44.8068 42.622 44.6568 42.622 44.4752C42.622 44.2082 42.7158 44.0117 42.9033 43.8857C43.0908 43.7582 43.3721 43.6877 43.7471 43.6742L44.1837 43.6607V43.5504C44.1837 43.4184 44.1491 43.3216 44.0801 43.2601C44.0111 43.1986 43.9151 43.1679 43.7921 43.1679C43.6706 43.1679 43.5513 43.1851 43.4343 43.2196C43.3173 43.2541 43.2003 43.2976 43.0833 43.3501L42.856 42.8866C42.9895 42.8161 43.1388 42.7606 43.3038 42.7201C43.4703 42.6796 43.6421 42.6593 43.8191 42.6593ZM44.1837 44.0612L43.9181 44.0702C43.6961 44.0762 43.5416 44.1159 43.4546 44.1895C43.3691 44.263 43.3263 44.3597 43.3263 44.4797C43.3263 44.5847 43.3571 44.6598 43.4186 44.7048C43.4801 44.7483 43.5603 44.77 43.6593 44.77C43.8064 44.77 43.9301 44.7265 44.0306 44.6395C44.1326 44.5525 44.1837 44.4287 44.1837 44.2682V44.0612ZM47.3295 44.4797C47.3295 44.6508 47.289 44.7955 47.2079 44.914C47.1284 45.031 47.0092 45.1203 46.8502 45.1818C46.6911 45.2418 46.4931 45.2718 46.2561 45.2718C46.0806 45.2718 45.9298 45.2606 45.8038 45.2381C45.6793 45.2156 45.5533 45.1781 45.4258 45.1255V44.5585C45.5623 44.62 45.7085 44.671 45.8646 44.7115C46.0221 44.7505 46.1601 44.77 46.2786 44.77C46.4121 44.77 46.5074 44.7505 46.5644 44.7115C46.6229 44.671 46.6521 44.6185 46.6521 44.554C46.6521 44.512 46.6401 44.4745 46.6161 44.4415C46.5936 44.407 46.5441 44.3687 46.4676 44.3267C46.3911 44.2832 46.2711 44.227 46.1076 44.158C45.9501 44.0919 45.8203 44.0252 45.7183 43.9577C45.6178 43.8902 45.5428 43.8107 45.4933 43.7192C45.4453 43.6262 45.4213 43.5084 45.4213 43.3659C45.4213 43.1334 45.5113 42.9586 45.6913 42.8416C45.8728 42.7231 46.1151 42.6638 46.4181 42.6638C46.5741 42.6638 46.7226 42.6796 46.8637 42.7111C47.0062 42.7426 47.1524 42.7928 47.3025 42.8618L47.0954 43.3569C46.9709 43.3029 46.8532 43.2586 46.7421 43.2241C46.6326 43.1896 46.5209 43.1724 46.4069 43.1724C46.3064 43.1724 46.2306 43.1859 46.1796 43.2129C46.1286 43.2399 46.1031 43.2811 46.1031 43.3366C46.1031 43.3771 46.1158 43.4131 46.1413 43.4446C46.1683 43.4761 46.2193 43.5114 46.2944 43.5504C46.3709 43.5879 46.4826 43.6367 46.6296 43.6967C46.7722 43.7552 46.8959 43.8167 47.0009 43.8812C47.1059 43.9442 47.1869 44.0229 47.2439 44.1174C47.301 44.2105 47.3295 44.3312 47.3295 44.4797ZM49.6202 44.4797C49.6202 44.6508 49.5797 44.7955 49.4987 44.914C49.4192 45.031 49.2999 45.1203 49.1409 45.1818C48.9819 45.2418 48.7838 45.2718 48.5468 45.2718C48.3713 45.2718 48.2205 45.2606 48.0945 45.2381C47.97 45.2156 47.844 45.1781 47.7165 45.1255V44.5585C47.853 44.62 47.9993 44.671 48.1553 44.7115C48.3128 44.7505 48.4508 44.77 48.5693 44.77C48.7028 44.77 48.7981 44.7505 48.8551 44.7115C48.9136 44.671 48.9429 44.6185 48.9429 44.554C48.9429 44.512 48.9309 44.4745 48.9069 44.4415C48.8844 44.407 48.8349 44.3687 48.7583 44.3267C48.6818 44.2832 48.5618 44.227 48.3983 44.158C48.2408 44.0919 48.111 44.0252 48.009 43.9577C47.9085 43.8902 47.8335 43.8107 47.784 43.7192C47.736 43.6262 47.712 43.5084 47.712 43.3659C47.712 43.1334 47.802 42.9586 47.982 42.8416C48.1635 42.7231 48.4058 42.6638 48.7088 42.6638C48.8649 42.6638 49.0134 42.6796 49.1544 42.7111C49.2969 42.7426 49.4432 42.7928 49.5932 42.8618L49.3862 43.3569C49.2616 43.3029 49.1439 43.2586 49.0329 43.2241C48.9234 43.1896 48.8116 43.1724 48.6976 43.1724C48.5971 43.1724 48.5213 43.1859 48.4703 43.2129C48.4193 43.2399 48.3938 43.2811 48.3938 43.3366C48.3938 43.3771 48.4066 43.4131 48.4321 43.4446C48.4591 43.4761 48.5101 43.5114 48.5851 43.5504C48.6616 43.5879 48.7733 43.6367 48.9204 43.6967C49.0629 43.7552 49.1866 43.8167 49.2916 43.8812C49.3967 43.9442 49.4777 44.0229 49.5347 44.1174C49.5917 44.2105 49.6202 44.3312 49.6202 44.4797ZM50.842 41.7255V42.54C50.842 42.6346 50.839 42.7283 50.833 42.8213C50.8285 42.9143 50.8225 42.9863 50.815 43.0373H50.842C50.9081 42.9338 50.9981 42.8461 51.1121 42.7741C51.2261 42.7006 51.3738 42.6638 51.5554 42.6638C51.8374 42.6638 52.0662 42.7741 52.2417 42.9946C52.4172 43.2151 52.505 43.5384 52.505 43.9644C52.505 44.251 52.4645 44.4917 52.3834 44.6868C52.3024 44.8803 52.1892 45.0265 52.0437 45.1255C51.8982 45.2231 51.7294 45.2718 51.5374 45.2718C51.3528 45.2718 51.2073 45.2388 51.1008 45.1728C50.9943 45.1068 50.9081 45.0325 50.842 44.95H50.7948L50.68 45.2268H50.1557V41.7255H50.842ZM51.3348 43.2129C51.2148 43.2129 51.1196 43.2376 51.0491 43.2871C50.9786 43.3366 50.9268 43.4109 50.8938 43.5099C50.8623 43.6089 50.845 43.7342 50.842 43.8857V43.9599C50.842 44.2045 50.8781 44.392 50.9501 44.5225C51.0221 44.6515 51.1533 44.716 51.3438 44.716C51.4849 44.716 51.5966 44.6508 51.6791 44.5202C51.7631 44.3897 51.8051 44.2015 51.8051 43.9554C51.8051 43.7094 51.7631 43.5241 51.6791 43.3996C51.5951 43.2751 51.4804 43.2129 51.3348 43.2129ZM55.3582 43.9644C55.3582 44.1745 55.3297 44.3605 55.2727 44.5225C55.2172 44.6845 55.1355 44.8218 55.0275 44.9343C54.9209 45.0453 54.7919 45.1293 54.6404 45.1863C54.4904 45.2433 54.3209 45.2718 54.1319 45.2718C53.9549 45.2718 53.7921 45.2433 53.6436 45.1863C53.4966 45.1293 53.3683 45.0453 53.2588 44.9343C53.1508 44.8218 53.0668 44.6845 53.0068 44.5225C52.9483 44.3605 52.919 44.1745 52.919 43.9644C52.919 43.6854 52.9685 43.4491 53.0675 43.2556C53.1665 43.0621 53.3075 42.9151 53.4906 42.8146C53.6736 42.7141 53.8918 42.6638 54.1454 42.6638C54.3809 42.6638 54.5894 42.7141 54.7709 42.8146C54.9539 42.9151 55.0972 43.0621 55.2007 43.2556C55.3057 43.4491 55.3582 43.6854 55.3582 43.9644ZM53.6188 43.9644C53.6188 44.1294 53.6368 44.2682 53.6728 44.3807C53.7088 44.4932 53.7651 44.578 53.8416 44.635C53.9181 44.692 54.0179 44.7205 54.1409 44.7205C54.2624 44.7205 54.3606 44.692 54.4356 44.635C54.5122 44.578 54.5677 44.4932 54.6022 44.3807C54.6382 44.2682 54.6562 44.1294 54.6562 43.9644C54.6562 43.7979 54.6382 43.6599 54.6022 43.5504C54.5677 43.4394 54.5122 43.3561 54.4356 43.3006C54.3591 43.2451 54.2594 43.2174 54.1364 43.2174C53.9549 43.2174 53.8228 43.2796 53.7403 43.4041C53.6593 43.5286 53.6188 43.7154 53.6188 43.9644ZM56.6116 45.2268H55.9253V41.7255H56.6116V45.2268ZM58.3938 44.725C58.4688 44.725 58.5415 44.7175 58.6121 44.7025C58.6841 44.6875 58.7553 44.6688 58.8258 44.6463V45.157C58.7523 45.1901 58.6608 45.2171 58.5513 45.2381C58.4433 45.2606 58.3248 45.2718 58.1958 45.2718C58.0457 45.2718 57.9107 45.2478 57.7907 45.1998C57.6722 45.1503 57.5785 45.0655 57.5094 44.9455C57.4419 44.824 57.4082 44.6553 57.4082 44.4392V43.2264H57.0797V42.9361L57.4577 42.7066L57.6557 42.1755H58.0945V42.7111H58.7988V43.2264H58.0945V44.4392C58.0945 44.5352 58.1215 44.6072 58.1755 44.6553C58.231 44.7018 58.3038 44.725 58.3938 44.725Z" fill="#020202"/>
                        <ellipse cx="123.517" cy="54.2178" rx="9.52153" ry="9.44218" stroke="#020202" stroke-opacity="0.25" stroke-width="1.85141"/>
                        <path d="M123.517 44.7756C124.767 44.7756 126.005 45.0199 127.16 45.4944C128.316 45.9689 129.365 46.6644 130.249 47.5412C131.134 48.418 131.835 49.4589 132.313 50.6045C132.792 51.75 133.038 52.9779 133.038 54.2178" stroke="#020202" stroke-width="1.85141" stroke-linecap="round"/>
                        <path d="M47.5347 73.9548H129.465" stroke="#D6D6D6" stroke-linecap="round"/>
                        <g filter="url(#filter0_f_5_20425)">
                            <path d="M40.8511 111.368C41.1451 111.368 41.3634 111.434 41.5059 111.566C41.6484 111.698 41.7196 111.909 41.7196 112.198V113.875H41.4474L41.3754 113.51H41.3574C41.2884 113.6 41.2163 113.676 41.1413 113.738C41.0663 113.798 40.9793 113.843 40.8803 113.875C40.7828 113.905 40.6628 113.92 40.5203 113.92C40.3703 113.92 40.2368 113.894 40.1197 113.841C40.0042 113.789 39.9127 113.709 39.8452 113.603C39.7792 113.496 39.7462 113.361 39.7462 113.198C39.7462 112.951 39.8437 112.762 40.0387 112.63C40.2338 112.498 40.5308 112.426 40.9298 112.414L41.3551 112.396V112.246C41.3551 112.033 41.3094 111.883 41.2178 111.798C41.1263 111.712 40.9973 111.67 40.8308 111.67C40.7018 111.67 40.5788 111.688 40.4618 111.726C40.3448 111.763 40.2338 111.808 40.1287 111.859L40.014 111.575C40.125 111.518 40.2525 111.469 40.3965 111.429C40.5405 111.388 40.692 111.368 40.8511 111.368ZM41.3506 112.66L40.9748 112.675C40.6673 112.687 40.4505 112.738 40.3245 112.826C40.1985 112.915 40.1355 113.04 40.1355 113.202C40.1355 113.343 40.1782 113.447 40.2638 113.515C40.3493 113.582 40.4625 113.616 40.6035 113.616C40.8226 113.616 41.0018 113.555 41.1413 113.434C41.2809 113.312 41.3506 113.13 41.3506 112.887V112.66ZM43.3668 113.92C43.0548 113.92 42.8073 113.813 42.6242 113.6C42.4427 113.387 42.352 113.071 42.352 112.651C42.352 112.226 42.445 111.906 42.631 111.69C42.817 111.472 43.0645 111.364 43.3736 111.364C43.5041 111.364 43.6181 111.381 43.7156 111.415C43.8131 111.45 43.8971 111.496 43.9676 111.555C44.0381 111.612 44.0974 111.677 44.1454 111.751H44.1724C44.1664 111.704 44.1604 111.64 44.1544 111.559C44.1484 111.478 44.1454 111.412 44.1454 111.361V110.373H44.5189V113.875H44.2174L44.1611 113.524H44.1454C44.0989 113.597 44.0396 113.664 43.9676 113.724C43.8971 113.784 43.8123 113.832 43.7133 113.868C43.6158 113.903 43.5003 113.92 43.3668 113.92ZM43.4253 113.609C43.6893 113.609 43.8761 113.534 43.9856 113.384C44.0951 113.234 44.1499 113.011 44.1499 112.716V112.648C44.1499 112.335 44.0974 112.094 43.9924 111.926C43.8889 111.758 43.6998 111.674 43.4253 111.674C43.1958 111.674 43.024 111.763 42.91 111.94C42.796 112.115 42.739 112.355 42.739 112.66C42.739 112.963 42.7953 113.197 42.9078 113.362C43.0218 113.527 43.1943 113.609 43.4253 113.609ZM46.2336 111.368C46.5276 111.368 46.7459 111.434 46.8884 111.566C47.0309 111.698 47.1022 111.909 47.1022 112.198V113.875H46.8299L46.7579 113.51H46.7399C46.6709 113.6 46.5989 113.676 46.5239 113.738C46.4489 113.798 46.3618 113.843 46.2628 113.875C46.1653 113.905 46.0453 113.92 45.9028 113.92C45.7528 113.92 45.6193 113.894 45.5023 113.841C45.3868 113.789 45.2952 113.709 45.2277 113.603C45.1617 113.496 45.1287 113.361 45.1287 113.198C45.1287 112.951 45.2262 112.762 45.4213 112.63C45.6163 112.498 45.9133 112.426 46.3123 112.414L46.7376 112.396V112.246C46.7376 112.033 46.6919 111.883 46.6004 111.798C46.5089 111.712 46.3798 111.67 46.2133 111.67C46.0843 111.67 45.9613 111.688 45.8443 111.726C45.7273 111.763 45.6163 111.808 45.5113 111.859L45.3965 111.575C45.5075 111.518 45.635 111.469 45.779 111.429C45.9231 111.388 46.0746 111.368 46.2336 111.368ZM46.7331 112.66L46.3573 112.675C46.0498 112.687 45.833 112.738 45.707 112.826C45.581 112.915 45.518 113.04 45.518 113.202C45.518 113.343 45.5608 113.447 45.6463 113.515C45.7318 113.582 45.845 113.616 45.9861 113.616C46.2051 113.616 46.3843 113.555 46.5239 113.434C46.6634 113.312 46.7331 113.13 46.7331 112.887V112.66ZM51.3461 112.232C51.3461 112.375 51.3296 112.514 51.2966 112.651C51.2651 112.786 51.2163 112.908 51.1503 113.017C51.0843 113.125 51.0018 113.212 50.9028 113.276C50.8053 113.341 50.6898 113.373 50.5563 113.373C50.4167 113.373 50.3057 113.333 50.2232 113.252C50.1407 113.17 50.0912 113.074 50.0747 112.963H50.0545C49.9975 113.082 49.9134 113.18 49.8024 113.258C49.6929 113.335 49.5579 113.373 49.3974 113.373C49.1634 113.373 48.9826 113.296 48.8551 113.141C48.7291 112.985 48.6661 112.778 48.6661 112.52C48.6661 112.319 48.7058 112.141 48.7853 111.987C48.8663 111.831 48.9796 111.709 49.1251 111.62C49.2721 111.53 49.4454 111.485 49.6449 111.485C49.7784 111.485 49.9082 111.496 50.0342 111.519C50.1602 111.541 50.2607 111.566 50.3357 111.593L50.2907 112.5C50.2892 112.555 50.2877 112.598 50.2862 112.628C50.2847 112.657 50.284 112.679 50.284 112.696C50.284 112.858 50.3125 112.967 50.3695 113.024C50.428 113.08 50.4985 113.107 50.581 113.107C50.6815 113.107 50.7655 113.068 50.833 112.99C50.902 112.911 50.9545 112.805 50.9905 112.673C51.0266 112.54 51.0446 112.392 51.0446 112.23C51.0446 111.943 50.9868 111.699 50.8713 111.496C50.7558 111.294 50.596 111.139 50.392 111.033C50.1895 110.926 49.9562 110.873 49.6922 110.873C49.4296 110.873 49.1964 110.914 48.9924 110.997C48.7898 111.079 48.6181 111.196 48.4771 111.348C48.3375 111.498 48.2318 111.676 48.1598 111.883C48.0878 112.09 48.0518 112.319 48.0518 112.57C48.0518 112.876 48.1058 113.136 48.2138 113.351C48.3233 113.565 48.4831 113.729 48.6931 113.841C48.9046 113.952 49.1619 114.008 49.4649 114.008C49.6479 114.008 49.8242 113.987 49.9937 113.947C50.1632 113.906 50.3147 113.861 50.4482 113.81V114.102C50.3162 114.158 50.1685 114.203 50.005 114.237C49.8414 114.273 49.6614 114.291 49.4649 114.291C49.1034 114.291 48.7943 114.223 48.5378 114.086C48.2813 113.951 48.0848 113.756 47.9483 113.501C47.8117 113.246 47.7435 112.94 47.7435 112.583C47.7435 112.294 47.7877 112.027 47.8762 111.784C47.9663 111.541 48.0953 111.331 48.2633 111.152C48.4328 110.974 48.6376 110.836 48.8776 110.738C49.1191 110.639 49.3906 110.589 49.6922 110.589C50.0147 110.589 50.2997 110.656 50.5473 110.79C50.7963 110.922 50.9913 111.111 51.1323 111.357C51.2748 111.601 51.3461 111.893 51.3461 112.232ZM49.0014 112.529C49.0014 112.729 49.0411 112.875 49.1206 112.968C49.2001 113.061 49.3104 113.107 49.4514 113.107C49.6254 113.107 49.7529 113.042 49.8339 112.912C49.9164 112.781 49.9637 112.609 49.9757 112.394L50.0027 111.807C49.9592 111.793 49.9059 111.782 49.8429 111.773C49.7814 111.763 49.7169 111.757 49.6494 111.757C49.4949 111.757 49.3696 111.794 49.2736 111.868C49.1791 111.941 49.1101 112.036 49.0666 112.153C49.0231 112.27 49.0014 112.396 49.0014 112.529ZM53.162 111.364C53.4695 111.364 53.7148 111.469 53.8978 111.681C54.0808 111.892 54.1724 112.21 54.1724 112.635C54.1724 112.915 54.1304 113.151 54.0463 113.342C53.9623 113.532 53.8438 113.676 53.6908 113.774C53.5393 113.871 53.36 113.92 53.153 113.92C53.0225 113.92 52.9077 113.903 52.8087 113.868C52.7097 113.834 52.625 113.787 52.5544 113.729C52.4839 113.67 52.4254 113.606 52.3789 113.537H52.3519C52.3564 113.596 52.3617 113.666 52.3677 113.749C52.3752 113.831 52.3789 113.903 52.3789 113.965V114.977H52.0031V111.409H52.3114L52.3609 111.773H52.3789C52.4269 111.698 52.4854 111.63 52.5544 111.568C52.6235 111.505 52.7075 111.456 52.8065 111.42C52.907 111.382 53.0255 111.364 53.162 111.364ZM53.0968 111.679C52.9257 111.679 52.7877 111.712 52.6827 111.778C52.5792 111.844 52.5034 111.943 52.4554 112.075C52.4074 112.205 52.3819 112.369 52.3789 112.567V112.639C52.3789 112.848 52.4014 113.024 52.4464 113.168C52.4929 113.312 52.5687 113.422 52.6737 113.497C52.7802 113.572 52.9227 113.609 53.1013 113.609C53.2543 113.609 53.3818 113.568 53.4838 113.486C53.5858 113.403 53.6616 113.288 53.7111 113.141C53.7621 112.993 53.7876 112.822 53.7876 112.63C53.7876 112.339 53.7306 112.108 53.6166 111.937C53.504 111.765 53.3308 111.679 53.0968 111.679ZM55.7475 111.368C56.0415 111.368 56.2598 111.434 56.4023 111.566C56.5448 111.698 56.6161 111.909 56.6161 112.198V113.875H56.3438L56.2718 113.51H56.2538C56.1848 113.6 56.1128 113.676 56.0378 113.738C55.9628 113.798 55.8758 113.843 55.7768 113.875C55.6793 113.905 55.5592 113.92 55.4167 113.92C55.2667 113.92 55.1332 113.894 55.0162 113.841C54.9007 113.789 54.8092 113.709 54.7417 113.603C54.6757 113.496 54.6427 113.361 54.6427 113.198C54.6427 112.951 54.7402 112.762 54.9352 112.63C55.1302 112.498 55.4272 112.426 55.8263 112.414L56.2516 112.396V112.246C56.2516 112.033 56.2058 111.883 56.1143 111.798C56.0228 111.712 55.8938 111.67 55.7273 111.67C55.5982 111.67 55.4752 111.688 55.3582 111.726C55.2412 111.763 55.1302 111.808 55.0252 111.859L54.9104 111.575C55.0214 111.518 55.149 111.469 55.293 111.429C55.437 111.388 55.5885 111.368 55.7475 111.368ZM56.2471 112.66L55.8713 112.675C55.5637 112.687 55.347 112.738 55.221 112.826C55.0949 112.915 55.0319 113.04 55.0319 113.202C55.0319 113.343 55.0747 113.447 55.1602 113.515C55.2457 113.582 55.359 113.616 55.5 113.616C55.719 113.616 55.8983 113.555 56.0378 113.434C56.1773 113.312 56.2471 113.13 56.2471 112.887V112.66ZM58.9811 113.2C58.9811 113.357 58.9413 113.49 58.8618 113.598C58.7838 113.705 58.6713 113.785 58.5243 113.839C58.3788 113.893 58.2047 113.92 58.0022 113.92C57.8297 113.92 57.6804 113.906 57.5544 113.879C57.4284 113.852 57.3182 113.814 57.2237 113.765V113.42C57.3242 113.47 57.4442 113.515 57.5837 113.555C57.7232 113.596 57.8657 113.616 58.0112 113.616C58.2243 113.616 58.3788 113.582 58.4748 113.513C58.5708 113.444 58.6188 113.35 58.6188 113.231C58.6188 113.164 58.5993 113.104 58.5603 113.053C58.5228 113.001 58.459 112.951 58.369 112.903C58.279 112.853 58.1545 112.799 57.9955 112.741C57.838 112.681 57.7014 112.621 57.5859 112.563C57.4719 112.503 57.3834 112.43 57.3204 112.345C57.2589 112.259 57.2282 112.148 57.2282 112.012C57.2282 111.803 57.3122 111.643 57.4802 111.532C57.6497 111.42 57.8717 111.364 58.1462 111.364C58.2948 111.364 58.4335 111.379 58.5625 111.409C58.693 111.437 58.8146 111.476 58.9271 111.526L58.8011 111.825C58.699 111.781 58.5903 111.745 58.4748 111.715C58.3593 111.685 58.2415 111.67 58.1215 111.67C57.949 111.67 57.8162 111.698 57.7232 111.755C57.6317 111.812 57.5859 111.89 57.5859 111.989C57.5859 112.066 57.6069 112.129 57.6489 112.178C57.6924 112.228 57.7615 112.274 57.856 112.318C57.9505 112.361 58.075 112.412 58.2295 112.471C58.384 112.528 58.5175 112.587 58.63 112.648C58.7426 112.708 58.8288 112.782 58.8888 112.869C58.9503 112.954 58.9811 113.065 58.9811 113.2ZM61.1773 113.2C61.1773 113.357 61.1375 113.49 61.058 113.598C60.98 113.705 60.8675 113.785 60.7205 113.839C60.575 113.893 60.401 113.92 60.1984 113.92C60.0259 113.92 59.8767 113.906 59.7506 113.879C59.6246 113.852 59.5144 113.814 59.4199 113.765V113.42C59.5204 113.47 59.6404 113.515 59.7799 113.555C59.9194 113.596 60.0619 113.616 60.2074 113.616C60.4205 113.616 60.575 113.582 60.671 113.513C60.767 113.444 60.815 113.35 60.815 113.231C60.815 113.164 60.7955 113.104 60.7565 113.053C60.719 113.001 60.6552 112.951 60.5652 112.903C60.4752 112.853 60.3507 112.799 60.1917 112.741C60.0342 112.681 59.8977 112.621 59.7822 112.563C59.6681 112.503 59.5796 112.43 59.5166 112.345C59.4551 112.259 59.4244 112.148 59.4244 112.012C59.4244 111.803 59.5084 111.643 59.6764 111.532C59.8459 111.42 60.0679 111.364 60.3425 111.364C60.491 111.364 60.6297 111.379 60.7587 111.409C60.8893 111.437 61.0108 111.476 61.1233 111.526L60.9973 111.825C60.8953 111.781 60.7865 111.745 60.671 111.715C60.5555 111.685 60.4377 111.67 60.3177 111.67C60.1452 111.67 60.0124 111.698 59.9194 111.755C59.8279 111.812 59.7822 111.89 59.7822 111.989C59.7822 112.066 59.8032 112.129 59.8452 112.178C59.8887 112.228 59.9577 112.274 60.0522 112.318C60.1467 112.361 60.2712 112.412 60.4257 112.471C60.5802 112.528 60.7137 112.587 60.8263 112.648C60.9388 112.708 61.025 112.782 61.085 112.869C61.1465 112.954 61.1773 113.065 61.1773 113.2ZM62.1516 110.373V111.249C62.1516 111.349 62.1486 111.447 62.1426 111.541C62.1381 111.636 62.1344 111.709 62.1314 111.762H62.1516C62.2191 111.651 62.3166 111.557 62.4442 111.481C62.5717 111.404 62.7344 111.366 62.9325 111.366C63.2415 111.366 63.4875 111.473 63.6705 111.688C63.855 111.901 63.9473 112.218 63.9473 112.639C63.9473 112.917 63.9053 113.151 63.8213 113.342C63.7373 113.532 63.6188 113.676 63.4658 113.774C63.3127 113.871 63.132 113.92 62.9235 113.92C62.7284 113.92 62.5679 113.884 62.4419 113.812C62.3174 113.738 62.2214 113.649 62.1539 113.544H62.1246L62.0481 113.875H61.7781V110.373H62.1516ZM62.8717 111.679C62.6932 111.679 62.5514 111.714 62.4464 111.784C62.3414 111.853 62.2656 111.958 62.2191 112.099C62.1741 112.239 62.1516 112.416 62.1516 112.63V112.651C62.1516 112.961 62.2034 113.199 62.3069 113.364C62.4104 113.528 62.5987 113.609 62.8717 113.609C63.1012 113.609 63.273 113.525 63.387 113.357C63.5025 113.189 63.5603 112.949 63.5603 112.637C63.5603 112.319 63.5033 112.08 63.3893 111.919C63.2767 111.759 63.1042 111.679 62.8717 111.679ZM66.7263 112.637C66.7263 112.84 66.7001 113.02 66.6476 113.179C66.5951 113.339 66.5193 113.473 66.4203 113.582C66.3213 113.692 66.2013 113.776 66.0603 113.834C65.9207 113.891 65.7625 113.92 65.5855 113.92C65.4204 113.92 65.2689 113.891 65.1309 113.834C64.9944 113.776 64.8759 113.692 64.7754 113.582C64.6764 113.473 64.5991 113.339 64.5436 113.179C64.4896 113.02 64.4626 112.84 64.4626 112.637C64.4626 112.367 64.5084 112.138 64.5999 111.949C64.6914 111.758 64.8219 111.613 64.9914 111.514C65.1624 111.414 65.3657 111.364 65.6012 111.364C65.8262 111.364 66.0228 111.414 66.1908 111.514C66.3603 111.615 66.4916 111.76 66.5846 111.951C66.6791 112.14 66.7263 112.369 66.7263 112.637ZM64.8496 112.637C64.8496 112.835 64.8759 113.007 64.9284 113.152C64.9809 113.298 65.0619 113.411 65.1714 113.49C65.2809 113.57 65.4219 113.609 65.5945 113.609C65.7655 113.609 65.9057 113.57 66.0153 113.49C66.1263 113.411 66.208 113.298 66.2605 113.152C66.313 113.007 66.3393 112.835 66.3393 112.637C66.3393 112.441 66.313 112.271 66.2605 112.129C66.208 111.985 66.127 111.874 66.0175 111.796C65.908 111.718 65.7662 111.679 65.5922 111.679C65.3357 111.679 65.1474 111.763 65.0274 111.933C64.9089 112.102 64.8496 112.337 64.8496 112.637ZM67.7479 113.875H67.3721V110.373H67.7479V113.875ZM69.3343 113.614C69.3958 113.614 69.4588 113.609 69.5233 113.598C69.5879 113.588 69.6404 113.575 69.6809 113.56V113.85C69.6374 113.87 69.5766 113.886 69.4986 113.9C69.4221 113.913 69.3471 113.92 69.2736 113.92C69.1431 113.92 69.0246 113.897 68.918 113.852C68.8115 113.806 68.726 113.728 68.6615 113.618C68.5985 113.509 68.567 113.357 68.567 113.164V111.701H68.216V111.519L68.5693 111.373L68.7178 110.837H68.9428V111.409H69.6651V111.701H68.9428V113.152C68.9428 113.307 68.978 113.423 69.0486 113.499C69.1206 113.576 69.2158 113.614 69.3343 113.614ZM70.1242 113.641C70.1242 113.536 70.1497 113.462 70.2007 113.418C70.2517 113.373 70.3139 113.351 70.3874 113.351C70.4639 113.351 70.5284 113.373 70.581 113.418C70.6335 113.462 70.6597 113.536 70.6597 113.641C70.6597 113.744 70.6335 113.82 70.581 113.868C70.5284 113.915 70.4639 113.938 70.3874 113.938C70.3139 113.938 70.2517 113.915 70.2007 113.868C70.1497 113.82 70.1242 113.744 70.1242 113.641ZM72.3789 113.92C72.1569 113.92 71.9611 113.874 71.7916 113.783C71.6221 113.691 71.49 113.552 71.3955 113.364C71.301 113.176 71.2538 112.94 71.2538 112.655C71.2538 112.357 71.3033 112.113 71.4023 111.924C71.5028 111.733 71.6408 111.592 71.8163 111.501C71.9918 111.409 72.1914 111.364 72.4149 111.364C72.5379 111.364 72.6564 111.376 72.7704 111.402C72.8859 111.426 72.9804 111.457 73.0539 111.494L72.9414 111.807C72.8664 111.777 72.7794 111.75 72.6804 111.726C72.5829 111.702 72.4914 111.69 72.4059 111.69C72.2349 111.69 72.0923 111.727 71.9783 111.8C71.8658 111.874 71.7811 111.982 71.7241 112.124C71.6686 112.267 71.6408 112.442 71.6408 112.651C71.6408 112.85 71.6678 113.02 71.7218 113.161C71.7773 113.303 71.8591 113.411 71.9671 113.486C72.0766 113.559 72.2131 113.596 72.3766 113.596C72.5071 113.596 72.6249 113.582 72.7299 113.555C72.8349 113.527 72.9302 113.494 73.0157 113.456V113.789C72.9332 113.831 72.8409 113.864 72.7389 113.886C72.6384 113.909 72.5184 113.92 72.3789 113.92ZM75.7272 112.637C75.7272 112.84 75.7009 113.02 75.6484 113.179C75.5959 113.339 75.5202 113.473 75.4212 113.582C75.3222 113.692 75.2021 113.776 75.0611 113.834C74.9216 113.891 74.7634 113.92 74.5863 113.92C74.4213 113.92 74.2698 113.891 74.1318 113.834C73.9953 113.776 73.8768 113.692 73.7763 113.582C73.6773 113.473 73.6 113.339 73.5445 113.179C73.4905 113.02 73.4635 112.84 73.4635 112.637C73.4635 112.367 73.5092 112.138 73.6007 111.949C73.6923 111.758 73.8228 111.613 73.9923 111.514C74.1633 111.414 74.3666 111.364 74.6021 111.364C74.8271 111.364 75.0236 111.414 75.1916 111.514C75.3612 111.615 75.4924 111.76 75.5854 111.951C75.6799 112.14 75.7272 112.369 75.7272 112.637ZM73.8505 112.637C73.8505 112.835 73.8768 113.007 73.9293 113.152C73.9818 113.298 74.0628 113.411 74.1723 113.49C74.2818 113.57 74.4228 113.609 74.5953 113.609C74.7664 113.609 74.9066 113.57 75.0161 113.49C75.1271 113.411 75.2089 113.298 75.2614 113.152C75.3139 113.007 75.3402 112.835 75.3402 112.637C75.3402 112.441 75.3139 112.271 75.2614 112.129C75.2089 111.985 75.1279 111.874 75.0184 111.796C74.9089 111.718 74.7671 111.679 74.5931 111.679C74.3366 111.679 74.1483 111.763 74.0283 111.933C73.9098 112.102 73.8505 112.337 73.8505 112.637ZM79.0508 111.364C79.3223 111.364 79.5271 111.435 79.6651 111.577C79.8031 111.718 79.8721 111.946 79.8721 112.259V113.875H79.5031V112.277C79.5031 112.078 79.4596 111.928 79.3726 111.829C79.287 111.729 79.1595 111.679 78.99 111.679C78.7515 111.679 78.5782 111.748 78.4702 111.886C78.3622 112.024 78.3082 112.227 78.3082 112.495V113.875H77.9369V112.277C77.9369 112.144 77.9174 112.033 77.8784 111.944C77.8409 111.856 77.7839 111.79 77.7074 111.746C77.6324 111.701 77.5371 111.679 77.4216 111.679C77.2581 111.679 77.1268 111.712 77.0278 111.78C76.9288 111.847 76.8568 111.948 76.8118 112.081C76.7683 112.213 76.7465 112.376 76.7465 112.57V113.875H76.373V111.409H76.6745L76.7308 111.757H76.7511C76.8006 111.672 76.8628 111.6 76.9378 111.541C77.0128 111.483 77.0968 111.439 77.1898 111.409C77.2829 111.379 77.3819 111.364 77.4869 111.364C77.6744 111.364 77.8312 111.399 77.9572 111.469C78.0847 111.538 78.1769 111.644 78.2339 111.787H78.2542C78.3352 111.644 78.4462 111.538 78.5872 111.469C78.7282 111.399 78.8828 111.364 79.0508 111.364Z" fill="#020202"/>
                            <path d="M42.3809 105.884V98.8643L40.8472 99.4836L40.4048 98.0384L42.897 96.6964H44.475V105.884H42.3809ZM47.6308 104.38C48.2207 103.819 48.7368 103.328 49.1793 102.905C49.6217 102.482 50.0002 102.109 50.3148 101.784C50.6392 101.45 50.8997 101.145 51.0964 100.87C51.3028 100.595 51.4503 100.324 51.5388 100.059C51.6371 99.7933 51.6863 99.5082 51.6863 99.2034C51.6863 99.056 51.6666 98.9232 51.6273 98.8053C51.5879 98.6873 51.524 98.589 51.4356 98.5103C51.3471 98.4219 51.2291 98.353 51.0816 98.3039C50.944 98.2547 50.7719 98.2301 50.5655 98.2301C50.3787 98.2301 50.2066 98.2498 50.0493 98.2891C49.892 98.3186 49.7446 98.3727 49.6069 98.4513C49.4693 98.53 49.3415 98.6332 49.2235 98.761C49.1252 98.8888 49.0613 98.9872 49.0318 99.056C49.0121 99.1248 49.0072 99.1985 49.017 99.2772L48.9138 99.4099L48.8106 99.3362L47.4096 98.2596C47.6456 97.8762 47.9307 97.5567 48.2649 97.3011C48.5992 97.0455 48.963 96.8537 49.3562 96.7259C49.7593 96.5883 50.1722 96.5195 50.595 96.5195C51.1455 96.5195 51.6469 96.6325 52.0992 96.8587C52.5612 97.075 52.9299 97.3846 53.2052 97.7877C53.4805 98.181 53.6181 98.648 53.6181 99.1887C53.6181 99.5525 53.5739 99.8916 53.4854 100.206C53.3969 100.521 53.2642 100.826 53.0872 101.121C52.9201 101.415 52.7087 101.72 52.4531 102.035C52.1975 102.349 51.8927 102.684 51.5388 103.038C51.1947 103.392 50.8063 103.785 50.3738 104.217H52.925C53.0921 104.217 53.2101 104.208 53.2789 104.188C53.3478 104.168 53.4117 104.134 53.4706 104.085H53.6329V104.217V105.884H47.6308V104.38ZM57.762 106.061C57.182 106.061 56.6118 105.972 56.0514 105.795C55.491 105.609 55.0535 105.319 54.7389 104.925L55.6974 103.421L55.7712 103.303L55.9187 103.392C55.9383 103.46 55.958 103.539 55.9776 103.628C56.0071 103.706 56.0809 103.805 56.1988 103.922C56.3955 104.08 56.6167 104.208 56.8625 104.306C57.1181 104.394 57.3835 104.439 57.6588 104.439C57.9243 104.439 58.1504 104.389 58.3372 104.291C58.524 104.193 58.6665 104.055 58.7648 103.878C58.873 103.691 58.927 103.48 58.927 103.244C58.927 102.969 58.8828 102.738 58.7943 102.551C58.7058 102.364 58.5682 102.222 58.3814 102.123C58.1946 102.015 57.9537 101.951 57.6588 101.932C57.3737 101.902 57.0296 101.912 56.6265 101.961V100.339C57.0296 100.359 57.3688 100.344 57.6441 100.295C57.9292 100.246 58.1553 100.172 58.3224 100.074C58.4896 99.9654 58.6075 99.8425 58.6763 99.7048C58.755 99.5672 58.7943 99.4197 58.7943 99.2624C58.7943 99.0953 58.7648 98.9478 58.7058 98.82C58.6567 98.6922 58.583 98.5841 58.4846 98.4956C58.3863 98.3973 58.2634 98.3235 58.116 98.2744C57.9783 98.2252 57.821 98.2006 57.6441 98.2006C57.4474 98.2006 57.2508 98.2301 57.0542 98.2891C56.8575 98.3383 56.6757 98.4169 56.5085 98.5251C56.3414 98.6332 56.1939 98.7709 56.0661 98.938L54.8864 97.7287C55.2501 97.2962 55.6876 96.9865 56.1988 96.7997C56.7199 96.6129 57.2361 96.5195 57.7473 96.5195C58.3175 96.5195 58.8287 96.6276 59.281 96.8439C59.7431 97.0504 60.1068 97.3355 60.3723 97.6992C60.6377 98.063 60.7704 98.4759 60.7704 98.938C60.7704 99.2919 60.6918 99.6065 60.5345 99.8818C60.387 100.157 60.2002 100.388 59.9741 100.575C59.7578 100.752 59.5464 100.89 59.34 100.988C59.5956 101.076 59.8512 101.219 60.1068 101.415C60.3624 101.602 60.5738 101.853 60.7409 102.168C60.9179 102.482 61.0064 102.861 61.0064 103.303C61.0064 103.824 60.8687 104.296 60.5935 104.719C60.328 105.132 59.9544 105.461 59.4727 105.707C58.991 105.943 58.4207 106.061 57.762 106.061ZM73.0105 105.884V103.76H69.6481V102.433L73.4824 96.6964H74.9718V102.094H76.1958V103.775H74.9718V105.884H73.0105ZM71.6537 102.138H73.0695V99.8376L71.6537 102.138ZM80.2955 106.061C79.6073 106.061 78.9928 105.943 78.4521 105.707C77.9114 105.461 77.5083 105.083 77.2429 104.571L78.6438 103.406L78.7471 103.318L78.8503 103.436C78.8503 103.514 78.865 103.588 78.8945 103.657C78.924 103.726 78.9879 103.824 79.0862 103.952C79.2435 104.099 79.4205 104.213 79.6171 104.291C79.8138 104.37 80.0202 104.409 80.2365 104.409C80.443 104.409 80.6249 104.375 80.7822 104.306C80.9493 104.227 81.0918 104.119 81.2098 103.981C81.3278 103.844 81.4163 103.691 81.4753 103.524C81.5343 103.347 81.5637 103.165 81.5637 102.979C81.5637 102.753 81.5343 102.546 81.4753 102.359C81.4261 102.163 81.3475 101.996 81.2393 101.858C81.1312 101.71 80.9935 101.597 80.8264 101.519C80.6593 101.43 80.4626 101.386 80.2365 101.386C80.0497 101.386 79.8728 101.406 79.7056 101.445C79.5385 101.484 79.3861 101.553 79.2485 101.651C79.1207 101.74 79.0027 101.858 78.8945 102.005L77.641 101.74L77.9802 96.6964H83.0679V98.3186H79.7204L79.6024 100.029C79.6909 99.9703 79.8039 99.9162 79.9416 99.8671C80.0792 99.8179 80.2218 99.7835 80.3692 99.7638C80.5167 99.7343 80.6494 99.7196 80.7674 99.7196C81.1803 99.7196 81.5539 99.7835 81.8882 99.9113C82.2224 100.039 82.5076 100.231 82.7435 100.486C82.9893 100.732 83.1761 101.047 83.3039 101.43C83.4317 101.814 83.4956 102.256 83.4956 102.757C83.4956 103.436 83.358 104.026 83.0827 104.527C82.8074 105.019 82.4289 105.397 81.9472 105.663C81.4753 105.928 80.9247 106.061 80.2955 106.061ZM87.7722 106.061C87.0841 106.061 86.4991 105.879 86.0174 105.515C85.5356 105.142 85.1719 104.625 84.9261 103.967C84.6803 103.298 84.5574 102.526 84.5574 101.651C84.5574 100.58 84.7147 99.6655 85.0293 98.9085C85.3439 98.1417 85.7667 97.5518 86.2975 97.1389C86.8383 96.7259 87.4478 96.5195 88.1262 96.5195C88.5489 96.5195 88.9913 96.5932 89.4534 96.7407C89.9253 96.8783 90.3284 97.1192 90.6627 97.4633L89.5861 98.6726L89.4977 98.7758L89.3649 98.6726C89.3551 98.5939 89.3207 98.5349 89.2617 98.4956C89.2027 98.4563 89.1044 98.3973 88.9668 98.3186C88.9078 98.299 88.8439 98.2842 88.775 98.2744C88.7062 98.2547 88.6374 98.24 88.5686 98.2301C88.4998 98.2203 88.4309 98.2154 88.3621 98.2154C88.2245 98.2154 88.077 98.2301 87.9197 98.2596C87.7722 98.2891 87.6297 98.3481 87.4921 98.4366C87.3544 98.5152 87.2217 98.6332 87.0939 98.7905C86.9759 98.9478 86.8727 99.1543 86.7842 99.4099C86.6957 99.6655 86.6318 99.985 86.5925 100.368C86.7203 100.241 86.8678 100.133 87.0349 100.044C87.2119 99.9555 87.3937 99.8867 87.5805 99.8376C87.7673 99.7884 87.9492 99.7638 88.1262 99.7638C88.5096 99.7638 88.8635 99.8228 89.188 99.9408C89.5124 100.049 89.7926 100.226 90.0285 100.472C90.2743 100.708 90.4611 101.017 90.5889 101.401C90.7266 101.774 90.7954 102.227 90.7954 102.757C90.7954 103.367 90.6676 103.922 90.412 104.424C90.1564 104.925 89.8024 105.323 89.3502 105.618C88.8979 105.913 88.372 106.061 87.7722 106.061ZM87.8017 104.439C87.9689 104.439 88.1163 104.394 88.2442 104.306C88.3818 104.217 88.4998 104.099 88.5981 103.952C88.6964 103.795 88.7701 103.618 88.8193 103.421C88.8684 103.215 88.893 102.993 88.893 102.757C88.893 102.522 88.8635 102.315 88.8045 102.138C88.7456 101.961 88.662 101.814 88.5538 101.696C88.4555 101.578 88.3376 101.489 88.1999 101.43C88.0721 101.371 87.9345 101.342 87.787 101.342C87.6592 101.342 87.5412 101.361 87.4331 101.401C87.3249 101.44 87.2217 101.499 87.1234 101.578C87.0349 101.647 86.9464 101.735 86.8579 101.843C86.7793 101.941 86.7006 102.059 86.622 102.197C86.622 102.59 86.6515 102.93 86.7105 103.215C86.7694 103.5 86.8481 103.736 86.9464 103.922C87.0546 104.099 87.1775 104.232 87.3151 104.321C87.4626 104.399 87.6248 104.439 87.8017 104.439Z" fill="#020202"/>
                            <path d="M40.9996 88.603C41.4241 88.603 41.7339 88.6945 41.9289 88.8775C42.124 89.059 42.2215 89.3096 42.2215 89.6291C42.2215 89.7731 42.1997 89.9111 42.1562 90.0431C42.1127 90.1737 42.0414 90.2899 41.9424 90.3919C41.8449 90.4939 41.7144 90.5749 41.5509 90.6349C41.3874 90.6935 41.1856 90.7227 40.9456 90.7227H40.6463V91.8928H39.9487V88.603H40.9996ZM40.9636 89.1746H40.6463V90.1512H40.8758C41.0063 90.1512 41.1196 90.1339 41.2156 90.0994C41.3116 90.0649 41.3859 90.0109 41.4384 89.9374C41.4909 89.8639 41.5171 89.7694 41.5171 89.6539C41.5171 89.4918 41.4721 89.3718 41.3821 89.2938C41.2921 89.2143 41.1526 89.1746 40.9636 89.1746ZM43.8191 89.3253C44.1566 89.3253 44.4154 89.3988 44.5954 89.5458C44.7755 89.6929 44.8655 89.9164 44.8655 90.2164V91.8928H44.3862L44.2534 91.5508H44.2354C44.1634 91.6408 44.0899 91.7143 44.0149 91.7713C43.9399 91.8283 43.8536 91.8703 43.7561 91.8973C43.6586 91.9243 43.5401 91.9378 43.4006 91.9378C43.2521 91.9378 43.1185 91.9093 43 91.8523C42.883 91.7953 42.7908 91.7083 42.7233 91.5913C42.6558 91.4728 42.622 91.3228 42.622 91.1412C42.622 90.8742 42.7158 90.6777 42.9033 90.5517C43.0908 90.4242 43.3721 90.3537 43.7471 90.3402L44.1837 90.3267V90.2164C44.1837 90.0844 44.1491 89.9876 44.0801 89.9261C44.0111 89.8646 43.9151 89.8339 43.7921 89.8339C43.6706 89.8339 43.5513 89.8511 43.4343 89.8856C43.3173 89.9201 43.2003 89.9636 43.0833 90.0161L42.856 89.5526C42.9895 89.4821 43.1388 89.4266 43.3038 89.3861C43.4703 89.3456 43.6421 89.3253 43.8191 89.3253ZM44.1837 90.7272L43.9181 90.7362C43.6961 90.7422 43.5416 90.782 43.4546 90.8555C43.3691 90.929 43.3263 91.0257 43.3263 91.1457C43.3263 91.2508 43.3571 91.3258 43.4186 91.3708C43.4801 91.4143 43.5603 91.436 43.6593 91.436C43.8064 91.436 43.9301 91.3925 44.0306 91.3055C44.1326 91.2185 44.1837 91.0947 44.1837 90.9342V90.7272ZM47.3295 91.1457C47.3295 91.3168 47.289 91.4615 47.2079 91.58C47.1284 91.6971 47.0092 91.7863 46.8502 91.8478C46.6911 91.9078 46.4931 91.9378 46.2561 91.9378C46.0806 91.9378 45.9298 91.9266 45.8038 91.9041C45.6793 91.8816 45.5533 91.8441 45.4258 91.7916V91.2245C45.5623 91.286 45.7085 91.337 45.8646 91.3775C46.0221 91.4165 46.1601 91.436 46.2786 91.436C46.4121 91.436 46.5074 91.4165 46.5644 91.3775C46.6229 91.337 46.6521 91.2845 46.6521 91.22C46.6521 91.178 46.6401 91.1405 46.6161 91.1075C46.5936 91.073 46.5441 91.0347 46.4676 90.9927C46.3911 90.9492 46.2711 90.893 46.1076 90.824C45.9501 90.758 45.8203 90.6912 45.7183 90.6237C45.6178 90.5562 45.5428 90.4767 45.4933 90.3852C45.4453 90.2922 45.4213 90.1744 45.4213 90.0319C45.4213 89.7994 45.5113 89.6246 45.6913 89.5076C45.8728 89.3891 46.1151 89.3298 46.4181 89.3298C46.5741 89.3298 46.7226 89.3456 46.8637 89.3771C47.0062 89.4086 47.1524 89.4588 47.3025 89.5278L47.0954 90.0229C46.9709 89.9689 46.8532 89.9246 46.7421 89.8901C46.6326 89.8556 46.5209 89.8384 46.4069 89.8384C46.3064 89.8384 46.2306 89.8519 46.1796 89.8789C46.1286 89.9059 46.1031 89.9471 46.1031 90.0026C46.1031 90.0431 46.1158 90.0791 46.1413 90.1106C46.1683 90.1422 46.2193 90.1774 46.2944 90.2164C46.3709 90.2539 46.4826 90.3027 46.6296 90.3627C46.7722 90.4212 46.8959 90.4827 47.0009 90.5472C47.1059 90.6102 47.1869 90.689 47.2439 90.7835C47.301 90.8765 47.3295 90.9972 47.3295 91.1457ZM49.6202 91.1457C49.6202 91.3168 49.5797 91.4615 49.4987 91.58C49.4192 91.6971 49.2999 91.7863 49.1409 91.8478C48.9819 91.9078 48.7838 91.9378 48.5468 91.9378C48.3713 91.9378 48.2205 91.9266 48.0945 91.9041C47.97 91.8816 47.844 91.8441 47.7165 91.7916V91.2245C47.853 91.286 47.9993 91.337 48.1553 91.3775C48.3128 91.4165 48.4508 91.436 48.5693 91.436C48.7028 91.436 48.7981 91.4165 48.8551 91.3775C48.9136 91.337 48.9429 91.2845 48.9429 91.22C48.9429 91.178 48.9309 91.1405 48.9069 91.1075C48.8844 91.073 48.8349 91.0347 48.7583 90.9927C48.6818 90.9492 48.5618 90.893 48.3983 90.824C48.2408 90.758 48.111 90.6912 48.009 90.6237C47.9085 90.5562 47.8335 90.4767 47.784 90.3852C47.736 90.2922 47.712 90.1744 47.712 90.0319C47.712 89.7994 47.802 89.6246 47.982 89.5076C48.1635 89.3891 48.4058 89.3298 48.7088 89.3298C48.8649 89.3298 49.0134 89.3456 49.1544 89.3771C49.2969 89.4086 49.4432 89.4588 49.5932 89.5278L49.3862 90.0229C49.2616 89.9689 49.1439 89.9246 49.0329 89.8901C48.9234 89.8556 48.8116 89.8384 48.6976 89.8384C48.5971 89.8384 48.5213 89.8519 48.4703 89.8789C48.4193 89.9059 48.3938 89.9471 48.3938 90.0026C48.3938 90.0431 48.4066 90.0791 48.4321 90.1106C48.4591 90.1422 48.5101 90.1774 48.5851 90.2164C48.6616 90.2539 48.7733 90.3027 48.9204 90.3627C49.0629 90.4212 49.1866 90.4827 49.2916 90.5472C49.3967 90.6102 49.4777 90.689 49.5347 90.7835C49.5917 90.8765 49.6202 90.9972 49.6202 91.1457ZM50.842 88.3915V89.2061C50.842 89.3006 50.839 89.3943 50.833 89.4873C50.8285 89.5803 50.8225 89.6524 50.815 89.7034H50.842C50.9081 89.5998 50.9981 89.5121 51.1121 89.4401C51.2261 89.3666 51.3738 89.3298 51.5554 89.3298C51.8374 89.3298 52.0662 89.4401 52.2417 89.6606C52.4172 89.8811 52.505 90.2044 52.505 90.6304C52.505 90.917 52.4645 91.1578 52.3834 91.3528C52.3024 91.5463 52.1892 91.6926 52.0437 91.7916C51.8982 91.8891 51.7294 91.9378 51.5374 91.9378C51.3528 91.9378 51.2073 91.9048 51.1008 91.8388C50.9943 91.7728 50.9081 91.6986 50.842 91.616H50.7948L50.68 91.8928H50.1557V88.3915H50.842ZM51.3348 89.8789C51.2148 89.8789 51.1196 89.9036 51.0491 89.9531C50.9786 90.0026 50.9268 90.0769 50.8938 90.1759C50.8623 90.2749 50.845 90.4002 50.842 90.5517V90.6259C50.842 90.8705 50.8781 91.058 50.9501 91.1885C51.0221 91.3175 51.1533 91.382 51.3438 91.382C51.4849 91.382 51.5966 91.3168 51.6791 91.1863C51.7631 91.0557 51.8051 90.8675 51.8051 90.6214C51.8051 90.3754 51.7631 90.1902 51.6791 90.0656C51.5951 89.9411 51.4804 89.8789 51.3348 89.8789ZM55.3582 90.6304C55.3582 90.8405 55.3297 91.0265 55.2727 91.1885C55.2172 91.3505 55.1355 91.4878 55.0275 91.6003C54.9209 91.7113 54.7919 91.7953 54.6404 91.8523C54.4904 91.9093 54.3209 91.9378 54.1319 91.9378C53.9549 91.9378 53.7921 91.9093 53.6436 91.8523C53.4966 91.7953 53.3683 91.7113 53.2588 91.6003C53.1508 91.4878 53.0668 91.3505 53.0068 91.1885C52.9483 91.0265 52.919 90.8405 52.919 90.6304C52.919 90.3514 52.9685 90.1151 53.0675 89.9216C53.1665 89.7281 53.3075 89.5811 53.4906 89.4806C53.6736 89.3801 53.8918 89.3298 54.1454 89.3298C54.3809 89.3298 54.5894 89.3801 54.7709 89.4806C54.9539 89.5811 55.0972 89.7281 55.2007 89.9216C55.3057 90.1151 55.3582 90.3514 55.3582 90.6304ZM53.6188 90.6304C53.6188 90.7955 53.6368 90.9342 53.6728 91.0467C53.7088 91.1593 53.7651 91.244 53.8416 91.301C53.9181 91.358 54.0179 91.3865 54.1409 91.3865C54.2624 91.3865 54.3606 91.358 54.4356 91.301C54.5122 91.244 54.5677 91.1593 54.6022 91.0467C54.6382 90.9342 54.6562 90.7955 54.6562 90.6304C54.6562 90.4639 54.6382 90.3259 54.6022 90.2164C54.5677 90.1054 54.5122 90.0221 54.4356 89.9666C54.3591 89.9111 54.2594 89.8834 54.1364 89.8834C53.9549 89.8834 53.8228 89.9456 53.7403 90.0701C53.6593 90.1947 53.6188 90.3814 53.6188 90.6304ZM56.6116 91.8928H55.9253V88.3915H56.6116V91.8928ZM58.3938 91.391C58.4688 91.391 58.5415 91.3835 58.6121 91.3685C58.6841 91.3535 58.7553 91.3348 58.8258 91.3123V91.8231C58.7523 91.8561 58.6608 91.8831 58.5513 91.9041C58.4433 91.9266 58.3248 91.9378 58.1958 91.9378C58.0457 91.9378 57.9107 91.9138 57.7907 91.8658C57.6722 91.8163 57.5785 91.7316 57.5094 91.6115C57.4419 91.49 57.4082 91.3213 57.4082 91.1052V89.8924H57.0797V89.6021L57.4577 89.3726L57.6557 88.8415H58.0945V89.3771H58.7988V89.8924H58.0945V91.1052C58.0945 91.2013 58.1215 91.2733 58.1755 91.3213C58.231 91.3678 58.3038 91.391 58.3938 91.391Z" fill="#020202"/>
                            <ellipse cx="123.517" cy="100.884" rx="9.52153" ry="9.44218" stroke="#020202" stroke-opacity="0.25" stroke-width="1.85141"/>
                            <path d="M123.517 91.4417C124.767 91.4417 126.005 91.6859 127.16 92.1604C128.316 92.6349 129.365 93.3304 130.249 94.2072C131.134 95.084 131.835 96.1249 132.313 97.2705C132.792 98.416 133.038 99.6439 133.038 100.884" stroke="#020202" stroke-width="1.85141" stroke-linecap="round"/>
                            <path d="M47.5347 120.621H129.465" stroke="#D6D6D6" stroke-linecap="round"/>
                        </g>
                        <g filter="url(#filter1_f_5_20425)">
                            <path d="M40.8511 158.034C41.1451 158.034 41.3634 158.1 41.5059 158.232C41.6484 158.364 41.7196 158.575 41.7196 158.864V160.541H41.4474L41.3754 160.176H41.3574C41.2884 160.266 41.2163 160.342 41.1413 160.404C41.0663 160.464 40.9793 160.509 40.8803 160.541C40.7828 160.571 40.6628 160.586 40.5203 160.586C40.3703 160.586 40.2368 160.56 40.1197 160.507C40.0042 160.455 39.9127 160.375 39.8452 160.268C39.7792 160.162 39.7462 160.027 39.7462 159.863C39.7462 159.617 39.8437 159.428 40.0387 159.296C40.2338 159.164 40.5308 159.092 40.9298 159.08L41.3551 159.062V158.912C41.3551 158.699 41.3094 158.549 41.2178 158.464C41.1263 158.378 40.9973 158.336 40.8308 158.336C40.7018 158.336 40.5788 158.354 40.4618 158.392C40.3448 158.429 40.2338 158.474 40.1287 158.525L40.014 158.241C40.125 158.184 40.2525 158.135 40.3965 158.095C40.5405 158.054 40.692 158.034 40.8511 158.034ZM41.3506 159.326L40.9748 159.341C40.6673 159.353 40.4505 159.404 40.3245 159.492C40.1985 159.581 40.1355 159.706 40.1355 159.868C40.1355 160.009 40.1782 160.113 40.2638 160.181C40.3493 160.248 40.4625 160.282 40.6035 160.282C40.8226 160.282 41.0018 160.221 41.1413 160.1C41.2809 159.978 41.3506 159.796 41.3506 159.553V159.326ZM43.3668 160.586C43.0548 160.586 42.8073 160.479 42.6242 160.266C42.4427 160.053 42.352 159.737 42.352 159.317C42.352 158.892 42.445 158.572 42.631 158.356C42.817 158.138 43.0645 158.03 43.3736 158.03C43.5041 158.03 43.6181 158.047 43.7156 158.081C43.8131 158.116 43.8971 158.162 43.9676 158.221C44.0381 158.278 44.0974 158.343 44.1454 158.417H44.1724C44.1664 158.37 44.1604 158.306 44.1544 158.225C44.1484 158.144 44.1454 158.078 44.1454 158.027V157.039H44.5189V160.541H44.2174L44.1611 160.19H44.1454C44.0989 160.263 44.0396 160.33 43.9676 160.39C43.8971 160.45 43.8123 160.498 43.7133 160.534C43.6158 160.569 43.5003 160.586 43.3668 160.586ZM43.4253 160.275C43.6893 160.275 43.8761 160.2 43.9856 160.05C44.0951 159.9 44.1499 159.677 44.1499 159.382V159.314C44.1499 159.001 44.0974 158.76 43.9924 158.592C43.8889 158.424 43.6998 158.34 43.4253 158.34C43.1958 158.34 43.024 158.429 42.91 158.606C42.796 158.781 42.739 159.021 42.739 159.326C42.739 159.629 42.7953 159.863 42.9078 160.028C43.0218 160.193 43.1943 160.275 43.4253 160.275ZM46.2336 158.034C46.5276 158.034 46.7459 158.1 46.8884 158.232C47.0309 158.364 47.1022 158.575 47.1022 158.864V160.541H46.8299L46.7579 160.176H46.7399C46.6709 160.266 46.5989 160.342 46.5239 160.404C46.4489 160.464 46.3618 160.509 46.2628 160.541C46.1653 160.571 46.0453 160.586 45.9028 160.586C45.7528 160.586 45.6193 160.56 45.5023 160.507C45.3868 160.455 45.2952 160.375 45.2277 160.268C45.1617 160.162 45.1287 160.027 45.1287 159.863C45.1287 159.617 45.2262 159.428 45.4213 159.296C45.6163 159.164 45.9133 159.092 46.3123 159.08L46.7376 159.062V158.912C46.7376 158.699 46.6919 158.549 46.6004 158.464C46.5089 158.378 46.3798 158.336 46.2133 158.336C46.0843 158.336 45.9613 158.354 45.8443 158.392C45.7273 158.429 45.6163 158.474 45.5113 158.525L45.3965 158.241C45.5075 158.184 45.635 158.135 45.779 158.095C45.9231 158.054 46.0746 158.034 46.2336 158.034ZM46.7331 159.326L46.3573 159.341C46.0498 159.353 45.833 159.404 45.707 159.492C45.581 159.581 45.518 159.706 45.518 159.868C45.518 160.009 45.5608 160.113 45.6463 160.181C45.7318 160.248 45.845 160.282 45.9861 160.282C46.2051 160.282 46.3843 160.221 46.5239 160.1C46.6634 159.978 46.7331 159.796 46.7331 159.553V159.326ZM51.3461 158.898C51.3461 159.041 51.3296 159.18 51.2966 159.317C51.2651 159.452 51.2163 159.574 51.1503 159.683C51.0843 159.791 51.0018 159.878 50.9028 159.942C50.8053 160.007 50.6898 160.039 50.5563 160.039C50.4167 160.039 50.3057 159.998 50.2232 159.917C50.1407 159.836 50.0912 159.74 50.0747 159.629H50.0545C49.9975 159.748 49.9134 159.846 49.8024 159.924C49.6929 160.001 49.5579 160.039 49.3974 160.039C49.1634 160.039 48.9826 159.962 48.8551 159.807C48.7291 159.651 48.6661 159.444 48.6661 159.186C48.6661 158.985 48.7058 158.807 48.7853 158.653C48.8663 158.497 48.9796 158.375 49.1251 158.286C49.2721 158.196 49.4454 158.151 49.6449 158.151C49.7784 158.151 49.9082 158.162 50.0342 158.185C50.1602 158.207 50.2607 158.232 50.3357 158.259L50.2907 159.166C50.2892 159.221 50.2877 159.264 50.2862 159.294C50.2847 159.323 50.284 159.345 50.284 159.362C50.284 159.524 50.3125 159.633 50.3695 159.69C50.428 159.746 50.4985 159.773 50.581 159.773C50.6815 159.773 50.7655 159.734 50.833 159.656C50.902 159.577 50.9545 159.471 50.9905 159.339C51.0266 159.206 51.0446 159.058 51.0446 158.896C51.0446 158.609 50.9868 158.365 50.8713 158.162C50.7558 157.96 50.596 157.805 50.392 157.699C50.1895 157.592 49.9562 157.539 49.6922 157.539C49.4296 157.539 49.1964 157.58 48.9924 157.663C48.7898 157.745 48.6181 157.862 48.4771 158.014C48.3375 158.164 48.2318 158.342 48.1598 158.549C48.0878 158.756 48.0518 158.985 48.0518 159.236C48.0518 159.542 48.1058 159.802 48.2138 160.016C48.3233 160.231 48.4831 160.395 48.6931 160.507C48.9046 160.618 49.1619 160.674 49.4649 160.674C49.6479 160.674 49.8242 160.653 49.9937 160.613C50.1632 160.572 50.3147 160.527 50.4482 160.476V160.768C50.3162 160.824 50.1685 160.869 50.005 160.903C49.8414 160.939 49.6614 160.957 49.4649 160.957C49.1034 160.957 48.7943 160.889 48.5378 160.752C48.2813 160.617 48.0848 160.422 47.9483 160.167C47.8117 159.912 47.7435 159.606 47.7435 159.249C47.7435 158.96 47.7877 158.693 47.8762 158.45C47.9663 158.207 48.0953 157.997 48.2633 157.818C48.4328 157.639 48.6376 157.501 48.8776 157.404C49.1191 157.305 49.3906 157.255 49.6922 157.255C50.0147 157.255 50.2997 157.322 50.5473 157.456C50.7963 157.588 50.9913 157.777 51.1323 158.023C51.2748 158.267 51.3461 158.559 51.3461 158.898ZM49.0014 159.195C49.0014 159.395 49.0411 159.541 49.1206 159.634C49.2001 159.727 49.3104 159.773 49.4514 159.773C49.6254 159.773 49.7529 159.708 49.8339 159.578C49.9164 159.447 49.9637 159.275 49.9757 159.06L50.0027 158.473C49.9592 158.459 49.9059 158.448 49.8429 158.439C49.7814 158.429 49.7169 158.423 49.6494 158.423C49.4949 158.423 49.3696 158.46 49.2736 158.534C49.1791 158.607 49.1101 158.702 49.0666 158.819C49.0231 158.936 49.0014 159.062 49.0014 159.195ZM53.162 158.03C53.4695 158.03 53.7148 158.135 53.8978 158.347C54.0808 158.558 54.1724 158.876 54.1724 159.301C54.1724 159.581 54.1304 159.817 54.0463 160.007C53.9623 160.198 53.8438 160.342 53.6908 160.44C53.5393 160.537 53.36 160.586 53.153 160.586C53.0225 160.586 52.9077 160.569 52.8087 160.534C52.7097 160.5 52.625 160.453 52.5544 160.395C52.4839 160.336 52.4254 160.272 52.3789 160.203H52.3519C52.3564 160.262 52.3617 160.332 52.3677 160.415C52.3752 160.497 52.3789 160.569 52.3789 160.631V161.643H52.0031V158.075H52.3114L52.3609 158.439H52.3789C52.4269 158.364 52.4854 158.296 52.5544 158.234C52.6235 158.171 52.7075 158.122 52.8065 158.086C52.907 158.048 53.0255 158.03 53.162 158.03ZM53.0968 158.345C52.9257 158.345 52.7877 158.378 52.6827 158.444C52.5792 158.51 52.5034 158.609 52.4554 158.741C52.4074 158.871 52.3819 159.035 52.3789 159.233V159.305C52.3789 159.514 52.4014 159.69 52.4464 159.834C52.4929 159.978 52.5687 160.088 52.6737 160.163C52.7802 160.238 52.9227 160.275 53.1013 160.275C53.2543 160.275 53.3818 160.234 53.4838 160.151C53.5858 160.069 53.6616 159.954 53.7111 159.807C53.7621 159.659 53.7876 159.488 53.7876 159.296C53.7876 159.005 53.7306 158.774 53.6166 158.603C53.504 158.431 53.3308 158.345 53.0968 158.345ZM55.7475 158.034C56.0415 158.034 56.2598 158.1 56.4023 158.232C56.5448 158.364 56.6161 158.575 56.6161 158.864V160.541H56.3438L56.2718 160.176H56.2538C56.1848 160.266 56.1128 160.342 56.0378 160.404C55.9628 160.464 55.8758 160.509 55.7768 160.541C55.6793 160.571 55.5592 160.586 55.4167 160.586C55.2667 160.586 55.1332 160.56 55.0162 160.507C54.9007 160.455 54.8092 160.375 54.7417 160.268C54.6757 160.162 54.6427 160.027 54.6427 159.863C54.6427 159.617 54.7402 159.428 54.9352 159.296C55.1302 159.164 55.4272 159.092 55.8263 159.08L56.2516 159.062V158.912C56.2516 158.699 56.2058 158.549 56.1143 158.464C56.0228 158.378 55.8938 158.336 55.7273 158.336C55.5982 158.336 55.4752 158.354 55.3582 158.392C55.2412 158.429 55.1302 158.474 55.0252 158.525L54.9104 158.241C55.0214 158.184 55.149 158.135 55.293 158.095C55.437 158.054 55.5885 158.034 55.7475 158.034ZM56.2471 159.326L55.8713 159.341C55.5637 159.353 55.347 159.404 55.221 159.492C55.0949 159.581 55.0319 159.706 55.0319 159.868C55.0319 160.009 55.0747 160.113 55.1602 160.181C55.2457 160.248 55.359 160.282 55.5 160.282C55.719 160.282 55.8983 160.221 56.0378 160.1C56.1773 159.978 56.2471 159.796 56.2471 159.553V159.326ZM58.9811 159.866C58.9811 160.023 58.9413 160.156 58.8618 160.264C58.7838 160.371 58.6713 160.451 58.5243 160.505C58.3788 160.559 58.2047 160.586 58.0022 160.586C57.8297 160.586 57.6804 160.572 57.5544 160.545C57.4284 160.518 57.3182 160.48 57.2237 160.431V160.086C57.3242 160.136 57.4442 160.181 57.5837 160.221C57.7232 160.262 57.8657 160.282 58.0112 160.282C58.2243 160.282 58.3788 160.247 58.4748 160.178C58.5708 160.109 58.6188 160.016 58.6188 159.897C58.6188 159.83 58.5993 159.77 58.5603 159.719C58.5228 159.667 58.459 159.617 58.369 159.569C58.279 159.519 58.1545 159.465 57.9955 159.407C57.838 159.347 57.7014 159.287 57.5859 159.229C57.4719 159.169 57.3834 159.096 57.3204 159.011C57.2589 158.925 57.2282 158.814 57.2282 158.678C57.2282 158.469 57.3122 158.309 57.4802 158.198C57.6497 158.086 57.8717 158.03 58.1462 158.03C58.2948 158.03 58.4335 158.045 58.5625 158.075C58.693 158.103 58.8146 158.142 58.9271 158.192L58.8011 158.491C58.699 158.447 58.5903 158.411 58.4748 158.381C58.3593 158.351 58.2415 158.336 58.1215 158.336C57.949 158.336 57.8162 158.364 57.7232 158.421C57.6317 158.478 57.5859 158.556 57.5859 158.655C57.5859 158.732 57.6069 158.795 57.6489 158.844C57.6924 158.894 57.7615 158.94 57.856 158.984C57.9505 159.027 58.075 159.078 58.2295 159.137C58.384 159.194 58.5175 159.253 58.63 159.314C58.7426 159.374 58.8288 159.448 58.8888 159.535C58.9503 159.62 58.9811 159.731 58.9811 159.866ZM61.1773 159.866C61.1773 160.023 61.1375 160.156 61.058 160.264C60.98 160.371 60.8675 160.451 60.7205 160.505C60.575 160.559 60.401 160.586 60.1984 160.586C60.0259 160.586 59.8767 160.572 59.7506 160.545C59.6246 160.518 59.5144 160.48 59.4199 160.431V160.086C59.5204 160.136 59.6404 160.181 59.7799 160.221C59.9194 160.262 60.0619 160.282 60.2074 160.282C60.4205 160.282 60.575 160.247 60.671 160.178C60.767 160.109 60.815 160.016 60.815 159.897C60.815 159.83 60.7955 159.77 60.7565 159.719C60.719 159.667 60.6552 159.617 60.5652 159.569C60.4752 159.519 60.3507 159.465 60.1917 159.407C60.0342 159.347 59.8977 159.287 59.7822 159.229C59.6681 159.169 59.5796 159.096 59.5166 159.011C59.4551 158.925 59.4244 158.814 59.4244 158.678C59.4244 158.469 59.5084 158.309 59.6764 158.198C59.8459 158.086 60.0679 158.03 60.3425 158.03C60.491 158.03 60.6297 158.045 60.7587 158.075C60.8893 158.103 61.0108 158.142 61.1233 158.192L60.9973 158.491C60.8953 158.447 60.7865 158.411 60.671 158.381C60.5555 158.351 60.4377 158.336 60.3177 158.336C60.1452 158.336 60.0124 158.364 59.9194 158.421C59.8279 158.478 59.7822 158.556 59.7822 158.655C59.7822 158.732 59.8032 158.795 59.8452 158.844C59.8887 158.894 59.9577 158.94 60.0522 158.984C60.1467 159.027 60.2712 159.078 60.4257 159.137C60.5802 159.194 60.7137 159.253 60.8263 159.314C60.9388 159.374 61.025 159.448 61.085 159.535C61.1465 159.62 61.1773 159.731 61.1773 159.866ZM62.1516 157.039V157.915C62.1516 158.015 62.1486 158.113 62.1426 158.207C62.1381 158.302 62.1344 158.375 62.1314 158.428H62.1516C62.2191 158.317 62.3166 158.223 62.4442 158.147C62.5717 158.07 62.7344 158.032 62.9325 158.032C63.2415 158.032 63.4875 158.139 63.6705 158.354C63.855 158.567 63.9473 158.884 63.9473 159.305C63.9473 159.583 63.9053 159.817 63.8213 160.007C63.7373 160.198 63.6188 160.342 63.4658 160.44C63.3127 160.537 63.132 160.586 62.9235 160.586C62.7284 160.586 62.5679 160.55 62.4419 160.478C62.3174 160.404 62.2214 160.315 62.1539 160.21H62.1246L62.0481 160.541H61.7781V157.039H62.1516ZM62.8717 158.345C62.6932 158.345 62.5514 158.38 62.4464 158.45C62.3414 158.519 62.2656 158.624 62.2191 158.765C62.1741 158.905 62.1516 159.082 62.1516 159.296V159.317C62.1516 159.627 62.2034 159.865 62.3069 160.03C62.4104 160.193 62.5987 160.275 62.8717 160.275C63.1012 160.275 63.273 160.191 63.387 160.023C63.5025 159.855 63.5603 159.615 63.5603 159.303C63.5603 158.985 63.5033 158.746 63.3893 158.585C63.2767 158.425 63.1042 158.345 62.8717 158.345ZM66.7263 159.303C66.7263 159.506 66.7001 159.686 66.6476 159.845C66.5951 160.004 66.5193 160.139 66.4203 160.248C66.3213 160.358 66.2013 160.442 66.0603 160.5C65.9207 160.557 65.7625 160.586 65.5855 160.586C65.4204 160.586 65.2689 160.557 65.1309 160.5C64.9944 160.442 64.8759 160.358 64.7754 160.248C64.6764 160.139 64.5991 160.004 64.5436 159.845C64.4896 159.686 64.4626 159.506 64.4626 159.303C64.4626 159.033 64.5084 158.804 64.5999 158.615C64.6914 158.424 64.8219 158.279 64.9914 158.18C65.1624 158.08 65.3657 158.03 65.6012 158.03C65.8262 158.03 66.0228 158.08 66.1908 158.18C66.3603 158.281 66.4916 158.426 66.5846 158.617C66.6791 158.806 66.7263 159.035 66.7263 159.303ZM64.8496 159.303C64.8496 159.501 64.8759 159.673 64.9284 159.818C64.9809 159.964 65.0619 160.076 65.1714 160.156C65.2809 160.235 65.4219 160.275 65.5945 160.275C65.7655 160.275 65.9057 160.235 66.0153 160.156C66.1263 160.076 66.208 159.964 66.2605 159.818C66.313 159.673 66.3393 159.501 66.3393 159.303C66.3393 159.107 66.313 158.937 66.2605 158.795C66.208 158.651 66.127 158.54 66.0175 158.462C65.908 158.384 65.7662 158.345 65.5922 158.345C65.3357 158.345 65.1474 158.429 65.0274 158.599C64.9089 158.768 64.8496 159.003 64.8496 159.303ZM67.7479 160.541H67.3721V157.039H67.7479V160.541ZM69.3343 160.28C69.3958 160.28 69.4588 160.274 69.5233 160.264C69.5879 160.253 69.6404 160.241 69.6809 160.226V160.516C69.6374 160.536 69.5766 160.552 69.4986 160.566C69.4221 160.579 69.3471 160.586 69.2736 160.586C69.1431 160.586 69.0246 160.563 68.918 160.518C68.8115 160.472 68.726 160.394 68.6615 160.284C68.5985 160.175 68.567 160.023 68.567 159.83V158.367H68.216V158.185L68.5693 158.039L68.7178 157.503H68.9428V158.075H69.6651V158.367H68.9428V159.818C68.9428 159.973 68.978 160.088 69.0486 160.165C69.1206 160.241 69.2158 160.28 69.3343 160.28ZM70.1242 160.307C70.1242 160.202 70.1497 160.127 70.2007 160.084C70.2517 160.039 70.3139 160.016 70.3874 160.016C70.4639 160.016 70.5284 160.039 70.581 160.084C70.6335 160.127 70.6597 160.202 70.6597 160.307C70.6597 160.41 70.6335 160.486 70.581 160.534C70.5284 160.581 70.4639 160.604 70.3874 160.604C70.3139 160.604 70.2517 160.581 70.2007 160.534C70.1497 160.486 70.1242 160.41 70.1242 160.307ZM72.3789 160.586C72.1569 160.586 71.9611 160.54 71.7916 160.449C71.6221 160.357 71.49 160.217 71.3955 160.03C71.301 159.842 71.2538 159.606 71.2538 159.321C71.2538 159.023 71.3033 158.779 71.4023 158.59C71.5028 158.399 71.6408 158.258 71.8163 158.167C71.9918 158.075 72.1914 158.03 72.4149 158.03C72.5379 158.03 72.6564 158.042 72.7704 158.068C72.8859 158.092 72.9804 158.123 73.0539 158.16L72.9414 158.473C72.8664 158.443 72.7794 158.416 72.6804 158.392C72.5829 158.368 72.4914 158.356 72.4059 158.356C72.2349 158.356 72.0923 158.393 71.9783 158.466C71.8658 158.54 71.7811 158.648 71.7241 158.79C71.6686 158.933 71.6408 159.108 71.6408 159.317C71.6408 159.516 71.6678 159.686 71.7218 159.827C71.7773 159.968 71.8591 160.076 71.9671 160.151C72.0766 160.225 72.2131 160.262 72.3766 160.262C72.5071 160.262 72.6249 160.248 72.7299 160.221C72.8349 160.193 72.9302 160.16 73.0157 160.122V160.455C72.9332 160.497 72.8409 160.53 72.7389 160.552C72.6384 160.575 72.5184 160.586 72.3789 160.586ZM75.7272 159.303C75.7272 159.506 75.7009 159.686 75.6484 159.845C75.5959 160.004 75.5202 160.139 75.4212 160.248C75.3222 160.358 75.2021 160.442 75.0611 160.5C74.9216 160.557 74.7634 160.586 74.5863 160.586C74.4213 160.586 74.2698 160.557 74.1318 160.5C73.9953 160.442 73.8768 160.358 73.7763 160.248C73.6773 160.139 73.6 160.004 73.5445 159.845C73.4905 159.686 73.4635 159.506 73.4635 159.303C73.4635 159.033 73.5092 158.804 73.6007 158.615C73.6923 158.424 73.8228 158.279 73.9923 158.18C74.1633 158.08 74.3666 158.03 74.6021 158.03C74.8271 158.03 75.0236 158.08 75.1916 158.18C75.3612 158.281 75.4924 158.426 75.5854 158.617C75.6799 158.806 75.7272 159.035 75.7272 159.303ZM73.8505 159.303C73.8505 159.501 73.8768 159.673 73.9293 159.818C73.9818 159.964 74.0628 160.076 74.1723 160.156C74.2818 160.235 74.4228 160.275 74.5953 160.275C74.7664 160.275 74.9066 160.235 75.0161 160.156C75.1271 160.076 75.2089 159.964 75.2614 159.818C75.3139 159.673 75.3402 159.501 75.3402 159.303C75.3402 159.107 75.3139 158.937 75.2614 158.795C75.2089 158.651 75.1279 158.54 75.0184 158.462C74.9089 158.384 74.7671 158.345 74.5931 158.345C74.3366 158.345 74.1483 158.429 74.0283 158.599C73.9098 158.768 73.8505 159.003 73.8505 159.303ZM79.0508 158.03C79.3223 158.03 79.5271 158.101 79.6651 158.243C79.8031 158.384 79.8721 158.612 79.8721 158.925V160.541H79.5031V158.943C79.5031 158.744 79.4596 158.594 79.3726 158.495C79.287 158.395 79.1595 158.345 78.99 158.345C78.7515 158.345 78.5782 158.414 78.4702 158.552C78.3622 158.69 78.3082 158.893 78.3082 159.161V160.541H77.9369V158.943C77.9369 158.81 77.9174 158.699 77.8784 158.61C77.8409 158.522 77.7839 158.456 77.7074 158.412C77.6324 158.367 77.5371 158.345 77.4216 158.345C77.2581 158.345 77.1268 158.378 77.0278 158.446C76.9288 158.513 76.8568 158.614 76.8118 158.747C76.7683 158.879 76.7465 159.042 76.7465 159.236V160.541H76.373V158.075H76.6745L76.7308 158.423H76.7511C76.8006 158.338 76.8628 158.266 76.9378 158.207C77.0128 158.149 77.0968 158.105 77.1898 158.075C77.2829 158.045 77.3819 158.03 77.4869 158.03C77.6744 158.03 77.8312 158.065 77.9572 158.135C78.0847 158.204 78.1769 158.31 78.2339 158.453H78.2542C78.3352 158.31 78.4462 158.204 78.5872 158.135C78.7282 158.065 78.8828 158.03 79.0508 158.03Z" fill="#020202"/>
                            <path d="M42.3809 152.55V145.53L40.8472 146.15L40.4048 144.704L42.897 143.362H44.475V152.55H42.3809ZM47.6308 151.046C48.2207 150.485 48.7368 149.994 49.1793 149.571C49.6217 149.148 50.0002 148.775 50.3148 148.45C50.6392 148.116 50.8997 147.811 51.0964 147.536C51.3028 147.261 51.4503 146.99 51.5388 146.725C51.6371 146.459 51.6863 146.174 51.6863 145.869C51.6863 145.722 51.6666 145.589 51.6273 145.471C51.5879 145.353 51.524 145.255 51.4356 145.176C51.3471 145.088 51.2291 145.019 51.0816 144.97C50.944 144.921 50.7719 144.896 50.5655 144.896C50.3787 144.896 50.2066 144.916 50.0493 144.955C49.892 144.985 49.7446 145.039 49.6069 145.117C49.4693 145.196 49.3415 145.299 49.2235 145.427C49.1252 145.555 49.0613 145.653 49.0318 145.722C49.0121 145.791 49.0072 145.864 49.017 145.943L48.9138 146.076L48.8106 146.002L47.4096 144.926C47.6456 144.542 47.9307 144.223 48.2649 143.967C48.5992 143.711 48.963 143.52 49.3562 143.392C49.7593 143.254 50.1722 143.185 50.595 143.185C51.1455 143.185 51.6469 143.298 52.0992 143.525C52.5612 143.741 52.9299 144.051 53.2052 144.454C53.4805 144.847 53.6181 145.314 53.6181 145.855C53.6181 146.218 53.5739 146.558 53.4854 146.872C53.3969 147.187 53.2642 147.492 53.0872 147.787C52.9201 148.081 52.7087 148.386 52.4531 148.701C52.1975 149.015 51.8927 149.35 51.5388 149.704C51.1947 150.058 50.8063 150.451 50.3738 150.883H52.925C53.0921 150.883 53.2101 150.874 53.2789 150.854C53.3478 150.834 53.4117 150.8 53.4706 150.751H53.6329V150.883V152.55H47.6308V151.046ZM57.762 152.727C57.182 152.727 56.6118 152.638 56.0514 152.461C55.491 152.275 55.0535 151.985 54.7389 151.591L55.6974 150.087L55.7712 149.969L55.9187 150.058C55.9383 150.126 55.958 150.205 55.9776 150.294C56.0071 150.372 56.0809 150.47 56.1988 150.588C56.3955 150.746 56.6167 150.874 56.8625 150.972C57.1181 151.06 57.3835 151.105 57.6588 151.105C57.9243 151.105 58.1504 151.055 58.3372 150.957C58.524 150.859 58.6665 150.721 58.7648 150.544C58.873 150.357 58.927 150.146 58.927 149.91C58.927 149.635 58.8828 149.404 58.7943 149.217C58.7058 149.03 58.5682 148.888 58.3814 148.789C58.1946 148.681 57.9537 148.617 57.6588 148.598C57.3737 148.568 57.0296 148.578 56.6265 148.627V147.005C57.0296 147.025 57.3688 147.01 57.6441 146.961C57.9292 146.912 58.1553 146.838 58.3224 146.739C58.4896 146.631 58.6075 146.508 58.6763 146.371C58.755 146.233 58.7943 146.086 58.7943 145.928C58.7943 145.761 58.7648 145.614 58.7058 145.486C58.6567 145.358 58.583 145.25 58.4846 145.162C58.3863 145.063 58.2634 144.989 58.116 144.94C57.9783 144.891 57.821 144.867 57.6441 144.867C57.4474 144.867 57.2508 144.896 57.0542 144.955C56.8575 145.004 56.6757 145.083 56.5085 145.191C56.3414 145.299 56.1939 145.437 56.0661 145.604L54.8864 144.395C55.2501 143.962 55.6876 143.652 56.1988 143.466C56.7199 143.279 57.2361 143.185 57.7473 143.185C58.3175 143.185 58.8287 143.294 59.281 143.51C59.7431 143.716 60.1068 144.001 60.3723 144.365C60.6377 144.729 60.7704 145.142 60.7704 145.604C60.7704 145.958 60.6918 146.272 60.5345 146.548C60.387 146.823 60.2002 147.054 59.9741 147.241C59.7578 147.418 59.5464 147.555 59.34 147.654C59.5956 147.742 59.8512 147.885 60.1068 148.081C60.3624 148.268 60.5738 148.519 60.7409 148.834C60.9179 149.148 61.0064 149.527 61.0064 149.969C61.0064 150.49 60.8687 150.962 60.5935 151.385C60.328 151.798 59.9544 152.127 59.4727 152.373C58.991 152.609 58.4207 152.727 57.762 152.727ZM73.0105 152.55V150.426H69.6481V149.099L73.4824 143.362H74.9718V148.76H76.1958V150.441H74.9718V152.55H73.0105ZM71.6537 148.804H73.0695V146.504L71.6537 148.804ZM80.2955 152.727C79.6073 152.727 78.9928 152.609 78.4521 152.373C77.9114 152.127 77.5083 151.749 77.2429 151.237L78.6438 150.072L78.7471 149.984L78.8503 150.102C78.8503 150.18 78.865 150.254 78.8945 150.323C78.924 150.392 78.9879 150.49 79.0862 150.618C79.2435 150.765 79.4205 150.878 79.6171 150.957C79.8138 151.036 80.0202 151.075 80.2365 151.075C80.443 151.075 80.6249 151.041 80.7822 150.972C80.9493 150.893 81.0918 150.785 81.2098 150.647C81.3278 150.51 81.4163 150.357 81.4753 150.19C81.5343 150.013 81.5637 149.831 81.5637 149.645C81.5637 149.419 81.5343 149.212 81.4753 149.025C81.4261 148.829 81.3475 148.662 81.2393 148.524C81.1312 148.376 80.9935 148.263 80.8264 148.185C80.6593 148.096 80.4626 148.052 80.2365 148.052C80.0497 148.052 79.8728 148.072 79.7056 148.111C79.5385 148.15 79.3861 148.219 79.2485 148.317C79.1207 148.406 79.0027 148.524 78.8945 148.671L77.641 148.406L77.9802 143.362H83.0679V144.985H79.7204L79.6024 146.695C79.6909 146.636 79.8039 146.582 79.9416 146.533C80.0792 146.484 80.2218 146.449 80.3692 146.43C80.5167 146.4 80.6494 146.386 80.7674 146.386C81.1803 146.386 81.5539 146.449 81.8882 146.577C82.2224 146.705 82.5076 146.897 82.7435 147.152C82.9893 147.398 83.1761 147.713 83.3039 148.096C83.4317 148.48 83.4956 148.922 83.4956 149.423C83.4956 150.102 83.358 150.692 83.0827 151.193C82.8074 151.685 82.4289 152.063 81.9472 152.329C81.4753 152.594 80.9247 152.727 80.2955 152.727ZM87.7722 152.727C87.0841 152.727 86.4991 152.545 86.0174 152.181C85.5356 151.808 85.1719 151.291 84.9261 150.633C84.6803 149.964 84.5574 149.192 84.5574 148.317C84.5574 147.246 84.7147 146.331 85.0293 145.574C85.3439 144.808 85.7667 144.218 86.2975 143.805C86.8383 143.392 87.4478 143.185 88.1262 143.185C88.5489 143.185 88.9913 143.259 89.4534 143.407C89.9253 143.544 90.3284 143.785 90.6627 144.129L89.5861 145.339L89.4977 145.442L89.3649 145.339C89.3551 145.26 89.3207 145.201 89.2617 145.162C89.2027 145.122 89.1044 145.063 88.9668 144.985C88.9078 144.965 88.8439 144.95 88.775 144.94C88.7062 144.921 88.6374 144.906 88.5686 144.896C88.4998 144.886 88.4309 144.881 88.3621 144.881C88.2245 144.881 88.077 144.896 87.9197 144.926C87.7722 144.955 87.6297 145.014 87.4921 145.103C87.3544 145.181 87.2217 145.299 87.0939 145.456C86.9759 145.614 86.8727 145.82 86.7842 146.076C86.6957 146.331 86.6318 146.651 86.5925 147.034C86.7203 146.907 86.8678 146.798 87.0349 146.71C87.2119 146.621 87.3937 146.553 87.5805 146.504C87.7673 146.454 87.9492 146.43 88.1262 146.43C88.5096 146.43 88.8635 146.489 89.188 146.607C89.5124 146.715 89.7926 146.892 90.0285 147.138C90.2743 147.374 90.4611 147.683 90.5889 148.067C90.7266 148.44 90.7954 148.893 90.7954 149.423C90.7954 150.033 90.6676 150.588 90.412 151.09C90.1564 151.591 89.8024 151.989 89.3502 152.284C88.8979 152.579 88.372 152.727 87.7722 152.727ZM87.8017 151.105C87.9689 151.105 88.1163 151.06 88.2442 150.972C88.3818 150.883 88.4998 150.765 88.5981 150.618C88.6964 150.461 88.7701 150.284 88.8193 150.087C88.8684 149.881 88.893 149.659 88.893 149.423C88.893 149.187 88.8635 148.981 88.8045 148.804C88.7456 148.627 88.662 148.48 88.5538 148.362C88.4555 148.244 88.3376 148.155 88.1999 148.096C88.0721 148.037 87.9345 148.008 87.787 148.008C87.6592 148.008 87.5412 148.027 87.4331 148.067C87.3249 148.106 87.2217 148.165 87.1234 148.244C87.0349 148.312 86.9464 148.401 86.8579 148.509C86.7793 148.607 86.7006 148.725 86.622 148.863C86.622 149.256 86.6515 149.595 86.7105 149.881C86.7694 150.166 86.8481 150.402 86.9464 150.588C87.0546 150.765 87.1775 150.898 87.3151 150.987C87.4626 151.065 87.6248 151.105 87.8017 151.105Z" fill="#020202"/>
                            <path d="M40.9996 135.269C41.4241 135.269 41.7339 135.361 41.9289 135.544C42.124 135.725 42.2215 135.976 42.2215 136.295C42.2215 136.439 42.1997 136.577 42.1562 136.709C42.1127 136.84 42.0414 136.956 41.9424 137.058C41.8449 137.16 41.7144 137.241 41.5509 137.301C41.3874 137.359 41.1856 137.389 40.9456 137.389H40.6463V138.559H39.9487V135.269H40.9996ZM40.9636 135.841H40.6463V136.817H40.8758C41.0063 136.817 41.1196 136.8 41.2156 136.765C41.3116 136.731 41.3859 136.677 41.4384 136.603C41.4909 136.53 41.5171 136.435 41.5171 136.32C41.5171 136.158 41.4721 136.038 41.3821 135.96C41.2921 135.88 41.1526 135.841 40.9636 135.841ZM43.8191 135.991C44.1566 135.991 44.4154 136.065 44.5954 136.212C44.7755 136.359 44.8655 136.582 44.8655 136.882V138.559H44.3862L44.2534 138.217H44.2354C44.1634 138.307 44.0899 138.38 44.0149 138.437C43.9399 138.494 43.8536 138.536 43.7561 138.563C43.6586 138.59 43.5401 138.604 43.4006 138.604C43.2521 138.604 43.1185 138.575 43 138.518C42.883 138.461 42.7908 138.374 42.7233 138.257C42.6558 138.139 42.622 137.989 42.622 137.807C42.622 137.54 42.7158 137.344 42.9033 137.218C43.0908 137.09 43.3721 137.02 43.7471 137.006L44.1837 136.993V136.882C44.1837 136.75 44.1491 136.654 44.0801 136.592C44.0111 136.531 43.9151 136.5 43.7921 136.5C43.6706 136.5 43.5513 136.517 43.4343 136.552C43.3173 136.586 43.2003 136.63 43.0833 136.682L42.856 136.219C42.9895 136.148 43.1388 136.093 43.3038 136.052C43.4703 136.012 43.6421 135.991 43.8191 135.991ZM44.1837 137.393L43.9181 137.402C43.6961 137.408 43.5416 137.448 43.4546 137.521C43.3691 137.595 43.3263 137.692 43.3263 137.812C43.3263 137.917 43.3571 137.992 43.4186 138.037C43.4801 138.08 43.5603 138.102 43.6593 138.102C43.8064 138.102 43.9301 138.059 44.0306 137.972C44.1326 137.885 44.1837 137.761 44.1837 137.6V137.393ZM47.3295 137.812C47.3295 137.983 47.289 138.128 47.2079 138.246C47.1284 138.363 47.0092 138.452 46.8502 138.514C46.6911 138.574 46.4931 138.604 46.2561 138.604C46.0806 138.604 45.9298 138.593 45.8038 138.57C45.6793 138.548 45.5533 138.51 45.4258 138.458V137.891C45.5623 137.952 45.7085 138.003 45.8646 138.044C46.0221 138.083 46.1601 138.102 46.2786 138.102C46.4121 138.102 46.5074 138.083 46.5644 138.044C46.6229 138.003 46.6521 137.951 46.6521 137.886C46.6521 137.844 46.6401 137.807 46.6161 137.774C46.5936 137.739 46.5441 137.701 46.4676 137.659C46.3911 137.615 46.2711 137.559 46.1076 137.49C45.9501 137.424 45.8203 137.357 45.7183 137.29C45.6178 137.222 45.5428 137.143 45.4933 137.051C45.4453 136.958 45.4213 136.84 45.4213 136.698C45.4213 136.465 45.5113 136.291 45.6913 136.174C45.8728 136.055 46.1151 135.996 46.4181 135.996C46.5741 135.996 46.7226 136.012 46.8637 136.043C47.0062 136.075 47.1524 136.125 47.3025 136.194L47.0954 136.689C46.9709 136.635 46.8532 136.591 46.7421 136.556C46.6326 136.522 46.5209 136.504 46.4069 136.504C46.3064 136.504 46.2306 136.518 46.1796 136.545C46.1286 136.572 46.1031 136.613 46.1031 136.669C46.1031 136.709 46.1158 136.745 46.1413 136.777C46.1683 136.808 46.2193 136.843 46.2944 136.882C46.3709 136.92 46.4826 136.969 46.6296 137.029C46.7722 137.087 46.8959 137.149 47.0009 137.213C47.1059 137.276 47.1869 137.355 47.2439 137.449C47.301 137.542 47.3295 137.663 47.3295 137.812ZM49.6202 137.812C49.6202 137.983 49.5797 138.128 49.4987 138.246C49.4192 138.363 49.2999 138.452 49.1409 138.514C48.9819 138.574 48.7838 138.604 48.5468 138.604C48.3713 138.604 48.2205 138.593 48.0945 138.57C47.97 138.548 47.844 138.51 47.7165 138.458V137.891C47.853 137.952 47.9993 138.003 48.1553 138.044C48.3128 138.083 48.4508 138.102 48.5693 138.102C48.7028 138.102 48.7981 138.083 48.8551 138.044C48.9136 138.003 48.9429 137.951 48.9429 137.886C48.9429 137.844 48.9309 137.807 48.9069 137.774C48.8844 137.739 48.8349 137.701 48.7583 137.659C48.6818 137.615 48.5618 137.559 48.3983 137.49C48.2408 137.424 48.111 137.357 48.009 137.29C47.9085 137.222 47.8335 137.143 47.784 137.051C47.736 136.958 47.712 136.84 47.712 136.698C47.712 136.465 47.802 136.291 47.982 136.174C48.1635 136.055 48.4058 135.996 48.7088 135.996C48.8649 135.996 49.0134 136.012 49.1544 136.043C49.2969 136.075 49.4432 136.125 49.5932 136.194L49.3862 136.689C49.2616 136.635 49.1439 136.591 49.0329 136.556C48.9234 136.522 48.8116 136.504 48.6976 136.504C48.5971 136.504 48.5213 136.518 48.4703 136.545C48.4193 136.572 48.3938 136.613 48.3938 136.669C48.3938 136.709 48.4066 136.745 48.4321 136.777C48.4591 136.808 48.5101 136.843 48.5851 136.882C48.6616 136.92 48.7733 136.969 48.9204 137.029C49.0629 137.087 49.1866 137.149 49.2916 137.213C49.3967 137.276 49.4777 137.355 49.5347 137.449C49.5917 137.542 49.6202 137.663 49.6202 137.812ZM50.842 135.057V135.872C50.842 135.967 50.839 136.06 50.833 136.153C50.8285 136.246 50.8225 136.318 50.815 136.369H50.842C50.9081 136.266 50.9981 136.178 51.1121 136.106C51.2261 136.033 51.3738 135.996 51.5554 135.996C51.8374 135.996 52.0662 136.106 52.2417 136.327C52.4172 136.547 52.505 136.87 52.505 137.296C52.505 137.583 52.4645 137.824 52.3834 138.019C52.3024 138.212 52.1892 138.359 52.0437 138.458C51.8982 138.555 51.7294 138.604 51.5374 138.604C51.3528 138.604 51.2073 138.571 51.1008 138.505C50.9943 138.439 50.9081 138.365 50.842 138.282H50.7948L50.68 138.559H50.1557V135.057H50.842ZM51.3348 136.545C51.2148 136.545 51.1196 136.57 51.0491 136.619C50.9786 136.669 50.9268 136.743 50.8938 136.842C50.8623 136.941 50.845 137.066 50.842 137.218V137.292C50.842 137.536 50.8781 137.724 50.9501 137.855C51.0221 137.984 51.1533 138.048 51.3438 138.048C51.4849 138.048 51.5966 137.983 51.6791 137.852C51.7631 137.722 51.8051 137.533 51.8051 137.287C51.8051 137.041 51.7631 136.856 51.6791 136.732C51.5951 136.607 51.4804 136.545 51.3348 136.545ZM55.3582 137.296C55.3582 137.506 55.3297 137.693 55.2727 137.855C55.2172 138.017 55.1355 138.154 55.0275 138.266C54.9209 138.377 54.7919 138.461 54.6404 138.518C54.4904 138.575 54.3209 138.604 54.1319 138.604C53.9549 138.604 53.7921 138.575 53.6436 138.518C53.4966 138.461 53.3683 138.377 53.2588 138.266C53.1508 138.154 53.0668 138.017 53.0068 137.855C52.9483 137.693 52.919 137.506 52.919 137.296C52.919 137.017 52.9685 136.781 53.0675 136.588C53.1665 136.394 53.3075 136.247 53.4906 136.147C53.6736 136.046 53.8918 135.996 54.1454 135.996C54.3809 135.996 54.5894 136.046 54.7709 136.147C54.9539 136.247 55.0972 136.394 55.2007 136.588C55.3057 136.781 55.3582 137.017 55.3582 137.296ZM53.6188 137.296C53.6188 137.461 53.6368 137.6 53.6728 137.713C53.7088 137.825 53.7651 137.91 53.8416 137.967C53.9181 138.024 54.0179 138.053 54.1409 138.053C54.2624 138.053 54.3606 138.024 54.4356 137.967C54.5122 137.91 54.5677 137.825 54.6022 137.713C54.6382 137.6 54.6562 137.461 54.6562 137.296C54.6562 137.13 54.6382 136.992 54.6022 136.882C54.5677 136.771 54.5122 136.688 54.4356 136.633C54.3591 136.577 54.2594 136.549 54.1364 136.549C53.9549 136.549 53.8228 136.612 53.7403 136.736C53.6593 136.861 53.6188 137.047 53.6188 137.296ZM56.6116 138.559H55.9253V135.057H56.6116V138.559ZM58.3938 138.057C58.4688 138.057 58.5415 138.05 58.6121 138.035C58.6841 138.02 58.7553 138.001 58.8258 137.978V138.489C58.7523 138.522 58.6608 138.549 58.5513 138.57C58.4433 138.593 58.3248 138.604 58.1958 138.604C58.0457 138.604 57.9107 138.58 57.7907 138.532C57.6722 138.482 57.5785 138.398 57.5094 138.278C57.4419 138.156 57.4082 137.987 57.4082 137.771V136.558H57.0797V136.268L57.4577 136.039L57.6557 135.508H58.0945V136.043H58.7988V136.558H58.0945V137.771C58.0945 137.867 58.1215 137.939 58.1755 137.987C58.231 138.034 58.3038 138.057 58.3938 138.057Z" fill="#020202"/>
                            <ellipse cx="123.517" cy="147.55" rx="9.52153" ry="9.44218" stroke="#020202" stroke-opacity="0.25" stroke-width="1.85141"/>
                            <path d="M123.517 138.108C124.767 138.108 126.005 138.352 127.16 138.826C128.316 139.301 129.365 139.996 130.249 140.873C131.134 141.75 131.835 142.791 132.313 143.936C132.792 145.082 133.038 146.31 133.038 147.55" stroke="#020202" stroke-width="1.85141" stroke-linecap="round"/>
                            <path d="M47.5347 167.287H129.465" stroke="#D6D6D6" stroke-linecap="round"/>
                        </g>
                        <g filter="url(#filter2_f_5_20425)">
                            <path d="M40.8511 204.7C41.1451 204.7 41.3634 204.766 41.5059 204.898C41.6484 205.03 41.7196 205.241 41.7196 205.53V207.207H41.4474L41.3754 206.842H41.3574C41.2884 206.932 41.2163 207.008 41.1413 207.07C41.0663 207.13 40.9793 207.175 40.8803 207.207C40.7828 207.237 40.6628 207.252 40.5203 207.252C40.3703 207.252 40.2368 207.226 40.1197 207.173C40.0042 207.121 39.9127 207.041 39.8452 206.935C39.7792 206.828 39.7462 206.693 39.7462 206.529C39.7462 206.283 39.8437 206.094 40.0387 205.962C40.2338 205.83 40.5308 205.758 40.9298 205.746L41.3551 205.728V205.578C41.3551 205.365 41.3094 205.215 41.2178 205.13C41.1263 205.044 40.9973 205.002 40.8308 205.002C40.7018 205.002 40.5788 205.02 40.4618 205.058C40.3448 205.095 40.2338 205.14 40.1287 205.191L40.014 204.907C40.125 204.85 40.2525 204.801 40.3965 204.761C40.5405 204.72 40.692 204.7 40.8511 204.7ZM41.3506 205.992L40.9748 206.007C40.6673 206.019 40.4505 206.07 40.3245 206.158C40.1985 206.247 40.1355 206.372 40.1355 206.534C40.1355 206.675 40.1782 206.779 40.2638 206.847C40.3493 206.914 40.4625 206.948 40.6035 206.948C40.8226 206.948 41.0018 206.887 41.1413 206.766C41.2809 206.644 41.3506 206.462 41.3506 206.219V205.992ZM43.3668 207.252C43.0548 207.252 42.8073 207.145 42.6242 206.932C42.4427 206.719 42.352 206.403 42.352 205.983C42.352 205.558 42.445 205.238 42.631 205.022C42.817 204.804 43.0645 204.696 43.3736 204.696C43.5041 204.696 43.6181 204.713 43.7156 204.747C43.8131 204.782 43.8971 204.828 43.9676 204.887C44.0381 204.944 44.0974 205.009 44.1454 205.083H44.1724C44.1664 205.036 44.1604 204.972 44.1544 204.891C44.1484 204.81 44.1454 204.744 44.1454 204.693V203.705H44.5189V207.207H44.2174L44.1611 206.856H44.1454C44.0989 206.929 44.0396 206.996 43.9676 207.056C43.8971 207.116 43.8123 207.164 43.7133 207.2C43.6158 207.235 43.5003 207.252 43.3668 207.252ZM43.4253 206.941C43.6893 206.941 43.8761 206.866 43.9856 206.716C44.0951 206.566 44.1499 206.343 44.1499 206.048V205.98C44.1499 205.667 44.0974 205.426 43.9924 205.258C43.8889 205.09 43.6998 205.006 43.4253 205.006C43.1958 205.006 43.024 205.095 42.91 205.272C42.796 205.447 42.739 205.687 42.739 205.992C42.739 206.295 42.7953 206.529 42.9078 206.694C43.0218 206.859 43.1943 206.941 43.4253 206.941ZM46.2336 204.7C46.5276 204.7 46.7459 204.766 46.8884 204.898C47.0309 205.03 47.1022 205.241 47.1022 205.53V207.207H46.8299L46.7579 206.842H46.7399C46.6709 206.932 46.5989 207.008 46.5239 207.07C46.4489 207.13 46.3618 207.175 46.2628 207.207C46.1653 207.237 46.0453 207.252 45.9028 207.252C45.7528 207.252 45.6193 207.226 45.5023 207.173C45.3868 207.121 45.2952 207.041 45.2277 206.935C45.1617 206.828 45.1287 206.693 45.1287 206.529C45.1287 206.283 45.2262 206.094 45.4213 205.962C45.6163 205.83 45.9133 205.758 46.3123 205.746L46.7376 205.728V205.578C46.7376 205.365 46.6919 205.215 46.6004 205.13C46.5089 205.044 46.3798 205.002 46.2133 205.002C46.0843 205.002 45.9613 205.02 45.8443 205.058C45.7273 205.095 45.6163 205.14 45.5113 205.191L45.3965 204.907C45.5075 204.85 45.635 204.801 45.779 204.761C45.9231 204.72 46.0746 204.7 46.2336 204.7ZM46.7331 205.992L46.3573 206.007C46.0498 206.019 45.833 206.07 45.707 206.158C45.581 206.247 45.518 206.372 45.518 206.534C45.518 206.675 45.5608 206.779 45.6463 206.847C45.7318 206.914 45.845 206.948 45.9861 206.948C46.2051 206.948 46.3843 206.887 46.5239 206.766C46.6634 206.644 46.7331 206.462 46.7331 206.219V205.992ZM51.3461 205.564C51.3461 205.707 51.3296 205.846 51.2966 205.983C51.2651 206.118 51.2163 206.24 51.1503 206.349C51.0843 206.457 51.0018 206.544 50.9028 206.608C50.8053 206.673 50.6898 206.705 50.5563 206.705C50.4167 206.705 50.3057 206.664 50.2232 206.583C50.1407 206.502 50.0912 206.406 50.0747 206.295H50.0545C49.9975 206.414 49.9134 206.512 49.8024 206.59C49.6929 206.667 49.5579 206.705 49.3974 206.705C49.1634 206.705 48.9826 206.628 48.8551 206.473C48.7291 206.317 48.6661 206.11 48.6661 205.852C48.6661 205.651 48.7058 205.473 48.7853 205.319C48.8663 205.163 48.9796 205.041 49.1251 204.952C49.2721 204.862 49.4454 204.817 49.6449 204.817C49.7784 204.817 49.9082 204.828 50.0342 204.851C50.1602 204.873 50.2607 204.898 50.3357 204.925L50.2907 205.832C50.2892 205.887 50.2877 205.93 50.2862 205.96C50.2847 205.989 50.284 206.011 50.284 206.028C50.284 206.19 50.3125 206.299 50.3695 206.356C50.428 206.412 50.4985 206.439 50.581 206.439C50.6815 206.439 50.7655 206.4 50.833 206.322C50.902 206.243 50.9545 206.137 50.9905 206.005C51.0266 205.872 51.0446 205.724 51.0446 205.562C51.0446 205.275 50.9868 205.031 50.8713 204.828C50.7558 204.626 50.596 204.471 50.392 204.365C50.1895 204.258 49.9562 204.205 49.6922 204.205C49.4296 204.205 49.1964 204.246 48.9924 204.329C48.7898 204.411 48.6181 204.528 48.4771 204.68C48.3375 204.83 48.2318 205.008 48.1598 205.215C48.0878 205.422 48.0518 205.651 48.0518 205.902C48.0518 206.208 48.1058 206.468 48.2138 206.682C48.3233 206.897 48.4831 207.061 48.6931 207.173C48.9046 207.284 49.1619 207.34 49.4649 207.34C49.6479 207.34 49.8242 207.319 49.9937 207.279C50.1632 207.238 50.3147 207.193 50.4482 207.142V207.434C50.3162 207.49 50.1685 207.535 50.005 207.569C49.8414 207.605 49.6614 207.623 49.4649 207.623C49.1034 207.623 48.7943 207.555 48.5378 207.418C48.2813 207.283 48.0848 207.088 47.9483 206.833C47.8117 206.578 47.7435 206.272 47.7435 205.915C47.7435 205.626 47.7877 205.359 47.8762 205.116C47.9663 204.873 48.0953 204.663 48.2633 204.484C48.4328 204.306 48.6376 204.167 48.8776 204.07C49.1191 203.971 49.3906 203.921 49.6922 203.921C50.0147 203.921 50.2997 203.988 50.5473 204.122C50.7963 204.254 50.9913 204.443 51.1323 204.689C51.2748 204.933 51.3461 205.225 51.3461 205.564ZM49.0014 205.861C49.0014 206.061 49.0411 206.207 49.1206 206.3C49.2001 206.393 49.3104 206.439 49.4514 206.439C49.6254 206.439 49.7529 206.374 49.8339 206.244C49.9164 206.113 49.9637 205.941 49.9757 205.726L50.0027 205.139C49.9592 205.125 49.9059 205.114 49.8429 205.105C49.7814 205.095 49.7169 205.089 49.6494 205.089C49.4949 205.089 49.3696 205.126 49.2736 205.2C49.1791 205.273 49.1101 205.368 49.0666 205.485C49.0231 205.602 49.0014 205.728 49.0014 205.861ZM53.162 204.696C53.4695 204.696 53.7148 204.801 53.8978 205.013C54.0808 205.224 54.1724 205.542 54.1724 205.967C54.1724 206.247 54.1304 206.483 54.0463 206.673C53.9623 206.864 53.8438 207.008 53.6908 207.106C53.5393 207.203 53.36 207.252 53.153 207.252C53.0225 207.252 52.9077 207.235 52.8087 207.2C52.7097 207.166 52.625 207.119 52.5544 207.061C52.4839 207.002 52.4254 206.938 52.3789 206.869H52.3519C52.3564 206.928 52.3617 206.998 52.3677 207.081C52.3752 207.163 52.3789 207.235 52.3789 207.297V208.309H52.0031V204.741H52.3114L52.3609 205.105H52.3789C52.4269 205.03 52.4854 204.962 52.5544 204.9C52.6235 204.837 52.7075 204.788 52.8065 204.752C52.907 204.714 53.0255 204.696 53.162 204.696ZM53.0968 205.011C52.9257 205.011 52.7877 205.044 52.6827 205.11C52.5792 205.176 52.5034 205.275 52.4554 205.407C52.4074 205.537 52.3819 205.701 52.3789 205.899V205.971C52.3789 206.18 52.4014 206.356 52.4464 206.5C52.4929 206.644 52.5687 206.754 52.6737 206.829C52.7802 206.904 52.9227 206.941 53.1013 206.941C53.2543 206.941 53.3818 206.9 53.4838 206.817C53.5858 206.735 53.6616 206.62 53.7111 206.473C53.7621 206.325 53.7876 206.154 53.7876 205.962C53.7876 205.671 53.7306 205.44 53.6166 205.269C53.504 205.097 53.3308 205.011 53.0968 205.011ZM55.7475 204.7C56.0415 204.7 56.2598 204.766 56.4023 204.898C56.5448 205.03 56.6161 205.241 56.6161 205.53V207.207H56.3438L56.2718 206.842H56.2538C56.1848 206.932 56.1128 207.008 56.0378 207.07C55.9628 207.13 55.8758 207.175 55.7768 207.207C55.6793 207.237 55.5592 207.252 55.4167 207.252C55.2667 207.252 55.1332 207.226 55.0162 207.173C54.9007 207.121 54.8092 207.041 54.7417 206.935C54.6757 206.828 54.6427 206.693 54.6427 206.529C54.6427 206.283 54.7402 206.094 54.9352 205.962C55.1302 205.83 55.4272 205.758 55.8263 205.746L56.2516 205.728V205.578C56.2516 205.365 56.2058 205.215 56.1143 205.13C56.0228 205.044 55.8938 205.002 55.7273 205.002C55.5982 205.002 55.4752 205.02 55.3582 205.058C55.2412 205.095 55.1302 205.14 55.0252 205.191L54.9104 204.907C55.0214 204.85 55.149 204.801 55.293 204.761C55.437 204.72 55.5885 204.7 55.7475 204.7ZM56.2471 205.992L55.8713 206.007C55.5637 206.019 55.347 206.07 55.221 206.158C55.0949 206.247 55.0319 206.372 55.0319 206.534C55.0319 206.675 55.0747 206.779 55.1602 206.847C55.2457 206.914 55.359 206.948 55.5 206.948C55.719 206.948 55.8983 206.887 56.0378 206.766C56.1773 206.644 56.2471 206.462 56.2471 206.219V205.992ZM58.9811 206.532C58.9811 206.689 58.9413 206.822 58.8618 206.93C58.7838 207.037 58.6713 207.117 58.5243 207.171C58.3788 207.225 58.2047 207.252 58.0022 207.252C57.8297 207.252 57.6804 207.238 57.5544 207.211C57.4284 207.184 57.3182 207.146 57.2237 207.097V206.752C57.3242 206.802 57.4442 206.847 57.5837 206.887C57.7232 206.928 57.8657 206.948 58.0112 206.948C58.2243 206.948 58.3788 206.914 58.4748 206.845C58.5708 206.775 58.6188 206.682 58.6188 206.563C58.6188 206.496 58.5993 206.436 58.5603 206.385C58.5228 206.333 58.459 206.283 58.369 206.235C58.279 206.185 58.1545 206.131 57.9955 206.073C57.838 206.013 57.7014 205.953 57.5859 205.895C57.4719 205.835 57.3834 205.762 57.3204 205.677C57.2589 205.591 57.2282 205.48 57.2282 205.344C57.2282 205.135 57.3122 204.975 57.4802 204.864C57.6497 204.752 57.8717 204.696 58.1462 204.696C58.2948 204.696 58.4335 204.711 58.5625 204.741C58.693 204.769 58.8146 204.808 58.9271 204.858L58.8011 205.157C58.699 205.113 58.5903 205.077 58.4748 205.047C58.3593 205.017 58.2415 205.002 58.1215 205.002C57.949 205.002 57.8162 205.03 57.7232 205.087C57.6317 205.144 57.5859 205.222 57.5859 205.321C57.5859 205.398 57.6069 205.461 57.6489 205.51C57.6924 205.56 57.7615 205.606 57.856 205.65C57.9505 205.693 58.075 205.744 58.2295 205.803C58.384 205.86 58.5175 205.919 58.63 205.98C58.7426 206.04 58.8288 206.114 58.8888 206.201C58.9503 206.286 58.9811 206.397 58.9811 206.532ZM61.1773 206.532C61.1773 206.689 61.1375 206.822 61.058 206.93C60.98 207.037 60.8675 207.117 60.7205 207.171C60.575 207.225 60.401 207.252 60.1984 207.252C60.0259 207.252 59.8767 207.238 59.7506 207.211C59.6246 207.184 59.5144 207.146 59.4199 207.097V206.752C59.5204 206.802 59.6404 206.847 59.7799 206.887C59.9194 206.928 60.0619 206.948 60.2074 206.948C60.4205 206.948 60.575 206.914 60.671 206.845C60.767 206.775 60.815 206.682 60.815 206.563C60.815 206.496 60.7955 206.436 60.7565 206.385C60.719 206.333 60.6552 206.283 60.5652 206.235C60.4752 206.185 60.3507 206.131 60.1917 206.073C60.0342 206.013 59.8977 205.953 59.7822 205.895C59.6681 205.835 59.5796 205.762 59.5166 205.677C59.4551 205.591 59.4244 205.48 59.4244 205.344C59.4244 205.135 59.5084 204.975 59.6764 204.864C59.8459 204.752 60.0679 204.696 60.3425 204.696C60.491 204.696 60.6297 204.711 60.7587 204.741C60.8893 204.769 61.0108 204.808 61.1233 204.858L60.9973 205.157C60.8953 205.113 60.7865 205.077 60.671 205.047C60.5555 205.017 60.4377 205.002 60.3177 205.002C60.1452 205.002 60.0124 205.03 59.9194 205.087C59.8279 205.144 59.7822 205.222 59.7822 205.321C59.7822 205.398 59.8032 205.461 59.8452 205.51C59.8887 205.56 59.9577 205.606 60.0522 205.65C60.1467 205.693 60.2712 205.744 60.4257 205.803C60.5802 205.86 60.7137 205.919 60.8263 205.98C60.9388 206.04 61.025 206.114 61.085 206.201C61.1465 206.286 61.1773 206.397 61.1773 206.532ZM62.1516 203.705V204.581C62.1516 204.681 62.1486 204.779 62.1426 204.873C62.1381 204.968 62.1344 205.041 62.1314 205.094H62.1516C62.2191 204.983 62.3166 204.889 62.4442 204.813C62.5717 204.736 62.7344 204.698 62.9325 204.698C63.2415 204.698 63.4875 204.805 63.6705 205.02C63.855 205.233 63.9473 205.55 63.9473 205.971C63.9473 206.249 63.9053 206.483 63.8213 206.673C63.7373 206.864 63.6188 207.008 63.4658 207.106C63.3127 207.203 63.132 207.252 62.9235 207.252C62.7284 207.252 62.5679 207.216 62.4419 207.144C62.3174 207.07 62.2214 206.981 62.1539 206.876H62.1246L62.0481 207.207H61.7781V203.705H62.1516ZM62.8717 205.011C62.6932 205.011 62.5514 205.046 62.4464 205.116C62.3414 205.185 62.2656 205.29 62.2191 205.431C62.1741 205.571 62.1516 205.748 62.1516 205.962V205.983C62.1516 206.293 62.2034 206.531 62.3069 206.696C62.4104 206.86 62.5987 206.941 62.8717 206.941C63.1012 206.941 63.273 206.857 63.387 206.689C63.5025 206.521 63.5603 206.281 63.5603 205.969C63.5603 205.651 63.5033 205.412 63.3893 205.251C63.2767 205.091 63.1042 205.011 62.8717 205.011ZM66.7263 205.969C66.7263 206.172 66.7001 206.352 66.6476 206.511C66.5951 206.67 66.5193 206.805 66.4203 206.914C66.3213 207.024 66.2013 207.108 66.0603 207.166C65.9207 207.223 65.7625 207.252 65.5855 207.252C65.4204 207.252 65.2689 207.223 65.1309 207.166C64.9944 207.108 64.8759 207.024 64.7754 206.914C64.6764 206.805 64.5991 206.67 64.5436 206.511C64.4896 206.352 64.4626 206.172 64.4626 205.969C64.4626 205.699 64.5084 205.47 64.5999 205.281C64.6914 205.09 64.8219 204.945 64.9914 204.846C65.1624 204.746 65.3657 204.696 65.6012 204.696C65.8262 204.696 66.0228 204.746 66.1908 204.846C66.3603 204.947 66.4916 205.092 66.5846 205.283C66.6791 205.472 66.7263 205.701 66.7263 205.969ZM64.8496 205.969C64.8496 206.167 64.8759 206.339 64.9284 206.484C64.9809 206.63 65.0619 206.742 65.1714 206.822C65.2809 206.902 65.4219 206.941 65.5945 206.941C65.7655 206.941 65.9057 206.902 66.0153 206.822C66.1263 206.742 66.208 206.63 66.2605 206.484C66.313 206.339 66.3393 206.167 66.3393 205.969C66.3393 205.773 66.313 205.603 66.2605 205.461C66.208 205.317 66.127 205.206 66.0175 205.128C65.908 205.05 65.7662 205.011 65.5922 205.011C65.3357 205.011 65.1474 205.095 65.0274 205.265C64.9089 205.434 64.8496 205.669 64.8496 205.969ZM67.7479 207.207H67.3721V203.705H67.7479V207.207ZM69.3343 206.946C69.3958 206.946 69.4588 206.941 69.5233 206.93C69.5879 206.92 69.6404 206.907 69.6809 206.892V207.182C69.6374 207.202 69.5766 207.218 69.4986 207.232C69.4221 207.245 69.3471 207.252 69.2736 207.252C69.1431 207.252 69.0246 207.229 68.918 207.184C68.8115 207.138 68.726 207.06 68.6615 206.95C68.5985 206.841 68.567 206.689 68.567 206.496V205.033H68.216V204.851L68.5693 204.705L68.7178 204.169H68.9428V204.741H69.6651V205.033H68.9428V206.484C68.9428 206.639 68.978 206.754 69.0486 206.831C69.1206 206.908 69.2158 206.946 69.3343 206.946ZM70.1242 206.973C70.1242 206.868 70.1497 206.793 70.2007 206.75C70.2517 206.705 70.3139 206.682 70.3874 206.682C70.4639 206.682 70.5284 206.705 70.581 206.75C70.6335 206.793 70.6597 206.868 70.6597 206.973C70.6597 207.076 70.6335 207.152 70.581 207.2C70.5284 207.247 70.4639 207.27 70.3874 207.27C70.3139 207.27 70.2517 207.247 70.2007 207.2C70.1497 207.152 70.1242 207.076 70.1242 206.973ZM72.3789 207.252C72.1569 207.252 71.9611 207.206 71.7916 207.115C71.6221 207.023 71.49 206.884 71.3955 206.696C71.301 206.508 71.2538 206.272 71.2538 205.987C71.2538 205.689 71.3033 205.445 71.4023 205.256C71.5028 205.065 71.6408 204.924 71.8163 204.833C71.9918 204.741 72.1914 204.696 72.4149 204.696C72.5379 204.696 72.6564 204.708 72.7704 204.734C72.8859 204.758 72.9804 204.789 73.0539 204.826L72.9414 205.139C72.8664 205.109 72.7794 205.082 72.6804 205.058C72.5829 205.034 72.4914 205.022 72.4059 205.022C72.2349 205.022 72.0923 205.059 71.9783 205.132C71.8658 205.206 71.7811 205.314 71.7241 205.456C71.6686 205.599 71.6408 205.774 71.6408 205.983C71.6408 206.182 71.6678 206.352 71.7218 206.493C71.7773 206.634 71.8591 206.742 71.9671 206.817C72.0766 206.891 72.2131 206.928 72.3766 206.928C72.5071 206.928 72.6249 206.914 72.7299 206.887C72.8349 206.859 72.9302 206.826 73.0157 206.788V207.121C72.9332 207.163 72.8409 207.196 72.7389 207.218C72.6384 207.241 72.5184 207.252 72.3789 207.252ZM75.7272 205.969C75.7272 206.172 75.7009 206.352 75.6484 206.511C75.5959 206.67 75.5202 206.805 75.4212 206.914C75.3222 207.024 75.2021 207.108 75.0611 207.166C74.9216 207.223 74.7634 207.252 74.5863 207.252C74.4213 207.252 74.2698 207.223 74.1318 207.166C73.9953 207.108 73.8768 207.024 73.7763 206.914C73.6773 206.805 73.6 206.67 73.5445 206.511C73.4905 206.352 73.4635 206.172 73.4635 205.969C73.4635 205.699 73.5092 205.47 73.6007 205.281C73.6923 205.09 73.8228 204.945 73.9923 204.846C74.1633 204.746 74.3666 204.696 74.6021 204.696C74.8271 204.696 75.0236 204.746 75.1916 204.846C75.3612 204.947 75.4924 205.092 75.5854 205.283C75.6799 205.472 75.7272 205.701 75.7272 205.969ZM73.8505 205.969C73.8505 206.167 73.8768 206.339 73.9293 206.484C73.9818 206.63 74.0628 206.742 74.1723 206.822C74.2818 206.902 74.4228 206.941 74.5953 206.941C74.7664 206.941 74.9066 206.902 75.0161 206.822C75.1271 206.742 75.2089 206.63 75.2614 206.484C75.3139 206.339 75.3402 206.167 75.3402 205.969C75.3402 205.773 75.3139 205.603 75.2614 205.461C75.2089 205.317 75.1279 205.206 75.0184 205.128C74.9089 205.05 74.7671 205.011 74.5931 205.011C74.3366 205.011 74.1483 205.095 74.0283 205.265C73.9098 205.434 73.8505 205.669 73.8505 205.969ZM79.0508 204.696C79.3223 204.696 79.5271 204.767 79.6651 204.909C79.8031 205.05 79.8721 205.278 79.8721 205.591V207.207H79.5031V205.609C79.5031 205.41 79.4596 205.26 79.3726 205.161C79.287 205.061 79.1595 205.011 78.99 205.011C78.7515 205.011 78.5782 205.08 78.4702 205.218C78.3622 205.356 78.3082 205.559 78.3082 205.827V207.207H77.9369V205.609C77.9369 205.476 77.9174 205.365 77.8784 205.276C77.8409 205.188 77.7839 205.122 77.7074 205.078C77.6324 205.033 77.5371 205.011 77.4216 205.011C77.2581 205.011 77.1268 205.044 77.0278 205.112C76.9288 205.179 76.8568 205.28 76.8118 205.413C76.7683 205.545 76.7465 205.708 76.7465 205.902V207.207H76.373V204.741H76.6745L76.7308 205.089H76.7511C76.8006 205.004 76.8628 204.932 76.9378 204.873C77.0128 204.815 77.0968 204.771 77.1898 204.741C77.2829 204.711 77.3819 204.696 77.4869 204.696C77.6744 204.696 77.8312 204.731 77.9572 204.801C78.0847 204.87 78.1769 204.976 78.2339 205.119H78.2542C78.3352 204.976 78.4462 204.87 78.5872 204.801C78.7282 204.731 78.8828 204.696 79.0508 204.696Z" fill="#020202"/>
                            <path d="M42.3809 199.216V192.196L40.8472 192.816L40.4048 191.37L42.897 190.028H44.475V199.216H42.3809ZM47.6308 197.712C48.2207 197.151 48.7368 196.66 49.1793 196.237C49.6217 195.814 50.0002 195.441 50.3148 195.116C50.6392 194.782 50.8997 194.477 51.0964 194.202C51.3028 193.927 51.4503 193.656 51.5388 193.391C51.6371 193.125 51.6863 192.84 51.6863 192.535C51.6863 192.388 51.6666 192.255 51.6273 192.137C51.5879 192.019 51.524 191.921 51.4356 191.842C51.3471 191.754 51.2291 191.685 51.0816 191.636C50.944 191.587 50.7719 191.562 50.5655 191.562C50.3787 191.562 50.2066 191.582 50.0493 191.621C49.892 191.651 49.7446 191.705 49.6069 191.783C49.4693 191.862 49.3415 191.965 49.2235 192.093C49.1252 192.221 49.0613 192.319 49.0318 192.388C49.0121 192.457 49.0072 192.53 49.017 192.609L48.9138 192.742L48.8106 192.668L47.4096 191.592C47.6456 191.208 47.9307 190.889 48.2649 190.633C48.5992 190.377 48.963 190.186 49.3562 190.058C49.7593 189.92 50.1722 189.851 50.595 189.851C51.1455 189.851 51.6469 189.965 52.0992 190.191C52.5612 190.407 52.9299 190.717 53.2052 191.12C53.4805 191.513 53.6181 191.98 53.6181 192.521C53.6181 192.884 53.5739 193.224 53.4854 193.538C53.3969 193.853 53.2642 194.158 53.0872 194.453C52.9201 194.747 52.7087 195.052 52.4531 195.367C52.1975 195.681 51.8927 196.016 51.5388 196.37C51.1947 196.724 50.8063 197.117 50.3738 197.549H52.925C53.0921 197.549 53.2101 197.54 53.2789 197.52C53.3478 197.5 53.4117 197.466 53.4706 197.417H53.6329V197.549V199.216H47.6308V197.712ZM57.762 199.393C57.182 199.393 56.6118 199.304 56.0514 199.127C55.491 198.941 55.0535 198.651 54.7389 198.257L55.6974 196.753L55.7712 196.635L55.9187 196.724C55.9383 196.792 55.958 196.871 55.9776 196.96C56.0071 197.038 56.0809 197.136 56.1988 197.254C56.3955 197.412 56.6167 197.54 56.8625 197.638C57.1181 197.726 57.3835 197.771 57.6588 197.771C57.9243 197.771 58.1504 197.721 58.3372 197.623C58.524 197.525 58.6665 197.387 58.7648 197.21C58.873 197.023 58.927 196.812 58.927 196.576C58.927 196.301 58.8828 196.07 58.7943 195.883C58.7058 195.696 58.5682 195.554 58.3814 195.455C58.1946 195.347 57.9537 195.283 57.6588 195.264C57.3737 195.234 57.0296 195.244 56.6265 195.293V193.671C57.0296 193.691 57.3688 193.676 57.6441 193.627C57.9292 193.578 58.1553 193.504 58.3224 193.405C58.4896 193.297 58.6075 193.174 58.6763 193.037C58.755 192.899 58.7943 192.752 58.7943 192.594C58.7943 192.427 58.7648 192.28 58.7058 192.152C58.6567 192.024 58.583 191.916 58.4846 191.828C58.3863 191.729 58.2634 191.656 58.116 191.606C57.9783 191.557 57.821 191.533 57.6441 191.533C57.4474 191.533 57.2508 191.562 57.0542 191.621C56.8575 191.67 56.6757 191.749 56.5085 191.857C56.3414 191.965 56.1939 192.103 56.0661 192.27L54.8864 191.061C55.2501 190.628 55.6876 190.318 56.1988 190.132C56.7199 189.945 57.2361 189.851 57.7473 189.851C58.3175 189.851 58.8287 189.96 59.281 190.176C59.7431 190.382 60.1068 190.667 60.3723 191.031C60.6377 191.395 60.7704 191.808 60.7704 192.27C60.7704 192.624 60.6918 192.938 60.5345 193.214C60.387 193.489 60.2002 193.72 59.9741 193.907C59.7578 194.084 59.5464 194.221 59.34 194.32C59.5956 194.408 59.8512 194.551 60.1068 194.747C60.3624 194.934 60.5738 195.185 60.7409 195.5C60.9179 195.814 61.0064 196.193 61.0064 196.635C61.0064 197.156 60.8687 197.628 60.5935 198.051C60.328 198.464 59.9544 198.793 59.4727 199.039C58.991 199.275 58.4207 199.393 57.762 199.393ZM73.0105 199.216V197.092H69.6481V195.765L73.4824 190.028H74.9718V195.426H76.1958V197.107H74.9718V199.216H73.0105ZM71.6537 195.47H73.0695V193.17L71.6537 195.47ZM80.2955 199.393C79.6073 199.393 78.9928 199.275 78.4521 199.039C77.9114 198.793 77.5083 198.415 77.2429 197.903L78.6438 196.738L78.7471 196.65L78.8503 196.768C78.8503 196.846 78.865 196.92 78.8945 196.989C78.924 197.058 78.9879 197.156 79.0862 197.284C79.2435 197.431 79.4205 197.544 79.6171 197.623C79.8138 197.702 80.0202 197.741 80.2365 197.741C80.443 197.741 80.6249 197.707 80.7822 197.638C80.9493 197.559 81.0918 197.451 81.2098 197.313C81.3278 197.176 81.4163 197.023 81.4753 196.856C81.5343 196.679 81.5637 196.497 81.5637 196.311C81.5637 196.085 81.5343 195.878 81.4753 195.691C81.4261 195.495 81.3475 195.328 81.2393 195.19C81.1312 195.042 80.9935 194.929 80.8264 194.851C80.6593 194.762 80.4626 194.718 80.2365 194.718C80.0497 194.718 79.8728 194.738 79.7056 194.777C79.5385 194.816 79.3861 194.885 79.2485 194.983C79.1207 195.072 79.0027 195.19 78.8945 195.337L77.641 195.072L77.9802 190.028H83.0679V191.651H79.7204L79.6024 193.361C79.6909 193.302 79.8039 193.248 79.9416 193.199C80.0792 193.15 80.2218 193.115 80.3692 193.096C80.5167 193.066 80.6494 193.052 80.7674 193.052C81.1803 193.052 81.5539 193.115 81.8882 193.243C82.2224 193.371 82.5076 193.563 82.7435 193.818C82.9893 194.064 83.1761 194.379 83.3039 194.762C83.4317 195.146 83.4956 195.588 83.4956 196.089C83.4956 196.768 83.358 197.358 83.0827 197.859C82.8074 198.351 82.4289 198.729 81.9472 198.995C81.4753 199.26 80.9247 199.393 80.2955 199.393ZM87.7722 199.393C87.0841 199.393 86.4991 199.211 86.0174 198.847C85.5356 198.474 85.1719 197.957 84.9261 197.299C84.6803 196.63 84.5574 195.858 84.5574 194.983C84.5574 193.912 84.7147 192.997 85.0293 192.24C85.3439 191.474 85.7667 190.884 86.2975 190.471C86.8383 190.058 87.4478 189.851 88.1262 189.851C88.5489 189.851 88.9913 189.925 89.4534 190.073C89.9253 190.21 90.3284 190.451 90.6627 190.795L89.5861 192.005L89.4977 192.108L89.3649 192.005C89.3551 191.926 89.3207 191.867 89.2617 191.828C89.2027 191.788 89.1044 191.729 88.9668 191.651C88.9078 191.631 88.8439 191.616 88.775 191.606C88.7062 191.587 88.6374 191.572 88.5686 191.562C88.4998 191.552 88.4309 191.547 88.3621 191.547C88.2245 191.547 88.077 191.562 87.9197 191.592C87.7722 191.621 87.6297 191.68 87.4921 191.769C87.3544 191.847 87.2217 191.965 87.0939 192.122C86.9759 192.28 86.8727 192.486 86.7842 192.742C86.6957 192.997 86.6318 193.317 86.5925 193.7C86.7203 193.573 86.8678 193.464 87.0349 193.376C87.2119 193.288 87.3937 193.219 87.5805 193.17C87.7673 193.12 87.9492 193.096 88.1262 193.096C88.5096 193.096 88.8635 193.155 89.188 193.273C89.5124 193.381 89.7926 193.558 90.0285 193.804C90.2743 194.04 90.4611 194.349 90.5889 194.733C90.7266 195.106 90.7954 195.559 90.7954 196.089C90.7954 196.699 90.6676 197.254 90.412 197.756C90.1564 198.257 89.8024 198.655 89.3502 198.95C88.8979 199.245 88.372 199.393 87.7722 199.393ZM87.8017 197.771C87.9689 197.771 88.1163 197.726 88.2442 197.638C88.3818 197.549 88.4998 197.431 88.5981 197.284C88.6964 197.127 88.7701 196.95 88.8193 196.753C88.8684 196.547 88.893 196.325 88.893 196.089C88.893 195.853 88.8635 195.647 88.8045 195.47C88.7456 195.293 88.662 195.146 88.5538 195.028C88.4555 194.91 88.3376 194.821 88.1999 194.762C88.0721 194.703 87.9345 194.674 87.787 194.674C87.6592 194.674 87.5412 194.693 87.4331 194.733C87.3249 194.772 87.2217 194.831 87.1234 194.91C87.0349 194.979 86.9464 195.067 86.8579 195.175C86.7793 195.273 86.7006 195.391 86.622 195.529C86.622 195.922 86.6515 196.261 86.7105 196.547C86.7694 196.832 86.8481 197.068 86.9464 197.254C87.0546 197.431 87.1775 197.564 87.3151 197.653C87.4626 197.731 87.6248 197.771 87.8017 197.771Z" fill="#020202"/>
                            <path d="M40.9996 181.935C41.4241 181.935 41.7339 182.027 41.9289 182.21C42.124 182.391 42.2215 182.642 42.2215 182.961C42.2215 183.105 42.1997 183.243 42.1562 183.375C42.1127 183.506 42.0414 183.622 41.9424 183.724C41.8449 183.826 41.7144 183.907 41.5509 183.967C41.3874 184.025 41.1856 184.055 40.9456 184.055H40.6463V185.225H39.9487V181.935H40.9996ZM40.9636 182.507H40.6463V183.483H40.8758C41.0063 183.483 41.1196 183.466 41.2156 183.431C41.3116 183.397 41.3859 183.343 41.4384 183.269C41.4909 183.196 41.5171 183.101 41.5171 182.986C41.5171 182.824 41.4721 182.704 41.3821 182.626C41.2921 182.546 41.1526 182.507 40.9636 182.507ZM43.8191 182.657C44.1566 182.657 44.4154 182.731 44.5954 182.878C44.7755 183.025 44.8655 183.248 44.8655 183.548V185.225H44.3862L44.2534 184.883H44.2354C44.1634 184.973 44.0899 185.046 44.0149 185.103C43.9399 185.16 43.8536 185.202 43.7561 185.229C43.6586 185.256 43.5401 185.27 43.4006 185.27C43.2521 185.27 43.1185 185.241 43 185.184C42.883 185.127 42.7908 185.04 42.7233 184.923C42.6558 184.805 42.622 184.655 42.622 184.473C42.622 184.206 42.7158 184.01 42.9033 183.884C43.0908 183.756 43.3721 183.686 43.7471 183.672L44.1837 183.659V183.548C44.1837 183.416 44.1491 183.32 44.0801 183.258C44.0111 183.197 43.9151 183.166 43.7921 183.166C43.6706 183.166 43.5513 183.183 43.4343 183.218C43.3173 183.252 43.2003 183.296 43.0833 183.348L42.856 182.885C42.9895 182.814 43.1388 182.759 43.3038 182.718C43.4703 182.678 43.6421 182.657 43.8191 182.657ZM44.1837 184.059L43.9181 184.068C43.6961 184.074 43.5416 184.114 43.4546 184.188C43.3691 184.261 43.3263 184.358 43.3263 184.478C43.3263 184.583 43.3571 184.658 43.4186 184.703C43.4801 184.746 43.5603 184.768 43.6593 184.768C43.8064 184.768 43.9301 184.725 44.0306 184.638C44.1326 184.551 44.1837 184.427 44.1837 184.266V184.059ZM47.3295 184.478C47.3295 184.649 47.289 184.794 47.2079 184.912C47.1284 185.029 47.0092 185.118 46.8502 185.18C46.6911 185.24 46.4931 185.27 46.2561 185.27C46.0806 185.27 45.9298 185.259 45.8038 185.236C45.6793 185.214 45.5533 185.176 45.4258 185.124V184.557C45.5623 184.618 45.7085 184.669 45.8646 184.71C46.0221 184.749 46.1601 184.768 46.2786 184.768C46.4121 184.768 46.5074 184.749 46.5644 184.71C46.6229 184.669 46.6521 184.617 46.6521 184.552C46.6521 184.51 46.6401 184.473 46.6161 184.44C46.5936 184.405 46.5441 184.367 46.4676 184.325C46.3911 184.281 46.2711 184.225 46.1076 184.156C45.9501 184.09 45.8203 184.023 45.7183 183.956C45.6178 183.888 45.5428 183.809 45.4933 183.717C45.4453 183.624 45.4213 183.506 45.4213 183.364C45.4213 183.131 45.5113 182.957 45.6913 182.84C45.8728 182.721 46.1151 182.662 46.4181 182.662C46.5741 182.662 46.7226 182.678 46.8637 182.709C47.0062 182.741 47.1524 182.791 47.3025 182.86L47.0954 183.355C46.9709 183.301 46.8532 183.257 46.7421 183.222C46.6326 183.188 46.5209 183.17 46.4069 183.17C46.3064 183.17 46.2306 183.184 46.1796 183.211C46.1286 183.238 46.1031 183.279 46.1031 183.335C46.1031 183.375 46.1158 183.411 46.1413 183.443C46.1683 183.474 46.2193 183.509 46.2944 183.548C46.3709 183.586 46.4826 183.635 46.6296 183.695C46.7722 183.753 46.8959 183.815 47.0009 183.879C47.1059 183.942 47.1869 184.021 47.2439 184.115C47.301 184.209 47.3295 184.329 47.3295 184.478ZM49.6202 184.478C49.6202 184.649 49.5797 184.794 49.4987 184.912C49.4192 185.029 49.2999 185.118 49.1409 185.18C48.9819 185.24 48.7838 185.27 48.5468 185.27C48.3713 185.27 48.2205 185.259 48.0945 185.236C47.97 185.214 47.844 185.176 47.7165 185.124V184.557C47.853 184.618 47.9993 184.669 48.1553 184.71C48.3128 184.749 48.4508 184.768 48.5693 184.768C48.7028 184.768 48.7981 184.749 48.8551 184.71C48.9136 184.669 48.9429 184.617 48.9429 184.552C48.9429 184.51 48.9309 184.473 48.9069 184.44C48.8844 184.405 48.8349 184.367 48.7583 184.325C48.6818 184.281 48.5618 184.225 48.3983 184.156C48.2408 184.09 48.111 184.023 48.009 183.956C47.9085 183.888 47.8335 183.809 47.784 183.717C47.736 183.624 47.712 183.506 47.712 183.364C47.712 183.131 47.802 182.957 47.982 182.84C48.1635 182.721 48.4058 182.662 48.7088 182.662C48.8649 182.662 49.0134 182.678 49.1544 182.709C49.2969 182.741 49.4432 182.791 49.5932 182.86L49.3862 183.355C49.2616 183.301 49.1439 183.257 49.0329 183.222C48.9234 183.188 48.8116 183.17 48.6976 183.17C48.5971 183.17 48.5213 183.184 48.4703 183.211C48.4193 183.238 48.3938 183.279 48.3938 183.335C48.3938 183.375 48.4066 183.411 48.4321 183.443C48.4591 183.474 48.5101 183.509 48.5851 183.548C48.6616 183.586 48.7733 183.635 48.9204 183.695C49.0629 183.753 49.1866 183.815 49.2916 183.879C49.3967 183.942 49.4777 184.021 49.5347 184.115C49.5917 184.209 49.6202 184.329 49.6202 184.478ZM50.842 181.724V182.538C50.842 182.633 50.839 182.726 50.833 182.819C50.8285 182.912 50.8225 182.984 50.815 183.035H50.842C50.9081 182.932 50.9981 182.844 51.1121 182.772C51.2261 182.699 51.3738 182.662 51.5554 182.662C51.8374 182.662 52.0662 182.772 52.2417 182.993C52.4172 183.213 52.505 183.536 52.505 183.962C52.505 184.249 52.4645 184.49 52.3834 184.685C52.3024 184.878 52.1892 185.025 52.0437 185.124C51.8982 185.221 51.7294 185.27 51.5374 185.27C51.3528 185.27 51.2073 185.237 51.1008 185.171C50.9943 185.105 50.9081 185.031 50.842 184.948H50.7948L50.68 185.225H50.1557V181.724H50.842ZM51.3348 183.211C51.2148 183.211 51.1196 183.236 51.0491 183.285C50.9786 183.335 50.9268 183.409 50.8938 183.508C50.8623 183.607 50.845 183.732 50.842 183.884V183.958C50.842 184.203 50.8781 184.39 50.9501 184.521C51.0221 184.65 51.1533 184.714 51.3438 184.714C51.4849 184.714 51.5966 184.649 51.6791 184.518C51.7631 184.388 51.8051 184.2 51.8051 183.953C51.8051 183.707 51.7631 183.522 51.6791 183.398C51.5951 183.273 51.4804 183.211 51.3348 183.211ZM55.3582 183.962C55.3582 184.173 55.3297 184.359 55.2727 184.521C55.2172 184.683 55.1355 184.82 55.0275 184.932C54.9209 185.043 54.7919 185.127 54.6404 185.184C54.4904 185.241 54.3209 185.27 54.1319 185.27C53.9549 185.27 53.7921 185.241 53.6436 185.184C53.4966 185.127 53.3683 185.043 53.2588 184.932C53.1508 184.82 53.0668 184.683 53.0068 184.521C52.9483 184.359 52.919 184.173 52.919 183.962C52.919 183.683 52.9685 183.447 53.0675 183.254C53.1665 183.06 53.3075 182.913 53.4906 182.813C53.6736 182.712 53.8918 182.662 54.1454 182.662C54.3809 182.662 54.5894 182.712 54.7709 182.813C54.9539 182.913 55.0972 183.06 55.2007 183.254C55.3057 183.447 55.3582 183.683 55.3582 183.962ZM53.6188 183.962C53.6188 184.127 53.6368 184.266 53.6728 184.379C53.7088 184.491 53.7651 184.576 53.8416 184.633C53.9181 184.69 54.0179 184.719 54.1409 184.719C54.2624 184.719 54.3606 184.69 54.4356 184.633C54.5122 184.576 54.5677 184.491 54.6022 184.379C54.6382 184.266 54.6562 184.127 54.6562 183.962C54.6562 183.796 54.6382 183.658 54.6022 183.548C54.5677 183.437 54.5122 183.354 54.4356 183.299C54.3591 183.243 54.2594 183.215 54.1364 183.215C53.9549 183.215 53.8228 183.278 53.7403 183.402C53.6593 183.527 53.6188 183.713 53.6188 183.962ZM56.6116 185.225H55.9253V181.724H56.6116V185.225ZM58.3938 184.723C58.4688 184.723 58.5415 184.716 58.6121 184.701C58.6841 184.686 58.7553 184.667 58.8258 184.644V185.155C58.7523 185.188 58.6608 185.215 58.5513 185.236C58.4433 185.259 58.3248 185.27 58.1958 185.27C58.0457 185.27 57.9107 185.246 57.7907 185.198C57.6722 185.148 57.5785 185.064 57.5094 184.944C57.4419 184.822 57.4082 184.653 57.4082 184.437V183.224H57.0797V182.934L57.4577 182.705L57.6557 182.174H58.0945V182.709H58.7988V183.224H58.0945V184.437C58.0945 184.533 58.1215 184.605 58.1755 184.653C58.231 184.7 58.3038 184.723 58.3938 184.723Z" fill="#020202"/>
                            <ellipse cx="123.517" cy="194.216" rx="9.52153" ry="9.44218" stroke="#020202" stroke-opacity="0.25" stroke-width="1.85141"/>
                            <path d="M123.517 184.774C124.767 184.774 126.005 185.018 127.16 185.492C128.316 185.967 129.365 186.662 130.249 187.539C131.134 188.416 131.835 189.457 132.313 190.602C132.792 191.748 133.038 192.976 133.038 194.216" stroke="#020202" stroke-width="1.85141" stroke-linecap="round"/>
                            <path d="M47.5347 213.953H129.465" stroke="#D6D6D6" stroke-linecap="round"/>
                        </g>
                        <rect x="-2.09851" y="2.09851" width="116.118" height="223.841" rx="11.8916" transform="matrix(-1 0 0 1 144.46 7.48083)" stroke="black" stroke-width="4.19702"/>
                        <rect x="0.699504" y="-0.699504" width="121.714" height="229.437" rx="14.6896" transform="matrix(-1 0 0 1 150.056 7.48083)" stroke="#C8C8C8" stroke-width="1.39901"/>
                        <defs>
                            <filter id="filter0_f_5_20425" x="35.5347" y="81.1469" width="114.199" height="43.9739" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                                <feGaussianBlur stdDeviation="2" result="effect1_foregroundBlur_5_20425"/>
                            </filter>
                            <filter id="filter1_f_5_20425" x="35.5347" y="127.813" width="114.199" height="43.9741" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                                <feGaussianBlur stdDeviation="2" result="effect1_foregroundBlur_5_20425"/>
                            </filter>
                            <filter id="filter2_f_5_20425" x="35.5347" y="174.479" width="114.199" height="43.974" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                                <feGaussianBlur stdDeviation="2" result="effect1_foregroundBlur_5_20425"/>
                            </filter>
                        </defs>
                    </svg>
                    <p><?= __('When using a new browser, you need an additional code from your phone.'); ?></p>
                </div>
                <div class="step">
                    <!-- SVG setup TOTP login -->
                    <svg width="177" height="243" viewBox="0 0 177 243" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_1_27469)">
                            <path d="M52.4666 32.0295V36.4008H53.7262C54.562 36.4008 55.1406 36.2234 55.4883 35.8865C55.8361 35.5497 56.0027 34.9608 56.0027 34.1625C56.0027 33.3911 55.8479 32.8447 55.5264 32.5284C55.2049 32.1864 54.6657 32.0347 53.881 32.0347L52.4666 32.0295ZM50.4092 30.3685H54.3691C55.5658 30.3685 56.4908 30.7117 57.16 31.4086C57.8291 32.1054 58.1624 33.0684 58.1624 34.2974C58.1704 34.7707 58.1008 35.2421 57.9564 35.6937C57.8198 36.1136 57.6064 36.5057 57.3266 36.8508C57.0091 37.2472 56.593 37.5571 56.1182 37.7507C55.6419 37.9281 55.0252 38.0169 54.2405 38.0169H52.4666V40.7977H50.4092V30.3685Z" fill="var(--icon-color)"/>
                            <path d="M62.3022 36.4895H64.8739V34.9056H62.457C61.9807 34.9056 61.6475 34.9686 61.4664 35.0958C61.2853 35.2231 61.204 35.4507 61.204 35.767C61.204 36.0331 61.2801 36.2234 61.4218 36.3365C61.5635 36.4496 61.8522 36.4895 62.3022 36.4895ZM59.577 30.3685H63.7757C64.8438 30.3685 65.6402 30.6102 66.1808 31.091C66.7214 31.5718 66.9903 32.2828 66.9903 33.2329V38.0349H61.4664C60.6949 38.0349 60.0913 37.8446 59.6793 37.4653C59.2673 37.086 59.0692 36.5396 59.0692 35.83C59.0692 34.9557 59.3001 34.3347 59.7764 33.9555C60.2527 33.5762 61.0373 33.3795 62.1618 33.3795H64.8608V33.1943C64.8608 32.7379 64.7204 32.423 64.4501 32.2314C64.1798 32.0398 63.7035 31.9524 62.9976 31.9524H59.577V30.3685Z" fill="var(--icon-color)"/>
                            <path d="M68.6671 36.438H72.997C73.3828 36.438 73.6662 36.375 73.8328 36.2606C73.9255 36.1982 73.9995 36.1129 74.0475 36.0133C74.0954 35.9137 74.1155 35.8034 74.1058 35.6936C74.1161 35.5836 74.0966 35.4728 74.0491 35.3725C74.0016 35.2723 73.9279 35.1861 73.8355 35.1228C73.6557 34.9942 73.3736 34.9325 72.9997 34.9325H71.2257C70.176 34.9325 69.4649 34.768 69.0909 34.4517C68.717 34.1354 68.5385 33.5646 68.5385 32.7662C68.5385 31.9434 68.7576 31.334 69.2077 30.9418C69.6577 30.5497 70.3531 30.3569 71.2716 30.3569H75.6816V31.9524H72.0589C71.4667 31.9524 71.0809 32.0034 70.9016 32.1054C70.7218 32.2057 70.6313 32.3831 70.6313 32.6492C70.6228 32.7471 70.6396 32.8456 70.6802 32.9355C70.7208 33.0254 70.7839 33.1038 70.8636 33.1635C71.0171 33.2766 71.2742 33.328 71.6088 33.328H73.476C74.3249 33.328 74.9796 33.5299 75.4179 33.9233C75.8561 34.3167 76.0857 34.8734 76.0857 35.6088C76.0857 36.3185 75.8797 36.8945 75.4822 37.3444C75.2944 37.5614 75.0594 37.7343 74.7944 37.8505C74.5294 37.9666 74.2411 38.023 73.9509 38.0155H68.6671V36.438Z" fill="var(--icon-color)"/>
                            <path d="M77.4388 36.438H81.7688C82.1545 36.438 82.4379 36.375 82.6046 36.2606C82.6967 36.1979 82.7703 36.1124 82.8178 36.0129C82.8652 35.9133 82.8849 35.8031 82.8749 35.6936C82.8853 35.5836 82.8657 35.4728 82.8182 35.3725C82.7708 35.2723 82.697 35.1861 82.6046 35.1228C82.4248 34.9942 82.1427 34.9325 81.7688 34.9325H79.9948C78.9451 34.9325 78.234 34.768 77.86 34.4517C77.4861 34.1354 77.3076 33.562 77.3076 32.7636C77.3076 31.9408 77.5268 31.3314 77.9768 30.9393C78.4269 30.5472 79.121 30.3569 80.046 30.3569H84.4573V31.9524H80.8306C80.2393 31.9524 79.8535 32.0034 79.6733 32.1054C79.4936 32.2057 79.4031 32.3831 79.4031 32.6492C79.3946 32.7471 79.4114 32.8456 79.452 32.9355C79.4926 33.0254 79.5556 33.1038 79.6353 33.1635C79.7888 33.2766 80.046 33.328 80.3806 33.328H82.2451C83.094 33.328 83.75 33.5299 84.187 33.9233C84.6239 34.3167 84.8548 34.8734 84.8548 35.6088C84.8548 36.3185 84.6501 36.8945 84.2513 37.3444C84.0637 37.5612 83.8288 37.7341 83.5641 37.8502C83.2993 37.9663 83.0113 38.0228 82.7214 38.0155H77.4113V36.438H77.4388Z" fill="var(--icon-color)"/>
                            <path d="M88.3902 27.594V30.3684H90.1524C90.9396 30.3684 91.5537 30.4572 92.0287 30.6474C92.509 30.8316 92.9274 31.1432 93.2371 31.5474C93.5171 31.8959 93.7309 32.2909 93.8683 32.7135C94.0113 33.1645 94.0804 33.6349 94.0729 34.1071C94.0729 35.3362 93.7388 36.2992 93.0705 36.996C92.4026 37.6929 91.4763 38.0348 90.281 38.0348H86.3197V27.594H88.3902ZM89.6407 32.0295H88.3797V36.4008H89.7942C90.5814 36.4008 91.1312 36.2362 91.4409 35.9186C91.7505 35.6011 91.9158 35.0444 91.9158 34.2589C91.9158 33.4733 91.7361 32.8909 91.391 32.5489C91.0459 32.2069 90.4607 32.0295 89.6407 32.0295Z" fill="var(--icon-color)"/>
                            <path d="M96.9795 34.2087C96.9795 34.9428 97.1462 35.4944 97.4939 35.9186C97.8416 36.3429 98.3166 36.5267 98.9464 36.5267C99.5762 36.5267 100.039 36.3249 100.4 35.9186C100.761 35.5124 100.925 34.9428 100.925 34.2087C100.925 33.4746 100.744 32.9153 100.4 32.5103C100.056 32.1054 99.5775 31.9022 98.9464 31.9022C98.6732 31.89 98.4007 31.9383 98.1492 32.0436C97.8977 32.1489 97.6737 32.3084 97.4939 32.5103C97.1462 32.9153 96.9795 33.4862 96.9795 34.2087ZM103.074 34.2087C103.074 35.4086 102.702 36.3716 101.956 37.0976C101.21 37.8073 100.219 38.175 98.9595 38.175C97.6999 38.175 96.6961 37.8201 95.9508 37.0976C95.2056 36.375 94.8329 35.4262 94.8329 34.2215C94.8329 33.0169 95.2056 32.0539 95.9508 31.3314C96.6961 30.6088 97.6999 30.2424 98.9569 30.2424C100.214 30.2424 101.207 30.6101 101.954 31.3314C102.7 32.0526 103.074 33.004 103.074 34.2087Z" fill="var(--icon-color)"/>
                            <path d="M106.443 38.0348H104.309V27.594H106.443V38.0348Z" fill="var(--icon-color)"/>
                            <path d="M107.433 30.3684H108.885V27.594H110.943V30.3684H113.116V31.9022H110.943V34.9943C110.943 35.5638 111.046 35.9572 111.238 36.1848C111.429 36.4123 111.779 36.5139 112.267 36.5139H113.116V38.0477H111.226C110.468 38.0477 109.888 37.8446 109.477 37.4267C109.066 37.0089 108.874 36.4136 108.874 35.6397V31.9022H107.42V30.3684H107.433Z" fill="var(--icon-color)"/>
                            <path d="M126.257 32.7636L121.656 28.5184C121.46 28.3409 121.202 28.2424 120.935 28.2424C120.667 28.2424 120.41 28.3409 120.213 28.5184L117.326 31.1938C117.705 31.3314 118.044 31.5545 118.318 31.8449C118.591 32.1353 118.791 32.4849 118.901 32.8652H122.798C122.845 32.8652 122.892 32.8744 122.936 32.8922C122.98 32.9101 123.02 32.9362 123.054 32.9692C123.087 33.0022 123.114 33.0413 123.132 33.0843C123.15 33.1274 123.159 33.1735 123.159 33.22V33.8024C123.159 33.849 123.15 33.8951 123.132 33.9381C123.114 33.9812 123.087 34.0203 123.054 34.0533C123.02 34.0862 122.98 34.1124 122.936 34.1302C122.892 34.1481 122.845 34.1573 122.798 34.1573H122.348V34.9814C122.348 35.0279 122.339 35.074 122.321 35.117C122.303 35.16 122.277 35.1992 122.244 35.2322C122.21 35.2651 122.17 35.2913 122.127 35.3092C122.083 35.327 122.036 35.3362 121.988 35.3362H121C120.953 35.3362 120.906 35.327 120.862 35.3092C120.818 35.2913 120.779 35.2651 120.745 35.2322C120.712 35.1992 120.685 35.16 120.667 35.117C120.65 35.074 120.64 35.0279 120.641 34.9814V34.1573H118.901C118.797 34.5418 118.599 34.8958 118.325 35.1893C118.051 35.4828 117.708 35.707 117.326 35.8428L120.226 38.5221C120.423 38.6995 120.681 38.798 120.948 38.798C121.215 38.798 121.473 38.6995 121.67 38.5221L126.262 34.2794C126.366 34.1813 126.449 34.0635 126.506 33.933C126.562 33.8025 126.591 33.6622 126.591 33.5204C126.59 33.3787 126.56 33.2385 126.503 33.1084C126.446 32.9783 126.362 32.861 126.257 32.7636Z" fill="#D40101"/>
                            <path d="M116.472 32.351C116.284 32.3546 116.1 32.3985 115.931 32.4795C115.743 32.5711 115.583 32.7103 115.468 32.8828C115.353 33.0552 115.287 33.2547 115.277 33.4605C115.267 33.6663 115.313 33.871 115.41 34.0535C115.508 34.236 115.654 34.3896 115.832 34.4984C116.011 34.6073 116.216 34.6675 116.426 34.6728C116.636 34.678 116.844 34.6282 117.028 34.5284C117.212 34.4286 117.366 34.2825 117.473 34.1052C117.58 33.9278 117.636 33.7257 117.637 33.5196C117.641 33.3674 117.613 33.2161 117.556 33.0744C117.5 32.9328 117.414 32.8037 117.306 32.6948C117.197 32.5859 117.067 32.4994 116.924 32.4404C116.781 32.3813 116.627 32.3509 116.472 32.351Z" fill="#D40101"/>
                        </g>
                        <g filter="url(#filter0_d_1_27469)">
                            <path d="M9.07132 55.6519C9.07132 54.7404 9.81026 54.0015 10.7218 54.0015H166.278C167.19 54.0015 167.929 54.7404 167.929 55.6519V192.3C167.929 193.211 167.19 193.95 166.278 193.95H10.7218C9.81026 193.95 9.07132 193.211 9.07132 192.3V55.6519Z" fill="#F1F1F1" shape-rendering="crispEdges"/>
                            <path d="M28.417 84.8071H24.3057V77.6684H28.417V78.9086H25.8193V80.476H28.2363V81.7162H25.8193V83.5571H28.417V84.8071ZM34.833 84.8071H33.3438V81.6186C33.3438 81.2247 33.2738 80.9301 33.1338 80.7348C32.9938 80.5362 32.7708 80.437 32.4648 80.437C32.0482 80.437 31.7471 80.5769 31.5615 80.8569C31.376 81.1336 31.2832 81.5942 31.2832 82.2387V84.8071H29.7939V79.3481H30.9316L31.1318 80.0463H31.2148C31.3809 79.7827 31.6087 79.5841 31.8984 79.4506C32.1914 79.3139 32.5234 79.2455 32.8945 79.2455C33.5293 79.2455 34.0111 79.4181 34.3398 79.7631C34.6686 80.1049 34.833 80.5997 34.833 81.2475V84.8071ZM38.666 83.7182C38.9264 83.7182 39.2389 83.6612 39.6035 83.5473V84.6557C39.2324 84.8217 38.7767 84.9047 38.2363 84.9047C37.6406 84.9047 37.2061 84.755 36.9326 84.4555C36.6624 84.1528 36.5273 83.7003 36.5273 83.0981V80.4662H35.8145V79.8364L36.6348 79.3383L37.0645 78.186H38.0166V79.3481H39.5449V80.4662H38.0166V83.0981C38.0166 83.3097 38.0752 83.4659 38.1924 83.5668C38.3128 83.6677 38.4707 83.7182 38.666 83.7182ZM42.9727 80.3051C42.6569 80.3051 42.4095 80.406 42.2305 80.6078C42.0514 80.8064 41.9489 81.0896 41.9229 81.4575H44.0127C44.0062 81.0896 43.9102 80.8064 43.7246 80.6078C43.5391 80.406 43.2884 80.3051 42.9727 80.3051ZM43.1826 84.9047C42.3037 84.9047 41.6169 84.6622 41.1221 84.1772C40.6273 83.6922 40.3799 83.0053 40.3799 82.1166C40.3799 81.2019 40.6077 80.4955 41.0635 79.9975C41.5225 79.4962 42.1556 79.2455 42.9629 79.2455C43.7344 79.2455 44.335 79.4653 44.7646 79.9047C45.1943 80.3442 45.4092 80.9513 45.4092 81.726V82.4487H41.8887C41.9049 82.8718 42.0303 83.2023 42.2646 83.4399C42.499 83.6775 42.8278 83.7963 43.251 83.7963C43.5798 83.7963 43.8906 83.7621 44.1836 83.6938C44.4766 83.6254 44.7826 83.5164 45.1016 83.3666V84.519C44.8411 84.6492 44.5628 84.7452 44.2666 84.8071C43.9704 84.8722 43.609 84.9047 43.1826 84.9047ZM49.667 79.2455C49.8688 79.2455 50.0365 79.2602 50.1699 79.2895L50.0576 80.686C49.9372 80.6534 49.7907 80.6371 49.6182 80.6371C49.1429 80.6371 48.7718 80.7592 48.5049 81.0034C48.2412 81.2475 48.1094 81.5893 48.1094 82.0287V84.8071H46.6201V79.3481H47.748L47.9678 80.2661H48.041C48.2103 79.9601 48.4382 79.7143 48.7246 79.5287C49.0143 79.3399 49.3285 79.2455 49.667 79.2455ZM56.0586 83.7182C56.319 83.7182 56.6315 83.6612 56.9961 83.5473V84.6557C56.625 84.8217 56.1693 84.9047 55.6289 84.9047C55.0332 84.9047 54.5986 84.755 54.3252 84.4555C54.055 84.1528 53.9199 83.7003 53.9199 83.0981V80.4662H53.207V79.8364L54.0273 79.3383L54.457 78.186H55.4092V79.3481H56.9375V80.4662H55.4092V83.0981C55.4092 83.3097 55.4678 83.4659 55.585 83.5668C55.7054 83.6677 55.8633 83.7182 56.0586 83.7182ZM63.1436 84.8071H61.6543V81.6186C61.6543 80.8308 61.3613 80.437 60.7754 80.437C60.3587 80.437 60.0576 80.5786 59.8721 80.8618C59.6865 81.145 59.5938 81.6039 59.5938 82.2387V84.8071H58.1045V77.2094H59.5938V78.7573C59.5938 78.8777 59.5824 79.1609 59.5596 79.6069L59.5254 80.0463H59.6035C59.9355 79.5125 60.4629 79.2455 61.1855 79.2455C61.8268 79.2455 62.3135 79.4181 62.6455 79.7631C62.9775 80.1082 63.1436 80.603 63.1436 81.2475V84.8071ZM66.9375 80.3051C66.6217 80.3051 66.3743 80.406 66.1953 80.6078C66.0163 80.8064 65.9137 81.0896 65.8877 81.4575H67.9775C67.971 81.0896 67.875 80.8064 67.6895 80.6078C67.5039 80.406 67.2533 80.3051 66.9375 80.3051ZM67.1475 84.9047C66.2686 84.9047 65.5817 84.6622 65.0869 84.1772C64.5921 83.6922 64.3447 83.0053 64.3447 82.1166C64.3447 81.2019 64.5726 80.4955 65.0283 79.9975C65.4873 79.4962 66.1204 79.2455 66.9277 79.2455C67.6992 79.2455 68.2998 79.4653 68.7295 79.9047C69.1592 80.3442 69.374 80.9513 69.374 81.726V82.4487H65.8535C65.8698 82.8718 65.9951 83.2023 66.2295 83.4399C66.4639 83.6775 66.7926 83.7963 67.2158 83.7963C67.5446 83.7963 67.8555 83.7621 68.1484 83.6938C68.4414 83.6254 68.7474 83.5164 69.0664 83.3666V84.519C68.806 84.6492 68.5277 84.7452 68.2314 84.8071C67.9352 84.8722 67.5739 84.9047 67.1475 84.9047ZM76.9912 83.186C76.9912 83.7459 76.7959 84.1723 76.4053 84.4653C76.0179 84.7582 75.4368 84.9047 74.6621 84.9047C74.265 84.9047 73.9264 84.8771 73.6465 84.8217C73.3665 84.7696 73.1045 84.6915 72.8604 84.5873V83.3569C73.137 83.4871 73.4479 83.5961 73.793 83.684C74.1413 83.7719 74.4473 83.8159 74.7109 83.8159C75.2513 83.8159 75.5215 83.6596 75.5215 83.3471C75.5215 83.2299 75.4857 83.1355 75.4141 83.0639C75.3424 82.989 75.2188 82.906 75.043 82.8149C74.8672 82.7205 74.6328 82.6114 74.3398 82.4877C73.9199 82.312 73.6107 82.1492 73.4121 81.9995C73.2168 81.8497 73.0736 81.6788 72.9824 81.4868C72.8945 81.2914 72.8506 81.0522 72.8506 80.769C72.8506 80.284 73.0378 79.9096 73.4121 79.6459C73.7897 79.379 74.3236 79.2455 75.0137 79.2455C75.6712 79.2455 76.3109 79.3888 76.9326 79.6752L76.4834 80.7495C76.21 80.6323 75.9544 80.5362 75.7168 80.4614C75.4792 80.3865 75.2367 80.3491 74.9893 80.3491C74.5498 80.3491 74.3301 80.4679 74.3301 80.7055C74.3301 80.839 74.4001 80.9545 74.54 81.0522C74.6833 81.1498 74.9941 81.2947 75.4727 81.4868C75.8991 81.6593 76.2116 81.8204 76.4102 81.9702C76.6087 82.1199 76.7552 82.2924 76.8496 82.4877C76.944 82.683 76.9912 82.9158 76.9912 83.186ZM78.0898 77.937C78.0898 77.4519 78.36 77.2094 78.9004 77.2094C79.4408 77.2094 79.7109 77.4519 79.7109 77.937C79.7109 78.1681 79.6426 78.3487 79.5059 78.4789C79.3724 78.6059 79.1706 78.6694 78.9004 78.6694C78.36 78.6694 78.0898 78.4252 78.0898 77.937ZM79.6426 84.8071H78.1533V79.3481H79.6426V84.8071ZM82.3281 82.019L80.5703 79.3481H82.2598L83.3193 81.0864L84.3887 79.3481H86.0781L84.3008 82.019L86.1611 84.8071H84.4668L83.3193 82.937L82.167 84.8071H80.4775L82.3281 82.019ZM91.3174 84.9047C90.6761 84.9047 90.1715 84.6557 89.8037 84.1577C89.4391 83.6596 89.2568 82.9695 89.2568 82.0873C89.2568 81.1922 89.4424 80.4955 89.8135 79.9975C90.1878 79.4962 90.7021 79.2455 91.3564 79.2455C92.0433 79.2455 92.5674 79.5125 92.9287 80.0463H92.9775C92.9027 79.6394 92.8652 79.2765 92.8652 78.9575V77.2094H94.3594V84.8071H93.2168L92.9287 84.0991H92.8652C92.5267 84.6362 92.0107 84.9047 91.3174 84.9047ZM91.8398 83.7182C92.2207 83.7182 92.499 83.6075 92.6748 83.3862C92.8538 83.1648 92.9515 82.7888 92.9678 82.2582V82.0971C92.9678 81.5112 92.8766 81.0912 92.6943 80.8373C92.5153 80.5834 92.2223 80.4565 91.8154 80.4565C91.4834 80.4565 91.2246 80.5981 91.0391 80.8813C90.8568 81.1612 90.7656 81.5698 90.7656 82.1069C90.7656 82.644 90.8584 83.0476 91.0439 83.3178C91.2295 83.5847 91.4948 83.7182 91.8398 83.7182ZM95.8535 77.937C95.8535 77.4519 96.1237 77.2094 96.6641 77.2094C97.2044 77.2094 97.4746 77.4519 97.4746 77.937C97.4746 78.1681 97.4062 78.3487 97.2695 78.4789C97.1361 78.6059 96.9342 78.6694 96.6641 78.6694C96.1237 78.6694 95.8535 78.4252 95.8535 77.937ZM97.4062 84.8071H95.917V79.3481H97.4062V84.8071ZM103.725 79.3481V80.1049L102.87 80.3246C103.026 80.5688 103.104 80.8422 103.104 81.145C103.104 81.7309 102.899 82.1883 102.489 82.517C102.082 82.8425 101.516 83.0053 100.79 83.0053L100.521 82.9907L100.302 82.9662C100.149 83.0834 100.072 83.2136 100.072 83.3569C100.072 83.5717 100.346 83.6791 100.893 83.6791H101.82C102.419 83.6791 102.875 83.8077 103.188 84.0649C103.503 84.322 103.661 84.6996 103.661 85.1977C103.661 85.8357 103.394 86.3305 102.86 86.6821C102.33 87.0336 101.566 87.2094 100.57 87.2094C99.8086 87.2094 99.2259 87.0759 98.8223 86.809C98.4219 86.5453 98.2217 86.1743 98.2217 85.6957C98.2217 85.367 98.3242 85.0919 98.5293 84.8705C98.7344 84.6492 99.0355 84.4913 99.4326 84.3969C99.2796 84.3318 99.1462 84.226 99.0322 84.0795C98.9183 83.9298 98.8613 83.7719 98.8613 83.6059C98.8613 83.3976 98.9215 83.225 99.042 83.0883C99.1624 82.9483 99.3366 82.8116 99.5645 82.6782C99.278 82.5545 99.0501 82.3559 98.8809 82.0825C98.7148 81.809 98.6318 81.4868 98.6318 81.1157C98.6318 80.52 98.8255 80.0593 99.2129 79.7338C99.6003 79.4083 100.154 79.2455 100.873 79.2455C101.026 79.2455 101.207 79.2602 101.415 79.2895C101.627 79.3155 101.762 79.3351 101.82 79.3481H103.725ZM99.5107 85.5786C99.5107 85.7836 99.6084 85.9448 99.8037 86.062C100.002 86.1791 100.279 86.2377 100.634 86.2377C101.168 86.2377 101.586 86.1645 101.889 86.018C102.191 85.8715 102.343 85.6713 102.343 85.4174C102.343 85.2123 102.253 85.0707 102.074 84.9926C101.895 84.9145 101.618 84.8754 101.244 84.8754H100.473C100.199 84.8754 99.9697 84.9389 99.7842 85.0659C99.6019 85.1961 99.5107 85.367 99.5107 85.5786ZM100.053 81.1352C100.053 81.4314 100.119 81.6658 100.253 81.8383C100.39 82.0108 100.596 82.0971 100.873 82.0971C101.153 82.0971 101.358 82.0108 101.488 81.8383C101.618 81.6658 101.684 81.4314 101.684 81.1352C101.684 80.4776 101.413 80.1489 100.873 80.1489C100.326 80.1489 100.053 80.4776 100.053 81.1352ZM104.564 77.937C104.564 77.4519 104.835 77.2094 105.375 77.2094C105.915 77.2094 106.186 77.4519 106.186 77.937C106.186 78.1681 106.117 78.3487 105.98 78.4789C105.847 78.6059 105.645 78.6694 105.375 78.6694C104.835 78.6694 104.564 78.4252 104.564 77.937ZM106.117 84.8071H104.628V79.3481H106.117V84.8071ZM109.984 83.7182C110.245 83.7182 110.557 83.6612 110.922 83.5473V84.6557C110.551 84.8217 110.095 84.9047 109.555 84.9047C108.959 84.9047 108.524 84.755 108.251 84.4555C107.981 84.1528 107.846 83.7003 107.846 83.0981V80.4662H107.133V79.8364L107.953 79.3383L108.383 78.186H109.335V79.3481H110.863V80.4662H109.335V83.0981C109.335 83.3097 109.394 83.4659 109.511 83.5668C109.631 83.6677 109.789 83.7182 109.984 83.7182ZM119.667 84.8071H118.178V81.6186C118.178 81.2247 118.108 80.9301 117.968 80.7348C117.828 80.5362 117.605 80.437 117.299 80.437C116.882 80.437 116.581 80.5769 116.396 80.8569C116.21 81.1336 116.117 81.5942 116.117 82.2387V84.8071H114.628V79.3481H115.766L115.966 80.0463H116.049C116.215 79.7827 116.443 79.5841 116.732 79.4506C117.025 79.3139 117.357 79.2455 117.729 79.2455C118.363 79.2455 118.845 79.4181 119.174 79.7631C119.503 80.1049 119.667 80.5997 119.667 81.2475V84.8071ZM125.067 84.8071L124.867 84.1088H124.789C124.63 84.3627 124.403 84.5597 124.11 84.6996C123.817 84.8364 123.484 84.9047 123.109 84.9047C122.468 84.9047 121.985 84.7338 121.659 84.392C121.334 84.047 121.171 83.5522 121.171 82.9077V79.3481H122.66V82.5366C122.66 82.9304 122.73 83.2267 122.87 83.4252C123.01 83.6205 123.233 83.7182 123.539 83.7182C123.956 83.7182 124.257 83.5799 124.442 83.3032C124.628 83.0232 124.721 82.561 124.721 81.9164V79.3481H126.21V84.8071H125.067ZM132.66 84.8071H131.171V81.6186C131.171 81.2247 131.104 80.9301 130.971 80.7348C130.84 80.5362 130.634 80.437 130.351 80.437C129.97 80.437 129.693 80.5769 129.521 80.8569C129.348 81.1368 129.262 81.5974 129.262 82.2387V84.8071H127.772V79.3481H128.91L129.11 80.0463H129.193C129.34 79.7957 129.551 79.6004 129.828 79.4604C130.105 79.3172 130.422 79.2455 130.78 79.2455C131.597 79.2455 132.151 79.5125 132.44 80.0463H132.572C132.719 79.7924 132.934 79.5955 133.217 79.4555C133.503 79.3155 133.826 79.2455 134.184 79.2455C134.802 79.2455 135.269 79.405 135.585 79.7241C135.904 80.0398 136.063 80.5476 136.063 81.2475V84.8071H134.569V81.6186C134.569 81.2247 134.503 80.9301 134.369 80.7348C134.239 80.5362 134.032 80.437 133.749 80.437C133.384 80.437 133.111 80.5672 132.929 80.8276C132.75 81.088 132.66 81.5014 132.66 82.0678V84.8071ZM140.634 79.2455C141.278 79.2455 141.783 79.4978 142.147 80.0024C142.512 80.5037 142.694 81.1922 142.694 82.0678C142.694 82.9695 142.506 83.6677 142.128 84.1625C141.754 84.6573 141.243 84.9047 140.595 84.9047C139.953 84.9047 139.451 84.672 139.086 84.2065H138.983L138.734 84.8071H137.597V77.2094H139.086V78.977C139.086 79.2016 139.066 79.5613 139.027 80.0561H139.086C139.434 79.5157 139.95 79.2455 140.634 79.2455ZM140.155 80.437C139.787 80.437 139.519 80.5509 139.35 80.7787C139.18 81.0034 139.092 81.3761 139.086 81.8969V82.058C139.086 82.644 139.172 83.0639 139.345 83.3178C139.521 83.5717 139.797 83.6987 140.175 83.6987C140.481 83.6987 140.723 83.5587 140.902 83.2787C141.085 82.9955 141.176 82.5854 141.176 82.0483C141.176 81.5112 141.085 81.1092 140.902 80.8422C140.72 80.572 140.471 80.437 140.155 80.437ZM146.186 80.3051C145.87 80.3051 145.622 80.406 145.443 80.6078C145.264 80.8064 145.162 81.0896 145.136 81.4575H147.226C147.219 81.0896 147.123 80.8064 146.938 80.6078C146.752 80.406 146.501 80.3051 146.186 80.3051ZM146.396 84.9047C145.517 84.9047 144.83 84.6622 144.335 84.1772C143.84 83.6922 143.593 83.0053 143.593 82.1166C143.593 81.2019 143.821 80.4955 144.276 79.9975C144.735 79.4962 145.368 79.2455 146.176 79.2455C146.947 79.2455 147.548 79.4653 147.978 79.9047C148.407 80.3442 148.622 80.9513 148.622 81.726V82.4487H145.102C145.118 82.8718 145.243 83.2023 145.478 83.4399C145.712 83.6775 146.041 83.7963 146.464 83.7963C146.793 83.7963 147.104 83.7621 147.396 83.6938C147.689 83.6254 147.995 83.5164 148.314 83.3666V84.519C148.054 84.6492 147.776 84.7452 147.479 84.8071C147.183 84.8722 146.822 84.9047 146.396 84.9047ZM152.88 79.2455C153.082 79.2455 153.249 79.2602 153.383 79.2895L153.271 80.686C153.15 80.6534 153.004 80.6371 152.831 80.6371C152.356 80.6371 151.985 80.7592 151.718 81.0034C151.454 81.2475 151.322 81.5893 151.322 82.0287V84.8071H149.833V79.3481H150.961L151.181 80.2661H151.254C151.423 79.9601 151.651 79.7143 151.938 79.5287C152.227 79.3399 152.541 79.2455 152.88 79.2455ZM40.0576 98.8071L39.7695 98.0649H39.7305C39.4798 98.3806 39.221 98.6004 38.9541 98.7241C38.6904 98.8445 38.3454 98.9047 37.9189 98.9047C37.3949 98.9047 36.9814 98.755 36.6787 98.4555C36.3792 98.156 36.2295 97.7296 36.2295 97.1762C36.2295 96.5968 36.4313 96.1703 36.835 95.8969C37.2419 95.6202 37.8538 95.4672 38.6709 95.4379L39.6182 95.4086V95.1694C39.6182 94.616 39.335 94.3393 38.7686 94.3393C38.3324 94.3393 37.8197 94.4711 37.2305 94.7348L36.7373 93.7289C37.3656 93.4002 38.0622 93.2358 38.8271 93.2358C39.5596 93.2358 40.1211 93.3953 40.5117 93.7143C40.9023 94.0333 41.0977 94.5183 41.0977 95.1694V98.8071H40.0576ZM39.6182 96.2778L39.042 96.2973C38.609 96.3103 38.2868 96.3884 38.0752 96.5317C37.8636 96.6749 37.7578 96.893 37.7578 97.186C37.7578 97.6059 37.9987 97.8159 38.4805 97.8159C38.8255 97.8159 39.1006 97.7166 39.3057 97.518C39.514 97.3194 39.6182 97.0558 39.6182 96.727V96.2778ZM46.4443 97.186C46.4443 97.7459 46.249 98.1723 45.8584 98.4653C45.471 98.7582 44.89 98.9047 44.1152 98.9047C43.7181 98.9047 43.3796 98.8771 43.0996 98.8217C42.8197 98.7696 42.5576 98.6915 42.3135 98.5873V97.3569C42.5902 97.4871 42.901 97.5961 43.2461 97.684C43.5944 97.7719 43.9004 97.8159 44.1641 97.8159C44.7044 97.8159 44.9746 97.6596 44.9746 97.3471C44.9746 97.2299 44.9388 97.1355 44.8672 97.0639C44.7956 96.989 44.6719 96.906 44.4961 96.8149C44.3203 96.7205 44.0859 96.6114 43.793 96.4877C43.373 96.312 43.0638 96.1492 42.8652 95.9995C42.6699 95.8497 42.5267 95.6788 42.4355 95.4868C42.3477 95.2914 42.3037 95.0522 42.3037 94.769C42.3037 94.284 42.4909 93.9096 42.8652 93.6459C43.2428 93.379 43.7767 93.2455 44.4668 93.2455C45.1243 93.2455 45.764 93.3888 46.3857 93.6752L45.9365 94.7495C45.6631 94.6323 45.4076 94.5362 45.1699 94.4614C44.9323 94.3865 44.6898 94.3491 44.4424 94.3491C44.0029 94.3491 43.7832 94.4679 43.7832 94.7055C43.7832 94.839 43.8532 94.9545 43.9932 95.0522C44.1364 95.1498 44.4473 95.2947 44.9258 95.4868C45.3522 95.6593 45.6647 95.8204 45.8633 95.9702C46.0618 96.1199 46.2083 96.2924 46.3027 96.4877C46.3971 96.683 46.4443 96.9158 46.4443 97.186ZM53.2021 98.9047C52.5609 98.9047 52.0579 98.672 51.6934 98.2065H51.6152C51.6673 98.6622 51.6934 98.9259 51.6934 98.9975V101.209H50.2041V93.3481H51.415L51.625 94.0561H51.6934C52.0417 93.5157 52.5576 93.2455 53.2412 93.2455C53.8857 93.2455 54.3903 93.4946 54.7549 93.9926C55.1195 94.4907 55.3018 95.1824 55.3018 96.0678C55.3018 96.6505 55.2155 97.1567 55.043 97.5864C54.8737 98.0161 54.6312 98.3432 54.3154 98.5678C53.9997 98.7924 53.6286 98.9047 53.2021 98.9047ZM52.7627 94.437C52.3949 94.437 52.1263 94.5509 51.957 94.7787C51.7878 95.0034 51.6999 95.3761 51.6934 95.8969V96.058C51.6934 96.644 51.7796 97.0639 51.9521 97.3178C52.1279 97.5717 52.4046 97.6987 52.7822 97.6987C53.4495 97.6987 53.7832 97.1485 53.7832 96.0483C53.7832 95.5112 53.7002 95.1092 53.5342 94.8422C53.3714 94.572 53.1143 94.437 52.7627 94.437ZM59.5791 93.2455C59.7809 93.2455 59.9486 93.2602 60.082 93.2895L59.9697 94.686C59.8493 94.6534 59.7028 94.6371 59.5303 94.6371C59.055 94.6371 58.6839 94.7592 58.417 95.0034C58.1533 95.2475 58.0215 95.5893 58.0215 96.0287V98.8071H56.5322V93.3481H57.6602L57.8799 94.2661H57.9531C58.1224 93.9601 58.3503 93.7143 58.6367 93.5287C58.9264 93.3399 59.2406 93.2455 59.5791 93.2455ZM63.334 94.3051C63.0182 94.3051 62.7708 94.406 62.5918 94.6078C62.4128 94.8064 62.3102 95.0896 62.2842 95.4575H64.374C64.3675 95.0896 64.2715 94.8064 64.0859 94.6078C63.9004 94.406 63.6497 94.3051 63.334 94.3051ZM63.5439 98.9047C62.665 98.9047 61.9782 98.6622 61.4834 98.1772C60.9886 97.6922 60.7412 97.0053 60.7412 96.1166C60.7412 95.2019 60.9691 94.4955 61.4248 93.9975C61.8838 93.4962 62.5169 93.2455 63.3242 93.2455C64.0957 93.2455 64.6963 93.4653 65.126 93.9047C65.5557 94.3442 65.7705 94.9513 65.7705 95.726V96.4487H62.25C62.2663 96.8718 62.3916 97.2023 62.626 97.4399C62.8604 97.6775 63.1891 97.7963 63.6123 97.7963C63.9411 97.7963 64.252 97.7621 64.5449 97.6938C64.8379 97.6254 65.1439 97.5164 65.4629 97.3666V98.519C65.2025 98.6492 64.9242 98.7452 64.6279 98.8071C64.3317 98.8722 63.9704 98.9047 63.5439 98.9047ZM70.79 97.186C70.79 97.7459 70.5947 98.1723 70.2041 98.4653C69.8167 98.7582 69.2357 98.9047 68.4609 98.9047C68.0638 98.9047 67.7253 98.8771 67.4453 98.8217C67.1654 98.7696 66.9033 98.6915 66.6592 98.5873V97.3569C66.9359 97.4871 67.2467 97.5961 67.5918 97.684C67.9401 97.7719 68.2461 97.8159 68.5098 97.8159C69.0501 97.8159 69.3203 97.6596 69.3203 97.3471C69.3203 97.2299 69.2845 97.1355 69.2129 97.0639C69.1413 96.989 69.0176 96.906 68.8418 96.8149C68.666 96.7205 68.4316 96.6114 68.1387 96.4877C67.7188 96.312 67.4095 96.1492 67.2109 95.9995C67.0156 95.8497 66.8724 95.6788 66.7812 95.4868C66.6934 95.2914 66.6494 95.0522 66.6494 94.769C66.6494 94.284 66.8366 93.9096 67.2109 93.6459C67.5885 93.379 68.1224 93.2455 68.8125 93.2455C69.4701 93.2455 70.1097 93.3888 70.7314 93.6752L70.2822 94.7495C70.0088 94.6323 69.7533 94.5362 69.5156 94.4614C69.278 94.3865 69.0355 94.3491 68.7881 94.3491C68.3486 94.3491 68.1289 94.4679 68.1289 94.7055C68.1289 94.839 68.1989 94.9545 68.3389 95.0522C68.4821 95.1498 68.793 95.2947 69.2715 95.4868C69.6979 95.6593 70.0104 95.8204 70.209 95.9702C70.4076 96.1199 70.554 96.2924 70.6484 96.4877C70.7428 96.683 70.79 96.9158 70.79 97.186ZM74.2129 94.3051C73.8971 94.3051 73.6497 94.406 73.4707 94.6078C73.2917 94.8064 73.1891 95.0896 73.1631 95.4575H75.2529C75.2464 95.0896 75.1504 94.8064 74.9648 94.6078C74.7793 94.406 74.5286 94.3051 74.2129 94.3051ZM74.4229 98.9047C73.5439 98.9047 72.8571 98.6622 72.3623 98.1772C71.8675 97.6922 71.6201 97.0053 71.6201 96.1166C71.6201 95.2019 71.848 94.4955 72.3037 93.9975C72.7627 93.4962 73.3958 93.2455 74.2031 93.2455C74.9746 93.2455 75.5752 93.4653 76.0049 93.9047C76.4346 94.3442 76.6494 94.9513 76.6494 95.726V96.4487H73.1289C73.1452 96.8718 73.2705 97.2023 73.5049 97.4399C73.7393 97.6775 74.068 97.7963 74.4912 97.7963C74.82 97.7963 75.1309 97.7621 75.4238 97.6938C75.7168 97.6254 76.0228 97.5164 76.3418 97.3666V98.519C76.0814 98.6492 75.8031 98.7452 75.5068 98.8071C75.2106 98.8722 74.8493 98.9047 74.4229 98.9047ZM82.8994 98.8071H81.4102V95.6186C81.4102 95.2247 81.3402 94.9301 81.2002 94.7348C81.0602 94.5362 80.8372 94.437 80.5312 94.437C80.1146 94.437 79.8135 94.5769 79.6279 94.8569C79.4424 95.1336 79.3496 95.5942 79.3496 96.2387V98.8071H77.8604V93.3481H78.998L79.1982 94.0463H79.2812C79.4473 93.7827 79.6751 93.5841 79.9648 93.4506C80.2578 93.3139 80.5898 93.2455 80.9609 93.2455C81.5957 93.2455 82.0775 93.4181 82.4062 93.7631C82.735 94.1049 82.8994 94.5997 82.8994 95.2475V98.8071ZM86.7324 97.7182C86.9928 97.7182 87.3053 97.6612 87.6699 97.5473V98.6557C87.2988 98.8217 86.8431 98.9047 86.3027 98.9047C85.707 98.9047 85.2725 98.755 84.999 98.4555C84.7288 98.1528 84.5938 97.7003 84.5938 97.0981V94.4662H83.8809V93.8364L84.7012 93.3383L85.1309 92.186H86.083V93.3481H87.6113V94.4662H86.083V97.0981C86.083 97.3097 86.1416 97.4659 86.2588 97.5668C86.3792 97.6677 86.5371 97.7182 86.7324 97.7182ZM91.0391 94.3051C90.7233 94.3051 90.4759 94.406 90.2969 94.6078C90.1178 94.8064 90.0153 95.0896 89.9893 95.4575H92.0791C92.0726 95.0896 91.9766 94.8064 91.791 94.6078C91.6055 94.406 91.3548 94.3051 91.0391 94.3051ZM91.249 98.9047C90.3701 98.9047 89.6833 98.6622 89.1885 98.1772C88.6937 97.6922 88.4463 97.0053 88.4463 96.1166C88.4463 95.2019 88.6742 94.4955 89.1299 93.9975C89.5889 93.4962 90.222 93.2455 91.0293 93.2455C91.8008 93.2455 92.4014 93.4653 92.8311 93.9047C93.2607 94.3442 93.4756 94.9513 93.4756 95.726V96.4487H89.9551C89.9714 96.8718 90.0967 97.2023 90.3311 97.4399C90.5654 97.6775 90.8942 97.7963 91.3174 97.7963C91.6462 97.7963 91.957 97.7621 92.25 97.6938C92.543 97.6254 92.849 97.5164 93.168 97.3666V98.519C92.9076 98.6492 92.6292 98.7452 92.333 98.8071C92.0368 98.8722 91.6755 98.9047 91.249 98.9047ZM96.415 98.9047C95.7738 98.9047 95.2692 98.6557 94.9014 98.1577C94.5368 97.6596 94.3545 96.9695 94.3545 96.0873C94.3545 95.1922 94.54 94.4955 94.9111 93.9975C95.2855 93.4962 95.7998 93.2455 96.4541 93.2455C97.141 93.2455 97.665 93.5125 98.0264 94.0463H98.0752C98.0003 93.6394 97.9629 93.2765 97.9629 92.9575V91.2094H99.457V98.8071H98.3145L98.0264 98.0991H97.9629C97.6243 98.6362 97.1084 98.9047 96.415 98.9047ZM96.9375 97.7182C97.3184 97.7182 97.5967 97.6075 97.7725 97.3862C97.9515 97.1648 98.0492 96.7888 98.0654 96.2582V96.0971C98.0654 95.5112 97.9743 95.0912 97.792 94.8373C97.613 94.5834 97.32 94.4565 96.9131 94.4565C96.5811 94.4565 96.3223 94.5981 96.1367 94.8813C95.9544 95.1612 95.8633 95.5698 95.8633 96.1069C95.8633 96.644 95.9561 97.0476 96.1416 97.3178C96.3271 97.5847 96.5924 97.7182 96.9375 97.7182ZM104.799 96.0678C104.799 96.6082 104.887 97.0167 105.062 97.2934C105.242 97.5701 105.531 97.7084 105.932 97.7084C106.329 97.7084 106.614 97.5717 106.786 97.2983C106.962 97.0216 107.05 96.6114 107.05 96.0678C107.05 95.5274 106.962 95.1222 106.786 94.852C106.61 94.5818 106.322 94.4467 105.922 94.4467C105.525 94.4467 105.238 94.5818 105.062 94.852C104.887 95.1189 104.799 95.5242 104.799 96.0678ZM108.573 96.0678C108.573 96.9565 108.339 97.6515 107.87 98.1528C107.401 98.6541 106.749 98.9047 105.912 98.9047C105.388 98.9047 104.926 98.7908 104.525 98.5629C104.125 98.3318 103.817 98.0014 103.603 97.5717C103.388 97.142 103.28 96.6407 103.28 96.0678C103.28 95.1759 103.513 94.4825 103.979 93.9877C104.444 93.4929 105.098 93.2455 105.941 93.2455C106.465 93.2455 106.928 93.3595 107.328 93.5873C107.729 93.8152 108.036 94.1424 108.251 94.5688C108.466 94.9952 108.573 95.4949 108.573 96.0678ZM114.843 98.8071H113.354V95.6186C113.354 95.2247 113.284 94.9301 113.144 94.7348C113.004 94.5362 112.781 94.437 112.475 94.437C112.058 94.437 111.757 94.5769 111.571 94.8569C111.386 95.1336 111.293 95.5942 111.293 96.2387V98.8071H109.804V93.3481H110.941L111.142 94.0463H111.225C111.391 93.7827 111.618 93.5841 111.908 93.4506C112.201 93.3139 112.533 93.2455 112.904 93.2455C113.539 93.2455 114.021 93.4181 114.35 93.7631C114.678 94.1049 114.843 94.5997 114.843 95.2475V98.8071ZM118.192 93.3481H119.823L120.854 96.4194C120.941 96.6863 121.002 97.0021 121.034 97.3666H121.063C121.099 97.0314 121.169 96.7156 121.273 96.4194L122.284 93.3481H123.881L121.571 99.5053C121.36 100.075 121.057 100.501 120.663 100.785C120.272 101.068 119.815 101.209 119.291 101.209C119.034 101.209 118.782 101.182 118.534 101.126V99.9448C118.713 99.9871 118.909 100.008 119.12 100.008C119.384 100.008 119.613 99.9269 119.809 99.7641C120.007 99.6046 120.162 99.3621 120.272 99.0366L120.36 98.768L118.192 93.3481ZM125.854 96.0678C125.854 96.6082 125.941 97.0167 126.117 97.2934C126.296 97.5701 126.586 97.7084 126.986 97.7084C127.383 97.7084 127.668 97.5717 127.841 97.2983C128.017 97.0216 128.104 96.6114 128.104 96.0678C128.104 95.5274 128.017 95.1222 127.841 94.852C127.665 94.5818 127.377 94.4467 126.977 94.4467C126.579 94.4467 126.293 94.5818 126.117 94.852C125.941 95.1189 125.854 95.5242 125.854 96.0678ZM129.628 96.0678C129.628 96.9565 129.394 97.6515 128.925 98.1528C128.456 98.6541 127.803 98.9047 126.967 98.9047C126.443 98.9047 125.98 98.7908 125.58 98.5629C125.18 98.3318 124.872 98.0014 124.657 97.5717C124.442 97.142 124.335 96.6407 124.335 96.0678C124.335 95.1759 124.568 94.4825 125.033 93.9877C125.499 93.4929 126.153 93.2455 126.996 93.2455C127.52 93.2455 127.982 93.3595 128.383 93.5873C128.783 93.8152 129.091 94.1424 129.306 94.5688C129.521 94.9952 129.628 95.4949 129.628 96.0678ZM134.726 98.8071L134.525 98.1088H134.447C134.288 98.3627 134.062 98.5597 133.769 98.6996C133.476 98.8364 133.142 98.9047 132.768 98.9047C132.126 98.9047 131.643 98.7338 131.317 98.392C130.992 98.047 130.829 97.5522 130.829 96.9077V93.3481H132.318V96.5366C132.318 96.9304 132.388 97.2267 132.528 97.4252C132.668 97.6205 132.891 97.7182 133.197 97.7182C133.614 97.7182 133.915 97.5799 134.101 97.3032C134.286 97.0232 134.379 96.561 134.379 95.9164V93.3481H135.868V98.8071H134.726ZM140.478 93.2455C140.679 93.2455 140.847 93.2602 140.98 93.2895L140.868 94.686C140.748 94.6534 140.601 94.6371 140.429 94.6371C139.953 94.6371 139.582 94.7592 139.315 95.0034C139.052 95.2475 138.92 95.5893 138.92 96.0287V98.8071H137.431V93.3481H138.559L138.778 94.2661H138.852C139.021 93.9601 139.249 93.7143 139.535 93.5287C139.825 93.3399 140.139 93.2455 140.478 93.2455ZM52.0889 112.905C51.4476 112.905 50.9447 112.672 50.5801 112.206H50.502C50.554 112.662 50.5801 112.926 50.5801 112.997V115.209H49.0908V107.348H50.3018L50.5117 108.056H50.5801C50.9284 107.516 51.4443 107.246 52.1279 107.246C52.7725 107.246 53.277 107.495 53.6416 107.993C54.0062 108.491 54.1885 109.182 54.1885 110.068C54.1885 110.65 54.1022 111.157 53.9297 111.586C53.7604 112.016 53.5179 112.343 53.2021 112.568C52.8864 112.792 52.5153 112.905 52.0889 112.905ZM51.6494 108.437C51.2816 108.437 51.013 108.551 50.8438 108.779C50.6745 109.003 50.5866 109.376 50.5801 109.897V110.058C50.5801 110.644 50.6663 111.064 50.8389 111.318C51.0146 111.572 51.2913 111.699 51.6689 111.699C52.3363 111.699 52.6699 111.149 52.6699 110.048C52.6699 109.511 52.5869 109.109 52.4209 108.842C52.2581 108.572 52.001 108.437 51.6494 108.437ZM60.458 112.807H58.9688V109.619C58.9688 108.831 58.6758 108.437 58.0898 108.437C57.6732 108.437 57.3721 108.579 57.1865 108.862C57.001 109.145 56.9082 109.604 56.9082 110.239V112.807H55.4189V105.209H56.9082V106.757C56.9082 106.878 56.8968 107.161 56.874 107.607L56.8398 108.046H56.918C57.25 107.512 57.7773 107.246 58.5 107.246C59.1413 107.246 59.6279 107.418 59.96 107.763C60.292 108.108 60.458 108.603 60.458 109.247V112.807ZM63.1777 110.068C63.1777 110.608 63.2656 111.017 63.4414 111.293C63.6204 111.57 63.9102 111.708 64.3105 111.708C64.7077 111.708 64.9925 111.572 65.165 111.298C65.3408 111.022 65.4287 110.611 65.4287 110.068C65.4287 109.527 65.3408 109.122 65.165 108.852C64.9893 108.582 64.7012 108.447 64.3008 108.447C63.9036 108.447 63.6172 108.582 63.4414 108.852C63.2656 109.119 63.1777 109.524 63.1777 110.068ZM66.9521 110.068C66.9521 110.956 66.7178 111.651 66.249 112.153C65.7803 112.654 65.1276 112.905 64.291 112.905C63.7669 112.905 63.3047 112.791 62.9043 112.563C62.5039 112.332 62.1963 112.001 61.9814 111.572C61.7666 111.142 61.6592 110.641 61.6592 110.068C61.6592 109.176 61.8919 108.483 62.3574 107.988C62.8229 107.493 63.4772 107.246 64.3203 107.246C64.8444 107.246 65.3066 107.359 65.707 107.587C66.1074 107.815 66.415 108.142 66.6299 108.569C66.8447 108.995 66.9521 109.495 66.9521 110.068ZM73.2217 112.807H71.7324V109.619C71.7324 109.225 71.6624 108.93 71.5225 108.735C71.3825 108.536 71.1595 108.437 70.8535 108.437C70.4368 108.437 70.1357 108.577 69.9502 108.857C69.7646 109.134 69.6719 109.594 69.6719 110.239V112.807H68.1826V107.348H69.3203L69.5205 108.046H69.6035C69.7695 107.783 69.9974 107.584 70.2871 107.451C70.5801 107.314 70.9121 107.246 71.2832 107.246C71.918 107.246 72.3997 107.418 72.7285 107.763C73.0573 108.105 73.2217 108.6 73.2217 109.247V112.807ZM77.0156 108.305C76.6999 108.305 76.4525 108.406 76.2734 108.608C76.0944 108.806 75.9919 109.09 75.9658 109.457H78.0557C78.0492 109.09 77.9531 108.806 77.7676 108.608C77.582 108.406 77.3314 108.305 77.0156 108.305ZM77.2256 112.905C76.3467 112.905 75.6598 112.662 75.165 112.177C74.6702 111.692 74.4229 111.005 74.4229 110.117C74.4229 109.202 74.6507 108.496 75.1064 107.997C75.5654 107.496 76.1986 107.246 77.0059 107.246C77.7773 107.246 78.3779 107.465 78.8076 107.905C79.2373 108.344 79.4521 108.951 79.4521 109.726V110.449H75.9316C75.9479 110.872 76.0732 111.202 76.3076 111.44C76.542 111.678 76.8708 111.796 77.2939 111.796C77.6227 111.796 77.9336 111.762 78.2266 111.694C78.5195 111.625 78.8255 111.516 79.1445 111.367V112.519C78.8841 112.649 78.6058 112.745 78.3096 112.807C78.0133 112.872 77.652 112.905 77.2256 112.905ZM84.4473 110.068C84.4473 110.608 84.5352 111.017 84.7109 111.293C84.89 111.57 85.1797 111.708 85.5801 111.708C85.9772 111.708 86.262 111.572 86.4346 111.298C86.6104 111.022 86.6982 110.611 86.6982 110.068C86.6982 109.527 86.6104 109.122 86.4346 108.852C86.2588 108.582 85.9707 108.447 85.5703 108.447C85.1732 108.447 84.8867 108.582 84.7109 108.852C84.5352 109.119 84.4473 109.524 84.4473 110.068ZM88.2217 110.068C88.2217 110.956 87.9873 111.651 87.5186 112.153C87.0498 112.654 86.3971 112.905 85.5605 112.905C85.0365 112.905 84.5742 112.791 84.1738 112.563C83.7734 112.332 83.4658 112.001 83.251 111.572C83.0361 111.142 82.9287 110.641 82.9287 110.068C82.9287 109.176 83.1615 108.483 83.627 107.988C84.0924 107.493 84.7467 107.246 85.5898 107.246C86.1139 107.246 86.5762 107.359 86.9766 107.587C87.377 107.815 87.6846 108.142 87.8994 108.569C88.1143 108.995 88.2217 109.495 88.2217 110.068ZM92.499 107.246C92.7008 107.246 92.8685 107.26 93.002 107.289L92.8896 108.686C92.7692 108.653 92.6227 108.637 92.4502 108.637C91.9749 108.637 91.6038 108.759 91.3369 109.003C91.0732 109.247 90.9414 109.589 90.9414 110.029V112.807H89.4521V107.348H90.5801L90.7998 108.266H90.873C91.0423 107.96 91.2702 107.714 91.5566 107.529C91.8464 107.34 92.1605 107.246 92.499 107.246ZM98.8906 111.718C99.151 111.718 99.4635 111.661 99.8281 111.547V112.656C99.457 112.822 99.0013 112.905 98.4609 112.905C97.8652 112.905 97.4307 112.755 97.1572 112.456C96.887 112.153 96.752 111.7 96.752 111.098V108.466H96.0391V107.836L96.8594 107.338L97.2891 106.186H98.2412V107.348H99.7695V108.466H98.2412V111.098C98.2412 111.31 98.2998 111.466 98.417 111.567C98.5374 111.668 98.6953 111.718 98.8906 111.718ZM104.403 112.807L104.115 112.065H104.076C103.826 112.381 103.567 112.6 103.3 112.724C103.036 112.845 102.691 112.905 102.265 112.905C101.741 112.905 101.327 112.755 101.024 112.456C100.725 112.156 100.575 111.73 100.575 111.176C100.575 110.597 100.777 110.17 101.181 109.897C101.588 109.62 102.2 109.467 103.017 109.438L103.964 109.409V109.169C103.964 108.616 103.681 108.339 103.114 108.339C102.678 108.339 102.165 108.471 101.576 108.735L101.083 107.729C101.711 107.4 102.408 107.236 103.173 107.236C103.905 107.236 104.467 107.395 104.857 107.714C105.248 108.033 105.443 108.518 105.443 109.169V112.807H104.403ZM103.964 110.278L103.388 110.297C102.955 110.31 102.632 110.388 102.421 110.532C102.209 110.675 102.104 110.893 102.104 111.186C102.104 111.606 102.344 111.816 102.826 111.816C103.171 111.816 103.446 111.717 103.651 111.518C103.86 111.319 103.964 111.056 103.964 110.727V110.278ZM110.019 107.246C110.663 107.246 111.168 107.498 111.532 108.002C111.897 108.504 112.079 109.192 112.079 110.068C112.079 110.97 111.89 111.668 111.513 112.163C111.138 112.657 110.627 112.905 109.979 112.905C109.338 112.905 108.835 112.672 108.471 112.206H108.368L108.119 112.807H106.981V105.209H108.471V106.977C108.471 107.202 108.451 107.561 108.412 108.056H108.471C108.819 107.516 109.335 107.246 110.019 107.246ZM109.54 108.437C109.172 108.437 108.904 108.551 108.734 108.779C108.565 109.003 108.477 109.376 108.471 109.897V110.058C108.471 110.644 108.557 111.064 108.729 111.318C108.905 111.572 109.182 111.699 109.56 111.699C109.866 111.699 110.108 111.559 110.287 111.279C110.469 110.996 110.561 110.585 110.561 110.048C110.561 109.511 110.469 109.109 110.287 108.842C110.105 108.572 109.856 108.437 109.54 108.437ZM114.799 112.807H113.31V105.209H114.799V112.807ZM118.627 108.305C118.311 108.305 118.064 108.406 117.885 108.608C117.706 108.806 117.603 109.09 117.577 109.457H119.667C119.66 109.09 119.564 108.806 119.379 108.608C119.193 108.406 118.943 108.305 118.627 108.305ZM118.837 112.905C117.958 112.905 117.271 112.662 116.776 112.177C116.282 111.692 116.034 111.005 116.034 110.117C116.034 109.202 116.262 108.496 116.718 107.997C117.177 107.496 117.81 107.246 118.617 107.246C119.389 107.246 119.989 107.465 120.419 107.905C120.849 108.344 121.063 108.951 121.063 109.726V110.449H117.543C117.559 110.872 117.685 111.202 117.919 111.44C118.153 111.678 118.482 111.796 118.905 111.796C119.234 111.796 119.545 111.762 119.838 111.694C120.131 111.625 120.437 111.516 120.756 111.367V112.519C120.495 112.649 120.217 112.745 119.921 112.807C119.625 112.872 119.263 112.905 118.837 112.905ZM124.574 111.718C124.835 111.718 125.147 111.661 125.512 111.547V112.656C125.141 112.822 124.685 112.905 124.145 112.905C123.549 112.905 123.114 112.755 122.841 112.456C122.571 112.153 122.436 111.7 122.436 111.098V108.466H121.723V107.836L122.543 107.338L122.973 106.186H123.925V107.348H125.453V108.466H123.925V111.098C123.925 111.31 123.983 111.466 124.101 111.567C124.221 111.668 124.379 111.718 124.574 111.718ZM126.41 112.109C126.41 111.835 126.483 111.629 126.63 111.489C126.776 111.349 126.99 111.279 127.27 111.279C127.54 111.279 127.748 111.35 127.895 111.494C128.044 111.637 128.119 111.842 128.119 112.109C128.119 112.366 128.044 112.569 127.895 112.719C127.745 112.866 127.536 112.939 127.27 112.939C126.996 112.939 126.785 112.867 126.635 112.724C126.485 112.578 126.41 112.372 126.41 112.109Z" fill="#020202"/>
                            <rect x="22.0687" y="128.803" width="132.863" height="14.1892" rx="1.44416" fill="white"/>
                            <g opacity="0.5">
                                <path d="M27.7368 137.897H27.2472V134.748C27.2472 134.486 27.2553 134.238 27.2714 134.005C27.2291 134.047 27.1817 134.091 27.1293 134.138C27.077 134.184 26.8372 134.381 26.4101 134.727L26.1441 134.383L27.3137 133.479H27.7368V137.897ZM32.3243 137.897H29.4201V137.465L30.5836 136.296C30.9382 135.937 31.1719 135.681 31.2847 135.528C31.3975 135.375 31.4822 135.226 31.5386 135.081C31.595 134.936 31.6232 134.779 31.6232 134.612C31.6232 134.376 31.5517 134.19 31.4086 134.053C31.2656 133.914 31.0671 133.845 30.8133 133.845C30.6299 133.845 30.4557 133.875 30.2905 133.935C30.1273 133.996 29.9449 134.105 29.7435 134.265L29.4775 133.923C29.8845 133.585 30.3277 133.415 30.8072 133.415C31.2223 133.415 31.5476 133.522 31.7834 133.736C32.0191 133.947 32.137 134.232 32.137 134.591C32.137 134.871 32.0584 135.148 31.9012 135.422C31.7441 135.696 31.4499 136.043 31.0188 136.462L30.0517 137.408V137.432H32.3243V137.897ZM35.7 134.519C35.7 134.801 35.6204 135.031 35.4613 135.211C35.3041 135.39 35.0805 135.51 34.7904 135.57V135.594C35.1449 135.639 35.4079 135.752 35.5791 135.933C35.7504 136.114 35.836 136.352 35.836 136.646C35.836 137.067 35.6899 137.392 35.3978 137.619C35.1057 137.845 34.6906 137.958 34.1527 137.958C33.919 137.958 33.7044 137.94 33.509 137.903C33.3156 137.869 33.1272 137.808 32.9439 137.719V137.241C33.1353 137.336 33.3387 137.409 33.5543 137.459C33.7719 137.507 33.9774 137.532 34.1708 137.532C34.9344 137.532 35.3162 137.232 35.3162 136.634C35.3162 136.098 34.8951 135.83 34.053 135.83H33.6178V135.398H34.059C34.4035 135.398 34.6765 135.322 34.878 135.171C35.0795 135.018 35.1802 134.807 35.1802 134.537C35.1802 134.321 35.1057 134.152 34.9566 134.029C34.8095 133.906 34.609 133.845 34.3552 133.845C34.1618 133.845 33.9794 133.871 33.8082 133.923C33.6369 133.976 33.4415 134.072 33.2219 134.213L32.968 133.875C33.1494 133.732 33.3579 133.62 33.5936 133.539C33.8313 133.457 34.0812 133.415 34.3431 133.415C34.7722 133.415 35.1057 133.514 35.3434 133.712C35.5811 133.907 35.7 134.176 35.7 134.519ZM39.6166 136.882H38.9608V137.897H38.4803V136.882H36.3316V136.444L38.429 133.455H38.9608V136.425H39.6166V136.882ZM38.4803 136.425V134.957C38.4803 134.669 38.4904 134.343 38.5105 133.981H38.4864C38.3897 134.174 38.299 134.334 38.2144 134.461L36.8333 136.425H38.4803ZM41.4269 135.198C41.8923 135.198 42.2579 135.314 42.5239 135.546C42.7918 135.776 42.9258 136.091 42.9258 136.492C42.9258 136.949 42.7798 137.308 42.4876 137.568C42.1975 137.828 41.7966 137.958 41.2848 137.958C40.7872 137.958 40.4074 137.878 40.1455 137.719V137.235C40.2865 137.326 40.4618 137.398 40.6713 137.45C40.8809 137.5 41.0874 137.525 41.2909 137.525C41.6455 137.525 41.9205 137.442 42.1159 137.275C42.3134 137.107 42.4121 136.866 42.4121 136.549C42.4121 135.933 42.0343 135.625 41.2788 135.625C41.0874 135.625 40.8315 135.654 40.5112 135.712L40.2513 135.546L40.4175 133.479H42.6146V133.941H40.8466L40.7348 135.268C40.9665 135.222 41.1972 135.198 41.4269 135.198ZM43.639 136.008C43.639 135.14 43.8073 134.491 44.1437 134.062C44.4822 133.631 44.9819 133.415 45.6427 133.415C45.8704 133.415 46.0497 133.435 46.1806 133.473V133.905C46.0255 133.855 45.8482 133.829 45.6487 133.829C45.1753 133.829 44.8136 133.978 44.5638 134.274C44.314 134.568 44.177 135.031 44.1528 135.664H44.1891C44.4107 135.317 44.7612 135.144 45.2408 135.144C45.6377 135.144 45.9499 135.264 46.1776 135.504C46.4073 135.743 46.5221 136.069 46.5221 136.48C46.5221 136.939 46.3962 137.301 46.1444 137.565C45.8945 137.827 45.5561 137.958 45.1289 137.958C44.6716 137.958 44.3089 137.786 44.041 137.444C43.773 137.099 43.639 136.621 43.639 136.008ZM45.1229 137.532C45.409 137.532 45.6306 137.442 45.7878 137.263C45.9469 137.081 46.0265 136.82 46.0265 136.48C46.0265 136.188 45.953 135.958 45.8059 135.791C45.6588 135.624 45.4392 135.54 45.1471 135.54C44.9657 135.54 44.7995 135.577 44.6484 135.652C44.4973 135.726 44.3764 135.829 44.2858 135.96C44.1971 136.091 44.1528 136.227 44.1528 136.368C44.1528 136.576 44.1931 136.769 44.2737 136.948C44.3543 137.128 44.4681 137.27 44.6152 137.374C44.7643 137.479 44.9335 137.532 45.1229 137.532Z" fill="black"/>
                            </g>
                            <rect x="22.0687" y="128.803" width="132.863" height="14.1892" rx="1.44416" stroke="#BDBDBD" stroke-width="0.412617"/>
                            <rect x="22.4814" y="162.797" width="132.037" height="17.7425" rx="1.44416" fill="#2894DF"/>
                            <path d="M81.1918 169.367H82.3269L80.5245 174.669H79.2988L77.5 169.367H78.6351L79.6324 172.522C79.688 172.708 79.7448 172.926 79.8028 173.175C79.8633 173.421 79.9008 173.593 79.9153 173.69C79.9419 173.467 80.0325 173.078 80.1872 172.522L81.1918 169.367ZM84.5898 171.325C84.3553 171.325 84.1716 171.4 84.0386 171.55C83.9056 171.698 83.8295 171.908 83.8101 172.181H85.3623C85.3574 171.908 85.2861 171.698 85.1483 171.55C85.0105 171.4 84.8243 171.325 84.5898 171.325ZM84.7458 174.741C84.093 174.741 83.5829 174.561 83.2154 174.201C82.8479 173.841 82.6642 173.331 82.6642 172.671C82.6642 171.991 82.8334 171.467 83.1719 171.097C83.5128 170.724 83.983 170.538 84.5826 170.538C85.1556 170.538 85.6016 170.701 85.9208 171.028C86.2399 171.354 86.3995 171.805 86.3995 172.38V172.917H83.7847C83.7968 173.232 83.8899 173.477 84.064 173.653C84.2381 173.83 84.4822 173.918 84.7965 173.918C85.0407 173.918 85.2716 173.893 85.4892 173.842C85.7068 173.791 85.9341 173.71 86.171 173.599V174.455C85.9776 174.552 85.7709 174.623 85.5509 174.669C85.3308 174.717 85.0625 174.741 84.7458 174.741ZM89.5618 170.538C89.7117 170.538 89.8362 170.549 89.9353 170.571L89.8519 171.608C89.7624 171.584 89.6537 171.572 89.5255 171.572C89.1725 171.572 88.8969 171.662 88.6987 171.844C88.5028 172.025 88.4049 172.279 88.4049 172.605V174.669H87.2988V170.614H88.1366L88.2998 171.296H88.3542C88.4799 171.069 88.6491 170.886 88.8619 170.749C89.077 170.608 89.3103 170.538 89.5618 170.538ZM90.6243 169.566C90.6243 169.206 90.825 169.026 91.2263 169.026C91.6277 169.026 91.8284 169.206 91.8284 169.566C91.8284 169.738 91.7776 169.872 91.676 169.969C91.5769 170.063 91.427 170.11 91.2263 170.11C90.825 170.11 90.6243 169.929 90.6243 169.566ZM91.7776 174.669H90.6715V170.614H91.7776V174.669ZM95.1829 171.445H94.2255V174.669H93.1194V171.445H92.5101V170.912L93.1194 170.614V170.317C93.1194 169.855 93.233 169.518 93.4603 169.305C93.6875 169.092 94.0514 168.986 94.5519 168.986C94.9339 168.986 95.2735 169.043 95.5709 169.157L95.288 169.969C95.0656 169.899 94.8601 169.864 94.6715 169.864C94.5144 169.864 94.4008 169.911 94.3306 170.005C94.2605 170.097 94.2255 170.215 94.2255 170.361V170.614H95.1829V171.445ZM95.2409 170.614H96.4522L97.2173 172.895C97.2826 173.094 97.3274 173.328 97.3515 173.599H97.3733C97.3999 173.35 97.4519 173.115 97.5292 172.895L98.2799 170.614H99.4658L97.7504 175.187C97.5933 175.611 97.3685 175.927 97.0759 176.138C96.7858 176.348 96.4461 176.453 96.0569 176.453C95.8659 176.453 95.6785 176.433 95.4948 176.391V175.514C95.6277 175.545 95.7728 175.561 95.9299 175.561C96.1258 175.561 96.2962 175.501 96.4413 175.38C96.5888 175.261 96.7036 175.081 96.7858 174.839L96.8511 174.64L95.2409 170.614Z" fill="white"/>
                            <rect x="22.4814" y="162.797" width="132.037" height="17.7425" rx="1.44416" stroke="#2894DF" stroke-width="0.412617"/>
                        </g>
                        <defs>
                            <filter id="filter0_d_1_27469" x="6.59562" y="51.5258" width="167.11" height="148.201" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                <feOffset dx="1.65047" dy="1.65047"/>
                                <feGaussianBlur stdDeviation="2.06308"/>
                                <feComposite in2="hardAlpha" operator="out"/>
                                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1_27469"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1_27469" result="shape"/>
                            </filter>
                            <clipPath id="clip0_1_27469">
                                <rect width="76.1816" height="13.2037" fill="white" transform="translate(50.4092 27.594)"/>
                            </clipPath>
                        </defs>
                    </svg>

                    <p><?= __('Once you enter this code, you can log in.'); ?></p>
                </div>
            </div>
            <div class="actions-wrapper">
                <a class="button cancel" href="<?= Router::url('/mfa/setup/select', true); ?>">
                    <?= __('Cancel'); ?>
                </a>
                <a class="button primary" href="<?= Router::url('/mfa/setup/totp', true); ?>">
                    <?= __('Get started'); ?>
                </a>
            </div>
        </div>
        <div class="col4 last">
            <div class="sidebar-help">
                <h3><?= __('Requirements') ?></h3>
                <p>
                    <?= __('To proceed you need to install an application that supports Time Based One Time Passwords (TOTP) on your phone or tablet such as:'); ?>
                    <a href="https://support.google.com/accounts/answer/1066447" target="_blank" rel="noopener">Google Authenticator</a> <?= __('or'); ?>
                    <a href="https://freeotp.github.io/" target="_blank" rel="noopener">FreeOTP</a>.
                </p>
                <a href="https://help.passbolt.com/start/" target="_blank" rel="noopener" class="button"><?= __('learn more'); ?></a>
            </div>
        </div>
    </div>
</div>
