<?php
/**
 * @var \App\View\AppView $this
 * @var mixed $setupForm
 * @var string $formUrl
 */
use Cake\Routing\Router;

    $title = __('Getting started with Duo');
    $this->assign('title', $title);
    $this->assign('pageClass', 'iframe mfa');
    $formContext = [
        'url' => $formUrl,
        'target' => '_top',
        'id' => 'duo_form',
    ];
    ?>
<div class="grid grid-responsive-12">
    <div class="row">
        <div class="col7 main-column how-it-works">
            <h3><?= $title; ?></h3>
            <h4 class="no-border"><?= __('How does it work?'); ?></h4>
            <div class="instruction no-margin-top">
                <div class="step">
                    <!-- SVG Passbolt login -->
                    <svg width="177" height="243" viewBox="0 0 177 243" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_280_142230)">
                            <path d="M52.4666 22.9608V27.3321H53.7262C54.562 27.3321 55.1406 27.1546 55.4883 26.8178C55.836 26.481 56.0027 25.8921 56.0027 25.0937C56.0027 24.3223 55.8478 23.7759 55.5264 23.4597C55.2049 23.1177 54.6656 22.966 53.881 22.966L52.4666 22.9608ZM50.4092 21.2997H54.3691C55.5657 21.2997 56.4908 21.643 57.1599 22.3398C57.8291 23.0367 58.1624 23.9996 58.1624 25.2287C58.1704 25.7019 58.1008 26.1733 57.9564 26.6249C57.8198 27.0449 57.6064 27.437 57.3266 27.782C57.0091 28.1785 56.593 28.4884 56.1181 28.682C55.6418 28.8594 55.0252 28.9481 54.2405 28.9481H52.4666V31.729H50.4092V21.2997Z" fill="var(--icon-color)"/>
                            <path d="M62.3024 27.4208H64.8741V25.8368H62.4572C61.9809 25.8368 61.6476 25.8998 61.4665 26.0271C61.2855 26.1544 61.2041 26.382 61.2041 26.6982C61.2041 26.9644 61.2802 27.1546 61.4219 27.2678C61.5636 27.3809 61.8523 27.4208 62.3024 27.4208ZM59.5771 21.2997H63.7758C64.8439 21.2997 65.6403 21.5414 66.1809 22.0223C66.7215 22.5031 66.9905 23.2141 66.9905 24.1642V28.9661H61.4665C60.695 28.9661 60.0915 28.7759 59.6795 28.3966C59.2675 28.0173 59.0693 27.4709 59.0693 26.7612C59.0693 25.887 59.3003 25.266 59.7766 24.8867C60.2529 24.5075 61.0375 24.3108 62.162 24.3108H64.861V24.1256C64.861 23.6692 64.7206 23.3542 64.4503 23.1627C64.18 22.9711 63.7037 22.8837 62.9978 22.8837H59.5771V21.2997Z" fill="var(--icon-color)"/>
                            <path d="M68.6672 27.3693H72.9971C73.3829 27.3693 73.6663 27.3063 73.8329 27.1919C73.9255 27.1295 73.9996 27.0442 74.0475 26.9445C74.0955 26.8449 74.1156 26.7346 74.1058 26.6249C74.1162 26.5149 74.0967 26.4041 74.0492 26.3038C74.0017 26.2036 73.928 26.1174 73.8355 26.0541C73.6558 25.9255 73.3737 25.8638 72.9997 25.8638H71.2258C70.1761 25.8638 69.4649 25.6992 69.091 25.383C68.717 25.0667 68.5386 24.4959 68.5386 23.6975C68.5386 22.8747 68.7577 22.2652 69.2077 21.8731C69.6578 21.481 70.3532 21.2881 71.2717 21.2881H75.6817V22.8837H72.0589C71.4667 22.8837 71.081 22.9346 70.9017 23.0366C70.7219 23.1369 70.6314 23.3143 70.6314 23.5805C70.6229 23.6784 70.6397 23.7769 70.6803 23.8668C70.7209 23.9566 70.7839 24.035 70.8636 24.0947C71.0171 24.2079 71.2743 24.2593 71.6089 24.2593H73.476C74.3249 24.2593 74.9797 24.4612 75.4179 24.8546C75.8562 25.248 76.0858 25.8047 76.0858 26.5401C76.0858 27.2498 75.8798 27.8257 75.4822 28.2757C75.2945 28.4927 75.0594 28.6656 74.7944 28.7818C74.5294 28.8979 74.2412 28.9543 73.951 28.9468H68.6672V27.3693Z" fill="var(--icon-color)"/>
                            <path d="M77.4388 27.3693H81.7688C82.1545 27.3693 82.4379 27.3063 82.6046 27.1919C82.6967 27.1292 82.7703 27.0437 82.8177 26.9441C82.8652 26.8445 82.8849 26.7344 82.8749 26.6249C82.8852 26.5149 82.8657 26.4041 82.8182 26.3038C82.7707 26.2036 82.697 26.1174 82.6046 26.0541C82.4248 25.9255 82.1427 25.8638 81.7688 25.8638H79.9948C78.9451 25.8638 78.234 25.6992 77.86 25.383C77.4861 25.0667 77.3076 24.4933 77.3076 23.6949C77.3076 22.8721 77.5267 22.2627 77.9768 21.8706C78.4268 21.4784 79.1209 21.2881 80.046 21.2881H84.4573V22.8837H80.8306C80.2393 22.8837 79.8535 22.9346 79.6733 23.0366C79.4936 23.1369 79.403 23.3143 79.403 23.5805C79.3945 23.6784 79.4114 23.7769 79.452 23.8667C79.4925 23.9566 79.5556 24.035 79.6353 24.0947C79.7888 24.2079 80.046 24.2593 80.3806 24.2593H82.2451C83.094 24.2593 83.75 24.4612 84.187 24.8546C84.6239 25.248 84.8548 25.8047 84.8548 26.5401C84.8548 27.2498 84.6501 27.8257 84.2513 28.2757C84.0637 28.4925 83.8288 28.6653 83.5641 28.7815C83.2993 28.8976 83.0113 28.9541 82.7213 28.9468H77.4113V27.3693H77.4388Z" fill="var(--icon-color)"/>
                            <path d="M88.3903 18.5253V21.2997H90.1525C90.9397 21.2997 91.5538 21.3884 92.0288 21.5787C92.5091 21.7629 92.9275 22.0745 93.2372 22.4787C93.5172 22.8272 93.731 23.2221 93.8683 23.6448C94.0114 24.0958 94.0805 24.5662 94.073 25.0384C94.073 26.2675 93.7389 27.2305 93.0706 27.9273C92.4027 28.6241 91.4764 28.9661 90.2811 28.9661H86.3198V18.5253H88.3903ZM89.6408 22.9608H88.3798V27.332H89.7943C90.5815 27.332 91.1313 27.1675 91.441 26.8499C91.7506 26.5324 91.9159 25.9757 91.9159 25.1901C91.9159 24.4046 91.7362 23.8222 91.3911 23.4802C91.046 23.1382 90.4608 22.9608 89.6408 22.9608Z" fill="var(--icon-color)"/>
                            <path d="M96.9796 25.14C96.9796 25.8741 97.1462 26.4256 97.4939 26.8499C97.8417 27.2742 98.3166 27.458 98.9464 27.458C99.5763 27.458 100.039 27.2562 100.4 26.8499C100.761 26.4436 100.925 25.8741 100.925 25.14C100.925 24.4059 100.744 23.8466 100.4 23.4416C100.056 23.0366 99.5776 22.8335 98.9464 22.8335C98.6732 22.8212 98.4007 22.8695 98.1492 22.9748C97.8977 23.0801 97.6738 23.2397 97.4939 23.4416C97.1462 23.8466 96.9796 24.4174 96.9796 25.14ZM103.074 25.14C103.074 26.3399 102.702 27.3029 101.956 28.0288C101.21 28.7385 100.219 29.1062 98.9596 29.1062C97.6999 29.1062 96.6962 28.7514 95.9509 28.0288C95.2056 27.3063 94.833 26.3575 94.833 25.1528C94.833 23.9482 95.2056 22.9852 95.9509 22.2627C96.6962 21.5401 97.6999 21.1737 98.9569 21.1737C100.214 21.1737 101.207 21.5414 101.954 22.2627C102.7 22.9839 103.074 23.9353 103.074 25.14Z" fill="var(--icon-color)"/>
                            <path d="M106.443 28.9661H104.309V18.5253H106.443V28.9661Z" fill="var(--icon-color)"/>
                            <path d="M107.433 21.2997H108.885V18.5253H110.943V21.2997H113.116V22.8335H110.943V25.9255C110.943 26.4951 111.046 26.8885 111.238 27.116C111.429 27.3436 111.778 27.4452 112.267 27.4452H113.116V28.979H111.226C110.468 28.979 109.888 28.7758 109.477 28.358C109.066 27.9402 108.873 27.3449 108.873 26.5709V22.8335H107.42V21.2997H107.433Z" fill="var(--icon-color)"/>
                            <path d="M126.257 23.6949L121.656 19.4497C121.46 19.2722 121.202 19.1737 120.935 19.1737C120.667 19.1737 120.41 19.2722 120.213 19.4497L117.326 22.1251C117.705 22.2627 118.044 22.4858 118.318 22.7762C118.591 23.0666 118.791 23.4162 118.901 23.7965H122.798C122.845 23.7965 122.892 23.8057 122.936 23.8235C122.98 23.8414 123.02 23.8675 123.053 23.9005C123.087 23.9334 123.114 23.9726 123.132 24.0156C123.15 24.0587 123.159 24.1048 123.159 24.1513V24.7337C123.159 24.7803 123.15 24.8264 123.132 24.8694C123.114 24.9125 123.087 24.9516 123.053 24.9846C123.02 25.0175 122.98 25.0437 122.936 25.0615C122.892 25.0794 122.845 25.0886 122.798 25.0886H122.348V25.9127C122.348 25.9591 122.339 26.0052 122.321 26.0483C122.303 26.0913 122.277 26.1304 122.243 26.1634C122.21 26.1964 122.17 26.2226 122.126 26.2405C122.083 26.2583 122.036 26.2675 121.988 26.2675H121C120.953 26.2675 120.906 26.2583 120.862 26.2405C120.818 26.2226 120.779 26.1964 120.745 26.1634C120.712 26.1304 120.685 26.0913 120.667 26.0483C120.649 26.0052 120.64 25.9591 120.641 25.9127V25.0886H118.901C118.797 25.473 118.599 25.8271 118.325 26.1206C118.051 26.414 117.708 26.6382 117.326 26.7741L120.226 29.4534C120.423 29.6308 120.68 29.7293 120.948 29.7293C121.215 29.7293 121.473 29.6308 121.669 29.4534L126.262 25.2107C126.366 25.1126 126.449 24.9947 126.506 24.8643C126.562 24.7338 126.591 24.5934 126.591 24.4517C126.59 24.31 126.56 24.1698 126.503 24.0397C126.445 23.9096 126.362 23.7923 126.257 23.6949Z" fill="#D40101"/>
                            <path d="M116.472 23.2822C116.284 23.2859 116.1 23.3298 115.931 23.4108C115.743 23.5024 115.583 23.6416 115.468 23.814C115.353 23.9865 115.287 24.1859 115.277 24.3917C115.267 24.5976 115.313 24.8023 115.411 24.9848C115.508 25.1672 115.654 25.3209 115.832 25.4297C116.011 25.5386 116.216 25.5988 116.426 25.604C116.636 25.6093 116.844 25.5595 117.028 25.4597C117.212 25.3599 117.366 25.2138 117.473 25.0364C117.58 24.8591 117.637 24.6569 117.637 24.4509C117.641 24.2987 117.613 24.1473 117.557 24.0057C117.5 23.8641 117.414 23.735 117.306 23.6261C117.197 23.5172 117.068 23.4307 116.924 23.3716C116.781 23.3126 116.627 23.2822 116.472 23.2822Z" fill="#D40101"/>
                        </g>
                        <g filter="url(#filter0_d_280_142230)">
                            <path d="M9.07129 46.5832C9.07129 45.6717 9.81023 44.9327 10.7218 44.9327H166.278C167.19 44.9327 167.929 45.6717 167.929 46.5832V201.368C167.929 202.28 167.19 203.019 166.278 203.019H10.7218C9.81023 203.019 9.07129 202.28 9.07129 201.368V46.5832Z" fill="#F1F1F1" shape-rendering="crispEdges"/>
                            <path d="M88.4999 101.874C98.7546 101.874 107.068 93.5607 107.068 83.306C107.068 73.0513 98.7546 64.7383 88.4999 64.7383C78.2452 64.7383 69.9321 73.0513 69.9321 83.306C69.9321 93.5607 78.2452 101.874 88.4999 101.874Z" fill="#939598"/>
                            <path d="M88.4842 85.1546C86.7225 85.1505 85.0344 84.4477 83.7901 83.2005C82.5459 81.9533 81.8472 80.2636 81.8472 78.5019C81.8513 76.7429 82.552 75.0572 83.7957 73.8134C85.0395 72.5696 86.7252 71.869 88.4842 71.8649C90.2431 71.869 91.9288 72.5696 93.1726 73.8134C94.4164 75.0572 95.117 76.7429 95.1212 78.5019C95.1212 80.2636 94.4224 81.9533 93.1782 83.2005C91.934 84.4477 90.2459 85.1505 88.4842 85.1546V85.1546Z" fill="white"/>
                            <path d="M93.9675 88.2049H83.0639C82.1833 88.1914 81.3091 88.3567 80.4943 88.6908C79.6794 89.0249 78.9408 89.5208 78.3232 90.1486C77.694 90.766 77.1961 91.5042 76.8594 92.3189C76.5227 93.1336 76.3541 94.0079 76.3637 94.8893V95.9007C79.6071 99.0351 83.942 100.786 88.4525 100.784C92.963 100.786 97.2978 99.0351 100.541 95.9007V94.8893C100.554 94.0089 100.388 93.135 100.054 92.3202C99.7201 91.5055 99.2246 90.7668 98.5976 90.1486C97.9924 89.535 97.2717 89.0472 96.477 88.7136C95.6823 88.38 94.8294 88.2071 93.9675 88.2049V88.2049Z" fill="white"/>
                            <path d="M71.4976 114.476L71.1772 113.424H69.5664L69.2461 114.476H68.2367L69.7961 110.039H70.9415L72.5069 114.476H71.4976ZM70.9536 112.638L70.6332 111.611C70.6131 111.542 70.5859 111.455 70.5516 111.348C70.5194 111.239 70.4862 111.129 70.4519 111.018C70.4197 110.906 70.3935 110.808 70.3733 110.725C70.3532 110.808 70.325 110.911 70.2887 111.033C70.2545 111.154 70.2212 111.269 70.189 111.378C70.1568 111.487 70.1336 111.564 70.1195 111.611L69.8022 112.638H70.9536ZM74.0633 114.536C73.6866 114.536 73.3793 114.389 73.1416 114.095C72.9059 113.799 72.788 113.365 72.788 112.792C72.788 112.214 72.9079 111.777 73.1476 111.481C73.3874 111.183 73.7007 111.033 74.0875 111.033C74.2487 111.033 74.3907 111.056 74.5136 111.1C74.6365 111.144 74.7423 111.204 74.8309 111.278C74.9216 111.353 74.9981 111.436 75.0606 111.529H75.0908C75.0787 111.465 75.0636 111.37 75.0455 111.245C75.0294 111.118 75.0213 110.988 75.0213 110.855V109.773H75.9461V114.476H75.2389L75.0606 114.037H75.0213C74.9629 114.13 74.8894 114.215 74.8007 114.291C74.7141 114.366 74.6103 114.425 74.4894 114.47C74.3685 114.514 74.2265 114.536 74.0633 114.536ZM74.3867 113.802C74.6385 113.802 74.8158 113.727 74.9186 113.578C75.0233 113.427 75.0787 113.2 75.0848 112.898V112.798C75.0848 112.47 75.0344 112.219 74.9337 112.046C74.8329 111.871 74.6456 111.783 74.3716 111.783C74.1681 111.783 74.0089 111.871 73.8941 112.046C73.7792 112.221 73.7218 112.474 73.7218 112.804C73.7218 113.135 73.7792 113.384 73.8941 113.551C74.0109 113.718 74.1751 113.802 74.3867 113.802ZM78.2942 111.027C78.7476 111.027 79.0951 111.126 79.3369 111.324C79.5786 111.521 79.6995 111.821 79.6995 112.224V114.476H79.0558L78.8775 114.016H78.8533C78.7566 114.137 78.6579 114.236 78.5572 114.312C78.4564 114.389 78.3406 114.445 78.2096 114.482C78.0787 114.518 77.9195 114.536 77.7321 114.536C77.5327 114.536 77.3534 114.498 77.1942 114.421C77.0371 114.345 76.9131 114.228 76.8225 114.071C76.7318 113.912 76.6865 113.71 76.6865 113.466C76.6865 113.108 76.8124 112.844 77.0643 112.674C77.3161 112.503 77.6939 112.409 78.1975 112.39L78.7838 112.372V112.224C78.7838 112.047 78.7375 111.917 78.6448 111.834C78.5521 111.752 78.4232 111.71 78.258 111.71C78.0948 111.71 77.9346 111.734 77.7775 111.78C77.6203 111.826 77.4632 111.885 77.306 111.955L77.0008 111.333C77.1801 111.238 77.3806 111.163 77.6022 111.109C77.8258 111.055 78.0565 111.027 78.2942 111.027ZM78.7838 112.91L78.4272 112.922C78.129 112.93 77.9215 112.984 77.8047 113.082C77.6898 113.181 77.6324 113.311 77.6324 113.472C77.6324 113.613 77.6737 113.714 77.7563 113.775C77.8389 113.833 77.9467 113.862 78.0797 113.862C78.2771 113.862 78.4433 113.804 78.5783 113.687C78.7153 113.57 78.7838 113.404 78.7838 113.188V112.91ZM82.3318 114.476V110.057H83.2686V113.702H85.0607V114.476H82.3318ZM88.8293 112.78C88.8293 113.062 88.791 113.312 88.7144 113.53C88.6399 113.747 88.5301 113.932 88.385 114.083C88.242 114.232 88.0687 114.345 87.8652 114.421C87.6637 114.498 87.4361 114.536 87.1822 114.536C86.9445 114.536 86.7259 114.498 86.5264 114.421C86.329 114.345 86.1567 114.232 86.0096 114.083C85.8646 113.932 85.7518 113.747 85.6712 113.53C85.5926 113.312 85.5533 113.062 85.5533 112.78C85.5533 112.406 85.6198 112.088 85.7528 111.828C85.8857 111.568 86.0751 111.371 86.3209 111.236C86.5667 111.101 86.8599 111.033 87.2004 111.033C87.5167 111.033 87.7967 111.101 88.0405 111.236C88.2863 111.371 88.4787 111.568 88.6177 111.828C88.7587 112.088 88.8293 112.406 88.8293 112.78ZM86.4932 112.78C86.4932 113.002 86.5174 113.188 86.5657 113.339C86.6141 113.49 86.6896 113.604 86.7924 113.681C86.8951 113.757 87.0291 113.796 87.1943 113.796C87.3575 113.796 87.4895 113.757 87.5902 113.681C87.693 113.604 87.7675 113.49 87.8138 113.339C87.8622 113.188 87.8864 113.002 87.8864 112.78C87.8864 112.557 87.8622 112.371 87.8138 112.224C87.7675 112.075 87.693 111.963 87.5902 111.889C87.4875 111.814 87.3535 111.777 87.1883 111.777C86.9445 111.777 86.7672 111.861 86.6564 112.028C86.5476 112.195 86.4932 112.446 86.4932 112.78ZM90.3947 114.476L89.1073 111.097H90.0713L90.7241 113.022C90.7604 113.135 90.7886 113.254 90.8087 113.379C90.8309 113.504 90.846 113.615 90.8541 113.714H90.8782C90.8843 113.607 90.8984 113.493 90.9206 113.373C90.9447 113.252 90.976 113.135 91.0142 113.022L91.664 111.097H92.628L91.3406 114.476H90.3947ZM94.5078 111.033C94.8201 111.033 95.089 111.094 95.3147 111.215C95.5403 111.334 95.7146 111.507 95.8375 111.735C95.9604 111.962 96.0218 112.24 96.0218 112.569V113.016H93.8429C93.853 113.276 93.9306 113.48 94.0756 113.629C94.2227 113.777 94.4262 113.85 94.6861 113.85C94.9017 113.85 95.0991 113.828 95.2784 113.784C95.4577 113.739 95.6421 113.673 95.8315 113.584V114.297C95.6642 114.38 95.489 114.44 95.3056 114.479C95.1243 114.517 94.9037 114.536 94.6438 114.536C94.3053 114.536 94.0051 114.474 93.7432 114.349C93.4833 114.224 93.2788 114.033 93.1297 113.778C92.9826 113.522 92.9091 113.199 92.9091 112.81C92.9091 112.416 92.9756 112.087 93.1085 111.825C93.2435 111.561 93.4309 111.364 93.6707 111.233C93.9104 111.1 94.1895 111.033 94.5078 111.033ZM94.5138 111.689C94.3345 111.689 94.1854 111.747 94.0666 111.862C93.9497 111.976 93.8822 112.157 93.8641 112.402H95.1575C95.1555 112.265 95.1303 112.144 95.082 112.037C95.0356 111.93 94.9651 111.845 94.8704 111.783C94.7778 111.721 94.6589 111.689 94.5138 111.689ZM97.6931 114.476H96.7713V109.773H97.6931V114.476ZM100.047 111.027C100.501 111.027 100.848 111.126 101.09 111.324C101.332 111.521 101.453 111.821 101.453 112.224V114.476H100.809L100.631 114.016H100.606C100.51 114.137 100.411 114.236 100.31 114.312C100.209 114.389 100.094 114.445 99.9627 114.482C99.8317 114.518 99.6725 114.536 99.4852 114.536C99.2857 114.536 99.1064 114.498 98.9472 114.421C98.7901 114.345 98.6662 114.228 98.5755 114.071C98.4849 113.912 98.4395 113.71 98.4395 113.466C98.4395 113.108 98.5654 112.844 98.8173 112.674C99.0691 112.503 99.4469 112.409 99.9506 112.39L100.537 112.372V112.224C100.537 112.047 100.491 111.917 100.398 111.834C100.305 111.752 100.176 111.71 100.011 111.71C99.8478 111.71 99.6876 111.734 99.5305 111.78C99.3733 111.826 99.2162 111.885 99.059 111.955L98.7538 111.333C98.9331 111.238 99.1336 111.163 99.3552 111.109C99.5788 111.055 99.8095 111.027 100.047 111.027ZM100.537 112.91L100.18 112.922C99.8821 112.93 99.6745 112.984 99.5577 113.082C99.4429 113.181 99.3854 113.311 99.3854 113.472C99.3854 113.613 99.4267 113.714 99.5093 113.775C99.5919 113.833 99.6997 113.862 99.8327 113.862C100.03 113.862 100.196 113.804 100.331 113.687C100.468 113.57 100.537 113.404 100.537 113.188V112.91ZM103.777 114.536C103.442 114.536 103.157 114.476 102.921 114.355C102.686 114.232 102.506 114.042 102.383 113.787C102.26 113.531 102.199 113.203 102.199 112.804C102.199 112.391 102.269 112.055 102.408 111.795C102.549 111.533 102.743 111.341 102.991 111.218C103.241 111.095 103.53 111.033 103.858 111.033C104.092 111.033 104.293 111.057 104.463 111.103C104.634 111.147 104.783 111.201 104.91 111.263L104.638 111.976C104.493 111.918 104.358 111.871 104.233 111.834C104.108 111.796 103.983 111.777 103.858 111.777C103.697 111.777 103.563 111.815 103.456 111.892C103.349 111.966 103.27 112.079 103.217 112.23C103.165 112.381 103.139 112.571 103.139 112.798C103.139 113.022 103.167 113.207 103.223 113.354C103.28 113.502 103.362 113.611 103.468 113.684C103.575 113.754 103.705 113.79 103.858 113.79C104.05 113.79 104.22 113.764 104.369 113.714C104.518 113.662 104.663 113.589 104.804 113.496V114.285C104.663 114.374 104.515 114.437 104.36 114.476C104.207 114.516 104.012 114.536 103.777 114.536ZM106.983 111.033C107.295 111.033 107.564 111.094 107.79 111.215C108.016 111.334 108.19 111.507 108.313 111.735C108.436 111.962 108.497 112.24 108.497 112.569V113.016H106.318C106.328 113.276 106.406 113.48 106.551 113.629C106.698 113.777 106.901 113.85 107.161 113.85C107.377 113.85 107.574 113.828 107.754 113.784C107.933 113.739 108.117 113.673 108.307 113.584V114.297C108.139 114.38 107.964 114.44 107.781 114.479C107.599 114.517 107.379 114.536 107.119 114.536C106.78 114.536 106.48 114.474 106.218 114.349C105.958 114.224 105.754 114.033 105.605 113.778C105.458 113.522 105.384 113.199 105.384 112.81C105.384 112.416 105.451 112.087 105.584 111.825C105.719 111.561 105.906 111.364 106.146 111.233C106.386 111.1 106.665 111.033 106.983 111.033ZM106.989 111.689C106.81 111.689 106.661 111.747 106.542 111.862C106.425 111.976 106.357 112.157 106.339 112.402H107.633C107.631 112.265 107.606 112.144 107.557 112.037C107.511 111.93 107.44 111.845 107.346 111.783C107.253 111.721 107.134 111.689 106.989 111.689Z" fill="#020202"/>
                            <path d="M68.0439 120.433C68.3598 120.433 68.5943 120.504 68.7474 120.646C68.9006 120.787 68.9771 121.014 68.9771 121.325V123.126H68.6846L68.6072 122.734H68.5879C68.5137 122.831 68.4364 122.913 68.3558 122.979C68.2752 123.043 68.1817 123.092 68.0753 123.126C67.9706 123.158 67.8416 123.174 67.6885 123.174C67.5273 123.174 67.3839 123.146 67.2582 123.09C67.1341 123.033 67.0357 122.948 66.9632 122.834C66.8923 122.719 66.8568 122.574 66.8568 122.398C66.8568 122.134 66.9616 121.931 67.1711 121.789C67.3807 121.647 67.6998 121.57 68.1285 121.557L68.5855 121.538V121.376C68.5855 121.147 68.5363 120.986 68.438 120.895C68.3397 120.803 68.2011 120.757 68.0221 120.757C67.8835 120.757 67.7514 120.777 67.6256 120.817C67.4999 120.858 67.3807 120.905 67.2678 120.96L67.1445 120.655C67.2638 120.594 67.4008 120.542 67.5555 120.498C67.7103 120.455 67.8731 120.433 68.0439 120.433ZM68.5806 121.821L68.1769 121.837C67.8465 121.85 67.6136 121.904 67.4782 121.999C67.3428 122.095 67.2751 122.229 67.2751 122.403C67.2751 122.555 67.321 122.667 67.4129 122.739C67.5048 122.812 67.6265 122.848 67.778 122.848C68.0133 122.848 68.2059 122.783 68.3558 122.652C68.5057 122.522 68.5806 122.326 68.5806 122.065V121.821ZM70.7469 123.174C70.4116 123.174 70.1457 123.06 69.949 122.831C69.754 122.602 69.6565 122.262 69.6565 121.811C69.6565 121.355 69.7564 121.011 69.9563 120.779C70.1561 120.545 70.4221 120.428 70.7541 120.428C70.8943 120.428 71.0168 120.447 71.1216 120.484C71.2264 120.521 71.3166 120.571 71.3924 120.633C71.4681 120.695 71.5318 120.765 71.5834 120.844H71.6124C71.6059 120.794 71.5995 120.725 71.5931 120.638C71.5866 120.551 71.5834 120.48 71.5834 120.426V119.364H71.9847V123.126H71.6607L71.6003 122.749H71.5834C71.5334 122.828 71.4698 122.9 71.3924 122.964C71.3166 123.029 71.2256 123.08 71.1192 123.119C71.0144 123.156 70.8903 123.174 70.7469 123.174ZM70.8097 122.841C71.0934 122.841 71.2941 122.76 71.4117 122.599C71.5294 122.438 71.5882 122.199 71.5882 121.881V121.808C71.5882 121.472 71.5318 121.213 71.419 121.032C71.3078 120.852 71.1047 120.762 70.8097 120.762C70.5631 120.762 70.3786 120.857 70.2561 121.047C70.1336 121.235 70.0723 121.493 70.0723 121.821C70.0723 122.146 70.1328 122.398 70.2537 122.575C70.3762 122.752 70.5615 122.841 70.8097 122.841ZM73.827 120.433C74.1429 120.433 74.3774 120.504 74.5305 120.646C74.6836 120.787 74.7602 121.014 74.7602 121.325V123.126H74.4677L74.3903 122.734H74.371C74.2968 122.831 74.2195 122.913 74.1389 122.979C74.0583 123.043 73.9648 123.092 73.8584 123.126C73.7536 123.158 73.6247 123.174 73.4716 123.174C73.3104 123.174 73.167 123.146 73.0412 123.09C72.9171 123.033 72.8188 122.948 72.7463 122.834C72.6754 122.719 72.6399 122.574 72.6399 122.398C72.6399 122.134 72.7447 121.931 72.9542 121.789C73.1637 121.647 73.4829 121.57 73.9116 121.557L74.3685 121.538V121.376C74.3685 121.147 74.3194 120.986 74.2211 120.895C74.1227 120.803 73.9841 120.757 73.8052 120.757C73.6666 120.757 73.5344 120.777 73.4087 120.817C73.283 120.858 73.1637 120.905 73.0509 120.96L72.9276 120.655C73.0469 120.594 73.1839 120.542 73.3386 120.498C73.4933 120.455 73.6561 120.433 73.827 120.433ZM74.3637 121.821L73.96 121.837C73.6295 121.85 73.3966 121.904 73.2612 121.999C73.1259 122.095 73.0582 122.229 73.0582 122.403C73.0582 122.555 73.1041 122.667 73.196 122.739C73.2878 122.812 73.4095 122.848 73.561 122.848C73.7964 122.848 73.989 122.783 74.1389 122.652C74.2888 122.522 74.3637 122.326 74.3637 122.065V121.821ZM79.3199 121.361C79.3199 121.514 79.3022 121.664 79.2668 121.811C79.2329 121.956 79.1805 122.087 79.1096 122.205C79.0387 122.321 78.95 122.414 78.8437 122.483C78.7389 122.552 78.6148 122.587 78.4713 122.587C78.3214 122.587 78.2022 122.543 78.1135 122.456C78.0249 122.369 77.9717 122.266 77.954 122.147H77.9322C77.8709 122.274 77.7807 122.38 77.6614 122.464C77.5438 122.546 77.3987 122.587 77.2262 122.587C76.9748 122.587 76.7806 122.504 76.6436 122.338C76.5082 122.17 76.4405 121.948 76.4405 121.671C76.4405 121.455 76.4832 121.264 76.5686 121.098C76.6557 120.93 76.7774 120.799 76.9337 120.704C77.0917 120.607 77.2778 120.559 77.4922 120.559C77.6356 120.559 77.775 120.571 77.9104 120.595C78.0458 120.619 78.1538 120.646 78.2344 120.675L78.1861 121.649C78.1844 121.709 78.1828 121.754 78.1812 121.787C78.1796 121.817 78.1788 121.842 78.1788 121.859C78.1788 122.033 78.2094 122.151 78.2707 122.212C78.3335 122.272 78.4093 122.302 78.4979 122.302C78.6059 122.302 78.6962 122.26 78.7687 122.176C78.8429 122.091 78.8993 121.977 78.938 121.835C78.9766 121.692 78.996 121.533 78.996 121.359C78.996 121.051 78.9339 120.788 78.8098 120.571C78.6857 120.353 78.5141 120.187 78.2948 120.073C78.0773 119.958 77.8266 119.901 77.543 119.901C77.2609 119.901 77.0103 119.945 76.7911 120.034C76.5735 120.123 76.3889 120.248 76.2374 120.411C76.0875 120.572 75.9739 120.764 75.8965 120.986C75.8191 121.209 75.7805 121.455 75.7805 121.724C75.7805 122.053 75.8385 122.332 75.9545 122.563C76.0722 122.793 76.2439 122.969 76.4695 123.09C76.6968 123.209 76.9732 123.269 77.2988 123.269C77.4954 123.269 77.6848 123.247 77.8669 123.203C78.0491 123.16 78.2118 123.111 78.3553 123.056V123.37C78.2135 123.43 78.0547 123.478 77.879 123.515C77.7033 123.554 77.5099 123.573 77.2988 123.573C76.9103 123.573 76.5783 123.5 76.3027 123.353C76.0271 123.208 75.8159 122.999 75.6693 122.725C75.5226 122.451 75.4492 122.122 75.4492 121.738C75.4492 121.427 75.4968 121.141 75.5919 120.88C75.6886 120.619 75.8272 120.393 76.0077 120.201C76.1899 120.009 76.4099 119.861 76.6678 119.756C76.9273 119.649 77.219 119.596 77.543 119.596C77.8895 119.596 78.1957 119.668 78.4617 119.811C78.7292 119.953 78.9388 120.156 79.0903 120.421C79.2434 120.683 79.3199 120.997 79.3199 121.361ZM76.8007 121.68C76.8007 121.895 76.8434 122.052 76.9289 122.152C77.0143 122.252 77.1328 122.302 77.2843 122.302C77.4712 122.302 77.6082 122.232 77.6953 122.091C77.7839 121.951 77.8347 121.766 77.8476 121.535L77.8766 120.904C77.8298 120.89 77.7726 120.878 77.7049 120.868C77.6389 120.857 77.5695 120.851 77.497 120.851C77.331 120.851 77.1964 120.891 77.0933 120.97C76.9917 121.049 76.9176 121.151 76.8708 121.277C76.8241 121.402 76.8007 121.537 76.8007 121.68ZM81.271 120.428C81.6014 120.428 81.8649 120.542 82.0616 120.769C82.2582 120.996 82.3565 121.338 82.3565 121.794C82.3565 122.095 82.3114 122.348 82.2212 122.553C82.1309 122.758 82.0036 122.913 81.8392 123.017C81.6764 123.122 81.4838 123.174 81.2613 123.174C81.1211 123.174 80.9978 123.156 80.8914 123.119C80.7851 123.082 80.694 123.032 80.6182 122.969C80.5425 122.906 80.4796 122.838 80.4297 122.763H80.4006C80.4055 122.826 80.4111 122.902 80.4176 122.991C80.4256 123.079 80.4297 123.157 80.4297 123.223V124.311H80.0259V120.476H80.3571L80.4103 120.868H80.4297C80.4812 120.787 80.5441 120.714 80.6182 120.648C80.6924 120.58 80.7826 120.527 80.889 120.488C80.997 120.448 81.1243 120.428 81.271 120.428ZM81.2009 120.766C81.0171 120.766 80.8689 120.802 80.756 120.873C80.6448 120.944 80.5634 121.05 80.5119 121.192C80.4603 121.332 80.4329 121.509 80.4297 121.721V121.799C80.4297 122.023 80.4538 122.212 80.5022 122.367C80.5522 122.522 80.6335 122.639 80.7464 122.72C80.8608 122.801 81.0139 122.841 81.2057 122.841C81.3701 122.841 81.5071 122.796 81.6167 122.708C81.7263 122.619 81.8077 122.496 81.8609 122.338C81.9157 122.178 81.9431 121.995 81.9431 121.789C81.9431 121.476 81.8819 121.228 81.7594 121.044C81.6385 120.859 81.4523 120.766 81.2009 120.766ZM84.0489 120.433C84.3648 120.433 84.5993 120.504 84.7525 120.646C84.9056 120.787 84.9821 121.014 84.9821 121.325V123.126H84.6896L84.6122 122.734H84.5929C84.5187 122.831 84.4414 122.913 84.3608 122.979C84.2802 123.043 84.1867 123.092 84.0803 123.126C83.9756 123.158 83.8466 123.174 83.6935 123.174C83.5323 123.174 83.3889 123.146 83.2632 123.09C83.1391 123.033 83.0407 122.948 82.9682 122.834C82.8973 122.719 82.8618 122.574 82.8618 122.398C82.8618 122.134 82.9666 121.931 83.1761 121.789C83.3857 121.647 83.7048 121.57 84.1335 121.557L84.5905 121.538V121.376C84.5905 121.147 84.5413 120.986 84.443 120.895C84.3447 120.803 84.2061 120.757 84.0272 120.757C83.8885 120.757 83.7564 120.777 83.6307 120.817C83.5049 120.858 83.3857 120.905 83.2728 120.96L83.1495 120.655C83.2688 120.594 83.4058 120.542 83.5605 120.498C83.7153 120.455 83.8781 120.433 84.0489 120.433ZM84.5856 121.821L84.1819 121.837C83.8515 121.85 83.6186 121.904 83.4832 121.999C83.3478 122.095 83.2801 122.229 83.2801 122.403C83.2801 122.555 83.326 122.667 83.4179 122.739C83.5098 122.812 83.6315 122.848 83.783 122.848C84.0183 122.848 84.2109 122.783 84.3608 122.652C84.5107 122.522 84.5856 122.326 84.5856 122.065V121.821ZM87.5231 122.401C87.5231 122.57 87.4804 122.713 87.395 122.829C87.3112 122.943 87.1903 123.029 87.0323 123.087C86.876 123.145 86.689 123.174 86.4714 123.174C86.2861 123.174 86.1257 123.16 85.9903 123.131C85.8549 123.102 85.7365 123.061 85.6349 123.008V122.638C85.7429 122.691 85.8718 122.739 86.0217 122.783C86.1716 122.826 86.3248 122.848 86.4811 122.848C86.71 122.848 86.876 122.811 86.9791 122.737C87.0823 122.663 87.1339 122.562 87.1339 122.435C87.1339 122.362 87.1129 122.298 87.071 122.244C87.0307 122.187 86.9622 122.133 86.8655 122.082C86.7688 122.028 86.635 121.97 86.4642 121.908C86.2949 121.843 86.1483 121.779 86.0242 121.717C85.9017 121.652 85.8066 121.574 85.7389 121.482C85.6728 121.39 85.6397 121.271 85.6397 121.124C85.6397 120.9 85.73 120.729 85.9105 120.609C86.0927 120.488 86.3312 120.428 86.6262 120.428C86.7857 120.428 86.9348 120.444 87.0734 120.476C87.2137 120.507 87.3442 120.549 87.4651 120.602L87.3297 120.924C87.2201 120.877 87.1032 120.837 86.9791 120.805C86.855 120.773 86.7285 120.757 86.5996 120.757C86.4142 120.757 86.2716 120.787 86.1716 120.849C86.0733 120.91 86.0242 120.994 86.0242 121.1C86.0242 121.182 86.0467 121.25 86.0919 121.303C86.1386 121.356 86.2127 121.406 86.3143 121.453C86.4158 121.5 86.5496 121.555 86.7156 121.617C86.8816 121.679 87.0251 121.742 87.146 121.808C87.2668 121.873 87.3595 121.952 87.424 122.045C87.4901 122.137 87.5231 122.256 87.5231 122.401ZM89.8828 122.401C89.8828 122.57 89.8401 122.713 89.7546 122.829C89.6708 122.943 89.5499 123.029 89.392 123.087C89.2356 123.145 89.0487 123.174 88.8311 123.174C88.6457 123.174 88.4853 123.16 88.35 123.131C88.2146 123.102 88.0961 123.061 87.9946 123.008V122.638C88.1026 122.691 88.2315 122.739 88.3814 122.783C88.5313 122.826 88.6844 122.848 88.8407 122.848C89.0696 122.848 89.2356 122.811 89.3388 122.737C89.4419 122.663 89.4935 122.562 89.4935 122.435C89.4935 122.362 89.4726 122.298 89.4307 122.244C89.3904 122.187 89.3219 122.133 89.2252 122.082C89.1285 122.028 88.9947 121.97 88.8238 121.908C88.6546 121.843 88.5079 121.779 88.3838 121.717C88.2613 121.652 88.1662 121.574 88.0985 121.482C88.0324 121.39 87.9994 121.271 87.9994 121.124C87.9994 120.9 88.0897 120.729 88.2702 120.609C88.4523 120.488 88.6909 120.428 88.9858 120.428C89.1454 120.428 89.2945 120.444 89.4331 120.476C89.5733 120.507 89.7039 120.549 89.8247 120.602L89.6894 120.924C89.5798 120.877 89.4629 120.837 89.3388 120.805C89.2147 120.773 89.0882 120.757 88.9592 120.757C88.7739 120.757 88.6312 120.787 88.5313 120.849C88.433 120.91 88.3838 120.994 88.3838 121.1C88.3838 121.182 88.4064 121.25 88.4515 121.303C88.4982 121.356 88.5724 121.406 88.6739 121.453C88.7755 121.5 88.9092 121.555 89.0753 121.617C89.2413 121.679 89.3847 121.742 89.5056 121.808C89.6265 121.873 89.7192 121.952 89.7836 122.045C89.8497 122.137 89.8828 122.256 89.8828 122.401ZM90.9296 119.364V120.305C90.9296 120.413 90.9264 120.517 90.9199 120.619C90.9151 120.721 90.9111 120.799 90.9079 120.856H90.9296C91.0021 120.737 91.1069 120.636 91.2439 120.554C91.3809 120.471 91.5558 120.43 91.7686 120.43C92.1006 120.43 92.3649 120.546 92.5615 120.776C92.7598 121.005 92.8589 121.346 92.8589 121.799C92.8589 122.097 92.8138 122.348 92.7235 122.553C92.6333 122.758 92.5059 122.913 92.3415 123.017C92.1771 123.122 91.9829 123.174 91.7589 123.174C91.5493 123.174 91.3769 123.136 91.2415 123.058C91.1077 122.979 91.0046 122.884 90.932 122.771H90.9006L90.8184 123.126H90.5283V119.364H90.9296ZM91.7033 120.766C91.5115 120.766 91.3592 120.804 91.2463 120.88C91.1335 120.954 91.0521 121.067 91.0021 121.219C90.9538 121.368 90.9296 121.559 90.9296 121.789V121.811C90.9296 122.145 90.9852 122.4 91.0964 122.577C91.2077 122.753 91.4099 122.841 91.7033 122.841C91.9499 122.841 92.1344 122.751 92.2569 122.57C92.381 122.39 92.4431 122.132 92.4431 121.796C92.4431 121.455 92.3818 121.198 92.2593 121.025C92.1385 120.853 91.9531 120.766 91.7033 120.766ZM95.8448 121.796C95.8448 122.014 95.8165 122.208 95.7601 122.379C95.7037 122.55 95.6223 122.694 95.5159 122.812C95.4096 122.929 95.2806 123.02 95.1291 123.083C94.9792 123.144 94.8092 123.174 94.619 123.174C94.4417 123.174 94.2789 123.144 94.1306 123.083C93.9839 123.02 93.8566 122.929 93.7486 122.812C93.6422 122.694 93.5592 122.55 93.4996 122.379C93.4416 122.208 93.4126 122.014 93.4126 121.796C93.4126 121.506 93.4617 121.26 93.56 121.057C93.6584 120.852 93.7986 120.696 93.9807 120.59C94.1645 120.482 94.3829 120.428 94.6359 120.428C94.8777 120.428 95.0888 120.482 95.2693 120.59C95.4515 120.698 95.5925 120.854 95.6924 121.059C95.794 121.262 95.8448 121.508 95.8448 121.796ZM93.8284 121.796C93.8284 122.009 93.8566 122.194 93.913 122.35C93.9694 122.506 94.0565 122.627 94.1741 122.713C94.2918 122.798 94.4433 122.841 94.6287 122.841C94.8124 122.841 94.9631 122.798 95.0808 122.713C95.2 122.627 95.2879 122.506 95.3443 122.35C95.4007 122.194 95.4289 122.009 95.4289 121.796C95.4289 121.585 95.4007 121.403 95.3443 121.25C95.2879 121.095 95.2008 120.976 95.0832 120.892C94.9655 120.808 94.8132 120.766 94.6262 120.766C94.3506 120.766 94.1483 120.858 94.0194 121.04C93.8921 121.222 93.8284 121.474 93.8284 121.796ZM96.9424 123.126H96.5386V119.364H96.9424V123.126ZM98.6468 122.846C98.7129 122.846 98.7806 122.84 98.8499 122.829C98.9192 122.817 98.9756 122.804 99.0192 122.788V123.1C98.9724 123.12 98.9071 123.138 98.8233 123.153C98.7411 123.167 98.6605 123.174 98.5816 123.174C98.4413 123.174 98.314 123.15 98.1996 123.102C98.0851 123.052 97.9933 122.968 97.924 122.85C97.8563 122.733 97.8224 122.57 97.8224 122.362V120.791H97.4453V120.595L97.8248 120.438L97.9844 119.862H98.2262V120.476H99.0022V120.791H98.2262V122.35C98.2262 122.516 98.264 122.64 98.3398 122.722C98.4172 122.805 98.5195 122.846 98.6468 122.846ZM99.4954 122.875C99.4954 122.762 99.5228 122.682 99.5776 122.635C99.6324 122.587 99.6993 122.563 99.7783 122.563C99.8605 122.563 99.9298 122.587 99.9862 122.635C100.043 122.682 100.071 122.762 100.071 122.875C100.071 122.986 100.043 123.067 99.9862 123.119C99.9298 123.169 99.8605 123.194 99.7783 123.194C99.6993 123.194 99.6324 123.169 99.5776 123.119C99.5228 123.067 99.4954 122.986 99.4954 122.875ZM101.918 123.174C101.679 123.174 101.469 123.125 101.287 123.027C101.105 122.929 100.963 122.779 100.861 122.577C100.76 122.376 100.709 122.122 100.709 121.816C100.709 121.495 100.762 121.233 100.869 121.03C100.977 120.825 101.125 120.674 101.314 120.575C101.502 120.477 101.716 120.428 101.957 120.428C102.089 120.428 102.216 120.442 102.339 120.469C102.463 120.495 102.564 120.528 102.643 120.568L102.522 120.904C102.442 120.872 102.348 120.843 102.242 120.817C102.137 120.791 102.039 120.779 101.947 120.779C101.763 120.779 101.61 120.818 101.488 120.897C101.367 120.976 101.276 121.092 101.214 121.245C101.155 121.398 101.125 121.587 101.125 121.811C101.125 122.025 101.154 122.208 101.212 122.36C101.272 122.511 101.359 122.627 101.476 122.708C101.593 122.787 101.74 122.826 101.916 122.826C102.056 122.826 102.182 122.812 102.295 122.783C102.408 122.752 102.51 122.717 102.602 122.676V123.034C102.514 123.079 102.414 123.114 102.305 123.138C102.197 123.162 102.068 123.174 101.918 123.174ZM105.515 121.796C105.515 122.014 105.487 122.208 105.431 122.379C105.374 122.55 105.293 122.694 105.187 122.812C105.08 122.929 104.951 123.02 104.8 123.083C104.65 123.144 104.48 123.174 104.29 123.174C104.112 123.174 103.95 123.144 103.801 123.083C103.655 123.02 103.527 122.929 103.419 122.812C103.313 122.694 103.23 122.55 103.17 122.379C103.112 122.208 103.083 122.014 103.083 121.796C103.083 121.506 103.132 121.26 103.231 121.057C103.329 120.852 103.469 120.696 103.651 120.59C103.835 120.482 104.054 120.428 104.307 120.428C104.548 120.428 104.76 120.482 104.94 120.59C105.122 120.698 105.263 120.854 105.363 121.059C105.465 121.262 105.515 121.508 105.515 121.796ZM103.499 121.796C103.499 122.009 103.527 122.194 103.584 122.35C103.64 122.506 103.727 122.627 103.845 122.713C103.962 122.798 104.114 122.841 104.299 122.841C104.483 122.841 104.634 122.798 104.751 122.713C104.871 122.627 104.959 122.506 105.015 122.35C105.071 122.194 105.1 122.009 105.1 121.796C105.1 121.585 105.071 121.403 105.015 121.25C104.959 121.095 104.872 120.976 104.754 120.892C104.636 120.808 104.484 120.766 104.297 120.766C104.021 120.766 103.819 120.858 103.69 121.04C103.563 121.222 103.499 121.474 103.499 121.796ZM109.086 120.428C109.378 120.428 109.598 120.505 109.746 120.658C109.895 120.809 109.969 121.053 109.969 121.39V123.126H109.572V121.41C109.572 121.195 109.526 121.035 109.432 120.928C109.34 120.82 109.203 120.766 109.021 120.766C108.765 120.766 108.579 120.841 108.463 120.989C108.347 121.137 108.289 121.356 108.289 121.644V123.126H107.89V121.41C107.89 121.266 107.869 121.147 107.827 121.052C107.786 120.957 107.725 120.886 107.643 120.839C107.562 120.791 107.46 120.766 107.336 120.766C107.16 120.766 107.019 120.803 106.913 120.875C106.806 120.948 106.729 121.056 106.681 121.199C106.634 121.341 106.611 121.516 106.611 121.724V123.126H106.209V120.476H106.533L106.594 120.851H106.615C106.669 120.759 106.736 120.682 106.816 120.619C106.897 120.556 106.987 120.509 107.087 120.476C107.187 120.444 107.293 120.428 107.406 120.428C107.608 120.428 107.776 120.466 107.911 120.542C108.048 120.616 108.147 120.729 108.209 120.882H108.231C108.318 120.729 108.437 120.616 108.588 120.542C108.74 120.466 108.906 120.428 109.086 120.428Z" fill="#020202"/>
                            <rect x="22.0686" y="138.124" width="132.863" height="14.1892" rx="1.44416" fill="white"/>
                            <g opacity="0.5">
                                <path d="M27.3345 142.8C27.9047 142.8 28.3208 142.912 28.5827 143.135C28.8466 143.357 28.9786 143.675 28.9786 144.09C28.9786 144.278 28.9473 144.456 28.8849 144.625C28.8244 144.792 28.7257 144.94 28.5887 145.069C28.4517 145.196 28.2714 145.297 28.0478 145.372C27.8261 145.444 27.5541 145.48 27.2318 145.48H26.6939V147.218H26.1801V142.8H27.3345ZM27.2862 143.238H26.6939V145.039H27.1744C27.4564 145.039 27.6911 145.009 27.8785 144.949C28.0679 144.888 28.2099 144.79 28.3046 144.655C28.3993 144.518 28.4467 144.337 28.4467 144.111C28.4467 143.817 28.353 143.599 28.1656 143.456C27.9782 143.311 27.6851 143.238 27.2862 143.238ZM31.0668 143.852C31.4617 143.852 31.7549 143.94 31.9463 144.117C32.1377 144.295 32.2334 144.578 32.2334 144.967V147.218H31.8677L31.771 146.729H31.7468C31.6541 146.849 31.5574 146.951 31.4567 147.034C31.3559 147.114 31.2391 147.176 31.1061 147.218C30.9752 147.258 30.814 147.279 30.6226 147.279C30.4211 147.279 30.2418 147.243 30.0846 147.173C29.9295 147.102 29.8066 146.996 29.716 146.852C29.6273 146.709 29.583 146.528 29.583 146.308C29.583 145.978 29.7139 145.724 29.9759 145.547C30.2378 145.37 30.6367 145.273 31.1726 145.257L31.7438 145.233V145.03C31.7438 144.744 31.6823 144.544 31.5594 144.429C31.4365 144.314 31.2633 144.256 31.0396 144.256C30.8664 144.256 30.7012 144.282 30.544 144.332C30.3869 144.382 30.2378 144.442 30.0967 144.51L29.9426 144.13C30.0917 144.053 30.263 143.988 30.4564 143.933C30.6498 143.879 30.8533 143.852 31.0668 143.852ZM31.7377 145.586L31.233 145.607C30.82 145.623 30.5289 145.691 30.3597 145.81C30.1904 145.929 30.1058 146.097 30.1058 146.315C30.1058 146.504 30.1632 146.644 30.2781 146.735C30.3929 146.825 30.545 146.871 30.7344 146.871C31.0285 146.871 31.2693 146.789 31.4567 146.626C31.644 146.463 31.7377 146.218 31.7377 145.891V145.586ZM35.4096 146.312C35.4096 146.523 35.3562 146.701 35.2494 146.846C35.1446 146.989 34.9935 147.097 34.7961 147.17C34.6007 147.242 34.367 147.279 34.095 147.279C33.8633 147.279 33.6628 147.26 33.4936 147.224C33.3243 147.188 33.1762 147.137 33.0493 147.07V146.608C33.1843 146.674 33.3455 146.735 33.5329 146.789C33.7202 146.843 33.9116 146.871 34.1071 146.871C34.3931 146.871 34.6007 146.824 34.7296 146.732C34.8585 146.639 34.923 146.513 34.923 146.354C34.923 146.263 34.8968 146.184 34.8444 146.115C34.7941 146.045 34.7085 145.977 34.5876 145.913C34.4667 145.846 34.2995 145.774 34.0859 145.695C33.8744 145.614 33.691 145.535 33.5359 145.456C33.3828 145.376 33.2639 145.278 33.1793 145.163C33.0967 145.048 33.0554 144.899 33.0554 144.716C33.0554 144.436 33.1682 144.221 33.3938 144.072C33.6215 143.921 33.9197 143.845 34.2884 143.845C34.4878 143.845 34.6742 143.866 34.8475 143.906C35.0227 143.944 35.1859 143.997 35.337 144.063L35.1678 144.465C35.0308 144.407 34.8847 144.357 34.7296 144.317C34.5745 144.277 34.4163 144.256 34.2551 144.256C34.0234 144.256 33.8451 144.295 33.7202 144.371C33.5973 144.448 33.5359 144.553 33.5359 144.686C33.5359 144.788 33.5641 144.873 33.6205 144.939C33.6789 145.006 33.7716 145.068 33.8985 145.127C34.0255 145.185 34.1927 145.254 34.4002 145.332C34.6077 145.409 34.787 145.488 34.9381 145.571C35.0892 145.652 35.2051 145.75 35.2857 145.867C35.3683 145.982 35.4096 146.13 35.4096 146.312ZM38.3591 146.312C38.3591 146.523 38.3057 146.701 38.199 146.846C38.0942 146.989 37.9431 147.097 37.7457 147.17C37.5502 147.242 37.3165 147.279 37.0445 147.279C36.8128 147.279 36.6124 147.26 36.4431 147.224C36.2739 147.188 36.1258 147.137 35.9989 147.07V146.608C36.1339 146.674 36.295 146.735 36.4824 146.789C36.6698 146.843 36.8612 146.871 37.0566 146.871C37.3427 146.871 37.5502 146.824 37.6792 146.732C37.8081 146.639 37.8726 146.513 37.8726 146.354C37.8726 146.263 37.8464 146.184 37.794 146.115C37.7436 146.045 37.658 145.977 37.5371 145.913C37.4162 145.846 37.249 145.774 37.0355 145.695C36.8239 145.614 36.6406 145.535 36.4854 145.456C36.3323 145.376 36.2135 145.278 36.1288 145.163C36.0462 145.048 36.0049 144.899 36.0049 144.716C36.0049 144.436 36.1178 144.221 36.3434 144.072C36.5711 143.921 36.8692 143.845 37.2379 143.845C37.4374 143.845 37.6238 143.866 37.797 143.906C37.9723 143.944 38.1355 143.997 38.2866 144.063L38.1174 144.465C37.9804 144.407 37.8343 144.357 37.6792 144.317C37.524 144.277 37.3659 144.256 37.2047 144.256C36.973 144.256 36.7947 144.295 36.6698 144.371C36.5469 144.448 36.4854 144.553 36.4854 144.686C36.4854 144.788 36.5136 144.873 36.5701 144.939C36.6285 145.006 36.7212 145.068 36.8481 145.127C36.975 145.185 37.1422 145.254 37.3498 145.332C37.5573 145.409 37.7366 145.488 37.8877 145.571C38.0388 145.652 38.1546 145.75 38.2352 145.867C38.3178 145.982 38.3591 146.13 38.3591 146.312ZM40.7224 143.845C41.1354 143.845 41.4648 143.988 41.7106 144.272C41.9564 144.556 42.0793 144.983 42.0793 145.553C42.0793 145.93 42.0229 146.246 41.9101 146.502C41.7973 146.758 41.6381 146.951 41.4326 147.082C41.2291 147.213 40.9884 147.279 40.7103 147.279C40.535 147.279 40.3809 147.255 40.2479 147.209C40.115 147.163 40.0011 147.1 39.9065 147.022C39.8118 146.943 39.7332 146.858 39.6707 146.765H39.6345C39.6405 146.843 39.6476 146.938 39.6556 147.049C39.6657 147.16 39.6707 147.256 39.6707 147.339V148.699H39.166V143.906H39.5801L39.6466 144.396H39.6707C39.7352 144.295 39.8138 144.203 39.9065 144.12C39.9991 144.036 40.112 143.969 40.2449 143.921C40.3799 143.871 40.5391 143.845 40.7224 143.845ZM40.6348 144.269C40.4051 144.269 40.2197 144.313 40.0787 144.402C39.9397 144.49 39.838 144.623 39.7735 144.8C39.709 144.976 39.6748 145.196 39.6707 145.462V145.559C39.6707 145.839 39.7009 146.076 39.7614 146.269C39.8238 146.463 39.9256 146.61 40.0666 146.71C40.2097 146.811 40.4011 146.862 40.6408 146.862C40.8463 146.862 41.0176 146.806 41.1546 146.695C41.2916 146.585 41.3933 146.43 41.4598 146.233C41.5283 146.033 41.5626 145.805 41.5626 145.547C41.5626 145.156 41.486 144.846 41.3329 144.616C41.1818 144.384 40.9491 144.269 40.6348 144.269ZM43.4574 142.516V143.921C43.4574 144.002 43.4554 144.083 43.4514 144.166C43.4473 144.246 43.4403 144.321 43.4302 144.389H43.4635C43.532 144.273 43.6186 144.175 43.7234 144.096C43.8301 144.016 43.951 143.955 44.086 143.915C44.221 143.873 44.364 143.852 44.5151 143.852C44.7811 143.852 45.0027 143.894 45.18 143.978C45.3593 144.063 45.4933 144.194 45.5819 144.371C45.6726 144.549 45.7179 144.778 45.7179 145.06V147.218H45.2223V145.094C45.2223 144.818 45.1588 144.611 45.0319 144.474C44.907 144.337 44.7146 144.269 44.4547 144.269C44.2089 144.269 44.0125 144.316 43.8654 144.411C43.7203 144.503 43.6156 144.64 43.5511 144.822C43.4886 145.003 43.4574 145.225 43.4574 145.486V147.218H42.9557V142.516H43.4574ZM48.2565 143.845C48.323 143.845 48.3925 143.85 48.465 143.858C48.5375 143.864 48.602 143.873 48.6584 143.885L48.595 144.35C48.5406 144.336 48.4801 144.325 48.4136 144.317C48.3472 144.309 48.2847 144.305 48.2263 144.305C48.0933 144.305 47.9674 144.332 47.8485 144.386C47.7317 144.439 47.6289 144.515 47.5403 144.616C47.4516 144.715 47.3821 144.835 47.3317 144.976C47.2814 145.115 47.2562 145.27 47.2562 145.441V147.218H46.7515V143.906H47.1685L47.2229 144.516H47.2441C47.3126 144.393 47.3952 144.282 47.4919 144.181C47.5886 144.078 47.7004 143.997 47.8274 143.936C47.9563 143.876 48.0993 143.845 48.2565 143.845ZM50.5231 143.852C50.918 143.852 51.2111 143.94 51.4025 144.117C51.5939 144.295 51.6896 144.578 51.6896 144.967V147.218H51.3239L51.2272 146.729H51.203C51.1104 146.849 51.0137 146.951 50.9129 147.034C50.8122 147.114 50.6953 147.176 50.5624 147.218C50.4314 147.258 50.2702 147.279 50.0788 147.279C49.8773 147.279 49.698 147.243 49.5409 147.173C49.3858 147.102 49.2629 146.996 49.1722 146.852C49.0835 146.709 49.0392 146.528 49.0392 146.308C49.0392 145.978 49.1702 145.724 49.4321 145.547C49.694 145.37 50.0929 145.273 50.6288 145.257L51.2 145.233V145.03C51.2 144.744 51.1386 144.544 51.0157 144.429C50.8928 144.314 50.7195 144.256 50.4959 144.256C50.3226 144.256 50.1574 144.282 50.0002 144.332C49.8431 144.382 49.694 144.442 49.553 144.51L49.3988 144.13C49.5479 144.053 49.7192 143.988 49.9126 143.933C50.106 143.879 50.3095 143.852 50.5231 143.852ZM51.194 145.586L50.6893 145.607C50.2763 145.623 49.9851 145.691 49.8159 145.81C49.6467 145.929 49.562 146.097 49.562 146.315C49.562 146.504 49.6195 146.644 49.7343 146.735C49.8491 146.825 50.0013 146.871 50.1906 146.871C50.4848 146.871 50.7255 146.789 50.9129 146.626C51.1003 146.463 51.194 146.218 51.194 145.891V145.586ZM54.8658 146.312C54.8658 146.523 54.8124 146.701 54.7056 146.846C54.6009 146.989 54.4498 147.097 54.2523 147.17C54.0569 147.242 53.8232 147.279 53.5512 147.279C53.3195 147.279 53.119 147.26 52.9498 147.224C52.7806 147.188 52.6325 147.137 52.5056 147.07V146.608C52.6405 146.674 52.8017 146.735 52.9891 146.789C53.1765 146.843 53.3679 146.871 53.5633 146.871C53.8494 146.871 54.0569 146.824 54.1858 146.732C54.3148 146.639 54.3793 146.513 54.3793 146.354C54.3793 146.263 54.3531 146.184 54.3007 146.115C54.2503 146.045 54.1647 145.977 54.0438 145.913C53.9229 145.846 53.7557 145.774 53.5421 145.695C53.3306 145.614 53.1472 145.535 52.9921 145.456C52.839 145.376 52.7201 145.278 52.6355 145.163C52.5529 145.048 52.5116 144.899 52.5116 144.716C52.5116 144.436 52.6244 144.221 52.8501 144.072C53.0777 143.921 53.3759 143.845 53.7446 143.845C53.9441 143.845 54.1304 143.866 54.3037 143.906C54.479 143.944 54.6422 143.997 54.7933 144.063L54.624 144.465C54.487 144.407 54.341 144.357 54.1858 144.317C54.0307 144.277 53.8726 144.256 53.7114 144.256C53.4797 144.256 53.3014 144.295 53.1765 144.371C53.0536 144.448 52.9921 144.553 52.9921 144.686C52.9921 144.788 53.0203 144.873 53.0767 144.939C53.1352 145.006 53.2278 145.068 53.3548 145.127C53.4817 145.185 53.6489 145.254 53.8564 145.332C54.064 145.409 54.2433 145.488 54.3944 145.571C54.5455 145.652 54.6613 145.75 54.7419 145.867C54.8245 145.982 54.8658 146.13 54.8658 146.312ZM56.948 143.845C57.2301 143.845 57.4719 143.908 57.6733 144.033C57.8748 144.158 58.0289 144.333 58.1357 144.559C58.2425 144.782 58.2959 145.044 58.2959 145.344V145.656H56.0082C56.0142 146.045 56.1109 146.341 56.2983 146.544C56.4857 146.748 56.7496 146.849 57.0901 146.849C57.2996 146.849 57.485 146.83 57.6461 146.792C57.8073 146.754 57.9745 146.697 58.1478 146.623V147.064C57.9806 147.139 57.8144 147.193 57.6492 147.227C57.486 147.261 57.2926 147.279 57.0689 147.279C56.7506 147.279 56.4726 147.214 56.2348 147.085C55.9991 146.954 55.8158 146.763 55.6848 146.511C55.5538 146.259 55.4884 145.951 55.4884 145.586C55.4884 145.23 55.5478 144.921 55.6667 144.661C55.7876 144.4 55.9568 144.198 56.1744 144.057C56.394 143.916 56.6519 143.845 56.948 143.845ZM56.942 144.256C56.674 144.256 56.4605 144.344 56.3013 144.519C56.1421 144.695 56.0475 144.939 56.0172 145.254H57.77C57.768 145.056 57.7368 144.883 57.6764 144.734C57.6179 144.583 57.5283 144.466 57.4074 144.383C57.2865 144.299 57.1314 144.256 56.942 144.256Z" fill="black"/>
                            </g>
                            <rect x="22.0686" y="138.124" width="132.863" height="14.1892" rx="1.44416" stroke="#BDBDBD" stroke-width="0.412617"/>
                            <rect x="22.4812" y="171.866" width="132.037" height="17.7425" rx="1.44416" fill="#2894DF"/>
                            <path d="M79.7967 182.265C79.7967 182.579 79.7206 182.853 79.5682 183.085C79.4159 183.317 79.1935 183.496 78.901 183.621C78.6108 183.747 78.2579 183.81 77.842 183.81C77.6583 183.81 77.4782 183.798 77.3017 183.774C77.1276 183.75 76.9596 183.715 76.7976 183.669C76.638 183.62 76.4857 183.561 76.3406 183.491V182.446C76.5921 182.558 76.8532 182.658 77.124 182.747C77.3948 182.837 77.6631 182.882 77.9291 182.882C78.1128 182.882 78.2603 182.857 78.3715 182.809C78.4851 182.761 78.5673 182.694 78.6181 182.61C78.6689 182.525 78.6943 182.428 78.6943 182.32C78.6943 182.187 78.6495 182.073 78.5601 181.979C78.4706 181.884 78.3473 181.796 78.1902 181.714C78.0354 181.632 77.8602 181.543 77.6643 181.449C77.541 181.391 77.4068 181.321 77.2618 181.239C77.1167 181.154 76.9789 181.051 76.8484 180.931C76.7178 180.81 76.6102 180.663 76.5256 180.492C76.4434 180.318 76.4023 180.11 76.4023 179.868C76.4023 179.551 76.4748 179.281 76.6199 179.056C76.7649 178.831 76.9717 178.659 77.24 178.541C77.5108 178.42 77.8299 178.359 78.1974 178.359C78.473 178.359 78.7354 178.392 78.9844 178.457C79.2358 178.52 79.4981 178.612 79.7713 178.733L79.4087 179.607C79.1645 179.508 78.9457 179.432 78.7523 179.378C78.5589 179.323 78.3618 179.295 78.1612 179.295C78.0209 179.295 77.9013 179.318 77.8021 179.364C77.703 179.407 77.6281 179.47 77.5773 179.552C77.5265 179.632 77.5011 179.725 77.5011 179.832C77.5011 179.957 77.5374 180.064 77.6099 180.151C77.6849 180.235 77.7961 180.318 77.9436 180.397C78.0935 180.477 78.2796 180.57 78.502 180.677C78.7728 180.805 79.0037 180.939 79.1947 181.079C79.3881 181.217 79.5368 181.38 79.6408 181.569C79.7447 181.755 79.7967 181.987 79.7967 182.265ZM81.7768 179.683V183.737H80.6707V179.683H81.7768ZM81.2256 178.095C81.39 178.095 81.5314 178.133 81.6499 178.211C81.7683 178.286 81.8276 178.427 81.8276 178.635C81.8276 178.84 81.7683 178.983 81.6499 179.063C81.5314 179.14 81.39 179.179 81.2256 179.179C81.0587 179.179 80.9161 179.14 80.7976 179.063C80.6816 178.983 80.6236 178.84 80.6236 178.635C80.6236 178.427 80.6816 178.286 80.7976 178.211C80.9161 178.133 81.0587 178.095 81.2256 178.095ZM84.1268 185.522C83.561 185.522 83.1283 185.423 82.8285 185.224C82.5311 185.029 82.3824 184.753 82.3824 184.398C82.3824 184.153 82.4586 183.949 82.6109 183.785C82.7632 183.62 82.9868 183.503 83.2818 183.433C83.1682 183.385 83.069 183.306 82.9844 183.197C82.8998 183.086 82.8575 182.969 82.8575 182.845C82.8575 182.691 82.9022 182.562 82.9917 182.461C83.0811 182.357 83.2105 182.255 83.3797 182.156C83.167 182.064 82.9977 181.917 82.872 181.714C82.7487 181.511 82.687 181.271 82.687 180.996C82.687 180.701 82.7511 180.451 82.8792 180.245C83.0098 180.037 83.1984 179.879 83.445 179.77C83.694 179.661 83.9962 179.607 84.3516 179.607C84.4266 179.607 84.5136 179.612 84.6127 179.621C84.7118 179.631 84.8025 179.642 84.8847 179.654C84.9693 179.666 85.0261 179.676 85.0552 179.683H86.4695V180.245L85.8349 180.408C85.8929 180.498 85.9364 180.593 85.9654 180.695C85.9944 180.796 86.0089 180.904 86.0089 181.018C86.0089 181.453 85.8566 181.792 85.552 182.037C85.2498 182.278 84.8291 182.399 84.29 182.399C84.1618 182.392 84.0409 182.382 83.9273 182.37C83.8717 182.414 83.8294 182.46 83.8004 182.508C83.7714 182.556 83.7569 182.607 83.7569 182.66C83.7569 182.714 83.7786 182.758 83.8221 182.795C83.8681 182.828 83.9358 182.855 84.0252 182.874C84.1171 182.891 84.2307 182.9 84.3661 182.9H85.0552C85.5 182.9 85.8385 182.995 86.0706 183.186C86.3051 183.377 86.4224 183.658 86.4224 184.028C86.4224 184.501 86.2241 184.869 85.8276 185.13C85.4335 185.391 84.8666 185.522 84.1268 185.522ZM84.1739 184.8C84.4374 184.8 84.6635 184.775 84.8521 184.724C85.0431 184.676 85.1893 184.605 85.2909 184.514C85.3924 184.424 85.4432 184.317 85.4432 184.191C85.4432 184.089 85.413 184.008 85.3525 183.948C85.2945 183.89 85.2051 183.849 85.0842 183.825C84.9657 183.8 84.8134 183.788 84.6272 183.788H84.0542C83.9189 183.788 83.7968 183.81 83.688 183.854C83.5816 183.897 83.497 183.957 83.4341 184.035C83.3712 184.115 83.3398 184.207 83.3398 184.31C83.3398 184.463 83.4123 184.582 83.5574 184.67C83.7049 184.757 83.9104 184.8 84.1739 184.8ZM84.3516 181.725C84.5595 181.725 84.7118 181.661 84.8086 181.533C84.9053 181.404 84.9536 181.23 84.9536 181.01C84.9536 180.766 84.9028 180.584 84.8013 180.463C84.7022 180.339 84.5523 180.278 84.3516 180.278C84.1485 180.278 83.9962 180.339 83.8947 180.463C83.7931 180.584 83.7424 180.766 83.7424 181.01C83.7424 181.23 83.7919 181.404 83.891 181.533C83.9926 181.661 84.1461 181.725 84.3516 181.725ZM89.4432 179.607C89.876 179.607 90.2241 179.725 90.4877 179.962C90.7512 180.197 90.883 180.574 90.883 181.094V183.737H89.7769V181.369C89.7769 181.079 89.7237 180.86 89.6173 180.713C89.5133 180.565 89.3489 180.492 89.1241 180.492C88.7856 180.492 88.5547 180.607 88.4314 180.836C88.3081 181.066 88.2465 181.397 88.2465 181.83V183.737H87.1404V179.683H87.9854L88.1341 180.202H88.1957C88.2828 180.061 88.3903 179.948 88.5185 179.861C88.649 179.774 88.7929 179.71 88.95 179.669C89.1096 179.627 89.274 179.607 89.4432 179.607ZM95.0571 179.683V183.737H93.951V179.683H95.0571ZM94.5058 178.095C94.6703 178.095 94.8117 178.133 94.9302 178.211C95.0486 178.286 95.1078 178.427 95.1078 178.635C95.1078 178.84 95.0486 178.983 94.9302 179.063C94.8117 179.14 94.6703 179.179 94.5058 179.179C94.339 179.179 94.1964 179.14 94.0779 179.063C93.9619 178.983 93.9038 178.84 93.9038 178.635C93.9038 178.427 93.9619 178.286 94.0779 178.211C94.1964 178.133 94.339 178.095 94.5058 178.095ZM98.524 179.607C98.9568 179.607 99.3049 179.725 99.5685 179.962C99.832 180.197 99.9638 180.574 99.9638 181.094V183.737H98.8577V181.369C98.8577 181.079 98.8045 180.86 98.6981 180.713C98.5941 180.565 98.4297 180.492 98.2049 180.492C97.8664 180.492 97.6355 180.607 97.5122 180.836C97.3889 181.066 97.3273 181.397 97.3273 181.83V183.737H96.2212V179.683H97.0662L97.2149 180.202H97.2765C97.3635 180.061 97.4711 179.948 97.5993 179.861C97.7298 179.774 97.8737 179.71 98.0308 179.669C98.1904 179.627 98.3548 179.607 98.524 179.607Z" fill="white"/>
                            <rect x="22.4812" y="171.866" width="132.037" height="17.7425" rx="1.44416" stroke="#2894DF" stroke-width="0.412617"/>
                        </g>
                        <defs>
                            <filter id="filter0_d_280_142230" x="6.59559" y="42.457" width="167.11" height="166.338" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                <feOffset dx="1.65047" dy="1.65047"/>
                                <feGaussianBlur stdDeviation="2.06308"/>
                                <feComposite in2="hardAlpha" operator="out"/>
                                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_280_142230"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_280_142230" result="shape"/>
                            </filter>
                            <clipPath id="clip0_280_142230">
                                <rect width="76.1816" height="13.2037" fill="white" transform="translate(50.4092 18.5253)"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <p><?= __('You sign in to passbolt just like you normally do.'); ?></p>
                </div>
                <div class="step">
                    <!-- SVG setup duo check -->
                    <svg width="157" height="240" viewBox="0 0 157 240" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <g filter="url(#filter0_d_280_143472)">
                            <mask id="path-1-inside-1_280_143472" fill="white">
                                <path d="M16.5 35.305C16.5 33.4797 17.9797 32 19.805 32H137.195C139.02 32 140.5 33.4797 140.5 35.305V204.695C140.5 206.52 139.02 208 137.195 208H19.805C17.9797 208 16.5 206.52 16.5 204.695V35.305Z"/>
                            </mask>
                            <path d="M16.5 35.305C16.5 33.4797 17.9797 32 19.805 32H137.195C139.02 32 140.5 33.4797 140.5 35.305V204.695C140.5 206.52 139.02 208 137.195 208H19.805C17.9797 208 16.5 206.52 16.5 204.695V35.305Z" fill="white" shape-rendering="crispEdges"/>
                            <path d="M41.3698 48.4611L35.382 42.9354C35.126 42.7044 34.7907 42.5762 34.4427 42.5762C34.0947 42.5762 33.7594 42.7044 33.5034 42.9354L29.7461 46.4178C30.2383 46.5969 30.6804 46.8872 31.0365 47.2652C31.3926 47.6432 31.6526 48.0982 31.7955 48.5933H36.8679C36.9297 48.5933 36.9909 48.6052 37.048 48.6284C37.1051 48.6517 37.1569 48.6857 37.2006 48.7286C37.2442 48.7715 37.2787 48.8225 37.3022 48.8785C37.3258 48.9345 37.3377 48.9945 37.3375 49.0551V49.8132C37.3377 49.8738 37.3258 49.9338 37.3022 49.9898C37.2787 50.0458 37.2442 50.0968 37.2006 50.1397C37.1569 50.1826 37.1051 50.2166 37.048 50.2399C36.9909 50.2631 36.9297 50.2751 36.8679 50.2751H36.2821V51.3477C36.2825 51.4082 36.2707 51.4682 36.2474 51.5242C36.2241 51.5803 36.1897 51.6312 36.1462 51.6741C36.1027 51.7171 36.051 51.7511 35.994 51.7744C35.937 51.7976 35.8759 51.8096 35.8141 51.8096H34.5281C34.4663 51.8096 34.4052 51.7976 34.3482 51.7744C34.2912 51.7511 34.2395 51.7171 34.196 51.6741C34.1525 51.6312 34.1181 51.5803 34.0948 51.5242C34.0715 51.4682 34.0597 51.4082 34.0601 51.3477V50.2751H31.7955C31.6596 50.7755 31.4023 51.2364 31.0455 51.6183C30.6886 52.0003 30.2428 52.2922 29.7461 52.4689L33.5205 55.9564C33.7765 56.1874 34.1118 56.3156 34.4598 56.3156C34.8078 56.3156 35.1431 56.1874 35.3991 55.9564L41.3766 50.434C41.5125 50.3064 41.6205 50.153 41.6941 49.9831C41.7677 49.8133 41.8053 49.6306 41.8047 49.4461C41.8041 49.2616 41.7652 49.0792 41.6904 48.9098C41.6157 48.7405 41.5066 48.5878 41.3698 48.4611Z" fill="#D40101"/>
                            <path d="M28.6337 47.924C28.3895 47.9287 28.1493 47.9858 27.9301 48.0913C27.6849 48.2105 27.4766 48.3917 27.3268 48.6162C27.177 48.8406 27.0911 49.1002 27.0779 49.3681C27.0648 49.636 27.1249 49.9025 27.252 50.14C27.3792 50.3775 27.5687 50.5775 27.8011 50.7192C28.0335 50.8609 28.3003 50.9392 28.574 50.9461C28.8476 50.9529 29.1181 50.8881 29.3576 50.7582C29.5971 50.6283 29.7968 50.4381 29.9362 50.2073C30.0755 49.9764 30.1495 49.7133 30.1503 49.4451C30.1551 49.247 30.1194 49.05 30.0453 48.8656C29.9713 48.6813 29.8603 48.5133 29.719 48.3715C29.5777 48.2298 29.4089 48.1172 29.2225 48.0403C29.0361 47.9635 28.8359 47.9239 28.6337 47.924Z" fill="#D40101"/>
                            <path d="M52.0132 74.5505C51.7722 74.5505 51.5571 74.6021 51.3677 74.7054C51.1784 74.8052 51.0165 74.9516 50.8823 75.1444C50.748 75.3371 50.6447 75.573 50.5724 75.8518C50.5036 76.1273 50.4691 76.4405 50.4691 76.7917C50.4691 77.2668 50.5294 77.6662 50.6499 77.9898C50.7704 78.3134 50.9529 78.5578 51.1973 78.7231C51.4452 78.8883 51.755 78.971 52.1268 78.971C52.4642 78.971 52.7878 78.9245 53.0977 78.8315C53.411 78.7386 53.726 78.6267 54.0427 78.4959V80.2207C53.7088 80.3687 53.3662 80.4755 53.0151 80.5409C52.6673 80.6063 52.2973 80.639 51.9048 80.639C51.0854 80.639 50.4141 80.4772 49.8908 80.1536C49.3709 79.8265 48.987 79.3738 48.7392 78.7954C48.4947 78.217 48.3725 77.5457 48.3725 76.7814C48.3725 76.2099 48.4517 75.6866 48.6101 75.2115C48.7719 74.7364 49.0077 74.325 49.3175 73.9773C49.6274 73.6261 50.0095 73.3558 50.464 73.1665C50.9219 72.9737 51.4452 72.8773 52.0339 72.8773C52.3988 72.8773 52.7827 72.9203 53.1855 73.0064C53.5917 73.089 53.9876 73.2233 54.3732 73.4092L53.7484 75.0152C53.473 74.8844 53.1941 74.7743 52.9118 74.6847C52.6295 74.5952 52.33 74.5505 52.0132 74.5505ZM57.4201 72.5003V73.6416C57.4201 74.0754 57.4097 74.4403 57.3891 74.7364C57.3719 75.029 57.3547 75.2528 57.3374 75.4077H57.4304C57.5578 75.2046 57.7024 75.0428 57.8642 74.9223C58.026 74.8018 58.205 74.7157 58.4013 74.6641C58.5975 74.609 58.8109 74.5815 59.0416 74.5815C59.4272 74.5815 59.7749 74.6555 60.0848 74.8035C60.3981 74.9516 60.6477 75.1839 60.8336 75.5007C61.0195 75.814 61.1124 76.2237 61.1124 76.7297V80.5357H59.0829V77.3443C59.0829 76.9552 59.0261 76.6626 58.9125 76.4664C58.7989 76.2667 58.6233 76.1668 58.3858 76.1668C58.1413 76.1668 57.9485 76.2374 57.8074 76.3786C57.6662 76.5163 57.5664 76.7194 57.5079 76.9879C57.4493 77.253 57.4201 77.5784 57.4201 77.964V80.5357H55.4009V72.5003H57.4201ZM65.1198 74.5815C65.6878 74.5815 66.1784 74.6813 66.5916 74.881C67.0047 75.0772 67.3232 75.3733 67.5469 75.7692C67.7707 76.1651 67.8826 76.6609 67.8826 77.2565V78.155H64.2729C64.2901 78.4614 64.4037 78.7128 64.6137 78.909C64.8272 79.1052 65.1404 79.2034 65.5536 79.2034C65.9185 79.2034 66.2525 79.1672 66.5554 79.0949C66.8618 79.0226 67.1768 78.9107 67.5005 78.7592V80.2104C67.2181 80.3584 66.91 80.4669 66.5761 80.5357C66.2421 80.6046 65.8204 80.639 65.3109 80.639C64.7222 80.639 64.1954 80.534 63.7306 80.324C63.2659 80.114 62.8992 79.7886 62.6307 79.348C62.3656 78.9073 62.233 78.3409 62.233 77.649C62.233 76.9466 62.3535 76.37 62.5945 75.919C62.8355 75.4645 63.1729 75.1289 63.6067 74.912C64.0405 74.6916 64.5449 74.5815 65.1198 74.5815ZM65.1921 75.9551C64.9545 75.9551 64.7549 76.0309 64.593 76.1823C64.4347 76.3304 64.3417 76.5645 64.3142 76.8847H66.0493C66.0459 76.7125 66.0115 76.5559 65.9461 76.4147C65.8806 76.2736 65.7842 76.1617 65.6569 76.0791C65.5329 75.9964 65.378 75.9551 65.1921 75.9551ZM71.6886 80.639C71.0964 80.639 70.5817 80.534 70.1445 80.324C69.7073 80.1105 69.3682 79.7835 69.1272 79.3428C68.8896 78.8987 68.7708 78.3306 68.7708 77.6386C68.7708 76.9294 68.9034 76.3493 69.1685 75.8983C69.437 75.4473 69.8037 75.1151 70.2684 74.9016C70.7332 74.6882 71.2599 74.5815 71.8487 74.5815C72.2067 74.5815 72.5458 74.6211 72.866 74.7002C73.1896 74.7794 73.4891 74.8879 73.7645 75.0256L73.1707 76.518C72.9297 76.4113 72.7042 76.3269 72.4942 76.265C72.2876 76.1996 72.0724 76.1668 71.8487 76.1668C71.6455 76.1668 71.4665 76.2202 71.3116 76.3269C71.1567 76.4337 71.0362 76.5955 70.9501 76.8124C70.864 77.0258 70.821 77.2978 70.821 77.6283C70.821 77.9657 70.864 78.2377 70.9501 78.4442C71.0396 78.6508 71.1618 78.8006 71.3167 78.8935C71.4751 78.9865 71.6559 79.0329 71.859 79.0329C72.1516 79.0329 72.4425 78.9882 72.7317 78.8987C73.0244 78.8057 73.3015 78.6783 73.5631 78.5165V80.1226C73.3222 80.2809 73.0502 80.4066 72.7472 80.4996C72.4443 80.5925 72.0914 80.639 71.6886 80.639ZM76.7546 72.5003V75.6608C76.7546 75.8983 76.7443 76.1634 76.7236 76.456C76.7064 76.7452 76.6788 77.0086 76.641 77.2462H76.6823C76.7615 77.1257 76.8613 76.9742 76.9818 76.7917C77.1023 76.6092 77.2107 76.4578 77.3071 76.3373L78.6188 74.6847H80.8704L78.8409 77.1739L80.9995 80.5357H78.6911L77.4104 78.4391L76.7546 78.94V80.5357H74.7251V72.5003H76.7546ZM88.0176 76.1978H86.773V80.5357H84.7538V76.1978H83.9792V75.2063L84.7951 74.7106V74.6124C84.7951 74.1064 84.8623 73.695 84.9965 73.3782C85.1308 73.058 85.3443 72.8222 85.6369 72.6707C85.9295 72.5193 86.3117 72.4435 86.7833 72.4435C87.0863 72.4435 87.36 72.4676 87.6044 72.5158C87.8523 72.564 88.1105 72.6329 88.379 72.7224L87.9453 74.0289C87.8454 74.0014 87.7335 73.9773 87.6096 73.9566C87.4891 73.9359 87.3583 73.9256 87.2171 73.9256C87.0622 73.9256 86.9486 73.9738 86.8763 74.0702C86.8074 74.1632 86.773 74.3164 86.773 74.5298V74.6847H88.0176V76.1978ZM94.4004 77.5973C94.4004 78.0862 94.3333 78.52 94.199 78.8987C94.0647 79.2774 93.8702 79.5958 93.6155 79.854C93.3607 80.1122 93.0526 80.3085 92.6911 80.4428C92.3296 80.5736 91.9216 80.639 91.4672 80.639C91.0437 80.639 90.6547 80.5736 90.3001 80.4428C89.9489 80.3085 89.6425 80.1122 89.3809 79.854C89.1192 79.5958 88.9161 79.2774 88.7715 78.8987C88.6304 78.52 88.5598 78.0862 88.5598 77.5973C88.5598 76.9501 88.6768 76.4027 88.9109 75.9551C89.1485 75.5076 89.4859 75.1667 89.9231 74.9326C90.3638 74.6985 90.8888 74.5815 91.4982 74.5815C92.0593 74.5815 92.5585 74.6985 92.9958 74.9326C93.433 75.1667 93.7756 75.5076 94.0234 75.9551C94.2748 76.4027 94.4004 76.9501 94.4004 77.5973ZM90.6099 77.5973C90.6099 77.9313 90.6392 78.2136 90.6977 78.4442C90.7563 78.6715 90.8492 78.8453 90.9766 78.9658C91.1074 79.0829 91.2778 79.1414 91.4878 79.1414C91.6979 79.1414 91.8648 79.0829 91.9888 78.9658C92.1127 78.8453 92.2022 78.6715 92.2573 78.4442C92.3158 78.2136 92.3451 77.9313 92.3451 77.5973C92.3451 77.2634 92.3158 76.9845 92.2573 76.7607C92.2022 76.5369 92.111 76.3683 91.9836 76.2546C91.8597 76.141 91.691 76.0842 91.4775 76.0842C91.1711 76.0842 90.9491 76.2116 90.8113 76.4664C90.6771 76.7211 90.6099 77.0981 90.6099 77.5973ZM99.0895 74.5815C99.1996 74.5815 99.315 74.5901 99.4354 74.6073C99.5559 74.6211 99.6455 74.6331 99.704 74.6434L99.5232 76.549C99.4578 76.5318 99.3735 76.518 99.2702 76.5077C99.1669 76.4939 99.0223 76.487 98.8364 76.487C98.709 76.487 98.573 76.4991 98.4284 76.5232C98.2838 76.5473 98.1461 76.5989 98.0153 76.6781C97.8879 76.7538 97.7829 76.8709 97.7003 77.0293C97.6177 77.1842 97.5764 77.3942 97.5764 77.6593V80.5357H95.5572V74.6847H97.0599L97.375 75.6195H97.4731C97.5798 75.4267 97.7158 75.2528 97.881 75.0979C98.0497 74.9395 98.2374 74.8138 98.4439 74.7209C98.6539 74.6279 98.8691 74.5815 99.0895 74.5815ZM106.128 74.5815C106.868 74.5815 107.447 74.7656 107.863 75.134C108.28 75.499 108.488 76.0205 108.488 76.6988V80.5357H107.089L106.701 79.7611H106.66C106.495 79.9677 106.324 80.1363 106.149 80.2672C105.977 80.3946 105.779 80.4875 105.555 80.546C105.331 80.608 105.057 80.639 104.734 80.639C104.396 80.639 104.093 80.5701 103.825 80.4324C103.556 80.2947 103.345 80.0864 103.19 79.8076C103.035 79.5287 102.957 79.1758 102.957 78.7489C102.957 78.1223 103.174 77.6576 103.608 77.3546C104.042 77.0516 104.67 76.8812 105.493 76.8434L106.469 76.8124V76.7297C106.469 76.4681 106.404 76.2822 106.273 76.172C106.145 76.0618 105.973 76.0068 105.756 76.0068C105.526 76.0068 105.267 76.0481 104.982 76.1307C104.699 76.2099 104.415 76.3132 104.13 76.4405L103.546 75.1082C103.883 74.9361 104.266 74.8052 104.693 74.7157C105.119 74.6262 105.598 74.5815 106.128 74.5815ZM106.479 77.9227L106.015 77.9433C105.643 77.9571 105.381 78.0225 105.23 78.1395C105.082 78.2532 105.008 78.4167 105.008 78.6301C105.008 78.8298 105.061 78.9779 105.168 79.0743C105.274 79.1672 105.416 79.2137 105.591 79.2137C105.836 79.2137 106.044 79.1362 106.216 78.9813C106.392 78.8264 106.479 78.625 106.479 78.3771V77.9227ZM60.3894 90.6006C60.3894 91.4785 60.2259 92.2084 59.8989 92.7902C59.5718 93.3721 59.1105 93.8093 58.5149 94.1019C57.9227 94.3911 57.2256 94.5357 56.4234 94.5357H53.9808V86.9857H56.5938C57.4063 86.9857 58.0949 87.1252 58.6595 87.404C59.2241 87.6829 59.6527 88.0909 59.9453 88.6279C60.2414 89.165 60.3894 89.8226 60.3894 90.6006ZM58.2722 90.6729C58.2722 90.215 58.2102 89.8363 58.0862 89.5368C57.9657 89.2339 57.7833 89.0084 57.5388 88.8603C57.2944 88.7088 56.9863 88.6331 56.6145 88.6331H56.0206V92.8625H56.475C57.0947 92.8625 57.5492 92.6835 57.8384 92.3255C58.1276 91.964 58.2722 91.4131 58.2722 90.6729ZM67.3197 88.6847V94.5357H65.7963L65.5432 93.8076H65.4245C65.304 94.0038 65.1508 94.1639 64.9649 94.2878C64.7824 94.4083 64.5793 94.4961 64.3555 94.5512C64.1317 94.6097 63.8993 94.639 63.6583 94.639C63.2762 94.639 62.9302 94.565 62.6203 94.4169C62.3139 94.2689 62.0695 94.0365 61.887 93.7198C61.708 93.403 61.6185 92.9951 61.6185 92.4959V88.6847H63.6377V91.8813C63.6377 92.26 63.691 92.5492 63.7978 92.7489C63.9079 92.9452 64.087 93.0433 64.3348 93.0433C64.5896 93.0433 64.7858 92.9744 64.9236 92.8367C65.0647 92.699 65.1628 92.4959 65.2179 92.2273C65.273 91.9588 65.3005 91.6317 65.3005 91.2462V88.6847H67.3197ZM74.3016 91.5973C74.3016 92.0862 74.2345 92.52 74.1002 92.8987C73.9659 93.2774 73.7714 93.5958 73.5167 93.854C73.2619 94.1122 72.9538 94.3085 72.5923 94.4428C72.2308 94.5736 71.8228 94.639 71.3684 94.639C70.9449 94.639 70.5559 94.5736 70.2013 94.4428C69.8501 94.3085 69.5437 94.1122 69.2821 93.854C69.0204 93.5958 68.8173 93.2774 68.6727 92.8987C68.5316 92.52 68.461 92.0862 68.461 91.5973C68.461 90.9501 68.578 90.4027 68.8121 89.9551C69.0497 89.5076 69.3871 89.1667 69.8243 88.9326C70.265 88.6985 70.79 88.5815 71.3994 88.5815C71.9605 88.5815 72.4597 88.6985 72.897 88.9326C73.3342 89.1667 73.6768 89.5076 73.9246 89.9551C74.176 90.4027 74.3016 90.9501 74.3016 91.5973ZM70.5111 91.5973C70.5111 91.9313 70.5404 92.2136 70.5989 92.4442C70.6575 92.6715 70.7504 92.8453 70.8778 92.9658C71.0086 93.0829 71.179 93.1414 71.389 93.1414C71.5991 93.1414 71.766 93.0829 71.89 92.9658C72.0139 92.8453 72.1034 92.6715 72.1585 92.4442C72.217 92.2136 72.2463 91.9313 72.2463 91.5973C72.2463 91.2634 72.217 90.9845 72.1585 90.7607C72.1034 90.5369 72.0122 90.3683 71.8848 90.2546C71.7609 90.141 71.5922 90.0842 71.3787 90.0842C71.0723 90.0842 70.8503 90.2116 70.7125 90.4664C70.5783 90.7211 70.5111 91.0981 70.5111 91.5973ZM80.9375 86.9857C81.8946 86.9857 82.6107 87.194 83.0858 87.6106C83.5644 88.0272 83.8036 88.6193 83.8036 89.3871C83.8036 89.7313 83.7537 90.0618 83.6539 90.3786C83.5575 90.6953 83.3974 90.9776 83.1736 91.2255C82.9533 91.4734 82.6589 91.6696 82.2905 91.8142C81.9256 91.9588 81.4746 92.0311 80.9375 92.0311H80.3643V94.5357H78.3245V86.9857H80.9375ZM80.8911 88.6331H80.3643V90.3683H80.7671C80.9427 90.3683 81.1062 90.339 81.2577 90.2805C81.4092 90.2185 81.5297 90.1204 81.6192 89.9861C81.7121 89.8484 81.7586 89.6659 81.7586 89.4387C81.7586 89.2012 81.688 89.0084 81.5469 88.8603C81.4057 88.7088 81.1871 88.6331 80.8911 88.6331ZM90.579 88.6847V94.5357H89.0555L88.8025 93.8076H88.6837C88.5632 94.0038 88.41 94.1639 88.2241 94.2878C88.0417 94.4083 87.8385 94.4961 87.6147 94.5512C87.391 94.6097 87.1586 94.639 86.9176 94.639C86.5354 94.639 86.1894 94.565 85.8796 94.4169C85.5732 94.2689 85.3288 94.0365 85.1463 93.7198C84.9673 93.403 84.8778 92.9951 84.8778 92.4959V88.6847H86.8969V91.8813C86.8969 92.26 86.9503 92.5492 87.057 92.7489C87.1672 92.9452 87.3462 93.0433 87.5941 93.0433C87.8489 93.0433 88.0451 92.9744 88.1828 92.8367C88.324 92.699 88.4221 92.4959 88.4772 92.2273C88.5322 91.9588 88.5598 91.6317 88.5598 91.2462V88.6847H90.579ZM96.3215 92.7386C96.3215 93.1104 96.2389 93.4392 96.0736 93.7249C95.9083 94.0107 95.6433 94.2345 95.2783 94.3963C94.9168 94.5581 94.44 94.639 93.8479 94.639C93.4313 94.639 93.0577 94.6166 92.7272 94.5719C92.4002 94.5271 92.068 94.441 91.7306 94.3136V92.6973C92.0989 92.866 92.4742 92.9882 92.8563 93.0639C93.2385 93.1362 93.5397 93.1724 93.7601 93.1724C93.9873 93.1724 94.1525 93.1483 94.2558 93.1001C94.3625 93.0484 94.4159 92.9727 94.4159 92.8729C94.4159 92.7868 94.3798 92.7145 94.3075 92.656C94.2386 92.594 94.1129 92.5234 93.9305 92.4442C93.7515 92.365 93.4984 92.2583 93.1714 92.1241C92.8477 91.9898 92.5775 91.8435 92.3606 91.6851C92.1471 91.5267 91.987 91.3374 91.8803 91.1171C91.7736 90.8967 91.7202 90.6265 91.7202 90.3063C91.7202 89.7348 91.9406 89.3044 92.3812 89.0152C92.8219 88.7261 93.4055 88.5815 94.1319 88.5815C94.5175 88.5815 94.8807 88.6245 95.2215 88.7106C95.5623 88.7932 95.9152 88.9154 96.2802 89.0772L95.7276 90.3786C95.4384 90.2478 95.1458 90.1428 94.8497 90.0636C94.5536 89.9844 94.3178 89.9448 94.1422 89.9448C93.9838 89.9448 93.8616 89.9654 93.7756 90.0068C93.6895 90.0481 93.6465 90.1083 93.6465 90.1875C93.6465 90.2598 93.6757 90.3235 93.7342 90.3786C93.7962 90.4337 93.9115 90.4974 94.0802 90.5697C94.2489 90.642 94.4951 90.7435 94.8187 90.8743C95.1595 91.012 95.4401 91.1601 95.6605 91.3185C95.8842 91.4734 96.0495 91.6627 96.1562 91.8865C96.2664 92.1103 96.3215 92.3943 96.3215 92.7386ZM99.4664 86.5003V87.6416C99.4664 88.0754 99.4561 88.4403 99.4354 88.7364C99.4182 89.029 99.401 89.2528 99.3838 89.4077H99.4768C99.6041 89.2046 99.7487 89.0428 99.9105 88.9223C100.072 88.8018 100.251 88.7157 100.448 88.6641C100.644 88.609 100.857 88.5815 101.088 88.5815C101.474 88.5815 101.821 88.6555 102.131 88.8035C102.444 88.9516 102.694 89.1839 102.88 89.5007C103.066 89.814 103.159 90.2237 103.159 90.7297V94.5357H101.129V91.3443C101.129 90.9552 101.072 90.6626 100.959 90.4664C100.845 90.2667 100.67 90.1668 100.432 90.1668C100.188 90.1668 99.9949 90.2374 99.8537 90.3786C99.7126 90.5163 99.6127 90.7194 99.5542 90.9879C99.4957 91.253 99.4664 91.5784 99.4664 91.964V94.5357H97.4473V86.5003H99.4664Z" fill="black"/>
                            <path d="M44.6299 101.897L43.0919 106.18H42.5909L41.0528 101.897H41.5743L42.5762 104.718C42.6172 104.831 42.6534 104.94 42.6846 105.043C42.7178 105.147 42.7471 105.246 42.7725 105.342C42.7979 105.438 42.8204 105.53 42.8399 105.62C42.8594 105.53 42.8819 105.438 42.9073 105.342C42.9327 105.244 42.962 105.144 42.9952 105.04C43.0284 104.935 43.0655 104.824 43.1065 104.709L44.1026 101.897H44.6299ZM46.3819 102.91C46.6553 102.91 46.8897 102.971 47.085 103.092C47.2803 103.213 47.4297 103.383 47.5333 103.602C47.6368 103.818 47.6885 104.072 47.6885 104.363V104.665H45.4708C45.4766 105.042 45.5704 105.329 45.752 105.526C45.9337 105.724 46.1895 105.822 46.5196 105.822C46.7227 105.822 46.9024 105.804 47.0587 105.767C47.2149 105.73 47.377 105.675 47.545 105.603V106.03C47.3829 106.103 47.2217 106.155 47.0616 106.189C46.9034 106.222 46.7159 106.238 46.4991 106.238C46.1905 106.238 45.921 106.176 45.6905 106.051C45.462 105.924 45.2842 105.738 45.1573 105.494C45.0303 105.25 44.9669 104.951 44.9669 104.598C44.9669 104.252 45.0245 103.953 45.1397 103.701C45.2569 103.447 45.421 103.252 45.6319 103.115C45.8448 102.979 46.0948 102.91 46.3819 102.91ZM46.376 103.309C46.1163 103.309 45.9092 103.394 45.7549 103.564C45.6006 103.733 45.5088 103.971 45.4795 104.275H47.1788C47.1768 104.084 47.1465 103.916 47.0879 103.772C47.0313 103.625 46.9444 103.512 46.8272 103.432C46.71 103.35 46.5596 103.309 46.376 103.309ZM49.9737 102.91C50.0381 102.91 50.1055 102.914 50.1758 102.922C50.2462 102.928 50.3087 102.937 50.3633 102.948L50.3018 103.399C50.2491 103.386 50.1905 103.375 50.126 103.367C50.0616 103.359 50.001 103.356 49.9444 103.356C49.8155 103.356 49.6934 103.382 49.5782 103.435C49.4649 103.485 49.3653 103.56 49.2794 103.657C49.1934 103.753 49.126 103.869 49.0772 104.006C49.0284 104.141 49.004 104.291 49.004 104.457V106.18H48.5147V102.969H48.919L48.9717 103.561H48.9922C49.0587 103.441 49.1387 103.333 49.2325 103.235C49.3262 103.136 49.4346 103.057 49.5577 102.998C49.6827 102.94 49.8213 102.91 49.9737 102.91ZM51.4561 102.969V106.18H50.9698V102.969H51.4561ZM51.2188 101.768C51.2989 101.768 51.3672 101.794 51.4239 101.847C51.4825 101.898 51.5118 101.978 51.5118 102.087C51.5118 102.194 51.4825 102.274 51.4239 102.327C51.3672 102.38 51.2989 102.406 51.2188 102.406C51.1348 102.406 51.0645 102.38 51.0079 102.327C50.9532 102.274 50.9258 102.194 50.9258 102.087C50.9258 101.978 50.9532 101.898 51.0079 101.847C51.0645 101.794 51.1348 101.768 51.2188 101.768ZM53.917 103.35H53.1172V106.18H52.6309V103.35H52.0626V103.115L52.6309 102.954V102.74C52.6309 102.471 52.671 102.252 52.751 102.084C52.8311 101.914 52.9473 101.789 53.0997 101.709C53.252 101.629 53.4376 101.589 53.6563 101.589C53.7794 101.589 53.8917 101.6 53.9932 101.621C54.0967 101.643 54.1876 101.667 54.2657 101.694L54.1397 102.078C54.0733 102.057 53.9981 102.037 53.9141 102.02C53.8321 102 53.7481 101.99 53.6622 101.99C53.4766 101.99 53.3389 102.051 53.2491 102.172C53.1612 102.291 53.1172 102.479 53.1172 102.734V102.969H53.917V103.35ZM54.002 102.969H54.5235L55.2325 104.832C55.2735 104.941 55.3116 105.047 55.3467 105.148C55.3819 105.248 55.4131 105.344 55.4405 105.436C55.4678 105.527 55.4893 105.616 55.5049 105.702H55.5254C55.5528 105.605 55.5919 105.477 55.6426 105.318C55.6934 105.158 55.7481 104.995 55.8067 104.829L56.4776 102.969H57.002L55.6045 106.651C55.5303 106.849 55.4434 107.021 55.3438 107.167C55.2462 107.314 55.127 107.426 54.9864 107.504C54.8458 107.584 54.6758 107.624 54.4766 107.624C54.3848 107.624 54.3038 107.618 54.2335 107.607C54.1631 107.597 54.1026 107.585 54.0518 107.571V107.182C54.0948 107.191 54.1465 107.2 54.2071 107.208C54.2696 107.216 54.334 107.22 54.4004 107.22C54.5215 107.22 54.626 107.196 54.7139 107.149C54.8038 107.105 54.8809 107.038 54.9454 106.95C55.0098 106.862 55.0655 106.758 55.1124 106.637L55.2881 106.186L54.002 102.969ZM59.5596 102.969V106.18H59.0733V102.969H59.5596ZM59.3223 101.768C59.4024 101.768 59.4708 101.794 59.5274 101.847C59.586 101.898 59.6153 101.978 59.6153 102.087C59.6153 102.194 59.586 102.274 59.5274 102.327C59.4708 102.38 59.4024 102.406 59.3223 102.406C59.2383 102.406 59.168 102.38 59.1114 102.327C59.0567 102.274 59.0294 102.194 59.0294 102.087C59.0294 101.978 59.0567 101.898 59.1114 101.847C59.168 101.794 59.2383 101.768 59.3223 101.768ZM61.628 105.84C61.7081 105.84 61.7901 105.833 61.8741 105.819C61.9581 105.806 62.0264 105.789 62.0792 105.77V106.148C62.0225 106.173 61.9434 106.194 61.8419 106.212C61.7422 106.23 61.6446 106.238 61.5489 106.238C61.379 106.238 61.2247 106.209 61.086 106.15C60.9473 106.09 60.836 105.988 60.752 105.846C60.67 105.703 60.629 105.506 60.629 105.254V103.35H60.1719V103.112L60.6319 102.922L60.8253 102.225H61.1182V102.969H62.0587V103.35H61.1182V105.239C61.1182 105.44 61.1641 105.591 61.2559 105.69C61.3497 105.79 61.4737 105.84 61.628 105.84ZM63.1133 101.897L63.1573 101.961C63.1221 102.104 63.0772 102.257 63.0225 102.421C62.9678 102.583 62.9083 102.745 62.8438 102.907C62.7794 103.069 62.7149 103.222 62.6504 103.364H62.293C62.3223 103.253 62.3516 103.134 62.3809 103.007C62.4122 102.88 62.4415 102.751 62.4688 102.62C62.4962 102.489 62.5206 102.362 62.542 102.239C62.5655 102.116 62.585 102.002 62.6006 101.897H63.1133ZM65.8262 105.301C65.8262 105.506 65.7745 105.679 65.671 105.819C65.5694 105.958 65.4229 106.063 65.2315 106.133C65.042 106.203 64.8155 106.238 64.5518 106.238C64.3272 106.238 64.1329 106.221 63.9688 106.186C63.8047 106.15 63.6612 106.101 63.5381 106.036V105.588C63.669 105.652 63.8253 105.711 64.0069 105.764C64.1885 105.816 64.3741 105.843 64.5635 105.843C64.8409 105.843 65.042 105.798 65.167 105.708C65.292 105.618 65.3545 105.496 65.3545 105.342C65.3545 105.254 65.3292 105.177 65.2784 105.11C65.2295 105.042 65.1465 104.977 65.0294 104.914C64.9122 104.85 64.7501 104.779 64.543 104.703C64.3379 104.625 64.1602 104.548 64.0098 104.472C63.8614 104.394 63.7462 104.299 63.6641 104.188C63.584 104.076 63.544 103.932 63.544 103.754C63.544 103.482 63.6534 103.274 63.8721 103.13C64.0928 102.983 64.3819 102.91 64.7393 102.91C64.9327 102.91 65.1133 102.93 65.2813 102.969C65.4512 103.006 65.6094 103.057 65.7559 103.121L65.5919 103.511C65.459 103.454 65.3174 103.406 65.167 103.367C65.0167 103.328 64.8633 103.309 64.7071 103.309C64.4825 103.309 64.3096 103.346 64.1885 103.42C64.0694 103.494 64.0098 103.596 64.0098 103.725C64.0098 103.824 64.0372 103.906 64.0919 103.971C64.1485 104.035 64.2383 104.096 64.3614 104.152C64.4844 104.209 64.6465 104.275 64.8477 104.352C65.0489 104.426 65.2227 104.503 65.3692 104.583C65.5157 104.661 65.628 104.757 65.7061 104.87C65.7862 104.982 65.8262 105.125 65.8262 105.301ZM67.6602 102.969H68.1817L68.8907 104.832C68.9317 104.941 68.9698 105.047 69.0049 105.148C69.0401 105.248 69.0713 105.344 69.0987 105.436C69.126 105.527 69.1475 105.616 69.1631 105.702H69.1837C69.211 105.605 69.2501 105.477 69.3008 105.318C69.3516 105.158 69.4063 104.995 69.4649 104.829L70.1358 102.969H70.6602L69.2628 106.651C69.1885 106.849 69.1016 107.021 69.002 107.167C68.9044 107.314 68.7852 107.426 68.6446 107.504C68.504 107.584 68.334 107.624 68.1348 107.624C68.043 107.624 67.962 107.618 67.8917 107.607C67.8213 107.597 67.7608 107.585 67.71 107.571V107.182C67.753 107.191 67.8047 107.2 67.8653 107.208C67.9278 107.216 67.9922 107.22 68.0587 107.22C68.1797 107.22 68.2842 107.196 68.3721 107.149C68.462 107.105 68.5391 107.038 68.6036 106.95C68.668 106.862 68.7237 106.758 68.7706 106.637L68.9463 106.186L67.6602 102.969ZM73.9415 104.568C73.9415 104.832 73.9073 105.067 73.8389 105.274C73.7706 105.482 73.6719 105.656 73.543 105.799C73.4141 105.941 73.2579 106.051 73.0743 106.127C72.8926 106.201 72.6866 106.238 72.4561 106.238C72.2413 106.238 72.044 106.201 71.8643 106.127C71.6866 106.051 71.5323 105.941 71.4014 105.799C71.2725 105.656 71.1719 105.482 71.0997 105.274C71.0294 105.067 70.9942 104.832 70.9942 104.568C70.9942 104.217 71.0538 103.918 71.1729 103.672C71.292 103.424 71.462 103.235 71.6827 103.107C71.9053 102.976 72.17 102.91 72.4766 102.91C72.7696 102.91 73.0254 102.976 73.2442 103.107C73.4649 103.237 73.6358 103.427 73.7569 103.675C73.8799 103.921 73.9415 104.219 73.9415 104.568ZM71.4981 104.568C71.4981 104.826 71.5323 105.05 71.6006 105.239C71.669 105.429 71.7745 105.575 71.917 105.679C72.0596 105.782 72.2432 105.834 72.4678 105.834C72.6905 105.834 72.8731 105.782 73.0157 105.679C73.1602 105.575 73.2667 105.429 73.335 105.239C73.4034 105.05 73.4376 104.826 73.4376 104.568C73.4376 104.313 73.4034 104.092 73.335 103.906C73.2667 103.719 73.1612 103.574 73.0186 103.473C72.876 103.371 72.6915 103.32 72.4649 103.32C72.1309 103.32 71.8858 103.431 71.7295 103.651C71.5753 103.872 71.4981 104.178 71.4981 104.568ZM77.4337 102.969V106.18H77.0352L76.9649 105.729H76.9385C76.8721 105.84 76.7862 105.934 76.6807 106.01C76.5753 106.086 76.4561 106.143 76.3233 106.18C76.1924 106.219 76.0528 106.238 75.9044 106.238C75.6504 106.238 75.4376 106.197 75.2657 106.115C75.0938 106.033 74.9639 105.906 74.876 105.734C74.7901 105.563 74.7471 105.342 74.7471 105.072V102.969H75.2393V105.037C75.2393 105.305 75.2999 105.505 75.421 105.638C75.542 105.769 75.7266 105.834 75.9747 105.834C76.2129 105.834 76.4024 105.789 76.543 105.699C76.6856 105.609 76.7881 105.478 76.8506 105.304C76.9131 105.128 76.9444 104.913 76.9444 104.659V102.969H77.4337ZM80.5069 101.621V102.761C80.5069 102.892 80.503 103.019 80.4952 103.142C80.4893 103.265 80.4844 103.36 80.4805 103.429H80.5069C80.5948 103.284 80.7217 103.162 80.8878 103.063C81.0538 102.963 81.2657 102.913 81.5235 102.913C81.9258 102.913 82.2462 103.053 82.4844 103.332C82.7247 103.609 82.8448 104.023 82.8448 104.571C82.8448 104.933 82.7901 105.237 82.6807 105.485C82.5713 105.733 82.417 105.921 82.2178 106.048C82.0186 106.175 81.7833 106.238 81.5118 106.238C81.2579 106.238 81.0489 106.191 80.8848 106.098C80.7227 106.002 80.5977 105.886 80.5098 105.749H80.4717L80.3721 106.18H80.0206V101.621H80.5069ZM81.4444 103.32C81.212 103.32 81.0274 103.366 80.8907 103.458C80.754 103.548 80.6553 103.685 80.5948 103.868C80.5362 104.05 80.5069 104.28 80.5069 104.56V104.586C80.5069 104.99 80.5743 105.3 80.709 105.515C80.8438 105.728 81.0889 105.834 81.4444 105.834C81.7432 105.834 81.9669 105.725 82.1153 105.506C82.2657 105.287 82.3409 104.975 82.3409 104.568C82.3409 104.154 82.2667 103.843 82.1182 103.634C81.9717 103.425 81.7471 103.32 81.4444 103.32ZM83.1876 102.969H83.709L84.418 104.832C84.459 104.941 84.4971 105.047 84.5323 105.148C84.5674 105.248 84.5987 105.344 84.626 105.436C84.6534 105.527 84.6749 105.616 84.6905 105.702H84.711C84.7383 105.605 84.7774 105.477 84.8282 105.318C84.879 105.158 84.9337 104.995 84.9922 104.829L85.6631 102.969H86.1876L84.7901 106.651C84.7159 106.849 84.629 107.021 84.5294 107.167C84.4317 107.314 84.3126 107.426 84.1719 107.504C84.0313 107.584 83.8614 107.624 83.6622 107.624C83.5704 107.624 83.4893 107.618 83.419 107.607C83.3487 107.597 83.2881 107.585 83.2374 107.571V107.182C83.2803 107.191 83.3321 107.2 83.3926 107.208C83.4551 107.216 83.5196 107.22 83.586 107.22C83.7071 107.22 83.8116 107.196 83.8995 107.149C83.9893 107.105 84.0665 107.038 84.1309 106.95C84.1954 106.862 84.251 106.758 84.2979 106.637L84.4737 106.186L83.1876 102.969ZM89.46 102.916C89.8428 102.916 90.127 103.002 90.3126 103.174C90.4981 103.346 90.5909 103.62 90.5909 103.997V106.18H90.2364L90.1426 105.705H90.1192C90.0294 105.822 89.9356 105.921 89.8379 106.001C89.7403 106.079 89.627 106.139 89.4981 106.18C89.3712 106.219 89.2149 106.238 89.0294 106.238C88.834 106.238 88.6602 106.204 88.5079 106.136C88.3575 106.067 88.2383 105.964 88.1504 105.825C88.0645 105.687 88.0215 105.511 88.0215 105.298C88.0215 104.978 88.1485 104.732 88.4024 104.56C88.6563 104.388 89.043 104.294 89.5626 104.278L90.1163 104.255V104.059C90.1163 103.781 90.0567 103.587 89.9376 103.476C89.8184 103.364 89.6504 103.309 89.4337 103.309C89.2657 103.309 89.1055 103.333 88.9532 103.382C88.8008 103.431 88.6563 103.488 88.5196 103.555L88.3702 103.186C88.5147 103.111 88.6807 103.048 88.8682 102.995C89.0557 102.942 89.253 102.916 89.46 102.916ZM90.1104 104.598L89.6212 104.618C89.2208 104.634 88.9385 104.699 88.7745 104.815C88.6104 104.93 88.5284 105.093 88.5284 105.304C88.5284 105.487 88.584 105.623 88.6954 105.711C88.8067 105.799 88.9542 105.843 89.1378 105.843C89.4229 105.843 89.6563 105.764 89.8379 105.606C90.0196 105.447 90.1104 105.21 90.1104 104.894V104.598ZM93.1016 102.91C93.502 102.91 93.8213 103.048 94.0596 103.323C94.2979 103.599 94.417 104.013 94.417 104.565C94.417 104.931 94.3624 105.237 94.253 105.485C94.1436 105.733 93.9893 105.921 93.7901 106.048C93.5928 106.175 93.3594 106.238 93.0899 106.238C92.92 106.238 92.7706 106.216 92.6417 106.171C92.5128 106.126 92.4024 106.065 92.3106 105.989C92.2188 105.913 92.1426 105.83 92.0821 105.74H92.0469C92.0528 105.816 92.0596 105.908 92.0674 106.016C92.0772 106.123 92.0821 106.217 92.0821 106.297V107.615H91.5928V102.969H91.9942L92.0587 103.443H92.0821C92.1446 103.346 92.2208 103.257 92.3106 103.177C92.4004 103.095 92.5098 103.03 92.6387 102.983C92.7696 102.935 92.9239 102.91 93.1016 102.91ZM93.0167 103.32C92.794 103.32 92.6143 103.363 92.4776 103.449C92.3428 103.535 92.2442 103.664 92.1817 103.836C92.1192 104.006 92.086 104.22 92.0821 104.478V104.571C92.0821 104.843 92.1114 105.072 92.17 105.26C92.2305 105.447 92.3292 105.59 92.4659 105.688C92.6045 105.785 92.7901 105.834 93.0225 105.834C93.2217 105.834 93.3878 105.78 93.5206 105.673C93.6534 105.565 93.752 105.416 93.8165 105.225C93.8829 105.031 93.9161 104.81 93.9161 104.56C93.9161 104.181 93.8419 103.88 93.6934 103.657C93.5469 103.433 93.3213 103.32 93.0167 103.32ZM96.7754 102.91C97.1758 102.91 97.4952 103.048 97.7335 103.323C97.9717 103.599 98.0909 104.013 98.0909 104.565C98.0909 104.931 98.0362 105.237 97.9268 105.485C97.8174 105.733 97.6631 105.921 97.4639 106.048C97.2667 106.175 97.0333 106.238 96.7637 106.238C96.5938 106.238 96.4444 106.216 96.3155 106.171C96.1866 106.126 96.0762 106.065 95.9844 105.989C95.8926 105.913 95.8165 105.83 95.7559 105.74H95.7208C95.7266 105.816 95.7335 105.908 95.7413 106.016C95.751 106.123 95.7559 106.217 95.7559 106.297V107.615H95.2667V102.969H95.668L95.7325 103.443H95.7559C95.8184 103.346 95.8946 103.257 95.9844 103.177C96.0743 103.095 96.1837 103.03 96.3126 102.983C96.4434 102.935 96.5977 102.91 96.7754 102.91ZM96.6905 103.32C96.4678 103.32 96.2881 103.363 96.1514 103.449C96.0167 103.535 95.918 103.664 95.8555 103.836C95.793 104.006 95.7598 104.22 95.7559 104.478V104.571C95.7559 104.843 95.7852 105.072 95.8438 105.26C95.9044 105.447 96.003 105.59 96.1397 105.688C96.2784 105.785 96.4639 105.834 96.6963 105.834C96.8956 105.834 97.0616 105.78 97.1944 105.673C97.3272 105.565 97.4258 105.416 97.4903 105.225C97.5567 105.031 97.5899 104.81 97.5899 104.56C97.5899 104.181 97.5157 103.88 97.3672 103.657C97.2208 103.433 96.9952 103.32 96.6905 103.32ZM100.399 102.91C100.464 102.91 100.531 102.914 100.602 102.922C100.672 102.928 100.734 102.937 100.789 102.948L100.728 103.399C100.675 103.386 100.616 103.375 100.552 103.367C100.487 103.359 100.427 103.356 100.37 103.356C100.241 103.356 100.119 103.382 100.004 103.435C99.8907 103.485 99.7911 103.56 99.7051 103.657C99.6192 103.753 99.5518 103.869 99.503 104.006C99.4542 104.141 99.4297 104.291 99.4297 104.457V106.18H98.9405V102.969H99.3448L99.3975 103.561H99.418C99.4844 103.441 99.5645 103.333 99.6583 103.235C99.752 103.136 99.8604 103.057 99.9835 102.998C100.108 102.94 100.247 102.91 100.399 102.91ZM104.164 104.568C104.164 104.832 104.13 105.067 104.062 105.274C103.993 105.482 103.895 105.656 103.766 105.799C103.637 105.941 103.481 106.051 103.297 106.127C103.115 106.201 102.909 106.238 102.679 106.238C102.464 106.238 102.267 106.201 102.087 106.127C101.909 106.051 101.755 105.941 101.624 105.799C101.495 105.656 101.395 105.482 101.322 105.274C101.252 105.067 101.217 104.832 101.217 104.568C101.217 104.217 101.276 103.918 101.396 103.672C101.515 103.424 101.685 103.235 101.905 103.107C102.128 102.976 102.393 102.91 102.699 102.91C102.992 102.91 103.248 102.976 103.467 103.107C103.688 103.237 103.858 103.427 103.98 103.675C104.103 103.921 104.164 104.219 104.164 104.568ZM101.721 104.568C101.721 104.826 101.755 105.05 101.823 105.239C101.892 105.429 101.997 105.575 102.14 105.679C102.282 105.782 102.466 105.834 102.69 105.834C102.913 105.834 103.096 105.782 103.238 105.679C103.383 105.575 103.489 105.429 103.558 105.239C103.626 105.05 103.66 104.826 103.66 104.568C103.66 104.313 103.626 104.092 103.558 103.906C103.489 103.719 103.384 103.574 103.241 103.473C103.099 103.371 102.914 103.32 102.688 103.32C102.354 103.32 102.108 103.431 101.952 103.651C101.798 103.872 101.721 104.178 101.721 104.568ZM105.711 106.18L104.492 102.969H105.014L105.72 104.911C105.769 105.044 105.818 105.19 105.869 105.351C105.92 105.511 105.955 105.64 105.975 105.737H105.995C106.019 105.64 106.058 105.511 106.112 105.351C106.167 105.189 106.217 105.042 106.262 104.911L106.968 102.969H107.489L106.268 106.18H105.711ZM108.491 102.969V106.18H108.005V102.969H108.491ZM108.254 101.768C108.334 101.768 108.402 101.794 108.459 101.847C108.518 101.898 108.547 101.978 108.547 102.087C108.547 102.194 108.518 102.274 108.459 102.327C108.402 102.38 108.334 102.406 108.254 102.406C108.17 102.406 108.1 102.38 108.043 102.327C107.988 102.274 107.961 102.194 107.961 102.087C107.961 101.978 107.988 101.898 108.043 101.847C108.1 101.794 108.17 101.768 108.254 101.768ZM111.043 102.91C111.424 102.91 111.712 103.004 111.907 103.191C112.103 103.377 112.2 103.676 112.2 104.088V106.18H111.72V104.12C111.72 103.853 111.658 103.652 111.535 103.52C111.414 103.387 111.228 103.32 110.976 103.32C110.62 103.32 110.37 103.421 110.226 103.622C110.081 103.823 110.009 104.115 110.009 104.498V106.18H109.523V102.969H109.915L109.988 103.432H110.015C110.083 103.318 110.17 103.224 110.275 103.148C110.381 103.069 110.499 103.011 110.63 102.972C110.761 102.931 110.898 102.91 111.043 102.91ZM114.099 107.621C113.677 107.621 113.352 107.542 113.123 107.384C112.895 107.228 112.78 107.008 112.78 106.725C112.78 106.523 112.844 106.352 112.971 106.209C113.1 106.066 113.277 105.972 113.504 105.925C113.42 105.886 113.348 105.827 113.287 105.749C113.229 105.671 113.199 105.581 113.199 105.48C113.199 105.362 113.232 105.26 113.296 105.172C113.362 105.082 113.463 104.996 113.598 104.914C113.43 104.846 113.293 104.731 113.188 104.568C113.084 104.404 113.032 104.214 113.032 103.997C113.032 103.767 113.08 103.57 113.176 103.408C113.272 103.244 113.41 103.119 113.592 103.033C113.773 102.947 113.993 102.904 114.251 102.904C114.308 102.904 114.364 102.907 114.421 102.913C114.48 102.917 114.535 102.924 114.588 102.934C114.641 102.941 114.687 102.951 114.726 102.963H115.827V103.276L115.235 103.35C115.294 103.426 115.343 103.518 115.382 103.625C115.421 103.732 115.44 103.852 115.44 103.982C115.44 104.303 115.332 104.558 115.115 104.747C114.898 104.935 114.601 105.028 114.222 105.028C114.132 105.028 114.04 105.021 113.946 105.005C113.851 105.058 113.777 105.116 113.727 105.181C113.678 105.245 113.653 105.319 113.653 105.403C113.653 105.466 113.672 105.516 113.709 105.553C113.748 105.59 113.804 105.617 113.876 105.635C113.948 105.65 114.035 105.658 114.137 105.658H114.702C115.052 105.658 115.319 105.732 115.505 105.878C115.692 106.024 115.786 106.238 115.786 106.52C115.786 106.875 115.642 107.148 115.353 107.337C115.064 107.526 114.646 107.621 114.099 107.621ZM114.113 107.24C114.379 107.24 114.599 107.213 114.773 107.158C114.948 107.106 115.079 107.028 115.165 106.927C115.253 106.827 115.297 106.708 115.297 106.569C115.297 106.44 115.268 106.343 115.209 106.276C115.15 106.212 115.065 106.169 114.951 106.148C114.838 106.124 114.699 106.112 114.535 106.112H113.979C113.834 106.112 113.708 106.135 113.601 106.18C113.493 106.225 113.41 106.291 113.352 106.379C113.295 106.467 113.267 106.576 113.267 106.707C113.267 106.881 113.34 107.013 113.486 107.103C113.633 107.194 113.842 107.24 114.113 107.24ZM114.239 104.674C114.472 104.674 114.647 104.615 114.764 104.498C114.881 104.381 114.94 104.21 114.94 103.985C114.94 103.745 114.88 103.565 114.761 103.446C114.642 103.325 114.466 103.265 114.233 103.265C114.011 103.265 113.839 103.327 113.718 103.452C113.599 103.575 113.539 103.756 113.539 103.994C113.539 104.213 113.6 104.381 113.721 104.498C113.842 104.615 114.015 104.674 114.239 104.674ZM58.8594 113.84C58.9395 113.84 59.0215 113.833 59.1055 113.819C59.1895 113.806 59.2579 113.789 59.3106 113.77V114.148C59.254 114.173 59.1749 114.194 59.0733 114.212C58.9737 114.23 58.876 114.238 58.7803 114.238C58.6104 114.238 58.4561 114.209 58.3174 114.15C58.1788 114.09 58.0674 113.988 57.9835 113.846C57.9014 113.703 57.8604 113.506 57.8604 113.254V111.35H57.4034V111.112L57.8633 110.922L58.0567 110.225H58.3497V110.969H59.2901V111.35H58.3497V113.239C58.3497 113.44 58.3956 113.591 58.4874 113.69C58.5811 113.79 58.7051 113.84 58.8594 113.84ZM60.4473 109.621V110.983C60.4473 111.062 60.4454 111.141 60.4415 111.221C60.4376 111.299 60.4307 111.371 60.421 111.438H60.4532C60.5196 111.324 60.6036 111.23 60.7051 111.153C60.8087 111.075 60.9258 111.017 61.0567 110.978C61.1876 110.937 61.3262 110.916 61.4727 110.916C61.7305 110.916 61.9454 110.957 62.1172 111.039C62.2911 111.121 62.421 111.248 62.5069 111.42C62.5948 111.592 62.6387 111.815 62.6387 112.088V114.18H62.1583V112.12C62.1583 111.853 62.0967 111.652 61.9737 111.52C61.8526 111.387 61.6661 111.32 61.4141 111.32C61.1758 111.32 60.9854 111.366 60.8428 111.458C60.7022 111.548 60.6006 111.681 60.5381 111.857C60.4776 112.032 60.4473 112.247 60.4473 112.501V114.18H59.961V109.621H60.4473ZM64.877 110.91C65.1504 110.91 65.3848 110.971 65.5801 111.092C65.7754 111.213 65.9249 111.383 66.0284 111.602C66.1319 111.818 66.1837 112.072 66.1837 112.363V112.665H63.9659C63.9717 113.042 64.0655 113.329 64.2471 113.526C64.4288 113.724 64.6846 113.822 65.0147 113.822C65.2178 113.822 65.3975 113.804 65.5538 113.767C65.71 113.73 65.8721 113.675 66.0401 113.603V114.03C65.878 114.103 65.7169 114.155 65.5567 114.189C65.3985 114.222 65.211 114.238 64.9942 114.238C64.6856 114.238 64.4161 114.176 64.1856 114.051C63.9571 113.924 63.7794 113.738 63.6524 113.494C63.5254 113.25 63.462 112.951 63.462 112.598C63.462 112.252 63.5196 111.953 63.6348 111.701C63.752 111.447 63.9161 111.252 64.127 111.115C64.3399 110.979 64.5899 110.91 64.877 110.91ZM64.8712 111.309C64.6114 111.309 64.4044 111.394 64.2501 111.564C64.0958 111.733 64.004 111.971 63.9747 112.275H65.6739C65.6719 112.084 65.6417 111.916 65.5831 111.772C65.5264 111.625 65.4395 111.512 65.3223 111.432C65.2051 111.35 65.0547 111.309 64.8712 111.309ZM70.0889 110.91C70.4698 110.91 70.7579 111.004 70.9532 111.191C71.1485 111.377 71.2462 111.676 71.2462 112.088V114.18H70.7657V112.12C70.7657 111.853 70.7042 111.652 70.5811 111.52C70.46 111.387 70.2735 111.32 70.0215 111.32C69.6661 111.32 69.4161 111.421 69.2715 111.622C69.127 111.823 69.0547 112.115 69.0547 112.498V114.18H68.5684V110.969H68.961L69.0342 111.432H69.0606C69.129 111.318 69.2159 111.224 69.3213 111.148C69.4268 111.069 69.545 111.011 69.6758 110.972C69.8067 110.931 69.9444 110.91 70.0889 110.91ZM75.0167 112.568C75.0167 112.832 74.9825 113.067 74.9141 113.274C74.8458 113.482 74.7471 113.656 74.6182 113.799C74.4893 113.941 74.3331 114.051 74.1495 114.127C73.9678 114.201 73.7618 114.238 73.5313 114.238C73.3165 114.238 73.1192 114.201 72.9395 114.127C72.7618 114.051 72.6075 113.941 72.4766 113.799C72.3477 113.656 72.2471 113.482 72.1749 113.274C72.1045 113.067 72.0694 112.832 72.0694 112.568C72.0694 112.217 72.129 111.918 72.2481 111.672C72.3672 111.424 72.5372 111.235 72.7579 111.107C72.9805 110.976 73.2452 110.91 73.5518 110.91C73.8448 110.91 74.1006 110.976 74.3194 111.107C74.5401 111.237 74.711 111.427 74.8321 111.675C74.9551 111.921 75.0167 112.219 75.0167 112.568ZM72.5733 112.568C72.5733 112.826 72.6075 113.05 72.6758 113.239C72.7442 113.429 72.8497 113.575 72.9922 113.679C73.1348 113.782 73.3184 113.834 73.543 113.834C73.7657 113.834 73.9483 113.782 74.0909 113.679C74.2354 113.575 74.3419 113.429 74.4102 113.239C74.4786 113.05 74.5128 112.826 74.5128 112.568C74.5128 112.313 74.4786 112.092 74.4102 111.906C74.3419 111.719 74.2364 111.574 74.0938 111.473C73.9512 111.371 73.7667 111.32 73.5401 111.32C73.2061 111.32 72.961 111.431 72.8047 111.651C72.6504 111.872 72.5733 112.178 72.5733 112.568ZM76.8946 113.84C76.9747 113.84 77.0567 113.833 77.1407 113.819C77.2247 113.806 77.293 113.789 77.3458 113.77V114.148C77.2891 114.173 77.21 114.194 77.1085 114.212C77.0088 114.23 76.9112 114.238 76.8155 114.238C76.6456 114.238 76.4913 114.209 76.3526 114.15C76.2139 114.09 76.1026 113.988 76.0186 113.846C75.9366 113.703 75.8956 113.506 75.8956 113.254V111.35H75.4385V111.112L75.8985 110.922L76.0919 110.225H76.3848V110.969H77.3253V111.35H76.3848V113.239C76.3848 113.44 76.4307 113.591 76.5225 113.69C76.6163 113.79 76.7403 113.84 76.8946 113.84ZM78.4825 110.969V114.18H77.9962V110.969H78.4825ZM78.2452 109.768C78.3253 109.768 78.3936 109.794 78.4503 109.847C78.5088 109.898 78.5381 109.978 78.5381 110.087C78.5381 110.194 78.5088 110.274 78.4503 110.327C78.3936 110.38 78.3253 110.406 78.2452 110.406C78.1612 110.406 78.0909 110.38 78.0342 110.327C77.9795 110.274 77.9522 110.194 77.9522 110.087C77.9522 109.978 77.9795 109.898 78.0342 109.847C78.0909 109.794 78.1612 109.768 78.2452 109.768ZM80.9434 111.35H80.1436V114.18H79.6573V111.35H79.0889V111.115L79.6573 110.954V110.74C79.6573 110.471 79.6973 110.252 79.7774 110.084C79.8575 109.914 79.9737 109.789 80.126 109.709C80.2784 109.629 80.4639 109.589 80.6827 109.589C80.8057 109.589 80.918 109.6 81.0196 109.621C81.1231 109.643 81.2139 109.667 81.292 109.694L81.1661 110.078C81.0997 110.057 81.0245 110.037 80.9405 110.02C80.8585 110 80.7745 109.99 80.6885 109.99C80.503 109.99 80.3653 110.051 80.2754 110.172C80.1876 110.291 80.1436 110.479 80.1436 110.734V110.969H80.9434V111.35ZM82.0186 110.969V114.18H81.5323V110.969H82.0186ZM81.7813 109.768C81.8614 109.768 81.9297 109.794 81.9864 109.847C82.045 109.898 82.0743 109.978 82.0743 110.087C82.0743 110.194 82.045 110.274 81.9864 110.327C81.9297 110.38 81.8614 110.406 81.7813 110.406C81.6973 110.406 81.627 110.38 81.5704 110.327C81.5157 110.274 81.4883 110.194 81.4883 110.087C81.4883 109.978 81.5157 109.898 81.5704 109.847C81.627 109.794 81.6973 109.768 81.7813 109.768ZM84.3331 114.238C84.044 114.238 83.7891 114.179 83.5684 114.06C83.3477 113.94 83.1758 113.759 83.0528 113.515C82.9297 113.271 82.8682 112.963 82.8682 112.592C82.8682 112.203 82.9327 111.886 83.0616 111.64C83.1924 111.392 83.3721 111.208 83.6006 111.089C83.8292 110.97 84.0889 110.91 84.3799 110.91C84.5401 110.91 84.6944 110.927 84.8428 110.96C84.9932 110.991 85.1163 111.031 85.212 111.08L85.0655 111.487C84.9678 111.448 84.8545 111.413 84.7256 111.382C84.5987 111.351 84.4795 111.335 84.3682 111.335C84.1456 111.335 83.96 111.383 83.8116 111.479C83.6651 111.574 83.5547 111.715 83.4805 111.9C83.4083 112.086 83.3721 112.315 83.3721 112.586C83.3721 112.846 83.4073 113.067 83.4776 113.251C83.5499 113.435 83.6563 113.575 83.7969 113.673C83.9395 113.769 84.1172 113.816 84.3301 113.816C84.5001 113.816 84.6534 113.799 84.7901 113.764C84.9268 113.727 85.0508 113.684 85.1622 113.635V114.068C85.0547 114.123 84.9346 114.165 84.8018 114.194C84.671 114.224 84.5147 114.238 84.3331 114.238ZM87.1251 110.916C87.5079 110.916 87.792 111.002 87.9776 111.174C88.1631 111.346 88.2559 111.62 88.2559 111.997V114.18H87.9014L87.8077 113.705H87.7842C87.6944 113.822 87.6006 113.921 87.503 114.001C87.4053 114.079 87.292 114.139 87.1631 114.18C87.0362 114.219 86.8799 114.238 86.6944 114.238C86.4991 114.238 86.3253 114.204 86.1729 114.136C86.0225 114.067 85.9034 113.964 85.8155 113.825C85.7295 113.687 85.6866 113.511 85.6866 113.298C85.6866 112.978 85.8135 112.732 86.0674 112.56C86.3213 112.388 86.7081 112.294 87.2276 112.278L87.7813 112.255V112.059C87.7813 111.781 87.7217 111.587 87.6026 111.476C87.4835 111.364 87.3155 111.309 87.0987 111.309C86.9307 111.309 86.7706 111.333 86.6182 111.382C86.4659 111.431 86.3213 111.488 86.1846 111.555L86.0352 111.186C86.1797 111.111 86.3458 111.048 86.5333 110.995C86.7208 110.942 86.918 110.916 87.1251 110.916ZM87.7754 112.598L87.2862 112.618C86.8858 112.634 86.6036 112.699 86.4395 112.815C86.2754 112.93 86.1934 113.093 86.1934 113.304C86.1934 113.487 86.2491 113.623 86.3604 113.711C86.4717 113.799 86.6192 113.843 86.8028 113.843C87.0879 113.843 87.3213 113.764 87.503 113.606C87.6846 113.447 87.7754 113.21 87.7754 112.894V112.598ZM90.295 113.84C90.3751 113.84 90.4571 113.833 90.5411 113.819C90.6251 113.806 90.6934 113.789 90.7462 113.77V114.148C90.6895 114.173 90.6104 114.194 90.5088 114.212C90.4092 114.23 90.3116 114.238 90.2159 114.238C90.046 114.238 89.8917 114.209 89.753 114.15C89.6143 114.09 89.503 113.988 89.419 113.846C89.337 113.703 89.296 113.506 89.296 113.254V111.35H88.8389V111.112L89.2989 110.922L89.4922 110.225H89.7852V110.969H90.7256V111.35H89.7852V113.239C89.7852 113.44 89.8311 113.591 89.9229 113.69C90.0167 113.79 90.1407 113.84 90.295 113.84ZM91.8829 110.969V114.18H91.3965V110.969H91.8829ZM91.6456 109.768C91.7256 109.768 91.794 109.794 91.8506 109.847C91.9092 109.898 91.9385 109.978 91.9385 110.087C91.9385 110.194 91.9092 110.274 91.8506 110.327C91.794 110.38 91.7256 110.406 91.6456 110.406C91.5616 110.406 91.4913 110.38 91.4346 110.327C91.3799 110.274 91.3526 110.194 91.3526 110.087C91.3526 109.978 91.3799 109.898 91.4346 109.847C91.4913 109.794 91.5616 109.768 91.6456 109.768ZM95.6827 112.568C95.6827 112.832 95.6485 113.067 95.5801 113.274C95.5118 113.482 95.4131 113.656 95.2842 113.799C95.1553 113.941 94.9991 114.051 94.8155 114.127C94.6338 114.201 94.4278 114.238 94.1973 114.238C93.9825 114.238 93.7852 114.201 93.6055 114.127C93.4278 114.051 93.2735 113.941 93.1426 113.799C93.0137 113.656 92.9131 113.482 92.8409 113.274C92.7706 113.067 92.7354 112.832 92.7354 112.568C92.7354 112.217 92.795 111.918 92.9141 111.672C93.0333 111.424 93.2032 111.235 93.4239 111.107C93.6465 110.976 93.9112 110.91 94.2178 110.91C94.5108 110.91 94.7667 110.976 94.9854 111.107C95.2061 111.237 95.377 111.427 95.4981 111.675C95.6212 111.921 95.6827 112.219 95.6827 112.568ZM93.2393 112.568C93.2393 112.826 93.2735 113.05 93.3419 113.239C93.4102 113.429 93.5157 113.575 93.6583 113.679C93.8008 113.782 93.9844 113.834 94.209 113.834C94.4317 113.834 94.6143 113.782 94.7569 113.679C94.9014 113.575 95.0079 113.429 95.0762 113.239C95.1446 113.05 95.1788 112.826 95.1788 112.568C95.1788 112.313 95.1446 112.092 95.0762 111.906C95.0079 111.719 94.9024 111.574 94.7598 111.473C94.6172 111.371 94.4327 111.32 94.2061 111.32C93.8721 111.32 93.627 111.431 93.4708 111.651C93.3165 111.872 93.2393 112.178 93.2393 112.568ZM98.044 110.91C98.4249 110.91 98.7129 111.004 98.9083 111.191C99.1036 111.377 99.2012 111.676 99.2012 112.088V114.18H98.7208V112.12C98.7208 111.853 98.6592 111.652 98.5362 111.52C98.4151 111.387 98.2286 111.32 97.9766 111.32C97.6212 111.32 97.3712 111.421 97.2266 111.622C97.0821 111.823 97.0098 112.115 97.0098 112.498V114.18H96.5235V110.969H96.9161L96.9893 111.432H97.0157C97.084 111.318 97.171 111.224 97.2764 111.148C97.3819 111.069 97.5001 111.011 97.6309 110.972C97.7618 110.931 97.8995 110.91 98.044 110.91Z" fill="black"/>
                            <rect x="55.6697" y="139.976" width="45.6606" height="29.191" fill="url(#pattern0)"/>
                            <path d="M16.5 35.305C16.5 32.0195 19.1635 29.356 22.4491 29.356H134.551C137.837 29.356 140.5 32.0195 140.5 35.305C140.5 34.94 139.02 34.644 137.195 34.644H19.805C17.9797 34.644 16.5 34.94 16.5 35.305ZM140.5 208H16.5H140.5ZM16.5 208V32V208ZM140.5 32V208V32Z" fill="#2F67DD" mask="url(#path-1-inside-1_280_143472)"/>
                        </g>
                        <defs>
                            <filter id="filter0_d_280_143472" x="13.856" y="32" width="129.288" height="181.288" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                <feOffset dy="2.64404"/>
                                <feGaussianBlur stdDeviation="1.32202"/>
                                <feComposite in2="hardAlpha" operator="out"/>
                                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_280_143472"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_280_143472" result="shape"/>
                            </filter>
                            <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
                                <use xlink:href="#image0_280_143472" transform="scale(0.00248756 0.00389105)"/>
                            </pattern>
                        </defs>
                    </svg>
                    <p><?= __('Use you 2FA device to authenticate.'); ?></p>
                </div>
                <div class="step">
                    <!-- SVG setup duo success -->
                    <svg width="157" height="240" viewBox="0 0 157 240" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g filter="url(#filter0_d_280_143490)">
                            <mask id="path-1-inside-1_280_143490" fill="white">
                                <path d="M16.5 35.305C16.5 33.4797 17.9797 32 19.805 32H137.195C139.02 32 140.5 33.4797 140.5 35.305V204.695C140.5 206.52 139.02 208 137.195 208H19.805C17.9797 208 16.5 206.52 16.5 204.695V35.305Z"/>
                            </mask>
                            <path d="M16.5 35.305C16.5 33.4797 17.9797 32 19.805 32H137.195C139.02 32 140.5 33.4797 140.5 35.305V204.695C140.5 206.52 139.02 208 137.195 208H19.805C17.9797 208 16.5 206.52 16.5 204.695V35.305Z" fill="white" shape-rendering="crispEdges"/>
                            <path d="M41.3698 48.4611L35.382 42.9354C35.126 42.7044 34.7907 42.5762 34.4427 42.5762C34.0947 42.5762 33.7594 42.7044 33.5034 42.9354L29.7461 46.4178C30.2383 46.5969 30.6804 46.8872 31.0365 47.2652C31.3926 47.6432 31.6526 48.0982 31.7955 48.5933H36.8679C36.9297 48.5933 36.9909 48.6052 37.048 48.6284C37.1051 48.6517 37.1569 48.6857 37.2006 48.7286C37.2442 48.7715 37.2787 48.8225 37.3022 48.8785C37.3258 48.9345 37.3377 48.9945 37.3375 49.0551V49.8132C37.3377 49.8738 37.3258 49.9338 37.3022 49.9898C37.2787 50.0458 37.2442 50.0968 37.2006 50.1397C37.1569 50.1826 37.1051 50.2166 37.048 50.2399C36.9909 50.2631 36.9297 50.2751 36.8679 50.2751H36.2821V51.3477C36.2825 51.4082 36.2707 51.4682 36.2474 51.5242C36.2241 51.5803 36.1897 51.6312 36.1462 51.6741C36.1027 51.7171 36.051 51.7511 35.994 51.7744C35.937 51.7976 35.8759 51.8096 35.8141 51.8096H34.5281C34.4663 51.8096 34.4052 51.7976 34.3482 51.7744C34.2912 51.7511 34.2395 51.7171 34.196 51.6741C34.1525 51.6312 34.1181 51.5803 34.0948 51.5242C34.0715 51.4682 34.0597 51.4082 34.0601 51.3477V50.2751H31.7955C31.6596 50.7755 31.4023 51.2364 31.0455 51.6183C30.6886 52.0003 30.2428 52.2922 29.7461 52.4689L33.5205 55.9564C33.7765 56.1874 34.1118 56.3156 34.4598 56.3156C34.8078 56.3156 35.1431 56.1874 35.3991 55.9564L41.3766 50.434C41.5125 50.3064 41.6205 50.153 41.6941 49.9831C41.7677 49.8133 41.8053 49.6306 41.8047 49.4461C41.8041 49.2616 41.7652 49.0792 41.6904 48.9098C41.6157 48.7405 41.5066 48.5878 41.3698 48.4611Z" fill="#D40101"/>
                            <path d="M28.6337 47.924C28.3895 47.9287 28.1493 47.9858 27.9301 48.0913C27.6849 48.2105 27.4766 48.3917 27.3268 48.6162C27.177 48.8406 27.0911 49.1002 27.0779 49.3681C27.0648 49.636 27.1249 49.9025 27.252 50.14C27.3792 50.3775 27.5687 50.5775 27.8011 50.7192C28.0335 50.8609 28.3003 50.9392 28.574 50.9461C28.8476 50.9529 29.1181 50.8881 29.3576 50.7582C29.5971 50.6283 29.7968 50.4381 29.9362 50.2073C30.0755 49.9764 30.1495 49.7133 30.1503 49.4451C30.1551 49.247 30.1194 49.05 30.0453 48.8656C29.9713 48.6813 29.8603 48.5133 29.719 48.3715C29.5777 48.2298 29.4089 48.1172 29.2225 48.0403C29.0361 47.9635 28.8359 47.9239 28.6337 47.924Z" fill="#D40101"/>
                            <path d="M61.6805 78.2428C61.6805 78.6525 61.5772 79.0416 61.3706 79.4099C61.1641 79.7749 60.8422 80.0709 60.4049 80.2982C59.9712 80.5254 59.41 80.639 58.7214 80.639C58.3772 80.639 58.0742 80.6235 57.8125 80.5925C57.5543 80.5615 57.3133 80.5116 57.0896 80.4428C56.8658 80.3705 56.6334 80.2775 56.3924 80.1639V78.3461C56.8021 78.5527 57.2152 78.711 57.6318 78.8212C58.0484 78.9279 58.4254 78.9813 58.7627 78.9813C58.9659 78.9813 59.1311 78.9572 59.2585 78.909C59.3893 78.8608 59.4857 78.7954 59.5477 78.7128C59.6097 78.6267 59.6406 78.5286 59.6406 78.4184C59.6406 78.2876 59.5942 78.1774 59.5012 78.0879C59.4117 77.995 59.2671 77.8986 59.0674 77.7987C58.8677 77.6989 58.6044 77.5749 58.2773 77.4269C57.9985 77.2961 57.7454 77.1618 57.5182 77.0241C57.2944 76.8864 57.1016 76.7297 56.9398 76.5542C56.7814 76.3751 56.6592 76.1668 56.5732 75.9293C56.4871 75.6917 56.444 75.4112 56.444 75.0875C56.444 74.6021 56.5628 74.1959 56.8004 73.8688C57.0414 73.5383 57.3753 73.2904 57.8022 73.1252C58.2326 72.9599 58.7283 72.8773 59.2895 72.8773C59.7818 72.8773 60.2242 72.9324 60.6167 73.0426C61.0126 73.1527 61.3672 73.2784 61.6805 73.4195L61.0556 74.9946C60.732 74.8466 60.4135 74.7295 60.1003 74.6434C59.787 74.5539 59.4961 74.5092 59.2275 74.5092C59.0519 74.5092 58.9073 74.5315 58.7937 74.5763C58.6836 74.6176 58.6009 74.6744 58.5459 74.7467C58.4942 74.819 58.4684 74.9016 58.4684 74.9946C58.4684 75.1116 58.5131 75.2166 58.6027 75.3096C58.6956 75.4026 58.8488 75.5041 59.0623 75.6143C59.2792 75.721 59.5735 75.8604 59.9453 76.0326C60.3137 76.1978 60.627 76.3769 60.8852 76.5697C61.1434 76.759 61.3396 76.9879 61.4739 77.2565C61.6116 77.5216 61.6805 77.8504 61.6805 78.2428ZM68.4197 74.6847V80.5357H66.8963L66.6432 79.8076H66.5244C66.4039 80.0038 66.2507 80.1639 66.0648 80.2878C65.8824 80.4083 65.6792 80.4961 65.4555 80.5512C65.2317 80.6097 64.9993 80.639 64.7583 80.639C64.3762 80.639 64.0302 80.565 63.7203 80.4169C63.4139 80.2689 63.1695 80.0365 62.987 79.7198C62.808 79.403 62.7185 78.9951 62.7185 78.4959V74.6847H64.7376V77.8813C64.7376 78.26 64.791 78.5492 64.8977 78.7489C65.0079 78.9452 65.1869 79.0433 65.4348 79.0433C65.6896 79.0433 65.8858 78.9744 66.0235 78.8367C66.1647 78.699 66.2628 78.4959 66.3179 78.2273C66.373 77.9588 66.4005 77.6317 66.4005 77.2462V74.6847H68.4197ZM72.4787 80.639C71.8865 80.639 71.3718 80.534 70.9346 80.324C70.4974 80.1105 70.1583 79.7835 69.9173 79.3428C69.6797 78.8987 69.5609 78.3306 69.5609 77.6386C69.5609 76.9294 69.6935 76.3493 69.9586 75.8983C70.2271 75.4473 70.5938 75.1151 71.0585 74.9016C71.5233 74.6882 72.0501 74.5815 72.6388 74.5815C72.9968 74.5815 73.3359 74.6211 73.6561 74.7002C73.9797 74.7794 74.2792 74.8879 74.5547 75.0256L73.9608 76.518C73.7198 76.4113 73.4943 76.3269 73.2843 76.265C73.0777 76.1996 72.8625 76.1668 72.6388 76.1668C72.4356 76.1668 72.2566 76.2202 72.1017 76.3269C71.9468 76.4337 71.8263 76.5955 71.7402 76.8124C71.6541 77.0258 71.6111 77.2978 71.6111 77.6283C71.6111 77.9657 71.6541 78.2377 71.7402 78.4442C71.8297 78.6508 71.9519 78.8006 72.1069 78.8935C72.2652 78.9865 72.446 79.0329 72.6491 79.0329C72.9417 79.0329 73.2326 78.9882 73.5218 78.8987C73.8145 78.8057 74.0916 78.6783 74.3533 78.5165V80.1226C74.1123 80.2809 73.8403 80.4066 73.5373 80.4996C73.2344 80.5925 72.8815 80.639 72.4787 80.639ZM78.1799 80.639C77.5877 80.639 77.073 80.534 76.6358 80.324C76.1986 80.1105 75.8595 79.7835 75.6185 79.3428C75.3809 78.8987 75.2621 78.3306 75.2621 77.6386C75.2621 76.9294 75.3947 76.3493 75.6598 75.8983C75.9283 75.4473 76.295 75.1151 76.7597 74.9016C77.2245 74.6882 77.7513 74.5815 78.34 74.5815C78.698 74.5815 79.0371 74.6211 79.3573 74.7002C79.6809 74.7794 79.9804 74.8879 80.2559 75.0256L79.662 76.518C79.421 76.4113 79.1955 76.3269 78.9855 76.265C78.7789 76.1996 78.5637 76.1668 78.34 76.1668C78.1368 76.1668 77.9578 76.2202 77.8029 76.3269C77.648 76.4337 77.5275 76.5955 77.4414 76.8124C77.3553 77.0258 77.3123 77.2978 77.3123 77.6283C77.3123 77.9657 77.3553 78.2377 77.4414 78.4442C77.5309 78.6508 77.6531 78.8006 77.8081 78.8935C77.9664 78.9865 78.1472 79.0329 78.3503 79.0329C78.6429 79.0329 78.9338 78.9882 79.223 78.8987C79.5157 78.8057 79.7928 78.6783 80.0545 78.5165V80.1226C79.8135 80.2809 79.5415 80.4066 79.2385 80.4996C78.9356 80.5925 78.5827 80.639 78.1799 80.639ZM83.8501 74.5815C84.4182 74.5815 84.9087 74.6813 85.3219 74.881C85.735 75.0772 86.0535 75.3733 86.2772 75.7692C86.501 76.1651 86.6129 76.6609 86.6129 77.2565V78.155H83.0032C83.0204 78.4614 83.134 78.7128 83.344 78.909C83.5575 79.1052 83.8708 79.2034 84.2839 79.2034C84.6488 79.2034 84.9828 79.1672 85.2857 79.0949C85.5921 79.0226 85.9071 78.9107 86.2308 78.7592V80.2104C85.9485 80.3584 85.6403 80.4669 85.3064 80.5357C84.9724 80.6046 84.5507 80.639 84.0412 80.639C83.4525 80.639 82.9257 80.534 82.4609 80.324C81.9962 80.114 81.6295 79.7886 81.361 79.348C81.0959 78.9073 80.9633 78.3409 80.9633 77.649C80.9633 76.9466 81.0838 76.37 81.3248 75.919C81.5658 75.4645 81.9032 75.1289 82.337 74.912C82.7708 74.6916 83.2752 74.5815 83.8501 74.5815ZM83.9224 75.9551C83.6848 75.9551 83.4852 76.0309 83.3234 76.1823C83.165 76.3304 83.072 76.5645 83.0445 76.8847H84.7796C84.7762 76.7125 84.7418 76.5559 84.6764 76.4147C84.6109 76.2736 84.5146 76.1617 84.3872 76.0791C84.2632 75.9964 84.1083 75.9551 83.9224 75.9551ZM92.1024 78.7386C92.1024 79.1104 92.0198 79.4392 91.8545 79.7249C91.6892 80.0107 91.4242 80.2345 91.0592 80.3963C90.6977 80.5581 90.2209 80.639 89.6288 80.639C89.2122 80.639 88.8386 80.6166 88.5081 80.5719C88.1811 80.5271 87.8489 80.441 87.5115 80.3136V78.6973C87.8798 78.866 88.2551 78.9882 88.6372 79.0639C89.0194 79.1362 89.3206 79.1724 89.541 79.1724C89.7682 79.1724 89.9334 79.1483 90.0367 79.1001C90.1435 79.0484 90.1968 78.9727 90.1968 78.8729C90.1968 78.7868 90.1607 78.7145 90.0884 78.656C90.0195 78.594 89.8939 78.5234 89.7114 78.4442C89.5324 78.365 89.2793 78.2583 88.9523 78.1241C88.6286 77.9898 88.3584 77.8435 88.1415 77.6851C87.928 77.5267 87.768 77.3374 87.6612 77.1171C87.5545 76.8967 87.5011 76.6265 87.5011 76.3063C87.5011 75.7348 87.7215 75.3044 88.1621 75.0152C88.6028 74.7261 89.1864 74.5815 89.9128 74.5815C90.2984 74.5815 90.6616 74.6245 91.0024 74.7106C91.3433 74.7932 91.6961 74.9154 92.0611 75.0772L91.5085 76.3786C91.2193 76.2478 90.9267 76.1428 90.6306 76.0636C90.3345 75.9844 90.0987 75.9448 89.9231 75.9448C89.7647 75.9448 89.6425 75.9654 89.5565 76.0068C89.4704 76.0481 89.4274 76.1083 89.4274 76.1875C89.4274 76.2598 89.4566 76.3235 89.5151 76.3786C89.5771 76.4337 89.6925 76.4974 89.8611 76.5697C90.0298 76.642 90.276 76.7435 90.5996 76.8743C90.9404 77.012 91.221 77.1601 91.4414 77.3185C91.6651 77.4734 91.8304 77.6627 91.9371 77.8865C92.0473 78.1103 92.1024 78.3943 92.1024 78.7386ZM97.5764 78.7386C97.5764 79.1104 97.4937 79.4392 97.3285 79.7249C97.1632 80.0107 96.8981 80.2345 96.5332 80.3963C96.1717 80.5581 95.6949 80.639 95.1027 80.639C94.6862 80.639 94.3126 80.6166 93.9821 80.5719C93.6551 80.5271 93.3228 80.441 92.9854 80.3136V78.6973C93.3538 78.866 93.7291 78.9882 94.1112 79.0639C94.4934 79.1362 94.7946 79.1724 95.0149 79.1724C95.2422 79.1724 95.4074 79.1483 95.5107 79.1001C95.6174 79.0484 95.6708 78.9727 95.6708 78.8729C95.6708 78.7868 95.6346 78.7145 95.5623 78.656C95.4935 78.594 95.3678 78.5234 95.1854 78.4442C95.0063 78.365 94.7533 78.2583 94.4262 78.1241C94.1026 77.9898 93.8324 77.8435 93.6155 77.6851C93.402 77.5267 93.2419 77.3374 93.1352 77.1171C93.0285 76.8967 92.9751 76.6265 92.9751 76.3063C92.9751 75.7348 93.1955 75.3044 93.6361 75.0152C94.0768 74.7261 94.6603 74.5815 95.3868 74.5815C95.7724 74.5815 96.1356 74.6245 96.4764 74.7106C96.8172 74.7932 97.1701 74.9154 97.535 75.0772L96.9825 76.3786C96.6933 76.2478 96.4007 76.1428 96.1046 76.0636C95.8085 75.9844 95.5727 75.9448 95.3971 75.9448C95.2387 75.9448 95.1165 75.9654 95.0304 76.0068C94.9444 76.0481 94.9013 76.1083 94.9013 76.1875C94.9013 76.2598 94.9306 76.3235 94.9891 76.3786C95.0511 76.4337 95.1664 76.4974 95.3351 76.5697C95.5038 76.642 95.75 76.7435 96.0736 76.8743C96.4144 77.012 96.695 77.1601 96.9154 77.3185C97.1391 77.4734 97.3044 77.6627 97.4111 77.8865C97.5213 78.1103 97.5764 78.3943 97.5764 78.7386ZM100.396 77.871H98.6918L98.4284 72.9857H100.659L100.396 77.871ZM98.4491 79.6785C98.4491 79.3135 98.5558 79.057 98.7693 78.909C98.9862 78.761 99.2427 78.6869 99.5387 78.6869C99.8314 78.6869 100.083 78.761 100.293 78.909C100.503 79.057 100.608 79.3135 100.608 79.6785C100.608 80.0262 100.503 80.2775 100.293 80.4324C100.083 80.5873 99.8314 80.6648 99.5387 80.6648C99.2427 80.6648 98.9862 80.5873 98.7693 80.4324C98.5558 80.2775 98.4491 80.0262 98.4491 79.6785Z" fill="black"/>
                            <path d="M56.5596 92.1797V87.8965H57.0577V91.7344H58.959V92.1797H56.5596ZM62.3897 90.5684C62.3897 90.8321 62.3555 91.0674 62.2872 91.2745C62.2188 91.4815 62.1202 91.6563 61.9913 91.7989C61.8624 91.9415 61.7061 92.0508 61.5225 92.127C61.3409 92.2012 61.1348 92.2383 60.9044 92.2383C60.6895 92.2383 60.4922 92.2012 60.3126 92.127C60.1348 92.0508 59.9805 91.9415 59.8497 91.7989C59.7208 91.6563 59.6202 91.4815 59.5479 91.2745C59.4776 91.0674 59.4424 90.8321 59.4424 90.5684C59.4424 90.2169 59.502 89.918 59.6212 89.6719C59.7403 89.4239 59.9102 89.2354 60.1309 89.1065C60.3536 88.9756 60.6182 88.9102 60.9249 88.9102C61.2178 88.9102 61.4737 88.9756 61.6924 89.1065C61.9131 89.2374 62.084 89.4268 62.2051 89.6749C62.3282 89.921 62.3897 90.2188 62.3897 90.5684ZM59.9463 90.5684C59.9463 90.8262 59.9805 91.0499 60.0489 91.2393C60.1172 91.4288 60.2227 91.5753 60.3653 91.6788C60.5079 91.7823 60.6915 91.834 60.9161 91.834C61.1387 91.834 61.3213 91.7823 61.4639 91.6788C61.6085 91.5753 61.7149 91.4288 61.7833 91.2393C61.8516 91.0499 61.8858 90.8262 61.8858 90.5684C61.8858 90.3126 61.8516 90.0919 61.7833 89.9063C61.7149 89.7188 61.6094 89.5743 61.4669 89.4727C61.3243 89.3712 61.1397 89.3204 60.9131 89.3204C60.5792 89.3204 60.334 89.4307 60.1778 89.6514C60.0235 89.8721 59.9463 90.1778 59.9463 90.5684ZM64.127 93.6212C63.7051 93.6212 63.3799 93.5421 63.1514 93.3839C62.9229 93.2276 62.8087 93.0079 62.8087 92.7247C62.8087 92.5235 62.8721 92.3516 62.9991 92.209C63.128 92.0665 63.3057 91.9717 63.5323 91.9249C63.4483 91.8858 63.376 91.8272 63.3155 91.7491C63.2569 91.671 63.2276 91.5811 63.2276 91.4796C63.2276 91.3624 63.2598 91.2598 63.3243 91.1719C63.3907 91.0821 63.4913 90.9962 63.626 90.9141C63.4581 90.8458 63.3213 90.7305 63.2159 90.5684C63.1124 90.4044 63.0606 90.2139 63.0606 89.9971C63.0606 89.7667 63.1085 89.5704 63.2042 89.4083C63.2999 89.2442 63.4385 89.1192 63.6202 89.0333C63.8018 88.9473 64.0215 88.9044 64.2794 88.9044C64.336 88.9044 64.3926 88.9073 64.4493 88.9131C64.5079 88.9171 64.5635 88.9239 64.6163 88.9337C64.669 88.9415 64.7149 88.9512 64.754 88.963H65.8555V89.2764L65.2637 89.3497C65.3223 89.4258 65.3712 89.5176 65.4102 89.6251C65.4493 89.7325 65.4688 89.8516 65.4688 89.9825C65.4688 90.3028 65.3604 90.5577 65.1436 90.7471C64.9268 90.9346 64.629 91.0284 64.2501 91.0284C64.1602 91.0284 64.0684 91.0206 63.9747 91.0049C63.879 91.0577 63.8057 91.1163 63.7549 91.1807C63.7061 91.2452 63.6817 91.3194 63.6817 91.4034C63.6817 91.4659 63.7003 91.5157 63.7374 91.5528C63.7764 91.5899 63.8321 91.6172 63.9044 91.6348C63.9766 91.6505 64.0635 91.6583 64.1651 91.6583H64.7305C65.0801 91.6583 65.3477 91.7315 65.5333 91.878C65.7208 92.0245 65.8145 92.2383 65.8145 92.5196C65.8145 92.8751 65.67 93.1475 65.3809 93.337C65.0919 93.5264 64.6739 93.6212 64.127 93.6212ZM64.1417 93.2403C64.4073 93.2403 64.627 93.213 64.8008 93.1583C64.9766 93.1055 65.1075 93.0284 65.1934 92.9268C65.2813 92.8272 65.3253 92.7081 65.3253 92.5694C65.3253 92.4405 65.296 92.3428 65.2374 92.2764C65.1788 92.212 65.0928 92.169 64.9795 92.1475C64.8663 92.1241 64.7276 92.1124 64.5635 92.1124H64.0069C63.8624 92.1124 63.7364 92.1348 63.629 92.1797C63.5215 92.2247 63.4385 92.2911 63.3799 92.379C63.3233 92.4669 63.295 92.5762 63.295 92.7071C63.295 92.8809 63.3682 93.0128 63.5147 93.1026C63.6612 93.1944 63.8702 93.2403 64.1417 93.2403ZM64.2676 90.6739C64.5001 90.6739 64.6749 90.6153 64.792 90.4981C64.9092 90.3809 64.9678 90.21 64.9678 89.9854C64.9678 89.7452 64.9083 89.5655 64.7891 89.4464C64.67 89.3253 64.4942 89.2647 64.2618 89.2647C64.0391 89.2647 63.8672 89.3272 63.7462 89.4522C63.627 89.5753 63.5674 89.7559 63.5674 89.9942C63.5674 90.213 63.628 90.3809 63.7491 90.4981C63.8702 90.6153 64.043 90.6739 64.2676 90.6739ZM67.3848 93.6212C66.9629 93.6212 66.6378 93.5421 66.4092 93.3839C66.1807 93.2276 66.0665 93.0079 66.0665 92.7247C66.0665 92.5235 66.1299 92.3516 66.2569 92.209C66.3858 92.0665 66.5635 91.9717 66.7901 91.9249C66.7061 91.8858 66.6338 91.8272 66.5733 91.7491C66.5147 91.671 66.4854 91.5811 66.4854 91.4796C66.4854 91.3624 66.5176 91.2598 66.5821 91.1719C66.6485 91.0821 66.7491 90.9962 66.8838 90.9141C66.7159 90.8458 66.5792 90.7305 66.4737 90.5684C66.3702 90.4044 66.3184 90.2139 66.3184 89.9971C66.3184 89.7667 66.3663 89.5704 66.462 89.4083C66.5577 89.2442 66.6963 89.1192 66.878 89.0333C67.0596 88.9473 67.2794 88.9044 67.5372 88.9044C67.5938 88.9044 67.6504 88.9073 67.7071 88.9131C67.7657 88.9171 67.8213 88.9239 67.8741 88.9337C67.9268 88.9415 67.9727 88.9512 68.0118 88.963H69.1133V89.2764L68.5215 89.3497C68.5801 89.4258 68.629 89.5176 68.668 89.6251C68.7071 89.7325 68.7266 89.8516 68.7266 89.9825C68.7266 90.3028 68.6182 90.5577 68.4014 90.7471C68.1846 90.9346 67.8868 91.0284 67.5079 91.0284C67.418 91.0284 67.3262 91.0206 67.2325 91.0049C67.1368 91.0577 67.0635 91.1163 67.0128 91.1807C66.9639 91.2452 66.9395 91.3194 66.9395 91.4034C66.9395 91.4659 66.9581 91.5157 66.9952 91.5528C67.0342 91.5899 67.0899 91.6172 67.1622 91.6348C67.2344 91.6505 67.3213 91.6583 67.4229 91.6583H67.9883C68.3379 91.6583 68.6055 91.7315 68.7911 91.878C68.9786 92.0245 69.0723 92.2383 69.0723 92.5196C69.0723 92.8751 68.9278 93.1475 68.6387 93.337C68.3497 93.5264 67.9317 93.6212 67.3848 93.6212ZM67.3995 93.2403C67.6651 93.2403 67.8848 93.213 68.0587 93.1583C68.2344 93.1055 68.3653 93.0284 68.4512 92.9268C68.5391 92.8272 68.5831 92.7081 68.5831 92.5694C68.5831 92.4405 68.5538 92.3428 68.4952 92.2764C68.4366 92.212 68.3506 92.169 68.2374 92.1475C68.1241 92.1241 67.9854 92.1124 67.8213 92.1124H67.2647C67.1202 92.1124 66.9942 92.1348 66.8868 92.1797C66.7794 92.2247 66.6963 92.2911 66.6378 92.379C66.5811 92.4669 66.5528 92.5762 66.5528 92.7071C66.5528 92.8809 66.626 93.0128 66.7725 93.1026C66.919 93.1944 67.128 93.2403 67.3995 93.2403ZM67.5254 90.6739C67.7579 90.6739 67.9327 90.6153 68.0499 90.4981C68.167 90.3809 68.2256 90.21 68.2256 89.9854C68.2256 89.7452 68.1661 89.5655 68.0469 89.4464C67.9278 89.3253 67.752 89.2647 67.5196 89.2647C67.2969 89.2647 67.1251 89.3272 67.004 89.4522C66.8848 89.5753 66.8253 89.7559 66.8253 89.9942C66.8253 90.213 66.8858 90.3809 67.0069 90.4981C67.128 90.6153 67.3008 90.6739 67.5254 90.6739ZM70.2325 88.9688V92.1797H69.7462V88.9688H70.2325ZM69.9952 87.7676C70.0753 87.7676 70.1436 87.794 70.2003 87.8467C70.2588 87.8975 70.2881 87.9776 70.2881 88.087C70.2881 88.1944 70.2588 88.2745 70.2003 88.3272C70.1436 88.3799 70.0753 88.4063 69.9952 88.4063C69.9112 88.4063 69.8409 88.3799 69.7842 88.3272C69.7295 88.2745 69.7022 88.1944 69.7022 88.087C69.7022 87.9776 69.7295 87.8975 69.7842 87.8467C69.8409 87.794 69.9112 87.7676 69.9952 87.7676ZM72.7842 88.9102C73.1651 88.9102 73.4532 89.004 73.6485 89.1915C73.8438 89.377 73.9415 89.6758 73.9415 90.088V92.1797H73.461V90.1202C73.461 89.8526 73.3995 89.6524 73.2764 89.5196C73.1553 89.3868 72.9688 89.3204 72.7169 89.3204C72.3614 89.3204 72.1114 89.421 71.9669 89.6221C71.8223 89.8233 71.7501 90.1153 71.7501 90.4981V92.1797H71.2637V88.9688H71.6563L71.7295 89.4317H71.7559C71.8243 89.3184 71.9112 89.2237 72.0167 89.1475C72.1221 89.0694 72.2403 89.0108 72.3712 88.9717C72.502 88.9307 72.6397 88.9102 72.7842 88.9102ZM75.8399 93.6212C75.418 93.6212 75.0928 93.5421 74.8643 93.3839C74.6358 93.2276 74.5215 93.0079 74.5215 92.7247C74.5215 92.5235 74.585 92.3516 74.712 92.209C74.8409 92.0665 75.0186 91.9717 75.2452 91.9249C75.1612 91.8858 75.0889 91.8272 75.0284 91.7491C74.9698 91.671 74.9405 91.5811 74.9405 91.4796C74.9405 91.3624 74.9727 91.2598 75.0372 91.1719C75.1036 91.0821 75.2042 90.9962 75.3389 90.9141C75.171 90.8458 75.0342 90.7305 74.9288 90.5684C74.8253 90.4044 74.7735 90.2139 74.7735 89.9971C74.7735 89.7667 74.8213 89.5704 74.917 89.4083C75.0128 89.2442 75.1514 89.1192 75.3331 89.0333C75.5147 88.9473 75.7344 88.9044 75.9922 88.9044C76.0489 88.9044 76.1055 88.9073 76.1622 88.9131C76.2208 88.9171 76.2764 88.9239 76.3292 88.9337C76.3819 88.9415 76.4278 88.9512 76.4669 88.963H77.5684V89.2764L76.9766 89.3497C77.0352 89.4258 77.084 89.5176 77.1231 89.6251C77.1622 89.7325 77.1817 89.8516 77.1817 89.9825C77.1817 90.3028 77.0733 90.5577 76.8565 90.7471C76.6397 90.9346 76.3419 91.0284 75.9629 91.0284C75.8731 91.0284 75.7813 91.0206 75.6876 91.0049C75.5919 91.0577 75.5186 91.1163 75.4678 91.1807C75.419 91.2452 75.3946 91.3194 75.3946 91.4034C75.3946 91.4659 75.4131 91.5157 75.4503 91.5528C75.4893 91.5899 75.545 91.6172 75.6172 91.6348C75.6895 91.6505 75.7764 91.6583 75.878 91.6583H76.4434C76.793 91.6583 77.0606 91.7315 77.2462 91.878C77.4337 92.0245 77.5274 92.2383 77.5274 92.5196C77.5274 92.8751 77.3829 93.1475 77.0938 93.337C76.8047 93.5264 76.3868 93.6212 75.8399 93.6212ZM75.8545 93.2403C76.1202 93.2403 76.3399 93.213 76.5137 93.1583C76.6895 93.1055 76.8204 93.0284 76.9063 92.9268C76.9942 92.8272 77.0381 92.7081 77.0381 92.5694C77.0381 92.4405 77.0088 92.3428 76.9503 92.2764C76.8917 92.212 76.8057 92.169 76.6924 92.1475C76.5792 92.1241 76.4405 92.1124 76.2764 92.1124H75.7198C75.5753 92.1124 75.4493 92.1348 75.3419 92.1797C75.2344 92.2247 75.1514 92.2911 75.0928 92.379C75.0362 92.4669 75.0079 92.5762 75.0079 92.7071C75.0079 92.8809 75.0811 93.0128 75.2276 93.1026C75.3741 93.1944 75.5831 93.2403 75.8545 93.2403ZM75.9805 90.6739C76.2129 90.6739 76.3878 90.6153 76.5049 90.4981C76.6221 90.3809 76.6807 90.21 76.6807 89.9854C76.6807 89.7452 76.6212 89.5655 76.502 89.4464C76.3829 89.3253 76.2071 89.2647 75.9747 89.2647C75.752 89.2647 75.5801 89.3272 75.459 89.4522C75.3399 89.5753 75.2803 89.7559 75.2803 89.9942C75.2803 90.213 75.3409 90.3809 75.462 90.4981C75.5831 90.6153 75.7559 90.6739 75.9805 90.6739ZM79.253 88.9688H79.7745L80.4835 90.8321C80.5245 90.9415 80.5626 91.0469 80.5977 91.1485C80.6329 91.2481 80.6641 91.3438 80.6915 91.4356C80.7188 91.5274 80.7403 91.6163 80.7559 91.7022H80.7764C80.8038 91.6046 80.8428 91.4766 80.8936 91.3184C80.9444 91.1583 80.9991 90.9952 81.0577 90.8292L81.7286 88.9688H82.253L80.8555 92.6514C80.7813 92.8487 80.6944 93.0206 80.5948 93.1671C80.4971 93.3135 80.378 93.4258 80.2374 93.504C80.0967 93.584 79.9268 93.6241 79.7276 93.6241C79.6358 93.6241 79.5547 93.6182 79.4844 93.6065C79.4141 93.5967 79.3536 93.585 79.3028 93.5714V93.1817C79.3458 93.1915 79.3975 93.2003 79.4581 93.2081C79.5206 93.2159 79.585 93.2198 79.6514 93.2198C79.7725 93.2198 79.877 93.1964 79.9649 93.1495C80.0547 93.1046 80.1319 93.0381 80.1963 92.9503C80.2608 92.8624 80.3165 92.7579 80.3633 92.6368L80.5391 92.1856L79.253 88.9688ZM85.5342 90.5684C85.5342 90.8321 85.5001 91.0674 85.4317 91.2745C85.3633 91.4815 85.2647 91.6563 85.1358 91.7989C85.0069 91.9415 84.8506 92.0508 84.667 92.127C84.4854 92.2012 84.2794 92.2383 84.0489 92.2383C83.834 92.2383 83.6368 92.2012 83.4571 92.127C83.2794 92.0508 83.1251 91.9415 82.9942 91.7989C82.8653 91.6563 82.7647 91.4815 82.6924 91.2745C82.6221 91.0674 82.587 90.8321 82.587 90.5684C82.587 90.2169 82.6465 89.918 82.7657 89.6719C82.8848 89.4239 83.0547 89.2354 83.2754 89.1065C83.4981 88.9756 83.7628 88.9102 84.0694 88.9102C84.3624 88.9102 84.6182 88.9756 84.837 89.1065C85.0577 89.2374 85.2286 89.4268 85.3497 89.6749C85.4727 89.921 85.5342 90.2188 85.5342 90.5684ZM83.0909 90.5684C83.0909 90.8262 83.1251 91.0499 83.1934 91.2393C83.2618 91.4288 83.3672 91.5753 83.5098 91.6788C83.6524 91.7823 83.836 91.834 84.0606 91.834C84.2833 91.834 84.4659 91.7823 84.6085 91.6788C84.753 91.5753 84.8594 91.4288 84.9278 91.2393C84.9962 91.0499 85.0303 90.8262 85.0303 90.5684C85.0303 90.3126 84.9962 90.0919 84.9278 89.9063C84.8594 89.7188 84.754 89.5743 84.6114 89.4727C84.4688 89.3712 84.2842 89.3204 84.0577 89.3204C83.7237 89.3204 83.4786 89.4307 83.3223 89.6514C83.168 89.8721 83.0909 90.1778 83.0909 90.5684ZM89.0264 88.9688V92.1797H88.628L88.5577 91.7286H88.5313C88.4649 91.8399 88.379 91.9337 88.2735 92.0098C88.168 92.086 88.0489 92.1426 87.9161 92.1797C87.7852 92.2188 87.6456 92.2383 87.4971 92.2383C87.2432 92.2383 87.0303 92.1973 86.8585 92.1153C86.6866 92.0333 86.5567 91.9063 86.4688 91.7344C86.3829 91.5626 86.3399 91.3419 86.3399 91.0723V88.9688H86.8321V91.0372C86.8321 91.3047 86.8926 91.5049 87.0137 91.6378C87.1348 91.7686 87.3194 91.834 87.5674 91.834C87.8057 91.834 87.9952 91.7891 88.1358 91.6993C88.2784 91.6094 88.3809 91.4776 88.4434 91.3038C88.5059 91.128 88.5372 90.9131 88.5372 90.6592V88.9688H89.0264ZM92.0997 88.9688V92.1797H91.6133V88.9688H92.0997ZM91.8624 87.7676C91.9424 87.7676 92.0108 87.794 92.0674 87.8467C92.126 87.8975 92.1553 87.9776 92.1553 88.087C92.1553 88.1944 92.126 88.2745 92.0674 88.3272C92.0108 88.3799 91.9424 88.4063 91.8624 88.4063C91.7784 88.4063 91.7081 88.3799 91.6514 88.3272C91.5967 88.2745 91.5694 88.1944 91.5694 88.087C91.5694 87.9776 91.5967 87.8975 91.6514 87.8467C91.7081 87.794 91.7784 87.7676 91.8624 87.7676ZM94.6514 88.9102C95.0323 88.9102 95.3204 89.004 95.5157 89.1915C95.711 89.377 95.8087 89.6758 95.8087 90.088V92.1797H95.3282V90.1202C95.3282 89.8526 95.2667 89.6524 95.1436 89.5196C95.0225 89.3868 94.836 89.3204 94.584 89.3204C94.2286 89.3204 93.9786 89.421 93.834 89.6221C93.6895 89.8233 93.6172 90.1153 93.6172 90.4981V92.1797H93.1309V88.9688H93.5235L93.5967 89.4317H93.6231C93.6915 89.3184 93.7784 89.2237 93.8838 89.1475C93.9893 89.0694 94.1075 89.0108 94.2383 88.9717C94.3692 88.9307 94.5069 88.9102 94.6514 88.9102ZM96.7374 91.8751C96.7374 91.7383 96.7706 91.6417 96.837 91.585C96.9034 91.5264 96.9844 91.4971 97.0801 91.4971C97.1797 91.4971 97.2637 91.5264 97.3321 91.585C97.4004 91.6417 97.4346 91.7383 97.4346 91.8751C97.4346 92.0098 97.4004 92.1085 97.3321 92.171C97.2637 92.2315 97.1797 92.2618 97.0801 92.2618C96.9844 92.2618 96.9034 92.2315 96.837 92.171C96.7706 92.1085 96.7374 92.0098 96.7374 91.8751ZM98.3135 91.8751C98.3135 91.7383 98.3467 91.6417 98.4131 91.585C98.4795 91.5264 98.5606 91.4971 98.6563 91.4971C98.7559 91.4971 98.8399 91.5264 98.9083 91.585C98.9766 91.6417 99.0108 91.7383 99.0108 91.8751C99.0108 92.0098 98.9766 92.1085 98.9083 92.171C98.8399 92.2315 98.7559 92.2618 98.6563 92.2618C98.5606 92.2618 98.4795 92.2315 98.4131 92.171C98.3467 92.1085 98.3135 92.0098 98.3135 91.8751ZM99.8897 91.8751C99.8897 91.7383 99.9229 91.6417 99.9893 91.585C100.056 91.5264 100.137 91.4971 100.232 91.4971C100.332 91.4971 100.416 91.5264 100.484 91.585C100.553 91.6417 100.587 91.7383 100.587 91.8751C100.587 92.0098 100.553 92.1085 100.484 92.171C100.416 92.2315 100.332 92.2618 100.232 92.2618C100.137 92.2618 100.056 92.2315 99.9893 92.171C99.9229 92.1085 99.8897 92.0098 99.8897 91.8751Z" fill="black"/>
                            <circle cx="78.5001" cy="136.573" r="17.9085" fill="#7FBD5D" stroke="#7FBD5D" stroke-width="1.37757"/>
                            <path d="M85.2015 131.547L75.9867 140.762L71.7981 136.573" stroke="white" stroke-width="2.30721" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M16.5 35.305C16.5 32.0195 19.1635 29.356 22.4491 29.356H134.551C137.837 29.356 140.5 32.0195 140.5 35.305C140.5 34.94 139.02 34.644 137.195 34.644H19.805C17.9797 34.644 16.5 34.94 16.5 35.305ZM140.5 208H16.5H140.5ZM16.5 208V32V208ZM140.5 32V208V32Z" fill="#2F67DD" mask="url(#path-1-inside-1_280_143490)"/>
                        </g>
                        <defs>
                            <filter id="filter0_d_280_143490" x="13.856" y="32" width="129.288" height="181.288" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                <feOffset dy="2.64404"/>
                                <feGaussianBlur stdDeviation="1.32202"/>
                                <feComposite in2="hardAlpha" operator="out"/>
                                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_280_143490"/>
                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_280_143490" result="shape"/>
                            </filter>
                        </defs>
                    </svg>
                    <p><?= __('Follow the procedure to login.'); ?></p>
                </div>
            </div>
            <?= $this->Form->create($setupForm, $formContext); ?>
                <div class="actions-wrapper">
                    <!-- Note: Router is not used there to allow the parent frame navigation -->
                    <a href="app/settings/mfa" target="_top" rel="noopener noreferrer" class="button cancel"><?= __('Cancel'); ?></a>
                    <button type="submit" class="button primary"><?= __('Get started'); ?></button>
                </div>
            <?= $this->Form->end(); ?>
        </div>
        <div class="col4 last">
            <div class="sidebar-help">
                <h3><?= __('Requirements') ?></h3>
                <p>
                    <?= __('To proceed, you need to install the Duo mobile application or to have a device to authenticate which is supported by Duo.'); ?> <?= __('For the list of supported devices, see:'); ?>
                    <a href="https://duo.com/product/multi-factor-authentication-mfa/authentication-methods" target="_blank" rel="noopener noreferrer"><?= __('Duo authentication methods'); ?></a>.
                </p>
                <a href="https://help.passbolt.com/configure/mfa/duo.html" target="_blank" rel="noopener noreferrer" class="button"><?= __('Learn more'); ?></a>
            </div>
        </div>
    </div>
</div>
