<?php
declare(strict_types=1);

/**
 * Passbolt ~ Open source password manager for teams
 * Copyright (c) Passbolt SA (https://www.passbolt.com)
 *
 * Licensed under GNU Affero General Public License version 3 of the or any later version.
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Passbolt SA (https://www.passbolt.com)
 * @license       https://opensource.org/licenses/AGPL-3.0 AGPL License
 * @link          https://www.passbolt.com Passbolt(tm)
 * @since         3.10.0
 */

namespace Passbolt\MultiFactorAuthentication\Service\MfaPolicies;

class DefaultRememberAMonthSettingService implements RememberAMonthSettingInterface
{
    /**
     * {@inheritDoc}
     *
     * **Note:** This method will always return `true` since this is the current default behavior. When MfaPolicies
     *           plugin is enabled this service will be overridden by another service which actually does the check.
     */
    public function isEnabled(): bool
    {
        return true;
    }
}
