<?php
declare(strict_types=1);

/**
 * Passbolt ~ Open source password manager for teams
 * Copyright (c) Passbolt SA (https://www.passbolt.com)
 *
 * Licensed under GNU Affero General Public License version 3 of the or any later version.
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Passbolt SA (https://www.passbolt.com)
 * @license       https://opensource.org/licenses/AGPL-3.0 AGPL License
 * @link          https://www.passbolt.com Passbolt(tm)
 * @since         3.2.0
 */

namespace Passbolt\Folders\Test\TestCase\Model\Table\FoldersHistory;

use App\Error\Exception\ValidationException;
use App\Utility\UuidFactory;
use Cake\ORM\Locator\LocatorAwareTrait;
use Cake\TestSuite\TestCase;
use Passbolt\Folders\Model\Entity\Folder;
use Passbolt\Folders\Model\Entity\FolderHistory;

/**
 * @covers \Passbolt\Folders\Model\Table\FoldersHistoryTable
 */
class FoldersHistoryTableTest extends TestCase
{
    use LocatorAwareTrait;

    /**
     * @var \Passbolt\Folders\Model\Table\FoldersHistoryTable
     */
    protected $FoldersHistory;

    /**
     * setUp method
     *
     * @return void
     */
    public function setUp(): void
    {
        parent::setUp();
        $this->FoldersHistory = $this->fetchTable('Passbolt/Folders.FoldersHistory');
    }

    /**
     * tearDown method
     *
     * @return void
     */
    public function tearDown(): void
    {
        unset($this->FoldersHistory);

        parent::tearDown();
    }

    /**
     * Ensure that the entity generated by the FoldersHistoryTable
     * is a FolderHistory. This is important since FoldersHistoryTable
     * does not follow CakePHP naming convention.
     */
    public function testCreateFoldersHistory(): void
    {
        $data = [
            'id' => UuidFactory::uuid(),
            'name' => str_repeat('1', Folder::MAX_NAME_LENGTH),
        ];

        $entity = $this->FoldersHistory->create($data);
        $this->assertInstanceOf(FolderHistory::class, $entity);
    }

    public function testCreateFoldersHistory_Name_Too_long(): void
    {
        $data = [
            'id' => UuidFactory::uuid(),
            'name' => str_repeat('1', Folder::MAX_NAME_LENGTH + 1),
        ];

        $this->expectException(ValidationException::class);
        $this->expectExceptionMessage('Could not validate folder history data.');
        $entity = $this->FoldersHistory->create($data);
    }
}
