# Local Development

Welcome to the local development environment for the Generative AI Containers course!

This folder contains everything you need to set up and test your generative AI projects locally using Docker containers. In 01_containers you'll find resources for:

* Running containerized applications:

    * 00_helloworld_ops: Scripts and configuration files for setting up and managing your **local Docker environment**.

    * 01_helloworld_dev_python: **Python code** and **dependencies** for the basic **"Hello, World!"** containerized application.

    * 02_dockerfile: **Instructions** for building container image.

    * 03_push: Scripts for pushing your container image to a **registry** (optional).

* Working with advanced features:

    * 04_pydantic: Code and examples for using **Pydantic** for data validation and schema definition.

    * 05_volume_mounts: Techniques and examples for persisting data outside containers using **volume mounts**.

    * 06_yaml: Configuration files and samples in **YAML** format for various tools and services.

    * 07_docker_compose: **Multi-container configurations** for running complex applications with dependencies.

    * 08_postgres: Tutorials and resources for working with a local **PostgreSQL database** in your containers.

    * 09_flask_with_postgres: Example code for building a Flask web application with a PostgreSQL database backend.

    * 10_todo_api: A more advanced project template showcasing a **RESTful API** built with **Flask** and **SQLAlchemy**.

* Deploying streamlit applications (optional):

    * xx_deploy_streamlit: Resources and instructions for deploying **Streamlit applications** using Docker and various cloud platforms.

### Getting started:

* Refer to the individual folder READMEs for specific setup and usage instructions.

    * Start with the **00_helloworld_ops** folder to configure your local Docker environment.

    * Follow the **01_helloworld_dev_python** and **02_dockerfile folders** to build and run the basic "Hello, World!" container.

    * Explore the other folders progressively as you learn more advanced concepts.

* Remember:

    * This folder is for local development only. Deployment instructions are located in the **03_deploy_cloud** folder.

    * Feel free to experiment and personalize this environment to suit your needs.

    * Refer to the course materials and documentation for detailed explanations of each technique.

    * We hope this guide helps you get started with your generative AI projects using container! Enjoy the journey!