# AI Agents

In the context of recent advancements in generative AI, AI agents are evolving rapidly, taking on new roles and capabilities. 

## Letters from Andrew Ng: Design Patterns for AI agentic workflows

[AI Pioneer Shows The Power of AI AGENTS - "The Future Is Agentic"](https://www.youtube.com/watch?v=ZYf9V2fSFwU)

[Agentic Design Patterns Part 1](https://www.deeplearning.ai/the-batch/how-agents-can-improve-llm-performance/)

[Agentic Design Patterns Part 2, Reflection](https://www.deeplearning.ai/the-batch/agentic-design-patterns-part-2-reflection/?ref=dl-staging-website.ghost.io)

[Agentic Design Patterns Part 3, Tool Use](https://www.deeplearning.ai/the-batch/agentic-design-patterns-part-3-tool-use/)

[Agentic Design Patterns Part 4, Planning](https://www.deeplearning.ai/the-batch/agentic-design-patterns-part-4-planning/)

[Agentic Design Patterns Part 5, Multi-Agent Collaboration](https://www.deeplearning.ai/the-batch/agentic-design-patterns-part-5-multi-agent-collaboration/)

## Review of Frameworks

[AI Agents EXPLAINED: Unbiased Review of Langraph, AutoGen, and Crew AI Frameworks](https://www.youtube.com/watch?v=NjOj5mkytvw)

[LangGraph: Multi-Agent Workflows](https://blog.langchain.dev/langgraph-multi-agent-workflows/)



Here's a breakdown of what they are and how they're changing:

**Traditional AI Agents:**

* **Autonomous entities:** Capable of making decisions and acting independently within defined parameters.
* **Task-oriented:** Focused on specific goals, like playing games, controlling robots, or managing resources.
* **Limited reasoning:** Often rely on pre-programmed rules or reinforcement learning to achieve goals.

**Generative AI Agents:**

* **Hybrid capabilities:** Combine traditional task-oriented skills with the ability to generate novel content, translate languages, and adapt to new situations.
* **Enhanced creativity and flexibility:** Can generate text, code, images, and other forms of creative content, often surpassing human capabilities in specific domains.
* **Improved learning and adaptation:** Can learn from large datasets and adapt their behavior based on new information and feedback.

**New Roles and Applications:**

* **Personalized Assistants:** Generate personalized recommendations, create custom content, and adapt to individual user preferences.
* **Creative Collaborators:** Assist humans in creative tasks like writing, composing music, or designing products.
* **Explainable AI:** Help humans understand the reasoning behind AI decisions and improve transparency.
* **Generative Simulations:** Create realistic virtual environments for training other AI agents or testing scenarios.

**Challenges and Considerations:**

* **Bias and Fairness:** Ensure AI agents are trained on diverse data and mitigate potential biases in their outputs.
* **Explainability and Trust:** Develop methods for understanding how AI agents arrive at decisions and build trust with users.
* **Ethical Implications:** Consider the ethical implications of powerful generative AI, especially in areas like misinformation and deepfakes.

**Overall, AI agents are becoming increasingly sophisticated and versatile, fueled by the power of generative AI.** They are transforming how we interact with technology, creating new possibilities for personalization, creativity, and collaboration. As we navigate this exciting landscape, it's crucial to address the challenges and ensure responsible development of these powerful tools.

Here are some additional resources you might find helpful:

* **A Neural Conversational Model with Persona: Chatting as Different People**: [https://arxiv.org/abs/1506.05869](https://arxiv.org/abs/1506.05869)
* **Towards Safe and Explainable Generative AI**: [https://arxiv.org/abs/2302.09270](https://arxiv.org/abs/2302.09270)
* **The Future of Generative AI**: [https://pub.towardsai.net/generative-ai-and-future-c3b1695876f2](https://pub.towardsai.net/generative-ai-and-future-c3b1695876f2)


When we talk about AI agents in the context of generative AI, it can encompass both **autonomous** and **non-autonomous** agents. However, the emphasis often shifts towards **more autonomous capabilities** due to the nature of generative AI.

Here's a breakdown:

**Autonomous AI Agents:**

* Operate independently within defined parameters, making decisions and taking actions without direct human intervention.
* Often used in robotics, game playing, and resource management tasks.

**Non-Autonomous AI Agents:**

* Require some degree of human guidance or interaction to function.
* Can involve personalization assistants, chatbot assistants, and text-based systems requiring user prompts or queries.

**In the context of generative AI:**

* The focus often shifts towards **hybrid agents** that combine traditional task-oriented skills with **some level of autonomy**.
* These agents can handle complex tasks, generate novel content, adapt to new situations, and learn from data, but may still require user input or operate within specific defined boundaries.
* The degree of autonomy varies depending on the specific application and desired level of control.

**For example:**

* A text-based AI agent that generates poems based on user prompts might be considered non-autonomous, requiring input to function.
* However, this same agent could become more autonomous if it could also analyze user preferences and generate diverse poems without further prompts, adapting its style and content based on past interactions.

**Therefore, whether we're talking about autonomous or non-autonomous AI agents depends on the specific context and capabilities involved.** In the realm of generative AI, the trend is towards developing **more autonomous and adaptive agents** with hybrid skillsets, pushing the boundaries of what AI can achieve without sacrificing human control and oversight.





## Reading Material

[OpenAI's Bet on a Cognitive Architecture](https://blog.langchain.dev/openais-bet-on-a-cognitive-architecture/)

[OpenAI takes ‘baby step’ toward AI agents with Assistants API](https://venturebeat.com/ai/openai-takes-baby-step-toward-ai-agents-with-assistants-api/)

[Opportunities in Agents after GPT-4 Turbo](https://www.linkedin.com/pulse/opportunities-agents-after-gpt-4-turbo-wei-min-lu-z63fc/)

[What Are Large Language Model (LLM) Agents and Autonomous Agents](https://promptengineering.org/what-are-large-language-model-llm-agents/)

[Creating AI agents swarms using Assistants API for autonomous automation](https://www.geeky-gadgets.com/creating-ai-agents-swarms-using-assistants-api/)

[OpenAI Assistants API to Build AI Agent SWARMS. Better than AutoGen?](https://www.youtube.com/watch?v=hdHtIdJSWuQ)

[How to Create Agent Swarms With the NEW OpenAI Assistants API](https://www.youtube.com/watch?v=8fMnAZI1bdA)

[AI Agents: When and How To Implement](https://arize.com/blog-course/ai-agents-when-and-how-to-implement-langchain-llamaindex-babyagi/)