# Build an AI Travel Assistant For Global Explorers

You will create the concept of an an AI-powered travel assistant that aids global travelers, combining Generative AI with maps. 

#### Key Concepts To Use:
1. Use OpenAI Assistants API to create the Travel Assistant.
2. Create interactive AI powered map interactions using Plotly and MapBox
3. Leverage parallel function calling to navigate the map and mark travel locations as the assistant share travel suggestions.
4. Use Retrival and code inteprator to analyse uploaded pdfs/receipts and make calculations (e.g: airbnb share)

## Challenge Details

1. **Create an Open AI Travel Assistant**:
   - Use OpenAI Travel Assistant API to create a stateful assistant for planning travel destinations.
   - Implement a system where users can input preferences and receive tailored recommendations.

2. **AI Powered Map Integration**:
   - Use Plotly and MapBox to display interactive maps.
   - Control the map using AI Travel Assistant to navigate places and place markers.

3. **Add Retrival and Code Inteprator**:
   - Upload Files and add them to thread.
   - Use retrival to discuss your trip with code inteprator and code inteprator to make any calculations.



### Development Stages
- **Stage 1**: Setting up the OpenAI Travel Assistant.
- **Stage 2**: Integrating Plotly and MapBox for map functionalities.
- **Stage 3**: Implementing AI-powered interactions with the map.
- **Stage 4**: Reusability: Create Classes to manage files and Assistant Operations.
- **Stage 5**: Use Retrival and Code Inteprator to retrive trip details and make calculations.

## Resources To Get Started
- Watch OpenAI Dev Day Demo Example (33:33)
https://www.youtube.com/watch?v=U9mJuUkhUzk

- Get MapBox Access Token:
https://www.mapbox.com/

## Evaluation Criteria
- **Functionality**: How well does it works?
- **Code Quality**: Is the code well-organized, documented, and efficient?
- **Type Hinting**: Is the code properly typed?
- **Creativity**: How unique and innovative is your solution?


## Conclusion
This challenge will help you apply your skills in a real-world-like scenario, combining Generative AI and geospatial technology. 

Next in Streamlit Sub Step 14, you will develop the frontend for this AI-powered travel assistant. It's your chance to innovate and create a useful tool for travelers. Best of luck, and happy coding!
