## Authorization - 

So far we have learned to build an authentication flow in FastAPI following OAuth2 password flow specification.

Now it's time to learn about authorization. So only an authorized user can access our APIs.

We will be using the code from last step as starter code. Let's start by learning about the special security class provided by FastAPI to handle this.

## OAuth2PasswordBearer - A Special FastAPI Security Class

OAuth2PasswordBearer is a special FastAPI Security Class that will let us authorize our APIs and the OpenAPI Docs(locahost:8000/docs) generated by it as well.

We can import it 
`from fastapi.security import OAuth2PasswordBearer`

## Coding Time

1. Take your code from last step or clone this step code.

2. Import OAuth2PasswordBearer class 

```
from fastapi.security import OAuth2PasswordBearer
```

3. Initial OAuth2PasswordBearer class with login route path

We will create a new variable - let's name it `oauth2_scheme`. It will initialize the OAuth2PasswordRequestForm class and in it we will pass our login endpoint path.

```
oauth2_scheme = OAuth2PasswordBearer(tokenUrl="login")
```

Now we are ready to use it.

4. Authenticate /users/me API route

Remember in last step we created a `users/me` endpoint and it was taking endpoint as query parameter. Now let's add proper authorization to it using the variable we have created in step 3. So our updated code is:

```
@app.get("/users/me")
def read_users_me(token: Annotated[str, Depends(oauth2_scheme)]):
    user_token_data = decode_access_token(token)
    
    user_in_db = fake_users_db.get(user_token_data["sub"])
    
    return user_in_db
```

Now visit the Docs - there are 2 Notable differences

    1. in the Endpoint /users/me:
        - Calling this endpoint returns 401 unauthorized and 
        - I don't have any option to pass token. 
    2. There is a shiny `Authorize` Button and the top left corner. 
        - Clicking on it we see the option to add username and email


5. Try Authorize Button.

Try Authorize button and pass dummy the username and password we declared in last step

```
i.e: 
"username": "ameenalam"
"password": "ameenalamsecret"
```

And viola it shows I am logged In - What's Next???

-> Call the `/users/me` endpoint again and see what happens. On call now I get the user data

Now play with this - pass this same `token: Annotated[str, Depends(oauth2_scheme)]` to any endpoint you want to add authorization to and then try them.

6. How are endpoints Authorized using `token: Annotated[str, Depends(oauth2_scheme)]`?

Passing the above to any endpoint requires us to send token in the header to API. This is a secure way to send secrets when using APIs without exposing them. The format is:

`Bearer {token}` passed in Headers ot APIs.

In our docs we get the complete security mechanism by create the oauth2_scheme variable and special class.

# Further Learning Resources

https://fastapi.tiangolo.com/tutorial/header-params/?h=header

https://fastapi.tiangolo.com/tutorial/security/first-steps/?h=oauth2passwordbearer#fastapis-oauth2passwordbearer

https://github.com/tiangolo/full-stack-fastapi-template/tree/master/backend
