# FastAPI App with PostgresSQL and SQLModel

### Note: Follow our code in fastapi_neon/main.py and tests/test_main.py, not the code in the tutorial link

[Dependency Injection Explained in 7 Minutes](https://www.youtube.com/watch?v=DpMGEhwuuyA)

PostgreSQL has gained significant traction in the recent years in the cloud landscape, we beleave it has almost become the **de facto standard**. Here's a breakdown of the current situation:

**PostgreSQL's Rise in Cloud Popularity:**

* **Open Source and Feature-Rich:** Being open-source and offering a comprehensive feature set with strong community support, PostgreSQL has become a compelling alternative to proprietary cloud database offerings.
* **Cloud Provider Support:** Major cloud providers like Google Cloud Platform (GCP), Amazon Web Services (AWS), and Microsoft Azure all offer managed PostgreSQL services, indicating recognition of its growing demand.
* **Strengths:** PostgreSQL boasts strengths in areas like complex queries, data integrity, and extensibility, making it suitable for various data-intensive applications in the cloud.

**However, there are still strong contenders:**

* **MySQL:** Remains a popular choice, especially for smaller projects and those already invested in the MySQL ecosystem. Its ease of use and familiarity for many developers contribute to its continued adoption.
* **Cloud-Specific Databases:** Cloud providers offer their own proprietary database services, often built on open-source technologies like PostgreSQL or MySQL. These services often integrate tightly with other cloud offerings, providing convenience and potential performance benefits.

## Tutorial

https://neon.tech/blog/deploy-a-serverless-fastapi-app-with-neon-postgres-and-aws-app-runner-at-any-scale

[Review Annotated Details for Inversion of Control](https://stackoverflow.com/questions/71898644/how-to-use-python-typing-annotated)

Note: We will not cover AWS deployment at this stage, ignore it in this tututorial for now.

Code

https://github.com/neondatabase/fastapi-apprunner-neon

Note: We can use it as a template also

Create Project:

    poetry new fastapi-helloworld

Change directory to project:

    cd fastapi-helloworld 

Add dependecies:

    poetry install

Add poetry virtualenv interpreter in VSCode

Write main.py

Create a Neon Database Project and copy the connection string and paste it to .env file (check .env_back sample):

https://neon.tech/docs/guides/python#create-a-neon-project

Create a Neon Database Project Test Branch and copy the connection string and paste it to .env file (check .env_back sample):

https://neon.tech/docs/manage/branches#create-a-branch

Run test:

    poetry run pytest

Run project in Poetry Envirnoment:

    poetry run uvicorn fastapi_neon.main:app --host 0.0.0.0 --port 8000

Open in Browser:

    http://0.0.0.0:8000/

    http://0.0.0.0:8000/docs

    http://0.0.0.0:8000/openapi.json

## Publish on the Web while running locally

Install Ngrok:

https://ngrok.com/docs/getting-started/

Run the following command to add your authtoken to the default ngrok.yml:

    ngrok config add-authtoken 2bZGNZ3Mj3HdRxPt19defOl_7oFHsvr5AmM9A9UZUyhFn

Deploy with your static domain:

    ngrok http --domain=my-static-domain.ngrok-free.app 8000

Open in Browser:

    https://my-static-domain.ngrok-free.app/

Open in Browser:

    https://my-static-domain.ngrok-free.app/

Open Docs in Browser:

    https://my-static-domain.ngrok-free.app/docs

Open OpenAPI specs in Browser:

    https://my-static-domain.ngrok-free.app/openapi.json

Now we will use this json to create GPT Action.

Now create a Custom GPT here:

    https://chat.openai.com/gpts

Add the following server url in the openapi.json file generated by FastAPI and paste it into action schema:

    "servers": [
        {
        "url": "https://my-static-domain.ngrok-free.app/"
        }
    ],

## PostgreSQL for Microservices

PostgreSQL, a popular open-source relational database, is not inherently optimized for microservices, but its features and versatility make it a strong candidate for such architectures. Regarding cloud vendor lock-in, using PostgreSQL and its variants can help mitigate this risk, but the situation varies with different cloud-based offerings like "Serverless Neo Database" and other PostgreSQL-compatible databases developed by cloud providers.

### PostgreSQL for Microservices Development

1. **Scalability**: PostgreSQL handles large volumes of data and concurrent connections efficiently, which is essential for the scalable nature of microservices.

2. **Advanced Features**: It supports advanced features like JSON/JSONB data types, full-text search, and powerful indexing, beneficial for microservices handling complex queries or semi-structured data.

3. **Reliability and ACID Compliance**: Known for its reliability and strict compliance with ACID properties, PostgreSQL ensures robust transaction processing, a critical aspect of many microservices.

4. **Language and Framework Support**: PostgreSQL supports various programming languages and frameworks, aligning well with the diverse technology stacks often used in microservices.

5. **Extension Ecosystem**: Its strong extension ecosystem, including tools like PostGIS, allows customization to meet specific microservices requirements.

6. **Containerization Compatibility**: It can be containerized, aligning with the container-centric approach commonly used in microservices architectures.

### PostgreSQL and Cloud Vendor Lock-in

1. **Open Source and Portability**: PostgreSQL’s open-source nature allows deployment in diverse environments, aiding in avoiding vendor lock-in. You’re not restricted to a specific cloud provider's proprietary database solution.

2. **Availability Across Cloud Providers**: Major cloud providers offer PostgreSQL as a service (e.g., Amazon RDS, Azure Database for PostgreSQL, Google Cloud SQL). This widespread availability supports easier migration across clouds.

3. **Managed Services and Proprietary Features**: While managed services add convenience, they can introduce lock-in due to unique features or optimizations. It's essential to differentiate between standard PostgreSQL features and those specific to a cloud provider's implementation.

4. **Backup and Migration Tools**: PostgreSQL’s ecosystem includes tools for backup and migration, facilitating transitions between different environments.

### PostgreSQL-Compatible Cloud Databases

1. **Serverless Neo Database (and Similar Offerings)**: Cloud providers have developed PostgreSQL-compatible databases with additional features like serverless scaling. These databases often provide seamless scaling, cost-efficiency, and maintenance benefits, aligning well with microservices' dynamic nature.

2. **Compatibility vs. Lock-in**: While these databases are compatible with PostgreSQL, they may include proprietary features or behaviors. Relying heavily on these unique aspects can lead to a form of lock-in, as migrating to another provider or a standard PostgreSQL setup might require significant modifications.

3. **Use-Case Fit**: These cloud-specific databases are often designed with specific use-cases in mind, like handling sporadic traffic patterns or reducing operational overhead, which might be advantageous for certain microservices.

### Conclusion

In essence, PostgreSQL is a capable choice for microservices development due to its features and reliability. Its open-source nature and wide availability across cloud platforms make it conducive to avoiding cloud vendor lock-in, particularly if you adhere to standard PostgreSQL functionalities. However, when considering cloud-specific PostgreSQL-compatible databases, it's important to balance their advanced features and conveniences against the potential for increased vendor dependency, especially with proprietary enhancements or serverless capabilities like those found in "Serverless Neo Database" and similar offerings.
