# AI Essentials

[Google Gemini](https://gemini.google.com/app)

[Gemini for Google Workspace](https://inthecloud.withgoogle.com/gemini-for-google-workspace-prompt-guide/dl-cd.html)

[Google AI Essentials](https://grow.google/ai-essentials/)

## Other LLM Websites

[Microsoft Copilot](https://copilot.microsoft.com/)

[ChatGPT](https://chat.openai.com/)

## Prompt Engineering Explained: Sculpting AI's Responses

Prompt engineering is the art of crafting the inputs for generative AI models to achieve desired outputs. Imagine it like writing instructions for a very capable but literal friend who needs detailed guidance to complete tasks. In this case, the instructions are your prompts, and the friend is the AI model.

Here's a breakdown of the key aspects:

**What is a prompt?**

A prompt is a piece of text, code, or even an image that guides an AI model in its generation process. It can be a simple question, a creative narrative starter, or a set of specific instructions. The more precise and nuanced your prompt, the more control you have over the AI's output.

**Why is it important?**

Prompt engineering unlocks the full potential of generative AI models. It allows you to:

* **Fine-tune AI outputs:** Tailor the AI's response to your specific needs and context.
* **Control style and tone:** Craft outputs that match your desired tone, format, and level of formality.
* **Boost creativity and originality:** Spark the AI to generate novel ideas and unexpected solutions.
* **Reduce bias and misinformation:** Guide the AI towards accurate and responsible outputs.

**How does it work?**

Different techniques can be used in prompt engineering:

* **Contextual framing:** Provide background information to the AI to inform its understanding.
* **Examples and counter-examples:** Show the AI examples of desired outputs and what to avoid.
* **Emotional cues:** Conveying emotions and tones in the prompt can influence the AI's response.
* **Chain-of-thought prompts:** Break down complex tasks into smaller steps to improve reasoning and accuracy.

**Examples in action:**

* **Prompt:** "Write a poem about a robot falling in love with the moon, in the style of Shakespearean sonnets."
* **Prompt:** "Translate this code into Python, ensuring it follows best practices for code readability and efficiency."
* **Prompt:** "Generate a news article summarizing the impact of climate change on endangered species, citing reliable sources."

**The future of prompt engineering:**

As AI technology evolves, prompt engineering will become even more crucial. We can expect:

* **More sophisticated techniques:** Development of advanced approaches for handling complex tasks and emotions.
* **Integration with other AI tools:** Seamless combination of prompt engineering with other AI techniques for enhanced capabilities.
* **User-friendly interfaces:** Tools that make prompt engineering accessible even to non-technical users.


## Guides

[OpenAI Prompt Engineering Guide](https://platform.openai.com/docs/guides/prompt-engineering/)

[ChatGPT Prompt Engineering for Developers](https://www.deeplearning.ai/short-courses/chatgpt-prompt-engineering-for-developers/)

[Must-Read Best Of Practical Prompt Engineering Strategies To Become A Skillful Prompting Wizard In Generative AI](https://www.forbes.com/sites/lanceeliot/2023/12/28/must-read-best-of-practical-prompt-engineering-strategies-to-become-a-skillful-prompting-wizard-in-generative-ai/?sh=4d05d27f19cd)

[Prompting Guide for Schools - Using Gemini for Google Workspace](https://docs.google.com/presentation/d/1os-52PymXoxEUYESTkUB_gatlsjAl8jPuAsIE11tEno/edit?usp=sharing)