/*
 * Decompiled with CFR 0.152.
 */
package simplejavatexteditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import simplejavatexteditor.About;
import simplejavatexteditor.AutoComplete;
import simplejavatexteditor.FEdit;
import simplejavatexteditor.Find;
import simplejavatexteditor.HighlightText;
import simplejavatexteditor.SupportedKeywords;

public class UI
extends JFrame
implements ActionListener {
    private final String[] dragDropExtensionFilter = new String[]{".txt", ".dat", ".log", ".xml", ".mf", ".html"};
    private static long serialVersionUID = 1L;
    private final JTextArea textArea;
    private final JMenuBar menuBar;
    private final JComboBox<String> fontType;
    private final JComboBox<Integer> fontSize;
    private final JMenu menuFile;
    private final JMenu menuEdit;
    private final JMenu menuFind;
    private final JMenu menuAbout;
    private final JMenuItem newFile;
    private final JMenuItem openFile;
    private final JMenuItem saveFile;
    private final JMenuItem close;
    private final JMenuItem cut;
    private final JMenuItem copy;
    private final JMenuItem paste;
    private final JMenuItem clearFile;
    private final JMenuItem selectAll;
    private final JMenuItem quickFind;
    private final JMenuItem aboutMe;
    private final JMenuItem aboutSoftware;
    private final JMenuItem wordWrap;
    private final JToolBar mainToolbar;
    JButton newButton;
    JButton openButton;
    JButton saveButton;
    JButton clearButton;
    JButton quickButton;
    JButton aboutMeButton;
    JButton aboutButton;
    JButton closeButton;
    JButton boldButton;
    JButton italicButton;
    private final Action selectAllAction;
    private final ImageIcon boldIcon = new ImageIcon(UI.class.getResource("icons/bold.png"));
    private final ImageIcon italicIcon = new ImageIcon("icons/italic.png");
    private final ImageIcon newIcon = new ImageIcon(UI.class.getResource("icons/new.png"));
    private final ImageIcon openIcon = new ImageIcon(UI.class.getResource("icons/open.png"));
    private final ImageIcon saveIcon = new ImageIcon(UI.class.getResource("icons/save.png"));
    private final ImageIcon closeIcon = new ImageIcon(UI.class.getResource("icons/close.png"));
    private final ImageIcon clearIcon = new ImageIcon(UI.class.getResource("icons/clear.png"));
    private final ImageIcon cutIcon = new ImageIcon(UI.class.getResource("icons/cut.png"));
    private final ImageIcon copyIcon = new ImageIcon(UI.class.getResource("icons/copy.png"));
    private final ImageIcon pasteIcon = new ImageIcon(UI.class.getResource("icons/paste.png"));
    private final ImageIcon selectAllIcon = new ImageIcon(UI.class.getResource("icons/selectall.png"));
    private final ImageIcon wordwrapIcon = new ImageIcon(UI.class.getResource("icons/wordwrap.png"));
    private final ImageIcon searchIcon = new ImageIcon(UI.class.getResource("icons/search.png"));
    private final ImageIcon aboutMeIcon = new ImageIcon(UI.class.getResource("icons/about_me.png"));
    private final ImageIcon aboutIcon = new ImageIcon(UI.class.getResource("icons/about.png"));
    private SupportedKeywords kw = new SupportedKeywords();
    private HighlightText languageHighlighter = new HighlightText(Color.GRAY);
    AutoComplete autocomplete;
    private boolean hasListener = false;
    private boolean edit = false;
    DropTargetListener dropTargetListener = new DropTargetListener(){

        @Override
        public void dragEnter(DropTargetDragEvent e) {
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (UI.this.edit) {
                Object[] options = new Object[]{"Save", "No Save", "Return"};
                int n = JOptionPane.showOptionDialog(UI.this, "Do you want to save the file at first ?", "Question", 1, 3, null, options, options[2]);
                if (n == 0) {
                    UI.this.saveFile();
                    UI.this.edit = false;
                } else if (n == 1) {
                    UI.this.edit = false;
                    FEdit.clear(UI.this.textArea);
                } else if (n == 2) {
                    e.rejectDrop();
                    return;
                }
            }
            try {
                DataFlavor[] flavors;
                Transferable tr = e.getTransferable();
                DataFlavor[] dataFlavorArray = flavors = tr.getTransferDataFlavors();
                int n = flavors.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor flavor = dataFlavorArray[n2];
                    if (flavor.isFlavorJavaFileListType()) {
                        e.acceptDrop(e.getDropAction());
                        try {
                            String fileName = tr.getTransferData(flavor).toString().replace("[", "").replace("]", "");
                            boolean extensionAllowed = false;
                            String[] stringArray = UI.this.dragDropExtensionFilter;
                            int n3 = UI.this.dragDropExtensionFilter.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String s = stringArray[n4];
                                if (fileName.endsWith(s)) {
                                    extensionAllowed = true;
                                    break;
                                }
                                ++n4;
                            }
                            if (!extensionAllowed) {
                                JOptionPane.showMessageDialog(UI.this, "This file is not allowed for drag & drop", "Error", 0);
                            } else {
                                FileInputStream fis = new FileInputStream(new File(fileName));
                                byte[] ba = new byte[fis.available()];
                                fis.read(ba);
                                UI.this.textArea.setText(new String(ba));
                                fis.close();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        e.dropComplete(true);
                        return;
                    }
                    ++n2;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            e.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    };

    public UI() {
        String[] fonts;
        try {
            ImageIcon image = new ImageIcon(UI.class.getResource("icons/ste.png"));
            super.setIconImage(image.getImage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setSize(800, 500);
        this.setTitle("Untitled | PHNotePad");
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.textArea = new JTextArea("", 0, 0);
        this.textArea.setFont(new Font("Century Gothic", 0, 12));
        this.textArea.setTabSize(2);
        this.textArea.setFont(new Font("Century Gothic", 0, 12));
        this.textArea.setTabSize(2);
        this.textArea.setLineWrap(true);
        DropTarget dropTarget = new DropTarget(this.textArea, this.dropTargetListener);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UI.this.setTitle("Untitled | PHNotePad     [ Length: " + UI.this.textArea.getText().length() + "    Lines: " + (String.valueOf(UI.this.textArea.getText()) + "|").split("\n").length + "    Words: " + UI.this.textArea.getText().trim().split("\\s+").length + " ]");
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                UI.this.edit = true;
                UI.this.languageHighlighter.highLight(UI.this.textArea, UI.this.kw.getCppKeywords());
                UI.this.languageHighlighter.highLight(UI.this.textArea, UI.this.kw.getJavaKeywords());
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.textArea.setWrapStyleWord(true);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(scrollPane);
        this.getContentPane().add(panel);
        this.menuFile = new JMenu("File");
        this.menuEdit = new JMenu("Edit");
        this.menuFind = new JMenu("Search");
        this.menuAbout = new JMenu("About");
        this.newFile = new JMenuItem("New", this.newIcon);
        this.openFile = new JMenuItem("Open", this.openIcon);
        this.saveFile = new JMenuItem("Save", this.saveIcon);
        this.close = new JMenuItem("Quit", this.closeIcon);
        this.clearFile = new JMenuItem("Clear", this.clearIcon);
        this.quickFind = new JMenuItem("Quick", this.searchIcon);
        this.aboutMe = new JMenuItem("About Me", this.aboutMeIcon);
        this.aboutSoftware = new JMenuItem("About Software", this.aboutIcon);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuEdit);
        this.menuBar.add(this.menuFind);
        this.menuBar.add(this.menuAbout);
        this.setJMenuBar(this.menuBar);
        this.selectAllAction = new SelectAllAction("Select All", this.clearIcon, "Select all text", new Integer(65), this.textArea);
        this.setJMenuBar(this.menuBar);
        this.newFile.addActionListener(this);
        this.newFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.menuFile.add(this.newFile);
        this.openFile.addActionListener(this);
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuFile.add(this.openFile);
        this.saveFile.addActionListener(this);
        this.saveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFile.add(this.saveFile);
        this.close.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.close.addActionListener(this);
        this.menuFile.add(this.close);
        this.selectAll = new JMenuItem(this.selectAllAction);
        this.selectAll.setText("Select All");
        this.selectAll.setIcon(this.selectAllIcon);
        this.selectAll.setToolTipText("Select All");
        this.selectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.menuEdit.add(this.selectAll);
        this.clearFile.addActionListener(this);
        this.clearFile.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.menuEdit.add(this.clearFile);
        this.cut = new JMenuItem(new DefaultEditorKit.CutAction());
        this.cut.setText("Cut");
        this.cut.setIcon(this.cutIcon);
        this.cut.setToolTipText("Cut");
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.menuEdit.add(this.cut);
        this.wordWrap = new JMenuItem();
        this.wordWrap.setText("Word Wrap");
        this.wordWrap.setIcon(this.wordwrapIcon);
        this.wordWrap.setToolTipText("Word Wrap");
        this.wordWrap.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.menuEdit.add(this.wordWrap);
        this.wordWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UI.this.textArea.setLineWrap(!UI.this.textArea.getLineWrap());
            }
        });
        this.copy = new JMenuItem(new DefaultEditorKit.CopyAction());
        this.copy.setText("Copy");
        this.copy.setIcon(this.copyIcon);
        this.copy.setToolTipText("Copy");
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.menuEdit.add(this.copy);
        this.paste = new JMenuItem(new DefaultEditorKit.PasteAction());
        this.paste.setText("Paste");
        this.paste.setIcon(this.pasteIcon);
        this.paste.setToolTipText("Paste");
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.menuEdit.add(this.paste);
        this.quickFind.addActionListener(this);
        this.quickFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuFind.add(this.quickFind);
        this.aboutMe.addActionListener(this);
        this.aboutMe.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.menuAbout.add(this.aboutMe);
        this.aboutSoftware.addActionListener(this);
        this.aboutSoftware.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuAbout.add(this.aboutSoftware);
        this.mainToolbar = new JToolBar();
        this.add((Component)this.mainToolbar, "North");
        this.newButton = new JButton(this.newIcon);
        this.newButton.setToolTipText("New");
        this.newButton.addActionListener(this);
        this.mainToolbar.add(this.newButton);
        this.mainToolbar.addSeparator();
        this.openButton = new JButton(this.openIcon);
        this.openButton.setToolTipText("Open");
        this.openButton.addActionListener(this);
        this.mainToolbar.add(this.openButton);
        this.mainToolbar.addSeparator();
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.setToolTipText("Save");
        this.saveButton.addActionListener(this);
        this.mainToolbar.add(this.saveButton);
        this.mainToolbar.addSeparator();
        this.clearButton = new JButton(this.clearIcon);
        this.clearButton.setToolTipText("Clear All");
        this.clearButton.addActionListener(this);
        this.mainToolbar.add(this.clearButton);
        this.mainToolbar.addSeparator();
        this.quickButton = new JButton(this.searchIcon);
        this.quickButton.setToolTipText("Quick Search");
        this.quickButton.addActionListener(this);
        this.mainToolbar.add(this.quickButton);
        this.mainToolbar.addSeparator();
        this.aboutMeButton = new JButton(this.aboutMeIcon);
        this.aboutMeButton.setToolTipText("About Me");
        this.aboutMeButton.addActionListener(this);
        this.mainToolbar.add(this.aboutMeButton);
        this.mainToolbar.addSeparator();
        this.aboutButton = new JButton(this.aboutIcon);
        this.aboutButton.setToolTipText("About NotePad PH");
        this.aboutButton.addActionListener(this);
        this.mainToolbar.add(this.aboutButton);
        this.mainToolbar.addSeparator();
        this.closeButton = new JButton(this.closeIcon);
        this.closeButton.setToolTipText("Quit");
        this.closeButton.addActionListener(this);
        this.mainToolbar.add(this.closeButton);
        this.mainToolbar.addSeparator();
        this.boldButton = new JButton(this.boldIcon);
        this.boldButton.setToolTipText("Bold");
        this.boldButton.addActionListener(this);
        this.mainToolbar.add(this.boldButton);
        this.mainToolbar.addSeparator();
        this.italicButton = new JButton(this.italicIcon);
        this.italicButton.setToolTipText("Italic");
        this.italicButton.addActionListener(this);
        this.mainToolbar.add(this.italicButton);
        this.mainToolbar.addSeparator();
        this.fontType = new JComboBox();
        String[] stringArray = fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            String font = stringArray[n2];
            this.fontType.addItem(font);
            ++n2;
        }
        this.fontType.setMaximumSize(new Dimension(170, 30));
        this.fontType.setToolTipText("Font Type");
        this.mainToolbar.add(this.fontType);
        this.mainToolbar.addSeparator();
        this.fontType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String p = UI.this.fontType.getSelectedItem().toString();
                int s = UI.this.textArea.getFont().getSize();
                UI.this.textArea.setFont(new Font(p, 0, s));
            }
        });
        this.fontSize = new JComboBox();
        int i = 5;
        while (i <= 100) {
            this.fontSize.addItem(i);
            ++i;
        }
        this.fontSize.setMaximumSize(new Dimension(70, 30));
        this.fontSize.setToolTipText("Font Size");
        this.mainToolbar.add(this.fontSize);
        this.fontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String sizeValue = UI.this.fontSize.getSelectedItem().toString();
                int sizeOfFont = Integer.parseInt(sizeValue);
                String fontFamily = UI.this.textArea.getFont().getFamily();
                Font font1 = new Font(fontFamily, 0, sizeOfFont);
                UI.this.textArea.setFont(font1);
            }
        });
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.edit) {
                Object[] options = new Object[]{"Save and exit", "No Save and exit", "Return"};
                int n = JOptionPane.showOptionDialog(this, "Do you want to save the file ?", "Question", 1, 3, null, options, options[1]);
                if (n == 0) {
                    this.saveFile();
                    this.dispose();
                } else if (n == 1) {
                    this.dispose();
                }
            } else {
                System.exit(99);
            }
        }
    }

    protected JTextArea getEditor() {
        return this.textArea;
    }

    public void enableAutoComplete(File file) {
        if (this.hasListener) {
            this.textArea.getDocument().removeDocumentListener(this.autocomplete);
            this.hasListener = false;
        }
        String[] list = this.kw.getSupportedLanguages();
        int i = 0;
        while (i < list.length) {
            if (file.getName().endsWith(list[i])) {
                switch (i) {
                    case 0: {
                        String[] jk = this.kw.getJavaKeywords();
                        ArrayList<String> arrayList = this.kw.setKeywords(jk);
                        this.autocomplete = new AutoComplete(this, arrayList);
                        this.textArea.getDocument().addDocumentListener(this.autocomplete);
                        this.hasListener = true;
                        break;
                    }
                    case 1: {
                        String[] ck = this.kw.getCppKeywords();
                        ArrayList<String> arrayList = this.kw.setKeywords(ck);
                        this.autocomplete = new AutoComplete(this, arrayList);
                        this.textArea.getDocument().addDocumentListener(this.autocomplete);
                        this.hasListener = true;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int n;
        Object[] options;
        if (e.getSource() == this.close || e.getSource() == this.closeButton) {
            if (this.edit) {
                options = new Object[]{"Save and exit", "No Save and exit", "Return"};
                n = JOptionPane.showOptionDialog(this, "Do you want to save the file ?", "Question", 1, 3, null, options, options[2]);
                if (n == 0) {
                    this.saveFile();
                    this.dispose();
                } else if (n == 1) {
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        } else if (e.getSource() == this.newFile || e.getSource() == this.newButton) {
            if (this.edit) {
                options = new Object[]{"Save", "No Save", "Return"};
                n = JOptionPane.showOptionDialog(this, "Do you want to save the file at first ?", "Question", 1, 3, null, options, options[2]);
                if (n == 0) {
                    this.saveFile();
                    this.edit = false;
                } else if (n == 1) {
                    this.edit = false;
                    FEdit.clear(this.textArea);
                }
            } else {
                FEdit.clear(this.textArea);
            }
        } else if (e.getSource() == this.openFile || e.getSource() == this.openButton) {
            int option;
            JFileChooser open = new JFileChooser();
            if (!this.textArea.getText().equals("")) {
                this.saveFile();
            }
            if ((option = open.showOpenDialog(this)) == 0) {
                FEdit.clear(this.textArea);
                try {
                    File openFile = open.getSelectedFile();
                    this.setTitle(String.valueOf(openFile.getName()) + " | " + "PHNotePad");
                    Scanner scan = new Scanner(new FileReader(openFile.getPath()));
                    while (scan.hasNext()) {
                        this.textArea.append(String.valueOf(scan.nextLine()) + "\n");
                    }
                    this.enableAutoComplete(openFile);
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            }
        } else if (e.getSource() == this.saveFile || e.getSource() == this.saveButton) {
            this.saveFile();
        } else if (e.getSource() == this.boldButton) {
            if (this.textArea.getFont().getStyle() == 1) {
                this.textArea.setFont(this.textArea.getFont().deriveFont(0));
            } else {
                this.textArea.setFont(this.textArea.getFont().deriveFont(1));
            }
        } else if (e.getSource() == this.italicButton) {
            if (this.textArea.getFont().getStyle() == 2) {
                this.textArea.setFont(this.textArea.getFont().deriveFont(0));
            } else {
                this.textArea.setFont(this.textArea.getFont().deriveFont(2));
            }
        }
        if ((e.getSource() == this.clearFile || e.getSource() == this.clearButton) && (n = JOptionPane.showOptionDialog(this, "Are you sure to clear the text Area ?", "Question", 1, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 0) {
            FEdit.clear(this.textArea);
        }
        if (e.getSource() == this.quickFind || e.getSource() == this.quickButton) {
            new Find(this.textArea);
        } else if (e.getSource() == this.aboutMe || e.getSource() == this.aboutMeButton) {
            new About(this).me();
        } else if (e.getSource() == this.aboutSoftware || e.getSource() == this.aboutButton) {
            new About(this).software();
        }
    }

    private void saveFile() {
        JFileChooser fileChoose = new JFileChooser();
        int option = fileChoose.showSaveDialog(this);
        if (option == 0) {
            try {
                File openFile = fileChoose.getSelectedFile();
                this.setTitle(String.valueOf(openFile.getName()) + " | " + "PHNotePad");
                BufferedWriter out = new BufferedWriter(new FileWriter(openFile.getPath()));
                out.write(this.textArea.getText());
                out.close();
                this.enableAutoComplete(openFile);
                this.edit = false;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SelectAllAction(String text, ImageIcon icon, String desc, Integer mnemonic, JTextArea textArea) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UI.this.textArea.selectAll();
        }
    }
}

