/*
 * Decompiled with CFR 0.152.
 */
package simplejavatexteditor;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class HighlightText
extends DefaultHighlighter.DefaultHighlightPainter {
    public HighlightText(Color color) {
        super(color);
    }

    public void highLight(JTextComponent textComp, String[] pattern) {
        this.removeHighlights(textComp);
        try {
            Highlighter highlighter = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int i = 0;
            while (i < pattern.length) {
                int pos = 0;
                while ((pos = text.indexOf(pattern[i], pos)) >= 0) {
                    highlighter.addHighlight(pos, pos + pattern[i].length(), this);
                    pos += pattern[i].length();
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeHighlights(JTextComponent textComp) {
        Highlighter highlighter = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = highlighter.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter() instanceof HighlightText) {
                highlighter.removeHighlight(hilites[i]);
            }
            ++i;
        }
    }
}

