/*
 * Decompiled with CFR 0.152.
 */
package simplejavatexteditor;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import simplejavatexteditor.SupportedKeywords;
import simplejavatexteditor.UI;

public class AutoComplete
implements DocumentListener {
    private ArrayList<String> brackets = new ArrayList();
    private ArrayList<String> bracketCompletions = new ArrayList();
    private ArrayList<String> words = new ArrayList();
    SupportedKeywords kw;
    private final UI ui;
    private Mode mode = Mode.INSERT;
    private final JTextArea textArea;
    private static final String COMMIT_ACTION = "commit";
    private boolean isKeyword;
    private int pos;
    private String content;

    public AutoComplete(UI ui, ArrayList<String> al) {
        this.words = al;
        this.kw = new SupportedKeywords();
        this.brackets = this.kw.getBrackets();
        this.bracketCompletions = this.kw.getBracketCompletions();
        this.ui = ui;
        this.textArea = ui.getEditor();
        InputMap im = this.textArea.getInputMap();
        ActionMap am = this.textArea.getActionMap();
        im.put(KeyStroke.getKeyStroke("ENTER "), COMMIT_ACTION);
        am.put(COMMIT_ACTION, new CommitAction());
        Collections.sort(this.words);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.pos = e.getOffset();
        this.content = null;
        try {
            this.content = this.textArea.getText(0, this.pos + 1);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        if (e.getLength() != 1) {
            return;
        }
        this.checkForBracket();
        int start = this.pos;
        while (start >= 0) {
            if (!Character.isLetter(this.content.charAt(start))) break;
            --start;
        }
        if (this.pos - start < 2) {
            return;
        }
        String prefix = this.content.substring(start + 1);
        int n = Collections.binarySearch(this.words, prefix);
        if (n < 0 && -n < this.words.size()) {
            String match = this.words.get(-n - 1);
            if (match.startsWith(prefix)) {
                String completion = match.substring(this.pos - start);
                this.isKeyword = true;
                SwingUtilities.invokeLater(new CompletionTask(completion, this.pos + 1));
            } else {
                this.mode = Mode.INSERT;
            }
        }
    }

    private void checkForBracket() {
        char c = this.content.charAt(this.pos);
        String s = String.valueOf(c);
        int i = 0;
        while (i < this.brackets.size()) {
            if (this.brackets.get(i).equals(s)) {
                this.isKeyword = false;
                SwingUtilities.invokeLater(new CompletionTask(this.bracketCompletions.get(i), this.pos + 1));
            }
            ++i;
        }
    }

    private ArrayList<String> getKeywords() {
        return this.words;
    }

    private void setKeywords(String keyword) {
        this.words.add(keyword);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private class CommitAction
    extends AbstractAction {
        private CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AutoComplete.this.mode == Mode.COMPLETION) {
                int pos = AutoComplete.this.textArea.getSelectionEnd();
                if (AutoComplete.this.isKeyword) {
                    AutoComplete.this.textArea.insert(" ", pos);
                    AutoComplete.this.textArea.setCaretPosition(pos + 1);
                    AutoComplete.this.mode = Mode.INSERT;
                }
            } else {
                AutoComplete.this.mode = Mode.INSERT;
                AutoComplete.this.textArea.replaceSelection("\n");
            }
        }
    }

    private class CompletionTask
    implements Runnable {
        private final String completion;
        private final int position;

        public CompletionTask(String completion, int position) {
            this.completion = completion;
            this.position = position;
        }

        @Override
        public void run() {
            AutoComplete.this.textArea.insert(this.completion, this.position);
            AutoComplete.this.textArea.setCaretPosition(this.position + this.completion.length());
            AutoComplete.this.textArea.moveCaretPosition(this.position);
            AutoComplete.this.mode = Mode.COMPLETION;
            if (!AutoComplete.this.isKeyword) {
                AutoComplete.this.textArea.addKeyListener(new HandleBracketEvent());
            }
        }
    }

    private class HandleBracketEvent
    implements KeyListener {
        private HandleBracketEvent() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            String keyEvent = String.valueOf(e.getKeyChar());
            for (String bracketCompletion : AutoComplete.this.bracketCompletions) {
                if (!keyEvent.equals(bracketCompletion)) continue;
                AutoComplete.this.textArea.replaceRange("", AutoComplete.this.pos, AutoComplete.this.pos + 1);
                AutoComplete.this.mode = Mode.INSERT;
                AutoComplete.this.textArea.removeKeyListener(this);
            }
            int currentPosition = AutoComplete.this.textArea.getCaretPosition();
            switch (e.getKeyChar()) {
                case '\n': {
                    AutoComplete.this.textArea.insert("\n\n", currentPosition);
                    AutoComplete.this.textArea.setCaretPosition(currentPosition + 1);
                    AutoComplete.this.mode = Mode.INSERT;
                    AutoComplete.this.textArea.removeKeyListener(this);
                    break;
                }
                default: {
                    AutoComplete.this.textArea.setCaretPosition(AutoComplete.this.pos);
                    AutoComplete.this.mode = Mode.INSERT;
                    AutoComplete.this.textArea.removeKeyListener(this);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

