// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "Extension.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using namespace  ::osquery::extensions;

class ExtensionHandler : virtual public ExtensionIf {
 public:
  ExtensionHandler() {
    // Your initialization goes here
  }

  void ping(ExtensionStatus& _return) {
    // Your implementation goes here
    printf("ping\n");
  }

  void call(ExtensionResponse& _return, const std::string& registry, const std::string& item, const ExtensionPluginRequest& request) {
    // Your implementation goes here
    printf("call\n");
  }

  void shutdown() {
    // Your implementation goes here
    printf("shutdown\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  ::std::shared_ptr<ExtensionHandler> handler(new ExtensionHandler());
  ::std::shared_ptr<TProcessor> processor(new ExtensionProcessor(handler));
  ::std::shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  ::std::shared_ptr<TTransportFactory> transportFactory(
      new TBufferedTransportFactory());
  ::std::shared_ptr<TProtocolFactory> protocolFactory(
      new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

