// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ExtensionManager.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using namespace  ::osquery::extensions;

class ExtensionManagerHandler : virtual public ExtensionManagerIf {
 public:
  ExtensionManagerHandler() {
    // Your initialization goes here
  }

  void extensions(InternalExtensionList& _return) {
    // Your implementation goes here
    printf("extensions\n");
  }

  void options(InternalOptionList& _return) {
    // Your implementation goes here
    printf("options\n");
  }

  void registerExtension(ExtensionStatus& _return, const InternalExtensionInfo& info, const ExtensionRegistry& registry) {
    // Your implementation goes here
    printf("registerExtension\n");
  }

  void deregisterExtension(ExtensionStatus& _return, const ExtensionRouteUUID uuid) {
    // Your implementation goes here
    printf("deregisterExtension\n");
  }

  void query(ExtensionResponse& _return, const std::string& sql) {
    // Your implementation goes here
    printf("query\n");
  }

  void getQueryColumns(ExtensionResponse& _return, const std::string& sql) {
    // Your implementation goes here
    printf("getQueryColumns\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  ::std::shared_ptr<ExtensionManagerHandler> handler(
      new ExtensionManagerHandler());
  ::std::shared_ptr<TProcessor> processor(
      new ExtensionManagerProcessor(handler));
  ::std::shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  ::std::shared_ptr<TTransportFactory> transportFactory(
      new TBufferedTransportFactory());
  ::std::shared_ptr<TProtocolFactory> protocolFactory(
      new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

