/* config.h. Generated by cmake from config.h.cmake */

#ifndef _DBUS_CONFIG_H
#define _DBUS_CONFIG_H
/****************************/
/* indicate that we are building with cmake */
#define DBUS_CMAKE 1

/* On Windows, we expect to be using msvcrt.dll-compatible printf
 * (%I64u instead of %llu) unless otherwise specified. This must be
 * done near the beginning of config.h, before we have included any
 * system headers that might check the value of this macro. */
#ifndef __USE_MINGW_ANSI_STDIO
#   define __USE_MINGW_ANSI_STDIO 0
#endif

/* generated by cmake macro autopackage */

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT "https://bugs.freedesktop.org/enter_bug.cgi?product=dbus"

/* Define to the full name of this package. */
#define PACKAGE_NAME "dbus"

/* Define to the full name and version of this package. */
#define PACKAGE_STRING "dbus 1.12.24"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "dbus"

/* Define to the home page for this package. */
#define PACKAGE_URL "http://dbus.freedesktop.org"

/* Define to the version of this package. */
#define PACKAGE_VERSION "1.12.24"

/* defined by autotools package */
#define PACKAGE "dbus"
#define VERSION "1.12.24"


/*
 * Variables defined by AC_DEFINE in ../configure.ac
 * should be placed in this file
*/
/* #undef HAVE_GNUC_VARARGS */

/* #undef DBUS_CONSOLE_AUTH_DIR */
#define DBUS_DATADIR  "/usr/share"
#define DBUS_BINDIR   "/usr/bin"
#define DBUS_PREFIX "/usr"
#define DBUS_SYSTEM_CONFIG_FILE  "/dbus-1/system.conf"
#define DBUS_SESSION_CONFIG_FILE "/dbus-1/session.conf"
#define DBUS_DAEMON_NAME "dbus-daemon"
#define DBUS_SYSTEM_BUS_DEFAULT_ADDRESS  "unix:path=/var/run/dbus/system_bus_socket"
#define DBUS_SESSION_BUS_CONNECT_ADDRESS  "autolaunch:"
#define DBUS_MACHINE_UUID_FILE "/var/lib/dbus/machine-id"
#define DBUS_DAEMONDIR "/usr/bin"
#define DBUS_RUNSTATEDIR "/var/run"

/* #undef DBUS_ENABLE_STATS */

#define TEST_LISTEN       ""

// test binaries
#define DBUS_EXEEXT ""

/* Some dbus features */
/* #undef DBUS_ENABLE_ANSI */
/* #undef DBUS_ENABLE_VERBOSE_MODE */
/* #undef DBUS_DISABLE_ASSERT */
#ifndef DBUS_DISABLE_ASSERT
#  define DBUS_ENABLE_ASSERT 1
#endif
/* #undef DBUS_DISABLE_CHECKS */
#ifndef DBUS_DISABLE_CHECKS
#  define DBUS_ENABLE_CHECKS 1
#endif
/* xmldocs */
/* doxygen */
/* #undef DBUS_GCOV_ENABLED */

/* selinux */
/* kqueue */
/* #undef HAVE_CONSOLE_OWNER_FILE */
#define DBUS_CONSOLE_OWNER_FILE ""

/* #undef DBUS_BUILD_X11 */
/* For the moment, the cmake build system doesn't have an equivalent of
 * the autoconf build system's --disable-x11-autolaunch */
#ifdef DBUS_BUILD_X11
# define DBUS_ENABLE_X11_AUTOLAUNCH 1
#endif

#define _DBUS_VA_COPY_ASSIGN(a1,a2) { a1 = a2; }

#define DBUS_VA_COPY_FUNC
#if (defined DBUS_VA_COPY_FUNC)
# define DBUS_VA_COPY va_copy
#endif

#ifdef DBUS_VA_COPY_FUNC
#undef DBUS_VA_COPY_FUNC
#endif

/* #undef DBUS_VA_COPY_AS_ARRAY */

/* #undef DBUS_WITH_GLIB */
/* #undef GLIB_VERSION_MIN_REQUIRED */
/* #undef GLIB_VERSION_MAX_ALLOWED */

// headers
#define HAVE_ALLOCA_H
#define HAVE_BYTESWAP_H
/* #undef HAVE_CRT_EXTERNS_H */

/* Define to 1 if you have dirent.h */
#define   HAVE_DIRENT_H 1

#define HAVE_DLFCN_H

/* Define to 1 if you have errno.h */
#define   HAVE_ERRNO_H 1

#define HAVE_EXECINFO_H
/* #undef HAVE_EXPAT_H */

/* Define to 1 if you have grp.h */
#define   HAVE_GRP_H 1

/* Define to 1 if you have inttypes.h */
#define   HAVE_INTTYPES_H 1

/* Define to 1 if you have io.h */
/* #undef HAVE_IO_H */

/* Define to 1 if you have locale.h */
#define   HAVE_LOCALE_H 1

#define HAVE_MEMORY_H

/* Define to 1 if you have sys/poll.h */
#define    HAVE_POLL 1

/* Define to 1 if you have signal.h */
#define   HAVE_SIGNAL_H 1

/* Define to 1 if you have stdint.h */
#define   HAVE_STDINT_H 1

#define HAVE_STDLIB_H

/* Define to 1 if you have stdio.h */
#define   HAVE_STDIO_H 1

#define HAVE_STRINGS_H
#define HAVE_STRING_H
#define HAVE_SYSLOG_H
/* #undef HAVE_SYS_EVENTS_H */
#define HAVE_SYS_INOTIFY_H
#define HAVE_SYS_PRCTL_H
#define HAVE_SYS_RESOURCE_H
#define HAVE_SYS_STAT_H

/* Define to 1 if you have sys/syslimits.h */
/* #undef HAVE_SYS_SYSLIMITS_H */

/* Define to 1 if you have sys/time.h */
#define    HAVE_SYS_TIME_H 1

#define HAVE_SYS_TYPES_H

#define HAVE_SYS_UIO_H

/* Define to 1 if you have sys/wait.h */
#define    HAVE_SYS_WAIT_H 1

/* Define to 1 if you have time.h */
#define   HAVE_TIME_H 1

/* Define to 1 if you have unistd.h */
#define   HAVE_UNISTD_H 1

/* Define to 1 if you have ws2tcpip.h */
/* #undef HAVE_WS2TCPIP_H */

// symbols
/* Define to 1 if you have backtrace */
#define   HAVE_BACKTRACE 1

/* Define to 1 if you have getgrouplist */
#define   HAVE_GETGROUPLIST 1

/* Define to 1 if you have getpeerucred */
/* #undef HAVE_GETPEERUCRED */

/* Define to 1 if you have nanosleep */
#define   HAVE_NANOSLEEP 1

/* Define to 1 if you have getpwnam_r */
/* #undef HAVE_POSIX_GETPWNAM_R */

/* Define to 1 if you have socketpair */
#define   HAVE_SOCKETPAIR 1

/* Define to 1 if you have setenv */
#define   HAVE_SETENV 1

/* Define to 1 if you have unsetenv */
#define   HAVE_UNSETENV 1

/* Define to 1 if you have clearenv */
#define   HAVE_CLEARENV 1

/* Define to 1 if you have writev */
#define   HAVE_WRITEV 1

/* Define to 1 if you have socklen_t */
#define   HAVE_SOCKLEN_T 1

/* Define to 1 if you have setlocale */
#define   HAVE_SETLOCALE 1

/* Define to 1 if you have localeconv */
#define   HAVE_LOCALECONV 1

/* Define to 1 if you have strtoll */
#define   HAVE_STRTOLL 1

/* Define to 1 if you have strtoull */
#define   HAVE_STRTOULL 1

/* Define to 1 if you have pip2 */
#define   HAVE_PIPE2

#define HAVE_ACCEPT4 1
#define HAVE_DIRFD 1
#define HAVE_INOTIFY_INIT1 1
#define HAVE_GETRLIMIT 1
#define HAVE_PRLIMIT 1
#define HAVE_SETRLIMIT 1
#define HAVE_UNIX_FD_PASSING 1

// structs
/* Define to 1 if you have struct cmsgred */
/* #undef HAVE_CMSGCRED */

/* #undef FD_SETSIZE */

#define DBUS_USER "messagebus"
#define DBUS_TEST_USER "nobody"

// system type defines
#if defined(_WIN32) || defined(_WIN64) || defined (_WIN32_WCE)
# define DBUS_WIN
# define DBUS_WIN_FIXME 1
# ifdef _WIN32_WCE
#  define DBUS_WINCE
# else
#  define DBUS_WIN32
# endif
#else
# define DBUS_UNIX
#endif 

#if defined(_WIN32) || defined(_WIN64)
// mingw mode_t
# ifdef HAVE_STDIO_H
#  include <stdio.h>
# endif
# ifndef _MSC_VER
#  define uid_t int
#  define gid_t int
# else
#  define snprintf _snprintf
   typedef int mode_t;
#  if !defined(_WIN32_WCE)
#    define strtoll _strtoi64
#    define strtoull _strtoui64
#    define HAVE_STRTOLL 1
#    define HAVE_STRTOULL 1
#  endif
# endif
#endif	// defined(_WIN32) || defined(_WIN64)

#ifdef interface
#undef interface
#endif

#ifndef SIGHUP
#define SIGHUP	1
#endif

/* #undef DBUS_VERBOSE_C_S */
#ifdef DBUS_VERBOSE_C_S
#define _dbus_verbose_C_S printf
#else
#define _dbus_verbose_C_S _dbus_verbose
#endif 

# if defined(_MSC_VER) && !defined(inline)
#define inline __inline
#endif

#ifdef DBUS_WIN
#define FD_SETSIZE 
#endif

#endif  // _DBUS_CONFIG_H
