# Augeas library build notes

The library will depend on libxml2; the system one should be enough, osquery will not use it. In fact, when editing the augeas CMakeLists.txt in osquery, remember to remove `augrun.c` and `xml.c` from the build files, since these are what require libxml2 and are unused in osquery.

It's also possible to do the same when configuring the library on its own to avoid requiring libxml2 in the system.

## Linux

## Common

Prepare the environment

```bash
export TOOLCHAIN="/usr/local/osquery-toolchain"
export PKG_CONFIG_SYSROOT_DIR=${TOOLCHAIN}
export PKG_CONFIG_PATH=
export PKG_CONFIG_LIBDIR=${TOOLCHAIN}/usr/lib/pkgconfig
export PATH="${TOOLCHAIN}/usr/bin:${PATH}"
export CFLAGS="--sysroot ${TOOLCHAIN}"
export CXXFLAGS="${CFLAGS}"
export CPPFLAGS="${CFLAGS}"
export LDFLAGS="${CFLAGS}"
export CC=clang
```

Disables tests, documentation and examples:

```bash
sed -i '/SUBDIRS += tests man doc examples/d' Makefile.am
sed -i '/SUBDIRS += gnulib\/tests/d' Makefile.am
```

Disable the command line tools:

```bash
sed -i '/AUGEAS_CHECK_READLINE/d' configure.ac
sed -i '/bin_PROGRAMS = augtool augparse augmatch/c\bin_PROGRAMS = ' src/Makefile.am
```

Now configure the library

```bash
./autogen.sh \
  --enable-static \
  --enable-shared=no \
  --without-selinux
```

Build the library

```bash
make -j $(nproc)
```

Copy the generated augeas files:

 - `config.h`
 - `datadir.h`
 - `parser.c`
 - `parser.h`
 - `lexer.c`

Copy the generated gnulib files:

 - `config.h` (use the augeas one)
 - All the files containing `GENERATED AUTOMATICALLY` under `lib`

## macOS

Ensure to have GNU `bison` and `flex` installed from brew

```bash
brew install bison flex
```

### x86_64

```bash
export PATH="/usr/local/opt/bison/bin:/usr/local/opt/flex/bin:${PATH}"
export CFLAGS="-isysroot /Applications/Xcode_13.0.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX11.3.sdk -mmacosx-version-min=10.14 -Wunguarded-availability-new"
export LDFLAGS="${CFLAGS}"
export CC=clang
```

Disables tests, documentation and examples:

```bash
gsed -i '/SUBDIRS += tests man doc examples/d' Makefile.am
gsed -i '/SUBDIRS += gnulib\/tests/d' Makefile.am
```

Disable the command line tools:

```bash
gsed -i '/AUGEAS_CHECK_READLINE/d' configure.ac
gsed -i '/bin_PROGRAMS = augtool augparse augmatch/c\bin_PROGRAMS = ' src/Makefile.am
```

Now configure the library

```bash
./autogen.sh \
  --enable-static \
  --enable-shared=no \
  --without-selinux
```

Build the library

```bash
make -j $(nproc)
```

Copy the generated augeas files:

 - `config.h`
 - `datadir.h`
 - `parser.c`
 - `parser.h`
 - `lexer.c`

Copy the generated gnulib files:

 - `config.h` (use the augeas one)
 - All the files containing `AUTOGENERATED` under `lib`

### macOS ARM (M1, M2 etc.)

Same as above, but use the following environment variables instead:

```bash
export CFLAGS="-isysroot /Applications/Xcode_13.0.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX11.3.sdk -mmacosx-version-min=10.15 -Wunguarded-availability-new -target arm64-apple-macos10.15"
export LDFLAGS="${CFLAGS}"
export CC=clang
```

Also pass this additional flag to `autogen.sh`: `--host=arm64-apple-macos10.15`
