/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// UpdateSettingsFlowWithPasskeyMethod Update Settings Flow with Passkey Method
type UpdateSettingsFlowWithPasskeyMethod struct {
	// CSRFToken is the anti-CSRF token
	CsrfToken *string `json:"csrf_token,omitempty"`
	// Method  Should be set to \"passkey\" when trying to add, update, or remove a webAuthn pairing.
	Method string `json:"method"`
	// Remove a WebAuthn Security Key  This must contain the ID of the WebAuthN connection.
	PasskeyRemove *string `json:"passkey_remove,omitempty"`
	// Register a WebAuthn Security Key  It is expected that the JSON returned by the WebAuthn registration process is included here.
	PasskeySettingsRegister *string `json:"passkey_settings_register,omitempty"`
}

// NewUpdateSettingsFlowWithPasskeyMethod instantiates a new UpdateSettingsFlowWithPasskeyMethod object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateSettingsFlowWithPasskeyMethod(method string) *UpdateSettingsFlowWithPasskeyMethod {
	this := UpdateSettingsFlowWithPasskeyMethod{}
	this.Method = method
	return &this
}

// NewUpdateSettingsFlowWithPasskeyMethodWithDefaults instantiates a new UpdateSettingsFlowWithPasskeyMethod object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateSettingsFlowWithPasskeyMethodWithDefaults() *UpdateSettingsFlowWithPasskeyMethod {
	this := UpdateSettingsFlowWithPasskeyMethod{}
	return &this
}

// GetCsrfToken returns the CsrfToken field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetCsrfToken() string {
	if o == nil || o.CsrfToken == nil {
		var ret string
		return ret
	}
	return *o.CsrfToken
}

// GetCsrfTokenOk returns a tuple with the CsrfToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetCsrfTokenOk() (*string, bool) {
	if o == nil || o.CsrfToken == nil {
		return nil, false
	}
	return o.CsrfToken, true
}

// HasCsrfToken returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) HasCsrfToken() bool {
	if o != nil && o.CsrfToken != nil {
		return true
	}

	return false
}

// SetCsrfToken gets a reference to the given string and assigns it to the CsrfToken field.
func (o *UpdateSettingsFlowWithPasskeyMethod) SetCsrfToken(v string) {
	o.CsrfToken = &v
}

// GetMethod returns the Method field value
func (o *UpdateSettingsFlowWithPasskeyMethod) GetMethod() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Method
}

// GetMethodOk returns a tuple with the Method field value
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetMethodOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Method, true
}

// SetMethod sets field value
func (o *UpdateSettingsFlowWithPasskeyMethod) SetMethod(v string) {
	o.Method = v
}

// GetPasskeyRemove returns the PasskeyRemove field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetPasskeyRemove() string {
	if o == nil || o.PasskeyRemove == nil {
		var ret string
		return ret
	}
	return *o.PasskeyRemove
}

// GetPasskeyRemoveOk returns a tuple with the PasskeyRemove field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetPasskeyRemoveOk() (*string, bool) {
	if o == nil || o.PasskeyRemove == nil {
		return nil, false
	}
	return o.PasskeyRemove, true
}

// HasPasskeyRemove returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) HasPasskeyRemove() bool {
	if o != nil && o.PasskeyRemove != nil {
		return true
	}

	return false
}

// SetPasskeyRemove gets a reference to the given string and assigns it to the PasskeyRemove field.
func (o *UpdateSettingsFlowWithPasskeyMethod) SetPasskeyRemove(v string) {
	o.PasskeyRemove = &v
}

// GetPasskeySettingsRegister returns the PasskeySettingsRegister field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetPasskeySettingsRegister() string {
	if o == nil || o.PasskeySettingsRegister == nil {
		var ret string
		return ret
	}
	return *o.PasskeySettingsRegister
}

// GetPasskeySettingsRegisterOk returns a tuple with the PasskeySettingsRegister field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) GetPasskeySettingsRegisterOk() (*string, bool) {
	if o == nil || o.PasskeySettingsRegister == nil {
		return nil, false
	}
	return o.PasskeySettingsRegister, true
}

// HasPasskeySettingsRegister returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithPasskeyMethod) HasPasskeySettingsRegister() bool {
	if o != nil && o.PasskeySettingsRegister != nil {
		return true
	}

	return false
}

// SetPasskeySettingsRegister gets a reference to the given string and assigns it to the PasskeySettingsRegister field.
func (o *UpdateSettingsFlowWithPasskeyMethod) SetPasskeySettingsRegister(v string) {
	o.PasskeySettingsRegister = &v
}

func (o UpdateSettingsFlowWithPasskeyMethod) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CsrfToken != nil {
		toSerialize["csrf_token"] = o.CsrfToken
	}
	if true {
		toSerialize["method"] = o.Method
	}
	if o.PasskeyRemove != nil {
		toSerialize["passkey_remove"] = o.PasskeyRemove
	}
	if o.PasskeySettingsRegister != nil {
		toSerialize["passkey_settings_register"] = o.PasskeySettingsRegister
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateSettingsFlowWithPasskeyMethod struct {
	value *UpdateSettingsFlowWithPasskeyMethod
	isSet bool
}

func (v NullableUpdateSettingsFlowWithPasskeyMethod) Get() *UpdateSettingsFlowWithPasskeyMethod {
	return v.value
}

func (v *NullableUpdateSettingsFlowWithPasskeyMethod) Set(val *UpdateSettingsFlowWithPasskeyMethod) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateSettingsFlowWithPasskeyMethod) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateSettingsFlowWithPasskeyMethod) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateSettingsFlowWithPasskeyMethod(val *UpdateSettingsFlowWithPasskeyMethod) *NullableUpdateSettingsFlowWithPasskeyMethod {
	return &NullableUpdateSettingsFlowWithPasskeyMethod{value: val, isSet: true}
}

func (v NullableUpdateSettingsFlowWithPasskeyMethod) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateSettingsFlowWithPasskeyMethod) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
