/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
	"time"
)

// OAuth2Client struct for OAuth2Client
type OAuth2Client struct {
	// OAuth 2.0 Access Token Strategy  AccessTokenStrategy is the strategy used to generate access tokens. Valid options are `jwt` and `opaque`. `jwt` is a bad idea, see https://www.ory.sh/docs/hydra/advanced#json-web-tokens Setting the stragegy here overrides the global setting in `strategies.access_token`.
	AccessTokenStrategy *string  `json:"access_token_strategy,omitempty"`
	AllowedCorsOrigins  []string `json:"allowed_cors_origins,omitempty"`
	Audience            []string `json:"audience,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	AuthorizationCodeGrantAccessTokenLifespan *string `json:"authorization_code_grant_access_token_lifespan,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	AuthorizationCodeGrantIdTokenLifespan *string `json:"authorization_code_grant_id_token_lifespan,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	AuthorizationCodeGrantRefreshTokenLifespan *string `json:"authorization_code_grant_refresh_token_lifespan,omitempty"`
	// OpenID Connect Back-Channel Logout Session Required  Boolean value specifying whether the RP requires that a sid (session ID) Claim be included in the Logout Token to identify the RP session with the OP when the backchannel_logout_uri is used. If omitted, the default value is false.
	BackchannelLogoutSessionRequired *bool `json:"backchannel_logout_session_required,omitempty"`
	// OpenID Connect Back-Channel Logout URI  RP URL that will cause the RP to log itself out when sent a Logout Token by the OP.
	BackchannelLogoutUri *string `json:"backchannel_logout_uri,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	ClientCredentialsGrantAccessTokenLifespan *string `json:"client_credentials_grant_access_token_lifespan,omitempty"`
	// OAuth 2.0 Client ID  The ID is immutable. If no ID is provided, a UUID4 will be generated.
	ClientId *string `json:"client_id,omitempty"`
	// OAuth 2.0 Client Name  The human-readable name of the client to be presented to the end-user during authorization.
	ClientName *string `json:"client_name,omitempty"`
	// OAuth 2.0 Client Secret  The secret will be included in the create request as cleartext, and then never again. The secret is kept in hashed format and is not recoverable once lost.
	ClientSecret *string `json:"client_secret,omitempty"`
	// OAuth 2.0 Client Secret Expires At  The field is currently not supported and its value is always 0.
	ClientSecretExpiresAt *int64 `json:"client_secret_expires_at,omitempty"`
	// OAuth 2.0 Client URI  ClientURI is a URL string of a web page providing information about the client. If present, the server SHOULD display this URL to the end-user in a clickable fashion.
	ClientUri *string  `json:"client_uri,omitempty"`
	Contacts  []string `json:"contacts,omitempty"`
	// OAuth 2.0 Client Creation Date  CreatedAt returns the timestamp of the client's creation.
	CreatedAt *time.Time `json:"created_at,omitempty"`
	// OpenID Connect Front-Channel Logout Session Required  Boolean value specifying whether the RP requires that iss (issuer) and sid (session ID) query parameters be included to identify the RP session with the OP when the frontchannel_logout_uri is used. If omitted, the default value is false.
	FrontchannelLogoutSessionRequired *bool `json:"frontchannel_logout_session_required,omitempty"`
	// OpenID Connect Front-Channel Logout URI  RP URL that will cause the RP to log itself out when rendered in an iframe by the OP. An iss (issuer) query parameter and a sid (session ID) query parameter MAY be included by the OP to enable the RP to validate the request and to determine which of the potentially multiple sessions is to be logged out; if either is included, both MUST be.
	FrontchannelLogoutUri *string  `json:"frontchannel_logout_uri,omitempty"`
	GrantTypes            []string `json:"grant_types,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	ImplicitGrantAccessTokenLifespan *string `json:"implicit_grant_access_token_lifespan,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	ImplicitGrantIdTokenLifespan *string `json:"implicit_grant_id_token_lifespan,omitempty"`
	// OAuth 2.0 Client JSON Web Key Set  Client's JSON Web Key Set [JWK] document, passed by value. The semantics of the jwks parameter are the same as the jwks_uri parameter, other than that the JWK Set is passed by value, rather than by reference. This parameter is intended only to be used by Clients that, for some reason, are unable to use the jwks_uri parameter, for instance, by native applications that might not have a location to host the contents of the JWK Set. If a Client can use jwks_uri, it MUST NOT use jwks. One significant downside of jwks is that it does not enable key rotation (which jwks_uri does, as described in Section 10 of OpenID Connect Core 1.0 [OpenID.Core]). The jwks_uri and jwks parameters MUST NOT be used together.
	Jwks interface{} `json:"jwks,omitempty"`
	// OAuth 2.0 Client JSON Web Key Set URL  URL for the Client's JSON Web Key Set [JWK] document. If the Client signs requests to the Server, it contains the signing key(s) the Server uses to validate signatures from the Client. The JWK Set MAY also contain the Client's encryption keys(s), which are used by the Server to encrypt responses to the Client. When both signing and encryption keys are made available, a use (Key Use) parameter value is REQUIRED for all keys in the referenced JWK Set to indicate each key's intended usage. Although some algorithms allow the same key to be used for both signatures and encryption, doing so is NOT RECOMMENDED, as it is less secure. The JWK x5c parameter MAY be used to provide X.509 representations of keys provided. When used, the bare key values MUST still be present and MUST match those in the certificate.
	JwksUri *string `json:"jwks_uri,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	JwtBearerGrantAccessTokenLifespan *string `json:"jwt_bearer_grant_access_token_lifespan,omitempty"`
	// OAuth 2.0 Client Logo URI  A URL string referencing the client's logo.
	LogoUri  *string     `json:"logo_uri,omitempty"`
	Metadata interface{} `json:"metadata,omitempty"`
	// OAuth 2.0 Client Owner  Owner is a string identifying the owner of the OAuth 2.0 Client.
	Owner *string `json:"owner,omitempty"`
	// OAuth 2.0 Client Policy URI  PolicyURI is a URL string that points to a human-readable privacy policy document that describes how the deployment organization collects, uses, retains, and discloses personal data.
	PolicyUri              *string  `json:"policy_uri,omitempty"`
	PostLogoutRedirectUris []string `json:"post_logout_redirect_uris,omitempty"`
	RedirectUris           []string `json:"redirect_uris,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	RefreshTokenGrantAccessTokenLifespan *string `json:"refresh_token_grant_access_token_lifespan,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	RefreshTokenGrantIdTokenLifespan *string `json:"refresh_token_grant_id_token_lifespan,omitempty"`
	// Specify a time duration in milliseconds, seconds, minutes, hours.
	RefreshTokenGrantRefreshTokenLifespan *string `json:"refresh_token_grant_refresh_token_lifespan,omitempty"`
	// OpenID Connect Dynamic Client Registration Access Token  RegistrationAccessToken can be used to update, get, or delete the OAuth2 Client. It is sent when creating a client using Dynamic Client Registration.
	RegistrationAccessToken *string `json:"registration_access_token,omitempty"`
	// OpenID Connect Dynamic Client Registration URL  RegistrationClientURI is the URL used to update, get, or delete the OAuth2 Client.
	RegistrationClientUri *string `json:"registration_client_uri,omitempty"`
	// OpenID Connect Request Object Signing Algorithm  JWS [JWS] alg algorithm [JWA] that MUST be used for signing Request Objects sent to the OP. All Request Objects from this Client MUST be rejected, if not signed with this algorithm.
	RequestObjectSigningAlg *string  `json:"request_object_signing_alg,omitempty"`
	RequestUris             []string `json:"request_uris,omitempty"`
	ResponseTypes           []string `json:"response_types,omitempty"`
	// OAuth 2.0 Client Scope  Scope is a string containing a space-separated list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749]) that the client can use when requesting access tokens.
	Scope *string `json:"scope,omitempty"`
	// OpenID Connect Sector Identifier URI  URL using the https scheme to be used in calculating Pseudonymous Identifiers by the OP. The URL references a file with a single JSON array of redirect_uri values.
	SectorIdentifierUri *string `json:"sector_identifier_uri,omitempty"`
	// SkipConsent skips the consent screen for this client. This field can only be set from the admin API.
	SkipConsent *bool `json:"skip_consent,omitempty"`
	// SkipLogoutConsent skips the logout consent screen for this client. This field can only be set from the admin API.
	SkipLogoutConsent *bool `json:"skip_logout_consent,omitempty"`
	// OpenID Connect Subject Type  The `subject_types_supported` Discovery parameter contains a list of the supported subject_type values for this server. Valid types include `pairwise` and `public`.
	SubjectType *string `json:"subject_type,omitempty"`
	// OAuth 2.0 Token Endpoint Authentication Method  Requested Client Authentication method for the Token Endpoint. The options are:  `client_secret_basic`: (default) Send `client_id` and `client_secret` as `application/x-www-form-urlencoded` encoded in the HTTP Authorization header. `client_secret_post`: Send `client_id` and `client_secret` as `application/x-www-form-urlencoded` in the HTTP body. `private_key_jwt`: Use JSON Web Tokens to authenticate the client. `none`: Used for public clients (native apps, mobile apps) which can not have secrets.
	TokenEndpointAuthMethod *string `json:"token_endpoint_auth_method,omitempty"`
	// OAuth 2.0 Token Endpoint Signing Algorithm  Requested Client Authentication signing algorithm for the Token Endpoint.
	TokenEndpointAuthSigningAlg *string `json:"token_endpoint_auth_signing_alg,omitempty"`
	// OAuth 2.0 Client Terms of Service URI  A URL string pointing to a human-readable terms of service document for the client that describes a contractual relationship between the end-user and the client that the end-user accepts when authorizing the client.
	TosUri *string `json:"tos_uri,omitempty"`
	// OAuth 2.0 Client Last Update Date  UpdatedAt returns the timestamp of the last update.
	UpdatedAt *time.Time `json:"updated_at,omitempty"`
	// OpenID Connect Request Userinfo Signed Response Algorithm  JWS alg algorithm [JWA] REQUIRED for signing UserInfo Responses. If this is specified, the response will be JWT [JWT] serialized, and signed using JWS. The default, if omitted, is for the UserInfo Response to return the Claims as a UTF-8 encoded JSON object using the application/json content-type.
	UserinfoSignedResponseAlg *string `json:"userinfo_signed_response_alg,omitempty"`
}

// NewOAuth2Client instantiates a new OAuth2Client object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewOAuth2Client() *OAuth2Client {
	this := OAuth2Client{}
	return &this
}

// NewOAuth2ClientWithDefaults instantiates a new OAuth2Client object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewOAuth2ClientWithDefaults() *OAuth2Client {
	this := OAuth2Client{}
	return &this
}

// GetAccessTokenStrategy returns the AccessTokenStrategy field value if set, zero value otherwise.
func (o *OAuth2Client) GetAccessTokenStrategy() string {
	if o == nil || o.AccessTokenStrategy == nil {
		var ret string
		return ret
	}
	return *o.AccessTokenStrategy
}

// GetAccessTokenStrategyOk returns a tuple with the AccessTokenStrategy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAccessTokenStrategyOk() (*string, bool) {
	if o == nil || o.AccessTokenStrategy == nil {
		return nil, false
	}
	return o.AccessTokenStrategy, true
}

// HasAccessTokenStrategy returns a boolean if a field has been set.
func (o *OAuth2Client) HasAccessTokenStrategy() bool {
	if o != nil && o.AccessTokenStrategy != nil {
		return true
	}

	return false
}

// SetAccessTokenStrategy gets a reference to the given string and assigns it to the AccessTokenStrategy field.
func (o *OAuth2Client) SetAccessTokenStrategy(v string) {
	o.AccessTokenStrategy = &v
}

// GetAllowedCorsOrigins returns the AllowedCorsOrigins field value if set, zero value otherwise.
func (o *OAuth2Client) GetAllowedCorsOrigins() []string {
	if o == nil || o.AllowedCorsOrigins == nil {
		var ret []string
		return ret
	}
	return o.AllowedCorsOrigins
}

// GetAllowedCorsOriginsOk returns a tuple with the AllowedCorsOrigins field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAllowedCorsOriginsOk() ([]string, bool) {
	if o == nil || o.AllowedCorsOrigins == nil {
		return nil, false
	}
	return o.AllowedCorsOrigins, true
}

// HasAllowedCorsOrigins returns a boolean if a field has been set.
func (o *OAuth2Client) HasAllowedCorsOrigins() bool {
	if o != nil && o.AllowedCorsOrigins != nil {
		return true
	}

	return false
}

// SetAllowedCorsOrigins gets a reference to the given []string and assigns it to the AllowedCorsOrigins field.
func (o *OAuth2Client) SetAllowedCorsOrigins(v []string) {
	o.AllowedCorsOrigins = v
}

// GetAudience returns the Audience field value if set, zero value otherwise.
func (o *OAuth2Client) GetAudience() []string {
	if o == nil || o.Audience == nil {
		var ret []string
		return ret
	}
	return o.Audience
}

// GetAudienceOk returns a tuple with the Audience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAudienceOk() ([]string, bool) {
	if o == nil || o.Audience == nil {
		return nil, false
	}
	return o.Audience, true
}

// HasAudience returns a boolean if a field has been set.
func (o *OAuth2Client) HasAudience() bool {
	if o != nil && o.Audience != nil {
		return true
	}

	return false
}

// SetAudience gets a reference to the given []string and assigns it to the Audience field.
func (o *OAuth2Client) SetAudience(v []string) {
	o.Audience = v
}

// GetAuthorizationCodeGrantAccessTokenLifespan returns the AuthorizationCodeGrantAccessTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetAuthorizationCodeGrantAccessTokenLifespan() string {
	if o == nil || o.AuthorizationCodeGrantAccessTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationCodeGrantAccessTokenLifespan
}

// GetAuthorizationCodeGrantAccessTokenLifespanOk returns a tuple with the AuthorizationCodeGrantAccessTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAuthorizationCodeGrantAccessTokenLifespanOk() (*string, bool) {
	if o == nil || o.AuthorizationCodeGrantAccessTokenLifespan == nil {
		return nil, false
	}
	return o.AuthorizationCodeGrantAccessTokenLifespan, true
}

// HasAuthorizationCodeGrantAccessTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasAuthorizationCodeGrantAccessTokenLifespan() bool {
	if o != nil && o.AuthorizationCodeGrantAccessTokenLifespan != nil {
		return true
	}

	return false
}

// SetAuthorizationCodeGrantAccessTokenLifespan gets a reference to the given string and assigns it to the AuthorizationCodeGrantAccessTokenLifespan field.
func (o *OAuth2Client) SetAuthorizationCodeGrantAccessTokenLifespan(v string) {
	o.AuthorizationCodeGrantAccessTokenLifespan = &v
}

// GetAuthorizationCodeGrantIdTokenLifespan returns the AuthorizationCodeGrantIdTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetAuthorizationCodeGrantIdTokenLifespan() string {
	if o == nil || o.AuthorizationCodeGrantIdTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationCodeGrantIdTokenLifespan
}

// GetAuthorizationCodeGrantIdTokenLifespanOk returns a tuple with the AuthorizationCodeGrantIdTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAuthorizationCodeGrantIdTokenLifespanOk() (*string, bool) {
	if o == nil || o.AuthorizationCodeGrantIdTokenLifespan == nil {
		return nil, false
	}
	return o.AuthorizationCodeGrantIdTokenLifespan, true
}

// HasAuthorizationCodeGrantIdTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasAuthorizationCodeGrantIdTokenLifespan() bool {
	if o != nil && o.AuthorizationCodeGrantIdTokenLifespan != nil {
		return true
	}

	return false
}

// SetAuthorizationCodeGrantIdTokenLifespan gets a reference to the given string and assigns it to the AuthorizationCodeGrantIdTokenLifespan field.
func (o *OAuth2Client) SetAuthorizationCodeGrantIdTokenLifespan(v string) {
	o.AuthorizationCodeGrantIdTokenLifespan = &v
}

// GetAuthorizationCodeGrantRefreshTokenLifespan returns the AuthorizationCodeGrantRefreshTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetAuthorizationCodeGrantRefreshTokenLifespan() string {
	if o == nil || o.AuthorizationCodeGrantRefreshTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationCodeGrantRefreshTokenLifespan
}

// GetAuthorizationCodeGrantRefreshTokenLifespanOk returns a tuple with the AuthorizationCodeGrantRefreshTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetAuthorizationCodeGrantRefreshTokenLifespanOk() (*string, bool) {
	if o == nil || o.AuthorizationCodeGrantRefreshTokenLifespan == nil {
		return nil, false
	}
	return o.AuthorizationCodeGrantRefreshTokenLifespan, true
}

// HasAuthorizationCodeGrantRefreshTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasAuthorizationCodeGrantRefreshTokenLifespan() bool {
	if o != nil && o.AuthorizationCodeGrantRefreshTokenLifespan != nil {
		return true
	}

	return false
}

// SetAuthorizationCodeGrantRefreshTokenLifespan gets a reference to the given string and assigns it to the AuthorizationCodeGrantRefreshTokenLifespan field.
func (o *OAuth2Client) SetAuthorizationCodeGrantRefreshTokenLifespan(v string) {
	o.AuthorizationCodeGrantRefreshTokenLifespan = &v
}

// GetBackchannelLogoutSessionRequired returns the BackchannelLogoutSessionRequired field value if set, zero value otherwise.
func (o *OAuth2Client) GetBackchannelLogoutSessionRequired() bool {
	if o == nil || o.BackchannelLogoutSessionRequired == nil {
		var ret bool
		return ret
	}
	return *o.BackchannelLogoutSessionRequired
}

// GetBackchannelLogoutSessionRequiredOk returns a tuple with the BackchannelLogoutSessionRequired field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetBackchannelLogoutSessionRequiredOk() (*bool, bool) {
	if o == nil || o.BackchannelLogoutSessionRequired == nil {
		return nil, false
	}
	return o.BackchannelLogoutSessionRequired, true
}

// HasBackchannelLogoutSessionRequired returns a boolean if a field has been set.
func (o *OAuth2Client) HasBackchannelLogoutSessionRequired() bool {
	if o != nil && o.BackchannelLogoutSessionRequired != nil {
		return true
	}

	return false
}

// SetBackchannelLogoutSessionRequired gets a reference to the given bool and assigns it to the BackchannelLogoutSessionRequired field.
func (o *OAuth2Client) SetBackchannelLogoutSessionRequired(v bool) {
	o.BackchannelLogoutSessionRequired = &v
}

// GetBackchannelLogoutUri returns the BackchannelLogoutUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetBackchannelLogoutUri() string {
	if o == nil || o.BackchannelLogoutUri == nil {
		var ret string
		return ret
	}
	return *o.BackchannelLogoutUri
}

// GetBackchannelLogoutUriOk returns a tuple with the BackchannelLogoutUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetBackchannelLogoutUriOk() (*string, bool) {
	if o == nil || o.BackchannelLogoutUri == nil {
		return nil, false
	}
	return o.BackchannelLogoutUri, true
}

// HasBackchannelLogoutUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasBackchannelLogoutUri() bool {
	if o != nil && o.BackchannelLogoutUri != nil {
		return true
	}

	return false
}

// SetBackchannelLogoutUri gets a reference to the given string and assigns it to the BackchannelLogoutUri field.
func (o *OAuth2Client) SetBackchannelLogoutUri(v string) {
	o.BackchannelLogoutUri = &v
}

// GetClientCredentialsGrantAccessTokenLifespan returns the ClientCredentialsGrantAccessTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientCredentialsGrantAccessTokenLifespan() string {
	if o == nil || o.ClientCredentialsGrantAccessTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.ClientCredentialsGrantAccessTokenLifespan
}

// GetClientCredentialsGrantAccessTokenLifespanOk returns a tuple with the ClientCredentialsGrantAccessTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientCredentialsGrantAccessTokenLifespanOk() (*string, bool) {
	if o == nil || o.ClientCredentialsGrantAccessTokenLifespan == nil {
		return nil, false
	}
	return o.ClientCredentialsGrantAccessTokenLifespan, true
}

// HasClientCredentialsGrantAccessTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientCredentialsGrantAccessTokenLifespan() bool {
	if o != nil && o.ClientCredentialsGrantAccessTokenLifespan != nil {
		return true
	}

	return false
}

// SetClientCredentialsGrantAccessTokenLifespan gets a reference to the given string and assigns it to the ClientCredentialsGrantAccessTokenLifespan field.
func (o *OAuth2Client) SetClientCredentialsGrantAccessTokenLifespan(v string) {
	o.ClientCredentialsGrantAccessTokenLifespan = &v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *OAuth2Client) SetClientId(v string) {
	o.ClientId = &v
}

// GetClientName returns the ClientName field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientName() string {
	if o == nil || o.ClientName == nil {
		var ret string
		return ret
	}
	return *o.ClientName
}

// GetClientNameOk returns a tuple with the ClientName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientNameOk() (*string, bool) {
	if o == nil || o.ClientName == nil {
		return nil, false
	}
	return o.ClientName, true
}

// HasClientName returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientName() bool {
	if o != nil && o.ClientName != nil {
		return true
	}

	return false
}

// SetClientName gets a reference to the given string and assigns it to the ClientName field.
func (o *OAuth2Client) SetClientName(v string) {
	o.ClientName = &v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *OAuth2Client) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetClientSecretExpiresAt returns the ClientSecretExpiresAt field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientSecretExpiresAt() int64 {
	if o == nil || o.ClientSecretExpiresAt == nil {
		var ret int64
		return ret
	}
	return *o.ClientSecretExpiresAt
}

// GetClientSecretExpiresAtOk returns a tuple with the ClientSecretExpiresAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientSecretExpiresAtOk() (*int64, bool) {
	if o == nil || o.ClientSecretExpiresAt == nil {
		return nil, false
	}
	return o.ClientSecretExpiresAt, true
}

// HasClientSecretExpiresAt returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientSecretExpiresAt() bool {
	if o != nil && o.ClientSecretExpiresAt != nil {
		return true
	}

	return false
}

// SetClientSecretExpiresAt gets a reference to the given int64 and assigns it to the ClientSecretExpiresAt field.
func (o *OAuth2Client) SetClientSecretExpiresAt(v int64) {
	o.ClientSecretExpiresAt = &v
}

// GetClientUri returns the ClientUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetClientUri() string {
	if o == nil || o.ClientUri == nil {
		var ret string
		return ret
	}
	return *o.ClientUri
}

// GetClientUriOk returns a tuple with the ClientUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetClientUriOk() (*string, bool) {
	if o == nil || o.ClientUri == nil {
		return nil, false
	}
	return o.ClientUri, true
}

// HasClientUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasClientUri() bool {
	if o != nil && o.ClientUri != nil {
		return true
	}

	return false
}

// SetClientUri gets a reference to the given string and assigns it to the ClientUri field.
func (o *OAuth2Client) SetClientUri(v string) {
	o.ClientUri = &v
}

// GetContacts returns the Contacts field value if set, zero value otherwise.
func (o *OAuth2Client) GetContacts() []string {
	if o == nil || o.Contacts == nil {
		var ret []string
		return ret
	}
	return o.Contacts
}

// GetContactsOk returns a tuple with the Contacts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetContactsOk() ([]string, bool) {
	if o == nil || o.Contacts == nil {
		return nil, false
	}
	return o.Contacts, true
}

// HasContacts returns a boolean if a field has been set.
func (o *OAuth2Client) HasContacts() bool {
	if o != nil && o.Contacts != nil {
		return true
	}

	return false
}

// SetContacts gets a reference to the given []string and assigns it to the Contacts field.
func (o *OAuth2Client) SetContacts(v []string) {
	o.Contacts = v
}

// GetCreatedAt returns the CreatedAt field value if set, zero value otherwise.
func (o *OAuth2Client) GetCreatedAt() time.Time {
	if o == nil || o.CreatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil || o.CreatedAt == nil {
		return nil, false
	}
	return o.CreatedAt, true
}

// HasCreatedAt returns a boolean if a field has been set.
func (o *OAuth2Client) HasCreatedAt() bool {
	if o != nil && o.CreatedAt != nil {
		return true
	}

	return false
}

// SetCreatedAt gets a reference to the given time.Time and assigns it to the CreatedAt field.
func (o *OAuth2Client) SetCreatedAt(v time.Time) {
	o.CreatedAt = &v
}

// GetFrontchannelLogoutSessionRequired returns the FrontchannelLogoutSessionRequired field value if set, zero value otherwise.
func (o *OAuth2Client) GetFrontchannelLogoutSessionRequired() bool {
	if o == nil || o.FrontchannelLogoutSessionRequired == nil {
		var ret bool
		return ret
	}
	return *o.FrontchannelLogoutSessionRequired
}

// GetFrontchannelLogoutSessionRequiredOk returns a tuple with the FrontchannelLogoutSessionRequired field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetFrontchannelLogoutSessionRequiredOk() (*bool, bool) {
	if o == nil || o.FrontchannelLogoutSessionRequired == nil {
		return nil, false
	}
	return o.FrontchannelLogoutSessionRequired, true
}

// HasFrontchannelLogoutSessionRequired returns a boolean if a field has been set.
func (o *OAuth2Client) HasFrontchannelLogoutSessionRequired() bool {
	if o != nil && o.FrontchannelLogoutSessionRequired != nil {
		return true
	}

	return false
}

// SetFrontchannelLogoutSessionRequired gets a reference to the given bool and assigns it to the FrontchannelLogoutSessionRequired field.
func (o *OAuth2Client) SetFrontchannelLogoutSessionRequired(v bool) {
	o.FrontchannelLogoutSessionRequired = &v
}

// GetFrontchannelLogoutUri returns the FrontchannelLogoutUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetFrontchannelLogoutUri() string {
	if o == nil || o.FrontchannelLogoutUri == nil {
		var ret string
		return ret
	}
	return *o.FrontchannelLogoutUri
}

// GetFrontchannelLogoutUriOk returns a tuple with the FrontchannelLogoutUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetFrontchannelLogoutUriOk() (*string, bool) {
	if o == nil || o.FrontchannelLogoutUri == nil {
		return nil, false
	}
	return o.FrontchannelLogoutUri, true
}

// HasFrontchannelLogoutUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasFrontchannelLogoutUri() bool {
	if o != nil && o.FrontchannelLogoutUri != nil {
		return true
	}

	return false
}

// SetFrontchannelLogoutUri gets a reference to the given string and assigns it to the FrontchannelLogoutUri field.
func (o *OAuth2Client) SetFrontchannelLogoutUri(v string) {
	o.FrontchannelLogoutUri = &v
}

// GetGrantTypes returns the GrantTypes field value if set, zero value otherwise.
func (o *OAuth2Client) GetGrantTypes() []string {
	if o == nil || o.GrantTypes == nil {
		var ret []string
		return ret
	}
	return o.GrantTypes
}

// GetGrantTypesOk returns a tuple with the GrantTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetGrantTypesOk() ([]string, bool) {
	if o == nil || o.GrantTypes == nil {
		return nil, false
	}
	return o.GrantTypes, true
}

// HasGrantTypes returns a boolean if a field has been set.
func (o *OAuth2Client) HasGrantTypes() bool {
	if o != nil && o.GrantTypes != nil {
		return true
	}

	return false
}

// SetGrantTypes gets a reference to the given []string and assigns it to the GrantTypes field.
func (o *OAuth2Client) SetGrantTypes(v []string) {
	o.GrantTypes = v
}

// GetImplicitGrantAccessTokenLifespan returns the ImplicitGrantAccessTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetImplicitGrantAccessTokenLifespan() string {
	if o == nil || o.ImplicitGrantAccessTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.ImplicitGrantAccessTokenLifespan
}

// GetImplicitGrantAccessTokenLifespanOk returns a tuple with the ImplicitGrantAccessTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetImplicitGrantAccessTokenLifespanOk() (*string, bool) {
	if o == nil || o.ImplicitGrantAccessTokenLifespan == nil {
		return nil, false
	}
	return o.ImplicitGrantAccessTokenLifespan, true
}

// HasImplicitGrantAccessTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasImplicitGrantAccessTokenLifespan() bool {
	if o != nil && o.ImplicitGrantAccessTokenLifespan != nil {
		return true
	}

	return false
}

// SetImplicitGrantAccessTokenLifespan gets a reference to the given string and assigns it to the ImplicitGrantAccessTokenLifespan field.
func (o *OAuth2Client) SetImplicitGrantAccessTokenLifespan(v string) {
	o.ImplicitGrantAccessTokenLifespan = &v
}

// GetImplicitGrantIdTokenLifespan returns the ImplicitGrantIdTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetImplicitGrantIdTokenLifespan() string {
	if o == nil || o.ImplicitGrantIdTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.ImplicitGrantIdTokenLifespan
}

// GetImplicitGrantIdTokenLifespanOk returns a tuple with the ImplicitGrantIdTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetImplicitGrantIdTokenLifespanOk() (*string, bool) {
	if o == nil || o.ImplicitGrantIdTokenLifespan == nil {
		return nil, false
	}
	return o.ImplicitGrantIdTokenLifespan, true
}

// HasImplicitGrantIdTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasImplicitGrantIdTokenLifespan() bool {
	if o != nil && o.ImplicitGrantIdTokenLifespan != nil {
		return true
	}

	return false
}

// SetImplicitGrantIdTokenLifespan gets a reference to the given string and assigns it to the ImplicitGrantIdTokenLifespan field.
func (o *OAuth2Client) SetImplicitGrantIdTokenLifespan(v string) {
	o.ImplicitGrantIdTokenLifespan = &v
}

// GetJwks returns the Jwks field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *OAuth2Client) GetJwks() interface{} {
	if o == nil {
		var ret interface{}
		return ret
	}
	return o.Jwks
}

// GetJwksOk returns a tuple with the Jwks field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *OAuth2Client) GetJwksOk() (*interface{}, bool) {
	if o == nil || o.Jwks == nil {
		return nil, false
	}
	return &o.Jwks, true
}

// HasJwks returns a boolean if a field has been set.
func (o *OAuth2Client) HasJwks() bool {
	if o != nil && o.Jwks != nil {
		return true
	}

	return false
}

// SetJwks gets a reference to the given interface{} and assigns it to the Jwks field.
func (o *OAuth2Client) SetJwks(v interface{}) {
	o.Jwks = v
}

// GetJwksUri returns the JwksUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetJwksUri() string {
	if o == nil || o.JwksUri == nil {
		var ret string
		return ret
	}
	return *o.JwksUri
}

// GetJwksUriOk returns a tuple with the JwksUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetJwksUriOk() (*string, bool) {
	if o == nil || o.JwksUri == nil {
		return nil, false
	}
	return o.JwksUri, true
}

// HasJwksUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasJwksUri() bool {
	if o != nil && o.JwksUri != nil {
		return true
	}

	return false
}

// SetJwksUri gets a reference to the given string and assigns it to the JwksUri field.
func (o *OAuth2Client) SetJwksUri(v string) {
	o.JwksUri = &v
}

// GetJwtBearerGrantAccessTokenLifespan returns the JwtBearerGrantAccessTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetJwtBearerGrantAccessTokenLifespan() string {
	if o == nil || o.JwtBearerGrantAccessTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.JwtBearerGrantAccessTokenLifespan
}

// GetJwtBearerGrantAccessTokenLifespanOk returns a tuple with the JwtBearerGrantAccessTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetJwtBearerGrantAccessTokenLifespanOk() (*string, bool) {
	if o == nil || o.JwtBearerGrantAccessTokenLifespan == nil {
		return nil, false
	}
	return o.JwtBearerGrantAccessTokenLifespan, true
}

// HasJwtBearerGrantAccessTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasJwtBearerGrantAccessTokenLifespan() bool {
	if o != nil && o.JwtBearerGrantAccessTokenLifespan != nil {
		return true
	}

	return false
}

// SetJwtBearerGrantAccessTokenLifespan gets a reference to the given string and assigns it to the JwtBearerGrantAccessTokenLifespan field.
func (o *OAuth2Client) SetJwtBearerGrantAccessTokenLifespan(v string) {
	o.JwtBearerGrantAccessTokenLifespan = &v
}

// GetLogoUri returns the LogoUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetLogoUri() string {
	if o == nil || o.LogoUri == nil {
		var ret string
		return ret
	}
	return *o.LogoUri
}

// GetLogoUriOk returns a tuple with the LogoUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetLogoUriOk() (*string, bool) {
	if o == nil || o.LogoUri == nil {
		return nil, false
	}
	return o.LogoUri, true
}

// HasLogoUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasLogoUri() bool {
	if o != nil && o.LogoUri != nil {
		return true
	}

	return false
}

// SetLogoUri gets a reference to the given string and assigns it to the LogoUri field.
func (o *OAuth2Client) SetLogoUri(v string) {
	o.LogoUri = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *OAuth2Client) GetMetadata() interface{} {
	if o == nil {
		var ret interface{}
		return ret
	}
	return o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *OAuth2Client) GetMetadataOk() (*interface{}, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return &o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *OAuth2Client) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given interface{} and assigns it to the Metadata field.
func (o *OAuth2Client) SetMetadata(v interface{}) {
	o.Metadata = v
}

// GetOwner returns the Owner field value if set, zero value otherwise.
func (o *OAuth2Client) GetOwner() string {
	if o == nil || o.Owner == nil {
		var ret string
		return ret
	}
	return *o.Owner
}

// GetOwnerOk returns a tuple with the Owner field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetOwnerOk() (*string, bool) {
	if o == nil || o.Owner == nil {
		return nil, false
	}
	return o.Owner, true
}

// HasOwner returns a boolean if a field has been set.
func (o *OAuth2Client) HasOwner() bool {
	if o != nil && o.Owner != nil {
		return true
	}

	return false
}

// SetOwner gets a reference to the given string and assigns it to the Owner field.
func (o *OAuth2Client) SetOwner(v string) {
	o.Owner = &v
}

// GetPolicyUri returns the PolicyUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetPolicyUri() string {
	if o == nil || o.PolicyUri == nil {
		var ret string
		return ret
	}
	return *o.PolicyUri
}

// GetPolicyUriOk returns a tuple with the PolicyUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetPolicyUriOk() (*string, bool) {
	if o == nil || o.PolicyUri == nil {
		return nil, false
	}
	return o.PolicyUri, true
}

// HasPolicyUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasPolicyUri() bool {
	if o != nil && o.PolicyUri != nil {
		return true
	}

	return false
}

// SetPolicyUri gets a reference to the given string and assigns it to the PolicyUri field.
func (o *OAuth2Client) SetPolicyUri(v string) {
	o.PolicyUri = &v
}

// GetPostLogoutRedirectUris returns the PostLogoutRedirectUris field value if set, zero value otherwise.
func (o *OAuth2Client) GetPostLogoutRedirectUris() []string {
	if o == nil || o.PostLogoutRedirectUris == nil {
		var ret []string
		return ret
	}
	return o.PostLogoutRedirectUris
}

// GetPostLogoutRedirectUrisOk returns a tuple with the PostLogoutRedirectUris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetPostLogoutRedirectUrisOk() ([]string, bool) {
	if o == nil || o.PostLogoutRedirectUris == nil {
		return nil, false
	}
	return o.PostLogoutRedirectUris, true
}

// HasPostLogoutRedirectUris returns a boolean if a field has been set.
func (o *OAuth2Client) HasPostLogoutRedirectUris() bool {
	if o != nil && o.PostLogoutRedirectUris != nil {
		return true
	}

	return false
}

// SetPostLogoutRedirectUris gets a reference to the given []string and assigns it to the PostLogoutRedirectUris field.
func (o *OAuth2Client) SetPostLogoutRedirectUris(v []string) {
	o.PostLogoutRedirectUris = v
}

// GetRedirectUris returns the RedirectUris field value if set, zero value otherwise.
func (o *OAuth2Client) GetRedirectUris() []string {
	if o == nil || o.RedirectUris == nil {
		var ret []string
		return ret
	}
	return o.RedirectUris
}

// GetRedirectUrisOk returns a tuple with the RedirectUris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRedirectUrisOk() ([]string, bool) {
	if o == nil || o.RedirectUris == nil {
		return nil, false
	}
	return o.RedirectUris, true
}

// HasRedirectUris returns a boolean if a field has been set.
func (o *OAuth2Client) HasRedirectUris() bool {
	if o != nil && o.RedirectUris != nil {
		return true
	}

	return false
}

// SetRedirectUris gets a reference to the given []string and assigns it to the RedirectUris field.
func (o *OAuth2Client) SetRedirectUris(v []string) {
	o.RedirectUris = v
}

// GetRefreshTokenGrantAccessTokenLifespan returns the RefreshTokenGrantAccessTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetRefreshTokenGrantAccessTokenLifespan() string {
	if o == nil || o.RefreshTokenGrantAccessTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.RefreshTokenGrantAccessTokenLifespan
}

// GetRefreshTokenGrantAccessTokenLifespanOk returns a tuple with the RefreshTokenGrantAccessTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRefreshTokenGrantAccessTokenLifespanOk() (*string, bool) {
	if o == nil || o.RefreshTokenGrantAccessTokenLifespan == nil {
		return nil, false
	}
	return o.RefreshTokenGrantAccessTokenLifespan, true
}

// HasRefreshTokenGrantAccessTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasRefreshTokenGrantAccessTokenLifespan() bool {
	if o != nil && o.RefreshTokenGrantAccessTokenLifespan != nil {
		return true
	}

	return false
}

// SetRefreshTokenGrantAccessTokenLifespan gets a reference to the given string and assigns it to the RefreshTokenGrantAccessTokenLifespan field.
func (o *OAuth2Client) SetRefreshTokenGrantAccessTokenLifespan(v string) {
	o.RefreshTokenGrantAccessTokenLifespan = &v
}

// GetRefreshTokenGrantIdTokenLifespan returns the RefreshTokenGrantIdTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetRefreshTokenGrantIdTokenLifespan() string {
	if o == nil || o.RefreshTokenGrantIdTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.RefreshTokenGrantIdTokenLifespan
}

// GetRefreshTokenGrantIdTokenLifespanOk returns a tuple with the RefreshTokenGrantIdTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRefreshTokenGrantIdTokenLifespanOk() (*string, bool) {
	if o == nil || o.RefreshTokenGrantIdTokenLifespan == nil {
		return nil, false
	}
	return o.RefreshTokenGrantIdTokenLifespan, true
}

// HasRefreshTokenGrantIdTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasRefreshTokenGrantIdTokenLifespan() bool {
	if o != nil && o.RefreshTokenGrantIdTokenLifespan != nil {
		return true
	}

	return false
}

// SetRefreshTokenGrantIdTokenLifespan gets a reference to the given string and assigns it to the RefreshTokenGrantIdTokenLifespan field.
func (o *OAuth2Client) SetRefreshTokenGrantIdTokenLifespan(v string) {
	o.RefreshTokenGrantIdTokenLifespan = &v
}

// GetRefreshTokenGrantRefreshTokenLifespan returns the RefreshTokenGrantRefreshTokenLifespan field value if set, zero value otherwise.
func (o *OAuth2Client) GetRefreshTokenGrantRefreshTokenLifespan() string {
	if o == nil || o.RefreshTokenGrantRefreshTokenLifespan == nil {
		var ret string
		return ret
	}
	return *o.RefreshTokenGrantRefreshTokenLifespan
}

// GetRefreshTokenGrantRefreshTokenLifespanOk returns a tuple with the RefreshTokenGrantRefreshTokenLifespan field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRefreshTokenGrantRefreshTokenLifespanOk() (*string, bool) {
	if o == nil || o.RefreshTokenGrantRefreshTokenLifespan == nil {
		return nil, false
	}
	return o.RefreshTokenGrantRefreshTokenLifespan, true
}

// HasRefreshTokenGrantRefreshTokenLifespan returns a boolean if a field has been set.
func (o *OAuth2Client) HasRefreshTokenGrantRefreshTokenLifespan() bool {
	if o != nil && o.RefreshTokenGrantRefreshTokenLifespan != nil {
		return true
	}

	return false
}

// SetRefreshTokenGrantRefreshTokenLifespan gets a reference to the given string and assigns it to the RefreshTokenGrantRefreshTokenLifespan field.
func (o *OAuth2Client) SetRefreshTokenGrantRefreshTokenLifespan(v string) {
	o.RefreshTokenGrantRefreshTokenLifespan = &v
}

// GetRegistrationAccessToken returns the RegistrationAccessToken field value if set, zero value otherwise.
func (o *OAuth2Client) GetRegistrationAccessToken() string {
	if o == nil || o.RegistrationAccessToken == nil {
		var ret string
		return ret
	}
	return *o.RegistrationAccessToken
}

// GetRegistrationAccessTokenOk returns a tuple with the RegistrationAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRegistrationAccessTokenOk() (*string, bool) {
	if o == nil || o.RegistrationAccessToken == nil {
		return nil, false
	}
	return o.RegistrationAccessToken, true
}

// HasRegistrationAccessToken returns a boolean if a field has been set.
func (o *OAuth2Client) HasRegistrationAccessToken() bool {
	if o != nil && o.RegistrationAccessToken != nil {
		return true
	}

	return false
}

// SetRegistrationAccessToken gets a reference to the given string and assigns it to the RegistrationAccessToken field.
func (o *OAuth2Client) SetRegistrationAccessToken(v string) {
	o.RegistrationAccessToken = &v
}

// GetRegistrationClientUri returns the RegistrationClientUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetRegistrationClientUri() string {
	if o == nil || o.RegistrationClientUri == nil {
		var ret string
		return ret
	}
	return *o.RegistrationClientUri
}

// GetRegistrationClientUriOk returns a tuple with the RegistrationClientUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRegistrationClientUriOk() (*string, bool) {
	if o == nil || o.RegistrationClientUri == nil {
		return nil, false
	}
	return o.RegistrationClientUri, true
}

// HasRegistrationClientUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasRegistrationClientUri() bool {
	if o != nil && o.RegistrationClientUri != nil {
		return true
	}

	return false
}

// SetRegistrationClientUri gets a reference to the given string and assigns it to the RegistrationClientUri field.
func (o *OAuth2Client) SetRegistrationClientUri(v string) {
	o.RegistrationClientUri = &v
}

// GetRequestObjectSigningAlg returns the RequestObjectSigningAlg field value if set, zero value otherwise.
func (o *OAuth2Client) GetRequestObjectSigningAlg() string {
	if o == nil || o.RequestObjectSigningAlg == nil {
		var ret string
		return ret
	}
	return *o.RequestObjectSigningAlg
}

// GetRequestObjectSigningAlgOk returns a tuple with the RequestObjectSigningAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRequestObjectSigningAlgOk() (*string, bool) {
	if o == nil || o.RequestObjectSigningAlg == nil {
		return nil, false
	}
	return o.RequestObjectSigningAlg, true
}

// HasRequestObjectSigningAlg returns a boolean if a field has been set.
func (o *OAuth2Client) HasRequestObjectSigningAlg() bool {
	if o != nil && o.RequestObjectSigningAlg != nil {
		return true
	}

	return false
}

// SetRequestObjectSigningAlg gets a reference to the given string and assigns it to the RequestObjectSigningAlg field.
func (o *OAuth2Client) SetRequestObjectSigningAlg(v string) {
	o.RequestObjectSigningAlg = &v
}

// GetRequestUris returns the RequestUris field value if set, zero value otherwise.
func (o *OAuth2Client) GetRequestUris() []string {
	if o == nil || o.RequestUris == nil {
		var ret []string
		return ret
	}
	return o.RequestUris
}

// GetRequestUrisOk returns a tuple with the RequestUris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetRequestUrisOk() ([]string, bool) {
	if o == nil || o.RequestUris == nil {
		return nil, false
	}
	return o.RequestUris, true
}

// HasRequestUris returns a boolean if a field has been set.
func (o *OAuth2Client) HasRequestUris() bool {
	if o != nil && o.RequestUris != nil {
		return true
	}

	return false
}

// SetRequestUris gets a reference to the given []string and assigns it to the RequestUris field.
func (o *OAuth2Client) SetRequestUris(v []string) {
	o.RequestUris = v
}

// GetResponseTypes returns the ResponseTypes field value if set, zero value otherwise.
func (o *OAuth2Client) GetResponseTypes() []string {
	if o == nil || o.ResponseTypes == nil {
		var ret []string
		return ret
	}
	return o.ResponseTypes
}

// GetResponseTypesOk returns a tuple with the ResponseTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetResponseTypesOk() ([]string, bool) {
	if o == nil || o.ResponseTypes == nil {
		return nil, false
	}
	return o.ResponseTypes, true
}

// HasResponseTypes returns a boolean if a field has been set.
func (o *OAuth2Client) HasResponseTypes() bool {
	if o != nil && o.ResponseTypes != nil {
		return true
	}

	return false
}

// SetResponseTypes gets a reference to the given []string and assigns it to the ResponseTypes field.
func (o *OAuth2Client) SetResponseTypes(v []string) {
	o.ResponseTypes = v
}

// GetScope returns the Scope field value if set, zero value otherwise.
func (o *OAuth2Client) GetScope() string {
	if o == nil || o.Scope == nil {
		var ret string
		return ret
	}
	return *o.Scope
}

// GetScopeOk returns a tuple with the Scope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetScopeOk() (*string, bool) {
	if o == nil || o.Scope == nil {
		return nil, false
	}
	return o.Scope, true
}

// HasScope returns a boolean if a field has been set.
func (o *OAuth2Client) HasScope() bool {
	if o != nil && o.Scope != nil {
		return true
	}

	return false
}

// SetScope gets a reference to the given string and assigns it to the Scope field.
func (o *OAuth2Client) SetScope(v string) {
	o.Scope = &v
}

// GetSectorIdentifierUri returns the SectorIdentifierUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetSectorIdentifierUri() string {
	if o == nil || o.SectorIdentifierUri == nil {
		var ret string
		return ret
	}
	return *o.SectorIdentifierUri
}

// GetSectorIdentifierUriOk returns a tuple with the SectorIdentifierUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetSectorIdentifierUriOk() (*string, bool) {
	if o == nil || o.SectorIdentifierUri == nil {
		return nil, false
	}
	return o.SectorIdentifierUri, true
}

// HasSectorIdentifierUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasSectorIdentifierUri() bool {
	if o != nil && o.SectorIdentifierUri != nil {
		return true
	}

	return false
}

// SetSectorIdentifierUri gets a reference to the given string and assigns it to the SectorIdentifierUri field.
func (o *OAuth2Client) SetSectorIdentifierUri(v string) {
	o.SectorIdentifierUri = &v
}

// GetSkipConsent returns the SkipConsent field value if set, zero value otherwise.
func (o *OAuth2Client) GetSkipConsent() bool {
	if o == nil || o.SkipConsent == nil {
		var ret bool
		return ret
	}
	return *o.SkipConsent
}

// GetSkipConsentOk returns a tuple with the SkipConsent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetSkipConsentOk() (*bool, bool) {
	if o == nil || o.SkipConsent == nil {
		return nil, false
	}
	return o.SkipConsent, true
}

// HasSkipConsent returns a boolean if a field has been set.
func (o *OAuth2Client) HasSkipConsent() bool {
	if o != nil && o.SkipConsent != nil {
		return true
	}

	return false
}

// SetSkipConsent gets a reference to the given bool and assigns it to the SkipConsent field.
func (o *OAuth2Client) SetSkipConsent(v bool) {
	o.SkipConsent = &v
}

// GetSkipLogoutConsent returns the SkipLogoutConsent field value if set, zero value otherwise.
func (o *OAuth2Client) GetSkipLogoutConsent() bool {
	if o == nil || o.SkipLogoutConsent == nil {
		var ret bool
		return ret
	}
	return *o.SkipLogoutConsent
}

// GetSkipLogoutConsentOk returns a tuple with the SkipLogoutConsent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetSkipLogoutConsentOk() (*bool, bool) {
	if o == nil || o.SkipLogoutConsent == nil {
		return nil, false
	}
	return o.SkipLogoutConsent, true
}

// HasSkipLogoutConsent returns a boolean if a field has been set.
func (o *OAuth2Client) HasSkipLogoutConsent() bool {
	if o != nil && o.SkipLogoutConsent != nil {
		return true
	}

	return false
}

// SetSkipLogoutConsent gets a reference to the given bool and assigns it to the SkipLogoutConsent field.
func (o *OAuth2Client) SetSkipLogoutConsent(v bool) {
	o.SkipLogoutConsent = &v
}

// GetSubjectType returns the SubjectType field value if set, zero value otherwise.
func (o *OAuth2Client) GetSubjectType() string {
	if o == nil || o.SubjectType == nil {
		var ret string
		return ret
	}
	return *o.SubjectType
}

// GetSubjectTypeOk returns a tuple with the SubjectType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetSubjectTypeOk() (*string, bool) {
	if o == nil || o.SubjectType == nil {
		return nil, false
	}
	return o.SubjectType, true
}

// HasSubjectType returns a boolean if a field has been set.
func (o *OAuth2Client) HasSubjectType() bool {
	if o != nil && o.SubjectType != nil {
		return true
	}

	return false
}

// SetSubjectType gets a reference to the given string and assigns it to the SubjectType field.
func (o *OAuth2Client) SetSubjectType(v string) {
	o.SubjectType = &v
}

// GetTokenEndpointAuthMethod returns the TokenEndpointAuthMethod field value if set, zero value otherwise.
func (o *OAuth2Client) GetTokenEndpointAuthMethod() string {
	if o == nil || o.TokenEndpointAuthMethod == nil {
		var ret string
		return ret
	}
	return *o.TokenEndpointAuthMethod
}

// GetTokenEndpointAuthMethodOk returns a tuple with the TokenEndpointAuthMethod field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetTokenEndpointAuthMethodOk() (*string, bool) {
	if o == nil || o.TokenEndpointAuthMethod == nil {
		return nil, false
	}
	return o.TokenEndpointAuthMethod, true
}

// HasTokenEndpointAuthMethod returns a boolean if a field has been set.
func (o *OAuth2Client) HasTokenEndpointAuthMethod() bool {
	if o != nil && o.TokenEndpointAuthMethod != nil {
		return true
	}

	return false
}

// SetTokenEndpointAuthMethod gets a reference to the given string and assigns it to the TokenEndpointAuthMethod field.
func (o *OAuth2Client) SetTokenEndpointAuthMethod(v string) {
	o.TokenEndpointAuthMethod = &v
}

// GetTokenEndpointAuthSigningAlg returns the TokenEndpointAuthSigningAlg field value if set, zero value otherwise.
func (o *OAuth2Client) GetTokenEndpointAuthSigningAlg() string {
	if o == nil || o.TokenEndpointAuthSigningAlg == nil {
		var ret string
		return ret
	}
	return *o.TokenEndpointAuthSigningAlg
}

// GetTokenEndpointAuthSigningAlgOk returns a tuple with the TokenEndpointAuthSigningAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetTokenEndpointAuthSigningAlgOk() (*string, bool) {
	if o == nil || o.TokenEndpointAuthSigningAlg == nil {
		return nil, false
	}
	return o.TokenEndpointAuthSigningAlg, true
}

// HasTokenEndpointAuthSigningAlg returns a boolean if a field has been set.
func (o *OAuth2Client) HasTokenEndpointAuthSigningAlg() bool {
	if o != nil && o.TokenEndpointAuthSigningAlg != nil {
		return true
	}

	return false
}

// SetTokenEndpointAuthSigningAlg gets a reference to the given string and assigns it to the TokenEndpointAuthSigningAlg field.
func (o *OAuth2Client) SetTokenEndpointAuthSigningAlg(v string) {
	o.TokenEndpointAuthSigningAlg = &v
}

// GetTosUri returns the TosUri field value if set, zero value otherwise.
func (o *OAuth2Client) GetTosUri() string {
	if o == nil || o.TosUri == nil {
		var ret string
		return ret
	}
	return *o.TosUri
}

// GetTosUriOk returns a tuple with the TosUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetTosUriOk() (*string, bool) {
	if o == nil || o.TosUri == nil {
		return nil, false
	}
	return o.TosUri, true
}

// HasTosUri returns a boolean if a field has been set.
func (o *OAuth2Client) HasTosUri() bool {
	if o != nil && o.TosUri != nil {
		return true
	}

	return false
}

// SetTosUri gets a reference to the given string and assigns it to the TosUri field.
func (o *OAuth2Client) SetTosUri(v string) {
	o.TosUri = &v
}

// GetUpdatedAt returns the UpdatedAt field value if set, zero value otherwise.
func (o *OAuth2Client) GetUpdatedAt() time.Time {
	if o == nil || o.UpdatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetUpdatedAtOk() (*time.Time, bool) {
	if o == nil || o.UpdatedAt == nil {
		return nil, false
	}
	return o.UpdatedAt, true
}

// HasUpdatedAt returns a boolean if a field has been set.
func (o *OAuth2Client) HasUpdatedAt() bool {
	if o != nil && o.UpdatedAt != nil {
		return true
	}

	return false
}

// SetUpdatedAt gets a reference to the given time.Time and assigns it to the UpdatedAt field.
func (o *OAuth2Client) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = &v
}

// GetUserinfoSignedResponseAlg returns the UserinfoSignedResponseAlg field value if set, zero value otherwise.
func (o *OAuth2Client) GetUserinfoSignedResponseAlg() string {
	if o == nil || o.UserinfoSignedResponseAlg == nil {
		var ret string
		return ret
	}
	return *o.UserinfoSignedResponseAlg
}

// GetUserinfoSignedResponseAlgOk returns a tuple with the UserinfoSignedResponseAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OAuth2Client) GetUserinfoSignedResponseAlgOk() (*string, bool) {
	if o == nil || o.UserinfoSignedResponseAlg == nil {
		return nil, false
	}
	return o.UserinfoSignedResponseAlg, true
}

// HasUserinfoSignedResponseAlg returns a boolean if a field has been set.
func (o *OAuth2Client) HasUserinfoSignedResponseAlg() bool {
	if o != nil && o.UserinfoSignedResponseAlg != nil {
		return true
	}

	return false
}

// SetUserinfoSignedResponseAlg gets a reference to the given string and assigns it to the UserinfoSignedResponseAlg field.
func (o *OAuth2Client) SetUserinfoSignedResponseAlg(v string) {
	o.UserinfoSignedResponseAlg = &v
}

func (o OAuth2Client) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessTokenStrategy != nil {
		toSerialize["access_token_strategy"] = o.AccessTokenStrategy
	}
	if o.AllowedCorsOrigins != nil {
		toSerialize["allowed_cors_origins"] = o.AllowedCorsOrigins
	}
	if o.Audience != nil {
		toSerialize["audience"] = o.Audience
	}
	if o.AuthorizationCodeGrantAccessTokenLifespan != nil {
		toSerialize["authorization_code_grant_access_token_lifespan"] = o.AuthorizationCodeGrantAccessTokenLifespan
	}
	if o.AuthorizationCodeGrantIdTokenLifespan != nil {
		toSerialize["authorization_code_grant_id_token_lifespan"] = o.AuthorizationCodeGrantIdTokenLifespan
	}
	if o.AuthorizationCodeGrantRefreshTokenLifespan != nil {
		toSerialize["authorization_code_grant_refresh_token_lifespan"] = o.AuthorizationCodeGrantRefreshTokenLifespan
	}
	if o.BackchannelLogoutSessionRequired != nil {
		toSerialize["backchannel_logout_session_required"] = o.BackchannelLogoutSessionRequired
	}
	if o.BackchannelLogoutUri != nil {
		toSerialize["backchannel_logout_uri"] = o.BackchannelLogoutUri
	}
	if o.ClientCredentialsGrantAccessTokenLifespan != nil {
		toSerialize["client_credentials_grant_access_token_lifespan"] = o.ClientCredentialsGrantAccessTokenLifespan
	}
	if o.ClientId != nil {
		toSerialize["client_id"] = o.ClientId
	}
	if o.ClientName != nil {
		toSerialize["client_name"] = o.ClientName
	}
	if o.ClientSecret != nil {
		toSerialize["client_secret"] = o.ClientSecret
	}
	if o.ClientSecretExpiresAt != nil {
		toSerialize["client_secret_expires_at"] = o.ClientSecretExpiresAt
	}
	if o.ClientUri != nil {
		toSerialize["client_uri"] = o.ClientUri
	}
	if o.Contacts != nil {
		toSerialize["contacts"] = o.Contacts
	}
	if o.CreatedAt != nil {
		toSerialize["created_at"] = o.CreatedAt
	}
	if o.FrontchannelLogoutSessionRequired != nil {
		toSerialize["frontchannel_logout_session_required"] = o.FrontchannelLogoutSessionRequired
	}
	if o.FrontchannelLogoutUri != nil {
		toSerialize["frontchannel_logout_uri"] = o.FrontchannelLogoutUri
	}
	if o.GrantTypes != nil {
		toSerialize["grant_types"] = o.GrantTypes
	}
	if o.ImplicitGrantAccessTokenLifespan != nil {
		toSerialize["implicit_grant_access_token_lifespan"] = o.ImplicitGrantAccessTokenLifespan
	}
	if o.ImplicitGrantIdTokenLifespan != nil {
		toSerialize["implicit_grant_id_token_lifespan"] = o.ImplicitGrantIdTokenLifespan
	}
	if o.Jwks != nil {
		toSerialize["jwks"] = o.Jwks
	}
	if o.JwksUri != nil {
		toSerialize["jwks_uri"] = o.JwksUri
	}
	if o.JwtBearerGrantAccessTokenLifespan != nil {
		toSerialize["jwt_bearer_grant_access_token_lifespan"] = o.JwtBearerGrantAccessTokenLifespan
	}
	if o.LogoUri != nil {
		toSerialize["logo_uri"] = o.LogoUri
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if o.Owner != nil {
		toSerialize["owner"] = o.Owner
	}
	if o.PolicyUri != nil {
		toSerialize["policy_uri"] = o.PolicyUri
	}
	if o.PostLogoutRedirectUris != nil {
		toSerialize["post_logout_redirect_uris"] = o.PostLogoutRedirectUris
	}
	if o.RedirectUris != nil {
		toSerialize["redirect_uris"] = o.RedirectUris
	}
	if o.RefreshTokenGrantAccessTokenLifespan != nil {
		toSerialize["refresh_token_grant_access_token_lifespan"] = o.RefreshTokenGrantAccessTokenLifespan
	}
	if o.RefreshTokenGrantIdTokenLifespan != nil {
		toSerialize["refresh_token_grant_id_token_lifespan"] = o.RefreshTokenGrantIdTokenLifespan
	}
	if o.RefreshTokenGrantRefreshTokenLifespan != nil {
		toSerialize["refresh_token_grant_refresh_token_lifespan"] = o.RefreshTokenGrantRefreshTokenLifespan
	}
	if o.RegistrationAccessToken != nil {
		toSerialize["registration_access_token"] = o.RegistrationAccessToken
	}
	if o.RegistrationClientUri != nil {
		toSerialize["registration_client_uri"] = o.RegistrationClientUri
	}
	if o.RequestObjectSigningAlg != nil {
		toSerialize["request_object_signing_alg"] = o.RequestObjectSigningAlg
	}
	if o.RequestUris != nil {
		toSerialize["request_uris"] = o.RequestUris
	}
	if o.ResponseTypes != nil {
		toSerialize["response_types"] = o.ResponseTypes
	}
	if o.Scope != nil {
		toSerialize["scope"] = o.Scope
	}
	if o.SectorIdentifierUri != nil {
		toSerialize["sector_identifier_uri"] = o.SectorIdentifierUri
	}
	if o.SkipConsent != nil {
		toSerialize["skip_consent"] = o.SkipConsent
	}
	if o.SkipLogoutConsent != nil {
		toSerialize["skip_logout_consent"] = o.SkipLogoutConsent
	}
	if o.SubjectType != nil {
		toSerialize["subject_type"] = o.SubjectType
	}
	if o.TokenEndpointAuthMethod != nil {
		toSerialize["token_endpoint_auth_method"] = o.TokenEndpointAuthMethod
	}
	if o.TokenEndpointAuthSigningAlg != nil {
		toSerialize["token_endpoint_auth_signing_alg"] = o.TokenEndpointAuthSigningAlg
	}
	if o.TosUri != nil {
		toSerialize["tos_uri"] = o.TosUri
	}
	if o.UpdatedAt != nil {
		toSerialize["updated_at"] = o.UpdatedAt
	}
	if o.UserinfoSignedResponseAlg != nil {
		toSerialize["userinfo_signed_response_alg"] = o.UserinfoSignedResponseAlg
	}
	return json.Marshal(toSerialize)
}

type NullableOAuth2Client struct {
	value *OAuth2Client
	isSet bool
}

func (v NullableOAuth2Client) Get() *OAuth2Client {
	return v.value
}

func (v *NullableOAuth2Client) Set(val *OAuth2Client) {
	v.value = val
	v.isSet = true
}

func (v NullableOAuth2Client) IsSet() bool {
	return v.isSet
}

func (v *NullableOAuth2Client) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOAuth2Client(val *OAuth2Client) *NullableOAuth2Client {
	return &NullableOAuth2Client{value: val, isSet: true}
}

func (v NullableOAuth2Client) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOAuth2Client) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
