/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
	"fmt"
)

// LoginFlowState The experimental state represents the state of a login flow. This field is EXPERIMENTAL and subject to change!
type LoginFlowState string

// List of loginFlowState
const (
	LOGINFLOWSTATE_CHOOSE_METHOD    LoginFlowState = "choose_method"
	LOGINFLOWSTATE_SENT_EMAIL       LoginFlowState = "sent_email"
	LOGINFLOWSTATE_PASSED_CHALLENGE LoginFlowState = "passed_challenge"
)

func (v *LoginFlowState) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := LoginFlowState(value)
	for _, existing := range []LoginFlowState{"choose_method", "sent_email", "passed_challenge"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid LoginFlowState", value)
}

// Ptr returns reference to loginFlowState value
func (v LoginFlowState) Ptr() *LoginFlowState {
	return &v
}

type NullableLoginFlowState struct {
	value *LoginFlowState
	isSet bool
}

func (v NullableLoginFlowState) Get() *LoginFlowState {
	return v.value
}

func (v *NullableLoginFlowState) Set(val *LoginFlowState) {
	v.value = val
	v.isSet = true
}

func (v NullableLoginFlowState) IsSet() bool {
	return v.isSet
}

func (v *NullableLoginFlowState) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLoginFlowState(val *LoginFlowState) *NullableLoginFlowState {
	return &NullableLoginFlowState{value: val, isSet: true}
}

func (v NullableLoginFlowState) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLoginFlowState) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
