/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
)

// Linger please
var (
	_ context.Context
)

type FrontendAPI interface {

	/*
			 * CreateBrowserLoginFlow Create Login Flow for Browsers
			 * This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate
		cookies and anti-CSRF measures required for browser-based flows.

		If this endpoint is opened as a link in the browser, it will be redirected to
		`selfservice.flows.login.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
		exists already, the browser will be redirected to `urls.default_redirect_url` unless the query parameter
		`?refresh=true` was set.

		If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

		The optional query parameter login_challenge is set when using Kratos with
		Hydra in an OAuth2 flow. See the oauth2_provider.url configuration
		option.

		This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserLoginFlowRequest
	*/
	CreateBrowserLoginFlow(ctx context.Context) FrontendAPIApiCreateBrowserLoginFlowRequest

	/*
	 * CreateBrowserLoginFlowExecute executes the request
	 * @return LoginFlow
	 */
	CreateBrowserLoginFlowExecute(r FrontendAPIApiCreateBrowserLoginFlowRequest) (*LoginFlow, *http.Response, error)

	/*
			 * CreateBrowserLogoutFlow Create a Logout URL for Browsers
			 * This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.

		This endpoint is NOT INTENDED for API clients and only works
		with browsers (Chrome, Firefox, ...). For API clients you can
		call the `/self-service/logout/api` URL directly with the Ory Session Token.

		The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns
		a 401 error.

		When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserLogoutFlowRequest
	*/
	CreateBrowserLogoutFlow(ctx context.Context) FrontendAPIApiCreateBrowserLogoutFlowRequest

	/*
	 * CreateBrowserLogoutFlowExecute executes the request
	 * @return LogoutFlow
	 */
	CreateBrowserLogoutFlowExecute(r FrontendAPIApiCreateBrowserLogoutFlowRequest) (*LogoutFlow, *http.Response, error)

	/*
			 * CreateBrowserRecoveryFlow Create Recovery Flow for Browsers
			 * This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to
		`selfservice.flows.recovery.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
		exists, the browser is returned to the configured return URL.

		If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects
		or a 400 bad request error if the user is already authenticated.

		This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

		More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserRecoveryFlowRequest
	*/
	CreateBrowserRecoveryFlow(ctx context.Context) FrontendAPIApiCreateBrowserRecoveryFlowRequest

	/*
	 * CreateBrowserRecoveryFlowExecute executes the request
	 * @return RecoveryFlow
	 */
	CreateBrowserRecoveryFlowExecute(r FrontendAPIApiCreateBrowserRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error)

	/*
			 * CreateBrowserRegistrationFlow Create Registration Flow for Browsers
			 * This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate
		cookies and anti-CSRF measures required for browser-based flows.

		If this endpoint is opened as a link in the browser, it will be redirected to
		`selfservice.flows.registration.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
		exists already, the browser will be redirected to `urls.default_redirect_url`.

		If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

		If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.

		This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserRegistrationFlowRequest
	*/
	CreateBrowserRegistrationFlow(ctx context.Context) FrontendAPIApiCreateBrowserRegistrationFlowRequest

	/*
	 * CreateBrowserRegistrationFlowExecute executes the request
	 * @return RegistrationFlow
	 */
	CreateBrowserRegistrationFlowExecute(r FrontendAPIApiCreateBrowserRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error)

	/*
			 * CreateBrowserSettingsFlow Create Settings Flow for Browsers
			 * This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to
		`selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid
		Ory Kratos Session Cookie is included in the request, a login flow will be initialized.

		If this endpoint is opened as a link in the browser, it will be redirected to
		`selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid user session
		was set, the browser will be redirected to the login endpoint.

		If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects
		or a 401 forbidden error if no valid session was set.

		Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
		Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
		credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
		to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.

		If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`session_inactive`: No Ory Session was found - sign in a user first.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

		This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

		More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserSettingsFlowRequest
	*/
	CreateBrowserSettingsFlow(ctx context.Context) FrontendAPIApiCreateBrowserSettingsFlowRequest

	/*
	 * CreateBrowserSettingsFlowExecute executes the request
	 * @return SettingsFlow
	 */
	CreateBrowserSettingsFlowExecute(r FrontendAPIApiCreateBrowserSettingsFlowRequest) (*SettingsFlow, *http.Response, error)

	/*
			 * CreateBrowserVerificationFlow Create Verification Flow for Browser Clients
			 * This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to
		`selfservice.flows.verification.ui_url` with the flow ID set as the query parameter `?flow=`.

		If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.

		This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).

		More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateBrowserVerificationFlowRequest
	*/
	CreateBrowserVerificationFlow(ctx context.Context) FrontendAPIApiCreateBrowserVerificationFlowRequest

	/*
	 * CreateBrowserVerificationFlowExecute executes the request
	 * @return VerificationFlow
	 */
	CreateBrowserVerificationFlowExecute(r FrontendAPIApiCreateBrowserVerificationFlowRequest) (*VerificationFlow, *http.Response, error)

	/*
			 * CreateNativeLoginFlow Create Login Flow for Native Apps
			 * This endpoint initiates a login flow for native apps that do not use a browser, such as mobile devices, smart TVs, and so on.

		If a valid provided session cookie or session token is provided, a 400 Bad Request error
		will be returned unless the URL query parameter `?refresh=true` is set.

		To fetch an existing login flow call `/self-service/login/flows?flow=<flow_id>`.

		You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
		Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
		you vulnerable to a variety of CSRF attacks, including CSRF login attacks.

		In the case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.

		This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateNativeLoginFlowRequest
	*/
	CreateNativeLoginFlow(ctx context.Context) FrontendAPIApiCreateNativeLoginFlowRequest

	/*
	 * CreateNativeLoginFlowExecute executes the request
	 * @return LoginFlow
	 */
	CreateNativeLoginFlowExecute(r FrontendAPIApiCreateNativeLoginFlowRequest) (*LoginFlow, *http.Response, error)

	/*
			 * CreateNativeRecoveryFlow Create Recovery Flow for Native Apps
			 * This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.

		If a valid provided session cookie or session token is provided, a 400 Bad Request error.

		On an existing recovery flow, use the `getRecoveryFlow` API endpoint.

		You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
		Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
		you vulnerable to a variety of CSRF attacks.

		This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

		More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateNativeRecoveryFlowRequest
	*/
	CreateNativeRecoveryFlow(ctx context.Context) FrontendAPIApiCreateNativeRecoveryFlowRequest

	/*
	 * CreateNativeRecoveryFlowExecute executes the request
	 * @return RecoveryFlow
	 */
	CreateNativeRecoveryFlowExecute(r FrontendAPIApiCreateNativeRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error)

	/*
			 * CreateNativeRegistrationFlow Create Registration Flow for Native Apps
			 * This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.

		If a valid provided session cookie or session token is provided, a 400 Bad Request error
		will be returned unless the URL query parameter `?refresh=true` is set.

		To fetch an existing registration flow call `/self-service/registration/flows?flow=<flow_id>`.

		You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
		Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
		you vulnerable to a variety of CSRF attacks.

		In the case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.

		This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateNativeRegistrationFlowRequest
	*/
	CreateNativeRegistrationFlow(ctx context.Context) FrontendAPIApiCreateNativeRegistrationFlowRequest

	/*
	 * CreateNativeRegistrationFlowExecute executes the request
	 * @return RegistrationFlow
	 */
	CreateNativeRegistrationFlowExecute(r FrontendAPIApiCreateNativeRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error)

	/*
			 * CreateNativeSettingsFlow Create Settings Flow for Native Apps
			 * This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on.
		You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.

		To fetch an existing settings flow call `/self-service/settings/flows?flow=<flow_id>`.

		You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
		Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
		you vulnerable to a variety of CSRF attacks.

		Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
		Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
		credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
		to sign in with the second factor or change the configuration.

		In the case of an error, the `error.id` of the JSON response body can be one of:

		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`session_inactive`: No Ory Session was found - sign in a user first.

		This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

		More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateNativeSettingsFlowRequest
	*/
	CreateNativeSettingsFlow(ctx context.Context) FrontendAPIApiCreateNativeSettingsFlowRequest

	/*
	 * CreateNativeSettingsFlowExecute executes the request
	 * @return SettingsFlow
	 */
	CreateNativeSettingsFlowExecute(r FrontendAPIApiCreateNativeSettingsFlowRequest) (*SettingsFlow, *http.Response, error)

	/*
			 * CreateNativeVerificationFlow Create Verification Flow for Native Apps
			 * This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.

		To fetch an existing verification flow call `/self-service/verification/flows?flow=<flow_id>`.

		You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
		Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
		you vulnerable to a variety of CSRF attacks.

		This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

		More information can be found at [Ory Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiCreateNativeVerificationFlowRequest
	*/
	CreateNativeVerificationFlow(ctx context.Context) FrontendAPIApiCreateNativeVerificationFlowRequest

	/*
	 * CreateNativeVerificationFlowExecute executes the request
	 * @return VerificationFlow
	 */
	CreateNativeVerificationFlowExecute(r FrontendAPIApiCreateNativeVerificationFlowRequest) (*VerificationFlow, *http.Response, error)

	/*
			 * DisableMyOtherSessions Disable my other sessions
			 * Calling this endpoint invalidates all except the current session that belong to the logged-in user.
		Session data are not deleted.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiDisableMyOtherSessionsRequest
	*/
	DisableMyOtherSessions(ctx context.Context) FrontendAPIApiDisableMyOtherSessionsRequest

	/*
	 * DisableMyOtherSessionsExecute executes the request
	 * @return DeleteMySessionsCount
	 */
	DisableMyOtherSessionsExecute(r FrontendAPIApiDisableMyOtherSessionsRequest) (*DeleteMySessionsCount, *http.Response, error)

	/*
			 * DisableMySession Disable one of my sessions
			 * Calling this endpoint invalidates the specified session. The current session cannot be revoked.
		Session data are not deleted.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param id ID is the session's ID.
			 * @return FrontendAPIApiDisableMySessionRequest
	*/
	DisableMySession(ctx context.Context, id string) FrontendAPIApiDisableMySessionRequest

	/*
	 * DisableMySessionExecute executes the request
	 */
	DisableMySessionExecute(r FrontendAPIApiDisableMySessionRequest) (*http.Response, error)

	/*
	 * ExchangeSessionToken Exchange Session Token
	 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return FrontendAPIApiExchangeSessionTokenRequest
	 */
	ExchangeSessionToken(ctx context.Context) FrontendAPIApiExchangeSessionTokenRequest

	/*
	 * ExchangeSessionTokenExecute executes the request
	 * @return SuccessfulNativeLogin
	 */
	ExchangeSessionTokenExecute(r FrontendAPIApiExchangeSessionTokenRequest) (*SuccessfulNativeLogin, *http.Response, error)

	/*
			 * GetFlowError Get User-Flow Errors
			 * This endpoint returns the error associated with a user-facing self service errors.

		This endpoint supports stub values to help you implement the error UI:

		`?id=stub:500` - returns a stub 500 (Internal Server Error) error.

		More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetFlowErrorRequest
	*/
	GetFlowError(ctx context.Context) FrontendAPIApiGetFlowErrorRequest

	/*
	 * GetFlowErrorExecute executes the request
	 * @return FlowError
	 */
	GetFlowErrorExecute(r FrontendAPIApiGetFlowErrorRequest) (*FlowError, *http.Response, error)

	/*
			 * GetLoginFlow Get Login Flow
			 * This endpoint returns a login flow's context with, for example, error details and other information.

		Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
		For AJAX requests you must ensure that cookies are included in the request or requests will fail.

		If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
		and you need to forward the incoming HTTP Cookie header to this endpoint:

		```js
		pseudo-code example
		router.get('/login', async function (req, res) {
		const flow = await client.getLoginFlow(req.header('cookie'), req.query['flow'])

		res.render('login', flow)
		})
		```

		This request may fail due to several reasons. The `error.id` can be one of:

		`session_already_available`: The user is already signed in.
		`self_service_flow_expired`: The flow is expired and you should request a new one.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetLoginFlowRequest
	*/
	GetLoginFlow(ctx context.Context) FrontendAPIApiGetLoginFlowRequest

	/*
	 * GetLoginFlowExecute executes the request
	 * @return LoginFlow
	 */
	GetLoginFlowExecute(r FrontendAPIApiGetLoginFlowRequest) (*LoginFlow, *http.Response, error)

	/*
			 * GetRecoveryFlow Get Recovery Flow
			 * This endpoint returns a recovery flow's context with, for example, error details and other information.

		Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
		For AJAX requests you must ensure that cookies are included in the request or requests will fail.

		If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
		and you need to forward the incoming HTTP Cookie header to this endpoint:

		```js
		pseudo-code example
		router.get('/recovery', async function (req, res) {
		const flow = await client.getRecoveryFlow(req.header('Cookie'), req.query['flow'])

		res.render('recovery', flow)
		})
		```

		More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetRecoveryFlowRequest
	*/
	GetRecoveryFlow(ctx context.Context) FrontendAPIApiGetRecoveryFlowRequest

	/*
	 * GetRecoveryFlowExecute executes the request
	 * @return RecoveryFlow
	 */
	GetRecoveryFlowExecute(r FrontendAPIApiGetRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error)

	/*
			 * GetRegistrationFlow Get Registration Flow
			 * This endpoint returns a registration flow's context with, for example, error details and other information.

		Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
		For AJAX requests you must ensure that cookies are included in the request or requests will fail.

		If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
		and you need to forward the incoming HTTP Cookie header to this endpoint:

		```js
		pseudo-code example
		router.get('/registration', async function (req, res) {
		const flow = await client.getRegistrationFlow(req.header('cookie'), req.query['flow'])

		res.render('registration', flow)
		})
		```

		This request may fail due to several reasons. The `error.id` can be one of:

		`session_already_available`: The user is already signed in.
		`self_service_flow_expired`: The flow is expired and you should request a new one.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetRegistrationFlowRequest
	*/
	GetRegistrationFlow(ctx context.Context) FrontendAPIApiGetRegistrationFlowRequest

	/*
	 * GetRegistrationFlowExecute executes the request
	 * @return RegistrationFlow
	 */
	GetRegistrationFlowExecute(r FrontendAPIApiGetRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error)

	/*
			 * GetSettingsFlow Get Settings Flow
			 * When accessing this endpoint through Ory Kratos' Public API you must ensure that either the Ory Kratos Session Cookie
		or the Ory Kratos Session Token are set.

		Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
		Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
		credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
		to sign in with the second factor or change the configuration.

		You can access this endpoint without credentials when using Ory Kratos' Admin API.

		If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`session_inactive`: No Ory Session was found - sign in a user first.
		`security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
		identity logged in instead.

		More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetSettingsFlowRequest
	*/
	GetSettingsFlow(ctx context.Context) FrontendAPIApiGetSettingsFlowRequest

	/*
	 * GetSettingsFlowExecute executes the request
	 * @return SettingsFlow
	 */
	GetSettingsFlowExecute(r FrontendAPIApiGetSettingsFlowRequest) (*SettingsFlow, *http.Response, error)

	/*
			 * GetVerificationFlow Get Verification Flow
			 * This endpoint returns a verification flow's context with, for example, error details and other information.

		Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
		For AJAX requests you must ensure that cookies are included in the request or requests will fail.

		If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
		and you need to forward the incoming HTTP Cookie header to this endpoint:

		```js
		pseudo-code example
		router.get('/recovery', async function (req, res) {
		const flow = await client.getVerificationFlow(req.header('cookie'), req.query['flow'])

		res.render('verification', flow)
		})
		```

		More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetVerificationFlowRequest
	*/
	GetVerificationFlow(ctx context.Context) FrontendAPIApiGetVerificationFlowRequest

	/*
	 * GetVerificationFlowExecute executes the request
	 * @return VerificationFlow
	 */
	GetVerificationFlowExecute(r FrontendAPIApiGetVerificationFlowRequest) (*VerificationFlow, *http.Response, error)

	/*
			 * GetWebAuthnJavaScript Get WebAuthn JavaScript
			 * This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.

		If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:

		```html
		<script src="https://public-kratos.example.org/.well-known/ory/webauthn.js" type="script" async />
		```

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiGetWebAuthnJavaScriptRequest
	*/
	GetWebAuthnJavaScript(ctx context.Context) FrontendAPIApiGetWebAuthnJavaScriptRequest

	/*
	 * GetWebAuthnJavaScriptExecute executes the request
	 * @return string
	 */
	GetWebAuthnJavaScriptExecute(r FrontendAPIApiGetWebAuthnJavaScriptRequest) (string, *http.Response, error)

	/*
			 * ListMySessions Get My Active Sessions
			 * This endpoints returns all other active sessions that belong to the logged-in user.
		The current session can be retrieved by calling the `/sessions/whoami` endpoint.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiListMySessionsRequest
	*/
	ListMySessions(ctx context.Context) FrontendAPIApiListMySessionsRequest

	/*
	 * ListMySessionsExecute executes the request
	 * @return []Session
	 */
	ListMySessionsExecute(r FrontendAPIApiListMySessionsRequest) ([]Session, *http.Response, error)

	/*
			 * PerformNativeLogout Perform Logout for Native Apps
			 * Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully
		revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when
		the Ory Session Token has been revoked already before.

		If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.

		This endpoint does not remove any HTTP
		Cookies - use the Browser-Based Self-Service Logout Flow instead.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiPerformNativeLogoutRequest
	*/
	PerformNativeLogout(ctx context.Context) FrontendAPIApiPerformNativeLogoutRequest

	/*
	 * PerformNativeLogoutExecute executes the request
	 */
	PerformNativeLogoutExecute(r FrontendAPIApiPerformNativeLogoutRequest) (*http.Response, error)

	/*
			 * ToSession Check Who the Current HTTP Session Belongs To
			 * Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated.
		Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent.
		When the request it successful it adds the user ID to the 'X-Kratos-Authenticated-Identity-Id' header
		in the response.

		If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:

		```js
		pseudo-code example
		router.get('/protected-endpoint', async function (req, res) {
		const session = await client.toSession(undefined, req.header('cookie'))

		console.log(session)
		})
		```

		When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:

		```js
		pseudo-code example
		...
		const session = await client.toSession("the-session-token")

		console.log(session)
		```

		When using a token template, the token is included in the `tokenized` field of the session.

		```js
		pseudo-code example
		...
		const session = await client.toSession("the-session-token", { tokenize_as: "example-jwt-template" })

		console.log(session.tokenized) // The JWT
		```

		Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator
		Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
		credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
		to sign in with the second factor or change the configuration.

		This endpoint is useful for:

		AJAX calls. Remember to send credentials and set up CORS correctly!
		Reverse proxies and API Gateways
		Server-side calls - use the `X-Session-Token` header!

		This endpoint authenticates users by checking:

		if the `Cookie` HTTP header was set containing an Ory Kratos Session Cookie;
		if the `Authorization: bearer <ory-session-token>` HTTP header was set with a valid Ory Kratos Session Token;
		if the `X-Session-Token` HTTP header was set with a valid Ory Kratos Session Token.

		If none of these headers are set or the cookie or token are invalid, the endpoint returns a HTTP 401 status code.

		As explained above, this request may fail due to several reasons. The `error.id` can be one of:

		`session_inactive`: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token).
		`session_aal2_required`: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiToSessionRequest
	*/
	ToSession(ctx context.Context) FrontendAPIApiToSessionRequest

	/*
	 * ToSessionExecute executes the request
	 * @return Session
	 */
	ToSessionExecute(r FrontendAPIApiToSessionRequest) (*Session, *http.Response, error)

	/*
			 * UpdateLoginFlow Submit a Login Flow
			 * Use this endpoint to complete a login flow. This endpoint
		behaves differently for API and browser flows.

		API flows expect `application/json` to be sent in the body and responds with
		HTTP 200 and a application/json body with the session token on success;
		HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
		HTTP 400 on form validation errors.

		Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
		a HTTP 303 redirect to the post/after login URL or the `return_to` value if it was set and if the login succeeded;
		a HTTP 303 redirect to the login UI URL with the flow ID containing the validation errors otherwise.

		Browser flows with an accept header of `application/json` will not redirect but instead respond with
		HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
		HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
		HTTP 400 on form validation errors.

		If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
		`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
		Most likely used in Social Sign In flows.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateLoginFlowRequest
	*/
	UpdateLoginFlow(ctx context.Context) FrontendAPIApiUpdateLoginFlowRequest

	/*
	 * UpdateLoginFlowExecute executes the request
	 * @return SuccessfulNativeLogin
	 */
	UpdateLoginFlowExecute(r FrontendAPIApiUpdateLoginFlowRequest) (*SuccessfulNativeLogin, *http.Response, error)

	/*
			 * UpdateLogoutFlow Update Logout Flow
			 * This endpoint logs out an identity in a self-service manner.

		If the `Accept` HTTP header is not set to `application/json`, the browser will be redirected (HTTP 303 See Other)
		to the `return_to` parameter of the initial request or fall back to `urls.default_return_to`.

		If the `Accept` HTTP header is set to `application/json`, a 204 No Content response
		will be sent on successful logout instead.

		This endpoint is NOT INTENDED for API clients and only works
		with browsers (Chrome, Firefox, ...). For API clients you can
		call the `/self-service/logout/api` URL directly with the Ory Session Token.

		More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateLogoutFlowRequest
	*/
	UpdateLogoutFlow(ctx context.Context) FrontendAPIApiUpdateLogoutFlowRequest

	/*
	 * UpdateLogoutFlowExecute executes the request
	 */
	UpdateLogoutFlowExecute(r FrontendAPIApiUpdateLogoutFlowRequest) (*http.Response, error)

	/*
			 * UpdateRecoveryFlow Update Recovery Flow
			 * Use this endpoint to update a recovery flow. This endpoint
		behaves differently for API and browser flows and has several states:

		`choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
		and works with API- and Browser-initiated flows.
		For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid.
		and a HTTP 303 See Other redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired).
		For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Recovery UI URL with the Recovery Flow ID appended.
		`sent_email` is the success state after `choose_method` for the `link` method and allows the user to request another recovery email. It
		works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
		`passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a recovery link")
		does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
		(if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with
		a new Recovery Flow ID which contains an error message that the recovery link was invalid.

		More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateRecoveryFlowRequest
	*/
	UpdateRecoveryFlow(ctx context.Context) FrontendAPIApiUpdateRecoveryFlowRequest

	/*
	 * UpdateRecoveryFlowExecute executes the request
	 * @return RecoveryFlow
	 */
	UpdateRecoveryFlowExecute(r FrontendAPIApiUpdateRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error)

	/*
			 * UpdateRegistrationFlow Update Registration Flow
			 * Use this endpoint to complete a registration flow by sending an identity's traits and password. This endpoint
		behaves differently for API and browser flows.

		API flows expect `application/json` to be sent in the body and respond with
		HTTP 200 and a application/json body with the created identity success - if the session hook is configured the
		`session` and `session_token` will also be included;
		HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
		HTTP 400 on form validation errors.

		Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
		a HTTP 303 redirect to the post/after registration URL or the `return_to` value if it was set and if the registration succeeded;
		a HTTP 303 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.

		Browser flows with an accept header of `application/json` will not redirect but instead respond with
		HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
		HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
		HTTP 400 on form validation errors.

		If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`session_already_available`: The user is already signed in.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
		`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
		Most likely used in Social Sign In flows.

		More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateRegistrationFlowRequest
	*/
	UpdateRegistrationFlow(ctx context.Context) FrontendAPIApiUpdateRegistrationFlowRequest

	/*
	 * UpdateRegistrationFlowExecute executes the request
	 * @return SuccessfulNativeRegistration
	 */
	UpdateRegistrationFlowExecute(r FrontendAPIApiUpdateRegistrationFlowRequest) (*SuccessfulNativeRegistration, *http.Response, error)

	/*
			 * UpdateSettingsFlow Complete Settings Flow
			 * Use this endpoint to complete a settings flow by sending an identity's updated password. This endpoint
		behaves differently for API and browser flows.

		API-initiated flows expect `application/json` to be sent in the body and respond with
		HTTP 200 and an application/json body with the session token on success;
		HTTP 303 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set;
		HTTP 400 on form validation errors.
		HTTP 401 when the endpoint is called without a valid session token.
		HTTP 403 when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
		Implies that the user needs to re-authenticate.

		Browser flows without HTTP Header `Accept` or with `Accept: text/*` respond with
		a HTTP 303 redirect to the post/after settings URL or the `return_to` value if it was set and if the flow succeeded;
		a HTTP 303 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise.
		a HTTP 303 redirect to the login endpoint when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.

		Browser flows with HTTP Header `Accept: application/json` respond with
		HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
		HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
		HTTP 401 when the endpoint is called without a valid session cookie.
		HTTP 403 when the page is accessed without a session cookie or the session's AAL is too low.
		HTTP 400 on form validation errors.

		Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
		Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
		credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
		to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.

		If this endpoint is called with a `Accept: application/json` HTTP header, the response contains the flow without a redirect. In the
		case of an error, the `error.id` of the JSON response body can be one of:

		`session_refresh_required`: The identity requested to change something that needs a privileged session. Redirect
		the identity to the login init endpoint with query parameters `?refresh=true&return_to=<the-current-browser-url>`,
		or initiate a refresh login flow otherwise.
		`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
		`session_inactive`: No Ory Session was found - sign in a user first.
		`security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
		identity logged in instead.
		`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
		`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
		Most likely used in Social Sign In flows.

		More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateSettingsFlowRequest
	*/
	UpdateSettingsFlow(ctx context.Context) FrontendAPIApiUpdateSettingsFlowRequest

	/*
	 * UpdateSettingsFlowExecute executes the request
	 * @return SettingsFlow
	 */
	UpdateSettingsFlowExecute(r FrontendAPIApiUpdateSettingsFlowRequest) (*SettingsFlow, *http.Response, error)

	/*
			 * UpdateVerificationFlow Complete Verification Flow
			 * Use this endpoint to complete a verification flow. This endpoint
		behaves differently for API and browser flows and has several states:

		`choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
		and works with API- and Browser-initiated flows.
		For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid
		and a HTTP 303 See Other redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired).
		For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Verification UI URL with the Verification Flow ID appended.
		`sent_email` is the success state after `choose_method` when using the `link` method and allows the user to request another verification email. It
		works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
		`passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a verification link")
		does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
		(if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with
		a new Verification Flow ID which contains an error message that the verification link was invalid.

		More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
			 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return FrontendAPIApiUpdateVerificationFlowRequest
	*/
	UpdateVerificationFlow(ctx context.Context) FrontendAPIApiUpdateVerificationFlowRequest

	/*
	 * UpdateVerificationFlowExecute executes the request
	 * @return VerificationFlow
	 */
	UpdateVerificationFlowExecute(r FrontendAPIApiUpdateVerificationFlowRequest) (*VerificationFlow, *http.Response, error)
}

// FrontendAPIService FrontendAPI service
type FrontendAPIService service

type FrontendAPIApiCreateBrowserLoginFlowRequest struct {
	ctx            context.Context
	ApiService     FrontendAPI
	refresh        *bool
	aal            *string
	returnTo       *string
	cookie         *string
	loginChallenge *string
	organization   *string
	via            *string
}

func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Refresh(refresh bool) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.refresh = &refresh
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Aal(aal string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.aal = &aal
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Cookie(cookie string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.cookie = &cookie
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) LoginChallenge(loginChallenge string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.loginChallenge = &loginChallenge
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Organization(organization string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.organization = &organization
	return r
}
func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Via(via string) FrontendAPIApiCreateBrowserLoginFlowRequest {
	r.via = &via
	return r
}

func (r FrontendAPIApiCreateBrowserLoginFlowRequest) Execute() (*LoginFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserLoginFlowExecute(r)
}

/*
  - CreateBrowserLoginFlow Create Login Flow for Browsers
  - This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate

cookies and anti-CSRF measures required for browser-based flows.

If this endpoint is opened as a link in the browser, it will be redirected to
`selfservice.flows.login.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
exists already, the browser will be redirected to `urls.default_redirect_url` unless the query parameter
`?refresh=true` was set.

If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

The optional query parameter login_challenge is set when using Kratos with
Hydra in an OAuth2 flow. See the oauth2_provider.url configuration
option.

This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserLoginFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserLoginFlow(ctx context.Context) FrontendAPIApiCreateBrowserLoginFlowRequest {
	return FrontendAPIApiCreateBrowserLoginFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return LoginFlow
 */
func (a *FrontendAPIService) CreateBrowserLoginFlowExecute(r FrontendAPIApiCreateBrowserLoginFlowRequest) (*LoginFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *LoginFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserLoginFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/login/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.refresh != nil {
		localVarQueryParams.Add("refresh", parameterToString(*r.refresh, ""))
	}
	if r.aal != nil {
		localVarQueryParams.Add("aal", parameterToString(*r.aal, ""))
	}
	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	if r.loginChallenge != nil {
		localVarQueryParams.Add("login_challenge", parameterToString(*r.loginChallenge, ""))
	}
	if r.organization != nil {
		localVarQueryParams.Add("organization", parameterToString(*r.organization, ""))
	}
	if r.via != nil {
		localVarQueryParams.Add("via", parameterToString(*r.via, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateBrowserLogoutFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	cookie     *string
	returnTo   *string
}

func (r FrontendAPIApiCreateBrowserLogoutFlowRequest) Cookie(cookie string) FrontendAPIApiCreateBrowserLogoutFlowRequest {
	r.cookie = &cookie
	return r
}
func (r FrontendAPIApiCreateBrowserLogoutFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserLogoutFlowRequest {
	r.returnTo = &returnTo
	return r
}

func (r FrontendAPIApiCreateBrowserLogoutFlowRequest) Execute() (*LogoutFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserLogoutFlowExecute(r)
}

/*
  - CreateBrowserLogoutFlow Create a Logout URL for Browsers
  - This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.

This endpoint is NOT INTENDED for API clients and only works
with browsers (Chrome, Firefox, ...). For API clients you can
call the `/self-service/logout/api` URL directly with the Ory Session Token.

The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns
a 401 error.

When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserLogoutFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserLogoutFlow(ctx context.Context) FrontendAPIApiCreateBrowserLogoutFlowRequest {
	return FrontendAPIApiCreateBrowserLogoutFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return LogoutFlow
 */
func (a *FrontendAPIService) CreateBrowserLogoutFlowExecute(r FrontendAPIApiCreateBrowserLogoutFlowRequest) (*LogoutFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *LogoutFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserLogoutFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/logout/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 500 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateBrowserRecoveryFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	returnTo   *string
}

func (r FrontendAPIApiCreateBrowserRecoveryFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserRecoveryFlowRequest {
	r.returnTo = &returnTo
	return r
}

func (r FrontendAPIApiCreateBrowserRecoveryFlowRequest) Execute() (*RecoveryFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserRecoveryFlowExecute(r)
}

/*
  - CreateBrowserRecoveryFlow Create Recovery Flow for Browsers
  - This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to

`selfservice.flows.recovery.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
exists, the browser is returned to the configured return URL.

If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects
or a 400 bad request error if the user is already authenticated.

This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserRecoveryFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserRecoveryFlow(ctx context.Context) FrontendAPIApiCreateBrowserRecoveryFlowRequest {
	return FrontendAPIApiCreateBrowserRecoveryFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RecoveryFlow
 */
func (a *FrontendAPIService) CreateBrowserRecoveryFlowExecute(r FrontendAPIApiCreateBrowserRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RecoveryFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserRecoveryFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/recovery/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateBrowserRegistrationFlowRequest struct {
	ctx                       context.Context
	ApiService                FrontendAPI
	returnTo                  *string
	loginChallenge            *string
	afterVerificationReturnTo *string
	organization              *string
}

func (r FrontendAPIApiCreateBrowserRegistrationFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserRegistrationFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiCreateBrowserRegistrationFlowRequest) LoginChallenge(loginChallenge string) FrontendAPIApiCreateBrowserRegistrationFlowRequest {
	r.loginChallenge = &loginChallenge
	return r
}
func (r FrontendAPIApiCreateBrowserRegistrationFlowRequest) AfterVerificationReturnTo(afterVerificationReturnTo string) FrontendAPIApiCreateBrowserRegistrationFlowRequest {
	r.afterVerificationReturnTo = &afterVerificationReturnTo
	return r
}
func (r FrontendAPIApiCreateBrowserRegistrationFlowRequest) Organization(organization string) FrontendAPIApiCreateBrowserRegistrationFlowRequest {
	r.organization = &organization
	return r
}

func (r FrontendAPIApiCreateBrowserRegistrationFlowRequest) Execute() (*RegistrationFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserRegistrationFlowExecute(r)
}

/*
  - CreateBrowserRegistrationFlow Create Registration Flow for Browsers
  - This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate

cookies and anti-CSRF measures required for browser-based flows.

If this endpoint is opened as a link in the browser, it will be redirected to
`selfservice.flows.registration.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
exists already, the browser will be redirected to `urls.default_redirect_url`.

If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.

This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserRegistrationFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserRegistrationFlow(ctx context.Context) FrontendAPIApiCreateBrowserRegistrationFlowRequest {
	return FrontendAPIApiCreateBrowserRegistrationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RegistrationFlow
 */
func (a *FrontendAPIService) CreateBrowserRegistrationFlowExecute(r FrontendAPIApiCreateBrowserRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RegistrationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserRegistrationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/registration/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	if r.loginChallenge != nil {
		localVarQueryParams.Add("login_challenge", parameterToString(*r.loginChallenge, ""))
	}
	if r.afterVerificationReturnTo != nil {
		localVarQueryParams.Add("after_verification_return_to", parameterToString(*r.afterVerificationReturnTo, ""))
	}
	if r.organization != nil {
		localVarQueryParams.Add("organization", parameterToString(*r.organization, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateBrowserSettingsFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	returnTo   *string
	cookie     *string
}

func (r FrontendAPIApiCreateBrowserSettingsFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserSettingsFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiCreateBrowserSettingsFlowRequest) Cookie(cookie string) FrontendAPIApiCreateBrowserSettingsFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiCreateBrowserSettingsFlowRequest) Execute() (*SettingsFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserSettingsFlowExecute(r)
}

/*
  - CreateBrowserSettingsFlow Create Settings Flow for Browsers
  - This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to

`selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid
Ory Kratos Session Cookie is included in the request, a login flow will be initialized.

If this endpoint is opened as a link in the browser, it will be redirected to
`selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid user session
was set, the browser will be redirected to the login endpoint.

If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects
or a 401 forbidden error if no valid session was set.

Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.

If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`session_inactive`: No Ory Session was found - sign in a user first.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!

This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.

More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserSettingsFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserSettingsFlow(ctx context.Context) FrontendAPIApiCreateBrowserSettingsFlowRequest {
	return FrontendAPIApiCreateBrowserSettingsFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SettingsFlow
 */
func (a *FrontendAPIService) CreateBrowserSettingsFlowExecute(r FrontendAPIApiCreateBrowserSettingsFlowRequest) (*SettingsFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SettingsFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserSettingsFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/settings/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateBrowserVerificationFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	returnTo   *string
}

func (r FrontendAPIApiCreateBrowserVerificationFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateBrowserVerificationFlowRequest {
	r.returnTo = &returnTo
	return r
}

func (r FrontendAPIApiCreateBrowserVerificationFlowRequest) Execute() (*VerificationFlow, *http.Response, error) {
	return r.ApiService.CreateBrowserVerificationFlowExecute(r)
}

/*
  - CreateBrowserVerificationFlow Create Verification Flow for Browser Clients
  - This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to

`selfservice.flows.verification.ui_url` with the flow ID set as the query parameter `?flow=`.

If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.

This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).

More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateBrowserVerificationFlowRequest
*/
func (a *FrontendAPIService) CreateBrowserVerificationFlow(ctx context.Context) FrontendAPIApiCreateBrowserVerificationFlowRequest {
	return FrontendAPIApiCreateBrowserVerificationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return VerificationFlow
 */
func (a *FrontendAPIService) CreateBrowserVerificationFlowExecute(r FrontendAPIApiCreateBrowserVerificationFlowRequest) (*VerificationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *VerificationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateBrowserVerificationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/verification/browser"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateNativeLoginFlowRequest struct {
	ctx                            context.Context
	ApiService                     FrontendAPI
	refresh                        *bool
	aal                            *string
	xSessionToken                  *string
	returnSessionTokenExchangeCode *bool
	returnTo                       *string
	organization                   *string
	via                            *string
}

func (r FrontendAPIApiCreateNativeLoginFlowRequest) Refresh(refresh bool) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.refresh = &refresh
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) Aal(aal string) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.aal = &aal
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) XSessionToken(xSessionToken string) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) ReturnSessionTokenExchangeCode(returnSessionTokenExchangeCode bool) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.returnSessionTokenExchangeCode = &returnSessionTokenExchangeCode
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) Organization(organization string) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.organization = &organization
	return r
}
func (r FrontendAPIApiCreateNativeLoginFlowRequest) Via(via string) FrontendAPIApiCreateNativeLoginFlowRequest {
	r.via = &via
	return r
}

func (r FrontendAPIApiCreateNativeLoginFlowRequest) Execute() (*LoginFlow, *http.Response, error) {
	return r.ApiService.CreateNativeLoginFlowExecute(r)
}

/*
  - CreateNativeLoginFlow Create Login Flow for Native Apps
  - This endpoint initiates a login flow for native apps that do not use a browser, such as mobile devices, smart TVs, and so on.

If a valid provided session cookie or session token is provided, a 400 Bad Request error
will be returned unless the URL query parameter `?refresh=true` is set.

To fetch an existing login flow call `/self-service/login/flows?flow=<flow_id>`.

You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
you vulnerable to a variety of CSRF attacks, including CSRF login attacks.

In the case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.

This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateNativeLoginFlowRequest
*/
func (a *FrontendAPIService) CreateNativeLoginFlow(ctx context.Context) FrontendAPIApiCreateNativeLoginFlowRequest {
	return FrontendAPIApiCreateNativeLoginFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return LoginFlow
 */
func (a *FrontendAPIService) CreateNativeLoginFlowExecute(r FrontendAPIApiCreateNativeLoginFlowRequest) (*LoginFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *LoginFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateNativeLoginFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/login/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.refresh != nil {
		localVarQueryParams.Add("refresh", parameterToString(*r.refresh, ""))
	}
	if r.aal != nil {
		localVarQueryParams.Add("aal", parameterToString(*r.aal, ""))
	}
	if r.returnSessionTokenExchangeCode != nil {
		localVarQueryParams.Add("return_session_token_exchange_code", parameterToString(*r.returnSessionTokenExchangeCode, ""))
	}
	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	if r.organization != nil {
		localVarQueryParams.Add("organization", parameterToString(*r.organization, ""))
	}
	if r.via != nil {
		localVarQueryParams.Add("via", parameterToString(*r.via, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateNativeRecoveryFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
}

func (r FrontendAPIApiCreateNativeRecoveryFlowRequest) Execute() (*RecoveryFlow, *http.Response, error) {
	return r.ApiService.CreateNativeRecoveryFlowExecute(r)
}

/*
  - CreateNativeRecoveryFlow Create Recovery Flow for Native Apps
  - This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.

If a valid provided session cookie or session token is provided, a 400 Bad Request error.

On an existing recovery flow, use the `getRecoveryFlow` API endpoint.

You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
you vulnerable to a variety of CSRF attacks.

This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateNativeRecoveryFlowRequest
*/
func (a *FrontendAPIService) CreateNativeRecoveryFlow(ctx context.Context) FrontendAPIApiCreateNativeRecoveryFlowRequest {
	return FrontendAPIApiCreateNativeRecoveryFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RecoveryFlow
 */
func (a *FrontendAPIService) CreateNativeRecoveryFlowExecute(r FrontendAPIApiCreateNativeRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RecoveryFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateNativeRecoveryFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/recovery/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateNativeRegistrationFlowRequest struct {
	ctx                            context.Context
	ApiService                     FrontendAPI
	returnSessionTokenExchangeCode *bool
	returnTo                       *string
	organization                   *string
}

func (r FrontendAPIApiCreateNativeRegistrationFlowRequest) ReturnSessionTokenExchangeCode(returnSessionTokenExchangeCode bool) FrontendAPIApiCreateNativeRegistrationFlowRequest {
	r.returnSessionTokenExchangeCode = &returnSessionTokenExchangeCode
	return r
}
func (r FrontendAPIApiCreateNativeRegistrationFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateNativeRegistrationFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiCreateNativeRegistrationFlowRequest) Organization(organization string) FrontendAPIApiCreateNativeRegistrationFlowRequest {
	r.organization = &organization
	return r
}

func (r FrontendAPIApiCreateNativeRegistrationFlowRequest) Execute() (*RegistrationFlow, *http.Response, error) {
	return r.ApiService.CreateNativeRegistrationFlowExecute(r)
}

/*
  - CreateNativeRegistrationFlow Create Registration Flow for Native Apps
  - This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.

If a valid provided session cookie or session token is provided, a 400 Bad Request error
will be returned unless the URL query parameter `?refresh=true` is set.

To fetch an existing registration flow call `/self-service/registration/flows?flow=<flow_id>`.

You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
you vulnerable to a variety of CSRF attacks.

In the case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.

This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateNativeRegistrationFlowRequest
*/
func (a *FrontendAPIService) CreateNativeRegistrationFlow(ctx context.Context) FrontendAPIApiCreateNativeRegistrationFlowRequest {
	return FrontendAPIApiCreateNativeRegistrationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RegistrationFlow
 */
func (a *FrontendAPIService) CreateNativeRegistrationFlowExecute(r FrontendAPIApiCreateNativeRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RegistrationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateNativeRegistrationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/registration/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnSessionTokenExchangeCode != nil {
		localVarQueryParams.Add("return_session_token_exchange_code", parameterToString(*r.returnSessionTokenExchangeCode, ""))
	}
	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	if r.organization != nil {
		localVarQueryParams.Add("organization", parameterToString(*r.organization, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateNativeSettingsFlowRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	xSessionToken *string
}

func (r FrontendAPIApiCreateNativeSettingsFlowRequest) XSessionToken(xSessionToken string) FrontendAPIApiCreateNativeSettingsFlowRequest {
	r.xSessionToken = &xSessionToken
	return r
}

func (r FrontendAPIApiCreateNativeSettingsFlowRequest) Execute() (*SettingsFlow, *http.Response, error) {
	return r.ApiService.CreateNativeSettingsFlowExecute(r)
}

/*
  - CreateNativeSettingsFlow Create Settings Flow for Native Apps
  - This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on.

You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.

To fetch an existing settings flow call `/self-service/settings/flows?flow=<flow_id>`.

You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
you vulnerable to a variety of CSRF attacks.

Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
to sign in with the second factor or change the configuration.

In the case of an error, the `error.id` of the JSON response body can be one of:

`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`session_inactive`: No Ory Session was found - sign in a user first.

This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateNativeSettingsFlowRequest
*/
func (a *FrontendAPIService) CreateNativeSettingsFlow(ctx context.Context) FrontendAPIApiCreateNativeSettingsFlowRequest {
	return FrontendAPIApiCreateNativeSettingsFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SettingsFlow
 */
func (a *FrontendAPIService) CreateNativeSettingsFlowExecute(r FrontendAPIApiCreateNativeSettingsFlowRequest) (*SettingsFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SettingsFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateNativeSettingsFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/settings/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiCreateNativeVerificationFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	returnTo   *string
}

func (r FrontendAPIApiCreateNativeVerificationFlowRequest) ReturnTo(returnTo string) FrontendAPIApiCreateNativeVerificationFlowRequest {
	r.returnTo = &returnTo
	return r
}

func (r FrontendAPIApiCreateNativeVerificationFlowRequest) Execute() (*VerificationFlow, *http.Response, error) {
	return r.ApiService.CreateNativeVerificationFlowExecute(r)
}

/*
  - CreateNativeVerificationFlow Create Verification Flow for Native Apps
  - This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.

To fetch an existing verification flow call `/self-service/verification/flows?flow=<flow_id>`.

You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
you vulnerable to a variety of CSRF attacks.

This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).

More information can be found at [Ory Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiCreateNativeVerificationFlowRequest
*/
func (a *FrontendAPIService) CreateNativeVerificationFlow(ctx context.Context) FrontendAPIApiCreateNativeVerificationFlowRequest {
	return FrontendAPIApiCreateNativeVerificationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return VerificationFlow
 */
func (a *FrontendAPIService) CreateNativeVerificationFlowExecute(r FrontendAPIApiCreateNativeVerificationFlowRequest) (*VerificationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *VerificationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.CreateNativeVerificationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/verification/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiDisableMyOtherSessionsRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	xSessionToken *string
	cookie        *string
}

func (r FrontendAPIApiDisableMyOtherSessionsRequest) XSessionToken(xSessionToken string) FrontendAPIApiDisableMyOtherSessionsRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiDisableMyOtherSessionsRequest) Cookie(cookie string) FrontendAPIApiDisableMyOtherSessionsRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiDisableMyOtherSessionsRequest) Execute() (*DeleteMySessionsCount, *http.Response, error) {
	return r.ApiService.DisableMyOtherSessionsExecute(r)
}

/*
  - DisableMyOtherSessions Disable my other sessions
  - Calling this endpoint invalidates all except the current session that belong to the logged-in user.

Session data are not deleted.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiDisableMyOtherSessionsRequest
*/
func (a *FrontendAPIService) DisableMyOtherSessions(ctx context.Context) FrontendAPIApiDisableMyOtherSessionsRequest {
	return FrontendAPIApiDisableMyOtherSessionsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return DeleteMySessionsCount
 */
func (a *FrontendAPIService) DisableMyOtherSessionsExecute(r FrontendAPIApiDisableMyOtherSessionsRequest) (*DeleteMySessionsCount, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *DeleteMySessionsCount
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.DisableMyOtherSessions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/sessions"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiDisableMySessionRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	id            string
	xSessionToken *string
	cookie        *string
}

func (r FrontendAPIApiDisableMySessionRequest) XSessionToken(xSessionToken string) FrontendAPIApiDisableMySessionRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiDisableMySessionRequest) Cookie(cookie string) FrontendAPIApiDisableMySessionRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiDisableMySessionRequest) Execute() (*http.Response, error) {
	return r.ApiService.DisableMySessionExecute(r)
}

/*
  - DisableMySession Disable one of my sessions
  - Calling this endpoint invalidates the specified session. The current session cannot be revoked.

Session data are not deleted.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param id ID is the session's ID.
  - @return FrontendAPIApiDisableMySessionRequest
*/
func (a *FrontendAPIService) DisableMySession(ctx context.Context, id string) FrontendAPIApiDisableMySessionRequest {
	return FrontendAPIApiDisableMySessionRequest{
		ApiService: a,
		ctx:        ctx,
		id:         id,
	}
}

/*
 * Execute executes the request
 */
func (a *FrontendAPIService) DisableMySessionExecute(r FrontendAPIApiDisableMySessionRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.DisableMySession")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/sessions/{id}"
	localVarPath = strings.Replace(localVarPath, "{"+"id"+"}", url.PathEscape(parameterToString(r.id, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type FrontendAPIApiExchangeSessionTokenRequest struct {
	ctx          context.Context
	ApiService   FrontendAPI
	initCode     *string
	returnToCode *string
}

func (r FrontendAPIApiExchangeSessionTokenRequest) InitCode(initCode string) FrontendAPIApiExchangeSessionTokenRequest {
	r.initCode = &initCode
	return r
}
func (r FrontendAPIApiExchangeSessionTokenRequest) ReturnToCode(returnToCode string) FrontendAPIApiExchangeSessionTokenRequest {
	r.returnToCode = &returnToCode
	return r
}

func (r FrontendAPIApiExchangeSessionTokenRequest) Execute() (*SuccessfulNativeLogin, *http.Response, error) {
	return r.ApiService.ExchangeSessionTokenExecute(r)
}

/*
 * ExchangeSessionToken Exchange Session Token
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return FrontendAPIApiExchangeSessionTokenRequest
 */
func (a *FrontendAPIService) ExchangeSessionToken(ctx context.Context) FrontendAPIApiExchangeSessionTokenRequest {
	return FrontendAPIApiExchangeSessionTokenRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SuccessfulNativeLogin
 */
func (a *FrontendAPIService) ExchangeSessionTokenExecute(r FrontendAPIApiExchangeSessionTokenRequest) (*SuccessfulNativeLogin, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SuccessfulNativeLogin
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.ExchangeSessionToken")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/sessions/token-exchange"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.initCode == nil {
		return localVarReturnValue, nil, reportError("initCode is required and must be specified")
	}
	if r.returnToCode == nil {
		return localVarReturnValue, nil, reportError("returnToCode is required and must be specified")
	}

	localVarQueryParams.Add("init_code", parameterToString(*r.initCode, ""))
	localVarQueryParams.Add("return_to_code", parameterToString(*r.returnToCode, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetFlowErrorRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	id         *string
}

func (r FrontendAPIApiGetFlowErrorRequest) Id(id string) FrontendAPIApiGetFlowErrorRequest {
	r.id = &id
	return r
}

func (r FrontendAPIApiGetFlowErrorRequest) Execute() (*FlowError, *http.Response, error) {
	return r.ApiService.GetFlowErrorExecute(r)
}

/*
  - GetFlowError Get User-Flow Errors
  - This endpoint returns the error associated with a user-facing self service errors.

This endpoint supports stub values to help you implement the error UI:

`?id=stub:500` - returns a stub 500 (Internal Server Error) error.

More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetFlowErrorRequest
*/
func (a *FrontendAPIService) GetFlowError(ctx context.Context) FrontendAPIApiGetFlowErrorRequest {
	return FrontendAPIApiGetFlowErrorRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return FlowError
 */
func (a *FrontendAPIService) GetFlowErrorExecute(r FrontendAPIApiGetFlowErrorRequest) (*FlowError, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *FlowError
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetFlowError")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/errors"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 500 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetLoginFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	id         *string
	cookie     *string
}

func (r FrontendAPIApiGetLoginFlowRequest) Id(id string) FrontendAPIApiGetLoginFlowRequest {
	r.id = &id
	return r
}
func (r FrontendAPIApiGetLoginFlowRequest) Cookie(cookie string) FrontendAPIApiGetLoginFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiGetLoginFlowRequest) Execute() (*LoginFlow, *http.Response, error) {
	return r.ApiService.GetLoginFlowExecute(r)
}

/*
  - GetLoginFlow Get Login Flow
  - This endpoint returns a login flow's context with, for example, error details and other information.

Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
For AJAX requests you must ensure that cookies are included in the request or requests will fail.

If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
and you need to forward the incoming HTTP Cookie header to this endpoint:

```js
pseudo-code example
router.get('/login', async function (req, res) {
const flow = await client.getLoginFlow(req.header('cookie'), req.query['flow'])

res.render('login', flow)
})
```

This request may fail due to several reasons. The `error.id` can be one of:

`session_already_available`: The user is already signed in.
`self_service_flow_expired`: The flow is expired and you should request a new one.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetLoginFlowRequest
*/
func (a *FrontendAPIService) GetLoginFlow(ctx context.Context) FrontendAPIApiGetLoginFlowRequest {
	return FrontendAPIApiGetLoginFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return LoginFlow
 */
func (a *FrontendAPIService) GetLoginFlowExecute(r FrontendAPIApiGetLoginFlowRequest) (*LoginFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *LoginFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetLoginFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/login/flows"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetRecoveryFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	id         *string
	cookie     *string
}

func (r FrontendAPIApiGetRecoveryFlowRequest) Id(id string) FrontendAPIApiGetRecoveryFlowRequest {
	r.id = &id
	return r
}
func (r FrontendAPIApiGetRecoveryFlowRequest) Cookie(cookie string) FrontendAPIApiGetRecoveryFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiGetRecoveryFlowRequest) Execute() (*RecoveryFlow, *http.Response, error) {
	return r.ApiService.GetRecoveryFlowExecute(r)
}

/*
  - GetRecoveryFlow Get Recovery Flow
  - This endpoint returns a recovery flow's context with, for example, error details and other information.

Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
For AJAX requests you must ensure that cookies are included in the request or requests will fail.

If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
and you need to forward the incoming HTTP Cookie header to this endpoint:

```js
pseudo-code example
router.get('/recovery', async function (req, res) {
const flow = await client.getRecoveryFlow(req.header('Cookie'), req.query['flow'])

res.render('recovery', flow)
})
```

More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetRecoveryFlowRequest
*/
func (a *FrontendAPIService) GetRecoveryFlow(ctx context.Context) FrontendAPIApiGetRecoveryFlowRequest {
	return FrontendAPIApiGetRecoveryFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RecoveryFlow
 */
func (a *FrontendAPIService) GetRecoveryFlowExecute(r FrontendAPIApiGetRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RecoveryFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetRecoveryFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/recovery/flows"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetRegistrationFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	id         *string
	cookie     *string
}

func (r FrontendAPIApiGetRegistrationFlowRequest) Id(id string) FrontendAPIApiGetRegistrationFlowRequest {
	r.id = &id
	return r
}
func (r FrontendAPIApiGetRegistrationFlowRequest) Cookie(cookie string) FrontendAPIApiGetRegistrationFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiGetRegistrationFlowRequest) Execute() (*RegistrationFlow, *http.Response, error) {
	return r.ApiService.GetRegistrationFlowExecute(r)
}

/*
  - GetRegistrationFlow Get Registration Flow
  - This endpoint returns a registration flow's context with, for example, error details and other information.

Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
For AJAX requests you must ensure that cookies are included in the request or requests will fail.

If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
and you need to forward the incoming HTTP Cookie header to this endpoint:

```js
pseudo-code example
router.get('/registration', async function (req, res) {
const flow = await client.getRegistrationFlow(req.header('cookie'), req.query['flow'])

res.render('registration', flow)
})
```

This request may fail due to several reasons. The `error.id` can be one of:

`session_already_available`: The user is already signed in.
`self_service_flow_expired`: The flow is expired and you should request a new one.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetRegistrationFlowRequest
*/
func (a *FrontendAPIService) GetRegistrationFlow(ctx context.Context) FrontendAPIApiGetRegistrationFlowRequest {
	return FrontendAPIApiGetRegistrationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RegistrationFlow
 */
func (a *FrontendAPIService) GetRegistrationFlowExecute(r FrontendAPIApiGetRegistrationFlowRequest) (*RegistrationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RegistrationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetRegistrationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/registration/flows"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetSettingsFlowRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	id            *string
	xSessionToken *string
	cookie        *string
}

func (r FrontendAPIApiGetSettingsFlowRequest) Id(id string) FrontendAPIApiGetSettingsFlowRequest {
	r.id = &id
	return r
}
func (r FrontendAPIApiGetSettingsFlowRequest) XSessionToken(xSessionToken string) FrontendAPIApiGetSettingsFlowRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiGetSettingsFlowRequest) Cookie(cookie string) FrontendAPIApiGetSettingsFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiGetSettingsFlowRequest) Execute() (*SettingsFlow, *http.Response, error) {
	return r.ApiService.GetSettingsFlowExecute(r)
}

/*
  - GetSettingsFlow Get Settings Flow
  - When accessing this endpoint through Ory Kratos' Public API you must ensure that either the Ory Kratos Session Cookie

or the Ory Kratos Session Token are set.

Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
to sign in with the second factor or change the configuration.

You can access this endpoint without credentials when using Ory Kratos' Admin API.

If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`session_inactive`: No Ory Session was found - sign in a user first.
`security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
identity logged in instead.

More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetSettingsFlowRequest
*/
func (a *FrontendAPIService) GetSettingsFlow(ctx context.Context) FrontendAPIApiGetSettingsFlowRequest {
	return FrontendAPIApiGetSettingsFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SettingsFlow
 */
func (a *FrontendAPIService) GetSettingsFlowExecute(r FrontendAPIApiGetSettingsFlowRequest) (*SettingsFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SettingsFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetSettingsFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/settings/flows"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetVerificationFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	id         *string
	cookie     *string
}

func (r FrontendAPIApiGetVerificationFlowRequest) Id(id string) FrontendAPIApiGetVerificationFlowRequest {
	r.id = &id
	return r
}
func (r FrontendAPIApiGetVerificationFlowRequest) Cookie(cookie string) FrontendAPIApiGetVerificationFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiGetVerificationFlowRequest) Execute() (*VerificationFlow, *http.Response, error) {
	return r.ApiService.GetVerificationFlowExecute(r)
}

/*
  - GetVerificationFlow Get Verification Flow
  - This endpoint returns a verification flow's context with, for example, error details and other information.

Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
For AJAX requests you must ensure that cookies are included in the request or requests will fail.

If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
and you need to forward the incoming HTTP Cookie header to this endpoint:

```js
pseudo-code example
router.get('/recovery', async function (req, res) {
const flow = await client.getVerificationFlow(req.header('cookie'), req.query['flow'])

res.render('verification', flow)
})
```

More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetVerificationFlowRequest
*/
func (a *FrontendAPIService) GetVerificationFlow(ctx context.Context) FrontendAPIApiGetVerificationFlowRequest {
	return FrontendAPIApiGetVerificationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return VerificationFlow
 */
func (a *FrontendAPIService) GetVerificationFlowExecute(r FrontendAPIApiGetVerificationFlowRequest) (*VerificationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *VerificationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetVerificationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/verification/flows"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.id == nil {
		return localVarReturnValue, nil, reportError("id is required and must be specified")
	}

	localVarQueryParams.Add("id", parameterToString(*r.id, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiGetWebAuthnJavaScriptRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
}

func (r FrontendAPIApiGetWebAuthnJavaScriptRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.GetWebAuthnJavaScriptExecute(r)
}

/*
  - GetWebAuthnJavaScript Get WebAuthn JavaScript
  - This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.

If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:

```html
<script src="https://public-kratos.example.org/.well-known/ory/webauthn.js" type="script" async />
```

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiGetWebAuthnJavaScriptRequest
*/
func (a *FrontendAPIService) GetWebAuthnJavaScript(ctx context.Context) FrontendAPIApiGetWebAuthnJavaScriptRequest {
	return FrontendAPIApiGetWebAuthnJavaScriptRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return string
 */
func (a *FrontendAPIService) GetWebAuthnJavaScriptExecute(r FrontendAPIApiGetWebAuthnJavaScriptRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.GetWebAuthnJavaScript")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/.well-known/ory/webauthn.js"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiListMySessionsRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	perPage       *int64
	page          *int64
	pageSize      *int64
	pageToken     *string
	xSessionToken *string
	cookie        *string
}

func (r FrontendAPIApiListMySessionsRequest) PerPage(perPage int64) FrontendAPIApiListMySessionsRequest {
	r.perPage = &perPage
	return r
}
func (r FrontendAPIApiListMySessionsRequest) Page(page int64) FrontendAPIApiListMySessionsRequest {
	r.page = &page
	return r
}
func (r FrontendAPIApiListMySessionsRequest) PageSize(pageSize int64) FrontendAPIApiListMySessionsRequest {
	r.pageSize = &pageSize
	return r
}
func (r FrontendAPIApiListMySessionsRequest) PageToken(pageToken string) FrontendAPIApiListMySessionsRequest {
	r.pageToken = &pageToken
	return r
}
func (r FrontendAPIApiListMySessionsRequest) XSessionToken(xSessionToken string) FrontendAPIApiListMySessionsRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiListMySessionsRequest) Cookie(cookie string) FrontendAPIApiListMySessionsRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiListMySessionsRequest) Execute() ([]Session, *http.Response, error) {
	return r.ApiService.ListMySessionsExecute(r)
}

/*
  - ListMySessions Get My Active Sessions
  - This endpoints returns all other active sessions that belong to the logged-in user.

The current session can be retrieved by calling the `/sessions/whoami` endpoint.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiListMySessionsRequest
*/
func (a *FrontendAPIService) ListMySessions(ctx context.Context) FrontendAPIApiListMySessionsRequest {
	return FrontendAPIApiListMySessionsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return []Session
 */
func (a *FrontendAPIService) ListMySessionsExecute(r FrontendAPIApiListMySessionsRequest) ([]Session, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  []Session
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.ListMySessions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/sessions"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.perPage != nil {
		localVarQueryParams.Add("per_page", parameterToString(*r.perPage, ""))
	}
	if r.page != nil {
		localVarQueryParams.Add("page", parameterToString(*r.page, ""))
	}
	if r.pageSize != nil {
		localVarQueryParams.Add("page_size", parameterToString(*r.pageSize, ""))
	}
	if r.pageToken != nil {
		localVarQueryParams.Add("page_token", parameterToString(*r.pageToken, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiPerformNativeLogoutRequest struct {
	ctx                     context.Context
	ApiService              FrontendAPI
	performNativeLogoutBody *PerformNativeLogoutBody
}

func (r FrontendAPIApiPerformNativeLogoutRequest) PerformNativeLogoutBody(performNativeLogoutBody PerformNativeLogoutBody) FrontendAPIApiPerformNativeLogoutRequest {
	r.performNativeLogoutBody = &performNativeLogoutBody
	return r
}

func (r FrontendAPIApiPerformNativeLogoutRequest) Execute() (*http.Response, error) {
	return r.ApiService.PerformNativeLogoutExecute(r)
}

/*
  - PerformNativeLogout Perform Logout for Native Apps
  - Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully

revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when
the Ory Session Token has been revoked already before.

If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.

This endpoint does not remove any HTTP
Cookies - use the Browser-Based Self-Service Logout Flow instead.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiPerformNativeLogoutRequest
*/
func (a *FrontendAPIService) PerformNativeLogout(ctx context.Context) FrontendAPIApiPerformNativeLogoutRequest {
	return FrontendAPIApiPerformNativeLogoutRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 */
func (a *FrontendAPIService) PerformNativeLogoutExecute(r FrontendAPIApiPerformNativeLogoutRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.PerformNativeLogout")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/logout/api"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.performNativeLogoutBody == nil {
		return nil, reportError("performNativeLogoutBody is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.performNativeLogoutBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type FrontendAPIApiToSessionRequest struct {
	ctx           context.Context
	ApiService    FrontendAPI
	xSessionToken *string
	cookie        *string
	tokenizeAs    *string
}

func (r FrontendAPIApiToSessionRequest) XSessionToken(xSessionToken string) FrontendAPIApiToSessionRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiToSessionRequest) Cookie(cookie string) FrontendAPIApiToSessionRequest {
	r.cookie = &cookie
	return r
}
func (r FrontendAPIApiToSessionRequest) TokenizeAs(tokenizeAs string) FrontendAPIApiToSessionRequest {
	r.tokenizeAs = &tokenizeAs
	return r
}

func (r FrontendAPIApiToSessionRequest) Execute() (*Session, *http.Response, error) {
	return r.ApiService.ToSessionExecute(r)
}

/*
  - ToSession Check Who the Current HTTP Session Belongs To
  - Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated.

Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent.
When the request it successful it adds the user ID to the 'X-Kratos-Authenticated-Identity-Id' header
in the response.

If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:

```js
pseudo-code example
router.get('/protected-endpoint', async function (req, res) {
const session = await client.toSession(undefined, req.header('cookie'))

console.log(session)
})
```

When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:

```js
pseudo-code example
...
const session = await client.toSession("the-session-token")

console.log(session)
```

When using a token template, the token is included in the `tokenized` field of the session.

```js
pseudo-code example
...
const session = await client.toSession("the-session-token", { tokenize_as: "example-jwt-template" })

console.log(session.tokenized) // The JWT
```

Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator
Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
to sign in with the second factor or change the configuration.

This endpoint is useful for:

AJAX calls. Remember to send credentials and set up CORS correctly!
Reverse proxies and API Gateways
Server-side calls - use the `X-Session-Token` header!

This endpoint authenticates users by checking:

if the `Cookie` HTTP header was set containing an Ory Kratos Session Cookie;
if the `Authorization: bearer <ory-session-token>` HTTP header was set with a valid Ory Kratos Session Token;
if the `X-Session-Token` HTTP header was set with a valid Ory Kratos Session Token.

If none of these headers are set or the cookie or token are invalid, the endpoint returns a HTTP 401 status code.

As explained above, this request may fail due to several reasons. The `error.id` can be one of:

`session_inactive`: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token).
`session_aal2_required`: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiToSessionRequest
*/
func (a *FrontendAPIService) ToSession(ctx context.Context) FrontendAPIApiToSessionRequest {
	return FrontendAPIApiToSessionRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Session
 */
func (a *FrontendAPIService) ToSessionExecute(r FrontendAPIApiToSessionRequest) (*Session, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *Session
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.ToSession")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/sessions/whoami"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.tokenizeAs != nil {
		localVarQueryParams.Add("tokenize_as", parameterToString(*r.tokenizeAs, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateLoginFlowRequest struct {
	ctx                 context.Context
	ApiService          FrontendAPI
	flow                *string
	updateLoginFlowBody *UpdateLoginFlowBody
	xSessionToken       *string
	cookie              *string
}

func (r FrontendAPIApiUpdateLoginFlowRequest) Flow(flow string) FrontendAPIApiUpdateLoginFlowRequest {
	r.flow = &flow
	return r
}
func (r FrontendAPIApiUpdateLoginFlowRequest) UpdateLoginFlowBody(updateLoginFlowBody UpdateLoginFlowBody) FrontendAPIApiUpdateLoginFlowRequest {
	r.updateLoginFlowBody = &updateLoginFlowBody
	return r
}
func (r FrontendAPIApiUpdateLoginFlowRequest) XSessionToken(xSessionToken string) FrontendAPIApiUpdateLoginFlowRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiUpdateLoginFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateLoginFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateLoginFlowRequest) Execute() (*SuccessfulNativeLogin, *http.Response, error) {
	return r.ApiService.UpdateLoginFlowExecute(r)
}

/*
  - UpdateLoginFlow Submit a Login Flow
  - Use this endpoint to complete a login flow. This endpoint

behaves differently for API and browser flows.

API flows expect `application/json` to be sent in the body and responds with
HTTP 200 and a application/json body with the session token on success;
HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
HTTP 400 on form validation errors.

Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
a HTTP 303 redirect to the post/after login URL or the `return_to` value if it was set and if the login succeeded;
a HTTP 303 redirect to the login UI URL with the flow ID containing the validation errors otherwise.

Browser flows with an accept header of `application/json` will not redirect but instead respond with
HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
HTTP 400 on form validation errors.

If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
Most likely used in Social Sign In flows.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateLoginFlowRequest
*/
func (a *FrontendAPIService) UpdateLoginFlow(ctx context.Context) FrontendAPIApiUpdateLoginFlowRequest {
	return FrontendAPIApiUpdateLoginFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SuccessfulNativeLogin
 */
func (a *FrontendAPIService) UpdateLoginFlowExecute(r FrontendAPIApiUpdateLoginFlowRequest) (*SuccessfulNativeLogin, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SuccessfulNativeLogin
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateLoginFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/login"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.flow == nil {
		return localVarReturnValue, nil, reportError("flow is required and must be specified")
	}
	if r.updateLoginFlowBody == nil {
		return localVarReturnValue, nil, reportError("updateLoginFlowBody is required and must be specified")
	}

	localVarQueryParams.Add("flow", parameterToString(*r.flow, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	// body params
	localVarPostBody = r.updateLoginFlowBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v LoginFlow
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v ErrorBrowserLocationChangeRequired
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateLogoutFlowRequest struct {
	ctx        context.Context
	ApiService FrontendAPI
	token      *string
	returnTo   *string
	cookie     *string
}

func (r FrontendAPIApiUpdateLogoutFlowRequest) Token(token string) FrontendAPIApiUpdateLogoutFlowRequest {
	r.token = &token
	return r
}
func (r FrontendAPIApiUpdateLogoutFlowRequest) ReturnTo(returnTo string) FrontendAPIApiUpdateLogoutFlowRequest {
	r.returnTo = &returnTo
	return r
}
func (r FrontendAPIApiUpdateLogoutFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateLogoutFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateLogoutFlowRequest) Execute() (*http.Response, error) {
	return r.ApiService.UpdateLogoutFlowExecute(r)
}

/*
  - UpdateLogoutFlow Update Logout Flow
  - This endpoint logs out an identity in a self-service manner.

If the `Accept` HTTP header is not set to `application/json`, the browser will be redirected (HTTP 303 See Other)
to the `return_to` parameter of the initial request or fall back to `urls.default_return_to`.

If the `Accept` HTTP header is set to `application/json`, a 204 No Content response
will be sent on successful logout instead.

This endpoint is NOT INTENDED for API clients and only works
with browsers (Chrome, Firefox, ...). For API clients you can
call the `/self-service/logout/api` URL directly with the Ory Session Token.

More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateLogoutFlowRequest
*/
func (a *FrontendAPIService) UpdateLogoutFlow(ctx context.Context) FrontendAPIApiUpdateLogoutFlowRequest {
	return FrontendAPIApiUpdateLogoutFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 */
func (a *FrontendAPIService) UpdateLogoutFlowExecute(r FrontendAPIApiUpdateLogoutFlowRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateLogoutFlow")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/logout"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.token != nil {
		localVarQueryParams.Add("token", parameterToString(*r.token, ""))
	}
	if r.returnTo != nil {
		localVarQueryParams.Add("return_to", parameterToString(*r.returnTo, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateRecoveryFlowRequest struct {
	ctx                    context.Context
	ApiService             FrontendAPI
	flow                   *string
	updateRecoveryFlowBody *UpdateRecoveryFlowBody
	token                  *string
	cookie                 *string
}

func (r FrontendAPIApiUpdateRecoveryFlowRequest) Flow(flow string) FrontendAPIApiUpdateRecoveryFlowRequest {
	r.flow = &flow
	return r
}
func (r FrontendAPIApiUpdateRecoveryFlowRequest) UpdateRecoveryFlowBody(updateRecoveryFlowBody UpdateRecoveryFlowBody) FrontendAPIApiUpdateRecoveryFlowRequest {
	r.updateRecoveryFlowBody = &updateRecoveryFlowBody
	return r
}
func (r FrontendAPIApiUpdateRecoveryFlowRequest) Token(token string) FrontendAPIApiUpdateRecoveryFlowRequest {
	r.token = &token
	return r
}
func (r FrontendAPIApiUpdateRecoveryFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateRecoveryFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateRecoveryFlowRequest) Execute() (*RecoveryFlow, *http.Response, error) {
	return r.ApiService.UpdateRecoveryFlowExecute(r)
}

/*
  - UpdateRecoveryFlow Update Recovery Flow
  - Use this endpoint to update a recovery flow. This endpoint

behaves differently for API and browser flows and has several states:

`choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
and works with API- and Browser-initiated flows.
For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid.
and a HTTP 303 See Other redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired).
For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Recovery UI URL with the Recovery Flow ID appended.
`sent_email` is the success state after `choose_method` for the `link` method and allows the user to request another recovery email. It
works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
`passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a recovery link")
does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
(if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with
a new Recovery Flow ID which contains an error message that the recovery link was invalid.

More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateRecoveryFlowRequest
*/
func (a *FrontendAPIService) UpdateRecoveryFlow(ctx context.Context) FrontendAPIApiUpdateRecoveryFlowRequest {
	return FrontendAPIApiUpdateRecoveryFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RecoveryFlow
 */
func (a *FrontendAPIService) UpdateRecoveryFlowExecute(r FrontendAPIApiUpdateRecoveryFlowRequest) (*RecoveryFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *RecoveryFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateRecoveryFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/recovery"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.flow == nil {
		return localVarReturnValue, nil, reportError("flow is required and must be specified")
	}
	if r.updateRecoveryFlowBody == nil {
		return localVarReturnValue, nil, reportError("updateRecoveryFlowBody is required and must be specified")
	}

	localVarQueryParams.Add("flow", parameterToString(*r.flow, ""))
	if r.token != nil {
		localVarQueryParams.Add("token", parameterToString(*r.token, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	// body params
	localVarPostBody = r.updateRecoveryFlowBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v RecoveryFlow
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v ErrorBrowserLocationChangeRequired
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateRegistrationFlowRequest struct {
	ctx                        context.Context
	ApiService                 FrontendAPI
	flow                       *string
	updateRegistrationFlowBody *UpdateRegistrationFlowBody
	cookie                     *string
}

func (r FrontendAPIApiUpdateRegistrationFlowRequest) Flow(flow string) FrontendAPIApiUpdateRegistrationFlowRequest {
	r.flow = &flow
	return r
}
func (r FrontendAPIApiUpdateRegistrationFlowRequest) UpdateRegistrationFlowBody(updateRegistrationFlowBody UpdateRegistrationFlowBody) FrontendAPIApiUpdateRegistrationFlowRequest {
	r.updateRegistrationFlowBody = &updateRegistrationFlowBody
	return r
}
func (r FrontendAPIApiUpdateRegistrationFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateRegistrationFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateRegistrationFlowRequest) Execute() (*SuccessfulNativeRegistration, *http.Response, error) {
	return r.ApiService.UpdateRegistrationFlowExecute(r)
}

/*
  - UpdateRegistrationFlow Update Registration Flow
  - Use this endpoint to complete a registration flow by sending an identity's traits and password. This endpoint

behaves differently for API and browser flows.

API flows expect `application/json` to be sent in the body and respond with
HTTP 200 and a application/json body with the created identity success - if the session hook is configured the
`session` and `session_token` will also be included;
HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
HTTP 400 on form validation errors.

Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
a HTTP 303 redirect to the post/after registration URL or the `return_to` value if it was set and if the registration succeeded;
a HTTP 303 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.

Browser flows with an accept header of `application/json` will not redirect but instead respond with
HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
HTTP 400 on form validation errors.

If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`session_already_available`: The user is already signed in.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
Most likely used in Social Sign In flows.

More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateRegistrationFlowRequest
*/
func (a *FrontendAPIService) UpdateRegistrationFlow(ctx context.Context) FrontendAPIApiUpdateRegistrationFlowRequest {
	return FrontendAPIApiUpdateRegistrationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SuccessfulNativeRegistration
 */
func (a *FrontendAPIService) UpdateRegistrationFlowExecute(r FrontendAPIApiUpdateRegistrationFlowRequest) (*SuccessfulNativeRegistration, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SuccessfulNativeRegistration
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateRegistrationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/registration"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.flow == nil {
		return localVarReturnValue, nil, reportError("flow is required and must be specified")
	}
	if r.updateRegistrationFlowBody == nil {
		return localVarReturnValue, nil, reportError("updateRegistrationFlowBody is required and must be specified")
	}

	localVarQueryParams.Add("flow", parameterToString(*r.flow, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	// body params
	localVarPostBody = r.updateRegistrationFlowBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v RegistrationFlow
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v ErrorBrowserLocationChangeRequired
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateSettingsFlowRequest struct {
	ctx                    context.Context
	ApiService             FrontendAPI
	flow                   *string
	updateSettingsFlowBody *UpdateSettingsFlowBody
	xSessionToken          *string
	cookie                 *string
}

func (r FrontendAPIApiUpdateSettingsFlowRequest) Flow(flow string) FrontendAPIApiUpdateSettingsFlowRequest {
	r.flow = &flow
	return r
}
func (r FrontendAPIApiUpdateSettingsFlowRequest) UpdateSettingsFlowBody(updateSettingsFlowBody UpdateSettingsFlowBody) FrontendAPIApiUpdateSettingsFlowRequest {
	r.updateSettingsFlowBody = &updateSettingsFlowBody
	return r
}
func (r FrontendAPIApiUpdateSettingsFlowRequest) XSessionToken(xSessionToken string) FrontendAPIApiUpdateSettingsFlowRequest {
	r.xSessionToken = &xSessionToken
	return r
}
func (r FrontendAPIApiUpdateSettingsFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateSettingsFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateSettingsFlowRequest) Execute() (*SettingsFlow, *http.Response, error) {
	return r.ApiService.UpdateSettingsFlowExecute(r)
}

/*
  - UpdateSettingsFlow Complete Settings Flow
  - Use this endpoint to complete a settings flow by sending an identity's updated password. This endpoint

behaves differently for API and browser flows.

API-initiated flows expect `application/json` to be sent in the body and respond with
HTTP 200 and an application/json body with the session token on success;
HTTP 303 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set;
HTTP 400 on form validation errors.
HTTP 401 when the endpoint is called without a valid session token.
HTTP 403 when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
Implies that the user needs to re-authenticate.

Browser flows without HTTP Header `Accept` or with `Accept: text/*` respond with
a HTTP 303 redirect to the post/after settings URL or the `return_to` value if it was set and if the flow succeeded;
a HTTP 303 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise.
a HTTP 303 redirect to the login endpoint when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.

Browser flows with HTTP Header `Accept: application/json` respond with
HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
HTTP 401 when the endpoint is called without a valid session cookie.
HTTP 403 when the page is accessed without a session cookie or the session's AAL is too low.
HTTP 400 on form validation errors.

Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.

If this endpoint is called with a `Accept: application/json` HTTP header, the response contains the flow without a redirect. In the
case of an error, the `error.id` of the JSON response body can be one of:

`session_refresh_required`: The identity requested to change something that needs a privileged session. Redirect
the identity to the login init endpoint with query parameters `?refresh=true&return_to=<the-current-browser-url>`,
or initiate a refresh login flow otherwise.
`security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
`session_inactive`: No Ory Session was found - sign in a user first.
`security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
identity logged in instead.
`security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
`browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
Most likely used in Social Sign In flows.

More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateSettingsFlowRequest
*/
func (a *FrontendAPIService) UpdateSettingsFlow(ctx context.Context) FrontendAPIApiUpdateSettingsFlowRequest {
	return FrontendAPIApiUpdateSettingsFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return SettingsFlow
 */
func (a *FrontendAPIService) UpdateSettingsFlowExecute(r FrontendAPIApiUpdateSettingsFlowRequest) (*SettingsFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *SettingsFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateSettingsFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/settings"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.flow == nil {
		return localVarReturnValue, nil, reportError("flow is required and must be specified")
	}
	if r.updateSettingsFlowBody == nil {
		return localVarReturnValue, nil, reportError("updateSettingsFlowBody is required and must be specified")
	}

	localVarQueryParams.Add("flow", parameterToString(*r.flow, ""))
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xSessionToken != nil {
		localVarHeaderParams["X-Session-Token"] = parameterToString(*r.xSessionToken, "")
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	// body params
	localVarPostBody = r.updateSettingsFlowBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v SettingsFlow
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 403 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 422 {
			var v ErrorBrowserLocationChangeRequired
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type FrontendAPIApiUpdateVerificationFlowRequest struct {
	ctx                        context.Context
	ApiService                 FrontendAPI
	flow                       *string
	updateVerificationFlowBody *UpdateVerificationFlowBody
	token                      *string
	cookie                     *string
}

func (r FrontendAPIApiUpdateVerificationFlowRequest) Flow(flow string) FrontendAPIApiUpdateVerificationFlowRequest {
	r.flow = &flow
	return r
}
func (r FrontendAPIApiUpdateVerificationFlowRequest) UpdateVerificationFlowBody(updateVerificationFlowBody UpdateVerificationFlowBody) FrontendAPIApiUpdateVerificationFlowRequest {
	r.updateVerificationFlowBody = &updateVerificationFlowBody
	return r
}
func (r FrontendAPIApiUpdateVerificationFlowRequest) Token(token string) FrontendAPIApiUpdateVerificationFlowRequest {
	r.token = &token
	return r
}
func (r FrontendAPIApiUpdateVerificationFlowRequest) Cookie(cookie string) FrontendAPIApiUpdateVerificationFlowRequest {
	r.cookie = &cookie
	return r
}

func (r FrontendAPIApiUpdateVerificationFlowRequest) Execute() (*VerificationFlow, *http.Response, error) {
	return r.ApiService.UpdateVerificationFlowExecute(r)
}

/*
  - UpdateVerificationFlow Complete Verification Flow
  - Use this endpoint to complete a verification flow. This endpoint

behaves differently for API and browser flows and has several states:

`choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
and works with API- and Browser-initiated flows.
For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid
and a HTTP 303 See Other redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired).
For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Verification UI URL with the Verification Flow ID appended.
`sent_email` is the success state after `choose_method` when using the `link` method and allows the user to request another verification email. It
works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
`passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a verification link")
does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
(if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with
a new Verification Flow ID which contains an error message that the verification link was invalid.

More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
  - @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return FrontendAPIApiUpdateVerificationFlowRequest
*/
func (a *FrontendAPIService) UpdateVerificationFlow(ctx context.Context) FrontendAPIApiUpdateVerificationFlowRequest {
	return FrontendAPIApiUpdateVerificationFlowRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return VerificationFlow
 */
func (a *FrontendAPIService) UpdateVerificationFlowExecute(r FrontendAPIApiUpdateVerificationFlowRequest) (*VerificationFlow, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *VerificationFlow
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FrontendAPIService.UpdateVerificationFlow")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/self-service/verification"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.flow == nil {
		return localVarReturnValue, nil, reportError("flow is required and must be specified")
	}
	if r.updateVerificationFlowBody == nil {
		return localVarReturnValue, nil, reportError("updateVerificationFlowBody is required and must be specified")
	}

	localVarQueryParams.Add("flow", parameterToString(*r.flow, ""))
	if r.token != nil {
		localVarQueryParams.Add("token", parameterToString(*r.token, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.cookie != nil {
		localVarHeaderParams["Cookie"] = parameterToString(*r.cookie, "")
	}
	// body params
	localVarPostBody = r.updateVerificationFlowBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(io.LimitReader(localVarHTTPResponse.Body, 1024*1024))
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v VerificationFlow
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 410 {
			var v ErrorGeneric
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v ErrorGeneric
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
