/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// UpdateSettingsFlowWithTotpMethod Update Settings Flow with TOTP Method
type UpdateSettingsFlowWithTotpMethod struct {
	// CSRFToken is the anti-CSRF token
	CsrfToken *string `json:"csrf_token,omitempty"`
	// Method  Should be set to \"totp\" when trying to add, update, or remove a totp pairing.
	Method string `json:"method"`
	// ValidationTOTP must contain a valid TOTP based on the
	TotpCode *string `json:"totp_code,omitempty"`
	// UnlinkTOTP if true will remove the TOTP pairing, effectively removing the credential. This can be used to set up a new TOTP device.
	TotpUnlink *bool `json:"totp_unlink,omitempty"`
	// Transient data to pass along to any webhooks
	TransientPayload map[string]interface{} `json:"transient_payload,omitempty"`
}

// NewUpdateSettingsFlowWithTotpMethod instantiates a new UpdateSettingsFlowWithTotpMethod object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateSettingsFlowWithTotpMethod(method string) *UpdateSettingsFlowWithTotpMethod {
	this := UpdateSettingsFlowWithTotpMethod{}
	this.Method = method
	return &this
}

// NewUpdateSettingsFlowWithTotpMethodWithDefaults instantiates a new UpdateSettingsFlowWithTotpMethod object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateSettingsFlowWithTotpMethodWithDefaults() *UpdateSettingsFlowWithTotpMethod {
	this := UpdateSettingsFlowWithTotpMethod{}
	return &this
}

// GetCsrfToken returns the CsrfToken field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithTotpMethod) GetCsrfToken() string {
	if o == nil || o.CsrfToken == nil {
		var ret string
		return ret
	}
	return *o.CsrfToken
}

// GetCsrfTokenOk returns a tuple with the CsrfToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithTotpMethod) GetCsrfTokenOk() (*string, bool) {
	if o == nil || o.CsrfToken == nil {
		return nil, false
	}
	return o.CsrfToken, true
}

// HasCsrfToken returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithTotpMethod) HasCsrfToken() bool {
	if o != nil && o.CsrfToken != nil {
		return true
	}

	return false
}

// SetCsrfToken gets a reference to the given string and assigns it to the CsrfToken field.
func (o *UpdateSettingsFlowWithTotpMethod) SetCsrfToken(v string) {
	o.CsrfToken = &v
}

// GetMethod returns the Method field value
func (o *UpdateSettingsFlowWithTotpMethod) GetMethod() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Method
}

// GetMethodOk returns a tuple with the Method field value
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithTotpMethod) GetMethodOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Method, true
}

// SetMethod sets field value
func (o *UpdateSettingsFlowWithTotpMethod) SetMethod(v string) {
	o.Method = v
}

// GetTotpCode returns the TotpCode field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithTotpMethod) GetTotpCode() string {
	if o == nil || o.TotpCode == nil {
		var ret string
		return ret
	}
	return *o.TotpCode
}

// GetTotpCodeOk returns a tuple with the TotpCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithTotpMethod) GetTotpCodeOk() (*string, bool) {
	if o == nil || o.TotpCode == nil {
		return nil, false
	}
	return o.TotpCode, true
}

// HasTotpCode returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithTotpMethod) HasTotpCode() bool {
	if o != nil && o.TotpCode != nil {
		return true
	}

	return false
}

// SetTotpCode gets a reference to the given string and assigns it to the TotpCode field.
func (o *UpdateSettingsFlowWithTotpMethod) SetTotpCode(v string) {
	o.TotpCode = &v
}

// GetTotpUnlink returns the TotpUnlink field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithTotpMethod) GetTotpUnlink() bool {
	if o == nil || o.TotpUnlink == nil {
		var ret bool
		return ret
	}
	return *o.TotpUnlink
}

// GetTotpUnlinkOk returns a tuple with the TotpUnlink field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithTotpMethod) GetTotpUnlinkOk() (*bool, bool) {
	if o == nil || o.TotpUnlink == nil {
		return nil, false
	}
	return o.TotpUnlink, true
}

// HasTotpUnlink returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithTotpMethod) HasTotpUnlink() bool {
	if o != nil && o.TotpUnlink != nil {
		return true
	}

	return false
}

// SetTotpUnlink gets a reference to the given bool and assigns it to the TotpUnlink field.
func (o *UpdateSettingsFlowWithTotpMethod) SetTotpUnlink(v bool) {
	o.TotpUnlink = &v
}

// GetTransientPayload returns the TransientPayload field value if set, zero value otherwise.
func (o *UpdateSettingsFlowWithTotpMethod) GetTransientPayload() map[string]interface{} {
	if o == nil || o.TransientPayload == nil {
		var ret map[string]interface{}
		return ret
	}
	return o.TransientPayload
}

// GetTransientPayloadOk returns a tuple with the TransientPayload field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSettingsFlowWithTotpMethod) GetTransientPayloadOk() (map[string]interface{}, bool) {
	if o == nil || o.TransientPayload == nil {
		return nil, false
	}
	return o.TransientPayload, true
}

// HasTransientPayload returns a boolean if a field has been set.
func (o *UpdateSettingsFlowWithTotpMethod) HasTransientPayload() bool {
	if o != nil && o.TransientPayload != nil {
		return true
	}

	return false
}

// SetTransientPayload gets a reference to the given map[string]interface{} and assigns it to the TransientPayload field.
func (o *UpdateSettingsFlowWithTotpMethod) SetTransientPayload(v map[string]interface{}) {
	o.TransientPayload = v
}

func (o UpdateSettingsFlowWithTotpMethod) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CsrfToken != nil {
		toSerialize["csrf_token"] = o.CsrfToken
	}
	if true {
		toSerialize["method"] = o.Method
	}
	if o.TotpCode != nil {
		toSerialize["totp_code"] = o.TotpCode
	}
	if o.TotpUnlink != nil {
		toSerialize["totp_unlink"] = o.TotpUnlink
	}
	if o.TransientPayload != nil {
		toSerialize["transient_payload"] = o.TransientPayload
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateSettingsFlowWithTotpMethod struct {
	value *UpdateSettingsFlowWithTotpMethod
	isSet bool
}

func (v NullableUpdateSettingsFlowWithTotpMethod) Get() *UpdateSettingsFlowWithTotpMethod {
	return v.value
}

func (v *NullableUpdateSettingsFlowWithTotpMethod) Set(val *UpdateSettingsFlowWithTotpMethod) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateSettingsFlowWithTotpMethod) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateSettingsFlowWithTotpMethod) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateSettingsFlowWithTotpMethod(val *UpdateSettingsFlowWithTotpMethod) *NullableUpdateSettingsFlowWithTotpMethod {
	return &NullableUpdateSettingsFlowWithTotpMethod{value: val, isSet: true}
}

func (v NullableUpdateSettingsFlowWithTotpMethod) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateSettingsFlowWithTotpMethod) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
