/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
	"fmt"
)

// RegistrationFlowState The experimental state represents the state of a registration flow. This field is EXPERIMENTAL and subject to change!
type RegistrationFlowState string

// List of registrationFlowState
const (
	REGISTRATIONFLOWSTATE_CHOOSE_METHOD    RegistrationFlowState = "choose_method"
	REGISTRATIONFLOWSTATE_SENT_EMAIL       RegistrationFlowState = "sent_email"
	REGISTRATIONFLOWSTATE_PASSED_CHALLENGE RegistrationFlowState = "passed_challenge"
)

func (v *RegistrationFlowState) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := RegistrationFlowState(value)
	for _, existing := range []RegistrationFlowState{"choose_method", "sent_email", "passed_challenge"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid RegistrationFlowState", value)
}

// Ptr returns reference to registrationFlowState value
func (v RegistrationFlowState) Ptr() *RegistrationFlowState {
	return &v
}

type NullableRegistrationFlowState struct {
	value *RegistrationFlowState
	isSet bool
}

func (v NullableRegistrationFlowState) Get() *RegistrationFlowState {
	return v.value
}

func (v *NullableRegistrationFlowState) Set(val *RegistrationFlowState) {
	v.value = val
	v.isSet = true
}

func (v NullableRegistrationFlowState) IsSet() bool {
	return v.isSet
}

func (v *NullableRegistrationFlowState) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRegistrationFlowState(val *RegistrationFlowState) *NullableRegistrationFlowState {
	return &NullableRegistrationFlowState{value: val, isSet: true}
}

func (v NullableRegistrationFlowState) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRegistrationFlowState) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
