/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// IdentityCredentialsCodeAddress struct for IdentityCredentialsCodeAddress
type IdentityCredentialsCodeAddress struct {
	// The address for this code
	Address *string `json:"address,omitempty"`
	Channel *string `json:"channel,omitempty"`
}

// NewIdentityCredentialsCodeAddress instantiates a new IdentityCredentialsCodeAddress object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewIdentityCredentialsCodeAddress() *IdentityCredentialsCodeAddress {
	this := IdentityCredentialsCodeAddress{}
	return &this
}

// NewIdentityCredentialsCodeAddressWithDefaults instantiates a new IdentityCredentialsCodeAddress object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewIdentityCredentialsCodeAddressWithDefaults() *IdentityCredentialsCodeAddress {
	this := IdentityCredentialsCodeAddress{}
	return &this
}

// GetAddress returns the Address field value if set, zero value otherwise.
func (o *IdentityCredentialsCodeAddress) GetAddress() string {
	if o == nil || o.Address == nil {
		var ret string
		return ret
	}
	return *o.Address
}

// GetAddressOk returns a tuple with the Address field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *IdentityCredentialsCodeAddress) GetAddressOk() (*string, bool) {
	if o == nil || o.Address == nil {
		return nil, false
	}
	return o.Address, true
}

// HasAddress returns a boolean if a field has been set.
func (o *IdentityCredentialsCodeAddress) HasAddress() bool {
	if o != nil && o.Address != nil {
		return true
	}

	return false
}

// SetAddress gets a reference to the given string and assigns it to the Address field.
func (o *IdentityCredentialsCodeAddress) SetAddress(v string) {
	o.Address = &v
}

// GetChannel returns the Channel field value if set, zero value otherwise.
func (o *IdentityCredentialsCodeAddress) GetChannel() string {
	if o == nil || o.Channel == nil {
		var ret string
		return ret
	}
	return *o.Channel
}

// GetChannelOk returns a tuple with the Channel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *IdentityCredentialsCodeAddress) GetChannelOk() (*string, bool) {
	if o == nil || o.Channel == nil {
		return nil, false
	}
	return o.Channel, true
}

// HasChannel returns a boolean if a field has been set.
func (o *IdentityCredentialsCodeAddress) HasChannel() bool {
	if o != nil && o.Channel != nil {
		return true
	}

	return false
}

// SetChannel gets a reference to the given string and assigns it to the Channel field.
func (o *IdentityCredentialsCodeAddress) SetChannel(v string) {
	o.Channel = &v
}

func (o IdentityCredentialsCodeAddress) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Address != nil {
		toSerialize["address"] = o.Address
	}
	if o.Channel != nil {
		toSerialize["channel"] = o.Channel
	}
	return json.Marshal(toSerialize)
}

type NullableIdentityCredentialsCodeAddress struct {
	value *IdentityCredentialsCodeAddress
	isSet bool
}

func (v NullableIdentityCredentialsCodeAddress) Get() *IdentityCredentialsCodeAddress {
	return v.value
}

func (v *NullableIdentityCredentialsCodeAddress) Set(val *IdentityCredentialsCodeAddress) {
	v.value = val
	v.isSet = true
}

func (v NullableIdentityCredentialsCodeAddress) IsSet() bool {
	return v.isSet
}

func (v *NullableIdentityCredentialsCodeAddress) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableIdentityCredentialsCodeAddress(val *IdentityCredentialsCodeAddress) *NullableIdentityCredentialsCodeAddress {
	return &NullableIdentityCredentialsCodeAddress{value: val, isSet: true}
}

func (v NullableIdentityCredentialsCodeAddress) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableIdentityCredentialsCodeAddress) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
