/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// IdentityCredentialsCode CredentialsCode represents a one time login/registration code
type IdentityCredentialsCode struct {
	Addresses []IdentityCredentialsCodeAddress `json:"addresses,omitempty"`
}

// NewIdentityCredentialsCode instantiates a new IdentityCredentialsCode object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewIdentityCredentialsCode() *IdentityCredentialsCode {
	this := IdentityCredentialsCode{}
	return &this
}

// NewIdentityCredentialsCodeWithDefaults instantiates a new IdentityCredentialsCode object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewIdentityCredentialsCodeWithDefaults() *IdentityCredentialsCode {
	this := IdentityCredentialsCode{}
	return &this
}

// GetAddresses returns the Addresses field value if set, zero value otherwise.
func (o *IdentityCredentialsCode) GetAddresses() []IdentityCredentialsCodeAddress {
	if o == nil || o.Addresses == nil {
		var ret []IdentityCredentialsCodeAddress
		return ret
	}
	return o.Addresses
}

// GetAddressesOk returns a tuple with the Addresses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *IdentityCredentialsCode) GetAddressesOk() ([]IdentityCredentialsCodeAddress, bool) {
	if o == nil || o.Addresses == nil {
		return nil, false
	}
	return o.Addresses, true
}

// HasAddresses returns a boolean if a field has been set.
func (o *IdentityCredentialsCode) HasAddresses() bool {
	if o != nil && o.Addresses != nil {
		return true
	}

	return false
}

// SetAddresses gets a reference to the given []IdentityCredentialsCodeAddress and assigns it to the Addresses field.
func (o *IdentityCredentialsCode) SetAddresses(v []IdentityCredentialsCodeAddress) {
	o.Addresses = v
}

func (o IdentityCredentialsCode) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Addresses != nil {
		toSerialize["addresses"] = o.Addresses
	}
	return json.Marshal(toSerialize)
}

type NullableIdentityCredentialsCode struct {
	value *IdentityCredentialsCode
	isSet bool
}

func (v NullableIdentityCredentialsCode) Get() *IdentityCredentialsCode {
	return v.value
}

func (v *NullableIdentityCredentialsCode) Set(val *IdentityCredentialsCode) {
	v.value = val
	v.isSet = true
}

func (v NullableIdentityCredentialsCode) IsSet() bool {
	return v.isSet
}

func (v *NullableIdentityCredentialsCode) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableIdentityCredentialsCode(val *IdentityCredentialsCode) *NullableIdentityCredentialsCode {
	return &NullableIdentityCredentialsCode{value: val, isSet: true}
}

func (v NullableIdentityCredentialsCode) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableIdentityCredentialsCode) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
