/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
	"fmt"
)

// CourierMessageType It can either be `email` or `phone`
type CourierMessageType string

// List of courierMessageType
const (
	COURIERMESSAGETYPE_EMAIL CourierMessageType = "email"
	COURIERMESSAGETYPE_PHONE CourierMessageType = "phone"
)

func (v *CourierMessageType) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := CourierMessageType(value)
	for _, existing := range []CourierMessageType{"email", "phone"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid CourierMessageType", value)
}

// Ptr returns reference to courierMessageType value
func (v CourierMessageType) Ptr() *CourierMessageType {
	return &v
}

type NullableCourierMessageType struct {
	value *CourierMessageType
	isSet bool
}

func (v NullableCourierMessageType) Get() *CourierMessageType {
	return v.value
}

func (v *NullableCourierMessageType) Set(val *CourierMessageType) {
	v.value = val
	v.isSet = true
}

func (v NullableCourierMessageType) IsSet() bool {
	return v.isSet
}

func (v *NullableCourierMessageType) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCourierMessageType(val *CourierMessageType) *NullableCourierMessageType {
	return &NullableCourierMessageType{value: val, isSet: true}
}

func (v NullableCourierMessageType) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCourierMessageType) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
