/*
 * Ory Identities API
 *
 * This is the API specification for Ory Identities with features such as registration, login, recovery, account verification, profile settings, password reset, identity management, session management, email and sms delivery, and more.
 *
 * API version:
 * Contact: office@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// ContinueWithRedirectBrowserTo Indicates, that the UI flow could be continued by showing a recovery ui
type ContinueWithRedirectBrowserTo struct {
	// Action will always be `redirect_browser_to` redirect_browser_to ContinueWithActionRedirectBrowserToString
	Action string `json:"action"`
	// The URL to redirect the browser to
	RedirectBrowserTo string `json:"redirect_browser_to"`
}

// NewContinueWithRedirectBrowserTo instantiates a new ContinueWithRedirectBrowserTo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContinueWithRedirectBrowserTo(action string, redirectBrowserTo string) *ContinueWithRedirectBrowserTo {
	this := ContinueWithRedirectBrowserTo{}
	this.Action = action
	this.RedirectBrowserTo = redirectBrowserTo
	return &this
}

// NewContinueWithRedirectBrowserToWithDefaults instantiates a new ContinueWithRedirectBrowserTo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContinueWithRedirectBrowserToWithDefaults() *ContinueWithRedirectBrowserTo {
	this := ContinueWithRedirectBrowserTo{}
	return &this
}

// GetAction returns the Action field value
func (o *ContinueWithRedirectBrowserTo) GetAction() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Action
}

// GetActionOk returns a tuple with the Action field value
// and a boolean to check if the value has been set.
func (o *ContinueWithRedirectBrowserTo) GetActionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Action, true
}

// SetAction sets field value
func (o *ContinueWithRedirectBrowserTo) SetAction(v string) {
	o.Action = v
}

// GetRedirectBrowserTo returns the RedirectBrowserTo field value
func (o *ContinueWithRedirectBrowserTo) GetRedirectBrowserTo() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RedirectBrowserTo
}

// GetRedirectBrowserToOk returns a tuple with the RedirectBrowserTo field value
// and a boolean to check if the value has been set.
func (o *ContinueWithRedirectBrowserTo) GetRedirectBrowserToOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RedirectBrowserTo, true
}

// SetRedirectBrowserTo sets field value
func (o *ContinueWithRedirectBrowserTo) SetRedirectBrowserTo(v string) {
	o.RedirectBrowserTo = v
}

func (o ContinueWithRedirectBrowserTo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["action"] = o.Action
	}
	if true {
		toSerialize["redirect_browser_to"] = o.RedirectBrowserTo
	}
	return json.Marshal(toSerialize)
}

type NullableContinueWithRedirectBrowserTo struct {
	value *ContinueWithRedirectBrowserTo
	isSet bool
}

func (v NullableContinueWithRedirectBrowserTo) Get() *ContinueWithRedirectBrowserTo {
	return v.value
}

func (v *NullableContinueWithRedirectBrowserTo) Set(val *ContinueWithRedirectBrowserTo) {
	v.value = val
	v.isSet = true
}

func (v NullableContinueWithRedirectBrowserTo) IsSet() bool {
	return v.isSet
}

func (v *NullableContinueWithRedirectBrowserTo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContinueWithRedirectBrowserTo(val *ContinueWithRedirectBrowserTo) *NullableContinueWithRedirectBrowserTo {
	return &NullableContinueWithRedirectBrowserTo{value: val, isSet: true}
}

func (v NullableContinueWithRedirectBrowserTo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContinueWithRedirectBrowserTo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
