# [STEPIK]
# Программирование на Python https://stepik.org/67
# 03_07_01 Задачи по материалам недели

'''
Напишите программу, которая принимает на стандартный вход список игр футбольных команд с результатом матча и выводит на стандартный вывод сводную таблицу результатов всех матчей.

За победу команде начисляется 3 очка, за поражение — 0, за ничью — 1.

Формат ввода следующий:
В первой строке указано целое число n — количество завершенных игр.
После этого идет n строк, в которых записаны результаты игры в следующем формате:
Первая_команда;Забито_первой_командой;Вторая_команда;Забито_второй_командой

Вывод программы необходимо оформить следующим образом:
Команда:Всего_игр Побед Ничьих Поражений Всего_очков

Конкретный пример ввода-вывода приведён ниже.

Порядок вывода команд произвольный.

Sample Input:
3
Зенит;3;Спартак;1
Спартак;1;ЦСКА;1
ЦСКА;0;Зенит;2
Sample Output:
Зенит:2 2 0 0 6
ЦСКА:2 0 1 1 1
Спартак:2 0 1 1 1
'''

n = int(input())

teams = {}
games = 1
wins = 0
draws = 0
loses = 0
points = 0
#team_list = [games, wins, draws, loses, points]

i = 0

for _ in range(n):
    
	string = input().split(';')
	
	# Проверка наличия команд из ввода в словаре
	# если нет, добавляем
	# если есть, увеличиваем количество игр на 1
	
	# Проверка наличия первой команды из ввода в словаре
	if string[i] not in teams:
		teams[string[i]] = [games, wins, draws, loses, points]
	elif string[i] in teams:
		teams[string[i]][0] += 1
		
	# Проверка наличия второй команды из ввода в словаре
	if string[i+2] not in teams:
		teams[string[i+2]] = [games, wins, draws, loses, points]
	elif string[i+2] in teams:
		teams[string[i+2]][0] += 1
		
	# Проверка результатов матча
	
	if string[i+1] > string[i+3]:
		teams[string[i]][1] += 1     # Начисление победы для К1
		teams[string[i]][4] += 3     # Начисление очков победы для К1
		teams[string[i+2]][3] += 1   # Начисление поражения для К2
		teams[string[i+2]][4] += 0   # Начисление очков поражения для К2
	elif string[i+1] < string[i+3]:
		teams[string[i+2]][1] += 1   # Начисление победы для К2
		teams[string[i+2]][4] += 3   # Начисление очков победы для К2
		teams[string[i]][3] += 1     # Начисление поражения для К1
		teams[string[i]][4] += 0     # Начисление очков поражения для К1
	elif string[i+1] == string[i+3]:
		teams[string[i]][2] += 1   # Начисление ничьей для К1
		teams[string[i]][4] += 1   # Начисление очков ничьей для К1
		teams[string[i+2]][2] += 1     # Начисление ничьей для К2
		teams[string[i+2]][4] += 1     # Начисление очков ничьей для К2

for key, value in teams.items():
	row = key + ':' + ' ' + str(value[0]) + ' ' + str(value[1]) + ' ' + str(value[2]) + ' ' + str(value[3]) + ' ' + str(value[4])
	print(row) 