"""
[STEPIK]
Python: основы и применение https://stepik.org/512
03_02_08 Регулярные выражения в Python
"""

"""
Примечание:
Эта задача является дополнительной, то есть ее решение не принесет вам баллы.
Задача сложнее остальных задач из этого раздела, и идея ее решения выходит за рамки простого понимания 
регулярных выражений как средства задания шаблона строки.
Мы решили включить данную задачу в урок, чтобы показать, что регулярным выражением можно проверить 
не только "внешний вид" строки, но и заложенный в ней смысл.


Вам дана последовательность строк.
Выведите строки, содержащие двоичную запись числа, кратного 3.

Двоичной записью числа называется его запись в двоичной системе счисления.

Примечание 2:
Данная задача очень просто может быть решена приведением строки к целому числу и проверке остатка от деления на три, 
но мы все же предлагаем вам решить ее, не используя приведение к числу.

Sample Input:
0
10010
00101
01001
Not a number
1 1
0 0

Sample Output:
0
10010
01001
"""

# import re
# import sys
#
#
# for line in sys.stdin:
#     line = line.rstrip()
#     match = re.search(r'^([0-1]+)$', line)
#     if match:
#         binary = match.group(0)
#         dec = int(binary, base=2)
#         if dec % 3 == 0:
#             print(binary)

import re
import sys

pattern = "^(0|(1(01*0)*1))*$"
pattern = re.compile(pattern)
for line in sys.stdin:
    line = line.rstrip()
    if pattern.match(line):
        print(line)
