"""
Написать бесконечно работающий калькулятор. Детали реализации:
1. Пользователю предлагается выбрать действие (список действий предварительно выводится на экран):
ввод "1" - сложение (+)
ввод "2" - вычитание (-)
ввод "3" - умножение (*)
ввод "4" - деление (/)
2. Если пользователь выбирает недопустимое действие - выводится ошибка и пользователю предлагается выбрать
действие повторно
3. Если выбрано существующее действие, пользователю предлагается ввести сначала первое число, затем второе
4. Если пользователем вводится не число хотя бы в одно из двух значений - выдается ошибка и программа возвращается
к п.1
5. Если введены корректные числа - выполняем действие, выводим результат на экран и переходим к п.1
"""


while True:
    command = input('Выберите действие: 1 (+), 2 (-), 3 (*), 4 (/): ')
    if command not in '1234':
        print('Ошибка. Выберите значения: 1 (+), 2 (-), 3 (*), 4 (/)')
        continue

    a, b = input('Введите первое число: '), input('Введите второе число: ')
    try:
        a, b = float(a), float(b)
    except ValueError:
        print('На ввод принимаются только числовые значения')
        continue

    match command:
        case '1':
            print(f'{a} + {b} = {a + b}')
        case '2':
            print(f'{a} - {b} = {a - b}')
        case '3':
            print(f'{a} * {b} = {a * b}')
        case '4':
            if not b:
                print('На ноль делить нельзя')
                continue
            print(f'{a} / {b} = {a / b}')
