# what-in-the-word app
Are you learning a new language? This app will help you remember all the new vocabulary. In this app you will be able to introduce the words you want to memorize with its translation. Every day, when entering to the app you will see that translations have disappeared, and you have to write them again. Repeating this process every day will help you remember anything! There's also a practice mode that will let you test yourself at any time.

### [Click here to try the app!](https://what-in-the-word.herokuapp.com)

## Commits
Two emojis are used to describe te general purpose of the commits:

➕: Add/create/implement a new feature

🔄: Refactor/small update/fix existing features

## Handy commands
```
# Start Symfony server
symfony server:start

# Create entity
php bin/console make:entity

# db migrations
php bin/console doctrine:migrations:diff
php bin/console doctrine:migrations:migrate

# Compile css
yarn encore dev
yarn run encore dev --watch
```

## How does it work?
The most important things are **categories** and **words**. The user can create categories, and these categories are the ones that will contain words. Every word has a **main** and a **translation**. For example: _hola_ (main) / _hello_ (translation).

Once logged in, the app will show an empty workspace:
<img width="1440" alt="Screenshot 2020-10-01 at 11 29 44" src="https://user-images.githubusercontent.com/19328191/94800367-63623100-03dc-11eb-80d2-42205e3b04ee.png">

The next step is adding a category. It is as simple as clicking "Add category" button. After that, any name can be put to the category:
<img width="1440" alt="Screenshot 2020-10-01 at 11 30 01" src="https://user-images.githubusercontent.com/19328191/94800583-b63be880-03dc-11eb-8387-fdf59cecb70d.png">

Pressing enter or clicking in any part of the screen will save the name of the category. After creating it, the next step is adding new words. It can be done by clicking the button "+ Add new word". After that, a simple form will turn up:
<img width="1440" alt="Screenshot 2020-10-01 at 11 30 11" src="https://user-images.githubusercontent.com/19328191/94800824-0a46cd00-03dd-11eb-90e3-ad8de7cb2740.png">
 
This is the moment to write the **main** word and the **translation**. Once done, pressing enter or clicking the button "Create new word" will add the word in the category:
<img width="1440" alt="Screenshot 2020-10-01 at 11 30 30" src="https://user-images.githubusercontent.com/19328191/94800996-4e39d200-03dd-11eb-9f77-3942396c2b4d.png">

The word can be removed at any time. Hovering over it will turn the ➡️ into a ❌. Once ❌ is clicked the word is going to be removed:
<img width="1440" alt="Screenshot 2020-10-01 at 11 30 43" src="https://user-images.githubusercontent.com/19328191/94801345-cef8ce00-03dd-11eb-89b2-c91cb28f8783.png">

After 12 hours, the translations will disappear, and the user will have to write them again. Also, the "Practice" button will do the same, but without waiting 12 hours, so the user can practice at any time:
<img width="1440" alt="Screenshot 2020-10-01 at 11 34 35" src="https://user-images.githubusercontent.com/19328191/94801427-edf76000-03dd-11eb-8d1a-8522317b4567.png">

Now the user can practice introducing the translations and pressing enter to check if it's correct:
<img width="1440" alt="Screenshot 2020-10-01 at 11 35 00" src="https://user-images.githubusercontent.com/19328191/94801873-973e5600-03de-11eb-8416-d4cf526b65bc.png">

At any moment, the name of the category can be updated, or if needed, the category can be removed. This can be done by clicking the title of the category:
<img width="1440" alt="Screenshot 2020-10-01 at 11 35 43" src="https://user-images.githubusercontent.com/19328191/94802108-f69c6600-03de-11eb-89a6-6bce13a2abe4.png">
Pressing enter or clicking at any part of the screen will save the new name for the category. Clicking the X button will delete the category and all the words inside it.

There's no limit for adding words or categories:
<img width="1440" alt="Screenshot 2020-10-01 at 11 39 25" src="https://user-images.githubusercontent.com/19328191/94802245-33685d00-03df-11eb-949c-a9b14f70ec65.png">
