use crate::dram_lib::write_pi;

const DENALI_PI_00_DATA: u32 = 0b00000000000000000000101100000000; // PI_VERSION:RD:16:16:=0x0000 PI_DRAM_CLASS:RW:8:4:=0x0b PI_START:RW:0:1:=0x00
const DENALI_PI_01_DATA: u32 = 0b00000000000000000000000100000001; // PI_ONBUS_MBIST:RW:24:1:=0x00 PI_NOTCARE_PHYUPD:RW:16:1:=0x00 PI_INIT_LVL_EN:RW:8:1:=0x01 PI_NORMAL_LVL_SEQ:RW:0:1:=0x01
const DENALI_PI_02_DATA: u32 = 0b00000000011001000000000000000000; // PI_TRAIN_ALL_FREQ_REQ:WR:24:1:=0x00 RESERVED:RW_D:16:8:=0x64 PI_TCMD_GAP:RW:0:16:=0x0000
const DENALI_PI_03_DATA: u32 = 0b00000000000000000000000000000001; // PI_DFI_PHYMSTR_STATE_SEL_R:RW:24:1:=0x00 PI_DFI_PHYMSTR_CS_STATE_R:RW:16:1:=0x00 PI_DFI_PHYMSTR_TYPE:RW:8:2:=0x00 PI_DFI_VERSION:RW:0:1:=0x01
const DENALI_PI_04_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_PHYMSTR_MAX:RD:0:32:=0x00000000
const DENALI_PI_05_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_PHYMSTR_RESP:RD:0:20:=0x000000
const DENALI_PI_06_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_PHYUPD_RESP:RD:0:20:=0x000000
const DENALI_PI_07_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_PHYUPD_MAX:RD:0:32:=0x00000000
const DENALI_PI_08_DATA: u32 = 0b00000000000000000000000000000001; // PI_EXIT_AFTER_INIT_CALVL:RW_D:0:1:=0x01
const DENALI_PI_09_DATA: u32 = 0b00000000000000000000000000000111; // PI_FREQ_MAP:RW:0:32:=0x00000007
const DENALI_PI_10_DATA: u32 = 0b00000000000000010000000000000010; // RESERVED:RW:24:1:=0x00 PI_SW_RST_N:RW_D:16:1:=0x01 PI_INIT_DFS_CALVL_ONLY:RW:8:1:=0x00 PI_INIT_WORK_FREQ:RW:0:5:=0x02
const DENALI_PI_11_DATA: u32 = 0b00000011000000000000100000001111; // PI_PREAMBLE_SUPPORT:RW:24:2:=0x03 PI_TMPRR:RW:16:4:=0x00 PI_TMRR:RW:8:4:=0x08 PI_CS_MAP:RW:0:4:=0x0f
const DENALI_PI_12_DATA: u32 = 0b00000000000000000000000000000001; // RESERVED:RW:8:1:=0x00 PI_MCAREF_FORWARD_ONLY:RW:0:1:=0x01
const DENALI_PI_13_DATA: u32 = 0b00000000000000000000000000000101; // PI_ON_DFIBUS:RD:24:1:=0x00 PI_TREF_INTERVAL:RW:0:20:=0x000005
const DENALI_PI_14_DATA: u32 = 0b00000000000000000000000000000000; // PI_SW_WRLVL_RESP_0:RD:24:1:=0x00 PI_SWLVL_OP_DONE:RD:16:1:=0x00 PI_SWLVL_LOAD:WR:8:1:=0x00 PI_DATA_RETENTION:RD:0:1:=0x00
const DENALI_PI_15_DATA: u32 = 0b00000000000000000000000000000000; // PI_SW_RDLVL_RESP_0:RD:24:2:=0x00 PI_SW_WRLVL_RESP_3:RD:16:1:=0x00 PI_SW_WRLVL_RESP_2:RD:8:1:=0x00 PI_SW_WRLVL_RESP_1:RD:0:1:=0x00
const DENALI_PI_16_DATA: u32 = 0b00000000000000000000000000000000; // PI_SW_CALVL_RESP_0:RD:24:2:=0x00 PI_SW_RDLVL_RESP_3:RD:16:2:=0x00 PI_SW_RDLVL_RESP_2:RD:8:2:=0x00 PI_SW_RDLVL_RESP_1:RD:0:2:=0x00
const DENALI_PI_17_DATA: u32 = 0b00000000000000000000000000000000; // PI_SWLVL_WR_SLICE_0:WR:24:1:=0x00 PI_SWLVL_EXIT:WR:16:1:=0x00 PI_SWLVL_START:WR:8:1:=0x00 PI_SW_LEVELING_MODE:RW:0:3:=0x00
const DENALI_PI_18_DATA: u32 = 0b00000000000000000000000000000000; // PI_SWLVL_WR_SLICE_1:WR:24:1:=0x00 PI_SW_WDQLVL_RESP_0:RD:16:2:=0x00 PI_SWLVL_VREF_UPDATE_SLICE_0:WR:8:1:=0x00 PI_SWLVL_RD_SLICE_0:WR:0:1:=0x00
const DENALI_PI_19_DATA: u32 = 0b00000000000000000000000000000000; // PI_SWLVL_WR_SLICE_2:WR:24:1:=0x00 PI_SW_WDQLVL_RESP_1:RD:16:2:=0x00 PI_SWLVL_VREF_UPDATE_SLICE_1:WR:8:1:=0x00 PI_SWLVL_RD_SLICE_1:WR:0:1:=0x00
const DENALI_PI_20_DATA: u32 = 0b00000000000000000000000000000000; // PI_SWLVL_WR_SLICE_3:WR:24:1:=0x00 PI_SW_WDQLVL_RESP_2:RD:16:2:=0x00 PI_SWLVL_VREF_UPDATE_SLICE_2:WR:8:1:=0x00 PI_SWLVL_RD_SLICE_2:WR:0:1:=0x00
const DENALI_PI_21_DATA: u32 = 0b00000000000000000000000000000000; // PI_SWLVL_SM2_START:WR:24:1:=0x00 PI_SW_WDQLVL_RESP_3:RD:16:2:=0x00 PI_SWLVL_VREF_UPDATE_SLICE_3:WR:8:1:=0x00 PI_SWLVL_RD_SLICE_3:WR:0:1:=0x00
const DENALI_PI_22_DATA: u32 = 0b00000000000000000000000000000000; // PI_DFS_PERIOD_EN:RW:24:1:=0x00 PI_SEQUENTIAL_LVL_REQ:WR:16:1:=0x00 PI_SWLVL_SM2_RD:WR:8:1:=0x00 PI_SWLVL_SM2_WR:WR:0:1:=0x00
const DENALI_PI_23_DATA: u32 = 0b00000001000000010000000000000000; // PI_16BIT_DRAM_CONNECT:RW_D:24:1:=0x01 PI_DFI40_POLARITY:RW:16:1:=0x01 PI_MPD_PERIOD_EN:RW:8:1:=0x00 PI_SRE_PERIOD_EN:RW:0:1:=0x00
const DENALI_PI_24_DATA: u32 = 0b00101000000010100000000000000000; // PI_WLMRD:RW:24:6:=0x28 PI_WLDQSEN:RW:16:6:=0x0a PI_WRLVL_CS:RW:8:2:=0x00 PI_WRLVL_REQ:WR:0:1:=0x00
const DENALI_PI_25_DATA: u32 = 0b00000000000000000000000000000000; // PI_WRLVL_ON_SREF_EXIT:RW:24:1:=0x00 PI_WRLVL_PERIODIC:RW:16:1:=0x00 PI_WRLVL_INTERVAL:RW:0:16:=0x0000
const DENALI_PI_26_DATA: u32 = 0b00000000000000000000000000000001; // PI_WRLVL_ROTATE:RW:24:1:=0x00 PI_WRLVL_RESP_MASK:RW:16:4:=0x00 PI_WRLVL_DISABLE_DFS:RW:8:1:=0x00 PI_WRLVL_ON_DPDX:RW:0:1:=0x01
const DENALI_PI_27_DATA: u32 = 0b00110010000000000000000000001111; // PI_TDFI_WRLVL_EN:RW:24:8:=0x32 PI_WRLVL_ERROR_STATUS:RD:16:1:=0x00 PI_WRLVL_ON_MPD_EXIT:RW:8:1:=0x00 PI_WRLVL_CS_MAP:RW:0:4:=0x0f
const DENALI_PI_28_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_WRLVL_RESP:RW:0:32:=0x00000000
const DENALI_PI_29_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_WRLVL_MAX:RW:0:32:=0x00000000
const DENALI_PI_30_DATA: u32 = 0b00000000000000010000000100000010; // PI_EN_ODT_ASSERT_EXCEPT_RD:RW:24:1:=0x00 PI_TODTH_RD:RW:16:4:=0x01 PI_TODTH_WR:RW:8:4:=0x01 PI_WRLVL_STROBE_NUM:RW:0:5:=0x02
const DENALI_PI_31_DATA: u32 = 0b00000000000000000000000000000001; // PI_ADDRESS_MIRRORING:RW:8:4:=0x00 PI_ODT_VALUE:RW:0:4:=0x01
const DENALI_PI_32_DATA: u32 = 0b00000000000000000000000000000000; // PI_CA_PARITY_ERROR_INJECT:RW:0:25:=0x00000000
const DENALI_PI_33_DATA: u32 = 0b00000000000000000000000000000000; // PI_RDLVL_GATE_REQ:WR:24:1:=0x00 PI_RDLVL_REQ:WR:16:1:=0x00 RESERVED:RW:8:4:=0x00 RESERVED:RW+:0:3:=0x00
const DENALI_PI_34_DATA: u32 = 0b00000000000000000000000000000000; // PI_RDLVL_CS:RW:0:2:=0x00
const DENALI_PI_35_DATA: u32 = 0b00000000000000000000000010101010; // PI_RDLVL_PAT_0:RW:0:32:=0x000000aa
const DENALI_PI_36_DATA: u32 = 0b00000000000000000000000001010101; // PI_RDLVL_PAT_1:RW:0:32:=0x00000055
const DENALI_PI_37_DATA: u32 = 0b00000000000000000000000010110101; // PI_RDLVL_PAT_2:RW:0:32:=0x000000b5
const DENALI_PI_38_DATA: u32 = 0b00000000000000000000000001001010; // PI_RDLVL_PAT_3:RW:0:32:=0x0000004a
const DENALI_PI_39_DATA: u32 = 0b00000000000000000000000001010110; // PI_RDLVL_PAT_4:RW:0:32:=0x00000056
const DENALI_PI_40_DATA: u32 = 0b00000000000000000000000010101001; // PI_RDLVL_PAT_5:RW:0:32:=0x000000a9
const DENALI_PI_41_DATA: u32 = 0b00000000000000000000000010101001; // PI_RDLVL_PAT_6:RW:0:32:=0x000000a9
const DENALI_PI_42_DATA: u32 = 0b00000000000000000000000010110101; // PI_RDLVL_PAT_7:RW:0:32:=0x000000b5
const DENALI_PI_43_DATA: u32 = 0b00000001000000000000000000000000; // PI_RDLVL_ON_DPDX:RW:24:1:=0x01 PI_RDLVL_ON_SREF_EXIT:RW:16:1:=0x00 PI_RDLVL_PERIODIC:RW:8:1:=0x00 PI_RDLVL_SEQ_EN:RW:0:4:=0x00
const DENALI_PI_44_DATA: u32 = 0b00000001000000000000000000000000; // PI_RDLVL_GATE_ON_DPDX:RW:24:1:=0x01 PI_RDLVL_GATE_ON_SREF_EXIT:RW:16:1:=0x00 PI_RDLVL_GATE_PERIODIC:RW:8:1:=0x00 PI_RDLVL_DISABLE_DFS:RW:0:1:=0x00
const DENALI_PI_45_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 PI_RDLVL_GATE_ON_MPD_EXIT:RW:16:1:=0x00 PI_RDLVL_ON_MPD_EXIT:RW:8:1:=0x00 PI_RDLVL_GATE_DISABLE_DFS:RW:0:1:=0x00
const DENALI_PI_46_DATA: u32 = 0b00001111000011110000000000000000; // PI_RDLVL_GATE_CS_MAP:RW:24:4:=0x0f PI_RDLVL_CS_MAP:RW:16:4:=0x0f PI_RDLVL_GATE_ROTATE:RW:8:1:=0x00 PI_RDLVL_ROTATE:RW:0:1:=0x00
const DENALI_PI_47_DATA: u32 = 0b00000000000000000000000000010100; // PI_TDFI_RDLVL_RR:RW:0:10:=0x0014
const DENALI_PI_48_DATA: u32 = 0b00000000000000000000011111010000; // PI_TDFI_RDLVL_RESP:RW:0:32:=0x000007d0
const DENALI_PI_49_DATA: u32 = 0b00000000000000000000001100000000; // PI_TDFI_RDLVL_EN:RW:8:8:=0x03 PI_RDLVL_RESP_MASK:RW:0:4:=0x00
const DENALI_PI_50_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_RDLVL_MAX:RW:0:32:=0x00000000
const DENALI_PI_51_DATA: u32 = 0b00000000000000000000000000000000; // PI_RDLVL_INTERVAL:RW:8:16:=0x0000 PI_RDLVL_ERROR_STATUS:RD:0:1:=0x00
const DENALI_PI_52_DATA: u32 = 0b00000001000000000000000000000000; // PI_RDLVL_PATTERN_NUM:RW:24:4:=0x01 PI_RDLVL_PATTERN_START:RW:16:4:=0x00 PI_RDLVL_GATE_INTERVAL:RW:0:16:=0x0000
const DENALI_PI_53_DATA: u32 = 0b00000000000000010000000100000001; // PI_REG_DIMM_ENABLE:RW:24:1:=0x00 PI_RD_PREAMBLE_TRAINING_EN:RW:16:1:=0x01 PI_RDLVL_GATE_STROBE_NUM:RW:8:5:=0x01 PI_RDLVL_STROBE_NUM:RW:0:5:=0x01
const DENALI_PI_54_DATA: u32 = 0b00000000000000000000000000000000; // PI_CALVL_CS:RW:24:2:=0x00 PI_CALVL_REQ:WR:16:1:=0x00 PI_TDFI_PHY_WRLAT:RD:8:8:=0x00 PI_TDFI_RDDATA_EN:RD:0:8:=0x00
const DENALI_PI_55_DATA: u32 = 0b00000000000000110000000000000000; // PI_CALVL_PERIODIC:RW:24:1:=0x00 PI_CALVL_SEQ_EN:RW:16:2:=0x03 RESERVED:RW:8:4:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_56_DATA: u32 = 0b00000000000000000000000100000000; // PI_CALVL_ROTATE:RW:24:1:=0x00 PI_CALVL_DISABLE_DFS:RW:16:1:=0x00 PI_CALVL_ON_DPDX:RW:8:1:=0x01 PI_CALVL_ON_SREF_EXIT:RW:0:1:=0x00
const DENALI_PI_57_DATA: u32 = 0b00000000000000000001011100001111; // PI_TDFI_CALVL_EN:RW:8:8:=0x17 PI_CALVL_CS_MAP:RW:0:4:=0x0f
const DENALI_PI_58_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_CALVL_RESP:RW:0:32:=0x00000000
const DENALI_PI_59_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_CALVL_MAX:RW:0:32:=0x00000000
const DENALI_PI_60_DATA: u32 = 0b00000000000000000000000000000000; // PI_CALVL_INTERVAL:RW:16:16:=0x0000 PI_CALVL_ERROR_STATUS:RD:8:2:=0x00 PI_CALVL_RESP_MASK:RW:0:1:=0x00
const DENALI_PI_61_DATA: u32 = 0b00001010000101000000101000000001; // PI_TCACKEH:RW:24:5:=0x0a PI_TCAMRD:RW:16:6:=0x14 PI_TCACKEL:RW:8:5:=0x0a PI_CALVL_MAX_STROBE_PEND:RW:0:4:=0x01
const DENALI_PI_62_DATA: u32 = 0b00000010000001000000000100001010; // PI_CALVL_VREF_NORMAL_STEPSIZE:RW:24:4:=0x02 PI_CALVL_VREF_INITIAL_STEPSIZE:RW:16:4:=0x04 PI_CA_TRAIN_VREF_EN:RW:8:1:=0x01 PI_TCAEXT:RW:0:5:=0x0a
const DENALI_PI_63_DATA: u32 = 0b00000010000010000000010100010000; // PI_CALVL_STROBE_NUM:RW:24:5:=0x02 PI_TCKCKEH:RW:16:4:=0x08 PI_TDFI_INIT_COMPLETE_MIN:RW:8:8:=0x05 PI_TDFI_INIT_START_MIN:RW:0:8:=0x10
const DENALI_PI_64_DATA: u32 = 0b00000000000001000000010000000000; // PI_DRAM_CLK_DISABLE_DEASSERT_SEL:RW:24:1:=0x00 PI_INIT_STARTORCOMPLETE_2_CLKDISABLE:RW:16:8:=0x04 PI_CLKDISABLE_2_INIT_START:RW:8:8:=0x04 PI_SW_CA_TRAIN_VREF:RW:0:7:=0x00
const DENALI_PI_65_DATA: u32 = 0b00000001000000000000000100000001; // PI_VREFLVL_DISABLE_DFS:RW:24:1:=0x01 PI_VREF_PDA_EN:RW:16:1:=0x00 PI_VREF_CS:RW:8:2:=0x01 PI_REFRESH_BETWEEN_SEGMENT_DISABLE:RW_D:0:1:=0x01
const DENALI_PI_66_DATA: u32 = 0b00000000000000010000000100000000; // PI_WDQLVL_RESP_MASK:RW:24:4:=0x00 PI_WDQLVL_BST_NUM:RW:16:3:=0x01 PI_WDQLVL_VREF_EN:RW:8:1:=0x01 PI_MC_DFS_PI_SET_VREF_ENABLE:RW:0:1:=0x00
const DENALI_PI_67_DATA: u32 = 0b00000010000001000000111100000000; // PI_WDQLVL_VREF_NORMAL_STEPSIZE:RW:24:5:=0x02 PI_WDQLVL_VREF_INITIAL_STEPSIZE:RW:16:5:=0x04 PI_WDQLVL_CS_MAP:RW:8:4:=0x0f PI_WDQLVL_ROTATE:RW:0:1:=0x00
const DENALI_PI_68_DATA: u32 = 0b00110100000000000000000000000000; // PI_TDFI_WDQLVL_EN:RW:24:8:=0x34 PI_WDQLVL_CS:RW:16:2:=0x00 PI_WDQLVL_REQ:WR:8:1:=0x00 PI_WDQLVL_PERIODIC:RW:0:1:=0x00
const DENALI_PI_69_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_WDQLVL_RESP:RW:0:32:=0x00000000
const DENALI_PI_70_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDFI_WDQLVL_MAX:RW:0:32:=0x00000000
const DENALI_PI_71_DATA: u32 = 0b00000001000000000000000000000000; // PI_WDQLVL_ON_DPDX:RW:24:1:=0x01 PI_WDQLVL_ON_SREF_EXIT:RW:16:1:=0x00 PI_WDQLVL_INTERVAL:RW:0:16:=0x0000
const DENALI_PI_72_DATA: u32 = 0b00000000000000000000000000000000; // PI_WDQLVL_NEED_SAVE_RESTORE:RW:24:2:=0x00 PI_WDQLVL_ERROR_STATUS:RD:16:2:=0x00 PI_WDQLVL_DISABLE_DFS:RW:8:1:=0x00 PI_WDQLVL_ON_MPD_EXIT:RW:0:1:=0x00
const DENALI_PI_73_DATA: u32 = 0b00000000000000000000000000000000; // PI_WDQLVL_DRAM_LVL_START_ADDR:RW:0:36:=0x00000000
const DENALI_PI_74_DATA: u32 = 0b00000000000000000000000000000000; // PI_NO_MEMORY_DM:RW:16:1:=0x00 PI_WDQLVL_DM_LEVEL_EN:RW:8:1:=0x00 PI_WDQLVL_DRAM_LVL_START_ADDR:RW:0:36:=0x00
const DENALI_PI_75_DATA: u32 = 0b00000000000000000000000000000000; // PI_WDQLVL_NIBBLE_MODE:RW:24:1:=0x00 PI_SWLVL_SM2_DM_NIBBLE_START:WR:16:1:=0x00 PI_TDFI_WDQLVL_WW:RW:0:10:=0x0000
const DENALI_PI_76_DATA: u32 = 0b00000000000000010000000100000000; // PI_DBILVL_RESP_MASK:RW:24:4:=0x00 PI_PARALLEL_WDQLVL_EN:RW:16:1:=0x01 PI_WDQLVL_PDA_VREF_TRAIN:RW:8:1:=0x01 PI_WDQLVL_PDA_EN:RW:0:1:=0x00
const DENALI_PI_77_DATA: u32 = 0b00000000000010000000000100000001; // RESERVED:RW_D:24:4:=0x00 PI_TCCD:RW:16:5:=0x08 PI_ROW_DIFF:RW:8:3:=0x01 PI_BANK_DIFF:RW:0:2:=0x01
const DENALI_PI_78_DATA: u32 = 0b00000010000000000000001000000000; // RESERVED:RW_D:24:4:=0x02 RESERVED:RW_D:16:4:=0x00 RESERVED:RW_D:8:4:=0x02 RESERVED:RW_D:0:4:=0x00
const DENALI_PI_79_DATA: u32 = 0b00000001000000000000000100000000; // RESERVED:RW_D:24:4:=0x01 RESERVED:RW_D:16:4:=0x00 RESERVED:RW_D:8:4:=0x01 RESERVED:RW_D:0:4:=0x00
const DENALI_PI_80_DATA: u32 = 0b00000001000000000000000000000000; // RESERVED:RW_D:24:4:=0x01 RESERVED:RW_D:16:4:=0x00 RESERVED:RW_D:8:4:=0x00 RESERVED:RW_D:0:4:=0x00
const DENALI_PI_81_DATA: u32 = 0b00000010000000000000001000000000; // RESERVED:RW_D:24:4:=0x02 RESERVED:RW_D:16:4:=0x00 RESERVED:RW_D:8:4:=0x02 RESERVED:RW_D:0:4:=0x00
const DENALI_PI_82_DATA: u32 = 0b00000000000000000000001000000000; // RESERVED:RW_D:16:4:=0x00 RESERVED:RW_D:8:4:=0x02 RESERVED:RW_D:0:4:=0x00
const DENALI_PI_83_DATA: u32 = 0b00000000000000000000000000000000; // PI_INT_STATUS:RD:0:28:=0x00000000
const DENALI_PI_84_DATA: u32 = 0b00000000000000000000000000000000; // PI_INT_ACK:WR:0:27:=0x00000000
const DENALI_PI_85_DATA: u32 = 0b00000000000000000000000000000000; // PI_INT_MASK:RW:0:28:=0x00000000
const DENALI_PI_86_DATA: u32 = 0b00001110000000000000000000000100; // PI_PARITY_IN_MUX:RW_D:24:5:=0x0e PI_CMD_SWAP_EN:RW_D:16:1:=0x00 PI_LONG_COUNT_MASK:RW:8:5:=0x00 PI_BSTLEN:RW_D:0:5:=0x04
const DENALI_PI_87_DATA: u32 = 0b00001100000011010001000000001111; // PI_CAS_N_MUX:RW_D:24:5:=0x0c PI_RAS_N_MUX:RW_D:16:5:=0x0d PI_A14_MUX:RW_D:8:5:=0x10 PI_A15_MUX:RW_D:0:5:=0x0f
const DENALI_PI_88_DATA: u32 = 0b00001010000010010000100000001011; // PI_BANK_MUX_2:RW_D:24:5:=0x0a PI_BANK_MUX_1:RW_D:16:5:=0x09 PI_BANK_MUX_0:RW_D:8:5:=0x08 PI_WE_N_MUX:RW_D:0:5:=0x0b
const DENALI_PI_89_DATA: u32 = 0b00000010000000010000000000000000; // PI_DATA_BYTE_SWAP_SLICE2:RW_D:24:2:=0x02 PI_DATA_BYTE_SWAP_SLICE1:RW_D:16:2:=0x01 PI_DATA_BYTE_SWAP_SLICE0:RW_D:8:2:=0x00 PI_DATA_BYTE_SWAP_EN:RW_D:0:1:=0x00
const DENALI_PI_90_DATA: u32 = 0b00000000000010000000000100000011; // PI_UPDATE_ERROR_STATUS:RD:24:2:=0x00 PI_TDFI_CTRLUPD_MIN:RW:16:8:=0x08 PI_CTRLUPD_REQ_PER_AREF_EN:RW:8:1:=0x01 PI_DATA_BYTE_SWAP_SLICE3:RW_D:0:2:=0x03
const DENALI_PI_91_DATA: u32 = 0b00000000000000000000001000000000; // PI_SELF_REFRESH_EN:RW:24:1:=0x00 PI_BG_ROTATE_EN:RW:16:1:=0x00 PI_COL_DIFF:RW:8:4:=0x02 PI_TDFI_PARIN_LAT:RW:0:3:=0x00
const DENALI_PI_92_DATA: u32 = 0b00000000000000000000000000000000; // PI_NO_MRW_BT_INIT:RW:24:1:=0x00 PI_SREF_ENTRY_REQ:WR:16:1:=0x00 PI_SREFRESH_EXIT_NO_REFRESH:RW:8:1:=0x00 PI_PWRUP_SREFRESH_EXIT:RW+:0:1:=0x00
const DENALI_PI_93_DATA: u32 = 0b00001111000000000000000000000000; // PI_PWRUP_SREFRESH_EXIT_CS:RW:24:4:=0x0f PI_NO_AUTO_MRR_INIT:RW:16:1:=0x00 PI_NO_PHY_IND_TRAIN_INIT:RW:8:1:=0x00 PI_NO_MRW_INIT:RW:0:1:=0x00
const DENALI_PI_94_DATA: u32 = 0b00000000000000000000000000000100; // PI_TRST_PWRON:RW:0:32:=0x00000004
const DENALI_PI_95_DATA: u32 = 0b00000000000000000000000000001010; // PI_CKE_INACTIVE:RW:0:32:=0x0000000a
const DENALI_PI_96_DATA: u32 = 0b00000000000000000000000000000000; // PI_DLL_RST_DELAY:RW:16:16:=0x0000 PI_DRAM_INIT_EN:RW:8:1:=0x00 PI_DLL_RST:RW:0:1:=0x00
const DENALI_PI_97_DATA: u32 = 0b00000000000000000000000000000000; // PI_DLL_RST_ADJ_DLY:RW:0:8:=0x00
const DENALI_PI_98_DATA: u32 = 0b00000000000000000000000000000000; // PI_WRITE_MODEREG:RW+:0:26:=0x00000000
const DENALI_PI_99_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:8:1:=0x00 PI_MRW_STATUS:RD:0:8:=0x00
const DENALI_PI_100_DATA: u32 = 0b00000000000000000000000000000000; // PI_READ_MODEREG:RW+:0:17:=0x000000
const DENALI_PI_101_DATA: u32 = 0b00000000000000000000000000000000; // PI_PERIPHERAL_MRR_DATA:RD:0:40:=0x00000000
const DENALI_PI_102_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:WR:24:4:=0x00 RESERVED:RW:16:4:=0x00 PI_NO_ZQ_INIT:RW:8:1:=0x00 PI_PERIPHERAL_MRR_DATA:RD:0:40:=0x00
const DENALI_PI_103_DATA: u32 = 0b00000000000000110000000100000000; // PI_MONITOR_SRC_SEL_0:RW:24:4:=0x00 RESERVED:RW:16:3:=0x03 RESERVED:RW:8:1:=0x01 PI_ZQ_REQ_PENDING:RD:0:1:=0x00
const DENALI_PI_104_DATA: u32 = 0b00000001000000010000000000000001; // PI_MONITOR_CAP_SEL_1:RW:24:1:=0x01 PI_MONITOR_SRC_SEL_1:RW:16:4:=0x01 PI_MONITOR_0:RD:8:8:=0x00 PI_MONITOR_CAP_SEL_0:RW:0:1:=0x01
const DENALI_PI_105_DATA: u32 = 0b00000000000000010000001000000000; // PI_MONITOR_2:RD:24:8:=0x00 PI_MONITOR_CAP_SEL_2:RW:16:1:=0x01 PI_MONITOR_SRC_SEL_2:RW:8:4:=0x02 PI_MONITOR_1:RD:0:8:=0x00
const DENALI_PI_106_DATA: u32 = 0b00000100000000000000000100000011; // PI_MONITOR_SRC_SEL_4:RW:24:4:=0x04 PI_MONITOR_3:RD:16:8:=0x00 PI_MONITOR_CAP_SEL_3:RW:8:1:=0x01 PI_MONITOR_SRC_SEL_3:RW:0:4:=0x03
const DENALI_PI_107_DATA: u32 = 0b00000001000001010000000000000001; // PI_MONITOR_CAP_SEL_5:RW:24:1:=0x01 PI_MONITOR_SRC_SEL_5:RW:16:4:=0x05 PI_MONITOR_4:RD:8:8:=0x00 PI_MONITOR_CAP_SEL_4:RW:0:1:=0x01
const DENALI_PI_108_DATA: u32 = 0b00000000000000010000011000000000; // PI_MONITOR_6:RD:24:8:=0x00 PI_MONITOR_CAP_SEL_6:RW:16:1:=0x01 PI_MONITOR_SRC_SEL_6:RW:8:4:=0x06 PI_MONITOR_5:RD:0:8:=0x00
const DENALI_PI_109_DATA: u32 = 0b00000000000000000000000100000111; // PI_MONITOR_7:RD:16:8:=0x00 PI_MONITOR_CAP_SEL_7:RW:8:1:=0x01 PI_MONITOR_SRC_SEL_7:RW:0:4:=0x07
const DENALI_PI_110_DATA: u32 = 0b00000000000000000000000000000000; // PI_MONITOR_STROBE:WR:0:8:=0x00
const DENALI_PI_111_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 PI_FREQ_RETENTION_NUM:RW+:16:5:=0x00 PI_FREQ_NUMBER_STATUS:RD:8:5:=0x00 PI_DLL_LOCK:RD:0:1:=0x00
const DENALI_PI_112_DATA: u32 = 0b00000000000000010000000000000001; // RESERVED:RW:24:1:=0x00 PI_POWER_REDUC_EN:RW:16:1:=0x01 RESERVED:RW:8:1:=0x00 PI_PHYMSTR_TYPE:RW:0:2:=0x01
const DENALI_PI_113_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 RESERVED:RW:16:1:=0x00 RESERVED:RW:8:1:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_114_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 RESERVED:RW:16:1:=0x00 RESERVED:RW:8:1:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_115_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 RESERVED:RW:16:1:=0x00 RESERVED:RW:8:1:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_116_DATA: u32 = 0b00000000000000000000000000000000; // RESERVED:RW:24:1:=0x00 RESERVED:RW:16:1:=0x00 RESERVED:RW:8:1:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_117_DATA: u32 = 0b00000000000000010000000000000000; // PI_WRLVL_MAX_STROBE_PEND:RW:16:8:=0x01 RESERVED:RW:8:1:=0x00 RESERVED:RW:0:1:=0x00
const DENALI_PI_118_DATA: u32 = 0b00000000000000000000000000000100; // PI_TREFBW_THR:RW:0:9:=0x0004
const DENALI_PI_119_DATA: u32 = 0b00000000000000000000000000000000; // PI_FREQ_CHANGE_REG_COPY:RW:0:5:=0x00
const DENALI_PI_120_DATA: u32 = 0b00000000000000010000000000000000; // PI_CATR:RW:24:4:=0x00 PI_PARALLEL_CALVL_EN:RW:16:1:=0x01 RESERVED:RW:8:5:=0x00 PI_FREQ_SEL_FROM_REGIF:RW:0:1:=0x00
const DENALI_PI_121_DATA: u32 = 0b00000000000000000000000000000000; // PI_NOTCARE_MC_INIT_START:RW:24:1:=0x00 PI_DISCONNECT_MC:RW:16:1:=0x00 PI_MASK_INIT_COMPLETE:RW:8:1:=0x00 PI_NO_CATR_READ:RW:0:1:=0x00
const DENALI_PI_122_DATA: u32 = 0b00000000001111000000000000000011; // PI_TVREF_F1:RW:16:16:=0x003c PI_TVREF_F0:RW:0:16:=0x0003
const DENALI_PI_123_DATA: u32 = 0b00001000000000010000000010100000; // PI_TSDO_F1:RW:24:8:=0x08 PI_TSDO_F0:RW:16:8:=0x01 PI_TVREF_F2:RW:0:16:=0x00a0
const DENALI_PI_124_DATA: u32 = 0b00000000000000000000000000010110; // PI_TSDO_F2:RW:0:8:=0x16
const DENALI_PI_125_DATA: u32 = 0b00000000000000000000000000101100; // PI_TDELAY_RDWR_2_BUS_IDLE_F0:RW:0:8:=0x2c
const DENALI_PI_126_DATA: u32 = 0b00000000000000000000000000110011; // PI_TDELAY_RDWR_2_BUS_IDLE_F1:RW:0:8:=0x33
const DENALI_PI_127_DATA: u32 = 0b00000000000000100000000001000011; // PI_ZQINIT_F0:RW_D:8:12:=0x0200 PI_TDELAY_RDWR_2_BUS_IDLE_F2:RW:0:8:=0x43
const DENALI_PI_128_DATA: u32 = 0b00000010000000000000001000000000; // PI_ZQINIT_F2:RW_D:16:12:=0x0200 PI_ZQINIT_F1:RW_D:0:12:=0x0200
const DENALI_PI_129_DATA: u32 = 0b00000000000000000000000000000100; // PI_TPARITY_ERROR_CMD_INHIBIT_F0:RW:24:8:=0x00 PI_CA_PARITY_LAT_F0:RW:16:4:=0x00 PI_ADDITIVE_LAT_F0:RW:8:6:=0x00 PI_WRLAT_F0:RW:0:7:=0x04
const DENALI_PI_130_DATA: u32 = 0b00000000000000000000011000001100; // PI_CA_PARITY_LAT_F1:RW:24:4:=0x00 PI_ADDITIVE_LAT_F1:RW:16:6:=0x00 PI_WRLAT_F1:RW:8:7:=0x06 PI_CASLAT_LIN_F0:RW:0:7:=0x0c
const DENALI_PI_131_DATA: u32 = 0b00000000000010100001010000000000; // PI_ADDITIVE_LAT_F2:RW:24:6:=0x00 PI_WRLAT_F2:RW:16:7:=0x0a PI_CASLAT_LIN_F1:RW:8:7:=0x14 PI_TPARITY_ERROR_CMD_INHIBIT_F1:RW:0:8:=0x00
const DENALI_PI_132_DATA: u32 = 0b00000000001010000000000000000000; // PI_CASLAT_LIN_F2:RW:16:7:=0x28 PI_TPARITY_ERROR_CMD_INHIBIT_F2:RW:8:8:=0x00 PI_CA_PARITY_LAT_F2:RW:0:4:=0x00
const DENALI_PI_133_DATA: u32 = 0b00000000000000000000000000000110; // PI_TRFC_F0:RW:0:10:=0x0006
const DENALI_PI_134_DATA: u32 = 0b00000000000000000000000001000110; // PI_TREF_F0:RW:0:20:=0x000046
const DENALI_PI_135_DATA: u32 = 0b00000000000000000000000001110000; // PI_TRFC_F1:RW:0:10:=0x0070
const DENALI_PI_136_DATA: u32 = 0b00000000000000000000011000010000; // PI_TREF_F1:RW:0:20:=0x000610
const DENALI_PI_137_DATA: u32 = 0b00000000000000000000000100101011; // PI_TRFC_F2:RW:0:10:=0x012b
const DENALI_PI_138_DATA: u32 = 0b00000100000000000001000000110101; // PI_TDFI_CTRL_DELAY_F0:RW_D:24:4:=0x04 PI_TREF_F2:RW:0:20:=0x001035
const DENALI_PI_139_DATA: u32 = 0b00000001000000010000010000000100; // PI_WRLVL_EN_F1:RW:24:2:=0x01 PI_WRLVL_EN_F0:RW:16:2:=0x01 PI_TDFI_CTRL_DELAY_F2:RW_D:8:4:=0x04 PI_TDFI_CTRL_DELAY_F1:RW_D:0:4:=0x04
const DENALI_PI_140_DATA: u32 = 0b00000000000000000001111000000001; // PI_TDFI_WRLVL_WW_F0:RW:8:10:=0x001e PI_WRLVL_EN_F2:RW:0:2:=0x01
const DENALI_PI_141_DATA: u32 = 0b00000000000111100000000000011110; // PI_TDFI_WRLVL_WW_F2:RW:16:10:=0x001e PI_TDFI_WRLVL_WW_F1:RW:0:10:=0x001e
const DENALI_PI_142_DATA: u32 = 0b00000001000000000000000100000000; // PI_ODT_EN_F1:RW:24:1:=0x01 PI_TODTL_2CMD_F1:RW:16:8:=0x00 PI_ODT_EN_F0:RW:8:1:=0x01 PI_TODTL_2CMD_F0:RW:0:8:=0x00
const DENALI_PI_143_DATA: u32 = 0b00000000000000000000000100000000; // PI_TODTON_MIN_F0:RW:24:4:=0x00 PI_ODTLON_F0:RW:16:4:=0x00 PI_ODT_EN_F2:RW:8:1:=0x01 PI_TODTL_2CMD_F2:RW:0:8:=0x00
const DENALI_PI_144_DATA: u32 = 0b00000000000000000000000000000000; // PI_TODTON_MIN_F2:RW:24:4:=0x00 PI_ODTLON_F2:RW:16:4:=0x00 PI_TODTON_MIN_F1:RW:8:4:=0x00 PI_ODTLON_F1:RW:0:4:=0x00
const DENALI_PI_145_DATA: u32 = 0b00000101000001100000010000000011; // PI_RD_TO_ODTH_F0:RW:24:6:=0x05 PI_WR_TO_ODTH_F2:RW:16:6:=0x06 PI_WR_TO_ODTH_F1:RW:8:6:=0x04 PI_WR_TO_ODTH_F0:RW:0:6:=0x03
const DENALI_PI_146_DATA: u32 = 0b00000001000000010001000100001000; // PI_RDLVL_GATE_EN_F0:RW:24:2:=0x01 PI_RDLVL_EN_F0:RW:16:2:=0x01 PI_RD_TO_ODTH_F2:RW:8:6:=0x11 PI_RD_TO_ODTH_F1:RW:0:6:=0x08
const DENALI_PI_147_DATA: u32 = 0b00000001000000010000000100000001; // PI_RDLVL_GATE_EN_F2:RW:24:2:=0x01 PI_RDLVL_EN_F2:RW:16:2:=0x01 PI_RDLVL_GATE_EN_F1:RW:8:2:=0x01 PI_RDLVL_EN_F1:RW:0:2:=0x01
const DENALI_PI_148_DATA: u32 = 0b00000000000011110000101000001010; // PI_RDLVL_PAT0_EN_F0:RW:24:2:=0x00 PI_TWR_MPR_F2:RW:16:8:=0x0f PI_TWR_MPR_F1:RW:8:8:=0x0a PI_TWR_MPR_F0:RW:0:8:=0x0a
const DENALI_PI_149_DATA: u32 = 0b00000000000000000000000000000000; // PI_RDLVL_PAT0_EN_F1:RW:24:2:=0x00 PI_RDLVL_MULTI_EN_F0:RW:16:2:=0x00 PI_RDLVL_DFE_EN_F0:RW:8:2:=0x00 PI_RDLVL_RXCAL_EN_F0:RW:0:2:=0x00
const DENALI_PI_150_DATA: u32 = 0b00000000000000000000000000000000; // PI_RDLVL_PAT0_EN_F2:RW:24:2:=0x00 PI_RDLVL_MULTI_EN_F1:RW:16:2:=0x00 PI_RDLVL_DFE_EN_F1:RW:8:2:=0x00 PI_RDLVL_RXCAL_EN_F1:RW:0:2:=0x00
const DENALI_PI_151_DATA: u32 = 0b00000100000000000000000000000000; // PI_RDLAT_ADJ_F0:RW:24:8:=0x04 PI_RDLVL_MULTI_EN_F2:RW:16:2:=0x00 PI_RDLVL_DFE_EN_F2:RW:8:2:=0x00 PI_RDLVL_RXCAL_EN_F2:RW:0:2:=0x00
const DENALI_PI_152_DATA: u32 = 0b00000100000000100001000000001000; // PI_WRLAT_ADJ_F1:RW:24:8:=0x04 PI_WRLAT_ADJ_F0:RW:16:8:=0x02 PI_RDLAT_ADJ_F2:RW:8:8:=0x10 PI_RDLAT_ADJ_F1:RW:0:8:=0x08
const DENALI_PI_153_DATA: u32 = 0b00000100000000100000001000000110; // PI_TDFI_PHY_WRDATA_F2:RW:24:3:=0x04 PI_TDFI_PHY_WRDATA_F1:RW:16:3:=0x02 PI_TDFI_PHY_WRDATA_F0:RW:8:3:=0x02 PI_WRLAT_ADJ_F2:RW:0:8:=0x06
const DENALI_PI_154_DATA: u32 = 0b00000000000011000000000000110100; // PI_TDFI_CALVL_CAPTURE_F0:RW:16:10:=0x000c PI_TDFI_CALVL_CC_F0:RW:0:10:=0x0034
const DENALI_PI_155_DATA: u32 = 0b00000000000100000000000000111000; // PI_TDFI_CALVL_CAPTURE_F1:RW:16:10:=0x0010 PI_TDFI_CALVL_CC_F1:RW:0:10:=0x0038
const DENALI_PI_156_DATA: u32 = 0b00000000000101110000000000111111; // PI_TDFI_CALVL_CAPTURE_F2:RW:16:10:=0x0017 PI_TDFI_CALVL_CC_F2:RW:0:10:=0x003f
const DENALI_PI_157_DATA: u32 = 0b00000000000000010000000000000001; // PI_CALVL_AREF_LP3_EN_F1:RW:24:1:=0x00 PI_CALVL_EN_F1:RW:16:2:=0x01 PI_CALVL_AREF_LP3_EN_F0:RW:8:1:=0x00 PI_CALVL_EN_F0:RW:0:2:=0x01
const DENALI_PI_158_DATA: u32 = 0b00000000000000010000000000000001; // PI_TMRZ_F0:RW:16:5:=0x01 PI_CALVL_AREF_LP3_EN_F2:RW:8:1:=0x00 PI_CALVL_EN_F2:RW:0:2:=0x01
const DENALI_PI_159_DATA: u32 = 0b00000000000000010000000000000101; // PI_TMRZ_F1:RW:16:5:=0x01 PI_TCAENT_F0:RW:0:14:=0x0005
const DENALI_PI_160_DATA: u32 = 0b00000000000000100000000001100100; // PI_TMRZ_F2:RW:16:5:=0x02 PI_TCAENT_F1:RW:0:14:=0x0064
const DENALI_PI_161_DATA: u32 = 0b00000001000000000000000100001011; // PI_TDFI_CASEL_F0:RW:24:5:=0x01 PI_TDFI_CACSCA_F0:RW:16:5:=0x00 PI_TCAENT_F2:RW:0:14:=0x010b
const DENALI_PI_162_DATA: u32 = 0b00000000000001100000000000000110; // PI_TVREF_LONG_F0:RW:16:10:=0x0006 PI_TVREF_SHORT_F0:RW:0:10:=0x0006
const DENALI_PI_163_DATA: u32 = 0b00000000011001010000000100000000; // PI_TVREF_SHORT_F1:RW:16:10:=0x0065 PI_TDFI_CASEL_F1:RW:8:5:=0x01 PI_TDFI_CACSCA_F1:RW:0:5:=0x00
const DENALI_PI_164_DATA: u32 = 0b00000001000000000000000001100101; // PI_TDFI_CASEL_F2:RW:24:5:=0x01 PI_TDFI_CACSCA_F2:RW:16:5:=0x00 PI_TVREF_LONG_F1:RW:0:10:=0x0065
const DENALI_PI_165_DATA: u32 = 0b00000001000011000000000100001100; // PI_TVREF_LONG_F2:RW:16:10:=0x010c PI_TVREF_SHORT_F2:RW:0:10:=0x010c
const DENALI_PI_166_DATA: u32 = 0b00011110000110100001111000011010; // PI_CALVL_VREF_INITIAL_STOP_POINT_F1:RW:24:7:=0x1e PI_CALVL_VREF_INITIAL_START_POINT_F1:RW:16:7:=0x1a PI_CALVL_VREF_INITIAL_STOP_POINT_F0:RW:8:7:=0x1e PI_CALVL_VREF_INITIAL_START_POINT_F0:RW:0:7:=0x1a
const DENALI_PI_167_DATA: u32 = 0b00000001000000010001111000011010; // PI_CALVL_VREF_DELTA_F1:RW:24:4:=0x01 PI_CALVL_VREF_DELTA_F0:RW:16:4:=0x01 PI_CALVL_VREF_INITIAL_STOP_POINT_F2:RW:8:7:=0x1e PI_CALVL_VREF_INITIAL_START_POINT_F2:RW:0:7:=0x1a
const DENALI_PI_168_DATA: u32 = 0b00001010000001110000011000000001; // PI_TMRWCKEL_F0:RW:24:8:=0x0a PI_TXP_F0:RW:16:5:=0x07 PI_TDFI_CALVL_STROBE_F0:RW:8:4:=0x06 PI_CALVL_VREF_DELTA_F2:RW:0:4:=0x01
const DENALI_PI_169_DATA: u32 = 0b00001010000001110000011000001101; // PI_TMRWCKEL_F1:RW:24:8:=0x0a PI_TXP_F1:RW:16:5:=0x07 PI_TDFI_CALVL_STROBE_F1:RW:8:4:=0x06 PI_TCKELCK_F0:RW:0:5:=0x0d
const DENALI_PI_170_DATA: u32 = 0b00010000000010110000100000001101; // PI_TMRWCKEL_F2:RW:24:8:=0x10 PI_TXP_F2:RW:16:5:=0x0b PI_TDFI_CALVL_STROBE_F2:RW:8:4:=0x08 PI_TCKELCK_F1:RW:0:5:=0x0d
const DENALI_PI_171_DATA: u32 = 0b00000000000000001100000000001111; // PI_TDFI_INIT_START_F0:RW:8:10:=0x00c0 PI_TCKELCK_F2:RW:0:5:=0x0f
const DENALI_PI_172_DATA: u32 = 0b00000000110000000001000000000000; // PI_TDFI_INIT_START_F1:RW:16:10:=0x00c0 PI_TDFI_INIT_COMPLETE_F0:RW:0:16:=0x1000
const DENALI_PI_173_DATA: u32 = 0b00000000110000000001000000000000; // PI_TDFI_INIT_START_F2:RW:16:10:=0x00c0 PI_TDFI_INIT_COMPLETE_F1:RW:0:16:=0x1000
const DENALI_PI_174_DATA: u32 = 0b00000000000000100001000000000000; // PI_TCKEHDQS_F0:RW:16:6:=0x02 PI_TDFI_INIT_COMPLETE_F2:RW:0:16:=0x1000
const DENALI_PI_175_DATA: u32 = 0b00000000000100100000000000000101; // PI_TCKEHDQS_F1:RW:16:6:=0x12 PI_TFC_F0:RW:0:10:=0x0005
const DENALI_PI_176_DATA: u32 = 0b00000000000110010000000001100100; // PI_TCKEHDQS_F2:RW:16:6:=0x19 PI_TFC_F1:RW:0:10:=0x0064
const DENALI_PI_177_DATA: u32 = 0b00000000000000000000000100001011; // PI_VREF_EN_F1:RW:24:2:=0x00 PI_VREF_EN_F0:RW:16:2:=0x00 PI_TFC_F2:RW:0:10:=0x010b
const DENALI_PI_178_DATA: u32 = 0b00000000000000000001000100000000; // PI_TDFI_WDQLVL_WR_F0:RW:8:10:=0x0011 PI_VREF_EN_F2:RW:0:2:=0x00
const DENALI_PI_179_DATA: u32 = 0b00011110000110100000000001010110; // PI_WDQLVL_VREF_INITIAL_STOP_POINT_F0:RW:24:7:=0x1e PI_WDQLVL_VREF_INITIAL_START_POINT_F0:RW:16:7:=0x1a PI_TDFI_WDQLVL_RW_F0:RW:0:10:=0x0056
const DENALI_PI_180_DATA: u32 = 0b00000110000000000000000100000001; // PI_WDQLVL_CL_F0:RW:24:5:=0x06 PI_NTP_TRAIN_EN_F0:RW:16:2:=0x00 PI_WDQLVL_EN_F0:RW:8:2:=0x01 PI_WDQLVL_VREF_DELTA_F0:RW:0:4:=0x01
const DENALI_PI_181_DATA: u32 = 0b00000000000100110000001000000100; // PI_TDFI_WDQLVL_WR_F1:RW:16:10:=0x0013 PI_WDQLVL_WRLAT_ADJ_F0:RW:8:8:=0x02 PI_WDQLVL_RDLAT_ADJ_F0:RW:0:8:=0x04
const DENALI_PI_182_DATA: u32 = 0b00011110000110100000000001011000; // PI_WDQLVL_VREF_INITIAL_STOP_POINT_F1:RW:24:7:=0x1e PI_WDQLVL_VREF_INITIAL_START_POINT_F1:RW:16:7:=0x1a PI_TDFI_WDQLVL_RW_F1:RW:0:10:=0x0058
const DENALI_PI_183_DATA: u32 = 0b00000001000000000000000100000001; // PI_WDQLVL_CL_F1:RW:24:5:=0x01 PI_NTP_TRAIN_EN_F1:RW:16:2:=0x00 PI_WDQLVL_EN_F1:RW:8:2:=0x01 PI_WDQLVL_VREF_DELTA_F1:RW:0:4:=0x01
const DENALI_PI_184_DATA: u32 = 0b00000000001000110000010000001000; // PI_TDFI_WDQLVL_WR_F2:RW:16:10:=0x0023 PI_WDQLVL_WRLAT_ADJ_F1:RW:8:8:=0x04 PI_WDQLVL_RDLAT_ADJ_F1:RW:0:8:=0x08
const DENALI_PI_185_DATA: u32 = 0b00011110000110100000000001011110; // PI_WDQLVL_VREF_INITIAL_STOP_POINT_F2:RW:24:7:=0x1e PI_WDQLVL_VREF_INITIAL_START_POINT_F2:RW:16:7:=0x1a PI_TDFI_WDQLVL_RW_F2:RW:0:10:=0x005e
const DENALI_PI_186_DATA: u32 = 0b00001001000000000000000100000001; // PI_WDQLVL_CL_F2:RW:24:5:=0x09 PI_NTP_TRAIN_EN_F2:RW:16:2:=0x00 PI_WDQLVL_EN_F2:RW:8:2:=0x01 PI_WDQLVL_VREF_DELTA_F2:RW:0:4:=0x01
const DENALI_PI_187_DATA: u32 = 0b00000000000000000000011000010000; // PI_RD_DBI_LEVEL_EN_F1:RW:24:2:=0x00 PI_RD_DBI_LEVEL_EN_F0:RW:16:2:=0x00 PI_WDQLVL_WRLAT_ADJ_F2:RW:8:8:=0x06 PI_WDQLVL_RDLAT_ADJ_F2:RW:0:8:=0x10
const DENALI_PI_188_DATA: u32 = 0b00000100000001000000100000000000; // PI_TRCD_F0:RW:24:8:=0x04 PI_TRP_F0:RW:16:8:=0x04 PI_TRTP_F0:RW:8:8:=0x08 PI_RD_DBI_LEVEL_EN_F2:RW:0:2:=0x00
const DENALI_PI_189_DATA: u32 = 0b00000000000001000000000100000000; // PI_TWR_F0:RW:16:8:=0x04 PI_TWTR_F0:RW:8:6:=0x01 PI_TCCD_L_F0:RW:0:5:=0x00
const DENALI_PI_190_DATA: u32 = 0b00000011000000000000001001110111; // PI_TRAS_MIN_F0:RW:24:8:=0x03 PI_TRAS_MAX_F0:RW:0:20:=0x000277
const DENALI_PI_191_DATA: u32 = 0b00001010000000110010000000000001; // PI_TMRD_F0:RW:24:8:=0x0a PI_TSR_F0:RW:16:8:=0x03 PI_TCCDMW_F0:RW:8:6:=0x20 PI_TDQSCK_MAX_F0:RW:0:4:=0x01
const DENALI_PI_192_DATA: u32 = 0b00000000000000000000101000001010; // PI_TMRD_PAR_F0:RW:24:8:=0x00 PI_TMOD_PAR_F0:RW:16:8:=0x00 PI_TMOD_F0:RW:8:8:=0x0a PI_TMRW_F0:RW:0:8:=0x0a
const DENALI_PI_193_DATA: u32 = 0b00000000000010000000100100001000; // PI_TCCD_L_F1:RW:24:5:=0x00 PI_TRCD_F1:RW:16:8:=0x08 PI_TRP_F1:RW:8:8:=0x09 PI_TRTP_F1:RW:0:8:=0x08
const DENALI_PI_194_DATA: u32 = 0b00000000000000000000100100000001; // PI_TWR_F1:RW:8:8:=0x09 PI_TWTR_F1:RW:0:6:=0x01
const DENALI_PI_195_DATA: u32 = 0b00010001000000000011000101011100; // PI_TRAS_MIN_F1:RW:24:8:=0x11 PI_TRAS_MAX_F1:RW:0:20:=0x00315c
const DENALI_PI_196_DATA: u32 = 0b00001010000001100010000000000010; // PI_TMRD_F1:RW:24:8:=0x0a PI_TSR_F1:RW:16:8:=0x06 PI_TCCDMW_F1:RW:8:6:=0x20 PI_TDQSCK_MAX_F1:RW:0:4:=0x02
const DENALI_PI_197_DATA: u32 = 0b00000000000000000000101000001010; // PI_TMRD_PAR_F1:RW:24:8:=0x00 PI_TMOD_PAR_F1:RW:16:8:=0x00 PI_TMOD_F1:RW:8:8:=0x0a PI_TMRW_F1:RW:0:8:=0x0a
const DENALI_PI_198_DATA: u32 = 0b00000000000101000001011100001000; // PI_TCCD_L_F2:RW:24:5:=0x00 PI_TRCD_F2:RW:16:8:=0x14 PI_TRP_F2:RW:8:8:=0x17 PI_TRTP_F2:RW:0:8:=0x08
const DENALI_PI_199_DATA: u32 = 0b00000000000000000001010100001101; // PI_TWR_F2:RW:8:8:=0x15 PI_TWTR_F2:RW:0:6:=0x0d
const DENALI_PI_200_DATA: u32 = 0b00101101000000001000001110001110; // PI_TRAS_MIN_F2:RW:24:8:=0x2d PI_TRAS_MAX_F2:RW:0:20:=0x00838e
const DENALI_PI_201_DATA: u32 = 0b00001111000100000010000000000100; // PI_TMRD_F2:RW:24:8:=0x0f PI_TSR_F2:RW:16:8:=0x10 PI_TCCDMW_F2:RW:8:6:=0x20 PI_TDQSCK_MAX_F2:RW:0:4:=0x04
const DENALI_PI_202_DATA: u32 = 0b00000000000000000000111100001011; // PI_TMRD_PAR_F2:RW:24:8:=0x00 PI_TMOD_PAR_F2:RW:16:8:=0x00 PI_TMOD_F2:RW:8:8:=0x0f PI_TMRW_F2:RW:0:8:=0x0b
const DENALI_PI_203_DATA: u32 = 0b00000000000000000000000010001100; // PI_TDFI_CTRLUPD_MAX_F0:RW:0:21:=0x00008c
const DENALI_PI_204_DATA: u32 = 0b00000000000000000000010101111000; // PI_TDFI_CTRLUPD_INTERVAL_F0:RW:0:32:=0x00000578
const DENALI_PI_205_DATA: u32 = 0b00000000000000000000110000100000; // PI_TDFI_CTRLUPD_MAX_F1:RW:0:21:=0x000c20
const DENALI_PI_206_DATA: u32 = 0b00000000000000000111100101000000; // PI_TDFI_CTRLUPD_INTERVAL_F1:RW:0:32:=0x00007940
const DENALI_PI_207_DATA: u32 = 0b00000000000000000010000001101010; // PI_TDFI_CTRLUPD_MAX_F2:RW:0:21:=0x00206a
const DENALI_PI_208_DATA: u32 = 0b00000000000000010100010000100100; // PI_TDFI_CTRLUPD_INTERVAL_F2:RW:0:32:=0x00014424
const DENALI_PI_209_DATA: u32 = 0b00000000011100110000000000000110; // PI_TXSR_F1:RW:16:16:=0x0073 PI_TXSR_F0:RW:0:16:=0x0006
const DENALI_PI_210_DATA: u32 = 0b00000011000000110000000100110011; // PI_TEXCKE_F1:RW:24:6:=0x03 PI_TEXCKE_F0:RW:16:6:=0x03 PI_TXSR_F2:RW:0:16:=0x0133
const DENALI_PI_211_DATA: u32 = 0b00000000000000000000000000000100; // PI_TDLL_F0:RW:8:16:=0x0000 PI_TEXCKE_F2:RW:0:6:=0x04
const DENALI_PI_212_DATA: u32 = 0b00000000000000000000000000000000; // PI_TDLL_F2:RW:16:16:=0x0000 PI_TDLL_F1:RW:0:16:=0x0000
const DENALI_PI_213_DATA: u32 = 0b00000000000000000000000000000100; // PI_TINIT_F0:RW:0:24:=0x000004
const DENALI_PI_214_DATA: u32 = 0b00000000000000000000000000000001; // PI_TINIT3_F0:RW:0:24:=0x000001
const DENALI_PI_215_DATA: u32 = 0b00000000000000000000000000000101; // PI_TINIT4_F0:RW:0:24:=0x000005
const DENALI_PI_216_DATA: u32 = 0b00000000000000000000000000000010; // PI_TINIT5_F0:RW:0:24:=0x000002
const DENALI_PI_217_DATA: u32 = 0b00000000000000000000000000000110; // PI_TXSNR_F0:RW:0:16:=0x0006
const DENALI_PI_218_DATA: u32 = 0b00000000000000000000000001010000; // PI_TINIT_F1:RW:0:24:=0x000050
const DENALI_PI_219_DATA: u32 = 0b00000000000000000000000000000001; // PI_TINIT3_F1:RW:0:24:=0x000001
const DENALI_PI_220_DATA: u32 = 0b00000000000000000000000000000101; // PI_TINIT4_F1:RW:0:24:=0x000005
const DENALI_PI_221_DATA: u32 = 0b00000000000000000000000000101000; // PI_TINIT5_F1:RW:0:24:=0x000028
const DENALI_PI_222_DATA: u32 = 0b00000000000000000000000001110011; // PI_TXSNR_F1:RW:0:16:=0x0073
const DENALI_PI_223_DATA: u32 = 0b00000000000000000000000011010110; // PI_TINIT_F2:RW:0:24:=0x0000d6
const DENALI_PI_224_DATA: u32 = 0b00000000000000000000000000000001; // PI_TINIT3_F2:RW:0:24:=0x000001
const DENALI_PI_225_DATA: u32 = 0b00000000000000000000000000000101; // PI_TINIT4_F2:RW:0:24:=0x000005
const DENALI_PI_226_DATA: u32 = 0b00000000000000000000000001101011; // PI_TINIT5_F2:RW:0:24:=0x00006b
const DENALI_PI_227_DATA: u32 = 0b00000001000000000000000100110011; // RESERVED:RW:16:12:=0x0100 PI_TXSNR_F2:RW:0:16:=0x0133
const DENALI_PI_228_DATA: u32 = 0b00000000000101000000000001000000; // PI_TZQCAL_F0:RW:16:12:=0x0014 RESERVED:RW:0:12:=0x0040
const DENALI_PI_229_DATA: u32 = 0b00000000000000010000000000000001; // RESERVED:RW:8:12:=0x0100 PI_TZQLAT_F0:RW:0:7:=0x01
const DENALI_PI_230_DATA: u32 = 0b00000001100100000000000001000000; // PI_TZQCAL_F1:RW:16:12:=0x0190 RESERVED:RW:0:12:=0x0040
const DENALI_PI_231_DATA: u32 = 0b00000000000000010000000000001100; // RESERVED:RW:8:12:=0x0100 PI_TZQLAT_F1:RW:0:7:=0x0c
const DENALI_PI_232_DATA: u32 = 0b00000100001010110000000001000000; // PI_TZQCAL_F2:RW:16:12:=0x042b RESERVED:RW:0:12:=0x0040
const DENALI_PI_233_DATA: u32 = 0b00000000000000000000001100100000; // RESERVED:RW:8:12:=0x0003 PI_TZQLAT_F2:RW:0:7:=0x20
const DENALI_PI_234_DATA: u32 = 0b00000000001101100000000000010100; // RESERVED:RW:16:12:=0x0036 RESERVED:RW:0:12:=0x0014
const DENALI_PI_235_DATA: u32 = 0b00000001000000010000000100000001; // PI_MEMDATA_RATIO_3:RW:24:3:=0x01 PI_MEMDATA_RATIO_2:RW:16:3:=0x01 PI_MEMDATA_RATIO_1:RW:8:3:=0x01 PI_MEMDATA_RATIO_0:RW:0:3:=0x01
const DENALI_PI_236_DATA: u32 = 0b00000010000000100000000100000001; // PI_ODT_WR_MAP_CS1:RW:24:4:=0x02 PI_ODT_RD_MAP_CS1:RW:16:4:=0x02 PI_ODT_WR_MAP_CS0:RW:8:4:=0x01 PI_ODT_RD_MAP_CS0:RW:0:4:=0x01
const DENALI_PI_237_DATA: u32 = 0b00001000000010000000010000000100; // PI_ODT_WR_MAP_CS3:RW:24:4:=0x08 PI_ODT_RD_MAP_CS3:RW:16:4:=0x08 PI_ODT_WR_MAP_CS2:RW:8:4:=0x04 PI_ODT_RD_MAP_CS2:RW:0:4:=0x04
const DENALI_PI_238_DATA: u32 = 0b01100111011001110110011101100111; // PI_VREF_VAL_DEV0_3:RW:24:7:=0x67 PI_VREF_VAL_DEV0_2:RW:16:7:=0x67 PI_VREF_VAL_DEV0_1:RW:8:7:=0x67 PI_VREF_VAL_DEV0_0:RW:0:7:=0x67
const DENALI_PI_239_DATA: u32 = 0b01100111011001110110011101100111; // PI_VREF_VAL_DEV1_3:RW:24:7:=0x67 PI_VREF_VAL_DEV1_2:RW:16:7:=0x67 PI_VREF_VAL_DEV1_1:RW:8:7:=0x67 PI_VREF_VAL_DEV1_0:RW:0:7:=0x67
const DENALI_PI_240_DATA: u32 = 0b01100111011001110110011101100111; // PI_VREF_VAL_DEV2_3:RW:24:7:=0x67 PI_VREF_VAL_DEV2_2:RW:16:7:=0x67 PI_VREF_VAL_DEV2_1:RW:8:7:=0x67 PI_VREF_VAL_DEV2_0:RW:0:7:=0x67
const DENALI_PI_241_DATA: u32 = 0b01100111011001110110011101100111; // PI_VREF_VAL_DEV3_3:RW:24:7:=0x67 PI_VREF_VAL_DEV3_2:RW:16:7:=0x67 PI_VREF_VAL_DEV3_1:RW:8:7:=0x67 PI_VREF_VAL_DEV3_0:RW:0:7:=0x67
const DENALI_PI_242_DATA: u32 = 0b00000000000000000000000000000000; // PI_SLICE_PER_DEV_3:RW:24:2:=0x00 PI_SLICE_PER_DEV_2:RW:16:2:=0x00 PI_SLICE_PER_DEV_1:RW:8:2:=0x00 PI_SLICE_PER_DEV_0:RW:0:2:=0x00
const DENALI_PI_243_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR6_VREF_0_3:RD:24:6:=0x00 PI_MR6_VREF_0_2:RD:16:6:=0x00 PI_MR6_VREF_0_1:RD:8:6:=0x00 PI_MR6_VREF_0_0:RD:0:6:=0x00
const DENALI_PI_244_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR6_VREF_1_3:RD:24:6:=0x00 PI_MR6_VREF_1_2:RD:16:6:=0x00 PI_MR6_VREF_1_1:RD:8:6:=0x00 PI_MR6_VREF_1_0:RD:0:6:=0x00
const DENALI_PI_245_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR6_VREF_2_3:RD:24:6:=0x00 PI_MR6_VREF_2_2:RD:16:6:=0x00 PI_MR6_VREF_2_1:RD:8:6:=0x00 PI_MR6_VREF_2_0:RD:0:6:=0x00
const DENALI_PI_246_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR6_VREF_3_3:RD:24:6:=0x00 PI_MR6_VREF_3_2:RD:16:6:=0x00 PI_MR6_VREF_3_1:RD:8:6:=0x00 PI_MR6_VREF_3_0:RD:0:6:=0x00
const DENALI_PI_247_DATA: u32 = 0b00000000000000000101010100000000; // PI_MR17_DATA_0:RW:24:8:=0x00 PI_MR16_DATA_0:RW:16:8:=0x00 PI_MR15_DATA_0:RW:8:8:=0x55 PI_MR13_DATA_0:RW+:0:8:=0x00
const DENALI_PI_248_DATA: u32 = 0b00000000000000000101101000000000; // PI_MR32_DATA_0:RW:8:17:=0x00005a PI_MR20_DATA_0:RW:0:8:=0x00
const DENALI_PI_249_DATA: u32 = 0b00000000010101010000000000111100; // PI_MR16_DATA_1:RW:24:8:=0x00 PI_MR15_DATA_1:RW:16:8:=0x55 PI_MR13_DATA_1:RW+:8:8:=0x00 PI_MR40_DATA_0:RW:0:8:=0x3c
const DENALI_PI_250_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR20_DATA_1:RW:8:8:=0x00 PI_MR17_DATA_1:RW:0:8:=0x00
const DENALI_PI_251_DATA: u32 = 0b00111100000000000000000001011010; // PI_MR40_DATA_1:RW:24:8:=0x3c PI_MR32_DATA_1:RW:0:17:=0x00005a
const DENALI_PI_252_DATA: u32 = 0b00000000000000000101010100000000; // PI_MR17_DATA_2:RW:24:8:=0x00 PI_MR16_DATA_2:RW:16:8:=0x00 PI_MR15_DATA_2:RW:8:8:=0x55 PI_MR13_DATA_2:RW+:0:8:=0x00
const DENALI_PI_253_DATA: u32 = 0b00000000000000000101101000000000; // PI_MR32_DATA_2:RW:8:17:=0x00005a PI_MR20_DATA_2:RW:0:8:=0x00
const DENALI_PI_254_DATA: u32 = 0b00000000010101010000000000111100; // PI_MR16_DATA_3:RW:24:8:=0x00 PI_MR15_DATA_3:RW:16:8:=0x55 PI_MR13_DATA_3:RW+:8:8:=0x00 PI_MR40_DATA_2:RW:0:8:=0x3c
const DENALI_PI_255_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR20_DATA_3:RW:8:8:=0x00 PI_MR17_DATA_3:RW:0:8:=0x00
const DENALI_PI_256_DATA: u32 = 0b00111100000000000000000001011010; // PI_MR40_DATA_3:RW:24:8:=0x3c PI_MR32_DATA_3:RW:0:17:=0x00005a
const DENALI_PI_257_DATA: u32 = 0b00011000000101110001011000010101; // PI_CKE_MUX_3:RW_D:24:5:=0x18 PI_CKE_MUX_2:RW_D:16:5:=0x17 PI_CKE_MUX_1:RW_D:8:5:=0x16 PI_CKE_MUX_0:RW_D:0:5:=0x15
const DENALI_PI_258_DATA: u32 = 0b00010100000100110001001000010001; // PI_CS_MUX_3:RW_D:24:5:=0x14 PI_CS_MUX_2:RW_D:16:5:=0x13 PI_CS_MUX_1:RW_D:8:5:=0x12 PI_CS_MUX_0:RW_D:0:5:=0x11
const DENALI_PI_259_DATA: u32 = 0b00000111000001100000010100000100; // PI_ODT_MUX_3:RW_D:24:5:=0x07 PI_ODT_MUX_2:RW_D:16:5:=0x06 PI_ODT_MUX_1:RW_D:8:5:=0x05 PI_ODT_MUX_0:RW_D:0:5:=0x04
const DENALI_PI_260_DATA: u32 = 0b00000011000000100000000100000000; // PI_RESET_N_MUX_3:RW_D:24:5:=0x03 PI_RESET_N_MUX_2:RW_D:16:5:=0x02 PI_RESET_N_MUX_1:RW_D:8:5:=0x01 PI_RESET_N_MUX_0:RW_D:0:5:=0x00
const DENALI_PI_261_DATA: u32 = 0b00000000000000000000000000000000; // PI_MRSINGLE_DATA_0:RW:0:17:=0x000000
const DENALI_PI_262_DATA: u32 = 0b00000000000000000000000000000000; // PI_MRSINGLE_DATA_1:RW:0:17:=0x000000
const DENALI_PI_263_DATA: u32 = 0b00000000000000000000000000000000; // PI_MRSINGLE_DATA_2:RW:0:17:=0x000000
const DENALI_PI_264_DATA: u32 = 0b00000001000000000000000000000000; // PI_ZQ_CAL_START_MAP_0:RW_D:24:4:=0x01 PI_MRSINGLE_DATA_3:RW:0:17:=0x000000
const DENALI_PI_265_DATA: u32 = 0b00000100000000100000001000000001; // PI_ZQ_CAL_START_MAP_2:RW_D:24:4:=0x04 PI_ZQ_CAL_LATCH_MAP_1:RW_D:16:4:=0x02 PI_ZQ_CAL_START_MAP_1:RW_D:8:4:=0x02 PI_ZQ_CAL_LATCH_MAP_0:RW_D:0:4:=0x01
const DENALI_PI_266_DATA: u32 = 0b00000000000010000000100000000100; // PI_ZQ_CAL_LATCH_MAP_3:RW_D:16:4:=0x08 PI_ZQ_CAL_START_MAP_3:RW_D:8:4:=0x08 PI_ZQ_CAL_LATCH_MAP_2:RW_D:0:4:=0x04
const DENALI_PI_267_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F0_0:RW:0:17:=0x000000
const DENALI_PI_268_DATA: u32 = 0b00000000000000000000000000000100; // PI_MR1_DATA_F0_0:RW+:0:17:=0x000004
const DENALI_PI_269_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR2_DATA_F0_0:RW+:0:17:=0x000000
const DENALI_PI_270_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F0_0:RW+:0:17:=0x000031
const DENALI_PI_271_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F0_0:RW:0:17:=0x000031
const DENALI_PI_272_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F0_0:RW:0:17:=0x000000
const DENALI_PI_273_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F0_0:RW+:24:8:=0x00 PI_MR6_DATA_F0_0:RW+:0:17:=0x000000
const DENALI_PI_274_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F0_0:RW+:16:8:=0x00 PI_MR14_DATA_F0_0:RW+:8:8:=0x4d PI_MR12_DATA_F0_0:RW+:0:8:=0x4d
const DENALI_PI_275_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F1_0:RW:0:17:=0x000000
const DENALI_PI_276_DATA: u32 = 0b00000000000000000000000000010100; // PI_MR1_DATA_F1_0:RW+:0:17:=0x000014
const DENALI_PI_277_DATA: u32 = 0b00000000000000000000000000001001; // PI_MR2_DATA_F1_0:RW+:0:17:=0x000009
const DENALI_PI_278_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F1_0:RW+:0:17:=0x000031
const DENALI_PI_279_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F1_0:RW:0:17:=0x000031
const DENALI_PI_280_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F1_0:RW:0:17:=0x000000
const DENALI_PI_281_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F1_0:RW+:24:8:=0x00 PI_MR6_DATA_F1_0:RW+:0:17:=0x000000
const DENALI_PI_282_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F1_0:RW+:16:8:=0x00 PI_MR14_DATA_F1_0:RW+:8:8:=0x4d PI_MR12_DATA_F1_0:RW+:0:8:=0x4d
const DENALI_PI_283_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F2_0:RW:0:17:=0x000000
const DENALI_PI_284_DATA: u32 = 0b00000000000000000000000000110100; // PI_MR1_DATA_F2_0:RW+:0:17:=0x000034
const DENALI_PI_285_DATA: u32 = 0b00000000000000000000000000011011; // PI_MR2_DATA_F2_0:RW+:0:17:=0x00001b
const DENALI_PI_286_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F2_0:RW+:0:17:=0x000031
const DENALI_PI_287_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F2_0:RW:0:17:=0x000031
const DENALI_PI_288_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F2_0:RW:0:17:=0x000000
const DENALI_PI_289_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F2_0:RW+:24:8:=0x00 PI_MR6_DATA_F2_0:RW+:0:17:=0x000000
const DENALI_PI_290_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F2_0:RW+:16:8:=0x00 PI_MR14_DATA_F2_0:RW+:8:8:=0x4d PI_MR12_DATA_F2_0:RW+:0:8:=0x4d
const DENALI_PI_291_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F0_1:RW:0:17:=0x000000
const DENALI_PI_292_DATA: u32 = 0b00000000000000000000000000000100; // PI_MR1_DATA_F0_1:RW+:0:17:=0x000004
const DENALI_PI_293_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR2_DATA_F0_1:RW+:0:17:=0x000000
const DENALI_PI_294_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F0_1:RW+:0:17:=0x000031
const DENALI_PI_295_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F0_1:RW:0:17:=0x000031
const DENALI_PI_296_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F0_1:RW:0:17:=0x000000
const DENALI_PI_297_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F0_1:RW+:24:8:=0x00 PI_MR6_DATA_F0_1:RW+:0:17:=0x000000
const DENALI_PI_298_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F0_1:RW+:16:8:=0x00 PI_MR14_DATA_F0_1:RW+:8:8:=0x4d PI_MR12_DATA_F0_1:RW+:0:8:=0x4d
const DENALI_PI_299_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F1_1:RW:0:17:=0x000000
const DENALI_PI_300_DATA: u32 = 0b00000000000000000000000000010100; // PI_MR1_DATA_F1_1:RW+:0:17:=0x000014
const DENALI_PI_301_DATA: u32 = 0b00000000000000000000000000001001; // PI_MR2_DATA_F1_1:RW+:0:17:=0x000009
const DENALI_PI_302_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F1_1:RW+:0:17:=0x000031
const DENALI_PI_303_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F1_1:RW:0:17:=0x000031
const DENALI_PI_304_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F1_1:RW:0:17:=0x000000
const DENALI_PI_305_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F1_1:RW+:24:8:=0x00 PI_MR6_DATA_F1_1:RW+:0:17:=0x000000
const DENALI_PI_306_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F1_1:RW+:16:8:=0x00 PI_MR14_DATA_F1_1:RW+:8:8:=0x4d PI_MR12_DATA_F1_1:RW+:0:8:=0x4d
const DENALI_PI_307_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F2_1:RW:0:17:=0x000000
const DENALI_PI_308_DATA: u32 = 0b00000000000000000000000000110100; // PI_MR1_DATA_F2_1:RW+:0:17:=0x000034
const DENALI_PI_309_DATA: u32 = 0b00000000000000000000000000011011; // PI_MR2_DATA_F2_1:RW+:0:17:=0x00001b
const DENALI_PI_310_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F2_1:RW+:0:17:=0x000031
const DENALI_PI_311_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F2_1:RW:0:17:=0x000031
const DENALI_PI_312_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F2_1:RW:0:17:=0x000000
const DENALI_PI_313_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F2_1:RW+:24:8:=0x00 PI_MR6_DATA_F2_1:RW+:0:17:=0x000000
const DENALI_PI_314_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F2_1:RW+:16:8:=0x00 PI_MR14_DATA_F2_1:RW+:8:8:=0x4d PI_MR12_DATA_F2_1:RW+:0:8:=0x4d
const DENALI_PI_315_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F0_2:RW:0:17:=0x000000
const DENALI_PI_316_DATA: u32 = 0b00000000000000000000000000000100; // PI_MR1_DATA_F0_2:RW+:0:17:=0x000004
const DENALI_PI_317_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR2_DATA_F0_2:RW+:0:17:=0x000000
const DENALI_PI_318_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F0_2:RW+:0:17:=0x000031
const DENALI_PI_319_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F0_2:RW:0:17:=0x000031
const DENALI_PI_320_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F0_2:RW:0:17:=0x000000
const DENALI_PI_321_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F0_2:RW+:24:8:=0x00 PI_MR6_DATA_F0_2:RW+:0:17:=0x000000
const DENALI_PI_322_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F0_2:RW+:16:8:=0x00 PI_MR14_DATA_F0_2:RW+:8:8:=0x4d PI_MR12_DATA_F0_2:RW+:0:8:=0x4d
const DENALI_PI_323_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F1_2:RW:0:17:=0x000000
const DENALI_PI_324_DATA: u32 = 0b00000000000000000000000000010100; // PI_MR1_DATA_F1_2:RW+:0:17:=0x000014
const DENALI_PI_325_DATA: u32 = 0b00000000000000000000000000001001; // PI_MR2_DATA_F1_2:RW+:0:17:=0x000009
const DENALI_PI_326_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F1_2:RW+:0:17:=0x000031
const DENALI_PI_327_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F1_2:RW:0:17:=0x000031
const DENALI_PI_328_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F1_2:RW:0:17:=0x000000
const DENALI_PI_329_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F1_2:RW+:24:8:=0x00 PI_MR6_DATA_F1_2:RW+:0:17:=0x000000
const DENALI_PI_330_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F1_2:RW+:16:8:=0x00 PI_MR14_DATA_F1_2:RW+:8:8:=0x4d PI_MR12_DATA_F1_2:RW+:0:8:=0x4d
const DENALI_PI_331_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F2_2:RW:0:17:=0x000000
const DENALI_PI_332_DATA: u32 = 0b00000000000000000000000000110100; // PI_MR1_DATA_F2_2:RW+:0:17:=0x000034
const DENALI_PI_333_DATA: u32 = 0b00000000000000000000000000011011; // PI_MR2_DATA_F2_2:RW+:0:17:=0x00001b
const DENALI_PI_334_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F2_2:RW+:0:17:=0x000031
const DENALI_PI_335_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F2_2:RW:0:17:=0x000031
const DENALI_PI_336_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F2_2:RW:0:17:=0x000000
const DENALI_PI_337_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F2_2:RW+:24:8:=0x00 PI_MR6_DATA_F2_2:RW+:0:17:=0x000000
const DENALI_PI_338_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F2_2:RW+:16:8:=0x00 PI_MR14_DATA_F2_2:RW+:8:8:=0x4d PI_MR12_DATA_F2_2:RW+:0:8:=0x4d
const DENALI_PI_339_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F0_3:RW:0:17:=0x000000
const DENALI_PI_340_DATA: u32 = 0b00000000000000000000000000000100; // PI_MR1_DATA_F0_3:RW+:0:17:=0x000004
const DENALI_PI_341_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR2_DATA_F0_3:RW+:0:17:=0x000000
const DENALI_PI_342_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F0_3:RW+:0:17:=0x000031
const DENALI_PI_343_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F0_3:RW:0:17:=0x000031
const DENALI_PI_344_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F0_3:RW:0:17:=0x000000
const DENALI_PI_345_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F0_3:RW+:24:8:=0x00 PI_MR6_DATA_F0_3:RW+:0:17:=0x000000
const DENALI_PI_346_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F0_3:RW+:16:8:=0x00 PI_MR14_DATA_F0_3:RW+:8:8:=0x4d PI_MR12_DATA_F0_3:RW+:0:8:=0x4d
const DENALI_PI_347_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F1_3:RW:0:17:=0x000000
const DENALI_PI_348_DATA: u32 = 0b00000000000000000000000000010100; // PI_MR1_DATA_F1_3:RW+:0:17:=0x000014
const DENALI_PI_349_DATA: u32 = 0b00000000000000000000000000001001; // PI_MR2_DATA_F1_3:RW+:0:17:=0x000009
const DENALI_PI_350_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F1_3:RW+:0:17:=0x000031
const DENALI_PI_351_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F1_3:RW:0:17:=0x000031
const DENALI_PI_352_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F1_3:RW:0:17:=0x000000
const DENALI_PI_353_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F1_3:RW+:24:8:=0x00 PI_MR6_DATA_F1_3:RW+:0:17:=0x000000
const DENALI_PI_354_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F1_3:RW+:16:8:=0x00 PI_MR14_DATA_F1_3:RW+:8:8:=0x4d PI_MR12_DATA_F1_3:RW+:0:8:=0x4d
const DENALI_PI_355_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR0_DATA_F2_3:RW:0:17:=0x000000
const DENALI_PI_356_DATA: u32 = 0b00000000000000000000000000110100; // PI_MR1_DATA_F2_3:RW+:0:17:=0x000034
const DENALI_PI_357_DATA: u32 = 0b00000000000000000000000000011011; // PI_MR2_DATA_F2_3:RW+:0:17:=0x00001b
const DENALI_PI_358_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR3_DATA_F2_3:RW+:0:17:=0x000031
const DENALI_PI_359_DATA: u32 = 0b00000000000000000000000000110001; // PI_MR4_DATA_F2_3:RW:0:17:=0x000031
const DENALI_PI_360_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR5_DATA_F2_3:RW:0:17:=0x000000
const DENALI_PI_361_DATA: u32 = 0b00000000000000000000000000000000; // PI_MR11_DATA_F2_3:RW+:24:8:=0x00 PI_MR6_DATA_F2_3:RW+:0:17:=0x000000
const DENALI_PI_362_DATA: u32 = 0b00000000000000000100110101001101; // PI_MR22_DATA_F2_3:RW+:16:8:=0x00 PI_MR14_DATA_F2_3:RW+:8:8:=0x4d PI_MR12_DATA_F2_3:RW+:0:8:=0x4d

pub fn init(base_addr: usize) {
    write_pi(base_addr, 0, DENALI_PI_00_DATA);
    write_pi(base_addr, 1, DENALI_PI_01_DATA);
    write_pi(base_addr, 2, DENALI_PI_02_DATA);
    write_pi(base_addr, 3, DENALI_PI_03_DATA);
    write_pi(base_addr, 4, DENALI_PI_04_DATA);
    write_pi(base_addr, 5, DENALI_PI_05_DATA);
    write_pi(base_addr, 6, DENALI_PI_06_DATA);
    write_pi(base_addr, 7, DENALI_PI_07_DATA);
    write_pi(base_addr, 8, DENALI_PI_08_DATA);
    write_pi(base_addr, 9, DENALI_PI_09_DATA);
    write_pi(base_addr, 10, DENALI_PI_10_DATA);
    write_pi(base_addr, 11, DENALI_PI_11_DATA);
    write_pi(base_addr, 12, DENALI_PI_12_DATA);
    write_pi(base_addr, 13, DENALI_PI_13_DATA);
    write_pi(base_addr, 14, DENALI_PI_14_DATA);
    write_pi(base_addr, 15, DENALI_PI_15_DATA);
    write_pi(base_addr, 16, DENALI_PI_16_DATA);
    write_pi(base_addr, 17, DENALI_PI_17_DATA);
    write_pi(base_addr, 18, DENALI_PI_18_DATA);
    write_pi(base_addr, 19, DENALI_PI_19_DATA);
    write_pi(base_addr, 20, DENALI_PI_20_DATA);
    write_pi(base_addr, 21, DENALI_PI_21_DATA);
    write_pi(base_addr, 22, DENALI_PI_22_DATA);
    write_pi(base_addr, 23, DENALI_PI_23_DATA);
    write_pi(base_addr, 24, DENALI_PI_24_DATA);
    write_pi(base_addr, 25, DENALI_PI_25_DATA);
    write_pi(base_addr, 26, DENALI_PI_26_DATA);
    write_pi(base_addr, 27, DENALI_PI_27_DATA);
    write_pi(base_addr, 28, DENALI_PI_28_DATA);
    write_pi(base_addr, 29, DENALI_PI_29_DATA);
    write_pi(base_addr, 30, DENALI_PI_30_DATA);
    write_pi(base_addr, 31, DENALI_PI_31_DATA);
    write_pi(base_addr, 32, DENALI_PI_32_DATA);
    write_pi(base_addr, 33, DENALI_PI_33_DATA);
    write_pi(base_addr, 34, DENALI_PI_34_DATA);
    write_pi(base_addr, 35, DENALI_PI_35_DATA);
    write_pi(base_addr, 36, DENALI_PI_36_DATA);
    write_pi(base_addr, 37, DENALI_PI_37_DATA);
    write_pi(base_addr, 38, DENALI_PI_38_DATA);
    write_pi(base_addr, 39, DENALI_PI_39_DATA);
    write_pi(base_addr, 40, DENALI_PI_40_DATA);
    write_pi(base_addr, 41, DENALI_PI_41_DATA);
    write_pi(base_addr, 42, DENALI_PI_42_DATA);
    write_pi(base_addr, 43, DENALI_PI_43_DATA);
    write_pi(base_addr, 44, DENALI_PI_44_DATA);
    write_pi(base_addr, 45, DENALI_PI_45_DATA);
    write_pi(base_addr, 46, DENALI_PI_46_DATA);
    write_pi(base_addr, 47, DENALI_PI_47_DATA);
    write_pi(base_addr, 48, DENALI_PI_48_DATA);
    write_pi(base_addr, 49, DENALI_PI_49_DATA);
    write_pi(base_addr, 50, DENALI_PI_50_DATA);
    write_pi(base_addr, 51, DENALI_PI_51_DATA);
    write_pi(base_addr, 52, DENALI_PI_52_DATA);
    write_pi(base_addr, 53, DENALI_PI_53_DATA);
    write_pi(base_addr, 54, DENALI_PI_54_DATA);
    write_pi(base_addr, 55, DENALI_PI_55_DATA);
    write_pi(base_addr, 56, DENALI_PI_56_DATA);
    write_pi(base_addr, 57, DENALI_PI_57_DATA);
    write_pi(base_addr, 58, DENALI_PI_58_DATA);
    write_pi(base_addr, 59, DENALI_PI_59_DATA);
    write_pi(base_addr, 60, DENALI_PI_60_DATA);
    write_pi(base_addr, 61, DENALI_PI_61_DATA);
    write_pi(base_addr, 62, DENALI_PI_62_DATA);
    write_pi(base_addr, 63, DENALI_PI_63_DATA);
    write_pi(base_addr, 64, DENALI_PI_64_DATA);
    write_pi(base_addr, 65, DENALI_PI_65_DATA);
    write_pi(base_addr, 66, DENALI_PI_66_DATA);
    write_pi(base_addr, 67, DENALI_PI_67_DATA);
    write_pi(base_addr, 68, DENALI_PI_68_DATA);
    write_pi(base_addr, 69, DENALI_PI_69_DATA);
    write_pi(base_addr, 70, DENALI_PI_70_DATA);
    write_pi(base_addr, 71, DENALI_PI_71_DATA);
    write_pi(base_addr, 72, DENALI_PI_72_DATA);
    write_pi(base_addr, 73, DENALI_PI_73_DATA);
    write_pi(base_addr, 74, DENALI_PI_74_DATA);
    write_pi(base_addr, 75, DENALI_PI_75_DATA);
    write_pi(base_addr, 76, DENALI_PI_76_DATA);
    write_pi(base_addr, 77, DENALI_PI_77_DATA);
    write_pi(base_addr, 78, DENALI_PI_78_DATA);
    write_pi(base_addr, 79, DENALI_PI_79_DATA);
    write_pi(base_addr, 80, DENALI_PI_80_DATA);
    write_pi(base_addr, 81, DENALI_PI_81_DATA);
    write_pi(base_addr, 82, DENALI_PI_82_DATA);
    write_pi(base_addr, 83, DENALI_PI_83_DATA);
    write_pi(base_addr, 84, DENALI_PI_84_DATA);
    write_pi(base_addr, 85, DENALI_PI_85_DATA);
    write_pi(base_addr, 86, DENALI_PI_86_DATA);
    write_pi(base_addr, 87, DENALI_PI_87_DATA);
    write_pi(base_addr, 88, DENALI_PI_88_DATA);
    write_pi(base_addr, 89, DENALI_PI_89_DATA);
    write_pi(base_addr, 90, DENALI_PI_90_DATA);
    write_pi(base_addr, 91, DENALI_PI_91_DATA);
    write_pi(base_addr, 92, DENALI_PI_92_DATA);
    write_pi(base_addr, 93, DENALI_PI_93_DATA);
    write_pi(base_addr, 94, DENALI_PI_94_DATA);
    write_pi(base_addr, 95, DENALI_PI_95_DATA);
    write_pi(base_addr, 96, DENALI_PI_96_DATA);
    write_pi(base_addr, 97, DENALI_PI_97_DATA);
    write_pi(base_addr, 98, DENALI_PI_98_DATA);
    write_pi(base_addr, 99, DENALI_PI_99_DATA);
    write_pi(base_addr, 100, DENALI_PI_100_DATA);
    write_pi(base_addr, 101, DENALI_PI_101_DATA);
    write_pi(base_addr, 102, DENALI_PI_102_DATA);
    write_pi(base_addr, 103, DENALI_PI_103_DATA);
    write_pi(base_addr, 104, DENALI_PI_104_DATA);
    write_pi(base_addr, 105, DENALI_PI_105_DATA);
    write_pi(base_addr, 106, DENALI_PI_106_DATA);
    write_pi(base_addr, 107, DENALI_PI_107_DATA);
    write_pi(base_addr, 108, DENALI_PI_108_DATA);
    write_pi(base_addr, 109, DENALI_PI_109_DATA);
    write_pi(base_addr, 110, DENALI_PI_110_DATA);
    write_pi(base_addr, 111, DENALI_PI_111_DATA);
    write_pi(base_addr, 112, DENALI_PI_112_DATA);
    write_pi(base_addr, 113, DENALI_PI_113_DATA);
    write_pi(base_addr, 114, DENALI_PI_114_DATA);
    write_pi(base_addr, 115, DENALI_PI_115_DATA);
    write_pi(base_addr, 116, DENALI_PI_116_DATA);
    write_pi(base_addr, 117, DENALI_PI_117_DATA);
    write_pi(base_addr, 118, DENALI_PI_118_DATA);
    write_pi(base_addr, 119, DENALI_PI_119_DATA);
    write_pi(base_addr, 120, DENALI_PI_120_DATA);
    write_pi(base_addr, 121, DENALI_PI_121_DATA);
    write_pi(base_addr, 122, DENALI_PI_122_DATA);
    write_pi(base_addr, 123, DENALI_PI_123_DATA);
    write_pi(base_addr, 124, DENALI_PI_124_DATA);
    write_pi(base_addr, 125, DENALI_PI_125_DATA);
    write_pi(base_addr, 126, DENALI_PI_126_DATA);
    write_pi(base_addr, 127, DENALI_PI_127_DATA);
    write_pi(base_addr, 128, DENALI_PI_128_DATA);
    write_pi(base_addr, 129, DENALI_PI_129_DATA);
    write_pi(base_addr, 130, DENALI_PI_130_DATA);
    write_pi(base_addr, 131, DENALI_PI_131_DATA);
    write_pi(base_addr, 132, DENALI_PI_132_DATA);
    write_pi(base_addr, 133, DENALI_PI_133_DATA);
    write_pi(base_addr, 134, DENALI_PI_134_DATA);
    write_pi(base_addr, 135, DENALI_PI_135_DATA);
    write_pi(base_addr, 136, DENALI_PI_136_DATA);
    write_pi(base_addr, 137, DENALI_PI_137_DATA);
    write_pi(base_addr, 138, DENALI_PI_138_DATA);
    write_pi(base_addr, 139, DENALI_PI_139_DATA);
    write_pi(base_addr, 140, DENALI_PI_140_DATA);
    write_pi(base_addr, 141, DENALI_PI_141_DATA);
    write_pi(base_addr, 142, DENALI_PI_142_DATA);
    write_pi(base_addr, 143, DENALI_PI_143_DATA);
    write_pi(base_addr, 144, DENALI_PI_144_DATA);
    write_pi(base_addr, 145, DENALI_PI_145_DATA);
    write_pi(base_addr, 146, DENALI_PI_146_DATA);
    write_pi(base_addr, 147, DENALI_PI_147_DATA);
    write_pi(base_addr, 148, DENALI_PI_148_DATA);
    write_pi(base_addr, 149, DENALI_PI_149_DATA);
    write_pi(base_addr, 150, DENALI_PI_150_DATA);
    write_pi(base_addr, 151, DENALI_PI_151_DATA);
    write_pi(base_addr, 152, DENALI_PI_152_DATA);
    write_pi(base_addr, 153, DENALI_PI_153_DATA);
    write_pi(base_addr, 154, DENALI_PI_154_DATA);
    write_pi(base_addr, 155, DENALI_PI_155_DATA);
    write_pi(base_addr, 156, DENALI_PI_156_DATA);
    write_pi(base_addr, 157, DENALI_PI_157_DATA);
    write_pi(base_addr, 158, DENALI_PI_158_DATA);
    write_pi(base_addr, 159, DENALI_PI_159_DATA);
    write_pi(base_addr, 160, DENALI_PI_160_DATA);
    write_pi(base_addr, 161, DENALI_PI_161_DATA);
    write_pi(base_addr, 162, DENALI_PI_162_DATA);
    write_pi(base_addr, 163, DENALI_PI_163_DATA);
    write_pi(base_addr, 164, DENALI_PI_164_DATA);
    write_pi(base_addr, 165, DENALI_PI_165_DATA);
    write_pi(base_addr, 166, DENALI_PI_166_DATA);
    write_pi(base_addr, 167, DENALI_PI_167_DATA);
    write_pi(base_addr, 168, DENALI_PI_168_DATA);
    write_pi(base_addr, 169, DENALI_PI_169_DATA);
    write_pi(base_addr, 170, DENALI_PI_170_DATA);
    write_pi(base_addr, 171, DENALI_PI_171_DATA);
    write_pi(base_addr, 172, DENALI_PI_172_DATA);
    write_pi(base_addr, 173, DENALI_PI_173_DATA);
    write_pi(base_addr, 174, DENALI_PI_174_DATA);
    write_pi(base_addr, 175, DENALI_PI_175_DATA);
    write_pi(base_addr, 176, DENALI_PI_176_DATA);
    write_pi(base_addr, 177, DENALI_PI_177_DATA);
    write_pi(base_addr, 178, DENALI_PI_178_DATA);
    write_pi(base_addr, 179, DENALI_PI_179_DATA);
    write_pi(base_addr, 180, DENALI_PI_180_DATA);
    write_pi(base_addr, 181, DENALI_PI_181_DATA);
    write_pi(base_addr, 182, DENALI_PI_182_DATA);
    write_pi(base_addr, 183, DENALI_PI_183_DATA);
    write_pi(base_addr, 184, DENALI_PI_184_DATA);
    write_pi(base_addr, 185, DENALI_PI_185_DATA);
    write_pi(base_addr, 186, DENALI_PI_186_DATA);
    write_pi(base_addr, 187, DENALI_PI_187_DATA);
    write_pi(base_addr, 188, DENALI_PI_188_DATA);
    write_pi(base_addr, 189, DENALI_PI_189_DATA);
    write_pi(base_addr, 190, DENALI_PI_190_DATA);
    write_pi(base_addr, 191, DENALI_PI_191_DATA);
    write_pi(base_addr, 192, DENALI_PI_192_DATA);
    write_pi(base_addr, 193, DENALI_PI_193_DATA);
    write_pi(base_addr, 194, DENALI_PI_194_DATA);
    write_pi(base_addr, 195, DENALI_PI_195_DATA);
    write_pi(base_addr, 196, DENALI_PI_196_DATA);
    write_pi(base_addr, 197, DENALI_PI_197_DATA);
    write_pi(base_addr, 198, DENALI_PI_198_DATA);
    write_pi(base_addr, 199, DENALI_PI_199_DATA);
    write_pi(base_addr, 200, DENALI_PI_200_DATA);
    write_pi(base_addr, 201, DENALI_PI_201_DATA);
    write_pi(base_addr, 202, DENALI_PI_202_DATA);
    write_pi(base_addr, 203, DENALI_PI_203_DATA);
    write_pi(base_addr, 204, DENALI_PI_204_DATA);
    write_pi(base_addr, 205, DENALI_PI_205_DATA);
    write_pi(base_addr, 206, DENALI_PI_206_DATA);
    write_pi(base_addr, 207, DENALI_PI_207_DATA);
    write_pi(base_addr, 208, DENALI_PI_208_DATA);
    write_pi(base_addr, 209, DENALI_PI_209_DATA);
    write_pi(base_addr, 210, DENALI_PI_210_DATA);
    write_pi(base_addr, 211, DENALI_PI_211_DATA);
    write_pi(base_addr, 212, DENALI_PI_212_DATA);
    write_pi(base_addr, 213, DENALI_PI_213_DATA);
    write_pi(base_addr, 214, DENALI_PI_214_DATA);
    write_pi(base_addr, 215, DENALI_PI_215_DATA);
    write_pi(base_addr, 216, DENALI_PI_216_DATA);
    write_pi(base_addr, 217, DENALI_PI_217_DATA);
    write_pi(base_addr, 218, DENALI_PI_218_DATA);
    write_pi(base_addr, 219, DENALI_PI_219_DATA);
    write_pi(base_addr, 220, DENALI_PI_220_DATA);
    write_pi(base_addr, 221, DENALI_PI_221_DATA);
    write_pi(base_addr, 222, DENALI_PI_222_DATA);
    write_pi(base_addr, 223, DENALI_PI_223_DATA);
    write_pi(base_addr, 224, DENALI_PI_224_DATA);
    write_pi(base_addr, 225, DENALI_PI_225_DATA);
    write_pi(base_addr, 226, DENALI_PI_226_DATA);
    write_pi(base_addr, 227, DENALI_PI_227_DATA);
    write_pi(base_addr, 228, DENALI_PI_228_DATA);
    write_pi(base_addr, 229, DENALI_PI_229_DATA);
    write_pi(base_addr, 230, DENALI_PI_230_DATA);
    write_pi(base_addr, 231, DENALI_PI_231_DATA);
    write_pi(base_addr, 232, DENALI_PI_232_DATA);
    write_pi(base_addr, 233, DENALI_PI_233_DATA);
    write_pi(base_addr, 234, DENALI_PI_234_DATA);
    write_pi(base_addr, 235, DENALI_PI_235_DATA);
    write_pi(base_addr, 236, DENALI_PI_236_DATA);
    write_pi(base_addr, 237, DENALI_PI_237_DATA);
    write_pi(base_addr, 238, DENALI_PI_238_DATA);
    write_pi(base_addr, 239, DENALI_PI_239_DATA);
    write_pi(base_addr, 240, DENALI_PI_240_DATA);
    write_pi(base_addr, 241, DENALI_PI_241_DATA);
    write_pi(base_addr, 242, DENALI_PI_242_DATA);
    write_pi(base_addr, 243, DENALI_PI_243_DATA);
    write_pi(base_addr, 244, DENALI_PI_244_DATA);
    write_pi(base_addr, 245, DENALI_PI_245_DATA);
    write_pi(base_addr, 246, DENALI_PI_246_DATA);
    write_pi(base_addr, 247, DENALI_PI_247_DATA);
    write_pi(base_addr, 248, DENALI_PI_248_DATA);
    write_pi(base_addr, 249, DENALI_PI_249_DATA);
    write_pi(base_addr, 250, DENALI_PI_250_DATA);
    write_pi(base_addr, 251, DENALI_PI_251_DATA);
    write_pi(base_addr, 252, DENALI_PI_252_DATA);
    write_pi(base_addr, 253, DENALI_PI_253_DATA);
    write_pi(base_addr, 254, DENALI_PI_254_DATA);
    write_pi(base_addr, 255, DENALI_PI_255_DATA);
    write_pi(base_addr, 256, DENALI_PI_256_DATA);
    write_pi(base_addr, 257, DENALI_PI_257_DATA);
    write_pi(base_addr, 258, DENALI_PI_258_DATA);
    write_pi(base_addr, 259, DENALI_PI_259_DATA);
    write_pi(base_addr, 260, DENALI_PI_260_DATA);
    write_pi(base_addr, 261, DENALI_PI_261_DATA);
    write_pi(base_addr, 262, DENALI_PI_262_DATA);
    write_pi(base_addr, 263, DENALI_PI_263_DATA);
    write_pi(base_addr, 264, DENALI_PI_264_DATA);
    write_pi(base_addr, 265, DENALI_PI_265_DATA);
    write_pi(base_addr, 266, DENALI_PI_266_DATA);
    write_pi(base_addr, 267, DENALI_PI_267_DATA);
    write_pi(base_addr, 268, DENALI_PI_268_DATA);
    write_pi(base_addr, 269, DENALI_PI_269_DATA);
    write_pi(base_addr, 270, DENALI_PI_270_DATA);
    write_pi(base_addr, 271, DENALI_PI_271_DATA);
    write_pi(base_addr, 272, DENALI_PI_272_DATA);
    write_pi(base_addr, 273, DENALI_PI_273_DATA);
    write_pi(base_addr, 274, DENALI_PI_274_DATA);
    write_pi(base_addr, 275, DENALI_PI_275_DATA);
    write_pi(base_addr, 276, DENALI_PI_276_DATA);
    write_pi(base_addr, 277, DENALI_PI_277_DATA);
    write_pi(base_addr, 278, DENALI_PI_278_DATA);
    write_pi(base_addr, 279, DENALI_PI_279_DATA);
    write_pi(base_addr, 280, DENALI_PI_280_DATA);
    write_pi(base_addr, 281, DENALI_PI_281_DATA);
    write_pi(base_addr, 282, DENALI_PI_282_DATA);
    write_pi(base_addr, 283, DENALI_PI_283_DATA);
    write_pi(base_addr, 284, DENALI_PI_284_DATA);
    write_pi(base_addr, 285, DENALI_PI_285_DATA);
    write_pi(base_addr, 286, DENALI_PI_286_DATA);
    write_pi(base_addr, 287, DENALI_PI_287_DATA);
    write_pi(base_addr, 288, DENALI_PI_288_DATA);
    write_pi(base_addr, 289, DENALI_PI_289_DATA);
    write_pi(base_addr, 290, DENALI_PI_290_DATA);
    write_pi(base_addr, 291, DENALI_PI_291_DATA);
    write_pi(base_addr, 292, DENALI_PI_292_DATA);
    write_pi(base_addr, 293, DENALI_PI_293_DATA);
    write_pi(base_addr, 294, DENALI_PI_294_DATA);
    write_pi(base_addr, 295, DENALI_PI_295_DATA);
    write_pi(base_addr, 296, DENALI_PI_296_DATA);
    write_pi(base_addr, 297, DENALI_PI_297_DATA);
    write_pi(base_addr, 298, DENALI_PI_298_DATA);
    write_pi(base_addr, 299, DENALI_PI_299_DATA);
    write_pi(base_addr, 300, DENALI_PI_300_DATA);
    write_pi(base_addr, 301, DENALI_PI_301_DATA);
    write_pi(base_addr, 302, DENALI_PI_302_DATA);
    write_pi(base_addr, 303, DENALI_PI_303_DATA);
    write_pi(base_addr, 304, DENALI_PI_304_DATA);
    write_pi(base_addr, 305, DENALI_PI_305_DATA);
    write_pi(base_addr, 306, DENALI_PI_306_DATA);
    write_pi(base_addr, 307, DENALI_PI_307_DATA);
    write_pi(base_addr, 308, DENALI_PI_308_DATA);
    write_pi(base_addr, 309, DENALI_PI_309_DATA);
    write_pi(base_addr, 310, DENALI_PI_310_DATA);
    write_pi(base_addr, 311, DENALI_PI_311_DATA);
    write_pi(base_addr, 312, DENALI_PI_312_DATA);
    write_pi(base_addr, 313, DENALI_PI_313_DATA);
    write_pi(base_addr, 314, DENALI_PI_314_DATA);
    write_pi(base_addr, 315, DENALI_PI_315_DATA);
    write_pi(base_addr, 316, DENALI_PI_316_DATA);
    write_pi(base_addr, 317, DENALI_PI_317_DATA);
    write_pi(base_addr, 318, DENALI_PI_318_DATA);
    write_pi(base_addr, 319, DENALI_PI_319_DATA);
    write_pi(base_addr, 320, DENALI_PI_320_DATA);
    write_pi(base_addr, 321, DENALI_PI_321_DATA);
    write_pi(base_addr, 322, DENALI_PI_322_DATA);
    write_pi(base_addr, 323, DENALI_PI_323_DATA);
    write_pi(base_addr, 324, DENALI_PI_324_DATA);
    write_pi(base_addr, 325, DENALI_PI_325_DATA);
    write_pi(base_addr, 326, DENALI_PI_326_DATA);
    write_pi(base_addr, 327, DENALI_PI_327_DATA);
    write_pi(base_addr, 328, DENALI_PI_328_DATA);
    write_pi(base_addr, 329, DENALI_PI_329_DATA);
    write_pi(base_addr, 330, DENALI_PI_330_DATA);
    write_pi(base_addr, 331, DENALI_PI_331_DATA);
    write_pi(base_addr, 332, DENALI_PI_332_DATA);
    write_pi(base_addr, 333, DENALI_PI_333_DATA);
    write_pi(base_addr, 334, DENALI_PI_334_DATA);
    write_pi(base_addr, 335, DENALI_PI_335_DATA);
    write_pi(base_addr, 336, DENALI_PI_336_DATA);
    write_pi(base_addr, 337, DENALI_PI_337_DATA);
    write_pi(base_addr, 338, DENALI_PI_338_DATA);
    write_pi(base_addr, 339, DENALI_PI_339_DATA);
    write_pi(base_addr, 340, DENALI_PI_340_DATA);
    write_pi(base_addr, 341, DENALI_PI_341_DATA);
    write_pi(base_addr, 342, DENALI_PI_342_DATA);
    write_pi(base_addr, 343, DENALI_PI_343_DATA);
    write_pi(base_addr, 344, DENALI_PI_344_DATA);
    write_pi(base_addr, 345, DENALI_PI_345_DATA);
    write_pi(base_addr, 346, DENALI_PI_346_DATA);
    write_pi(base_addr, 347, DENALI_PI_347_DATA);
    write_pi(base_addr, 348, DENALI_PI_348_DATA);
    write_pi(base_addr, 349, DENALI_PI_349_DATA);
    write_pi(base_addr, 350, DENALI_PI_350_DATA);
    write_pi(base_addr, 351, DENALI_PI_351_DATA);
    write_pi(base_addr, 352, DENALI_PI_352_DATA);
    write_pi(base_addr, 353, DENALI_PI_353_DATA);
    write_pi(base_addr, 354, DENALI_PI_354_DATA);
    write_pi(base_addr, 355, DENALI_PI_355_DATA);
    write_pi(base_addr, 356, DENALI_PI_356_DATA);
    write_pi(base_addr, 357, DENALI_PI_357_DATA);
    write_pi(base_addr, 358, DENALI_PI_358_DATA);
    write_pi(base_addr, 359, DENALI_PI_359_DATA);
    write_pi(base_addr, 360, DENALI_PI_360_DATA);
    write_pi(base_addr, 361, DENALI_PI_361_DATA);
    write_pi(base_addr, 362, DENALI_PI_362_DATA);
}
