(function() {
  'use strict';

  var globals = typeof global === 'undefined' ? self : global;
  if (typeof globals.require === 'function') return;

  var modules = {};
  var cache = {};
  var aliases = {};
  var has = {}.hasOwnProperty;

  var expRe = /^\.\.?(\/|$)/;
  var expand = function(root, name) {
    var results = [], part;
    var parts = (expRe.test(name) ? root + '/' + name : name).split('/');
    for (var i = 0, length = parts.length; i < length; i++) {
      part = parts[i];
      if (part === '..') {
        results.pop();
      } else if (part !== '.' && part !== '') {
        results.push(part);
      }
    }
    return results.join('/');
  };

  var dirname = function(path) {
    return path.split('/').slice(0, -1).join('/');
  };

  var localRequire = function(path) {
    return function expanded(name) {
      var absolute = expand(dirname(path), name);
      return globals.require(absolute, path);
    };
  };

  var initModule = function(name, definition) {
    var hot = hmr && hmr.createHot(name);
    var module = {id: name, exports: {}, hot: hot};
    cache[name] = module;
    definition(module.exports, localRequire(name), module);
    return module.exports;
  };

  var expandAlias = function(name) {
    var val = aliases[name];
    return (val && name !== val) ? expandAlias(val) : name;
  };

  var _resolve = function(name, dep) {
    return expandAlias(expand(dirname(name), dep));
  };

  var require = function(name, loaderPath) {
    if (loaderPath == null) loaderPath = '/';
    var path = expandAlias(name);

    if (has.call(cache, path)) return cache[path].exports;
    if (has.call(modules, path)) return initModule(path, modules[path]);

    throw new Error("Cannot find module '" + name + "' from '" + loaderPath + "'");
  };

  require.alias = function(from, to) {
    aliases[to] = from;
  };

  var extRe = /\.[^.\/]+$/;
  var indexRe = /\/index(\.[^\/]+)?$/;
  var addExtensions = function(bundle) {
    if (extRe.test(bundle)) {
      var alias = bundle.replace(extRe, '');
      if (!has.call(aliases, alias) || aliases[alias].replace(extRe, '') === alias + '/index') {
        aliases[alias] = bundle;
      }
    }

    if (indexRe.test(bundle)) {
      var iAlias = bundle.replace(indexRe, '');
      if (!has.call(aliases, iAlias)) {
        aliases[iAlias] = bundle;
      }
    }
  };

  require.register = require.define = function(bundle, fn) {
    if (bundle && typeof bundle === 'object') {
      for (var key in bundle) {
        if (has.call(bundle, key)) {
          require.register(key, bundle[key]);
        }
      }
    } else {
      modules[bundle] = fn;
      delete cache[bundle];
      addExtensions(bundle);
    }
  };

  require.list = function() {
    var list = [];
    for (var item in modules) {
      if (has.call(modules, item)) {
        list.push(item);
      }
    }
    return list;
  };

  var hmr = globals._hmr && new globals._hmr(_resolve, require, modules, cache);
  require._cache = cache;
  require.hmr = hmr && hmr.wrap;
  require.brunch = true;
  globals.require = require;
})();

(function() {
var global = typeof window === 'undefined' ? this : window;
var process;
var __makeRelativeRequire = function(require, mappings, pref) {
  var none = {};
  var tryReq = function(name, pref) {
    var val;
    try {
      val = require(pref + '/node_modules/' + name);
      return val;
    } catch (e) {
      if (e.toString().indexOf('Cannot find module') === -1) {
        throw e;
      }

      if (pref.indexOf('node_modules') !== -1) {
        var s = pref.split('/');
        var i = s.lastIndexOf('node_modules');
        var newPref = s.slice(0, i).join('/');
        return tryReq(name, newPref);
      }
    }
    return none;
  };
  return function(name) {
    if (name in mappings) name = mappings[name];
    if (!name) return;
    if (name[0] !== '.' && pref) {
      var val = tryReq(name, pref);
      if (val !== none) return val;
    }
    return require(name);
  }
};

require.register("php-wasm/PhpBase.js", function(exports, require, module) {
  require = __makeRelativeRequire(require, {}, "php-wasm");
  (function() {
    "use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhpBase = void 0;

var _UniqueIndex = require("./UniqueIndex");

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var STR = 'string';
var NUM = 'number';

var PhpBase = /*#__PURE__*/function (_EventTarget) {
  _inherits(PhpBase, _EventTarget);

  var _super = _createSuper(PhpBase);

  function PhpBase(PhpBinary) {
    var _this;

    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, PhpBase);

    _this = _super.call(this);
    var FLAGS = {};
    _this.returnValue = -1;

    _this.onerror = function () {};

    _this.onoutput = function () {};

    _this.onready = function () {};

    var callbacks = new _UniqueIndex.UniqueIndex();
    var targets = new _UniqueIndex.UniqueIndex();
    var defaults = {
      callbacks: callbacks,
      targets: targets,
      postRun: function postRun() {
        var event = new CustomEvent('ready');

        _this.onready(event);

        _this.dispatchEvent(event);
      },
      print: function print() {
        for (var _len = arguments.length, chunks = new Array(_len), _key = 0; _key < _len; _key++) {
          chunks[_key] = arguments[_key];
        }

        var event = new CustomEvent('output', {
          detail: chunks.map(function (c) {
            return c + "\n";
          })
        });

        _this.onoutput(event);

        _this.dispatchEvent(event);
      },
      printErr: function printErr() {
        for (var _len2 = arguments.length, chunks = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          chunks[_key2] = arguments[_key2];
        }

        var event = new CustomEvent('error', {
          detail: chunks.map(function (c) {
            return c + "\n";
          })
        });

        _this.onerror(event);

        _this.dispatchEvent(event);
      }
    };
    var phpSettings = window && window.phpSettings ? window.phpSettings : {};
    _this.binary = new PhpBinary(Object.assign({}, defaults, phpSettings, args)).then(function (php) {
      var retVal = php.ccall('pib_init', NUM, [STR], []);
      return php;
    })["catch"](function (error) {
      return console.error(error);
    });
    return _this;
  }

  _createClass(PhpBase, [{
    key: "run",
    value: function run(phpCode) {
      return this.binary.then(function (php) {
        return php.ccall('pib_run', NUM, [STR], ["?>".concat(phpCode)]);
      });
    }
  }, {
    key: "exec",
    value: function exec(phpCode) {
      return this.binary.then(function (php) {
        return php.ccall('pib_exec', STR, [STR], [phpCode]);
      });
    }
  }, {
    key: "refresh",
    value: function refresh() {
      var call = this.binary.then(function (php) {
        return php.ccall('pib_refresh', NUM, [], []);
      });
      call["catch"](function (error) {
        return console.error(error);
      });
      return call;
    }
  }]);

  return PhpBase;
}( /*#__PURE__*/_wrapNativeSuper(EventTarget));

exports.PhpBase = PhpBase;
  })();
});

require.register("php-wasm/PhpWebDrupal.js", function(exports, require, module) {
  require = __makeRelativeRequire(require, {}, "php-wasm");
  (function() {
    "use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhpWebDrupal = void 0;

var _PhpBase2 = require("./PhpBase");

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var PhpBinary = require('./php-web-drupal');

var PhpWebDrupal = /*#__PURE__*/function (_PhpBase) {
  _inherits(PhpWebDrupal, _PhpBase);

  var _super = _createSuper(PhpWebDrupal);

  function PhpWebDrupal() {
    var args = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, PhpWebDrupal);

    return _super.call(this, PhpBinary, args);
  }

  return PhpWebDrupal;
}(_PhpBase2.PhpBase);

exports.PhpWebDrupal = PhpWebDrupal;

if (window && document) {
  var php = new PhpWebDrupal();

  var runScriptTag = function runScriptTag(element) {
    var src = element.getAttribute('src');

    if (src) {
      fetch(src).then(function (r) {
        return r.text();
      }).then(function (r) {
        php.run(r).then(function (exit) {
          return console.log(exit);
        });
      });
      return;
    }

    var inlineCode = element.innerText.trim();

    if (inlineCode) {
      php.run(inlineCode);
    }
  };

  php.addEventListener('ready', function () {
    var phpSelector = 'script[type="text/php"]';
    var htmlNode = document.body.parentElement;
    var observer = new MutationObserver(function (mutations, observer) {
      var _iterator = _createForOfIteratorHelper(mutations),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var mutation = _step.value;

          var _iterator2 = _createForOfIteratorHelper(mutation.addedNodes),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var addedNode = _step2.value;

              if (!addedNode.matches || !addedNode.matches(phpSelector)) {
                continue;
              }

              runScriptTag(addedNode);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    });
    observer.observe(htmlNode, {
      childList: true,
      subtree: true
    });
    var phpNodes = document.querySelectorAll(phpSelector);

    var _iterator3 = _createForOfIteratorHelper(phpNodes),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var phpNode = _step3.value;
        var code = phpNode.innerText.trim();
        runScriptTag(phpNode);
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  });
}
  })();
});

require.register("php-wasm/UniqueIndex.js", function(exports, require, module) {
  require = __makeRelativeRequire(require, {}, "php-wasm");
  (function() {
    "use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UniqueIndex = void 0;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var UniqueIndex = function UniqueIndex() {
  _classCallCheck(this, UniqueIndex);

  var map = new Map();
  var set = new WeakMap();
  var id = 0;
  Object.defineProperty(this, 'add', {
    configurable: false,
    writable: false,
    value: function value(callback) {
      var existing = set.has(callback);

      if (existing) {
        return existing;
      }

      var newid = ++id;
      set.set(callback, newid);
      map.set(newid, callback);
      return newid;
    }
  });
  Object.defineProperty(this, 'has', {
    configurable: false,
    writable: false,
    value: function value(callback) {
      if (set.has(callback)) {
        return set.get(callback);
      }
    }
  });
  Object.defineProperty(this, 'get', {
    configurable: false,
    writable: false,
    value: function value(id) {
      if (map.has(id)) {
        return map.get(id);
      }
    }
  });
  Object.defineProperty(this, 'remove', {
    configurable: false,
    writable: false,
    value: function value(id) {
      var callback = map.get(id);

      if (callback) {
        set["delete"](callback);
        map["delete"](id);
      }
    }
  });
};

exports.UniqueIndex = UniqueIndex;
  })();
});

require.register("php-wasm/php-web-drupal.js", function(exports, require, module) {
  require = __makeRelativeRequire(require, {}, "php-wasm");
  (function() {
    var PHP = (function() {
  var _scriptDir = typeof document !== 'undefined' && document.currentScript ? document.currentScript.src : undefined;
  
  return (
function(PHP) {
  PHP = PHP || {};

var Module=typeof PHP!=="undefined"?PHP:{};var readyPromiseResolve,readyPromiseReject;Module["ready"]=new Promise(function(resolve,reject){readyPromiseResolve=resolve;readyPromiseReject=reject});if(!Module.expectedDataFileDownloads){Module.expectedDataFileDownloads=0}Module.expectedDataFileDownloads++;(function(){var loadPackage=function(metadata){var PACKAGE_PATH;if(typeof window==="object"){PACKAGE_PATH=window["encodeURIComponent"](window.location.pathname.toString().substring(0,window.location.pathname.toString().lastIndexOf("/"))+"/")}else if(typeof location!=="undefined"){PACKAGE_PATH=encodeURIComponent(location.pathname.toString().substring(0,location.pathname.toString().lastIndexOf("/"))+"/")}else{throw"using preloaded data can only be done on a web page or in a web worker"}var PACKAGE_NAME="../../build/php-web-drupal.data";var REMOTE_PACKAGE_BASE="php-web-drupal.data";if(typeof Module["locateFilePackage"]==="function"&&!Module["locateFile"]){Module["locateFile"]=Module["locateFilePackage"];err("warning: you defined Module.locateFilePackage, that has been renamed to Module.locateFile (using your locateFilePackage for now)")}var REMOTE_PACKAGE_NAME=Module["locateFile"]?Module["locateFile"](REMOTE_PACKAGE_BASE,""):REMOTE_PACKAGE_BASE;var REMOTE_PACKAGE_SIZE=metadata["remote_package_size"];var PACKAGE_UUID=metadata["package_uuid"];function fetchRemotePackage(packageName,packageSize,callback,errback){var xhr=new XMLHttpRequest;xhr.open("GET",packageName,true);xhr.responseType="arraybuffer";xhr.onprogress=function(event){var url=packageName;var size=packageSize;if(event.total)size=event.total;if(event.loaded){if(!xhr.addedTotal){xhr.addedTotal=true;if(!Module.dataFileDownloads)Module.dataFileDownloads={};Module.dataFileDownloads[url]={loaded:event.loaded,total:size}}else{Module.dataFileDownloads[url].loaded=event.loaded}var total=0;var loaded=0;var num=0;for(var download in Module.dataFileDownloads){var data=Module.dataFileDownloads[download];total+=data.total;loaded+=data.loaded;num++}total=Math.ceil(total*Module.expectedDataFileDownloads/num);if(Module["setStatus"])Module["setStatus"]("Downloading data... ("+loaded+"/"+total+")")}else if(!Module.dataFileDownloads){if(Module["setStatus"])Module["setStatus"]("Downloading data...")}};xhr.onerror=function(event){throw new Error("NetworkError for: "+packageName)};xhr.onload=function(event){if(xhr.status==200||xhr.status==304||xhr.status==206||xhr.status==0&&xhr.response){var packageData=xhr.response;callback(packageData)}else{throw new Error(xhr.statusText+" : "+xhr.responseURL)}};xhr.send(null)}function handleError(error){console.error("package error:",error)}var fetchedCallback=null;var fetched=Module["getPreloadedPackage"]?Module["getPreloadedPackage"](REMOTE_PACKAGE_NAME,REMOTE_PACKAGE_SIZE):null;if(!fetched)fetchRemotePackage(REMOTE_PACKAGE_NAME,REMOTE_PACKAGE_SIZE,function(data){if(fetchedCallback){fetchedCallback(data);fetchedCallback=null}else{fetched=data}},handleError);function runWithFS(){function assert(check,msg){if(!check)throw msg+(new Error).stack}Module["FS_createPath"]("/","preload",true,true);Module["FS_createPath"]("/preload","drupal-7.59",true,true);Module["FS_createPath"]("/preload/drupal-7.59","includes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/includes","filetransfer",true,true);Module["FS_createPath"]("/preload/drupal-7.59/includes","database",true,true);Module["FS_createPath"]("/preload/drupal-7.59/includes/database","sqlite",true,true);Module["FS_createPath"]("/preload/drupal-7.59/includes/database","mysql",true,true);Module["FS_createPath"]("/preload/drupal-7.59/includes/database","pgsql",true,true);Module["FS_createPath"]("/preload/drupal-7.59","themes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes","stark",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes","garland",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/garland","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/garland","color",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes","engines",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/engines","phptemplate",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes","seven",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/seven","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes","bartik",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/bartik","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/bartik","color",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/bartik","css",true,true);Module["FS_createPath"]("/preload/drupal-7.59/themes/bartik","templates",true,true);Module["FS_createPath"]("/preload/drupal-7.59","scripts",true,true);Module["FS_createPath"]("/preload/drupal-7.59","modules",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","simpletest",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest","src",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/src","Tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest","files",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/files","css_test_files",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/files/css_test_files","css_subfolder",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest","lib",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/lib","Drupal",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/lib/Drupal","simpletest",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/lib/Drupal/simpletest","Tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","drupal_system_listing_incompatible_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","drupal_system_listing_compatible_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","themes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes","engines",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes/engines","nyan_cat",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes","test_basetheme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes","test_theme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme","templates",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes","test_subtheme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes","test_theme_nyan_cat",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme_nyan_cat","templates",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","psr_4_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_4_test","src",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/src","Tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/src/Tests","Nested",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","psr_0_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_0_test","lib",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib","Drupal",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib/Drupal","psr_0_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib/Drupal/psr_0_test","Tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib/Drupal/psr_0_test/Tests","Nested",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","drupal_autoload_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/simpletest/tests","upgrade",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","field",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field","theme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field","modules",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules","options",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules","number",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules","list",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules/list","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules","field_sql_storage",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field/modules","text",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/field","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","help",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","menu",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","trigger",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/trigger","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","color",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/color","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","blog",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","path",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","contextual",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/contextual","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","locale",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/locale","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/locale/tests","translations",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","shortcut",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","toolbar",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","aggregator",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/aggregator","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","search",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/search","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","tracker",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","file",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/file","icons",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/file","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","block",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/block","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/block/tests","themes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/block/tests/themes","block_test_theme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","translation",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/translation","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","taxonomy",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","statistics",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","poll",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","book",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","image",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/image","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","system",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/system","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","syslog",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","filter",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/filter","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","comment",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","dashboard",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","profile",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","php",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","contact",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","forum",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","node",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/node","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","user",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/user","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","openid",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/openid","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","dblog",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","update",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/update","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/update/tests","themes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/update/tests/themes","update_test_admintheme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/update/tests/themes","update_test_basetheme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/update/tests/themes","update_test_subtheme",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","field_ui",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","rdf",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/rdf","tests",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules","overlay",true,true);Module["FS_createPath"]("/preload/drupal-7.59/modules/overlay","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59","misc",true,true);Module["FS_createPath"]("/preload/drupal-7.59/misc","ui",true,true);Module["FS_createPath"]("/preload/drupal-7.59/misc/ui","images",true,true);Module["FS_createPath"]("/preload/drupal-7.59/misc","farbtastic",true,true);Module["FS_createPath"]("/preload/drupal-7.59","sites",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites","all",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/all","libraries",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/all","themes",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/all","modules",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites","default",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/default","files",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/default/files","styles",true,true);Module["FS_createPath"]("/preload/drupal-7.59/sites/default/files","tmp",true,true);Module["FS_createPath"]("/preload/drupal-7.59","profiles",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles","standard",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles/standard","translations",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles","testing",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles/testing","modules",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles/testing/modules","drupal_system_listing_incompatible_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles/testing/modules","drupal_system_listing_compatible_test",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles","minimal",true,true);Module["FS_createPath"]("/preload/drupal-7.59/profiles/minimal","translations",true,true);Module["FS_createPath"]("/preload","Zend",true,true);function DataRequest(start,end,audio){this.start=start;this.end=end;this.audio=audio}DataRequest.prototype={requests:{},open:function(mode,name){this.name=name;this.requests[name]=this;Module["addRunDependency"]("fp "+this.name)},send:function(){},onload:function(){var byteArray=this.byteArray.subarray(this.start,this.end);this.finish(byteArray)},finish:function(byteArray){var that=this;Module["FS_createDataFile"](this.name,null,byteArray,true,true,true);Module["removeRunDependency"]("fp "+that.name);this.requests[this.name]=null}};var files=metadata["files"];for(var i=0;i<files.length;++i){new DataRequest(files[i]["start"],files[i]["end"],files[i]["audio"]).open("GET",files[i]["filename"])}function processPackageData(arrayBuffer){assert(arrayBuffer,"Loading data file failed.");assert(arrayBuffer instanceof ArrayBuffer,"bad input to processPackageData");var byteArray=new Uint8Array(arrayBuffer);DataRequest.prototype.byteArray=byteArray;var files=metadata["files"];for(var i=0;i<files.length;++i){DataRequest.prototype.requests[files[i].filename].onload()}Module["removeRunDependency"]("datafile_../../build/php-web-drupal.data")}Module["addRunDependency"]("datafile_../../build/php-web-drupal.data");if(!Module.preloadResults)Module.preloadResults={};Module.preloadResults[PACKAGE_NAME]={fromCache:false};if(fetched){processPackageData(fetched);fetched=null}else{fetchedCallback=processPackageData}}if(Module["calledRun"]){runWithFS()}else{if(!Module["preRun"])Module["preRun"]=[];Module["preRun"].push(runWithFS)}};loadPackage({"files":[{"filename":"/preload/drupal-7.59/install.php","start":0,"end":703,"audio":0},{"filename":"/preload/drupal-7.59/UPGRADE.txt","start":703,"end":10826,"audio":0},{"filename":"/preload/drupal-7.59/LICENSE.txt","start":10826,"end":28918,"audio":0},{"filename":"/preload/drupal-7.59/xmlrpc.php","start":28918,"end":29335,"audio":0},{"filename":"/preload/drupal-7.59/authorize.php","start":29335,"end":35939,"audio":0},{"filename":"/preload/drupal-7.59/README.txt","start":35939,"end":41321,"audio":0},{"filename":"/preload/drupal-7.59/update.php","start":41321,"end":61307,"audio":0},{"filename":"/preload/drupal-7.59/MAINTAINERS.txt","start":61307,"end":70017,"audio":0},{"filename":"/preload/drupal-7.59/cron.php","start":70017,"end":70737,"audio":0},{"filename":"/preload/drupal-7.59/.gitignore","start":70737,"end":70911,"audio":0},{"filename":"/preload/drupal-7.59/INSTALL.mysql.txt","start":70911,"end":72628,"audio":0},{"filename":"/preload/drupal-7.59/.editorconfig","start":72628,"end":72945,"audio":0},{"filename":"/preload/drupal-7.59/web.config","start":72945,"end":75145,"audio":0},{"filename":"/preload/drupal-7.59/.htaccess","start":75145,"end":81257,"audio":0},{"filename":"/preload/drupal-7.59/INSTALL.txt","start":81257,"end":99252,"audio":0},{"filename":"/preload/drupal-7.59/robots.txt","start":99252,"end":101441,"audio":0},{"filename":"/preload/drupal-7.59/index.php","start":101441,"end":101970,"audio":0},{"filename":"/preload/drupal-7.59/COPYRIGHT.txt","start":101970,"end":103451,"audio":0},{"filename":"/preload/drupal-7.59/INSTALL.sqlite.txt","start":103451,"end":104749,"audio":0},{"filename":"/preload/drupal-7.59/CHANGELOG.txt","start":104749,"end":216728,"audio":0},{"filename":"/preload/drupal-7.59/INSTALL.pgsql.txt","start":216728,"end":218602,"audio":0},{"filename":"/preload/drupal-7.59/includes/theme.maintenance.inc","start":218602,"end":225672,"audio":0},{"filename":"/preload/drupal-7.59/includes/module.inc","start":225672,"end":269329,"audio":0},{"filename":"/preload/drupal-7.59/includes/path.inc","start":269329,"end":290135,"audio":0},{"filename":"/preload/drupal-7.59/includes/entity.inc","start":290135,"end":340090,"audio":0},{"filename":"/preload/drupal-7.59/includes/form.inc","start":340090,"end":540440,"audio":0},{"filename":"/preload/drupal-7.59/includes/mail.inc","start":540440,"end":563683,"audio":0},{"filename":"/preload/drupal-7.59/includes/utility.inc","start":563683,"end":565674,"audio":0},{"filename":"/preload/drupal-7.59/includes/unicode.inc","start":565674,"end":588429,"audio":0},{"filename":"/preload/drupal-7.59/includes/authorize.inc","start":588429,"end":602093,"audio":0},{"filename":"/preload/drupal-7.59/includes/cache.inc","start":602093,"end":623143,"audio":0},{"filename":"/preload/drupal-7.59/includes/menu.inc","start":623143,"end":764951,"audio":0},{"filename":"/preload/drupal-7.59/includes/unicode.entities.inc","start":764951,"end":770438,"audio":0},{"filename":"/preload/drupal-7.59/includes/ajax.inc","start":770438,"end":820895,"audio":0},{"filename":"/preload/drupal-7.59/includes/errors.inc","start":820895,"end":831770,"audio":0},{"filename":"/preload/drupal-7.59/includes/file.inc","start":831770,"end":923614,"audio":0},{"filename":"/preload/drupal-7.59/includes/date.inc","start":923614,"end":928120,"audio":0},{"filename":"/preload/drupal-7.59/includes/common.inc","start":928120,"end":1243003,"audio":0},{"filename":"/preload/drupal-7.59/includes/install.core.inc","start":1243003,"end":1322842,"audio":0},{"filename":"/preload/drupal-7.59/includes/image.inc","start":1322842,"end":1336258,"audio":0},{"filename":"/preload/drupal-7.59/includes/iso.inc","start":1336258,"end":1351828,"audio":0},{"filename":"/preload/drupal-7.59/includes/update.inc","start":1351828,"end":1411244,"audio":0},{"filename":"/preload/drupal-7.59/includes/archiver.inc","start":1411244,"end":1412945,"audio":0},{"filename":"/preload/drupal-7.59/includes/tablesort.inc","start":1412945,"end":1420392,"audio":0},{"filename":"/preload/drupal-7.59/includes/session.inc","start":1420392,"end":1438776,"audio":0},{"filename":"/preload/drupal-7.59/includes/graph.inc","start":1438776,"end":1443604,"audio":0},{"filename":"/preload/drupal-7.59/includes/batch.inc","start":1443604,"end":1461113,"audio":0},{"filename":"/preload/drupal-7.59/includes/password.inc","start":1461113,"end":1470634,"audio":0},{"filename":"/preload/drupal-7.59/includes/file.mimetypes.inc","start":1470634,"end":1495006,"audio":0},{"filename":"/preload/drupal-7.59/includes/pager.inc","start":1495006,"end":1517560,"audio":0},{"filename":"/preload/drupal-7.59/includes/xmlrpcs.inc","start":1517560,"end":1529393,"audio":0},{"filename":"/preload/drupal-7.59/includes/request-sanitizer.inc","start":1529393,"end":1533541,"audio":0},{"filename":"/preload/drupal-7.59/includes/updater.inc","start":1533541,"end":1547216,"audio":0},{"filename":"/preload/drupal-7.59/includes/batch.queue.inc","start":1547216,"end":1549526,"audio":0},{"filename":"/preload/drupal-7.59/includes/registry.inc","start":1549526,"end":1556038,"audio":0},{"filename":"/preload/drupal-7.59/includes/xmlrpc.inc","start":1556038,"end":1574866,"audio":0},{"filename":"/preload/drupal-7.59/includes/language.inc","start":1574866,"end":1594338,"audio":0},{"filename":"/preload/drupal-7.59/includes/theme.inc","start":1594338,"end":1709120,"audio":0},{"filename":"/preload/drupal-7.59/includes/locale.inc","start":1709120,"end":1795569,"audio":0},{"filename":"/preload/drupal-7.59/includes/cache-install.inc","start":1795569,"end":1798056,"audio":0},{"filename":"/preload/drupal-7.59/includes/stream_wrappers.inc","start":1798056,"end":1826294,"audio":0},{"filename":"/preload/drupal-7.59/includes/lock.inc","start":1826294,"end":1835719,"audio":0},{"filename":"/preload/drupal-7.59/includes/json-encode.inc","start":1835719,"end":1838907,"audio":0},{"filename":"/preload/drupal-7.59/includes/install.inc","start":1838907,"end":1883252,"audio":0},{"filename":"/preload/drupal-7.59/includes/token.inc","start":1883252,"end":1893116,"audio":0},{"filename":"/preload/drupal-7.59/includes/bootstrap.inc","start":1893116,"end":2028518,"audio":0},{"filename":"/preload/drupal-7.59/includes/actions.inc","start":2028518,"end":2042334,"audio":0},{"filename":"/preload/drupal-7.59/includes/filetransfer/local.inc","start":2042334,"end":2045111,"audio":0},{"filename":"/preload/drupal-7.59/includes/filetransfer/ssh.inc","start":2045111,"end":2049240,"audio":0},{"filename":"/preload/drupal-7.59/includes/filetransfer/ftp.inc","start":2049240,"end":2054030,"audio":0},{"filename":"/preload/drupal-7.59/includes/filetransfer/filetransfer.inc","start":2054030,"end":2066039,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/log.inc","start":2066039,"end":2070911,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/database.inc","start":2070911,"end":2168279,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/select.inc","start":2168279,"end":2219021,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/schema.inc","start":2219021,"end":2246391,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/query.inc","start":2246391,"end":2303817,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/prefetch.inc","start":2303817,"end":2317807,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/sqlite/database.inc","start":2317807,"end":2335854,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/sqlite/select.inc","start":2335854,"end":2336258,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/sqlite/schema.inc","start":2336258,"end":2359660,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/sqlite/query.inc","start":2359660,"end":2364166,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/sqlite/install.inc","start":2364166,"end":2365791,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/mysql/database.inc","start":2365791,"end":2375930,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/mysql/schema.inc","start":2375930,"end":2394906,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/mysql/query.inc","start":2394906,"end":2397817,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/mysql/install.inc","start":2397817,"end":2398446,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/pgsql/database.inc","start":2398446,"end":2406658,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/pgsql/select.inc","start":2406658,"end":2410115,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/pgsql/schema.inc","start":2410115,"end":2433166,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/pgsql/query.inc","start":2433166,"end":2441038,"audio":0},{"filename":"/preload/drupal-7.59/includes/database/pgsql/install.inc","start":2441038,"end":2448172,"audio":0},{"filename":"/preload/drupal-7.59/themes/README.txt","start":2448172,"end":2448616,"audio":0},{"filename":"/preload/drupal-7.59/themes/stark/README.txt","start":2448616,"end":2449620,"audio":0},{"filename":"/preload/drupal-7.59/themes/stark/layout.css","start":2449620,"end":2450824,"audio":0},{"filename":"/preload/drupal-7.59/themes/stark/stark.info","start":2450824,"end":2451263,"audio":0},{"filename":"/preload/drupal-7.59/themes/stark/logo.png","start":2451263,"end":2453589,"audio":0},{"filename":"/preload/drupal-7.59/themes/stark/screenshot.png","start":2453589,"end":2465251,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/node.tpl.php","start":2465251,"end":2466243,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/maintenance-page.tpl.php","start":2466243,"end":2468992,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/fix-ie-rtl.css","start":2468992,"end":2470154,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/theme-settings.php","start":2470154,"end":2470907,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/print.css","start":2470907,"end":2471954,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/page.tpl.php","start":2471954,"end":2474868,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/template.php","start":2474868,"end":2479534,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/style.css","start":2479534,"end":2500320,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/style-rtl.css","start":2500320,"end":2505287,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/logo.png","start":2505287,"end":2510403,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/garland.info","start":2510403,"end":2510811,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/comment.tpl.php","start":2510811,"end":2511625,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/fix-ie.css","start":2511625,"end":2512945,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/screenshot.png","start":2512945,"end":2523895,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/task-list.png","start":2523895,"end":2524023,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/body.png","start":2524023,"end":2524703,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/menu-collapsed.gif","start":2524703,"end":2524879,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-content.png","start":2524879,"end":2525364,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-tab.png","start":2525364,"end":2525479,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/menu-expanded.gif","start":2525479,"end":2525662,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-content-right.png","start":2525662,"end":2528481,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-navigation-item-hover.png","start":2528481,"end":2528922,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/gradient-inner.png","start":2528922,"end":2529110,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/menu-collapsed-rtl.gif","start":2529110,"end":2529286,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-content-left.png","start":2529286,"end":2532175,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/menu-leaf.gif","start":2532175,"end":2532349,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-navigation.png","start":2532349,"end":2532453,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-bar-white.png","start":2532453,"end":2532556,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-bar.png","start":2532556,"end":2532681,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/images/bg-navigation-item.png","start":2532681,"end":2533180,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/color/preview.css","start":2533180,"end":2534102,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/color/base.png","start":2534102,"end":2554996,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/color/color.inc","start":2554996,"end":2560955,"audio":0},{"filename":"/preload/drupal-7.59/themes/garland/color/preview.png","start":2560955,"end":2570920,"audio":0},{"filename":"/preload/drupal-7.59/themes/engines/phptemplate/phptemplate.engine","start":2570920,"end":2571492,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/seven.info","start":2571492,"end":2572043,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/ie6.css","start":2572043,"end":2572311,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/maintenance-page.tpl.php","start":2572311,"end":2573621,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/page.tpl.php","start":2573621,"end":2574750,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/template.php","start":2574750,"end":2579456,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/vertical-tabs.css","start":2579456,"end":2581869,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/style.css","start":2581869,"end":2600323,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/ie7.css","start":2600323,"end":2600691,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/reset.css","start":2600691,"end":2603638,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/jquery.ui.theme.css","start":2603638,"end":2618872,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/style-rtl.css","start":2618872,"end":2622634,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/vertical-tabs-rtl.css","start":2622634,"end":2623140,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/logo.png","start":2623140,"end":2627045,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/screenshot.png","start":2627045,"end":2639343,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/ie.css","start":2639343,"end":2639647,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/fc.png","start":2639647,"end":2639729,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/arrow-asc.png","start":2639729,"end":2639817,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/list-item-rtl.png","start":2639817,"end":2640042,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/task-item.png","start":2640042,"end":2640147,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/task-item-rtl.png","start":2640147,"end":2640325,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/ui-icons-800000-256x240.png","start":2640325,"end":2644027,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/ui-icons-222222-256x240.png","start":2644027,"end":2647729,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/arrow-prev.png","start":2647729,"end":2647844,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/buttons.png","start":2647844,"end":2648630,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/ui-icons-454545-256x240.png","start":2648630,"end":2652332,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/fc-rtl.png","start":2652332,"end":2652408,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/add.png","start":2652408,"end":2652568,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/ui-icons-ffffff-256x240.png","start":2652568,"end":2656270,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/task-check.png","start":2656270,"end":2656531,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/ui-icons-888888-256x240.png","start":2656531,"end":2660233,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/arrow-next.png","start":2660233,"end":2660351,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/arrow-desc.png","start":2660351,"end":2660446,"audio":0},{"filename":"/preload/drupal-7.59/themes/seven/images/list-item.png","start":2660446,"end":2660641,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/bartik.info","start":2660641,"end":2661709,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/template.php","start":2661709,"end":2667626,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/logo.png","start":2667626,"end":2671105,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/screenshot.png","start":2671105,"end":2690763,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/comment-arrow.gif","start":2690763,"end":2690860,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/comment-arrow-rtl.gif","start":2690860,"end":2690957,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/tabs-border.png","start":2690957,"end":2691040,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/buttons.png","start":2691040,"end":2691871,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/add.png","start":2691871,"end":2691965,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/images/search-button.png","start":2691965,"end":2692690,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/preview.js","start":2692690,"end":2694708,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/preview.css","start":2694708,"end":2699079,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/base.png","start":2699079,"end":2699185,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/color.inc","start":2699185,"end":2702766,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/preview.png","start":2702766,"end":2702872,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/color/preview.html","start":2702872,"end":2705027,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/maintenance-page.css","start":2705027,"end":2706340,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/ie6.css","start":2706340,"end":2706637,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/print.css","start":2706637,"end":2707293,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/ie-rtl.css","start":2707293,"end":2708142,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/layout-rtl.css","start":2708142,"end":2708525,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/layout.css","start":2708525,"end":2710159,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/style.css","start":2710159,"end":2742861,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/style-rtl.css","start":2742861,"end":2747728,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/ie.css","start":2747728,"end":2748847,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/css/colors.css","start":2748847,"end":2750159,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/templates/comment-wrapper.tpl.php","start":2750159,"end":2752161,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/templates/node.tpl.php","start":2752161,"end":2757565,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/templates/maintenance-page.tpl.php","start":2757565,"end":2760131,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/templates/page.tpl.php","start":2760131,"end":2770361,"audio":0},{"filename":"/preload/drupal-7.59/themes/bartik/templates/comment.tpl.php","start":2770361,"end":2774365,"audio":0},{"filename":"/preload/drupal-7.59/scripts/cron-curl.sh","start":2774365,"end":2774431,"audio":0},{"filename":"/preload/drupal-7.59/scripts/dump-database-d7.sh","start":2774431,"end":2777004,"audio":0},{"filename":"/preload/drupal-7.59/scripts/code-clean.sh","start":2777004,"end":2777573,"audio":0},{"filename":"/preload/drupal-7.59/scripts/drupal.sh","start":2777573,"end":2781837,"audio":0},{"filename":"/preload/drupal-7.59/scripts/dump-database-d6.sh","start":2781837,"end":2784792,"audio":0},{"filename":"/preload/drupal-7.59/scripts/generate-d7-content.sh","start":2784792,"end":2795582,"audio":0},{"filename":"/preload/drupal-7.59/scripts/run-tests.sh","start":2795582,"end":2821056,"audio":0},{"filename":"/preload/drupal-7.59/scripts/test.script","start":2821056,"end":2821241,"audio":0},{"filename":"/preload/drupal-7.59/scripts/generate-d6-content.sh","start":2821241,"end":2828113,"audio":0},{"filename":"/preload/drupal-7.59/scripts/password-hash.sh","start":2828113,"end":2830480,"audio":0},{"filename":"/preload/drupal-7.59/scripts/cron-lynx.sh","start":2830480,"end":2830558,"audio":0},{"filename":"/preload/drupal-7.59/modules/README.txt","start":2830558,"end":2831006,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.pages.inc","start":2831006,"end":2849020,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.css","start":2849020,"end":2850528,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/drupal_web_test_case.php","start":2850528,"end":2986768,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.info","start":2986768,"end":2988789,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.module","start":2988789,"end":3012973,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.install","start":3012973,"end":3019813,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.js","start":3019813,"end":3023407,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.api.php","start":3023407,"end":3024627,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/simpletest.test","start":3024627,"end":3054928,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/src/Tests/PSR4WebTest.php","start":3054928,"end":3055323,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-test-transparent-out-of-range.gif","start":3055323,"end":3055506,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/php-1.txt","start":3055506,"end":3055553,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/javascript-1.txt","start":3055553,"end":3055611,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-1.png","start":3055611,"end":3094936,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/README.txt","start":3094936,"end":3095180,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-test.jpg","start":3095180,"end":3097081,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/html-2.html","start":3097081,"end":3097105,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-test.png","start":3097105,"end":3097230,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/sql-2.sql","start":3097230,"end":3097271,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/javascript-2.script","start":3097271,"end":3097328,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-test.gif","start":3097328,"end":3097511,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/php-2.php","start":3097511,"end":3097555,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/html-1.txt","start":3097555,"end":3097579,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-2.jpg","start":3097579,"end":3099410,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/sql-1.txt","start":3099410,"end":3099451,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/image-test-no-transparency.gif","start":3099451,"end":3100415,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_with_import.css.unoptimized.css","start":3100415,"end":3101932,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_with_import.css","start":3101932,"end":3102415,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/comment_hacks.css.unoptimized.css","start":3102415,"end":3164330,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_with_import.css.optimized.css","start":3164330,"end":3165623,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_without_import.css.optimized.css","start":3165623,"end":3166435,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_without_import.css","start":3166435,"end":3167589,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_input_without_import.css.unoptimized.css","start":3167589,"end":3168743,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/comment_hacks.css.optimized.css","start":3168743,"end":3169587,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/import1.css","start":3169587,"end":3170594,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/import2.css","start":3170594,"end":3170665,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/comment_hacks.css","start":3170665,"end":3232580,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_subfolder/css_input_with_import.css.unoptimized.css","start":3232580,"end":3234014,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_subfolder/css_input_with_import.css","start":3234014,"end":3234417,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/files/css_test_files/css_subfolder/css_input_with_import.css.optimized.css","start":3234417,"end":3235630,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/lib/Drupal/simpletest/Tests/PSR0WebTest.php","start":3235630,"end":3236025,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/ajax_forms_test.module","start":3236025,"end":3252983,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_dependencies_test.module","start":3252983,"end":3252989,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_1.info","start":3252989,"end":3253249,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_1.module","start":3253249,"end":3253255,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_test.info","start":3253255,"end":3253540,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/image_test.info","start":3253540,"end":3253804,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/theme_test.info","start":3253804,"end":3254069,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module.test","start":3254069,"end":3270753,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/image.test","start":3270753,"end":3291652,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/path_test.info","start":3291652,"end":3291919,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_query_access_test.module","start":3291919,"end":3293454,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/xmlrpc.test","start":3293454,"end":3304851,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/file_test.module","start":3304851,"end":3317373,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_cache_test.module","start":3317373,"end":3318246,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_module_version_test.module","start":3318246,"end":3318252,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/requirements1_test.module","start":3318252,"end":3318363,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/path.test","start":3318363,"end":3331947,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/lock.test","start":3331947,"end":3334571,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/theme_test.template_test.tpl.php","start":3334571,"end":3334637,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/actions_loop_test.info","start":3334637,"end":3334904,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/graph.test","start":3334904,"end":3341281,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/ajax_test.info","start":3341281,"end":3341541,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/form.test","start":3341541,"end":3434797,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module_test.implementations.inc","start":3434797,"end":3434968,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/boot.test","start":3434968,"end":3436152,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/url_alter_test.module","start":3436152,"end":3437947,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/session.test","start":3437947,"end":3461299,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/database_test.module","start":3461299,"end":3467963,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_module_version_dependencies_test.info","start":3467963,"end":3468404,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_query_access_test.info","start":3468404,"end":3468692,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module_test.module","start":3468692,"end":3472870,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module_test.file.inc","start":3472870,"end":3473073,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/requirements2_test.module","start":3473073,"end":3473203,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module_test.info","start":3473203,"end":3473470,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test_cron_helper.info","start":3473470,"end":3473764,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/batch_test.module","start":3473764,"end":3487399,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/filetransfer.test","start":3487399,"end":3491943,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/theme_test.inc","start":3491943,"end":3492315,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/theme_test.module","start":3492315,"end":3497430,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/actions_loop_test.module","start":3497430,"end":3500029,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/boot_test_2.module","start":3500029,"end":3500218,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/pager.test","start":3500218,"end":3505707,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/https.php","start":3505707,"end":3506567,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_core_version_dependencies_test.info","start":3506567,"end":3506934,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update.test","start":3506934,"end":3511733,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/menu_test.info","start":3511733,"end":3512e3,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/schema.test","start":3512e3,"end":3525772,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test.module","start":3525772,"end":3533530,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/session_test.module","start":3533530,"end":3539114,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/menu.test","start":3539114,"end":3612464,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/theme.test","start":3612464,"end":3639214,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_3.module","start":3639214,"end":3639220,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_1.install","start":3639220,"end":3640847,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/boot_test_1.module","start":3640847,"end":3641397,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test_cron_helper.module","start":3641397,"end":3641759,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_cache_test.info","start":3641759,"end":3642077,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/xmlrpc_test.module","start":3642077,"end":3645256,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_crud_hook_test.test","start":3645256,"end":3658027,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/database_test.test","start":3658027,"end":3805618,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_project_namespace_test.info","start":3805618,"end":3805951,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_query.test","start":3805951,"end":3873142,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/menu_test.module","start":3873142,"end":3891505,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/xmlrpc_test.info","start":3891505,"end":3891807,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/bootstrap.test","start":3891807,"end":3934914,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_test.module","start":3934914,"end":3953506,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/form_test.module","start":3953506,"end":4013678,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test.print.css","start":4013678,"end":4013757,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test.info","start":4013757,"end":4014097,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/file.test","start":4014097,"end":4126010,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/database_test.info","start":4126010,"end":4126278,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/registry.test","start":4126278,"end":4131050,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common.test","start":4131050,"end":4269828,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_test.install","start":4269828,"end":4270366,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_project_namespace_test.module","start":4270366,"end":4270372,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/http.php","start":4270372,"end":4271269,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_cache_test_dependency.module","start":4271269,"end":4271574,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/batch.test","start":4271574,"end":4288458,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/url_alter_test.install","start":4288458,"end":4288725,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_core_version_test.module","start":4288725,"end":4288731,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/error.test","start":4288731,"end":4293417,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_script_test.info","start":4293417,"end":4293691,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/taxonomy_test.install","start":4293691,"end":4294438,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/filter_test.module","start":4294438,"end":4296155,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test.css","start":4296155,"end":4296234,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_module_version_test.info","start":4296234,"end":4296531,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_2.install","start":4296531,"end":4297738,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/actions_loop_test.install","start":4297738,"end":4297944,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/batch_test.info","start":4297944,"end":4298208,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module","start":4298208,"end":4298214,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/form_test.info","start":4298214,"end":4298475,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_dependencies_test.info","start":4298475,"end":4298796,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/database_test.install","start":4298796,"end":4304649,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/file_test.info","start":4304649,"end":4304939,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_3.install","start":4304939,"end":4305375,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/ajax.test","start":4305375,"end":4332155,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/form_test.file.inc","start":4332155,"end":4333588,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_core_version_test.info","start":4333588,"end":4333887,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/mail.test","start":4333887,"end":4353109,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/ajax_forms_test.info","start":4353109,"end":4353375,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_cache_test_dependency.info","start":4353375,"end":4353669,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_script_test.install","start":4353669,"end":4355617,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_2.info","start":4355617,"end":4355877,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/path_test.module","start":4355877,"end":4356287,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_script_test.module","start":4356287,"end":4356706,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/unicode.test","start":4356706,"end":4367857,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/requirements1_test.info","start":4367857,"end":4368169,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/session_test.info","start":4368169,"end":4368436,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/ajax_test.module","start":4368436,"end":4370325,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_crud.test","start":4370325,"end":4372234,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/batch_test.callbacks.inc","start":4372234,"end":4376740,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/actions.test","start":4376740,"end":4382580,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_3.info","start":4382580,"end":4382840,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_crud_hook_test.info","start":4382840,"end":4383112,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/boot_test_2.info","start":4383112,"end":4383388,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/requirements2_test.info","start":4383388,"end":4383779,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/boot_test_1.info","start":4383779,"end":4384050,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/password.test","start":4384050,"end":4387577,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/image_test.module","start":4387577,"end":4390820,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/common_test_info.txt","start":4390820,"end":4391154,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/taxonomy_test.info","start":4391154,"end":4391458,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/module_test.install","start":4391458,"end":4392388,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/url_alter_test.info","start":4392388,"end":4392659,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/cache.test","start":4392659,"end":4408410,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/tablesort.test","start":4408410,"end":4413193,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module","start":4413193,"end":4413199,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/error_test.module","start":4413199,"end":4415130,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/taxonomy_test.module","start":4415130,"end":4418550,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/entity_crud_hook_test.module","start":4418550,"end":4424693,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/system.base.css","start":4424693,"end":4424836,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/update_test_2.module","start":4424836,"end":4424842,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/requirements1_test.install","start":4424842,"end":4425347,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/error_test.info","start":4425347,"end":4425619,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/filter_test.info","start":4425619,"end":4425881,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module","start":4425881,"end":4425887,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.info","start":4425887,"end":4426203,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module","start":4426203,"end":4426209,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.info","start":4426209,"end":4426523,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/engines/nyan_cat/nyan_cat.engine","start":4426523,"end":4427841,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_basetheme/test_basetheme.info","start":4427841,"end":4428192,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme/template.php","start":4428192,"end":4428773,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme/test_theme.info","start":4428773,"end":4429819,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme/templates/node--1.tpl.php","start":4429819,"end":4429882,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_subtheme/test_subtheme.info","start":4429882,"end":4430205,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme_nyan_cat/test_theme_nyan_cat.info","start":4430205,"end":4430482,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/themes/test_theme_nyan_cat/templates/theme_test_template_test.nyan-cat.html","start":4430482,"end":4430487,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/psr_4_test.info","start":4430487,"end":4430741,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/psr_4_test.module","start":4430741,"end":4430747,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/src/Tests/ExampleTest.php","start":4430747,"end":4431168,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_4_test/src/Tests/Nested/NestedExampleTest.php","start":4431168,"end":4431609,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/psr_0_test.info","start":4431609,"end":4431863,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/psr_0_test.module","start":4431863,"end":4431869,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib/Drupal/psr_0_test/Tests/ExampleTest.php","start":4431869,"end":4432290,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/psr_0_test/lib/Drupal/psr_0_test/Tests/Nested/NestedExampleTest.php","start":4432290,"end":4432731,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test_trait.sh","start":4432731,"end":4433133,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test_interface.inc","start":4433133,"end":4433324,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.info","start":4433324,"end":4433695,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test_class.inc","start":4433695,"end":4433910,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.module","start":4433910,"end":4434489,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.bare.database.php","start":4434489,"end":4669957,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/update.user.test","start":4669957,"end":4670885,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/update.trigger.test","start":4670885,"end":4671961,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.trigger.database.php","start":4671961,"end":4673602,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.locale.database.php","start":4673602,"end":4679065,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.test","start":4679065,"end":4704208,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.node_type_broken.database.php","start":4704208,"end":4704859,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.poll.test","start":4704859,"end":4706960,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.filled.standard_all.database.php.gz","start":4706960,"end":4804563,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.filled.minimal.database.php.gz","start":4804563,"end":4846368,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/update.field.test","start":4846368,"end":4848093,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.user.test","start":4848093,"end":4851694,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.user-password-token.database.php","start":4851694,"end":4852808,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.taxonomy.test","start":4852808,"end":4862049,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.upload.test","start":4862049,"end":4867262,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.upload.database.php","start":4867262,"end":4879174,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.bare.standard_all.database.php.gz","start":4879174,"end":4956598,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.trigger.database.php","start":4956598,"end":4957107,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.aggregator.database.php","start":4957107,"end":4978134,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.comment.test","start":4978134,"end":4979011,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.locale.test","start":4979011,"end":4983414,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.filter.test","start":4983414,"end":4985311,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.translatable.database.php","start":4985311,"end":4987589,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.comments.database.php","start":4987589,"end":4988336,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.bare.minimal.database.php.gz","start":4988336,"end":5028179,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.menu.test","start":5028179,"end":5031949,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.filled.database.php","start":5031949,"end":5609192,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.user-no-password-token.database.php","start":5609192,"end":5609462,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.forum.database.php","start":5609462,"end":5614222,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/update.aggregator.test","start":5614222,"end":5615716,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.duplicate-permission.database.php","start":5615716,"end":5615891,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-7.field.database.php","start":5615891,"end":5616371,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/drupal-6.menu.database.php","start":5616371,"end":5620165,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.trigger.test","start":5620165,"end":5621377,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.forum.test","start":5621377,"end":5623708,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.node.test","start":5623708,"end":5629174,"audio":0},{"filename":"/preload/drupal-7.59/modules/simpletest/tests/upgrade/upgrade.translatable.test","start":5629174,"end":5631180,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.info","start":5631180,"end":5631632,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.install","start":5631632,"end":5647325,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.default.inc","start":5647325,"end":5657361,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.api.php","start":5657361,"end":5757150,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.multilingual.inc","start":5757150,"end":5768624,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.form.inc","start":5768624,"end":5791421,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.info.class.inc","start":5791421,"end":5813448,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.module","start":5813448,"end":5863447,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.crud.inc","start":5863447,"end":5903164,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.info.inc","start":5903164,"end":5929288,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/field.attach.inc","start":5929288,"end":5985600,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/theme/field.tpl.php","start":5985600,"end":5988538,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/theme/field.css","start":5988538,"end":5989088,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/theme/field-rtl.css","start":5989088,"end":5989409,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/options/options.module","start":5989409,"end":6001911,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/options/options.info","start":6001911,"end":6002240,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/options/options.api.php","start":6002240,"end":6004685,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/options/options.test","start":6004685,"end":6028015,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/number/number.module","start":6028015,"end":6043578,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/number/number.install","start":6043578,"end":6044451,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/number/number.info","start":6044451,"end":6044724,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/number/number.test","start":6044724,"end":6050903,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/list.module","start":6050903,"end":6068526,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/list.install","start":6068526,"end":6072347,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/list.info","start":6072347,"end":6072688,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/tests/list.test","start":6072688,"end":6090963,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/tests/list_test.module","start":6090963,"end":6091677,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/list/tests/list_test.info","start":6091677,"end":6091942,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/field_sql_storage/field_sql_storage.info","start":6091942,"end":6092262,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/field_sql_storage/field_sql_storage.install","start":6092262,"end":6099028,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/field_sql_storage/field_sql_storage.module","start":6099028,"end":6128597,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/field_sql_storage/field_sql_storage.test","start":6128597,"end":6155093,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/text/text.module","start":6155093,"end":6176208,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/text/text.js","start":6176208,"end":6177985,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/text/text.test","start":6177985,"end":6196566,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/text/text.info","start":6196566,"end":6196855,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/modules/text/text.install","start":6196855,"end":6198997,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.install","start":6198997,"end":6203319,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.info","start":6203319,"end":6203619,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field.test","start":6203619,"end":6371209,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.field.inc","start":6371209,"end":6383287,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.module","start":6383287,"end":6392676,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.storage.inc","start":6392676,"end":6406998,"audio":0},{"filename":"/preload/drupal-7.59/modules/field/tests/field_test.entity.inc","start":6406998,"end":6421761,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help.css","start":6421761,"end":6421899,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help-rtl.css","start":6421899,"end":6422032,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help.admin.inc","start":6422032,"end":6424579,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help.info","start":6424579,"end":6424832,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help.module","start":6424832,"end":6429122,"audio":0},{"filename":"/preload/drupal-7.59/modules/help/help.test","start":6429122,"end":6433614,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.admin.inc","start":6433614,"end":6461918,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.css","start":6461918,"end":6462035,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.install","start":6462035,"end":6469163,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.api.php","start":6469163,"end":6471742,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.test","start":6471742,"end":6499494,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.module","start":6499494,"end":6527835,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.js","start":6527835,"end":6530330,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.admin.js","start":6530330,"end":6531758,"audio":0},{"filename":"/preload/drupal-7.59/modules/menu/menu.info","start":6531758,"end":6532069,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.info","start":6532069,"end":6532419,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.module","start":6532419,"end":6553026,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.api.php","start":6553026,"end":6555711,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.install","start":6555711,"end":6559314,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.admin.inc","start":6559314,"end":6570062,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/trigger.test","start":6570062,"end":6600694,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/tests/trigger_test.module","start":6600694,"end":6604601,"audio":0},{"filename":"/preload/drupal-7.59/modules/trigger/tests/trigger_test.info","start":6604601,"end":6604843,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/preview.js","start":6604843,"end":6606311,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.test","start":6606311,"end":6610589,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.install","start":6610589,"end":6612868,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.js","start":6612868,"end":6620485,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.info","start":6620485,"end":6620775,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.module","start":6620775,"end":6648362,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color.css","start":6648362,"end":6649809,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/preview.html","start":6649809,"end":6650371,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/color-rtl.css","start":6650371,"end":6651089,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/images/lock.png","start":6651089,"end":6651319,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/images/hook.png","start":6651319,"end":6651435,"audio":0},{"filename":"/preload/drupal-7.59/modules/color/images/hook-rtl.png","start":6651435,"end":6651551,"audio":0},{"filename":"/preload/drupal-7.59/modules/blog/blog.install","start":6651551,"end":6651955,"audio":0},{"filename":"/preload/drupal-7.59/modules/blog/blog.test","start":6651955,"end":6660441,"audio":0},{"filename":"/preload/drupal-7.59/modules/blog/blog.module","start":6660441,"end":6669550,"audio":0},{"filename":"/preload/drupal-7.59/modules/blog/blog.pages.inc","start":6669550,"end":6673044,"audio":0},{"filename":"/preload/drupal-7.59/modules/blog/blog.info","start":6673044,"end":6673287,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.test","start":6673287,"end":6693463,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.admin.inc","start":6693463,"end":6703412,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.api.php","start":6703412,"end":6704896,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.module","start":6704896,"end":6716918,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.info","start":6716918,"end":6717201,"audio":0},{"filename":"/preload/drupal-7.59/modules/path/path.js","start":6717201,"end":6717621,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual-rtl.css","start":6717621,"end":6718029,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.api.php","start":6718029,"end":6719088,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.test","start":6719088,"end":6721014,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.info","start":6721014,"end":6721325,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.js","start":6721325,"end":6723129,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.css","start":6723129,"end":6725469,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/contextual.module","start":6725469,"end":6731156,"audio":0},{"filename":"/preload/drupal-7.59/modules/contextual/images/gear-select.png","start":6731156,"end":6731662,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.info","start":6731662,"end":6732046,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.install","start":6732046,"end":6746961,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.admin.inc","start":6746961,"end":6800140,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.datepicker.js","start":6800140,"end":6802250,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale-rtl.css","start":6802250,"end":6802561,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.api.php","start":6802561,"end":6803470,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.test","start":6803470,"end":6932373,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.module","start":6932373,"end":6978620,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/locale.css","start":6978620,"end":6979495,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/tests/locale_test.info","start":6979495,"end":6979763,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/tests/locale_test.module","start":6979763,"end":6985308,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/tests/locale_test.js","start":6985308,"end":6987037,"audio":0},{"filename":"/preload/drupal-7.59/modules/locale/tests/translations/test.xx.po","start":6987037,"end":6987477,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.api.php","start":6987477,"end":6988716,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.install","start":6988716,"end":6991769,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.admin.inc","start":6991769,"end":7018651,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.admin.css","start":7018651,"end":7018755,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.admin.js","start":7018755,"end":7023240,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.png","start":7023240,"end":7023798,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.module","start":7023798,"end":7050997,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.css","start":7050997,"end":7053405,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut-rtl.css","start":7053405,"end":7054472,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.test","start":7054472,"end":7068134,"audio":0},{"filename":"/preload/drupal-7.59/modules/shortcut/shortcut.info","start":7068134,"end":7068469,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.js","start":7068469,"end":7071489,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.tpl.php","start":7071489,"end":7072829,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.png","start":7072829,"end":7073387,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.module","start":7073387,"end":7084345,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.css","start":7084345,"end":7087721,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar-rtl.css","start":7087721,"end":7088282,"audio":0},{"filename":"/preload/drupal-7.59/modules/toolbar/toolbar.info","start":7088282,"end":7088582,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-rtl.css","start":7088582,"end":7088706,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-feed-source.tpl.php","start":7088706,"end":7089811,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.css","start":7089811,"end":7090590,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.install","start":7090590,"end":7100458,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-wrapper.tpl.php","start":7100458,"end":7100855,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.module","start":7100855,"end":7129823,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.fetcher.inc","start":7129823,"end":7131519,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.parser.inc","start":7131519,"end":7141077,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.processor.inc","start":7141077,"end":7149145,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.info","start":7149145,"end":7149524,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-summary-item.tpl.php","start":7149524,"end":7150239,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-item.tpl.php","start":7150239,"end":7151535,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator-summary-items.tpl.php","start":7151535,"end":7152187,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.test","start":7152187,"end":7193112,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.api.php","start":7193112,"end":7200491,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.admin.inc","start":7200491,"end":7224911,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/aggregator.pages.inc","start":7224911,"end":7244781,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/tests/aggregator_test_title_entities.xml","start":7244781,"end":7245222,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/tests/aggregator_test_atom.xml","start":7245222,"end":7245794,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/tests/aggregator_test.info","start":7245794,"end":7246078,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/tests/aggregator_test_rss091.xml","start":7246078,"end":7248671,"audio":0},{"filename":"/preload/drupal-7.59/modules/aggregator/tests/aggregator_test.module","start":7248671,"end":7250753,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.info","start":7250753,"end":7251114,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.test","start":7251114,"end":7334149,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.pages.inc","start":7334149,"end":7339893,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search-rtl.css","start":7339893,"end":7340114,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.api.php","start":7340114,"end":7353290,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.admin.inc","start":7353290,"end":7361376,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search-result.tpl.php","start":7361376,"end":7364693,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.css","start":7364693,"end":7365257,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.module","start":7365257,"end":7416453,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search-results.tpl.php","start":7416453,"end":7417504,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.install","start":7417504,"end":7422871,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search-block-form.tpl.php","start":7422871,"end":7424043,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/search.extender.inc","start":7424043,"end":7441593,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_extra_type.info","start":7441593,"end":7441865,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/UnicodeTest.txt","start":7441865,"end":7487110,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_embedded_form.info","start":7487110,"end":7487404,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_node_tags.info","start":7487404,"end":7487684,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_embedded_form.module","start":7487684,"end":7489631,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_node_tags.module","start":7489631,"end":7490148,"audio":0},{"filename":"/preload/drupal-7.59/modules/search/tests/search_extra_type.module","start":7490148,"end":7491820,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.install","start":7491820,"end":7497981,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.pages.inc","start":7497981,"end":7503518,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.css","start":7503518,"end":7503609,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.module","start":7503609,"end":7516553,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.test","start":7516553,"end":7528156,"audio":0},{"filename":"/preload/drupal-7.59/modules/tracker/tracker.info","start":7528156,"end":7528450,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.install","start":7528450,"end":7532370,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.js","start":7532370,"end":7538545,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.info","start":7538545,"end":7538818,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.css","start":7538818,"end":7539390,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.api.php","start":7539390,"end":7541330,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.module","start":7541330,"end":7584002,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/file.field.inc","start":7584002,"end":7619861,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/image-x-generic.png","start":7619861,"end":7620246,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/package-x-generic.png","start":7620246,"end":7620506,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/x-office-spreadsheet.png","start":7620506,"end":7620689,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/text-x-script.png","start":7620689,"end":7620965,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/application-pdf.png","start":7620965,"end":7621311,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/video-x-generic.png","start":7621311,"end":7621525,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/audio-x-generic.png","start":7621525,"end":7621839,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/application-octet-stream.png","start":7621839,"end":7622028,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/x-office-document.png","start":7622028,"end":7622224,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/text-x-generic.png","start":7622224,"end":7622444,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/text-html.png","start":7622444,"end":7622709,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/text-plain.png","start":7622709,"end":7622929,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/application-x-executable.png","start":7622929,"end":7623118,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/icons/x-office-presentation.png","start":7623118,"end":7623299,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/tests/file.test","start":7623299,"end":7707208,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/tests/file_module_test.module","start":7707208,"end":7709435,"audio":0},{"filename":"/preload/drupal-7.59/modules/file/tests/file_module_test.info","start":7709435,"end":7709705,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.css","start":7709705,"end":7710448,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.js","start":7710448,"end":7716673,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.test","start":7716673,"end":7755868,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.install","start":7755868,"end":7773078,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.module","start":7773078,"end":7812953,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.tpl.php","start":7812953,"end":7815410,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block-admin-display-form.tpl.php","start":7815410,"end":7818087,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.api.php","start":7818087,"end":7833757,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.info","start":7833757,"end":7834151,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/block.admin.inc","start":7834151,"end":7858802,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/tests/block_test.info","start":7858802,"end":7859044,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/tests/block_test.module","start":7859044,"end":7860582,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/tests/themes/block_test_theme/block_test_theme.info","start":7860582,"end":7861088,"audio":0},{"filename":"/preload/drupal-7.59/modules/block/tests/themes/block_test_theme/page.tpl.php","start":7861088,"end":7864530,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/translation.pages.inc","start":7864530,"end":7867808,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/translation.info","start":7867808,"end":7868129,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/translation.test","start":7868129,"end":7890216,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/translation.module","start":7890216,"end":7913620,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/tests/translation_test.module","start":7913620,"end":7913827,"audio":0},{"filename":"/preload/drupal-7.59/modules/translation/tests/translation_test.info","start":7913827,"end":7914115,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.js","start":7914115,"end":7915885,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.tokens.inc","start":7915885,"end":7921913,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.css","start":7921913,"end":7922145,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.pages.inc","start":7922145,"end":7928858,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy-term.tpl.php","start":7928858,"end":7931002,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.api.php","start":7931002,"end":7937054,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.admin.inc","start":7937054,"end":7973632,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.test","start":7973632,"end":8056999,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.install","start":8056999,"end":8087892,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.info","start":8087892,"end":8088244,"audio":0},{"filename":"/preload/drupal-7.59/modules/taxonomy/taxonomy.module","start":8088244,"end":8159982,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.test","start":8159982,"end":8179109,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.pages.inc","start":8179109,"end":8182369,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.php","start":8182369,"end":8183341,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.install","start":8183341,"end":8187625,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.js","start":8187625,"end":8187840,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.info","start":8187840,"end":8188150,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.admin.inc","start":8188150,"end":8200279,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.module","start":8200279,"end":8219426,"audio":0},{"filename":"/preload/drupal-7.59/modules/statistics/statistics.tokens.inc","start":8219426,"end":8221209,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.install","start":8221209,"end":8227289,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-results--block.tpl.php","start":8227289,"end":8228111,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-rtl.css","start":8228111,"end":8228245,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-bar--block.tpl.php","start":8228245,"end":8228954,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-vote.tpl.php","start":8228954,"end":8229751,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.tokens.inc","start":8229751,"end":8232648,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.pages.inc","start":8232648,"end":8235775,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.css","start":8235775,"end":8236584,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-bar.tpl.php","start":8236584,"end":8237359,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.test","start":8237359,"end":8271621,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.module","start":8271621,"end":8302353,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll-results.tpl.php","start":8302353,"end":8303142,"audio":0},{"filename":"/preload/drupal-7.59/modules/poll/poll.info","start":8303142,"end":8303485,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.admin.inc","start":8303485,"end":8313090,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book-node-export-html.tpl.php","start":8313090,"end":8313776,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book-export-html.tpl.php","start":8313776,"end":8315678,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.install","start":8315678,"end":8318016,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.info","start":8318016,"end":8318370,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.module","start":8318370,"end":8366313,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book-all-books-block.tpl.php","start":8366313,"end":8366999,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book-rtl.css","start":8366999,"end":8367213,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book-navigation.tpl.php","start":8367213,"end":8369300,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.js","start":8369300,"end":8369889,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.test","start":8369889,"end":8385366,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.pages.inc","start":8385366,"end":8392722,"audio":0},{"filename":"/preload/drupal-7.59/modules/book/book.css","start":8392722,"end":8393758,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.test","start":8393758,"end":8475693,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.admin.css","start":8475693,"end":8476809,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.css","start":8476809,"end":8477034,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.admin.inc","start":8477034,"end":8510475,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image-rtl.css","start":8510475,"end":8510614,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.install","start":8510614,"end":8525752,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.module","start":8525752,"end":8573996,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.field.inc","start":8573996,"end":8595064,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.effects.inc","start":8595064,"end":8607398,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.api.php","start":8607398,"end":8614612,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/sample.png","start":8614612,"end":8782722,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/image.info","start":8782722,"end":8783042,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/tests/image_module_test.info","start":8783042,"end":8783364,"audio":0},{"filename":"/preload/drupal-7.59/modules/image/tests/image_module_test.module","start":8783364,"end":8784592,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.base-rtl.css","start":8784592,"end":8785465,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/theme.api.php","start":8785465,"end":8794456,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.info","start":8794456,"end":8794917,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.messages.css","start":8794917,"end":8795878,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.theme.css","start":8795878,"end":8799589,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.api.php","start":8799589,"end":9003196,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.menus.css","start":9003196,"end":9005231,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.tar.inc","start":9005231,"end":9090004,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.js","start":9090004,"end":9094701,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.menus-rtl.css","start":9094701,"end":9095252,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/image.gd.inc","start":9095252,"end":9109367,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/maintenance-page.tpl.php","start":9109367,"end":9112385,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.messages-rtl.css","start":9112385,"end":9112561,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.admin-rtl.css","start":9112561,"end":9114035,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.module","start":9114035,"end":9257356,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/form.api.php","start":9257356,"end":9262495,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.tokens.inc","start":9262495,"end":9270632,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.mail.inc","start":9270632,"end":9275277,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/region.tpl.php","start":9275277,"end":9276583,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.admin.inc","start":9276583,"end":9393231,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/page.tpl.php","start":9393231,"end":9400166,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/language.api.php","start":9400166,"end":9406730,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.archiver.inc","start":9406730,"end":9409825,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.test","start":9409825,"end":9531541,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.queue.inc","start":9531541,"end":9544192,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.install","start":9544192,"end":9665632,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.maintenance.css","start":9665632,"end":9666443,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.admin.css","start":9666443,"end":9671560,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.theme-rtl.css","start":9671560,"end":9672371,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.updater.inc","start":9672371,"end":9677128,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/html.tpl.php","start":9677128,"end":9679861,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.cron.js","start":9679861,"end":9680350,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/system.base.css","start":9680350,"end":9685778,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/tests/system_cron_test.module","start":9685778,"end":9686086,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/tests/cron_queue_test.module","start":9686086,"end":9686634,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/tests/system_cron_test.info","start":9686634,"end":9686908,"audio":0},{"filename":"/preload/drupal-7.59/modules/system/tests/cron_queue_test.info","start":9686908,"end":9687177,"audio":0},{"filename":"/preload/drupal-7.59/modules/syslog/syslog.install","start":9687177,"end":9687443,"audio":0},{"filename":"/preload/drupal-7.59/modules/syslog/syslog.test","start":9687443,"end":9688654,"audio":0},{"filename":"/preload/drupal-7.59/modules/syslog/syslog.info","start":9688654,"end":9688962,"audio":0},{"filename":"/preload/drupal-7.59/modules/syslog/syslog.module","start":9688962,"end":9694974,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.js","start":9694974,"end":9695530,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.admin.inc","start":9695530,"end":9710291,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.info","start":9710291,"end":9710613,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.api.php","start":9710613,"end":9722426,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.module","start":9722426,"end":9790459,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.css","start":9790459,"end":9791382,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.test","start":9791382,"end":9881414,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.admin.js","start":9881414,"end":9882994,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.pages.inc","start":9882994,"end":9885417,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/filter.install","start":9885417,"end":9901224,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/tests/filter.url-input.txt","start":9901224,"end":9903407,"audio":0},{"filename":"/preload/drupal-7.59/modules/filter/tests/filter.url-output.txt","start":9903407,"end":9907045,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment-node-form.js","start":9907045,"end":9908095,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.install","start":9908095,"end":9926374,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment-wrapper.tpl.php","start":9926374,"end":9928400,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.module","start":9928400,"end":10021696,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.tokens.inc","start":10021696,"end":10029547,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.info","start":10029547,"end":10029942,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.admin.inc","start":10029942,"end":10039269,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.api.php","start":10039269,"end":10043162,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.css","start":10043162,"end":10043346,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.tpl.php","start":10043346,"end":10046995,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment-rtl.css","start":10046995,"end":10047050,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.test","start":10047050,"end":10143495,"audio":0},{"filename":"/preload/drupal-7.59/modules/comment/comment.pages.inc","start":10143495,"end":10148090,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.test","start":10148090,"end":10154473,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.js","start":10154473,"end":10161569,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.css","start":10161569,"end":10164004,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.module","start":10164004,"end":10190788,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.info","start":10190788,"end":10191213,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.install","start":10191213,"end":10193162,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard-rtl.css","start":10193162,"end":10193881,"audio":0},{"filename":"/preload/drupal-7.59/modules/dashboard/dashboard.api.php","start":10193881,"end":10194942,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.js","start":10194942,"end":10197639,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile-wrapper.tpl.php","start":10197639,"end":10198458,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.test","start":10198458,"end":10217856,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.info","start":10217856,"end":10218429,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile-block.tpl.php","start":10218429,"end":10219794,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.admin.inc","start":10219794,"end":10237918,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile-listing.tpl.php","start":10237918,"end":10239564,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.css","start":10239564,"end":10239732,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.pages.inc","start":10239732,"end":10244247,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.module","start":10244247,"end":10267297,"audio":0},{"filename":"/preload/drupal-7.59/modules/profile/profile.install","start":10267297,"end":10272172,"audio":0},{"filename":"/preload/drupal-7.59/modules/php/php.test","start":10272172,"end":10276739,"audio":0},{"filename":"/preload/drupal-7.59/modules/php/php.module","start":10276739,"end":10284400,"audio":0},{"filename":"/preload/drupal-7.59/modules/php/php.info","start":10284400,"end":10284673,"audio":0},{"filename":"/preload/drupal-7.59/modules/php/php.install","start":10284673,"end":10286289,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.pages.inc","start":10286289,"end":10296124,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.module","start":10296124,"end":10307769,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.admin.inc","start":10307769,"end":10315167,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.info","start":10315167,"end":10315488,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.test","start":10315488,"end":10336171,"audio":0},{"filename":"/preload/drupal-7.59/modules/contact/contact.install","start":10336171,"end":10340324,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.module","start":10340324,"end":10389220,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.pages.inc","start":10389220,"end":10390258,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum-rtl.css","start":10390258,"end":10390656,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum-topic-list.tpl.php","start":10390656,"end":10393153,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.install","start":10393153,"end":10406740,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.info","start":10406740,"end":10407103,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum-submitted.tpl.php","start":10407103,"end":10407814,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.admin.inc","start":10407814,"end":10419818,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forums.tpl.php","start":10419818,"end":10420368,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.test","start":10420368,"end":10445952,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum-list.tpl.php","start":10445952,"end":10449295,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum-icon.tpl.php","start":10449295,"end":10449986,"audio":0},{"filename":"/preload/drupal-7.59/modules/forum/forum.css","start":10449986,"end":10451042,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.module","start":10451042,"end":10590505,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.tokens.inc","start":10590505,"end":10597258,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.tpl.php","start":10597258,"end":10602218,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.css","start":10602218,"end":10602362,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.test","start":10602362,"end":10720864,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.admin.inc","start":10720864,"end":10744689,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.api.php","start":10744689,"end":10794292,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.pages.inc","start":10794292,"end":10818843,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/content_types.inc","start":10818843,"end":10834425,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.install","start":10834425,"end":10865693,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/content_types.js","start":10865693,"end":10866898,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.info","start":10866898,"end":10867284,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/node.js","start":10867284,"end":10868887,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_test.info","start":10868887,"end":10869159,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_test_exception.info","start":10869159,"end":10869451,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_access_test.module","start":10869451,"end":10875767,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_access_test.info","start":10875767,"end":10876049,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_test.module","start":10876049,"end":10881137,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_access_test.install","start":10881137,"end":10882166,"audio":0},{"filename":"/preload/drupal-7.59/modules/node/tests/node_test_exception.module","start":10882166,"end":10882472,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.install","start":10882472,"end":10912472,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.js","start":10912472,"end":10919072,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user-profile-item.tpl.php","start":10919072,"end":10919990,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.permissions.js","start":10919990,"end":10922713,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.pages.inc","start":10922713,"end":10946078,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.css","start":10946078,"end":10947905,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.api.php","start":10947905,"end":10963603,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.info","start":10963603,"end":10963968,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user-rtl.css","start":10963968,"end":10964478,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user-picture.tpl.php","start":10964478,"end":10965085,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.tokens.inc","start":10965085,"end":10969178,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user-profile-category.tpl.php","start":10969178,"end":10970179,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.admin.inc","start":10970179,"end":11009623,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.test","start":11009623,"end":11121277,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user-profile.tpl.php","start":11121277,"end":11122966,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/user.module","start":11122966,"end":11267535,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/tests/user_form_test.info","start":11267535,"end":11267809,"audio":0},{"filename":"/preload/drupal-7.59/modules/user/tests/user_form_test.module","start":11267809,"end":11270117,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.test","start":11270117,"end":11307616,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.inc","start":11307616,"end":11334448,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.install","start":11334448,"end":11341409,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.js","start":11341409,"end":11343238,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.api.php","start":11343238,"end":11346575,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/login-bg.png","start":11346575,"end":11346780,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.module","start":11346780,"end":11388080,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid-rtl.css","start":11388080,"end":11388460,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.info","start":11388460,"end":11388732,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.pages.inc","start":11388732,"end":11392513,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/openid.css","start":11392513,"end":11393553,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/tests/openid_test.module","start":11393553,"end":11408106,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/tests/openid_test.install","start":11408106,"end":11408549,"audio":0},{"filename":"/preload/drupal-7.59/modules/openid/tests/openid_test.info","start":11408549,"end":11408840,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.admin.inc","start":11408840,"end":11420925,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog-rtl.css","start":11420925,"end":11421100,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.test","start":11421100,"end":11449305,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.module","start":11449305,"end":11456655,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.info","start":11456655,"end":11456933,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.install","start":11456933,"end":11461323,"audio":0},{"filename":"/preload/drupal-7.59/modules/dblog/dblog.css","start":11461323,"end":11462721,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.install","start":11462721,"end":11469094,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update-rtl.css","start":11469094,"end":11469611,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.fetch.inc","start":11469611,"end":11484663,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.report.inc","start":11484663,"end":11497149,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.manager.inc","start":11497149,"end":11531811,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.test","start":11531811,"end":11566733,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.info","start":11566733,"end":11567110,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.module","start":11567110,"end":11605917,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.authorize.inc","start":11605917,"end":11618113,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.settings.inc","start":11618113,"end":11622937,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.compare.inc","start":11622937,"end":11658397,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.api.php","start":11658397,"end":11663555,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/update.css","start":11663555,"end":11665583,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/aaa_update_test.no-releases.xml","start":11665583,"end":11665711,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/drupal.0.xml","start":11665711,"end":11666850,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/aaa_update_test.info","start":11666850,"end":11667099,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/aaa_update_test.module","start":11667099,"end":11667166,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/update_test_basetheme.1_1-sec.xml","start":11667166,"end":11669147,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/update_test.info","start":11669147,"end":11669410,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/update_test.module","start":11669410,"end":11675653,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/bbb_update_test.module","start":11675653,"end":11675720,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/drupal.2-sec.xml","start":11675720,"end":11678139,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/drupal.dev.xml","start":11678139,"end":11679829,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/ccc_update_test.1_0.xml","start":11679829,"end":11681034,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/aaa_update_test.tar.gz","start":11681034,"end":11681417,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/aaa_update_test.1_0.xml","start":11681417,"end":11682622,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/ccc_update_test.module","start":11682622,"end":11682689,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/bbb_update_test.info","start":11682689,"end":11682938,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/drupal.1.xml","start":11682938,"end":11684681,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/update_test_subtheme.1_0.xml","start":11684681,"end":11685915,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/ccc_update_test.info","start":11685915,"end":11686164,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/bbb_update_test.1_0.xml","start":11686164,"end":11687369,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/themes/update_test_admintheme/update_test_admintheme.info","start":11687369,"end":11687607,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/themes/update_test_basetheme/update_test_basetheme.info","start":11687607,"end":11687867,"audio":0},{"filename":"/preload/drupal-7.59/modules/update/tests/themes/update_test_subtheme/update_test_subtheme.info","start":11687867,"end":11688159,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.admin.inc","start":11688159,"end":11767611,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.module","start":11767611,"end":11789210,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui-rtl.css","start":11789210,"end":11789389,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.js","start":11789389,"end":11801193,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.info","start":11801193,"end":11801475,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.api.php","start":11801475,"end":11807580,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.test","start":11807580,"end":11838981,"audio":0},{"filename":"/preload/drupal-7.59/modules/field_ui/field_ui.css","start":11838981,"end":11840745,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/rdf.info","start":11840745,"end":11841109,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/rdf.api.php","start":11841109,"end":11844745,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/rdf.module","start":11844745,"end":11879085,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/rdf.install","start":11879085,"end":11880377,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/rdf.test","start":11880377,"end":11915963,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/tests/rdf_test.info","start":11915963,"end":11916254,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/tests/rdf_test.install","start":11916254,"end":11916726,"audio":0},{"filename":"/preload/drupal-7.59/modules/rdf/tests/rdf_test.module","start":11916726,"end":11918317,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay-child.css","start":11918317,"end":11921668,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay.install","start":11921668,"end":11922148,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay-parent.css","start":11922148,"end":11923270,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay.info","start":11923270,"end":11923530,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay-child.js","start":11923530,"end":11930226,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay.tpl.php","start":11930226,"end":11931594,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay-child-rtl.css","start":11931594,"end":11932165,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay-parent.js","start":11932165,"end":11970589,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay.module","start":11970589,"end":12007058,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/overlay.api.php","start":12007058,"end":12008115,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/images/background.png","start":12008115,"end":12008191,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/images/close.png","start":12008191,"end":12008535,"audio":0},{"filename":"/preload/drupal-7.59/modules/overlay/images/close-rtl.png","start":12008535,"end":12008903,"audio":0},{"filename":"/preload/drupal-7.59/misc/ajax.js","start":12008903,"end":12033938,"audio":0},{"filename":"/preload/drupal-7.59/misc/timezone.js","start":12033938,"end":12036496,"audio":0},{"filename":"/preload/drupal-7.59/misc/form.js","start":12036496,"end":12038956,"audio":0},{"filename":"/preload/drupal-7.59/misc/druplicon.png","start":12038956,"end":12042861,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-black-135x42.png","start":12042861,"end":12045560,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-24-ok.png","start":12045560,"end":12046618,"audio":0},{"filename":"/preload/drupal-7.59/misc/tableheader.js","start":12046618,"end":12051948,"audio":0},{"filename":"/preload/drupal-7.59/misc/grippie.png","start":12051948,"end":12052054,"audio":0},{"filename":"/preload/drupal-7.59/misc/tableselect.js","start":12052054,"end":12055987,"audio":0},{"filename":"/preload/drupal-7.59/misc/watchdog-warning.png","start":12055987,"end":12056305,"audio":0},{"filename":"/preload/drupal-7.59/misc/arrow-asc.png","start":12056305,"end":12056423,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-blue-135x42.png","start":12056423,"end":12059302,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-16-ok.png","start":12059302,"end":12059941,"audio":0},{"filename":"/preload/drupal-7.59/misc/permissions.png","start":12059941,"end":12060183,"audio":0},{"filename":"/preload/drupal-7.59/misc/menu-expanded.png","start":12060183,"end":12060289,"audio":0},{"filename":"/preload/drupal-7.59/misc/print.css","start":12060289,"end":12060580,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-24-error.png","start":12060580,"end":12061313,"audio":0},{"filename":"/preload/drupal-7.59/misc/vertical-tabs.js","start":12061313,"end":12067644,"audio":0},{"filename":"/preload/drupal-7.59/misc/jquery.once.js","start":12067644,"end":12070618,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-black-80x15.png","start":12070618,"end":12072066,"audio":0},{"filename":"/preload/drupal-7.59/misc/menu-collapsed-rtl.png","start":12072066,"end":12072173,"audio":0},{"filename":"/preload/drupal-7.59/misc/drupal.js","start":12072173,"end":12092392,"audio":0},{"filename":"/preload/drupal-7.59/misc/textarea.js","start":12092392,"end":12093312,"audio":0},{"filename":"/preload/drupal-7.59/misc/watchdog-error.png","start":12093312,"end":12094092,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-16-warning.png","start":12094092,"end":12094534,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-gray-135x42.png","start":12094534,"end":12097128,"audio":0},{"filename":"/preload/drupal-7.59/misc/watchdog-ok.png","start":12097128,"end":12097503,"audio":0},{"filename":"/preload/drupal-7.59/misc/configure.png","start":12097503,"end":12097751,"audio":0},{"filename":"/preload/drupal-7.59/misc/throbber.gif","start":12097751,"end":12099087,"audio":0},{"filename":"/preload/drupal-7.59/misc/throbber-inactive.png","start":12099087,"end":12099407,"audio":0},{"filename":"/preload/drupal-7.59/misc/menu-leaf.png","start":12099407,"end":12099533,"audio":0},{"filename":"/preload/drupal-7.59/misc/feed.png","start":12099533,"end":12100189,"audio":0},{"filename":"/preload/drupal-7.59/misc/vertical-tabs.css","start":12100189,"end":12102246,"audio":0},{"filename":"/preload/drupal-7.59/misc/jquery.cookie.js","start":12102246,"end":12103207,"audio":0},{"filename":"/preload/drupal-7.59/misc/favicon.ico","start":12103207,"end":12108637,"audio":0},{"filename":"/preload/drupal-7.59/misc/jquery.form.js","start":12108637,"end":12118550,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-24-info.png","start":12118550,"end":12119561,"audio":0},{"filename":"/preload/drupal-7.59/misc/draggable.png","start":12119561,"end":12119829,"audio":0},{"filename":"/preload/drupal-7.59/misc/jquery.js","start":12119829,"end":12198431,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-blue-88x31.png","start":12198431,"end":12200440,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-24-warning.png","start":12200440,"end":12201193,"audio":0},{"filename":"/preload/drupal-7.59/misc/menu-collapsed.png","start":12201193,"end":12201298,"audio":0},{"filename":"/preload/drupal-7.59/misc/tabledrag.js","start":12201298,"end":12244081,"audio":0},{"filename":"/preload/drupal-7.59/misc/collapse.js","start":12244081,"end":12247404,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-gray-88x31.png","start":12247404,"end":12249372,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-blue-80x15.png","start":12249372,"end":12250315,"audio":0},{"filename":"/preload/drupal-7.59/misc/progress.gif","start":12250315,"end":12256187,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-16-help.png","start":12256187,"end":12256855,"audio":0},{"filename":"/preload/drupal-7.59/misc/progress.js","start":12256855,"end":12259967,"audio":0},{"filename":"/preload/drupal-7.59/misc/vertical-tabs-rtl.css","start":12259967,"end":12260232,"audio":0},{"filename":"/preload/drupal-7.59/misc/help.png","start":12260232,"end":12260526,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-16-error.png","start":12260526,"end":12261045,"audio":0},{"filename":"/preload/drupal-7.59/misc/tree.png","start":12261045,"end":12261175,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-black-88x31.png","start":12261175,"end":12263180,"audio":0},{"filename":"/preload/drupal-7.59/misc/authorize.js","start":12263180,"end":12264148,"audio":0},{"filename":"/preload/drupal-7.59/misc/forum-icons.png","start":12264148,"end":12265913,"audio":0},{"filename":"/preload/drupal-7.59/misc/tree-bottom.png","start":12265913,"end":12266042,"audio":0},{"filename":"/preload/drupal-7.59/misc/batch.js","start":12266042,"end":12266981,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-16-info.png","start":12266981,"end":12267714,"audio":0},{"filename":"/preload/drupal-7.59/misc/arrow-desc.png","start":12267714,"end":12267832,"audio":0},{"filename":"/preload/drupal-7.59/misc/jquery.ba-bbq.js","start":12267832,"end":12271951,"audio":0},{"filename":"/preload/drupal-7.59/misc/message-24-help.png","start":12271951,"end":12273039,"audio":0},{"filename":"/preload/drupal-7.59/misc/print-rtl.css","start":12273039,"end":12273095,"audio":0},{"filename":"/preload/drupal-7.59/misc/states.js","start":12273095,"end":12290599,"audio":0},{"filename":"/preload/drupal-7.59/misc/powered-gray-80x15.png","start":12290599,"end":12291297,"audio":0},{"filename":"/preload/drupal-7.59/misc/autocomplete.js","start":12291297,"end":12299723,"audio":0},{"filename":"/preload/drupal-7.59/misc/throbber-active.gif","start":12299723,"end":12300956,"audio":0},{"filename":"/preload/drupal-7.59/misc/machine-name.js","start":12300956,"end":12306070,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.tabs.css","start":12306070,"end":12307453,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.selectable.css","start":12307453,"end":12307776,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.draggable.min.js","start":12307776,"end":12326328,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.blind.min.js","start":12326328,"end":12327199,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.selectable.min.js","start":12327199,"end":12331504,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.autocomplete.css","start":12331504,"end":12332611,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.scale.min.js","start":12332611,"end":12336535,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.core.min.js","start":12336535,"end":12340860,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.tabs.min.js","start":12340860,"end":12352488,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.slide.min.js","start":12352488,"end":12353550,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.button.css","start":12353550,"end":12356021,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.resizable.min.js","start":12356021,"end":12373387,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.clip.min.js","start":12373387,"end":12374449,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.slider.css","start":12374449,"end":12375590,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.fold.min.js","start":12375590,"end":12376719,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.core.css","start":12376719,"end":12378178,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.datepicker.css","start":12378178,"end":12382225,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.dialog.min.js","start":12382225,"end":12393746,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.highlight.min.js","start":12393746,"end":12394660,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.sortable.min.js","start":12394660,"end":12418350,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.dialog.css","start":12418350,"end":12419713,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.shake.min.js","start":12419713,"end":12420846,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.explode.min.js","start":12420846,"end":12422490,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.theme.css","start":12422490,"end":12441633,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.accordion.css","start":12441633,"end":12442699,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.transfer.min.js","start":12442699,"end":12443515,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.pulsate.min.js","start":12443515,"end":12444466,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.mouse.min.js","start":12444466,"end":12447199,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.autocomplete.min.js","start":12447199,"end":12455952,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.drop.min.js","start":12455952,"end":12457023,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.button.min.js","start":12457023,"end":12463687,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.datepicker.min.js","start":12463687,"end":12499314,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.accordion.min.js","start":12499314,"end":12508312,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.slider.min.js","start":12508312,"end":12518634,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.progressbar.css","start":12518634,"end":12518992,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.widget.min.js","start":12518992,"end":12522266,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.droppable.min.js","start":12522266,"end":12528036,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.fade.min.js","start":12528036,"end":12528613,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.core.min.js","start":12528613,"end":12539442,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.position.min.js","start":12539442,"end":12543055,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.effects.bounce.min.js","start":12543055,"end":12544727,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.progressbar.min.js","start":12544727,"end":12546548,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/jquery.ui.resizable.css","start":12546548,"end":12547720,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_highlight-soft_75_cccccc_1x100.png","start":12547720,"end":12547821,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_flat_0_aaaaaa_40x100.png","start":12547821,"end":12548001,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_glass_75_dadada_1x400.png","start":12548001,"end":12548112,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_flat_75_ffffff_40x100.png","start":12548112,"end":12548290,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_glass_65_ffffff_1x400.png","start":12548290,"end":12548395,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-icons_2e83ff_256x240.png","start":12548395,"end":12552764,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_glass_95_fef1ec_1x400.png","start":12552764,"end":12552883,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-icons_cd0a0a_256x240.png","start":12552883,"end":12557252,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_glass_55_fbf9ee_1x400.png","start":12557252,"end":12557372,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-bg_glass_75_e6e6e6_1x400.png","start":12557372,"end":12557482,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-icons_454545_256x240.png","start":12557482,"end":12561851,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-icons_222222_256x240.png","start":12561851,"end":12566220,"audio":0},{"filename":"/preload/drupal-7.59/misc/ui/images/ui-icons_888888_256x240.png","start":12566220,"end":12570589,"audio":0},{"filename":"/preload/drupal-7.59/misc/farbtastic/mask.png","start":12570589,"end":12572590,"audio":0},{"filename":"/preload/drupal-7.59/misc/farbtastic/farbtastic.css","start":12572590,"end":12573166,"audio":0},{"filename":"/preload/drupal-7.59/misc/farbtastic/wheel.png","start":12573166,"end":12584755,"audio":0},{"filename":"/preload/drupal-7.59/misc/farbtastic/marker.png","start":12584755,"end":12585192,"audio":0},{"filename":"/preload/drupal-7.59/misc/farbtastic/farbtastic.js","start":12585192,"end":12589260,"audio":0},{"filename":"/preload/drupal-7.59/sites/README.txt","start":12589260,"end":12590164,"audio":0},{"filename":"/preload/drupal-7.59/sites/example.sites.php","start":12590164,"end":12592529,"audio":0},{"filename":"/preload/drupal-7.59/sites/all/libraries/README.txt","start":12592529,"end":12592680,"audio":0},{"filename":"/preload/drupal-7.59/sites/all/themes/README.txt","start":12592680,"end":12593700,"audio":0},{"filename":"/preload/drupal-7.59/sites/all/modules/README.txt","start":12593700,"end":12595174,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/logo.png","start":12595174,"end":12609477,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/settings.php","start":12609477,"end":12635932,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/default.settings.php","start":12635932,"end":12662182,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/2.4mb-.ht.sqlite","start":12662182,"end":15213990,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/.ht.sqlite","start":15213990,"end":17765798,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/.htaccess","start":17765798,"end":17766274,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/3.4mb-.ht.sqlite","start":17766274,"end":21280642,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/styles/.gitignore","start":21280642,"end":21280642,"audio":0},{"filename":"/preload/drupal-7.59/sites/default/files/tmp/.gitignore","start":21280642,"end":21280642,"audio":0},{"filename":"/preload/drupal-7.59/profiles/README.txt","start":21280642,"end":21281683,"audio":0},{"filename":"/preload/drupal-7.59/profiles/standard/standard.install","start":21281683,"end":21293517,"audio":0},{"filename":"/preload/drupal-7.59/profiles/standard/standard.profile","start":21293517,"end":21293975,"audio":0},{"filename":"/preload/drupal-7.59/profiles/standard/standard.info","start":21293975,"end":21294717,"audio":0},{"filename":"/preload/drupal-7.59/profiles/standard/translations/README.txt","start":21294717,"end":21294809,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/testing.profile","start":21294809,"end":21294868,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/testing.install","start":21294868,"end":21295479,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/testing.info","start":21295479,"end":21295756,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/modules/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module","start":21295756,"end":21295762,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/modules/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.info","start":21295762,"end":21296258,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/modules/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.test","start":21296258,"end":21297349,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/modules/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module","start":21297349,"end":21297355,"audio":0},{"filename":"/preload/drupal-7.59/profiles/testing/modules/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.info","start":21297355,"end":21297722,"audio":0},{"filename":"/preload/drupal-7.59/profiles/minimal/minimal.info","start":21297722,"end":21297992,"audio":0},{"filename":"/preload/drupal-7.59/profiles/minimal/minimal.profile","start":21297992,"end":21298448,"audio":0},{"filename":"/preload/drupal-7.59/profiles/minimal/minimal.install","start":21298448,"end":21300512,"audio":0},{"filename":"/preload/drupal-7.59/profiles/minimal/translations/README.txt","start":21300512,"end":21300604,"audio":0},{"filename":"/preload/Zend/bench.php","start":21300604,"end":21308238,"audio":0}],"remote_package_size":21308238,"package_uuid":"810f12dc-218a-40e5-b332-094cc42aac8b"})})();var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var arguments_=[];var thisProgram="./this.program";var quit_=function(status,toThrow){throw toThrow};var ENVIRONMENT_IS_WEB=true;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}return scriptDirectory+path}var read_,readAsync,readBinary,setWindowTitle;if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(document.currentScript){scriptDirectory=document.currentScript.src}if(_scriptDir){scriptDirectory=_scriptDir}if(scriptDirectory.indexOf("blob:")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf("/")+1)}else{scriptDirectory=""}{read_=function shell_read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(ENVIRONMENT_IS_WORKER){readBinary=function readBinary(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}}readAsync=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}onerror()};xhr.onerror=onerror;xhr.send(null)}}setWindowTitle=function(title){document.title=title}}else{}var out=Module["print"]||console.log.bind(console);var err=Module["printErr"]||console.warn.bind(console);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=null;if(Module["arguments"])arguments_=Module["arguments"];if(Module["thisProgram"])thisProgram=Module["thisProgram"];if(Module["quit"])quit_=Module["quit"];function dynamicAlloc(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=ret+size+15&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;return ret}function getNativeTypeSize(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return 4}else if(type[0]==="i"){var bits=Number(type.substr(1));assert(bits%8===0,"getNativeTypeSize invalid bits "+bits+", type "+type);return bits/8}else{return 0}}}}var asm2wasmImports={"f64-rem":function(x,y){return x%y},"debugger":function(){}};var functionPointers=new Array(0);var tempRet0=0;var setTempRet0=function(value){tempRet0=value};var getTempRet0=function(){return tempRet0};var wasmBinary;if(Module["wasmBinary"])wasmBinary=Module["wasmBinary"];var noExitRuntime;if(Module["noExitRuntime"])noExitRuntime=Module["noExitRuntime"];if(typeof WebAssembly!=="object"){err("no native wasm support detected")}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}var wasmMemory;var wasmTable=new WebAssembly.Table({"initial":6743,"maximum":6743,"element":"anyfunc"});var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}function ccall(ident,returnType,argTypes,args,opts){var toC={"string":function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=stackAlloc(len);stringToUTF8(str,ret,len)}return ret},"array":function(arr){var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}};function convertReturnValue(ret){if(returnType==="string")return UTF8ToString(ret);if(returnType==="boolean")return Boolean(ret);return ret}var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);ret=convertReturnValue(ret);if(stack!==0)stackRestore(stack);return ret}var ALLOC_STACK=1;var ALLOC_NONE=3;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,stackAlloc,dynamicAlloc][allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function getMemory(size){if(!runtimeInitialized)return dynamicAlloc(size);return _malloc(size)}var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(heap,idx,maxBytesToRead){var endIdx=idx+maxBytesToRead;var endPtr=idx;while(heap[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&heap.subarray&&UTF8Decoder){return UTF8Decoder.decode(heap.subarray(idx,endPtr))}else{var str="";while(idx<endPtr){var u0=heap[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=heap[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=heap[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|heap[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}return str}function UTF8ToString(ptr,maxBytesToRead){return ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):""}function stringToUTF8Array(str,heap,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;heap[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;heap[outIdx++]=192|u>>6;heap[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;heap[outIdx++]=224|u>>12;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}else{if(outIdx+3>=endIdx)break;heap[outIdx++]=240|u>>18;heap[outIdx++]=128|u>>12&63;heap[outIdx++]=128|u>>6&63;heap[outIdx++]=128|u&63}}heap[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127)++len;else if(u<=2047)len+=2;else if(u<=65535)len+=3;else len+=4}return len}function allocateUTF8(str){var size=lengthBytesUTF8(str)+1;var ret=_malloc(size);if(ret)stringToUTF8Array(str,HEAP8,ret,size);return ret}function allocateUTF8OnStack(str){var size=lengthBytesUTF8(str)+1;var ret=stackAlloc(size);stringToUTF8Array(str,HEAP8,ret,size);return ret}function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}var WASM_PAGE_SIZE=65536;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferAndViews(buf){buffer=buf;Module["HEAP8"]=HEAP8=new Int8Array(buf);Module["HEAP16"]=HEAP16=new Int16Array(buf);Module["HEAP32"]=HEAP32=new Int32Array(buf);Module["HEAPU8"]=HEAPU8=new Uint8Array(buf);Module["HEAPU16"]=HEAPU16=new Uint16Array(buf);Module["HEAPU32"]=HEAPU32=new Uint32Array(buf);Module["HEAPF32"]=HEAPF32=new Float32Array(buf);Module["HEAPF64"]=HEAPF64=new Float64Array(buf)}var DYNAMIC_BASE=7748784,DYNAMICTOP_PTR=2505712;var INITIAL_INITIAL_MEMORY=Module["INITIAL_MEMORY"]||1073741824;if(Module["wasmMemory"]){wasmMemory=Module["wasmMemory"]}else{wasmMemory=new WebAssembly.Memory({"initial":INITIAL_INITIAL_MEMORY/WASM_PAGE_SIZE})}if(wasmMemory){buffer=wasmMemory.buffer}INITIAL_INITIAL_MEMORY=buffer.byteLength;updateGlobalBufferAndViews(buffer);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback(Module);continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;if(!Module["noFSInit"]&&!FS.init.initialized)FS.init();TTY.init();SOCKFS.root=FS.mount(SOCKFS,{},null);PIPEFS.root=FS.mount(PIPEFS,{},null);callRuntimeCallbacks(__ATINIT__)}function preMain(){FS.ignorePermissions=false;callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};function abort(what){if(Module["onAbort"]){Module["onAbort"](what)}what+="";out(what);err(what);ABORT=true;EXITSTATUS=1;what="abort("+what+"). Build with -s ASSERTIONS=1 for more info.";throw new WebAssembly.RuntimeError(what)}function hasPrefix(str,prefix){return String.prototype.startsWith?str.startsWith(prefix):str.indexOf(prefix)===0}var dataURIPrefix="data:application/octet-stream;base64,";function isDataURI(filename){return hasPrefix(filename,dataURIPrefix)}var wasmBinaryFile="php-web-drupal.wasm";if(!isDataURI(wasmBinaryFile)){wasmBinaryFile=locateFile(wasmBinaryFile)}function getBinary(){try{if(wasmBinary){return new Uint8Array(wasmBinary)}if(readBinary){return readBinary(wasmBinaryFile)}else{throw"both async and sync fetching of the wasm failed"}}catch(err){abort(err)}}function getBinaryPromise(){if(!wasmBinary&&(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&typeof fetch==="function"){return fetch(wasmBinaryFile,{credentials:"same-origin"}).then(function(response){if(!response["ok"]){throw"failed to load wasm binary file at '"+wasmBinaryFile+"'"}return response["arrayBuffer"]()}).catch(function(){return getBinary()})}return new Promise(function(resolve,reject){resolve(getBinary())})}function createWasm(){var info={"env":asmLibraryArg,"wasi_snapshot_preview1":asmLibraryArg,"global":{"NaN":NaN,Infinity:Infinity},"global.Math":Math,"asm2wasm":asm2wasmImports};function receiveInstance(instance,module){var exports=instance.exports;Module["asm"]=exports;removeRunDependency("wasm-instantiate")}addRunDependency("wasm-instantiate");function receiveInstantiatedSource(output){receiveInstance(output["instance"])}function instantiateArrayBuffer(receiver){return getBinaryPromise().then(function(binary){return WebAssembly.instantiate(binary,info)}).then(receiver,function(reason){err("failed to asynchronously prepare wasm: "+reason);abort(reason)})}function instantiateAsync(){if(!wasmBinary&&typeof WebAssembly.instantiateStreaming==="function"&&!isDataURI(wasmBinaryFile)&&typeof fetch==="function"){fetch(wasmBinaryFile,{credentials:"same-origin"}).then(function(response){var result=WebAssembly.instantiateStreaming(response,info);return result.then(receiveInstantiatedSource,function(reason){err("wasm streaming compile failed: "+reason);err("falling back to ArrayBuffer instantiation");return instantiateArrayBuffer(receiveInstantiatedSource)})})}else{return instantiateArrayBuffer(receiveInstantiatedSource)}}if(Module["instantiateWasm"]){try{var exports=Module["instantiateWasm"](info,receiveInstance);return exports}catch(e){err("Module.instantiateWasm callback failed with error: "+e);return false}}instantiateAsync();return{}}Module["asm"]=createWasm;var tempDouble;var tempI64;var ASM_CONSTS=[function($0,$1){const target=Module.targets.get($0)||window;const property=UTF8ToString($1);const result=target[property];console.log("target/prop:",$0,target,property,typeof result,result);if(!result||!["function","object"].includes(typeof result)){const jsRet="OK"+String(result);const len=lengthBytesUTF8(jsRet)+1;const strLoc=_malloc(len);stringToUTF8(jsRet,strLoc,len);return strLoc}const jsRet="XX";const len=lengthBytesUTF8(jsRet)+1;const strLoc=_malloc(len);stringToUTF8(jsRet,strLoc,len);return strLoc},function($0,$1){const target=Module.targets.get($0)||window;const property=UTF8ToString($1);const result=target[property];console.log("target/prop:",$0,target,property,typeof result,result);if(["function","object"].includes(typeof result)){let index=Module.targets.has(result);if(!index){index=Module.targets.add(result)}console.log(index);return index}console.log(0);return 0},function($0,$1,$2){const target=Module.targets.get($0)||window;const eventName=UTF8ToString($1);const funcPtr=$2;const options={};const callback=()=>{Module.ccall("exec_callback","number",["number"],[funcPtr])};target.addEventListener(eventName,callback,options);const remover=()=>{target.removeEventListener(eventName,callback,options);return $2};return Module.callbacks.add(remover)},function($0){const remover=Module.callbacks.get($0);return remover()},function($0,$1){const target=Module.targets.get($0)||document;const querySelector=UTF8ToString($1);const result=target.querySelector(querySelector);if(!result){return 0}let index=Module.targets.has(result)||0;if(!index){index=Module.targets.add(result)}return index},function($0){const jsRet=String(eval(UTF8ToString($0)));const len=lengthBytesUTF8(jsRet)+1;const strLoc=_malloc(len);stringToUTF8(jsRet,strLoc,len);return strLoc},function($0,$1){const funcName=UTF8ToString($0);const argJson=UTF8ToString($1);const func=window[funcName];const args=JSON.parse(argJson||"[]")||[];const jsRet=String(func(...args));const len=lengthBytesUTF8(jsRet)+1;const strLoc=_malloc(len);stringToUTF8(jsRet,strLoc,len);return strLoc},function($0,$1){const timeout=Number(UTF8ToString($0));const funcPtr=$1;setTimeout(()=>{Module.ccall("exec_callback","number",["number"],[funcPtr]);Module.ccall("del_callback","number",["number"],[funcPtr])},timeout)}];function _emscripten_asm_const_iii(code,a0,a1){return ASM_CONSTS[code](a0,a1)}function _emscripten_asm_const_ii(code,a0){return ASM_CONSTS[code](a0)}function _emscripten_asm_const_iiii(code,a0,a1,a2){return ASM_CONSTS[code](a0,a1,a2)}__ATINIT__.push({func:function(){___emscripten_environ_constructor()}});function demangle(func){return func}function demangleAll(text){var regex=/\b__Z[\w\d_]+/g;return text.replace(regex,function(x){var y=demangle(x);return x===y?x:y+" ["+x+"]"})}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}function ___assert_fail(condition,filename,line,func){abort("Assertion failed: "+UTF8ToString(condition)+", at: "+[filename?UTF8ToString(filename):"unknown filename",line,func?UTF8ToString(func):"unknown function"])}var ENV={};function __getExecutableName(){return thisProgram||"./this.program"}function ___buildEnvironment(environ){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]="web_user";ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]=(typeof navigator==="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8";ENV["_"]=__getExecutableName();poolPtr=getMemory(TOTAL_ENV_SIZE);envPtr=getMemory(MAX_ENV_VALUES*4);HEAP32[envPtr>>2]=poolPtr;HEAP32[environ>>2]=envPtr}else{envPtr=HEAP32[environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in ENV){if(typeof ENV[key]==="string"){var line=key+"="+ENV[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var _emscripten_get_now;_emscripten_get_now=function(){return performance.now()};var _emscripten_get_now_is_monotonic=true;function setErrNo(value){HEAP32[___errno_location()>>2]=value;return value}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if((clk_id===1||clk_id===4)&&_emscripten_get_now_is_monotonic){now=_emscripten_get_now()}else{setErrNo(28);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}function ___clock_gettime(a0,a1){return _clock_gettime(a0,a1)}function ___map_file(pathname,size){setErrNo(63);return-1}var PATH={splitPath:function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)},normalizeArray:function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts},normalize:function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter(function(p){return!!p}),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path},dirname:function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir},basename:function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)},extname:function(path){return PATH.splitPath(path)[3]},join:function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))},join2:function(l,r){return PATH.normalize(l+"/"+r)}};var PATH_FS={resolve:function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter(function(p){return!!p}),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."},relative:function(from,to){from=PATH_FS.resolve(from).substr(1);to=PATH_FS.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")}};var TTY={ttys:[],init:function(){},shutdown:function(){},register:function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)},stream_ops:{open:function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(43)}stream.tty=tty;stream.seekable=false},close:function(stream){stream.tty.ops.flush(stream.tty)},flush:function(stream){stream.tty.ops.flush(stream.tty)},read:function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(60)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead},write:function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(60)}try{for(var i=0;i<length;i++){stream.tty.ops.put_char(stream.tty,buffer[offset+i])}}catch(e){throw new FS.ErrnoError(29)}if(length){stream.node.timestamp=Date.now()}return i}},default_tty_ops:{get_char:function(tty){if(!tty.input.length){var result=null;if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()},put_char:function(tty,val){if(val===null||val===10){out(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}},flush:function(tty){if(tty.output&&tty.output.length>0){out(UTF8ArrayToString(tty.output,0));tty.output=[]}}},default_tty1_ops:{put_char:function(tty,val){if(val===null||val===10){err(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}},flush:function(tty){if(tty.output&&tty.output.length>0){err(UTF8ArrayToString(tty.output,0));tty.output=[]}}}};var MEMFS={ops_table:null,mount:function(mount){return MEMFS.createNode(null,"/",16384|511,0)},createNode:function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(63)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node},getFileDataAsRegularArray:function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents},getFileDataAsTypedArray:function(node){if(!node.contents)return new Uint8Array(0);if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)},expandFileStorage:function(node,newCapacity){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)>>>0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return},resizeFileStorage:function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(newSize);if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize},node_ops:{getattr:function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr},setattr:function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}},lookup:function(parent,name){throw FS.genericErrors[44]},mknod:function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)},rename:function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(55)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir},unlink:function(parent,name){delete parent.contents[name]},rmdir:function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(55)}delete parent.contents[name]},readdir:function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries},symlink:function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node},readlink:function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(28)}return node.link}},stream_ops:{read:function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size},write:function(stream,buffer,offset,length,position,canOwn){if(buffer.buffer===HEAP8.buffer){canOwn=false}if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=buffer.slice(offset,offset+length);node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length},llseek:function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(28)}return position},allocate:function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)},mmap:function(stream,address,length,position,prot,flags){assert(address===0);if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&contents.buffer===buffer){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<contents.length){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(48)}HEAP8.set(contents,ptr)}return{ptr:ptr,allocated:allocated}},msync:function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0}}};var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return setErrNo(e.errno)},lookupPath:function(path,opts){path=PATH_FS.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(32)}var parts=PATH.normalizeArray(path.split("/").filter(function(p){return!!p}),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH_FS.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(32)}}}}return{path:current_path,node:current}},getPath:function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}},hashName:function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length},hashAddNode:function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node},hashRemoveNode:function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}},lookupNode:function(parent,name){var errCode=FS.mayLookup(parent);if(errCode){throw new FS.ErrnoError(errCode,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)},createNode:function(parent,name,mode,rdev){var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node},destroyNode:function(node){FS.hashRemoveNode(node)},isRoot:function(node){return node===node.parent},isMountpoint:function(node){return!!node.mounted},isFile:function(mode){return(mode&61440)===32768},isDir:function(mode){return(mode&61440)===16384},isLink:function(mode){return(mode&61440)===40960},isChrdev:function(mode){return(mode&61440)===8192},isBlkdev:function(mode){return(mode&61440)===24576},isFIFO:function(mode){return(mode&61440)===4096},isSocket:function(mode){return(mode&49152)===49152},flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags},flagsToPermissionString:function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms},nodePermissions:function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return 2}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return 2}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return 2}return 0},mayLookup:function(dir){var errCode=FS.nodePermissions(dir,"x");if(errCode)return errCode;if(!dir.node_ops.lookup)return 2;return 0},mayCreate:function(dir,name){try{var node=FS.lookupNode(dir,name);return 20}catch(e){}return FS.nodePermissions(dir,"wx")},mayDelete:function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var errCode=FS.nodePermissions(dir,"wx");if(errCode){return errCode}if(isdir){if(!FS.isDir(node.mode)){return 54}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return 10}}else{if(FS.isDir(node.mode)){return 31}}return 0},mayOpen:function(node,flags){if(!node){return 44}if(FS.isLink(node.mode)){return 32}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return 31}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))},MAX_OPEN_FDS:4096,nextfd:function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(33)},getStream:function(fd){return FS.streams[fd]},createStream:function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=function(){};FS.FSStream.prototype={object:{get:function(){return this.node},set:function(val){this.node=val}},isRead:{get:function(){return(this.flags&2097155)!==1}},isWrite:{get:function(){return(this.flags&2097155)!==0}},isAppend:{get:function(){return this.flags&1024}}}}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream},closeStream:function(fd){FS.streams[fd]=null},chrdev_stream_ops:{open:function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}},llseek:function(){throw new FS.ErrnoError(70)}},major:function(dev){return dev>>8},minor:function(dev){return dev&255},makedev:function(ma,mi){return ma<<8|mi},registerDevice:function(dev,ops){FS.devices[dev]={stream_ops:ops}},getDevice:function(dev){return FS.devices[dev]},getMounts:function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts},syncfs:function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){err("warning: "+FS.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work")}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(errCode){FS.syncFSRequests--;return callback(errCode)}function done(errCode){if(errCode){if(!done.errored){done.errored=true;return doCallback(errCode)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach(function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)})},mount:function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(10)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot},unmount:function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(28)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach(function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}});node.mounted=null;var idx=node.mount.mounts.indexOf(mount);node.mount.mounts.splice(idx,1)},lookup:function(parent,name){return parent.node_ops.lookup(parent,name)},mknod:function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(28)}var errCode=FS.mayCreate(parent,name);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(63)}return parent.node_ops.mknod(parent,name,mode,dev)},create:function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)},mkdir:function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)},mkdirTree:function(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=20)throw e}}},mkdev:function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)},symlink:function(oldpath,newpath){if(!PATH_FS.resolve(oldpath)){throw new FS.ErrnoError(44)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(44)}var newname=PATH.basename(newpath);var errCode=FS.mayCreate(parent,newname);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(63)}return parent.node_ops.symlink(parent,newname,oldpath)},rename:function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(10)}if(!old_dir||!new_dir)throw new FS.ErrnoError(44);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(75)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH_FS.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(28)}relative=PATH_FS.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(55)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var errCode=FS.mayDelete(old_dir,old_name,isdir);if(errCode){throw new FS.ErrnoError(errCode)}errCode=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(errCode){throw new FS.ErrnoError(errCode)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(63)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(10)}if(new_dir!==old_dir){errCode=FS.nodePermissions(old_dir,"w");if(errCode){throw new FS.ErrnoError(errCode)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){err("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){err("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}},rmdir:function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,true);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){err("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){err("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}},readdir:function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(54)}return node.node_ops.readdir(node)},unlink:function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,false);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){err("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){err("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}},readlink:function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(44)}if(!link.node_ops.readlink){throw new FS.ErrnoError(28)}return PATH_FS.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))},stat:function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(44)}if(!node.node_ops.getattr){throw new FS.ErrnoError(63)}return node.node_ops.getattr(node)},lstat:function(path){return FS.stat(path,true)},chmod:function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})},lchmod:function(path,mode){FS.chmod(path,mode,true)},fchmod:function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(8)}FS.chmod(stream.node,mode)},chown:function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}node.node_ops.setattr(node,{timestamp:Date.now()})},lchown:function(path,uid,gid){FS.chown(path,uid,gid,true)},fchown:function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(8)}FS.chown(stream.node,uid,gid)},truncate:function(path,len){if(len<0){throw new FS.ErrnoError(28)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(63)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(31)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(28)}var errCode=FS.nodePermissions(node,"w");if(errCode){throw new FS.ErrnoError(errCode)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})},ftruncate:function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(28)}FS.truncate(stream.node,len)},utime:function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})},open:function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(44)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(20)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(44)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}if(!created){var errCode=FS.mayOpen(node,flags);if(errCode){throw new FS.ErrnoError(errCode)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512|131072);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;err("FS.trackingDelegate error on read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){err("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream},close:function(stream){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}stream.fd=null},isClosed:function(stream){return stream.fd===null},llseek:function(stream,offset,whence){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(70)}if(whence!=0&&whence!=1&&whence!=2){throw new FS.ErrnoError(28)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position},read:function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.read){throw new FS.ErrnoError(28)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead},write:function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.write){throw new FS.ErrnoError(28)}if(stream.seekable&&stream.flags&1024){FS.llseek(stream,0,2)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){err("FS.trackingDelegate['onWriteToFile']('"+stream.path+"') threw an exception: "+e.message)}return bytesWritten},allocate:function(stream,offset,length){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(offset<0||length<=0){throw new FS.ErrnoError(28)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(43)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(138)}stream.stream_ops.allocate(stream,offset,length)},mmap:function(stream,address,length,position,prot,flags){if((prot&2)!==0&&(flags&2)===0&&(stream.flags&2097155)!==2){throw new FS.ErrnoError(2)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(2)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(43)}return stream.stream_ops.mmap(stream,address,length,position,prot,flags)},msync:function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)},munmap:function(stream){return 0},ioctl:function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(59)}return stream.stream_ops.ioctl(stream,cmd,arg)},readFile:function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret},writeFile:function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";var stream=FS.open(path,opts.flags,opts.mode);if(typeof data==="string"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,undefined,opts.canOwn)}else if(ArrayBuffer.isView(data)){FS.write(stream,data,0,data.byteLength,undefined,opts.canOwn)}else{throw new Error("Unsupported data type")}FS.close(stream)},cwd:function(){return FS.currentPath},chdir:function(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(44)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(54)}var errCode=FS.nodePermissions(lookup.node,"x");if(errCode){throw new FS.ErrnoError(errCode)}FS.currentPath=lookup.path},createDefaultDirectories:function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")},createDefaultDevices:function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:function(){return 0},write:function(stream,buffer,offset,length,pos){return length}});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto==="object"&&typeof crypto["getRandomValues"]==="function"){var randomBuffer=new Uint8Array(1);random_device=function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]}}else{}if(!random_device){random_device=function(){abort("random_device")}}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")},createSpecialDirectories:function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(8);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:function(){return stream.path}}};ret.parent=ret;return ret}};return node}},{},"/proc/self/fd")},createStandardStreams:function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");var stdout=FS.open("/dev/stdout","w");var stderr=FS.open("/dev/stderr","w")},ensureErrnoError:function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=function(errno){this.errno=errno};this.setErrno(errno);this.message="FS error"};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[44].forEach(function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"})},staticInit:function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS}},init:function(input,output,error){FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()},quit:function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}},getMode:function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode},joinPath:function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path},absolutePath:function(relative,base){return PATH_FS.resolve(base,relative)},standardizePath:function(path){return PATH.normalize(path)},findObject:function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{setErrNo(ret.error);return null}},analyzePath:function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret},createFolder:function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)},createPath:function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current},createFile:function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)},createDataFile:function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node},createDevice:function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:function(stream){stream.seekable=false},close:function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}},read:function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead},write:function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(29)}}if(length){stream.node.timestamp=Date.now()}return i}});return FS.mkdev(path,mode,dev)},createLink:function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)},forceLoadFile:function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(read_){try{obj.contents=intArrayFromString(read_(obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)setErrNo(29);return success},createLazyFile:function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}};var lazyArray=this;lazyArray.setDataGetter(function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]});if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;out("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:function(){if(!this.lengthKnown){this.cacheLength()}return this._length}},chunkSize:{get:function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize}}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:function(){return this.contents.length}}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach(function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(29)}return fn.apply(null,arguments)}});stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(29)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node},createPreloadedFile:function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH_FS.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach(function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,function(){if(onerror)onerror();removeRunDependency(dep)});handled=true}});if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,function(byteArray){processData(byteArray)},onerror)}else{processData(url)}},indexedDB:function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB},DB_NAME:function(){return"EM_FS_"+window.location.pathname},DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function(paths,onload,onerror){onload=onload||function(){};onerror=onerror||function(){};var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){out("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach(function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}});transaction.onerror=onerror};openRequest.onerror=onerror},loadFilesFromDB:function(paths,onload,onerror){onload=onload||function(){};onerror=onerror||function(){};var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach(function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}});transaction.onerror=onerror};openRequest.onerror=onerror}};var SYSCALLS={mappings:{},DEFAULT_POLLMASK:5,umask:511,calculateAt:function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(8);dir=dirstream.path}path=PATH.join2(dir,path)}return path},doStat:function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-54}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;tempI64=[stat.size>>>0,(tempDouble=stat.size,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+40>>2]=tempI64[0],HEAP32[buf+44>>2]=tempI64[1];HEAP32[buf+48>>2]=4096;HEAP32[buf+52>>2]=stat.blocks;HEAP32[buf+56>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+76>>2]=0;tempI64=[stat.ino>>>0,(tempDouble=stat.ino,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[buf+80>>2]=tempI64[0],HEAP32[buf+84>>2]=tempI64[1];return 0},doMsync:function(addr,stream,len,flags,offset){var buffer=HEAPU8.slice(addr,addr+len);FS.msync(stream,buffer,offset,len,flags)},doMkdir:function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0},doMknod:function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-28}FS.mknod(path,mode,dev);return 0},doReadlink:function(path,buf,bufsize){if(bufsize<=0)return-28;var ret=FS.readlink(path);var len=Math.min(bufsize,lengthBytesUTF8(ret));var endChar=HEAP8[buf+len];stringToUTF8(ret,buf,bufsize+1);HEAP8[buf+len]=endChar;return len},doAccess:function(path,amode){if(amode&~7){return-28}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;if(!node){return-44}var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-2}return 0},doDup:function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd},doReadv:function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret},doWritev:function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret},varargs:undefined,get:function(){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret},getStr:function(ptr){var ret=UTF8ToString(ptr);return ret},getStreamFromFD:function(fd){var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(8);return stream},get64:function(low,high){return low}};function ___sys_unlink(path){try{path=SYSCALLS.getStr(path);FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall10(a0){return ___sys_unlink(a0)}var ERRNO_CODES={EPERM:63,ENOENT:44,ESRCH:71,EINTR:27,EIO:29,ENXIO:60,E2BIG:1,ENOEXEC:45,EBADF:8,ECHILD:12,EAGAIN:6,EWOULDBLOCK:6,ENOMEM:48,EACCES:2,EFAULT:21,ENOTBLK:105,EBUSY:10,EEXIST:20,EXDEV:75,ENODEV:43,ENOTDIR:54,EISDIR:31,EINVAL:28,ENFILE:41,EMFILE:33,ENOTTY:59,ETXTBSY:74,EFBIG:22,ENOSPC:51,ESPIPE:70,EROFS:69,EMLINK:34,EPIPE:64,EDOM:18,ERANGE:68,ENOMSG:49,EIDRM:24,ECHRNG:106,EL2NSYNC:156,EL3HLT:107,EL3RST:108,ELNRNG:109,EUNATCH:110,ENOCSI:111,EL2HLT:112,EDEADLK:16,ENOLCK:46,EBADE:113,EBADR:114,EXFULL:115,ENOANO:104,EBADRQC:103,EBADSLT:102,EDEADLOCK:16,EBFONT:101,ENOSTR:100,ENODATA:116,ETIME:117,ENOSR:118,ENONET:119,ENOPKG:120,EREMOTE:121,ENOLINK:47,EADV:122,ESRMNT:123,ECOMM:124,EPROTO:65,EMULTIHOP:36,EDOTDOT:125,EBADMSG:9,ENOTUNIQ:126,EBADFD:127,EREMCHG:128,ELIBACC:129,ELIBBAD:130,ELIBSCN:131,ELIBMAX:132,ELIBEXEC:133,ENOSYS:52,ENOTEMPTY:55,ENAMETOOLONG:37,ELOOP:32,EOPNOTSUPP:138,EPFNOSUPPORT:139,ECONNRESET:15,ENOBUFS:42,EAFNOSUPPORT:5,EPROTOTYPE:67,ENOTSOCK:57,ENOPROTOOPT:50,ESHUTDOWN:140,ECONNREFUSED:14,EADDRINUSE:3,ECONNABORTED:13,ENETUNREACH:40,ENETDOWN:38,ETIMEDOUT:73,EHOSTDOWN:142,EHOSTUNREACH:23,EINPROGRESS:26,EALREADY:7,EDESTADDRREQ:17,EMSGSIZE:35,EPROTONOSUPPORT:66,ESOCKTNOSUPPORT:137,EADDRNOTAVAIL:4,ENETRESET:39,EISCONN:30,ENOTCONN:53,ETOOMANYREFS:141,EUSERS:136,EDQUOT:19,ESTALE:72,ENOTSUP:138,ENOMEDIUM:148,EILSEQ:25,EOVERFLOW:61,ECANCELED:11,ENOTRECOVERABLE:56,EOWNERDEAD:62,ESTRPIPE:135};var SOCKFS={mount:function(mount){Module["websocket"]=Module["websocket"]&&"object"===typeof Module["websocket"]?Module["websocket"]:{};Module["websocket"]._callbacks={};Module["websocket"]["on"]=function(event,callback){if("function"===typeof callback){this._callbacks[event]=callback}return this};Module["websocket"].emit=function(event,param){if("function"===typeof this._callbacks[event]){this._callbacks[event].call(this,param)}};return FS.createNode(null,"/",16384|511,0)},createSocket:function(family,type,protocol){var streaming=type==1;if(protocol){assert(streaming==(protocol==6))}var sock={family:family,type:type,protocol:protocol,server:null,error:null,peers:{},pending:[],recv_queue:[],sock_ops:SOCKFS.websocket_sock_ops};var name=SOCKFS.nextname();var node=FS.createNode(SOCKFS.root,name,49152,0);node.sock=sock;var stream=FS.createStream({path:name,node:node,flags:FS.modeStringToFlags("r+"),seekable:false,stream_ops:SOCKFS.stream_ops});sock.stream=stream;return sock},getSocket:function(fd){var stream=FS.getStream(fd);if(!stream||!FS.isSocket(stream.node.mode)){return null}return stream.node.sock},stream_ops:{poll:function(stream){var sock=stream.node.sock;return sock.sock_ops.poll(sock)},ioctl:function(stream,request,varargs){var sock=stream.node.sock;return sock.sock_ops.ioctl(sock,request,varargs)},read:function(stream,buffer,offset,length,position){var sock=stream.node.sock;var msg=sock.sock_ops.recvmsg(sock,length);if(!msg){return 0}buffer.set(msg.buffer,offset);return msg.buffer.length},write:function(stream,buffer,offset,length,position){var sock=stream.node.sock;return sock.sock_ops.sendmsg(sock,buffer,offset,length)},close:function(stream){var sock=stream.node.sock;sock.sock_ops.close(sock)}},nextname:function(){if(!SOCKFS.nextname.current){SOCKFS.nextname.current=0}return"socket["+SOCKFS.nextname.current+++"]"},websocket_sock_ops:{createPeer:function(sock,addr,port){var ws;if(typeof addr==="object"){ws=addr;addr=null;port=null}if(ws){if(ws._socket){addr=ws._socket.remoteAddress;port=ws._socket.remotePort}else{var result=/ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);if(!result){throw new Error("WebSocket URL must be in the format ws(s)://address:port")}addr=result[1];port=parseInt(result[2],10)}}else{try{var runtimeConfig=Module["websocket"]&&"object"===typeof Module["websocket"];var url="ws:#".replace("#","//");if(runtimeConfig){if("string"===typeof Module["websocket"]["url"]){url=Module["websocket"]["url"]}}if(url==="ws://"||url==="wss://"){var parts=addr.split("/");url=url+parts[0]+":"+port+"/"+parts.slice(1).join("/")}var subProtocols="binary";if(runtimeConfig){if("string"===typeof Module["websocket"]["subprotocol"]){subProtocols=Module["websocket"]["subprotocol"]}}var opts=undefined;if(subProtocols!=="null"){subProtocols=subProtocols.replace(/^ +| +$/g,"").split(/ *, */);opts=ENVIRONMENT_IS_NODE?{"protocol":subProtocols.toString()}:subProtocols}if(runtimeConfig&&null===Module["websocket"]["subprotocol"]){subProtocols="null";opts=undefined}var WebSocketConstructor;{WebSocketConstructor=WebSocket}ws=new WebSocketConstructor(url,opts);ws.binaryType="arraybuffer"}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH)}}var peer={addr:addr,port:port,socket:ws,dgram_send_queue:[]};SOCKFS.websocket_sock_ops.addPeer(sock,peer);SOCKFS.websocket_sock_ops.handlePeerEvents(sock,peer);if(sock.type===2&&typeof sock.sport!=="undefined"){peer.dgram_send_queue.push(new Uint8Array([255,255,255,255,"p".charCodeAt(0),"o".charCodeAt(0),"r".charCodeAt(0),"t".charCodeAt(0),(sock.sport&65280)>>8,sock.sport&255]))}return peer},getPeer:function(sock,addr,port){return sock.peers[addr+":"+port]},addPeer:function(sock,peer){sock.peers[peer.addr+":"+peer.port]=peer},removePeer:function(sock,peer){delete sock.peers[peer.addr+":"+peer.port]},handlePeerEvents:function(sock,peer){var first=true;var handleOpen=function(){Module["websocket"].emit("open",sock.stream.fd);try{var queued=peer.dgram_send_queue.shift();while(queued){peer.socket.send(queued);queued=peer.dgram_send_queue.shift()}}catch(e){peer.socket.close()}};function handleMessage(data){if(typeof data==="string"){var encoder=new TextEncoder;data=encoder.encode(data)}else{assert(data.byteLength!==undefined);if(data.byteLength==0){return}else{data=new Uint8Array(data)}}var wasfirst=first;first=false;if(wasfirst&&data.length===10&&data[0]===255&&data[1]===255&&data[2]===255&&data[3]===255&&data[4]==="p".charCodeAt(0)&&data[5]==="o".charCodeAt(0)&&data[6]==="r".charCodeAt(0)&&data[7]==="t".charCodeAt(0)){var newport=data[8]<<8|data[9];SOCKFS.websocket_sock_ops.removePeer(sock,peer);peer.port=newport;SOCKFS.websocket_sock_ops.addPeer(sock,peer);return}sock.recv_queue.push({addr:peer.addr,port:peer.port,data:data});Module["websocket"].emit("message",sock.stream.fd)}if(ENVIRONMENT_IS_NODE){peer.socket.on("open",handleOpen);peer.socket.on("message",function(data,flags){if(!flags.binary){return}handleMessage(new Uint8Array(data).buffer)});peer.socket.on("close",function(){Module["websocket"].emit("close",sock.stream.fd)});peer.socket.on("error",function(error){sock.error=ERRNO_CODES.ECONNREFUSED;Module["websocket"].emit("error",[sock.stream.fd,sock.error,"ECONNREFUSED: Connection refused"])})}else{peer.socket.onopen=handleOpen;peer.socket.onclose=function(){Module["websocket"].emit("close",sock.stream.fd)};peer.socket.onmessage=function peer_socket_onmessage(event){handleMessage(event.data)};peer.socket.onerror=function(error){sock.error=ERRNO_CODES.ECONNREFUSED;Module["websocket"].emit("error",[sock.stream.fd,sock.error,"ECONNREFUSED: Connection refused"])}}},poll:function(sock){if(sock.type===1&&sock.server){return sock.pending.length?64|1:0}var mask=0;var dest=sock.type===1?SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport):null;if(sock.recv_queue.length||!dest||dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=64|1}if(!dest||dest&&dest.socket.readyState===dest.socket.OPEN){mask|=4}if(dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=16}return mask},ioctl:function(sock,request,arg){switch(request){case 21531:var bytes=0;if(sock.recv_queue.length){bytes=sock.recv_queue[0].data.length}HEAP32[arg>>2]=bytes;return 0;default:return ERRNO_CODES.EINVAL}},close:function(sock){if(sock.server){try{sock.server.close()}catch(e){}sock.server=null}var peers=Object.keys(sock.peers);for(var i=0;i<peers.length;i++){var peer=sock.peers[peers[i]];try{peer.socket.close()}catch(e){}SOCKFS.websocket_sock_ops.removePeer(sock,peer)}return 0},bind:function(sock,addr,port){if(typeof sock.saddr!=="undefined"||typeof sock.sport!=="undefined"){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}sock.saddr=addr;sock.sport=port;if(sock.type===2){if(sock.server){sock.server.close();sock.server=null}try{sock.sock_ops.listen(sock,0)}catch(e){if(!(e instanceof FS.ErrnoError))throw e;if(e.errno!==ERRNO_CODES.EOPNOTSUPP)throw e}}},connect:function(sock,addr,port){if(sock.server){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}if(typeof sock.daddr!=="undefined"&&typeof sock.dport!=="undefined"){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(dest){if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EALREADY)}else{throw new FS.ErrnoError(ERRNO_CODES.EISCONN)}}}var peer=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port);sock.daddr=peer.addr;sock.dport=peer.port;throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS)},listen:function(sock,backlog){if(!ENVIRONMENT_IS_NODE){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}},accept:function(listensock){if(!listensock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var newsock=listensock.pending.shift();newsock.stream.flags=listensock.stream.flags;return newsock},getname:function(sock,peer){var addr,port;if(peer){if(sock.daddr===undefined||sock.dport===undefined){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}addr=sock.daddr;port=sock.dport}else{addr=sock.saddr||0;port=sock.sport||0}return{addr:addr,port:port}},sendmsg:function(sock,buffer,offset,length,addr,port){if(sock.type===2){if(addr===undefined||port===undefined){addr=sock.daddr;port=sock.dport}if(addr===undefined||port===undefined){throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ)}}else{addr=sock.daddr;port=sock.dport}var dest=SOCKFS.websocket_sock_ops.getPeer(sock,addr,port);if(sock.type===1){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}if(ArrayBuffer.isView(buffer)){offset+=buffer.byteOffset;buffer=buffer.buffer}var data;data=buffer.slice(offset,offset+length);if(sock.type===2){if(!dest||dest.socket.readyState!==dest.socket.OPEN){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){dest=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port)}dest.dgram_send_queue.push(data);return length}}try{dest.socket.send(data);return length}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}},recvmsg:function(sock,length){if(sock.type===1&&sock.server){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}var queued=sock.recv_queue.shift();if(!queued){if(sock.type===1){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(!dest){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){return null}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var queuedLength=queued.data.byteLength||queued.data.length;var queuedOffset=queued.data.byteOffset||0;var queuedBuffer=queued.data.buffer||queued.data;var bytesRead=Math.min(length,queuedLength);var res={buffer:new Uint8Array(queuedBuffer,queuedOffset,bytesRead),addr:queued.addr,port:queued.port};if(sock.type===1&&bytesRead<queuedLength){var bytesRemaining=queuedLength-bytesRead;queued.data=new Uint8Array(queuedBuffer,queuedOffset+bytesRead,bytesRemaining);sock.recv_queue.unshift(queued)}return res}}};function __inet_pton4_raw(str){var b=str.split(".");for(var i=0;i<4;i++){var tmp=Number(b[i]);if(isNaN(tmp))return null;b[i]=tmp}return(b[0]|b[1]<<8|b[2]<<16|b[3]<<24)>>>0}function jstoi_q(str){return parseInt(str)}function __inet_pton6_raw(str){var words;var w,offset,z;var valid6regx=/^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i;var parts=[];if(!valid6regx.test(str)){return null}if(str==="::"){return[0,0,0,0,0,0,0,0]}if(str.indexOf("::")===0){str=str.replace("::","Z:")}else{str=str.replace("::",":Z:")}if(str.indexOf(".")>0){str=str.replace(new RegExp("[.]","g"),":");words=str.split(":");words[words.length-4]=jstoi_q(words[words.length-4])+jstoi_q(words[words.length-3])*256;words[words.length-3]=jstoi_q(words[words.length-2])+jstoi_q(words[words.length-1])*256;words=words.slice(0,words.length-2)}else{words=str.split(":")}offset=0;z=0;for(w=0;w<words.length;w++){if(typeof words[w]==="string"){if(words[w]==="Z"){for(z=0;z<8-words.length+1;z++){parts[w+z]=0}offset=z-1}else{parts[w+offset]=_htons(parseInt(words[w],16))}}else{parts[w+offset]=words[w]}}return[parts[1]<<16|parts[0],parts[3]<<16|parts[2],parts[5]<<16|parts[4],parts[7]<<16|parts[6]]}var DNS={address_map:{id:1,addrs:{},names:{}},lookup_name:function(name){var res=__inet_pton4_raw(name);if(res!==null){return name}res=__inet_pton6_raw(name);if(res!==null){return name}var addr;if(DNS.address_map.addrs[name]){addr=DNS.address_map.addrs[name]}else{var id=DNS.address_map.id++;assert(id<65535,"exceeded max address mappings of 65535");addr="172.29."+(id&255)+"."+(id&65280);DNS.address_map.names[addr]=name;DNS.address_map.addrs[name]=addr}return addr},lookup_addr:function(addr){if(DNS.address_map.names[addr]){return DNS.address_map.names[addr]}return null}};function __inet_ntop4_raw(addr){return(addr&255)+"."+(addr>>8&255)+"."+(addr>>16&255)+"."+(addr>>24&255)}function __inet_ntop6_raw(ints){var str="";var word=0;var longest=0;var lastzero=0;var zstart=0;var len=0;var i=0;var parts=[ints[0]&65535,ints[0]>>16,ints[1]&65535,ints[1]>>16,ints[2]&65535,ints[2]>>16,ints[3]&65535,ints[3]>>16];var hasipv4=true;var v4part="";for(i=0;i<5;i++){if(parts[i]!==0){hasipv4=false;break}}if(hasipv4){v4part=__inet_ntop4_raw(parts[6]|parts[7]<<16);if(parts[5]===-1){str="::ffff:";str+=v4part;return str}if(parts[5]===0){str="::";if(v4part==="0.0.0.0")v4part="";if(v4part==="0.0.0.1")v4part="1";str+=v4part;return str}}for(word=0;word<8;word++){if(parts[word]===0){if(word-lastzero>1){len=0}lastzero=word;len++}if(len>longest){longest=len;zstart=word-longest+1}}for(word=0;word<8;word++){if(longest>1){if(parts[word]===0&&word>=zstart&&word<zstart+longest){if(word===zstart){str+=":";if(zstart===0)str+=":"}continue}}str+=Number(_ntohs(parts[word]&65535)).toString(16);str+=word<7?":":""}return str}function __read_sockaddr(sa,salen){var family=HEAP16[sa>>1];var port=_ntohs(HEAPU16[sa+2>>1]);var addr;switch(family){case 2:if(salen!==16){return{errno:28}}addr=HEAP32[sa+4>>2];addr=__inet_ntop4_raw(addr);break;case 10:if(salen!==28){return{errno:28}}addr=[HEAP32[sa+8>>2],HEAP32[sa+12>>2],HEAP32[sa+16>>2],HEAP32[sa+20>>2]];addr=__inet_ntop6_raw(addr);break;default:return{errno:5}}return{family:family,addr:addr,port:port}}function __write_sockaddr(sa,family,addr,port){switch(family){case 2:addr=__inet_pton4_raw(addr);HEAP16[sa>>1]=family;HEAP32[sa+4>>2]=addr;HEAP16[sa+2>>1]=_htons(port);break;case 10:addr=__inet_pton6_raw(addr);HEAP32[sa>>2]=family;HEAP32[sa+8>>2]=addr[0];HEAP32[sa+12>>2]=addr[1];HEAP32[sa+16>>2]=addr[2];HEAP32[sa+20>>2]=addr[3];HEAP16[sa+2>>1]=_htons(port);HEAP32[sa+4>>2]=0;HEAP32[sa+24>>2]=0;break;default:return{errno:5}}return{}}function ___sys_socketcall(call,socketvararg){try{SYSCALLS.varargs=socketvararg;var getSocketFromFD=function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(8);return socket};var getSocketAddress=function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info};switch(call){case 1:{var domain=SYSCALLS.get(),type=SYSCALLS.get(),protocol=SYSCALLS.get();var sock=SOCKFS.createSocket(domain,type,protocol);return sock.stream.fd}case 2:{var sock=getSocketFromFD(),info=getSocketAddress();sock.sock_ops.bind(sock,info.addr,info.port);return 0}case 3:{var sock=getSocketFromFD(),info=getSocketAddress();sock.sock_ops.connect(sock,info.addr,info.port);return 0}case 4:{var sock=getSocketFromFD(),backlog=SYSCALLS.get();sock.sock_ops.listen(sock,backlog);return 0}case 5:{var sock=getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var newsock=sock.sock_ops.accept(sock);if(addr){var res=__write_sockaddr(addr,newsock.family,DNS.lookup_name(newsock.daddr),newsock.dport)}return newsock.stream.fd}case 6:{var sock=getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(sock.saddr||"0.0.0.0"),sock.sport);return 0}case 7:{var sock=getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();if(!sock.daddr){return-53}var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(sock.daddr),sock.dport);return 0}case 11:{var sock=getSocketFromFD(),message=SYSCALLS.get(),length=SYSCALLS.get(),flags=SYSCALLS.get(),dest=getSocketAddress(true);if(!dest){return FS.write(sock.stream,HEAP8,message,length)}else{return sock.sock_ops.sendmsg(sock,HEAP8,message,length,dest.addr,dest.port)}}case 12:{var sock=getSocketFromFD(),buf=SYSCALLS.get(),len=SYSCALLS.get(),flags=SYSCALLS.get(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var msg=sock.sock_ops.recvmsg(sock,len);if(!msg)return 0;if(addr){var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(msg.addr),msg.port)}HEAPU8.set(msg.buffer,buf);return msg.buffer.byteLength}case 14:{return-50}case 15:{var sock=getSocketFromFD(),level=SYSCALLS.get(),optname=SYSCALLS.get(),optval=SYSCALLS.get(),optlen=SYSCALLS.get();if(level===1){if(optname===4){HEAP32[optval>>2]=sock.error;HEAP32[optlen>>2]=4;sock.error=null;return 0}}return-50}case 16:{var sock=getSocketFromFD(),message=SYSCALLS.get(),flags=SYSCALLS.get();var iov=HEAP32[message+8>>2];var num=HEAP32[message+12>>2];var addr,port;var name=HEAP32[message>>2];var namelen=HEAP32[message+4>>2];if(name){var info=__read_sockaddr(name,namelen);if(info.errno)return-info.errno;port=info.port;addr=DNS.lookup_addr(info.addr)||info.addr}var total=0;for(var i=0;i<num;i++){total+=HEAP32[iov+(8*i+4)>>2]}var view=new Uint8Array(total);var offset=0;for(var i=0;i<num;i++){var iovbase=HEAP32[iov+(8*i+0)>>2];var iovlen=HEAP32[iov+(8*i+4)>>2];for(var j=0;j<iovlen;j++){view[offset++]=HEAP8[iovbase+j>>0]}}return sock.sock_ops.sendmsg(sock,view,0,total,addr,port)}case 17:{var sock=getSocketFromFD(),message=SYSCALLS.get(),flags=SYSCALLS.get();var iov=HEAP32[message+8>>2];var num=HEAP32[message+12>>2];var total=0;for(var i=0;i<num;i++){total+=HEAP32[iov+(8*i+4)>>2]}var msg=sock.sock_ops.recvmsg(sock,total);if(!msg)return 0;var name=HEAP32[message>>2];if(name){var res=__write_sockaddr(name,sock.family,DNS.lookup_name(msg.addr),msg.port)}var bytesRead=0;var bytesRemaining=msg.buffer.byteLength;for(var i=0;bytesRemaining>0&&i<num;i++){var iovbase=HEAP32[iov+(8*i+0)>>2];var iovlen=HEAP32[iov+(8*i+4)>>2];if(!iovlen){continue}var length=Math.min(iovlen,bytesRemaining);var buf=msg.buffer.subarray(bytesRead,bytesRead+length);HEAPU8.set(buf,iovbase+bytesRead);bytesRead+=length;bytesRemaining-=length}return bytesRead}default:{return-52}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall102(a0,a1){return ___sys_socketcall(a0,a1)}function ___sys_wait4(pid,wstart,options,rusage){try{abort("cannot wait on child processes")}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall114(a0,a1,a2,a3){return ___sys_wait4(a0,a1,a2,a3)}function ___sys_chdir(path){try{path=SYSCALLS.getStr(path);FS.chdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall12(a0){return ___sys_chdir(a0)}function ___sys_uname(buf){try{if(!buf)return-21;var layout={"__size__":390,"sysname":0,"nodename":65,"release":130,"version":195,"machine":260,"domainname":325};var copyString=function(element,value){var offset=layout[element];writeAsciiToMemory(value,buf+offset)};copyString("sysname","Emscripten");copyString("nodename","emscripten");copyString("release","1.0");copyString("version","#1");copyString("machine","x86-JS");return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall122(a0){return ___sys_uname(a0)}function ___sys__newselect(nfds,readfds,writefds,exceptfds,timeout){try{var total=0;var srcReadLow=readfds?HEAP32[readfds>>2]:0,srcReadHigh=readfds?HEAP32[readfds+4>>2]:0;var srcWriteLow=writefds?HEAP32[writefds>>2]:0,srcWriteHigh=writefds?HEAP32[writefds+4>>2]:0;var srcExceptLow=exceptfds?HEAP32[exceptfds>>2]:0,srcExceptHigh=exceptfds?HEAP32[exceptfds+4>>2]:0;var dstReadLow=0,dstReadHigh=0;var dstWriteLow=0,dstWriteHigh=0;var dstExceptLow=0,dstExceptHigh=0;var allLow=(readfds?HEAP32[readfds>>2]:0)|(writefds?HEAP32[writefds>>2]:0)|(exceptfds?HEAP32[exceptfds>>2]:0);var allHigh=(readfds?HEAP32[readfds+4>>2]:0)|(writefds?HEAP32[writefds+4>>2]:0)|(exceptfds?HEAP32[exceptfds+4>>2]:0);var check=function(fd,low,high,val){return fd<32?low&val:high&val};for(var fd=0;fd<nfds;fd++){var mask=1<<fd%32;if(!check(fd,allLow,allHigh,mask)){continue}var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(8);var flags=SYSCALLS.DEFAULT_POLLMASK;if(stream.stream_ops.poll){flags=stream.stream_ops.poll(stream)}if(flags&1&&check(fd,srcReadLow,srcReadHigh,mask)){fd<32?dstReadLow=dstReadLow|mask:dstReadHigh=dstReadHigh|mask;total++}if(flags&4&&check(fd,srcWriteLow,srcWriteHigh,mask)){fd<32?dstWriteLow=dstWriteLow|mask:dstWriteHigh=dstWriteHigh|mask;total++}if(flags&2&&check(fd,srcExceptLow,srcExceptHigh,mask)){fd<32?dstExceptLow=dstExceptLow|mask:dstExceptHigh=dstExceptHigh|mask;total++}}if(readfds){HEAP32[readfds>>2]=dstReadLow;HEAP32[readfds+4>>2]=dstReadHigh}if(writefds){HEAP32[writefds>>2]=dstWriteLow;HEAP32[writefds+4>>2]=dstWriteHigh}if(exceptfds){HEAP32[exceptfds>>2]=dstExceptLow;HEAP32[exceptfds+4>>2]=dstExceptHigh}return total}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall142(a0,a1,a2,a3,a4){return ___sys__newselect(a0,a1,a2,a3,a4)}function ___sys_chmod(path,mode){try{path=SYSCALLS.getStr(path);FS.chmod(path,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall15(a0,a1){return ___sys_chmod(a0,a1)}function ___sys_mremap(old_addr,old_size,new_size,flags){return-48}function ___syscall163(a0,a1,a2,a3,a4){return ___sys_mremap(a0,a1,a2,a3,a4)}function ___sys_poll(fds,nfds,timeout){try{var nonzero=0;for(var i=0;i<nfds;i++){var pollfd=fds+8*i;var fd=HEAP32[pollfd>>2];var events=HEAP16[pollfd+4>>1];var mask=32;var stream=FS.getStream(fd);if(stream){mask=SYSCALLS.DEFAULT_POLLMASK;if(stream.stream_ops.poll){mask=stream.stream_ops.poll(stream)}}mask&=events|8|16;if(mask)nonzero++;HEAP16[pollfd+6>>1]=mask}return nonzero}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall168(a0,a1,a2){return ___sys_poll(a0,a1,a2)}function ___sys_getcwd(buf,size){try{if(size===0)return-28;var cwd=FS.cwd();var cwdLengthInBytes=lengthBytesUTF8(cwd);if(size<cwdLengthInBytes+1)return-68;stringToUTF8(cwd,buf,size);return buf}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall183(a0,a1){return ___sys_getcwd(a0,a1)}function syscallMmap2(addr,len,prot,flags,fd,off){off<<=12;var ptr;var allocated=false;if((flags&16)!==0&&addr%16384!==0){return-28}if((flags&32)!==0){ptr=_memalign(16384,len);if(!ptr)return-48;_memset(ptr,0,len);allocated=true}else{var info=FS.getStream(fd);if(!info)return-8;var res=FS.mmap(info,addr,len,off,prot,flags);ptr=res.ptr;allocated=res.allocated}SYSCALLS.mappings[ptr]={malloc:ptr,len:len,allocated:allocated,fd:fd,prot:prot,flags:flags,offset:off};return ptr}function ___sys_mmap2(addr,len,prot,flags,fd,off){try{return syscallMmap2(addr,len,prot,flags,fd,off)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall192(a0,a1,a2,a3,a4,a5){return ___sys_mmap2(a0,a1,a2,a3,a4,a5)}function ___sys_ftruncate64(fd,zero,low,high){try{var length=SYSCALLS.get64(low,high);FS.ftruncate(fd,length);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall194(a0,a1,a2,a3){return ___sys_ftruncate64(a0,a1,a2,a3)}function ___sys_stat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall195(a0,a1){return ___sys_stat64(a0,a1)}function ___sys_lstat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.doStat(FS.lstat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall196(a0,a1){return ___sys_lstat64(a0,a1)}function ___sys_fstat64(fd,buf){try{var stream=SYSCALLS.getStreamFromFD(fd);return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall197(a0,a1){return ___sys_fstat64(a0,a1)}function ___sys_lchown32(path,owner,group){try{path=SYSCALLS.getStr(path);FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall198(a0,a1,a2){return ___sys_lchown32(a0,a1,a2)}function ___sys_getegid32(){return 0}function ___sys_getuid32(){return ___sys_getegid32()}function ___syscall199(){return ___sys_getuid32()}function ___sys_getpid(){return 42}function ___syscall20(){return ___sys_getpid()}function ___sys_getgid32(){return ___sys_getegid32()}function ___syscall200(){return ___sys_getgid32()}function ___sys_geteuid32(){return ___sys_getegid32()}function ___syscall201(){return ___sys_geteuid32()}function ___sys_getgroups32(size,list){if(size<1)return-28;HEAP32[list>>2]=0;return 1}function ___syscall205(a0,a1){return ___sys_getgroups32(a0,a1)}function ___sys_fchown32(fd,owner,group){try{FS.fchown(fd,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall207(a0,a1,a2){return ___sys_fchown32(a0,a1,a2)}function ___sys_chown32(path,owner,group){try{path=SYSCALLS.getStr(path);FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall212(a0,a1,a2){return ___sys_chown32(a0,a1,a2)}function ___sys_madvise1(addr,length,advice){return 0}function ___syscall219(a0,a1,a2){return ___sys_madvise1(a0,a1,a2)}function ___sys_getdents64(fd,dirp,count){try{var stream=SYSCALLS.getStreamFromFD(fd);if(!stream.getdents){stream.getdents=FS.readdir(stream.path)}var struct_size=280;var pos=0;var off=FS.llseek(stream,0,1);var idx=Math.floor(off/struct_size);while(idx<stream.getdents.length&&pos+struct_size<=count){var id;var type;var name=stream.getdents[idx];if(name[0]==="."){id=1;type=4}else{var child=FS.lookupNode(stream.node,name);id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}tempI64=[id>>>0,(tempDouble=id,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[dirp+pos>>2]=tempI64[0],HEAP32[dirp+pos+4>>2]=tempI64[1];tempI64=[(idx+1)*struct_size>>>0,(tempDouble=(idx+1)*struct_size,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[dirp+pos+8>>2]=tempI64[0],HEAP32[dirp+pos+12>>2]=tempI64[1];HEAP16[dirp+pos+16>>1]=280;HEAP8[dirp+pos+18>>0]=type;stringToUTF8(name,dirp+pos+19,256);pos+=struct_size;idx+=1}FS.llseek(stream,idx*struct_size,0);return pos}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall220(a0,a1,a2){return ___sys_getdents64(a0,a1,a2)}function ___sys_fcntl64(fd,cmd,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-28}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd}case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0}case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0}case 13:case 14:return 0;case 16:case 8:return-28;case 9:setErrNo(28);return-1;default:{return-28}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(a0,a1,a2){return ___sys_fcntl64(a0,a1,a2)}function ___sys_statfs64(path,size,buf){try{path=SYSCALLS.getStr(path);HEAP32[buf+4>>2]=4096;HEAP32[buf+40>>2]=4096;HEAP32[buf+8>>2]=1e6;HEAP32[buf+12>>2]=5e5;HEAP32[buf+16>>2]=5e5;HEAP32[buf+20>>2]=FS.nextInode;HEAP32[buf+24>>2]=1e6;HEAP32[buf+28>>2]=42;HEAP32[buf+44>>2]=2;HEAP32[buf+36>>2]=255;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall268(a0,a1,a2){return ___sys_statfs64(a0,a1,a2)}function ___sys_read(fd,buf,count){try{var stream=SYSCALLS.getStreamFromFD(fd);return FS.read(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall3(a0,a1,a2){return ___sys_read(a0,a1,a2)}function ___sys_access(path,amode){try{path=SYSCALLS.getStr(path);return SYSCALLS.doAccess(path,amode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall33(a0,a1){return ___sys_access(a0,a1)}function ___sys_nice(inc){return-63}function ___syscall34(a0){return ___sys_nice(a0)}function ___sys_rename(old_path,new_path){try{old_path=SYSCALLS.getStr(old_path);new_path=SYSCALLS.getStr(new_path);FS.rename(old_path,new_path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall38(a0,a1){return ___sys_rename(a0,a1)}function ___sys_mkdir(path,mode){try{path=SYSCALLS.getStr(path);return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall39(a0,a1){return ___sys_mkdir(a0,a1)}function ___sys_rmdir(path){try{path=SYSCALLS.getStr(path);FS.rmdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall40(a0){return ___sys_rmdir(a0)}function ___sys_dup(fd){try{var old=SYSCALLS.getStreamFromFD(fd);return FS.open(old.path,old.flags,0).fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall41(a0){return ___sys_dup(a0)}var PIPEFS={BUCKET_BUFFER_SIZE:8192,mount:function(mount){return FS.createNode(null,"/",16384|511,0)},createPipe:function(){var pipe={buckets:[]};pipe.buckets.push({buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:0,roffset:0});var rName=PIPEFS.nextname();var wName=PIPEFS.nextname();var rNode=FS.createNode(PIPEFS.root,rName,4096,0);var wNode=FS.createNode(PIPEFS.root,wName,4096,0);rNode.pipe=pipe;wNode.pipe=pipe;var readableStream=FS.createStream({path:rName,node:rNode,flags:FS.modeStringToFlags("r"),seekable:false,stream_ops:PIPEFS.stream_ops});rNode.stream=readableStream;var writableStream=FS.createStream({path:wName,node:wNode,flags:FS.modeStringToFlags("w"),seekable:false,stream_ops:PIPEFS.stream_ops});wNode.stream=writableStream;return{readable_fd:readableStream.fd,writable_fd:writableStream.fd}},stream_ops:{poll:function(stream){var pipe=stream.node.pipe;if((stream.flags&2097155)===1){return 256|4}else{if(pipe.buckets.length>0){for(var i=0;i<pipe.buckets.length;i++){var bucket=pipe.buckets[i];if(bucket.offset-bucket.roffset>0){return 64|1}}}}return 0},ioctl:function(stream,request,varargs){return ERRNO_CODES.EINVAL},fsync:function(stream){return ERRNO_CODES.EINVAL},read:function(stream,buffer,offset,length,position){var pipe=stream.node.pipe;var currentLength=0;for(var i=0;i<pipe.buckets.length;i++){var bucket=pipe.buckets[i];currentLength+=bucket.offset-bucket.roffset}assert(buffer instanceof ArrayBuffer||ArrayBuffer.isView(buffer));var data=buffer.subarray(offset,offset+length);if(length<=0){return 0}if(currentLength==0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}var toRead=Math.min(currentLength,length);var totalRead=toRead;var toRemove=0;for(var i=0;i<pipe.buckets.length;i++){var currBucket=pipe.buckets[i];var bucketSize=currBucket.offset-currBucket.roffset;if(toRead<=bucketSize){var tmpSlice=currBucket.buffer.subarray(currBucket.roffset,currBucket.offset);if(toRead<bucketSize){tmpSlice=tmpSlice.subarray(0,toRead);currBucket.roffset+=toRead}else{toRemove++}data.set(tmpSlice);break}else{var tmpSlice=currBucket.buffer.subarray(currBucket.roffset,currBucket.offset);data.set(tmpSlice);data=data.subarray(tmpSlice.byteLength);toRead-=tmpSlice.byteLength;toRemove++}}if(toRemove&&toRemove==pipe.buckets.length){toRemove--;pipe.buckets[toRemove].offset=0;pipe.buckets[toRemove].roffset=0}pipe.buckets.splice(0,toRemove);return totalRead},write:function(stream,buffer,offset,length,position){var pipe=stream.node.pipe;assert(buffer instanceof ArrayBuffer||ArrayBuffer.isView(buffer));var data=buffer.subarray(offset,offset+length);var dataLen=data.byteLength;if(dataLen<=0){return 0}var currBucket=null;if(pipe.buckets.length==0){currBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:0,roffset:0};pipe.buckets.push(currBucket)}else{currBucket=pipe.buckets[pipe.buckets.length-1]}assert(currBucket.offset<=PIPEFS.BUCKET_BUFFER_SIZE);var freeBytesInCurrBuffer=PIPEFS.BUCKET_BUFFER_SIZE-currBucket.offset;if(freeBytesInCurrBuffer>=dataLen){currBucket.buffer.set(data,currBucket.offset);currBucket.offset+=dataLen;return dataLen}else if(freeBytesInCurrBuffer>0){currBucket.buffer.set(data.subarray(0,freeBytesInCurrBuffer),currBucket.offset);currBucket.offset+=freeBytesInCurrBuffer;data=data.subarray(freeBytesInCurrBuffer,data.byteLength)}var numBuckets=data.byteLength/PIPEFS.BUCKET_BUFFER_SIZE|0;var remElements=data.byteLength%PIPEFS.BUCKET_BUFFER_SIZE;for(var i=0;i<numBuckets;i++){var newBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:PIPEFS.BUCKET_BUFFER_SIZE,roffset:0};pipe.buckets.push(newBucket);newBucket.buffer.set(data.subarray(0,PIPEFS.BUCKET_BUFFER_SIZE));data=data.subarray(PIPEFS.BUCKET_BUFFER_SIZE,data.byteLength)}if(remElements>0){var newBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:data.byteLength,roffset:0};pipe.buckets.push(newBucket);newBucket.buffer.set(data)}return dataLen},close:function(stream){var pipe=stream.node.pipe;pipe.buckets=null}},nextname:function(){if(!PIPEFS.nextname.current){PIPEFS.nextname.current=0}return"pipe["+PIPEFS.nextname.current+++"]"}};function ___sys_pipe(fdPtr){try{if(fdPtr==0){throw new FS.ErrnoError(21)}var res=PIPEFS.createPipe();HEAP32[fdPtr>>2]=res.readable_fd;HEAP32[fdPtr+4>>2]=res.writable_fd;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall42(a0){return ___sys_pipe(a0)}function ___sys_open(path,flags,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(path);var mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(a0,a1,a2){return ___sys_open(a0,a1,a2)}function ___sys_ioctl(fd,op,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(op){case 21509:case 21505:{if(!stream.tty)return-59;return 0}case 21510:case 21511:case 21512:case 21506:case 21507:case 21508:{if(!stream.tty)return-59;return 0}case 21519:{if(!stream.tty)return-59;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0}case 21520:{if(!stream.tty)return-59;return-28}case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)}case 21523:{if(!stream.tty)return-59;return 0}case 21524:{if(!stream.tty)return-59;return 0}default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(a0,a1,a2){return ___sys_ioctl(a0,a1,a2)}function ___sys_umask(mask){try{var old=SYSCALLS.umask;SYSCALLS.umask=mask;return old}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall60(a0){return ___sys_umask(a0)}function ___sys_dup2(oldfd,suggestFD){try{var old=SYSCALLS.getStreamFromFD(oldfd);if(old.fd===suggestFD)return suggestFD;return SYSCALLS.doDup(old.path,old.flags,suggestFD)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall63(a0,a1){return ___sys_dup2(a0,a1)}function ___sys_getrusage(who,usage){try{_memset(usage,0,136);HEAP32[usage>>2]=1;HEAP32[usage+4>>2]=2;HEAP32[usage+8>>2]=3;HEAP32[usage+12>>2]=4;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall77(a0,a1){return ___sys_getrusage(a0,a1)}function ___sys_symlink(target,linkpath){try{target=SYSCALLS.getStr(target);linkpath=SYSCALLS.getStr(linkpath);FS.symlink(target,linkpath);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall83(a0,a1){return ___sys_symlink(a0,a1)}function ___sys_readlink(path,buf,bufsize){try{path=SYSCALLS.getStr(path);return SYSCALLS.doReadlink(path,buf,bufsize)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall85(a0,a1,a2){return ___sys_readlink(a0,a1,a2)}function ___sys_link(oldpath,newpath){return-34}function ___syscall9(a0,a1){return ___sys_link(a0,a1)}function syscallMunmap(addr,len){if((addr|0)===-1||len===0){return-28}var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);if(info.prot&2){SYSCALLS.doMsync(addr,stream,len,info.flags,info.offset)}FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}function ___sys_munmap(addr,len){try{return syscallMunmap(addr,len)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall91(a0,a1){return ___sys_munmap(a0,a1)}function ___sys_fchmod(fd,mode){try{FS.fchmod(fd,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall94(a0,a1){return ___sys_fchmod(a0,a1)}function _fd_close(fd){try{var stream=SYSCALLS.getStreamFromFD(fd);FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_close(a0){return _fd_close(a0)}function _fd_fdstat_get(fd,pbuf){try{var stream=SYSCALLS.getStreamFromFD(fd);var type=stream.tty?2:FS.isDir(stream.mode)?3:FS.isLink(stream.mode)?7:4;HEAP8[pbuf>>0]=type;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_fdstat_get(a0,a1){return _fd_fdstat_get(a0,a1)}function _fd_read(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=SYSCALLS.doReadv(stream,iov,iovcnt);HEAP32[pnum>>2]=num;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_read(a0,a1,a2,a3){return _fd_read(a0,a1,a2,a3)}function _fd_seek(fd,offset_low,offset_high,whence,newOffset){try{var stream=SYSCALLS.getStreamFromFD(fd);var HIGH_OFFSET=4294967296;var offset=offset_high*HIGH_OFFSET+(offset_low>>>0);var DOUBLE_LIMIT=9007199254740992;if(offset<=-DOUBLE_LIMIT||offset>=DOUBLE_LIMIT){return-61}FS.llseek(stream,offset,whence);tempI64=[stream.position>>>0,(tempDouble=stream.position,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[newOffset>>2]=tempI64[0],HEAP32[newOffset+4>>2]=tempI64[1];if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_seek(a0,a1,a2,a3,a4){return _fd_seek(a0,a1,a2,a3,a4)}function _fd_sync(fd){try{var stream=SYSCALLS.getStreamFromFD(fd);if(stream.stream_ops&&stream.stream_ops.fsync){return-stream.stream_ops.fsync(stream)}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_sync(a0){return _fd_sync(a0)}function _fd_write(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=SYSCALLS.doWritev(stream,iov,iovcnt);HEAP32[pnum>>2]=num;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return e.errno}}function ___wasi_fd_write(a0,a1,a2,a3){return _fd_write(a0,a1,a2,a3)}function _exit(status){exit(status)}function __exit(a0){return _exit(a0)}function _abort(){abort()}function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[__get_timezone()>>2]=(new Date).getTimezoneOffset()*60;var currentYear=(new Date).getFullYear();var winter=new Date(currentYear,0,1);var summer=new Date(currentYear,6,1);HEAP32[__get_daylight()>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());function extractZone(date){var match=date.toTimeString().match(/\(([A-Za-z ]+)\)$/);return match?match[1]:"GMT"}var winterName=extractZone(winter);var summerName=extractZone(summer);var winterNamePtr=allocateUTF8(winterName);var summerNamePtr=allocateUTF8(summerName);if(summer.getTimezoneOffset()<winter.getTimezoneOffset()){HEAP32[__get_tzname()>>2]=winterNamePtr;HEAP32[__get_tzname()+4>>2]=summerNamePtr}else{HEAP32[__get_tzname()>>2]=summerNamePtr;HEAP32[__get_tzname()+4>>2]=winterNamePtr}}function _mktime(tmPtr){_tzset();var date=new Date(HEAP32[tmPtr+20>>2]+1900,HEAP32[tmPtr+16>>2],HEAP32[tmPtr+12>>2],HEAP32[tmPtr+8>>2],HEAP32[tmPtr+4>>2],HEAP32[tmPtr>>2],0);var dst=HEAP32[tmPtr+32>>2];var guessedOffset=date.getTimezoneOffset();var start=new Date(date.getFullYear(),0,1);var summerOffset=new Date(date.getFullYear(),6,1).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dstOffset=Math.min(winterOffset,summerOffset);if(dst<0){HEAP32[tmPtr+32>>2]=Number(summerOffset!=winterOffset&&dstOffset==guessedOffset)}else if(dst>0!=(dstOffset==guessedOffset)){var nonDstOffset=Math.max(winterOffset,summerOffset);var trueOffset=dst>0?dstOffset:nonDstOffset;date.setTime(date.getTime()+(trueOffset-guessedOffset)*6e4)}HEAP32[tmPtr+24>>2]=date.getDay();var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;return date.getTime()/1e3|0}function _asctime_r(tmPtr,buf){var date={tm_sec:HEAP32[tmPtr>>2],tm_min:HEAP32[tmPtr+4>>2],tm_hour:HEAP32[tmPtr+8>>2],tm_mday:HEAP32[tmPtr+12>>2],tm_mon:HEAP32[tmPtr+16>>2],tm_year:HEAP32[tmPtr+20>>2],tm_wday:HEAP32[tmPtr+24>>2]};var days=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];var months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];var s=days[date.tm_wday]+" "+months[date.tm_mon]+(date.tm_mday<10?"  ":" ")+date.tm_mday+(date.tm_hour<10?" 0":" ")+date.tm_hour+(date.tm_min<10?":0":":")+date.tm_min+(date.tm_sec<10?":0":":")+date.tm_sec+" "+(1900+date.tm_year)+"\n";stringToUTF8(s,buf,26);return buf}function _chroot(path){setErrNo(2);return-1}function _difftime(time1,time0){return time1-time0}function _dlclose(handle){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking")}function _dlerror(){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking")}function _dlopen(filename,flag){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking")}function _dlsym(handle,symbol){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/emscripten-core/emscripten/wiki/Linking")}function _emscripten_get_heap_size(){return HEAPU8.length}function emscripten_realloc_buffer(size){try{wasmMemory.grow(size-buffer.byteLength+65535>>>16);updateGlobalBufferAndViews(wasmMemory.buffer);return 1}catch(e){}}function _emscripten_resize_heap(requestedSize){requestedSize=requestedSize>>>0;var oldSize=_emscripten_get_heap_size();var PAGE_MULTIPLE=65536;var maxHeapSize=2147483648-PAGE_MULTIPLE;if(requestedSize>maxHeapSize){return false}var minHeapSize=16777216;for(var cutDown=1;cutDown<=4;cutDown*=2){var overGrownHeapSize=oldSize*(1+.2/cutDown);overGrownHeapSize=Math.min(overGrownHeapSize,requestedSize+100663296);var newSize=Math.min(maxHeapSize,alignUp(Math.max(minHeapSize,requestedSize,overGrownHeapSize),PAGE_MULTIPLE));var replacement=emscripten_realloc_buffer(newSize);if(replacement){return true}}return false}function _execl(path,arg0,varArgs){setErrNo(45);return-1}function _execle(a0,a1,a2){return _execl(a0,a1,a2)}function _execvp(a0,a1,a2){return _execl(a0,a1,a2)}function _flock(fd,operation){return 0}function _fork(){setErrNo(6);return-1}var GAI_ERRNO_MESSAGES={};function _gai_strerror(val){var buflen=256;if(!_gai_strerror.buffer){_gai_strerror.buffer=_malloc(buflen);GAI_ERRNO_MESSAGES["0"]="Success";GAI_ERRNO_MESSAGES[""+-1]="Invalid value for 'ai_flags' field";GAI_ERRNO_MESSAGES[""+-2]="NAME or SERVICE is unknown";GAI_ERRNO_MESSAGES[""+-3]="Temporary failure in name resolution";GAI_ERRNO_MESSAGES[""+-4]="Non-recoverable failure in name res";GAI_ERRNO_MESSAGES[""+-6]="'ai_family' not supported";GAI_ERRNO_MESSAGES[""+-7]="'ai_socktype' not supported";GAI_ERRNO_MESSAGES[""+-8]="SERVICE not supported for 'ai_socktype'";GAI_ERRNO_MESSAGES[""+-10]="Memory allocation failure";GAI_ERRNO_MESSAGES[""+-11]="System error returned in 'errno'";GAI_ERRNO_MESSAGES[""+-12]="Argument buffer overflow"}var msg="Unknown error";if(val in GAI_ERRNO_MESSAGES){if(GAI_ERRNO_MESSAGES[val].length>buflen-1){msg="Message too long"}else{msg=GAI_ERRNO_MESSAGES[val]}}writeAsciiToMemory(msg,_gai_strerror.buffer);return _gai_strerror.buffer}function _getaddrinfo(node,service,hint,out){var addr=0;var port=0;var flags=0;var family=0;var type=0;var proto=0;var ai;function allocaddrinfo(family,type,proto,canon,addr,port){var sa,salen,ai;var res;salen=family===10?28:16;addr=family===10?__inet_ntop6_raw(addr):__inet_ntop4_raw(addr);sa=_malloc(salen);res=__write_sockaddr(sa,family,addr,port);assert(!res.errno);ai=_malloc(32);HEAP32[ai+4>>2]=family;HEAP32[ai+8>>2]=type;HEAP32[ai+12>>2]=proto;HEAP32[ai+24>>2]=canon;HEAP32[ai+20>>2]=sa;if(family===10){HEAP32[ai+16>>2]=28}else{HEAP32[ai+16>>2]=16}HEAP32[ai+28>>2]=0;return ai}if(hint){flags=HEAP32[hint>>2];family=HEAP32[hint+4>>2];type=HEAP32[hint+8>>2];proto=HEAP32[hint+12>>2]}if(type&&!proto){proto=type===2?17:6}if(!type&&proto){type=proto===17?2:1}if(proto===0){proto=6}if(type===0){type=1}if(!node&&!service){return-2}if(flags&~(1|2|4|1024|8|16|32)){return-1}if(hint!==0&&HEAP32[hint>>2]&2&&!node){return-1}if(flags&32){return-2}if(type!==0&&type!==1&&type!==2){return-7}if(family!==0&&family!==2&&family!==10){return-6}if(service){service=UTF8ToString(service);port=parseInt(service,10);if(isNaN(port)){if(flags&1024){return-2}return-8}}if(!node){if(family===0){family=2}if((flags&1)===0){if(family===2){addr=_htonl(2130706433)}else{addr=[0,0,0,1]}}ai=allocaddrinfo(family,type,proto,null,addr,port);HEAP32[out>>2]=ai;return 0}node=UTF8ToString(node);addr=__inet_pton4_raw(node);if(addr!==null){if(family===0||family===2){family=2}else if(family===10&&flags&8){addr=[0,0,_htonl(65535),addr];family=10}else{return-2}}else{addr=__inet_pton6_raw(node);if(addr!==null){if(family===0||family===10){family=10}else{return-2}}}if(addr!=null){ai=allocaddrinfo(family,type,proto,node,addr,port);HEAP32[out>>2]=ai;return 0}if(flags&4){return-2}node=DNS.lookup_name(node);addr=__inet_pton4_raw(node);if(family===0){family=2}else if(family===10){addr=[0,0,_htonl(65535),addr]}ai=allocaddrinfo(family,type,proto,null,addr,port);HEAP32[out>>2]=ai;return 0}function _getdtablesize(){err("missing function: getdtablesize");abort(-1)}function _getenv(name){if(name===0)return 0;name=UTF8ToString(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocateUTF8(ENV[name]);return _getenv.ret}function _getgrnam(){throw"getgrnam: TODO"}function _gethostbyname(name){name=UTF8ToString(name);var ret=_malloc(20);var nameBuf=_malloc(name.length+1);stringToUTF8(name,nameBuf,name.length+1);HEAP32[ret>>2]=nameBuf;var aliasesBuf=_malloc(4);HEAP32[aliasesBuf>>2]=0;HEAP32[ret+4>>2]=aliasesBuf;var afinet=2;HEAP32[ret+8>>2]=afinet;HEAP32[ret+12>>2]=4;var addrListBuf=_malloc(12);HEAP32[addrListBuf>>2]=addrListBuf+8;HEAP32[addrListBuf+4>>2]=0;HEAP32[addrListBuf+8>>2]=__inet_pton4_raw(DNS.lookup_name(name));HEAP32[ret+16>>2]=addrListBuf;return ret}function _gethostbyaddr(addr,addrlen,type){if(type!==2){setErrNo(5);return null}addr=HEAP32[addr>>2];var host=__inet_ntop4_raw(addr);var lookup=DNS.lookup_addr(host);if(lookup){host=lookup}var hostp=allocate(intArrayFromString(host),"i8",ALLOC_STACK);return _gethostbyname(hostp)}function _gethostbyname_r(name,ret,buf,buflen,out,err){var data=_gethostbyname(name);_memcpy(ret,data,20);_free(data);HEAP32[err>>2]=0;HEAP32[out>>2]=ret;return 0}function _getloadavg(loadavg,nelem){var limit=Math.min(nelem,3);var doubleSize=8;for(var i=0;i<limit;i++){HEAPF64[loadavg+i*doubleSize>>3]=.1}return limit}var Protocols={list:[],map:{}};function _setprotoent(stayopen){function allocprotoent(name,proto,aliases){var nameBuf=_malloc(name.length+1);writeAsciiToMemory(name,nameBuf);var j=0;var length=aliases.length;var aliasListBuf=_malloc((length+1)*4);for(var i=0;i<length;i++,j+=4){var alias=aliases[i];var aliasBuf=_malloc(alias.length+1);writeAsciiToMemory(alias,aliasBuf);HEAP32[aliasListBuf+j>>2]=aliasBuf}HEAP32[aliasListBuf+j>>2]=0;var pe=_malloc(12);HEAP32[pe>>2]=nameBuf;HEAP32[pe+4>>2]=aliasListBuf;HEAP32[pe+8>>2]=proto;return pe}var list=Protocols.list;var map=Protocols.map;if(list.length===0){var entry=allocprotoent("tcp",6,["TCP"]);list.push(entry);map["tcp"]=map["6"]=entry;entry=allocprotoent("udp",17,["UDP"]);list.push(entry);map["udp"]=map["17"]=entry}_setprotoent.index=0}function _getprotobyname(name){name=UTF8ToString(name);_setprotoent(true);var result=Protocols.map[name];return result}function _getprotobynumber(number){_setprotoent(true);var result=Protocols.map[number];return result}function _getpwnam(){throw"getpwnam: TODO"}function _getpwuid(){throw"getpwuid: TODO"}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}var ___tm_timezone=(stringToUTF8("GMT",2505792,4),2505792);function _gmtime_r(time,tmPtr){var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getUTCSeconds();HEAP32[tmPtr+4>>2]=date.getUTCMinutes();HEAP32[tmPtr+8>>2]=date.getUTCHours();HEAP32[tmPtr+12>>2]=date.getUTCDate();HEAP32[tmPtr+16>>2]=date.getUTCMonth();HEAP32[tmPtr+20>>2]=date.getUTCFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getUTCDay();HEAP32[tmPtr+36>>2]=0;HEAP32[tmPtr+32>>2]=0;var start=Date.UTC(date.getUTCFullYear(),0,1,0,0,0,0);var yday=(date.getTime()-start)/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+40>>2]=___tm_timezone;return tmPtr}function _kill(pid,sig){setErrNo(ERRNO_CODES.EPERM);return-1}function _llvm_log10_f32(x){return Math.log(x)/Math.LN10}function _llvm_log10_f64(a0){return _llvm_log10_f32(a0)}function _llvm_stackrestore(p){var self=_llvm_stacksave;var ret=self.LLVM_SAVEDSTACKS[p];self.LLVM_SAVEDSTACKS.splice(p,1);stackRestore(ret)}function _llvm_stacksave(){var self=_llvm_stacksave;if(!self.LLVM_SAVEDSTACKS){self.LLVM_SAVEDSTACKS=[]}self.LLVM_SAVEDSTACKS.push(stackSave());return self.LLVM_SAVEDSTACKS.length-1}function _llvm_trap(){abort("trap!")}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var summerOffset=new Date(date.getFullYear(),6,1).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=(summerOffset!=winterOffset&&date.getTimezoneOffset()==Math.min(winterOffset,summerOffset))|0;HEAP32[tmPtr+32>>2]=dst;var zonePtr=HEAP32[__get_tzname()+(dst?4:0)>>2];HEAP32[tmPtr+40>>2]=zonePtr;return tmPtr}function _longjmp(env,value){_setThrew(env,value||1);throw"longjmp"}function _emscripten_memcpy_big(dest,src,num){HEAPU8.copyWithin(dest,src,src+num)}function _usleep(useconds){var start=_emscripten_get_now();while(_emscripten_get_now()-start<useconds/1e3){}}Module["_usleep"]=_usleep;function _nanosleep(rqtp,rmtp){if(rqtp===0){setErrNo(28);return-1}var seconds=HEAP32[rqtp>>2];var nanoseconds=HEAP32[rqtp+4>>2];if(nanoseconds<0||nanoseconds>999999999||seconds<0){setErrNo(28);return-1}if(rmtp!==0){HEAP32[rmtp>>2]=0;HEAP32[rmtp+4>>2]=0}return _usleep(seconds*1e6+nanoseconds/1e3)}function _popen(){err("missing function: popen");abort(-1)}function _pthread_create(){return 6}function _pthread_join(){}function _pthread_mutexattr_destroy(){}function _pthread_mutexattr_init(){}function _pthread_mutexattr_settype(){}function _pthread_setcancelstate(){return 0}function _putenv(string){if(string===0){setErrNo(28);return-1}string=UTF8ToString(string);var splitPoint=string.indexOf("=");if(string===""||string.indexOf("=")===-1){setErrNo(28);return-1}var name=string.slice(0,splitPoint);var value=string.slice(splitPoint+1);if(!(name in ENV)||ENV[name]!==value){ENV[name]=value;___buildEnvironment(__get_environ())}return 0}function _setTempRet0($i){setTempRet0($i|0)}function _setitimer(){throw"setitimer() is not implemented yet"}function _sigaction(signum,act,oldact){return 0}function _sigaddset(set,signum){HEAP32[set>>2]=HEAP32[set>>2]|1<<signum-1;return 0}function _sigdelset(set,signum){HEAP32[set>>2]=HEAP32[set>>2]&~(1<<signum-1);return 0}function _sigemptyset(set){HEAP32[set>>2]=0;return 0}function _sigfillset(set){HEAP32[set>>2]=-1>>>0;return 0}var __sigalrm_handler=0;function _signal(sig,func){if(sig==14){__sigalrm_handler=func}else{}return 0}function _sigprocmask(){return 0}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]){}return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?UTF8ToString(tm_zone):""};var pattern=UTF8ToString(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":function(date){return WEEKDAYS[date.tm_wday].substring(0,3)},"%A":function(date){return WEEKDAYS[date.tm_wday]},"%b":function(date){return MONTHS[date.tm_mon].substring(0,3)},"%B":function(date){return MONTHS[date.tm_mon]},"%C":function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)},"%d":function(date){return leadingNulls(date.tm_mday,2)},"%e":function(date){return leadingSomething(date.tm_mday,2," ")},"%g":function(date){return getWeekBasedYear(date).toString().substring(2)},"%G":function(date){return getWeekBasedYear(date)},"%H":function(date){return leadingNulls(date.tm_hour,2)},"%I":function(date){var twelveHour=date.tm_hour;if(twelveHour==0)twelveHour=12;else if(twelveHour>12)twelveHour-=12;return leadingNulls(twelveHour,2)},"%j":function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)},"%m":function(date){return leadingNulls(date.tm_mon+1,2)},"%M":function(date){return leadingNulls(date.tm_min,2)},"%n":function(){return"\n"},"%p":function(date){if(date.tm_hour>=0&&date.tm_hour<12){return"AM"}else{return"PM"}},"%S":function(date){return leadingNulls(date.tm_sec,2)},"%t":function(){return"\t"},"%u":function(date){return date.tm_wday||7},"%U":function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"},"%V":function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)},"%w":function(date){return date.tm_wday},"%W":function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"},"%y":function(date){return(date.tm_year+1900).toString().substring(2)},"%Y":function(date){return date.tm_year+1900},"%z":function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)},"%Z":function(date){return date.tm_zone},"%%":function(){return"%"}};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strptime(buf,format,tm){var pattern=UTF8ToString(format);var SPECIAL_CHARS="\\!@#$^&*()+=-[]/{}|:<>?,.";for(var i=0,ii=SPECIAL_CHARS.length;i<ii;++i){pattern=pattern.replace(new RegExp("\\"+SPECIAL_CHARS[i],"g"),"\\"+SPECIAL_CHARS[i])}var EQUIVALENT_MATCHERS={"%A":"%a","%B":"%b","%c":"%a %b %d %H:%M:%S %Y","%D":"%m\\/%d\\/%y","%e":"%d","%F":"%Y-%m-%d","%h":"%b","%R":"%H\\:%M","%r":"%I\\:%M\\:%S\\s%p","%T":"%H\\:%M\\:%S","%x":"%m\\/%d\\/(?:%y|%Y)","%X":"%H\\:%M\\:%S"};for(var matcher in EQUIVALENT_MATCHERS){pattern=pattern.replace(matcher,EQUIVALENT_MATCHERS[matcher])}var DATE_PATTERNS={"%a":"(?:Sun(?:day)?)|(?:Mon(?:day)?)|(?:Tue(?:sday)?)|(?:Wed(?:nesday)?)|(?:Thu(?:rsday)?)|(?:Fri(?:day)?)|(?:Sat(?:urday)?)","%b":"(?:Jan(?:uary)?)|(?:Feb(?:ruary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|May|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)","%C":"\\d\\d","%d":"0[1-9]|[1-9](?!\\d)|1\\d|2\\d|30|31","%H":"\\d(?!\\d)|[0,1]\\d|20|21|22|23","%I":"\\d(?!\\d)|0\\d|10|11|12","%j":"00[1-9]|0?[1-9](?!\\d)|0?[1-9]\\d(?!\\d)|[1,2]\\d\\d|3[0-6]\\d","%m":"0[1-9]|[1-9](?!\\d)|10|11|12","%M":"0\\d|\\d(?!\\d)|[1-5]\\d","%n":"\\s","%p":"AM|am|PM|pm|A\\.M\\.|a\\.m\\.|P\\.M\\.|p\\.m\\.","%S":"0\\d|\\d(?!\\d)|[1-5]\\d|60","%U":"0\\d|\\d(?!\\d)|[1-4]\\d|50|51|52|53","%W":"0\\d|\\d(?!\\d)|[1-4]\\d|50|51|52|53","%w":"[0-6]","%y":"\\d\\d","%Y":"\\d\\d\\d\\d","%%":"%","%t":"\\s"};var MONTH_NUMBERS={JAN:0,FEB:1,MAR:2,APR:3,MAY:4,JUN:5,JUL:6,AUG:7,SEP:8,OCT:9,NOV:10,DEC:11};var DAY_NUMBERS_SUN_FIRST={SUN:0,MON:1,TUE:2,WED:3,THU:4,FRI:5,SAT:6};var DAY_NUMBERS_MON_FIRST={MON:0,TUE:1,WED:2,THU:3,FRI:4,SAT:5,SUN:6};for(var datePattern in DATE_PATTERNS){pattern=pattern.replace(datePattern,"("+datePattern+DATE_PATTERNS[datePattern]+")")}var capture=[];for(var i=pattern.indexOf("%");i>=0;i=pattern.indexOf("%")){capture.push(pattern[i+1]);pattern=pattern.replace(new RegExp("\\%"+pattern[i+1],"g"),"")}var matches=new RegExp("^"+pattern,"i").exec(UTF8ToString(buf));function initDate(){function fixup(value,min,max){return typeof value!=="number"||isNaN(value)?min:value>=min?value<=max?value:max:min}return{year:fixup(HEAP32[tm+20>>2]+1900,1970,9999),month:fixup(HEAP32[tm+16>>2],0,11),day:fixup(HEAP32[tm+12>>2],1,31),hour:fixup(HEAP32[tm+8>>2],0,23),min:fixup(HEAP32[tm+4>>2],0,59),sec:fixup(HEAP32[tm>>2],0,59)}}if(matches){var date=initDate();var value;var getMatch=function(symbol){var pos=capture.indexOf(symbol);if(pos>=0){return matches[pos+1]}return};if(value=getMatch("S")){date.sec=jstoi_q(value)}if(value=getMatch("M")){date.min=jstoi_q(value)}if(value=getMatch("H")){date.hour=jstoi_q(value)}else if(value=getMatch("I")){var hour=jstoi_q(value);if(value=getMatch("p")){hour+=value.toUpperCase()[0]==="P"?12:0}date.hour=hour}if(value=getMatch("Y")){date.year=jstoi_q(value)}else if(value=getMatch("y")){var year=jstoi_q(value);if(value=getMatch("C")){year+=jstoi_q(value)*100}else{year+=year<69?2e3:1900}date.year=year}if(value=getMatch("m")){date.month=jstoi_q(value)-1}else if(value=getMatch("b")){date.month=MONTH_NUMBERS[value.substring(0,3).toUpperCase()]||0}if(value=getMatch("d")){date.day=jstoi_q(value)}else if(value=getMatch("j")){var day=jstoi_q(value);var leapYear=__isLeapYear(date.year);for(var month=0;month<12;++month){var daysUntilMonth=__arraySum(leapYear?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,month-1);if(day<=daysUntilMonth+(leapYear?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[month]){date.day=day-daysUntilMonth}}}else if(value=getMatch("a")){var weekDay=value.substring(0,3).toUpperCase();if(value=getMatch("U")){var weekDayNumber=DAY_NUMBERS_SUN_FIRST[weekDay];var weekNumber=jstoi_q(value);var janFirst=new Date(date.year,0,1);var endDate;if(janFirst.getDay()===0){endDate=__addDays(janFirst,weekDayNumber+7*(weekNumber-1))}else{endDate=__addDays(janFirst,7-janFirst.getDay()+weekDayNumber+7*(weekNumber-1))}date.day=endDate.getDate();date.month=endDate.getMonth()}else if(value=getMatch("W")){var weekDayNumber=DAY_NUMBERS_MON_FIRST[weekDay];var weekNumber=jstoi_q(value);var janFirst=new Date(date.year,0,1);var endDate;if(janFirst.getDay()===1){endDate=__addDays(janFirst,weekDayNumber+7*(weekNumber-1))}else{endDate=__addDays(janFirst,7-janFirst.getDay()+1+weekDayNumber+7*(weekNumber-1))}date.day=endDate.getDate();date.month=endDate.getMonth()}}var fullDate=new Date(date.year,date.month,date.day,date.hour,date.min,date.sec,0);HEAP32[tm>>2]=fullDate.getSeconds();HEAP32[tm+4>>2]=fullDate.getMinutes();HEAP32[tm+8>>2]=fullDate.getHours();HEAP32[tm+12>>2]=fullDate.getDate();HEAP32[tm+16>>2]=fullDate.getMonth();HEAP32[tm+20>>2]=fullDate.getFullYear()-1900;HEAP32[tm+24>>2]=fullDate.getDay();HEAP32[tm+28>>2]=__arraySum(__isLeapYear(fullDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,fullDate.getMonth()-1)+fullDate.getDate()-1;HEAP32[tm+32>>2]=0;return buf+intArrayFromString(matches[0]).length-1}return 0}function _sysconf(name){switch(name){case 30:return 16384;case 85:var maxHeapSize=4*1024*1024*1024;return maxHeapSize/16384;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:case 79:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}setErrNo(28);return-1}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _unsetenv(name){if(name===0){setErrNo(28);return-1}name=UTF8ToString(name);if(name===""||name.indexOf("=")!==-1){setErrNo(28);return-1}if(ENV.hasOwnProperty(name)){delete ENV[name];___buildEnvironment(__get_environ())}return 0}function _utime(path,times){var time;if(times){var offset=4;time=HEAP32[times+offset>>2];time*=1e3}else{time=Date.now()}path=UTF8ToString(path);try{FS.utime(path,time,time);return 0}catch(e){FS.handleFSError(e);return-1}}function _wait(stat_loc){setErrNo(12);return-1}function _waitpid(a0){return _wait(a0)}var FSNode=function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev};var readMode=292|73;var writeMode=146;Object.defineProperties(FSNode.prototype,{read:{get:function(){return(this.mode&readMode)===readMode},set:function(val){val?this.mode|=readMode:this.mode&=~readMode}},write:{get:function(){return(this.mode&writeMode)===writeMode},set:function(val){val?this.mode|=writeMode:this.mode&=~writeMode}},isFolder:{get:function(){return FS.isDir(this.mode)}},isDevice:{get:function(){return FS.isChrdev(this.mode)}}});FS.FSNode=FSNode;FS.staticInit();Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function invoke_i(index){var sp=stackSave();try{return dynCall_i(index)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_ii(index,a1){var sp=stackSave();try{return dynCall_ii(index,a1)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_iii(index,a1,a2){var sp=stackSave();try{return dynCall_iii(index,a1,a2)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_iiii(index,a1,a2,a3){var sp=stackSave();try{return dynCall_iiii(index,a1,a2,a3)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){var sp=stackSave();try{return dynCall_iiiii(index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return dynCall_iiiiii(index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return dynCall_iiiiiii(index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_v(index){var sp=stackSave();try{dynCall_v(index)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_vi(index,a1){var sp=stackSave();try{dynCall_vi(index,a1)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_vii(index,a1,a2){var sp=stackSave();try{dynCall_vii(index,a1,a2)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_viii(index,a1,a2,a3){var sp=stackSave();try{dynCall_viii(index,a1,a2,a3)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}function invoke_viiii(index,a1,a2,a3,a4){var sp=stackSave();try{dynCall_viiii(index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(e!==e+0&&e!=="longjmp")throw e;_setThrew(1,0)}}var asmGlobalArg={};var asmLibraryArg={"J":___assert_fail,"xb":___buildEnvironment,"wb":___clock_gettime,"vb":___map_file,"ub":___syscall10,"q":___syscall102,"tb":___syscall114,"sb":___syscall12,"rb":___syscall122,"qb":___syscall142,"oa":___syscall15,"pb":___syscall163,"ob":___syscall168,"nb":___syscall183,"mb":___syscall192,"lb":___syscall194,"na":___syscall195,"kb":___syscall196,"jb":___syscall197,"ib":___syscall198,"u":___syscall199,"w":___syscall20,"B":___syscall200,"ma":___syscall201,"hb":___syscall205,"gb":___syscall207,"la":___syscall212,"fb":___syscall219,"eb":___syscall220,"o":___syscall221,"db":___syscall268,"cb":___syscall3,"bb":___syscall33,"ab":___syscall34,"$a":___syscall38,"_a":___syscall39,"Za":___syscall40,"Ya":___syscall41,"Xa":___syscall42,"_":___syscall5,"Wa":___syscall54,"Va":___syscall60,"Ua":___syscall63,"Ta":___syscall77,"Sa":___syscall83,"Ra":___syscall85,"Qa":___syscall9,"Pa":___syscall91,"Oa":___syscall94,"I":___wasi_fd_close,"ka":___wasi_fd_fdstat_get,"Na":___wasi_fd_read,"yb":___wasi_fd_seek,"Ma":___wasi_fd_sync,"ja":___wasi_fd_write,"Q":__exit,"__memory_base":1024,"__table_base":0,"ia":_abort,"La":_asctime_r,"Ka":_chroot,"Ja":_clock_gettime,"Ia":_difftime,"y":_dlclose,"t":_dlerror,"D":_dlopen,"v":_dlsym,"ha":_emscripten_asm_const_ii,"G":_emscripten_asm_const_iii,"Ga":_emscripten_asm_const_iiii,"A":_emscripten_get_heap_size,"Fa":_emscripten_memcpy_big,"z":_emscripten_resize_heap,"Ea":_execl,"Da":_execle,"Ca":_execvp,"C":_exit,"ga":_flock,"Aa":_fork,"fa":_gai_strerror,"za":_getaddrinfo,"ya":_getdtablesize,"n":_getenv,"ea":_getgrnam,"da":_gethostbyaddr,"ca":_gethostbyname_r,"xa":_getloadavg,"wa":_getprotobyname,"Gb":_getprotobynumber,"va":_getpwnam,"Fb":_getpwuid,"m":_gettimeofday,"P":_gmtime_r,"ua":_kill,"Z":_llvm_log10_f64,"F":_llvm_stackrestore,"O":_llvm_stacksave,"ta":_llvm_trap,"N":_localtime_r,"b":_longjmp,"ba":_mktime,"Y":_nanosleep,"M":_popen,"X":_pthread_create,"l":_pthread_join,"Eb":_pthread_mutexattr_destroy,"Db":_pthread_mutexattr_init,"Cb":_pthread_mutexattr_settype,"E":_pthread_setcancelstate,"W":_putenv,"sa":_setTempRet0,"L":_setitimer,"k":_sigaction,"V":_sigaddset,"r":_sigdelset,"K":_sigemptyset,"Bb":_sigfillset,"Ab":_signal,"U":_sigprocmask,"aa":_strftime,"zb":_strptime,"T":_sysconf,"e":_time,"$":_tzset,"ra":_unsetenv,"qa":_usleep,"S":_utime,"pa":_waitpid,"h":abort,"a":getTempRet0,"R":invoke_i,"f":invoke_ii,"j":invoke_iii,"g":invoke_iiii,"H":invoke_iiiii,"Ha":invoke_iiiiii,"Ba":invoke_iiiiiii,"i":invoke_v,"d":invoke_vi,"p":invoke_vii,"x":invoke_viii,"s":invoke_viiii,"memory":wasmMemory,"c":setTempRet0,"table":wasmTable};var asm=Module["asm"](asmGlobalArg,asmLibraryArg,buffer);var ___emscripten_environ_constructor=Module["___emscripten_environ_constructor"]=function(){return(___emscripten_environ_constructor=Module["___emscripten_environ_constructor"]=Module["asm"]["Hb"]).apply(null,arguments)};var ___errno_location=Module["___errno_location"]=function(){return(___errno_location=Module["___errno_location"]=Module["asm"]["Ib"]).apply(null,arguments)};var __get_daylight=Module["__get_daylight"]=function(){return(__get_daylight=Module["__get_daylight"]=Module["asm"]["Jb"]).apply(null,arguments)};var __get_environ=Module["__get_environ"]=function(){return(__get_environ=Module["__get_environ"]=Module["asm"]["Kb"]).apply(null,arguments)};var __get_timezone=Module["__get_timezone"]=function(){return(__get_timezone=Module["__get_timezone"]=Module["asm"]["Lb"]).apply(null,arguments)};var __get_tzname=Module["__get_tzname"]=function(){return(__get_tzname=Module["__get_tzname"]=Module["asm"]["Mb"]).apply(null,arguments)};var _del_callback=Module["_del_callback"]=function(){return(_del_callback=Module["_del_callback"]=Module["asm"]["Nb"]).apply(null,arguments)};var _exec_callback=Module["_exec_callback"]=function(){return(_exec_callback=Module["_exec_callback"]=Module["asm"]["Ob"]).apply(null,arguments)};var _free=Module["_free"]=function(){return(_free=Module["_free"]=Module["asm"]["Pb"]).apply(null,arguments)};var _htonl=Module["_htonl"]=function(){return(_htonl=Module["_htonl"]=Module["asm"]["Qb"]).apply(null,arguments)};var _htons=Module["_htons"]=function(){return(_htons=Module["_htons"]=Module["asm"]["Rb"]).apply(null,arguments)};var _main=Module["_main"]=function(){return(_main=Module["_main"]=Module["asm"]["Sb"]).apply(null,arguments)};var _malloc=Module["_malloc"]=function(){return(_malloc=Module["_malloc"]=Module["asm"]["Tb"]).apply(null,arguments)};var _memalign=Module["_memalign"]=function(){return(_memalign=Module["_memalign"]=Module["asm"]["Ub"]).apply(null,arguments)};var _memcpy=Module["_memcpy"]=function(){return(_memcpy=Module["_memcpy"]=Module["asm"]["Vb"]).apply(null,arguments)};var _memset=Module["_memset"]=function(){return(_memset=Module["_memset"]=Module["asm"]["Wb"]).apply(null,arguments)};var _ntohs=Module["_ntohs"]=function(){return(_ntohs=Module["_ntohs"]=Module["asm"]["Xb"]).apply(null,arguments)};var _php_embed_init=Module["_php_embed_init"]=function(){return(_php_embed_init=Module["_php_embed_init"]=Module["asm"]["Yb"]).apply(null,arguments)};var _php_embed_shutdown=Module["_php_embed_shutdown"]=function(){return(_php_embed_shutdown=Module["_php_embed_shutdown"]=Module["asm"]["Zb"]).apply(null,arguments)};var _pib_destroy=Module["_pib_destroy"]=function(){return(_pib_destroy=Module["_pib_destroy"]=Module["asm"]["_b"]).apply(null,arguments)};var _pib_exec=Module["_pib_exec"]=function(){return(_pib_exec=Module["_pib_exec"]=Module["asm"]["$b"]).apply(null,arguments)};var _pib_init=Module["_pib_init"]=function(){return(_pib_init=Module["_pib_init"]=Module["asm"]["ac"]).apply(null,arguments)};var _pib_refresh=Module["_pib_refresh"]=function(){return(_pib_refresh=Module["_pib_refresh"]=Module["asm"]["bc"]).apply(null,arguments)};var _pib_run=Module["_pib_run"]=function(){return(_pib_run=Module["_pib_run"]=Module["asm"]["cc"]).apply(null,arguments)};var _setThrew=Module["_setThrew"]=function(){return(_setThrew=Module["_setThrew"]=Module["asm"]["dc"]).apply(null,arguments)};var _zend_eval_string=Module["_zend_eval_string"]=function(){return(_zend_eval_string=Module["_zend_eval_string"]=Module["asm"]["ec"]).apply(null,arguments)};var stackAlloc=Module["stackAlloc"]=function(){return(stackAlloc=Module["stackAlloc"]=Module["asm"]["rc"]).apply(null,arguments)};var stackRestore=Module["stackRestore"]=function(){return(stackRestore=Module["stackRestore"]=Module["asm"]["sc"]).apply(null,arguments)};var stackSave=Module["stackSave"]=function(){return(stackSave=Module["stackSave"]=Module["asm"]["tc"]).apply(null,arguments)};var dynCall_i=Module["dynCall_i"]=function(){return(dynCall_i=Module["dynCall_i"]=Module["asm"]["fc"]).apply(null,arguments)};var dynCall_ii=Module["dynCall_ii"]=function(){return(dynCall_ii=Module["dynCall_ii"]=Module["asm"]["gc"]).apply(null,arguments)};var dynCall_iii=Module["dynCall_iii"]=function(){return(dynCall_iii=Module["dynCall_iii"]=Module["asm"]["hc"]).apply(null,arguments)};var dynCall_iiii=Module["dynCall_iiii"]=function(){return(dynCall_iiii=Module["dynCall_iiii"]=Module["asm"]["ic"]).apply(null,arguments)};var dynCall_iiiii=Module["dynCall_iiiii"]=function(){return(dynCall_iiiii=Module["dynCall_iiiii"]=Module["asm"]["jc"]).apply(null,arguments)};var dynCall_iiiiii=Module["dynCall_iiiiii"]=function(){return(dynCall_iiiiii=Module["dynCall_iiiiii"]=Module["asm"]["kc"]).apply(null,arguments)};var dynCall_iiiiiii=Module["dynCall_iiiiiii"]=function(){return(dynCall_iiiiiii=Module["dynCall_iiiiiii"]=Module["asm"]["lc"]).apply(null,arguments)};var dynCall_v=Module["dynCall_v"]=function(){return(dynCall_v=Module["dynCall_v"]=Module["asm"]["mc"]).apply(null,arguments)};var dynCall_vi=Module["dynCall_vi"]=function(){return(dynCall_vi=Module["dynCall_vi"]=Module["asm"]["nc"]).apply(null,arguments)};var dynCall_vii=Module["dynCall_vii"]=function(){return(dynCall_vii=Module["dynCall_vii"]=Module["asm"]["oc"]).apply(null,arguments)};var dynCall_viii=Module["dynCall_viii"]=function(){return(dynCall_viii=Module["dynCall_viii"]=Module["asm"]["pc"]).apply(null,arguments)};var dynCall_viiii=Module["dynCall_viiii"]=function(){return(dynCall_viiii=Module["dynCall_viiii"]=Module["asm"]["qc"]).apply(null,arguments)};Module["ccall"]=ccall;Module["getMemory"]=getMemory;Module["UTF8ToString"]=UTF8ToString;Module["lengthBytesUTF8"]=lengthBytesUTF8;Module["addRunDependency"]=addRunDependency;Module["removeRunDependency"]=removeRunDependency;Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;var calledRun;function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}var calledMain=false;dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function callMain(args){var entryFunction=Module["_main"];args=args||[];var argc=args.length+1;var argv=stackAlloc((argc+1)*4);HEAP32[argv>>2]=allocateUTF8OnStack(thisProgram);for(var i=1;i<argc;i++){HEAP32[(argv>>2)+i]=allocateUTF8OnStack(args[i-1])}HEAP32[(argv>>2)+argc]=0;try{var ret=entryFunction(argc,argv);exit(ret,true)}catch(e){if(e instanceof ExitStatus){return}else if(e=="unwind"){noExitRuntime=true;return}else{var toLog=e;if(e&&typeof e==="object"&&e.stack){toLog=[e,e.stack]}err("exception thrown: "+toLog);quit_(1,e)}}finally{calledMain=true}}function run(args){args=args||arguments_;if(runDependencies>0){return}preRun();if(runDependencies>0)return;function doRun(){if(calledRun)return;calledRun=true;Module["calledRun"]=true;if(ABORT)return;initRuntime();preMain();readyPromiseResolve(Module);if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(shouldRunNow)callMain(args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout(function(){setTimeout(function(){Module["setStatus"]("")},1);doRun()},1)}else{doRun()}}Module["run"]=run;function exit(status,implicit){if(implicit&&noExitRuntime&&status===0){return}if(noExitRuntime){}else{ABORT=true;EXITSTATUS=status;exitRuntime();if(Module["onExit"])Module["onExit"](status)}quit_(status,new ExitStatus(status))}if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=false;if(Module["noInitialRun"])shouldRunNow=false;noExitRuntime=true;run();


  return PHP.ready
}
);
})();
if (typeof exports === 'object' && typeof module === 'object')
      module.exports = PHP;
    else if (typeof define === 'function' && define['amd'])
      define([], function() { return PHP; });
    else if (typeof exports === 'object')
      exports["PHP"] = PHP;
  })();
});
require.register("initialize.js", function(exports, require, module) {
"use strict";

var _PhpWebDrupal = require("php-wasm/PhpWebDrupal");

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

window.PHP = _PhpWebDrupal.PhpWebDrupal;
var php = new _PhpWebDrupal.PhpWebDrupal();
var session_id = '';
var serviceWorker = navigator.serviceWorker;

if (serviceWorker) {
  serviceWorker.register("".concat(location.pathname, "DrupalWorker.js")); // .then(result => console.log('Result, ', result))
  // .catch(error => console.log('Error, ', error));
}

document.addEventListener('DOMContentLoaded', function () {
  var input = document.querySelector('.input  textarea');
  var stdout = document.querySelector('.stdout > * > div.scroller');
  var stderr = document.querySelector('.stderr > * > div.scroller');
  var stdret = document.querySelector('.stdret > * > div.scroller');
  var run = document.querySelector('[data-run]');
  var token = document.querySelector('[data-tokenize]');
  var status = document.querySelector('[data-status]');
  var load = document.querySelector('[data-load-demo]');
  var demo = document.querySelector('[data-select-demo]');
  var editor = ace.edit(input);
  var ret = document.querySelector('#ret');
  var stdoutFrame = document.querySelector('.stdout > * > iframe');
  var stderrFrame = document.querySelector('.stderr > * > iframe');
  var stdretFrame = document.querySelector('.stdret > * > iframe');
  var openFile = document.getElementById('openFile');
  var exitBox = document.querySelector('#exit');
  var exitLabel = exitBox.querySelector('span');
  var persistBox = document.getElementById('persist');
  var singleBox = document.getElementById('singleExpression');
  var autorun = document.querySelector('#autorun');
  var renderAs = Array.from(document.querySelectorAll('[name=render-as]'));
  openFile.addEventListener('input', function (event) {
    var reader = new FileReader();

    reader.onload = function (event) {
      editor.setValue(event.target.result);
    };

    reader.readAsText(event.target.files[0]);
  });

  var runCode = function runCode() {
    exitLabel.innerText = '_';
    status.innerText = 'Executing...';
    stdoutFrame.srcdoc = ' ';
    stderrFrame.srcdoc = ' ';
    stdretFrame.srcdoc = ' ';

    while (stdout.firstChild) {
      stdout.firstChild.remove();
    }

    while (stderr.firstChild) {
      stderr.firstChild.remove();
    }

    while (stdret.firstChild) {
      stdret.firstChild.remove();
    }

    var code = editor.session.getValue();

    if (code.length < 1024 * 2) {
      query.set('autorun', autorun.checked ? 1 : 0);
      query.set('persist', persistBox.checked ? 1 : 0);
      query.set('single-expression', singleBox.checked ? 1 : 0);
      query.set('code', encodeURIComponent(code));
      history.replaceState({}, document.title, "?" + query.toString());
    }

    var func = singleBox.checked ? 'exec' : 'run';

    if (singleBox.checked) {
      code = code.replace(/^\s*<\?php/, '');
      code = code.replace(/\?>\s*/, '');
    }

    php[func](code).then(function (ret) {
      status.innerText = 'php-wasm ready!';
      var content = String(ret);
      stdret.innerText = content;
      stdretFrame.srcdoc = content;
      exitLabel.innerText = '_';

      if (!singleBox.checked) {
        setTimeout(function () {
          return exitLabel.innerText = ret;
        }, 100);
      }
    })["finally"](function () {
      if (!persistBox.checked) {
        php.refresh();
      }
    });
  };

  load.addEventListener('click', function (event) {
    if (!demo.value) {
      return;
    }

    fetch("/scripts/".concat(demo.value)).then(function (r) {
      return r.text();
    }).then(function (php) {
      var firstLine = String(php.split(/\n/).shift());
      var settings = JSON.parse(firstLine.split('//').pop());

      if ('autorun' in settings) {
        autorun.checked = !!settings.autorun;
      }

      if ('single-expression' in settings) {
        singleBox.checked = !!settings['single-expression'];
      }

      if ('persist' in settings) {
        persistBox.checked = !!settings.persist;
      }

      if ('render-as' in settings) {
        if (settings['render-as'] === 'text') {
          renderAs[0].checked = true;
          renderAs[0].dispatchEvent(new Event('change'));
          query.set('render-as', 'text');
        } else if (settings['render-as'] === 'html') {
          renderAs[1].checked = true;
          renderAs[1].dispatchEvent(new Event('change'));
          query.set('render-as', 'html');
        }
      }

      persistBox.dispatchEvent(new Event('change'));
      singleBox.dispatchEvent(new Event('input'));
      autorun.dispatchEvent(new Event('change'));
      history.replaceState({}, document.title, "?" + query.toString());
      editor.getSession().setValue(php);
      setTimeout(function () {
        return runCode();
      }, 100);
    });
  });
  var query = new URLSearchParams(location.search);
  editor.setTheme('ace/theme/monokai');
  editor.session.setMode("ace/mode/php");
  status.innerText = 'php-wasm loading...';

  var navigate = function navigate(_ref) {
    var path = _ref.path,
        method = _ref.method,
        _GET = _ref._GET,
        _POST = _ref._POST;
    // console.trace({path, method, _GET, _POST});
    exitLabel.innerText = '_';
    status.innerText = 'Executing...';
    stdoutFrame.srcdoc = ' ';
    stderrFrame.srcdoc = ' ';
    stdretFrame.srcdoc = ' ';

    while (stdout.firstChild) {
      stdout.firstChild.remove();
    }

    while (stderr.firstChild) {
      stderr.firstChild.remove();
    }

    while (stdret.firstChild) {
      stdret.firstChild.remove();
    }

    var code = "<?php\nini_set('session.save_path', '/home/web_user');\n\n$stdErr = fopen('php://stderr', 'w');\n$errors = [];\n\nfwrite($stdErr, isset($_SESSION) && json_encode(['session' => $_SESSION]) . \"\n\");\n\nregister_shutdown_function(function() use($stdErr){\n\tfwrite($stdErr, json_encode(['session_id' => session_id()]) . \"\n\");\n\tfwrite($stdErr, json_encode(['headers'=>headers_list()]) . \"\n\");\n\tfwrite($stdErr, json_encode(['errors' => error_get_last()]) . \"\n\");\n\tfwrite($stdErr, json_encode(['session' => $_SESSION]) . \"\n\");\n});\n\nset_error_handler(function(...$args) use($stdErr, &$errors){\n\tfwrite($stdErr, json_encode($args, JSON_PRETTY_PRINT) . \"\n\" );\n});\n\n$request = (object) json_decode(\n\t'".concat(JSON.stringify({
      path: path,
      method: method,
      _GET: _GET,
      _POST: _POST
    }), "'\n\t, JSON_OBJECT_AS_ARRAY\n);\n\nparse_str(substr($request->_GET, 1), $_GET);\n\n$_POST = $request->_POST;\n\n$origin  = 'http://localhost:3333';\n$docroot = '/preload/drupal-7.59';\n$script  = 'index.php';\n\n$path = $request->path;\n$path = preg_replace('/^\\/php-wasm/', '', $path);\n\n$_SERVER['SERVER_SOFTWARE'] = ").concat(JSON.stringify(navigator.userAgent), ";\n$_SERVER['REQUEST_URI']     = $path;\n$_SERVER['REMOTE_ADDR']     = '127.0.0.1';\n$_SERVER['SERVER_NAME']     = $origin;\n$_SERVER['SERVER_PORT']     = 3333;\n$_SERVER['REQUEST_METHOD']  = $request->method;\n$_SERVER['SCRIPT_FILENAME'] = $docroot . '/' . $script;\n$_SERVER['SCRIPT_NAME']     = $docroot . '/' . $script;\n$_SERVER['PHP_SELF']        = $docroot . '/' . $script;\n$_SERVER['DOCUMENT_ROOT']   = '/';\n$_SERVER['HTTPS']           = '';\n\nchdir($docroot);\n\ndefine('DRUPAL_ROOT', getcwd());\n\nrequire_once DRUPAL_ROOT . '/includes/bootstrap.inc';\ndrupal_bootstrap(DRUPAL_BOOTSTRAP_FULL);\n\n$uid     = 1;\n$user    = user_load($uid);\n$account = array('uid' => $user->uid);\nuser_login_submit(array(), $account);\n\n$itemPath = $path;\n$itemPath = preg_replace('/^\\/preload/', '', $itemPath);\n$itemPath = preg_replace('/^\\/drupal-7.59/', '', $itemPath);\n$itemPath = preg_replace('/^\\//', '', $itemPath);\n\nif($itemPath && (substr($itemPath, 0, 4) !== 'node' || substr($itemPath, -4) === 'edit'))\n{\n    $router_item = menu_get_item($itemPath);\n    $router_item['access_callback'] = true;\n    $router_item['access'] = true;\n\n    if ($router_item['include_file']) {\n      require_once DRUPAL_ROOT . '/' . $router_item['include_file'];\n    }\n\n    $page_callback_result = call_user_func_array(\n    \t$router_item['page_callback']\n    \t, is_string($router_item['page_arguments'])\n    \t\t? unserialize($router_item['page_arguments'])\n    \t\t: $router_item['page_arguments']\n    );\n\n    drupal_deliver_page($page_callback_result);\n}\nelse\n{\n    menu_execute_active_handler();\n}");
    php.run(code).then(function (exitCode) {
      exitLabel.innerText = exitCode;
      status.innerText = 'php-wasm ready!';
    })["finally"](function () {
      if (!persistBox.checked) {
        php.refresh();
      }
    });
  };

  php.addEventListener('ready', function (event) {
    if (serviceWorker) {
      serviceWorker.addEventListener('message', function (event) {
        return navigate(event.data);
      });
    }

    status.innerText = 'php-wasm ready!';
    run.removeAttribute('disabled');
    token && token.addEventListener('click', function () {
      var url = '/drupal-7.59/install.php';
      var options = {
        method: 'GET'
      };
      fetch(url, options).then(function (r) {
        return r.text();
      }).then(function (r) {
        console.log('Done');
      });
    });
    run.addEventListener('click', runCode);

    if (query.get('autorun')) {
      runCode();
    }
  });
  var outputBuffer = [];
  php.addEventListener('output', function (event) {
    var row = document.createElement('div');
    var content = event.detail.join('');
    outputBuffer.push(content);
    setTimeout(function () {
      var chunk = outputBuffer.join('');

      if (!outputBuffer || !chunk) {
        return;
      }

      if (location.hostname.match(/github.io$/)) {
        chunk = chunk.replace(/\/preload/g, '/php-wasm/preload');
      }

      var node = document.createTextNode(chunk);
      stdout.append(node);
      stdoutFrame.srcdoc += chunk;

      while (outputBuffer.pop()) {}

      ;
    }, 500);
  });
  var errorBuffer = [];
  php.addEventListener('error', function (event) {
    var content = event.detail.join(" ");

    try {
      var headers = JSON.parse(content);

      if (headers.session_id) {
        session_id = headers.session_id;
      }

      if (headers.headers) {
        var _iterator = _createForOfIteratorHelper(headers.headers),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var header = _step.value;
            var splitAt = header.indexOf(':');
            var _ref2 = [header.substring(0, splitAt), header.substring(splitAt + 2)],
                name = _ref2[0],
                value = _ref2[1];

            if (name === 'Location') {
              (function () {
                console.log(value);
                var redirectUrl = new URL(value);
                setTimeout(function () {
                  return navigate({
                    method: 'GET',
                    path: redirectUrl.pathname,
                    _GET: '',
                    _POST: {}
                  });
                }, 2000);
              })();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    } catch (error) {}

    var _iterator2 = _createForOfIteratorHelper(content),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var line = _step2.value;
        errorBuffer.push(line);
        setTimeout(function () {
          var chunk = errorBuffer.join('');

          if (!errorBuffer || !chunk) {
            return;
          }

          var node = document.createTextNode(chunk);
          stderr.append(node);
          stderrFrame.srcdoc += chunk;

          while (errorBuffer.pop()) {}

          ;
        }, 500);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  });
  ret.style.display = 'none';
  singleBox.addEventListener('input', function (event) {
    if (event.target.checked) {
      exitBox.style.display = 'none';
      ret.style.display = 'flex';
    } else {
      exitBox.style.display = 'flex';
      ret.style.display = 'none';
    }
  });
  exitLabel.innerText = '_';

  if (query.has('code')) {
    editor.setValue(decodeURIComponent(query.get('code')));
  }

  if (query.has('render-as')) {
    document.querySelector("[name=render-as][value=".concat(query.get('render-as'), "]")).checked = true;
  }

  autorun.checked = Number(query.get('autorun'));
  persistBox.checked = Number(query.get('persist'));
  singleBox.checked = Number(query.get('single-expression'));

  if (singleBox.checked) {
    exitBox.style.display = 'none';
    ret.style.display = 'flex';
  } else {
    exitBox.style.display = 'flex';
    ret.style.display = 'none';
  }

  setTimeout(function () {
    return editor.selection.moveCursorFileStart();
  }, 150);
  renderAs.map(function (radio) {
    if (query.get('render-as') === 'html') {
      stdout.style.display = 'none';
      stdoutFrame.style.display = 'flex';
      stderr.style.display = 'none';
      stderrFrame.style.display = 'flex';
      stdret.style.display = 'none';
      stdretFrame.style.display = 'flex';
    } else {
      stdout.style.display = 'flex';
      stdoutFrame.style.display = 'none';
      stderr.style.display = 'flex';
      stderrFrame.style.display = 'none';
      stdret.style.display = 'flex';
      stdretFrame.style.display = 'none';
    }

    radio.addEventListener('change', function (event) {
      var type = event.target.value;
      query.set('render-as', type);
      history.replaceState({}, document.title, "?" + query.toString());

      if (type === 'html') {
        stdout.style.display = 'none';
        stdoutFrame.style.display = 'flex';
        stderr.style.display = 'none';
        stderrFrame.style.display = 'flex';
        stdret.style.display = 'none';
        stdretFrame.style.display = 'flex';
      } else {
        stdout.style.display = 'flex';
        stdoutFrame.style.display = 'none';
        stderr.style.display = 'flex';
        stderrFrame.style.display = 'none';
        stdret.style.display = 'flex';
        stdretFrame.style.display = 'none';
      }
    });
  });
});

});

require.alias("process/browser.js", "process");process = require('process');require.register("___globals___", function(exports, require, module) {
  
});})();require('___globals___');

